<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "日志文件",
    'action-log.fromDate' => "开始时间：",
    'action-log.toDate' => "结束时间：",
    'action-log.clearLog' => "清除日志",
    'action-log.downloadLog' => "下载",
    'action-log.loggedActions' => "记录的操作",
    'action-log.storeLogsInDb' => "在数据库中存储记录",
    'action-log.storeNumber' => "项目",
    'action-log.dontRemoveRecs' => "不要删除记录",
    'action-log.confirmCleanLog' => "您确定要删除相应操作的日志记录吗？",
    'action-log.incorrectDate' => "指定的日期无效。",
    'action-log.incorrectNumPeriods' => "指定的循环周期无效。",
    'action-log.incorrectNumRecords' => "指定的记录数无效。",
    'action-log.yes' => "是",
    'action-log.no' => "否",
    'action-log.mixed' => "（混合）",
    'action-log.period' => "周期",
    'action-log.invalidDatePeriod' => "无效的日期期间",
    'action-log.submitDone' => "操作日志变更已保存。",
    'action-log.clearDone' => "操作日志已清除。",
    'action-log.periodDay' => "天",
    'action-log.periodWeek' => "星期",
    'action-log.periodMonth' => "月",

    'admin-info.adminInfoSection' => '管理员的信息',
    'admin-info.description-admin' => '管理员的描述',
    'admin-info.description-reseller' => '代理商的描述',
    'admin-info.description-owner' => '所有者的描述',
    'admin-info.description' => '描述',
    'admin-info.descriptionSuccess' => '该描述已被更新。',
    'admin-info.longDescription' => '指定的描述太长。不得超过 %%max%% 个字符。',
    'admin-info.add' => '添加描述',
    'admin-info.edit' => '编辑',
    'admin-info.remove' => '删除',
    'admin-info.confirmOnRemove' => '您要移除该描述吗？',
    'admin-info.popupTitle-customer' => '客户 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-reseller' => '代理商 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-subscription' => '订阅 %%name%% 的 %%descriptionType%%',
    'admin-info.popupTitle-site' => '%%name%% %%descriptionType%%',
    'admin-info.popupHint-admin' => '仅管理员可见该描述。',
    'admin-info.popupHint-reseller' => '代理商和管理员可见该描述。',
    'admin-info.popupHint-owner' => '其创建者和创建者的主机提供商可见该描述。',
    'admin-info.customerDescriptionHint' => '客户无法看到该描述。',
    'admin-info.subscriptionDescriptionHint' => "仅主机提供商可见该信息（Plesk 管理员或代理商）。",

    'apache-settings.formGeneralHint' => '您可在此为网站指定 Apache web 服务器设置。当您想要在网站上使用新类型的索引文件或要建立某个 MIME 类型与某个文件扩展名之间的关联时，可自定义 Apache 配置。使用默认值则表示 Apache 将会使用来自服务器级配置的相应指令。如果运行 Apache 时以 nginx 作为前端服务器，您还可在此页面上指定 nginx 设置。',
    'apache-settings.general' => '通用 Apache 设置',
    'apache-settings.example' => "例如：\n%%example%%",
    'apache-settings.settingOn' => '打开',
    'apache-settings.settingOff' => '关闭（默认）',
    'apache-settings.settingDefault' => '默认',
    'apache-settings.settingCustom' => '输入自定义值',
    'apache-settings.mimeTypes' => 'MIME 类型',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME类型会将文件扩展名与文件类型关联起来。通常，这用于为常见的文件类型创建自定义的文件扩展名。',
    'apache-settings.handlers' => '处理器',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache处理程序定义了web服务器在被请求时如何处理具有某些扩展名的文件。例如，字符串 'php-script .script' 意味着Apache将处理 .script 文件作为php脚本。",
    'apache-settings.deny' => '拒绝访问该网站',
    'apache-settings.allow' => '排除',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n禁止指定的主机和网络访问该网站。使用 '*' 拒绝所有连接。",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n允许指定的主机和网站访问该网站。",
    'apache-settings.directoryIndex' => '索引文件',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "当请求站点的索引页面时，Apache将查找指定的文件。",
    'apache-settings.expires' => 'Expires',
    'apache-settings.expiresStaticOnly' => '带有 Expires 头的响应仅用于静态文件',
    'apache-settings.expiresFullDescription' => 'web 服务器将会把 “Expires” 响应头添加到网页。以请求某网页的时间点开始，持续指定的时间长，整个时段即为过期时间戳。',
    'apache-settings.expiresStaticOnlyDescription' => '"Expires" 头将只用于静态文件。哪些文件会被视作静态文件由 "静态文件智能处理" 和 "由 nginx 直接服务静态文件" 选项决定。',
    'apache-settings.expiresUnitDays' => '天',
    'apache-settings.expiresUnitHours' => '小时',
    'apache-settings.expiresUnitMinutes' => '分钟',
    'apache-settings.expiresUnitSeconds' => '秒',
    'apache-settings.expiresSize' => '有效期',
    'apache-settings.expiresUnitSize' => '有效期单位',
    'apache-settings.nginxCacheTimeoutSize' => '缓存超时',
    'apache-settings.nginxCacheTimeoutUnitSize' => '缓存超时单位',
    'apache-settings.headers' => '其它信息头',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Web服务器将添加指定的HTTP响应头。",
    'apache-settings.restrictFollowSymLinks' => '限制遵循符号链接',
    'apache-settings.restrictFollowSymLinksDescription' => "选择该选项以阻止用户在 .htaccess 中使用 FollowSymLink 指令来提高服务器的安全性。",
    'apache-settings.nginx' => 'nginx 设置',
    'apache-settings.nginxProxyMode' => '代理模式',
    'apache-settings.nginxProxyModeDescription' => 'Nginx 将请求转发到 Apache。关闭以停止使用 Apache。',
    'apache-settings.nginxHttp3Enabled' => 'HTTP/3 支持',
    'apache-settings.nginxHttp3EnabledDescription' => '试验性功能。在极少数情况下，它可能会影响网站的可用性。',
    'apache-settings.nginxTransparentMode' => '静态文件智能处理',
    'apache-settings.nginxTransparentModeDescription' => '如果已被关闭，Apache 将会处理所有静态文件的请求。nginx 会不做修改通过请求和响应。关闭此选项仅用于故障排除。',
    'apache-settings.nginxServeStatic' => '由 nginx 直接服务静态文件',
    'apache-settings.nginxStaticExtensionsLabel' => '指定文件扩展名 ',
    'apache-settings.nginxStaticExtensions' => '指定文件扩展名由空格或 "|" 符号隔开。对这些文件的请求将会由 nginx 进行处理不会到达 Apache。注意：Apache 覆盖规则将不会被应用。',
    'apache-settings.nginxServePhp' => '由 nginx 处理 PHP',
    'apache-settings.nginxServePhpDescription' => 'PHP 文件 (.php) 将会由 nginx 和 PHP-FPM 处理。如果处于关闭状态，PHP 将会由 Apache 进行处理。',
    'apache-settings.nginxClientMaxBodySize' => '允许的最大HTTP请求正文大小',
    'apache-settings.nginxClientMaxBodySizeDescription' => '主体超过限制的请求将被丢弃，因为HTTP 413 有效负载太大（配置"client_max_body_size" nginx 指令值）。',
    'apache-settings.nginxClientMaxBodySizeDisabled' => '选项通过panel.ini中的指令"clientMaxBodySize"的空/零值执行全局禁用',
    'apache-settings.nginxCacheEnabled' => '启用 nginx 缓存',
    'apache-settings.nginxCacheEnabledDescription' => '缓存可能会减少网站响应时间和服务器负载，但是需慎重使用。',
    'apache-settings.nginxCacheSize' => '缓存大小',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => '缓存超时',
    'apache-settings.nginxCacheTimeoutDays' => '天',
    'apache-settings.nginxCacheTimeoutHours' => '小时',
    'apache-settings.nginxCacheTimeoutMinutes' => '分钟',
    'apache-settings.nginxCacheTimeoutSeconds' => '秒',
    'apache-settings.nginxCacheKey' => '缓存密钥',
    'apache-settings.nginxCacheCookies' => '使用 cookies 缓存请求',
    'apache-settings.nginxCacheBypassLocations' => '禁用位置缓存',
    'apache-settings.nginxCacheBypass' => '绕过缓存，当：',
    'apache-settings.nginxCacheBypassHeaderNocache' => '在请求中接收到了 HTTP no-cache 头',
    'apache-settings.nginxCacheBypassHeaderAuth' => '在请求中接收到了 HTTP 授权头',
    'apache-settings.nginxCacheBypassGetNocache' => '在请求中接收到了 GET nocache 参数',
    'apache-settings.nginxCacheUseStale' => '返回缓存过期记录',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream 返回 5xx 服务器错误',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream 返回 4xx 客户端错误',
    'apache-settings.nginxCacheUseStaleUpdating' => '缓存正被更新',
    'apache-settings.additional' => '其他 Apache 指令。',
    'apache-settings.additionalSettingsDescription' => '如果您无法找到某些设置，可添加这些设置到以下字段。这些设置将会覆盖服务器级的 Apache 指令。当访客通过 HTTP 访问网站时则会应用第一字段的指令。第二字段则包含用于 HTTPS 的指令。一般来说您需要为两个字段添加指令。请使用与 httpd.include 相同的句法。例如，如果您想要设置一个自定义错误页面，可添加该行：ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'HTTP 的其它指令',
    'apache-settings.additionalSslSettings' => 'HTTPS 的其它指令',
    'apache-settings.additionalSettingsError' => '无效的 Apache 配置： %%error%%',
    'apache-settings.rollbackFailed' => '无法使用当前的 Apache 配置文件且无法回滚到文件的原版本因为它们包含无效的配置。',
    'apache-settings.additionalNginx' => '其它 Nginx 指令',
    'apache-settings.additionalNginxSettingsDescription' => '您可在此为在 Apache 前端运行的 nginx 反向代理服务器指定相应设置。您的指令将会覆盖服务器级的 nginx 配置。例如，更改连接超时或使用 gzip 打包请求。请使用与 nginx.conf 相同的句法。例如，如果您想要使用 gzip 打包所有的代理请求，可添加行：\'gzip_proxied any;\'。',
    'apache-settings.additionalNginxSettings' => '其它 Nginx 指令',
    'apache-settings.additionalNginxSettingsError' => '无效的 Nginx 配置：%%error%%',
    'apache-settings.nginxRollbackFailed' => '无法使用当前的 nginx 配置文件并回滚至文件的原版本，因为它们都包含无效的配置。',
    'apache-settings.clearCache' => '清除缓存',
    'apache-settings.clearCacheHint' => '清除 %%website%% 的nginx缓存',
    'apache-settings.cacheHasClearedSuccessfuly' => '缓存已成功清除',

    'backup.backup-password-protection.securitySettingsSection' => '备份安全设置',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => '从远程存储的设置获取密码',
    'backup.backup-password-protection.backupPasswordManualInput' => '手动输入密码',
    'backup.backup-password-protection.providePasswordCheckbox' => '提供密码',
    'backup.backup-password-protection.backupPassword' => '密码',
    'backup.backup-password-protection.inputPasswordType' => '密码类型',
    'backup.backup-password-protection.confirmBackupPassword' => '重复密码',
    'backup.backup-password-protection.backupPasswordHint' => '如果您已忘记密码，请清空此选项。注意在这样的情况下一些敏感数据不会正常恢复。例如，用户密码将会被一个任意密码替换，有关已安装的 APS 应用程序将会丢失，等等。',
    'backup.backup-password-protection.backupPasswordFtpHint' => '如果此备份有密码保护，请在以下字段输入该密码。注意如果您提供的密码不正确，Plesk 将不会恢复该备份。而是会把备份复制到本地存储中。',

    'backup.conflict-database.dbMappingLegend' => '数据库服务器映射',
    'backup.conflict-database.serverType' => '服务器类型',
    'backup.conflict-database.hostName' => '主机名',
    'backup.conflict-database.port' => '端口',
    'backup.conflict-database.destinationDbServer' => '目的数据库服务器',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MS SQL中',
    'backup.conflict-database.migrationDbServerNotFind' => '数据库无法被恢复：没有合适的数据库服务器。',

    'backup.conflict-ip.buttonUploadMappingFile' => '上传 IP 映射文件',
    'backup.conflict-ip.ipMappingLegend' => 'IP 映射',
    'backup.conflict-ip.buttonSaveCurrentMapping' => '保存当前IP映射到文件',
    'backup.conflict-ip.ipAddressNotFound' => '无此类可用 IP 地址。',
    'backup.conflict-ip.sharedIp' => '共享',
    'backup.conflict-ip.dedicatedIp' => '独立',
    'backup.conflict-ip.fileNotFound' => '该文件不得为空。',
    'backup.conflict-ip.invalidIpToMap' => '旧 IP 地址的一个无效值：%%ip%%',
    'backup.conflict-ip.invalidMappingValue' => '新 IP 地址的一个无效值：%%ip%%',
    'backup.conflict-ip.ipNotFound' => '数据库中未找到 IP 地址 %%ip%%。',
    'backup.conflict-ip.uploadIpMappingFileLegend' => '上传 IP 映射文件',
    'backup.conflict-ip.ipMappingFileHint' => 'IP 映射文件是纯文本文件。该文件的每一行都包含 IP 映射，其格式为：<old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => '旧 IP 地址',
    'backup.conflict-ip.newIp' => '新 IP 地址',

    'backup.copy-to-server.ignoreBackupSign' => '上传没有有效签名的备份文件',
    'backup.copy-to-server.wrongPassword' => '指定的密码不正确。在备份恢复过程中，Plesk 将会提示您再次输入密码。',
    'backup.copy-to-server.corruptedSignatureUploaded' => '上传的备份文件 %%fileName%% 已在不支持签名备份的其它服务器或早期版本的 Plesk 上被修改、损坏、创建。要从该备份文件恢复数据，请确认是否可以信任该文件源。',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => '无法上传备份文件 %%fileName%%。该文件包含已修改或已损坏的数据，或该文件是在其它服务器或更早版本的 Plesk 上创建的。要从该文件恢复恢复数据，请联系您的主机提供商。',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => '无法上传备份文件 %%fileName%%。文件已在不支持签名备份的其它服务器或早期版本的 Plesk 上被修改、损坏、创建。如果您信任该备份，那么请选择“上传没有有效签名的备份文件”选项并再次上传。',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "无法移动所选备份 %%fileName%% 到服务器存储。错误：%%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "增量备份的以下部分未被复制：%%endl%%%%missedParts%%%%endl%%请复制丢失的部分。",

    'backup.ftp-settings.isActive' => '使用 FTP(S) 存储',
    'backup.ftp-settings.host' => 'FTP服务器主机名或IP',
    'backup.ftp-settings.directory' => '备份文件存放目录',
    'backup.ftp-settings.directoryHint' => '如/myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP 用户名',
    'backup.ftp-settings.ftpPassword' => 'FTP 密码',
    'backup.ftp-settings.usePassiveMode' => '使用被动模式',
    'backup.ftp-settings.useFtps' => '使用 FTPS',
    'backup.ftp-settings.errorHostIsLocal' => '禁止使用本地 Plesk 的 FTP 服务器作为远程存储。请指定一个远程地址。',
    'backup.ftp-settings.warningHostIsLocal' => '已配置FTP(S) 存储设置，以存储订阅文件所在的服务器上的备份。由于存在数据丢失和硬盘过度使用的风险，不建议这样的配置。',
    'backup.ftp-settings.enterFtpLogin' => '输入正确的用户名。',
    'backup.ftp-settings.enterFtpPassword' => '输入正确的密码。',

    'backup.remote-settings.isActive' => '使用存储',
    'backup.remote-settings.initError' => '无法初始化 %%extName%% 设置页面：%%error%%',

    'backup.remote-storages.backupSecuritySettings' => '备份安全设置',

    'backup.restore.detailsSection' => '详情',
    'backup.restore.contentInfoSection' => '备份内容',
    'backup.restore.restorationOptionsSection' => '恢复选项',
    'backup.restore.emailNotification' => '恢复任务结束时，发送通知到',
    'backup.restore.comments' => '备注',
    'backup.restore.creationDate' => '创建日期',
    'backup.restore.systemNotes' => '系统日志',
    'backup.restore.ownerAdmin' => '由管理员创建的。',
    'backup.restore.ownerReseller' => '由代理商创建的。',
    'backup.restore.ownerCustomer' => '由客户创建的。',
    'backup.restore.ownerServiceUser' => '由其他的用户创建。',
    'backup.restore.partOfParentBackup' => '%%type%% 备份的一部分。',
    'backup.restore.server' => '服务器',
    'backup.restore.reseller' => '代理商',
    'backup.restore.client' => '客户',
    'backup.restore.incremental' => '增量',
    'backup.restore.multiVolume' => '多卷宗',
    'backup.restore.backupSize' => '备份大小',
    'backup.restore.backupSizeFirstIncremental' => '%%this%%（该备份）+ %%base%%（初始备份）= %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%%（该备份）+ %%prev%%（之前的备份）+ %%base%%（初始备份）= %%total%%',
    'backup.restore.download' => '下载',
    'backup.restore.downloadHint' => '下载备份文件到您的本地电脑。',
    'backup.restore.downloadDisabled' => '暂时无法下载备份文件。请稍候再试或联系您的服务提供商。',
    'backup.restore.copy' => '复制到服务器存储',
    'backup.restore.copyHint' => '复制所选备份文件到服务器存储。',
    'backup.restore.contentInfo' => '备份内容',
    'backup.restore.restoreButton' => '恢复',
    'backup.restore.mail' => '邮件',
    'backup.restore.domainConfiguration' => '域名配置',
    'backup.restore.virtualHost' => '虚拟主机内容',
    'backup.restore.database' => '数据库',
    'backup.restore.serverConfiguration' => '服务器设置',
    'backup.restore.serverConfigurationLicense' => '许可证密钥',
    'backup.restore.serverPersonalConfiguration' => '管理员帐户配置',
    'backup.restore.serverPersonalDomains' => '管理员域名',
    'backup.restore.serverPersonalClients' => '管理员客户',
    'backup.restore.resellers' => '代理商',
    'backup.restore.resellerPersonalConfiguration' => '代理商帐户配置',
    'backup.restore.resellerPersonalDomains' => '代理商域名',
    'backup.restore.resellerPersonalClients' => '代理商客户',
    'backup.restore.clientPersonalConfiguration' => '客户帐户配置',
    'backup.restore.clientPersonalDomains' => '客户域名',
    'backup.restore.restoreModifiedSection' => '尽管签名损坏仍恢复备份文件',
    'backup.restore.restoreModifiedDump' => '尽管没有有效的签名仍然恢复该备份',
    'backup.restore.resolutionPolicy' => '解决策略',
    'backup.restore.resolutionPolicyDescription' => '计时冲突出现情况: 当恢复对象已在系统中，且新近修改日期更接近，或恢复对象当前没有出现在系统中。',
    'backup.restore.backupRestoreFtpWrongPassword' => '指定的密码不正确。将不会复制该备份文件至服务器的本地存储。',
    'backup.restore.backupRestoreLocalWrongPassword' => '无法恢复备份。指定的密码不正确。',
    'backup.restore.serverContentAndConfiguration' => '服务器配置及内容',
    'backup.restore.serverConfigurationOnly' => '服务器配置',
    'backup.restore.resellerContentAndConfiguration' => '代理商帐户配置及内容',
    'backup.restore.resellerConfigurationOnly' => '代理商帐户配置',
    'backup.restore.clientContentAndConfiguration' => '客户帐户配置及内容',
    'backup.restore.clientConfigurationOnly' => '客户帐户配置',
    'backup.restore.domainContentAndConfiguration' => '域名配置与内容',
    'backup.restore.domainConfigurationOnly' => '域名配置',
    'backup.restore.restoreType' => '您想要恢复什么？',
    'backup.restore.restoreTypeFull' => '所有对象（整个系统）',
    'backup.restore.restoreTypeGranular' => '选定的对象',
    'backup.restore.restoreObjectType' => '要恢复的对象的类型',
    'backup.restore.restoreObjectTypeSubscriptions' => '订阅',
    'backup.restore.restoreObjectTypeCustomers' => '客户',
    'backup.restore.restoreObjectTypeResellers' => '代理商',
    'backup.restore.restoreObjectTypeMailUsers' => '邮件帐户',
    'backup.restore.restoreObjectTypeDatabases' => '数据库',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS 证书',
    'backup.restore.restoreObjectTypeSites' => '网站',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS 区域',
    'backup.restore.restoreObjectTypeMailLists' => '邮件列表',
    'backup.restore.restoreObjectTypeWebContent' => '域名的文件',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => '选择文件',
    'backup.restore.restoreSubscriptionLookup' => '订阅',
    'backup.restore.restoreComponents' => '要恢复的组件',
    'backup.restore.errorLog' => '错误日志',
    'backup.restore.backupDetailsLogDoesntExist' => '备份日志不可用。',
    'backup.restore.dumpFailedSection' => '错误日志',
    'backup.restore.dumpFailed' => '无法恢复数据：该备份文件无效。',
    'backup.restore.granularNotSupported' => '您可以选择仅当恢复在 Plesk 12.0 或更新版本中创建的备份时要恢复的对象。',
    'backup.restore.fullNotSupportedInResellerPowerUser' => '在代理商高级用户视图中不支持从备份恢复所有数据。选择用于恢复的对象。您可以在 %%interfaceLink%% 中修改您的界面视图',
    'backup.restore.interfaceLink' => '界面偏好设置',
    'backup.restore.contentRestoreType' => '恢复',
    'backup.restore.contentRestoreTypeSettingsOnly' => '仅被选定对象的配置',
    'backup.restore.contentRestoreTypeFull' => '被选定对象的配置和内容',
    'backup.restore.errorWrongFormat' => '由于配置文件损坏，无法恢复备份。',
    'backup.restore.errorContentError' => '并非所有备份数据都可以恢复，因为备份包含内容错误。',
    'backup.restore.warningSignError' => '无法验证备份签名。备份文件可能是在其它服务器或早期版本的 Plesk 上被修改过、损坏过或创建的。',
    'backup.restore.warningSignErrorNotAdmin' => '只有 Plesk 管理员才能恢复该备份。',
    'backup.restore.warningPartial' => "未找到增量备份的以下部分：%%endl%%%%missedParts%%%%endl%%可能不会恢复所有文件。请上传丢失的部分然后再尝试恢复。",
    'backup.restore.errorPackedInvalid' => '无法恢复备份。备份文件可能被修改、损坏、在早期版本的 Plesk 中创建或丢失。',
    'backup.restore.warningDeprecatedBackupVersion' => '您要尝试恢复的备份是在不支持的 Plesk 版本中创建的，因而不能恢复。请使用 Plesk Migrator 扩展从旧的 Plesk 版本迁移您的数据。',
    'backup.restore.encryptionKeyError' => '该备份中的一个或多个帐户的密码无法被恢复且将要被重设。可能该备份是在其它 Plesk 服务器上创建的且使用加密密钥加密。',
    'backup.restore.errorCorruptedContent' => '下列文件找不到或已损坏： ',
    'backup.restore.statusSection' => '备份状态',
    'backup.restore.statusDetails' => '状态详情',
    'backup.restore.restoreBlocked' => '该备份无法被恢复。',
    'backup.restore.restoreBlockedDescription' => '现在无法恢复备份类型 %%backupType%%。若要进行恢复，请以备份所有者的身份登录并在备份管理器中点击该备份名称。',

    'backup.schedule.scheduleSection' => '计划',
    'backup.schedule.backupEnable' => '激活此备份任务',
    'backup.schedule.backupPeriod' => '运行此备份任务',
    'backup.schedule.on' => '打开',
    'backup.schedule.at' => '在',
    'backup.schedule.every' => '每',
    'backup.schedule.hours' => '（{period, plural, other {#小时}}）',
    'backup.schedule.retainHours' => '小时',
    'backup.schedule.useIncremental' => '使用增量式备份',
    'backup.schedule.useIncrementalDisableHint' => '选定的备份内容仅允许创建完整备份。',
    'backup.schedule.fullBackupPeriod' => '执行全量备份',
    'backup.schedule.hourly' => '按小时',
    'backup.schedule.daily' => '每日',
    'backup.schedule.weekly' => '每周',
    'backup.schedule.monthly' => '每月',
    'backup.schedule.yearly' => '每年',
    'backup.schedule.days' => '天',
    'backup.schedule.weeks' => '星期',
    'backup.schedule.months' => '月',
    'backup.schedule.years' => '年',
    'backup.schedule.backupTimeDescription' => '时区：%%timezone%%。',
    'backup.schedule.systemTimeZone' => '系统默认时区',
    'backup.schedule.first' => '首页',
    'backup.schedule.last' => '最后',
    'backup.schedule.dayOfMonth' => '日',
    'backup.schedule.email' => '如果在执行此预定备份任务的过程中出现任何错误，则会发送通知到',
    'backup.schedule.invalidFields' => '一些字段为空或者含有无效值：%%fields%%。',
    'backup.schedule.maxDumpFiles' => '可以进行存储的完整备份文件的最大数量（包括计划和手动备份）',
    'backup.schedule.retainDumpFilesFor' => '保留完整备份',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => '如果您不想自动移除全量备份请保留该字段为空。',
    'backup.schedule.maxDumpFilesLimitedDescription' => '主机提供商指定的服务器存储限制值为 %%max%%。您为其指定的限制值必须低于或等于 %%max%%。',
    'backup.schedule.retainLimitedDescription' => '主机提供商指定的服务器存储上限为 {max, plural, other {# 个完整备份}}（包括所有计划备份和手动备份）。',
    'backup.schedule.backupToCloudIsNotAllowed' => '在远程云存储中存储定期订阅备份是一项高级功能，可以在Plesk在线商店中进行购买。',
    'backup.schedule.backupHourlyWarning' => '启用按小时备份可能会导致服务器资源消耗增加。',
    'backup.schedule.titleHourly' => '按小时备份设置',
    'backup.schedule.titleDaily' => '每日备份设置',
    'backup.schedule.titleWeekly' => '每周备份设置',
    'backup.schedule.titleMonthly' => '每月备份设置',
    'backup.schedule.titleCustom' => '自定义备份设置',

    'backup.secure-backup.hint' => '您可以在备份中使用一个密码加密包含在 Plesk 数据库中的用户密码。注意在没有提供密码的情况下恢复受密码保护的备份会导致 Plesk 任意生成用户密码。',
    'backup.secure-backup.hintAdmin' => '您可以使用 Plesk 加密密钥或一个密码加密包含在备份中的 Plesk 数据库密码。此密钥对于每个 Plesk 安装实例都是唯一的。使用密钥加密的备份只能在创建这些备份的 Plesk 安装实例中恢复而不能在其它的 Plesk 安装实例中恢复。请注意 Plesk 不会保护备份中所有的敏感数据。我们建议您将备份保存在远程的云存储系统中并在云存储系统端启用备份加密。',
    'backup.secure-backup.usePasswordProtection' => '使用密码保护（推荐）',
    'backup.secure-backup.backupPasswordSource' => '密码类型',
    'backup.secure-backup.pleskKey' => 'Plesk 的加密密钥',
    'backup.secure-backup.userPassword' => '指定的密码',
    'backup.secure-backup.password' => '密码',
    'backup.secure-backup.passwordConfirmation' => '重复密码',

    'backup.subform.settingsSection' => '备份设置',
    'backup.subform.prefix' => '添加前缀到备份名',
    'backup.subform.comment' => '备注',
    'backup.subform.splitSize' => '创建多卷宗备份，卷宗大小 (MB)',
    'backup.subform.repository' => '存储于',
    'backup.subform.repositoryDescription' => 'FTP(S) 存储设置未指定。%%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => '服务器存储和 %%name%%',
    'backup.subform.remoteRepositoryOption' => '远程存储',
    'backup.subform.remoteRepository' => '远程存储',
    'backup.subform.remoteRepositoryText' => '选择远程的云存储',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">配置远程存储</a>以将您的备份存储在云端。',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">配置 FTP 存储</a>以将您的备份存储在异地。',
    'backup.subform.configureRemoteDesc' => '%%link%% 将您的备份保存在云端。',
    'backup.subform.configureRemoteLink' => '配置远程存储',
    'backup.subform.configureFtpDesc' => '%%link%% 将您的备份异地保存。',
    'backup.subform.configureFtpLink' => '配置 FTP 存储',
    'backup.subform.repositoryConfigure' => '配置',
    'backup.subform.email' => '当备份任务结束时，发送通知邮件到',
    'backup.subform.contentSection' => '备份内容',
    'backup.subform.domainConfiguration' => '配置',
    'backup.subform.domainConfigurationVhost' => '用户文件与数据库',
    'backup.subform.domainConfigurationFile' => '用户文件',
    'backup.subform.domainConfigurationDatabase' => '数据库',
    'backup.subform.domainConfigurationMail' => '邮件信息',
    'backup.subform.content' => '备份',
    'backup.subform.backupAll' => '所有配置及内容',
    'backup.subform.backupConfiguration' => '仅配置',
    'backup.subform.backupVhost' => '除邮件消息外的所有配置和内容',
    'backup.subform.backupMailFile' => '除用户数据库外的所有配置和内容',
    'backup.subform.backupMailDatabase' => '除用户文件外的所有配置和内容',
    'backup.subform.backupMail' => '仅配置和邮件信息',
    'backup.subform.backupDatabase' => '仅配置和用户数据库',
    'backup.subform.backupFile' => '仅配置和用户文件',
    'backup.subform.mssqlNativeBackup' => '如果可能请使用本地 MS SQL 备份功能',
    'backup.subform.mssqlNativeBackupAdmin' => '请使用本地 MS SQL 备份功能（对于远程数据库，请确保您已在 工具与设置> 数据库服务器 中配置了远程 MS SQL 服务器的备份设置）',
    'backup.subform.localRepository' => '服务器存储',
    'backup.subform.localRepositoryPath' => '位于 %%path%% 的服务器存储',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => '位于%%uri%% 的FTP(S) 存储<a href="%%link%%">Change Settings</a>',
    'backup.subform.ftpRepositoryText' => '位于 %%uri%% 的 FTP(S) 存储',
    'backup.subform.type' => '类型',
    'backup.subform.typeFullBackup' => '全量',
    'backup.subform.typeIncremental' => '增量',
    'backup.subform.typeIncrementalDescription' => '备份自上次备份起已被更改的网站和邮件主机数据（数据库数据总是会全量备份）。',
    'backup.subform.incrementalNotAvailable' => '若要创建增量备份，请首先创建全量备份。',
    'backup.subform.excludeLogs' => '排除日志文件',
    'backup.subform.excludeFiles' => '排除备份指定的文件',
    'backup.subform.excludeFilesDescription' => '您只能排除主机空间内的文件。指定与主机空间根目录的相对路径，以逗号隔开各个文件。允许使用面具标志（例如：/somedir/log*）。',

    'backup.upload.uploadHint' => '在此处您可上传备份文件到 Plesk 存储。最大文件容量限于 2 GB。',
    'backup.upload.backupFile' => '备份文件',
    'backup.upload.removeLink' => '移除',
    'backup.upload.addFileLink' => '上传更多文件',
    'backup.upload.backupSecuritySettings' => '备份安全设置',
    'backup.upload.signatureHint' => 'Plesk 会查看备份文件是否有有效的结构和签名。在其它服务器上修改、损坏或创建的文件不可信。下面的选项能够让您从此类文件恢复数据。只有在您信任备份源的情况下才选择此选项，因为上传此类文件可能会给安全带来隐患或影响服务器的操作。注意：在早于 11.5 版本的 Plesk 中所做的备份文件会被视作不可信任备份文件，因为没有签名。如果您信任该文件源请务必恢复此类文件。',
    'backup.upload.ignoreSign' => '上传没有有效签名的备份文件',
    'backup.upload.passwordHint' => '如果此备份有密码保护，请在以下字段输入该密码。注意如果输入的密码不正确，Plesk 将给以警告但仍会上传备份到服务器。然而，在恢复备份的过程中，会提示再次输入该密码。',
    'backup.upload.alreadyExistsWarning' => '该备份文件 %%fileName%% 已经存在于服务器的本地存储中。',
    'backup.upload.incorrectPasswordWarning' => '指定的密码不正确。在备份恢复过程中，Plesk 将会提示您再次输入密码。',
    'backup.upload.deprecatedDumpError' => '您要尝试上传的备份是在不支持的 Plesk 版本中创建的，因而不能导入。请使用 Plesk Migrator 扩展从旧的 Plesk 版本迁移您的数据。',
    'backup.upload.mailFormatWarning' => '备份文件 %%fileName%% 已被上传到存储中。重要说明：备份文件 %%fileName%% 包含无法恢复的邮件内容，因为其格式 (Plesk 8.3 - 8.6) 不被支持。要恢复该邮件内容，使用 Plesk 备份工具对其备份，请选择选项 备份邮箱内容，并选择选项 恢复转储至任何邮件服务器。',
    'backup.upload.corruptedSignatureAdminWarning' => '上传的备份文件 %%fileName%% 已在不支持签名备份的其它服务器或早期版本的 Plesk 上被修改、损坏、创建。要从该备份文件恢复数据，请确保是否可以信任该文件源。',
    'backup.upload.corruptedSignatureAdminError' => '无法上传备份文件 (%%fileName%%)。文件已在不支持签名备份的其它服务器或早期版本的 Plesk 上被修改、损坏、创建。如果您信任该备份，那么请选择“上传没有有效签名的备份文件”选项并再次上传。',
    'backup.upload.corruptedSignatureUserWarning' => '上传的备份文件 (%%fileName%%) 包含已修改或已损坏的数据，或该文件是在其它服务器或更早版本的 Plesk 上创建的。',
    'backup.upload.corruptedSignatureUserError' => '无法上传备份文件 (%%fileName%%)。该文件包含已修改或已损坏的数据，或该文件是在其它服务器或更早版本的 Plesk 上创建的。要从该文件恢复恢复数据，请联系您的主机提供商。',
    'backup.upload.uploadError' => '无法上传 %%fileName%% 到服务器存储：%%error%%',
    'backup.upload.fileNotSelected' => '没有选定要上传的文件。至少选择一个文件。',
    'backup.upload.missedPartsWarning' => "增量备份的以下部分未被上传：%%endl%%%%missedParts%%%%endl%%请上传丢失的部分。",
    'backup.upload.unknownType' => '未知的对象类型',
    'backup.upload.storageLink' => '其它存储',
    'backup.upload.anotherStorage' => '转储已被上传至 %%storageLink%%。',
    'backup.upload.resellerNotFound' => '未找到代理商 %%name%%。请首先创建它以恢复已上传的转储。',
    'backup.upload.clientNotFound' => '未找到客户 %%name%%。请首先创建它以恢复已上传的转储。',
    'backup.upload.domainNotFound' => '未找到域名 %%name%%。请首先创建它以恢复已上传的转储。',

    'backup.web-content-dynamic.addButtonTitle' => '添加文件',
    'backup.web-content-dynamic.noItems' => '无选定的文件',
    'backup.web-content-dynamic.hint' => '勾选复选框选择文件和文件夹。',
    'backup.web-content-dynamic.title' => '选择文件',
    'backup.web-content-dynamic.columnName' => '名称',
    'backup.web-content-dynamic.columnChangeDate' => '修改日期',
    'backup.web-content-dynamic.columnSize' => '大小',
    'backup.web-content-dynamic.columnPermissions' => '权限',
    'backup.web-content-dynamic.columnUser' => '用户',
    'backup.web-content-dynamic.columnGroup' => '群组',
    'backup.web-content-dynamic.waitButtonTitle' => '请稍候',
    'backup.web-content-dynamic.loadingTitle' => '请稍候。正在加载...',

    'backup.invalidFields' => '一些字段为空或者含有无效值。',
    'backup.notEnoughDiskSpace' => '%%path%% 没有足够的磁盘空间用于备份创建。至少需要 %%required%% GB 可用空间（%%available%% GB 可用）',

    'change-subscriptions-owner.ownerSection' => '新的所有者',
    'change-subscriptions-owner.subscriptionsSection' => '所选订阅',
    'change-subscriptions-owner.owner' => '所有者',
    'change-subscriptions-owner.subscriptionName' => '订阅',
    'change-subscriptions-owner.ownerName' => '所有者',
    'change-subscriptions-owner.currentIpAddress' => '当前 IP 地址',
    'change-subscriptions-owner.newIpAddress' => '新 IP 地址',
    'change-subscriptions-owner.noIpAddress' => '无可用 IP 地址',
    'change-subscriptions-owner.submit' => '重新分配',
    'change-subscriptions-owner.warningCustom' => "即将从当前服务方案取消限制订阅，并变成'自定义'。",
    'change-subscriptions-owner.warningEmptyPool' => "新所有者的提供商的 IP 池为空。请确保提供商的 IP 池中至少有一个 IP 地址。",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM 内存、CPU、磁盘 I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => '对订阅所消耗的系统资源设定限制。Plesk 会使用名为控制组群 (cgroups) 的 Linux 内核功能来确保不会超过限制。',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => '限制单个订阅只能使用指定量的 CPU。',
    'cgroups-settings.cpuPeriodLimit' => '检查 CPU 使用量的时段',
    'cgroups-settings.percentUsageDescription' => 'CPU 总时间等于您服务器的 %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'RAM 内存',
    'cgroups-settings.ramSettingsDescription' => '限制单个订阅只能使用指定量的 RAM 内存。注意如果订阅超过该限制，消耗大部分内存的进程将会被停止。',
    'cgroups-settings.ramPeriodLimit' => '检查内存使用量的时段',
    'cgroups-settings.diskSettings' => '磁盘 I/O',
    'cgroups-settings.diskReadSettings' => '磁盘读取',
    'cgroups-settings.diskReadSettingsDescription' => '允许单个订阅只能使用指定限制内的磁盘读取带宽。',
    'cgroups-settings.diskReadPeriodLimit' => '检查磁盘读取使用量的时段',
    'cgroups-settings.diskWriteSettings' => '磁盘写入',
    'cgroups-settings.diskWriteSettingsDescription' => '允许单个订阅只能使用指定限制内的磁盘写入带宽。',
    'cgroups-settings.diskWritePeriodLimit' => '检查磁盘写入使用量的时段',
    'cgroups-settings.limit' => '限制',
    'cgroups-settings.threshold' => '超过时通知',
    'cgroups-settings.limitNotificationEnabled' => '通知已启用',
    'cgroups-settings.periodFiveMinutes' => '5 分钟',
    'cgroups-settings.periodHour' => '1 小时',
    'cgroups-settings.periodDay' => '1 日（24 小时）',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/秒',

    'custom-button.privateLabel' => '仅向我显示',
    'custom-button.textLabel' => '按钮标签',
    'custom-button.tooltipLabel' => '工具提示文本',
    'custom-button.iconLabel' => '背景图片',
    'custom-button.priorityLabel' => '优先级',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => '添加参数到 URL',
    'custom-button.placeLabel' => '位置',
    'custom-button.internalLabel' => '在 Plesk 中打开 URL',
    'custom-button.internalDescription' => '指定是否在 Plesk 页面上或新的浏览器窗口中打开 URL。',
    'custom-button.noFrameLabel' => '不要使用帧',
    'custom-button.noFrameDescription' => '如果您添加一个引向客户面板中的 Plesk 扩展或应用程序的自定义按钮，您可指定该扩展/应用程序显示的方式：在帧中或作为 Plesk GUI 的一部分。',
    'custom-button.urlParamLabel_dom_id' => '包括订阅 ID、域名 ID 和域名别名 ID',
    'custom-button.urlParamLabel_dom_name' => '包括主域名',
    'custom-button.urlParamLabel_ftp_user' => '包含 FTP 用户名',
    'custom-button.urlParamLabel_ftp_pass' => '包含 FTP 密码',
    'custom-button.urlParamLabel_cl_id' => '包含客户ID',
    'custom-button.urlParamLabel_cname' => '包含客户的公司名称',
    'custom-button.urlParamLabel_pname' => '包含客户的联系人姓名',
    'custom-button.urlParamLabel_email' => '包含客户的电子邮箱',
    'custom-button.buttonPlace_navigation' => '通用访问',
    'custom-button.buttonPlace_admin' => '管理员首页',
    'custom-button.buttonPlace_admin-settings' => '管理员的 工具与设置 页面',
    'custom-button.buttonPlace_reseller' => "代理商首页",
    'custom-button.buttonPlace_reseller-settings' => '代理商的 工具与实用程序 页面',
    'custom-button.buttonPlace_client' => '客户首页',
    'custom-button.buttonPlace_domain' => "订阅的 网站与域名 页面",
    'custom-button.buttonPlace_domain_powerUser' => "主机空间的 网站与域名 页面",
    'custom-button.buttonPlace_domain-properties' => '网站工具',
    'custom-button.fileNotUploaded' => '文件无法上传。',

    'database-server-change-password.adminPassword' => '管理员密码',
    'database-server-change-password.success' => '管理员的密码已更新成功。',

    'database-server-create.general' => '常用',
    'database-server-create.type' => '数据库服务器类型',
    'database-server-create.unixSocket' => '(本地连接)',
    'database-server-create.host' => '主机名称或 IP 地址',
    'database-server-create.port' => '端口号',
    'database-server-create.portDescription' => '将默认端口号保留为空',
    'database-server-create.version' => '数据库服务器版本',
    'database-server-create.default' => '使用此服务器作为 %%type%% 的默认服务器',
    'database-server-create.externalConnections' => '允许本地 MariaDB/MySQL 服务器接受外部连接',
    'database-server-create.externalConnectionsDescription' => '更改该设置将导致本地 MariaDB/MySQL 服务器重新启动。要实现远程访问在 Plesk 中注册的其他 MariaDB/MySQL 服务器，请手动更改其配置。',
    'database-server-create.authentication' => '验证',
    'database-server-create.authenticationAddDescription' => '指定 Plesk 将用于访问数据库服务器的数据库管理员验证凭据。在数据库服务器上必须存在带有这些验证凭据的管理员帐户。',
    'database-server-create.authenticationEditDescription' => '在此处您可以更改 Plesk 将用于访问数据库服务器的验证凭据。这些验证凭据必须匹配数据库管理员的验证凭据。例如，您在数据库服务器上更改了管理员验证凭据后，有必要在 Plesk 中对其进行相应更改。',
    'database-server-create.authenticationChangeDescription' => '在此处您可以更改 Plesk 将用于访问数据库服务器的验证凭据。如果您修改下面的用户名和密码，将会在数据库服务器上和 Plesk 中同时更新带有管理权限的数据库用户帐户。',
    'database-server-create.adminLogin' => '用户名',
    'database-server-create.adminPassword' => '密码',
    'database-server-create.createSuccess' => '数据库服务器已成功创建。',
    'database-server-create.createError' => '创建了数据库服务器，但出现错误：%%error%%',
    'database-server-create.updateSuccess' => '数据库服务器已成功更新。',
    'database-server-create.updateError' => '数据库服务器已更新，但出现错误：%%error%%。',
    'database-server-create.backupSettings' => '备份',
    'database-server-create.backupTempDir' => '临时目录',
    'database-server-create.backupTempDirDescription' => '进入 MS SQL 服务器所在的远程服务器上的物理文件夹的路径。该 MS SQL 服务器必须能够访问该文件夹以读取和写入临时备份文件。例如，C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => '临时网络目录',
    'database-server-create.backupNetworkTempDirDescription' => '网络共享的路径被映射到以上指定的物理文件夹。Plesk 将会访问共享文件夹以下载和上传备份文件。例如，\\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => '用户名',
    'database-server-create.backupNetworkUserDescription' => '在远程服务器上创建的网络用户的用户名。例如，ServerName\\UserName。该用户必须有访问以上指定的共享文件夹的权限。',
    'database-server-create.backupNetworkPassword' => '密码',

    'domain.connection-info.title' => '连接信息',
    'domain.connection-info.systemUserCredentials' => '系统用户验证凭据',
    'domain.connection-info.systemUserCredentialsHint' => '总是启用通过 FTP 进行访问，通过 SSH 或远程桌面进行访问 — 只有在 %%details%% 的情况下。',
    'domain.connection-info.systemUserCredentialsHintDetails' => '已授予权限',
    'domain.connection-info.systemUserRemoveAccessEnabled' => '您的 SSH 或远程桌面访问功能已启用，您无法管理其状态。',
    'domain.connection-info.systemUserRemoveAccessDisabled' => '您的 SSH 或远程桌面访问功能已禁用，您无法管理其状态。',
    'domain.connection-info.ipAddress' => 'IP 地址',
    'domain.connection-info.copyIpAddressTooltip' => '复制 IP 地址到剪切板',
    'domain.connection-info.username' => '用户名',
    'domain.connection-info.copyUsernameTooltip' => '复制用户名到剪切板',
    'domain.connection-info.password' => '密码',
    'domain.connection-info.changeSystemUserPasswordTitle' => '系统用户密码更改',
    'domain.connection-info.changePasswordTooltip' => '更改密码',
    'domain.connection-info.newPassword' => '新密码',
    'domain.connection-info.manageAccess' => '管理访问',
    'domain.connection-info.additionalFtpAccounts' => '其它 FTP 帐户',
    'domain.connection-info.database' => '数据库',
    'domain.connection-info.databaseHint' => '属于订阅的 %%number%% 中的1个数据库。',
    'domain.connection-info.databaseNotCreatedHint' => '未创建数据库。',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => '主机',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => '数据库名称',
    'domain.connection-info.addDatabase' => '添加数据库',
    'domain.connection-info.manageDatabases' => '管理数据库',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => '数据库用户密码更改',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => '不要忘记在此处更改应用程序后更新其配置文件中的密码。',
    'domain.connection-info.buttonSave' => '保存',
    'domain.connection-info.buttonSaving' => '正在保存......',
    'domain.connection-info.buttonCancel' => '取消',
    'domain.connection-info.copyHostTooltip' => '复制主机名到剪切板',
    'domain.connection-info.copyDatabaseNameTooltip' => '复制数据库名称到剪切板',
    'domain.connection-info.copyDatabaseUserTooltip' => '复制数据库用户到剪切板',

    'domain.move.title' => '移动域名 %%name%%',
    'domain.move.hint' => '域名将连同其内容、配置文件、日志文件和 APS 应用程序一起被移动到新订阅。',
    'domain.move.hintMain' => '域名将与其内容、配置文件、日志文件、数据库、数据库用户、其它 FTP 用户、计划任务、smb 用户和 APS 应用程序一同被移动到新的订阅。',
    'domain.move.hintSubdomains' => '子域名 %%subdomains%% 将与父级域名一起移动。',
    'domain.move.hintAliases' => '域名别名 %%aliases%% 将与父级域名一起移动。',
    'domain.move.hintSubdomainsAndAliases' => '子域名 %%subdomains%% 和域名别名 %%aliases%% 将与父级域名一起移动。',
    'domain.move.labelDatabases' => '您移动了域名后，请打开 "数据库" 标签以移动相关联的数据库。',
    'domain.move.hintDatabases' => '如有必要，请单独移动数据库。',

    'domain.move.Form.submitButton' => '移动',
    'domain.move.Form.cancelButton' => '取消',

    'domain.move.selectTarget' => '可用的订阅',
    'domain.move.nothingFound' => '未找到任何项',
    'domain.move.targetIsRequred' => '选择要将域名移动到的订阅。',
    'domain.move.selectNewSubscription' => '创建一个新订阅',
    'domain.move.ipv4Address' => 'IPv4 地址',
    'domain.move.ipv4AddressHint' => '托管网站的 IP 地址是网站虚拟主机的网络地址。',
    'domain.move.ipv6Address' => 'IPv6 地址',
    'domain.move.ipv6AddressHint' => '托管网站的 IP 地址是网站虚拟主机的网络地址。',
    'domain.move.ipAddressIsNotSelected' => '必须至少选定一个 IP 地址。',
    'domain.move.username' => '用户名',
    'domain.move.usernameHint' => '系统用户帐户与主机空间建立关联。 用于通过 FTP 和 SSH 访问托管的文件。',
    'domain.move.usernameIsRequred' => '您必须要提供用户名。',
    'domain.move.password' => '密码',
    'domain.move.passwordIsRequred' => '您必须要提供密码。',
    'domain.move.noAvailableSubscriptions' => '没有可用的订阅',
    'domain.move.noWebHosting' => '域名没有 web 主机因此目前不创建系统用户。',

    'domain.rename.title' => '更改域名',
    'domain.rename.titleAlias' => '更改域名别名',
    'domain.rename.hint' => '您现在正在更改域名 %%domainName%%',
    'domain.rename.hintAlias' => '您现在正在更改域名别名 %%domainName%%',
    'domain.rename.name' => '新域名',
    'domain.rename.nameAlias' => '新域名别名',
    'domain.rename.domainNameIsRequired' => '必填字段为空。请在此字段中输入相应的值。',
    'domain.rename.submitButton' => '更改',
    'domain.rename.submitButtonProgress' => '更改',
    'domain.rename.successMessage' => '域名 %%oldName%% 已被更改为 %%newName%%。',
    'domain.rename.successMessageAlias' => '域名别名 %%oldName%% 已被更改为 %%newName%%。',

    'domain.rename.Form.cancelButton' => '取消',

    'domain.outgoing-messages.hint' => '在此处您可以修改该域名传出信息的数量限制。将无法传出超过指定数量限制的信息。',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => '默认（每小时 %%domainOutgoingMessages%% 条信息）',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => '条信息（每小时）',
    'domain.outgoing-messages.domainOutgoingMessages' => '限制传出消息数',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => '该域名的自定义值',

    'domain.tech-domain-name.title' => '选择您的域名',
    'domain.tech-domain-name.techDomainTitle' => '临时域名',
    'domain.tech-domain-name.customDomainTitle' => '注册的域名',
    'domain.tech-domain-name.techDomainText' => '我还没有注册的域名',
    'domain.tech-domain-name.customDomainText' => '我已经有一个注册的域名',
    'domain.tech-domain-name.techDomain' => '您的临时域名',
    'domain.tech-domain-name.customDomain' => '注册的域名',
    'domain.tech-domain-name.domainName' => '域名',
    'domain.tech-domain-name.techDomainDesc' => '临时域名用于在注册和购买合适的域名之前访问站点。在下列条件下免费提供：',
    'domain.tech-domain-name.techDomainRandom' => '名称是随机生成的',
    'domain.tech-domain-name.techDomainDns' => '它们在 .plesk.page DNS 区域中托管',
    'domain.tech-domain-name.techDomainSwitch' => '您可以在之后的任何时间在域名设置中重命名域名以切换到注册的域名。',
    'domain.tech-domain-name.error' => '发生意外错误。',
    'domain.tech-domain-name.errorNoIpAddress' => '您必须要选择 IP 地址。',
    'domain.tech-domain-name.generating' => '生成中......',

    'get-password.label' => '重设密码',
    'get-password.text' => '请输入您在 Plesk 中注册的电子邮箱地址或用户名，我们将给您发送一封密码重设邮件。',
    'get-password.emailLabel' => '电子邮件地址',
    'get-password.loginLabel' => '用户名',
    'get-password.send' => '发送',
    'get-password.cancel' => '取消',
    'get-password.errorInvalidEmail' => '该电子邮箱未被识别。请再检查一遍，然后再试。',
    'get-password.messageSend' => "密码重设邮件已发送到相关联的电子邮箱地址。\n若邮件未抵达，请联系您的 Plesk 管理员。",
    'get-password.rateLimitReached' => "密码重置尝试次数过多。请稍后重试。",
    'iis-settings.formGeneralHint' => '在此处您可通过更改默认值来指定网站的  IIS web 服务器设置。自定义 IIS 配置是很有帮助的，例如，当您想要在网站上使用新类型的索引文件或要为某个 MIME 类型及某个文件扩展名建立关联时。默认值由您的主机提供商进行定义。',
    'iis-settings.formGeneralHint_powerUser' => '在此处您可指定网站的 IIS web 服务器设置。自定义 IIS 配置是很有帮助的，例如，当您想要在网站上使用新类型的索引文件或要为某个 MIME 类型及某个文件扩展名建立关联时。默认值表示 IIS 将会使用来自其默认配置的响应指令。',
    'iis-settings.virtualDirectoryLoadError' => '无法获取指定的虚拟目录的属性：%%errorMessage%%',
    'iis-settings.general' => '通用设置',
    'iis-settings.example' => "例如：\n%%example%%",
    'iis-settings.settingOn' => '打开',
    'iis-settings.settingOff' => '关闭（默认）',
    'iis-settings.settingDefault' => '默认',
    'iis-settings.settingCustom' => '输入自定义值',
    'iis-settings.mimeTypes' => 'MIME 类型',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME类型会将文件扩展名与文件类型关联起来。通常，这用于为常见的文件类型创建自定义的文件扩展名。',
    'iis-settings.documents' => '默认文档',
    'iis-settings.documentsOff' => '禁用',
    'iis-settings.documentsCustom' => '输入数值',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => '当浏览器没有提供站点内的文档名称时，IIS将查找指定的默认文档，并提供找到的第一个文档。如果您没有指定默认的文档，但打开了目录浏览功能，那么目录列表将在浏览器中显示，而不是在索引页中显示。',
    'iis-settings.expires' => 'Expires',
    'iis-settings.expiresFullDescription' => 'web 服务器将会把 “Expires” 响应头添加到网页。以请求某网页的时间点开始，持续指定的时间长，整个时段即为过期时间戳。',
    'iis-settings.expiresUnitDays' => '天',
    'iis-settings.expiresUnitHours' => '小时',
    'iis-settings.expiresUnitMinutes' => '分钟',
    'iis-settings.expiresUnitSeconds' => '秒',
    'iis-settings.headers' => '其它信息头',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Web服务器将添加指定的HTTP响应头。',
    'iis-settings.directoryBrowsing' => '目录浏览',
    'iis-settings.directoryBrowsingDescription' => '允许用户在 web 浏览器中看到网址目录列表，例如，当无法使用默认的索引页面时。',
    'iis-settings.securityTabDirectory' => '目录安全设置',
    'iis-settings.allowAnonymous' => '匿名验证',
    'iis-settings.allowAnonymousDescription' => '匿名验证允许用户访问您网站的公共内容。匿名用户将无法访问网站上有密码保护的内容以及文件系统层的受保护内容。',
    'iis-settings.allowWindows' => 'Windows 验证',
    'iis-settings.allowWindowsDescription' => 'Windows 验证（以前称之为 NTLM）会保护文件系统层的网站内容。',
    'iis-settings.requireSsl' => '需要 SSL/TLS',
    'iis-settings.requireSslDescription' => '如果您已为您的网站启用 SSL/TLS 支持，该选项会强制 web 客户端（浏览器）仅使用安全的 HTTPS 连接。',
    'iis-settings.securityTabIpDeny' => '访问限制设置',
    'iis-settings.deny' => '拒绝访问该网站',
    'iis-settings.denyOff' => '默认',
    'iis-settings.denyCustom' => '输入自定义值',
    'iis-settings.allow' => '排除',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n禁止指定的主机和网站访问该网站。使用 '*' 拒绝所有连接。",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n允许指定的主机和网站访问该网站。",
    'iis-settings.dynamicIpSecurity' => '通过限制 IIS 动态 IP 以阻止 DoS 攻击。',
    'iis-settings.isDenyByConcurrentRequests' => '拒绝IP地址（基于来自特定IP地址的并发请求数量）',
    'iis-settings.maxConcurrentRequests' => '并发请求的最大数量',
    'iis-settings.isDenyByRequestRate' => '拒绝IP地址（基于一段时间内的请求数量）',
    'iis-settings.maxRequests' => '请求的最大数量',
    'iis-settings.requestInterval' => '时段（以毫秒为单位）',

    'ip-addresses-selector.ipAddress' => 'IP 地址',
    'ip-addresses-selector.ipv4Address' => 'IPv4 地址',
    'ip-addresses-selector.ipv4AddressHint' => "托管网站的 IP 地址是网站虚拟主机的网络地址。",
    'ip-addresses-selector.ipv6Address' => 'IPv6 地址',
    'ip-addresses-selector.ipv6AddressHint' => "托管网站的 IP 地址是网站虚拟主机的网络地址。",
    'ip-addresses-selector.noIpAddressHint' => '无',
    'ip-addresses-selector.shared' => '共享',
    'ip-addresses-selector.exclusive' => '独立',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP 服务器不支持 IPv6。至少分配一个 IPv4 地址，不然用户将无法通过 FTP 上传文件到服务器。',

    'license-key-revert.description' => '具有下列属性的许可证将被恢复:',
    'license-key-revert.submitButton' => '回滚',

    'license-key-upload.description' => '输入激活码来安装您的许可证密钥。',
    'license-key-upload.descriptionWithFileUpload' => '可通过输入激活代码或上传许可证密钥文件来安装许可证密钥。',
    'license-key-upload.type' => '选择下面的一项：',
    'license-key-upload.code' => '输入激活代码',
    'license-key-upload.codeDescription' => '粘贴收到的激活码。',
    'license-key-upload.file' => '上传许可证密钥文件',
    'license-key-upload.fileDescription' => '指定进入包含许可证密钥的文件的路径。',
    'license-key-upload.submitButton' => '安装',

    'log-rotation.customLogsDescription' => '注意您的自定义日志不会循环。',
    'log-rotation.logRotation' => '日志循环',
    'log-rotation.logRotationCondition' => '日志循环条件',
    'log-rotation.logRotationBySize' => '按大小',
    'log-rotation.logRotationByTime' => '按时间',
    'log-rotation.logRotationDaily' => '每日',
    'log-rotation.logRotationWeekly' => '每周',
    'log-rotation.logRotationMonthly' => '每月',
    'log-rotation.logRotationSizeDescription' => '大小值必须介于 %%min%% 和 %%max%% kB 之间。',
    'log-rotation.maximumNumberOfFiles' => '日志文件的最大数量',
    'log-rotation.compress' => '压缩日志文件',
    'log-rotation.sendLogToEmail' => 'Plesk 从 web 和 FTP 服务器的日志文件索取数据后，会通过邮件发送日志文件到该地址',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => '週期不能比伺服器範圍內的限制%%max%%大。',

    'login.loginLabel' => '用户名',
    'login.passwdLabel' => '密码',
    'login.loginButtonLabel' => '登录',
    'login.enterUsername' => '输入您的用户名。',
    'login.enterPassword' => '输入您的密码。',
    'login.whatUsernamePassword' => '要使用什么用户名和密码？',
    'login.forgotPasswordLabel' => '忘记您的密码？',
    'login.cookies' => 'Plesk 中的 Cookies 策略',
    'login.avoidSSLWarningsMsg' => '若要在登录 Plesk 的过程中避免 SSL 警告，请使用 %%link%%',
    'login.digitalOceanMsg' => 'Plesk on DigitalOcean 新功能？创建此 droplet 时使用 “root” 和密码进行登录。',
    'login.amazonLightsailMsg' => 'Plesk on Lightsail 新功能？要登录 Plesk，请通过 SSH 访问服务器，并使用 "plesk login" 命令。%%link%%',
    'login.readGuide' => '阅读完整的指南。',
    'login.mobileApplicationMessage' => '为了更佳体验，我们建议您安装 %%name%% 应用程序。',
    'login.mobileApplicationInstall' => '现在安装',
    'login.mobileApplicationHide' => '不，谢谢',

    'force-reset-password.saveButton' => '保存',
    'force-reset-password.title' => '更改您的密码',
    'force-reset-password.passwordLabel' => '新密码',

    'panel-access.title' => '自定义 Plesk URL',
    'panel-access.hint' => '选择用于登录 Plesk 的自定义 URL。这不会影响通过端口 %%httpsPort%% 登录 Plesk 的方式。%%link%%',
    'panel-access.details' => '更多详情',
    'panel-access.proxyEnabled' => '解析为服务器 IP 地址但不用于主机的所有域名和子域名',
    'panel-access.proxyDomain' => '指定的解析为服务器 IP 地址但不用于主机的域名或子域名',
    'panel-access.proxyDisabled' => '没有自定义 URL。 只有 https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => '保存',
    'panel-access.Form.cancelButton' => '取消',

    'panel-access.domainNameIsRequired' => '您必须要提供一个域名。',
    'panel-access.successMessage' => '应用了选定的登录方式。',
    'panel-access.notSupported' => '您的 Plesk 不支持选定的登录方式。',
    'panel-access.notViaDomainName' => '若要应用此登录方式，请选择第一个选项（“所有域名和子域名......”），通过 https://%%domainName%% 登录 Plesk，然后选择第二个选项。',
    'panel-access.notViaPort' => '若要应用此登录方式，请首先通过 https://<server-IP-or-hostname>:%%httpsPort%% 登录 Plesk。',

    'php-settings.performance' => '性能和安全设置',
    'php-settings.performanceSettingsNote' => '这些值不能通过 .htaccess、php.ini 或.user.ini 文件按域名更改，除非该域名属于拥有“主机性能设置管理”权限的订阅。',
    'php-settings.settings' => '通用设置',
    'php-settings.fastCgiSettings' => 'FastCGI 设置',
    'php-settings.fpmSettings' => 'PHP-FPM 设置',
    'php-settings.enableFastcgi' => '启用 FastCGI 设置',
    'php-settings.plainTextEditing' => '其他指令',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => '您可以定义任何 PHP 参数，方法是将其输入到下面的字段中。这些指令将会包括在 PHP 配置中。请使用与 php.ini 相同的句法。例如，要自动加载 mSQL 扩展，请添加以下行：extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => '如果您无法找到某个 PHP 参数，请添加到以下字段。这些其它的指令会与主服务方案中的指令合并。使用如 php.ini 中相同的句法。例如，如果您想要自动加载 mSQL 扩展，需添加：extension=msql.so。',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => '您可以定义任何 PHP 参数，方法是将其输入到下面的字段中。这些指令将会包括在 PHP 配置中。请使用与 php.ini 相同的句法。例如，要自动加载 mSQL 扩展，请添加以下行：extension=msql.so.若要自定义 PHP-FPM 池的设置，请添加 [php-fpm-pool-settings] 分隔符并在下面输入所需的设置。',
    'php-settings.additionalConfigurationDirectives' => '其它的配置指令',
    'php-settings.defaultValue' => '默认',
    'php-settings.predefinedValue' => '选择值',
    'php-settings.customValue' => '输入自定义值',
    'php-settings.phpSettingDescription_memory_limit' => '允许脚本分配的最大内存容量（字节）。',
    'php-settings.phpSettingDescription_max_execution_time' => '脚本终止前允许运行的最大时间（以秒为单位）。',
    'php-settings.phpSettingDescription_max_input_time' => '允许脚本解析输入数据的最大时间（以秒为单位）。',
    'php-settings.phpSettingDescription_post_max_size' => '可通过 POST 方式发布的最大数据量（字节）。通常应大于 upload_max_filesize 而小于 memory_limit。',
    'php-settings.phpSettingDescription_upload_max_filesize' => '上传文件的最大容量（字节）。',
    'php-settings.phpSettingDescription_safe_mode' => '出于安全考虑，PHP 安全模式会对脚本的执行设定一系列限制。',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => '当 safe_mode 指令生效时 PHP 脚本则能够访问指定目录中的文件。该目录必须在 include_path 中。',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => '当 safe_mode 指令生效时 PHP 脚本则能够执行指定目录中的程序。',
    'php-settings.phpSettingDescription_include_path' => '脚本在其上面查找文件（类似系统的 PATH 变量）的目录列表。若要隔开目录，请在 Linux 上使用冒号 (:) 而在 Windows 上使用分号 (;)。',
    'php-settings.phpSettingDescription_sessionsave_path' => '存储 PHP 会话文件的目录。',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'mail() 函数的其它参数。',
    'php-settings.phpSettingDescription_register_globals' => '注册 EGPCS 的内容（环境、GET、POST、Cookie、服务器）变量作为全局变量。',
    'php-settings.phpSettingDescription_open_basedir' => 'PHP 脚本可访问指定目录中的文件。若要隔开目录，请在 Linux 上使用冒号 (:) 而在 Windows 上使用分号 (;)。',
    'php-settings.phpSettingDescription_error_reporting' => '错误报告级别：',
    'php-settings.phpSettingDescription_display_errors' => '确定错误是否以输出的一部分显示。',
    'php-settings.phpSettingDescription_log_errors' => '启用记录 PHP 错误。',
    'php-settings.phpSettingDescription_allow_url_fopen' => '允许 PHP 文件函数通过 FTP 或 HTTP 从远程地址检索数据。',
    'php-settings.phpSettingDescription_file_uploads' => '允许通过 HTTP 上传文件。',
    'php-settings.phpSettingDescription_short_open_tag' => '允许使用 PHP 的 open tag 的简短格式 ( )。',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => '为 GPC (Get/Post/Cookie) 操作设置 magic_quotes 状态。当启用 magic_quotes 时，所有单引号、双引号、反斜杠和空字符都将自动转为反斜杠。',
    'php-settings.phpSettingDescription_disable_functions' => '该指令能够让您禁用某些功能。会使用以逗号隔开的功能名称列表。',
    'php-settings.phpSupport' => 'PHP 支持',
    'php-settings.phpRunAs' => '运行 PHP 以',
    'php-settings.phpVersion' => 'PHP 版本',
    'php-settings.phpHandlerOutdated' => '（已过时）',
    'php-settings.phpHandlerDeprecated' => '（已弃用）',
    'php-settings.phpServedByApache' => '由 Apache 服务',
    'php-settings.phpServedByNginx' => '由 nginx 服务',
    'php-settings.phpSettingsPhpVersion' => '您的 PHP 版本是 %%version%%。',
    'php-settings.phpSettingsPhpDisabled' => 'PHP 已被关闭。',
    'php-settings.phpHandlerTypeHint' => '以下是有关网站的 PHP 配置的详情。如果主机提供商给以您相应的权限则可以更改 PHP 配置。',
    'php-settings.fpmDedicatedHandlerHint' => '使用此处理程序可以增强网站的稳定性，但也会导致额外的内存消耗。',
    'php-settings.phpHandlerChangeHint' => '您已更改了 PHP handler 设置。如果您保存这些更改，您网站上的 PHP 脚本可能会因您的服务器配置停止 %%interval%% 秒。',
    'php-settings.phpHandlerOutdatedHint' => '若要检查新的PHP版本是否可用，请将%%link%%并查看产品组件的“Web 主机”类别。',
    'php-settings.phpHandlerOutdatedHintLink' => '打开 Plesk 安装程序',
    'php-settings.phpHandlerTypeHelpLink' => '了解如何选择最适合的 PHP 设置',
    'php-settings.phpHandlerTypeNotAvailableHint' => '不能禁用 PHP 支持，因为当前的主机配置不包括任何该域名可以进行使用的 PHP 版本。',
    'php-settings.phpHandlersNotAvailableHint' => '无法启用 PHP 支持，因为当前 Plesk 配置不包含任何可用的 PHP 版本。',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => '了解如何启用其他 PHP 版本。',
    'php-settings.phpSupportEditable' => '（PHP 版本 %%version%%，以 %%handler%% 运行 PHP）%%link%%',
    'php-settings.phpSupportReadonly' => '（版本： %%version%%; 处理器：%%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '（未注册）%%link%%',
    'php-settings.showPhpInfo' => '查看 phpinfo() 页面',
    'php-settings.phpSettingsFormError' => '无法索取 PHP 设置因为所需数据缺失。',
    'php-settings.phpSettingsFormBrokenPhpHandler' => '无法检索PHP设置，因为未安装此PHP版本。若要继续，请安装所选的PHP版本或为域名选择另一个版本。',
    'php-settings.showPhpInfoTitle' => '查看 phpinfo()',
    'php-settings.showPhpInfoDescription' => '您的一些 PHP 设置已被更改但是更改还未保存。若要查看 phpinfo() 页面上的新值，请首先应用更改。否则您将会看到当前的值。',
    'php-settings.showPhpInfoButton' => '查看 phpinfo()',
    'php-settings.onState' => '启用',
    'php-settings.offState' => '关闭',
    'php-settings.description' => '该页面会显示网站的 PHP 配置。这些设置针对该网站，而不会影响订阅上的其它网站。如果主机提供商给以您相应的权限则可以更改 PHP 配置。当您想要限制 PHP 脚本消耗的系统资源或想要达到某个 web 应用程序的要求时，自定义 PHP 配置可能会有用。当您设置一个参数为默认值时，PHP 会使用服务器级的 PHP 配置的该参数值。',
    'php-settings.availableVariables' => '您可在参数值中使用以下占位符：',
    'php-settings.variableDocroot' => '{DOCROOT} 代表网站的文档根目录。当前的值为 %%DOCROOT%%。%%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'HTTPS 文档根目录与 http 的相同。',
    'php-settings.variableDocrootHttpsDifferent' => 'HTTPS 文档根目录是 %%DOCROOT%%。',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} 代表订阅主网站的文档根目录。',
    'php-settings.variableTmp' => '{TMP} - 用于存储临时文件的目录。',
    'php-settings.note' => '注意：以下设置可以被 .htaccess、php.ini 或 .user.ini 文件中指定的参数覆盖。',
    'php-settings.showHelp' => '显示帮助',
    'php-settings.select-ariaLabel' => '选择值',
    'php-settings.tuxCarePhpPromo' => '使用过时 PHP 版本的网站可能成为攻击载体。立即通过 %%link%% 确保其安全',
    'php-settings.tuxCarePhpLink' => 'TuxCare PHP 扩展生命周期支持。',
    'php-settings.phpHandlerLabel' => 'PHP 处理程序',
    'php-settings.phpHandlerIdLabel' => 'PHP运行方式',

    'pmm.agent.sync.check' => '迁移与传输代理 正在检查更新。',
    'pmm.agent.sync.updating' => '同步与下载 迁移与传输代理',
    'pmm.agent.sync.done' => '已经成功同步 迁移与传输代理',
    'pmm.agent.sync.downloadLink' => '在开始迁移之前点击下载应该安装于源主机上的 迁移与传输代理 文件。',
    'pmm.agent.sync.error' => '迁移与传输代理 获取更新失败。请稍候再试。',

    'restore-password.title' => '更改您的密码',
    'restore-password.passwordLabel' => '新密码',
    'restore-password.buttonRestore' => '保存',
    'restore-password.buttonCancel' => '取消',
    'restore-password.isEmpty' => '必填字段为空。您需要指定一个值。',
    'restore-password.errorInvalidSecret' => '无效密码',
    'restore-password.errorNotFoundSecret' => '请申请一个新密码',
    'restore-password.restoreSuccess' => '您的密码已更新。使用新的密码登录到 Plesk 或到您的电子邮箱地址。',

    'scheduler.settings.schedulerNotification' => '计划程序通知',
    'scheduler.settings.notificationOff' => "已关闭",
    'scheduler.settings.notificationDefault' => "发送到默认邮件地址 (%%email%%)",
    'scheduler.settings.notificationCustom' => "发送到我指定的电子邮件",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => '使用时区显示任务计划',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => '使用系统默认的时区 (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => '使用系统默认的时区',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => '使用我指定的时区',

    'scheduler.task.active' => '活动',
    'scheduler.task.subscription' => '订阅',
    'scheduler.task.subscription_powerUser' => '主机空间',
    'scheduler.task.type' => '任务类型',
    'scheduler.task.typeCommand' => '运行命令',
    'scheduler.task.typeUrl' => '获取 URL',
    'scheduler.task.typeScript' => '运行 PHP 脚本',
    'scheduler.task.command' => '命令',
    'scheduler.task.arguments' => '带有参数',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => '指定一个绝对 URL，如 http://example.com。如果响应状态代码为 2xx 或 3xx，则该任务被认为已成功执行。',
    'scheduler.task.script' => '脚本路径',
    'scheduler.task.scriptRelativePathDescription' => '示例：%%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => '指定该脚本的完整路径。示例：%%path%%',
    'scheduler.task.scriptPhpVersion' => '使用 PHP 版本',
    'scheduler.task.scriptPathPopupTitle' => '脚本路径',
    'scheduler.task.chooseFile' => '选择文件',
    'scheduler.task.run' => '运行',
    'scheduler.task.on' => '打开',
    'scheduler.task.at' => '在',
    'scheduler.task.sysUser' => '系统用户',
    'scheduler.task.hourly' => '每小时',
    'scheduler.task.daily' => '每日',
    'scheduler.task.weekly' => '每周',
    'scheduler.task.monthly' => '每月',
    'scheduler.task.yearly' => '每年',
    'scheduler.task.cronStyle' => 'Cron 类型',
    'scheduler.task.cronStyleHint' => '请使用 UNIX crontab 格式 "分钟 小时 日 月 星期"。例如 "0 22 * * 1-5"。Plesk 将会使用默认的系统时区运行任务。',
    'scheduler.task.cronStyleWinHint' => '请使用格式 "分钟 小时 日 月 星期"，例如，"0 22 * * 6,7"。Plesk 将会使用默认的系统时区运行任务。',
    'scheduler.task.notify' => '通知',
    'scheduler.task.notifyIgnore' => '不通知',
    'scheduler.task.notifyErrors' => '仅错误',
    'scheduler.task.notifyAlways' => '每次',
    'scheduler.task.notifyErrorsHint' => '通知包含命令的标准错误流。如果输出流为空，则不会发送通知。',
    'scheduler.task.notifyErrorsHintWin' => '通知包含命令输出，只有在退出代码为非零值时才发送。',
    'scheduler.task.notifyAlwaysHint' => '通知包含命令输出。如果输出为空，则不会发送通知。',
    'scheduler.task.notifyAlwaysHintWin' => '通知包含命令输出，不管命令退出代码是什么都会发送该通知。',
    'scheduler.task.emailType' => '发送通知到',
    'scheduler.task.emailTypeDefault' => '默认的系统用户 (%%email%%)',
    'scheduler.task.emailTypeOwner' => '订阅所有者 (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => '管理员 (%%email%%)',
    'scheduler.task.emailTypeCustom' => '其它用户',
    'scheduler.task.emailTypeCustomDescription' => '您可以指定多个地址，以逗号隔开。',
    'scheduler.task.minute' => '分钟',
    'scheduler.task.shortMinute' => '分钟',
    'scheduler.task.dayOfMonth' => '日',
    'scheduler.task.description' => '描述',
    'scheduler.task.scheduleTimezoneHint' => '运行任务的时区是 %%timezone%%',
    'scheduler.task.runTaskNow' => '现在运行',
    'scheduler.task.runningTask' => '正在运行任务 "%%task%%"...',

    'server-settings.submitDone' => "服务器设置已更改。",
    'server-settings.systemSettings' => "系统设置",
    'server-settings.fullHostName' => "完整的主机名",
    'server-settings.trafficStatisticsPeriod' => "保留网站和流量统计",
    'server-settings.trafficStatisticsPeriodUnit' => "月",
    'server-settings.diskSpaceUsageCalculation' => "包含在磁盘空间使用量计算中",
    'server-settings.includeLogs' => "日志文件",
    'server-settings.includeLogsAndStats' => "日志文件和统计报告",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL 数据库",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL Server 数据库",
    'server-settings.includePgsqlDatabases' => "PostgreSQL 数据库",
    'server-settings.includeDatabases' => "数据库",
    'server-settings.includeRemoteDatabases' => "远程数据库",
    'server-settings.includeMailboxes' => "邮箱",
    'server-settings.includeMailLists' => "邮件列表",
    'server-settings.includeDomainDumps' => "域名备份文件",
    'server-settings.includeAdminDumps' => "管理员创建备份文件",
    'server-settings.calculatingDiskSpaceUsage' => "当计算磁盘空间使用量时，计算",
    'server-settings.typeByte' => "文件大小",
    'server-settings.typeBlock' => "磁盘空间使用量",
    'server-settings.trafficCalculation' => "包含在流量计算中",
    'server-settings.inboundAndOutbound' => "入站和出站流量",
    'server-settings.onlyInbound' => "仅入站流量",
    'server-settings.onlyOutbound' => "仅出站流量",
    'server-settings.forbidCreateDnsSubZone' => "不允许用户在其它用户的 DNS 主区域中创建 DNS 子区域",
    'server-settings.webDeployIncludePassword' => "将用户的密码包含到带有 Web Deploy 发布设置的文件中。",
    'server-settings.forbidSysUserRename' => "客户可更改其系统用户的名称",
    'server-settings.alwaysAllowSysUserRename' => "总是",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "只有在已授予主机管理权限的情况下",
    'server-settings.neverAllowSysUserRename' => "从不",
    'server-settings.forbidSubscriptionRename' => "禁止客户和代理商更改其主域名",
    'server-settings.preferredDomain' => "网站的偏好域名",
    'server-settings.preferredDomainNone' => "无",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP 日志记录",
    'server-settings.disableIpLogging' => "禁用 IIS、FTP 和邮件日志中的 IP 日志记录",
    'server-settings.disableIpLoggingDescription' => "如果选定，IIS 和 MailEnable 不再会将 IP 地址写入到日志文件中",
    'server-settings.anonymizeIps' => "隱藏IP地址",
    'server-settings.logrotateAnonymizeIps' => "在日誌輪轉和收集web統計資料時隱藏IP位址",
    'server-settings.logrotateAnonymizeIpsDescription' => '歸檔前，postrotate腳本會用"0"替換掉IPv4 位址的最後八位元位元組。在 IPv6 地址中，腳本會用"0000" （完整的形式）或"0"（簡短的形式） 替換掉該位址的後半部分（最後一個冒號後的兩個八位元位元組）',
    'server-settings.logrotate' => "日誌輪轉",
    'server-settings.logrotateForce' => "強制為所有域名執行每日日誌輪轉",
    'server-settings.allowToStoreLogs' => "允许存储网站日志",
    'server-settings.logrotatePeriod' => "天",
    'server-settings.configureUpdatePolicy' => "配置更新策略",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => '默认的服务器级的值（每小时 %%default%% 条信息）',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => '方案的自定义值',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => '订阅的自定义值',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => '信息',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => '发自一个邮箱的信息（每小时）',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => '发自一个域名的信息（每小时）',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => '发自一个订阅的信息（每小时）',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => '超过应在接下来一小时内发送的每小时信息限额的百分比',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '如果邮箱每小时传出邮件的限额为 100 而百分比为 10%，那么将可允许用户每小时提交 110  个信息，一个小时内可发送 100 个信息，而另外 10 个信息将会列入邮件队列中，准备在下一个小时发送。',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail 使用策略',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => '默认的服务器级设置（允许使用 Sendmail）',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => '默认的服务器级设置（不允许使用 Sendmail）',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => '方案的自定义设置',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => '订阅的自定义设置',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => '允许把 Sendmail 用于该订阅上的脚本和用户',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => '即使在超过了邮箱和域名的限制的情况下脚本和用户也将能够使用  Sendmail 发送邮件信息（代表订阅的系统用户）。可通过 Sendmail 发送的信息最大数量将由整个订阅的限制所定义。',

    'setup.hint' => '欢迎来到 Plesk，这是一款能够帮助您更优管理服务器的全能控制面板。Plesk 提供即购即可编码的环境，并配备一整套功能强大的扩展，帮助您更方便快捷地开发网站和应用。完成设置流程以开始使用 Plesk（只需要一分钟时间）。',
    'setup.contactInfoSection' => '联系信息',
    'setup.contactInfoSectionHint' => '输入您的姓名和电子邮箱地址，以便确定您是服务器的所有者，并接收有关该服务器的重要通知信息。如果您是一名企业服务器管理人员，请不要输入您的个人姓名或电子邮件地址。请使用您的职位名称和企业电子邮件地址，以避免违反数据保护法。',
    'setup.contactName' => '联系人姓名',
    'setup.emptyContactName' => '请提供一个联系人姓名。',
    'setup.contactNameTooLong' => '联系人姓名太长（最多允许 %max% 个字符）。',
    'setup.email' => '电子邮箱',
    'setup.emptyEmail' => '请提供电子邮件地址。',
    'setup.passwordSection' => '密码',
    'setup.passwordSectionHint' => '下次您登录 Plesk 时，请使用用户名 \'admin\' 和在下面输入的密码。',
    'setup.password' => '密码',
    'setup.licenseSection' => '许可证',
    'setup.licenseSectionHint' => '您需要安装一个许可证才能使用 Plesk。',
    'setup.licenseType' => '选择您的许可证类型',
    'setup.licenseTypePaid' => '使用付费许可证',
    'setup.activationCodeLabel' => '在此输入您的激活代码',
    'setup.onlineStoreLink' => '在线商店',
    'setup.licenseTypeTrial' => '使用全功能的试用许可证',
    'setup.activationCodeHint' => '如果您已购买了 Plesk 许可证，请在此处粘贴您收到的激活码。如还未购买，可以进入我们的 %%onlineStoreLink%% 购买新的许可证。',
    'setup.privacyPolicyLink' => 'WebPros 隐私策略',
    'setup.trialLicenseAgreement' => '为了签发试用许可证，WebPros International GmbH 将根据 %%privacyPolicyLink%% 使用和处理其内部系统中提供的信息。',
    'setup.eulaAgreementLabel' => '我确认已阅读并接受 %%link%%',
    'setup.eula' => '最终用户许可协议',
    'setup.invalidEulaAgreementValue' => '您必须接受最终用户许可协议',
    'setup.sendButton' => '进入 Plesk >>',
    'setup.resetPasswordOnFirstLogin' => '在下次登录时重置管理员的密码',

    'spam-filter.add.titleBlack' => '添加地址到黑名单中',
    'spam-filter.add.titleWhite' => '添加地址到白名单中',
    'spam-filter.add.fileDescription' => '上传一个 UTF-8 文档编码的文本文件（例如，*.txt 或 *.csv 文件）。',
    'spam-filter.add.listDescription' => '格式规则：<ul><li>使用逗号、分号或另起一行、空格或制表符分隔各个地址。</li><li>不要在 @ 符号左侧使用非 ASCII 字符。</li><li>您可以使用“*”和“?”通配符（例如，<nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>）。</li><li>不要在域名的非 ASCII 部分使用通配符。</li></ul>',
    'spam-filter.add.fromFile' => '来自文件',
    'spam-filter.add.fromList' => '来自列表',
    'spam-filter.add.success' => '已添加地址',

    'ssl-certificate.add.name' => '证书名称',
    'ssl-certificate.add.longName' => '指定的证书名称太长（允许最多 %max% 个字符）。',
    'ssl-certificate.add.certificateNameUsed' => '名为 %%name%% 的证书已存在。',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS 证书已签发。若要令其运行工作，请分配证书以保护域名、邮件或 web 邮箱的安全。',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS 证书已被成功更新。',
    'ssl-certificate.add.settings' => '设置',
    'ssl-certificate.add.settingsHint' => '使用该表格生成证书请求，从提供商购买证书，或者生成自签名证书。',
    'ssl-certificate.add.settingsHint2' => '一个请求是包含有关您在表格中指定的域名信息的 CSR 文件。您可以将此请求发给证书颁发机构，他们即可为您颁发证书。然后您可以用以下的上传表格将其上传。',
    'ssl-certificate.add.settingsHint3' => '自签名证书是由其创建者签发的身份证书。如果您使用此类证书，表示您自己要核实您网站的身份。尽管自签名证书允许使用 SSL/TLS，但其可信度低，安全性不高。',
    'ssl-certificate.add.bits' => '比特',
    'ssl-certificate.add.country' => '国家',
    'ssl-certificate.add.state' => '省/市/自治区',
    'ssl-certificate.add.longState' => '指定的州或省份名称太长。',
    'ssl-certificate.add.city' => '地址（市）',
    'ssl-certificate.add.longCity' => '指定的城市名称太长。',
    'ssl-certificate.add.shortCity' => '指定的城市名称太短。',
    'ssl-certificate.add.companyName' => '组织名称(公司)',
    'ssl-certificate.add.longCompanyName' => '指定的公司名称太长。',
    'ssl-certificate.add.companyUnitName' => '组织部门/分部名称',
    'ssl-certificate.add.longCompanyUnitName' => '指定的机构部门名称太长（允许最多 %max% 个字符）。',
    'ssl-certificate.add.domainName' => '域名',
    'ssl-certificate.add.email' => '电子邮件',
    'ssl-certificate.add.request' => '请求',
    'ssl-certificate.add.buyCertificate' => '购买 SSL/TLS 证书',
    'ssl-certificate.add.selfSigned' => '自签名',
    'ssl-certificate.add.invalidCertificateParams' => '一些字段为空或包含不合适的值。该值应限于 64 个字符。如果您正使用国际域名，请确定在转换为 ASCII 格式时各个点号之间的域名部分不超过 63 个字符。检查字段：',
    'ssl-certificate.add.unableCreateCsr' => '无法创建 CSR：%%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => '无法创建自签证书：%%error%%',
    'ssl-certificate.add.unableCreateUpload' => '无法设置证书数据：%%error%%',
    'ssl-certificate.add.unableSaveCertificate' => '无法在数据库中保存证书：%%error%%',
    'ssl-certificate.add.uploadFiles' => '上传证书文件',
    'ssl-certificate.add.uploadFilesHint' => '使用该表格以组成文件形式上传证书的组成部分。',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "私钥 (*.key)",
    'ssl-certificate.add.certificate' => "证书 (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA 证书 (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "上传证书",
    'ssl-certificate.add.fileNotUploaded' => '无法上传证书文件：%%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => '无法设置私钥：%%error%%',
    'ssl-certificate.add.unableSetCertificate' => '无法设置证书：%%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => '无法设置 CA 证书：%%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => '无法检查 CA 证书是否签署了证书：%%error%%',
    'ssl-certificate.add.removeCaCertificate' => '移除',
    'ssl-certificate.add.removeCaCertificateConfirmation' => '您想要移除 CA 证书吗？',
    'ssl-certificate.add.unableRemoveCaCertificate' => '无法清除 CA 证书：%%error%%',
    'ssl-certificate.add.caCertificateRemoved' => '证书的 CA 部分已被移除。',
    'ssl-certificate.add.rename' => '重命名',
    'ssl-certificate.add.unableRenameCertificate' => '无法重命名证书：%%error%%',
    'ssl-certificate.add.certificateRenamed' => '证书已被重命名为 %%name%%。',
    'ssl-certificate.add.uploadText' => "以文本形式上传证书",
    'ssl-certificate.add.uploadTextHint' => '使用该表格以文本形式上传证书的组成部分。复制文件内容并粘贴到相应的字段。',
    'ssl-certificate.add.sendText' => "上传证书",
    'ssl-certificate.add.componentIsMissing' => '该组件已丢失。',

    'ssl-certificate.find-private-key.findPrivateKey' => '在此处上传证书',
    'ssl-certificate.find-private-key.formGeneralHint' => '如果您在该服务器上创建了证书签名请求且收到了证书文件，请在此处上传它。如果您想要上传证书和在其它服务器上生成的私钥对，或生成自签名证书，请点击 <b> 添加 SSL/TLS 证书</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => '给域名添加 SSL/TLS 证书后，需要在网站主机设置中启用 SSL/TLS 支持并选择该证书：<b>网站与域名</b> > <b>主机设置</b>（该域名）/> <b>安全</b>。',
    'ssl-certificate.find-private-key.uploadCertificate' => '证书 (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => '上传证书',
    'ssl-certificate.find-private-key.fileNotUploaded' => '无法上传证书文件。',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => '无效的证书格式。',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => '无法为证书找到合适的私钥。',

    'ssl-certificate.secure.certificate' => '选择证书',
    'ssl-certificate.secure.serverPool' => '服务器池',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "日期",
    'system-time.dateAndTime' => "日期和时间",
    'system-time.daylight' => "自动将时钟调整为夏令时制",
    'system-time.dayMonthYear' => "日-月-年",
    'system-time.domainNameOrIp' => "域名或 IP",
    'system-time.hoursMinutesSeconds' => "时：分：秒",
    'system-time.networkTime' => "网络时间",
    'system-time.submitDone' => "系统时间设置已更改。",
    'system-time.synchronizedSystemTime' => "同步系统时间",
    'system-time.title' => "系统日期和时间",
    'system-time.timezone' => "时区",
    'system-time.time' => "时间",
    'system-time.updateSystemTime' => "更新系统时间",
    'system-time.yourTimezone' => "您的时区",

    'web-app-firewall.pageHint' => 'Web 应用程序防火墙会基于用户定义的规则检查和过滤接收的 HTTP 请求来保护 web 应用程序以令其免受攻击。',
    'web-app-firewall.webSitePageHint' => '在此处您可以配置 web 应用程序防火墙 (ModSecurity)。',
    'web-app-firewall.ruleEngine' => 'Web 应用程序防火墙模式',
    'web-app-firewall.ruleEngineOn' => '启用',
    'web-app-firewall.ruleEngineOnDescription' => '会针对一组规则对每次传入的 HTTP 请求以及相应响应进行检查。如果检查成功，该 HTTP 请求就会被传递到网站内容。如果检查失败，该事件就会被记录下来，会发送一个通知，且该 HTTP 响应会带有一个错误代码。',
    'web-app-firewall.ruleEngineOff' => '停用',
    'web-app-firewall.ruleEngineOffDescription' => '传入 HTTP 请求和相关响应不会被检查。',
    'web-app-firewall.ruleEngineDetectionOnly' => '仅检测',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => '会针对一组规则对每次传入的 HTTP 请求以及相应响应进行检查。如果检查成功，该 HTTP 请求就会被传递到网站内容。如果检查失败，该事件就会被记录下来且 ModSecurity 不会执行其它操作。其它服务（例如 Fail2ban）仍可以在检查失败的 HTTP 请求上执行其操作。',
    'web-app-firewall.ruleSetsSection' => '规则集',
    'web-app-firewall.ruleSetsSectionHint' => '选择用于检查接收的 HTTP 请求的规则集（包含安全规则的文件包）。',
    'web-app-firewall.ruleSet' => '规则集',
    'web-app-firewall.ruleSetCrs' => 'OWASP（免费）',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity 核心规则集有严格限制，可能会组织某些功能（如文件共享、Webmail）和网络应用程序的部分功能（如 WordPress 插件）。',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '应用更改？',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP 规则会非常严格，因此可能会阻止一些功能，例如，文件共享、web 邮箱和某些 web 应用程序。',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard（免费，可升级至 Atomic Advanced）',
    'web-app-firewall.ruleSetTortixDescription' => 'Atomicorp 的 ModSecurity 规则的入门版本。这些规则可提供基本保护，并每月更新。',
    'web-app-firewall.ruleSetTortixHowTo' => '将此规则集升级至 Atomic Advanced：',
    'web-app-firewall.ruleSetTortixBuy' => '从 Plesk 网站购买 %%linkPleskStore%% 和 %%linkDocumentation%%。',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Atomicorp 的高级 ModSecurity 规则',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => '安装购买的额外许可证秘钥',
    'web-app-firewall.ruleSetTortixSelect' => '选择此规则集会将其名称更改为“Atomic Advanced（购买自 Plesk）”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced（购买自 Plesk）',
    'web-app-firewall.ruleSetTortixProDescription' => 'Atomicorp 的高级 ModSecurity 规则包括 Atomic 标准规则及一些高级功能。',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced（购买自 Atomicorp）',
    'web-app-firewall.ruleSetAtomicDescription' => 'Atomicorp 的高级 ModSecurity 规则包括 Atomic 标准规则及一些高级功能。',
    'web-app-firewall.ruleSetAtomicInstall' => '切换到其它的 Atomicorp 账号。',
    'web-app-firewall.ruleSetAtomicInstalled' => '规则集已激活。',
    'web-app-firewall.ruleSetAtomicHowTo' => '如果您已经有 Atomicorp 账号并购买了 Atomic 高级规则，请在下面输入账号验证凭据以启用此规则集。',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => '如果您已经有 Atomicorp 账号并购买了 Atomic 高级规则，请在下面输入账号验证凭据以切换账号。',
    'web-app-firewall.ruleSetAtomicLogin' => '用户名',
    'web-app-firewall.ruleSetAtomicPassword' => '密码',
    'web-app-firewall.ruleSetComodo' => 'Comodo（免费订阅）',
    'web-app-firewall.ruleSetComodoDescription' => '免费 Comodo ModSecurity 规则。这些规则可提供基本保护。',
    'web-app-firewall.ruleSetComodoInstall' => '切换到其它的 Comodo 账号。',
    'web-app-firewall.ruleSetComodoInstalled' => '规则集已激活。',
    'web-app-firewall.ruleSetComodoHowTo' => '要启用该规则集：',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => '若要切换到其它的账号，请如下操作：',
    'web-app-firewall.ruleSetComodoRegister' => '在 Comodo 网站上注册',
    'web-app-firewall.ruleSetComodoCredentials' => '从该网站输入用户名和密码。',
    'web-app-firewall.ruleSetComodoLogin' => '用户名',
    'web-app-firewall.ruleSetComodoPassword' => '密码',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo（免费）',
    'web-app-firewall.ruleSetComodoFreeDescription' => '免费 Comodo ModSecurity 规则。这些规则可提供基本保护。',
    'web-app-firewall.ruleSetCustom' => '自定义规则集',
    'web-app-firewall.ruleSetCustomDescription' => '请上传自定义 web 应用程序防火墙规则集。支持的格式：zip、tar.gz、tgz、tar.bz2、conf。',
    'web-app-firewall.ruleSetCustomUpload' => '选择其它文件',
    'web-app-firewall.ruleSetError' => '安装 ModSecurity 规则集失败：%%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP 规则集缺失。使用 Plesk 安装程序重新安装 ModSecurity。',
    'web-app-firewall.ruleSetCustomMissingError' => '自定义规则集缺失。重新安装规则集。',
    'web-app-firewall.ruleSetAuthError' => '指定的用户名或密码无效。',
    'web-app-firewall.ruleSetInvalid' => '选定的规则集无法在 %%webServer%% 上运行。',
    'web-app-firewall.ruleSetSelectedInvalid' => '选定的规则集无法在选定的 web 服务器上运行。',
    'web-app-firewall.webServer' => '运行规则于',
    'web-app-firewall.webServerHint' => '选择所需的 web 服务器和 ModSecurity 版本组合以查看兼容的规则集。',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => '反向代理服务器 (nginx) 已关闭而无法用于处理请求。请选择<a href="%%serverUrl%%">其它的 web 服务器</a>或在<a href="%%servicesUrl%%">服务管理页面</a>上开启反向代理服务器。',
    'web-app-firewall.nginxIsIncompatible' => '选择不同的 ModSecurity 版本可能会导致某些设置不再有效（例如，您无法使用正则表达式关闭 ModSecurity 3 的安全规则）。请确保您的设置在应用更改后仍能照常运行。另外，您可以将可关闭安全规则的设置重设为默认值。',
    'web-app-firewall.nginxResetCustomizations' => '将关闭安全规则的服务器和域名设置重设为默认值。',
    'web-app-firewall.ruleSetUpdate' => '更新规则集',
    'web-app-firewall.ruleSetUpdateDaily' => '每日',
    'web-app-firewall.ruleSetUpdateWeekly' => '每周',
    'web-app-firewall.ruleSetUpdateMonthly' => '每月',
    'web-app-firewall.currentRuleSet' => '规则集',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '正在 %%webServer%% 上运行的 %%ruleSet%%',
    'web-app-firewall.changeRuleSetLink' => '修改规则集',
    'web-app-firewall.ruleSetRollbackFailed' => '无法使用当前的 ModSecurity 规则集和回滚到之前的版本，因为它们包含无效的规则。',
    'web-app-firewall.configurationSection' => '配置',
    'web-app-firewall.configurationSectionHint' => '请使用预定义的参数集或您自定义的 ModSecurity 指令配置 web 应用程序防火墙。',
    'web-app-firewall.configPreset' => '预先定义的值',
    'web-app-firewall.configPresetFast' => '快速',
    'web-app-firewall.configPresetFastDescription' => 'HTTP 请求 URI 和部分标头将会被分析。',
    'web-app-firewall.configPresetTradeOff' => '权衡',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP 请求 URI、标头和请求 POST 数据将会被分析。',
    'web-app-firewall.configPresetThrough' => '彻底',
    'web-app-firewall.configPresetThroughDescription' => '整个 HTTP 请求标头、请求 POST 数据和 HTTP 响应文本内容将被分析。',
    'web-app-firewall.configCustom' => '自定义指令',
    'web-app-firewall.configCustomDescription' => "在此处输入 ModSecurity 指令。它将会覆盖之前指定的指令（规则集、具体规则、预先定义的值，等等）\n例如：SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'ModSecurity 配置无效：%%error%%',
    'web-app-firewall.configRollbackFailed' => '无法使用当前的 ModSecurity 配置文件且无法回滚到文件的原版本因为它们包含无效的配置。',
    'web-app-firewall.rulesSection' => '关闭安全规则',
    'web-app-firewall.rulesSectionHint' => '您可在此关闭安全规则。若您能够找出对某些网站太过严格的安全规则，那就方便了。要停用安全规则，请指定其 ID（例如 340003 或 340005-340007）、标签（例如 CVE-2011-4898）或规则信息（例如 XSS）中的正则表达式。',
    'web-app-firewall.rulesSectionNginxHint' => '您可在此关闭安全规则。若您能够找出对某些网站太过严格的安全规则，那就方便了。要停用安全规则，请指定其 ID（例如 340003 或 340005-340007）、标签（例如 CVE-2011-4898）或规则信息（例如 "Found User-Agent associated with security scanner"）。',
    'web-app-firewall.filterById' => '安全规则 ID',
    'web-app-firewall.filterByIdInvalid' => '下列值无效：%%values%%。规则 ID 应包含数字或数字范围，如 913100、913105-913107。',
    'web-app-firewall.filterByIdInvalidRanges' => '以下范围无效：%%ranges%%。',
    'web-app-firewall.filterByTag' => '标签',
    'web-app-firewall.filterByTagActive' => '已启用：',
    'web-app-firewall.filterByTagDeactivated' => '已停用：',
    'web-app-firewall.filterByTagInvalid' => '下列选定的值无效：%%values%%。',
    'web-app-firewall.filterByRegexp' => '规则信息中的正则表达式',
    'web-app-firewall.filterByRegexpInvalid' => '以下值无效：%%values%%。其不得包含任何 “,” 字符。',
    'web-app-firewall.filterByRegexpNginx' => '规则信息',
    'web-app-firewall.filterByRegexpNginxHint' => '只支持严格匹配的。',
    'web-app-firewall.filterByRegexpNginxInvalid' => '以下值无效：%%values%%。规则信息必须由字母、数字、空格或字符 -:;.,!?#&$%*()/ 组成。',
    'web-app-firewall.auditLogSection' => 'ModSecurity 审计日志',
    'web-app-firewall.auditLogHint1' => 'ModSecurity 审计日志文件是系统中最重要的信息。当 ModSecurity 检测到任何发生的事件，就会在审计日志文件中生成一个条目。',
    'web-app-firewall.auditLogHint2' => '当您修改 web 应用程序防火墙模式从关闭或仅检测到打开时，一个网站可能会停止运行。如果出现这样的情况，请分析 ModSecurity 审计日志查找原因。您可以关闭特别严格的安全规则或调整网站。',
    'web-app-firewall.auditLogHint3' => '要找出为何一个网站上的 HTTP 请求无法完成：',
    'web-app-firewall.auditLogPoint1' => '点击下面的 ModSecurity 日志文件链接并在新的浏览器窗口中打开审计日志。',
    'web-app-firewall.auditLogPoint2' => '使用搜索（在大部分的 web 浏览器中按下 Ctrl+F）查找出问题的网站（域名）。例如，your_domain.tld。浏览器将会凸显如 HOST: your_domain.tld 的条目。',
    'web-app-firewall.auditLogPoint3' => '在凸显条目以上的三行中，找到如 --eece5138-B-- 的字串。连字符中间的八个字符（即 eece5138）是 HTTP 请求触发的事件的 ID。',
    'web-app-firewall.auditLogPoint4' => '进一步查找带有相同事件 ID 的其它条目。查找事件 ID 后面带有字母 H 的条目（例如，eece5138-H--）。该条目包含 ID 和当检查 HTTP 请求时触发的安全规则的描述。安全规则 ID 是在方框内带有 ID 前缀置于引号中的一个整数（例如， [id "340003"]）。',
    'web-app-firewall.auditLogPoint5' => '使用子字符串（例如，[id "3）在事件中查找安全规则 ID。',
    'web-app-firewall.auditLogPoint6' => '在下面的安全规则部分关闭带有该 ID 的安全规则：请输入安全规则 ID（仅数字）到安全规则 ID 字段然后点击确定。',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity 日志文件',
    'web-app-firewall.auditLogListLink' => '日志压缩文件',
    'web-app-firewall.errorLogSection' => '错误日志',
    'web-app-firewall.errorLogSectionHint' => '当您修改 web 应用程序防火墙模式从关闭或仅检测到打开时，一个网站可能会停止运行。如果出现这样的情况，请分析错误日志查找原因。您可以关闭特别严格的安全规则或调整网站。',
    'web-app-firewall.errorLogViewLink' => '错误日志文件',
    'web-app-firewall.notificationStateEnabled' => '有关规则集更新的 Plesk UI 通知已开启：%%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => '有关规则集更新的 Plesk UI 通知已关闭：%%notificationLink%%',
    'web-app-firewall.notificationLink' => '在通知页面上对其管理',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => '选择“权衡”或“彻底”选项可能会导致WordPress网站故障，以及其他不必要的副作用，因为以下 <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity 问题</a>。',
    'web-app-firewall.fileNotUploaded' => '文件无法上传。',

    'web-server-settings.selectUnitSize' => '选择单位大小',
    'web-server-settings.inputSize' => '输入大小',

    'ProtectedDirectory.pathLabel' => '目录名称',
    'ProtectedDirectory.realmLabel' => '受保护区的标题',
    'ProtectedDirectory.locationLabel' => '目录位置',
    'ProtectedDirectory.isNonSslLabel' => '非 SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => '报告名称',
    'SummaryReport.Layout.isDefault' => '作为默认报告',
    'SummaryReport.Layout.sections' => '部分',
    'SummaryReport.Layout.general' => '常用',
    'SummaryReport.Layout.resellers' => '代理商',
    'SummaryReport.Layout.clients' => '客户',
    'SummaryReport.Layout.personalClients' => '个人客户',
    'SummaryReport.Layout.domains' => '域名',
    'SummaryReport.Layout.personalDomains' => '个人域名',
    'SummaryReport.Layout.type.full' => '全量',
    'SummaryReport.Layout.type.summary' => '汇总',

    'SummaryReport.Schedule.enable' => '启用',
    'SummaryReport.Schedule.period' => '发送频率',
    'SummaryReport.Schedule.daily' => '每日',
    'SummaryReport.Schedule.weekly' => '每周',
    'SummaryReport.Schedule.monthly' => '每月',
    'SummaryReport.Schedule.email' => '发送到',
    'SummaryReport.Schedule.isEmpty' => '请输入有效的电子邮件地址。',

    'MassMailForm.name' => '模板名称',
    'MassMailForm.fromEmail' => '发自（电子邮件地址）',
    'MassMailForm.sendToAdmins' => '发送给 Plesk 管理员',
    'MassMailForm.sendToResellers' => '发送给代理商',
    'MassMailForm.sendToClients' => '发送给客户',
    'MassMailForm.subject' => '主题',
    'MassMailForm.body' => '信息文本',
    'MassMailForm.bodyDescription' => '
您可以在信息文本（但不是标头）中使用<name> 变量。这将会被客户或代理商的联系人名称代替。',
    'MassMailForm.sendToResellersMode' => '发送给',
    'MassMailForm.sendToResellersModeAll' => '所有代理商',
    'MassMailForm.sendToResellersModeSelect' => '所选代理商',
    'MassMailForm.sendToResellersModeExcept' => '除所选代理商外的全部代理商',
    'MassMailForm.sendToClientsMode' => '发送给',
    'MassMailForm.sendToClientsModeAll' => '所有客户',
    'MassMailForm.sendToClientsModeSelect' => '所选客户',
    'MassMailForm.sendToClientsModeExcept' => '除所选客户外的全部客户',

    'VirtualDirectory.DirectorySection.title' => '虚拟目录',
    'VirtualDirectory.DirectorySection.name' => '名称',
    'VirtualDirectory.DirectorySection.accessSource' => '脚本源访问',
    'VirtualDirectory.DirectorySection.accessRead' => '读取权限',
    'VirtualDirectory.DirectorySection.accessWrite' => '写入权限',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => '目录浏览',
    'VirtualDirectory.DirectorySection.log' => '日志访问',
    'VirtualDirectory.Path.path' => '路径',
    'VirtualDirectory.Path.autoPathLabel' => '创建与虚拟目录名称相同的物理目录',
    'VirtualDirectory.ApplicationSettingsSection.title' => '应用程序设置',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => '创建应用程序',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => '允许使用父路径',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => '允许应用程序在MTA(多线程单元)模式下运行',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => '执行权限',
    'VirtualDirectory.SecuritySection.title' => '目录安全性',
    'VirtualDirectory.SecuritySection.authAnonymous' => '启用匿名验证',
    'VirtualDirectory.SecuritySection.authNTLM' => '启用 Windows 验证',
    'VirtualDirectory.SecuritySection.requireSSL' => '需要 SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => '无',
    'VirtualDirectory.scriptExecuteOption.script' => '仅脚本',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => '脚本和可执行文件',
    'VirtualDirectory.AspSection.title' => 'ASP设置',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'ASP最大缓冲大小(KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'ASP请求邮件正文的最大容量 (KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => '启用 ASP 服务器端脚本调试',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => '启用 ASP 客户端脚本调试',
    'VirtualDirectory.AspSection.definedByIis' => '由IIS定义',
    'VirtualDirectory.AspSection.definedByIisWithSize' => '由IIS定义(%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => '由主目录定义',
    'VirtualDirectory.AspSection.definedByParentWithSize' => '由主目录定义(%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => '是',
    'VirtualDirectory.CheckboxField.false' => '否',
    'VirtualDirectory.DocumentsSection.title' => '文档',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => '使用默认文档',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => '默认文档搜索顺序',
    'VirtualDirectory.DefaultDocsField.remove' => '移除',
    'VirtualDirectory.NewDefaultDoc.add' => '添加',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => '单击向列表中添加文件。',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => '输入要添加到列表的文件名.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => '相同名称的物理目录已经存在。如果继续，此目录将变成不可访问。仍要继续吗？',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => '继续',

    'VirtualDirectoryMimeType.extension' => '扩展名',
    'VirtualDirectoryMimeType.content' => '内容',
    'VirtualDirectoryMimeType.custom' => '自定义',
];