<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subnät eller IP-adress',
    'access-network.subnetOrIpAddressHint' => 'Till exempel, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Nyhetsbrev',
    'admin.announcement-settings.getConsentLoading' => 'Hämtar information om nyhetsbrev...',
    'admin.announcement-settings.getConsentWarning' => 'Kunde inte hämta din prenumerationsstatus.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Jag vill få nyhetsbrev från WebPros. De kan innehålla säkerhetsrelaterad, teknisk och allmän produktinformation. Jag godkänner och auktoriserar WebPros att samla, bearbeta och använda mina personuppgifter (e-postadress), inklusive gränsöverskridande bearbetning, i enlighet med gällande lagstiftning om sekretess som för närvarande gäller för att skicka mig nyhetsbrev, antingen direkt eller via en tredjeparts tjänst. Genom att avmarkera den här kryssrutan återkallar jag mitt samtycke och beordrar WebPros för att sluta skicka mig e-postmeddelanden och permanent ta bort mina personuppgifter från sina system.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Genom WebPros-företagen som listas här får använda mitt namn och e-postadress (%%adminEmail%%) i syfte att ge mig anpassat marknadsföringsinnehåll, såsom nyhetsbrev och individuella erbjudanden kopplade till WebPros produkter. Företagen som ber om ditt samtycke är: WebPros International LLC och WebPros International GmbH. Information kommer att lyda under %%privacyPolicy%% fram tills att mitt samtycke dras tillbaka, och kan delas internt med andra entiteter i WebPros-gruppen. Jag kan modifiera eller dra tillbaka mitt samtycke när som helst genom att avbocka kryssrutan, klicka på länken i all mottagen kommunikation eller genom att skicka e-post till privacy@plesk.com',
    'admin.announcement-settings.privacyPolicy' => 'WebPros Sekretesspolicy',
    'admin.announcement-settings.noConsent' => 'Avsluta min prenumeration på WebPros nyhetsbrev.',
    'admin.announcement-settings.reportConsentError' => 'Kunde inte spara dina inställningar för att ta emot information från Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Vi kan tyvärr inte uppdatera din profil just nu. Försök igen senare.',
    'admin.announcement-settings.invalidConsentType' => "Okänd typ: '%%type%%'",
    'admin.announcement-settings.retry' => 'Försök igen',
    'admin.announcement-settings.consentGivenInfo' => 'Vi hoppas att du har gillat vårt allmänna WebPros-nyhetsbrev. Vi kan nu ge dig ett ännu bättre personligt alternativ med bra information och praktiska tips, beroende på dina behov. För att få ditt personliga WebPros-nyhetsbrev väljer du det första påståendet nedan och klickar på OK.',

    'admin.personal-info.title' => 'Redigera administratörsprofil',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk inställningar',
    'admin.personal-info.settingsSectionLegend' => 'Inställningar',

    'admin-alias.login' => 'Användarnamn',
    'admin-alias.password' => 'Lösenord',
    'admin-alias.passwordConfirmation' => 'Bekräfta lösenord',
    'admin-alias.email' => 'E-post',
    'admin-alias.contact' => 'Kontakt namn',
    'admin-alias.comments' => 'Kommentarer',
    'admin-alias.emptyLogin' => 'Ange ett användarnamn.',
    'admin-alias.loginTooLong' => 'Användarnamnets längd överstiger 20 tecken.',
    'admin-alias.emptyEmail' => 'Ange en e-postadress.',
    'admin-alias.emptyContactName' => 'Ange ett kontaktnamn.',
    'admin-alias.contactNameTooLong' => 'Kontaktens namn längd överstiger 255 tecken.',
    'admin-alias.emptyPassword' => 'Ange ett lösenord.',
    'admin-alias.commentsTooLong' => 'Kommentarens längd överstiger 255 tecken.',
    'admin-alias.emailActivation' => 'Aktivera kontot via e-post',
    'admin-alias.simplePanel' => 'Aktivera begränsat läge',
    'admin-alias.simplePanelHint' => 'Välj detta alternativ för att begränsa antalet åtgärder som den extra administratören kan vidta i Plesk. För att ändra åtgärderna som är tillgängliga, gå till %%link%%.',
    'admin-alias.simplePanelLink' => 'Verktyg & inställningar> Inställningar för begränsat läge',
    'admin-alias.lockPowerUser' => 'Force Power User-vy för ytterligare administratör',
    'admin-alias.lockPowerUserHint' => 'Förmåga att begränsa visningen till extra Plesk-administratör (ingen tillgång för kunder, återförsäljare och serviceplaner).',

    'admin-info.plesk-settings.multiplyLogin' => 'Tillåt flera sessioner med detta konto',
    'admin-info.plesk-settings.adminLanguage' => 'Administratörens gränssnittsspråk',
    'admin-info.plesk-settings.password' => 'Lösenord',
    'admin-info.plesk-settings.passwordConfirmation' => 'Bekräfta lösenord',
    'admin-info.plesk-settings.oldPassword' => 'Gammalt lösenord',

    'admin-panel.form.contact-info.login' => 'Inloggning',
    'admin-panel.form.contact-info.contactName' => 'Kontakt namn',
    'admin-panel.form.contact-info.emptyLogin' => 'Vänligen ange användarnamn.',
    'admin-panel.form.contact-info.emptyContactName' => 'Ange ett kontaktnamn.',
    'admin-panel.form.contact-info.loginTooLong' => 'För långt användarnamn (max %max% tecken tillåts).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Kontaktnamnet är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.email' => 'E-postadress',
    'admin-panel.form.contact-info.emptyEmail' => 'Ange en e-postadress.',
    'admin-panel.form.contact-info.companyName' => 'Företagsnamn',
    'admin-panel.form.contact-info.longCompanyName' => 'Detta företagsnamn är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.phone' => 'Telefonnummer',
    'admin-panel.form.contact-info.longPhone' => 'Detta telefonnummer är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.fax' => 'Faxnummer',
    'admin-panel.form.contact-info.imNumber' => 'Snabbmeddelande',
    'admin-panel.form.contact-info.longFax' => 'Detta faxnummer är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Det angivna telefonnumret är ogiltigt.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Detta faxnummer är felaktigt.',
    'admin-panel.form.contact-info.address' => 'Adress',
    'admin-panel.form.contact-info.longAddress' => 'Denna adress är för lång (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.city' => 'Stad',
    'admin-panel.form.contact-info.longCity' => 'Stadens namn är för långt.',
    'admin-panel.form.contact-info.shortCity' => 'Stadens namn är för kort.',
    'admin-panel.form.contact-info.state' => 'Län',
    'admin-panel.form.contact-info.postalCode' => 'Postnummer',
    'admin-panel.form.contact-info.country' => 'Land',
    'admin-panel.form.contact-info.additionalInfo' => 'Ytterligare information',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Endast oformaterad text: Alla HTML-taggar kommer att ignoreras.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Användare med en sådan e-postadress finns redan i systemet.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonnemang',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Skapa abonnemang för kunden',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Avmarkera denna kryssruta om du inte vill skapa ett värdtjänsttjänstabonnemang eller ställa in en webbplats för kunden just nu. Utan ett abonnemang, kommer kunden inte att kunna logga in till Kundpanelen.',
    'admin-panel.form.domain-info-section.domainName' => 'Domännamn',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Du  måste ange ett domännamn.',
    'admin-panel.form.domain-info-section.shared' => 'delad',
    'admin-panel.form.domain-info-section.exclusive' => 'dedikerad',
    'admin-panel.form.domain-info-section.userName' => 'Användarnamn',
    'admin-panel.form.domain-info-section.userNameHint' => 'Systemets användarkonto används för att hantera filer och mappar på webbplatserna som skapas inom abonnemanget.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Du måste ange ett användarnamn.',
    'admin-panel.form.domain-info-section.password' => 'Lösenord',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Du måste ange ett lösenord.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Bekräfta lösenord',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4-adress',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6-adress',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Ingen',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Ytterligare prenumerationsinställningar',
    'admin-panel.form.domain-info-section.credentials' => 'Uppgifter för systemanvändare',
    'admin-panel.form.domain-info-section.credentialsHint' => 'för åtkomst till hostade filer över FTP och SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'för åtkomst till hostade filer över FTP och RDP',

    'admin-panel.form.login-info.userName' => 'Användarnamn',
    'admin-panel.form.login-info.emptyUserName' => 'Ange ett användarnamn.',
    'admin-panel.form.login-info.oldPassword' => 'Gammalt lösenord',
    'admin-panel.form.login-info.password' => 'Lösenord',
    'admin-panel.form.login-info.emptyPassword' => 'Ange ett lösenord.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Upprepa lösenordet',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Att byta lösenord byter även lösenordet för den interna e-postadressen',
    'admin-panel.form.login-info.emailActivation' => 'Aktivera kontot via e-post',
    'admin-panel.form.login-info.emailActivationHint' => 'Ett skapat konto är inaktivt tills användaren aktiverar den med länken skickad via e-post eller administratören aktiverar kontot manuellt.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonnemang',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Tjänsteplan',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Aktuell serviceplan',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Ny serviceplan',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Enkel plan',
    'admin-panel.form.subscription-info-section.none' => 'Ingen',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Tillägg',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Sätt igång med anpassning av parametrarna för abonnemanget efter att planets associering har ändrats. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Anpassa parametrarna för prenumerationen efter att den skapats.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Anpassa prenumerationsparametrarna efter att kunden har skapats.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Fortsätt med att anpassa abonnemangsparametrarna efter skapandet. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Observera att det kommer låsa prenumerationen för synkning.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Lägg till Abonnemang',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'app.configure.otherSettings' => 'Övrigt',
    'app.configure.passwordConfirmation' => 'Bekräfta lösenord',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Framtvinga uppdateringar för alla installerade appar',
    'app.update-settings.forceUpdatesHint' => 'Alla kunders appar uppdateras automatiskt så snart uppdateringarna är tillgängliga. Kunderna kommer inte att kunna stänga av autoamtiska uppdateringar för sina appar. Varning: Använd detta alternativ försiktigt eftersom uppdateringar märkbart kan påverka app-funktionaliteten. Exempelvis kan app-tillägg sluta fungera med en annan version av appen.',
    'app.update-settings.suggestUpdates' => 'Aktivera alternativet "Uppdatera automatiskt denna app" som standard',
    'app.update-settings.suggestUpdatesHint' => 'För nyligen installerade appar, kommer alternativet "Uppdatera automatiskt denna app" i appens inställningar att slås på.',

    'backup.server-settings.rotation' => 'Maxantal fullständiga säkerhetskopierignsfiler för att lagra (inklusive schemalagda och manuella säkerhetskopior)',
    'backup.server-settings.rotationDescription' => 'Användare kan lagra många fullständiga säkerhetskopior o serverlagringsutrymmet. Om antalet fullständiga säkerhetskopior i lagret redan överstiger gränsvärdet, kommer endast de sista säkerhetskopiorna att behållas. Inkrementella säkerhetskopior påverkas inte.',
    'backup.server-settings.maxProcesses' => 'Maximalt antal samtidigt körande schemalagda säkerhetskopieringsprocesser',
    'backup.server-settings.niceScheduled' => 'Kör schemalagda säkerhetskopieringsprocesser med låg prioritet',
    'backup.server-settings.niceScheduledPriority' => 'Prioritet',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Ange ett värde mellan 1 och 19 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceScheduledIoPriority' => 'IO prioritet',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Ange ett värde mellan 0 och 7 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceAlways' => 'Kör alla säkerhetskopieringsprocesser med låg prioritet',
    'backup.server-settings.niceAlwaysPriority' => 'Prioritet',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Ange ett värde mellan 1 och 19 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO prioritet',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Ange ett värde mellan 0 och 7 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.compressionLevel' => 'Komprimeringsnivå',
    'backup.server-settings.compressionLevelNoCompression' => 'Ingen komprimering',
    'backup.server-settings.compressionLevelFastest' => 'Snabbaste',
    'backup.server-settings.compressionLevelFast' => 'Snabbt',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Maximal',
    'backup.server-settings.freeSpaceRequired' => 'Starta säkerhetskopieringen endast om servern har den angivna mängden ledigt diskutrymme (i MB)',
    'backup.server-settings.checkBackupDiskSpace' => 'Starta säkerhetskopieringen endast om servern har den angivna mängden ledigt diskutrymme',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Använd den integrerade MS SQL säkerhetskopieringsfunktionen (För fjärrstyrda databaser, se till att du har konfigurerat säkerhetskopieringsinställningarna för den fjärrstyrda MS SQL-servern i Verktyg och inställningar> Databasservrar)',
    'backup.server-settings.localFtpRestriction' => 'Tillåt inställningen av FTP-säkerhetskopiering i den lokala servern',
    'backup.server-settings.backupSecuritySettings' => 'Säkerhetsinställningar för säkerhetskopieringar',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Spara säkerhetskopior i serverlagringen om uppladdningen till fjärrlagringssystemet misslyckas',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Manuell och schemalagd säkerhetskopiering som avses för fjärrlagringen sparas i den lokala serverlagringen om uppladdningen till fjärrlagringen misslyckas. Användare måste ha tillstånd till att lagra säkerhetskopior i serverlagringen.',
    'backup.server-settings.AllowScheduleHourly' => 'Tillåt kunder och återförsäljare att schemalägga timvis säkerhetskopiering',

    'change-current-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för abonnemanget. Observera att om du väljer \'ingen\' som ny tjänsteplan, löses abonnemanget från tjänsteplanen och den blir då \'Anpassad\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'change-password.oldPassword' => 'Gammalt lösenord',
    'change-password.password' => 'Nytt lösenord',
    'change-password.passwordConfirmation' => 'Bekräfta lösenord',
    'change-password.oldPasswordIsIncorrect' => 'Det gamla lösenordet är felaktigt. Försök igen.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Kan inte hitta det extra administratörskontot.',
    'change-password.warningAboutAdminPasswordSyntax' => "Lösenordet ska vara %%min%% - %%max%% tecken långt och ska inte innehålla användarnamnet.\nAnvänd inte citationstecken, mellanslag och nationella alfabetstecken i lösenordet.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Använd inte citationstecken, mellanslag, semikolon och nationella alfabetstecken i lösenordet.\nLösenordet ska vara mellan %%min%% och %%max%% tecken långt, och det ska inte innehålla användarnamnet.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Överförsäljningspolicy',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med en plan. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med en plan, oavsett hur mycket dessa resurser för närvarande används.',

    'change-reseller-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för återförsäljarens abonnemang. Observera att om du väljer \'ingen\' som ny tjänsteplan, löses abonnemanget från tjänsteplanerna och den blir då \'Anpassad\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Ny plan',
    'change-reseller-subscription.oldSubscription' => 'Aktuell plan',
    'change-reseller-subscription.none' => 'ingen',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Abonnemangets association med tjänsteplanen har uppdaterats.',
    'change-reseller-subscription.customizeSubscription' => 'Fortsätt med anpassningen av abonnemangsparametrarna efter associeringen med tjänsteplanen har uppdaterats. Observera att när du gör det, låser sig abonnemanget för synkronisering.',

    'change-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för valda abonnemang.',
    'change-subscription.selectPlanLegend' => 'Tjänsteplan',
    'change-subscription.selectPlanDescription' => 'För att ändra till en annan tjänsteplan, välj den nya planen ur listan. Observera att om du väljer \'ingen\', löses abonnemanget från tjänsteplanen och den blir då \'Anpassad\'.',
    'change-subscription.servicePlan' => 'Ny serviceplan',
    'change-subscription.selectAddonPlansLegend' => 'Tilläggsplaner',
    'change-subscription.selectAddonPlansDescription' => 'Lägg till eller ta bort tilläggsplaner.',
    'change-subscription.noChange' => 'ingen ändring',
    'change-subscription.none' => 'ingen',
    'change-subscription.add' => 'lägg till',
    'change-subscription.del' => 'ta bort',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subnät eller IP-adress',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Till exempel, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Åtkomst till Plesk med administratörsprivilegier',
    'control-panel-access.settings.policyAllow' => 'Tillåtet, förutom för nätverken i listan.',
    'control-panel-access.settings.policyDeny' => 'Nekas från nätverken som inte är listade.',

    'create-subscription.title' => 'Lägga till ett Abonnemang',
    'create-subscription.titleOwn' => 'Lägga till ditt eget abonnemang',
    'create-subscription.poolIsEmpty' => 'Kan inte skapa en prenumeration eftersom det inte finns några delade IP-adresser och inga lediga dedikerade IP-adresser i Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'Abonnemanget %%name%% har skapats.',
    'create-subscription.createBeforeAppInstall' => 'Du behöver en prenumeration för att installera appen.',

    'customer.hint' => 'Det är här du tillför en ny kund till dina värdtjänsttjänster. Med denna inskrivning skapar du ett kundkonto i Plesk och ett abonnemang på en av dina värdtjänstplaner och alternativt tillägg. Abonnemanget kan också tillhandahålla en fullständig anpassad uppsättning resurser och tjänster som int eär bundna till några planer -- för detta väljer du \'Ingen\' bredvid tjänsteplanen.',
    'customer.contactInfoSection' => 'Kontaktinformation',
    'customer.additionalInfoSection' => 'Ytterligare kundinformation',
    'customer.accessToPanelSection' => 'Åtkomst till Plesk-tjänster',
    'customer.contactInfoSectionHint' => 'Ange kundens kontaktinformation.',
    'customer.accessToPanelSectionHint' => 'Autentiseringsuppgifter som kunden använder för åtkomst till Kundpanelen.',
    'customer.unableCreateSubscription' => 'Abonnemanget kan inte skapas: %%reason%%',
    'customer.poolIsEmpty' => 'IP-poolen är tom',
    'customer.buttonOk' => 'Lägg till kund',

    'database-settings.dbPrefixRadio' => 'Lägg till ett prefix och understreck i början av databasnamn',
    'database-settings.dbPrefixNone' => 'Ingen',
    'database-settings.dbPrefixUsername' => 'Användarnamn',
    'database-settings.dbPrefixExternalId' => 'Externt ID för ett abonnemang',
    'database-settings.dbPrefixCustom' => 'Eget prefix',
    'database-settings.dbUserPrefixRadio' => 'Lägg till ett prefix och understreck i början av användarnamn i databas',
    'database-settings.dbUserPrefixHint' => 'Databasanvändarnamn kommer att se ut som <prefix>_<database_user_name>. Till följd av databasbegränsningen för längd på användarnamn kan <prefix> förkortas.',
    'database-settings.grantAlterDatabase' => 'Bevilja ALTER DATABASE behörighet till alla Microsoft SQL Server databasanvändare',
    'database-settings.grantAlterDatabaseHint' => 'Nya och befintliga användare kommer att beviljas denna behörighet.',
    'database-settings.aclRadio' => 'Standardinställningar för fjärråtkomst för MariaDB/MySQL-databasanvändare',
    'database-settings.aclLocalhost' => 'Tillåt endast lokala anslutningar',
    'database-settings.aclAny' => 'Tillåt fjärranslutningar från valfri värd',
    'database-settings.aclCustom' => 'Tillåt fjärranslutningar från',
    'database-settings.aclDescription' => 'Denna inställning modifierar bara användarens behörigheter. För att aktivera fjärråtkomst till lokal MariaDB/MySQL-server, välj motsvarande alternativen i %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Inställningar för lokal MariaDB/MySQL',
    'database-settings.example' => "Till exempel:",
    'database-settings.aclExampleDescription' => "De angivna värdarna ges åtkomst till databasen å denna användares vägnar.",
    'database-settings.dbPrefixAlphaNumeric' => 'Prefixvärdet får bara innehålls alfanumeriska värden och understreck.',

    'dns.add-acl-record.description' => 'Lägg till en IP-adress för en DNS-server som kan ta emot en kopia av DNS-zonen.',
    'dns.add-acl-record.ipAddress' => 'IP-adress',
    'dns.add-acl-record.ipAddressWithMask' => 'IP-adress/mask',

    'dns.settings.recursion' => 'DNS-rekursionsanrop',
    'dns.settings.recursionOn' => 'Tillåt för alla förfrågningar',
    'dns.settings.recursionLocal' => 'Tillåt endast för lokala förfrågningar',
    'dns.settings.recursionLocalnets' => 'Tillåt endast förfrågningar från lokala nätverk',
    'dns.settings.recursionOff' => 'Neka för alla förfrågningar',
    'dns.settings.customConfiguration' => 'Ytterligare DNS-inställningar',
    'dns.settings.customConfigurationPlaceholder' => 'Inställningarna du angav här kommer att åsidosätta de som är serveromfattande.',
    'dns.settings.customConfigurationHint' => 'Om du inte hittar specifika inställningar, lägg till dem i fältet ovan med syntax named.conf.',
    'dns.settings.customConfigurationExample' => 'Lägg till exempel till följande rad för att dölja DNS-serverns host-namn: ',
    'dns.settings.restoreDefaultButton' => 'Använd standardinställningar',

    'dns.template.synchronize-done' => 'DNS-zonmallen har tillämpats korrekt.',
    'dns.template.synchronize-error' => 'DNS-zonmallen har inte tillämpats för vissa DNS-zoner.',
    'dns.template.synchronize-progress' => 'Tillämpa DNS-zonmallen.',

    'domain-restriction.name' => 'Domännamn',
    'domain-restriction.nameDescription' => 'Du kan ange ett mönster med jokertecken genom att använda asterisk tecknet (*). Exempelvis, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Det angivna domännamnet finns redan i listan.',

    'event-handler.eventLabel' => 'Händelse',
    'event-handler.priorityLabel' => 'Prioritet',
    'event-handler.userLabel' => 'Användare',
    'event-handler.commandLabel' => 'Kommando',
    'event-handler.commandHint' => 'För bäst resultat, ange en fullständig sökväg till en skriptfil i fältet \\’command\\’. Vi rekommenderar att du inte går in i systemkommandona eftersom de kanske inte fungerar. Exempelvis kommer kommandon med operatörer för utgångsomdirigering /&gt; eller &gt; inte att fungera.',
    'event-handler.priorityHighestText' => 'högst',
    'event-handler.priorityHighText' => 'hög',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'låg',
    'event-handler.priorityLowestText' => 'lägsta',
    'event-handler.priorityCustomText' => 'anpassad',
    'event-handler.priorityHighestOption' => 'högst (%%value%%)',
    'event-handler.priorityHighOption' => 'hög (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'låg (%%value%%)',
    'event-handler.priorityLowestOption' => 'lägst (%%value%%)',

    'extension.upload.fileUpload' => 'Sökväg till tilläggspaketfilen',

    'external-webmail.hint' => 'När du har registrerat en extra webbmail i Plesk, blir den tillgänglig för dina kunder: den visas som ett alternativ i \'Mail\'-egenskaperna i värdtjänstplanerna och abonnnemangen. Webbmailnamnet kommer att visas i listan över webbmailalternativ, och URL:en kommer att öppnas vid klick på webbmailikonen intill e-postkontot i Kundpanelen.',
    'external-webmail.name' => 'Webbmailens tjänstnamn',
    'external-webmail.url' => 'Webbmailens tjänste-URL',
    'external-webmail.enabled' => 'Tillgänglig',

    'ftp-settings.generalSection' => 'Allmänt',
    'ftp-settings.portRange' => 'Port eller portintervall för anslutningar i passivt FTP-läge',
    'ftp-settings.hintPortRange' => '(standardvärde: %%defaultPortRange%%)',

    'health.upload.hint' => 'Ladda upp din konfiguration av serverns hälsoövervakare. Konfigurationen tillämpas så snart den laddas upp.',
    'health.upload.selectFile' => 'Konfigurationsfil',

    'install-local-package.selectUploadType' => 'Välj något av följande:',
    'install-local-package.uploadAsFile' => 'Ladda upp ett APS-paket',
    'install-local-package.downloadFromCatalog' => 'Markera en app ur Programkatalogen',
    'install-local-package.formInfo' => "Öppna listan över tillgängliga program genom att ladda upp en ny app eller lägg till en app från Programkatalogen för ytterligare konfiguration.",
    'install-local-package.invalidFileExtension' => 'Den uppladdade appen måste vara ett ZIP-arkiv med .zip-tillägget.',
    'install-local-package.packagesNotSelected' => 'Inget av paketen är valt.',
    'install-local-package.fileNotUploaded' => 'Fil kan inte laddas upp.',
    'install-local-package.visible' => 'Gör den tillgänglig för kunderna',
    'install-local-package.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',
    'install-local-package.visibleDescription' => 'Gör appen tillgänglig för installation av kunderna.',

    'ip-address.addTitle' => 'Lägg till IP-adress',
    'ip-address.editTitle' => 'IP-adress %%address%% på gränssnittet %%interface%%',
    'ip-address.generalSection' => 'Allmänt',
    'ip-address.interface' => 'Gränssnitt',
    'ip-address.addressAndSubnetPrefixLength' => 'IP-adress och nätmask',
    'ip-address.addressHintIPv4' => 'Till exempel 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Till exempel 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Offentlig IP-adress',
    'ip-address.hintPublicIp' => 'Du kan använda en offentlig IP-adress om din Plesk-server är bakom NAT',
    'ip-address.distributionType' => 'IP-adressen distribueras som',
    'ip-address.distributionTypeShared' => 'Delad',
    'ip-address.distributionTypeExclusive' => 'Dedikerad',
    'ip-address.certificate' => 'SSL/TLS-certifikat',
    'ip-address.defaultSite' => 'Standardplats',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Den installerade FTP-servern stödjer inte FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Den installerade FTP-servern stödjer inte IPv6-adresser.',
    'ip-address.interfaceDHCPEnabled' => 'Kunde inte reparera IP-adressen. Detta nätverksgränssnitt får IP-adresser automatiskt.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Obs: Anpassad Plesk-URL är aktiverad för alla okända domäner; Plesk-gränssnittet kommer att visas istället för standardgränssnittet på "https://%%ip%%/"',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Nätverksadapter %%interface%% finns inte. Flytta denna IP-adress till en annan nätverksadapter eller ta bort den från listan.',
    'ip-address.none' => 'ingen',

    'ip-ban.filter.name' => 'Namn',
    'ip-ban.filter.content' => 'Innehåll',
    'ip-ban.filter.filterExistsError' => 'Ett filter med ett sådant namn finns redan.',

    'ip-ban.jail.name' => 'Namn',
    'ip-ban.jail.filter' => 'Filter',
    'ip-ban.jail.filterDescription' => 'Välj filter.',
    'ip-ban.jail.action' => 'Action',
    'ip-ban.jail.actionDescription' => 'Välj en åtgärd och klicka på knappen för att addera den.',
    'ip-ban.jail.logPath' => 'Loggsökväg',
    'ip-ban.jail.banTime' => 'Bannlysningsperiod för IP-adress',
    'ip-ban.jail.maxRetry' => 'Det maximala antalet misslyckade inloggningsförsök',
    'ip-ban.jail.timeUnit' => 'sekunder',
    'ip-ban.jail.addAction' => 'Lägg till',
    'ip-ban.jail.chooseAction' => 'Välj:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache-auktoriseringsfel (när du loggar in i filen)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache-auktoriseringsfel (eventuell loggning)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache-auktoriseringsfel (när du loggar in i syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Skräppost sökrobotar och dårliga webbcrawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP och POP3 autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3, och Sieve autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3 och Sieve-autentiseringsfel (aggressivt läge)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde webbpost autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Webbsäkerhets- och åtkomstkontrollbrott (Web Security)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube webbpost autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress autentiseringsfel',
    'ip-ban.jail.plesk-manual-filter-description' => 'Attrappfilter för manuell bannlysning',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP-klientfel (inklusive RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP-klientfel, autentiseringsfel och DDoS-attacker',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP och SASL autentiseringsmisslyckanden',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS-attacker',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP-klientfel och autentiseringsfel',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP-klientfel (inklusive RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP-klientfel (endast RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD inloggningsmisslyckanden',
    'ip-ban.jail.recidive-filter-description' => 'Värdar bannlysta upprepade gånger av Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'SSH inloggningsmisslyckanden',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH-inloggningsfel, förhandlingsfel och DDoS-attacker',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH-inloggningsfel och DDoS-attacker',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH-inloggnings- och förhandlingsfel',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Bannlysning via firewalld brandvägg, på alla porter',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Bannlysning via firewalld brandvägg, på flera porter',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Bannlysning via firewalld brandvägg, på en enkel port',
    'ip-ban.jail.iptables-action-description' => 'Bannlysning via iptables brandvägg, på en enkel port',
    'ip-ban.jail.iptables-allports-action-description' => 'Bannlysning via iptables brandvägg, på alla porter',
    'ip-ban.jail.iptables-multiport-action-description' => 'Bannlysning via iptables brandvägg, på flera porter',
    'ip-ban.jail.sendmail-action-description' => 'Skicka en e-postnotis med Sendmail',
    'ip-ban.jail.jailExistsError' => 'Ett fängelse med ett sådant namn finns redan.',
    'ip-ban.jail.invalidInteger' => 'Den angivna värdet är ogiltigt. Specificera ett heltal.',

    'ip-ban.settings.pageHint' => 'Här kan du ställa in bannlysning av IP-adress för att skydda servern din och dina värdbaserade webbplatser från skadlig trafik.',
    'ip-ban.settings.detectionEnabled' => 'Aktivera identifiering av intrång',
    'ip-ban.settings.banPeriod' => 'Bannlysningsperiod för IP-adress',
    'ip-ban.settings.banTimeWindow' => 'Tidsintervall för detektering av upprepade angrepp',
    'ip-ban.settings.maxRetries' => 'Antal misslyckanden för bannlysning av IP-adress',
    'ip-ban.settings.timeUnit' => 'sekunder',
    'ip-ban.settings.invalidInteger' => 'Ett ogiltigt värde har tillhandahållits. Tillhandahåll ett positivt heltal.',

    'ip-ban.trusted-ip.ipAddress' => 'IP-adress',
    'ip-ban.trusted-ip.hintIpAddress' => 'En IP-adress, en CIDR_mask eller ett DNS-värdnamn.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Beskrivning',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Förklaring till varför IP-adressen lades till i listan över betrodda.',

    'login-info.hint' => 'Det är här du ändrar användarnamnet och lösenordet som kunden använder för tillgång till Kundanelen.',
    'login-info.resellerHint' => 'Det är här du ändrar användarnamnet och/eller lösenordet som återförsäljaren använder för tillgång till deras Plesk.',
    'login-info.myProfileHint' => 'Det är här du ändrar lösenordet du använder för åtkomst till din Plesk.',

    'firewall-rule.titleEdit' => 'Redigera brandväggsregeln',
    'firewall-rule.titleNew' => 'Lägger till en regel',
    'firewall-rule.isEnabled' => 'Aktivera regeln',
    'firewall-rule.name' => 'Regelnamn',
    'firewall-rule.profiles' => 'Profiler',
    'firewall-rule.profilesHint' => 'Du måste välja minst en profil.',
    'firewall-rule.profileDomain' => 'Domän',
    'firewall-rule.profilePrivate' => 'Privat',
    'firewall-rule.profilePublic' => 'Publik',
    'firewall-rule.action' => 'Action',
    'firewall-rule.actionAllow' => 'Tillåt',
    'firewall-rule.actionBlock' => 'Förneka',
    'firewall-rule.port' => 'Tillåt anslutningar till följande port eller portintervall',
    'firewall-rule.portHint' => 'Till exempel: 1000 eller 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP-protokoll',
    'firewall-rule.protocolUdp' => 'UDP-protokoll',
    'firewall-rule.remoteAddresses' => 'Fjärradresser',
    'firewall-rule.remoteAddressesHint' => 'Till exempel: 192.168.0.1 eller 192.168.0.0/16',
    'firewall-rule.newRule' => 'Ny regel',
    'firewall-rule.successNew' => 'Brandväggsregeln lades till.',
    'firewall-rule.successEdit' => 'Brandväggsregeln uppdaterades.',

    'mail.lists-server-settings.email' => "E-postlistans administratörspost",
    'mail.lists-server-settings.emptyEmail' => 'Ange en e-postadress.',
    'mail.lists-server-settings.newPassword' => 'Nytt lösenord',
    'mail.lists-server-settings.emptyPassword' => 'Ange ett lösenord.',
    'mail.lists-server-settings.passwordConfirmation' => 'Bekräfta lösenord',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Programvarans e-postlista har konfigurerats.',

    'mail.outgoing-messages.hint' => 'Här kan du specificera en gräns för utgående meddelanden från en postlåda.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Maximalt antal utgående e-postmeddelanden',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% meddelanden per timme)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Anpassat värde för denna postlåda',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'meddelanden per timme',

    'mail-gate-settings.host' => 'Värddatornamn eller IP-adress',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Användarnamn',
    'mail-gate-settings.password' => 'Lösenord',
    'mail-gate-settings.encryption' => 'SMTP-servern kräver krypterad anslutning',
    'mail-gate-settings.allowUsers' => 'Tillåt användarskript skicka e-post via denna SMTP-server (genom att använda det angivna användarnamnet och lösenordet)',
    'mail-gate-settings.useDefaultSettings' => 'Använd e-post servern installerad med Plesk och standard e-postkontot skapad av Plesk',

    'mail-gate.hint' => 'Här kan du specificera SMTP-servern som ska användas när Plesks e-postserver inte har instalelrats eller är blockerad för att skicka utgående e-post. Denna server används som ett SMTP-relä av Plesk och användarskript för att skicka utgående e-post som e-postmeddelanden.',
    'mail-gate.enableMailGate' => 'Låt Plesk skicka e-postmeddelanden via denna SMTP-server',
    'mail-gate.notifications' => 'E-postmeddelanden från en extern SMTP-server',
    'mail-gate.smtpSettings' => 'Externa SMTP-serverinställningar',

    'optimization-settings.apacheModulesSection' => 'Apache-moduler',
    'optimization-settings.nginxSettingsSection' => 'Nginx-inställningar',
    'optimization-settings.nginxHttp3Enabled' => 'HTTP/3-stöd',
    'optimization-settings.nginxHttp3EnabledHint' => 'Att aktivera HTTP/3-stöd på hela servern för alla webbplatser den är värd för förbättrar webbplatsprestanda på moderna nätverk. Men du kan inaktivera HTTP/3-stöd i intställningar för ett individuellt abonnemang om det krävs. Tiden för att aktivera eller inaktivera HTTP/3-stöd beror på antalet påverkade domäner och kan ta flera minuter.',
    'optimization-settings.apacheSettingsSection' => 'Apache-inställningar',
    'optimization-settings.additionalPageHint' => 'Växla mellan moduler endast om du fullständigt begriper konsekvenserna av dina åtgärder. Notera att vissa modifieringar kan sänka Apaches prestanda eller t.o.m. leda till att det slutar fungera.',
    'optimization-settings.pageHint' => 'Här kan du optimera Plesk genom att stänga av oanvända Apache-moduler. Denna optimering förbättrar användningen av minnet och gör så att du kan betjäna mer värdtjänst-kunder. Notera att vissa moduler är beroende av varandra och kan slås av (på) enbart när modulerna de är beroende av är av (på).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Denna funktion är endast för avancerade användare.',
    'optimization-settings.apacheRestartInterval' => 'Apache omstartintervall (sekunder)',
    'optimization-settings.apacheRestartIntervalHint' => 'Väl i det angivna intervallet, söker Plesk efter ändringar gjorda på domäner och subdomäner. Om det finns förändringar som kräver att webbservern återstartas, startar Plesk om Apache.',
    'optimization-settings.gracefulRestart' => 'Apache graciös omstart',
    'optimization-settings.gracefulRestartHint' => 'Välj för att undvika driftstopp för alla webbplatser som finns på servern, varje gång du ändrar värdinställningarna.',
    'optimization-settings.pipedLog' => 'Pipade loggar',
    'optimization-settings.mpmMode' => 'MPM-läge',
    'optimization-settings.moduleDeprecated' => '(Avrådd)',

    'personal-info.contactInfoSection' => 'Kontaktinformation',
    'personal-info.hint' => 'Här redigerar du användarens kontaktinformation.',
    'personal-info.hintMyProfile' => 'Här redigerar du din kontaktinformation.',

    'php-handler.extension.title' => 'Installera PECL-paket',
    'php-handler.extension.description' => "Du kan installera en betaversion av ett tillägg genom att ange ytterligare parametrar med paketnamnet, som \"msgpack-beta\".",
    'php-handler.extension.name' => 'Paketnamn',

    'php-handler.ini.formHint' => 'Denna php.ini-fil används endast av denna hanterare.',
    'php-handler.ini.formHintSharedIni' => 'Denna php.ini-fil används också av följande PHP-hanterare: %%handlers%%. Inställningarna gäller alla webbplatser som använder dessa hanterare.',
    'php-handler.ini.incorrectTextForIniFile' => "De specificerade inställningarna är felaktiga och kan inte sparas i php.ini-filen. Fel: %%message%%.",

    'plan-item-custom.planItemName' => 'Tjänstnamn',
    'plan-item-custom.buttonLabel' => 'Detta namn används även som etikett för den anpassade knappen.',
    'plan-item-custom.planItemDescription' => 'Tjänstbeskrivning',
    'plan-item-custom.buttonTooltip' => 'Denna text används även som verktygstips för den anpassade knappen',
    'plan-item-custom.url' => 'URl som är bifogad den anpassade knappen',
    'plan-item-custom.backgroundImage' => 'Bakgrundsbild för den anpassade knappen',
    'plan-item-custom.emptyItemName' => 'Ange en etikett för tjänsten.',
    'plan-item-custom.emptyItemDescription' => 'Ange en text för verktygstipstjänsten.',
    'plan-item-custom.emptyUrl' => 'Specificera en URL.',
    'plan-item-custom.longItemName' => 'Denna tjänsteetikett är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.longItemDescription' => 'Denna tjänstetext är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.longUrl' => 'Denna URL är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.useCustomButton' => 'Använd den anpassade knappen för tjänsten',
    'plan-item-custom.useCustomButtonHint' => 'Placera en anpassad knapp på användarens startsida och webbplatsens sidor.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Öppna URL:en i Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Ange huruvida URL:en ska öppnas på en Plesk-sida eller i ett nytt webbläsarfönster.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Använd inte ramar',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Om du lägger till en anpassad knapp som leder till ett Plesk-tillägg eller en app på Kundpanelen, kan du specificera hur denna ändelse/app ska visas: i en ram eller som en del av Plesk GUI.',
    'plan-item-custom.includeDomId' => 'Inkludera abonnemang-ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Inkludera huvuddomännamnet',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Inkludera FTP-användarnamn',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Inkludera FTP-lösenord',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Inkludera kund-ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Inkludera kundens företagsnamn",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Inkludera kundens kontaktnamn",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Inkludera kundens e-post",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',
    'plan-item-custom.fileNotUploaded' => 'Fil kan inte laddas upp.',

    'preview-domain-settings.previewType' => 'Markera hur du ska förhandsvisa webbplatser',
    'preview-domain-settings.previewQuick' => 'Standard snabbförhandsgranskning',
    'preview-domain-settings.previewDisabled' => 'Inaktivera snabbdemonstrationen',
    'preview-domain-settings.previewQuickDescription' => 'Ett rekommenderat alternativ som fungerar i alla sammanhang.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Snabbdemonstration på ett domännamn i Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Välj en av dina Plesk-webbplatser som ska användas för förhandsgranskningen.',
    'preview-domain-settings.previewZoneDomainCreate' => 'För att använda denna funktion, %%link%% åtminstone en domän.',
    'preview-domain-settings.subscriptionCreateLink' => 'skapa',
    'preview-domain-settings.previewZoneTypeExternal' => 'Snabbdemonstration på ett externt domännamn',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Använd ett externt domännamn (DNS-zon). Om du använder detta alternativ, lägg till följande DNS-post (typ A) till den externa domänzonen: *.<Plesk_IP>.external.dom. Här <Plesk_IP>är Plesk-serverns IP där punkterna (.) för IPv4 eller kolon (:) för IPv6 ersätts av bindestreck (-). Till exempel, *.192-0-2-12.external.dom. Om Plesk har mer än ett registrerat IP, lägg till en post för varje adress.',
    'preview-domain-settings.sitePreviewProtection' => 'Kräv autentisering',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Kräv FTP-inloggning och lösenord för att få tillgång till förhandsgranskningen.',
    'preview-domain-settings.nginxNotInstalled' => 'Standard snabbförhandsgranskningen är inte tillgänglig eftersom nginx-webbservern inte är installerad.',
    'preview-domain-settings.nginxDisabled' => 'Standard snabbförhandsgranskningen är inte tillgänglig eftersom nginx-webbservern är inaktiverad.',

    'reseller-preferences.settingsSection' => 'Inställningar',
    'reseller-preferences.multiLogin' => 'Tillåt multipla sessioner',
    'reseller-preferences.language' => 'Gränssnittsspråk',
    'reseller-preferences.interfaceView' => 'Markera ditt gränssnitt',
    'reseller-preferences.serviceProviderView' => 'Internetleverantörens vy',
    'reseller-preferences.serviceProviderViewHint' => 'Denna vy är ämnad för serveradministratörer som tillhandahåller och säljer webbhotelltjänster till kunder med tjänsteplaner.',
    'reseller-preferences.powerUserView' => 'Power User-vyn',
    'reseller-preferences.powerUserViewHint' => 'Denna vy lämpar sig bäst för att hantera webbplatser, deras filer, databaser, e-postkonton, webbapplikationer och andra tjänster.',

    'reseller.hint' => 'Det är här du tillför en ny återförsäljare till dina värdtjänsttjänster.',
    'reseller.contactInfoSection' => 'Kontaktinformation',
    'reseller.contactInfoSectionHint' => 'Ange återförsäljarens kontaktinformation.',
    'reseller.accessToPanelSection' => 'Åtkomst till Plesk-tjänster',
    'reseller.accessToPanelSectionHint' => 'Autentiseringsuppgifter som återförsäljaren använder för Plesk åtkomst till tjänstehanteringen som han är registrerad för.',
    'reseller.subscription' => 'Abonnemang',
    'reseller.subscriptionSectionHint' => 'Markera en tjänsteplan som återförsäljaren ska abonnera på.',
    'reseller.servicePlan' => 'Tjänsteplan',
    'reseller.none' => 'ingen',
    'reseller.customizeSubscription' => 'Fortsätt med att anpassa abonnemangsparametrarna efter att ha skapat återförsäljaren. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'reseller.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'security-policy.encryptionSection' => 'Förbättrat säkerhetsläge',
    'security-policy.encryptionSectionHint' => 'Det förbättrade säkerhetsläget presenterar avancerat skydd av känsliga data i Plesk. I detta läge använder Plesk flera säkerhetsmekanismer som är absolut transparenta för Plesk-användare. För att förbättra säkerheten på Plesk, rekommenderar vi att du aktiverar läget.',
    'security-policy.encryptionEnable' => 'Förbättrat säkerhetsläge',
    'security-policy.securePassword' => 'Förbättrat säkerhetsläge',
    'security-policy.strengthSection' => 'Lösenordets styrka',
    'security-policy.strengthSectionHint' => 'De flesta lösenord som användare kan ställa in eller ändra i Plesk valideras för att se till att de uppfyller minimikraven för lösenordsstyrka som ställs in här. Starka lösenord är minst 9–12 tecken långa och inkluderar siffror, gemener och versaler, specialtecken och inga ord från ordboken. De är svårare att gissa, men även att komma ihåg. <a href="%%link%%" target="_blank">Lär dig mer om lösenordsstyrka</a>.',
    'security-policy.passwordStrength' => 'Minsta lösenordsstyrka',
    'security-policy.secureFtpSection' => 'Säker FTP',
    'security-policy.ftpOverSsl' => 'FTPS-användningspolicy',
    'security-policy.ftpOverSslHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Här kan du välja vilka typer av anslutningar som ska tillåtas.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Här kan du välja vilka typer av anslutningar som ska tillåtas. Det valda alternativet kommer att tillämpas på alla IP-adresser på servern. För att använda anpassade inställningar per IP-adress, välj motsvarande alternativ och ändra sedan FTPS-policyn i Verktyg & inställningar> IP-adresser.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Om du vill justera FTPS-inställningarna per IP-adress, välj först alternativet "Använd anpassade FTPS-inställningar per IP-adress" i Verktyg & inställningar> Säkerhetspolicy> Säker FTP.',
    'security-policy.ftpOverSslOptionRequired' => 'Tillåt endast skyddade FTPS-anslutningar',
    'security-policy.ftpOverSslOptionEnabled' => 'Tillåt båda säkra FTPS- och icke-säkra FTP-anslutningar',
    'security-policy.ftpOverSslOptionDisabled' => 'Tillåt endast icke-säkra FTP-anslutningar. Använd inte FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Använd anpassad FTPS-policy per IP-adress',
    'security-policy.prohibitWebConfigHandlersSection' => 'Anpassad hanteringspolitik',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Aktivera detta alternativ för att hindra kunder från att utesluta IIS-hanterare som definieras på servernivå via web.config.filen.',
    'security-policy.prohibitWebConfigHandlers' => 'Förhindrar möjligheten att utesluta hanterare via web.config',
    'security-policy.emailPasswordsSection' => 'Lagring av e-postlösenord',
    'security-policy.emailPasswordsSectionHint' => 'Lösenord till e-postkonton kan vara antingen symetriskt krypterade eller hashade. Efter att ha ändrat denna inställning gäller den nya policyn alla nyskapade konton och dessutom existerande konton nästa gång deras lösenord ändras.',
    'security-policy.emailPasswordHashingLabel' => 'Lagringsmetod',
    'security-policy.emailPasswordSymmetric' => 'Symetrisk kryptering',
    'security-policy.emailPasswordHashing' => 'Hashing',
    'security-policy.emailPasswordSymmetricHint' => 'Behändigare. Lösenord kan dekrypteras.',
    'security-policy.emailPasswordHashingHint' => 'Säkrare. Lösenord kan inte dekrypteras.',

    'server-mail-antivirus.used' => 'Använt antivirus',
    'server-mail-antivirus.policy' => 'Använd serveromfattande inställningar',
    'server-mail-antivirus.policyOff' => 'Skanning stängdes av',
    'server-mail-antivirus.policyAny' => 'Skanna både inkommande och utgående e-post',
    'server-mail-antivirus.policyFrom' => 'Skanna endast utgående e-post',
    'server-mail-antivirus.policyTo' => 'Skanna endast inkommande e-post',
    'server-mail-antivirus.allowPersonalSettings' => 'Tillåt personliga inställningar',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Tillåt åsidosättning av serveromfattande inställningar i varje e-postadress',
    'server-mail-antivirus.incoming' => 'för inkommande e-post',
    'server-mail-antivirus.outgoing' => 'för utgående e-post',
    'server-mail-antivirus.success' => 'Antivirusinställningarna ändrades.',

    'server-mail-black-list.title' => 'Lägg till domän i svartlistan',
    'server-mail-black-list.domainName' => 'Domännamn',
    'server-mail-black-list.emailAddress' => 'E-postadresser',
    'server-mail-black-list.emailAddressHint' => 'Det får inte finnas några icke-ASCII-tecken till vänster om @-tecknet. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com). Icke-ASCII-delar av domännamn får inte innehålla jokertecken.',
    'server-mail-black-list.action' => 'Vad man gör med e-postmeddelanden som uppfyller kriterierna:',
    'server-mail-black-list.actionDelete' => 'Ta bort från servern',
    'server-mail-black-list.actionSpam' => 'Mark som skräppost',
    'server-mail-black-list.success' => 'Domänen lades till i svartlistan.',

    'server-mail-white-list.title' => 'Lägg till nätverk i vitlistan',
    'server-mail-white-list.descEmailAddress' => 'E-postadresser som anges här kommer inte att registreras som skräppost av SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'IP-inmatningar som anges här kommer att läggas till i mail-serverns undantag.',
    'server-mail-white-list.ipAddress' => 'IP-adress/mask',
    'server-mail-white-list.ipAddressHint' => 'IP-adress får innehålla jokertecken eller CIDR-mask.',
    'server-mail-white-list.emailAddress' => 'E-postadresser',
    'server-mail-white-list.emailAddressHint' => 'Det får inte finnas några icke-ASCII-tecken till vänster om @-tecknet. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com). Icke-ASCII-delar av domännamn får inte innehålla jokertecken.',
    'server-mail-white-list.emailAddressOrIp' => 'E-post eller IP-adresser',
    'server-mail-white-list.wildcardPattern' => 'IP-adresser kan innehålla jokertecken (till exempel: 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP-adresser kan innehålla CIDR-masker (till exempel: 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Nätverket lades till i vitlistan.',

    'server-mail-settings.general.title' => 'Allmänna alternativ',
    'server-mail-settings.general.mailUiEnabled' => 'Aktivera posthanteringsfunktionerna på Plesk',
    'server-mail-settings.general.mailUiEnabledHint' => 'Att bocka ur alternativet tar bort förmågan att skapa inkorgar och ändra e-postinställningar för domäner via Plesk GUI. E-posttjänsten kommer att fortsätta fungera och webbmejl fortsätter att vara tillgänglig.',
    'server-mail-settings.general.serverName' => 'Installerad e-postserver',
    'server-mail-settings.general.changeServerName' => 'installera och använd en annan e-postserver',
    'server-mail-settings.general.imapServerName' => 'Installerad IMAP/POP3-server',
    'server-mail-settings.general.changeImapServerName' => 'installera och använd en annan IMAP/POP3 server',
    'server-mail-settings.general.changeServerHint' => 'Du kan %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Största meddelandestorlek',
    'server-mail-settings.general.kbytes' => 'KByte',
    'server-mail-settings.general.maxConnections' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Maximalt antal servrar (IMAP eller POP3) startat.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Maximalt antal e-postanvändare som kan vara inloggade samtidigt.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Maximalt antal anslutningar per IP adress.',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Maximalt antal anslutningar för en användare per IP adress.',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) tillåtet från samma IP adress.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) tillåtet från en e-postanvändare på varje IP adress.',
    'server-mail-settings.general.messageSubmission' => 'Aktivera SMTP-tjänsten i port 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Aktivera SMTP-tjänsten för port 587 för alla IP-adresser',
    'server-mail-settings.general.messageSubmissionBindTo' => 'På',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'Alla IP-adresser',
    'server-mail-settings.general.outgoingEmailMode' => 'Utgående e-post modus',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Sänd från domän IP adresser',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Sänd från domänens IP-adresser och använd domännamnen i SMTP-hälsningen',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Sänd från de specificerade IP adresserna',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Ingen',
    'server-mail-settings.general.subaddressing' => 'Aktivera underadresser av e-post',
    'server-mail-settings.general.subaddressingHint' => 'Det här alternativet aktiverar möjlighet att konfigurera e-postadresser för e-postlistor av typen %%verpStyleLink%%',
    'server-mail-settings.general.verpStyleLink' => 'VERP-typ',
    'server-mail-settings.general.mboxQuotaWarning' => 'Aktivera standardvarning för postlådekvot',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Skicka avisering till e-postanvändare när deras brevlådas kvotanvändning överstiger 95 %',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Anpassa standardvarning för postlådekvot',
    'server-mail-settings.general.fixSender' => 'Korrigera inkorrekt angiven avsändare för utgående e-post',
    'server-mail-settings.general.fixSenderHint' => 'Ange automatiskt giltiga e-postrubriker och avsändarkuvertadress för utgående e-post från domäner för att minska risken för att behandlas som skräppost',
    'server-mail-settings.general.maxMessageSizeHint' => 'För e-post med en bilaga bör värdet vara 35–40 % högre än bilagans storlek. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Se KB-artikeln för mer information',

    'server-mail-settings.autodiscover.title' => 'Automatisk upptäckt för e-post',
    'server-mail-settings.autodiscover.description' => 'Se hur det fungerar i %%link%%',
    'server-mail-settings.autodiscover.link' => 'kunskapsbas',
    'server-mail-settings.autodiscover.enabled' => 'Aktivera e-postens automatiska detektering',
    'server-mail-settings.autodiscover.enabledHint' => 'Aktivering av den här funktionen konfigurerar om alla domäner som har automatisk upptäckt aktiverad',
    'server-mail-settings.autodiscover.customServer' => 'Anpassat domännamn',
    'server-mail-settings.autodiscover.customServerHint' => 'Ange ett anpassat domännamn för användning som inkommande och utgående e-postservrar för automatisk upptäckt för e-post.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'OBS: Domännamnet måste vara skyddat med ett giltigt SSL/TLS-certifikat.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Konfigurera om automatisk upptäckt för DNS-poster',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Aktivering av den här funktionen konfigurerar om DNS-poster som har automatisk upptäckt aktiverad',

    'server-mail-settings.relay.title' => 'Vidaresändningsalternativ',
    'server-mail-settings.relay.type' => "Reläskifte",
    'server-mail-settings.relay.open' => "öppen",
    'server-mail-settings.relay.openSpamWarning' => "Att öppna din e-postrelä exponerar din e-postserver för skräppost.",
    'server-mail-settings.relay.openSpamChange' => "Behåll endast inställningen om du temporärt vill testa att e-postservern eller din Plesk-server är inuti det interna nätverket och inte åtkomliga via internet.",
    'server-mail-settings.relay.closed' => "stängd",
    'server-mail-settings.relay.auth' => "auktorisering krävs:",
    'server-mail-settings.relay.notSupported' => "stöds inte av e-postservern",
    'server-mail-settings.relay.change' => 'För att Plesk ska kunna skicka meddelanden när reläet är stängt, kan du %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'ändra SMTP-inställningarna',
    'server-mail-settings.relay.pop3' => "POP3 före SMTP",
    'server-mail-settings.relay.lockTime' => "låstidpunkt",
    'server-mail-settings.relay.min' => "Min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Använd inga vidaresändningsbegränsningar för följande nätverk:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP-adress/mask",

    'server-mail-settings.outgoing.title' => 'Begränsningar för utgående e-postmeddelanden',
    'server-mail-settings.outgoing.description' => 'Följande gränser är standard. De kan uteslutas i varje tjänsteplan och abonnemang. Gränserna verkar inte serveromfattande, utan agerar som en mall för de planer och prenumerationer för vilka det inte angetts några anpassade gränser. Observera att aktivering av begränsning av utgående e-postmeddelanden kan påverka e-postserverns prestanda. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Lär dig mer om att begränsa utgående post',
    'server-mail-settings.outgoing.enabled' => 'Aktivera begränsningar för utgående e-postmeddelanden',
    'server-mail-settings.outgoing.countRecipients' => 'Räkna antalet mottagare istället för meddelanden',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Aktiverar ett läge som räknar antalet mottagare istället för meddelanden när det begränsar Utgående post och räknestatistik. Ett meddelande som skickas till tio mottagare kommer till exempel att räknas som tio meddelanden.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Standardgräns på utgående meddelanden från en postlåda (per timme)',
    'server-mail-settings.outgoing.domainLimit' => 'Standardgräns på utgående meddelanden från ett domän (per timme)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Standardgräns på utgående meddelanden från ett abonnemang (per timme)',
    'server-mail-settings.outgoing.unlimited' => 'Obegränsat',
    'server-mail-settings.outgoing.sendmail' => 'Tillåt användare och skripts att använda Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Skripts och användare kan skicka e-postmeddelanden (å abonnemangets systemanvändares vägnar) genom att använda Sendmail även om gränserna för en postlåda och ett domän har överskridits. Maximalt antal meddelanden som kan sändas genom Sendmail vill definieras av gränsen för ett helt abonnemang. Denna inställningen tillåter inte serveromfattande bruk av skripts för Sendmail, men den agerar som en standardinställning för tjänsteplaner och abonnemang.',
    'server-mail-settings.outgoing.reportPeriod' => 'Visa rapporter baserade på statistik för senaste',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Rapporterna är skapade och avisering visas på startsidan om försök att överskrida gränserna för utgående e-postmeddelanden i den specificerade perioden.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Sänd ett e-postmeddelande varje',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Meddelanden ger statistik över försök till att överskrida gränserna för utgående e-postmeddelanden i den specificerade perioden.',
    'server-mail-settings.outgoing.periodP1D' => '1 dag',
    'server-mail-settings.outgoing.periodP1W' => '1 vecka',
    'server-mail-settings.outgoing.periodP2W' => '2 veckor',
    'server-mail-settings.outgoing.periodP1M' => '%1 månad',
    'server-mail-settings.outgoing.periodPT15M' => '15 minuter',
    'server-mail-settings.outgoing.periodPT1H' => '1 timma',
    'server-mail-settings.outgoing.periodPT6H' => '6 timmar',
    'server-mail-settings.outgoing.periodPT12H' => '12 timmar',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Gränserna för utgående post fungerar inte för e-postsändare vars IP-adresser fins på e-postserverns vita lista. Til exempel, om det finns en lokal värddator (127.0.0.0 / 8, ::1 / 128) i den vita listan, skickas alla e-postmeddelanden korrekt från den lokala servern oavsett begränsningarna. E-postsändare kan använda antingen lokala IP-adresser (webbplatser och anpassade script som finns i den lokala värddatorn) eller externa adresser (kunder som skickar e-post från e-postklienter som har installerats i deras datorer eller mobila enheter). För att gränserna ska fungera för alla e-postsändare (både lokala och externa), ta bort alla IP-adresser och nätverk från den vita listan. Observera att om du tar bort den lokala värddatorn (127.0.0.0 / 8, ::1 / 128) från den vita listan, kan åtgärden på webbplatser och script som skickar e-post från denna server avbrytas. För ytterligare detaljer om begränsningarna för utgående e-post, se Administratörsvägledningen, Skydd mot utgående spam.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Huvudreläet är öppet: gränserna för utgående post fungerar inte.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Gränsen för utgående meddelanden för en domän (%%value%%) kan inte vara större än gränsen för ett abonnemang (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Gränsen för utgående meddelanden för en e-postadress (%%value%%) kan inte vara större än gränsen för en domän (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Gränsen för utgående meddelanden för en e-postadress (%%value%%) kan inte vara större än gränsen för ett abonnemang (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Mailman-inställningar',
    'server-mail-settings.mailman.secureLinks' => 'Använd säkra länkar i e-postlistor',
    'server-mail-settings.mailman.secureLinksHint' => 'Aktivera eller inaktivera säker (HTTPS) länkgenerering i e-postlistor.',
    'server-mail-settings.mailman.noLocalhost' => 'För att använda utskickslistor, behöver du ha localhost (127.0.0.0/8, ::1/128) i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'För att använda utskickslistor, behöver du ha localhost i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor. Observera att det inte finns några IPv4 localhost-adresser (127.0.0.0/8) i vitlistan nu, så den utgående postkontrollen fungerar för IPv4-adresser.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'För att använda utskickslistor, behöver du ha localhost i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor. Observera att det inte finns några IPv6 localhost-adresser (::1/128) i vitlistan nu, så den utgående postkontrollen fungerar för IPv6-adresser.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Aktivera DMARC för att kontrollera inkommande post',
    'server-mail-settings.spam-filter.dmarcHint' => 'Det här alternativet är tillgängligt när DKIM och SPF är aktiverade för inkommande e-post.',
    'server-mail-settings.spam-filter.dkim' => 'DKIM skydd mot skräppost',
    'server-mail-settings.spam-filter.singOutgoing' => 'Tillåt signering av utgående e-post',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Kontrollera inkommande e-post',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Det här alternativet kan inte stängas av medan DMARC är aktiverat för inkommande e-post.',
    'server-mail-settings.spam-filter.spf' => 'SPF-spamskydd',
    'server-mail-settings.spam-filter.spfEnabled' => 'Aktivera SPF spamskydd för att kontrollera inkommande post',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Det här alternativet kan inte stängas av medan DMARC är aktiverat för inkommande e-post.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'SPF-kontroll fortsättar om det finns problem med DNS-sökning.',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'Först utför SPF en DNS-sökning. Markera detta alternativ om du vill fortsätta kontrollera om DNS-sökningen misslyckas. Detta alternativ är avmarkerat om det inte har någon effekt i aktuellt kontrollmodus.',
    'server-mail-settings.spam-filter.behavior' => 'SPF-kontrolläge',
    'server-mail-settings.spam-filter.behaviorHint' => 'Då använder SPF lokala och gissnings regler. Meddelandet kan avvisas avhängig av det valde kontrolläget och kontrollresultat.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Skapa bara Mottaget-SPF-rubriker, spärra aldrig',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Använd tillfälliga felmeddelanden när du har DNS-sökningsproblem',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Avvisa post när SPF anger "fail" (neka)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Avvisa post när SPF anger "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Avvisa post när SPF anger "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Avvisa post när SPF anger "pass"',
    'server-mail-settings.spam-filter.localRules' => 'lokala SPF-regler',
    'server-mail-settings.spam-filter.guessRules' => 'SPF-gissningsregler',
    'server-mail-settings.spam-filter.explanationText' => 'SPF-förklaringstext',
    'server-mail-settings.spam-filter.rbl' => "Skräpppostskydd baserat på DNS blackhole-listor",
    'server-mail-settings.spam-filter.rblEnabled' => "Aktivera skräppostskydd baserat på DNS-svarta hållistor",
    'server-mail-settings.spam-filter.rblServer' => "DNS-zoner för DNSBL-tjänsten",
    'server-mail-settings.spam-filter.rblServerHint' => "Separera posterna med ett semikolon, exempelvis: 'dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Extra sidhuvud för auto-svar',
    'server-mail-settings.auto-reply-headers.description' => 'Upprätta extra sidhuvuden för alla auto-svarsmeddelanden från Plesk-servern.',
    'server-mail-settings.auto-reply-headers.extra' => 'Extra sidhuvuden',

    'server-mail-settings.pop3-names.title' => "Namn för POP3/IMAP e-postkonton",
    'server-mail-settings.pop3-names.disabled' => "Endast fullständiga namn på POP3/IMAP e-postkonton kan användas",
    'server-mail-settings.pop3-names.enabled' => "Korta (webmaster) och fullständiga (webmaster@domain.com) namn på POP3/IMAP postkonton kan användas",

    'server-mail-settings.success' => 'E-postinställningarna har ändrats.',

    'server-mail-spam-filter.general' => 'Allmänt',
    'server-mail-spam-filter.isEnabled' => 'Aktivera serveromfattande filtrering av skräppost med SpamAssassin',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin är inte installerat.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Aktivera ett serveromfattande grå lista-skräppostskydd',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Applicera individuella inställningar på skräppostfiltrering',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Spamfilter är inaktiverat: mail-servern stödjer inte inställningar för filtrering av skräppost på e-postlådenivå.",
    'server-mail-spam-filter.settings' => 'SpamAssassin-inställningar',
    'server-mail-spam-filter.maxChildrenTitle' => 'Maxprocesser',
    'server-mail-spam-filter.maxChildrenDescription' => 'Maximalt antal spamd worker-processer att köra.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Krävda kärnor',
    'server-mail-spam-filter.requiredHitsDescription' => 'Poängen som ett meddelande måste få för att klassas som skräppost.',
    'server-mail-spam-filter.maxMailLimit' => 'Filtrera inte om mail-storlek överskrider detta värde',
    'server-mail-spam-filter.maxMailLimitText' => 'Storleksgräns',
    'server-mail-spam-filter.kbytes' => "KByte",
    'server-mail-spam-filter.maxThreadsLimit' => 'Antal trådar som skräppostfilter kan skapa',
    'server-mail-spam-filter.tagTitle' => 'Skräppostetikett',
    'server-mail-spam-filter.tagDescription' => 'Följande text kommer att läggas till i början av ämnet för varje meddelande som anses vara skräppost.',
    'server-mail-spam-filter.alarmMessage' => 'Varningstext skräppostdetektering',
    'server-mail-spam-filter.languages' => 'Betrodda språk',
    'server-mail-spam-filter.locales' => 'Betrodda språkversioner',
    'server-mail-spam-filter.success' => 'Skräppostfilterinställningarna har ändrats.',
    'server-mail-spam-filter.personalSettingsWarning' => 'Möjligheten att tillämpa personliga skräppostfiltreringsinställningar är avstängd av serveradministratören. Skräppostfilterinställningarna som anges nedan kommer inte att tillämpas',

    'service-plan.admin-plan.subscription_section' => 'Vanlig',
    'service-plan.admin-plan.tools_section' => 'Verktyg & resurser',
    'service-plan.admin-plan.apps_section' => 'Program och databaser',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk utseende',
    'service-plan.admin-plan.statistics_section' => 'Statistik',
    'service-plan.admin-plan.general_section' => 'Allmänt',
    'service-plan.admin-plan.mail_section' => 'E-post',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Anknytningar',
    'service-plan.admin-plan.troubleshooting_section' => 'Assistans och felsökning',
    'service-plan.admin-plan.simplePanel' => 'Begränsat läge',
    'service-plan.admin-plan.enabled' => 'Aktivera begränsat läge',
    'service-plan.admin-plan.enabledDescription' => 'Välj detta alternativ för att begränsa antalet åtgärder som den administratören kan vidta i Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Välj detta alternativ för att begränsa antalet åtgärder som den extra administratören kan vidta i Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Tillhandahåll endast programen jag väljer',
    'service-plan.applications-subscription.useFilterDescription' => 'Använd detta alternativ för att välja program som ska vara tillgängliga för abonnenten.',
    'service-plan.applications-subscription.applications' => 'Program',
    'service-plan.applications-subscription.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',

    'service-plan.applications.useFilterLabel' => 'Tillhandahåll endast programen jag väljer',
    'service-plan.applications.useFilterDescription' => 'Använd detta alternativ för att välja program som ska vara tillgängliga för abonnenterna.',
    'service-plan.applications.applications' => 'Program',
    'service-plan.applications.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',

    'service-plan.dns.dnsZoneType' => 'Domänens DNS-namn',
    'service-plan.dns.dnsZoneTypeMaster' => 'Primär',
    'service-plan.dns.dnsZoneTypeSlave' => 'Sekundär',

    'service-plan.extras.groupOtherServices' => 'Andra tjänster',
    'service-plan.extras.none' => 'Ingen',

    'service-plan.hosting.enablePhysicalHosting' => 'Aktivera värdtjänst',
    'service-plan.hosting.sectionCoreHosting' => 'Allmänna egenskaper',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Standarddatabasserver',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avancerat',
    'service-plan.hosting.phpSettingsHelpLink' => 'Lär dig att välja de mest lämpliga PHP-inställningarna',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Statusen för webbplatserna är upphävd i detta abonnemang',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status för webbplatserna i abonnemang som upphävts tillfälligt',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Vald status tillämpas på alla webbplatser under planens abonnemang när abonnemanget upphävs (till exempel då det löper ut eller dess betalningsperiod löper ut).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Vald status tillämpas på webbplatser när abonnemanget upphävs (till exempel då det löper ut eller dess betalningsperiod löper ut).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Inaktiverad',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Webbplatsbesökare kommer att omdirigeras till webbserverns standardsida.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Avstängd',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Webbplatsbesökare kommer att omdirigeras med sökmotorvänliga 503 HTTP-koden till den anpassade sidan med feldokument.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Aktiva',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Webbplatserna förblir tillgängliga från Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Allokera delade IP-adresser',
    'service-plan.ip.allocateExclusiveIp' => 'Allokera dedikerade IP-adresser',
    'service-plan.ip.allocateExclusiveIpV4' => 'Tilldela dedikerade IPv4-adresser',
    'service-plan.ip.allocateExclusiveIpV6' => 'Tilldela dedikerade IPv6-adresser',

    'service-plan.mail.mailService' => 'Posttjänst',
    'service-plan.mail.mailServiceDisabled' => 'Inaktiverad',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Inaktiverat för inkommande e-post',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk kommer inte att tillhandahålla några e-posttjänster på domäner.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Domäner kan endast skicka e-post och endast använd Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Aktiverad',
    'service-plan.mail.mailServiceEnabledHint' => 'Domäner kan skicka och ta emot e-post.',
    'service-plan.mail.mailServiceNotConfigured' => 'Inte konfigurerad',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk kommer inte att tillhandahålla några e-posttjänster på domäner.',
    'service-plan.mail.webMail' => 'Webbpost',
    'service-plan.mail.mailingLists' => 'Sätt på e-postlistor',
    'service-plan.mail.mailToNonExistentUser' => 'Policy om mail för obefintliga användare',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Returnera med meddelande',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Vidarebefordra till adressen',
    'service-plan.mail.mailToNonExistentUserReject' => 'Avvisa',
    'service-plan.mail.mailAutodiscovery' => 'Aktivera e-postens automatiska detektering',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Se hur det fungerar <a href="%%link%%" target="_blank">kunskapsbasen</a>',
    'service-plan.mail.bounceMessage' => 'Denna adress accepterar ingen e-post längre.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Omdirigera till extern e-postserver med IP-adress',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - inaktiverat',
    'service-plan.mail.notConfiguredConfirm' => 'Ta permanent bort alla inkorgar för domänerna ifråga, inklusive mottagen och skickad e-post.',
    'service-plan.mail.notConfiguredConfirmError' => 'Vänligen bekräfta',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Obs: Inställningen Behåll webb- och trafikstatistik ändras inte i abonnemangen när du uppdaterar den för en tjänsteplan. Det enda sättet att uppdatera denna inställning för varje domän är att ändra den i Plesk-databasen. Se <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">denna KB-artikel</a> för mer information.',
    'service-plan.misc.retainEnabled' => 'Behåll webb- och trafikstatistik för',
    'service-plan.misc.logRotation' => 'Loggrotering',
    'service-plan.misc.logRotationCondition' => 'Loggroteringsvillkor',
    'service-plan.misc.logRotationBySize' => 'Efter storlek',
    'service-plan.misc.logRotationByTime' => 'Efter tid',
    'service-plan.misc.logRotationDaily' => 'Dagens',
    'service-plan.misc.logRotationWeekly' => 'Veckovis',
    'service-plan.misc.logRotationMonthly' => 'Månadsvis',
    'service-plan.misc.logRotationSizeDescription' => 'Storleksvärdet måste vara mellan %%min%% och %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maximalt antal loggfiler',
    'service-plan.misc.compress' => 'Komprimera loggfilerna',
    'service-plan.misc.sendLogToEmail' => 'Efter att Plesk hämtat data från loggfilen i webben och FTP-servrarna, skicka loggarna via e-post till denna adress',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'månader',
    'service-plan.misc.logRotationPeriodGreater' => 'Loggrotationsperioden får inte vara längre än servergränsen %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Om den är avstängd använder alla webbplatser för ett abonnemang samma IIS-applikationspool som är dedikerad abonnemanget.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Markera tjänster och privilegier som tillhandahålls med abonnemanget.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Visa fler tillgängliga behörigheter',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Visa färre behörigheter',
    'service-plan.permissions-subscription.noShellManagement' => 'Tillåts inte',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Hantering av åtkomsten till servern via SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Ger kunderna möjlighet att byta SSH för deras systemanvändare. Gör att "SSH-åtkomst till servern under abonnemangets systemanvändare" värdparameter fungerar som en förinställning.',

    'service-plan.permissions.permissionsTabDescription' => 'Välj tjänsterna och tillstånden som tillhandahålls av planen.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Markera tjänster och privilegier som läggs till abonnemangen med denna tilläggsplan. Observera att tillstånd som inte väljs i tillägget inte kommer att modifiera abonnemangsparametrarna på något sätt.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Tillstånd låter kunder ändra specifika inställningar hos sina prenumerationer. När en prenumeration skapas så tillämpar Plesk förbestämda värden från planen på inställningarna som kunderna kan ändra. Efteråt kommer uppdatering av planen eller tillämpning av ett tillägg inte att skriva över kundens ändringar.',
    'service-plan.permissions.showMorePermissions' => 'Visa fler tillgängliga behörigheter',
    'service-plan.permissions.hideMorePermissions' => 'Visa färre behörigheter',
    'service-plan.permissions.noShellManagement' => 'Tillåts inte',
    'service-plan.permissions.systemAccessLabel' => 'Hantering av åtkomsten till servern via SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Gör så att värdtjänstparametern "SSH-åtkomst till serverskalet under abonnemangets systemanvändare" fungerar som förinställning.',

    'service-plan.resources-subscription.overusePolicy' => 'Överanvändningspolicy',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Överanvändning är inte tillåtet',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Tillåt inte överanvändning av resurser. Ett abonnemang upphävs automatiskt om resursanvändningen överstiger gränsvärdena.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Överanvändning av diskutrymme och trafik är tillåtet',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Tillåt överanvändning av diskutrymme och trafik. Tillåt inte överanvändning av andra resurser.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Överanvändning är tillåtet (rekommenderas inte)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Tillåt abonnenten att använda mer resurser än vad som till en början ingick med abonnemanget.',
    'service-plan.resources-subscription.overuseNotify' => 'Meddela mig via e-post vid överanvändning.',
    'service-plan.resources-subscription.oversellPolicy' => 'Överförsäljningspolicy',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med ett abonnemang. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med ett abonnemang, oavsett hur mycket dessa resurser för närvarande används.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Definiera gränserna för användningen av resurserna som tillhandahålls med abonnemanget.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Visa fler tillgängliga resurser',
    'service-plan.resources-subscription.hideMoreResources' => 'Visa mindre resurser',

    'service-plan.resources.overusePolicy' => 'Överanvändningspolicy',
    'service-plan.resources.overusePolicyNotAllowed' => 'Överanvändning är inte tillåtet',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Tillåt inte överanvändning av resurser. Ett abonnemang upphävs automatiskt om resursanvändningen överstiger gränsvärdena.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Överanvändning av diskutrymme och trafik är tillåtet',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Tillåt överanvändning av diskutrymme och trafik. Tillåt inte överanvändning av andra resurser.',
    'service-plan.resources.overusePolicyAllowed' => 'Överanvändning är tillåtet (rekommenderas inte)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Tillåt kunderna använda mer resurser än vad som till en början ingick i planen.',
    'service-plan.resources.overuseNotify' => 'Meddela mig via e-post vid överanvändning.',
    'service-plan.resources.oversellPolicy' => 'Överförsäljningspolicy',
    'service-plan.resources.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med en plan. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med en plan, oavsett hur mycket dessa resurser för närvarande används.',
    'service-plan.resources.mainGroupTitle' => 'Definiera resurserna som tillhandahålls med planen.',
    'service-plan.resources.additionalGroupTitle' => 'Visa fler tillgängliga resurser',
    'service-plan.resources.hideMoreResources' => 'Visa mindre resurser',
    'service-plan.resources.allowSitebuilderUpsell' => 'Låt kunden skapa en provversion av Presence Builder webbplatser.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Denna inställning låter kunderna skapa mer Presence Builder-webbplatser än vad som tillhandahålls av tjänsteplanen. Kunder måste köpa dessa webbplatser för att publicera dem.',

    'service-plan.servicePlanName' => 'Namn på servicenplan',
    'service-plan.resellerPlanName' => 'Återförsäljarens plannamn',
    'service-plan.addonPlanName' => 'Tilläggsprogram i planens namn',
    'service-plan.adminPlanPermissionsTab' => 'Administrationsverktyg',
    'service-plan.adminPlanPermissionsTabDescription' => 'Välj funktionerna som är tillgängliga för administratören när Begränsat läge är aktiverat.',
    'service-plan.hostingPermissionsTab' => 'värdtjänstverktyg',
    'service-plan.hostingPermissionsTabDescription' => 'Välj webbvärdtjänstverktyg och inställningar som är tillgängliga för administratören i Power User-vyn när det Begränsade läget är aktiverat.',
    'service-plan.resourcesTab' => 'Resurser',
    'service-plan.resourcesTabDescription' => 'Definiera resurserna som tillhandahålls med planen och policyn om resursanvändningen.',
    'service-plan.subscriptionResourcesTabDescription' => 'Definiera resurserna som tillhandahålls med abonnemanget och policyn om resursanvändningen.',
    'service-plan.hostingTab' => 'värdtjänstparametrar',
    'service-plan.hostingTabDescription' => 'Specificera parametrarna för värdtjänsttjänsten som tillhandahålls med planen. Observera att hostinginställningarna som specificerats i tilläggsplanen inte har tillämpats på abonnemangen som gav tillståndet "Hostinginställningshantering" antingen via serviceplanen eller tilläggsplanen.',
    'service-plan.secureSettingsDescription' => 'Om du vill att den tillhandahållna värdtjänsten ska vara den säkraste, %%link%%. Notera att några av behörigheterna, om beviljade, låter abonnenter förändra dessa inställningar. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'applicera förvalda säkra inställningar',
    'service-plan.secureSettingsHelpLink' => 'Lär dig om säker värdtjänstinställning',
    'service-plan.mailTab' => 'E-post',
    'service-plan.mailTabDescription' => 'Specificera parametrarna för e-posttjäntsen som tillhandahålls med planen.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Specificera parametrarna för DNS-tjänsten som tillhandahålls med planen.',
    'service-plan.performanceTab' => 'Uppträdande',
    'service-plan.performanceTabDescription' => 'Specificera systemparametrarna som påverkar prestandan för alla tjänster som tillhandahålls med planen.',
    'service-plan.permissionsTab' => 'Behörigheter',
    'service-plan.miscTab' => 'Loggar & statistik',
    'service-plan.miscTabDescription' => 'Specificera hur statistik och loggar för planens abonnemang ska lagras. Notera att dessa inställningar inte synkar i abonnemang.',
    'service-plan.miscTabAdminPlanDescription' => 'Specificera hur statistik och loggar från abonnemanget ska lagras.',
    'service-plan.extrasTab' => 'Ytterligare tjänster',
    'service-plan.extrasTabDescription' => 'Markera tjänsterna som ska inkluderas i planen förutom webbvärdtjänst, DNS och e-posttjänster.',
    'service-plan.ipTab' => 'IP-adresser',
    'service-plan.ipTabDescription' => 'Definiera parametrarna för IP-resurserna som tillhandahålls med planen.',
    'service-plan.applicationsTab' => 'Program',
    'service-plan.applicationsTabDescription' => 'Markera programmen som ska vara tillgängliga i planen. Du kan välja att tillhandahålla alla program som är tillgängliga i Programkatalogen, plus de som du har laddat upp till servern eller välj programmen manuellt. Om du vill tillhandahålla alla tillgängliga program, behöver du inte göra någonting på denna flik, gå till fliken Behörigheter och välj alternativet Tillgång till programkatalogen. Om du vill välja programmen manuellt, kan du göra det på denna flik.',
    'service-plan.applicationsTabDescription-addon' => 'Markera programmen som ska vara tillgängliga i tilläggen.',
    'service-plan.applicationsTabDescription-subscription' => 'Markera programmen som ska vara tillgängliga i abonnemanget. Du kan välja att tillhandahålla alla program som är tillgängliga i Programkatalogen, plus de som du har laddat upp till servern eller välj programmen manuellt. Om du vill tillhandahålla alla tillgängliga program, behöver du inte göra någonting på denna flik, gå till fliken Behörigheter och välj alternativet Tillgång till programkatalogen. Om du vill välja programmen manuellt, kan du göra det på denna flik.',
    'service-plan.planSyncSubsriptionWarning' => 'Vissa abonnemang är inte synkroniserade med planen. De har markerats som \'Osynkroniserade\' i prenumerationslistan. För att försöka med synkroniseringen igen, gå till abonnemangets översiktssida och klicka på Sync-knappen.',
    'service-plan.planSyncResellerWarning' => 'Vissa återförsäljare är inte synkroniserade med planen. De markerades som \'Osynkroniserade\' i återförsäljarnas lista. För att försöka med synkroniseringen igen, gå till återförsäljarens översiktssida och klicka på Sync-knappen.',
    'service-plan.planSyncAdminWarning' => 'Kan inte tillämpa ändringarna på abonnemang eftersom Plesk inte tillhandahåller några av de tjänster eller resurser som påverkas av dessa ändringar. Orsaken: %%reason%%',
    'service-plan.duplicateName' => 'En plan med det namnet existerar redan.',
    'service-plan.phpSettingsTab' => 'PHP-inställningar',
    'service-plan.phpHandlerNotFound' => 'Kan inte hämta information om planens PHP-version. Installera om den eller välj en annan PHP-version för tjänsteplanen.',
    'service-plan.phpHandlerNotRegistered' => "PHP-version %%fullVersion%% är inte installerad. PHP-skriptning för domänerna som använder denna tjänsteplan kommer inte att vara tillgängliga. Installera PHP <nobr>version %%fullVersion%%</nobr> eller välj en annan PHP-version för tjänsteplanen.",

    'service-plan.phpSettingsTabDescription' => 'Här kan du specificera PHP-inställningar per abonnemang, som förbigår inställningarna som anges av den serveromfattande php.ini-filen. Det kan till exempel vara användbart när du vill begränsa kundernas PHP-skripts förbrukning av systemresurserna. Kunderna (om så tillåts) kan förbigå denna PHP-konfiguration med sina egna konfigurationer per domän. När du ställer in en parameter till standardvärdet, använder PHP parametervärdet från den serveromfattande PHP-konfigurationen. Notera att följande platshållare stöds: {DOCROOT} och {WEBSPACEROOT} står för dokumentrotkatalogen av en domän och en rotkatalog av ett webbutrymme som får en egen PHP-konfiguration; {TMP} står för katalogen som lagrar temporära filer. Obs: Inställningarna nedan kan skrivas över av parametrar som anges i filerna .htaccess, php.ini eller .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Här kan du specificera förabonnemangets PHP-inställningar som förbigår inställningarna som definieras av huvudtjänsteplanen. Detta kan vara användbart till exempel när du vill ta bort vissa PHP-begränsningar som ställts in i huvudtjänsteplanen. När du ställer in en parameter på standardvärdet, kommer PHP att använda parametervärdet från tjänsteplanens PHP-konfiguration. Notera att följande platshållare stöds: {DOCROOT} och {WEBSPACEROOT} står för dokumentrotkatalogen av en domän och en rotkatalog av ett webbutrymme vilket får en egen PHP-konfiguration; {TMP} står för katalogen som lagrar temporära filer.',
    'service-plan.phpSettingsPhpVersion' => 'Din aktuella PHP-version är %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Här kan du specificera förabonnemangets PHP-inställningar som förbigår inställningarna som definieras av den serveromfattande php.ini-filne. När du ställer in en parameter till standardvärdet, använder PHP parametervärdet från den serveromfattande PHP-konfigurationen.',
    'service-plan.webServerSettingsTab' => 'Webbserver',
    'service-plan.webServerSettingsTabDescription' => 'Här kan du specificera Apache webbserverinställningar för denna tjänsteplan. Om Apache körs med nginx som en frontend-server, kan du ange nginx-inställningar på denna sida också. Alla nyskapade domäner kommer att få de specificerade inställningarna. Dock kommer befintliga domäner inte att erhålla förändringarna när du förändrar dessa inställningar.',
    'service-plan.servicesTab' => 'Tjänster',
    'service-plan.servicesTabDescription' => 'Här kan du specificera tjänster som tilldelats tjänsteplanen.',
    'service-plan.servicePropertiesTab' => 'Egenskaper %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Här kan du specificera egenskaperna för %%serviceName%% tjänsten som tilldelats tjänsteplanen.',
    'service-plan.longTaskWarning' => 'Du har %%subscriptionsCount%% abonnemang i denna plan. Synk-uppgiften kan behöva avsevärd tid, därför kommer den utföras i bakgrunden.',
    'service-plan.hostingParametersTab' => 'värdtjänstparametrar',
    'service-plan.adminInfoSection' => 'Information för administratören',
    'service-plan.descriptionInPanel' => 'Beskrivning',
    'service-plan.longDescription' => 'Den angivna beskrivningen är för lång.',
    'service-plan.conflictPermissions' => 'Kan inte ge följande tillstånd eftersom de står i konflikt med återförsäljningsplanen: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Startmetod',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatisk',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuell',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Stänga av',
    'services.change-startup-type.autoActionError' => 'Kan inte ställa in starttypen på \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Kan inte ställa in starttypen på \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Kan inte ställa in starttypen på \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Återställ till standard',
    'sessions.settings.restoreDefaultButtonDescription' => 'Återställ sessionsparametrarna till standardvärden.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Sessionsparametrarna har standardvärden.',
    'sessions.settings.idleTime' => 'Sessionens inaktivitetstid',
    'sessions.settings.disableCheckSessionIp' => 'Tillåt IP-adressändringar under en specifik session',
    'sessions.settings.minuteShortTitle' => 'Min',

    'settings-ui.controls.title' => 'Kontroller',

    'settings-ui.interface-views.description' => "Det finns flera produkt UI-vyer tillgängliga för dig. Beroende på vilken vy du använder, kan funktioner och inställningar finnas på olika platser eller t.o.m. vara aktiverade/inaktiverade. Olika vyer är bättre lämpade för olika typer av användare.",
    'settings-ui.interface-views.panelSimpleLink' => 'Verktyg & inställningar> Inställningar för begränsat läge',
    'settings-ui.interface-views.useCustomView' => 'Aktivera begränsat läge',
    'settings-ui.interface-views.useCustomViewHint' => 'Välj detta alternativ för att begränsa antalet åtgärder som administratören kan vidta i Plesk Panel. För att förändra tillgängligheten av åtgärderna, gå till %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Denna vy lämpar sig bäst för att hantera webbplatser, deras filer, databaser, e-postkonton, webbapplikationer och andra tjänster.',
    'settings-ui.interface-views.selectUiModeTitle' => "Markera ditt gränssnitt",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vy för avancerade användare (för utvecklare och webbyråer)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vy för tjänsteleverantör (för webbhotell)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Denna vy är ämnad för serveradministratörer som tillhandahåller och säljer webbhotelltjänster till kunder med tjänsteplaner.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Dölj returkontroller',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Döljer knappen som möjliggör inställning av hur processmejl skickas till icke-existerande e-postadresser',

    'settings-ui.branding.description' => 'Märk Plesk-gränssnittet genom att ändra hur sidtiteln visas i webbläsarens titelfält och/eller byta ut Plesk-logotypen i den övre vänstra hörnet.',
    'settings-ui.branding.buttonDefault' => 'Standardlogotyp',
    'settings-ui.branding.sectionTitle' => 'Anpassad titel',
    'settings-ui.branding.enableCustomTitle' => 'Aktivera anpassad titel på Plesk-sidor',
    'settings-ui.branding.customTitle' => 'Rubriktext',
    'settings-ui.branding.sectionLogo' => 'Anpassad logo',
    'settings-ui.branding.enableCustomLogo' => 'Aktivera anpassad panellogo',
    'settings-ui.branding.logo' => 'Logotyp-fil',
    'settings-ui.branding.logoUrl' => 'Logotyp URL',
    'settings-ui.branding.logoUrlEnabled' => 'Anpassad',
    'settings-ui.branding.logoUrlDisabled' => 'Standard',
    'settings-ui.branding.sectionFavicon' => 'Anpassad favicon',
    'settings-ui.branding.enableCustomFavicon' => 'Aktivera anpassad favicon',
    'settings-ui.branding.sectionFaviconDesc' => 'Samma favicon måste laddas upp i båda formaten för bättre stöd i olika webbläsare.',
    'settings-ui.branding.faviconSvg' => 'Favicon SVG-fil',
    'settings-ui.branding.faviconSvgHint' => 'Tillåtet format: SVG',
    'settings-ui.branding.faviconIco' => 'Favicon ICO-fil',
    'settings-ui.branding.faviconIcoHint' => 'Tillåtet format: ICO',
    'settings-ui.branding.show' => 'Visa',
    'settings-ui.branding.updateSuccess' => 'Plesk-brandingegenskaper var ändrats.',
    'settings-ui.branding.sectionBackground' => 'Anpassad bakgrund för inloggningsskärm',
    'settings-ui.branding.enableCustomBackground' => 'Aktivera bakgrundsbild',
    'settings-ui.branding.backgroundFile' => 'Bakgrundsbild',
    'settings-ui.branding.backgroundColor' => 'Bakgrundsfärg',
    'settings-ui.branding.backgroundResetColor' => 'Återställ',
    'settings-ui.branding.backgroundFit' => 'Bakgrundsfyllning',
    'settings-ui.branding.background.fit.fill' => 'Fyll skärm',
    'settings-ui.branding.background.fit.fit' => 'Anpassa till skärm',
    'settings-ui.branding.background.fit.center' => 'Centrera',
    'settings-ui.branding.background.fit.tile' => 'Rutor',

    'sitebuilder.trial.description' => 'Denna sida låter dig konfigurera Try and Buy-läget (tidigare Kundens förvärvsscenario). I detta läge kan kunden skapa en webbplats med alla tillgängliga funktioner i det inkluderadde Presence Builder-programmet. Men publiceringen av testwebbplatserna är inte tillgänglig för kunderna förrän de köper en värdtjänsttjänsteplan eller en tilläggsplan. Läget Try and Buy kan också ges dina befintliga kunder via en värdtjänstplan eller en tilläggsplan. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Se dokumentationen för ytterligare information.',
    'sitebuilder.trial.lifetimeLabel' => 'Livslängd för testwebbplatser',
    'sitebuilder.trial.lifetimeUnits' => 'dagar',
    'sitebuilder.trial.lifetimeDescription' => 'Detta är den tid som ska gå innan provwebbplatserna som inte köpts av kunderna tas bort från server.',
    'sitebuilder.trial.signupLabel' => 'Aktivera offentlig tillgång till testläget',
    'sitebuilder.trial.signupDescription' => 'Om du vill locka kunder med värdtjänstannonsering med Presence Bulider och tillhandahåller Presence Builder-demon till dem, aktivera det offentliga testläget och publicera testlägets åtkomst-URL på din webbplats.',
    'sitebuilder.trial.signupLinkLabel' => 'Testläge för URL-åtkomst',
    'sitebuilder.trial.signupLinkDescription' => 'Denna URL öppnar Presence Builder i testläge. Publicera denna URL på din webbplats för att annonsera värdtjänst med Presence Builder och locka kunder.',
    'sitebuilder.trial.promotionLabel' => 'Visa testlägesinformation i Presence Builder-redigeraren',
    'sitebuilder.trial.promotionDescription' => 'Använd detta alternativ om du vill visa extra information om att Presence Builder körs i testläge.',

    'update-settings.policyHintForPum' => 'Du kan ställa in automatiska installationer av uppdateringar här. Meddelanden om e-post kan ställas in när uppdateringar är tillgängliga för manuell installation eller installerades automatiskt.',
    'update-settings.policyHint' => 'Meddelanden om e-post kan ställas in när uppdateringar är tillgängliga för manuell installation eller installerades automatiskt.',
    'update-settings.branchDisabledDescription' => 'Meddela mig inte om tillgängliga uppgraderingar',
    'update-settings.automaticPatchesInstallation' => 'Installera Plesk-uppdateringar automatiskt (rekommenderas)',
    'update-settings.automaticPatchesThirdParty' => 'Installera automatiskt uppdateringar för tredjepartskomponenter som levereras av Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Installera systempaketens uppdateringar automatiskt',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Observera att detta installerar automatiskt uppdateringar för tredjepartskomponenter som levereras av Plesk',
    'update-settings.installerProxyMode' => 'Kom åt Plesk Installer via Plesks värdnamn och port',
    'update-settings.installerProxyModeHint' => 'Kom åt webbgränssnittet för Plesk Installer utan att behöva öppna ytterligare 8447 TCP-port i brandväggen.',
    'update-settings.automaticPatchesNotification' => 'Meddela tillgängliga och installerade uppdateringar för systempaket',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'E-postadress',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Meddelande om e-postfrekvens',
    'update-settings.daily' => 'Dagens',
    'update-settings.weekly' => 'Veckovis',
    'update-settings.generalSection' => 'Allmänt',
    'update-settings.notificationsSection' => 'Meddelanden',
    'update-settings.safeUpdatesSection' => 'Säkra uppdateringar',
    'update-settings.safeUpdatesSectionHint' => 'Plesk ser till att systempaketets uppdateringar installeras från samma katalog som paketen ursprungligen installerades från.Sådana uppdateringar anses säkra. Om du inaktiverar säkra uppdateringar, kan ditt systems pakethanterare installera uppdateringar från vilken katalog som helst i systemet.',
    'update-settings.safeUpdatesSectionWarn' => 'Vi rekommenderar att du lämnar säkra uppdateringar aktiverade om du inte är en avancerad användare. Okontrollerade uppdateringar av systempaket från olika kataloger kan påverka serverns funktion negativt.',
    'update-settings.allowSafeUpdates' => 'Aktivera säkra uppdateringar för systempaket',

    'requiredFields' => 'Obligatoriska fält',

    'ip-ban.banned-ip.ipAddress' => 'IP-adress',
    'ip-ban.banned-ip.hintIpAddress' => 'En IP-adress eller CIDR-mask.',
    'ip-ban.banned-ip.banType' => 'Bannlys IP-adressen: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'I en vecka',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Permanent',

    'server-mail-smarthost.settings.title' => 'Smarthost-inställningar',
    'server-mail-smarthost.settings.useSmarthost' => 'Skicka e-post till användare via en smarthost',
    'server-mail-smarthost.configuration.title' => 'Smarthost-konfiguration',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Värddatornamn eller IP-adress',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'För att inaktivera MX- eller SRV-sökningar, ange värdnamn eller IP-adress i hakparenteser, till exempel: [example.com]',
    'server-mail-smarthost.configuration.checkConnection' => 'Kontrollera anslutning',
    'server-mail-smarthost.configuration.port' => 'Port',
    'server-mail-smarthost.configuration.username' => 'Användarnamn',
    'server-mail-smarthost.configuration.password' => 'Lösenord',
    'server-mail-smarthost.configuration.encryption' => 'Krypterad anslutning',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Obligatoriskt',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'Krävs inte',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Ingen',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Autentisering krävs',
    'server-mail-smarthost.configuration.checkConnection.success' => 'Anslutning till smarthost har upprättats.',
    'server-mail-smarthost.success' => 'Smarthost-konfigurationen har ändrats.',
    'server-mail-smarthost.settings.noteTitle' => 'Obs:',
    'server-mail-smarthost.settings.note' => '%%title%% Om du ställer in sändning av e-post via en smarthost, måste du manuellt uppdatera SPF och andra relaterade DNS-poster i DNS-mallen och i DNS-zonerna för existerande domäner. Det är nödvändigt för att förhindra verifieringsfel för e-post som skickas via smarthost. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'Läs mer info.',
];