<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Hozzáférés megtagadva. Felfüggesztették a fiókját.",
    'login_up__login_has_been_locked' => "Túl sokszor próbálkozott helytelen jelszó használatával bejelentkezni. Biztonsági okokból nem tud egy ideig e felhasználónévvel bejelentkezni.",
    'login_up__unable_to_check_pass' => "A jelszó ellenőrzése nem lehetséges: %1",
    'login_up__warning_limits_licence_key' => "A következő paraméterek egyikénél licenckulcs korlát túllépés történt: felhasználói fiókok, domainek, postafiókok vagy a kiszolgálóján üzemeltetési szolgáltatásban részesített webes felhasználók száma.\nForduljon a Plesk értékesítési részlegéhez olyan kulcs vásárlása érdekében, mely lehetővé teszi a kívánt számú felhasználói fiók és domain üzemeltetését. Forduljon a Plesk műszaki támogatási részlegéhez, ha úgy gondolja, hogy tévedésből kapta ezen üzenetet.\nA felhasználói fiókok, domainek/postafiókok/webes felhasználók/nyelvi csomagok számának licenckorlátjai: %2.\nA jelenleg üzemeltetett felhasználói fiókok, domainek/postafiókok/webes felhasználók/nyelvi csomagok száma: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Nem lehet bejelentkezni. Probléma van a Plesk kiszolgáló licencével. Próbálja meg újra vagy forduljon a kiszolgáló adminisztrátorához.",
    'login_up__grace_period' => 'Terméklicence türelmi idejét tölti jelenleg. A terméklicence frissítéséhez válassza ki %1License Information page%2 Kulcsok beolvasása beállítását.',
    'login_up__partner_license_message' => 'Jelenleg olyan korlátozott terméklicencet használ, mely a teljes szolgáltatáskészlet aktiválása előtt regisztrációt igényel. A terméklicence frissítéséhez válassza ki %1License Information page%2 Kulcsok beolvasása beállítását.',
    'login_up__system_admin_disabled' => 'Biztonsági okokból tilos a felügyelőnek (adminisztrátor számla) a Plesk kezelőpanelbe bejelentkeznie.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk Adminisztrátor útmutató",
    'plesk_guide_reseller' => "Plesk Viszonteladó útmutató",
    'plesk_guide_client' => "Plesk Ügyfél útmutató",
    'plesk_guide_domain_admin' => "Plesk Domain adminisztrátor útmutató",
    'plesk_guide_mailuser' => "Plesk E-mail felhasználói útmutató",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Keresés', // multiple usage: TBI
    'nav__general' => 'Főmenü',
    '__home' => 'Kezdőlap',
    '__applications' => 'Alkalmazások',
    '__settings' => 'Beállítások',
    'nav__system' => 'Rendszer',
    '__master' => 'Fölérendelt',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Egy szinttel feljebb',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Eltávolítás',
    'bt_make_default' => 'Beállítás alapértelmezettként',

    // common list object search keys
    'bt_show_all' => "Keresés visszaállítása",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktív',
    '__object_off' => 'Felfüggesztve',

    '__home_description' => 'Vissza a Kezdőlapra.',
    'indicator_title' => '%1% használt, %2% szabad', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'Érvénytelen URL-cím kérelmezése történt.',

    // business objects
    'mn_list__mail_names_for_client' => '%1 felhasználói számla postafiókjai',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Név',
    'domains_list__state__filter_title' => 'Erőforrás-használat',
    'domains_list__filter_state_any' => 'Bármely típusú',
    'domains_list__filter_state_overuse' => 'Túlhasználat',
    'domains_list__filter_state_normal' => 'Korlátokon belül',
    'domains_list__status__filter_title' => 'Állapot',
    'domains_list__filter_status_any' => 'Bármely típusú',
    'domains_list__filter_status_blocked' => 'Felfüggesztve',
    'domains_list__filter_status_active' => 'Aktív',
    'domains_list__subrows__filter_title' => 'Megjelenítés',
    'domains_list__subrows_off' => 'Csak domainek',
    'domains_list__subrows_subdomain_domainaliases' => 'Aldomainekkel és aliasokkal',
    'domains_list__subrows_subdomain' => 'Aldomainekkel',
    'domains_list__subrows_domainaliases' => 'Aliasokkal',

    // objects list
    'domains_list__owner__title' => 'Tulajdonos',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Alkalmazások keresése",
    'site_apps__promo_main_text' => "Az Alkalmazás csomagolási szabvány azaz Application Packaging Standard (APS) katakógus tartalmazza egy domainbe vagy webtárhelyre telepíthető alkalmazások listáját. Ha olyan alkalmazásokat akar telepíteni, melyek jelenleg nem szerepelnek a katalógusban, akkor ezt könnyen megteheti a www.apsstandard.com címen található APS csomagolási útmutatások segítségével.",
    'site_apps__promo_download_now' => "Alkalmazások letöltése:",
    'site_apps__promo_close' => "E blokk bezárása",
    'site_apps__promo_preset__mostused' => 'Legnépszerűbb %1',
    'site_apps__promo_preset__lessused' => 'További legnépszerűbb %1',
    'site_apps__promo_preset__all' => "Az összes",
    'site_apps__promo_disclaimer_note' => 'Ne feledkezzen meg arról, hogy harmadik felek biztosították az APS-katalógusból telepített alkalmazásokat, továbbá azt, hogy a Plesk nem támogatja azokat.',
    'site_apps__promo_preset__page_title' => '%1 APS-alkalmazások',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Alkalmazások hozzáadása',

    // Errors
    'site_apps__no_applications_for_update' => 'Nincsenek telepített alkalmazások az Alkalmazástárolóban.',
    'site_apps__incorrect_download_preset_configuration' => 'Hibákat találhatóak az APS-katalógus konfiguráció letöltési előbeállításban.',
    'site_apps__aps_catalog_url_is_invalid' => 'Nem érvényes a megadott URL-cím.',
    'site_apps__no_updates_at_the_moment' => 'Jelenleg nem állnak alkalmazás frissítések rendelkezésre.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Helytelen adatok érkeztek az APS alkalmazás katalógustól. Később próbálja meg újból.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Mentésre kerültek az APS-katalógus beállítások, de a Plesk nem tud kapcsolatot létesíteni az APS-katalógus beállításoknál (%1) megadott APS-katalógussal. Ellenőrizze, hogy helyes-ezen APS-katalógus címe, és működik-e APS-katalógus e címen.',
    'site_apps__cannot_retrieve_updates' => 'Jelenleg nem lehet alkalmazásokat letölteni: nem lehet kapcsolatot létesíteni az APS-katalógussal (%1). Ellenőrizze, hogy helyes-ezen APS-katalógus címe, és működik-e APS-katalógus e címen.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Nem állnak telepítés céljára webalkalmazások rendelkezésre.',
    'site_apps__site_applications_already_installed_in_root' => 'Egyéb webalkalmazások már telepítve vannak e virtuális állomások gyökérkönyvtáraiba.',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET webalkalmazás nem támogatott Unix/Linux platformon.",
    'site_apps__server_wide_packages_not_supported' => 'Nem támogatottak az egész kiszolgálóra érvényes alkalmazások.',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 további webalkalmazást ütemeztek az Alkalmazástárolóhoz adásra.",
    'site_apps__applications_all_in_vault' => "A kiválasztott webalkalmazások már szerepelnek az Alkalmazástárolóban.",
    'site_apps__applications_already_in_download_queue' => "%1 kiválasztott webalkalmazások Alkalmazástárolóhoz adása éppen folyik.",
    'site_apps__applications_already_in_valut' => "%1 kiválasztott webalkalmazások már az Alkalmazástárolóban vannak.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Más (nem kategorizált)',

    // Errors
    'site_apps__no_applications_in_category' => 'Nem állnak rendelkezésre e kategóriába tartozó alkalmazások. Válasszon másik kategóriát.',
    'site_apps__no_category_selected__please_specify' => 'A bal oldali menüből válasszon ki egy kategóriát. Ezen ablakban jelenik meg a kiválasztott kategória összes rendelkezésre alkalmazásának listája.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Adminisztrátor számla',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Általános',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Állomásnév módosítása',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Biztonság',
    'bt_setup_firewall' => 'Tűzfal beállítása',
    'bt_manage_firewall_rules' => 'Tűzfalszabály kezelése',
    'cu_firewall__rule' => 'Hozzon létre egy tűzfal szabályt.',
    'cu_firewall__protocol' => 'Állítson be egy protokollt a szabály számára (\'tcp\' vagy \'udp\')',
    'cu_firewall__name' => "Állítson be egy szabálynevet.",
    'cu_firewall__disabled' => 'Ha \'true\', akkor létrehozás a után letiltásra kerül a szabály.',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'DNS-kiszolgáló kiválasztása', // PFW
    'bt_soa_records_template' => 'SOA-rekord sablon',
    'bt_restrict_creation_of_subzones' => 'Alzónák létrehozásának korlátozása',

    'databases' => 'Adatbázisok',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Alkalmazások',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-mail',
    'bt_select_mailserver' => 'Levelező kiszolgáló kiválasztása', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Víruskereső kiválasztása', // PFW
    'bt_virus_protection_settings' => 'Vírusvédelmi beállítások',
    'bt_select_spamfilter' => 'Levélszemét szűrő kiválasztása', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Webes levelezés kiválasztása',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Naplók és statisztikák',
    'bt_server_statistics_settings' => 'Kiszolgálóstatisztika beállítások',
    'bt_select_web_statistics' => 'Rendelkezésre álló webr kiválasztása', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk kezelőfelület',

    'components_and_modules' => 'Összetevők és modulok',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'VPN beállítása', // PFU
    'bt_setup_samba' => 'Samba beállítása',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Domain adminisztrátor számla',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Számla beállításai',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'DNS SOA-rekordok',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Feladatütemező beállítások',

    'website' => 'Webhely',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Webes felhasználó parancsprogram-kezelés',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'SSL/TLS-tanúsítvány kiválasztása',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webstatisztikák',
    'bt_log_rotation_settings' => 'Napló rotáció beállítások',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Korlátok", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Túlhasználati és túlértékesítési házirend",
    'limits__overuse_policy_legend' => "Túlhasználat",
    'limits__oversell_policy_legend' => "Túlértékesítés",
    'limits__reseller_overuse_description' => "A túlhasználati házirend szabja meg a Plesk kezelőpanel számára az erőforrás túlhasználat esetén a teendőket.",
    'limits__overuse_text' => "Túlhasználati házirend",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Lemezterület és forgalom',
    'limit__disk_space' => 'Lemezterület',
    'limit__max_traffic' => 'Forgalom',
    'limit_group__client' => 'Ügyfelek',
    'limit__max_cl' => 'Ügyfelek',
    'limit_group__domain' => 'Domainek',
    'limit__max_dom' => 'Domainek',
    'limit__max_dom_powerUser' => 'Előfizetések',
    'limit__max_subdom' => 'Aldomainek',
    'limit__max_dom_aliases' => 'Domain aliasok',
    'limit__max_wu' => 'Webes felhasználók',
    'limit__max_subftp_users' => 'További FTP-fiókok', // PFW
    'limit_group__mail' => 'E-mail',
    'limit__max_box' => 'Postaládák',
    'limit__mbox_quota' => 'Postaláda méret',
    'limit__total_mboxes_quota' => 'Összes postaláda kvóta', // PFW
    'limit__max_maillists' => 'Levelezési listák',
    'limit_group__database' => 'Adatbázisok',
    'limit__max_mssql_db' => 'Microsoft SQL-kiszolgáló adatbázisok', // PFW
    'limit__mssql_dbase_space' => 'Összes MS SQL-adatbázis kvóta', // PFW
    'limit__max_odbc' => 'ODBC-kapcsolatok', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL-adatbázis kvóta', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL adatbázis kvóta', // PFW
    'limit_group__application' => 'Alkalmazások',
    'limit__max_iis_app_pools' => 'IIS-alkalmazási készlet', // PFW
    'limit_group__security' => 'Biztonság',
    'limit_group__validity' => 'Lejárati dátum',
    'limit__expiration' => 'Lejárati dátum',
    'limit__validity' => 'Érvényességi időszak',
    'limit__max_site_builder' => 'Presence Builder weboldalkészítő segítségével létrehozott webhelyek',
    'limit__max_site' => 'Domainek',
    'limit__mssql_dbase_filesize' => 'MS SQL-adatbázisfájl mérete',
    'limit__mssql_dbase_log_filesize' => 'MS SQL-adatbázis naplófájl mérete',
    'limit__mssql_dbase_filesize_hint' => 'Egy Microsoft SQL-adatbázisfájl maximális mérete.',
    'limit__mssql_dbase_log_filesize_hint' => 'Egy Microsoft SQL-adatbázis naplófájl maximális mérete.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Érvénytelen domain korlát. 1 a minimális érték.',

    'property__has_wrong_value' => 'Helytelen %1 tulajdonság értéke.',
    'property__name_outgoing_messages_domain_limit' => 'Egy domain alapértelmezett kimenő üzenet (óránként) korlátját állítja be. Korlátlan érték beállításához a „-1” értéket adja meg. Az egész kiszolgálóra érvényes beállítások kiválasztására az „Alapértelmezett” értéket adja meg.',
    'property__name_outgoing_messages_mbox_limit' => 'Egy postaláda alapértelmezett (óránként) kimenő üzenet korlátját állítja be. Korlátlan érték beállításához a „-1” értéket adja meg. Az egész kiszolgálóra érvényes beállítások kiválasztására az „Alapértelmezett” értéket adja meg.',
    'property__name_outgoing_messages_subscription_limit' => 'Beállítja az egy előfizetésből származó kimenő üzenet korlátot (óránként). Korlátlan érték beállításához a „-1” értéket adja meg. Az egész kiszolgálóra érvényes beállítások kiválasztására az „Alapértelmezett” értéket adja meg.',

    // for CLI report & email notifications
    '__resource_notify' => 'Értesítés',
    '__general' => 'Általános',
    '__template_shared' => 'Megosztott sablon',
    'limit__overuse' => 'Túlhasználati házirend',
    'limit__max_traffic_soft' => 'Értesítsen a forgalmi kihasználtsági érték elérésekor.',
    'limit__disk_space_soft' => 'Értesítsen a lemezterület használati érték elérésekor.',
    '__overuse' => 'Túlhasználati házirend',
    'performance__title' => 'Teljesítmény',
    'performance__bandwidth' => 'Maximális használt sávszélesség (kB/s)',
    'performance__max_connections' => 'A következőre korlátozott a kapcsolatszám',

    'gch__hosting_php_isapi' => 'PHP ISAPI-bővítménykénti futtatása',
    'gch__hosting_ssi_html' => 'SSI használata *.htm, *.html fájlokhoz',
    'gch__hosting_php_handler_type' => 'PHP következőkénti futtatása',
    'gch__hosting_php_handler_id' => 'PHP következőkénti futtatása',
    'gch__hosting_php_served_by_nginx' => 'nginx PHP-kiszolgáló',
    'gch__hosting_unpaid_website_status' => 'Webhelyek állapota felfüggesztett előfizetések esetén',
    'gch__mn_no_autoresponder' => 'Nincs automatikus válaszadás beállítva a postaláda számára.',
    'gch__no_clients_selected' => "Nincsenek ügyfélszámlák kiválasztva.",
    'gch__no_domains_selected' => "Nincsenek kijelölt domainek",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/hónap",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Erőforrás neve',
    '__resource_usage' => 'Használt',
    '__resource_limit' => 'Korlát',

    '__never_expires' => 'Sohase jár le',
    '__resource_free' => '%1 / %2 szabad',
    '__resource_unlimited' => '%1 felhasználva a korlátlanból',

    '__unlimited' => 'Korlátlan',
    '__increment' => "Növelés (+)",
    '__decrement' => "Csökkentés (-)",
    '__pt' => 'egységek',
    '__procent' => '%',
    '__overused' => 'Túlzott mértékben használt',
    '__left' => 'balra',
    '__available' => 'rendelkezésre áll',
    '__not_available' => 'Nem tartalmazza',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Viszonteladó neve', // reseller report
    'report__full_client_name' => 'Ügyfél neve', // customer report
    'report__full_domain_name' => 'Domain név', // domain report
    'report__full_owner' => 'Tulajdonos', // customer & domain reports
    'report__full_creation_date' => 'Létrehozási dátum',
    'report__full_size' => 'Méret',
    'report__full_traffic' => 'Forgalom',
    'report__full_active_clients' => 'Aktív ügyfelek', // reseller report
    'report__full_clients' => 'Ügyfelek', // reseller report
    'report__full_active_domains' => 'Aktív domainek', // reseller & customer reports
    'report__full_domains' => 'Domainek', // reseller & customer reports
    'report__full_subdomains' => 'Aldomain',
    'report__full_mboxes' => 'Postaládák',
    'report__full_disk_space' => 'Lemezterület',
    'report__full_mail_groups' => 'Levél átirányítás',
    'report__full_mail_autoresp' => 'Válasz',
    'report__full_mail_antispam' => 'Levélszemét elleni védelem',
    'report__full_mail_antivirus' => 'Vírusvédelem',
    'report__full_mail_lists' => 'Levelezési lista',
    'report__full_web_users' => 'Webes felhasználó',
    'report__full_mysql_databases' => 'MariaDB/MySQL adatbázis',
    'report__full_mssql_databases' => 'MSSQL adatbázis',
    'report__full_pgsql_databases' => 'PostgreSQL adatbázid',

    // common summary report
    'report__section_general' => 'Általános',
    'report__version' => 'Termék verziószáma',
    'report__build' => 'Termék buildszáma',
    'report__status' => 'Állapot',
    'report__company_name' => 'Cégnév',
    'report__personal_name' => 'Név',
    'report__login' => 'Felhasználónév',
    'report__phone' => 'Telefonszám',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Cím',
    'report__city' => 'Város',
    'report__state' => 'Állam/megye.',
    'report__zip_code' => 'Irányítószám',
    'report__country' => 'Ország',
    'report__creation_date' => 'Létrehozási dátum',
    'report__expiration_date' => 'Lejárati dátum',
    'report__dumps_total_size' => 'Biztonsági másolat fájlok összmérete',
    'report__section_resellers' => 'Viszonteladók',
    'report__active_resellers' => 'Aktív előfizetéssel rendelkező viszonteladók',
    'report__resellers' => 'Viszonteladók',
    'report__section_full_resellers' => 'Viszonteladók',
    'report__section_clients' => 'Ügyfelek',
    'report__active_clients' => 'Aktív előfizetéssel rendelkező ügyfelek',
    'report__clients' => 'Ügyfelek',
    'report__section_full_clients' => 'Ügyfelek',
    'report__section_personal_clients' => 'Saját ügyfelek',
    'report__active_personal_clients' => 'Aktív előfizetéssel rendelkező saját ügyfelei',
    'report__personal_clients' => 'Saját ügyfelek',
    'report__section_full_personal_clients' => 'Saját ügyfelek',
    'report__section_domains' => 'Domainek',
    'report__disk_usage' => 'Lemezhasználat',
    'report__traffic' => 'Forgalom',
    'report__active_domains' => 'Aktív domainek',
    'report__domains' => 'Domainek',
    'report__subdomains' => 'Aldomainek',
    'report__mboxes' => 'Postaládák',
    'report__mail_groups' => 'Levéltovábbítások',
    'report__mail_autoresp' => 'Automatikus válaszok',
    'report__mail_lists' => 'Levelezési listák',
    'report__web_users' => 'Webes felhasználók',
    'report__mysql_databases' => 'MariaDB/MySQL-adatbázisok',
    'report__mssql_databases' => 'MSSQL-adatbázisok',
    'report__pgsql_databases' => 'PostgreSQL adatbázisok',
    'report__section_full_domains' => 'Domainek',
    'report__section_personal_domains' => 'Személyes domainek',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Személyes domainek',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Presence Builder weboldalkészítő segítségével létrehozott webhelyek',
    'report__invalid_email' => 'Egy érvényes e-mail címet adjon meg.',


    // CLI-specific sections
    'report__section_hosting' => 'Üzemeltetés',
    'report__section_webusers' => 'Webes felhasználók',
    'report__section_mailnames' => 'Postafiókok',
    'report__section_maillists' => 'Levelezési listák',
    'report__section_databases' => 'Adatbázisok',
    'report__section_siteapps' => 'Webalkalmazások',
    'report__section_aspnetapps' => 'ASP.NET alkalmazások', // PFW
    'report__owner_pname' => "Szolgáltató neve",
    'report__owner_login' => "Szolgáltató felhasználóneve",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Telepítve van, de nincs engedélyezve e rendszerben a megadott nyelvi csomag.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'Lejárt a munkamenet jogkivonata.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'A következő viszonteladói számlák ügyfélszámlákká alakítására kerül sor.',
    'downgradeResellers__downgrade' => 'Nem kerülnek átalakításra a viszonteladói számlák.',
    // controls
    'downgradeResellers__submit_downgrade' => 'Végezzen számla átalakítást.',
    'downgradeResellers__cancel_downgrade' => 'Törölje a számla átalakítást.',
    'downgradeResellers__confirm' => 'Átalakítás megerősítése',
    'downgradeResellers__confirm_message' => 'Erősítse meg a számla átalakítást a folytatáshoz.',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'A következő ügyfélszámlák viszonteladói számlákká kerülnek átalakításra.',
    'upgradeClients__upgrade' => 'Átalakításra kerülő ügyfélszámlák',
    // controls
    'upgradeClients__submit_upgrade' => 'Végezzen számla átalakítást.',
    'upgradeClients__cancel_upgrade' => 'Törölje a számla átalakítást.',
    'upgradeClients__confirm' => 'Átalakítás megerősítése',
    'upgradeClients__confirm_message' => 'Erősítse meg a számla átalakítást a folytatáshoz.',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Nem lehetséges \'%1\' viszonteladói számlává alakítása: \'%1\' már egy viszonteladói számla.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'A következő domain adminisztrátor számlák ügyfélszámlákká kerülnek átalakításra:',
    'upgradeDomainUser__upgrade' => 'Átalakítandó domain adminisztrátor számlák',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Végezzen számla átalakítást.',
    'upgradeDomainUser__cancel_upgrade' => 'Törölje a számla átalakítást.',
    'upgradeDomainUser__confirm' => 'Átalakítás megerősítése',
    'upgradeDomainUser__confirm_message' => 'Erősítse meg a számla átalakítást a folytatáshoz.',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Az át nem alakítható domain adminisztrátor számlák',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'A következő domain adminisztrátor számlák nem alakíthatóak át ügyfélszámlákká:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Több domain adminisztrátor számla nem alakítható át ügyfélszámlákká: %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'A domain adminisztrátor számla nem létezik.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Közvetlenül a kiszolgáló adminisztrátorhoz vagy egy viszonteladóhoz kell a domainnek tartoznia.",
    'upgradeDomainUser__all_logins_already_used' => 'Nem lehetséges létrehozni egy számlát az eredményül adódó ügyfél számára.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'A domain adminisztrátor számla átalakításra került.',
    'upgradeDomainUser__upgrade_notification_body' => '\'%%login%%\' felhasználónévvel és \'%%password%%\' jelszóval került ügyfélszámlává átalakításra a domain adminisztrátor számlája.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Nem rendelkezik \'%1\' engedéllyel a kiválasztott viszonteladó , de egyes ügyfelek rendelkeznik ilyen engedéllyel.',
    'clientOwnerChanger__application_not_allowed' => '\'%1\' alkalmazás nem áll rendelkezésre a kiválasztott viszonteladó számára, de rendelkezésre áll egyes ügyfelek számára.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maximális használt sávszélesség (%1)',
    'hosting_performance__max_connection_label' => 'A következőre korlátozott a kapcsolatszám',
    'performance__invalid_value' => "Érvénytelen az érték. %1 és %2 közötti tartományba kell esnie.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webes levelezés',
    'webmail__server_text' => 'Rendelkezésre álló webes levelezési ügyfelek',
    'webmail__none' => 'Nincs',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Kiszolgáló IP-cím készlete',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Kiszolgáló biztonsági másolat.",
    '__default_backup_comment_reseller' => "%1 szerinti viszonteladói számla biztonsági másokat készült.",
    '__default_backup_comment_client' => "%1 szerinti ügyfélszámla biztonsági másolat készült.",
    '__default_backup_comment_domain' => "%1 szerinti előfizetés biztonsági másolat készült.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "%1 ügyfél IP-cím készlete",
    'backup__ip_mapping__resellers_ip' => "%1 viszonteleadó IP-cím készlete",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtuális állomás',
    'backup__restore__object_plesk_admin' => 'Plesk adminisztrátor',
    'backup__restore__object_ftpuser' => 'FTP-fiók',
    'backup__restore__object_frontpageuser' => 'Frontpage fiók',
    'backup__restore__object_webuser' => 'webes felhasználó',
    'backup__restore__object_domain' => 'domain',
    'backup__restore__object_subdomain' => 'aldomain',
    'backup__restore__object_domainalias' => 'domain aliasnév',
    'backup__restore__object_client' => 'ügyfél',
    'backup__restore__object_reseller' => 'viszonteladó',
    'backup__restore__object_autoresponder' => 'automatikus válasz',
    'backup__restore__object_mailalias' => 'e-mail aliasnév',
    'backup__restore__object_database' => 'adatbázis',
    'backup__restore__object_mailname' => 'postafiók',
    'backup__restore__object_db_user' => 'adatbázis felhasználó',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-tanúsítvány',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Nem állíthatóak vissza a következő viszonteladók, mivel ügyfelekre változtatták őket: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Nem állíthatóak vissza a következő ügyfelek, mivel viszonteladókra változtatták őket: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Nem állíthatóak vissza a következő ügyfelek, mivel más tulajdonoshoz helyezték át őket: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Nincs elegendő lemezterület a célkiszolgálón az összes kiválasztott előfizetés áttelepítésére. Rendelkezésre áll: %1 MB. Szükséges: %2 MB. Megjegyzés: A web, levelezés és az adatbázis tartalmak összegeként került kiszámításra a szükséges terület. Naponta történik ennek a kiszámítása és a gyorsítótárban van tárolva, így a domainek aktuális mérete eltérhet a számított mérettől. Ha biztos abban, hogy a kiválasztott domainek nem foglalnak el a rendelkezésre állónál nagyobb lemezterület, akkor folytathatja az áttelepítést.',
    'backup__restore__capability_not_enough_disk_windows_text' => '\'%1’ lemezen nincs elegendő lemezterület a cél kiszolgálón az összes kiválasztott előfizetés áttelepítésére. Rendelkezésre áll: %2 MB. Szükséges: %3 MB. Megjegyzés: A számított szükséges terület a web, levelezés és az adatbázis tartalmak összegeként került kiszámításra. Naponta történik ennek a kiszámítása és a gyorsítótárban történik a tárolása, így a domainenek aktuális mérete eltérhet a számított mérettől. Ha biztos abban, hogy a kiválasztott domainek nem foglalnak el a rendelkezésre állónál nagyobb lemezterület, akkor folytathatja az áttelepítést.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Az áttelepítés folytatásához, a célkiszolgálóm szabadítson fel lemezterületet.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Nincs elegendő lemezterület a forráskiszolgálón az ideiglenes fájlok átvitelhez történő tárolására. Rendelkezésre áll: %1 MB. Szükséges: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Szabadítson fel lemeztetületet a forráskiszolgálón.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Kiszolgáló adatai',

    'backup__restore__capability_not_installed_component_text' => '%1 összetevő nincs telepítve a célkiszolgálón. %1 nem áll rendelkezésre az összes visszaállított objektumon.',
    'backup__restore__capability_not_installed_component_resolution' => 'Végezze el %1 telepítését. Ne feledkezzen meg arról, hogy ez néhány percig eltarthat.',
    'backup__restore__capability_existing_sys_user_text' => '%1 rendszerfelhasználó már létezik a célkiszolgálón.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Nevezze át a meglévő rendszerfelhasználót a célkiszolgán.',
    'backup__restore__capability_license_usage_text' => 'A következő (licenckulcsban meghatározott) erőforrás korlátok kerülnek a célkiszolgálón túllépésre az adatátvitel után:',
    'backup__restore__capability_license_usage_resolution' => 'A szükséges erőforrás mennyiséget biztosító licenckulcsot telepítse a célkiszolgálóra.',
    'backup__restore__capability_max_allowed_packet_text' => "%1 a 'max_allowed_packet' paraméter forrás adatbázis-kiszolgálón, mely nagyobb a célkiszolgáló %2 értékénél. Előfordulhat, hogy nem állíthatóak vissza az alább megadott domainek néhány adatbázis objektuma.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Növelje a 'max_allowed_packet' értéket a cél adatbázis-kiszolgálón.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Nem lehet a PostgreSQL adatbázisok átvitelét elvégezni, mivel a célkiszolgáló PostgreSQL verziója krábbi a forráskiszolgáló verziójánál. %1 az aktuális verzió, %2 a szükséges verzió.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'A szükséges PostgreSQL verziót telepítse a célkiszolgálóra.',
    'backup__restore__capability_db_server_connection_problems' => 'Nem lehet kapcsolódni a cél PostgreSQL adatbázis-kiszolgálóhoz. A kapcsolat visszaállítása nélkül nem kerülnek árvitelre az adatbázisok..',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Ellenőrizze a cél adatbázis-kiszolgáló kapcsolódási beállításait.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Nincs aktiválva %1 összetevő a célkiszolgálón.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Végezze el %1 aktiválását a célkiszolgálón.',
    'backup__restore__capability_not_configured_component_text' => '%1 összetevő nincs konfigurálva a célkiszolgálón.',
    'backup__restore__capability_not_configured_component_resolution' => 'Végezze el %1 konfigurálását az Eszközök és beállítások oldalon.',

    'backup__restore__capability_webmail_is_not_available' => '%1 webes levelezés szolgáltatás nem áll rendelkezésre a célkiszolgálón. Ehelyett a következő webes levelezés szolgáltatást használja a Plesk: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'A forráskiszolgálóéval megegyező webes levelezés használatához telepítenie kell e kiszolgálóra.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'A forráskiszolgálóéval megegyező webes levelezés használatához telepítenie kell azt a célkiszolgálóra.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1' webes levelezés szolgáltatás nem áll rendelkezésre a célkiszolgálón. Ehelyett a következő előfizetések esetében: %3, a következő webes levelezés szolgáltatást használja a Plesk: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Telepítse a levelezést a célkiszolgálóra.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webes levelezési beállítások',

    'backup__restore__capability_shell_is_not_available' => '%1 héj nem áll rendelkezésre a célkiszolgálón. Helyette az egyik rendelkezésre álló héj kerül felhasználásra.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'A forráskiszolgálóéval megegyező héj használatához aktiválnia azt (az /etc/ héjakban) vagy telepítenie kell a célkiszolgálóra.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'A cél DNS-kiszolgáló nem támogatja az Átvitel korlátozás sablonban szereplő hálózatokat. Nem kerülnek visszaállításra a DNS átvitel korlátozásban szereplő hálózati IP-című rekordok.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'A cél DNS-kiszolgáló nem támogatja az Átvitel korlátozás sablonban szereplő hálózatokat, de néhány előfizető rendelkezhet DNS átvitel korlátozásban szereplő hálózatokkal. Nem kerülnek visszaállításra a DNS átvitel korlátozásban szereplő hálózati IP-című rekordok.',

    'backup__restore__capability_wrong_php_handler_text' => '%1 PHP-kezelő nem áll rendelkezésre a célkiszolgálón. Ehelyett a következő PHP-kezelőt használja a Plesk: %2.',
    'backup__restore__capability_no_php_handler_text' => '%1 PHP-kezelő nem áll rendelkezésre a célkiszolgálón.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Ugyanolyan PHP-kezelő használatához a forráskiszolgálón aktiválnia vagy telepítenie kell azt a célkiszolgálón.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => '%1 PHP-kezelő nem áll rendelkezésre. Ehelyett a következő szolgáltatási csomagok esetében %2 kerül alkalmazásra a Plesk kezelőpanelben: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => '%1 PHP-kezelő nem áll rendelkezésre. Ehelyett a következő webhelyek esetében %2 kerül alkalmazásra a Plesk kezelőpanelben: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => '%1 PHP-kezelő nem áll rendelkezésre. Nem áll a következő webhelyek rendelkezésére: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 nem áll rendelkezésre a célkiszolgálón. Helyette z alapértelmezett verzió használata történik.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Ugyanolyan %1 használatához a forráskiszolgálón aktiválnia vagy telepítenie kell azt a célkiszolgálón.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'A célkiszolgáló víruskereső használati házirendje kimenő levelek esetén nem egedélyezi személyes (e-mail címenkénti) víruskereső beállítások használatát. Nem kerülnek átvitelre e beállítások.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'A célkiszolgáló víruskereső használati házirendje bejövő levelek esetén nem egedélyezi személyes (e-mail címenkénti) víruskereső beállítások használatát. Nem kerülnek átvitelre e beállítások.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'A célkiszolgáló víruskereső használati házirendje nem egedélyezi személyes (e-mail címenkénti) víruskereső beállítások használatát. Nem kerülnek átvitelre e beállítások.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Személyes (e-mail címenkénti) víruskereső beállítások átvitelére aktiválja az Eszközök és beállítások > Vírusvédelmi beállítások > megfelelő beállításait.",
    'backup__restore__capability_antivirus_not_active_text' => 'Nincs víruskereső szoftver bekapcsolva. Addig nincs aktiválva a forráskiszolgáló összes víruskereső beállítása, amíg ki nem választja a célkiszolgálón a víruskereső szoftvert.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Jelölje ki a víruskereső szoftvert az Eszközök és beállítások > Vírusvédelmi beállítások > Víruskereső beállítások menüpontnál.',

    'backup__restore__capability_antivirus_another_active_text' => '%2 víruskereső szoftver nem áll rendelkezésre a célkiszolgálón. %1 kerül helyette felhasználásra.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'A forráskiszolgálóével megegyező víruskereső használatához telepítse azt, majd jelölje ki az Eszközök és beállítások > Vírusvédelmi beállítások > Víruskereső beállítások menüpontot.',
    'backup__restore__capability_not_available_sni_text' => 'SNI nem áll rendelkezésre a célkiszolgálón. A megegyező IP-című webhelyek nem lesznek képesek egyébi SSL/TLS-tanúsítványok használatára.',
    'backup__restore__capability_not_available_sni_resolution' => "Ellenőrizze, hogy a célkiszolgáló operációs rendszere támogatja-e az SNI-bővítményt és be van-e jelölve az SNI-támogatás a Plesk kezelőpanelen ('Az SNI-támogatás bejelölése, mely lehetővé teszi egyéni SSL/TLS-tanúsítványok használatát a megegyező IP-című webhelyeken.' jelölőnégyzet az Eszközök és beállítások > Kiszolgáló beállítások lapon).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Kiszolgáló beállítások',

    'backup__restore__capability_vhost_already_exists_text' => '%1 webhely nem vihető át: ugyanilyen nevű webhely már létezik a célkiszolgálón.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Nevezze át vagy távolítsa el a megegyező webhelyet a kiszolgálóról.',
    'backup__restore__capability_removed_vhosts' => 'A következő előfizetések nem kerülnek helyreállításra, mivel a célkiszolgálón már szereplő domain neveket tartalmaznak: %1',
    'backup__restore__capability_duplicate_php_handler_text' => '%3 különböző %1 típusú és %2 verziójú kiszolgáló található a forráskiszolgálón. Helyettük egy megfelelő típusú és verziójú kiszolgáló kerül felhasználásra a célkiszolgálón. Ne feledkezzen meg arról, hogy eltérhetnek a forrás- és célkiszolgáló PHP-beállításai.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Nem támogatja a Plesk Installer a Microsoft Frontpage alkalmazást.',
    'backup__restore__capability_not_installed_python_resolution' => 'Nem támogatja a Plesk Installer a Python használatát. Kézzel végezze a Python telepítését.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Levelezési kiszolgáló beállítások',

    'backup__restore__capability_ftps_disabled' => 'Engedélyezett a biztonságos FTPS-kapcsolat használata a forráskiszolgálón, de tiltott a célkiszolgálón. Előfordulhat, hogy nem működnek megfelelően az FTP használatával működő felhasználói alkalmazások.',
    'backup__restore__capability_ftps_required' => 'Engedélyezett a nem biztonságos FTP használata a forráskiszolgálón, de tiltott a célkiszolgálón. Előfordulhat, hogy nem működnek megfelelően az FTP használatával működő felhasználói alkalmazások.',
    'backup__restore__capability_ftps_policy_resolution' => 'Az Eszközök és beállítások > Biztonsági házirend menüpontban változtassa meg a biztonságos FTP-házirendet.',

    'backup__restore__capability_too_much_download_time_text' => '%2 órán belül %1 megabájt adat átvitele történik meg a forráskiszolgálóról a célkiszolgálóra.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Egy gyorsabb átvitel érdekében ellenőrizze a forrás- és célkiszolgáló közötti hálózati kapcsolatot, majd hárítsa el a hibákat (ha előfordulnak).',
    'backup__restore__too_low_download_speed' => "0,01-nél kisebb",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Egy gyorsabb átvitel érdekében ellenőrizze a forrás- és célkiszolgáló közötti hálózati kapcsolatot, majd hárítsa el a hibákat (ha előfordulnak).',
    'backup__restore__capability_zero_download_speed_text' => '%1 Mb/s a minimálisan elfogadható letöltési sebesség. 0 Mb/s a forrás- és célkiszolgáló közötti letöltési sebesség. Hálózati kapcsolati problémák okozhatják ezt. Átvitel nem lehetséges.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Ellenőrizze a forrás- és célkiszolgáló közötti hálózati kapcsolatot, majd hárítsa el a hibákat (ha előfordulnak).',
    'backup__restore__capability_too_slow_download_speed_text' => '%2 Mb/s a minimálisan elfogadható letöltési sebesség. %1 Mb/s a forrás- és célkiszolgáló közötti letöltési sebesség. Ez megnövelheti az átviteli időt. A jelenlegi körülményei között %4 óra szükséges %3 MB áttelepítésére.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => '%2 Mb/s a minimálisan elfogadható letöltési sebesség. %1 Mb/s a forrás- és célkiszolgáló közötti letöltési sebesség. Ez megnövelheti az átviteli időt.',

    'backup__restore__capability_remote_database_migration' => "A következő domainek használnak távoli adatbázisokat: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Ne távolítsa el átvitel után e domaineket kiszolgálóról, ha 11.5-nél régebbi a forráskiszolgálón a Plesk verziója! Ehelyett függessze fel azokat. Ha eltávolítja a domaineket, akkor az adatbázisok is eltávolításra kerülnekj a távoli kiszolgálóról. Megjegyzés: A távoli adatbázisok memóriakép fájljainak tárolása a forráskiszolgáló %1 könyvtárában történik.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Előforduéhat, hogy nem állíthatóak vissza az MySQL adatbázis-kiszolgáló 5.1 (%1) verziónál régebbi verzióval készült biztonsági másolat fájljai a MySQL 5.1.x verzióval, mivel a MySQL 5.1.x eltérően kezeli az Unicode karaktereket.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Olvassa el a kapcsolódó #136850 szűmú tudásbázis cikket.',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP nincs telepítve a célkiszolgálón.',
    'backup__restore__capability_courier_not_installed_resolution' => 'A Plesk Installer segítségével végezze a Courier-IMAP telepítését.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot nincs telepítve a célkiszolgálón.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'A Plesk Installer segítségével végezze a Dovecot telepítését.',

    'backup__restore__wrong_stat_ttl_value_text' => 'A következő objektumok esetében kisebb a forgalmi statisztika megőrzési ideje, mint a célkiszolgáló egész kiszolgálóra érvényes értéke.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Változtassa meg a célkiszolgáló egész kiszolgálóra érvényes statisztika megőrzési idő értékét. A domain konfiguráció legkisesebb értékével megegyező vagy annál kisebb időt állítson be.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Egyes szolgáltatási domainek esetében a forgalmi statisztikák megőrzési ideje rövidebb, mint az egész kiszolgálóra érvényes érték (%1). E domainek esetében %1 értékre történik a változtatás.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Egyes szolgáltatási csomagok esetében a forgalmi statisztikák megőrzési ideje rövidebb, mint az egész kiszolgálóra érvényes érték (%1). E szolgáltatási csomagok esetében %1 értékre történik a változtatás.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Egy kizárólagos IP-címnek megosztotthoz rendelése letiltja a névtelen FTP- és HTTPS-kapcsolatokat (SNI támogatás bekapcsolása nélkül).',

    'backup__restore__no_postgresql_commands_text' => 'Egy távoli PostgreSQL adatbázist használ az előfizetés és nem készíthető ideiglenes biztonsági másolat fájlja, mivel nem tudja a forráskiszolgáló a pg_dump és a psql parancsokat értelmezni.',
    'backup__restore__no_postgresql_commands_resolution' => 'Telepítse bármelyik olyan PostgreSQL ügyfélcsomagot, mely támogatja e parancsokat',
    'backup__restore__capability_apache_modules_disabled_text' => 'A következő Apache modulok le vannak tiltva a célkiszolgálón: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'A lehetséges problémák felmerülésének megakadályozására engedélyezze e modulok működését.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'A következő Apache modulok nincsenek telepítve a célkiszolgálón: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'A lehetséges problémák felmerülésének megakadályozására telepítse és engedélyezze e modulok működését.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Nem támogatja a licence a kimenő üzenet korlátozást. Nem kerülnek átvitelre a megfelelő konfigurációs beállítások.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'A szükséges funkciókat biztosító licenckulcsot telepítse a célkiszolgálóra.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Nincs aktiválv a kimenő üzenet korlát a célkiszolgálón. Nem kerülnek átvitelre a megfelelő konfigurációs beállítások.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Végezze el a kimenő üzenet korlát aktiválását a célkiszolgálón.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Egész kiszolgálóra érvényes levelezési beállítások',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'A célkiszolgálón használt levelezési kiszolgáló nem támogatja egy postafiókból kimenő üzenetek korlátozását. Nem kerül e korlát értéke átvitelre.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'A forráskiszolgálón használtal megegyezőre változtassa a levelezési kiszolgálót.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Egész kiszolgálóra érvényes levelezési beállítások',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'A célkiszolgálón használt levelezési kiszolgáló nem támogatja egy domainből kimenő üzenetek korlátozását. Nem kerül e korlát értéke átvitelre.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'A forráskiszolgálón használtal megegyezőre változtassa a levelezési kiszolgálót.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Egész kiszolgálóra érvényes levelezési beállítások',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'A célkiszolgálón használt levelezési kiszolgáló nem támogatja egy előfizetésből kimenő üzenetek korlátozását. Nem kerül e korlát értéke átvitelre.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'A forráskiszolgálón használtal megegyezőre változtassa a levelezési kiszolgálót.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Egész kiszolgálóra érvényes levelezési beállítások',

    'bu_conflict_resolver_absent_phosting' => 'Nem állíthatóak vissza a megadott fájlok, mivel nem létezik fizikai üzemeltetés a visszaállításukhoz. Először hozzon létre egy fizikai üzemeltetéssel rendelkező domaint, majd indítsa újra a biztonsági másolat visszaállítást.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Nem történik meg a viszonteladói adatok visszaállítása, mivel nem támogatott a viszonteladók kezelése.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'A ModSecurity összetevő nincs telepítve a célkiszolgálón.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Végezze el a ModSecurity telepítését, ha azt akarja, hogy továbbra is működjön a webalkalmazás tűzfala az átvitt helyek esetében. Ne feledkezzen meg arról, hogy a telepítés néhány percig eltarthat.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Végezze el a ModSecurity telepítését, ha át akarja vinni a webalkalmazás tűzfalának beállításait. Ne feledkezzen meg arról, hogy a telepítés néhány percig eltarthat.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'A ModSecurity összetevő nincs konfigurálva a célkiszolgálón.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Végezze el a ModSecurity konfigurálását, ha azt akarja, hogy továbbra is működjön a webalkalmazás tűzfala az átvitt helyek esetében.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall (ModSecurity) webalkalmazás',
    'backup__restore__capability_modsecurity_not_active_text' => 'Ki van kapcsolva a ModSecurity a célkiszolgálón.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktiválja a ModSecurity alkalmazást, ha azt akarja, hogy továbbra is működjön webalkalmazás tűzfala az átvitt helyek esetében.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall (ModSecurity) webalkalmazás',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Nincs telepítve a ModSecurity összetevő. Nem kerülnek visszaállításra a következő objektumok esetében a webalkalmazás tűzfal beállításai: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Nem állíthatóak vissza webhelyek, mivel nem található azon %1 előfizetés, mekyhez tartoznak a Plesk kezelőpanelen:",
    'bu_conflict_resolver_attend_websites_subscription' => "Nem állíthatóak vissza egyes webhelyek azonos nevű előfizetések léteznek: %1.",
    'backup__restore__capability_not_installed_dns_text' => '%1 összetevő nincs telepítve a célkiszolgálón. Nem áll rendelkezésre a DNS-szolgáltatás és elvesznek a DNS-beállítások. Leállításra kerül az összes ügyfél webhely.',
    'bu_conflict_resolver_dns_not_installed' => 'A DNS szolgáltatás nincs telepítve. Nem kerülnek visszaállításra a következő objektumok esetében a DNS-beállítások: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Nem állíthatóak vissza a következő előfizetések, mivel más tulajdonosokhoz helyezték át azokat: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Nem állíthatóak vissza a következő előfizetések, mivel más szolgáltatókhoz helyezték át azokat: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Nem található a Web Presence Builder visszaállító segédprogram a Web Presence Builder adatok visszaállítására. Valószínűleg nincs telepítve a Web Presence Builder.',
    'backup__restore__capability_renamed_db' => '"%1" adatbázis nevet más előfizetés már használja. "%2" névre változik a visszaállított adatbázis neve.',
    'backup__restore__capability_renamed_db_user' => '"%1" adatbázis-felhasználó nevet más előfizetés már használja. "%2" névre változik a visszaállított adatbázis-felhasználó neve.',
    'backup__restore__capability_not_installed_perl_resolution' => 'Nem támogatja a Plesk Installer a Perl használatát. Kézzel végezze az ActiveState Perl telepítését.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (azonosító=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% Apache kiszolgáló (azonosító=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% nginx kiszolgáló (azonosító=%%id%%)',


    '__sni' => 'Kiszolgálónév azonosítás',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium vírusvédelem',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Erőforrás-használati ütközések',
    'backup__restore__hint_resource_usage_conflicts' => 'Erőforrás ütközések történnek, ha a visszaállított objektum erőforrás-használati korlátjának túllépése fordul elő a visszaállítás során.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Túlhasználat engedélyezése',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Állítsa vissza az objektumokat és engedélyezze a kezdetben biztosítottnál több erőforrás használatát.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Ne állítsa vissza.',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Ne állítsa vissza az olyan objektumokat, melyeknél erőforrás-használati ütközések fordulnak elő.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Beállítás ütközések',
    'backup__restore__hint_configuration_conflicts' => 'Beállítás ütközések történnek, ha olyan beállításokkal és webalkalmazásokkal rendelkezik a visszaállított objektum, melyeket tilt az aktuális kiszolgáló- vagy az objektumtulajdonos házirendje Például beállítás ütközések történnek, ha egyéni levélszemét szűrő beállításokkal rendelkeznek a visszaállított postaládák, miközben az aktuális kiszolgáló egész kiszolgálóra érvényes házirendje tiltja a postaládák ilyen beállításait.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatikus',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Állítsa vissza az objektumokat és automatikusan kapcsolja be az összes olyan beállítást, melynél beállítás ütközése fordul elő és rendelkezik a kezelésükhöz szükséges engedélyekkel.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Ne állítsa vissza.',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Ne állítsa vissza az olyan objektumokat, melyeknél beállítás ütközés fordulnak elő.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Nem engedélyezettek az IIS-alkalmazás készlet beállítások között a dedikált IIS-alkalmazás készletek.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Változtassa meg az IIS-alkalmazás készlet beállításait az Eszközök és beállítások > IIS-alkalmazás készlet > Globális beállítások menőpontnál.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Megosztott IIS-alkalmazás készletek nem engedélyezettek az IIS-alkalmazás készlet beállításoknál.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Változtassa meg az IIS-alkalmazás készlet beállításait az Eszközök és beállítások > IIS-alkalmazás készlet > Globális beállítások menőpontnál.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'A POP3/IMAP-postafiók nevek használata nem engedélyezett a célkiszolgálón.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Az adatok visszaállítása után nem állnak rendelkezésre a postafiók rövid nevek.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Nem lehet naplófájlt megnyitni.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '%1 előfizetés nem állítható vissza:  eltávolításra került a számlájáról, és nem rendelkezik előfizetés létrehozási engedéllyel. Ha vissza kell állítani, akkor forduljon a szolgáltatójához.',

    'backup__error11' => 'Nincs elegendő lemezterület a biztonsági mentéshez.',
    'backup__error3011' => 'Kapcsolat elutasítva. Nincs figyelést végző program a megadott címen és porton.',
    'backup__error3012' => 'Kapcsolat időkorlátja.',
    'backup__error3013' => 'Nem áll rendelkezésre a hálózat.',
    'backup__error3014' => 'Nem található útvonal az állomáshoz.',
    'backup__error3015' => 'A csatlakozás nem sikerült.',
    'backup__error3016' => 'Nem lehet feloldani az állomásnevet.',
    'backup__error3017' => 'Hibás felhasználónév vagy jelszó.',
    'backup__error3018' => 'SSH kapcsolat létrehozása nem sikerült.',

    'backup__error3110' => 'Nem lehet kapcsolódni az áttelepítési ügynökhöz: Nincs lehetőség az állomáshoz kapcsolódásra.',
    'backup__error3111' => 'Egy sikertelen áttelepítési feladat zárolta az áttelepítési ügynököt vagy másik áttelepítési eljárás használja azt. Indítsa újra a forráskiszolgálón az áttelepítési ügynököt.',
    'backup__error3112' => 'Nem lehet kapcsolódni az állomáshoz vagy nem fut a forrásállomáson az áttelepítési ügynökst.',
    'backup__error3113' => 'Nem lehet telepíteni az áttelepítési ügynököt egy Linux állomásra. Ellenőrizze a forrásállomás SSH-kapcsolatát.',
    'backup__error3114' => 'Nem lehet telepíteni az áttelepítési ügynököt egy Linux állomásra: SSH kapcsolat létrehozása nem sikerült.',
    'backup__error3115' => 'Hibás felhasználónév vagy jelszó.',
    'backup__error3116' => 'Nem rendelkezik adminisztrátori jogosultságokkal a megadott felhasználó.',

    'dns_t__unable_to_remove_ns_record' => 'Nem lehetséges az NS-rekord eltávolítása a DNS-sablonból: Mindegyik DNS-zónának legalább egy NS-rekordot kell tartalmaznia.',
    'dns__unsupported_server_zone_transfer' => 'Nem lehetséges az Átvitel korlátozási sablon átvitele az egész kiszolgálóra érvényes DNS-konfiguráció miatt: A következő hálózati címek engedélyezettek zónaátvitelre a forráskiszolgálón, de a Microsoft DNS-kiszolgáló tiltja e címek használatát: %1',
    'dns__unsupported_domain_zone_transfer' => 'Nem lehetséges az Átvitel korlátozási sablon átvitele a domain DNS-konfigurációja miatt: A következő hálózati címek engedélyezettek zónaátvitelre néhány domainen, de a Microsoft DNS-kiszolgáló tiltja e címek használatát: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Nem lehet a megosztott ideiglenes hálózati biztonsági másolat fájl könyvtárhoz férni. Ellenőrizze a hálózati könyvtárat, felhasználónevet és jelszót. Hiba: %1',

    'dbbackup__temp_dir_wrong_value' => 'Érvénytelen ideiglenes könyvtár érték került meghatározásra.',
    'dbbackup__network_temp_dir_wrong_value' => 'Érvénytelen ideiglenes hálózati könyvtár érték került meghatározásra.',
    'dbbackup__server_backup_not_configured' => 'Nem történt meg az adatbázis biztonsági mentések beállítása.',
    'dbbackup__temp_dir' => 'Ideiglenes könyvtár',
    'dbbackup__temp_dir_hint' => 'Azon távoli kiszolgálón található fizikai mappa elérési útja, melyen az MS SQL-kiszolgáló található. Igeiglenes biztonsági másolat fájlok olvasása és írása érdekében az MS SQL-kiszolgálónak képesnek kell lennie e mappához férésre. Például, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Az előzőekben került megadásra a fizikai mappához rendelt hálózati megosztás elérési útja. A Plesk hozzáfér a megosztott mappához a biztonsági másolat fájlok le- és feltöltése céljából. Például, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'A távoli kiszolgálón létrehozott hálózati felhasználó felhasználóneve. For example, ServerName\UserName. A felhasználónak hozzáféréssel kell rendelkeznie az előzőekben meghatározott megosztott mappához.',
    'dbbackup__network_password_hint' => 'A hálózati felhasználó jelszava',

    'dbbackup__success_import_without_dublicate_users' => 'Nem került sor a következő felhasználók importálására: %1. Már léteznek az adatbázis-kiszolgálón.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Naplófájlok tömörítése",
    'log_rot__log_rot_status' => "Napló rotáció állapota",
    'log_rot__log_rot_period' => "Napló rotáció feltétele",
    'log_rot__log_rot_size' => "méret szerint",
    'log_rot__log_rot_time' => "idő szerint",
    'log_rot__logrotation_enable' => "Napló rotáció bekapcsolása",
    'log_rot__mail' => "Küldje e-maillel a feldolgozott naplófájlokat.",
    'log_rot__max_number_of_logfiles' => "Naplófájlok maximális száma",
    'log_rot__time_period' => "időszak",
    'log_rot__unable_turn_off' => 'Nem állítható be a napló rotáció kikapcsolása, mivel ennek kikényszerítése a kiszolgáló szinten történik.',
    'log_rot__unable_set_period' => 'Nem állítható be \'daily\' napló rotáció időtartamtól eltérő időtartam, mivel ennek kikényszerítése a kiszolgáló szinten történik.',
    'log_rot__unable_set_max_log_files' => 'Az egész kiszolgálóra érvényes %1 korlátnál nagyobb érték nem állítható be a naplófájlok maximális számaként.',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Szám megadása szükséges: %1",
    'actionlog__incorrect_rotation' => "A naplózás rotációjára megadott paraméterek érvénytelenek: %1",
    'actionlog__unknown_rot_period' => "Ismeretlen rotációs gyakoriság: %1",
    'actionlog__unknown_rot_type' => "Ismeretlen rotációs típus: %1",
    'actionlog__session_preferences' => 'Munkamenet beállítások',
    'actionlog__nis2_delete_prohibited' => 'A NIS2 irányelv hatályos korlátozásai tiltják a naplórekordok eltávolítását.',
    'actionlog__nis2_forbidden_rot_type' => "A NIS2 irányelv hatályos korlátozásai miatt nem használható '%1' naplóforgatás típus.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Rendszergazdai információk',
    'actionlog__admin_preferences' => "Adminisztrátor beállítások",
    'actionlog__service' => 'Szolgáltatás',
    'actionlog__ip_addr' => 'IP-cím',
    'actionlog__client' => 'Ügyfélszámla',
    'actionlog__client_status' => 'Ügyfélszámla állapota',
    'actionlog__client_preferences' => "Ügyfél kezelőfelület beállításai",
    'actionlog__client_ip_pool' => "Ügyfél IP-készlete",
    'actionlog__client_siteapp' => "Ügyfél webalkalmazás készlete",
    'actionlog__client_guid' => "Ügyfél GUID azonosítója",
    'actionlog__domain' => 'Alapértelmezett domain (egy előfizetéshez adott első domain)',
    'actionlog__domain_owner' => 'Előfizetés tulajdonosa',
    'actionlog__domain_plan' => 'Előfizetési szolgáltatási csomag',
    'actionlog__domain_status' => 'Alapértelmezett domain, állapot',
    'actionlog__domain_dns' => 'Alapértelmezett domain, DNS-zóna',
    'actionlog__subdomain' => 'Alapértelmezett domain aldomainje',
    'actionlog__domain_alias' => 'Alapértelmezett domain, alias',
    'actionlog__domain_alias_dns' => 'Alapértelmezett domain, alias DNS-zóna',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Domain állapota',
    'actionlog__site_dns' => 'Domain DNS-zóna',
    'actionlog__site_guid' => 'Domain GUID-azonosító',
    'actionlog__site_subdomain' => 'Aldomain',
    'actionlog__site_alias' => 'Domain aliasnév',
    'actionlog__site_alias_dns' => 'Domain alias DNS-zóna',
    'actionlog__domain_limits' => 'Előfizetési korlátok',
    'actionlog__domain_limit_size' => 'Előfizetési lemezterület kvóta',
    'actionlog__domain_limit_traffic' => 'Előfizetési forgalmi korlát',
    'actionlog__domain_limits_powerUser' => 'Előfizetési korlátok',
    'actionlog__domain_limit_size_powerUser' => 'Előfizetési lemezterület kvóta',
    'actionlog__domain_limit_traffic_powerUser' => 'Előfizetési forgalmi korlát',
    'actionlog__domain_guid' => "Alapértelmezett domain, GUID-azonosító",
    'actionlog__cp_user' => 'Plesk felhasználó',
    'actionlog__mailname' => 'Postafiók',
    'actionlog__maillist' => 'Levelezési lista',
    'actionlog__phosting' => 'Üzemeltetési beállítások',
    'actionlog__forwarding' => 'Normál vagy kerettovábbításos üzemeltetés',
    'actionlog__webuser' => 'Web felhasználói fiók',
    'actionlog__site_application' => 'Webalkalmazás',
    'actionlog__license' => 'Licenckulcs',
    'actionlog__additional_license' => 'További licenckulcs',
    'actionlog__template_domain' => "Viszonteladó szolgáltatási csomagja",
    'actionlog__template_admin' => "Adminisztrátor szolgáltatási csomagja",
    'actionlog__template_reseller' => 'Viszonteladói csomag',
    'actionlog__admin_alias' => 'További adminisztrátor számla', // PFW
    'actionlog__ftpuser' => 'További FTP-fiók', // PFW
    'actionlog__db_server' => 'Adatbázis-kiszolgáló',
    'actionlog__db' => 'Adatbázis',
    'actionlog__db_user' => 'Adatbázis felhasználói fiók',
    'actionlog__client_sapppkg_pool' => "Felhasználó webalkalmazása", // PFW, not used?
    'actionlog__remote_dns' => 'Távoli DNS-kiszolgáló állapota', // PFW
    'actionlog__reseller' => 'Viszonteladói számlák',
    'actionlog__reseller_guid' => 'Viszonteladói GUID',
    'actionlog__reseller_ip_pool' => "Viszonteladó IP-cím készlete",
    'actionlog__reseller_limit_size' => 'Viszonteladói számla lemezterület korlát',
    'actionlog__reseller_limit_traffic' => 'Viszonteladói számla forgalmi korlát',
    'actionlog__reseller_limits' => 'Viszonteladói számla korlátok',
    'actionlog__reseller_permissions' => 'Viszonteladói engedélyek',
    'actionlog__reseller_preferences' => "Viszonteladó kezelőfelület beállítások",
    'actionlog__reseller_siteapp' => "Viszonteladói készlet webalkalmazásai",
    'actionlog__reseller_status' => 'Viszonteladói számla állapota',
    'actionlog__health_status' => 'Kiszolgáló állapota',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'elérve',
    'actionlog__added' => 'hozzáadásra',
    'actionlog__removed' => 'eltávolítva',
    'actionlog__change' => 'megváltoztatva',
    'actionlog__update' => 'frissítve',
    'actionlog__move' => 'áthelyezett',
    'actionlog__upgrade' => 'frissítve', // PFU?
    'actionlog__update_or_add' => 'frissítve vagy hozzáadva',
    'actionlog__expired' => 'lejárt',
    'actionlog__create' => 'létrehozva',
    'actionlog__delete' => 'törölve',
    'actionlog__clear' => 'törölve',
    'actionlog__service_stop' => 'leállítása',
    'actionlog__service_restart' => 'újraindítása',
    'actionlog__service_start' => 'indítása',
    'actionlog__login' => 'bejelentkezés',
    'actionlog__logout' => 'kijelentkezés',
    'actionlog__install' => 'telepítve',
    'actionlog__uninstall' => 'eltávolítva',
    'actionlog__reconfigure' => 'újrakonfigurálása',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Új jelszó kérése',
    'actionlog__event_admin_update' => 'Adminisztrátor adatok frissítve',
    'actionlog__event_admin_preferences_update' => "Adminisztrátor beállítások frissítettek",
    'actionlog__event_service_restart' => 'Szolgáltatás újraindítva',
    'actionlog__event_service_start' => 'Szolgáltatás elindítva',
    'actionlog__event_service_stop' => 'Szolgáltatás leállítva',
    'actionlog__event_ip_address_create' => 'IP-cím létrehozva',
    'actionlog__event_ip_address_delete' => 'IP-cím törölve',
    'actionlog__event_ip_address_update' => 'IP-cím frissítve',
    'actionlog__event_client_create' => 'Ügyfélszámla létrehozva',
    'actionlog__event_client_delete' => 'Ügyfélszámla törölve',
    'actionlog__event_client_update' => 'Ügyfélszámla frissítésére került sor.',
    'actionlog__event_client_status_update' => 'Ügyfélszámla állapotának frissítésére került sor.',
    'actionlog__event_client_preferences_update' => "Frissítésre kerültek az ügyfél kezelőfelület beállításai.",
    'actionlog__event_client_siteapp_added' => "Webalkalmazás ügyfélszámla alkalmazás készletéhez adására került sor.",
    'actionlog__event_client_siteapp_removed' => "Webalkalmazás ügyfélszámla alkalmazás készletéből eltávolítására került sor.",
    'actionlog__event_domain_limit_size_reached' => 'Előfizetési lemezterület kvóta elérve',
    'actionlog__event_domain_limit_traffic_reached' => 'Előfizetési forgalmi korlát elérve',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Előfizetési lemezterület kvóta elérve',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Előfizetési forgalmi korlát elérve',
    'actionlog__event_dns_record_create' => 'Létre lett hozva a DNS-rekord.',
    'actionlog__event_dns_record_delete' => 'Törölve lett a DNS-rekord.',
    'actionlog__event_dns_record_update' => 'Frissítve lett a DNS-rekord.',
    'actionlog__event_dns_zone_soa_record_update' => 'Frissítve lett a SOA DNS-rekord.',
    'actionlog__event_dns_zone_switch_to_master' => 'Elsődlegessé lett téve a DNS-zóna.',
    'actionlog__event_dns_zone_switch_to_slave' => 'Másodlagossá lett téve a DNS-zóna.',
    'actionlog__event_dns_zone_turn_off' => 'Le van tiltva a DNS-zóna.',
    'actionlog__event_dns_zone_turn_on' => 'Engedélyezve van a DNS-zóna.',
    'actionlog__event_pw_admin_force_reset' => 'Megváltoztatásra került egy adminisztrátori fiók jelszavának kötelező új jelszó kérési jelölése.',

    'actionlog__domain_limit_database' => 'Előfizetési adatbázis kvóta',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Megtörtént a MariaDB/MySQL-adatbázis előfizetési kvóta elérése',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Megtörtént a MariaDB/MySQL-adatbázis előfizetési enyhe kvóta elérése',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Megtörtént a Microsoft SQL-kiszolgáló előfizetési adatbázis kvóta elérése.',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Microsoft SQL-kiszolgáló előfizetési adatbázis enyhe kvóta elérve',
    'actionlog__event_plesk_component_upgrade' => 'Plesk összetevő frissítve',
    'actionlog__event_plesk_component_install' => 'Plesk összetevő telepítve',
    'actionlog__event_plesk_component_uninstall' => 'Plesk összetevő eltávolítva',
    'actionlog__event_domain_create' => 'Alapértelmezett domain (egy előfizetéshez adott első domain) létrehozva',
    'actionlog__event_domain_delete' => 'Alapértelmezett domain (egy előfizetéshez adott első domain) törölve',
    'actionlog__event_domain_update' => 'Alapértelmezett domain (egy előfizetéshez adott első domain) frissítve',
    'actionlog__event_domain_owner_change' => 'Előfizetés tulajdonosa megváltozott',
    'actionlog__event_domain_plan_change' => 'Megváltoztatása került az előfizetési szolgáltatási csomag',
    'actionlog__event_domain_status_update' => 'Alapértelmezett domain, állapot frissítve',
    'actionlog__event_domain_dns_update' => 'Alapértelmezett domain, DNS-zóna frissítve',
    'actionlog__event_subdomain_create' => 'Alapértelmezett domain aldomainje létrehozva',
    'actionlog__event_subdomain_delete' => 'Alapértelmezett domain aldomainje törölve',
    'actionlog__event_subdomain_update' => 'Alapértelmezett domain aldomainje frissítve',
    'actionlog__event_domain_alias_create' => 'Alapértelmezett domain, alias létrehozva',
    'actionlog__event_domain_alias_delete' => 'Alapértelmezett domain, alias törölve',
    'actionlog__event_domain_alias_update' => 'Alapértelmezett domain, alias frissítve',
    'actionlog__event_domain_limits_update' => 'Előfizetési korlátok frissítve',
    'actionlog__event_cp_user_login' => 'Plesk felhasználó bejelentkezett.',
    'actionlog__event_cp_user_logout' => 'Plesk felhasználó kijelentkezett.',
    'actionlog__event_mailname_create' => 'Postafiók létrehozva',
    'actionlog__event_mailname_delete' => 'Postafiók törölve',
    'actionlog__event_mailname_clear' => 'Ürítve lett a postafiók',
    'actionlog__event_mailname_update' => 'Postafiók frissítve',
    'actionlog__event_maillist_create' => 'Levelezési lista létrehozva',
    'actionlog__event_maillist_delete' => 'Levelezési lista törölve',
    'actionlog__event_maillist_update' => 'Levelezési lista frissítve',
    'actionlog__event_phys_hosting_create' => 'Fizikai üzemeltetés létrehozva',
    'actionlog__event_phys_hosting_delete' => 'Fizikai üzemeltetés törölve',
    'actionlog__event_phys_hosting_update' => 'Fizikai üzemeltetés frissítve',
    'actionlog__event_forwarding_create' => 'Normál- vagy kerettovábbításos üzemeltetés létrehozva',
    'actionlog__event_forwarding_delete' => 'Normál- vagy kerettovábbításos üzemeltetés törölve',
    'actionlog__event_forwarding_update' => 'Normál- vagy kerettovábbításos üzemeltetés frissítve',
    'actionlog__event_webuser_create' => 'Webes felhasználói fiók létrehozva',
    'actionlog__event_webuser_delete' => 'Webes felhasználói fiók törölve',
    'actionlog__event_webuser_update' => 'Webes felhasználói fiók frissítve',
    'actionlog__event_siteapp_install' => 'Megtörtént a webalkalmazás telepítése.',
    'actionlog__event_siteapp_reconfigure' => 'Megtörtént a webalkalmazás újrakonfigurálása.',
    'actionlog__event_siteapp_uninstall' => 'Megtörtént a webalkalmazás eltávolítása.',
    'actionlog__event_license_update' => 'Licenckulcs frissítve',
    'actionlog__event_admin_alias_create' => 'További adminisztrátor számla létrehozva',
    'actionlog__event_admin_alias_delete' => 'További adminisztrátor számla törölve',
    'actionlog__event_admin_alias_update' => 'További adminisztrátor számla frissítve',
    'actionlog__event_ftpuser_create' => 'További FTP-fiók létrehozva',
    'actionlog__event_ftpuser_update' => 'További FTP-fiók törölve',
    'actionlog__event_ftpuser_delete' => 'További FTP-fiók törölve',
    'actionlog__event_template_domain_create' => "Viszonteladó szolgáltatási csomagja létrehozva",
    'actionlog__event_template_domain_update' => "Viszonteladó szolgáltatási csomagja frissítve",
    'actionlog__event_template_domain_delete' => "Viszonteladó szolgáltatási csomagja törölve",
    'actionlog__event_template_admin_create' => "Adminisztrátor szolgáltatási csomagja létrehozva",
    'actionlog__event_template_admin_update' => "Adminisztrátor szolgáltatási csomagja létrehozva",
    'actionlog__event_template_admin_delete' => "Adminisztrátor szolgáltatási csomagja törölve",
    'actionlog__event_database_server_create' => 'Adatbázis-kiszolgáló létrehozva',
    'actionlog__event_database_server_update' => 'Adatbázis-kiszolgáló frissítve',
    'actionlog__event_database_server_delete' => 'Adatbázis-kiszolgáló törölve',
    'actionlog__event_remote_dns_status_update' => 'Távoli DNS-kiszolgáló állapota frissítve',
    'actionlog__event_session_preferences_update' => 'Munkamenet beállítások frissítve',
    'actionlog__event_domain_alias_dns_update' => 'Alapértelmezett domain, domain alias DNS-zóna frissítve',
    'actionlog__event_domain_move' => 'Egy új előfizetéshez lett áthelyezve az alapértelmezett domain.',
    'actionlog__event_site_move' => 'Egy új előfizetéshez lett áthelyezve a domain.',
    'actionlog__event_site_subdomain_move' => 'Egy új előfizetéshez lett áthelyezve az aldomain.',
    'actionlog__event_subdomain_move' => 'Egy új előfizetéshez lett áthelyezve az alapértelmezett domain aldomainje.',
    'actionlog__event_license_expired' => 'Lejárt a Plesk licenc.',
    'actionlog__event_database_create' => 'Adatbázis létrehozva',
    'actionlog__event_database_delete' => 'Adatbázis eltávolítva',
    'actionlog__event_database_user_create' => 'Adatbázis felhasználói fiók létrehozva',
    'actionlog__event_database_user_update' => 'Adatbázis felhasználói fiók beállítások frissítve',
    'actionlog__event_database_user_delete' => 'Adatbázis felhasználói fiók eltávolítva',
    'actionlog__event_client_guid_update' => "Ügyfél GUID azonosítója frissítve",
    'actionlog__event_domain_guid_update' => 'Alapértelmezett domain, GUID-azonosító frissítve',
    'actionlog__event_reseller_create' => 'Viszonteladói számla létrehozva',
    'actionlog__event_reseller_delete' => 'Viszonteladói számla törölve',
    'actionlog__event_reseller_update' => 'Viszonteladói számla frissítve',
    'actionlog__event_reseller_guid_update' => 'Viszonteladó GUID azonosítója frissítve',
    'actionlog__event_reseller_ip_pool_update' => "Viszonteladó IP-cím készlete frissítve",
    'actionlog__event_reseller_limit_size_reached' => 'Viszonteladói számla webtárhely korlát elérve',
    'actionlog__event_reseller_limit_traffic_reached' => 'Viszonteladói számla forgalmi korlát elérve',
    'actionlog__event_reseller_limits_update' => 'Viszonteladói számla korlátok frissítve',
    'actionlog__event_reseller_permissions_update' => 'Viszonteladói számla engedélyek frissítve',
    'actionlog__event_reseller_preferences_update' => "Viszonteladó kezelőfelület beállításai frissítve",
    'actionlog__event_reseller_siteapp_added' => "Alkalmazás ügyfélszámla alkalmazás készlet adására került sor.",
    'actionlog__event_reseller_siteapp_removed' => "Alkalmazás ügyfélszámla alkalmazás készletéből eltávolítására került sor.",
    'actionlog__event_reseller_status_update' => 'Viszonteladói számla állapota frissítve',
    'actionlog__event_template_reseller_create' => 'Viszonteladói csomag létrehozva',
    'actionlog__event_template_reseller_delete' => 'Viszonteladói csomag törölve',
    'actionlog__event_template_reseller_update' => 'Viszonteladói csomag frissítve',
    'actionlog__event_health_status_change' => 'Kiszolgáló állapota megváltozott',
    'actionlog__event_siteapp_upgrade' => 'Megtörtént a webalkalmazás frissítése.',
    'actionlog__event_extension_install' => 'Megtörtént a bővítmény telepítése.',
    'actionlog__event_extension_uninstall' => 'Megtörtént a bővítmény eltávolítása.',
    'actionlog__event_extension_upgrade' => 'Megtörtént a bővítmény magasabb verzióra frissítése.',
    'actionlog__event_extension_status_update' => 'Megtörtént a bővítmény állapotának a feltöltése.',
    'actionlog__event_additional_license_expired' => 'Lejárt a további licenckulcs.',
    'actionlog__event_hostname_changed' => 'Megváltoztatott kiszolgáló állomásnév',
    'actionlog__event_smb_user_create' => 'További felhasználó került létrehozásra',
    'actionlog__event_smb_user_delete' => 'További felhasználó került törlésre',
    'actionlog__event_smb_user_update' => 'További felhasználó került frissítésre',
    'actionlog__dns_record' => 'DNS-rekord',
    'actionlog__dns_zone' => 'DNS-zóna',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "A Plesk API RPC nincs telepítve a távoli állomásra. A szolgáltatójához forduljon segítségért.",
    'rsession_no_account_errmsg' => "Nem lehetséges a távoli alkalmazás elérése a fiókjából. Ennek a leggyakoribb oka, hogy a fiókja számára még nem lett aktiválva a szolgáltatás. Várjon pár percet majd próbálkozzon újra. Ha ismét fennáll a hibajelenség, akkor lépjen kapcsolatba a rendszergazdával.",
    'rsession_no_domain_errmsg' => "Nem tud távoli szolgáltatáshoz kapcsolódni e domain. Ennek a leggyakoribb oka, hogy még nincs aktiválva a szolgáltatás a domain számára. Várjon pár percet majd próbálkozzon újra. Ha ismét fennáll a hibajelenség, akkor lépjen kapcsolatba a rendszergazdával.",
    'rsession_unknown_errmsg' => "A távoli kiszolgáló visszautasította a távoli kapcsolat létesítési munkamentet. Lépjen kapcsolatba rendszergazdával a probléma megoldásához. Az előfordult hiba: %1",
    'rsession_unknown2_errmsg' => "Ismeretlen hiba jelentkezett a távoli munkamenet létesítésekor. A legvalószínűbb, hogy olgáló nem válaszol megfelelően vagy egyáltalán nem válaszol. Kérje meg rendszergazdáját, hogy ellenőrizze webkiszolgáló hibanaplójánban a hiba adatait.",
    'rsession_no_connect_errmsg' => "Nem lehetséges kapcsolódni a távoli szolgáltatáshoz: a távoli szolgáltatáshoz kapcsolódás nem sikerült. Lépjen kapcsolatba rendszergazdával a probléma megoldásához.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Feltöltés engedélyezése a bejövő fájlok könyvtárba",
    'anonftp__allow_create_dirs' => 'Alkönyvtárak létrehozásának engedélyezése a bejövő fájlok könyvtárban',
    'anonftp__allow_download_incoming' => 'Letöltés engedélyezése a bejövő fájlok könyvtárból',
    'anonftp__display_login' => 'Bejelentkezési üzenet megjelenítése',
    'anonftp__login_text' => 'Üzenet szövege',
    'anonftp__limit_incoming_disk_space' => "A diszkfoglalás limitálása a bejövő (incoming) könyvtárban",
    'anonftp__limit_maximum_bandwidth' => "A letöltési sávszélesség korlátozása e virtuális FTP-domaint illetően",
    'anonftp__limit_maximum_connections' => "Az egyidejű kapcsolatok számának korlátozása",
    'anonftp__unable_init' => "Névtelen FTP-fiók inicializálása nem lehetséges: %1",
    'anonftp__unable_set_quota' => "A bejövő fájl könyvtárra vonatkozó lemezterület foglalási korlát beállítása nem lehetséges: %1",
    'anonftp__unable_update' => "Névtelen FTP-fiók jellemzőinek frissítése nem lehetséges: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-tanúsítványok', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "A hitelesítésszolgáltatói tanúsítvány nem írja alá a tanúsítványt.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Nem kompatibilis személyes kulcs/tanúsítvány pár.",
    'class_sslcertificate__invalid_cert_format' => "A tanúsítvány formátuma érvénytelen.",
    'class_sslcertificate__invalid_private_key_format' => "A titkos kulcs formátuma érvénytelen.",
    'class_sslcertificate__prob_invalid_priv_key' => "Valószínűleg érvénytelen a titkos kulcs formátuma.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Nincsenek feltöltendő fájlok.',
    'login_up__access_denied_no_permission' => "Hozzáférés megtagadva. Nem rendelkezik bejelentkezési engedéllyel.",
    'mail__unable_remove_pattern' => "Nem lehet címet eltávolítani a kiszolgáló tiltólistájáról: %1", // PFW
    'mail__incorrect_network_format' => 'Helytelen hálózati formátum: %1', // PFW
    'initconf__unable_change_passwd' => "A rendszergazdai jelszó megváltoztatása nem lehetséges: %1",
    'initconf__unable_get_passwd' => 'Az aktuális rendszergazdai jelszó lekérdezése nem lehetséges: %1 nem sikerült: %2',
    'initconf__invalid_hostname' => 'Hiba fordult elő "%1" állomásnévben',
    'initconf__unable_reconfig' => 'Nem végezhető el Plesk konfigurálása: reconfig nem sikerült: %1',
    'initconf__unable_update_admin' => 'Nem végezhető el a rendszergazdai kapcsolattartási adatok frissítése: %1',
    'initconf__wpa_token_verification_failed' => 'Nem ellenőrizhető a jogkivonat.',
    'initconf__wpa_email_not_verified' => 'Nem történt meg az e-mail cím ellenőrzése.',
    'initconf__wpa_no_access_to_email' => 'Nem kérhető le az e-mail cím.',
    'initconf__wpa_no_access_to_id' => 'Nem kérhető le a felhasználói azonosító.',
    '__refresh' => 'Frissítés',
    '__dalias_not_exist' => 'A domain alias nem létezik.',
    '__bug146523_explanation' => 'A Plesk előző verziói maximum 16 karakteres FTP felhasználónevek használatát engedélyezték. E Plesk verzió maximum 15 karakterre korlátozza az FTP felhasználónevekben szereplő karakterek számát. E probléma kiküszöbölésére az érintett FTP felhasználónevek esetében csökkentse 15 karakterre az FTP felhasználónév karakterszámát, továbbá változtassa meg az érintett FTP felhasználónevek legalább egy karakterét a felhasználónév ütközések elkerülése érdekében. Sajnos e változtatás bármely kényelmetlenség oka.',
    'domain__cannot_change_webmail' => 'Nem lehetséges a domain webes levelezésének megváltoztatása: %1',
    'sb_publish_disable_warning' => 'Ha kikapcsolja a Presence Builder segítségével történő webhely létrehozást, akkor a Presence Builder által korábban létrehozott webhelyek eltávolításra, míg a webhely adatok törlésre kerülnek. Kattintson az OK gombra, ha folytatni akarja.',
    '__sbnet_client_use_sbnet' => "Megfelelő felhasználói számla létrehozása a Presence Builder weboldalkészítőben",
    'mail_resp_activate' => 'Automatikus válaszadás aktiválása',
    'limitsManger__limit_available_error' => 'Nem lehet lefoglalni a szükséges ("%%limitName%%") erőforrás mennyiséget: csupán %%available%% áll rendelkezésére a számláján.',
    'limitsManger__limit_reserved_error' => 'Nem lehet a már használtnál kevesebb ("%%limitName%%") erőforrásokat lefoglalni.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Nem lehetséges a domain átnevezése. A megadott névvel már létezik virtuális könyvtár.',
    'domain_unable_to_rename' => 'Nem lehetséges a domain átnevezése.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Általános',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin levélszemét szűrés',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin beállítások',
    'spamfilter__spamassassin_server_status_legend' =>  "Az egész kiszolgálóra érvényes SpamAssassin kéretlen levél szűrés",
    'spamfilter__spamassassin_user_status_legend' => 'SpamAssassin levélszemét szűrés bekapcsolása',
    'spamfilter__greylisting_status_legend' => 'Az egész kiszolgálóra érvényes szürkelistás kéretlen levelek elleni védelem bekapcsolása',
    'spamfilter__personal_settings_not_allowed' => 'A rendszer házirend szerint nem engedélyezett egyéni kéretlen levél szűrés beállítások használata.',
    'spamfilter__required_score' => 'A pontszám, melyet egy üzenetnek levélszemét minősítéshez kapnia kell.',
    'spamfilter__rewrite_header_subject' => 'A következő üzenetet adja a levélszemétként azonosított üzenetek tárgya elé.',
    'spamfilter__use_mailuser_prefs' => 'Egyéni beállítások kéretlen levél szűrésre használata',
    'spamfilter__score_error' => 'Nem lehet negatív előjelű a pontszám, 100 alatti értéknek kell a tizedesvessző előtt szerepelnie és maximum két számjegy lehet a tizedesvessző után.',
    'spamfilter__rewrite_header_error' => 'Az üzenet tárgyában a kettős kereszt (#) kivételével bármely nyomtatható karakterek szerepelhet.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Pattogás',
    'nonexistent_mail__mode_discard' => 'Elvetés',
    'nonexistent_mail__mode_catch_addr' => 'E-mail címre továbbítás',
    'nonexistent_mail__mode_catch_ip' => 'IP-címre továbbítás',
    'nonexistent_mail__bounce_not_supported' => 'Nem támogatott a Pattogási mód.',
    'nonexistent_mail__discard_not_supported' => 'Nem támogatott az Elvetési mód.',
    'nonexistent_mail__catch_not_supported' => 'Nem támogatott e-mail cím továbbítása.',
    'nonexistent_mail__redirect_not_supported' => 'Nem támogatott IP-címre történő továbbítás.',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-cím kiterjed a localhost címre.',
    'nonexistent_mail_address_should_be_local_domain' => 'Mivel be van kapcsolva a Kimenő levél ellenőrzés a nem létező címzettek %1 e-mail címének a kiválasztott domainhez kell tartoznia. Ha nem, akkor a továbbítás helyett az „Elutasítás” házirend kerül alkalmazásra.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Mivel be van kapcsolva a Kimenő levél ellenőrzés az e-mail továbbításhoz kiválasztott e-mail-cím címnek (%1) a kiválasztott domainhez kell tartoznia. Ha nem, akkor e címre küldött üzenetek nem kerülnek figyelembevételre a Kimenő levél ellenőrzés során.',
    // mail acc extras
    '__antivirus' => "Vírusvédelem",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Ki van kapcsolva az ASP.NET támogatás e webhely esetében.',
    'phosting__php_forced_by_site_isolation' => 'Nem lehetséges a PHP-beállítások megváltoztatása: nincs engedélyezve az egész kiszolgálóra érvényes biztonsági házirend felülbírálása.',
    'phosting__option_forced_by_site_isolation' => 'Nem lehetséges %1 beállítások megváltoztatása: nincs engedélyezve az egész kiszolgálóra érvényes biztonsági házirend felülbírálása.',
    'phosting__php_handler_id_not_registered' => 'Nincs engedélyezve a PHP-kezelő a webhely elkülönítési beállítások között. Az alapértelmezett PHP-kezelő használata történik.',
    'phosting__php_served_by_nginx_is_not_available' => 'Nincs engedélyezve a PHP-kezelő (nginx kiszolgáló FPM alkalmazása) a webhely elkülönítési beállítások között. Az alapértelmezett PHP-kezelő használata történik.',

    // tooltips

    'b_get_password_cancel' => 'Az e-mail elküldése nélkül térjen vissza az előző képernyőre.',
    'b_get_password_send' => 'Kattintson az OK gombra egy jelszó helyreállítási üzenetnek a rendszerben regisztrált e-mail címre küldése érdekében.',

    'b_back' => 'Térjen vissza az előző oldalra.',
    'b_next' => 'Ugrás a következő oldalra.',

    'b_dnsnstemplatelist_remove' => 'A kiválasztott névkiszolgáló törlése.',
    'b_dnsnstemplatelist_search' => 'Adjon meg egy keresési mintát és kattintson névkiszolgáló kereséséhez.',
    'b_dnsnstemplatelist_show_all' => 'Az összes névkiszolgáló megjelenítése.',

    'l_dnsnstemplatelist_ns' => 'DNS-sablon rekordok névkiszolgáló szerinti rendezése.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Hozzon létre biztonságos fájl- és mappahivatkozásokat.',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Nyilvános fájlok engedélyezése',
    'cu__serverfilesharing_fsPublicFolder' => 'Nyilvános fáljtároló mappa',
    'cu__serverfilesharing_fsPublicUrl' => 'Látogatói nyilvános fájl hozzáférési URL-cím',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Engedélyezze nyilvános fájlok jelszavas védelmét.',
    'cu__serverfilesharing_fsPartnerFolder' => 'Jelszóval védett fájltároló mappa',
    'cu__serverfilesharing_fsPartnersLogin' => 'Fájlhozzáférési felhasználónév',
    'cu__serverfilesharing_fsPartnersPassword' => 'Fájlhozzáférési jelszó',
    'cu__serverfilesharing_fsDomain' => 'Webmappa gyökér URL-cím. Domain név',
    'cu__serverfilesharing_fsPrefix' => 'Webmappa gyökér URL-cím. Előtag',
    'cu__serverfilesharing_commandUpdate' => 'Frissítse a fájlmegosztási beállításokat.',
    'cu__serverfilesharing_commandInfo' => 'Jelenítse meg az aktuális fájlmegosztási beállításokat.',
    'subscription_rename_is_forbidden' => 'Az egész kiszolgálóra érvényes házirend szerint tilos az előfizetések átnevezése.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "%1 domain FTP-fiókjai", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-fiókok",
    'ftp__user_name' => "FTP-fiók neve",
    'ftp__user_home' => "Kezdőkönyvtár",
    'ftp__invalid_path' => "Érvénytelen elérési út került megadásara.",
    'i_ftp_ses_sub_user' => 'FTP-fiók munkamenet.',
    '__new_passwd' => "Új %1 jelszó",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Nem lehet <%%host%%> állomáson webkiszolgálót konfigurálni.',
    'apacheConfigurationFailedMessageBody' => "A következő hibák miatt nem lehet webkiszolgáló konfigurációs fájlt generálni <%%host%%> állomáson:\n\n%%error%%\n\nKüszöbölje ki a webkiszolgáló konfigurációs sablon hibáit, majd generálja újra a fájlt.",

    'apacheConfigurationMessageAdminTitle' => 'Nem sikerült a webkiszolgáló konfiguráció generálása.',
    'apacheConfigurationMessageClientTitle' => 'Figyelmeztetés',

    'apacheConfigurationFailedAdminHomeMessage' => 'A konfigurációs sablonok hibái miatt nem készült új konfigurációs fájl. E-mailben elküldésre került a részletes hibaüzenet a számára, ezért ellenőrizze az e-mail üzeneteit, javítsa ki a hibákat, majd kattintson %1 gombra a konfiguráció generálás ismételt megpróbálására.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'itt', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'A konfigurációs sablonok hibái miatt nem készült új konfiguráció %1 domain esetében. E-mailben elküldésre került a részletes hibaüzenet a számára, ezért ellenőrizze az e-mail üzeneteit, javítsa ki a hibákat, majd kattintson %2 gombra a konfiguráció generálás ismételt megpróbálására.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'itt', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Előfordulhat, hogy nem konzisztens webkiszolgáló konfigurációja %1 domain esetében. A kiszolgáló adminisztrátorához forduljon a hiba elhárítása érdekben.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'A konfigurációs sablonok hibái miatt nem készült új konfiguráció egyes domainek számára. E-mailben elküldésre került a részletes hibaüzenet a számára, ezért ellenőrizze az e-mail üzeneteit, javítsa ki a hibákat, majd kattintson %1 gombra a konfiguráció generálás ismételt megpróbálására.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'itt', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Előfordulhat, hogy nem konzisztens a webkiszolgáló konfigurációja néhány domainje esetében . A kiszolgáló adminisztrátorához forduljon a hiba elhárítása érdekben.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Egyéni hiba dokumentumok",
    'dom_pref__webusers_script' => "Engedélyezze parancsprogramok használatát webes felhasználók számára.",
    '__seoRedirect' => 'Az előnyben részesített domain konfigurálása a következőképpen;',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Nincs',

    '__sites' => 'Domainek',
    'domain_plan__perm_denied_manage_phosting' => 'Engedélyre van szüksége az üzemeltetési beállítások kezelésére.',
    '__owned_by_client' => 'ügyfél a tulajdonos',
    'backup__restore__object_client_template' => 'Ügyfélsablon',
    '__template_name' => 'Szolgáltatási csomag neve',
    'template__not_exists' => 'Nincs ilyen szolgáltatási csomag.',
    'template__exists' => '%1 nevű csomag már létezik.',
    'clientOwnerChanger__ip_not_in_pool' => 'Nem szerepel a viszonteladó készletében a megadott IP-cím.',
    '__owner_name' => 'Szolgáltatási csomag tulajdonosa',

    'chown__error_check' => 'Problémák fordultak elő, amikor megpróbált néhány előfizetést egy új tulajdonoshoz rendelni.',

    '__redirect_hint' => '15 másodpercen belül egy új címre átirányításra kerül. Ha nem történik meg automatikusan az új helyre vitel, akkor engedélyezze a JavaScript működését vagy kattintson %%link%% hivatkozásra.',

    'backup__restore__object_maillist' => 'Levelezési lista',
    'backup__restore__object_site' => 'Hely',
    'backup__restore__object_user' => 'Felhasználó',
    'backup__restore__object_role' => 'Szerepkör',

    'limit__name_max_site' => 'webhely',

    'iis_pool__unable_rename_client' => "Nem lehet az IIS-alkalmazás készletet átnevezni: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Kizárólag egy előfizetés fődomainje számára támogatott névtelen FTP-szolgáltatás.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Kizárólag egy előfizetés fődomainje számára támogatott névtelen FTP-szolgáltatás.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/hónap',
    '__tb_month' => 'TB/hónap',

    '__customer_total' => 'Ügyfél összesen',
    '__site' => 'Hely',
    '__def_site' => 'Alapértelmezett hely',
    '__subscription_name' => 'Előfizetés neve',
    '__subscription_name_powerUser' => 'Előfizetés neve',

    'limit__units_max_traffic_suffix' => '/hónap',

    'dom_pref__discard' => "Elutasítás",

    'mail__pattern_already_exists' => '"%1" minta már szerepel a tiltólistán.',

    '__not_supported' => 'Nem támogatott',

    'plesk_key__sitebuilder' => 'Presence Builder weboldalkészítő segítségével létrehozott webhelyek',
    'limit__name_max_site_builder' => 'Presence Builder weboldalkészítő segítségével létrehozott webhelyek',
    'plesk_key__wpb-multi-language-sites-support' => 'Többnyelvű webhelyek támogatása a Presence Builder weboldalkészítőben',

    'login_up__access_denied_no_subscriptions' => "Hozzáférés megtagadva. Nem állnak előfizetések e számla számára rendelkezésre.",

    'interval__day' => '%1 nap',
    'interval__hour' => '%1 óra',
    'interval__minute' => '%1 perc',
    'interval__second' => '%1 másodperc',

    ///License options
    'plesk_key__backward_incompatibility' => 'Egy másik Plesk verzióhoz létrehozott licenckulcsot próbál használni. Forduljon a Plesk értékesítési képviselőihez a megfelelő licenckulcs beszerzése érdekében.',
    //Standalone or virtualization
    'virtualization_any' => "Fizikai kiszolgáló vagy bármelyik virtualizálási megoldás",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare virtualizálási megoldás",
    'virtualization_hyperv' => "Microsoft Hyper-V technológia",
    'virtualization_xen' => "Xen operációs rendszer",
    'virtualization_kvm' => "Rendszermag-alapú virtuális gép",
    'virtualization_parallels_server' => "Virtuozzo kiszolgáló",
    'plesk_key__virtualization' => "A következő környezetek esetén érvényes:",
    'plesk_key__virtualization_only_key' => 'Kizárólag %1 virtuális környezetben működő Plesk kezelőpanellel történő használatra szolgál a licenckulcs:',
    'plesk_key__virtualizations_only_key' => 'Kizárólag a következő virtuális környezetekben működő Plesk kezelőpanellel történő használatra szolgál a licenckulcs: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Tilos egyéni nyelvi csomagok használata.',
    'plesk_key__allowed-locales' => 'Rendelkezésre álló nyelvek',
    'plesk_key__allowed-locales-any' => 'Bármelyik nyelv',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'A következő helyen található a CGI-bin könyvtár;',
    '_cgi_bin_mode_webspace' => 'az előfizetés gyökérkönyvtára',
    '_cgi_bin_mode_www_root' => 'e domain dokumentumgyökere',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioritás',
    'custom_button__place' => 'Hely',
    'custom_button__place_navigation' => 'Közös hozzáférés',
    'custom_button__place_admin' => 'Adminisztrátor kezdőlapja',
    'custom_button__place_admin-settings' => 'Adminisztrátor Eszköz és beállítások oldal',
    'custom_button__place_reseller' => "Viszonteladó kezdőlapja",
    'custom_button__place_reseller-settings' => 'Viszonteladó Eszközök és segédprogramok oldala',
    'custom_button__place_client' => 'Ügyfél kezdőlapja',
    'custom_button__place_domain' => "Előfizetés Webhelyek és domainek oldala",
    'custom_button__place_domain_powerUser' => "Előfizetés Webhelyek és domainek oldala",
    'custom_button__place_domain-properties' => 'Webhely-eszközök',
    'custom_button__private' => 'Megjelenítés kizárólag a számomra',
    'custom_button__image' => 'Háttérkép',
    'custom_button__conhelp' => "Tooltip szöveg",
    'custom_button__edit' => "Egy További szolgáltatás hivatkozásának a beállításai",
    'custom_button__include_client_cname' => "Ügyfél vállalatnevének belefoglalása",
    'custom_button__include_client_email' => "Ügyfél e-mail címének belefoglalása",
    'custom_button__include_client_id' => "Ügyfélazonosító belefoglalása",
    'custom_button__include_client_pname' => "Ügyfél kapcsolattartója nevének belefoglalása",
    'custom_button__include_domain_id' => "Előfizetési, domain és alias azonosító belefoglalása",
    'custom_button__include_domain_id_powerUser' => "Előfizetési, domain és alias azonosító belefoglalása",

    'custom_button__include_domain_name' => "Elsődleges domain név belefoglalása",
    'custom_button__include_ftp_user' => "FTP-felhasználónév belefoglalása",
    'custom_button__include_ftp_pass' => "FTP-jelszó belefoglalása",
    'custom_button__internal_open' => "URL-cím megnyitása a Plesk kezelőpanelen",
    'custom_button__text' => "Gombfelirat",
    'custom_button__url' => "URL-cím",

    'custom_button__not_image' => 'Nem képfájl a fájl.',
    'custom_button__big_image' => 'Nem haladhatja meg a 100 kB-ot a fájlméret.',
    'custom_button__failed_copy_image' => 'Nem lehet másolni e fájlt: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Nem lehet visszaállítani egy nem Power User biztonsági másolatot Power User nézetben.',
    '__unknown_network_interface' => 'Ismeretlen hálózati kezelőfelület',

    'init_conf__ip_address' => 'IP-cím',

    //Confirmation page
    'bt_confirm' => 'Megerősítés',
    'b_confirm' => 'Erősítse meg webhelyei tulajdonjogát.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'A dedikált IIS-alkalmazás készlet beállításai összhangban vannak az egész kiszolgálóra érvényes biztonsági házirenddel (hely elkülönítési konfiguráció).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'A dedikált IIS-alkalmazás készlet beállításai összhangban vannak az egész kiszolgálóra érvényes teljesítmény beállításokkal.',

    '__current' => 'Aktuális',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Majdnem az összes Plesk licence által biztosított domaint felhasználta (90 %-ot vagy többet).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Majdnem az összes domaint felhasználta.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Majdnem az összes Presence Builder weboldalkészítő licence által készíthető weboldalt felhasználta (90 %-ot vagy többet).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Majdnem az össze Presence Builder weboldalkészítővel készíthető weboldalt felhasználta.',
    'promo__button_hide' => 'Elrejtés',
    'promo__button_next' => 'Tovább ť',
    'promo__button_prev' => '<Előző',
    'promo__button_license' => 'Licenc frissítése',

    'promo__google_integration_title' => 'Google szolgáltatásokba integrálás',
    'promo__google_integration' => 'Konfiguráció kiegészítése olyan Google szolgáltatásokkal, mint az AdSense, Google Apps, Webmaster eszközök.',
    'promo__google_integration_button' => 'Konfigurálás',

    'promo__button_learn_more' => 'További tudnivalók',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Az egyéni témák segítségével testre szabhatja a kezelőfelület megjelenését és védjegyezési beállításait. A Plesk témák testre szabására vonatkozó útmutatásokért %1 című részt nézze meg.',
    'panel_branding__description_link' => 'következő dokumentum',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Fájlok kigyűjtése',
    'filemanager_error_extracting_files' => 'Hiba történt az archívumfájlok kicsomagolásakor: %1',
    'filemanager_no_archive_files_specified' => 'Adja meg a kicsomagolandó archívumokat.',
    'filemanager_not_zip_archive_specified' => '%1 nem csomagolható ki, mivel ZIP-archívum.',
    'filemanager_files_successfully_extracted' => 'Ki van csomagolva az archívumfájl.',
    'filemanager_error_file_download' => 'Nem sikerült a fájl letöltése: %1',
    'filemanager__user_poolgrp' => 'Alkalmazáskészlet csoport',

    'loading' => 'Betöltés',
    'bt_create_archive' => 'Archívumhoz adás',
    'filemanager__pack' => "Az archívum elérési útja: %1",
    'filemanager__archive_name' => 'Archívumfájl neve',
    'filemanager__empty_filename' => 'Írja be az archívumfájl nevét.',
    'filemanager_archive_created' => 'Az archívum létrehozása sikerült.',
    'filemanager_error_creating_archive' => 'Nem sikerült az archívum létrehozása: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "E rekord ütközik a zóna AAAA rekordjával.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-kiszolgáló nem támogatja az IPv6-címeket.)",
    'cmd_dns__glue_dns_record_conflict' => 'E rekord ütközik a zóna \'%1\' összetartó rekordjával.',
    '__ftp_ipv6_not_supported' => "(FTP-kiszolgáló nem támogatja az IPv6-címeket.)",
    '__ipv6_not_supported' => 'IPv6 nem támogatott.',
    'mail__ipv6_not_supported' => 'Nem támogatja a levelezési kiszolgáló IPv6-cím használatát.',
    'mail__relay_while_list_ipv6_not_supported' => 'Nem támogatja a levelezési kiszolgáló az IPv6 továbbítási engedélyezési listát.',
    'mail__relay_while_list_ipv6_mask_mul_16' => '16 többszörösének kell a maszkértéknek lennie.',
    'mail__ip_or_mask_is_invalid' => 'Érvénytelen az IP-cím vagy maszk.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Nem támogatott IPv6 IP-címekre történő továbbítás.',
    'sa__invalid_trusted_networks' => 'Helytelenül megadott megbízható hálózatok: %1',
    'dns_add__enter_ipv6_address' => "IPv6-cím",
    'license_trial_days_left' => '%1 napon belül lejáró próbaidős licenccel működik a Plesk kezelőpanelje.',
    'excl_ipv6_num' => 'Dedikált IPv6-cím',
    '__ip_mask' => "Alhálózati maszk",
    '__ipv4_addr' => 'IPv4-cím',
    '__ipv6_addr' => 'IPv6-cím',
    'template__num_excl_ipv6s' => 'Dedikált IPv6-címek viszonteladóhoz rendelése',
    'anonftp__exclusive_ipv4_required' => 'Egy dedikált IPv4-cím szükséges névtelen FTP-szolgáltatás telepítéséhez és használatához.',
    'anonftp__ipv4_already_used' => 'Nem telepíthet névtelen FTP-szolgáltatást e hely számára, mivel már másik domainen ugyanarra az IPv4 címre konfigurálva van.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'A napló megtekintése',

    'chown__error_ip_absent_in_ip_pool' => 'Nem található %1 IP-cím a célfelhasználó IP-cím készletében.',
    'chown__error_ip_not_exist' => 'Nem létezik \'%1\' azonosítójú IP-cím.',
    'chown__error_domain_ip_not_selected' => 'Legalább egy IP-címet ki kell választani %1 domain számára. Ellenőrizze az IP-hozzárendeléshez kiválasztott értékeket.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'Érvénytelen az IPv6-cím vagy maszk. Érvényes egyedi küldési címnek kell az IP-címnek lennie.',

    '__subscriptions' => 'Előfizetések',

    '__owned_by_reseller' => 'viszonteladó a tulajdonos',
    '__owned_by_provider' => 'szolgáltató a tulajdonos',

    'service_plan__anonymous' => 'Egyéni',
    'subscription_not_locked__change_limits_warning' => 'Nincs zárolva ezen előfizetés: A szolgáltatási csomaggal történt szinkronizálás során megváltoztatásra kerülnek az erőforrás-használati korlátok.',
    'subscription_not_locked__change_permissions_warning' => 'Nincs zárolva ezen előfizetés: A szolgáltatási csomaggal történt szinkronizálás során megváltoztatásra kerülnek az engedélyek.',

    'subscription__conflict_resolution_policy' => 'Konfliktus-feloldási politika',
    'subscription__conflict_resolution_policy_lock' => "Előfizetés zárolása",

    'backup__list__backup_warnings' => 'Figyelmeztetések',
    'backup__list__backup_info' => 'Információ',
    'backup__restore__object_reseller_template' => 'Viszonteladói sablon',
    'backup__restore__object_domain_template' => 'Domain sablon',

    'subscription__unable_lock_anonymous' => 'Ezen előfizetés nincs a szolgáltatási csomaghoz rendelve, így nem oldható fel a zárolása.',
    'subscription__unable_sync_anonymous' => 'Ezen előfizetés nincs a szolgáltatási csomaghoz rendelve, így nem szinkronizálható.',
    'subscription__unable_sync_locked' => 'Ezen előfizetés zárolva van, így nem szinkronizálható.',
    'subscription__locked' => 'Zárolva van az előfizetés.',
    'component_name__urlrewrite' => "URL-cím átírása",
    '__quantity' => 'Mennyiség',
    'hst__www_root_dir_absent' =>  'Figyelmeztetés: Nem létezik a dokumentumgyökérként megadott könyvtár.',
    'object_creation__domain_is_not_a_webspace' => 'Kizárólag előfizetés esetén hozható létre az objektum.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Webhelyeket tartalmaz az előfizetés, ezért nem változtatható meg vagy törölhető az üzemeltetési típus.',
    'phosting__apache_error_docs_are_not_enabled' => 'Nem engedélyezettek az egyéni hiba dokumentumok a domainen.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Hiba: Nem sikerült az IP-cím frissítése. Bővítmény domainek nem rendelhetőek olyan IP-címhez, mely nincs az előfizetés fődomainjéhez rendelve.',
    'domain_plan__unable_change' => 'Nem lehetséges a szolgáltatási csomag változtatása: %1.',
    'domain_plan__different_hosting_type' => 'Eltér a szolgáltatási csomagban megadott típustól az aktuális üzemeltetési típus.',
    'domain_plan__addon_text' => 'Bővítőcsomag',
    'domain_plan__addon_description' => 'Bővítőcsomagot használnak egy üzemeltetési csomag kiegészítésére.',
    'asp_net__managed_runtime_version' => 'ASP.NET felügyelt futásiidejű verzió',
    'plan__can_not_change_hosting_type' => 'Egy csomag szerkesztésekor nem lehetséges az üzemeltetési típus megváltoztatása.',
    'plan__apply_problems' => 'A következő funkciók miatt nem történt meg a csomag alkalmazása: %1',
    'plan_save__subscription_update_problem' => '%1 esetében nem alkalmazhatóak a csomagváltoztatások.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "A biztonsági mentési vagy visszaállítási eljárás befejezéséig ideiglenesen felfüggesztésre kerül az előfizetés. Térjen vissza később.",
    '__login_incorrect_plain_shadow_password' => 'Egy érvénytelen jelszót adott meg az adminisztrátor számla. Használja az adminisztrátor hitelesítő adatokat vagy kérdezze le a jelszavát. Az adminisztrátor jelszó lekérdezésével kapcsolatos további tudnivalókért olvassa el a /etc/psa/README.psa.shadow. fájlt.',

    '__perm_denied_ip' => 'Nem küldhet azon IP-címet, amely nem a tulajdona.',

    'dns__dns_zone_not_synchronized' => 'Módosításra került a DNS-zóna. Ha alkalmazni akarja a DNS-sablon változtatásait e zónára, akkor kattintson ezen oldal \'DNS-sablon változtatások alkalmazása\' gombjára vagy válassza ki a Kiszolgáló adminisztrátor kezelőpanel > Eszközök és beállítások > DNS-sablon beállítások > DNS-sablon változtatások alkalmazása menüpontot, majd jelölje ki a \'Változtatások összes zónára alkalmazása\' beállítást.',
    'dns__dns_zone_synchronize_link' => 'Kattintás',
    'dns__dns_zone_synchronize_done' => 'A DNS-zóna szinkronizálása sikerült.',

    'dns__dns_zone_template_error' => 'Problémák történtek a DNS-zónáknak a DNS-zóna sablonnal szinkronizálása során. %1',

    'dns__soa_rname_type_owner' => 'Webhely tulajdonos e-mail címe',
    'dns__soa_rname_type_domain' => 'Domain e-mail címe',
    'dns__soa_rname_type_external' => 'Külső e-mail cím',
    'dns__soa_rname_enforce_email' => 'RNAME e-mail cím változtatásának megtiltása domainenként',
    'dns__soa_rname_label' => 'E mail (RNAME)',
    'dns__soa_rname_hint' => 'A domain DNS-zónájáért felelős személy e-mail címe. SOA-lekérdezésekre küldte válaszként a DNS-kiszolgáló.',

    'dns__dns_zone_soa_sync_title' => 'Valamennyi létező domain beállításainak a felülbírálása',
    'dns__dns_zone_soa_sync_legend' => 'Megerősítés szükséges',
    'dns__dns_zone_soa_sync_text' => 'Frissíti az összes üzemeltetett domain SOA-rekordjait a SOA-sablonon végzett változtatások alkalmazásával?',

    'cu_db__repair_mysql_dbus' => "Javítsa ki a MariaDB/MySQL felhasználói jelszavakat. Akkor szükséges e művelet, amikor egy korábbi verzióról Plesk 11 magasabb verzióra frissítést végzett.",

    'cu_scheduled_backup_comment' => 'Ütemezett biztonsági mentés',
    'cu_scheduled_backup_error' => 'Hiba történt a biztonsági mentés során. %1',
    'cu_scheduled_backup_mail_subject' => '<%1> hiba történt az ütemezett biztonsági mentési eljárás során.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk belépési pont: %2\n\nA következő hibák történtek az ütemezett biztonsági mentés során:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Óránkénti biztonsági mentés',
    'cu_scheduled_backup_daily' => 'Napi biztonsági mentés',
    'cu_scheduled_backup_weekly' => 'Heti biztonsági mentés',
    'cu_scheduled_backup_monthly' => 'Havi biztonsági mentés',
    'cu_scheduled_backup_comment_backup_all' => '%1. Az összes konfiguráció és tartalom.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Az email üzenetek kivételével az összes konfiguráció és tartalom.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Csak konfiguráció és e-mail üzenetek.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. A felhasználói adatbázisok kivételével az összes konfiguráció és tartalom.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. A felhasználói fájlok kivételével az összes konfiguráció és tartalom.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Csak konfiguráció és felhasználói adatbázisok.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Csak konfiguráció és felhasználói fájlok',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Domain konfiguráció.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Ütemezett biztonsági mentések felhőalapú tárolása egy prémium funkció. A feloldása érdekében forduljon az üzemeltetőjéhez.',

    'i_backup_invalid_file' => 'Ez nem egy érvényes biztonsági másolat. Nem állíthatóak vissza az adatok e fájlból. Kattintson a biztonsági másolat fájl nevére a részletekért.',

    'filemanager_resulting_archive_exists' => '%1 fájl már létezik a célkönyvtárban.',

    'agent_unable_to_connect' => 'Nem lehet kapcsolódni az ügynökhöz \'%2\' esetében. Ellenőrizze, hogy telepítve van-e és fut-e az ügynök, továbbá nincsenek-e \'%2\' állomáshoz kapcsolódási problémák.',
    'agent_test_connection_failed' => '\'%2\' ügynökéhez kapcsolódás nem sikerült.',

    'agent_unable_to_resolve_host' => 'Nem lehet \'%1\' távoli állomás helyét meghatározni. Ellenőrizze, hogy nincsenek-e az állomáshoz kapcsolódási problémák.',
    'agent_unknown_curl_error' => '\'%1\' hiba történt \'%2\' ügynökéhez kapcsolódás során.',
    'agent_unexpected_htp_code' => '\'%1\' váratlan HTTP-kód érkezett a HTTP-kérelemre \'%2\' ügynökéhez.',
    'agent_unable_to_auth' => 'Nem lehet hitelesítést végezni \'%1\' állomáson. E probléma megoldásához kövesse a következő című webhely útmutatásait: http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Egy belső kiszolgáló hiba történt \'%1\' távoli állomáson történő parancs végrehajtása során.',
    'agent_response_is_empty' => 'Egy üres válasz érkezett a HTTP-kérelemre \'%1\' ügynöke számára.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Nem található az Áttelepítési és az átviteli ügynök a helyi gyorsítótárban. Nyissa meg újra az Áttelepítési és az átviteli ügynököt és javítsa ki a problémát.',

    '__hosting_webdeploy' => "Web Deploy közzététele",
    'cu_domain__webdeploy' => "Web Deploy alkalmazáscsomag közzététele (alapértelmezett: %1)",
    'cu_dom_tpl__webdeploy' => "Web Deploy alkalmazáscsomag közzététele (alapértelmezett: %1)",
    'cu_subdomain__webdeploy' => "Web Deploy alkalmazáscsomag közzététele (alapértelmezett: %1)",
    'webdeploy__not_installed' => "Nincs telepítve a Microsoft Web Deploy a kiszolgálón.",
    'webdeploy__forced_by_site_isolation' => "Nem lehetséges a Web Deploy közzétételi beállítások megváltoztatása: Nem rendelkezik az egész kiszolgálóra érvényes házirend felülbírálására vonatkozó engedéllyel. A részletekért forduljon a szolgáltatójához.",



    'backup__restore_options__admin__server_configuration_license' => 'Licenckulcs',
    'migration_start_migrate_server_license' => 'Licenckulcs átvitele',

    'defaultcomponents__delegation_rule_not_exist' => '(nem létezik a szükséges \'appPoolPipeline, appPoolNetFx\' delegálási szabály)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Adminisztrátor hozta létre a biztonsági másolatot.',
    'i_backup_created_by_reseller' => 'Egy viszonteladó hozta létre a biztonsági másolatot.',
    'i_backup_created_by_client' => 'Egy ügyfél hozta létre a biztonsági másolatot.',

    'migration__object_exists_on_target_host' => '(már létezik a célállomáson)',

    'cu_cl_pref__manage_website_maintenance' => 'Speciális műveletkehez való hozzáférés: Webhely másolása',
    'cu_cl_pref__manage_protected_dirs' => 'Jelszóval védett könyvtárak kezelése',
    'cu_cl_pref__manage_mail_settings' => 'Levelezési beállítások változtatásának a képessége',


    'cu__command_update_php_settings' => 'Frissíti a PHP-beállításokat.',
    'cu__php_settings_option' => 'Beállítja a PHP-beállításokkal rendelkező fájlt.',

    'cu__additional_php_settings_option' => 'Állítsa a további PHP-direktívákkal rendelkező fájl elérési útját.',
    'cu__command_show_php_settings' => 'Az aktuális PHP-beállításokat jeleníti meg.',
    'cu__general_settings' => 'Általános beállítások:',
    'cu__performance_settings' => 'Teljesítmény beállítások:',
    'cu__php_fpm_settings' => 'PHP-FPM beállítások:',
    'cu__additional_directives' => 'További irányelvek:',

    'php_settings_permission_required' => 'Általános PHP-beállítás kezelés',
    'php_settings_performance_permission_required' => 'Üzemeltetési teljesítmény beállítások kezelése',
    'php_settings_customized' => 'Testre lettek szabva a PHP-beállítások.',
    'php_settings_synchronized_with_plan' => 'Szinkronizálni kell a csomaggal a PHP-beállításokat.',
    'phosting__unknown_shell_type' => 'Nem elérhető héj',

    'login_up__access_denied_subscription_deleted' => 'Hozzáférés megtagadva: Eltávolításra került az előfizetése.',

    'role_restricted_to_subscription' => '(az előfizetéssel küldött: %1)',

    'filemanager__extract' => "Fájlok kicsomagolása a következő helyre: %1",

    'cu__license_command_check_installed_license' => 'Ellenőrizze a telepített licenckulcs érvényességét (a 0 kilépési kulccsal válaszol érvényesség esetén, míg 1 értékkel érvénytelenség esetén).',

    'promo__mobile_manager_title' => 'Plesk kiszolgáló mobilkezelő',
    'promo__mobile_manager' => "Bővítse ki a Plesk funkcióit, hogy mobileszközökről (BlackBerry, iPhone és Android) is tudja vezérelni és ellenőrizni a kiszolgálót.",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Bármikor és bárhonnan kérdezze le a Plesk kiszolgálókra vonatkozó legfontosabb adatokat egy mobileszközről (BlackBerry, iPhone és Android).',
    'promo__mobile_button' => 'További tudnivalók',

    'subDomainNameHint' => 'Aldomain névként egy * karaktert írjon be egy helyettesítő aldomain létrehozására. A böngészőbe beírt aldomain névtől független a webhely látogatói átirányításra kerülnek ezen aldomainre.',
    'subdomains__wildcard_name_invalid' => "Érvénytelen az aldomain név. Kizárólag alfanumerikus karaktereket, egy kötőjelet (-) és csillagot (*) használhat helyettesítő aldomain nevekhez.",
    'subdomains__name_invalid' => "Érvénytelen az aldomain név. Kizárólag alfanumerikus karaktereket és egy kötőjelet (-) használhat aldomain nevekhez.",

    'domain__wildcard_no_www_prefix' => 'Helyettesítő aldomainek számára nem lehetséges www előtag használata.',

    '__service_title__milter' => "Plesk Postfix levélszűrő",
    '__service_description__milter' => "Plesk Postfix levélszűrő",
    '__milter' => "Postfix levélszűrő",
    'restart__milter' => "Plesk levélszűrő (%1)",
    'restart__pop3' => "Courier POP3-kiszolgáló",
    'restart__pop3s' => "Courier POP3-kiszolgáló SSL/TLS-támogatással",
    'restart__imap' => "Courier IMAP-kiszolgáló",
    'restart__imaps' => "Courier IMAP-kiszolgáló SSL/TLS-támogatással",
    'restart__authdaemon' => "Courier IMAP hitelesítési démon",
    'restart__imap-pop3' => "Dovecot IMAP- és POP3-kiszolgáló",


    'addon_packages_not_supported' => 'Nem támogatottak az APS csomagolt webalkalmazások bővítői.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Nem lehet egy domainhez automatikusan egy IP-címet rendelni. Az IP-beállítás használatával adjon meg egy IP-címet.',

    'plesk_key__mb_accounts' => 'Felhasználói számlák (viszonteladók és ügyfelek) a Customer & Business Manager összetevőben',

    'actionlog__subdomain_dns' => 'Aldomain DNS-zóna',
    'actionlog__site_subdomain_dns' => 'Egy további zóna aldomainjének DNS-zónája',

    // PfW only
    'actionlog__event_site_create' => 'Domain létrehozva',
    'actionlog__event_site_delete' => 'Domain törölve',
    'actionlog__event_site_update' => 'Domain frissítve',

    'actionlog__event_site_status_update' => 'Domain állapot frissítve',
    'actionlog__event_site_dns_update' => 'Domain DNS-zóna frissítve',
    'actionlog__event_site_guid_update' => 'Domain GUID frissítve',

    'actionlog__event_site_subdomain_create' => 'Aldomain létrehozva',
    'actionlog__event_site_subdomain_delete' => 'Aldomain törölve',
    'actionlog__event_site_subdomain_update' => 'Aldomain frissítve',

    'actionlog__event_site_alias_create' => 'Domain alias létrehozva',
    'actionlog__event_site_alias_delete' => 'Domain alias törölve',
    'actionlog__event_site_alias_update' => 'Domain alias frissítve',

    'actionlog__event_site_alias_dns_update' => 'Domain alias DNS-zónája frissítve',
    'actionlog__event_subdomain_dns_update' => 'Megtörtént az alapértelmezett domain aldomainje DNS-zónájának a frissítése.',
    'actionlog__event_site_subdomain_dns_update' => 'Aldomain DNS-zónája frissítve',
    // End of PfW only

    'win_policy__bad_password' => 'Az érvényesítés nem sikerült. A jelszó érvénytelen.',
    'win_policy__password_too_short' => 'Az érvényesítés nem sikerült. Nem felel meg a jelszó a jelszó házirend követelményeinek, mivel túl rövid.',
    'win_policy__password_too_long' => 'Az érvényesítés nem sikerült. Nem felel meg a jelszó a jelszó házirend követelményeinek, mivel túl hosszú.',
    'win_policy__password_not_complex_enough' => 'Nem sikerült az ellenőrzés. Nem elég összetett a jelszava, és nem felel meg a jelszóházirend követelményeinek. Egy erős jelszónak legalább a következőket kell tartalmaznia: nyolc karakter, egy nagy- vagy kisbetű; három szám és egy speciális karakter (!, @, #, $, %, ^, &, *, ?, _, ~) vagy egy szám és két speciális karakter.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Nem lehetséges a terméklicenc frissítése.',


    'filemanager__error_path_is_not_allowed' => 'Nem engedélyezett az elérési út.',
    'filemanager__error_path_is_invalid' => 'Érvénytelen az elérési út.',
    'filemanager__error_path_not_found' => 'Nem található az elérési út.',
    'filemanager__error_path_already_exists' => 'Már létezik az elérési út.',
    'filemanager__error_access_is_denied' => 'Hozzáférés megtagadva.',
    'filemanager__error_directory_not_empty' => 'Nem üres a mappa.',
    'filemanager__error_sharing_violation' => 'Megosztásmegsértés',
    'filemanager__error_not_same_device' => 'Nem ugyanazon az eszközön van a cél elérési út.',
    'filemanager__unable_to_resolve_realpath' => "Nem található %1 fájl a megadott helyen.",
    'filemanager__access_to_realpath_denied' => "El van utasítva a realpath funkció hozzáférés: %1 - %2.",
    'bt_exit' => 'Kilépés',

    'filemanager__copy_error__' => "%1 fájl %2 helyre másolása nem lehetséges: %3",
    'filemanager__copy_move' => "Fájlok másolása (áthelyezése) %1 helyről",
    'filemanager__count_size__' => 'Kijelölt méret: %1',
    'filemanager__count_size_error__' => '%1 méretének meghatározása nem lehetséges: %2',
    'filemanager__create_dir_error__' => "%1 könyvtár létrehozása nem lehetséges: %2",
    'filemanager__dir_not_exists' => "%1 könyvtár nem létezik.",
    'filemanager__dirname' => "Könyvtárnév",
    'filemanager__filename' => "Fájlnév",
    'filemanager__is_no_such' => "%1 néven nem található könyvtár vagy fájl",
    'filemanager__empty_selection' => "Nincs(enek) fáj(lok) kiválasztva.",
    'filemanager__move_error__' => "%1 áthelyezése %2 helyre nem lehetséges: %3",
    'filemanager__not_allowed' => "E fájl engedélyeinek változtatása nem engedélyezett a számára.",
    'filemanager__remove' => "Fájlok árhelyezése %1 helyről",
    'filemanager__remove_error__' => "%1 fájl eltávolítása nem lehetséges: %2",
    'filemanager__set_win_permissions_dir' => "%1 mappa engedélyeinek beállítása",
    'filemanager__set_win_permissions_file' => "%1 fájl engedélyeinek beállítása",
    'filemanager__touch_confirm' => "Biztosan módosítani kívánja a kijelölt fájlok időbélyegét?",
    'filemanager__upload_error__' => "%1 feltöltése %2 helyre nem lehetséges: %3",
    'filemanager__upload_file' => "Fájl feltöltése",
    'filemanager__upload_file_src' => "Fájl elérési útja",

    '__fastcgi_unix_support' => 'FastCGI támogatás',

    'dns__subdomain_dns_zone_parent' => 'Ezen aldomain DNS-rekordjainak tárolása a szülő DNS-zónában történik. Módosíthatja %1 szülőzónát vagy külön zónát hozhat létre az aldomain számára.',
    'dns__subdomain_dns_zone_parent_link' => 'itt',
    'dns__no_dns_zone' => 'Nincs domainnel DNS-zóna hozzárendelés. Domainje DNS-zónája kezeléséhez az \'Alapértelmezések visszaállítása\' gombot kell megnyomnia.',
    'dns__unable_turn_on_subdomain_zone' => 'Nem lehetséges az aldomain zónájának aktiválása, mivel a szülőzónájában nincs CNAME-rekord ezen aldomain számára.',

    '__hosting_write_modify' => 'További írás/olvasás engedélyek',

    'aspdotnet__group_framework_version' => "Keretrendszer verzió",

    'bt_restore_default' => "Beállítás alapértelmezettként",
    'b_autoinstaller' => 'Frissítse a Plesk kezelőpanelt vagy az összetevőit.',
    'b_autoinstaller_configure' => 'Frissítse a beállításokat.',
    'b_autoinstaller_install' => 'Telepítse a kiválasztott összetevőket.',

    '__iis_app_pool__use_dedicated' => 'Dedikált IIS alkalmazási készlet',
    '__iis_app_pool__use_dedicated_addons' => 'Dedikált IIS alkalmazási készlet mindegyik webhely számára',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32 bites alkalmazások engedélyezése',
    '__iis_app_pool__load_user_profile' => 'A felhasználói profil betöltése',
    'bt_iis_app_pool' => "IIS-alkalmazás készlet",

    'performance__cpu_usage' => 'Maximális CPU-használat (%)',
    'performance__cpu_usage_action' => 'Korlátozási művelet',
    'performance__cpu_usage_interval' => 'Korlátozási időköz (perc)',
    'performance__cpu_usage_action_not_supported' => 'Nem támogatja a webkiszolgáló a megadott műveletet.',

    'performance__idle_timeout_action_not_supported' => 'Nem támogatja a webkiszolgáló a megadott üresjárati időkorlát műveletet.',
    'performance__max_worker_processes' => 'A feldolgozófolyamatok maximális száma',
    'performance__idle_timeout' => 'Üresjárat időkorlátja (perc)',
    'performance__idle_timeout_action' => 'Üresjárat időkorlátja művelet',
    'performance__recycling_by_time' => 'Újrahasznosítás rendszeres időközökben (perc)',
    'performance__recycling_by_requests' => 'Újrahasznosítás maximális kérelemszám elérése esetén',
    'performance__recycling_by_virtual_memory' => 'Újrahasznosítás maximális virtuális memória használat esetén',
    'performance__recycling_by_private_memory' => 'Újrahasznosítás maximális saját memória használat esetén',
    'performance__managed_pipeline_mode' => 'Felügyelt folyamatkezelési mód',
    'performance__managed_pipeline_mode_not_supported' => 'Nem támogatja a webkiszolgáló a megadott módot.',

    'iis_app_pool' => 'IIS-alkalmazás készlet kezelése.',
    'b_iis_app_pool' => 'Végezze el az IIS-alkalmazás készlet kezelését.',
    'iis_app_pool_cl_dom' => 'IIS-alkalmazás készlet kezelése.',

    'bt_protect' => 'Védett',
    'bt_unprotect' => 'Védelem eltávolítása',
    'bt_show_additional_users' => 'Több felhasználó megjelenítése',
    'bt_hide_additional_users' => 'Kevesebb felhasználó megjelenítése',
    'error_doc__code_400' => 'Hibás kérelem',
    'error_doc__code_401' => 'Jogosulatlan',
    'error_doc__code_401.1' => 'Jogosulatlan - Nem sikerült a bejelentkezés.',
    'error_doc__code_401.2' => 'Jogosulatlan - Nem sikerült a bejelentkezés a kiszolgáló konfiguráció miatt.',
    'error_doc__code_401.3' => 'Jogosulatlan - Jogosulatlan az erőforráson lévő ACL miatt.',
    'error_doc__code_401.4' => 'Jogosulatlan - Nem sikerült a hitelesítés a szűrő miatt.',
    'error_doc__code_401.5' => 'Jogosulatlan - Nem sikerült a hitelesítés az ISAPI/CGI alkalmazás miatt.',
    'error_doc__code_401.7' => 'Jogosulatlan - Visszautasítva az URL-cím engedélyezési házirend miatt.',
    'error_doc__code_403' => 'Tiltott',
    'error_doc__code_403.1' => 'Tiltott - Végrehajtási hozzáférés elutasítva.',
    'error_doc__code_403.2' => 'Tiltott - Olvasási hozzáférés elutasítva.',
    'error_doc__code_403.3' => 'Tiltott - Írási hozzáférés elutasítva.',
    'error_doc__code_403.4' => 'Tiltott - SSL szükséges.',
    'error_doc__code_403.5' => 'Tiltott - SSL 128 szükséges.',
    'error_doc__code_403.6' => 'Tiltott - IP-cím elutasítva.',
    'error_doc__code_403.7' => 'Tiltott - Ügyfél tanúsítvány elutasítva.',
    'error_doc__code_403.8' => 'Tiltott - Oldal hozzáférés elutasítva.',
    'error_doc__code_403.9' => 'Tiltott - Túl sok felhasználó.',
    'error_doc__code_403.10' => 'Tiltott - Érvénytelen konfiguráció.',
    'error_doc__code_403.11' => 'Tiltott - Jelszó változtatás',
    'error_doc__code_403.12' => 'Tiltott - Elutasított hozzárendelő hozzáférés.',
    'error_doc__code_403.13' => 'Tiltott - Ügyfél tanúsítvány visszavonva.',
    'error_doc__code_403.14' => 'Tiltott - Könyvtárlista elutasítva.',
    'error_doc__code_403.15' => 'Tiltott - Ügyfél hozzáférési licencszám túllépve.',
    'error_doc__code_403.16' => 'Tiltott - Nem megbízható vagy helytelen formátumú ügyfél tanúsítvány',
    'error_doc__code_403.17' => 'Tiltott - Lejárt vagy még nem érvényes ügyfél tanúsítvány.',
    'error_doc__code_403.18' => 'Tiltott - Nem lehetséges a kérelem végrehajtása ezen alkalmazás-készletből.',
    'error_doc__code_403.19' => 'Tiltott - CGI hozzáférés elutasítva-',
    'error_doc__code_403.20' => 'Tiltott - Nem sikerült a jelszavas bejelentkezés.',
    'error_doc__code_404' => 'Nem található.',
    'error_doc__code_404.2' => 'Nem található - Elutasítva a zárolási házirend miatt.',
    'error_doc__code_404.3' => 'Nem található - Eliutasítva az MIMEMAP házirend miatt.',
    'error_doc__code_405' => 'Nem engedélyezett a módszer.',
    'error_doc__code_406' => 'Nem fogadható el.',
    'error_doc__code_407' => 'Proxy hitelesítés szükséges.',
    'error_doc__code_408' => 'Kérelem időtúllépés',
    'error_doc__code_412' => 'Sikertelen előfeltétel.',
    'error_doc__code_414' => 'Túl hosszú a kérelem URI-címe.',
    'error_doc__code_415' => 'Nem támogatott médiatípus',
    'error_doc__code_431' => 'Túl nagyok a kérelem fejléc mezők.',
    'error_doc__code_500' => 'Belső kiszolgáló hiba',
    'error_doc__code_500.12' => 'Belső kiszolgáló hiba - Alkalmazás újraindítása',
    'error_doc__code_500.13' => 'Belső kiszolgáló hiba - Foglalt a kiszolgáló.',
    'error_doc__code_500.15' => 'Belső kiszolgáló hiba - Tiltottak a GLOBAL.ASA közvetlen kérések.',
    'error_doc__code_500.16' => 'Belső kiszolgáló hiba - UNC hozzáférési hiba',
    'error_doc__code_500.17' => 'Belső kiszolgáló hiba - URL-hitelesítés tár nem található.',
    'error_doc__code_500.18' => 'Belső kiszolgáló hiba - URL-hitelesítés tár nem nyitható meg.',
    'error_doc__code_500.19' => 'Belső kiszolgáló hiba - Nem megfelelő fájl metaadatok.',
    'error_doc__code_500.100' => 'Belső kiszolgáló hiba - ASP hiba',
    'error_doc__code_501' => 'Nincs implementálva.',
    'error_doc__code_502' => 'Hibás átjáró',
    'error_doc__code_503' => 'A szolgáltatás átmenetileg nem áll rendelkezés.',

    'mimetype_edit__already_exists' => 'A MIME-típus már meghatározásra került ezen bővítmény számára.',
    'mimetype_edit__not_exists' => 'Nem létezik a MIME-típus.',

    'php__group_php_version' => "PHP-verzió",

    'virtualdir__path' => 'Útvonal',
    'virtualdir__read' => 'Olvasási engedély',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Írási engedély',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Parancsprogram forrás hozzáférése',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Könyvtár böngészése',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Engedélyek végrehajtása',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Látogatások naplózása',
    'virtualdir__app_create' => 'Alkalmazás létrehozása',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Névtelen hitelesítést kapcsol be.',
    'virtualdir__auth_windows' => 'A Windows hitelesítést kapcsolja be.',
    'virtualdir__auth_not_enabled' => 'Bekapcsolva kell lennie a Névtelen vagy Windows hitelesítésnek.',
    'virtualdir__require_ssl' => 'SSL/TLS igénylése',
    'virtualdir__enable_default_doc' => 'Alapértelmezett dokumentumok használata',
    'virtualdir__default_doc' => 'Alapértelmezett dokumentum keresési sorrend',
    'virtualdir__enable_parent_paths' => 'Szülő elérési út használatának engedélyezése',
    'virtualdir__execute_in_mta' => 'MTA (többszálas apartman) módban történő használat engedélyezése',
    'virtualdir_create__title' => 'Virtuális könyvtár létrehozása %1 keretein belül',
    'virtualdir_edit__title' => '%1 virtuális könyvtár tulajdonságai',
    'virtualdir_edit__legend' => 'Virtuális könyvtár',
    'virtualdir_edit__application_legend' => 'Alkalmazás beállításai',
    'virtualdir_edit__security_legend' => 'Könyvtár biztonsága',
    'virtualdir_edit__documents_legend' => 'Dokumentumok',
    'virtualdir_edit__list_legend' => 'Beágyazott virtuális könyvtárak',
    'virtualdir_error__path_not_in__' => 'Érvénytelen elérési út került megadásara.',
    'virtualdir_root' => 'Virtuális könyvtárak',
    'virtualdir_root__title' => 'Virtuális könyvtárak',
    'virtualdir_root__list_legend' => 'Virtuális könyvtárak',
    'virtualdir_se__none' => 'Nincs',
    'virtualdir_se__script' => 'Csak parancsprogramok',
    'virtualdir_se__script_execute' => 'Parancs- és végrehajtható programok',
    'virtualdirs__title' => 'Virtuális könyvtárak',
    'virtualdirs__path_not_exists' => 'Érvénytelen elérési út.',
    'virtualdirs__select_for_remove' => "Válassza ki az eltávolítandó virtuális könyvtárakat.",
    'virtualdirs_remove__title' => 'Virtuális könyvtárak eltávolítása',

    'asp_max_buffer_text' => 'ASP-puffer maximális mérete (kB)',
    'asp_max_body_text' => 'ASP-kérelem egység törzsének maximális mérete (kB)',
    'asp_buffers_legend' => 'ASP beállítások',
    'asp_client_debug_text' => 'ASP ügyféloldali parancsprogram hibakeresés',
    'asp_server_debug_text' => 'ASP kiszolgálóoldali parancsprogram hibakeresés',

    'permissions__group_or_user_name' => 'Csoport- vagy felhasználónevek',
    'permissions__FullControl' => 'Teljes hozzáférés',
    'permissions__Modify' => 'Módosítás',
    'permissions__ReadAndExecute' => 'Olvasás és végrehajtás',
    'permissions__ListFolderContents' => 'Mappatartalmak listázása',
    'permissions__Read' => 'Olvasás',
    'permissions__Write' => 'Írás',
    'permissions__ReadControl' => 'Vezérlőadatok olvasása',
    'permissions__WriteControl' => 'Írás ellenőrzés',
    'permissions__ExecuteControl' => 'Végrehajtás ellenőrzés',
    'permissions__TraverseFolderOrExecuteFile' => 'Mappa bejárása/fájl végrehajtása',
    'permissions__ListFolderOrRead' => 'Mappa listázása / adat olvasása',
    'permissions__CreateFilesOrWrite' => 'Fájlok létrehozása/adat írása',
    'permissions__CreateFoldersOrAppend' => 'Mappák létrehozása/adat hozzáfűzése',
    'permissions__DeleteSubfoldersandFiles' => 'Almappák és fájlok törlése',
    'permissions__Delete' => 'Törlés',
    'permissions__ChangePermissions' => 'Engedélyek módosítása',
    'permissions__TakeOwnership' => 'Tulajdonba vétel',
    'permissions__inherited_from' => 'Örökölt a következő helyről;',
    'permissions__not_inherited' => '<not inherited>',
    'permissions__apply_to' => 'Alkalmazás a következőre',
    'permissions__apply_onto' => 'Alkalmazás a következőre:',
    'permissions__apply_onto1' => 'Csak e mappa',
    'permissions__apply_onto2' => 'Csak almappák',
    'permissions__apply_onto3' => 'E mappa és almappák',
    'permissions__apply_onto4' => 'Csak fájlok',
    'permissions__apply_onto5' => 'E mappa és fájlok',
    'permissions__apply_onto6' => 'Csak almappák és fájlok',
    'permissions__apply_onto7' => 'E mappa, almappák és fájlok',

    'filemanager__not_allowed_dir' => "E mappa engedélyeinek változtatása nem engedélyezett a számára.",

    'filemanager__allow' => "Engedélyezés",
    'filemanager__deny' => "Megtagadás",
    'filemanager__user_domusr' => 'Webhely adminisztrátor',
    'filemanager__user_webusr' => 'Webes felhasználó',
    'filemanager__user_admins' => 'Adminisztrátorok',
    'filemanager__user_system' => 'RENDSZER',
    'filemanager__user_aspnet' => 'ASP.NET felhasználó',
    'filemanager__user_poolusr' => 'Alkalmazáskészlet felhasználó',
    'filemanager__user_sysaccount' => 'További rendszerfelhasználó',

    'bt_permissions_advanced' => 'Speciális',
    'b_permissions_advanced' => 'Kattintson speciális engedélyek megtekintéséhez és beállításához.',

    'hotlink-protection_invalid_friend_domain' => 'Érvénytelen a közelálló domain neve.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplikálva van a közelálló domainek neve.',
    'hotlink-protection_invalid_extensions' => 'Nem megfelelő karaktereket tartalmaznak a fájlnév kiterjesztések.',

    'i_domain_alias_status_on' => 'Engedélyezve van a domain alias.',
    'i_domain_alias_status_off' => 'Le van tiltva a domain alias.',
    'i_domain_alias_status_with_parent' => 'Le van tiltva a domain alias, mivel ki van kapcsolva a domain alias.',
    'i_domain_alias_turn_off' => 'Kattintson a letiltáshoz.',
    'i_domain_alias_turn_on' => 'Kattintson az engedélyezéshez.',

    'domain_alias__control_title' => '%1 domain alias',
    'domain_alias__control_info_legend' => 'Információ',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Szolgáltatás neve',
    'domain_alias__control_details_title' => 'Részletek',

    'domain_alias__invalid_values' => 'Érvénytelen a megadott domain név. Betűket, számjegyeket és kötőjeleket tartalmazhatnak a domain nevek. Nem lehetnek 63 szimbólumnál hosszabbak a domain név eges pontok közötti szakaszai.',
    'domain_alias__domain_already_exists' => "Helytelen %1 domain alias név. %1 aldomain már létezik.",
    'domain_alias__www_prefix_domain_already_exists' => "Helytelen domain alias www név.%1. Ezen alias már létrehozásra már megtörtént %1 domain számára.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Helytelen domain alias webes levelezési név.%1. Ezen alias már létrehozásra már megtörtént %1 domain számára.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Helyetelenek az domain alias listák nevei.%1. Ezen alias már létrehozásra már megtörtént %1 domain számára.',
    'domain_alias__dns_record_already_exists' => 'Nem sikerült %1 domain alias beállítása, mivel már létezik egy %1 állomásra mutató DNS-rekord.',
    'domain_alias__domain_alias_already_exists' => "Ilyen nevű domain alias már létezik.",
    'domain_aliases__mail_server_not_support_aliases' => 'A levelezési kiszolgáló nem támogatja a domain alias funkciót. Előfordulhat, hogy nem működnek megfelelően a domain aliasok.',
    'domain_alias__restrict_domain_creation' => 'Az egész kiszolgálóra érvényes házirend tiltja egy domain alias számára megadott nevet. Ha Önhöz tartozik e domain alias név, akkor forduljon az üzemeltetési szolgáltatójához.',
    'domain_alias__restrict_creation_with_www' => 'Egy \'www\' előtag nélküli domain nevet írjon be. Automatikusan megtörténik a www előtag webkiszolgáló konfigurációhoz adása a domain számára',
    'domain_unable_to_set_name' => 'Helytelen %1 domain név.',

    'domain_alias__domain_service_dns_disabled' => 'Egy másik DNS-kiszolgáló szolgálja ki e domaint.',
    'domain_alias__domain_service_dns_enabled_master' => 'E DNS-kiszolgáló most elsődleges névkiszolgálóként működik e DNS-zóna esetén.',
    'domain_alias__domain_service_dns_enabled_slave' => 'E DNS-kiszolgáló most másodlagos névkiszolgálóként működik e DNS-zóna esetén.',
    'domain_alias__domain_service_mail_enabled' => 'Aktiválva van a levelezési szolgáltatás a domain számára.',
    'domain_alias__domain_service_mail_disabled' => 'Ki van kapcsolva a domain levelezési szolgáltatása.',
    'domain_alias__domain_service_mail_mx' => '%1 levelezési kiszolgálóként használatos.',

    'domain_alias__service_seoRedirect_hint' => 'Ha a látogatók megnyitják az alias URL-címét, akkor az elsődleges domain URL-címére kerülnek átirányításra. Keresőbarát HTTP 301 átirányítást használ a Plesk, mely azt jelenti, hogy a keresőmotor rangsorolás nem kerül felosztásra az URL-címek között.',

    'bt_task_run_now' => 'Futtatás most',
    'ftp__read_perm' => "Olvasási engedély",
    'ftp__write_perm' => "Írási engedély",

    'filemanager__upload_backup_file_hint' => 'Itt végezhető el a biztonsági másolat fájlok feltöltése a Plesk tárolóba. Két gigabájtra korlátozott a maximális fájlméret.',

    '__default_for_mssql' => 'MS SQL alapbeállítása',

    '__login_does_not_pass_validation' => "Érvénytelen a felhasználónév. Ellenőrizze, hogy megfelel-e a következő követelményeknek: %1",
    '__login_allowed_symbols' => 'Pontokat, kötőjeleket és aláhúzásjeleket beleértve kizárólag alfanumerikus karakterek használat engedélyezett. Alfanumerikus karakternek kell az első karakternek lennie.',

    'restart__nginx' => 'Fordított proxykiszolgáló (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Általános termékinformációkat és közleményeket szeretnék kapni a Plesktől.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Biztonsággal kapcsolatos információkat és egyéb műszaki értesítéseket akarok kapni a Plesktől.",

    '__login_status_inactive' => 'Inaktív a számlája. Forduljon a Plesk adminisztrátorhoz.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Térjen vissza az Eszközök és beállítások oldalra. A háttérben folytatódik az áttelepítés.',

    'chk_js__warning_about_ftp_login_syntax' => "Alfanumerikus karaktereket, kötőjelet és aláhúzásjelet használhat a felhasználónévben.",
    'chk_js__warning_about_passwd_syntax' => "Ne használjon idézőjeleket, betűközt és nemzeti karaktereket a jelszóban.\n%1 és %2 között kell a jelszó karakterszámának lennie, és nem tartalmazhatja a felhasználónevet.",
    'chk_js__warning_about_plesk_login_syntax' => "Kisbetűs alfanumerikus karaktereket, pontot, kötőjelet és aláhúzásjelet használhat a felhasználónévben.",
    'chk_js__warning_about_admin_passwd_syntax' => "Ne használjon idézőjeleket, szóközt, pontosvesszőt és a helyi ábécé betűit egy jelszóban.\n %1 - %2 karakternek kell a jelszónak hosszának lennie és nem tartalmazhatja a felhasználónevet.",

    'cmd_server__admin_alias_not_found' => "Nem található a további adminisztrátor számla.",

    'panel_branding__skins_already_exists' => "Megjegyzés: '%1' téma már létezik. Az éppen telepített téma kerül a helyére.",
    'panel_branding__skins_file_exists' => "Nem lehet könyvtárat létrehozni '%1' téma számára: Ilyen nevű fájl már létezik.",

    'actionlog__login_failed' => 'nem sikerült a bejelentkezés',
    'actionlog__event_cp_user_login_failed' => 'Plesk felhasználó bejelentkezése nem sikerült.',
    'actionlog__api_login_failed' => 'nem sikerült az API-felületen keresztüli bejelentkezés',
    'actionlog__event_cp_user_api_login_failed' => 'Nem sikerült az API-felületen keresztüli bejelentkezés',
    'actionlog__pw_reset' => 'kért új jelszó létrehozás',
    'actionlog__pw_admin_force_reset' => 'kért kényszerített adminisztrátor jelszó visszaállítás',

    'ch_pass_admin__email_subject' => "Új Plesk jelszó kérése",
    'ch_pass_admin__email_body' => "Helló, %1!\n\nBiztonsági okokból nem küldhető el e-mailben az adminisztrátor jelszava.\n\nA 'plesk login' parancsot használja az 'admin’ minőségben való bejelentkezéshez.\n\nA 'plesk bin admin --set-password -passwd <new_password>' parancsot használja egy új 'admin’ beállítására.\n\n",
    'ch_pass_admin__message_send_error' => 'Nem lehetséges e mailt küldeni: %1',

    'ch_pass_by_secret__email_subject' => "Kér új Plesk jelszót?",
    'ch_pass_by_secret__email_body' => "Helló %2,\n\nIfegy új jelszót kért, új jelszó beállításához kövesse e hivatkozás útmutatásait: %1\n\n A bejelentkezési azonosítója: %3",
    'ch_pass_by_secret__message_send_error' => 'Nem sikerült a titkos kód küldése: %1',
    'ch_pass_by_secret__title' => 'Jelszava megváltoztatása',
    'ch_pass_by_secret__secret' => 'Titkos kód',

    'custom_button__noframe' => "Ne használjon kereteket",

    'custom_button__internal_hint' => 'Adja meg, hogy egy Plesk oldalon vagy egy új böngészőablakban történjen a URL-cím megnyitása.',
    'custom_button__noframe_hint' => 'Ha egy olyan egyéni gomb hozzáadását végezte le, mely egy Plesk bővítményre vagy az Ügyfél kezelőpanelen található alkalmazásra vezet, akkor megadhatja, hogyan jelenjen meg e bővítmény/alkalmazás: egy keretben vagy a Plesk grafikus felhasználói felület részeként.',


    'actionlog__patch' => 'Frissítés',
    'actionlog__patch_available' => 'rendelkezésre áll',
    'actionlog__event_patch_available' => 'Frissítés rendelkezésre áll',
    'actionlog__patch_installed' => 'telepítve',
    'actionlog__event_patch_installed' => 'Frissítés telepítve',

    'actionlog__extension' => 'Bővítmény',
    'actionlog__extension_status' => 'Bővítmény állapota.',
    'actionlog__cloning' => 'Kiszolgáló klónozása',
    'actionlog__cloning_complete' => 'kész.',
    'actionlog__event_cloning_complete' => 'Kiszolgáló klónozása kész.',

    'actionlog__ssl_web_binding' => 'Certificat SSL/TLS du domaine',
    'actionlog__ssl_web_binding_update' => 'hozzárendelt/Hozzárendelés nélküli',
    'actionlog__event_ssl_web_binding_update' => 'Certificat SSL/TLS du domaine attribué/non attribué.',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-tanúsítvány webes levelezés esetén',
    'actionlog__ssl_web_mail_binding_update' => 'hozzárendelt/hozzárendelés nélküli',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-tanúsítvány a webes levelezés esetében hozzárendelt/hozzárendelés nélküli',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-tanúsítvány a levelezési kiszolgáló esetében',
    'actionlog__ssl_mail_binding_update' => 'hozzárendelt/hozzárendelés nélküli',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-tanúsítvány a levelezési kiszolgál esetében hozzárendelt/hozzárendelés nélküli',

    'actionlog__ssl_panel_binding' => 'Certificat SSL/TLS de Plesk',
    'actionlog__ssl_panel_binding_update' => 'hozzárendelt/Hozzárendelés nélküli',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-tanúsítvány a Plesk kezelőpult esetében hozzárendelt/hozzárendelés nélküli',

    'actionlog__hostname' => 'Kiszolgáló állomásnév',
    'actionlog__hostname_changed' => 'megváltoztatva',

    'actionlog__smb_user' => 'További felhasználó',
    'actionlog__smb_user_create' => 'További felhasználó került létrehozásra',
    'actionlog__smb_user_delete' => 'További felhasználó került törlésre',
    'actionlog__smb_user_update' => 'További felhasználó került frissítésre',

    'actionlog__event_mail_management_status_update' => 'Levélkezelés állapotának a frissítése',
    'actionlog__mail_management' => 'Levélkezelés állapota',
    'actionlog__mail_management_status_update' => 'frissítve',

    'virtualization_openvz' => 'OpenVZ virtualizációs technológia',

    'passwordSecurityLevelCheckFailed' => 'Nem elég összetett a jelszava. A kiszolgáló házirendje szerint %1 a minimális jelszó erősség. A jelszó erősségének javítása érdekében használjon számokat, kis- és nagybetűket, továbbá olyan speciális karaktereket, mint !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Nagyon gyenge',
    'passwordSecurityLevelCheckFailedWeak' => 'Gyenge',
    'passwordSecurityLevelCheckFailedMediocre' => 'Közepes',
    'passwordSecurityLevelCheckFailedStrong' => 'Erős',
    'passwordSecurityLevelCheckFailedStronger' => 'Nagyon erős',

    'dns__dns_default_ipv4_modified' => 'Felhasználó által módosítottnak tekintettek ezen IP-címmel rendelkező rekordok és nem történik meg az egész kiszolgálóra érvényes DNS-sablonnal a szinkronizálásuk.',
    'dns__dns_default_ipv6_modified' => 'Felhasználó által módosítottnak tekintettek ezen IP-címmel rendelkező rekordok és nem történik meg az egész kiszolgálóra érvényes DNS-sablonnal a szinkronizálásuk.',

    'dns__view_dns_record_master_title' => 'Erőforrásrekord megtekintése',
    'dns__view_dns_record_off_title' => 'Névkiszolgáló rekordok megtekintése',
    'dns__view_dns_record_slave_title' => 'Elsődleges DNS-kiszolgáló rekordok megtekintése',

    'dns_unable_to_resolve_hostname' => "Nem lehetséges az állomásnév \"%1\" feloldása: %2 Gondoskodjon arról, hogy be legyen állítva és megfelelően működjön az operációs rendszer DNS-címfeloldó.",

    'no_database_server_available' => 'Nem állnak adatbázis-kiszolgálók rendelkezésre ezen előfizetés számára.',

    'database_used_by_application_can_not_be_moved' => 'Nem lehetséges az adatbázis áthelyezése: Egy webhelyen lévő alkalmazás használja az adatbázist.',
    'database_user_update_orphaned_is_restricted' => 'Tilos egy árván maradt adatbázis felhasználói fiókok frissítése. Csak törölheti vagy javíthatja azokat.',

    'database_unable_to_get_max_filesize_default_message' => 'Nem lehetséges az adatbázis maximális fájlméretének a meghatározása: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Nem lehetséges az adatbázis maximális fájlméretét beállítani: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Nem lehetséges a következő nevű adatbázis maximális naplófájl méretének a meghatározása: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Nem lehetséges az adatbázis maximális naplófájl méretét beállítani: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Nem lehetséges az adott \'%1\' nevű Microsoft SQL-adatbázis aktuális fájlméret korlátját meghatározása. Nem lehetséges egy új korlát beállítása.',
    'database_unable_to_set_max_filesize' => 'Nem lehetséges \'%1\' Microsoft SQL-adatbázis fájlméret korlátját beállítani.',
    'database_unable_to_get_max_log_filesize' => 'Nem lehetséges az adott \'%1\' nevű Microsoft SQL-adatbázis aktuális naplófájl méret korlátját meghatározása. Nem lehetséges egy új korlát beállítása.',
    'database_unable_to_set_max_log_filesize' => 'Nem lehetséges \'%1\' Microsoft SQL-adatbázis naplófájl méret korlátját beállítani.',

    'database_unable_to_create_because_max_filesize' => 'Ne lehetséges \'%1\' Microsoft SQL-adatbázis létrehozása: A fájlmérete meghaladja a maximálisan megengedett méretet.',
    'database_unable_to_move_because_max_filesize' => 'Nem lehetséges \'%1\' SQL-adatbázis áthelyezése: A fájlmérete meghaladja a maximálisan megengedett méretet. %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Ne lehetséges \'%1\' Microsoft SQL-adatbázis létrehozása: A naplófájl mérete meghaladja a maximálisan megengedett méretet.',
    'database_unable_to_move_because_max_log_filesize' => 'Nem lehetséges \'%1\' SQL-adatbázis áthelyezése: A naplófájl mérete meghaladja a maximálisan megengedett méretet. %2.',
    'database_unable_to_restore_because_max_filesize' => 'Nem lehetséges \'%1\' SQL-adatbázis visszaállítása: A fájlmérete meghaladja a maximálisan megengedett méretet.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Egy azonos MS SQL-kiszolgálót már regisztráltak a Plesk kezelőpanelen. Egy másik MS SQL-kiszolgálót adjon meg védőfalként.',
    'database_server__mssql_server_registered_as_sandbox' => 'Egy azonos védőfal MS SQL-kiszolgálót már regisztráltak a Plesk kezelőpanelen. Egy másik MS SQL-kiszolgálót adjon meg védőfalként.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Nem kapcsolódhat \'%1\' útján a kiszolgálóhoz: %2',

    'bu_conflict_resolver_feature_not_available' => 'Nem támogatják a következő szolgáltatási csomópontok %1 funkciót: %2. Letiltásra kerül e csomópontokon létrehozott összes objektum.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Nem támogatja %1 funkciót e kiszolgáló. Le lesz tiltva e funkció az összes visszaállított objektum esetben.',
    'bu_conflict_resolver_component_unavailable_in_sites' => '%1 összetevő nincs telepítve. Nem áll a következő webhelyek rendelkezésére: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => '%1 összetevő nincs telepítve. %2 helyettesíti a következő webhelyek esetén: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Az aktuális Plesk verzió nem támogatja a pont (.) karaktert tartalmazó felhasználónevek használatát. Nem kerülnek visszaállításra az ilyen ügyfél és viszonteladói felhasználónevek.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Nem található %1 %2 adatait tartalmazó biztonsági másolat fájl. %1 %2 adatainak nem kerülnek visszaállításra.',

    'bu_conflict_resolver_zone_master_removed' => "Nem állítható vissza az elsődleges DNS-rekord: Egy meglévő %1 IP-címre mutat a rekord a másodlagos zónában. Az elsődleges DNS-rekord eltávolításra kerül a másodlagos zónából.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Ki van kapcsolva a HTTPS DNS-rekordok támogatása. A következő domainek esetén nem állíthatóak helyre a HTTPS-rekordok: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 nem támogatott.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 nem támogatott. Nem áll a következő webhelyek rendelkezésére: {{objects}}',
    'bu_conflict_resolver_not_available_component' => '%1 összetevő nincs telepítve.',
    'bu_conflict_resolver_not_available_virusfilter' => 'The component %1 is not installed or activated.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Nem áll a következő szolgáltatási csomópontok rendelkezésére: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Nem áll a következő objektumok rendelkezésére: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'A következő adattbázis-kiszolgálók nem állnak rendelkezésre e kiszolgálón: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'Nem támogatott a SmartHost szolgáltatás általi kezelés. Nem kerülnek visszaállításra a SmartHost beállítások.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL natív formátumban történik egy MS SQL-adatbázis biztonsági másolat fájl tárolása, mely kizárólag a helyi MS SQL -kiszolgálón vagy hiánytalanul konfigurált biztonsági mentési beállításokkal rendelkező távoli MS SQL-kiszolgálón állítható vissza. Egyes adatbázisai nem kerültek visszaállításra, mivel nincs megfelelő MS SQL-kiszolgáló regisztrálva a Plesk kezelőpanelnél. A következő domainek érintettek: {{objects}}. Forduljon a szolgáltatóhoz.',

    'bu_conflict_resolver_not_available_webmail' => '%1 webes levelezési szolgáltatás nem áll rendelkezésre. %2 helyettesíti a következő objektumok esetében: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => '%1 webes levelezési szolgáltatás nem áll rendelkezésre. %2 helyettesíti a következő szolgáltatási csomagok esetében: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "'%1' típusú adatbázisok nem támogatják az adatbázis névvel egyező felhasználónevek használatát. '%2' felhasználó '%3' névre átnevezésre kerül '%4' adatbázis esetén.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Nem került beállításra a lemezterület-használati korlát a célkiszolgáló konfigurációjában.',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Nem került beállításra a kapcsolatok száma korlát a célkiszolgáló konfigurációjában.',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Nem került beállításra a forgalmi kihasználtság korlát a célkiszolgáló konfigurációjában.',
    'cu__pleskrestore_backup_file_extracted' => '"%1" hordozóra történt a biztonsági másolat fájlok kigyűjtése.',
    '__mod_bw_not_supported' => 'A fájlrendszer konfigurációja miatt nem támogatott az Apache webkiszolgáló mod_bw modulja. Nem működik a forgalmi kihasználtsági és az egyidejű kapcsolatok maximális száma korlát.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Nem támogatott levélátjátszáshoz a POP3-hitelesítés, POP3 az SMTP-hitelesítés előtt kerül helyette felhasználásra. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => '\'%1\' szolgáltatási csomag',
    'bu_conflict_resolver_replaced_in_plans' => '%1 nem támogatott. %2 helyettesíti a következő szolgáltatási csomagok esetében: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 nem támogatott. %2 helyettesíti a következő webhelyek esetében: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Nem találhatóak a következő objektumok a biztonsági másolat fájlban: %1',
    'bu_conflict_resolver_absent_domains' => 'Nem állíthatóak vissza egyes objektumok, mivel a következő domainekhez tartoznak, de azok nem találhatóak a Plesk kezelőpanelen: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Nem állíthatóak vissza egyes webhelyek, mivel nem találhatóak a következő szülődomainek a Plesk kezelőpanelen:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Nem lehetséges DNS-zónák visszaállítása: Inaktiválva van a DNS-szolgáltatás a kiszolgáló konfigurációban.',
    'bu_conflict_resolver_mail_not_supported' => 'Nem lehet postaládákat visszaállítani: Inaktiválva van a levelezési szolgáltatás a kiszolgáló konfigurációban.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Nem támogatja az IIS webkiszolgáló a megadott CPU korlátozási műveletet. %1 értékre kerül az érték visszaállításra.',
    'bu_conflict_detector_server_ssl_cert_name' => '%1 kiszolgáló SSL/TLS-tanúsítványa',
    'bu_conflict_detector_domain_ssl_cert_name' => '%1 domain %2 SSL/TLS-tanúsítványa',
    'bu_conflict_detector_ssl_cert_name' => '%1 SSL/TLS-tanúsítvány',
    'bu_conflict_resolver_absent_objects' => 'Nem állíthatóak vissza a következő objektumok tartalmai, mivel nem találhatóak az objektumok a Plesk kezelőpanelen: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Nem állíthatóak vissza a következő postaládák, mivel nem találhatóak a postaládák a Plesk kezelőpanelen: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Nem állíthatóak vissza a következő levelezési listák, mivel nem találhatóak a levelezési listák a Plesk kezelőpanelen: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Nem állíthatóak vissza a következő adatbázisok, mivel nem találhatóak az adatbázisok a Plesk kezelőpanelen: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Nem sikerült "%1" alkalmazás visszaállítása "%2" eszközön, mivel egy másik alkalmazás már telepítve van "%3" esetében. Eltávolíthatja a telepített alkalmazást és újra megpróbálhatja.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Nem támogatott a levelezési automatikus válaszadás funkció használata.',
    'bu_conflict_resolver_not_available_mail_content' => 'Nem támogatott a levelezési tartalomkorlátozás használata.',
    'bu_conflict_resolver_invalid_mail_name' => 'Nem történt meg a következő postaládák visszaállítása, mivel az alácímzés engedélyezett és bizonyos e-mail címek "%1" jelet tartalmaznak: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Nem történt meg a következő felhasználók visszaállítása, mivel az alácímzés engedélyezett és bizonyos e-mail címek "%1" jelet tartalmaznak: %2',
    'bu_conflict_resolver_licenses_expired' => 'A következő licencek járnak le, és nem kerülnek visszaállításra: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Nem érvényesek vagy lejártak, és nem állíthatóak helyre a következő licencek: {{objects}}',
    'expiration_unsupported' => "Nem támogatott a 'lejárat' korlát.",

    'component_name__dbconnector' => "Adatbázis-csatlakozó",
    'component_name__mysqlserver' => 'MariaDB/MySQL kiszolgáló',
    'component_name__troubleshooting' => 'Hibaelhárítás',
    'component_name__savi' => 'Sophos vírusvédelem kezelőfelület',

    '__subscription_has_no_license_key' => '#%1 szolgáltatási csomópont biztosítja az előfizetés erőforrásait, mely nem rendelkezik egy társított licenckulccsal.',
    '__subscription_has_expired_license_key' => '#%1 szolgáltatási csomópont biztosítja az előfizetés erőforrásait, melynek %2 licence lejárt.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%>Nem lehetséges konfigurációs fájlokat menteni.',
    '__cfgmonConfigurationFileSaveErrorBody' => "Nem lehetséges néhány konfigurációs fájlt <%%host%%> állomásra menteni: A következő hibák fordultak elő:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Levelezési listák esetén, változtatható válaszcímű levelek konfigurálását tesz lehetővé e beállítás.',
    'mail__enter_right_ip_mask' => "Írjon be 1 és 32 közötti IP-maszkot.",
    'mail__enter_right_ip_mask_24' => "Írjon be 24 és 32 közötti IP-maszkot.",
    'mail__invalid_dom_name' => "%1 domain név érvénytelen.",
    'mail__invalid_pop_lock_time' => "A megadott POP3 zárolási időtartam érvénytelen.",
    'mail__invalid_rbl_server' => "Érvénytelen a DNS-zóna neve.",
    'mail__total_files_size' => "A tároló teljes mérete: %1",
    'mail__filename_already_in_repository' => "Ilyen nevű fájl már létezik az adattárban.",
    'mail__no_white_list_mask_feature_24' => "24-es vagy nagyobb maszkértéket használjon. A levelezőkiszolgálója nem támogatja maszkok beállítását. Csak 24-es maszkértéknél nagyobb maszkbeállítások emulálhatóak.",
    'mail__unable_add_new_mail_name' => "Nem lehetséges a postafiók hozzáadása: %1",
    'mail_server_is_not_installed' => 'Nincs telepítve levelezési kiszolgáló (Postfix vagy Qmail). Telepítse a munka folytatásához.',
    'mail_server_not_available' => 'Nem támogatott levelezési kiszolgálók állnak rendelkezésre szolgáltatási csomópontban.',
    '__not_installed' => '(nincs telepítve)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Le van tiltva a kimenő e-mail üzenetek levélszemét szűrése.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => '%1 domain esetén a szolgáltatási csomópont nem támogatja egy domainből kimenő üzenetek számának korlátozását.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => '%1 domain esetén a szolgáltatási csomópont nem támogatja egy postaládából kimenő üzenetek számának korlátozását.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Legalább egy típusú (IPv4 vagy IPv6) címet adjon meg.',

    'mail__outgoing_email_mode_invalid' => 'Érvénytelen kimenő levél mód került megadásra.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Egy érvénytelen IPv4-cím került megadásra.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Érvénytelen IPv6-cím került megadásra.',
    'mail__outgoing_email_mode_unavailable' => 'Nem támogatott a Kimenő e-mail üzenetek mód változtatása, valószínűleg nincs telepítve a Postfix levelezési kiszolgáló e kiszolgálóra.',

    'mail__autoresponder_attachment_not_supported' => 'A jelenleg használt levelezési kiszolgáló nem támogatja az automata válaszadó melléklet kezelését.',

    'mail__smtp_white_list_not_supported' => 'A jelenleg használt levelezési kiszolgáló nem támogatja az IP-cím engedélyezőlista készítést.',
    'mail__smtp_whitelist_cidr_not_supported' => 'A jelenleg kiválasztott levelező kiszolgáló nem támogatja a CIDR-maszkokat. \'192.*.0.*’ formátumban határozza meg az IP-címet.',
    'mail__smtp_whitelist_mask_not_supported' => 'A jelenleg kiválasztott levelező kiszolgáló nem támogatja a helyettesítő karakteres IP-címeket. \'192.0.0.0/8\' formátumban határozza meg az IP-címet.',

    'sfdk_server_wide_verify_failed' => 'Nem lehetséges a DKIM ellenőrzési szolgáltatás beállításainak megváltoztatása.',

    'sfdk_domain__serverwide_disabled' => 'Ki van kapcsolva a kiszolgáló házirendjének megfelelően.',
    'feature__domainkeys__serverwide_disabled' => 'Ki van kapcsolva az egész kiszolgálóra érvényes DKIM kéretlen levelek elleni védelem.',

    'defaultcomponents__error_set_default' => 'Nem lehetséges %1 %2 alapértelmezettjekénti beállítása.',
    'defaultcomponents__error_set_default_none' => '„Nincs” nem állítható be %1 alapértelmezett alkotóelemeként.',
    'defaultcomponents__required_package_not_default' => 'Nem alapértelmezett a munkájához szükséges %1 öszetevő.',

    '__percentage' => '%',
    '__seconds' => 'Másodperc',
    '__resource_remain' => 'Fennmaradó',

    '__not_registered' => '(nincs regisztrálva)',
    '__php_handler_id' => 'PHP-verzió',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => '%1 PHP-kezelő nincs regisztrálva. Valószínűleg törlésre került a kiszolgálóról. Regisztráljon egy ugyanolyan tulajdonságokkal rendelkező kezelőt, majd próbálja újra.',
    '__php_handler_not_registered_on_domain' => '"%1" domain: nincs regisztrálva "%2" PHP-kezelő. Valószínűleg törlésre került a kiszolgálóról. Regisztráljon egy ugyanolyan tulajdonságokkal rendelkező kezelőt, majd próbálja újra.',
    '__php_fpm_handler' => 'FPM alkalmazás',
    '__php_fpm-dedicated_handler' => 'Dedikált FPM-alkalmazás',

    'mailname_create_assigned_user_dublicate_error' => 'Nem lehet a postaláda számára felhasználót létrehozni. %1 felhasználónevű felhasználó már létezik és egy másik postaládával rendelkezik.',
    'mailname_create_assigned_user_role_absent_error' => 'Nem lehet a postaláda számára felhasználót létrehozni. Nem létezik a felhasználó %1 alapértelmezett szerepköre.',

    'gphd__mime_types' => 'MIME-típusok',
    'gphd__handlers' => 'Apache kezelők',
    'gphd__ip_restrictions_allow' => 'Megadott állomások és hálózatok számára (a megtagadottak kivételével) engedélyezzen hozzáférést a webhelyhez.',
    'gphd__ip_restrictions_deny' => 'Megadott állomások és hálózatok számára tagadja meg a hozzáférést.',
    'gphd__directory_index' => 'Indexfájlok',
    'gphd__nginx_transparent_mode' => 'A mód, amikor az Apache kezeli mind a statikus, mind a dinamikus tartalmat, miközben az nginx csupán átadja a HTTP kérelmeket és változtatás nélkül válaszol.',
    'gphd__nginx_serve_static' => 'Közvetlenül nginx segítségével végezze statikus fájlok kiszolgálását.',
    'gphd__nginx_static_extensions' => 'nginx által kezelendő statikus fájl bővítmények',
    'gphd__nginx_serve_php' => 'nginx segítségével végezze PHP-fájlok feldolgozását.',
    'gphd__www_root' => 'WWW gyökérkönyvtár',

    'eol__none' => 'ne változtassa meg',
    'eol__lf' => 'Unix stílusra átalakítás',
    'eol__cr' => 'MacOS stílusra átalakítás',
    'eol__crlf' => 'Windows stílusra átalakítás',

    'ui__dns_bad_zone' => '"%1" nem konzisztens zóna:',
    'ui__dns_ns_has_no_address_records' => '"%1" S-rekord nem rendelkezik címrekordokkal (A vagy AAAA).',
    '__dns_bad_zone' => '"%1" nem konzisztens zóna:',
    '__dns_ns_has_no_address_records' => '"%1" S-rekord nem rendelkezik címrekordokkal (A vagy AAAA).',
    '__dns_ptr_is_wildcard' => 'Érvénytelen "%1" PTR-rekord: Egy helyettesítő wildcard domainre mutat a rekord.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Engedélyezze \'%4\' ügyfél \'%3\' adatbázis felhasználójának a távoli hozzáférést.',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Nem lehetséges távoli kapcsolatok engedélyezése \'%1\' adatbázis-felhasználó számára: Nem lehet meghatározni \'%2\' Microsoft SQL-kiszolgáló által használt TCP-portszámot. A következők lehetnek a lehetséges okok: nincs a TCP/IP-protokoll engedélyezve a kiszolgáló hálózati konfigurációjában vagy dinamikus TCP-portok használatára van konfigurálva a kiszolgáló. Egy rögzített TCP-port figyelésére konfigurálja a kiszolgálót, majd próbálja ismét engedélyezni a távoli kapcsolatokat.',

    'command__convertResellerHasCustomer' => 'Egy vagy több ügyfélszámlával rendelkezik \'%1\' viszonteladó számla. E viszonteladói számla ügyfélszámlákká átalakításához először adja át ezen ügyfélszámlákat egy új tulajdonosnak vagy alakítsa át viszonteladói számlává.',
    'command__convertResellerNotReseller' => 'Kizárólag viszonteladói számlák alakíthatóak át ügyfélszámlákká. \'%1\' már egy viszonteladó.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Nem szinkronizálható az előfizetés a szolgáltatási csomaggal. Az előfizetés következő beállításai ütköznek a szolgáltatási csomaggal: %%problems%%.',

    'moveCustomer__wrong_customer_type' => '\'%1\' fiók egy viszonteladói számla. Viszonteladói számlák nem helyezhetőek át egy új tulajdonoshoz, mivel a kiszolgáló adminisztrátora a tulajdonosuk.',
    'moveCustomer__wrong_owner_type' => "'%1' ügyfélszámla csak viszonteladóhoz vagy adminisztrátorhoz helyezhető át, nem egy másik ügyfélhez.",
    'moveCustomer__customer_already_belongs_to_owner' => '\'%1\' felhasználói fiók már a kijelölt felhasználóhoz tartozik.',
    'upgradeClient__user_is_admin' => '\'%1\' számla nem alakítható át viszonteladói számlává, mivel ez egy adminisztrátor számla.',

    'mail__error_setting_max_connections_courier' => 'Nem lehet beállítani a kapcsolatok maximális számát (IMAP, POP3, IMAP SSL/TLS-en keresztül vagy POP3 SSL/TLS-en keresztül): %1',
    'mail__error_setting_max_connections_dovecot' => 'Nem lehet beállítani a kapcsolatok maximális számát (IMAP, POP3, IMAP SSL/TLS-en keresztül vagy POP3 SSL/TLS-en keresztül): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Nem lehet beállítani a kapcsolatok maximális számát (IMAP, POP3, IMAP SSL/TLS-en keresztül vagy POP3 SSL/TLS-en keresztül): %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Nem lehet beállítani a kapcsolatok maximális számát (IMAP, POP3, IMAP SSL-en keresztül vagy POP3 SSL-en keresztül) egy megadott levelezés felhasználó IP-címeinként: %1',
    'outgoing_messages_limit_value_invalid' => '%%MIN%%..%%MAX%% tartományban kell az értéknek lennie. Kizárólag Plesk adminisztrátor végezheti el e beállítást.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Külső e-mail címeket használnak a következő dokumentumok nem létező címekre küldött levelek továbbítására. E címekre küldött üzenetek nem kerülnek figyelembevételre a Kimenő levél ellenőrzés során.\n %1",
    'outgoing_messages_white_list_not_empty' => 'Nem hatásosak a kimenő levél korlátok a levelezési kiszolgáló engedélyezési listáján szereplő levélküldők esetében. Például, ha szerepel a localhost (127.0.0.0 / 8, ::1 / 128) a engedélyezési listán, akkor a korlátozásoktól függetlenül sikeresen elküldésre kerülnek e helyi kiszolgálóról származó levelek. Helyi (a helyi kiszolgálón üzemeltetett webhelyek és egyéni parancsprogramok) vagy külső IP-címeket (olyan ügyfelek, akik a számítógépeikre vagy mobileszközeikre telepített levelezőprogramokatat használják levélküldésre) használhatnak a levélküldők. A korlátok minden levélküldő (mind helyi, mind külső) esetében hatásossá tétele érdekében távolítsa el az IP-címeket és hálózatokat az engedélyezési listáról. Ne feledje, hogy a localhost (127.0.0.0 / 8, ::1 / 128) engedélyezési listáról történő eltávolítása előfordulhat, hogy megszakítja azon webhely és a parancsprogramok működését, melyek levelet küldenek e kiszolgálóról. A kimenő levelekre vonatkozó korlátozás részleteiért az Adminisztrátor útmutató Kimenő levélszemét elleni védelem című részét nézze meg.',
    'outgoing_messages_relay_open' => 'Meg van nyitva a levélátjátszás: Nem hatásosak a kimenő levél korlátok.',

    'notification_aps_app_updates_available' => 'Frissítések állnak rendelkezésre a következő alkalmazások számára:',
    'notification_aps_app_updates_installed' => 'Automatikusan megtörténnek a következő alkalmazások frissítései:',
    'notification_aps_app_updates_requirements' => 'Frissítések állnak rendelkezésre a következő alkalmazások számára, azonban nem telepíthetőek, mivel a megfelelő webhelyek üzemeltetési beállításai nem felelnek meg a követelményeknek:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => '"%%name%%" beépülő modul %%parentName%% (%%url%%) esetében. Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => '"%%name%%" téma %%parentName%% (%%url%%) esetében. Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => '"%%name%%" beépülő modul %%parentName%% (%%url%%) esetében. Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => '"%%name%%" téma %%parentName%% (%%url%%) esetében. Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Verziója: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => '"%%name%%" beépülő modul %%parentName%% (%%url%%) esetében. Verziója: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => '"%%name%%" téma %%parentName%% (%%url%%) esetében. Verziója: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Új verzió: %%to%%. Előző verzió %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Új verzió: %%to%%. Előző verzió %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Új verzió: %%to%%. Előző verzió %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Telepített verzió: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Verziója: %%from%%. Rendelkezésre álló verzió: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'külső alkalmazás',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domainek',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-mail címek',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Előfizetések',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 üzenet óránként',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Korlátlan',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, %2 a korlát',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 kísérlet %2 - %3 korlát túllépésére',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 kísérlet %2 időponttól máig a korlátok túllépésére',

    'restart__docker' => "Docker platform",
    'restart__fail2ban' => "IP-cím letiltás (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban összetevő nincs telepítve a célkiszolgálón.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Fail2ban telepítése. Ne feledkezzen meg arról, hogy ez néhány percig eltarthat.',

    'plesk_key__no_reseller_support' => 'Licenckorlátozások miatt nem végezheti viszonteladók kezelését.',
    'plesk_key__no_customers_support' => 'Licenckorlátozások miatt nem végezheti ügyfelek kezelését.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Licenckorlátozások miatt nem sikerült a Szolgáltató nézetre az átkapcsolás.',
    'plesk_key__no_security_core_support' => 'Licenckorlátozások miatt nem miatt nem állnak rendelkezésre a biztonsági mag funkciói (ModSecurity és Fail2Ban).',
    'plesk_key__outgoing-antispam' => 'Kimenő levél ellenőrzés',
    'plesk_key__security-core' => 'Biztonsági mag (ModSecurity és Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Számlavezetés',
    'plesk_key__can-manage-subscriptions' => 'Előfizetések kezelése',
    'plesk_key__can-manage-customers' => 'Ügyfelek kezelése',
    'plesk_key__can-manage-resellers' => 'Viszonteladók kezelése',
    'plesk_key__can-manage-custom-view' => 'Korlátozott mód rendelkezésre állása',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Ki van kapcsolva a Viszonteladó kezelés, de számos előfizetéssel rendelkezik (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Ki van kapcsolva a Viszonteladó kezelés, de számos viszonteladóval rendelkezik (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Ki van kapcsolva az Ügyfél kezelés funkció, de több ügyféllel rendelkezik (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Bizonyos előfizetési erőforrásokat nem kezelhet többé a Plesk kezelőfelületen (mint a postaládák korlátait és domain lemezterületét), mivel most korlátlan a beállításuk.',
    'plesk_key__no_subscriptions_support' => 'Licenckorlátozások miatt nem végezheti előfizetések kezelését.',
    'plesk_key__no_custom_view_support' => 'Licenckorlátozások miatt nem használhatja a Korlátozott módot.',
    'plesk_key__trial_forbidden_region' => 'Elnézést, a Plesk kezelőpanel jelenleg nem rendelkezésre a régiójában.',
    'additional_key__main_key' => 'A kulcs egy főkulcs: További kulcsként nem tölthet fel egy főkulcsot.',

    'gch__hosting_waf_rule_engine' => 'Webalkalmazás tűzfal mód',

    'backup__fieldset__restoration_options' => 'Visszaállítási beállítások',
    'backup__restore_options__restore' => 'Visszaállítás',
    'backup__restore_options__domain__domain_configuration' => 'Domain konfiguráció',
    'backup__restore_options__domain__virtual_host_content' => 'Virtuális állomás tartalma',
    'backup__restore_options__domain__mail' => 'E-mail',
    'backup__restore_options__domain__databases' => 'Adatbázisok',
    'backup__restore_options__client__client_configuration' => 'Ügyfélszámla konfigurációja',
    'backup__restore_options__client__domains' => "Ügyfél domainek",
    'backup__restore_options__reseller__reseller_configuration' => 'Viszonteladói számla konfigurációja',
    'backup__restore_options__reseller__personal_domains' => "Viszonteladó domainjei",
    'backup__restore_options__reseller__clients' => "Viszonteladó ügyfelei",
    'backup__restore_options__admin__server_configuration' => 'Kiszolgáló beállítások',
    'backup__restore_options__admin__administrator_configuration' => 'Adminisztrátor számla konfigurációja',
    'backup__restore_options__admin__personal_domains' => "Adminisztrátor domainek",
    'backup__restore_options__admin__personal_clients' => "Adminisztrátor ügyfelek",
    'backup__restore_options__admin__resellers' => 'Viszonteladók',

    'badge_new' => 'Új',
    'upgrade_php_on_subscription' => 'Frissítse 5.3.0 vagy újabb verzióra előfizetése PHP-nyelvét.',

    'pkey_notify__body_expiration_notification' => 'Lejárt a licenckulcs. Nem állnak egyes funkciók rendelkezésre. Forduljon a szolgáltatóhoz.',

    'crontab__crontab_entry_exists' => "Már létezik az ütemezett feladat.",
    'crontab__crontab_entry_not_exists' => "Nem létezik az ütemezett feladat.",
    'crontab__invalid_values_found' => "Helytelen paraméterértékek.",
    'crontab__cmd_max_len' => "%1 karakternél nem lehet hosszabb a parancs.",

    'domain__domain_exists' => "Már szerepel 'www' előtaggal és megegyező névvel domain: %1.%2.",
    'domain__subdomain_exists' => "Már szerepel 'www' előtaggal és megegyező névvel aldomain: %1.%2.",
    'domain__dalias_exists' => "Már szerepel 'www' előtaggal és megegyező névvel domain alias: %1.%2.",
    'domain__record_exists' => "Szerepel %1.%2 állomásra mutató DNS-rekord.",

    'ip_addr__cannot_assign_certificate' => "Nem állítható be alapértelmezettnek '%1' tanúsítvány: hiányzik a személyes kulcs.",
    'ip_addr__update_dns_error' => 'Problémák fordultak elő a DNS-zónákban található IP-cím frissítése során. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Nem lehetséges az IP-cím hozzáadása. E hálózati illesztő automatikusan végzi az IP-címek beolvasását.',
    'ip_addr__cannot_remove_dhcp_enabled' => '%1 IP-cím nem távolítható el. Automatikusan végzi IP-címek beolvasását e hálózati illesztő.',
    'ip_addr__cannot_repair_dhcp_enabled' => '%1 IP-cím nem javítható. E hálózati illesztő automatikusan végzi az IP-címek beolvasását.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Nem változtatható meg %1 IP-cím illesztője, mivel %2 hálózati illesztő automatikusan végzi az IP-címek beolvasását.',

    'shm_lmsg__limit_for_resource_exceeded' => '%%type%% száma tekintetében túllépésre került az előfizetési korlát. %%limit%% és %%usage%% korlát jelenleg használatban van.',
    'shm_lmsg__resource_is_forbidden_for_creation' => '%%type%% típus létrehozás nem engedélyezett ezen előfizetés számára.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL-adatbázisok',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-adatbázisok',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL adatbázisok',
    'shm_lmsg__resource_title__db-user' => 'adatbázis-felhasználók',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-alkalmazási készlet',
    'shm_lmsg__resource_title__additional-ftp-account' => 'további FTP-fiókok',

    'db_user_unable_remove_mysql_global_privileges' => 'Nem lehetséges %1 adatbázis felhasználó MariaDB/MySQL globális jogosultságainak az eltávolítása. Ok: %2',
    'report__client_description' => 'Leírás',

    'db__user_role_error' => 'Helytelen adatbázis felhasználó szerepkör került megadásra: %1. Válasszon a következő szerepkörök közül: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Nem lehetséges a fájlméret korlát beállítása a következő Microsoft SQL-kiszolgáló adatbázisok esetében, mivel egy nagyobb méretű fájllal rendelkezik: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Nem lehetséges a naplófájl méret korlát beállítása a következő Microsoft SQL-kiszolgáló adatbázisok esetében, mivel egy nagyobb méretű fájllal rendelkezik: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Nem lehetséges nyilvános IP-cím beállítása: léteznie kell egy nyilvános IP-címnek.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Nem lehetséges nyilvános IPv4-címet beállítani az IPv6-cím számára.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Nem lehetséges nyilvános IPv6-címet beállítani az IPv4-cím számára.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Nem lehetséges egy nyilvános IP-cím beállítása: érvénytelen IP-cím.',

    '__user_already_exists' => "%1 felhasználó már létezik.",
    '__user_name_is_empty' => "Adjon meg egy felhasználónevet.",

    'upgrade_php_on_domain' => 'Nem található 5.3.0 vagy újabb PHP-verzió a WordPress domainjein. Próbálja meg a PHP magasabb verzióra frissítését.',

    'component_name__waf' => 'Webalkalmazás tűzfala',
    'component_name__vcs' => 'Verziókezelő rendszer',

    'virtualization_lxc' => 'LXC operációs rendszer',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Egy lehetséges hamisítási kísérlet észlelése történt: Irreleváns tartalmat próbált a hivatkozás megjeleníteni.',
    'forceResetPasswordUpdated' => 'Megváltoztatásra került a jelszava. Az új jelszót használja a Plesk kezelőpanelbe való bejelentkezéshez.',

    'php_handlers_error_no_available_instance' => 'Nem lehetséges egy domain létrehozása: nem állnak PHP-kezelők rendelkezésre.',
    'domain_error_unable_to_apply_hosting_settings' => 'Nem lehetséges az üzemeltetési beállítások alkalmazása: %1',

    'plesk_not_configured' => 'Nincs konfigurálva a Plesk kezelőpanel. Ugorjon a kezelőpanelre a telepítést követő konfigurálás elvégzésére.',
    'cmd_mail__mail_password_duplicated' => 'A megadott e-mail cím és jelszó már létezik a levelezési kiszolgálón. Másik e-mail címet vagy jelszót adjon meg.',

    'extensionRequirementOs' => 'Nem támogatja a csomag az operációs rendszert (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 a csomag által támogatott legrégebbi verzió.',
    'extensionRequirementPleskMaxVersion' => 'Nem támogatja a csomag a Plesk %1 verziótól a további verziókat.',
    'extensionBlacklisted' => '%1 bővítmény használata nem engedélyezett telepítéshez.',
    'extensionDisabled' => 'Le van tiltva a bővítmény.',


    'optimization_settings__unable_set_mpm_event' => 'Nem lehetséges az mpm_event mód beállítása: ehhez ki kell kapcsolni az Apache PHP5 modult, azonban domainek használják e modult.',
    'optimization_settings__unable_turn_off_php' => 'Nem lehetséges az Apache PHP5 modul kikapcsolása: domainek használják azt.',

    'hst_def__fp_admin_login' =>  'FTP-felhasználónév',
    'hst_def__fp_admin_passwd' =>  'FTP-jelszó',

    'database_user_orphaned_old_password_wrong' => "Nem javítható az árva felhasználó '%1': helytelen a jelszó.",
    'cannot_load_partner_central_property_key_no_exist' => "Nem lehet egyéni tulajdonságokat lekérdezni: nem létezik a licenckulcs.",
    'extensionScriptFailure' => "%1 végrehajtása nem sikerült, a következő hibaüzenet jelent meg: %3",
    '__ssl_redirect' => "Végleges, 301-es átirányítás HTTP-ről HTTPS-re",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Nem támogatott a DKIM kezelése.',
    'mail__dmarc_not_supported' => 'DMARC kezelése nem támogatott.',
    'mail__relay_white_list_not_supported' => 'Nem támogatott a fehérlista továbbítása.',
    'mail__black_list_not_supported' => 'Nem támogatott a Feketelista kezelése.',
    'mail__autoresponder_not_supported' => 'Nem támogatott az Automata válaszadó kezelése.',
    'mail__autoresponder_message_subject' => 'Automatikus válasz',
    'defaultcomponents__not_supported_version' => '(Nem támogatott verzió)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Nem található \'%1\' tanúsítvány.',
    'certificate__unable_setup_certificate' => 'Nem lehetséges a tanúsítvány telepítése: Hiányzik a titkos kulcs a tanúsítvány tartalma.',
    'certificate__used_by_panel' => 'A Plesk biztonságossá tételére szolgál az egyik tanúsítványt, melyet törölni készül.',
    'certificate__used_by_mail_server' => 'A levelezési kiszolgáló biztonságossá tételére szolgál az egyik tanúsítványt, melyet törölni készül.',
    'certificate__used_by_domain_service' => 'Domain szolgáltatáshoz használt az egyik törölni kívánt fájl.',
    'mail_server__not_installed' => 'Nem lehetséges a levelezési kiszolgáló tanúsítványának a telepítése, mivel nincs telepítve a levelezési kiszolgáló.',

    'email_activation_mail_subject' => 'Aktiválja a Plesk számláját.',
    'email_activation_mail_body' => "%1 Plesk kiszolgálón egy számlát hoztak létre. Számla adatai: Név: %2 E-mail cím: %3 Ha helyes ezen információ és Ön hozta létre a számlát, akkor a következő hivatkozással végezze el az aktiválását: %4 A számla aktiválásával engedélyezi a kiszolgáló birtokosa számára személyes adatai (név és e-mail cím) gyűjtését, tárolását, feldolgozását és használatát számlája létrehozására és támogatása céljából, összhangban a hatályos adatvédelmi törvényekkel, egy szerződés részeként.",

    'backup_transport_permission_name' => '%1 kezelése',
    'backup_transport_permission_description' => 'Engedélyezze %1 használatát biztonsági másolatok tárolásához.',

    'domain_move_err_target_no_hosting' => 'Impossible de déplacer le domaine vers un abonnement sans hébergement.',
    'domain_move_err_already_in_target' => 'Le domaine appartient déjà à l\'abonnement cible.',
    'domain_move_err_main_domain' => 'Le domaine principal ne peut être déplacé.',
    'domain_move_err_subdomain_without_parent' => 'Impossible de déplacer le sous-domaine %1 sans le domaine parent %2.',
    'domain_move_err_root_exists' => 'Le chemin cible de www_root %1 existe déjà.',
    'domain_move_err_nested_roots' => 'Impossible de déplacer le domaine car il partage le document root avec un autre domaine : %1.',
    'domain_move_err_no_mail_service' => 'Impossible de déplacer le domaine car le service de messagerie est désactivé sur l\'abonnement cible.',
    'domain_move_err_app' => "L'application installée sur %1 n'a pas été déplacée vers l'abonnement '%2' : %3",
    'domain_move_database_used_by_app' => "La base de données '%1' sur %2 est utilisée par l'application déplacée. Pour réaffecter la base de données à '%3', exécutez \" plesk bin database --assign-to-subscription \"",
    'domain_move_target_locked' => "La synchronisation de l'abonnement cible '%1' est verrouillée.",
    'domain_move_filesharing_disabled' => 'Partage de fichiers désactivé.',
    'domain_move_website_preview_disabled' => 'Le van tiltva a webhely előnézete.',
    'domain_move_additional_webserver_settings' => "Vérifiez les autres directives du serveur Web pour éviter tout problème de configuration.",
    'domain_move_no_permission' => "%1 nem engedélyezett '%2\\’ előfizetés számára.",
    'domain_move_no_access' => "'%1\\’ előfizetéshez nincs hozzáférés.",
    'domain_split_no_create_permission' => "Nem engedélyezett domain létrehozása.",
    'domain_split_empty_login' => 'A rendszerfelhasználó bejelentkezése szükséges.',
    'domain_split_empty_password' => 'A rendszerfelhasználó jelszava szükséges.',
    'domain_split_err_home_exists' => 'Nem helyezhető át %1 domain, mivel %2 helyen már létezik a cél  kezdőkönyvtárának az elérési útja. Egy új előfizetéshez való áthelyezéshez nevezze át a domaint.',
    'domain_split_err_no_hosting_subdomains' => 'Nem helyezhető át a domain egy új előfizetésbe, mivel nem rendelkezik üzemeltetéssel a  domain, de vannak aldomainjei. A domain áthelyezéséhez az „Üzemeltetés típusa” értékről „Webhely üzemeltetése” értékre változtassa az értékét (az Üzemeltetési beállításoknál).',
    'domain_split_target_locked' => "Zárolva van '%1' célelőfizetés szinkronizálása.",
    'domain_split_target_unsynced' => "A következő miatt nem történt meg '%1' célelőfizetésnek a csomaggal való szinkronizálása: %2.",
    'domain_merge_scheduled_backup_deactivated' => "'%1\\’ helyen megtörtént az ütemezett biztonsági mentés inaktiválása.",
    'domain_merge_database_error' => "Nem történt meg %2 helyen található '%1' adatbázis '%3' előfizetéshez áthelyezése: %4",
    'domain_merge_anon_ftp_deactivated' => "Ki van kapcsolva '%1' helyen található névtelen FTP .",
    'domain_merge_smb_user_access' => "Megtörtént '%1' újabb felhasználó ';%2' előfizetésre való áthelyezése, de visszavonásra került a felhasználó előfizetéshez való hozzáférése.",
    'domain_merge_scheduled_tasks' => "Megtörtént az ütemezett feladatoknak a cél előfizetésre való áthelyezése. Tekintse át a feladatok konfigurálását.",
    'domain_merge_scheduled_tasks_deactivated' => "Megtörtént az ütemezett feladatoknak a cél előfizetésre való áthelyezése és inaktiválása. Tekintse át a feladatok konfigurálását.",
    'domain_merge_no_remove_permission' => "Nem engedélyezett előfizetés eltávolítása.",
    'domain_merge_err_has_addons' => 'Nem végezhető el a hozzátartozó domainjeivel együtt a fődomain áthelyezése; először %1 domaint kell áthelyeznie.',
    'domain_merge_err_has_webusers' => 'Nem helyezhető át webes felhasználóival együtt a fődomain.',
    'domain_merge_err_root_exists' => '%1 cél elérési út már létezik.',

    'database_server_edit_used_for_psa' => 'Nem engedélyezett helyi MariaDB/MySQL adatbázis-kiszolgáló frissítése.',
    'suggest_repair_main_suggestion_ui' => '<b>A „Plesk javítás” segédprogram használatával javíthatja ki e hibát</b>.',
    'suggest_repair_main_suggestion_cli' =>  'A „Plesk javítás” segédprogram használatával javíthatja ki e hibát.',
    'suggest_repair_repair_kit_link_title' => 'Ugorjon a Diagnózis és javítás menüpontra.',
    'suggest_repair_using_cli_and_ui' => 'Ehhez futtassa a `plesk repair %1` parancsot a parancssori felület segítségével, vagy %2, és kattintson a „Plesk adatbázis” mellett található Javítás gombra.',
    'suggest_repair_using_cli' => 'Ehhez futtassa a `plesk repair %1` parancsot a parancssori felület segítségével',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'A biztonsági másolat készítésekor nem állt rendelkezésre a DNS-szolgáltatás. Azonban aktív DNS-zónák találhatóak a biztonsági másolatban, és a következő objektumok esetében ezek engedélyezve lesznek: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Erőforrás vezérlő (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Távoli SmarterMail támogatás',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(nem engedélyezi a licenckulcs)',
    'plesk_key__validation_failed' => '%1 (Hibakód: %2)',
    'promo__button_details' => 'Részletek',
    'promo__extension_catalog_title' => 'Bővítménykatalógus',
    'promo__extension_catalog_description' => 'Nézze meg az új bővítmény katalógust, és turbózza fel a Plesk kezelőpaneljét a különböző nagy teljesítményű bővítményekkel!',
    'promo__button_open_catalog' => 'A katalógus megnyitása',

    'backup__repository_check_login' => "Nem lehet a tárolóhoz férni: %1 Ellenőrizze, hogy helyesek-e a beírta tároló hitelesítő adatok.",
    'backup__repository_check_error_list' => "Nem lehet a tárolóhoz férni: %1 Ellenőrizze, hogy helyesek-e a beírt tároló beállítások.",
    'backup__repository_check_error_mkdir' => "Nem hozható létre a könyvtár: %1 Ellenőrizze, hogy rendelkezik-e mappáknak a tárolón való létrehozásához szükséges engedélyekkel.",
    'backup__repository_check_error_upload' => "Nem tölthető fel a fájl a tárolóba: %1 Ellenőrizze, hogy rendelkezik-e a tárolóba való feltöltéshez szükséges engedélyekkel.",
    'backup__repository_check_error_download' => "Nem tölthető le fájl a tárolóból: %1 Ellenőrizze, hogy rendelkezik-e fájlok fel- és letöltéséhez szükséges engedélyekkel.",
    'backup__repository_check_error_resume-upload' => "Nem folytatható a fájl tárolóba való feltöltése: %1 Ellenőrizze, hogy rendelkezik-e a tárolóba való feltöltés folytatásához szükséges engedélyekkel.",
    'backup__repository_check_error_resume-download' => "Nem folytatható a fájl letöltése a tárolóról: %1 Ellenőrizze, hogy rendelkezik-e a tárolóról való letöltésekhez folytatásához szükséges engedélyekkel.",
    'backup__repository_check_error_enable-utf8' => "Nem működtethető a tároló: %1 Ellenőrizze, hogy támogatja-e a tároló az UTF8-as kódolást.",
    'backup__repository_check_error_rm' => "Nem működtethető a tároló: %1 Ellenőrizze, hogy rendelkezik-e a tárolóról való törléshez szükséges engedélyekkel.",
    'backup__repository_check_error_rmdir' => "Nem működtethető a tároló: %1 Ellenőrizze, hogy rendelkezik-e a tárolóról mappák törléséhez szükséges engedélyekkel.",

    'backup__ftp_repository_check_login' => "%1 Függetlenül ellenőrizheti azokat a következő paranccsal: %2",
    'backup__ftp_repository_check_error_list' => "%1 Függetlenül ellenőrizheti azokat a következő paranccsal: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Függetlenül ellenőrizheti azt következő paranccsal: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Függetlenül ellenőrizheti azt következő paranccsal: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Függetlenül ellenőrizheti azt a következő parancsokkal: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Nem változtathatóak meg a DMARC beállítások. E beállítás engedélyezésére kapcsolja be a DKIM és SPF kéretlen levél elleni védelmet.',
    'spf_server_wide_disable_failed' => 'Nem változtathatóak meg a beállítások SPF kéretlen levél elleni védelem esetén. A SPF letiltására kapcsolja ki a DMARC bejövő levél hitelesítést.',
    'sfdk_server_wide_verify_disable_failed' => 'Nem változtathatóak meg a beállítások DKIM kéretlen levél elleni védelem esetén. A DKIM letiltására kapcsolja ki a DMARC bejövő levél hitelesítést.',

    'ccs_not_supported' => 'Az IIS központi tanúsítvány tároló nincs konfigurálva a rendszeren.',
    'ccs_not_enabled' => 'Az IIS központi tanúsítvány tároló kezelése nem engedélyezett a Plesk kezelőpanelen.',
    'ad_not_supported' => 'A kiszolgáló nincs domainhez csatlakozva.',

    'component_name__appinit' => "Alkalmazás inicializálása",
    'component_name__cors' => "Eredetközi erőforrás megosztás",
    'component_name__httpcompression' => 'HTTP tartalom tömörítése',
    'common_feature_is_not_supported' => 'Már nem támogatott e funkció.',
    'common_feature_is_not_supported_in_proto' => 'Nem támogatott e funkció %1 protokollverzió esetén.',
    'autoinstaller__plesk_component' => 'Plesk összetevő',
    'plesk_key__key_expired' => 'Lejárt a licenckulcsa. A Plesk kiszolgáló használatának a folytatásához, %1.',
    'plesk_key__key_purchase' => 'vásároljon egy új licencet',
    'plesk_key__key_expired_period' => 'Több mint %1 nappal ezelőtt lejárt a licenckulcsa.',

    'sa_action_move' => 'A levélszemét „Levélszemét” mappába helyezése',

    'bu_conflict_resolver_tomcat_not_supported' => 'Már nem támogatottak a Java alkalmazások. Nem áll a következő webhelyek rendelkezésére: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Már nem támogatottak a UNITY Mobile alkalmazás által üzemeltetett webhelyek mobilverziói. Nem áll a következő webhelyek rendelkezésére: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Az egész kiszolgálóra kiterjedő használati házirend nem engedélyezi személyes víruskereső beállítások használatát. A következő domaineken található e-mail fiókok esetén nem teljesen történik meg a visszaállításuk: {{objects}}',

    'module__not_installed' => "%1 bővítmény nincs telepítve.",

    'mail__mail_autodiscovery_server_error' => 'Adjon meg egy egyéni domain nevet az automatikus levelezés konfiguráláshoz.',
    'mail__error_mail_autodiscovery_enable' => 'Nem állítható be a automatikus levelezés konfigurálás: %1',
    'mail__error_mail_autodiscovery_server' => 'Nem állítható be egy egyéni domain név automatikus levelezés konfigurálás esetén: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Nem konfigurálhatóak át domainek automatikus levelezés konfigurálás DNS-rekordjai: %1',

    'mail__smarthost_not_configured_error' => 'Nincs konfigurálva a SmartHost szolgáltatás.',
    'mail__smarthost_attach_domains_error' => 'Hibákkal fejeződött be a domainek SmartHost szolgáltatáshoz csatolása:',

    '__invalid_url' => 'Érvénytelen az URL &quot;%1&quot;.',
    'actionlog__cloning_start' => 'Indítás',
    'actionlog__event_cloning_start' => 'Kiszolgáló klónozásának az indítása',

    '__UPLOAD_ERR_FORM_SIZE' => "A feltöltött fájl mérete meghaladja a megengedett méretet",
    '__UPLOAD_ERR_INI_SIZE' => "A feltöltött fájl mérete meghaladja a megengedett méretet",
    '__UPLOAD_ERR_NO_FILE' => "Nincs fogadott fájl",
    '__UPLOAD_ERR_OK' => "A fájl feltöltése sikerült",
    '__UPLOAD_ERR_PARTIAL' => "Csak részlegesen történt meg a fájl feltöltése, próbálja meg újból",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Hiányzik az Ideiglenes mappa.',
    '__UPLOAD_ERR_CANT_WRITE' => 'Nem sikerült a fájl lemezre írása.',
    '__UPLOAD_ERR_UNKNOWN' => 'Egy ismeretlen fájl feltöltése során hiba történt.',
    '__accounts' => "Fiókok",
    '__access' => "Hozzáférés",
    '__address' => "Cím",
    '__addresses' => "Címek",
    '__acl_records' => 'Hozzáférés-vezérlési lista rekordok',
    '__admin_repository' => "Rendszergazdai tároló",
    '__all' => 'Az összes',
    '__allowed' => "Engedélyezett",
    '__anonftp_status' => "Névtelen FTP",
    '__antispam' => "Levélszemét elleni védelem",
    '__apache_restart' => "...%1 webkiszolgáló újraindítása folyamatban, várjon...",
    '__asp' => "Microsoft ASP technológia",
    '__asp_dot_net' => "Microsoft ASP.NET keretrendszer",
    '__asp_dot_net_support' => "Microsoft ASP.NET támogatás",
    '__asp_win_support' => "Microsoft ASP támogatás",
    '__attachments' => "Mellékletek",
    '__attachments_list' => "Mellékletek",
    '__author' => 'Szerző',
    '__autoresp_name_already_exists' => "%1 nevű automatikus válasz már létezik.",
    '__autoresponder' => "Automatikus válasz",
    '__autoresponders' => "Automatikus válaszok",
    '__autoresponders_list' => "Automatikus válaszok",
    '__autoresponder_attachment_files' => "Automatikus válasz melléklet fájlok",
    '__auto_updates_list' => 'Rendelkezésre álló frissítések',
    '__backup_utilites' => "Biztonsági másolat segédprogramok",
    '__bind_status' => "A DNS kiszolgáló állapota",
    '__bu_is_not_installed' => "Ez a szolgáltatás jelenleg nem érhető el, mivel nem telepítették a biztonsági mentési segédprogramokat.",
    '__bu_not_support_in_key' => "Nem támogatja e licenckulcs a biztonsági mentési képességet.",
    '__notifications_not_support_in_key' => 'Az értesítéseket a licenckulcs nem támogatja.',
    'disabled_by_key' => 'Nem támogatja a licenckulcs.',
    '__bytes' => "Bájt",
    '__can_not_use_reserved_words' => "Nem használhat fenntartott szavakat.",
    '__certificate' => "Tanúsítvány",
    '__cgi_support' => "CGI támogatás",
    '__city' => "Város",
    '__cl_not_exist' => "Ügyfélszámla nem létezik.",
    '__client' => 'Ügyfél',
    '__client_card' => "Ügyfélkarton",
    '__client_contact_name' => "Ügyfél kapcsolattartójának a neve",
    '__client_form' => "Személyi adatok",
    '__client_ip_pool' => "Ügyfél IP-készlete",
    '__client_limits' => "Ügyfélszámla korlátok",
    '__client_permissions' => "Ügyfél engedélyei",
    '__client_preferences' => "Ügyfél beállításai",
    '__client_status' => "Ügyfél állapota",
    '__client_total' => "Ügyfél összesen",
    '__client_with_login_name_already_exists' => "\"%1\" nevű felhasználó már létezik.",
    '__client_domuser_with_login_already_exists' => "'%1' ügyfélnevet már használja '%1' domain adminisztrátora.",
    '__clients_global_changes' => "Kiválasztott ügyfélszámlák módosítása",
    '__cmd_not_found' => "Ismeretlen parancs: %1",
    '__comments' => "Megjegyzések",
    '__component_version' => "Komponens verziója",
    '__component_not_installed' => "Nem történt meg %1 összetevő telepítése.",
    '__confirm_overwrite' => "Erősíts meg a felülírást.",
    '__confirm_stop' => "Meg kell erősítenie a folyamat leállítását.",
    '__confirm_passwd' => "%1 jelszó megerősítése",
    '__conhelp' => "Leírás",
    '__contact_name' => "Kapcsolattartó neve",
    '__country' => "Ország",
    '__countries' => 'Ország',
    '__country_unknown' => 'Nem ismerhető fel az ország alkódja.',
    '__courier-imap' => 'Courier kiszolgáló',
    '__create_domain' => 'Domain létrehozása',
    '__crypted' => 'titkosított',
    '__cp_access' => "Hozzáférés a Plesk kezelőpanelhez",
    '__cp_user' => "Plesk felhasználó",
    '__create' => "Létrehozás",
    '__create_client_template_without_template' => "Felhasználói számla sablon nélküli létrehozása",
    '__create_domain_for' => "<b>%1</b> számára domain létrehozása",
    '__create_domain_template_without_template' => "Domain létrehozása sablon nélkül",
    '__creation_date' => "Létrehozási dátum",
    '__crontab_unix' => "Ütemező",
    '__crontab_win' => "Ütemező",
    '__ct_month_jan' => 'Január',
    '__ct_month_feb' => 'Február',
    '__ct_month_mar' => 'Március',
    '__ct_month_apr' => 'Április',
    '__ct_month_may' => 'Máj',
    '__ct_month_jun' => 'Június',
    '__ct_month_jul' => 'Július',
    '__ct_month_aug' => 'Augusztus',
    '__ct_month_sep' => 'Szeptember',
    '__ct_month_oct' => 'Október',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'December',
    '__custom_button' => "Egyéni gomb",
    '__custom_buttons_list' => "További szolgáltatások hivatkozásai",
    '__daily' => "Napi",
    '__database_not_activated' => "Nem történt meg %1 aktiválása a kiszolgáló adminisztrátor oldalon.",
    '__database_not_installed' => "%1 adatbázis nincs telepítve.",
    '__database_not_run' => "%1 adatbázis nem fut.",
    '__database_is_corrupt' => "Sérült a Plesk adatbázisa. Indítsa el az Újrakonfiguráló segédprogramot a kijavítására.",
    '__databases' => "Adatbázisok",
    '__databases_list' => "Adatbázisok",
    '__database_type_not_supported_by_key' => '%1 kiszolgáló használatához a licenckulcsának támogatása szükséges. Forduljon a Plesk értékesítési képviselőjéhez.',
    '__date_immediately' => "ma",
    '__date_never' => "soha",
    '__day(s)' => "Nap",
    '__day0' => "Vas",
    '__day1' => "Hét",
    '__day2' => "Kedd",
    '__day3' => "Szer",
    '__day4' => "Csüt",
    '__day5' => "Pén",
    '__day6' => "Szom",
    '__days' => "%1 nap",
    '__db_admin_login_empty' => "Nem írt be felhasználónevet, kezelőszerv kikapcsolása %1 által a kezelőfelületen. Akarja folytatni?",
    '__db_unable_to_unregister' => 'Nem lehet az adatbázis kapcsolat paramétereit eltávolítani.',
    '__db_db_exists' => 'Legalább egy adatbázis található a kiszolgálón.',
    '__db_unable_to_change_server_name' => 'Nem változtatható meg a kiszolgáló neve.',
    '__db_unable_to_change_port' => 'Nem változtatható meg a kiszolgáló portja.',
    '__db_already_exist' => "%1 adatbázis már létezik.",
    '__db_credentials_invalid' => "Érvénytelenek az adatbázis hitelesítő adatok.",
    '__db_invalid_password_characters' => 'Érvénytelen karaktereket tartalmaz a jelszó.',
    '__db_engine' => "Adatbázis motor", // indirect
    '__db_type' => "Adatbázis típusa",
    '__db_user' => "Adatbázis-felhasználó",
    '__db_server' => 'Adatbázis-kiszolgáló',
    '__def_domain' => "Alapértelmezett domain",
    '__default_for_mysql' => 'alapértelmezett MySQL esetén',
    '__default_for_mariadb' => 'MariaDB alapértelmezése',
    '__default_for_percona' => 'Percona alapértelmezése',
    '__default_for_postgresql' => 'alapértelmezett PostgreSQL esetén',
    '__delete' => "Törlés",
    '__demo' => "Bemutató verzióban nem áll rendelkezésre e funkció.",
    '__directory' => "Könyvtár",
    '__disable_lock_screen' => 'Felhasználók megakadályozása a Plesk kezelőpanellel történő munkavégzésben a kezelőfelület képernyő teljes feltöltéséig.',
    '__dismiss_news?' => "Biztosan teljesen be akarja zárni a hírblokkot?\n\nAddig nem látja a hírblokkot, amíg több hír áll rendelkezésre.",
    '__description' => "Leírás",
    '__disabled' => "ki van kapcsolva",
    '__disk_space_limit' => "Lemezhasználati korlát",
    '__cgroups_cpu_usage_limit' => 'CPU-használati korlát',
    '__cgroups_ram_usage_limit' => 'RAM-használati korlát',
    '__cgroups_disk_read_usage_limit' => 'Lemezolvasási sávszélesség korlát',
    '__cgroups_disk_write_usage_limit' => 'Lemezírási sávszélesség korlát',
    '__disk_usage_by' => "%1 által használt lemezterület",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "'%1' DNS-rekord már létezik.",
    '__dns_master_should_be_remote' => "Két különböző mérvadó névkiszolgálóval kell rendelkeznie különböző állomásokon.",
    '__dns_record_not_exist' => "A DNS-rekord nem létezik.",
    '__dns_server' => "DNS-kiszolgáló", // indirect
    '__dom_id_is_undefined' => "Nincs domain azonositó meghatározva.",
    '__dom_name' => "Domain név",
    '__dom_name_is_invalid' => "A domain név érvénytelen. Győződjön meg róla, hogy a domain név csak alfanumerikus karaktereket, pontot és kötőjelet tartalmaz és nem hosszabb 255 szimbólumnál. A domai név pontok közötti része nem haladhatja meg a 63 karaktert.",
    '__dom_not_exist' => "A domain nem létezik.",
    '__domain' => "Domain",
    '__domain_' => '%1 domain',
    '__domain_form' => "Domain űrlap",
    '__domain_id' => "Domainazonosító",
    '__domain_is_turned_off_for_backup' => "%1 ideiglenesen ki van kapcsolva a biztonsági mentés vagy visszaállítás idejére, így jelenleg nem áll rendelkezésre.",
    '__domain_limits' => "Domain korlátok",
    '__domain_name' => "Domain név",
    '__mail_name_in_ASCII_form' => "ASCII formátumú postafiók név",
    '__message_error' => 'Hiba',
    '__message_warning' => 'Figyelmeztetés',
    '__message_info' => 'Információ',
    '__domain_name_in_ASCII_form' => "Domain név ASCII formátumban",
    '__domain_repository' => "%1 domain tárolója",
    '__domain_status' => "Domain állapota",
    '__domain_found_tech' => "A domainen talált technológia",
    '__domain_dns' => 'Domain DNS-zóna',
    '__domain_total_powerUser' => "Az előfizetés teljes összege",
    '__domain_user' => "Domain adminisztrátor",
    '__domains_global_changes' => "Kiválasztott domainek módosítása",
    '__mailnames_global_changes' => "Kiválasztott postafiókok módosítása",
    '__backup_manager' => 'Biztonsági mentés kezelő',
    '__domains_list' => "Domainek",
    'domains_list__list_header' => "domainek",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "www kezdetű a domain név, bár WWW előtag is használatos.\nMindenképpen folytatja?",
    '__dovecot' => 'Dovecot IMAP- és POP3-kiszolgáló',
    '__dsmail' => "E-mail szolgáltatás",
    '__dsmaillist' => "Levelezési lista szolgáltatás",
    '__dumps_tot_size' => "Biztonsági másolat fájlok teljes mérete a helyi tárolón",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "Az e-mail cím érvénytelen.",
    '__enabled' => "be van kapcsolva",
    '__enter_cert_text' => "Tanúsítvány szövegének beírása",
    '__enter_size' => "Méret beírása",
    '__exclusive' => "Dedikált",
    '__expiration_date' => "Lejárati dátum",
    '__fax' => "Fax",
    '__file' => "Fájl",
    '__file_is_empty' => "Üres a fájl.",
    '__file_name' => "Fájlnév",
    '__file_type' => 'Fájltípus',
    '__filemanager' => "Fájlkezelő",
    '__filepath_is_empty' => "Az fájl elérési útja üres",
    '__files_list' => "Fájlok",
    '__frontpage' => "Microsoft FrontPage szoftver",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-beállítások",
    '__ftp_serv' => "FTP-kiszolgáló", // indirect
    '__ftp_server_parameters_are_empty' => "Először kell állítania az FTP-fiók tulajdonságait!",
    '__ftp_status' => "FTP-kiszolgáló állapota",
    '__full_day0' => "Vasárnap",
    '__full_day1' => "Hétfő",
    '__full_day2' => "Kedd",
    '__full_day3' => "Szerda",
    '__full_day4' => "Csütörtök",
    '__full_day5' => "Péntek",
    '__full_day6' => "Szombat",
    '__full_month1' => "Január",
    '__full_month10' => "Október",
    '__full_month11' => "November",
    '__full_month12' => "December",
    '__full_month2' => "Február",
    '__full_month3' => "Március",
    '__full_month4' => "Április",
    '__full_month5' => "Máj",
    '__full_month6' => "Június",
    '__full_month7' => "Július",
    '__full_month8' => "Augusztus",
    '__full_month9' => "Szeptember",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Merevlemez kvóta",
    '__hard_disk_quota_not_supported' => 'a kiszolgáló fájlrendszerének konfigurációja nem támogatja a merevlemez kvótát',
    '__help_topic_not_found' => 'A megjelölt témakör (%1 )nem található a súgótémakörök között.',
    '__hosting_ip_dns_ip_not_equiv' => "Egyik A típusú DNS-rekordban megadott IP-cím sem egyezik az üzemeltetéshez használt IP-címmel.",
    '__hosting_scripting' => "Üzemeltetés parancsfálkezelés támogatása",
    '__hosting_setup_page_title' => "%1 domain webüzemeltetési beállítása",
    '__hosting_title' => "Üzemeltetés (%1)",
    '__hosting_type' => "Üzemeltetési típus",
    '__hostname_is_empty' => "Az állomásnév üres.",
    '__hour(s)' => 'Óra',
    '__hst_type_incorrect' => "Nem helyes az üzemeltetés típus.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Üresjárati idő",
    '__iface' => "Kezelőfelület",
    '__image' => "Kép",
    '__imap_status' => "IMAP-kiszolgáló állapota",
    '__incorrect_databases_login_pass' => "Helytelen hitelesítő adatokat adott meg a PostgreSQL adatbázishoz férés számára.",
    '__incorrect_ip_or_network_address' => 'Helytelen a megadott IP-cím vagy hálózat.',
    '__info' => 'Információ',
    '__install' => "Telepítés",
    '__install_prefix' => "Telepítési előtag",
    '__invalid_cert_id' => "Érvénytelen tanúsítvány azonosító",
    '__invalid_context' => "Érvénytelen környezet: %1",
    '__invalid_db_usr_name' => "Adatbázis-felhasználó neve érvénytelen.",
    '__invalid_dir_name' => "Érvénytelen a könyvtárnév",
    '__invalid_dom_name' => "A domain név érvénytelen.",
    '__invalid_filename' => "Érvénytelen fájlnév. Ne használjon aposztróf és/vagy \"../\" kombinációt.",
    '__invalid_id' => "Érvénytelen azonosító.",
    '__invalid_lines_num' => "Nem megfelelő érték szerepel a sorok számában, csak számjegyek használata engedélyezett.",
    '__invalid_max_letter_size' => "Érvénytelen a maximális üzenetméret.",
    '__invalid_restart_apache_interval' => "Érvénytelen az Apache újraindítási időköze.",
    '__invalid_tmpl_name' => "A sablonnév érvénytelen.",
    '__invalid_value' => "Nem megfelelő érték.",
    '__ip_addr' => "IP-cím",
    '__ip_address_and_mask' => "IP-cím és alhálózati maszk",
    '__ip_alias__mask' => "IP-cím és alhálózati maszk",
    '__ip_addr_is_invalid' => "Az IP-cím érvénytelen.",
    '__ip_addr_list' => "IP-címek",
    '__ip_address_and_mask_hint' => 'Például, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "Java fejlesztőeszköz",
    '__kb' => "KB",
    '__kbps' => "kB/s",
    '__kbytes' => "kbájt",
    '__key_for_virtuozzo_only' => "A licenckulcsoát kizárólag Virtuozzo konténerekben történő használatra szánták.",
    '__key_limits_exceeding' => "E művelet túllépi az szoftverlicenc korlátait. Ha ezt az üzenetet kapja, akkor vegye fel a kapcsolatot a szolgáltatójával vagy a gyártóval a licenc korlátainak tisztázására vagy kiterjesztésére.",
    '__kilo' => "K",
    '__keywords' => 'Kulcsszavak',
    '__lang_unknown' => 'Nem ismeri fel a nyelvet.',
    '__languages' => 'Nyelv',
    '__learn_more' => 'További tudnivalók',
    '__loading' => 'Betöltés',
    '__locales' => "Nyelvi csomagok",
    '__lists' => "Levelezési listák",
    '__literal_bytes' => "B",
    '__processing' => "Várjon.<br>Betöltés.",
    '__locale' => "Kezelőfelület nyelve",
    '__locale_is_not_defined' => "Nincs meghatározva a kezelőfelület nyelve.",
    '__local_server_mysql' => 'Helyi MariaDB/MySQL kiszolgáló',
    '__local_server_postgresql' => 'Helyi PostgreSQL-kiszolgáló',
    '__local_server_mssql' => 'Helyi MS SQL-kiszolgáló',
    '__log_and_statistics_files' => 'Naplófájlok és statisztikai jelentések',
    '__config_files' => 'Konfigurációs fájlok',
    '__chroot_files' => 'Chroot környezet',
    '__login' => "%1 Bejelentkezés",
    '__login1' => "Bejelentkezés",
    '__login_disabled' => "Tiltva van a bejelentkezés.",
    '__login_enabled' => "Engedélyezve van a bejelentkezés.",
    '__login_incorrect' => "Helytelen felhasználónév vagy jelszó. Próbálja meg újból.",
    '__login_rate_limit_reached' => "Túl sok a kísérlet. Később próbálja meg újból.",
    '__login_name' => "%1 felhasználónév",
    '__login_name_is_invalid' => "%1 felhasználónév érvénytelen.",
    '__logon_time' => "A bejelentkezés ideje",
    '__ma' => "E-mail aliasok",
    '__mail' => "E-mail",
    '__mail_alias_name' => "E-mail alias",
    '__mail_autodiscovery' => 'Automatikus levelezés konfigurálás',
    '__mail_exchanger_name_is_invalid' => "Érvénytelen a cserélőnév.",
    '__mail_groups' => "Levelezési csoportok",
    '__mail_list_engine' => "Levelezési lista szoftver",
    '__mail_name' => "Postafiók",
    '__mail_name_form' => "Postafiók tulajdonságok",
    '__mail_names' => "Postafiókok",
    '__mail_serv' => "Levelezési kiszolgáló",
    '__mail_user' => 'Levelezési felhasználó',
    '__mailgroup' => "Levelezési csoport",
    '__maillist' => "Levelezési lista",
    '__maillists' => "Levelezési listák",
    '__maillist_member' => 'A levelezési lista tagja',
    '__mailname' => "Postafiók",
    '__mailname_redir_self' => "Nem végezhet Önmagának továbbítást a postafiók.",
    '__max_dom_num_reached_for_cl' => "Megtörtént a domainszám korlát elérése e felhasználói számla esetében.",
    '__max_file_size_available' => "A megengedett maximális fájlméret %1",
    '__max_subdom_num_reached_for_cl' => "Megtörtént az aldomainszám korlát elérése e felhasználói számla esetében.",
    '__max_subdom_num_reached_for_dom' => "Megtörtént az aldomain szám korlátjának az elérése a domain esetében.",
    '__max_subdom_num_reached_for_key' => "Megtörtént a licenckulcs által engedélyezett aldomain szám korlát elérése.",
    '__max_traffic_limit' => "Forgalmi korlát",
    '__maximum_excl_ip_num' => "Postafiókok",
    '__mb' => "MB",
    '__mbytes' => "MBájt",
    '__mb_month' => "MB/hónap",
    '__mb_sec' => "MB/s",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'perc',
    '__mls_not_in_key' => "A jelenlegi termékkulcs nem támogatja többnyelvű kezelőfelületet.",
    '__modification_date' => "Módosítási dátum",
    '__module' => "Bővítmény",
    '__month' => "hónap",
    '__month(s)' => "hónap",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Dec",
    '__month2' => "Feb",
    '__month3' => "Már",
    '__month4' => "Április",
    '__month5' => "Máj",
    '__month6' => "Június",
    '__month7' => "Július",
    '__month8' => "Aug",
    '__month9' => "Szeptember",
    '__monthly' => "Havi",
    '__months' => "hónap",
    'day-ariaLabel' => 'nap beírása',
    'month-ariaLabel' => 'hónap beírása',
    'year-ariaLabel' => 'év beírása',
    'select-ariaLabel' => 'érték kiválasztása',
    '__moved_permanently' => 'Tartósan áthelyezett',
    '__mssql' => "Microsoft SQL-kiszolgáló",
    '__mssql__server' => "Kiszolgáló",
    'mssql__server' => "Microsoft SQL-kiszolgáló név",
    'mssql__unable_to_change_server_name_db_exists' => "Nem változtatható meg a kiszolgáló neve: legalább egy adatbázis található rajta.",
    '__mssql_status' => "Microsoft SQL-kiszolgáló állapota",
    '__multiply_login_deny' => "Nem tud bejelentkezni. Ugyanilyen felhasználónévvel (%1) már bejelentkezett egy másik felhasználó a Plesk kezelőpanelbe.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL kiszolgáló állapota",
    '__mysql_version' => "MySQL verzió",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB kiszolgáló állapota",
    '__mariadb_version' => "MariaDB verzió",
    '__percona' => "Percona",
    '__percona_status' => "Percona kiszolgáló állapota",
    '__percona_version' => "Percona verzió",
    '__name' => "Név",
    '__name_invalid' => "A név érvénytelen.",
    '__nameserver' => "névkiszolgáló",
    '__network' => "Hálózat",
    '__networks' => "Hálózatok",
    '__no' => "Nem",
    '__no_ip_address_with_properly_type_available' => "Nem lehet helyreállítani a biztonsági mentés adatokat, mivel nem állnak megfelelő IP-címek rendelkezésre a helyreállítási művelethez.",
    '__no_clients_specified' => "Nincsenek ügyfélszámlák megadva.",
    '__no_comments' => "Nincsenek megjegyzések.",
    '__nologin' => "Tiltott",
    '__none' => "Nincs",
    '__not_configured' => "Nincs konfigurálva",
    '__not_implemented_yet' => "Nincs még megvalósítva.",
    '__not_supported_by_ftp' => "(FTP-kiszolgáló által nem támogatja)",
    '__notification' => "Értesítés",
    '__num_displayed' => "%1 / %2 megjelenítésre kerül",
    '__num_is_invalid' => "A szám érvénytelen.",
    '__object_not_found' => 'Nem található objektum: %1',
    '__off' => "Ki",
    '__ok' => "OK",
    '__old_passwd' => "Régi %1 jelszó",
    '__on' => "Be",
    '__others' => "Egyebek",
    '__other_ip__will_be_added' => 'Már rendelkezésre álló IP-címek (hozzáadásra kerülnek az ügyfél IP-cím készletéhez)',
    '__p' => "P",
    '__passwd' => "%1 jelszó",
    '__passwd_is_invalid' => "A(z) %1 jelszó érvénytelen.",
    '__path' => "Útvonal",
    '__perl_unix_support' => "Perl támogatás",
    '__perl_win_support' => "Perl támogatás",
    '__perm_denied' => "Engedély megtagadva.",
    '__permissions' => "Engedélyek",
    '__personal_name' => "Név",
    '__pg_admin_not_activated' => "Nem történt meg a PostgreSQL adatbázis aktiválása a kiszolgáló adminisztrátor oldalon.",
    '__pg_not_inst' => "Nincs PostgreSQL telepítve.",
    '__pg_not_run_or_inst' => "Nincs PostgreSQL telepítve vagy nem fut.",
    '__pg_not_support_in_key' => "Nem támogatja a licenckulcs a PostgreSQL adatbázist.",
    '__phone' => "Telefonszám",
    '__phosting' => "Fizikai üzemeltetés",
    '__php_support' => "PHP-támogatás",
    '__php_run_as_isapi' => "Futás ISAPI kiterjesztésként",
    '__php_safe_mode' => "PHP 'safe_mode' be",
    '__php_version' => "PHP-verzió",
    '__physical' => "Fizikai üzemeltetés",
    '__plesk_stat_pdir' => "'/plesk-stat/webstat/' védett könyvtár",
    '__plesk_stat_dir_name' => "Domain statisztikák",
    '__plesk_stat_protect' => "A felhasználó FTP felhasználónevével és jelszavával védje a webstatisztikákhoz való hozzáférést",
    '__plesk_stat_protect_install' => "'/plesk-stat/webstat/' jelszóval védett könyvtáron keresztül érhető el",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-kiszolgáló állapota",
    '__popen_error' => "Hiba lépett fel a popen függvény hívásakor.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL állapota",
    '__preferences' => "Beállítások",
    '__account_preferences' => "Számla beállításai",
    '__interface_preferences_general' => 'Általános',
    '__interface_preferences_default' => 'Alapértelmezett kezelőfelület beállítások',
    '__interface_preferences_admin' => "Renszergazda kezelőfelület beállítások",
    '__interface_template' => 'Interfész testreszabási sablon',
    '__interface_preferences' => "Kezelőfelület beállítások",
    '__proceed?' => "Biztosan folytatja?",
    '__provider_contact_name' => "Tulajdonos kapcsolattartójának neve",
    '__python_unix_support' => "Python támogatás",
    '__python_win_support' => "Python támogatás",
    '__quota' => "Kvóta",
    '__r' => "R",
    '__reconfigure' => "Újrakonfigurálás",
    '__record_type' => "Rekordtípus",
    '__release' => "Kiadás",
    '__remote_db_not_supported_by_key' => 'Nem támogatja a távoli adatbázis üzemeltetést a licenckulcsa.',
    '__remove_protection' => 'Védelem eltávolítása',
    '__report' => "Jelentés",
    '__report_size_na' => "Nem áll rendelkezésre a szolgáltatás",
    '__reports_list' => "Jelentések",
    '__requested' => "Igényelt",
    '__required_fields' => "Kötelezően kitöltendő mezők",
    '__resp_name_invalid' => "Érvénytelen az Automatikus válasz neve. Kizárólag alfanumerikus karaktereket, pontot, aláhúzásjelet és szóköz karaktereket használhat.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "A kiszolgálónév érvénytelen.",
    '__screenshots' => 'Képernyőképek',
    '__script_warning' => "Ha eltávolítja a parancsfájlkezelést e domainből, akkor az összes érintett parancsfájl egyszerű szövegként fog megjelenni a böngészőben. Célszerű, ha a rendszergazda az összes érintett parancsfájlt eltávolítja az adott domainből.",
    '__sec' => "Másodperc",
    '__second(s)' => "Másodperc",
    '__see_list_of_logged_in' => "Tekintse meg a jelenleg bejelentkezett felhasználók listáját.",
    '__select_certs_to_remove' => "Az eltávolítandó tanúsítványok kiválasztása.",
    '__select_files_to_remove' => "Az eltávolítandó fájlok kiválasztása.",
    '__select_ip' => "IP-cím hozzárendelése",
    '__select_ip_to_remove' => "Egy eltávolítandó IP-cím kiválasztása.",
    '__select_domain_template' => "Domainsablon beállítások használat",
    '__select_templates_to_remove' => "Az eltávolítandó sablonok kiválasztása.",
    '__server' => "Kiszolgáló",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MariaDB/MySQL adatbázis-kiszolgáló",
    '__service_description__mysql' => "MariaDB/MySQL adatbázis-kiszolgáló",
    '__service_title__web' => "Webkiszolgáló",
    '__service_description__web' => "Webkiszolgáló",
    '__service_title__smtp' => "SMTP-kiszolgáló",
    '__service_description__smtp' => "SMTP-kiszolgáló",
    '__service_title__mail' => "IMAP/POP3-kiszolgáló",
    '__service_description__mail' => "IMAP/POP3-kiszolgáló",
    '__service_title__dns' => "DNS-kiszolgáló",
    '__service_description__dns' => "DNS-kiszolgáló",
    '__service_title__postgresq' => "PostgreSQL adatbázis-kiszolgáló",
    '__service_description__postgresq' => "PostgreSQL adatbázis-kiszolgáló",
    '__service_title__spamassassin' => "SpamAssassin levélszemét szűrő szolgáltatás",
    '__service_description__spamassassin' => "SpamAssassin levélszemét szűrő szolgáltatás",
    '__all_services' => "Az összes szolgáltatás",
    '__sessions' => "Munkamenetek",
    'sessions__feature_ftp_session_manager_not_supported' => "Nem támogatja a jelenlegi FTP-kiszolgáló az FTP-munkamenet funkciót.",
    '__sessions_list' => "Munkamenetek",
    '__set' => "Bekapcsolás",
    '__shared' => "Megosztott",
    '__shell_access_warning' => "A rendszerhez történő hozzáférés engedélyezése nagyon veszélyes adatbiztonsági szempontból. Csak akkor tegye lehetővé a hozzáférést a rendszerhez, ha pontosan érti mit tesz, és akkor is csak a megbízható felhasználók számára. Biztosan folytatja?",
    '__siteapp_not_support_in_key' => "Nem támogatja a webalkalmazásokat a licenckulcs.",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Kézzel végezték e webalkalmazás konfigurációjának a változtatását. A kézzel végzett változtatások védelme érdekében, nem áll rendelkezésre a Plesk kezelőpanelen keresztül végzett újrakonfigurálás eredménye.',
    '__site_management' => "Közzététel a weben", // indirect
    '__size' => "Méret",
    '__skins' => 'Felszínek',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-kiszolgáló állapota",
    '__some_fields_are_empty_or_invalid' => "Néhány mező üres, vagy helytelen értéket tartalmaz.",
    '__no_email_addresses_selected' => 'Nincsenek e-mail címek kiválasztva.',
    '__unable_to_set_parameters' => "Nem végezhető el az alkotóelem paramétereinek a beállítása.",
    '__spamassassin' => "Levélszemét szűrő",
    '__spamassassin_status' => "SpamAssasin állapota",
    '__spamd_status' => 'Levélszemét szűrő állapota',
    '__splited_backup' => "(többkötetes biztonsági mentés)",
    '__split_backup_file' => "Többkötetes biztonsági mentés létrehozása",
    '__split_backup_size' => "Kötetméret",
    '__split_backup_less_than_500' => "Nem támogatottak az 500 MB-nál kisebb kötetméretek",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-támogatás",
    '__ssi_with_html' => "SSI használata *.htm, *.html fájl esetében",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-támogatás",
    '__same_ssl' => "SSL/TLS- és nem SSL/TLS-tartalmak azonos könyvtárban tárolása",
    '__same_ssl_cu' => "Közös SSL/TLS és nem SSL/TLS-tartalom",
    '__state' => "Állam/megye",

    '__status__Active' => 'Aktív',
    '__status__active' => 'aktív',
    '__status__Passive' => 'Kikapcsolva',
    '__status__passive' => 'ki van kapcsolva',
    '__status__off' => 'ki van kapcsolva',
    '__status__with_parent' => 'ki van kapcsolva',
    '__status__backup_restore' => 'átmenetileg felfüggesztve biztonsági mentés vagy visszaállítás miatt',
    '__status__admin' => 'kiszolgáló adminisztrátor által felfüggesztett',
    '__status__resseler' => 'viszonteladó által felfüggesztett',
    '__status__client' => 'ügyfél által felfüggesztett',
    '__status__unknown' => 'az állapot ismeretlen',

    '__status_of' => "%1 állapot",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel alkalmazás",
    '__stunnel_server' => "Stunnel kiszolgáló", // indirect
    '__subdomain' => "Aldomain",
    '__subdomain_name' => "Aldomain név",
    '__subdomain_name_in_ASCII_form' => "ASCII formátumú aldomain név",
    '__subdomains' => "Aldomainek",
    '__domainaliases' => "Domain aliasok",
    '__subdomains_list' => "Aldomainek",
    '__subdomains_not_support_in_key' => "Az aldomain műveleteket a jelenlegi licenckulcs nem támogatja",
    '__sys_user_type' => "FTP-felhasználó",
    '__sys_user_type_main' => "A fődomain FTP-felhasználói fiókjának használata",
    '__sys_user_type_native' => "Különálló FTP-felhasználói fiók létrehozása ezen aldomain számára",
    '__target_domain' => "Céldomain",
    '__template' => "Sablon",
    '__template_not_accepted' => "Nem fogadható el a sablon: a következő határértékeket meghaladása miatt.",
    '__templates' => "Sablonok",
    '__templates_list' => "Sablonok",
    '__tera' => "T",
    '__title' => "Beosztás",
    '__total' => "Teljes %1",
    '__total_size' => "Teljes méret",
    '__total_used' => "Összesen használt",
    '__traffic' => "Forgalom",
    '__traffic_by_client' => "Ügyfél forgalma",
    '__traffic_by_domain' => "Domain részesedése a forgalomból",
    '__traffic_by_service' => "Szolgáltatás részesedése a forgalomból",
    '__traffic_history' => "Forgalmi kimutatás",
    '__unable_change_locale' => "A kezelőfelület nyelvének megváltoztatása nem lehetséges: %1",
    '__unable_create_new_dom' => "Nem lehetséges egy domain létrehozása. %1",
    '__unable_define_dom_name' => "Domainnév meghatározása nem lehetséges: %1",
    '__unable_define_necessary_properties' => "Az összes szükséges tulajdonság meghatározása nem lehetséges.",
    '__unable_define_properties' => "Tulajdonságok meghatározása nem lehetséges: %1",
    '__unable_exec_util' => "Segédprogram végrehajtása nem lehetséges: %1",
    '__unable_get_dns_a_recs' => "Nem lehetséges A típusú DNS-rekordok számára IP-címeket beolvasni ezen üzemeltetési számla esetén: %1",
    '__unable_get_mbox_quota' => "A postaláda kvóta információk lekérése nem lehetséges.",
    '__unable_redirect_to_myself' => "Nem lehetséges ugyanarra a számlára továbbítást végezni.",
    '__unable_redirect_to_my_alias' => "Nem lehet e-mailt továbbítani egy e-mail alias számára.",
    '__default_domain_redirect_to_myself' => "Nem lehet a domaint alapértelmezettként IP-cím számára beállítani:\n Saját magára átirányítás észlelése történt.",
    '__unable_remove_client' => "Nem lehetséges ügyfelet eltávolítani: %1",
    '__unable_set_up_mbox_quota' => "A postaláda kvóta beállítása nem lehetséges: %1",
    '__unable_setup_pass' => "Jelszó beállítása nem lehetséges: %1",
    '__unable_to_create_new_account' => "Nem lehetséges egy számla létrehozása: %1",
    '__unable_to_define_db_size' => "Nem lehetséges adatbázis méret meghatározása.",
    '__unable_to_enable_short_names' => "Nem lehetséges rövid postafiók nevek használata POP3/IMAP-fiókok esetében.",
    '__unable_to_fetch_data_from_submit' => "Az elküldött adatok beolvasása nem lehetséges: %1",
    '__unable_to_open_file' => "Nem lehetséges %1 fájl megnyitása: %2",
    '__unable_to_update_subdomain' => "Az aldomainre vonatkozó változtatások érvényesítése nem lehetséges: %1",
    '__unable_update_cl_data' => "Nem lehetséges a felhasználói számla változtatásainak mentése: %1",
    '__unable_update_db_params' => "Az adatbázis paraméterek frissítése nem lehetséges: %1",
    '__unable_update_dom_data' => "A domain adatok frissítése nem lehetséges: %1",
    '__undefined' => "nem meghatározott",
    '__uninstall' => "Eltávolítás",
    '__unknown_error' => "Ismeretlen hiba",
    '__unlimited_lower' => "Korlátlan",
    '__unset' => "Kikapcsolás",
    '__update' => "Frissítés",
    '__uploaded_file_is_invalid' => "A feltöltött fájl érvénytelen: %1",
    '__url' => "URL-cím",
    '__usage' => "Lemezhasználat",
    '__user_already_logged' => "Ugyanilyen felhasználónévvel (%1) már bejelentkezett egy másik felhasználó a Plesk kezelőpanelbe.",
    '__version' => "Verzió",
    '__aps_license' => "Licenckulcs",
    '__vh_type' => "Virtuális állomás típusa",
    '__vhosts_apache_status' => "Webkiszolgáló állapot",
    '__wrong_charset_conversion' => 'Helytelen karakterkészlet, "%1" és "%2" közötti konverzió nem engedélyezett',
    '__warning_' => "Figyelmeztetés!",
    '__warning_excl_ip_num' => "Dedikált IP-cím",
    '__warning_expiration' => "Lejárati dátum",
    '__web_scripting' => "Webes parancsnyelv", // indirect
    '__web_serv' => "Webkiszolgáló", // indirect
    '__web_statistic' => "Webstatisztikák", // indirect
    '__webmail' => "Webes levelezés", // +indirect
    '__webstat_not_installed' => "Webalizer nincs telepítve e kiszolgálón. A Webalizer telepítésével kapcsolatosan forduljon a szolgáltatójához.",
    '__webstat_support' => "Webstatisztikák",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Amikor az egyik statisztikai programról a másikra vált, akkor törlésre kerül az előző statisztikai program által készített összes jelentés, majd a kiszolgálón tárolt naplófájlok alapján új jelentések készülnek. Ez azt jelenti, ha úgy konfigurálta a rendszert (a Domainek > domain név > Naplókezelő > Napló rotáció menüpontban), hogy csupán az utolsó hónap naplófájljait őrizze meg, akkor csupán az utolsó hónap webstatisztikái fognak rendelkezésre állni. Másik statisztikai csomagra akar váltani?",
    '__webstat_perm_denied' => 'Nincs engedélye a webstatisztikák kezelésére.',
    '__webuser' => "Webes felhasználó",
    '__sysusers_list' => "Rendszerfelhasználók",
    '__sysuser' => "Rendszerfelhasználó",
    '__weekly' => "Heti",
    '__whats_new_in_version' => "Milyen újdonságok találhatóak a Plesk %1 esetében?",
    '__wrong_hosting_type__virtual_required' => "Csak webhely üzemeltetéssel rendelkező domainek esetében áll e művelet rendelkezésre.",
    '__wrong_hosting_type__none' => 'Nincs webhely üzemeltetés konfigurálva %1 domain esetén.',
    '__wrong_hosting_type__std_fwd' => 'Normál továbbítási konfigurálással rendelkezik %1 domain. Csak webhely üzemeltetéssel rendelkező domainek esetében áll e művelet rendelkezésre.',
    '__wrong_hosting_type__frm_fwd' => 'Kerettovábbítási konfigurálással rendelkezik %1 domain. Csak webhely üzemeltetéssel rendelkező domainek esetében áll e művelet rendelkezésre.',
    '__wu' => "Webes felhasználók",
    '__www' => "www",
    '__www_prefix_was_changed' => "A www előtag megváltozott. Gondoskodjon az SSL/TLS-tanúsítvány ennek megfelelően változtatásáról.",
    '__year' => "Év",
    '__year(s)' => "Év",
    '__yes' => "Igen",
    '__you' => "Ön",
    '__zip_code' => "Irányítószám",
    '__form_normal' => "Normál",
    '__form_advanced' => "Speciális",

    'admin_ed__edit_administrator_info' => "Adminisztrátor profil szerkesztése",
    'admin_ed__create_default_client' => "Egy alapértelmezett ügyfélszámlát akarok létrehozni.",
    'admin_ed__unable_update' => "Rendszergazdai adatok frissítése nem lehetséges: %1",

    'auth__update_admin_info' => "Adja meg a rendszergazda információkat. Ezen adatok szükségesek a %1 működéséhez.",
    'auth__you_not_have_perm' => "Nincs megfelelő jogosultsága e domain kezeléséhez.",
    'auth__key_expired_admin' => 'Lejárt a Plesk licence. A Plesk kezelőpanel használatának folytatásához újítsa meg a licencét vagy vásároljon egy újat.',
    'auth__key_expired_admin_restricted' => 'Lejárt a Plesk licence. A Plesk kezelőpanel használatának folytatásához forduljon a szolgáltatójához.',
    'auth__key_expired_client' => 'Lejárt a Plesk licenc. Forduljon a szolgáltatóhoz.',
    'autoinstaller__not_installed' => 'Az automatikus telepítő komponens nincs telepítve.',
    'autoinstaller__release_action' => 'Rendelkezésre álló műveletek',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Egy új magasabb Plesk verzióra frissítés',
    'autoinstaller__release_action_update' => 'Frissítés vagy új komponens hozzáadása',
    'autoinstaller__release_action_up2date' => 'Naprakész verzióval rendelkezik.',
    'autoinstaller__component_action' => 'Állapot',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Nincs telepítve',
    'autoinstaller__component_action_update' => 'Frissítések állnak rendelkezésre.',
    'autoinstaller__component_action_upgrade' => 'Frissítés áll rendelkezésre',
    'autoinstaller__component_action_up2date' => 'Naprakész verzióval rendelkezik.',
    'autoinstaller__component_action_error' => 'Nincsenek frissítések',
    'autoinstaller__component_serverbuildtime' => 'Legújabb kiadás',
    'autoinstaller__component_localbuildtime' => 'A kiadása',
    'autoinstaller__component_installed_version' => 'Verziója',
    'autoinstaller__component_available_version' => 'Legújabb verzió',
    'autoinstaller__component' => 'Komponens',
    'autoinstaller__components' => 'Komponensek',
    'autoinstaller__components_title' => '%1 komponensek',
    'autoinstaller__component_dependency_note' => 'mely a kiválasztott komponensek telepítéséhez szükséges',
    'autoinstaller__install_confirm' => 'Igen, telepíteni akarom e komponenseket',
    'autoinstaller__install_confirm_request' => 'Jelölje be a jelölőnégyzetet a megerősítéshez.',
    'autoinstaller__install_title' => 'A kiválasztott komponensek telepítésének megerősítése',
    'autoinstaller__key_update_confirm' => 'Kulcsfrissítés kihagyásának megerősítése és az alapértelmezett kulcs telepítése',
    'autoinstaller__key_update_confirm_request' => 'Jelölje be a jelölőnégyzetet a megerősítéshez.',
    'autoinstaller__key_update_failed' => '<p>Nem tudja a terméklicencét frissíteni a Plesk.</p><p>%1</p><p>Ha megfelelő terméklicenc nélkül folytatja a magasabb verzióra frissítést, akkor ennek eredményeképpen a korlátozott funkciókkal rendelkező alapértelmezett licenc telepítése történik meg. Az adminisztrátoroknak célszerű a magasabb verzióra frissítés folytatása előtt először is beszerezniük a megfelelő licenckulcsot.</p>',
    'autoinstaller__email' => 'Értesítés küldése a következőnek',
    'autoinstaller__email_admin' => "Adminisztrátor e-maile",
    'autoinstaller__email_email' => 'Ügyfél e-mail címe',
    'autoinstaller__release' => 'Kiadásnév',
    'autoinstaller__releases' => 'Rendelkezésre álló kiadások',
    'autoinstaller__releases_title' => 'Plesk Frissítő funkció',
    'autoinstaller__select_components_to_install' => 'A telepítendő komponensek kiválasztása',
    'autoinstaller__status_error' => 'Hiba: %1',
    'autoinstaller__status_install_error' => 'Nem indítható el a telepítés: %1',
    'autoinstaller__status_install_busy' => 'A telepítés elindítása nem lehetséges: egy másik telepítés van jelenleg folyamatban.',
    'autoinstaller__status_install_ok' => 'Megtörtént a telepítés elindítása. E-mailen (%1) keresztül kap értesítést a telepítés előrehaladásról.',
    'autoinstaller__status_query_busy' => 'A telepítés folyamatban van.',
    'autoinstaller__status_query_error' => 'A telepítés állapotának lekérdezése nem lehetséges: %1',
    'autoinstaller__status_unknown' => 'Nem lehetséges a Plesk Autoinstaller állapotának a lekérdezése.',
    'autoinstaller__status_busy' => 'Foglalt a Plesk Autoinstaller, várjon.',
    'autoinstaller__configure_title' => 'Frissítő beállítások',
    'autoinstaller__preferences_legend' => 'Beállítások',
    'autoinstaller__target' => 'Átmeneti letöltési könyvtár',
    'autoinstaller__target_invalid' => "Adjon meg abszolút elérési útvonalat",
    'autoinstaller__check_updates' => 'Plesk kezelőpanelbe adminisztrátor bejelentkezés után történő frissítéskeres',
    'autoinstaller__check_updates_warning' => 'Új <a href="%1">frissítések</a> érhetőek el a %2 számára',
    'autoinstaller__source_type' => 'Forrástípus',
    'autoinstaller__source' => 'Forrás URL-címe',
    'autoinstaller_source__preferences_legend' => 'Beállítások',
    'autoinstaller_source__type' => 'Forrástípus',
    'autoinstaller_source__url_invalid' => 'Érvénytelen forrás',
    'autoinstaller_source__url_invalid_network' => 'Érvénytelen forrás URL-cím (például: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Forrás URL-címe',
    'autoinstaller__source_invalid_network' => 'Érvénytelen hálózati címet adott meg.',
    'backup__repository' => 'Biztonsági másolat fájl tároló helye',
    'backup__error_notify_email' => 'Ha hiba lép fel a biztonsági mentés során, akkor küldjön értesítést a következő e-mail címre;',
    'backup__dump_info' => "Biztonsági másolat információk",
    'backup__dump_file_name_not_defined' => "Nincs meghatározva a biztonsági másolat fájl neve",
    'backup__local_file' => 'Helyi biztonsági másolat fájl',
    'backup__domain_ftp' => 'távoli FTP-kiszolgáló',
    'backup__wrong_path' => "Helytelen elérési út a biztonsági másolat fájl tárolóhoz: Ne használja a ../../ karaktersort.",
    'backup__unable_to_connect_to_ftp_server' => "Az FTP-kiszolgálóhoz kapcsolódás nem lehetséges: %1",
    'backup__unable_to_read_file' => 'Nem lehet olvasni a biztonsági másolat fájlt.',
    'backup__backup_task_does_not_exist' => "A biztonsági mentési feladat nem létezik, létre kell hoznia az indítás előtt.",
    'backup__restore_params' => "Visszaállítási paraméterek",
    'backup__confirmation' => "Figyelmeztetés: biztonsági mentés/visszaállítás alatt nem áll a domain rendelkezésre.",
    'backup__backup_method' => 'Biztonsági mentési módszer',
    'backup__dumpfile_name' => "Biztonsági másolat fájl neve",
    'backup__dumpfile_name_is_invalid' => "Érvénytelen a biztonsági másolat fájl neve: csupán alfanumerikus karaktereket, kötőjelet, pontot és aláhúzásjelet használjon, de ne használjon olyan neveket, mint leírás.* biztonsági másolat fájlnévként.",
    'backup__email_required' => "Szükséges az e-mail címének a megadása ahhoz, hogy tájékoztatást kapjon a biztonsági mentés és visszaállítás előrehaladásáról. Adja meg az e-mail címét a számlaadatok között.",
    'backup__error_during_backup' => "Biztonsági másolat fájl létrehozása nem lehetséges: %1",
    'backup__input_email_warning' => "Meg kell adnia e-mail címet az értesítéshez vagy törölnie kell a jelölőnégyzet bejelölését.",
    'backup__make_download' => "Ne tárolja a biztonsági másolat fájlt tárolóban, hanem töltse le.",
    'backup__make_dump' => 'Hozzon létre biztonsági másolat fájlt és a helyi tárolóban tárolja.',
    'backup__makedump_to_ftp' => 'biztonsági másolat fájl létrehozása és távoli FTP-kiszolgálón tárolása',
    'backup__restore_ip' => "Visszaállítandó IP-cím",
    'backup__select_dumpfile' => "Egy biztonsági mentési fájl kiválasztása.",
    'backup__time' => "Biztonsági mentés ideje",
    'backup__day' => 'Biztonsági mentés napja',
    'backup__view_dump_info' => "%1 domain biztonsági másolat információinak megtekintése",
    'backup__wrong_domain_name' => "%1 domain adatait tartalmazza a biztonsági másolat fájl ezért nem állítható vissza %2 domainen",
    'backup__incorrect_ftp_user_or_passwd' => "Helytelen az FTP-felhasználónév vagy jelszó. Módosítsa az FTP-fiók tulajdonságokat",
    'backup__access_denied' => "Hozzáférés megtagadva. Módosítsa az FTP-fiók tulajdonságokat",
    'backup__restore_from' => "%1 visszaállítása",
    'backup__domain_session_failed' => '%1 domain nem került mentése nem történt meg',
    'backup__client_session_failed' => '%1 ügyfélszámla nem rendelkezik biztonsági másolattal.',
    'backup__domain_session_restore_failed' => '%1 domain visszaállítása nem történt meg',
    'backup__client_session_restore_failed' => 'Nem történt meg %1 ügyfélszámla visszaállítása.',
    'backup__domain_session_complete' => '%1 domain biztonsági mentése megtörtént',
    'backup__domain_session_backup' => '%1 domain biztonsági mentése',
    'backup__client_session_backup' => '%1 ügyfél biztonsági másolata',
    'backup__domain_stop_title' => '%1 domain biztonsági mentésének megszakítása',
    'backup__client_stop_title' => '%1 ügyfélszámla biztonsági mentésének a megszakítása',
    'backup__domain_restore_stop_title' => '%1 domain visszaállításának megszakítása',
    'backup__client_restore_stop_title' => '%1 ügyfélszámla visszaállításának a megszakítása',
    'backup__domain_session_backup_stop' => 'Éppen folyamatban lévő biztonsági mentés megszakítására készül. Nem kerül biztonsági másolat fájl létrehozásra.',
    'backup__backup_stop_confirm' => 'Igen, le akarom állítani a biztonsági mentési eljárást',
    'backup__restore_stop_confirm' => 'Igen, le akarom állítani a visszaállítási mentési eljárást.',
    'backup__domain_session_restore' => '%1 domain visszaállítása',
    'backup__domain_session_restore_stop' => 'Éppen folyamatban lévő visszaállítás megszakítására készül.',
    'backup__domain_backup_file_info' => 'Domain biztonsági másolat fájl Információ',
    'backup__domain_backup_file_list' => 'Meglévő biztonsági másolat fájlok',
    'backup__domain_backup_progress' => '%1 webhely biztonsági mentésének előrehaladása',
    'backup__domain_restore_progress' => '%1 webhely visszaállításának előrehaladása',
    'backup__domain_backup_progress_elapsed_time' => 'Eltelt idő: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Eltelt idő: %1',
    'backup__domain_restore_session_complete' => '%1 domain vissza van állítva.',
    'backup__domain_restore_session_complete_message' => 'Megtörtént %1 domain visszaállítása.',
    'backup__domain_backup_file_delete' => 'A következő biztonsági másolat fájlok eltávolításra kerülnek:',
    'backup__domain_backup_file_for_remove' => 'Válassza ki az eltávolítandó biztonsági másolat fájlokat',
    'backup__backup_overwrite_file_confirm' => 'Csere megerősítése',
    'backup__backup_overwrite_file_confirm_text' => '"%1" nevű biztonsági másolat fájl már létezik. Felül akarja írni?',
    'backup__backup_confirm_overwrite' => 'Fájl csere megerősítése',
    'backup__backup_overwrite_legeng' => 'Csere',
    'backup__backup_not_contain_domain' => 'A biztonsági másolat fájl nem tartalmaz információt %1 domainről',
    'backup__backup_not_contain_client' => 'Nem tartalmaz %1 ügyfélszámlára vonatkozó adatokat a biztonsági másolat fájl.',
    'backup__backup_client_info' => "Végezze el az ügyfél beállítások és számlaadatok biztonsági mentését.",
    'backup__client_backup_progress' => '%1 ügyfélszámla biztonsági mentésének előrehaladása',
    'backup__client_session_complete' => '%1 ügyfélszámla rendelkezik biztonsági másolattal.',
    'backup__client_backup_file_info' => 'Ügyfélszámla biztonsági másolat fájl adatai',
    'backup__restore_client_info' => "Végezze el az ügyfél beállítások és számlaadatok visszaállítását.",
    'backup__client_session_restore' => '%1 ügyfélszámla visszaállítása',
    'backup__client_db_server_map' => 'Adatbázis-kiszolgáló megfeleltetése',
    'backup__domain_db_server_map' => 'Adatbázis-kiszolgáló megfeleltetése',
    'backup__client_restore_session_complete_message' => 'Megtörtént %1 ügyfélszámla visszaállítása.',
    'backup__client_restore_session_complete' => 'Megtörtént %1 ügyfélszámla visszaállítása.',
    'backup__restore_select_some' => 'Jelölje ki a visszaállítandó objektumokat.',
    'backup__client_restore_progress' => '%1 ügyfélszámla visszaállításának előrehaladása',
    'backup__new_backup' => 'Új biztonsági mentés létrehozása',
    'backup__done' => 'Kész:',
    'backup__done_domains' => '%1 / %2 domain',
    'backup__done_clients' => '%1 / %2 ügyfél',
    'backup__remaining' => 'Fennmaradt:',
    'backup__remaining_domains' => '%1 domain',
    'backup__remaining_clients' => '%1 ügyfél',
    'backup__overall_backup_progress' => 'Teljes biztonsági mentési eljárás',
    'backup__comment_n_a' => 'Hiányzik',
    'backup__command_ignore' => '"%1" parancs figyelmen kívül van hagyva',
    'backup__no_objects' => 'Nincsenek biztonsági mentés számára objektumok',
    'backup__cli_warning_not_enough_ip' => 'FIGYELMEZTETÉS: nincs elegendő IP-cím az alapértelmezett IP-megfeleltetés végrehajtásához:',
    'backup__local_repository' => "Plesk tároló",
    'backup__ftp_repository' => 'FTP-tároló',
    'backup__ftp_login' => 'Felhasználónév',
    'backup__ftp_password' => 'Jelszó',
    'backup__ftp_account_settings' => 'FTP-fiók beállítások',
    'backup__ftp_account_preferences' => 'FTP-fiók beállítások',
    'backup__repository_not_exist' => 'A könyvtár nem létezik.',
    'backup__repository_not_readable' => 'Nem olvasható a megadott könyvtár.',
    'backup__ftp_repository_not_configure' => 'Egy FTP biztonsági másolat tároló használatához, <a href="%1">adja meg az FTP-fiókot</a> először.',
    'backup__ftp_repository_list_not_configure' => 'Nem kerültek megadásra a fiókbeállítások.',
    'backup__repository_list_unable_listing' => 'Nem lehetséges a fájllista beolvasása.',
    'backup__ftp_repository_unable_listing' => 'Nem lehetséges "%1" könyvtár lista beolvasása:',
    'backup__repository_legend' => 'Biztonsági másolat fájl tároló',
    'backup__store_in_repository' => 'Fájlok tárolása a következő helyen;',
    'backup__local_repository_lable' => 'Helyi tároló',
    'backup__ftp_repository_lable' => 'FTP-tároló',
    'backup__ftp_repository_not_configure_hint' => '(nem kerültek megadásra a fiókbeállítások)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-fiók nincs megadva vagy nem támogatott.)',
    'backup__other_user_process_modified' => 'Egy másik felhasználó leállítottt a biztonsági mentési vagy visszaállítási eljárást.',
    'backup__another_user_exist' => 'Egy másik Plesk felhasználó kezdeményezte a folyamatban lévő műveltetet. E felhasználó még be van jelentkezve Plesk kezelőpanelbe.',
    'backup__ftp_repository_wait' => 'Várjon, amíg megtörténik az FTP-tároló adatainak beolvasása.',
    'backup__ftp_write_test_failed' => 'Nem sikerült tesztadatok %1 FTP fiókba írása:',
    'backup__ftp_storage' => 'FTP(S)-tároló',
    'bt_upload_to_repository' => 'Fájlok helyi tárolóra történő feltöltése',
    'bt_new_restore' => "Visszaállítás",
    'bt_backup_schedule' => "Biztonsági mentés ütemezése",
    'backup_exist_backups' => "Meglévő biztonsági másolat fájlok",
    'backup_dialog__page_title' => "Biztonsági másolat fájl létrehozása",
    'backup_dialog__please_wait' => "Hamarosan megkezdődik a biztonsági mentési eljárás. A művelet eltarthat egy kis ideig. Várjon.",
    'backup_conf__page_title' => 'Biztonsági mentés konfigurációja',
    'bt_accept' => "Elfogadás",
    'bt_access' => "Hozzáférés",
    'bt_action_log' => "Tevékenységi napló",
    'bt_add' => "Hozzáadás",
    'bt_add_client' => "Felhasználókhoz rendelés",
    'bt_database_server_add' => 'Adatbázis-kiszolgáló hozzáadása',
    'bt_add_services' => "Szolgáltatások hozzáadása",
    'bt_anonftp_stats' => "Névtelen FTP statisztikák",
    'bt_anonymous_ftp' => "Névtelen FTP",
    'bt_aspdotnet' => "ASP.NET keretrendszer",
    'bt_attach' => "Mellékelés",
    'bt_autoinstaller' => 'Frissítő',
    'bt_auto-updates' => 'Frissítő',
    'bt_back' => "<< Vissza",
    'bt_backup' => "Biztonsági mentés",
    'bt_backup_configure' => "Biztonsági mentési beállítások",
    'bt_buy_certs' => "Vásároljon tanúsítványokat.",
    'bt_card' => "Kártya",
    'bt_cert' => "Tanúsítvány",
    'bt_certificates' => "Tanúsítványok",
    'bt_change_passwd' => "Jelszó megváltoztatása",
    'bt_clear' => "Törlés",
    'bt_client_templates' => "Ügyfélsablonok",
    'bt_clients' => "Ügyfelek",
    'bt_codepage_change' => 'Kódlap váltása',
    'bt_comp_info' => "Összetevő kezelés",
    'bt_configure_maillists' => "Mailman beállítása",
    'bt_configure' => 'Konfigurálás',
    'bt_copy' => "Másolás",
    'bt_copy_move' => "Másolás/áthelyezés",
    'bt_create' => "Létrehozás",
    'bt_create_account' => "Egy számla létrehozása",
    'bt_create_dir' => "Egy könyvtár hozzáadása",
    'bt_create_file' => "Egy fájl hozzáadása",
    'bt_count_size' => "Méretszámítás",
    'bt_crontab_unix' => "Cron táblázat fájl",
    'bt_crontab_win' => "Feladatütemező",
    'bt_custom_button_new' => "Egy gomb hozzáadása",
    'bt_custom_buttons' => "Egyéni gombok",
    'bt_customize' => "Testreszabás",
    'bt_databases' => "Adatbázisok",
    'bt_database_servers' => 'Adatbázis-kiszolgálók',
    'bt_sqlservers' => "Adatbázis-kiszolgálók",
    'bt_db_usr_new' => "Egy adatbázis-felhasználó hozzáadása",
    'bt_db_new' => "Egy adatbázis hozzáadása",
    'bt_db_phpmyadmin' => "MySQL adminisztrátor",
    'bt_dbuser_default' => "DB WebAdmin felügyeleti eszköz esetén alapértelmezetté tétel",
    'bt_decline' => "Visszautasítás",
    'bt_default' => "Alapértelmezett",
    'bt_defaultcomponents' => "Harmadik fél szolgáltatásai",
    'bt_defaults' => "Alapértelmezett értékek",
    'bt_delete' => "Törlés",
    'bt_directories' => "Védett könyvtárak",
    'bt_disable' => "Kikapcsolás",
    'bt_dns_zone_sync' => 'DNS-sablon változtatásainak alkalmazása',
    'bt_dnsrecord_add' => 'Rekord hozzáadása',
    'bt_do_backup' => "Biztonsági mentés",
    'bt_do_restore' => "Visszaállítás",
    'bt_do_upload' => "Feltöltés",
    'bt_domain_aliases' => "Domain aliasok",
    'bt_domain_templates' => "Domainsablonok",
    'bt_domain_user' => "Domain adminisztrátor",
    'bt_domain_user_passwd' => "Domain adminisztrátor jelszó",
    'bt_domains' => "Domainek",
    'bt_domain_alias_add' => 'Domain aliasok hozzáadása',
    'bt_download' => "Letöltés",
    'bt_edit' => "Szerkesztés",
    'bt_enable' => "Bekapcsolás",
    'bt_export' => 'Exportálás',
    'bt_extras' => "Extrák",
    'bt_finish' => "Befejezés",
    'bt_ftp_account' => "FTP-fiók tulajdonságok",
    'bt_forget_password' => "Elfelejtette a jelszavát?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS webhelygazda",
    'bt_fp_webadmin' => "FP webhelygazda",
    'bt_ftp_stats' => "FTP-statisztikák",
    'bt_get_password' => "Jelszó lekérdezése",
    'bt_global_changes' => "Módosítás",
    'bt_help' => "Súgó",
    'bt_hide_aliases' => "Aliasok elrejtése",
    'bt_hide_toolbar' => 'Eszköztár elrejtése',
    'bt_hide_subdomains' => "Aldomainek elrejtése",
    'bt_hide_domainaliases' => "Domain aliasok elrejtése",
    'bt_home' => "Kezdőlap",
    'bt_hosting' => "Üzemeltetés",
    'bt_icf' => 'Tűzfal',
    'bt_install' => "Telepítés",
    'bt_ip_aliasing' => "IP-címek",
    'bt_ip_add' => "IP-cím hozzáadása",
    'bt_ip_pool' => "IP-készlet",
    'bt_key_info' => "Licencinformációk",
    'bt_key_buyonline_addons' => 'Rendeljen Plesk bővítőket.',
    'bt_key_buyonline_upgrades' => 'Rendeljen Plesk magasabb verzióra frissítéseket.',
    'bt_key_buyonline_new' => 'Új kulcs rendelése',
    'bt_limits' => "Korlátok",
    'bt_locale_add' => 'Területi beállítások hozzáadása',
    'bt_locales' => 'Területi beállítások',
    'bt_log_manager' => "Naplókezelő",
    'bt_login' => "Bejelentkezés",
    'bt_logo' => "Védjegyezés",
    'bt_logo_send_link' => "Hivatkozás mellékelése",
    'bt_logo_send_logo' => "Logó mellékelése",
    'bt_logout' => "Kijelentkezés",
    'bt_logrotation' => "Rotation des logs",
    'bt_mail' => "E-mail",
    'bt_mail_alias_add' => "Levelezési lista Alias",
    'bt_mail_aliases' => "E-mail aliasok",
    'bt_mail_group_add' => "Tag hozzáadása",
    'bt_mail_groups' => "Csoportok",
    'bt_mail_name_add' => "Postafiók hozzáadása",
    'bt_mail_preferences' => "Beállítások",
    'bt_mail_group' => "Levelezési csoport",
    'bt_mail_mailbox' => "Postaláda",
    'bt_mail_redirect' => "Továbbító",
    'bt_mail_resp_add' => "Automatikus válasz hozzáadása",
    'bt_mail_resp_attach_add' => "Melléklet hozzáadása",
    'bt_mail_resp_files' => "Melléklet fájlok",
    'bt_mail_responders' => "Automatikus válaszok",
    'bt_mail_spamfilter' => "Levélszemét szűrő",
    'bt_mail_webmail' => "Webes levelezés",
    'bt_maillist_new' => "Levelezési lista hozzáadása",
    'bt_maillists' => "Levelezési listák",
    'bt_mailman' => "Levelezőlista",
    'bt_make_dump' => "Biztonsági másolat fájl létrehozása",
    'bt_manage' => "Kezelés",
    'bt_master' => "Fölérendelt",
    'bt_migrate' => 'Áttelepítés',
    'bt_modules_add' => 'Bővítmény hozzáadása',
    'bt_modules_manage' => 'Bővítmények kezelése',
    'bt_move' => "Áthelyezés",
    'bt_new_client' => "Ügyfélszámla hozzáadás",
    'bt_new_domain' => "Domain hozzáadása",
    'bt_next' => "Tovább ť",
    'bt_next_page' => "Tovább",
    'bt_network_add' => "Hálózat hozzáadása",
    'bt_notifications' => "Értesítések",
    'bt_off' => "Ki",
    'bt_on' => "Be",
    'bt_on_off' => "Be/Ki",
    'bt_performance' => 'Teljesítmény',
    'bt_permissions' => "Engedélyek",
    'bt_phpmyadmin' => "PhpMyAdmin szoftvereszköz",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Beállítások",
    'bt_prev_page' => "Előző",
    'bt_preview' => 'Hely előnézete',
    'bt_print' => "Nyomtatás",
    'bt_reboot' => "Újraindítás",
    'bt_reload' => "Újrabetöltés",
    'bt_refresh' => "Frissítés",
    'bt_register' => "Regisztrálás",
    'bt_remove' => "Eltávolítás",
    'bt_enable_selected' => 'Bekapcsolás',
    'bt_disable_selected' => 'Kikapcsolás',
    'bt_repair_ip' => "IP-cím javítása",
    'bt_report' => "Jelentés",
    'bt_report_new' => "Elrendezés hozzáadása",
    'bt_reset' => "Alaphelyzetbe állítás",
    'bt_restart_services' => "Szolgáltatások kezelése",
    'bt_save' => "Mentés",
    'bt_send_by_email' => "E-mailben küldés",
    'bt_send_file' => "Fájl küldése",
    'bt_send_mail' => "E-mail küldése",
    'bt_send_passwd' => "Jelszó küldése",
    'bt_send_text' => "Szöveg küldése",
    'bt_server' => "Kiszolgáló",
    'bt_server_add' => "Kiszolgáló hozzáadása",
    'bt_server_preferences' => "Kiszolgáló beállítások",
    'bt_servers_list' => "Kiszolgálók",
    'bt_sessions' => "Munkamenetek",
    'bt_set' => "Beállít",
    'bt_set_as_default' => "Alapértelmezettként beállítás",
    'bt_setup' => 'Beállítás',
    'bt_show_aliases' => "Aliasok megjelenítése",
    'bt_show_subdomains' => "Aldomainek megjelenítése",
    'bt_show_domainaliases' => "Domain aliasok megjelenítése",
    'bt_shutdown' => "Leállítás",
    'bt_site_apppkgs' => "Alkalmazástároló",
    'bt_site_apppool' => "Alkalmazáskészlet",
    'bt_application-pool' => "Webalkalmazások",
    'bt_site_apps' => "Webalkalmazások",
    'bt_site_app_add' => "Alkalmazás telepítése",
    'bt_site_builder' => "Presence Builder weboldalkészítő támogatása",
    'bt_skeleton' => 'Virtuális állomás sablon',
    'bt_skins' => 'Felszínek',
    'bt_skin_add' => 'Felszín hozzáadása',
    'bt_skin_manual' => 'Egyéni Plesk felszínek hivatkozás', // not used
    'bt_skin_download' => 'Felszín letöltése',
    'bt_skin_replace' => 'Felszínek frissítése',
    'bt_skip' => 'Kihagyás',
    'bt_spamassassin' => "Levélszemét szűrő",
    'bt_spamassassin_train' => "Betanítás",
    'bt_spamfilter' => "Levélszemét szűrő",
    'bt_start' => "Indítás",
    'bt_stop' => "Leállítás",
    'bt_recycle' => "Újrahasznosítás",
    'bt_statistics' => "Statisztikák",
    'bt_subdomain_new' => "Aldomain hozzáadása",
    'bt_subdomains' => "Aldomainek",
    'bt_submit' => "Küldés",
    'bt_summary_report' => "Összesítő jelentés",
    'bt_support' => "Támogatás",
    'bt_switch' => "Átkapcsolás",
    'bt_system_time' => "Rendszeridő",
    'bt_task_new' => "Feladat hozzáadása",
    'bt_dom_tmpl_add' => 'Domainsablon hozzáadása',
    'bt_cl_tmpl_add' => 'Ügyfélsablon hozzáadása',
    'bt_cron_backup' => 'Ütemezett biztonsági mentési beállítások',
    'bt_test' => "Kapcsolódási teszt",
    'bt_text' => "Szöveg",
    'bt_touch' => "Időbélyegző változtatása",
    'bt_traffic' => "Forgalom",
    'bt_traffic_history' => "Forgalmi kimutatás",
    'bt_update' => "Frissítés",
    'bt_upload' => "Feltöltés",
    'bt_upload_from_ftp' => "FTP feltöltés",
    'bt_virtualdirs' => 'Virtuális könyvtárak',
    'bt_virtualdir_new' => 'Virtuális könyvtár hozzáadása',
    'bt_virtualdir_add' => 'Virtuális könyvtár hozzáadása',
    'bt_web_app_new' => "Java alkalmazás telepítése",
    'bt_web_stats' => "Webstatisztikák",
    'bt_web_stats_ssl' => "SSL/TLS webstatisztikák",
    'bt_web_user_add' => "Webes felhasználó hozzáadása",
    'bt_web_users' => "Webes felhasználók",
    'bt_webadmin' => "Webhely adminisztrátor",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "A változások teljes listájának megtekintése",
    'cert_add__unable_set_ca_cert' => "Hitelesítésszolgáltatói tanúsítvány beállítása nem lehetséges: %1",
    'cert_add__unable_set_cert' => "A tanúsítvány beállítása nem lehetséges: %1",
    'cert_add__unable_set_private_key' => "A titkos kulcs beállítása nem lehetséges: %1",
    'certificates_list__certificate_used_as_default' => "Az alapértelmezett tanúsítványként használják az egyik tanúsítványt, melyet törölni készül.",
    'certificates_list__certificates_assigned_on_ip' => "Megtörtént egy vagy több tanúsítvány IP-címekhez/domainekhez rendelése.",
    'ch_pass__admin_pass' => "Adminisztrátor jelszavának változtatása",
    'ch_pass__old_pass' => "Régi jelszó",
    'ch_pass__pass_confirm' => "Megerősítés",
    'ch_pass__unable_change_admin_pass' => "A rendszergazdai jelszó megváltoztatása nem lehetséges: %1",
    'check_mail_cycle__aliases' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" cím szerepel e postafiók aliasai között.",
    'check_mail_cycle__autoresponders' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" cím szerepel e postafiók automatikus válaszai között.",
    'check_mail_cycle__mail_groups' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" cím szerepel e postafiók levelezőcsoportjai között.",
    'check_mail_cycle__mail_name' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" cím megegyezik e postafiókkal.",
    'check_mail_cycle__redirect' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" cím megegyezik e postafiók továbbítójával.",
    'check_mail_dup__redirect' => "Dupla továbbítás észlelése fordult elő, \"%1\" cím megegyezik e postafiók továbbítási címével.",
    'check_mail_dup__mail_groups' => "Dupla továbbítás észlelése fordult elő, \"%1\" cím szerepel e postafiók levelezőcsoportjában.",
    'check_maillist_cycle__admin' => "Ciklikus levélküldés észlelése fordult elő, az adminisztrátor \"%1\" email-címe megegyezik egy levelezési ista címével.",
    'check_maillist_cycle__member' => "Ciklikus levélküldés észlelése fordult elő, \"%1\" email-cím megegyezik a levelezési ista címével.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1 ügyfél adatai",
    'cl_limits__cl' => "%1 ügyfél korlátjai",
    'cl_logo__setup_logo_pref' => "Végezze el %1 ügyfél logó tulajdonságainak a beállítását.",
    'cl_new__enter_new_cl_data' => "Írja be az új ügyfél adatait.",
    'cl_new__unable_to_sent_notification' => 'Megtörtént a felhasználói számla létrehozása, de nem sikerült az ügyfél számára az értesítés elküldése: %1',
    'cl_perm__all_ip' => "Az összes rendelkezésre álló IP-cím",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Az ügyfelek IP-alapú üzemeltetési számlái Névalapúakká lesznek átalakítva.",
    'cl_perm__allow_client_create_domain' => "Kizárólag domainek létrehozására jogosító engedéllyel rendelkező ügyfelek használhatják a kiválasztani próbált mezőt.",
    'cl_perm__allow_create_nb_w_ip' => "%1 használatával Névalapú üzemeltetést hozhat létre az ügyfél.",
    'cl_perm__allow_creation_ip_based_hosting' => "IP-alapú üzemeltetési fiókok létrehozásának engedélyezése",
    'cl_perm__available_ips' => "Rendelkezésre álló IP-címek",
    'cl_perm__change_limits' => "Korlátok beállítása",
    'cl_perm__cl_disk_space' => "Az összes rendelkezésre álló lemezterület",
    'cl_perm__cl_expiration' => "Ügyfélszámla érvényességi időszaka",
    'cl_perm__cl_max_box' => "Postaládák",
    'cl_perm__cl_max_db' => "Adatbázisok",
    'cl_perm__cl_max_dom' => "Domainek",
    'cl_perm__cl_max_maillists' => "Levelezési listák",
    'cl_perm__cl_max_subdom' => "Aldomainek",
    'cl_perm__cl_max_traffic' => "A teljes rendelkezésre álló hálózati forgalom",
    'cl_perm__cl_max_wu' => "Webes felhasználók",
    'cl_perm__cl_mbox_quota' => "E felhasználói számla postaláda méret korlátja.",
    'cl_perm__current_maximum_exp_date' => "%1 a domain érvényességi időszakának jelenlegi maximális értéke, míg %2 a kérelmezett.",
    'cl_perm__current_maximum_mailbox_quota' => "%1 e felhasználói fiók egység postaládája jelenleg érvényes lemezterület korlátja, míg %2 az igényelt terület",
    'cl_perm__current_total_requested' => "%1 számára %2 a domain korlátok jelenlegi összértéke, míg %3 a kérelmezett.",
    'cl_perm__current_total_requested_dom' => "%1 jelenlegi száma, %2 ezen ügyfélhez tartozó, míg %3 a kérelmezett.",
    'cl_perm__disk_space' => "lemezterület maximális értéke",
    'cl_perm__dashboard_stdgui' => 'Felhasználói kezelőfelület',
    'cl_perm__dashboard' => 'Honlap nézet',
    'cl_perm__stdgui' => 'Szokásos nézet',
    'cl_perm__manage_dashboard' => 'Honlap kezelés',
    'cl_perm__dashboard_and_stdgui' => 'A Honlap és a Szokásos nézett használata engedélyezett.',
    'cl_perm__dashboard_only' => 'Kizárólag a Honlap nézet használata engedélyezett.',
    'cl_perm__stdgui_only' => 'Kizárólag a Szokásos nézet használat engedélyezett.',
    'cl_perm__edit_cl' => "%1 ügyfél engedélyei",
    'cl_perm__exp_date_exceeded' => "A beállítani próbált érvényességi időszak meghaladja ezen ügyféllel kapcsolatos egyedi domaineken belül megadott korlátot.",
    'cl_perm__invalid_value' => "Érvénytelen érték, csak számjegyek engedélyezettek.",
    'cl_perm__limit_disk_space' => "%1 A teljes lemezterület korlátja",
    'cl_perm__limit_expiration' => "%1 az ügyfélszámla érvényességi időszakának korlátja.",
    'cl_perm__limit_max_box' => "%1 A postaládaok maximális számának korlátja",
    'cl_perm__limit_max_db' => "%1 Az adatbázisok maximális számának korlátja",
    'cl_perm__limit_max_dom' => "%1 A domainek maximális számának korlátja",
    'cl_perm__limit_max_maillists' => "%1 A levelezési listák maximális számának korlátja",
    'cl_perm__limit_max_subdom' => "%1 Az aldomainek maximális számának korlátja",
    'cl_perm__limit_max_traffic' => "%1 A teljes hálózati forgalom korlátja",
    'cl_perm__limit_max_wu' => "%1 A webes felhasználók maximális számának korlátja",
    'cl_perm__limit_mbox_quota' => "%1 A postaláda kvóta beállítása",
    'cl_perm__limits_exceeded' => "Egy vagy több beállítani próbált korlát meghaladja ezen ügyfélhez tartozó egyedi domaineken belül meghatározott korlátokat.
Az ügyfél összesített korlátjának magasabbnak vagy egyenlőnek kell lennie ezen ügyfélszámla domainkorlátjai összegénél.",
    'cl_perm__mailbox_quota_exceeded' => "A postaládák számára kiosztandó lemezterüket korlát, melyet beállítani próbál meghaladja ezen ügyfélszámlákhoz tartozó egyedi domaineken belül meghatározott korlátot.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "A postaládák számára kiosztandó lemezterüket korlát, melyet beállítani próbál meghaladja a kiszolgáló szinten meghatározott korlátot.",
    'cl_perm__make_dumps' => "Biztonsági mentési és visszaállítási adatok",

    'cl_perm__max_box' => "postaládák maximális száma",
    'cl_perm__max_db' => "adatbázisok maximális száma",
    'cl_perm__max_dom' => "domainek",
    'cl_perm__max_maillists' => "levelezési listák maximális száma",
    'cl_perm__max_subdom' => "aldomainek",
    'cl_perm__max_traffic' => "a hálózati forgalom maximuma",
    'cl_perm__max_wu' => "webes felhasználók maximális száma",
    'cl_perm__max_dom_aliases' => "domain aliasok",
    'cl_perm__mbox_quota' => "postaláda kvóta",
    'cl_perm__not_allow_create_nb_hst' => "Névalapú üzemeltetést nem hozhat létre ügyfél.",
    'cl_perm__this_ip_used_vrt_hst' => "Ezen IP-címet használja a virtuális üzemeltetés.\nEzen IP-cím törléséhez távolítsa el az üzemeltetési szolgáltatást vagy változtassa Névalapúra a típust.",
    'cl_perm__unable_off_ipb_creating' => "Az ügyél már beállított IP-alapú üzemeltetési szolgáltatást. E funkció inaktiválására az ügyfél esetében törölje a \"Domain létrehozás\" jelölőnégyzet bejelölését vagy távolítsa el az IP-alapú számlákat.",
    'cl_perm__unable_off_nb_creating' => "Az ügyél már beállított Névalapú üzemeltetési szolgáltatást. E funkció inaktiválására az ügyfél esetében törölje a \"Domain létrehozás\" jelölőnégyzet bejelölését vagy távolítsa el a Névalapú számlákat.",
    'cl_perm__unable_set_domain_limit' => "Nem lehetséges a domainek maximális számának a korlátozása: %1 domainnel már rendelkezik az ügyfél.",
    'cl_perm__unable_update_client_limitations' => "Nem lehetséges az ügyfélszámla korlátok módosítása: %1",
    'cl_pref__edit_cl' => "%1 ügyfél beállításai",
    'class_anonftp__create_ftp_domain' => "Ezen dom_id azonosítóval még nem létezik virtuális FTP-domain, először próbálja meg létrehozni.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "A beállítani próbált lemezterület (%1) nem haladhatja meg a domain szinten (%2) meghatározott teljes lemezterület korlátot.",
    'class_anonftp__invalid_input_only_digits' => "Érvénytelen érték került megadásara, csak számjegyek engedélyezettek.",
    'class_anonftp__unable_change_ownerships' => "A kvótafájl tulajdonosának illetve a fájlra vonatkozó engedélyei megváltoztatása nem lehetséges: %1",
    'class_anonftp__unable_copy_quota_file' => "A kvótafájl másolása nem lehetséges: %1",
    'class_anonftp__unable_get_disk_usage' => "A bejövő könyvtárra vonatkozó lemezhasználati információk lekeresése nem lehetséges: %1",
    'class_anonftp__unable_parse_quota_file' => "A kvótafájl elemzése nem lehetséges.",
    'class_anonftp__unable_read_quota_file' => "A kvótafájl olvasása nem lehetséges: %1",
    'class_anonftp__unable_update_quota' => "Nem lehetséges a kvóta frissítése: %1 kB lemezterületet használnak a bejövő könyvtár fájljai, mely meghaladja az új kvótaértéket.",
    'class_anonftp__unable_write_temp_file' => "Az ideiglenes fájl írása nem lehetséges: %1",
    'class_bsdomain__warn_max_date__' => "%1 lejárati dátum került beállításra.",
    'class_client__client_creation_notification' => "Ügyfél létrehozási értesítés.",
    'class_client__client_with_contact_name_already_exists' => "%1 nevű ügyfél már létezik.",
    'class_client__disk_space' => "Lemezterület",
    'class_client__invalid_max_dom' => "A domainek számára megadott érték érvénytelen, csak számjegyek megengedettek.",
    'class_client__limit_exceed' => "Nem osztható ki a kért %1 mennyiség, mivel az meghalad %2 ügyfél számlája (%3) esetében kiosztott mennyiséget. Ha több erőforrást akar hozzárendelni, akkor ugorjon az Ügyfelek > ügyfélnév > Korlátok menüpontra és szükség szerint változtassa meg azokat. Majd térjen vissza e képernyőre és próbálja ismét elvégezni a kiosztásokat.",
    'class_client__limit_exceed_unlimited' => "Ha korlátlan erőforrás (%1) akar kiosztani, akkor először ugorjon az Ügyfelek > ügyfélnév > Korlátok menüpontra, majd jelölje be a szükséges erőforrás típus hoz tartozó Korlátlan elnevezésű jelölőnégyzetet. Majd térjen vissza e képernyőre és próbálja ismét elvégezni a kiosztásokat.",
    'class_client__max_box' => "Postaládák",
    'class_client__max_db' => "Adatbázisok",
    'class_client__max_maillists' => "Levelezési listák",
    'class_client__max_subdom' => "Aldomainek",
    'class_client__max_traffic' => "Maximális forgalom",
    'class_client__max_wu' => "Webes felhasználók",
    'class_client__max_dom_aliases' => "Domain aliasok",
    'class_client__mbox_quota' => "Postaláda kvóta",
    'class_client__unable_define_cl_status' => "Nem lehetséges az ügyfélszámla állapotának a meghatározása: %1",
    'class_client__unable_define_inactive_dom' => "Nem lehetséges %1 inaktív domainek meghatározása.",
    'class_client__unable_del_ip' => "Az IP-címek eltávolítása nem lehetséges: %1",
    'class_db__db_name_not_set' => "Nincs megadva az adatbázisnév.",
    'class_db__db_not_exist_for_curr_dom' => "Nem létezik adatbázis e domain számára.",
    'class_db__invalid_db_or_dom_name' => "Érvénytelen a domain- vagy adatbázis azonosító, illetve nincs meghatározva az adatbázis neve.",
    'class_db__invalid_pass' => "A jelszó érvénytelen.",
    'class_db__mailgrp_member_exist' => "A levelezési csoportnak tagja már létezik.",
    'class_db__access_hosts_notsupport' => 'Az állomás beállításhoz férés nem támogatottak ezen adatbázis típus esetén',
    'class_db__unable_add' => 'Nem lehetséges hozzáférési állomásrekord hozzáadása: %1',
    'class_db__unable_del' => 'Nem lehetséges a hozzáférési állomásrekord törlése: %1',
    'class_db__inc_user_not_exist' => 'A "%1" adatbázis-felhasználó nem létezik',
    'class_db__inc_access_record_exist' => 'E hozzáférési rekord már létezik',
    'class_db__inc_access_record_not_exist' => 'A megadott hozzáférési rekord nem létezik',
    'class_db__inc_unable_del_last_record' => 'Nem lehetséges a legutóbbi hozzáférési állomásrekord törlése',
    'class_domtmpleditform__dns_master' => "Elsődleges",
    'class_domtmpleditform__dns_slave' => "Másodlagos",
    'class_domtmpleditform__dns_type' => "A domain DNS-zóna típusa",
    'cmd_dns__a_dns_record_already_exist' => "E rekord ütközik a zóna A rekordjával.",
    'cmd_dns__domain_last_ns' => 'Nem törölhető a domain utolsó névkiszolgáló DNS-rekordja.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Érvénytelen a kanonikus domain név.",
    'cmd_dns__cname_dns_record_already_exist' => "E rekord ütközik a zóna CNAME rekordjával.",
    'cmd_dns__cname_in_rr_combination' => 'Helytelen DNS-rekord kombináció található a DNS-zónában.',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS-zóna rekord nem szerepelhet más DNS-rekordokkal együtt egy zónán belül.',
    'cmd_dns__dns_record_type_is_invalid' => "Érvénytelen a DNS-rekord típusa.",
    'cmd_dns__ext_host_is_not_resolved' => "%1 kanonikus név nincs feloldva A vagy AAAA rekord esetén.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Nem lehetséges %1 rekord %2 zónához adása: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Érvénytelen a cserélőnév.",
    'cmd_dns__mx_priority_is_invalid' => "Az MX prioritás érvénytelen.",
    'cmd_dns__name_server_is_invalid' => "A névkiszolgáló érvénytelen.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "24, 16 vagy 8 kell, hogy a hálózati maszk értéke legyen.",
    'cmd_dns__this_dns_record_already_exists' => "Ilyen DNS-rekord már létezik.",
    'cmd_dns__unable_add_record' => "'%1' hozzáadása nem lehetséges: %2",
    'cmd_dns__unable_add_a_record' => "A típusú rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_add_cname_record' => "CNAME típusú rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_add_dns_record' => "DNS-rekord hozzáadása nem lehetséges: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "EXT-NS típusú rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_add_ns_record' => "NS típusú rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_add_ptr_record' => "PTR típusú rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_add_txt_record' => "TXT-rekord hozzáadása nem lehetséges: %1",
    'cmd_dns__unable_create_dns_zone' => "%1 DNS-zóna létrehozása nem lehetséges",
    'cmd_dns__unable_define_dns_record' => "%1 DNS-rekord meghatározása nem lehetséges.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Alapértelmezett DNS-zóna állapot lekérése nem lehetséges: %1",
    'cmd_dns__unable_insert_a_record' => "A típusú rekord beszúrása nem lehetséges: %1",
    'cmd_dns__unable_insert_mx_record' => "MX típusú rekord beszúrása nem lehetséges: %1",
    'cmd_dns__unable_insert_ns_record' => "NS típusú rekord beszúrása nem lehetséges: %1",
    'cmd_dns__unable_set_dns_zone_status' => "A DNS-zóna állapotának beállítása nem lehetséges: %1",
    'cmd_domains__dom_already_exists' => "%1 domain már létezik.",
    'cmd_domains__dns_record_already_exists' => "Nem lehetséges %1 domain létrehozása, mivel már létezik egy %1 állomásra mutató DNS-rekord.",
    'cmd_domains__dom_already_exists1' => "E domainben %2 aldomain van. %1 domain már létezik.",
    'cmd_domains__dom_already_exists2' => "%1 aldomain már létezik.",
    'cmd_domains__dalias_already_exists' => "Ezen alias már létezik.",
    'cmd_domains__domain_alias_already_exists' => 'Ilyen nevű domain alias már létezik.',
    'cmd_domains__unable_del_mail_for_dom' => "Domain esetén e-mail szolgáltatások törlése nem lehetséges: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Domain esetén névtelen FTP-fiókjának törlése nem lehetséges: %1",
    'cmd_domains__unable_update_dom_param' => "A domain paramétereinek frissítése nem lehetséges: %1.",
    'cmd_domains__unable_rename_client_exist' => "Már használatban van a domain adminisztrátor felhasználóneve.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Nem fizikai az üzemeltetés típusa.",
    'cmd_hosting__unable_create_user' => "%2 felhasználó létrehozása nem lehetséges: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Név-alapú virtuális állomások esetén az IP-cím meghatározása a nem lehetséges: %1",
    'cmd_hosting__unable_del_old_hst' => "A korábban beállított üzemeltetés törlése nem lehetséges: %1",
    'cmd_hosting__unable_del_protected_directory' => "Nem lehetséges védett könyvtár törlése: %1.",
    'cmd_hosting__unable_del_web_user' => "Webes felhasználó törlése nem lehetséges: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "A virtuális állomás létrehozása vagy frissítése nem lehetséges: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "A kerettovábbítás üzemeltetés beállítása nem lehetséges.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Nem lehetséges a proftpd konfigurációs fájl újrakészítése: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Nem lehetséges az SSL/TLS-szolgáltatás beállítása: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Nem lehetséges az SSL/TLS-könyvtárról a védelem eltávolítása: %1",
    'cmd_hosting__unable_update_dest_url' => "Nem lehetséges %1 cél URL-cím frissítése.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "A domain esetén a DNS-zóna frissítése a domainre vonatkozóan nem lehetséges: segédprogram végrehajtása nem sikerült.",
    'cmd_hosting__unable_update_ftp_passwd' => "Nem lehetséges %1 FTP-jelszó frissítése.",
    'cmd_hosting__unable_update_user' => "%2 felhasználó frissítése nem lehetséges: %1",
    'cmd_hosting__unknown_hst_type' => "Ismeretlen üzemeltetési típus.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Nincs megfelelő engedélye a üzemeltetési szolgáltatás leállításához.",
    'cmd_mail__autoresponder__not_configured' => "Már konfigurálva van az automatikus válasz e postafiók esetében.",
    'cmd_mail__addr_already_used_in_mail_redirect' => "%1 cím már használatban van e-mail továbbítás céljára.",
    'cmd_mail__alias_already_exists' => "az alias már létezik.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Nem egyezik az Automatikus válasz és a postafiók azonosító.",
    'cmd_mail__autoresp_id_is_undefined' => "Nincs Automatikus válasz azonosító meghatározva.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "%1 postafiók esetében már létezik ilyen nevű e-mail alias.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "%1 postafiók már előfizetett e levelezési listára.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "%1 postafiók már létezik a domainben.",
    'cmd_mail__mail_name_not_exist' => "Nem létezik a postafiók.",
    'cmd_mail__mail_name_passwd_part' => "Nem tartalmazhat postafiók név részt a jelszó.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "%1 levelezési lista már létezik e domainben.",
    'cmd_mail__mailname_already_exist_in_mg' => "%1 postafiók már szerepel a levelezőcsoportban.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "%1 postafiók már létezik a domainben.",
    'cmd_mail__mailname_already_exists' => "A postafiók már létezik.",
    'cmd_mail__mailname_is_invalid' => "Érvénytelen ezen %1 postafiók név.",
    'cmd_mail__mailname_unable_update' => "Nem lehetséges a postafiók tulajdonságok frissítése:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "E domain esetében megtörtént az automatikus válaszok maximális számának elérése.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "E domain esetében megtörtént a levelezőcsoportok maximális számának elérése.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "E domain esetében megtörtént a továbbítók maximális számának elérése.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Megtörtént a postaládák maximális számának az elérése.",
    'cmd_mail__no_members_specified' => "nincsenek tagokat megadva.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Túl egyszerű a jelszó válasszon egy másikat.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Már létezik ezen e-mail cím.",
    'cmd_mail__unable_define_autoresp_id' => "Nem lehetséges %1 automatikus válasz azonosító meghatározása.",
    'cmd_mail__unable_update_mail_for_dom' => "Nem sikerült a levelezési szolgáltatás beállításainak megváltoztatása %1 domain esetében.",
    'cmd_mail__unable_del_mail_for_dom' => "Nem lehetséges a levelezési szolgáltatás eltávolítása %1 domainről.",
    'cmd_mail__unable_del_mail_redirection' => "Nem lehetséges az e-mail továbbítási szolgáltatás eltávolítása %1 domainről.",
    'cmd_mail__unable_remove_autoresp' => "Nem lehetséges automatikus válaszok eltávolítása: %1",
    'cmd_mail__unable_remove_mail_group_members' => "A levelezéscsoport-tagok eltávolítása nem lehetséges: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Nem sikerült a levelezőcsoport kikapcsolása: %1",
    'cmd_mail__unable_update_mail_redirect' => "Nem lehetséges az e-mail továbbítási szolgáltatás újrakonfigurálása %1 domain esetében.",
    'cmd_mail__uploaded_file_is_too_big' => "Túl nagy a feltöltött fájl.",
    'cmd_mail__additionally' => "Ezenfelül:",
    'cmd_pd__invalid_login' => "Helytelen a felhasználónév.",
    'cmd_pd__this_user_already_exist' => "Ilyen felhasználó már létezik",
    'cmd_pd__unable_define_hst_type' => "Üzemeltetési típus meghatározása nem lehetséges.",
    'cmd_pd__unable_upd_pd_usr' => "Nem lehetséges védett könyvtár felhasználó tulajdonságainak megváltoztatása: %1.",
    'cmd_pd__user_is_undefined' => "Felhasználó által meghatározott.",
    'cmd_server__no_enough_free_disk_space' => "Nincs elegendő lemezterület.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "Helytelen a régi jelszó. Próbálja meg újból.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "E domain esetén a webes felhasználók száma elérte a felső korlátot.",
    'cmd_web_usr__unable_create_user' => "Rendszer felhasználó létrehozása nem lehetséges: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Webes felhasználók számára vonatkozó felső korlát meghatározása nem lehetséges: %1",
    'cmd_web_usr__user_already_exists' => "A felhasználó már létezik.",
    'cmd_web_usr__web_user_name_is_invalid' => "%1 webes felhasználónév érvénytelen.",
    'cmd_web_usr__web_user_not_exist' => "A web felhasználó nem létezik.",
    'common_func__exec_bad_argument' => "Az exec argumentum nem tartalmazhat szimpla idézőjelet.",
    '__eol' => 'Sortörések',
    'eol__binary_file' => 'Nem lehetséges a sor tördelés megváltoztatása bináris fájlban.',
    'cp_access_admin_deny' => "'%1' címről tiltott a rendszergazda hozzáférés a jelenleg alkalmazott IP-hozzáférési házirendnek megfelelően.",
    'create_domain_warn__' => "A következő kivételek történtek a domain létrehozása során:",
    'create_domain__client_select' => 'Válassza ki az ügyfelet, mely számára domaint akar létrehozni.',

    'dashboard__nav_button_name' => "Kezdőlap",
    'dalias__list_title' => '%1 domain aliasai',
    'dalias__list_legend' => 'Domain aliasok',
    'dalias__list_header' => 'Domain aliasok',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Domain alias név',
    'dalias__list_ascii_name' => 'ASCII formátumban',
    'dalias__remove_title' => 'A %1 domain következő aliasai kerülnek eltávolításra:',
    'dalias__select_domain_aliases_to_remove' => 'Válssza ki az eltávolítandó domain aliasokat.',
    'dalias__mail_turn_on_failed' => 'Nem lehetséges a levelező levelezési szolgáltatás bekapcsolása: %1',
    'dalias__web_turn_on_failed' => 'Nem lehetséges a webszolgáltatás bekapcsolása: %1',
    'db_usr_edit__db_usr_name_old' => "Régi adatbázis felhasználóneve",
    'database_server_edit_form__cannot_infer_type' => 'A megadott adatokból nem következtethető ki kapcsolódási módszer. "127.0.0.1" adatbázis kiszolgáló állomásnevet adjon meg TCP/IP használatával a megadott porthoz való kapcsolódáshoz, vagy hagyja üresen a port mezőt "%1" Unix szoftvercsatorna használatához.',
    'database_server_edit_form__duplicate' => 'Ezen állomáscímmel és portszámmal rendelkező adatbázis-kiszolgáló már regisztrálva van.',
    'database_server_edit_form__host_is_invalid' => 'Érvénytelen a megadott állomásnév.',
    'database_server_edit_form__port_is_invalid' => 'Érvénytelen a megadott portszám.',
    'database_server_error__consult_admin' => 'Lépjen kapcsolatba a kiszolgáló adminisztrátorával.',
    'database_server_error__last__connection_failed' => 'Ezen adatbázis kezelésére irányuló legutóbbi kísérlet hálózati problémák miatt nem sikerült.',
    'database_server_error__last__permission_denied' => 'Ezen adatbázis kezelésére irányuló legutóbbi kísérlet nem sikerült, mivel a megadott fiók nem rendelkezik rendszegazda jogosultságokkal.',
    'database_server_error__last__credentials_not_set' => "Nem volt sikeres az utolsó ezen kiszolgálóhoz kapcsolódási kísérlet, mivel nem került érvényes adminisztrátor felhasználónév és jelszó megadásra.",
    'database_server_error__last__other_error' => 'Ezen adatbázis kezelésére irányuló legutóbbi kísérlet nem sikerült.',
    'database_server_error__real__connection_failed' => 'A következő hálózati problémák miatt nem sikerült az adatbázis-kiszolgálóhoz kapcsolódás:',
    'database_server_error__real__permission_denied' => 'Az adatbázis-kiszolgálóhoz kapcsolódás nem sikerült, mivel a megadott fiók nem rendelkezik rendszegazda jogosultságokkal:',
    'database_server_error__real__duplicate_object' => 'Névütközés miatt nem sikerült az adatbázis-kiszolgálóhoz kapcsolódás:',
    'database_server_error__real__unacceptable_name' => 'Egy érvénytelen objektumnév miatt nem sikerült az adatbázis-kiszolgálóhoz kapcsolódás:',
    'database_server_error__real__unacceptable_password' => 'Egy elfogadhatatlan jelszó miatt nem sikerült az adatbázis-kiszolgálóhoz kapcsolódás:',
    'database_server_error__real__credentials_not_set' => "Nem sikerült kapcsolódni az adatbázis-kiszolgálóhoz, mivel nem került érvényes adminisztrátor felhasználónév és jelszó megadásra.",
    'database_server_error__real__other_error' => 'Az adatbázis-kiszolgálóhoz kapcsolódás nem sikerült:',
    'database_server_error__test__connection_failed' => 'Nem volt sikeres az adatbázis-kiszolgáló kapcsolat tesztelése a következő hálózati problémák miatt:',
    'database_server_error__test__permission_denied' => 'Nem volt sikeres az adatbázis-kiszolgáló kapcsolat tesztelése, mivel a megadott számla nem rendelkezik adminisztrátor jogosultságokkal.',
    'database_server_error__test__duplicate_object' => 'Nem volt sikeres az adatbázis-kiszolgáló kapcsolat tesztelése névütközés miatt:',
    'database_server_error__test__unacceptable_name' => 'Nem volt sikeres az adatbázis-kiszolgáló kapcsolat tesztelés érvénytelen objektumnév miatt:',
    'database_server_error__test__unacceptable_password' => 'Nem volt sikeres az adatbázis-kiszolgáló kapcsolat tesztelése elfogadhatatlan jelszó miatt:',
    'database_server_error__test__credentials_not_set' => "Nem volt sikeres e kiszolgáló kapcsolat tesztelése, mivel nem került érvényes adminisztrátor felhasználónév és jelszó megadásra.",
    'database_server_error__test__other_error' => 'Nem volt sikeres e kiszolgáló kapcsolat tesztelése:',

    'db__create_new_db' => "Egy adatbázis hozzáadása",
    'db__db_add' => "Adatbázis hozzáadása",
    'db__db_for_dom' => "%1 webhely adatbázisa",
    'db__db_id_undefined' => "Nincs adatbázis azonositó meghatározva.",
    'db__db_name' => "Adatbázisnév",
    'db__db_not_exist' => "Az adatbázis nem létezik.",
    'db__db_type' => "Típus",
    'db__db_server' => "Adatbázis-kiszolgáló",
    'db_server_not_exist' => "Adatbázis-kiszolgáló nem létezik.",
    'db__db_user_not_exist' => "Adatbázis-felhasználó nem létezik.",
    'db__domain_not_exist' => "A domain nem létezik.",
    'db__enter_db_name' => "Írjon be új adatbázis nevet.",
    'db__invalid_db_id' => "Az adatbázis azonosítója érvénytelen.",
    'db__invalid_db_name' => "Érvénytelen az adatbázis név. Kizárólag latin betűket, számokat, aláhúzásjelet vagy kötőjelet tartalmazhat az adatbázis név. Nem haladhatja meg 63 szimbólumot.",
    'db__max_db_reached_for_dom' => "Az adatbázisok száma elérte e domainre vonatkozó korlátot.",
    'db__max_mssql_db_reached_for_dom' => "Az Microsoft SQL-kiszolgáló adatbázisok száma elérte e domainre vonatkozó korlátot.",
    'db__postgres_not_connect_for_admin' => "Nem lehet PostgreSQL adatbázishoz kapcsolódni. Kapcsolja be a PostgreSQL támogatást a kiszolgáló felügyeleti oldalán.",
    'db__postgres_not_connect_for_client' => "Nem lehet PostgreSQL adatbázishoz kapcsolódni. Lépjen kapcsolatba rendszergazdával a probléma megoldásához.",
    'db__remove_db_on_domain' => "Eltávolításra kerülnek %1 ügyfél által birtokolt %2 webhely következő adatbázisai:",
    'db__remove_db_on_domain_of_cl' => "Eltávolításra kerülnek %1 ügyfél által birtokolt %2 domain következő adatbázisai:",
    'db__remove_db_linked_resource' => 'Egy webalkalmazás használja az adatbázist. Kizárólag ezen webalkalmazás eltávolítása után távolítható el.',
    'db__remove_db_users' => "Eltávolításra kerülnek %1 ügyfél által birtokolt %2 webhely %3 adatbázis következő felhasználói:",
    'db__remove_db_users_of_cl' => "Eltávolításra kerülnek %1 ügyfél által birtokolt %2 webhely %3 adatbázis következő felhasználói:",
    'db__select_db_for_remove' => "Válassza ki az eltávolítandó adatbázisokat.",
    'db__select_db_users_for_remove' => "Válassza ki az eltávolítandó adatbázis-felhasználókat.",
    'db__unable_create_db_user' => "Az adatbázis-felhasználó létrehozása nem lehetséges: %1",
    'db__unable_define_db_name' => "Az adatbázisnév meghatározása nem lehetséges: %1",
    'db__unable_define_db_user' => "Az adatbázis-felhasználó meghatározása nem lehetséges: %1",
    'db__unable_define_db_users' => "Az adatbázis felhasználók meghatározása nem lehetséges: %1",
    'db__unable_select_dom_name' => "Domain név kiválasztása nem lehetséges: %1",
    'db_edit__db_for_dom' => "%2 domain %1 adatbázis felhasználók",
    'db_edit__invalid_db_name' => "Az adatbázisnév érvénytelen.",
    'db_edit__no_users' => "Nincsenek bejelentkezéshez szükséges hitelesítő adatokkal rendelkező felhasználók ezen adatbázishoz.",
    'db_edit__unable_define_db_usrs' => "Adatbázis-felhasználók meghatározása nem lehetséges: %1",
    'db_edit__unable_select_db_usr' => "Adatbázis-felhasználó kiválasztása nem lehetséges.",
    'db_edit__db_user_password_for_' => "Írja be a jelszót %1 adatbázis-felhasználókénti belépéshez",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Adatbázis-felhasználó hozzáadása",
    'db_usr_edit__db_usr_name' => "Adatbázis-felhasználó neve",
    'db_usr_edit__edit_db_usr' => "Adatbázis-felhasználó hitelesítő adatainak beállítása",
    'db_usr_edit__for_db' => "%1 adatbázisban",
    'db_usr_edit__not_create_pass' => "E művelet eredménye egy jelszó nélküli adatbázis felhasználói fiók létrehozása lesz.\nBiztosan egy jelszó nélküli felhasználót akar létrehozni?",
    'dbuser__only_one_user_can_be_default' => "Csupán egy felhasználót lehet mint alapértelmezett felhasználóként megadni.",
    'db_server__cannot_delete_default' => "Az alapértelmezett adatbázis-kiszolgálót nem lehet törölni.",
    'db_server__cannot_delete_local' => "A helyi adatbázis-kiszolgálót nem lehet törölni.",
    'db_server__cannot_delete_used' => 'Nem törölhető adatbázis-kiszolgáló, amíg adatbázisok vagy adatbázis felhasználók üzemeltetése folyik rajta.',
    'demo__disabled_in_demo' => "E művelet nem támogatott a bemutató verzióban.",
    'defaultcomponents__title' => "Alapértelmezett összetevők kiválasztása",
    'defaultcomponents__select_default' => "%1 alapértelmezett összetevőt válassza ki", //to check
    'defaultcomponents__not_installed' => "(nincs telepítve)",
    'defaultcomponents__not_configured' => "(nincs konfigurálva)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Érvénytelen kiválasztásokat tartalmaz néhány szolgáltatási kategória vagy nem történt meg a kiválasztás.",
    'defaultcomponents__depends_on' => "(%1 szükséges)",
    'defaultcomponents__parameters' => "%1 paraméterei",
    'component_name__antivirus' => "Vírusvédelem",
    'component_name__database' => "SQL-kiszolgáló",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-kiszolgáló",
    'component_name__firewall' => "Tűzfal",
    'component_name__ftpserver' => "FTP-kiszolgáló",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Levelezési kiszolgáló",
    'component_name__local_mailserver' => "Helyi levelezési kiszolgáló",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Webes parancsnyelv",
    'component_name__spamfilter' => "Levélszemét szűrő",
    'component_name__stats' => "Webstatisztikák",
    'component_name__stunnel' => "SSL/TLS-burkoló",
    'component_name__webmail' => "Webes levelezés",
    'component_name__webpublish' => "Közzététel a weben",
    'component_name__webserver' => "Webkiszolgáló",
    'dns__dns_record_invalid_values' => 'Helytelen DNS-rekord értékek kerültek megadásra: %1: %2',
    'dns__dns_record_not_found' => 'Nem található DNS-rekord.',
    'dns__dns_zone_invalid_values' => 'Helytelen DNS-zóna paraméterek kerültek megadásra.',

    'dns__soa_mname_title' => 'Elsődleges névkiszolgáló',
    'dns__soa_mname_legend' => 'Névkiszolgálók',
    'dns__soa_mname_autoselect' => '(Automatikus kiválasztás)',

    'dns__dns_zone_off_remove_title' => "A következő erőforrás rekordok eltávolításra kerülnek %1 zónából:",
    'dns__dns_zone_master_remove_title' => "Erőforrásrekordok törlése %1 DNS-zónából",
    'dns__dns_zone_slave_remove_title' => "%1 esetén eltávolításra kerülnek a következő elsődleges névkiszolgáló rekordok:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Írjon be rekord karakterláncot',
    'dns_add__is_spf_syntax' => 'SPF-rekord',
    'dns_add__spf_value_is_invalid' => "Helytelen az SPF-rekord értéke, 'v=spf' kezdetűnek kell lennie.",
    'dns__dns_zone_status' => "A DNS-zóna állapota.",
    'dns__invalid_ip_address' => "Érvénytelen vagy nincs megadva az új elsődleges DNS-kiszolgáló IP-címe.",
    'dns__ip_address' => "IP-cím",
    'dns__master_dns_type' => "egy elsődleges DNS-kiszolgáló",
    'dns__masters' => "elsődleges DNS-kiszolgálók",
    'dns__soa_minimum_too_large' => 'Negatív válaszok három óránál tovább történő gyorsítótárazása nem ajánlott.',
    'dns__select_masters_to_remove' => "Válassza ki az eltávolítandó elsődleges DNS-kiszolgálókat.",
    'dns__select_template_record_to_remove' => 'Válassza ki az eltávolítandó DNS-sablont.',
    'dns__nameservers_for_domain' => "A domain névkiszolgálói",
    'dns__remove_dns_zone_of_domain__' => "DNS-rekordok eltávolítása %1 domainből",
    'dns__remove_dns_zone_template__' => "A következő DNS-rekordok kerülnek eltávolításra a sablonból:",
    'dns__remove_this_dns_record?' => "Biztosan el akarja távolítani ezt a DNS-rekordot?",
    'dns__restore_default' => "A DNS-zóna visszaállítása a sablonból",
    'dns__restore_default_confirm' => "A DNS-zóna visszaállítása elveti a jelenlegi DNS-zóna konfigurációt. Mindenképpen folytatja?",
    'dns__restore_default_error' => "Hiba törént a DNS-zóna visszaállítása során:",
    'dns__slave_dns_type' => "egy másodlagos DNS-kiszolgáló",
    'dns__subdomain_dns_rec_removed' => "Megtörtént %1 aldomain zónából az A rekord eltávolítása.",
    'dns__zone_switched_off_no_ns' => "Nem történt meg a zóna kikapcsolása, mivel nincs %1 NS rekord, melynek a zónában szerepelnie kell. Egy rekord zónához adásához kattintson a Rekord hozzáadása gombra.",
    'dns__cant_switch_on_no_ns' => "Nem kapcsolható be a zóna, mivel nincs %1 NS rekord, melynek a zónában szerepelnie kell. Egy rekord zónához adásához kattintson a Rekord hozzáadása gombra.",
    'dns__unable_activate/deactivate_dns' => "DNS aktiválása/inaktiválása nem lehetséges: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Elsődleges DNS-kiszolgáló hozzáadása nem lehetséges: ismétlődő bejegyzés.",
    'dns__unable_add_dns_master_local_ip' => "Nem lehetséges IP-cím hozzáadást elsődleges DNS-kiszolgáló számára elvégezni: egy távoli kiszolgálón kell létrehozni e rekordot.",
    'dns__unable_define_dns_record' => "A DNS-rekord meghatározása nem lehetséges: %1",
    'dns__unable_get_dns_template_status' => "A DNS-sablon állapotának lekérése nem lehetséges.",
    'dns__unable_remove_dns_rec' => "A DNS-rekord eltávolítása nem lehetséges: %1",
    'dns__warnings__' => "A DNS-zóna módosításának eredménye:",
    'dns__you_not_have_perm_manage_dns' => "Nincs engedélye e domain DNS-zónájának a kezelésére.",
    'dns__cant_create_record_with_server_ip' => "Nem lehetséges ezen IP-cím hozzáadása, mivel egyezik a Plesk által kezelt kiszolgáló IP-címével.",

    'dns__tabs_acl' => "Zónaletöltések",
    'dns__acl_add_network_legend' => "Hálózat hozzáadása",
    'dns__acl_add_ip_legend' => "IP-cím hozzáadása",
    'dns__acl_network_not_allowed' => "Windows operációs rendszerben a DNS nem engedélyezi e hálózati címet.",
    'dns__acl_enter_ip_address_with_mask' => "IP-cím/maszk",
    'dns__acl_enter_ip_address' => "IP-cím",
    'dns__acl_list_network_legend' => "Engedélyezve van a hálózatok számára, hogy rendelkezzenek egy DNS-zóna másolattal.",
    'dns__acl_list_ip_legend' => "Engedélyezve van az IP-címek számára, hogy rendelkezzenek egy DNS-zóna másolattal.",
    'bt_dns_acl_add_network' => "Hálózat hozzáadása",
    'bt_dns_acl_add_ip' => "IP-cím hozzáadása",

    'dns_add__add_rec_for_zone' => "%1 hozzáadása %2 zónához",
    'dns_add__canonical_dom_name_is_invalid' => "Érvénytelen a kanonikus domain név.",
    'dns_add__enter_canonical_name' => "Kanonikus név",
    'dns_add__enter_dom_name' => "Domain név",
    'dns_add__enter_ip_address' => "IP-cím",
    'dns_add__enter_ip_mask' => "IP-cím és hálózati maszk",
    'dns_add__enter_mail_domain' => "Levelezési domain",
    'dns_add__enter_mail_exchanger' => "Levelezési adatcsere kiszolgáló",
    'dns_add__enter_nameserver' => "Névkiszolgáló",
    'dns_add__enter_txt_record' => "TXT-rekord",
    'dns_add__enter_service_name' => "Szolgáltatás neve",
    'dns_add__hint_service_name' => "Példa: SIP (aláhúzás szimbólum nélkül)",
    'dns_add__enter_protocol' => "Protokoll",
    'dns_add__hint_protocol_name' => "Példa: TCP (aláhúzás szimbólum nélkül)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritás",
    'dns_add__specify_weight_of_service' => "Azonos prioritású rekordok relatív súlya",
    'dns_add__enter_target_host' => "Célállomás",
    'dns_add__hint_target_host' => "Például: example.com",
    'dns_add__enter_target_port' => "Célport",
    'dns_add__caa_tag' => "Címke",
    'dns_add__caa_value' => "Érték",
    'dns_add-invalid-A_ip' => "Az IP-cím érvénytelen.",
    'dns_add-invalid-AAAA_ip' => "Az IP-cím érvénytelen.",
    'dns_add-invalid-PTR_ip_mask' => "Érvénytelen IP-cím/alhálózati maszk páros.",
    'dns_add-invalid-SRV_service_name' => "Érvénytelen szolgáltatásnév",
    'dns_add-invalid-SRV_protocol_name' => "Érvénytelen protokoll",
    'dns_add-invalid-SRV_target_port' => "Érvénytelen célport",

    'dns_add__invalid_ip' => "Az IP-cím érvénytelen.",
    'dns_add__low' => "alacsony",
    'dns_add__mail_dom_name_is_invalid' => "Az e-mail domain név érvénytelen.",
    'dns_add__nameserver_is_invalid' => "A névkiszolgáló érvénytelen.",
    'dns_add__record' => "%1 rekord",
    'dns_add__select_prefer_for_mail_exchange_server' => "A levelezési adatcsere kiszolgáló prioritásának megadása",
    'dns_add__unable_insert_new_dns_rec' => "Új DNS-rekord beszúrása nem lehetséges: %1",
    'dns_add__very_high' => "nagyon magas",
    'dom_ctrl__allowed' => "Engedélyezett",
    'dom_ctrl__db' => "MariaDB/MySQL-adatbázisok",
    'dom_ctrl__mssql_db' => "MS SQL-adatbázisok",
    'dom_ctrl__disk_space' => "Lemezterület",
    'dom_ctrl__dom_adm' => "%2 felhasználó %1 domainje",
    'dom_ctrl__dom_cl' => "%1 domain",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Továbbítás beállítással rendelkezik a domain, de nincs megadva továbbítási URL-cím",
    'dom_ctrl__domain_has_frame_forwarding' => "%1 URL-címre történő csomagtovábbítás van beállítva a domainnél",
    'dom_ctrl__domain_has_no_hosting' => "Nem rendelkezik üzemeltetés konfigurációval a domain",
    'dom_ctrl__domain_has_physical_hosting' => "Webüzemeltetés van %1 IP-címen konfigurálva e domain esetében.",
    'dom_ctrl__domain_has_standard_forwarding' => "%1 URL-címre történő normál továbbítás van beállítva a domainre",
    'dom_ctrl__maillists' => "Levelezési listák",
    'dom_ctrl__mboxes' => "Postaládák",
    'dom_ctrl__mg' => "Levéltovábbítások",
    'dom_ctrl__resource_name' => "Erőforrás",
    'dom_ctrl__resp' => "Automatikus válaszok",
    'dom_ctrl__subdom' => "Aldomainek",
    'dom_ctrl__dom_aliases' => "Domain aliasok",
    'dom_ctrl__traffic' => "Forgalom",
    'dom_ctrl__unable_activate/deactivate_dom' => "Domain aktiválása/inaktiválása nem lehetséges: %1",
    'dom_ctrl__used' => "Használt",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webes felhasználók",
    'dom_pref__bounce_with_phrase' => "Visszapattanó üzenet",
    'dom_pref__bounce' => "Pattogás",
    'dom_pref__catch_addr' => "Címre továbbítás",
    'dom_pref__reject' => 'Elutasítás',
    'dom_pref__confirm_domain_removing' => "Ne felejtse el értesíteni a domain felhasználóit a domain nevének megváltozásáról. Biztosan át kívánja nevezni a domaint?",
    'dom_pref__db_inconsystency' => "adatbázis inkonzisztencia.",
    'dom_pref__dbs' => "adatbázisok",
    'dom_pref__delete_traffic_stat' => "Web- és forgalmi statisztikák megőrzése",
    'dom_pref__delete_traffic_stat_older' => "Web- és forgalmi statisztikák megőrzése",
    'dom_pref__dom_level_name_conflict' => "A domain adminisztrátor felhasználóneve ütközik az egyik ügyfél felhasználónevével.",
    'dom_pref__invalid_disk_space_limit' => "Érvénytelen lemezterület korlát Maximális érték: %1",
    'dom_pref__invalid_expiration_date_limit' => "Érvénytelen lejárati dátum.",
    'dom_pref__invalid_max_traffic_limit' => "Érvénytelen forgalmi korlát. Maximális érték: %1",
    'dom_pref__limits_of_dom' => "%1 domain korlátok",
    'dom_pref__mail_grps' => "levelezési csoportok",
    'dom_pref__mail_nonexistent_user' => "Nem létező felhasználók e-mailjeivel a teendő",
    'dom_pref__mail_redirs' => "e-mail továbbítók.",
    'dom_pref__mail_resps' => "automatikus e-mail válaszok.",
    'dom_pref__max_limit_is_invalid' => "%1 érvénytelen.",
    'dom_pref__max_num_of_%objects_is_invalid' => "%1 maximális száma érvénytelen.",
    'dom_pref__new_limit_less_currently_used' => "%1: igényelt - %2, jelenleg használt - %3",
    'dom_pref__older_that' => "számára",
    'dom_pref__postboxes' => "postaládak",
    'dom_pref__preferences_of_dom' => "%1 domain beállításai",
    'dom_pref__redirect_to_itself' => "A domain továbbítási címe a saját címével lesz egyező",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "A forgalmi statisztikák megőrzési időtartama kevesebb, mint a kiszolgálóre meghatározott teljes érték (%1 hónap). A kiszolgáló alapértelmezett értékére (%1 hónap) állítsa be az adatmegőrzés időtartamát.",
    'dom_pref__unable_add_www_prefix_in_dom' => "Egy www előtag hozzáadása a domainhez nem lehetséges: %1",
    'dom_pref__unable_define_physical_hst_param' => "A fizikai üzemeltetésra vonatkozó paraméterek meghatározása nem lehetséges: %1",
    'dom_pref__unable_rename_domain' => "%1 domain átnevezése nem lehetséges: %2",
    'dom_pref__unable_set_up_mbox_quota' => "A postaláda kvóta beállítása e domain esetében nem lehetséges: %1",
    'dom_pref__unable_set_up_web_user_script' => "Parancsfájlkezelés beállítása a webes felhasználók számára nem lehetséges: %1",
    'dom_pref__unlimited' => "Korlátlan",
    'dom_pref__web_usrs' => "webes felhasználók",
    'dom_pref__you_already_have_%object' => "Már van %1",
    'cu_domain__error_unable_update_ftp_users' => 'Nem sikerül a domain FTP-felhasználók frissítése: %1',
    'dom_cli__warning_ignore_quota' => 'FIGYELMEZTETÉS: A "-merevlemez_kvóta" beállítás figyelmen kívül van hagyva: a merevlemez kvóta funkció nem támogatott',
    'dom_user_client_login_exist' => "Nem lehetséges domain adminisztrátor hozzáférést engedélyezni a Plesk kezelőpanelhez %1 domain esetébe: már használatban van e felhasználónév.",
    'domain__unable_to_turn_on_service' => "Nem sikerült %1 szolgáltatás bekapcsolása.",
    'domains__change_the_status_of_domain?' => "Biztosan meg akarja változtatni %1 nevű domain állapotát?",
    'domains__unable_to_change_client_status' => "Nem lehetséges az ügyfélszámla állapotának a megváltoztatása: %1",
    'domains__unable_update_apache_settings' => "Nem lehetséges az Apache beállítások frissítése.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Nincs engedélye a domainek törléséhez.",
    'domains_list__unable_remove_doms' => "A domainek eltávolítása nem lehetséges: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Válssza ki az eltávolítandó domain aliasokat.',
    'domain_aliases_remove__title' => 'Domain aliasok eltávolítása',
    'domain_aliases__max_aliases_reached_for_dom' => "Megtörtént e domain alias szám korlátjának az elérése.",
    'domain_edit__edit_title' => 'Domain alias név szerkesztése',
    'domain_alias_edit__type' => 'Domain alias típusa',
    'domain_aliases__list_header' => 'Domain aliasok',
    'domain_aliases__name' => 'Név',
    'domain_aliases__type' => 'Típus',
    'domain_aliases__type_full' => 'Web+FTP+e-mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domain aliasok',
    'domain_aliases__legend' => 'Domain aliasok',
    'domain_alias__domain_exists' => 'Ilyen nevű domain már létezik.',
    'domain_alias__subdomain_exists' => 'Ilyen nevű aldomain már létezik.',
    'domain_alias__dns_record_exists' => 'Már létezik a megadott domain alias névvel egy DNS-rekord.',
    'domain_alias__domain_alias_exists' => "Ilyen nevű domain alias már létezik.",
    'domain_alias__invalid_type_full' => 'A levelezési kiszolgáló nem támogatja a domain aliasokat.',
    'domain_alias__redirect_exists' => 'Önmagára átirányítás észlelése történt.',

    'ds__anonymous_ftp' => "Névtelen FTP",
    'drweb__pagetitle' => 'Vírusvédelmi beállítások',
    'drweb__drweb' => 'Vírusvédelmi levélellenőrzés',
    'drweb__drweb_direction' => 'Levelek vírusok szempontjából ellenőrzése',
    'drweb__drweb_direction_off' => 'Ne végezzen víruskeresést.',
    'drweb__drweb_direction_any' => 'Bejövő és kimenő levél',
    'drweb__drweb_direction_from' => 'Csak kimenő levél',
    'drweb__drweb_direction_to' => 'Csak bejövő levél',
    'drweb__disable_reason_key' => 'Nem támogatja a licenckulcs a vírusvédelmet.',
    'drweb__disable_reason_perm' => 'Nincs engedélye a Vírusvédelem kezelésére.',
    'drweb__disable_reason_install' => 'Nincs telepítve vírusvédelem.',
    'drweb__filters' => 'Vírusszűrők',
    'ds__dns' => "DNS-zóna",
    'ds__mail' => "E-mail",
    'dumps_list__deletion_page_title' => "%1 nevű domain biztonsági másolat fájlai közül a következők kerülnek törlésre:",
    'dumps_list__dumpfile_is_invalid' => "%1 fájl nem egy érvényes biztonsági másolat fájl.",
    'dumps_list__page_title' => "Biztonsági másolat fájl tároló",
    'dumps_upload__page_title' => "Biztonsági másolat fájlok tárolóba történő feltöltése",
    'dumps_list__repository_is_not_exist' => "Nem létezik a biztonsági másolat fájl tároló.",
    'dumps_list__unable_to_remove' => "A biztonsági másolat fájl eltávolítása nem lehetséges: %1",
    'dumps_list__dumpfile_can_conflict' => "A megadott fájl név ütközik %1 fájllal. Adjon meg egy másik fájlnevet.",
    'dusr_ed__allow_dl_usr_access' => "Domain adminisztrátor hozzáférés engedélyezése",
    'dusr_ed__information' => "%1 domain adminisztrátor tulajdonságai",
    'dusr_ed__locale' => "Domain adminisztrátor nyelve",
    'dusr_ed__skin' => "Domain adminisztrátor kezelőfelület felszíne",
    'dusr_ed__personal_information' => 'Személyi adatok',
    'ess__error' => "Hiba",
    'example__' => "Például: %1",
    'extras__allow_certificate_purchasing' => "Tanúsítvány vásárlás engedélyezése",
    'extras__allow_domain_registration' => "Domainregisztráció engedélyezése",
    'extras__allow_extras' => "Külön szolgáltatások engedélyezése",
    'extras__buy_new_key' => "A jelenlegi licence nem teszi lehetővé ezen objektumok módosítását.",
    'extras__setup_services' => "További szolgáltatások beállítása",

    'ruleeditform__error' => 'Nem frissíthető tűzfalszabály.',
    'ruleeditform__name_is_required' => 'Adja meg a szabály nevét.',
    'ruleeditform__profiles_is_required' => 'Válasszon legalább egy profilt.',
    'ruleeditform__invalid_ip' => 'Érvénytelen a megadott IP-cím vagy hálózat.',
    'ruleeditform__invalid_port' => 'Érvénytelen a megadott port. 1000 vagy 1000-1051 a lehetséges értékek.',

    'get_password__encrypted_password' => "Nem lehetséges jelszó adatok küldése: titkosítva van tárolva a jelszó.",
    'get_password__mail_error' => "Hiba történt a jelszó %1 e-mail címre küldési kísérlete során: %2",
    'get_password__mail_ok' => "Sikerese elküldésre került a jelszó a következő e-mail címre: %1",
    'get_password__message' => "E rendszerhez történő hozzáféréséhez szükséges jelszava: %1\n%2 a jelszava.",
    'get_password__subject' => "E rendszerhez történő hozzáférés jelszava",
    'groups__available' => "Rendelkezésre álló levelezési csoportok",
    'groups__groups_for_mailname' => "Azon levelezőcsoportok, melyekhez %1 postafiók elő van fizetve.",
    'groups__member_of' => "A következő levelezési csoportok tagja",
    'help__help_area' => "Súgó terület.",
    'hst_def__auth_disabled' => "letiltott",
    'hst_def__auth_enabled' => "engedélyezett",
    'hst_def__change_curr_dns_ip' => "Az A típusú DNS-rekord jelenlegi IP-címe megváltoztatásre kerül",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Az A típusú DNS-rekord IP-címei közül egyik sem egyezik meg azzal az IP-címmel, mely a létrehozandó üzemeltetési fiókhoz van rendelve",
    'hst_def__dest_url' => "Cél URL-cím",
    'hst_def__disk_quota' => "Lemezkvóta",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "A beállítani próbált lemezterület korlát meghaladja a névtelen FTP szolgáltatás bejövő könyvtárára lemezterület korlátját. A névtelen FTP szolgáltatás bejövő könyvtárárának lemezterület korlátja nem haladhatja meg a domain lemezterület korlátját.",
    'hst_def__frame_forwarding_definition' => "Kerettovábbítási hozzárendelés %1 domain számára",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Figyelmeztetés: %1 FTP-felhasználó szerepel az üzemeltetési számla beállítások között, de nincs a rendszerben.",
    'hst_def__hst_type_is_not_defined' => "Nincs meghatározva az üzemeltetési típus",
    'hst_def__ip_based' => "IP-alapú",
    'hst_def__name_based_power_anonymous_ftp_down' => "Ezen üzemeltetési számla megosztott IP-címre történő átvitele megszünteti e domainen a névtelen FTP-szolgáltatás rendelkezésre állását. Mindenképpen folytatja?",
    'hst_def__password_is_invalid_password_syntax' => "A jelszó érvénytelen.\nNe használjon szimpla idézőjelet és nemzeti karaktereket a jelszóban.\nA jelszó hossza 5 és 14 karakter között legyen. A jelszó nem tartalmazhatja a felhasználói nevet.",
    'hst_def__shell' => "SSH-hozzáférés a kiszolgáló felhasználói felületéhez az előfizetés rendszerfelhasználói számára",
    'hst_def__shell_windows' => "Az előfizetés rendszerfelhasználóinak Távoli asztal hozzáférése a kiszolgálóhoz",
    'hst_def__standard_forwarding_definition' => "Normál továbbítás hozzárendelés %1 domain számára",
    'hst_def__title_name_based' => "Névalapú",
    'hst_def__unable_create/update_physic_hst' => "A fizikai üzemeltetés létrehozása/frissítése nem lehetséges: %1",
    'hst_def__unable_create/update_std_fwd' => "Normál továbbítás létrehozása/frissítése nem lehetséges: %1",
    'hst_def__unable_create_forwarding_myself' => "A domain önmagára irányuló továbbításos működése nem lehetséges.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Nem lehetséges SSL/TLS- és nem SSL/TLS-tartalmak azonos könyvtárban tárolásának az engedélyezése: Nincs bekapcsolva az SSL-támogatás.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Nem lehetséges az SSL/TLS-támogatás bekapcsolása: nincs SSL/TLS-tanúsítvány telepítve.",
    'hst_def__url_is_invalid' => "Az URL-cím érvénytelen.",
    'hst_def__virtual_host_access' => "Virtuális állomás hozzáférés %1 domain esetén",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "FIGYELMEZTETÉS. Nem létező IP-címet használ e virtuális állomás az üzemeltetéshez.",
    'hst_def__you_have_no_ips' => "Nincsenek rendelkezésre álló IP-címei és nem engedélyezett az Ön számára Névalapú üzemeltetés létrehozása.",
    'hst_sel__header' => "Egy webhely ezen kiszolgálón történő üzemeltetéséhez a Fizikai üzemeltetés beállítást válassza ki.\n Egy másik gépen található webhelyre történő domain továbbítás beállításához, válassza ki a Kerettovábbítás vagy a Normál továbbítás beállítást.\n Normál továbbítás esetén egy felhasználó átirányításra kerül a webhelyre és a tényleges webhely URL-címe jelenik meg a felhasználó böngészőjében, így a felhasználó értesül az átirányításról. Kerettovábítás esetén anélkül kerül egy felhasználó átirányításra a webhelyre, hogy tudná ténylegesen másik helyen található a webhely.",
    'hst_sel__physical_hst' => "Fizikai üzemeltetés",
    'hst_sel__select_hst_type' => "A üzemeltetési típus kiválasztása a domain számára",
    'hst_sel__select_hst_type_warning' => "A üzemeltetési típus kiválasztása a domain számára",
    'hst_sel__hosting_exists' => "A üzemeltetés létrehozása nem lehetséges, mert ehhez a domainhez a üzemeltetést már konfigurálták. A üzemeltetés kezelése című lapra irányítjuk át.",
    'hst_sel__standard_frw' => "Normál továbbítás",
    'hst_sel__frame_frw' => "Kerettovábbítás",
    '__frame_frw' => "Kerettovábbítás",
    '__hosting_exists' => "A üzemeltetés létrehozása nem lehetséges, mert ehhez a domainhez a üzemeltetést már konfigurálták. A üzemeltetés kezelése című lapra irányítjuk át.",
    '__choose_hst_type' => "Válassza ki a kívánt üzemeltetési típust.",
    '__no_hst_conf' => "Nincs üzemeltetés konfigurálva a domainjéhez.",
    '__physical_hst' => "Fizikai üzemeltetés",
    '__select_hst_type' => "A üzemeltetési típus kiválasztása a domain számára",
    '__standard_frw' => "Normál továbbítás",
    '__warning' => "Figyelmeztetés! Az összes korábban beállított paraméter törlődni fog. Biztosan meg akarja változtatni a üzemeltetési típust?",
    'i_cl_off' => "Inaktív az ügyfél.",
    'i_cl_off_by_admin' => "A kiszolgáló adminisztrátor felfüggesztette az ügyfélszámlát.",
    'i_cl_off_expired' => "Lejárt az ügyfélszámla.",
    'i_cl_on' => "Aktív az ügyfél.",

    'icf__title' => 'Internetkapcsolat tűzfala',
    'icf__if_legend' => 'Illesztők',
    'icf__mode' => 'Mód',

    'invalid_value' => 'Érvénytelen az érték.',

    'ip_addr__already_exists' => "%1 IP-cím már létezik.",
    'ip_addr__cant_add' => "%1 IP-cím nem létezik vagy egy másik ügyfél IP-cím készletéhez tartozik.",
    'ip_alias__interface' => "Kezelőfelület",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-cím használata név alapú virtuális üzemeltetés céljára érvénytelen.",
    'ip_alias__invalid_ip_or_netmask' => "Érvénytelen IP-cím/alhálózati maszk páros.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Az eredeti kiszolgáló IP-cím %1 IP-cím, így nem távolítható el.",
    'ip_alias__ip_is_invalid' => "%1 IP-cím érvénytelen.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP-maszk érvénytelen.",
    'ip_alias__ip_not_exist' => "%1 IP-cím nem létezik.",
    'ip_alias__ip_address_and_mask' => 'IP-cím és alhálózati maszk',
    'ip_alias__mask' => "Alhálózati maszk",
    'ip_alias__remove_selected_ip_aliases?' => "Biztos el akarja távolítani a kijelölt IP-címeket?",
    'ip_alias__select_ip' => "Válasszon ki legalább egy IP-címet a listából az eltávolításhoz.",
    'ip_alias__this_ip_used_for_domain' => "Ezen (%1) IP-cím %2 domain számára került felhasználásra.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "Ezen (%1) IP-cím névalapú virtuális üzemeltetés számára került felhasználásra.",
    'ip_alias__unable_add_ip' => "IP-cím hozzáadása nem lehetséges: %1",
    'ip_alias__unable_remove_ip' => "IP-cím eltávolítása nem lehetséges: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Az IP-cím megváltoztatása típusúra változtatása nem lehetséges, mivel akkor '%1' domain névtelen FTP szolgáltatása elérhetetlenné válna.",
    'ip_ctrl__ip_addr' => "%1 kezelőfelületen lévő %2 IP-cím",
    'ip_ctrl__ip_exists_many_pools' => "Nem változtathatja meg az IP-cím típusát. Ezen IP-cím egyidejűleg több felhasználó készletéhez tartozik.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-tanúsítvány",
    'limit__date_in_past' => "Az érvényességi időtartam érvénytelen. %1 egy múltba mutató dátum.",
    'limit__enter_date' => "Dátum beírása",
    'limit__max_db' => "Adatbázisok",
    'limit__name_disk_space' => "lemezterület",
    'limit__name_max_box' => "postaládak",
    'limit__name_max_db' => "MariaDB/MySQL-adatbázisok",
    'limit__name_max_dom' => "domainek",
    'limit__name_max_maillists' => "levelezési listák",
    'limit__name_max_subdom' => "aldomainek",
    'limit__name_max_traffic' => "forgalom",
    'limit__name_max_wu' => "webes felhasználók",
    'limit__name_mbox_quota' => "postaláda kvóta",
    'limit__name_max_mn' => "postafiókok",
    'limit__name_max_cl' => 'ügyfelek',
    'limit__name_total_mboxes_quota' => "összes postaláda kvóta",
    'limit__name_mysql_dbase_space' => "MariaDB/MySQL-adatbázis területe",
    'limit__name_mssql_dbase_space' => "MSSQL-adatbázis terület",
    'limit__name_pgsql_dbase_space' => "PostgreSQL adatbázis terület",
    'limit__name_expiration' => 'lejárati dátum',

    'locale_upload__unable_to_install' => 'Nem lehetséges a nyelvi csomag fájl telepítése',
    'locale_upload__wrong_package' => 'Nem tartalmaz e Plesk verzió számára érvényes nyelvi csomagot az Ön által feltöltött fájl.',
    'locale_upload__wrong_locale' => 'Nem tartalmaz érvényes nyelvi csomagot az Ön által feltöltött fájl.',

    'ma__create_title' => '%1 e-mail alias létrehozása',
    'ma__edit_title' => "%1 e-mail alias szerkesztése",
    'ma__enter_new_alias' => "Írjon be új aliast.",
    'ma__invalid_alias' => "Érvénytelen e-mail alias.",
    'ma__mail_aliases_mailname' => "%1 postafiók mail aliasai",
    'ma__mailname_does_not_exist' => "Nem létezik a postafiók.",
    'ma__select_ma_for_remove' => "Válassza ki az eltávolítandó e-mail aliasokat.",
    'ma__unable_to_add_new_ma' => "Nem lehetséges egy mail alias hozzáadása: %1",

    'mail_queue__not_allowed_by_license_key' => 'A levelezés várakozási sorának kezelését nem engedélyezi a licenckulcs.',
    'maillist__' => "%1 levelezési lista",
    'maillist__already_exists' => "A levelezési lista már létezik.",
    'maillist__mail_alias_already_exists_in_this_domain' => "%1 e-mail alias már létezik e domainben",
    'maillists__' => "Levelezési listák %1",
    'maillists__limit_cl_max_maillists' => "Megtörtént az ügyfél levelezési lista szám korlátjának az elérése (korlát: %1, felhasználva: %2)",
    'maillists__limit_dom_max_maillists' => "Megtörtént a domain levelezési lista szám korlátjának az elérése.",
    'maillists__list' => "Levelezési listák",
    'maillists__mailman_not_installed_or_conf' => "\nA Mailman kiszolgáló bővítményeket nem telepítették vagy nem \nkonfigurálták a kiszolgálón. Kérje meg a kiszolgáló rendszergazdáját a Mailman kiszolgáló bővítmények telepítésére vagy megfelelő konfigurálására.",
    'maillists__status' => "Be van kapcsolva a levelezési lista szolgáltatás.",
    'maillists__unable_to_delete__' => "A levelezési lista törlése nem lehetséges: %1",
    'maillists__disabled_text' => 'Nem tudja kezelni levelezési listákat, mivel nincs telepítve vagy konfigurálva a Mailman levelezési lista kiszolgáló összetevő.',
    'maillist_member__already_exists' => 'A levelezési lista előfizető már létezik.',
    'maillist_member__not_exists' => 'A levelezési listának nincs ilyen tagja.',
    'mailserver_switching_warning' => "Figyelmeztetés!\n\nA levelezési kiszolgáló változtatását csak kezdeti beállításokra szánták, ha már használatban van a kiszolgáló, akkor a következő problémákat okozza: a postaláda tartalmak elvesztése, továbbá ha már konfigurálva van a másik kiszolgáló, akkor különböző ütközéseket.\nHa most használatban van a kiszolgáló és feltétlenül át akar egy másikra kapcsolni, akkor értesítheti az ügyfeleket erről a műveletről, hogy letölthessék és elmenthessék az e-mailjeiket.",
    'manager__access_denied' => "Hozzáférés letiltva: %1",
    'manager__admin' => "Adminisztrátor",
    'manager__client' => 'Ügyfél',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "Megtörtént a domainszám korlát elérése e felhasználói számla esetében.",
    'manager__domain_is_not_yours' => "%1 domain nem tartozik Önhöz.",
    'manager__domain_key_limit_exceeding' => "Megtörtént a licenckulcsában meghatározott domain létrehozási korlát elérése.",
    'manager__no_perm_to_call' => "Nem rendelkezik %1 hívási engedéllyel.",
    'manager__no_perm_to_create_domains' => "Nem rendelkezik domain létrehozási engedéllyel.",
    'manager__no_perm_to_modify_domain' => "Nem rendelkezik %1 domain módosítási engedéllyel.",
    'manager__no_perm_to_modify_domains' => "Nem rendelkezik domain módosítási engedéllyel.",
    'manager__no_perm_to_remove_domain' => "Nem rendelkezik %1 domain eltávolítási engedéllyel.",
    'manager__no_perm_to_remove_domains' => "Nem rendelkezik domain eltávolítási engedéllyel.",
    'manager__node_doesnt_exist' => "%1 nem létezik.",
    'manager__user_disabled' => "Fel van függesztve a számlája. Nem működtetheti a rendszert.",
    'mail_quota_unsupported' => "az e-mail kiszolgáló nem támogatja",
    'mbox_quota_unsupported' => "az e-mail kiszolgáló nem támogatja",
    'mn__create_title' => "Postafiók létrehozása",
    'mn__edit_title' => "Beállítások",
    'mn__files_list_title' => "Melléklet fájlok",
    'mn__files_remove' => "Távolítson el fájlokat a melléklet adattárból. Valószínűleg automatikus válaszok használják e fájlokat. Mind az adattárból, mind az azokat használó automatikus válaszokból eltávolításra kerülnek.",
    'mn__files_select_for_remove' => "Az eltávolítandó fájlok kiválasztása.",
    'mn__mail_alias_form' => "E-mail alias űrlap",
    'mn__mail_aliases_list' => "E-mail aliasok",
    'mn__mailbox' => "Postaláda kezelése",
    'mn__unable_define_mn' => "Nem lehetséges postafiók beállítása: %1",
    'mn__unable_remove_mbox_quota' => "Nem lehetséges postaláda kvóta eltávolítása. %1",
    'mn__upload_file' => "Fájl feltöltése",
    'mn_edit__attach_filename_changed' => 'Megtörtént %1 feltöltött fájl %2 névre átnevezése, mivel nem ASCII-karakterek is szerepeltek a névben.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Először tagokat kell adnia az e-mail csoporthoz, mielőtt engedélyezné azt.",
    'mn_edit__add_resp_or_turn_off_box' => "El kell végeznie automatikus válasz hozzáadását vagy törölnie kell az automatikus válasz jelölőnégyzet bejelölését.",
    'mn_edit__attachments' => "Mellékletek",
    'mn_edit__dom_quota_less_then_quota' => "Nem haladhatja meg a postaláda mérete, a postaládához e domainben rendelt lemezterület korlátot.",
    'mn_edit__enter_external_rcpnt_email' => "Külső levelezőcsoport tag e-mail címének beírása",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Írjon be egy e-mail címet az e-mail továbbításhoz vagy törölje a jelölőnégyzet bejelölését.",
    'mn_edit__ext_rcpnt_email_invalid' => "Érvénytelen a külső címzett e-mail címe.",
    'mn_edit__file_exists' => "Az fájlmár létezik. Felülírja?",
    'mn_edit__files_deld_from_repository' => "E fájlok törlésre kerülnek az adattárból és azon automatikus válaszokból, melyek tartalmazzák azokat. Akarja folytatni?",
    'mn_edit__mail_name' => "Postafiók",
    'mn_edit__mail_name_invalid' => "Érvénytelen a postafiók név.",
    'mn_edit__mail_redir' => "E-mail továbbítók",
    'mn_edit__mail_redir_add' => "Tag levelezőcsoporthoz adása",
    'mn_edit__mail_resps' => "Automatikus e-mail válaszok",
    'mn_edit__mailbox' => "Postaláda",
    'mn_edit__enable_mailbox' => "Postaláda",
    'mn_edit__mailgroup' => "Levelezési csoport",
    'mn_edit__mailgroup_addresses' => "Levelezőcsoport-tagok",
    'mn_edit__mailgroup_disabled' => "Kizárólag postafiók hozzáadása után áll rendelkezésre.",
    'mn_edit__max_dom_quota' => "A domain alapértelmezett értéke (%1)",
    'mn_edit__mbox_quota_invalid' => "Helytelen a postaláda kvóta.",
    'mn_edit__new_resp_name' => "Új automatikus válasz név",
    'mn_edit__no_autoresponders' => "Legalább egy automatikus válasz hozzáadását el kell végeznie, mielőtt be-/kikapcsolja az automatikus válasz szolgáltatást.",
    'mn_edit__no_file_sel' => "Nincsenek fájlok kijelölve.",
    'mn_edit__no_mail_addresses' => "Nincsenek e-mail címek megadva vagy kiválasztva.",
    'mn_edit__none' => "Nincs",
    'mn_edit__not_create_pass' => "Nem hoz létre jelszót e fiók számára.\nJelszó nélkül, a felhasználó nem lesz képes az elektronikus levelek elolvasására és küldésére.",
    'mn_edit__redir_email_invalid' => "Érvénytelen a továbbítási cím.",
    'mn_edit__redirect_addr' => "Továbbítási cím",
    'mn_edit__remove_autoresp?' => "Biztosan el akarja távolítani az automatikus választ?",
    'mn_edit__remove_rcpnts?' => "Biztosan el akarja távolítani e címzetteket?",
    'mn_edit__repository' => "Tároló",
    'mn_edit__resps_attach' => "Automatikus válasz melléklet fájlok",
    'mn_edit__select_rcpnt_from_list' => "Válasszon ki legalább egy címzettet a listáról az eltávolításhoz.",
    'mn_edit__select_registered_users' => "Regisztrált felhasználók kiválasztása",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Kiválasztott egy postaládát, de nem állított be jelszót a számára.",
    'mn_edit__unable_act_deact_mail_group' => "Nem lehetséges levelezőcsoport aktiválása vagy inaktiválása: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Nem lehetséges e-mail továbbítás aktiválása vagy inaktiválása: %1",
    'mn_edit__unable_act_deact_postbox' => "Nem lehetséges postaláda aktiválása vagy inaktiválása: %1",
    'mn_edit__unable_act_deact_resp' => "Nem lehetséges automatikus válaszok aktiválása vagy inaktiválása: %1",
    'mn_edit__unable_add_attach' => "Melléklet fájl hozzáadása nem lehetséges: %1",
    'mn_edit__unable_add_mail_group_member' => "Levelezőcsoport-tagok hozzáadása nem lehetséges: %1",
    'mn_edit__unable_add_resp' => "Nem lehetséges automatikus válasz hozzáadása: %1",
    'mn_edit__unable_change_mail_name' => "Nem lehetséges postafiók név változtatása: %1",
    'mn_edit__unable_deactivate_mail_group' => "Levelezési csoport inaktiválása nem lehetséges: %1",
    'mn_edit__unable_deactivate_resp' => "Nem lehetséges automatikus válaszok inaktiválása: %1",
    'mn_edit__unable_define_resp_id' => "Nem lehetséges automatikus válasz azonosító meghatározása: %1",
    'mn_edit__unable_remove_attach' => "Melléklet fájl(ok) eltávolítása nem lehetséges: %1",
    'mn_edit__unable_remove_autoresp' => "Nem lehetséges automatikus válasz eltávolítása: %1",
    'mn_edit__unable_remove_mail_group_member' => "Levelezőcsoport-tagok eltávolítása nem lehetséges: %1",
    'mn_edit__wrong_way' => 'Nem történik meg az üzenetek %1 címre kézbesítése, mivel nem rendelkezik postaládával a postafiók vagy nincs bekapcsolva az e-mail továbbító.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Ki van kapcsolva %1 címen található postaláda. Nem történt meg a postaládában lévő üzenetek eltávolítása , azonban nem olvashatja be azokat IMAP- vagy POP3-protokoll használatával.',
    'mn_list__mail_names_for_domain' => "%1 domain postafiókjai",
    'mn_list__sa_cannot_unable' => "Nem lehetséges a levélszemét szűrés bekapcsolása.",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Ügyfél',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Név",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Nem lehetséges a postafiókok eltávolítása. %1",
    'module_upload__module_was_installed' => 'E modul már telepítve van. Ha egy újabb verziót akar telepíteni, akkor a Plesk segítségével végezze el az eltávolítását, majd próbálja meg a telepíteni.',
    'module_upload__unable_to_install' => 'Nem lehetséges a modul csomagfájl telepítése',
    'module_upload__wrong_package' => 'Nem egy támogatott modulcsomag a feltöltött fájl.',
    'module_upload__wrong_module' => 'Nem tartalmaz modulcsomagot a feltöltött fájl.',

    'news_articles_title' => 'Plesk hírek',
    'notification_text__invalid_subject_length' => "Érvénytelen értesítési tárgy hossz. 1 és 255 karakter között kell lennie.",
    'notification_text__invalid_text_length' => "Érvénytelen értesítési szöveg hossz. 1 és 65533 karakter között kell lennie.",
    'notification_text__subject' => "Értesítés tárgya",
    'notification_text__text' => "Értesítési szöveg",
    'notification_text__title' => "Értesítés szerkesztése",
    'notification_text__unable_set_text' => "Értesítési szöveg szerkesztése nem lehetséges:",

    'odbc__cant_add_dsn' => "%1 adatforrásnév hozzáadása nem lehetséges: %2",
    'odbc__cant_connect' => "A kapcsolódás az adatforráshoz a megadott paraméterekkel nem lehetséges. A kiszolgáló a következő üzenetet küldte: %1",
    'odbc__cant_delete_dsn' => "%1 adatforrásnév törlése nem lehetséges: %2",
    'odbc__cant_get_drivers_info' => "Nem elérhetők a illesztőprogramokra vonatkozó információk.",
    'odbc__cant_get_drivers' => "Az ODBC-illesztőprogramok listájának betöltése nem lehetséges: %1",
    'odbc__cant_open_info_file' => "Nem lehetséges ODBC-illesztőprogram adatokkal megnyitni a fájlt.",
    'odbc__cant_parse_string' => "Nem lehetséges a kapcsolati karakterlánc elemzése.",
    'odbc__driver_not_set' => "Nincs beállítva az illesztőprogram",
    'odbc__driver_or_name_not_set' => "Nincs megadva az illeszőprogram vagy az ODBC kapcsolat neve",
    'odbc__dsn_already_exists' => "Adatforrásnév ezzel a névvel (%1) már létezik a rendszerben",
    'odbc__dsn_not_exists' => "Ezen adatforrásnév nem létezik",
    'odbc__enter_dsn_name' => "Írja be az adatforrásnevet",
    'odbc__invalid_dsn_name' => "A megadott ODBC-kapcsolatnév szintaktikailag hibás (%1): csak alfanumerikus karaktereket használjon.",
    'odbc__no_such_driver' => "Nem támogatott egy ilyen nevű (%1) ODBC-illesztőprogram.",
    'odbc__unknown_driver' => "Ismeretlen illesztőprogram név (%1).",
    'odbc_dsn_system' => "Rendszer adatforrásnév",

    'pb__aliases' => "Aliasok",
    'pb__anonftp' => "Névtelen FTP",
    'pb__autoinstaller_releases' => 'Frissítő',
    'pb__cert' => "Tanúsítványok",
    'pb__cl_pool' => "IP-címek",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Beállítások",
    'pb__cl_rpt' => "Jelentés",
    'pb__cl_rpt_list' => "Testreszabás",
    'pb__cl_templates' => "Ügyfélsablonok",
    'pb__cl_traffic' => "Forgalom",
    'pb__cl_traffic_history' => "Forgalmi kimutatás",
    'pb__cl_traffic_of' => "%1 forgalma",
    'pb__client' => "%1",
    'pb__clients' => "Ügyfelek",
    'pb__comp_info' => "Kiszolgáló összetevői",
    'pb__common_acl' => 'Letöltést engedélyező hozzáférés-vezérlési lista',
    'pb__cp_access' => "Hozzáférés",
    'pb__crontab' => "Ütemező",
    'pb__scheduler' => "Ütemező",
    'pb__custom_buttons' => "Egyéni gombok",
    'pb__databases_db' => 'Adatbázisok',
    'pb__sqlservers_db' => 'SQL-kiszolgálók', //to check
    'pb__db' => "Adatbázisok",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Adatbázis-kiszolgálók',
    'pb__dl_usr_ed' => "Domain adminisztrátor",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domain korlátok",
    'pb__dom_pref' => "Beállítások",
    'pb__dom_sum_report' => "Domain összesítő jelentés",
    'pb__dom_templates' => "Domainsablonok",
    'pb__dom_traffic' => "%1 forgalma",
    'pb__domains' => "Domainek",
    'pb__domain_aliases' => 'Domain aliasok',
    'pb__dumps_list' => "Biztonsági másolat fájl tároló",
    'pb__forwarding_setup' => "Továbbítási beállítások",
    'pb__filemanager' => "Fájlkezelő",
    'pb__ip_aliasing' => "IP-címek",
    'pb__ip_clients' => "IP-címek eltávolítása",
    'pb__license_management' => 'Licencinformációk',
    'pb__locales' => 'Területi beállítások',
    'pb__log_files' => "Naplófájlok",
    'pb__mail' => 'E-mail',
    'pb__mail_name_files' => "Melléklet fájlok",
    'pb__mail_name_redirects' => "E-mail továbbítók",
    'pb__mail_name_resp_attach_add' => "Új melléklet",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Automatikus e-mail válaszok",
    'pb__mail_names' => "E-mail",
    'pb__maillists' => "Levelezési listák",
    'pb__modules' => 'Modulok',
    'pb__modules_management' => 'Modulok kezelése',
    'pb__notifications' => "Értesítések",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "A fizikai üzemeltetés beállítása",
    'pb__prtd_dirs' => "Védett könyvtárak",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Testreszabás",
    'pb__server' => "Kiszolgáló",
    'pb__sessions' => "Munkamenetek",
    'pb__sapp_pool' => "Webalkalmazás készlet",
    'pb__siteapp_install' => 'Webalkalmazás telepítése',
    'pb__site_app_pkgs' => 'Webalkalmazások',
    'pb__site_apps' => "Webalkalmazások",
    'pb__additional_key_info' => 'Kulcs tulajdonságok',
    'pb__additional_key_properties' => 'Kulcs tulajdonságok',
    'pb__skins' => 'Felszínek',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Levélszemét szűrő",
    'pb__statistics' => "Statisztikák",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Aldomainek",
    'pb__templates' => "Sablonok",
    'pb__virtualdirs' => 'Virtuális könyvtárak',
    'pb__web_users' => "Webes felhasználók",
    'pdir__invalid_hst' => "Az üzemeltetési típus érvénytelen. Fizikainak kell lennie.",
    'pdir__pd_id_is_undefined' => "Nincs meghatározva a védett könyvtár azonosítója.",
    'pdir__pdir_exist' => "Az ilyen nevű könyvtár már védett.",
    'pdir__pdir_not_exist' => "Védett könyvtár nem létezik.",
    'pdir__pdir_usr_not_exist' => "A védett könyvtárhoz rendelt felhasználó nem létezik.",
    'pdir__remove_pdir_usrs' => "%1 webhelyen eltávolításra kerülnek %2 védett könyvtár következő felhasználói:",
    'pdir__remove_pdir_usrs_on_subdom' => "Eltávolításra kerülnek %1 aldomain %2 védett könyvtárának következő felhasználói:",
    'pdir__select_pdir_usrs_for_remove' => "Válassza ki a védett könyvtár eltávolítandó felhasználóit.",
    'pdir__select_pdirs_to_remove' => "Válassza ki a könyvtárakat, amelyekről a védelmet el kívánja távolítani.",
    'pdir__unable_define_pdir_users' => "A védett könyvtár felhasználóinak meghatározása nem lehetséges.",
    'pdir__unable_define_pdirs_properties' => "Nem lehetséges a védett könyvtárak tulajdonságainak a beállítása: %1",
    'pdir__unable_select_dom_param' => "A domain paramétereinek kiválasztása nem lehetséges: %1",
    'pdir_ed__dir_already_protect' => "Ez a könyvtár már védett.",
    'pdir_ed__invalid_login' => "Helytelen felhasználónevet adott meg.",
    'pdir_ed__login_exists' => "E felhasználó már létezik. Próbáljon másik felhasználónevet megadni.",
    'pdir_ed__pdir_users' => "Védett könyvtár használók",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Az SSL/TLS és nem SSL/TLS jelölőnégyzetek közül legalább az egyiket be kell jelölnie.",
    'pdir_ed__unable_cr_pdir_usr' => "A védett könyvtár felhasználójának létrehozása nem lehetséges: %1",
    'pdir_ed__unable_create_pdir' => "A védett könyvtár létrehozása nem lehetséges: %1",
    'pdir_ed__unable_define_hst_type' => "A üzemeltetési típus meghatározása nem lehetséges.",
    'pdir_ed__unable_update_pdir' => "Nem lehetséges a védett könyvtár beállításainak a mentése: %1",
    'pdir_ed__wrong_symbol_in_header' => "Ne használjon %1 karaktert a könyvtár nevében.",
    'pdir_usr_ed__not_create_pass' => "E művelet nem fog jelszót létrehozni a védett könyvtár új felhasználója számára.\nJelszó nélkül pedig a felhasználó nem tud majd bejelentkezni.",
    'pdir_usr_ed__unable_select_pdir_usr' => "A védett könyvtár felhasználójának kiválasztása nem lehetséges: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "A védett könyvtár felhasználóinak meghatározása nem lehetséges: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "A védett könyvtár felhasználóinak eltávolítása nem lehetséges: %1",
    'phosting__anonftp_encrypt' => 'Titkosított az FTP-felhasználó jelszava, ezért nem használható /plesk-stat/webstat/ könyvtár védelmére. Írja be újból az FTP-jelszavát vagy törölje a "\'/plesk-stat/webstat/\' jelszóval védett könyvtáron keresztül érhető el" beállítás kijelölését.',
    'phosting__hosting_and_dns_ip_difference_warning' => "%%domain_name%% domain név kiterjed %%dns_ip_address%% IP-címre is. %%hosting_ip_address%% IP-cím van a webhelyéhez rendelve. Ha nem nyílik meg a webhelye egy webböngészőben, amikor domain nevével hivatkozik rá, akkor ugorjon a DNS-kezelő képernyőre (Domainek > Domain név > DNS) és változtassa meg A erőforrásrekord tulajdonságait: rendelje %%hosting_ip_address%% IP-címet a megfelelő %%domain_name%% domain névhez.",
    'phosting__ip_change_warning' => "Megtörtént IP-cím megváltoztatása. A domain DNS-zónájában is történt a megfelelő változtatások elvégzése.",
    'phosting__other_hosting_exists_on_ip' => "Nem lehetséges a tanúsítvány megváltoztatása, mivel egy vagy több üzemeltetési számlában ezen IP-cím használatban van.",
    'phosting__unable_to_change_certificate' => "A tanúsítvány telepítése nem lehetséges: %1",
    'phosting__unable_to_change_ip_address' => "Nem lehetséges az IP-cím megváltoztatása: %1",
    'phosting__unable_to_set_cert' => "Nem lehetséges az SSL/TLS-tanúsítvány beállítása: %1",
    'phosting__unable_update' => "Nem lehetséges az üzemeltetési beállítások frissítése: %1",
    'phosting__unable_manage' => "A üzemeltetés kezelése nem lehetséges: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Nem konfigurálhat a Fail2ban szoftver a domain naplók követésére. A Fail2ban szolgáltatás következő újraindítása után automatikusan történik a naplók követése.\n%1",

    'picker_acl_record__tittle' => 'ACL-rekord kiválasztása',
    'picker_autoresponder__title' => 'Automatikus válasz kiválasztása',
    'picker_black_list__domain_name' => 'Domain név kiválasztása',
    'picker_certificate' => 'SSL/TLS-tanúsítvány kiválasztása',

    'picker_dns_zone_template__title' => 'Erőforrásrekord kiválasztása',
    'picker_domain__title' => 'Webhely kiválasztása',
    'picker_domain_alias__title' => 'Domain alias kiválasztása',
    'picker_resource_record__title' => 'Erőforrásrekord kiválasztása',
    'picker_disabled_resource_record__title' => 'Névkiszolgáló kiválasztása',
    'picker_ip_address__title' => 'IP-cím kiválasztása',
    'picker_ip_address_clients__title' => 'Ezen IP-címet használó ügyfelek kiválasztása',
    'picker_mail_queue' => 'E-mail üzenetek kiválasztása',
    'picker_site_application__title' => 'Webalkalmazás kiválasztása',
    'picker_subdomain__title' => 'Aldomain kiválasztása',
    'picker_web_user__title' => 'Webes felhasználó kiválasztása',
    'picker_custom_button__title' => 'Egyéni gomb kiválasztása',
    'picker_license_key__title' => "Licenckulcs kiválasztása",
    'picker_spamfilter_address__title' => 'Levélszemét szűrő cím kiválasztása',
    'picker_white_list__networks' => 'Hálózatok kiválasztása',

    'plesk_key__action_logs' => "Plesk felhasználók által végzett műveletnaplózás",
    'plesk_key__app_vault' => "Alkalmazástároló",
    'plesk_key__backup' => "Műveletek biztonsági mentése és visszaállítása",
    'plesk_key__client_templs' => "Szolgáltatási csomagok kezelése",
    'plesk_key__clients' => "Felhasználói számlák (viszonteladók és ügyfelek)",
    'plesk_key__resellers_only' => "Felhasználói számlák (viszonteladók)",
    'plesk_key__customers_only' => "Felhasználói számlák (ügyfelek)",
    'plesk_key__domains' => "Domainek",
    'plesk_key__domain_aliases' => "Domain aliasok",
    'plesk_key__subdomains_limit' => "Aldomainek",
    'plesk_key__databases' => "Adatbázisok",
    'plesk_key__mssql_databases' => "MS SQL-adatbázisok",
    'plesk_key__manage_dashboard' => 'Honlap testreszabása',
    'plesk_key__drweb' => "Vírusvédelem kezelése",
    'plesk_key__event_manager' => "Eseménykezelő",
    'plesk_key__expirations' => "Számla lejárati dátumok kezelése",
    'plesk_key__group_ops' => "Több objektum egyidejű kezelése",
    'plesk_key__expiration' => "Kulcs lejárati dátuma",
    'plesk_key__edition_name' => "Plesk kiadása",
    'plesk_key__key_number' => "Kulcsszám",
    'plesk_key__languages' => "Nyelvi csomagok",
    'plesk_key__mailnames' => "Postafiókok",
    'plesk_key__migration_manager' => "Áttelepítés és átvitel kezelő",
    'plesk_key__mssql' => "Microsoft SQL-kiszolgáló támogatása",
    'plesk_key__myplesk_func' => "SSL/TLS-tanúsítvány vásárlási és domain regisztrációs szolgáltatás hivatkozások",
    'plesk_key__myplesk_server_id' => "MPC alárendelt kiszolgáló azonosítója",
    'plesk_key__notifications' => "Értesítések kezelése",
    'plesk_key__postgresql' => "PostgreSQL adatbázis-kiszolgáló támogatása",
    'plesk_key__qmail_queue' => 'Levelezési várólista kezelése',
    'plesk_key__remote_db' => 'Távoli adatbázis üzemeltetés',
    'plesk_key__slave_servers' => "Szolga kiszolgálók",
    'plesk_key__spamassassin' => "Levélszemét szűrő kezelése",
    'plesk_key__subdomains' => "Aldomainek kezelése.",
    'plesk_key__sys_access' => "Kiszolgálóhoz hozzáférés kezelése",
    'plesk_key__traffic_reports' => "Forgalmi kihasználtsági jelentések",
    'plesk_key__tts' => "Ügyfélszolgálat",
    'plesk_key__virtuozzo' => "Kizárólag Virtuozzo konténerek esetében érvényes.",
    'plesk_key__webusers' => "Webes felhasználók",
    'plesk_key__cpu_cores' => 'CPU magok száma',
    'plesk_key__ram' => 'Memória',
    'plesk_key__license_update_date' => 'Következő licenclulcs frissítés',
    'plesk_key__autoinstaller_config' => 'Frissítő beállítások kezelése',
    'plesk_key__check_wrong' => "Érvénytelen a licenckulcs. A Plesk használatához szerezzen be és telepítsen egy érvényes licenckulcsot.",
    'plesk_key__upload_check_wrong' => 'Érvénytelen a feltöltött licenckulcs.',
    'plesk_key__revert_check_wrong' => 'Érvénytelen az előzőleg telepített licenckulcs.',
    'plesk_key__viruozzo_only_key' => 'E licenckulcsot kizárólag Virtuozzo konténerekbe telepített Plesk kezelőpanellel történő használatra szánták.',
    'plesk_key__ip_ranges_exceeded' => 'Kizárólag a következő IP-címekkel használhatja e licencelt Plesk példányt: %2. A következő IP-címekre nem terjed ki a licence: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'A jelenleg felhasznált erőforrások mennyisége túllépi a licencében meghatározott korlátokat.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe kezelőfelület',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'A kiszolgálón üzemeltetett webhelyek száma meghaladja a licence által megszabott korlátot. %2 webhelyet üzemeltet, a licence viszont csak %1 webhely üzemeltetését engedélyezi.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'A kiszolgálón üzemeltetett domain aliasok száma meghaladja a licence által megszabott korlátot. %2 domain aliasa áll a rendelkezésére, a licence viszont csak %1 domain alias használatát engedélyezi.',
    'plesk_key__limits_exceeded_lim-subdom' => 'A kiszolgálón található aldomainek száma túllépi a licenckorlátját. %2 aldomainnel rendelkezik; azonban csupán %1 aldomain üzemeltetését engedélyez a licence.',
    'plesk_key__limits_exceeded_lim-db' => 'A kiszolgálón található adatbázisok száma túllépi a licenckorlátját. %2 adatbázissal rendelkezik; azonban csupán %1 adatbázis üzemeltetését engedélyez a licence.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'A kiszolgálón található MS SQL adatbázisok száma túllépi a licenckorlátját. %2 adatbázissal rendelkezik; azonban csupán %1 adatbázis üzemeltetését engedélyez a licence.',
    'plesk_key__limits_exceeded_lim_cl' => 'A kiszolgált ügyfélfiókok száma meghaladja a licence által megszabott korlátot. Ön jelenleg %2 ügyfélszámlát szolgál ki, a licence viszont csak %1 ügyfélszámla kiszolgálást engedélyezi.',
    'plesk_key__limits_exceeded_lim_mn' => 'A kiszolgált e-mail fiókok száma meghaladja a licence által megszabott korlátot. Ön jelenleg %2 e-mail fiókot szolgál ki, a licence viszont csak %1 e-mail fiók kiszolgálást engedélyezi.',
    'plesk_key__limits_exceeded_lim_wu' => 'A kiszolgált webes felhasználói fiókok száma meghaladja a licenc által megszabott korlátot. Jelenleg %2 webes felhasználói fiókot szolgál ki, a licenc viszont csak %1 webes felhasználói fiók kiszolgálást engedélyezi.',
    'plesk_key__limits_exceeded_MLS' => 'A jelenleg telepített nyelvi csomagok száma meghaladja a licence által megszabott korlátot. %2 nyelvi csomag van telepítve, a licence viszont csak %1 nyelvi csomag telepítését engedélyezi.',
    'plesk_key__wrong_version' => 'Egy másik Plesk verzióhoz létrehozott licenckulcsot próbál használni. Forduljon a Plesk értékesítési képviselőihez a megfelelő licenckulcs beszerzése érdekében.',
    'plesk_key__other_product' => 'Egy másik termékhez létrehozott licenckulcsot próbál használni. Forduljon a Plesk értékesítési képviselőihez a megfelelő licenckulcs beszerzése érdekében.',
    'plesk_key__invalid_machine_id_trial' => 'Nem érvényes a jelenlegi licence, mivel egy másik Plesk kiszolgálón már aktiválva van. A Plesk kiszolgáló használatának a folytatásához telepítsen egy új licencet, vagy az aktiválási kódja (ha rendelkezik vele) beírásával telepítse újra a jelenlegi licencét.',
    'plesk_key__invalid_machine_id_retail' => 'Nem érvényes a jelenlegi licence, mivel egy másik Plesk kiszolgálón már aktiválva van. The WebPros Végfelhasználói licencszerződés (https://www.plesk.com/legal/) tiltja egy licenc két vagy több kiszolgálón való egyidejű használatát. A Plesk kiszolgáló használatának a folytatásához telepítsen egy új licencet, vagy az aktiválási kódja (ha rendelkezik vele) beírásával telepítse újra a jelenlegi licencét. Amikor megvásárolta a licencet, akkor e-mailben elküldtük a számára. <br>Nem találja az aktiválási kódot? A Plesk 360 felhőszolgáltatás igénybevételével lekérdezheti azt. Ehhez a vásárláskor használt e-mail cím használatával jelentkezzen be a https://platform360.io/ című webhelyre, ugorjon a „Licencek” lapra, majd nézze meg a licence aktiválási kódját. Vagy az online űrlap (https://www.plesk.com/licensing-and-purchase-support/) használatával kapcsolatba léphet a Plesk Licencelési és vásárlási részlegével. Ne feledkezzen meg beírni a licencszámát az űrlap „Hogyan segíthetek” című részébe.',
    'plesk_key__limits_exceeded_error' => 'Nem lehetséges a licenckulcs telepítése: a jelenleg használt erőforrások mennyisége meghaladja a feltöltött licenckulcsban meghatározott korlátokat.',
    'plesk_key__limits_exceeded_note' => 'A jelenleg használt erőforrások mennyisége meghaladja a feltöltött licenckulcsban meghatározott korlátokat.',
    'plesk_key__hardware_limits_exceeded' => 'E hardver konfiguráció túllépi a Plesk licencében meghatározott korlátokat.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => '%1 telepített memóriával rendelkezik a kiszolgáló, de a licence maximum %2 memóriát engedélyez.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => '%1 CPU maggal rendelkezik a kiszolgáló, de a licence maximum %2 számú magot engedélyez.',
    'plesk_key__key_file_invalid' => 'A betöltött kulcsfájlérvénytelen vagy nem tartalmazza a licenckulcsot.',
    'plesk_key__server_request_error' => 'Nem frissíthető a licenc. Ellenőrizze a TCP-port %1 esetében nincsenek-e blokkolva a ka.plesk.com licenckiszolgáló kapcsolatai. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Tekintse meg a menetét</a>.',
    'key__no_key_file_in_zip' => 'A feltöltött .zip fájl nem tartalmazza kulcsfájlt',
    'key__key_upload' => 'Licenckulcs telepítése',
    'additional_key__prop_name' => 'Tulajdonság',
    'additional_key__prop_value' => 'Érték',
    'additional_key__descr_name' => 'Kulcsnév',
    'additional_key__descr_key_number' => 'Kulcsszám',
    'additional_key__descr_key_vz' => "E licenckulcsot kizárólag Virtuozzo konténerekben történő használatra szánták.",
    'additional_key__descr_key_mailboxes' => 'Postaládák',
    'additional_key__descr_lim_date' => 'Lejárati dátum',
    'additional_key__descr_license_update_date' => 'Következő licenclulcs frissítés',
    'additional_key__file_invalid' => 'A betöltött kulcsfájlérvénytelen vagy nem tartalmazza a licenckulcsot.',
    'additional_key__file_incompatible' => 'A feltöltött kulcsfájl nem felel meg ezen alkalmazáshoz.',
    'additional_key__not_exists' => 'Nincs licenckulcs telepítve.',
    'additional_key_update__result_response' => 'Linceckiszolgáló válasza: %1',
    'additional_key_update__result_network' => 'Nem lehetséges a licenckiszolgálóhoz a kapcsolódás. Ellenőrizze, hogy a hálózaton engedélyezett a kommunikáció %1:%2 irányába.',
    'additional_key_update__result_lock' => 'Kulcsfrissítés már folyamatban',
    'additional_key_update__result_internal_error' => 'Hiba lépett fel a licenckulcs frissítésénél: %1',

    'proceed_to_cl_pool' => "Folytassa az ügyfél IP-cím készletének a konfigurálását.",
    'proceed_to_hosting_setup' => "Folytatás az üzemeltetés beállításával",
    'removeCerts__remove_certificates_cp' => "A következő tanúsítványok kerülnek eltávolításra:",
    'removeCerts__remove_certificates_domain' => "%1 tanúsítványai közül a következők kerülnek eltávolításra:",
    'removeClientsIP_remove_clients_ip' => "Ezen IP-cím eltávolításra kerül a következő ügyfelek készleteiből:",
    'removeMailAliases__remove_mail_aliases' => "%1 postafiók következő e-mail aliasai kerülnek eltávolításra:",
    'removeMailNames__remove_mailnames' => "%1 domain következő postafiókjai és e-mail aliasai kerülnek eltávolításra :",
    'removeMailNames__remove_mailnames_of_cl' => "%1 ügyfél %2 domainjének következő postafiókjai és e-mail aliasai kerülnek eltávolításra:",
    'removeMailNames__these_mailnames_will_not_delete' => "Megtörtént e postafiók eltávolítása.",
    'removeFtpSessions__remove_title' => "A következő FTP-munkamenetek kerülnek megszakításra:",
    'removeTemplates__remove_templates' => "A következő sablonok kerülnek eltávolításra:",
    'resp_edit__always_respond' => "mindig válaszol",
    'resp_edit__reply_subject' => "Válasz tárgya",
    'resp_edit__answer_subject' => "Válasz tárggyal együtt",
    'resp_edit__answer_txt' => "A válasz szövege",
    'resp_edit__attach' => "Fájlok mellékelése",
    'resp_edit__default_subject' => "Vál.: %1",
    'resp_edit__for' => "számára",
    'resp_edit__frw_rqst_email' => "Automatikus válasz esetén a megadott e-mail címre továbbítsa az eredeti üzenetet.",
    'resp_edit__fwd_email_invalid' => "Érvénytelen a cél e-mail cím.",
    'resp_edit__in_body' => "ha az üzenettörzsben találhatóak a megadott szavak",
    'resp_edit__in_subject' => "amikor a megadott szavak megtalálhatóak az üzenet tárgyában",
    'resp_edit__invalid_resp_freq' => "A megadott válaszadási gyakoriság érvénytelen.",
    'resp_edit__invalid_rqst_txt' => "A megadott lekérési szöveg érvénytelen.",
    'resp_edit__invalid_store_lim_num' => "A megadott határérték érvénytelen.",
    'resp_edit__limits_title' => "Korlátok",
    'resp_edit__maximum_allowed_resp_freq_reached' => "A napi válaszok száma meghaladja az egy napra engedélyezett értéket. Engedélyezett: %1, igényelt: %2",
    'resp_edit__no_files_sel' => "Nincsenek fájlok kijelölve.",
    'resp_edit__no_txt_supplied' => "Nincs szöveg megadva.",
    'resp_edit__reply_title' => "Válasz",
    'resp_edit__reply_to_address' => "Válaszcím",
    'resp_edit__reply_to_invalid' => "A megadott válaszcím érvénytelen.",
    'resp_edit__reply_uniq_email' => "Nem több, mint a következő számú egyedi e-mail címre válaszoljon;",
    'resp_edit__conditions_title' => "Feltételek",
    'resp_edit__request_title' => "Kérés",
    'resp_edit__resp' => "Automatikus válasz",
    'resp_edit__resp_name' => "Automatikus válasz név",
    'resp_edit__resp_not_exist' => "Nem létezik automatikus válasz.",
    'resp_edit__resp_status' => "Automatikus válasz állapota",
    'resp_edit__rqst_txt' => 'Automatikus válaszadás feltételének meghatározása',
    'resp_edit__select_files_on_server_for_attach' => "Mellékelendő fájlok megadása",
    'resp_edit__store_up_to' => "Eltárolás egészen",
    'resp_edit__subj_line_invalid' => "A tárgy mező megadott szövege érvénytelen.",
    'resp_edit__text_too_big' => "A válasz megadott szövege túl nagy.",
    'resp_edit__times_in_a_day' => "alkalommal naponta.",
    'resp_edit__unable_define_resp_cond' => "Nem lehetséges automatikus válasz állapotának meghatározása: %1",
    'resp_edit__unable_define_resp_status' => "Nem lehetséges automatikus válasz állapotának a meghatározása: %1",
    'resp_edit__unable_turn_on_resp' => "Nem lehetséges automatikus válasz bekapcsolása: %1",
    'resp_edit__uniq_email' => "egyedi e-mail címek",
    'resp_edit__content_type' => 'Levélküldési formátum',
    'resp_edit__content_type_text' => 'Egyszerű szöveg',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kódolás',
    'restart__dns' => 'DNS-kiszolgáló (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 kiszolgáló (%1)",
    'restart__mssql' => "Microsoft SQL-kiszolgáló",
    'restart__mysql' => "MariaDB/MySQL kiszolgáló",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Szolgáltatások",
    'restart__smtp' => "SMTP-kiszolgáló (%1)",
    'restart__spamd' => "Levélszemét szűrő",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel alkalmazás",
    'restart__web' => "Webkiszolgáló (%1)",
    'restart__ftp' => "FTP-kiszolgáló (%1)",
    'restart__service_start' => 'Engedélyezze egy időre a szolgáltatás számára az indítását.',
    'restart__service_stop' => 'Engedélyezze egy időre a szolgáltatás számára a leállítást.',
    'restart__service_restart' => 'Engedélyezze egy időre a szolgáltatás számára az újraindítást.',
    'rm_domains__some_domains_are_not_exist' => "Nem létezik néhány megadott domain. Lehetséges, hogy egy másik felhasználó eltávolította.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Lev.csop",
    'rpt_cl_dom_mail_lists' => "Lev. lista",
    'rpt_cl_dom_mail_resps' => "Aut. vál.",
    'rpt_cl_dom_mail_antispam' => "Levélszemét elleni védelem",
    'rpt_cl_dom_mail_antivirus' => "Vírusvédelem",
    'rpt_cl_dom_postboxes' => "Postal",
    'rpt_cl_dom_redirects' => "Továbbítók",
    'rpt_cl_dom_subdomains' => "Aldomain",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "Webes felh",
    'rpt_cl_report_for_admin__' => "%1 adminisztrátor számára készült jelentés",
    'rpt_cl_report_for_reseller__' => "%1 viszonteladó számára készült jelentés",
    'rpt_cl_report_for_cl__' => "%1 ügyfélről szóló jelentés",
    'rpt_cl_section_domains' => "Domainek",
    'rpt_cl_section_full_domains' => "Domainek",
    'rpt_cl_section_general' => "Általános",
    'rpt_create' => "Jelentés létrehozása",
    'rpt_empty' => "Legalább egy szakaszt tartalmaznia kell a jelentésnek",
    'rpt_dom_report_for_dom__' => "%1 domain jelentés",
    'rpt_dom_section_databases' => "Adatbázisok",
    'rpt_dom_section_full_databases' => "Adatbázisok",
    'rpt_dom_section_full_maillists' => "Levelezési listák",
    'rpt_dom_section_full_mailnames' => "Postafiókok",
    'rpt_dom_section_full_webusers' => "Webes felhasználók",
    'rpt_dom_section_full_siteapps' => 'Webalkalmazások',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET webalkalmazások',
    'rpt_dom_section_general' => "Általános",
    'rpt_dom_section_hosting' => "Üzemeltetés",
    'rpt_dom_section_maillists' => "Levelezési listák",
    'rpt_dom_section_mailnames' => "Postafiókok",
    'rpt_dom_section_siteapps' => 'Webalkalmazások',
    'rpt_dom_section_aspnetapps' => 'ASP.NET webalkalmazások',
    'rpt_dom_section_webusers' => "Webes felhasználók",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "%1 jelentés szerkesztése",
    'rpt_enter_email_address' => "Írja be azon e-mail címet, melyre a jelentést kézbesíteni kell.",
    'rpt_list' => "Egyedi jelentés elrendezések",
    'rpt_section_full' => "Teljes",
    'rpt_section_none' => "Nincs",
    'rpt_section_summary' => "Összesítő",
    'rpt_default_full' => 'Teljes jelentés',
    'rpt_default_summary' => 'Összesítő jelentés',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Hiba lépett fel a jelentés küldése során: %1",
    'rpt_send_report_by_email_ok__' => "Megtörtént %1 helyre a jelentés elküldése.",
    'sa_action' => "Művelet",
    'sa_action_del' => "Törlés",
    'sa_action_desc' => "A levélszemétnek minősített üzenetek kezelése",
    'sa_action_save' => "Levélszemétként megjelölés és postaládában tárolás",
    'sa_admin_blacklist' => "Adminisztrátor tiltólista",
    'sa_admin_whitelist' => "Adminisztrátor engedélyezési lista",
    'sa_db_del_confirm' => "Biztosan törölni akarja a Levélszemét szűrő adatbázisát?",
    'sa_eml_in_ignorelist' => "Szerepel a mellőzési listán az e-mail.",
    'sa_empty_email' => "Nem végezhető el üres e-mail minták hozzáadása.",
    'sa_exists_email' => "Ilyen e-mail minta már létezik.",
    'sa_disabled__mailname_not_filtering' => "A kiszolgáló jelenlegi beállításai nem teszik lehetővé e postafiók esetében a levelek szűrését.",
    'sa_disabled__filtering_is_disabled' => 'A kiszolgáló adminisztrátor kikapcsolta a levélszemét szűrést.',
    'sa_disabled__hasnt_mailbox' => "Postaláda nélkül nem lehetséges a levélszemét szűrés bekapcsolása.",
    'sa_enable_filter' => "Levélszemét szűrés bekapcsolása",
    'sa_forget' => "elfelejtés",
    'sa_from' => "Kezdet",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Érvénytelen a minta.",
    'sa_spam' => "levélszemét",
    'sa_trainer__page_title' => 'Levélszrő betanítása',
    'sa_trainer__tools_legend' => 'Eszközök',
    'sa_trainer__info_legend' => 'Információ',
    'sa_trainer__messages_list_legend' => 'Postaládájában lévő üzenetek',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Tárgy',
    'sa_trainer__from' => 'Kezdet',
    'sa_trainer__date' => 'Dátum',
    'sa_trainer__info_text' => 'Betanult üzenetek: %1 levélszemét, %2 nem levélszemét, %3 összesen.',
    'sa_trainer__messages' => 'üzenet(ek)',
    'sa_trainer__select__all' => 'Az összes',
    'sa_trainer__select__spam_only' => 'Levélszemét',
    'sa_trainer__select__ham_only' => 'Nem levélszemét',
    'sa_trainer__select__unknown_only' => 'Ismeretlen',
    'sa_trainer__cannot_remove_messages' => 'Nem lehetséges a kijelölt üzenetek eltávolítása a postaládából.',
    'sa_trainer__remove_messages_confirm' => 'Biztosan el akarja távolítani a kijelölt üzeneteket a postaládából?',
    'sa_subj' => "Tárgy",
    'sa_training' => "Levélszrő betanítása",
    'sa_training_legend' => "Bayesian szűrő betanítása",
    'sa_use_srv_settings' => "Egész kiszolgálóra érvényes beállítások használata",
    'sa_user_blacklist' => "Felhasználói feketelista",
    'sa_user_whitelist' => "Felhasználói engedélyezési lista",
    'sa_usr_disabled_by_srv' => "NEM engedélyezi a kiszolgáló adminisztrátor az egyéni levélszemét szűrési beállítások használatát.",
    'sa_usr_no_postbox' => "Nem engedélyezhető levélszemétszűrés, mivel ki van kapcsolva e fiók postaládája.",
    'sa_filters' => 'Levélszemét szűrők',
    'spamfilter__tools_legend' => 'Eszközök',
    'spamfilter__prefs_legend' => 'Beállítások',
    'spamfilter__max_children' => 'A futtatandó spamd feldolgozófolyamatok maximális száma',
    'spamfilter__rewrite_header_subject_hint' => 'Hagyja üresen e mezőt, ha nem akar szöveget hozzáadni. Írja be a _SCORE_ változót, ha azt akarja, hogy megjelenjen a pontszám az üzenet szövegmezejében.',
    'spamfilter__reject_spam' => 'Levélszemét törlése, amikor a postaládába kerül.',
    'spamfilter__enabled' => 'Bekapcsolva',
    'spamfilter_addresses_list__items' => 'címek',
    'spamfilter_addresses__remove_title' => 'A következő címek eltávolításra kerülnek a listáról:',
    'spamfilter_addresses__empty_selection' => 'Nincsenek címek kiválasztva.',
    'server__admin_info' => "Rendszergazdai információk",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Alább írja le a hibát",
    'server__power_management' => "Energigazdálkodás",
    'server__services' => "Szolgáltatások",
    'server__system' => "Rendszer",
    'server__title' => "Kiszolgáló felügyelet",
    'server_preferences__admin_skin' => "Rendszergazda kezelőfelület felszíne",
    'server_preferences__default_language' => "Alapértelmezett nyelv",
    'server_preferences__default_skin' => "Alapértelmezett felszín",
    'server_preferences__restart_apache_interval' => "Az Apache újraindítási időköz",
    'server_preferences__system' => 'Rendszerbeállítások',
    'mail__tabs_preferences' => "Beállítások",
    'mail__tabs_white_list' => "Engedélyezési lista",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Postaláda jelszavak ellenőrzése a szótárban",
    'sessions__agreement' => "Igen, be akarom fejezni ezen munkameneteket.",
    'sessions__select_sessions_for_remove' => "Válassza ki a megszakítandó munkameneteket.",
    'sessions__tabs_cp_sessions' => 'Plesk munkamenetek',
    'sessions__tabs_ftp_sessions' => 'FTP munkamenetek',
    'sessions__ftp_sessions_login' => 'FTP-fiók felhasználóneve',
    'sessions__ftp_sessions_domain' => 'Domain név',
    'sessions__ftp_sessions_path' => 'Jelenlegi hely',
    'sessions__ftp_sessions_file' => 'Fájlnév',
    'sessions__ftp_sessions_action' => 'Állapot',
    'sessions__ftp_sessions_speed' => 'Sebesség, kB/s',
    'sessions__ftp_sessions_comp' => 'Előrehaladás, %',

    'site_apps__access_level' => 'Hozzáférési szint',
    'site_apps__access_level_commercial' => 'Fizetős',
    'site_apps__access_level_free' => 'Ingyenes',
    'site_apps__action_installer' => "Webalkalmazás telepítése",
    'site_apps__action_reconfigure' => "Webalkalmazás újrakonfigurálása",
    'site_apps__custom_button_level' => 'Létre akar hozni egy egyéni gombot ezen alkalmazáshoz hozzáférés érdekében?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nem',
    'site_apps__custom_button_level_domain_user_only' => 'Igen',
    'site_apps__custom_button_level_false' => 'Nem',
    'site_apps__custom_button_level_domain' => 'Igen, és csak az aktuális domain esetébe biztosítsa a rendelkezésre állást.',
    'site_apps__custom_button_level_client' => 'Igen, és a felhasználó összes domainje esetébe biztosítsa a rendelkezésre állást.',
    'site_apps__custom_button_level_admin' => 'Igen, és az összes domain esetébe biztosítsa a rendelkezésre állást.',
    'site_apps__description' => "Leírás",
    'site_apps__dir_used_by_sapp__' => "Már más webalkalmazás használja a könyvtárat \"%1\".",
    'site_apps__dir_used_by_unknown__' => "A könyvtár \"%1\" már létezik. Megtörténik a felülírása, ha folytatja.",
    'site_apps__dir_invalid_name__' => "%1 könyvtárnév helytelen.",
    'site_apps__file_name' => 'Webalkalmazás fájlneve',
    'site_apps__invalid_install_prefix' => "Érvénytelen telepítési előtag",
    'site_apps__invalid_package' => "Érvénytelen a webalkalmazás.",
    'site_apps__key_status' => 'Licencelés',
    'site_apps__key_status_free' => 'Ingyenesen terjesztett. Nem igényel licenckulcsot',
    'site_apps__key_status_ok' => 'A szükséges licenckulcs telepítve van',
    'site_apps__key_status_problem' => 'Nincs telepítve a szükséges licenckulcs',
    'site_apps__name' => "Név",
    'site_apps__no_domains' => 'Nem telepíthető a webalkalmazás. Már egy másik webalkalmazás van telepítve e domain gyökérkönyvtárába. Fontolja meg egy aldomain létrehozását a webalkalmazás számára.',
    'site_apps__package_info_' => "Webalkalmazás adatok",
    'site_apps__package_integrated' => "Beépített alkalmazás, nem távolítható el.",
    'site_apps__pool_select_packages_to_add' => 'Webalkalmazás kiválasztása a készlethez adáshoz',
    'site_apps__release' => "Kiadás",
    'site_apps__resource_used_by_sapp' => "Egy telepített webalkalmazás használja ezen erőforrást.",
    'site_apps__root_used_by_sapp' => "Egy telepített webalkalmazás használja ezen erőforrást.",
    'site_apps__these_domains_will_not_delete' => 'Nem történik meg ezen (al)domainek törlése.',
    'site_apps__upload_site_app_pkg_title' => 'Új webalkalmazás feltöltése',
    'site_apps__version' => "Verzió",
    'site_apps__access_to' => "%1 esetében a hozzáférés",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Nem lehetséges az archívum kicsomagolása. Valószínűleg nincs archiváló telepítve e kiszolgálón. Forduljon az illetékes {$PROD_NAME} adminisztrátorhoz egy telepítése érdekében.",
    'skeleton__archive_corrupted' => "Az archivum ellenőrzés megállapította, hogy sérült az archívumfájl vagy nem támogatott ezen archívumtípus.",
    'skeleton__archive_too_large' => "Az archivum ellenőrzés megállapította, hogy túl nagy az archívumfájl.",
    'skeleton__not_supported_archive_type' => "Nem támogatott ezen archívum típus (%1 fájl).",
    'skin_download__title' => 'Felszín letöltése',
    'skin_download_now__title' => 'Felszín letöltése folyamatban van',
    'skin_download_now__text' => 'Folyamatban van a felszíncsomag létrehozása.<br>Ezen eljárás egy bizonyos időt vesz igénybe.<br> A párbeszédablak megjelenés után folytathatja a munkát a Plesk kezelőpanelen.',
    'skin_file__help_for_using_types' => "A következő formátumok egyikében használja a felszínek archívumokat:",
    'skin_info__title' => 'Felszín tulajdonságai',
    'skin_mng_err__rpm_not_skin' => 'Ezen RPM nem egy Plesk felszíncsomag.',
    'skin_mng_err__psa_install_noreloc' => 'Nem sikerült az RPM-alapú felszíncsomag telepítése az dott helyre.',
    'skin_mng_err__already_exists' => 'A felszín telepítési könyvtára már létezik és már alkalmazásban van egy felszíncsomag.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'A feltöltött fájl nem egy RPM felszíncsomag.',
    'skin_mng_err__rpm_upgrade_noskin' => 'A feltöltött fájl nem felszíncsomag.',
    'skin_mng_err__rpm_upgrade_base' => "A feltöltött fájl nem egy érvényes {$PROD_NAME} felszíncsomag.",
    'skin_mng_err__rpm_upgrade_other' => 'Nem lehetséges egy felszín telepítése: érvénytlen felszín formátum.',
    'skin_mng_err__no_a_skin' => "A feltöltött fájl nem egy érvényes {$PROD_NAME} felszíncsomag.",
    'skin_upload__title' => 'Új felszín feltöltése',
    'skin_upload__already_exists' => "'%1' felszín már létezik.",
    'skin_upload__unable_to_apply' => "Nem tartalmaz Plesk felszínt a feltöltött fájl vagy nem támogatott az archiválási formátum.",
    'skin_upload__unable_to_rename__' => "Nem lehetséges %2 - %1 felszín átnevezése: %3.",
    'skin_upload__file_name' => 'Felszíncsomag fájl elérési útja',
    'skins_list__title' => 'Felszín tároló',
    'skins_remove__title' => 'Felszín eltávolítása',
    'skins_remove__select_skins_for_remove' => 'Az eltávolítandó felszínek kiválasztása',

    'spf__unable_update' => 'Nem lehetséges SPF-paraméterek frissítése',
    'statistics__active_domains' => "Aktív domainek",
    'statistics__clients' => "Ügyfelek",
    'statistics__subdomains' => "Aldomainek",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Adatbázisok",
    'statistics__db_users' => "Adatbázis-felhasználók",
    'statistics__dirs' => "Védett könyvtárak",
    'statistics__dom_active' => "Aktív",
    'statistics__dom_passive' => "Passzív",
    'statistics__dom_problem' => "Probléma",
    'statistics__domains' => "Domainek",
    'statistics__domains_with_host' => "Üzemeltetéssel rendelkező domainek",
    'statistics__doms' => "Domainek",
    'statistics__filesystem' => "Fájlrendszer",
    'statistics__general' => "Általános",
    'statistics__hdd_available' => "Rendelkezésre áll",
    'statistics__hdd_capacity' => "Kapacitás",
    'statistics__hdd_total' => "Összes",
    'statistics__hdd_usage' => "Merevlemez kihasználtsága",
    'statistics__hdd_used' => "Használt",
    'statistics__ip' => "IP-cím",
    'statistics__key_number' => "Kulcsszám",
    'statistics__l1' => "Az utolsó 1 perc",
    'statistics__l15' => "Az utolsó 15 perc",
    'statistics__l5' => "Utolsó 5 perc",
    'statistics__la' => "CPU-használat",
    'statistics__mail_autoresponders' => "Automatikus válaszok",
    'statistics__mail_boxes' => "Postaládák",
    'statistics__mail_groups' => "Levelezési csoportok",
    'statistics__mail_lists' => "Levelezési listák",
    'statistics__mail_redirects' => "E-mail továbbítók",
    'statistics__mem' => "Memóriahasználat",
    'statistics__mem_usage' => "Használat",
    'statistics__memory_available' => "Rendelkezésre áll",
    'statistics__memory_buffer' => "Puffer",
    'statistics__memory_cached' => "Gyorsítótárazott",
    'statistics__memory_free' => "Szabad",
    'statistics__memory_shared' => "Megosztott",
    'statistics__memory_total' => "Összes",
    'statistics__memory_used' => "Használt",
    'statistics__os' => "Operációs rendszer",
    'statistics__problem_clients' => "Problémás ügyfelek",
    'statistics__problem_domains' => "Hibás domainek",
    'statistics__swap' => "Felcserélés használata",
    'statistics__swap_free' => "Szabad",
    'statistics__swap_total' => "Összes",
    'statistics__swap_usage' => "Használat",
    'statistics__swap_used' => "Használt",
    'statistics__system_stat' => "Kiszolgáló adatai",
    'statistics__unable_define_active_doms' => "Aktív domainszám meghatározása nem lehetséges: %1",
    'statistics__unable_define_inactive_doms' => "Nem lehet meghatározni az inaktív domainen számát: %1",
    'statistics__failed_define_swap_usage' => 'Nem sikerült a felcserélés használat meghatározása',
    'statistics__failed_define_load_averages' => 'Nem sikerült az átlagos terhelés meghatározása.',
    'statistics__up_time' => "Rendszer bekapcsolási ideje:",
    'statistics__ver' => "Verzió",
    'statistics__web_users' => "Webes felhasználók",
    'statistics__mem_win' => "Fizikai memória használat",
    'statistics__memory_total_win' => "Összes",
    'statistics__memory_used_win' => "Használt",
    'statistics__memory_free_win' => "Rendelkezésre áll",
    'statistics__swap_win' => "Fizikai memória használat",
    'statistics__swap_total_win' => "Összes",
    'statistics__swap_used_win' => "Használt",
    'statistics__swap_free_win' => "Rendelkezésre áll",
    'status__domain_has_reasons_to_be_off' => "A következő ok miatt még fel van függesztve a domain: %1",
    'subdomain__create__' => "%1 domain aldomainjének létrehozása",
    'subdomain__edit__' => "%1 aldomain kezelése",
    'subdomain__invalid_name' => "Érvénytelen aldomain név: csak alfanumerikus karaktereket és a kötőjel szimbólum használható.",
    'subdomain__incorrect_name' => "Érvénytelen aldomain név.",
    'subdomains__maillists_enabled_in_domain' => "Listákban történő használat miatt helytelen aldomain név listák.%1: %1 domain esetén levelezési listák már használják e domain nevet.",
    'subdomains__dalias_exists' => 'Ilyen nevű domain alias már létezik.',
    'subdomains__name_exists' => "Ilyen nevű aldomain már létezik.",
    'subdomains__regular_domain_exists' => "Ilyen nevű domain már létezik.",
    'subdomains__domain_alias_exists' => 'Ilyen nevű domain alias már létezik.',
    'subdomains__remove_subdomains_on_domain' => "%1 nevű domain aldomainjei közül a következők kerülnek eltávolításra:",
    'subdomains__select_subdomains_for_remove' => "Válassza ki az eltávolítandó aldomaineket.",
    'subdomains__webmail_enabled_in_domain' => "Webes levelezésnél történő használat miatt helytelen aldomain név.%1: %1 domain esetében webes levelezés eléréséhez már használatban van e domain név.",
    'subdomains__dns_record_already_exists' => 'Nem lehetséges %1 aldomain létrehozása, mivel már egy DNS-rekord a kérdéses %1 állomásra mutat.',
    'subdomains__www_prefix_in_domain' => "A www használata miatt helytelen aldomain név.%1: %1 domain már rendelkezik WWW előtaggal.",
    'subdomains__user_type_quota_exceeds' => 'Nem lehet megváltoztatni a felhasználói számlát, mivel ez a kiosztott lemezterület túllépését okozhatja.',
    'subdomains__creation_in_dns_slave' => "Másodlagos névkiszolgálóként működik a Plesk névkiszolgálója e domain esetén. Az aldomainje esetén, a helyes feloldás érdekében ellenőrizze, hogy az elsődleges DNS-kiszolgáló zóna fájlja tartalmazza-e %1 rekordot.",
    'sys_user__attributes_not_changed' => "\nA következő rendszer felhasználói jellemzők nem változtak: %1",
    'sys_user__no_access_without_password' => "Nem állított be jelszót. Megtörténik a rendszerfelhasználó létrehozása, de a jelszó megadásáig nem bejelentkhet be a rendszerbe. Folytatja?",
    'sys_user__no_hard_quota' => "nem támogatott",
    'sysuser__zero_quota_is_unlimited' => "0 a korlátlan megadásához",
    'template__num_excl_ips' => "Dedikált IP-címeknek az ügyfélhez rendelése",
    'template__sel_sh_ips' => "Kiválasztott megosztott IP-címek",
    'template__av_sh_ips' => "Rendelkezésre álló megosztott IP-címek",
    'template__up_to_excl_ip' => "Maximum %1 IP-cím",
    'templates__all_clients' => "az összes ügyfél",
    'templates__cl_domain_templates' => "%1 sablonok",
    'templates__cl_templates' => "Ügyfélsablonok",
    'time__invalid_ip' => "Az IP-cím vagy a domain név érvénytelen.",
    '__please_select_country' => 'Válassza ki az országát',
    'time__unable_set_time' => "A rendszeridő beállítása nem lehetséges: %1",
    'time__sinchronization_setup_error' => 'Nem állítható be idő szinkronizálás: nem sikerült az időzítés: %1',
    'time__sinchronization_disable_error' => 'Nem tiltható le az idő szinkronizálása: nem sikerült az időzítés: %1',
    'tmpl__create' => "Sablon létrehozása",
    'tmpl__edit__' => '%1 sablon',
    'tmpl__logrotation_warn' => "Csak egymást követő fizikai üzemeltetési fiókok létrehozása esetén történik meg a sablonnal létrehozott domainen a napló rotáció.",
    'tmpl__name' => "Sablonnév",
    'tmpl__dom_exist' => "Egy ilyen nevű domainsablon már létezik az adminisztrátor vagy az ügyfél sablonkészletében.",
    'tmpl__name_invalid' => "A sablonnév érvénytelen vagy üres.",
    'tmpl__use_next_ip_addr' => "A következő üres IP-cím kerül felhasználásra.",
    'tmpl_name_already_exists' => "'%1' nevű sablon már létezik.",

    'vh_based__no_free_ip_for_vh' => "Nincsenek szabad IP-címek az IP-alapú virtuális üzemeltetéshoz. Adjon új IP-címet a rendszerhez.",

    'wu__at_domains_text' => "Egy webuser@%1 hozzáférési formátum engedélyezése",
    'wu__unable_create' => "Webes felhasználó létrehozása nem lehetséges: %1",
    'wu_edit__disk_quota' => "Lemezkvóta",
    'wu_edit__invalid_pass' => "A jelszó érvénytelen.",
    'wu_edit__invalid_quota' => "Érvénytelen a megadott lemezkvóta. Egy pozitív egész számot addjon meg.",
    'wu_edit__invalid_quota_value' => "A jelenleg használtnál (%1MB) kisebb a megadott lemezterület kvóta. Előfordulhat, hogy néhány funkció nem áll rendelkezésre. Biztosan folytatja?",
    'wu_edit__not_create_pass' => "Nem hoz létre új jelszót e művelet aj új webes felhasználó számára.\nJelszó nélkül pedig a felhasználó nem tud majd bejelentkezni.",
    'wu_edit__unable_update' => "A webes felhasználó tulajdonságainak frissítése nem lehetséges: %1",

    'dns__tabs_general' => 'Zóna beállításai',
    'dns__tabs_zone_settings' => 'SOA-rekordok',
    'soa__seconds' => 'másodperc',
    'soa__minutes' => 'perc',
    'soa__hours' => 'óra',
    'soa__days' => 'nap',

    'DomainSubdirectory' => 'Cél alkönyvtár',

    'filemanager__select_codepage' => 'Kódlap kiválasztása:',

    'bt_server_app_add' => 'Kiszolgáló alkalmazás hozzáadása',
    'packages_list' => 'Kiszolgálóalkalmazás',

    'bt_packages_management' => 'Csomagok kezelése',
    'pb__packages_management' => 'Alkalmazáskezelés',
    'bt_package_new' => 'Alkalmazás hozzáadása',
    '__packages' => 'Kiszolgálóalkalmazás',

    'dom_ctrl__mysql_dbase_space' => 'Összes MariaDB/MySQL adatbázis kvóta',
    'dom_ctrl__mssql_dbase_space' => 'Összes MS SQL-adatbázis kvóta',

    'dns_add__enter_ixfr_path' => 'Írjon be IXFR elérési utat.',

    'cmd_dns__txt_dns_record_already_exist' => 'Az SPF TXT-rekord már létezik. Csupán egy SPF-rekord lehetséges. Először törölje a meglévőt egy rekord hozzáadásához.',

    'component_name__network' => 'Hálózatkezelés',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Felszín beállítása',
    'bt_set_skin' => 'Felszín beállítása',
    'firewall__rule_already_exists' => '"%1" nevű szabály már létezik.',
    'firewall__rule_readonly' => '"%1" szabály csak olvasható',
    'pb__firewall' => 'Tűzfal',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Vírusvédelem',
    'antivirus__antivirus' => 'Vírusok elleni védelem',
    'antivirus__antivirus_direction_off' => 'Kikapcsolva',
    'antivirus__antivirus_direction_any' => 'Bejövő és kimenő levél',
    'antivirus__antivirus_direction_from' => 'Csak kimenő levél',
    'antivirus__antivirus_direction_to' => 'Csak bejövő levél',
    'antivirus__unable_to_update_settings' => 'Nem lehetséges a vírusvédelmi beállítások megváltoztatása: %1',




    '__normal' => 'Normál',
    '__low' => 'Alacsony',
    '__high' => 'Magas',

    'mail__antivirus' => "Belső levelezési kiszolgáló vírusvédelem",
    'mail__use_internal_antivirus' => 'Belső vírusvédelem használata',

    'sa__tabs_blacklist' => 'Tiltólista',

    '__mysql_databases' => 'MariaDB/MySQL-adatbázisok',

    'cl_perm__mysql_dbase_space' => 'Összes MariaDB/MySQL adatbázis kvóta',
    'cl_perm__mssql_dbase_space' => 'Összes MS SQL-adatbázis kvóta',
    'cl_perm__max_mssql_db' => 'Microsoft SQL-kiszolgáló adatbázisok maximális száma',
    'cl_perm__total_mboxes_quota' => 'Összes postaláda kvóta',

    'i_i_cl_on' => 'Az ügyfél számlája aktív.',
    'i_i_cl_off_by_admin' => 'Az adminisztrátor felfügesztete az ügyfélszámlát.',

    'sa_exists_tn' => 'A hálózat már szerepel a listán.',

    'defaultcomponents__not_activated' => 'nincs aktiválva',

    'bt_traffic_at_domains' => 'Forgalom',

    '__awstats_perl_warning' => 'Perl telepítése nélkül, az AWStats nem teszi lehetővé a felhasználók számára az előző évek statisztikáinak az ellenőrzését.',

    'class_client__mysql_dbase_space' => 'Az érték túllépi az ügyfél korlátját.',
    'class_client__mssql_dbase_space' => 'Az érték túllépi az ügyfél korlátját.',
    'class_client__max_mssql_db' => 'Az érték túllépi az ügyfél korlátját.',

    'dns__remove_transfer_restrictions_list_items' => 'A következő hálózatok eltávolításra kerülnek a hozzáférés-vezérlési listáról:',

    'bt_up' => "Fel",
    'bt_down' => "Le",

    'bt_install_selected' => 'Kiválasztott licenckulcsok telepítése', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Másik IP-cím mellett dönt a domain: (%1). Javítsa ki a DNS-beállításokat.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'A jelenleg használt levelezési kiszolgáló nem támogatja a postaláda és levelezőcsoportok egyidejű bekapcsolását. Nyomja meg az OK gombot a postaládának a levelezőcsoportok kikapcsolása árán történő bekapcsolására. Nyomja meg a Mégse gombot minden érintetlenül hagyása érdekében.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'A jelenleg használt levelezési kiszolgáló nem támogatja a postaláda és levelezőcsoportok egyidejű bekapcsolását. Nyomja meg az OK gombot a levelezőcsoportoknak a postaláda kikapcsolása árán történő bekapcsolására. Nyomja meg a Mégse gombot minden érintetlenül hagyása érdekében.',

    'mysql_dbase_space_limit' => 'MariaDB/MySQL-adatbázis lemezterület korlát',
    'mysql_dbase_usage' => 'MariaDB/MySQL-adatbázis lemezterület-használat',
    'mssql_dbase_space_limit' => 'Microsoft SQL-kiszolgáló adatbázis lemezterület korlát',
    'mssql_dbase_usage' => 'Microsoft SQL-kiszolgáló adatbázis lemezterület-használat',

    '__statistics' => "statisztikák", //indirect

    'dns__soa_minimum_value_is_big' => 'A 3 órát meghaladó minimális TTL érték beállítása néhány domain adminisztrátor számára elérhetetlenné teheti a domainjeit. Csak akkor ajánlott ilyen érték beállítása, ha már tartalmazza a domain név nyilvántartása.',

    'virusfilter__interface_not_available' => 'Nem állnak vírus szűrők rendelkezésre.',
    'virusfilter__none_virus_filter' => 'Nincs',
    'virusfilter__mailname_status_text' => 'Vírusvédelem (%1)',
    'virusfilter__status_none' => 'ki van kapcsolva',
    'virusfilter__status_any' => 'bejövő és kimenő levél',
    'virusfilter__status_outgoing' => 'csak kimenő levél',
    'virusfilter__status_incoming' => 'csak bejövő levél',

    'visibility__root_override_parse_error' => 'Szintaktikai hiba lépett fel %1 fájl %2 jelű sorában.',

    'sb__not_support_publishing_api' => "Nem támogatja a Közzététel automatizálást az összetevő.",

    'component_name__cphosting' => "Plesk üzemeltetés",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Nem támogatja a jelenlegi levelezési kiszolgáló postaláda kvóta beállítását.',
    '__unable_get_total_mboxes_quota' => 'Nem támogatja a jelenlegi levelezési kiszolgáló postaláda kvóta beállítását.',

    'install_prefix__parent_not_exists' => "Szülőkönyvtár nem létezik.",

    'bt_change_version' => 'Verzió módosítása',
    'pb__aspdotnet' => 'ASP.NET keretrendszer',

    '__check_all' => "Az összes kijelölése",
    '__uncheck_all' => "Az összes törlése",

    'dns__editing_domain_controller_zone' => "Problémákat okozhat a domain működésében a domainvezérlő DNS zóna rekordjainak a szerlesztése.",

    'pb__interface_management' => "Kezelőfelület kezelése",
    'interface_management__tabs_skins' => "Felszínek",
    'interface_management__tabs_interface_templates' => "Kezelőfelület sablonok",
    'interface_management__tabs_locales' => "Területi beállítások",
    'locales_list__title' => "Nyelvi csomag tárhely",
    'locales_list__legend' => "Rendelkezésre álló nyelvek",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Nyelvi csomagok",
    'locales_list__lang_title' => "Nyelv",
    'locales_list__country_title' => "Ország",
    'locales_list__used_title' => "Használt",

    'backup__suspend_warning_during_backup' => "A biztonsági mentési folyamat alatt nem áll a domain rendelkezésre.",
    'backup__suspend_warning_during_restore' => "A visszaállítási folyamat alatt nem áll a domain rendelkezésre.",
    'backup__suspend_domain' => "Domain felfüggesztése",

    'locales_list__mls_limit' => "%2 nyelv használatát engedélyezi a jelenlegi Plesk licenc. Jelenleg %1 nyelv van beállítva a felhasználók számára rendelkezésre állóként, amely meghaladja a licenc által engedélyezett számot. %2 saját célra használni kívánt nyelvet válasszon ki, míg az 'S' oszlopban szereplő ikonjaikra kattintva tegye a felhasználók számára rendelkezésre nem állóvá a fennmaradókat.",

    'bt_change_owner' => 'Új tulajdonos hozzárendelése',
    'chown__limit_name' => 'Erőforrás neve',
    'chown__error_limits' => "Nem lehetséges az előfizetés átruházásának folytatása: több erőforrást igényel ezen előfizetés, mint az új tulajdonos szolgáltatója biztosítani képes.",
    'chown__error_empty_ip_pool' => "Nem lehetséges az előfizetés átruházásának folytatása: Üres az új tulajdonos szolgáltatójának IP-cím készlete. Ellenőrizze, hogy legalább egy IP-címmel rendelkezik-e a készletben a szolgáltató.",

    'backup__backup_time' => 'Biztonsági mentés ideje',
    'backup__backup_time_hour' => 'óra',
    'backup__backup_time_minute' => 'perc',
    'backup__every' => 'minden',
    'backup__day_of_month' => 'a hónap napja',

    'subdomain__select_hst_type' => 'Az üzemeltetési típus kiválasztása az aldomain számára',
    'hst_sel__subdom_subfolder_hst' => 'Aldomain, illetve almappa.',
    'subdomain__www_root_folder_not_exists' => 'Nem létezik a webhely %1 kezdőkönyvtár.',
    '__site_home_dir' => 'Weboldal kezdőkönyvtára',
    'subdomain__aspnet_disabled_domain' => 'domain által kikapcsolva',

    'domains__remove_description' => 'Megtörténik az összes domain adat, a domain és a megfelelő aldomain tartalmakat és beállításokat beleértve, a webalkalmazás adatok, postaláda tartalmak, e-mail, vírusvédelmi és levélszemét szűrési beállítások, naplófájlok, domain biztonsági másolat adattár és SSL/TLS-tanúsítványok törlése. Ha nem rendelkezik biztonsági másolat fájlokkal a helyi számítógépén, akkor véglegesen elveszik az összes adat.',
    'subdomains__remove_description' => 'Megtörténik az összes aldomain adat törlése, az aldomain tartalmakat és beállításokat, webalkalmazás adatokat és naplófájlokat beleértve. Ha nem rendelkezik biztonsági másolat fájlokkal a helyi számítógépén, akkor véglegesen elveszik az összes adat.',

    'mail__tabs_spam_filtering' => 'Levélszemét szűrése',
    'mail__tabs_antivirus' => 'Vírusvédelem',
    'antivirus__use_server_settings_scan' => 'Az alapértelmezett egész kiszolgálóra érvényes beállítások használata (végezzen keresést)',
    'antivirus__use_server_settings_no_scan' => 'Az alapértelmezett egész kiszolgálóra érvényes beállítások használata (ne végezzen keresést)',
    'antivirus__check_for_viruses' => 'Víruskeresés',
    'antivirus__dont_check_for_viruses' => 'Ne végezzen víruskeresést.',
    'antivirus__incoming_mail' => 'Bejövő levél',
    'antivirus__outgoing_mail' => 'Kimenő levél',

    'domain_alias__CNAME_dns_record_exists' => 'Már létezik egy ilyen nevű DNS CNAME rekord.',
    'domain_alias__A_dns_record_exists' => 'Már létezik egy ilyen nevű DNS A rekord.',
    'domain_alias__bad_prefix' => 'Helytelen domain alias előtag',
    'domain_alias__domain_doesnt_exist' => "A domain nem létezik.",

    'dns__zone_ttl_message_info' => 'Ha nincs megadva az élettartamérték, akkor az SOA-rekord sablonban (%1) szereplő élettartamérték helyettesíti azt e DNS-rekord esetén.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Egy index.html nevű fájl kerül létrehozásra a kiválasztott webalkalmazásra történő átirányítás céljából. Ha már létezik index.html nevű fájl, akkor index.html.old néven biztonsági másolat készül róla és az új kerül a helyére. Nyomja meg az OK gombot a megerősítéshez.",

    'bt_ftp_ctrl' => "További FTP-fiókok",
    'ftp_users_no_permission' => "Nem rendelkezik engedéllyel e domain FTP-fiókjainak a kezelésére.",
    'ftp_users_limit_reached' => "Megtörtént e domain esetében az FTP-fiók korlát elérése.",
    'pb__ftp_ctrl' => "FTP-kezelés",
    'class_client__max_subftp_users' => "További FTP-fiókok",

    '__client_form_settings' => "Ügyfélbeállítások",
    '__sbnet_client_keep_sbnet' => "Megfelelő felhasználói számla megőrzése a Presence Builder weboldalkészítőben",
    '__sbnet_cant_add_more_sites' => "Az ügyfél elérte a Presence Builder weboldalkészítőben használható webhelyszám korlátot.",
    '__sbnet_legend_text' => "Presence Builder integrálása",
    '__sbnet_synchronize_user_with_sbnet' => "Megfelelő felhasználói számla létrehozása a Presence Builder weboldalkészítőben",
    '__sbnet_client_warning_delete_sb_user' => "Az ezen ügyféllel társított Presence Builder felhasználói számlát próbálja eltávolítani. Ez törli a Presence Builder rendszerből az összes felhasználóhoz tartozó webhelyet és az összes fontos beállítást, ezáltal megszüntetve annak lehetőségét, hogy a Presence Builder használatával végezze a meglévő webhelyek szerkesztését, annak ellenére, hogy később azt ismét bekapcsolja. Ha később ismét létrehoz egy Presence Builder felhasználói számlát, akkor az elejéről kell végeznie a webhelyek létrehozását és közzétételét. Ki akarja kapcsolni a Presence Builder weboldalkészítőn keresztül történő a webhely létrehozást és közzétételt?",
    'sb__build_site_with_subdomains' => "Blog létrehozás és Fényképgyűjtemény aldomain",
    '__sbnet_client_dont_have_sbuser' => "Nem lehet létrehozni és közzétenni webhelyet a Presence Builder használatával: Nem létezi a Presence Builder felhasználó.",

    '__component_disabled' => "Összetevő ki van kapcsolva.",

    'subdomains__physical_path_not_exist' => "Nem létező fizikai mappákra hivatkozó aldomainek szerepelnek.",

    'dnsserver_bind_to_msdns_switching_warning' => "Figyelmeztetés: csupán a Hozzáférés-vezérlési listán szereplő, /8 és /16 maszkkal rendelkező alhálózatok, első 254 IP-címe kerül átadásra. Különálló IP-címekként kerülnek átadásra. Folytatni kívánja?",

    '__sbnet_net_framework_required_for_site' => "Előfordulhat, hogy ASP.NET 2.0 támogatást igényelnek a domainjén a Presence Builder webhelyek. Ajánljuk az ASP.NET 2.0 támogatás engedélyezését, ha Presence Builder weboldalkészítőt használ.",

    'subdomain_auto_create_dir' => "Fizikai könyvtár létrehozása aldomain számára",

    'sa_trainer__unable_to_get_messages_list' => "Nem kérhető le a postaládában lévő üzenetek listája: %1",
    'sa_trainer__pass_doesnt_exist' => "Hiányzik e postafiók jelszava.",

    '__sitebuilder_error' => "Hiba történt a Presence Builder weboldalkészítőhöz kapcsolódási kísérlet során. A szolgáltatójához forduljon segítségért.",
    'wsb_error_user_not_exist' => "Nem létezik ezen Presence Builder felhasználói számla.",
    'wsb_error_site_already_exist' => "Ezen oldal már létezik a Presence Builder weboldalkészítőben.",
    'wsb_error_site_limit_reached' => "Megtörtént a Presence Builder webhelyszám korlát elérése.",
    'wsb_error_internal_error' => "Belső Presence Builder hiba történt. A szolgáltatójához forduljon segítségért.",
    'wsb_error_user_already_exist' => "Ilyen nevű Presence Builder felhasználó már létezik a Presence Builder weboldalkészítőben.",
    'sb_error_user_not_exist' => "Nem létezi a Presence Builder felhasználó.",
    'wsb_error_object_not_found' => "A Presence Builder nem volt képes a helyes állomásbejegyzést megtalálni.",

    'mg_no_mail_groups' => "Nincsenek levelezőcsoportok",

    'drweb__drweb_incoming' => 'Bejövő levél vírusvédelmi ellenőrzése',
    'drweb__drweb_outgoing' => 'Kimenő levél vírusvédelmi ellenőrzése',
    'drweb__disable_reason_serv' => 'Nem támogatja a levelezési kiszolgáló a postaláda szintű vírusszűrő beállítások végzését.',

    'vz_sitebuilder3_client_cant_be_created' => "Nem lehet ügyfélszámlát létrehozni: Nincs SiteBuilder 3.1 vagy újabb telepítve.",

    // new limits

    'class_client__max_odbc' => "ODBC-kapcsolatok",
    'cl_perm__max_odbc' => "ODBC-kapcsolatok maximális száma",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Domain alias név',
    'domain_alias__list_ascii_name' => 'ASCII formátumban',


    // Interface Customization Templates
    'interface_preferences' => 'Kezelőfelület kezelése',
    'pb__interface_templates' => 'Kezelőfelület kezelés',
    'pb__interface_clients' => '%1 használó ügyfelek',

    // service management
    'bt_service_showall' => "Az összes megjelenítése",
    'bt_service_hideall' => "Az összes elrejtése",
    'bt_service_start' => "Indítás",
    'bt_service_stop' => "Leállítás",
    'bt_service_restart' => "Újraindítás",
    'bt_service_disable' => "Kikapcsolás",
    'bt_service_manual' => "Kézi",
    'bt_service_auto' => "Automatikus",
    'service_startup_auto' => 'Automatikus',
    'service_startup_manual' => 'Kézi',
    'service_startup_disabled' => 'Kikapcsolva',
    'service_action_ok' => "%1 szolgáltatással sikerült a művelet elvégzése.",
    'service_action_failed_disabled_service' => "Nem lehetett %1 szolgáltatással elvégezni a műveletet, mivel az ki van kapcsolva.",
    'service_action_failed_error' => "Nem lehetett elvégezni a műveletet: %1",
    'service_group_action_ok' => "A következő szolgáltatásokkal sikerült a művelet elvégzése: \n %1",
    'service_group_action_disabled' => "Nem lehetett a következő szolgáltatásokkal elvégezni a műveletet, mivel azok ki vannak kapcsolva. \n %1",
    'service_group_action_failed' => "Nem lehetséges a következő szolgáltatásokkal elvégezni a műveletet: \n %1. \n Részletes hibaadatokhoz jutás érdekében szolgáltatásonként külön végezze el a műveletet.",

    // php 4vs5
    'bt_php' => "PHP-beállítások",

    'bt_insert' => "Beszúrás",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder adatbázis hiba történt. A szolgáltatójához forduljon segítségért.",
    'wsb_error_sitebuilder_access_denied_error' => "A fájl nem érhető el: Nem rendelkezik hozzáférési jogosultsággal a Presence Builder a kívánt fájlhoz vagy mappához. A szolgáltatójához forduljon segítségért.",
    'wsb_error_sitebuilder_connection_failed' => "Nem lehet a Presence Builder weboldalkészítőhöz kapcsolódni, mivel megszakadt a kapcsolat. A szolgáltatójához forduljon segítségért.",
    'wsb_error_critical_during_operation' => "Kritikus Presence Builder hiba történt:\n%1",
    'wsb_error_license_during_operation' => "Presence Builder licenchiba történt:\n%1",
    'wsb_error_during_operation' => "Presence Builder hiba történt:\n%1",
    'wsb_error_license_error' => "Presence Builder licenckorlátozás történt.",

    // Other
    '__confrim_service_stop' => "Figyelmeztetés! Ha leállítja %1 szolgáltatást, akkor előfordulhat, hogy leáll a Plesk. Biztosan le akarja állítani %1 szolgáltatást?",
    'index_redirect_help_text' => 'Most megtörténik az automatikus átirányítás a kívánt webhelyre. Ha a böngészője nem támogatja az átirányítást, akkor kattintson %1 %2 helyre.',
    'bt_default_settings' => "Alapértelmezések visszaállítása",
    'logfiles__remove_failed' => "Nem lehetséges %1 fájl törlése: egy másik alkalmazás zárolta a fájlt. Később próbálja meg újból.",
    'subdomain__invalid_homedirectory' => "Érvénytelen a megadott aldomain kezdőkönyvtár.",
    'scheduler_item__empty_filename' => "Adja meg a futtatáshoz a végrehajtható fájlt.",
    'subdomains__overlapped_domain_exists' => '%1 domain DNS-zónája átfedi az aldomaint.',
    'subdomains__overlapped_domain_alias_exists' => '%1 domain alias DNS-zónája átfedi az aldomaint.',
    'services_action_none_selected' => 'Nem lehetett elvégezni a műveletet: válassza ki a kívánt szolgáltatásokat.',
    'cl_perm__max_subftp_users' => "További FTP-fiókok maximális száma",
    'login_up__access_denied_no_cp_access' => 'Hozzáférés megtagadva. Nem rendelkezik Plesk hozzáférési engedéllyel.',
    'drweb__disable_reason_admin' => "Nem engedélyezi a kiszolgáló házirendje a postaláda szintű vírusszűrő beállítások végzését.",

    '__use_default' => 'Alapértelmezés használata',

    'webalizer_hidden_referrer__already_exist' => 'Ilyen bejegyzés már létezik',
    'webalizer_group_referrer__already_exist' => 'Mát létezik ilyen nevű csoport.',

    'pb__dashboard' => 'Kezdőlap',

    'server_interface__page_title' => 'Kiszolgáló illesztőfelület beállításai',
    'server_interface__tabs_locales' => 'Területi beállítások',
    'server_interface__tabs_skins' => 'Felszínek',
    'server_interface__tabs_interface_templates' => 'Kezelőfelület sablonok',
    'bt_server_interface' => 'Kezelőfelület beállítások',
    'pb__server_interface' => 'Kezelőfelület beállítások',

    'bt_wizard_next' => 'Tovább ť',
    'bt_wizard_prev' => '<< Vissza',

    '__limit_exceeded_max_dom_server' => 'Nem üzemeltethet több domaint e kiszolgálón, mivel elérte a licenckulcsa által a kiszolgálóra meghatározott domain szám korlátot. E probléma megoldása érdekében forduljon a szolgáltatójához.',
    '__limit_exceeded_max_subdom_server' => 'Nem üzemeltethet több aldomaint e kiszolgálón. Forduljon a szolgáltatójához.',
    '__limit_exceeded_max_dom_aliases_server' => 'Nem állíthat be több domain aliast a kiszolgálón. Forduljon a szolgáltatójához.',
    '__limit_exceeded_max_wu_server' => 'Nem hozhat létre több webes felhasználót, mivel elérte a licenckulcsa által a kiszolgálóra engedélyezett webes felhasználó szám korlátot. E probléma megoldása érdekében forduljon a szolgáltatójához.',
    '__limit_exceeded_max_mn_server' => 'Nem hozhat létre több postafiókot e kiszolgálón, mivel elérte a licenckulcsa által a kiszolgálóra meghatározott postafiók szám korlátot. E probléma megoldása érdekében forduljon a szolgáltatójához.',

    '__limit_exceeded_max_cl_useradmin' => 'Elérte a licenckulcsa által meghatározott ügyfélszámla szám korlátot (%2).',
    '__limit_exceeded_max_dom_useradmin' => 'Elérte a licenckulcsa által meghatározott domain szám korlátot (%2).',
    '__limit_exceeded_max_subdom_useradmin' => 'Elérte a licenckulcsa által meghatározott aldomain szám korlátot (%2).',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Elérte a licenckulcsa által meghatározott domain alias szám korlátot (%2).',
    '__limit_exceeded_disk_space_useradmin' => 'Nem maradt szabad lemezterülete.',
    '__limit_exceeded_max_wu_useradmin' => 'Elérte a licenckulcsa által meghatározott webes felhasználói fiók szám korlátot (%2).',
    '__limit_exceeded_max_db_useradmin' => 'Elérte a licenckulcsa által meghatározott adatbázis szám korlátot (%2).',
    '__limit_exceeded_max_box_useradmin' => 'Elérte a licenckulcsa által meghatározott postaláda szám korlátot (%2).',
    '__limit_exceeded_max_mn_useradmin' => 'Elérte a licenckulcsa által meghatározott e-mail fiók szám korlátot (%2).',
    '__limit_exceeded_max_maillists_useradmin' => 'Elérte a licenckulcsa által meghatározott levelezési lista szám korlátot (%2).',

    '__limit_exceeded_max_dom_userclient' => 'Elérte a domain szám korlátot (%2).',
    '__limit_exceeded_max_subdom_userclient' => 'Elérte a szolgáltatója által engedélyezett aldomain szám (%2) korlátot.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Elérte a domain alias szám korlátot (%2).',
    '__limit_exceeded_disk_space_userclient' => 'Elérte e lemezterület-használati korlátot (%2).',
    '__limit_exceeded_max_traffic_userclient' => 'Elérte a havi használt sávszélesség korlátot (%2).',
    '__limit_exceeded_max_wu_userclient' => 'Elérte a szolgáltatója által engedélyezett webes felhasználói szám (%2) korlátot.',
    '__limit_exceeded_max_db_userclient' => 'Elérte az adatbázis szám korlátot (%2).',
    '__limit_exceeded_max_box_userclient' => 'Elérte a postaláda szám korlátot (%2).',
    '__limit_exceeded_max_maillists_userclient' => 'Elérte a levelezési lista szám korlátot (%2).',
    '__limit_exceeded_expiration_userclient' => 'Lejárt %2 számlája.',

    '__limit_exceeded_max_subdom_userdomain' => 'Elérte a szolgáltatója által engedélyezett aldomain szám (%2) korlátot.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Elérte a domain alias szám korlátot (%2).',
    '__limit_exceeded_disk_space_userdomain' => 'Elérte e lemezterület-használati korlátot (%2).',
    '__limit_exceeded_max_traffic_userdomain' => 'Elérte a havi használt sávszélesség korlátot (%2).',
    '__limit_exceeded_max_wu_userdomain' => 'Elérte a webes felhasználói foók szám korlátot (%2).',
    '__limit_exceeded_max_db_userdomain' => 'Elérte az adatbázis szám korlátot (%2).',
    '__limit_exceeded_max_box_userdomain' => 'Elérte a postaláda szám korlátot (%2).',
    '__limit_exceeded_max_maillists_userdomain' => 'Elérte a levelezési lista szám korlátot (%2).',
    '__limit_exceeded_expiration_userdomain' => 'Lejárt %2 számlája.',

    'sapp_error_validation_not_found' => 'Nem lehetséges a webalkalmazás ellenőrzése, mivel nem található az egyik szükséges fájl (%1). Forduljon a műszaki támogatási képviselőhöz segítségért.',
    'sapp_error_validation_spec_failed' => 'Nem felel meg az AppPacks specifikációnak a webalkalmazás: %1.',
    'sapp_error_validation_register' => 'Nem lehetséges ezen "%1" könyvtárban található webalkalmazás regisztrálása: %2 El kell távolítania a webalkalmazást a kiszolgálóról, mivel nem működik megfelelően.',

    'sapp__install_failed' => 'Nem sikerült a webalkalmazás telepítése: %1',
    'sapp__install_res_failed' => 'Nem sikerült a kért erőforrás létrehozása.',

    'server_preferences__subdomains_blog_and_photo' => 'Blog létrehozás és Fényképgyűjtemény aldomainek rendelkezésre állása alapértelmezés szerint',
    'plesk_key__blog_and_photo' => 'A Blog létrehozás és Fényképgyűjtemény aldomain alapértelmezett állapotának kezelését lehetővé tevő jelölőnégyzet',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Nem lehetséges az IP-cím típus dedokáltra változtatása, mivel az egynél több felhasználóhoz van hozzárendelve.',

    // 8.1.1

    '__write_modify_warning' => 'További írási/módosítási engedélyek kiválasztásával biztosítható egyes webalkalmazások helyes működése, de egyidejűleg jelentősen növeli a biztonsági kockázatokat.',
    '__write_modify_subdomain_warning' => 'További írási/módosítási engedélyek kiválasztásával biztosítható egyes webalkalmazások helyes működése, de egyidejűleg jelentősen növeli a biztonsági kockázatokat.',

    'phosting__php_incorrect_version_used' => "PHP-verzió problémák észlelése történt. E problémák kiküszöbölésére alább jelölje be a kívánt PHP-verzió jelölőnégyzetét, majd kattintson az OK gombra. A PHP-eszköznek e domainen történő kikapcsolására, a PHP-verzió kiválasztása nélkül kattintson az OK gombra",
    'fp__mail_preferences' => 'Levelezési beállítások',

    'mail__invalid_white_pattern' => 'Érvénytelen a meghatározott érték. A következő formátumot használja: mail@example.com e-mail címek esetén, például.com domainek számára.',
    'mail__invalid_black_pattern' => 'Érvénytelen a megadott érték. A következő formátumot használja: mail@example.com e-mail címek számára, például.com domainek számára.',

    'resp_edit__reply_as_html' => 'HTML-tartalomkénti küldés',
    'exception__path_very_long' => "Az elérési út túlságosan hosszú. Ellenőrizze, hogy %1 számnál kevesebb karakter szerepel-e az elérési úton.",

    // 8.2


    //SAPP
    'sapp_on' => 'Be',
    'sapp_off' => 'Ki',
    'sapp_directive_aspect' => 'Szükséges',
    'sapp_databases_num' => 'Adatbázisok',
    'sapp_db_required' => 'Szükséges',
    'sapp_Required' => 'Szükséges',
    'sapp_Variant' => 'Változat',
    'sapp_db_id' => 'Adatbázis azonosító',
    'sapp_db_id_type' => 'Adatbázis (azonosító: %1) típus',
    'sapp_db_id_min_version' => 'Adatbázis (azonosító: %1) min. verzió',
    'sapp_db_id_table_prefix' => 'Adatbázis (azonosító: %1) táblázatok előtagja',
    'sapp_Default' => 'Alapértelmezett érték',
    'sapp_apache_mod_req' => 'Apache modul',
    'sapp_dbtype_not_installed' => 'nincs telepítve',
    'sapp_apache_mod_not_installed' => 'nincs telepítve',
    'sapp_error_invalid_type' => '"%1" alkalmazás nem támogatja a szükséges műveletet.',
    'sapp_error_unknown_app_type' => 'Nem támogatott alkalmazástípus: %1.',
    'sapp__ssl_text' => 'Telepíti egy "http://" vagy "https://" virtuális állomásra az alkalmazást?',
    'sapp__app_to_upgrade' => 'Magasabb verzióra frissítendő alkalmazások',
    'sapp__upgrade_apps_title' => 'Alkalmazások magasabb verzióra frissítése',
    'sapp__upgrade_to_ver' => 'A következő verzióra frissítés;',
    'sapp__choose_pkg_ver' => 'Egy csomag kiválasztása',
    'sapp__pkg_cant_upgrade_pkg' => '"%1" csomag nem használható "%2" webalkalmazás magasabb verzióra frissítésére.',
    'sapp__app_ugrade_error' => 'Nem lehetséges az alkalmazás frissítése: %1. Forduljon a rendszergazdájához.',
    'sapp__no_suitable_db_found' => 'Nem található megfelelő adatbázis.',
    'sapp__upgrade_success' =>  'Az alkalmazás magasabb verzióra frissítése sikerült.',
    'sapp__pkg_info_changelog' => 'Korábbi változások',
    'sapp_requirement_legend' => 'Az alkalmazás által igényelt üzemeltetési funkciók',

    // other
    'bt_apply' => 'Alkalmaz',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Egy e-mail alias létrehozásához be kell kapcsolnia e postafiókban található postaládát. Bekapcsolja a postaládát?',
    'mn_edit__mailbox_disable_if_has_alias' => 'A postaláda kikapcsolása eltávolítja az e-mail aliasokat, mivel azok leállnak. Kikapcsolja a postafiókot?',
    'antivirus__disable_reason_install' => 'Nem végezhet vírusvédelmi kezelést, mivel nincs vírusvédelem telepítve.',
    'antivirus__disable_reason_key' => 'Nem végezheti a vírusvédelem kezelését, mivel nem rendelkezik megfelelő aktivált licenckulccsal.',
    'antivirus__disable_reason_deny_personal_settings' => 'Nem végezheti a vírusvédelem kezelését, mivel a kiszolgáló házirendje tiltja az egyéni virusvédelmi beállítások használatát.',
    'change_foreign_user_password' => 'Jelszó módosítása',
    'change_foreign_user_password_hint' => "Nem tartozik ezen alkalmazáshoz a felhasználó. Kattintson a hivatkozásra egy másik alkalmazásra ugráshoz, majd ott változtassa felhasználó jelszavát. Ennek elvégzéséhez rendelkeznie kell a megfelelő jogosultságokkal az alkalmazásban.",
    'cf_url_text' => 'JDBC URL-cím',
    'cf_sendStringParametersAsUnicode_text' => 'Karakterlánc formátuma',
    'lang_unknown' => 'Ismeretlen nyelv',
    'pb__cl_ed' => 'Ügyfél adatok',
    'pb__actionlog' => 'Műveleti napló',
    'pb__cl_limits' => 'Ügyfél korlátok',
    'pb__edit' => 'Szerkesztés',
    'pb__subdom_edit' => 'Üzemeltetési beállítások',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Postaláda tartalmak biztonsági mentése',

    'maillist_import_result' => "\nA fájlban található e-mail címek összesített száma: %1\nimportált e.mail címek száma: %2\na már meglévő e-mail címek száma: %3\nmegadott fájlban található duplikált e-mail címek száma: %4\nfájlban található érvénytelen e-mail címek száma: %5",
    'maillist_import_error' => 'Nem lehetséges e-mailcímlista importálása.',

    'dom_pref__external_mail_srv' => "Az IP-címmel rendelkező külső levelezési kiszolgálóra átirányítás",
    'mn_edit__store_messages' => 'Postaláda',

    // aps

    'sapp__before_upgrade_notice' => 'A magasabb verzióra frissítés előtt célszerű elvégezni az alkalmazás és felhasználói adatok biztonsági mentését.',
    'sapp__application_properties' => 'Alkalmazás tulajdonságok',
    'sapp__application_root_descr' => 'Az alkalmazás főoldala',

    'sapp__aps_license_invalid_id' => 'Érvénytelen a licenckulcs azonosító: %1.',
    'sapp__aps_lic_key_alredy_exists' => '%1 kulcsszámú licenc már létezik az adatbázisban.',
    'sapp__aps_lic_del_used' => 'Nem lehetséges a licenckulcs törlése, az egyik telepített alkalmazás használja.',
    'sapp__aps_lic_del_unknown' => 'Nem lehetséges a licenckulcs törlése: %1',
    'sapp__aps_cappi_duplicate' => "Ezen alkalmazás már létezik az ügyfél alkalmazáskészletében.",
    'sapp__appi_not_shared_no_install' => "Nincs ilyen alkalmazás az ügyfél alkalmazáskészletében. Ha egy webhelyre akarja telepíteni ezen alkalmazást, akkor először adja az ügyfél alkalmazáskészletéhez ezen alkalmazást.",
    'sapp__appi_shared_not_client' => "Nincs ilyen alkalmazás az ügyfél alkalmazáskészletében. Ha egy megadott magasabb verzióra akarja frissíteni az alkalmazást, akkor először az ügyfél alkalmazáskészletéhez kell adnia ezen alkalmazásverziót.",
    'sapp__apply_license_script_not_found' => 'Nem található e webalkalmazás "licenc alkalmazás" nevű parancsprogramja.',
    'sapp__unable_to_activate_key' => 'Hiba történt egy licenckulcs aktiválási kísérlete során: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Olyan telepített webalkalmazások vannak, melyek igénylik e webalkalmazás meglétét a rendszerben.',
    'sapp__unable_to_delete_ai_in_pool' => 'Ezen alkalmazás még az ügyfél készletében szerepel. Ha el akarja távolítani ezen alkalmazást, akkor először el kell azt távolítania az összes ügyfél alkalmazáskészletéből vagy díjmentessé kell tennie.',
    'sapp__unable_to_delete_app_template' => 'Nem lehetséges #%1 alkalmazás eltávolítása: %2',
    'sapp__limit_exceeded_client' => 'Elérte a webalkalmazás (%2) telepíthetőségi számának a korlátját.',


    // atis module

    '_week_on' => 'hét',
    '__week_first' => 'első',
    '__week_second' => 'második',
    '__week_third' => 'harmadik',
    '__week_fourth' => 'negyedik',
    '__week_last' => 'utolsó',
    '__not_started' => 'Várakozás',
    '__started' => 'Futtatás',
    '__cancel_pending' => 'Megszakítás',
    '__canceled' => 'Megszakítva',
    '__error' => 'Hiba',
    '__done' => 'Kész',

    '__php_cgi_handler' => 'CGI-alkalmazás',
    '__php_isapi_handler' => 'ISAPI-bővítmény',
    '__php_fastcgi_handler' => 'FastCGI-alkalmazás',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'a következőkénti futtatás;',

    'cf_dbfolder_text' => 'Adatbázis mappa',
    'cf_isnewdb_text' => 'Adatbázis létrehozása',
    'cf_isnewdb_title' => 'Jelölje be a jelölőnégyzetet, ha adatbázist kell létrehozni.',

    'pb__site_apps_upgrade' => 'Webalkalmazás magasabb verzióra frissítése',

    'detach' => 'Kapcsolat bontása',
    'preferences' => "Jelszó megváltoztatása",

    'toolsbar__switch_user?' => "Biztosan be akar jelentkezni egy másik felhasználói számlába?",
    '__aps_left' => 'Megmaradt telepített példányok',
    'aps__license_key' => 'Licenckulcs',
    'aps__download_code' => 'Licenckulcs letöltése és aktiválási kód',
    'aps__license_key_hint' => 'Lekérés a licenckiszolgálóról az aktiválási kód használatával',
    'aps__database_not_available' => 'Nem áll rendelkezésre, ellenőrizze a domain- vagy ügyfélkorlátot.',
    'aps__yes' => 'igen',
    'aps__no' => 'nem',
    '__click_to_enlarge' => 'Kattintson a nagyításhoz.',
    'site_apps__back_to_list' => 'Visszatérés a listához',
    'sapp__pkg_info_installation_requirements' => 'Telepítési követelmények',
    '__close_window' => 'Bezárás',

    //SAPP END

    'skin_info__already_default' => 'Alapértelmezettként már be van állítva a felszín.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus beállítások %1 számára',
    'drweb:properties_legend' => 'Beállítások',
    'drweb:status' => 'Levelek vírusok szempontjából ellenőrzése',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder varázsló',
    'dom_site_builder' => 'Kattintson a Presence Builder varázsló megnyitására.',
    'sb_plesk_admin_url' => 'Presence Builder kiszolgáló URL-címe. Ellenőrizze, hogy e cím megfelel-e a DNS követelményeinek.',
    'sb_plesk_admin_login' => 'Kiszolgáló adminisztrátor Presence Builder bejelentkezési felhasználóneve',
    'sb_plesk_admin_password' => 'Adminisztrátor jelszava',
    'sb_sitebuilder_preferences' => 'Presence Builder adminisztrátor hitelesítő adatok',
    'sb__server' => 'Presence Builder adminisztrátor beállítások',
    'sb__sitebuilder_support' => 'Presence Builder weboldalkészítő támogatása',
    'sb_keep_sb_user' => 'Megfelelő felhasználói számla megőrzése a Presence Builder weboldalkészítőben',
    'sb_create_sb_user' => 'Megfelelő felhasználói számla létrehozása a Presence Builder weboldalkészítőben',
    'sb__build_site_using_sitebuilder' => "Webhely létrehozása Presence Builder weboldalkészítő használatával",
    'sb_no_current_sb_server_set' => 'Még nincs konfigurálva a Presence Builder weboldalkészítőhöz a kapcsolódás: egy olyan A rekordot kell adnia a DNS-zónához, mely a Presence Builder kiszolgálóra mutat.',
    'sb_unable_update_sb_server_sb_return_message' => "Nem lehet adatokat beolvasni a Presence Builder rendszerből:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Nem lehet a Presence Builder weboldalkészítőhöz kapcsolódni: helytelen felhasználónév és jelszó.",
    'sb_init_sb_manager' => "Presence Builder kezelő inicializálása: %1",
    'sb_err_couldnt_connect_sb' => "Nem sikerült a Presence Builder rendszerhez kapcsolódni.",
    'sb_err_client_dont_have_sbuser' => "Ezen ügyfél nem rendelkezik felhasználói számlával a Presence Builder weboldalkészítőben.",
    'sb_err_sitebuilder_not_configured' => "Nincs konfigurálva a Presence Builder weboldalkészítő.",
    'sb_err_you_dont_have_sbaccount' => "Nem sikerült a Presence Builder weboldalkészítőben a belépésének az engedélyezése.",
    'sb_error_critical_during_operation' => "A következő hiba lépett fel a Presence Builder weboldalkészítőben:\n%1",
    'sb_err_sso_is_not_enabled' => "Nincs bekapcsolva az Egyszeri bejelentkezés támogatás a Plesk kezelőpanelen.",

    'warning__super_zone_exist' => "Megtörtént %1 zóna létrehozása, azonban e zónanév egy már létező %2 zóna alzónájának a neve, mely egy másik %3 felhasználóhoz tartozik. Ez lehetséges, de ellenőrizze, hogy a helyes felhasználói számlát választotta-e ki.",
    'error__super_zone_exist' => "Nem lehetséges a DNS-zónát létrehozni, mivel egy másik felhasználóhoz tartozik szuperzónája.",

    'locales__files_not_exits' => 'Nem lehetséges a területi beállítás változtatása: nem találhatóak meg a rendszerben a megadott kezelőfelület nyelvi csomag fájljai.',
    'locales__unavailable' => 'Nem lehetséges a területi beállítás változtatása: nem áll rendelkezésre a megadott kezelőfelület nyelv.',

    // DB BU

    'pb__dbbackup_list' => 'Adatbázis biztonsági másolat fájlok',
    // server
    'dbbackup__server_backup_settings' => 'Biztonsági mentés',
    'dbbackup__network_temp_dir' => 'Ideiglenes hálózati könyvtár',
    'dbbackup__network_user' => 'Felhasználónév',
    'dbbackup__network_pass' => 'Jelszó',
    // domain
    'dbbackup__add_database_legend' => 'Biztonsági másolattal rendelkező adatbázis visszaállítása',
    'dbbackup__add_database_restore' => 'Adatbázis biztonsági mentési fájlból történő visszaállítása',
    'dbbackup__add_database_file' => 'Adatbázis biztonsági másolat fájl',
    'dbbackup__add_database_user' => 'Alapértelmezett felhasználónév',
    'dbbackup__add_database_pass' => 'Alapértelmezett felhasználói jelszó',
    'dbbackup__add_database_pass2' => 'Alapértelmezett felhasználói jelszó megerősítése',

    'bt_dbbackup_now' => 'Biztonsági mentés',

    'bt_repair' => 'Javítás',

    'dbbackup__mssql_dump_upload_not_allowed' => 'A szolgáltató megtiltotta SQL-kiszolgáló adatbázis kiírások feltöltését.',

    // APS categories

    'cf_invalid_password' => 'Nem haladhatja meg a 16 karaktert a jelszó hossza.',
    'cf_invalid_description_length' => 'Nem haladhatja meg a 256 szimbólumot a leírás hossza.',
    'ip_addr__ip_used_by_external_mail_server' => '%1 IP-címet külső levelezési kiszolgáló már használja.',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Érvénytelen a megadott FTP-fiók felhasználónév vagy jelszó. Helyes FTP-felhasználói hitelesítő adatokat adjon meg.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Megtörtént a sorozatszám változtatási korlát elérése. Nem végezhető ma több DNS-zóna változtatás.',
    'dns__zone_apply_changes' => 'Még nem történt meg a DNS-rekordok változtatásainak mentése. Alább szerepelnek kiemelve az elvégzett változtatások. Kattintson a Frissítés gombra változtatások DNS-zónára történő alkalmazására vagy a Visszaállítás gombra a változtatások abbahagyására.',
    'dns__update_dns_zone' => 'Kattintson a DNS-rekordok változtatásainak a mentésére.',
    'dns__revert_dns_zone' => 'Kattintson a DNS-rekordok változtatásainak a törlésére.',
    'bt_revert' => 'Visszaállítás',
    'dns__dns_zone_has_beed_updated' => 'Megtörtént a DNS-rekordok mentése.',
    'dns__dns_zone_has_beed_reverted' => 'Megtörtént a DNS-rekordok változtatásainak törlése.',
    'db__nondefault_server_not_allowed' => 'Nem engedélyezett nem alapértelmezett alapbázis-kiszolgáló használata.',

    'site_apps__non_removable' => 'Eltávolíthatatlan elemek',
    'site_apps__non_removable_items' => 'Nem távolíthatóak el a következő webalkalmazások:',

    'rpt_reseller_section_general' => 'Általános',
    'rpt_reseller_section_domains' => 'Domainek',
    'rpt_reseller_section_clients' => 'Ügyfelek',
    'statistics__cl_active_domains' => "Aktív domainek",
    'rpt_reseller_cl_domains' => "Domainek",
    'rpt_reseller_cl_subdomains' => "Aldomainek",
    'by__cl_domains' => "ügyfelek domainjei",
    'dom_ctrl__cl_mboxes' => "Postaládák",
    'rpt_reseller_cl_redirects' => "Továbbítók",
    'rpt_reseller_cl_mail_groups' => "Levelezési csoportok",
    'rpt_reseller_cl_mail_resps' => "Automatikus válaszok",
    'rpt_reseller_cl_mail_lists' => "Levelezési listák",
    'rpt_reseller_cl_web_users' => "Webes felhasználók",
    'rpt_reseller_cl_data_bases' => "Adatbázisok",

    'statistics__active_clients' => 'Aktív előfizetéssel rendelkező ügyfelek',
    'statistics__clients_active_domains' => 'Aktív domainek',
    'statistics__clients_doms' => 'Domainek',
    'statistics__cl_doms' => 'Domainek',
    '__clients_subdomains' => 'Aldomainek',
    '__clients_domains' => 'Domainek',
    'dom_ctrl__clients_mboxes' => 'Postaládák',
    'dom_ctrl__clients_redir' => 'Továbbítók',
    'dom_ctrl__clients_mg' => 'Levelezési csoportok',
    'dom_ctrl__clients_resp' => 'Automatikus válaszok',
    'dom_ctrl__clients_maillists' => 'Levelezési listák',
    'dom_ctrl__clients_wu' => 'Webes felhasználók',
    'dom_ctrl__clients_db' => 'Adatbázisok',

    'dom_ctrl__cl_redir' => 'Továbbítók', // to resolve!
    'dom_ctrl__cl_mg' => 'Levelezési csoportok', // to resolve!
    'dom_ctrl__cl_resp' => 'Automatikus válaszok', // to resolve!
    'dom_ctrl__cl_maillists' => 'Levelezési listák', // to resolve!
    'dom_ctrl__cl_wu' => 'Webes felhasználók', // to resolve!
    'dom_ctrl__cl_db' => 'Adatbázisok', // to resolve!

    'rpt_cl_section_clients' => 'Ügyfelek',

    'rpt_admin_section_general' => 'Általános',
    'rpt_admin_section_resellers' => 'Viszonteladók',
    'rpt_admin_section_clients' => 'Ügyfelek',
    'rpt_admin_section_personal_clients' => 'Saját ügyfelek',
    'rpt_admin_section_domains' => 'Domainek',
    'rpt_admin_section_personal_domains' => 'Személyes domainek',

    'rpt_reseller_section_personal_domains' => 'Személyes domainek',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Túlértékesítés engedélyezése",
    'limits__reseller_oversell_description' => "Az eredeti erőforrás kiosztásnál több erőforrás értékesítését teszi a túlértékesítés a viszonteladó számára lehetővé. Ha engedélyezett a túlértékesítés, akkor a viszonteladó értékesítését a tényleges erőforrás-használat szabályozza a kezdeti erőforrás kiosztás helyett.",
    'limits__overuse_block_text' => "Túlhasználati házirend",
    'limits__overuse_block_true_text' => "Nem engedélyezett a túlértékesítés.",
    'limits__reseller_overuse_block_true_description' => "Blokkolja az erőforrás túlhasználatot. Az aktuális erőforrás-használat meghaladja az eredeti erőforrás kiosztást.",
    'limits__overuse_block_false_text' => "Engedélyezett a túlértékesítés.",
    'limits__reseller_overuse_block_false_description' => "Ne blokkolja az erőforrás túlhasználatot annak érdekében, hogy lehetővé tegye a viszonteladó számára az eredetinél több erőforrás használatát. A tényleges erőforrás-használat meghaladja az eredeti erőforrás kiosztást.",
    'limits__reseller_overuse_notify_text' => "Értesítse a viszonteladót az erőforráskorlátok eléréséről.",
    'reseller_perm__manage_sh_access_disabled' => "Viszonteladó nem engedélyezheti vagy tilthatja héjhoz való hozzáférést.",
    'reseller_perm__manage_sh_access_chrooted' => "Viszonteladó engedélyezheti kizárólag egy chrootolt környezethez való hozzáférést.",
    'reseller_perm__manage_sh_access_any' => "Viszonteladó engedélyezheti bármely típusú héjhoz való hozzáférést.",
    'template__reseller_num_excl_ips' => "Dedikált IP-címeknek a viszonteladóhoz rendelése",

    // Reseller's Home page
    'domains__reseller_info' => "%1 ügyfél, %2 domain, %3 felhasznált lemezterület, %4 átvitt adat.",
    'domains__reseller_info_hiding_traffic' => "%1 ügyfél, %2 domain, %3 felhasznált lemezterület.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Az összes webalkalmazás most kategóriákba van sorolva, mely megkönnyíti a megfelelő alkalmazás kiválasztását a telepítéshez.",
    'feature__domainkeys__reseller' => "Használhatja a DKIM e-mail küldő hitelesítési mechanizmust a levélszemét és adathalászati célú e-mailek számának a csökkentésére.",

    '__reseller_form' => "Viszonteladó űrlap",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "E sablon más ügyfelek számára rendelkezésre bocsátása",
    'template__shared_description' => "Akkor válassza ki e beállítást, ha azt akarja, hogy az ügyfelei használhassák e sablont.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "A domain adminisztrátor nem engedélyezheti vagy tilthatja héjhoz való hozzáférést.",
    'domain_perm__manage_sh_access_chrooted' => "A domain adminisztrátor engedélyezheti kizárólag egy chrootolt környezethez való hozzáférést.",
    'domain_perm__manage_sh_access_any' => "A domain adminisztrátor engedélyezheti bármely típusú héjhoz való hozzáférést.",

    // APS Catalog
    'bt_add_to_vault' => "Tárolóhoz adás",
    'bt_hide_updates' => "Rendelkezésre álló frissítések elrejtése",
    'bt_show_updates' => "Rendelkezésre álló frissítések megjelenítése",

    '__site_apps__applications' => "Alkalmazások",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "A tárolóhoz adás érdekében kiválasztott alkalmazások",
    'site_apps__application_selected' => "Kijelölt",
    'site_apps__currently_in_vault' => "Más verziók már szerepelnek a tárolóban:",
    'site_apps__new_versions' => "Új verziók:",
    'site_apps__patches' => "Javítások:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "A tárolóhoz adás érdekében üzemezett alkalmazások száma: %1",
    'site_apps__applications_downloading_now' => "A következő alkalmazások letöltése folyik: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Már szerepel a tárolóban.",

    // Server > Action Log
    'bt_skin_edit' => "Felszín leírás szerkesztése",
    'limits__oversell_legend' => "Túlértékesítés",
    'limitsManager__limit_available_error' => "Nem lehetséges a kívánt erőforrás mennyiség kiosztása (%%quantity%% %%limitName%%). Csupán %%available%% %%limitName%% áll rendelkezésre.",
    'limitsManager__limit_reserved_error' => "Nem lehetséges a kívánt erőforrás-használati korlát beállítása (%%quantity%% %%limitName%%), mivel az új érték kisebb, mint az ügyfelei számára fenntartott vagy maga által használt erőforrások mennyisége (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Nem lehetséges a kívánt erőforrás-használati korlát beállítása (%%quantity%% %%limitName%%), mivel az új érték kisebb, mint a számlája és a webhelyei által már jelenleg is felhasznált erőforrások mennyisége (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "Erőforrás-használat",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-alkalmazás katalógus",
    'site_apps__applications_have_updates' => "A következő alkalmazások magasabb verzióra frissített verziói állnak rendelkezésre:\n%1\nA frissítések megtekintésére ellenőrizze, hogy látható-e a Keresési terület, jelölje be a <b>Csak a frissítések megjelenítése</b> jelölőnégyzetet, majd keresse meg a szükséges alkalmazásokat.",
    'site_apps__progress_adding_to_vault' => "A tárolóhoz adás:",
    'site_apps__progress_done_message' => "Előrehaladás:",
    'site_apps__progress_applications_left' => "%1 / %2 alkalmazás maradt",
    'site_apps__download_item_long_task_title' => "APS-alkalmazás (%1) letöltése",
    'site_apps__download_transaction_long_task_title' => "APS-alkalmazás APS-katalógusból letöltése",
    'site_apps__last_check_for_updates' => "Utolsó frissítés keresés: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Az összes ütemezett alkalmazás hozzáadása sikerült az Alkalmazástárolóhoz.",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 ütemezett alkalmazás hozzáadása sikerült az Alkalmazástárolóhoz.",
    'site_apps__no_search_results' => 'Nem találhatók alkalmazások Próbálkozzon más keresési kéréssel vagy kategóriánként végezze az alkalmazások böngészését.',
    'site_apps__search_results_title' => 'Keresési eredmények',
    '__site_apps__search_by_application' => 'Alkalmazás neve',
    '__site_apps__search_by_vendor' => 'Forgalmazó',
    '__site_apps__search_by_vendor__all' => 'Az összes forgalmazó',
    '__site_apps__search_by_packager' => 'Csomagoló',
    '__site_apps__search_by_certification_level' => 'Tanúsítási szint',
    '__site_apps__search_by_cert__any' => 'Bármely típusú',
    '__site_apps__search_by_cert__silver_and_higher' => 'Ezüst és magasabb',
    '__site_apps__search_by_cert__gold_and_higher' => 'Arany és magasabb',
    '__retry' => 'Újból',
    'site_apps__application_packager_site' => 'Csomagoló',
    'site_apps__add_to_pool_message' => "A \"mindenki számára rendelkezésre áll\" jelzésű alkalmazások elosztása telepítési példány korlátozás nélkül történik az összes viszonteladó és ügyfél számára. A korlátozott alkalmazások elosztása kézzel, egyéni alapon, megadott számú telepített példánnyal történik az összes viszonteladó és ügyfél számára.",
    'site_apps__make_available_for_all' => "Biztosítsa az összes felhasználó számára a kiválasztott alkalmazások rendelkezésre állását.",

    'site_apps__broadcast_app_text' => "A \"mindenki számára rendelkezésre áll\" jelzésű alkalmazások elosztása telepítési példány korlátozás nélkül történik az összes viszonteladó és ügyfél számára. A korlátozott alkalmazások elosztása kézzel, egyéni alapon, megadott számú telepített példánnyal történik az összes viszonteladó és ügyfél számára.",
    'site_apps__broadcast_app_name' => 'Biztosítsa az összes felhasználó számára a rendelkezésre állást.',

    // User Application Pool per application
    'site_apps__available_clients' => 'Rendelkezésre álló felhasználók',
    'site_apps__no_more_clients_to_add_to_pool' => 'Nincs több felhasználói számla, melynek ezen alkalmazást biztosíthatja.',

    // Installed application instances
    'site_apps__installations' => 'Telepített példányok',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domain név és IP-cím",
    '__assign_ip_address' => "IP-cím hozzárendelése",
    '__switch_on_service' => "Szolgáltatás bekapcsolása",
    '__hosting_configuration' => "Üzemeltetés konfigurálása",
    '__vrt_hst' => "Webhely üzemeltetés",
    '__vrt_hst_hint' => "E kiszolgálón üzemeltessen egy webhelyet.",
    '__fwd' => "Továbbítás",
    '__web_hosting_settings' => "Üzemeltetési beállítások",
    '__fwd_hint' => "Irányítsa át más webhelyre a látogatókat.",
    '__none_hint' => "Most ne üzemeltessen webhelyet.",
    '__login_hint' => "Webhelye FTP-szolgáltatáson keresztüli hozzáférésre szolgál e felhasználónév.",
    '__password_hint' => "Webhelye FTP-szolgáltatáson keresztüli hozzáférésre szolgál e jelszó.",
    '__advanced_hosting_setup' => "Speciális webhely üzemeltetési beállítások konfigurálása",
    '__domain_creation_successful' => "Megtörtént a domain eltávolítása.",
    'bt_hosting_settings' => "Üzemeltetési beállítások",
    '__change_hosting_type' => "%1 domain üzemeltetési típusának megváltoztatása",
    '__hosting_type_change_warning' => "Amikor megváltoztatja a továbbítás üzemeltetési típusát, akkor vagy nincs üzemeltetés, akkor megtörténik a webhelyével kapcsolatos összes fájl és könyvtár eltávolítása. Feltétlenül készítsen a webhelyéről egy helyi másolatot.",
    '__current_hosting_type' => "Aktuális üzemeltetés típus",
    '__new_hosting_type' => "Új üzemeltetés típus",
    '__fwd_settings' => "Továbbítási beállítások",
    '__fwd_settings_legend' => "Továbbítási beállítások",
    '__fwd_destination_url' => "Cél URL-cím",
    '__fwd_type' => "Továbbítási típus",
    '__fwd_type_standart' => "Normál továbbítás",
    '__fwd_type_standart_hint' => "Irányítsa át a webhely látogatókat másik webhelyre és jelenítse meg a számukra a cél címét, így tudni fognak az átirányításról.",
    '__fwd_type_frame' => "Kerettovábbítás",
    '__fwd_type_frame_hint' => "Irányítsa át a webhely látogatókat másik webhelyre, de nem jelenítse meg a számukra a cél címét, így nem fognak tudni az átirányításról.",
    '__hosting_type_template_warning' => "Eltér a sablonban megadott típustól a kiválasztott üzemeltetés típus. Ha folytatja, akkor figyelmen kívül hagyásra kerülnek a kiválasztott sablon webüzemeltetési beállításai. Biztosan be akarja állítani a kiválasztott üzemeltetési típust?",

    '__no_resellers_selected' => "Legalább egy viszonteladói számlát ki kel választania.",

    'ippool_Manager__no_available_ips' => "Nincsenek szabad IP-címek az IP-cím készletben.",
    'ippool_Manager__ip_shared' => "megosztva",
    'ippool_Manager__ip_exclusive' => "dedikált",

    'ippoolManager__ip_shared' => "megosztva",
    'ippoolManager__ip_exclusive' => "dedikált",

    '__users_list' => "Felhasználók",
    '__users' => "Felhasználók",
    '__user_name' => "Felhasználó neve",

    'limit__name_max_dom_aliases' => "domain aliasok",
    'limit__name_max_subftp_users' => "további FTP-fiókok",
    'limit__name_max_mssql_db' => "Microsoft SQL-kiszolgáló adatbázisok",
    'limit__name_max_iis_app_pools' => "IIS-alkalmazási készlet",
    'limit__name_max_odbc' => "ODBC-kapcsolatok",
    'total_mboxes_quota_unsupported' => 'az e-mail kiszolgáló nem támogatja',
    'limit_soft__disk_space' => 'Értesítés a lemezterület eléréséről',
    'limit_soft__max_traffic' => 'Értesítés a forgalom eléréséről',
    'limitsManager__commit_failed' => "Nem lehetséges az erőforráskorlátok változtatása.",
    'limitsManager__date_in_past' => "Helytelen %1 lejárati dátum",
    'limitsManager__limit_not_supported' => "%1 erőforrás típus korlátai nem állíthatóak be.",
    'limitsManager__limit_oversell_inconsistency' => "Nem lehetséges a megadott erőforrás mennyiség kiosztása, ha ki van kapcsolva a túlértékesítés.",
    'limitsManager__limit_overuse_inconsistency' => "Meghaladja az erőforrás-használat a meghatározott korlátokat.",
    'limitsManager__no_resource_available' => "Nem állnak ilyen típusú erőforrások rendelkezésre (%%limitName%%). Kérelmezett %%quantity%%; rendelkezésre áll: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Nem állnak ilyen típusú erőforrások rendelkezésre (%%limitName%%) a szolgáltatójánál. Kérelmezett %%quantity%%; rendelkezésre áll: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "%1 értéknél korábbinak vagy azzal egyezőnek kell a lejárati dátumnak lennie.",
    'limitsManager__invalid_disk_space_limit' => "%1 értéknél kisebbnek vagy azzal egyezőnek kell a lemezterület nagyságának lennie.",
    'limitsManager__invalid_max_traffic_limit' => "%1 értéknél kisebbnek vagy azzal egyezőnek kell a forgalom nagyságának lennie.",
    'ippoolManager__ip_has_suballocations' => "Nem lehet megváltoztatni egy felhasználóhoz rendelt IP-cím típusát. %%reserved%% IP-címként, %%ip%% IP-cím már kiosztásra került a felhasználó(k) számára.",
    'ippoolManager__ip_is_already_in_pool' => "Ezen IP-cím már a felhasználóhoz van rendelve.",
    'ippoolManager__ip_is_not_in_pool' => "Nincs %%ip%% IP-cím a készletben.",
    'ippoolManager__can_not_allocate_ip' => "Csak %%available%% formájában áll %%ip%% IP-cím rendelkezésre.",
    'ippoolManager__unable_to_set_default_type' => "%%ip%% IP-cím nem osztható ki dedikáltként.",
    'ippoolManager__ip_used_by_hst_or_frw' => "%%ip%% már használatban van üzemeltetéshez.",
    'ippoolManager__active_anon_ftp_on_ip' => "Már be van kapcsolva a névtelen FTP-hozzáférés %%ip%% IP-cím számára.",
    'ippoolManager__no_vacant_ips' => "Nincsenek üres IP-címek.",
    'ippoolManager__no_available_ips' => "Nincsenek rendelkezésre álló IP-címek.",
    'templates__dublicate_name' => "Ilyen nevű sablon már létezik. Válasszon egy másik nevet e sablonnak.",
    'cl_perm__client_limits_exceeded' => "A megadott erőforrás korlátai meghaladják az üzemeltetési csomagja által megengedett értéket vagy a webhelyei által jelenleg használtnál kevesebb erőforrást biztosítanak ezen értékek.",
    'cl_perm__reseller_limits_exceeded' => "A megadott erőforrás korlátai meghaladják az üzemeltetési csomagja által megengedett értéket vagy felhasználói számlái és a webhelyei által jelenleg használtnál kevesebb erőforrást biztosítanak ezen értékek.",

    'site_apps__preferences_show_all_versions_title' => "A katalógusból letöltött minden alkalmazás teljes verziólistájának a megjelenítése",
    'site_apps__preferences_show_all_versions_hint' => "Ha ki van választva e beállítás, akkor előfordulhat, hogy jelentős idő szükséges mindegyik alkalmazás összes verziójának a beolvasásához a katalógus minden megnyitásakor. Ha nincs kiválasztva e beállítás, akkor csupán a legújabb verzió jelenik meg.",
    '__select_user_template' => "Felhasználói számla sablon alapján",
    'ip_already_added_to_all_clients' => "Ezen IP-cím már az összes felhasználóhoz hozzá van rendelve.",

    'site_apps__cancelled_apps' => "Törölte a következő alkalmazások hozzáadását: %2",

    'sb_url_is_not_resolved' => 'Nem oldható fel a megadott URL-cím: ellenőrizze a DNS-beállításokat. %1 URL-címnek meg kell felelnie a telepített Presence Builder honlapkészítővel rendelkező kiszolgáló IP-címének.',

    'ip_addr__is_last_on_interface' => 'Nem távolítható el %%ip%% IP-cím, mivel ez az utolsóként szereplő IP-cím a hálózati illesztőn.',
    'ip_addr__used_for_current_session' => 'Nem távolítható el %%ip%% IP-cím, mivel egy aktív munkamenet használja.',
    'ip_addr__used_for_hosting' => 'Nem távolítható el %%ip%% IP-cím, mivel egy webhely üzemeltetésére használja.',
    'ip_addr__is_main' => 'Nem távolítható el %%ip%% IP-cím, mivel ez a hálózati illesztő elsődleges IP-címe.',
    'ip_addr__ip_used_by_message_submission' => 'Nem távolítható el %%ip%% IP-cím, mivel e-mail küldésre használják',

    // RESELLER ACTION LOG

    '__cl_domains' => 'ügyfelek domainjei',
    'excl_ip_num' => 'Dedikált IP-cím',

    'sb_err_sitebuilder_not_installed' => 'Nincs telepítve a Presence Builder weboldalkészítő.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Nem vonható vissza a túlértékesítési engedély a felhasználótól, mivel a túlértékesítési módra áttéréskor a felhasználó a rendelkezésre állónál több erőforrást foglalt le.',
    'limitsManager__invalid_limit_value' => '%%value%% helytelen érték került %%limit_name%% korlát számára megadásra.',
    'limit__max_mn' => 'Postafiókok maximális száma',

    'limits__client_overuse_description' => 'A túlhasználati házirend igazítja el a Plesk kezelőpanelt az eredeti erőforrás kiosztás túllépése esetén a teendőről.',
    'limits__client_overuse_block_true_description' => 'Blokkolja az erőforrás túlhasználatot. Az aktuális erőforrás-használat meghaladja az eredeti erőforrás kiosztást.',
    'limits__client_overuse_block_false_description' => 'Ne blokkolja az erőforrás túlhasználatot annak érdekében, hogy lehetővé tegye a felhasználó számára az eredetinél több erőforrás használatát. A tényleges erőforrás-használat meghaladja az eredeti erőforrás kiosztást.',
    'limits__client_overuse_notify_text' => 'Értesítse az ügyfelet az erőforráskorlátok eléréséről.',

    'limits__domain_overuse_description' => 'A túlhasználati házirend igazítja el a Plesk kezelőpanelt az eredeti erőforrás kiosztás túllépése esetén a teendőről.',
    'limits__domain_overuse_block_true_description' => 'A túlhasználati házirend szabja meg a Plesk kezelőpanel számára az erőforrás túlhasználat esetén a teendőket.',
    'limits__domain_overuse_block_false_description' => 'Ne blokkolja az erőforrás túlhasználatot annak érdekében, hogy lehetővé tegye a domain számára az eredetinél több erőforrás használatát. A tényleges erőforrás-használat meghaladja az eredeti erőforrás kiosztást.',
    'limits__domain_overuse_notify_text' => 'Értesítse a domain tulajdonost az erőforráskorlátok eléréséről.',

    'dns__dns_rr_delete' => 'Eltávolításra kerülő elemek',
    'dns__delete_rr' => 'A következő DNS-rekordok kerülnek eltávolításra a DNS-zónából:',
    'dns__dns_rr_delete_non_removable' => 'Eltávolíthatatlan elemek',
    'dns__non_delete_rr' => 'Nem távolíthatóak el a következő DNS-rekordok:',
    'dns__dns_rr_delete_confirm_message' => 'Erősítse meg a DNS-rekordok eltávolítását.',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Ismeretlen webalkalmazás formátum: előfordulhat, hogy nem áll rendelkezésre telepítéshez és használathoz a webalkalmazás.',

    '__php_handler_type_desc' => 'PHP következőkénti futtatása;',
    'sfdk_domain_sign__failed' => 'Meghatározatlan hiba lépett fel, amikor megpróbálta bekapcsolni a DKIM levélszemét elleni védelmi rendszer segítségével az e-mail aláírást a domainen. A kiszolgáló hibanaplóját nézze meg további információkért.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Sikeres Plesk kulcs frissítési értesítés',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk kulcs frissítés halasztási értesítés',
    'pkey_notify__subj_update_error_notification' => 'Plesk kulcs frissítés hibaértesítés',
    'pkey_notify__update_successful' => '%1 frissítés sikeresen befejeződött.',
    'pkey_notify__update_failed_no_more_try' => 'Nem lehetséges %1 frissítése. Érvénytelen az elküldeni próbált kulcs. Tilos ezen kulcs ismételt frissítésével próbálkozni.',
    'pkey_notify__update_failed_try_later' => 'Nem végezhető el %1 frissítése: hiba történt a kulcsa feldolgozása során. Megpróbálhatja kézzel elvégezni a Plesk kezelőpanelbe való beolvasást (Eszközök és beállítások > Licencinformációk) vagy hagyni, hogy a Plesk kezelőpanel próbálja meg a frissítést a következő 24 órában. Ha már nem akar ilyen értesItést kapni, akkor távolítsa el ezt a Plesk kezelőpanelről.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domainek',
    'rpt_reseller_dom_subdomains' => 'Aldomain',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'Postal',
    'rpt_reseller_dom_redirects' => 'Továbbítók',
    'rpt_reseller_dom_mail_groups' => 'Lev.csop',
    'rpt_reseller_dom_mail_resps' => 'Aut. vál.',
    'rpt_reseller_dom_mail_antispam' => 'Levélszemét elleni védelem',
    'rpt_reseller_dom_mail_antivirus' => 'Vírusvédelem',
    'rpt_reseller_dom_mail_lists' => 'Lev. lista',
    'rpt_reseller_dom_web_users' => 'Webes felh',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Ügyfelek',
    '__cl_name' => 'Ügyfél neve',
    '__cl_creation_date' => 'Létrehozási dátum',
    '__clients_traffic' => 'Ügyfél forgalom',
    'rpt_reseller_cl_mail_antispam' => 'Levélszemét elleni védelem',
    'rpt_reseller_cl_mail_antivirus' => 'Vírusvédelem',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Nincs telepítve a Presence Builder weboldalkészítő.',
    'sitebuilder_disabled' => 'Ki van kapcsolva a Presence Builder weboldalkészítő.',
    'b_sitebuilder_disabled' => 'Ki van kapcsolva a Presence Builder weboldalkészítő.',
    'webmail_not_installed' => 'Nincs telepítve a webes levelezés szoftver.',
    'webmail_disabled' => 'Ki van kapcsolva a webes levelezési szolgáltatás.',
    'spamassassin_not_installed' => 'SpamAssassin nincs telepítve.',
    // pfu:
    'anonymous_ftp_shared' => 'Nem lehetséges névtelen FTP-szolgáltatás beállítása: megosztott IP-cím típus.',
    'anonymous_ftp_used' => 'Nem lehetséges névtelen FTP-szolgáltatás beállítása: egy másik domain használja névtelen FTP-szolgáltatásra az IP-címet.',
    // pfw:
    'aspdotnet_not_installed' => 'Nincs ASP.NET telepítve.',
    'site_builder_no_package' => 'Nem áll rendelkezésre a Presence Builder. Ellenőrizze, hogy telepítve van-e a Presence Builder, majd válassza ki aktív összetevőként.',
    'site_builder_not_configured' => 'Nincs konfigurálva a Presence Builder weboldalkészítő.',

    // various

    'disabled_by_admin' => 'Kiszolgáló adminisztrátor által letiltott',

    '__not_allowed' => 'Nincs engedélyezve',

    '__ip_addr_state_unknown' => "Még nem működik az IP-cím, mivel a rendszer még a kérelme feldolgozását végzi. Várjon egy percet.",

    'ip_addr__repair_is_not_allowed' => 'Virtuozzo környezetben nem javíthatóak IP-címek.',

    'ippoolManager__ip_used_by_nohost_domain' => "%%ip%% IP-cím nem távolítható el, mivel egy vagy több üzemeltetés nélküli domain használja.",
    'ippoolManager__ip_used_for_mail_service' => "%%ip%% IP-cím nem távolítható el, mivel egy vagy több domain a levelezési szolgáltatása IP-címéhez használja.",
    'ippoolManager__ip_used_for_send_emails' => "%%ip%% Ip-cím nem távolítható el, mivel azt megadott IP-címről való e-mail küldésre használják (lásd Levelező kiszolgáló beállítások).",
    'ippoolManager__ip_used_in_dns_zone' => '%%ip%% IP-cím nem távolítható el, mivel egy vagy több domain DNS-zónájaként használatos.',
    'ip_ctrl__cannot_manage_on_vz' => 'Virtuozzo konténerekben működik a Plesk telepített példánya. Kizárólag a Virtuozzo konténerek csomópont adminisztrátora végezheti új IP-címek hozzáadását.',

    'client_template__limits_auto_adjusted' => 'Automatikusan megtörténik az ügyfélsablon korlátjainak beállítása.',

    '__entries' => 'Bejegyzések',

    '__path_is_not_set' => 'Nem megadva az elérési út. Adjon meg egy érvényes elérési utat.',

    'defaultcomponents__imap_required' => '(A jelenlegi levelezési kiszolgálója nem támogatja az IMAP-módszer használatát.)',

    '__commercial_web_stats_not_installed' => 'A Plesk kizáróla aldomain statisztikai számításokra szolgáló kereskedelmi webstatisztikai szoftvert támogat. Jelenleg nincs ilyen szoftver a rendszerbe telepítve.',


    'server_settings_invalid_traffic_statistics' => 'Érvénytelen forgalmi statisztikai paraméter megőrzés.',
    'server_settings_invalid_logrotate_period' => 'Érvénytelen naplóforgatási idő paraméter.',

    'spam_filter/address/file_size' => 'Nem lehetséges a fájlok feltöltése. %1 egy feltöltendő fájl maximális mérete.',
    'spam_filter/address/file_empty_content' => 'Probléma merült fel az e-mail címek fájlból való olvasása során, ellenőrizze, hogy UTF-8 kódolású-e az egy vagy több e-mail címet tartalmazó fájl, majd próbálja meg újból.',
    'spam_filter/address/addresses_empty_content' => 'Nem szerepelnek e-mail címek a listán.',
    'spam_filter/address/addresses_available' => 'Kizárólag az idevágó %1 első egyedi e-mail címek kerülnek hozzáadásra.',
    'spam_filter/address/invalid_addresses' => 'Érvénytelenek a következő e-mail címek: %1.',

    'current_resources' => 'Jelenlegi erőforrások',
    'plan_limitations' => 'Csomagkorlátozások',
    'cannot_switch_plan' => 'Nem lehet átkapcsolni a kiválasztott csomagra, mivel a következő jelenlegi erőforrások túllépik a csomag korlátozásait:',

    'mail_status_enabled' => 'Engedélyezett',
    'mail_status_disabled' => 'Le vannak tiltva bejövő e-mail esetében',
    'mail_status_not_configured' => 'Nincs konfigurálva',
];
