<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Установка %%name%% в %%path%%...',
    'aps-install.queueNoPath' => 'Идет установка %%name%%...',
    'aps-install.done' => 'Приложение %%name%% было успешно установлено на сайт %%path%%. Данные для входа в это приложение указаны ниже. %%additionalMessage%%',
    'aps-install.doneNoPath' => 'Приложение %%name%% успешно установлено. Данные для входа в это приложение указаны ниже. %%additionalMessage%%',
    'aps-install.doneAdvanced' => 'Приложение %%name%% было успешно установлено на сайт %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => 'Приложение %%name%% успешно установлено. %%additionalMessage%%',
    'aps-install.error' => 'Не удалось выполнить установку %%name%% в %%path%%. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Не удалось выполнить установку %%name%%. %%errorMessage%%',

    'aps-update.queueDownload' => 'Загружается %%packageName%%...',
    'aps-update.errorDownload' => 'Не удалось загрузить %%packageName%%:',
    'aps-update.queueInstall' => 'Обновляется установка %%name%% для %%domainName%%...',
    'aps-update.doneInstall' => 'Установка %%name%% для %%domainName%% обновлена.',
    'aps-update.errorInstall' => 'Не удалось обновить установку %%name%% для %%domainName%%:',
    'aps-update.queueInstallMulti' => 'Обновляется %%instances%% установок для %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% установок %%name%% обновлены.',
    'aps-update.errorInstallMulti' => 'Не удалось обновить %%failures%% установок для %%name%%:',
    'aps-update.incorrectUpdateInformation' => 'Неверная информация об обновлении.',

    'common.hideCompletedTasks' => 'Скрыть выполненное',
    'common.progressBarHide' => 'Скрыть',
    'common.progressBarShow' => 'Показать',
    'common.close' => 'Закрыть',
    'common.refresh' => 'Обновить страницу',
    'common.taskInProgress' => '%%count%% задач выполняется...',
    'common.percentCompleted' => 'Выполнено %%percent%%%',
    'common.allTasksCompleted' => 'Все %%num%% задач успешно выполнены.',
    'common.minimize' => 'Свернуть',
    'common.statusDone' => 'Готово',
    'common.statusError' => 'Не удалось',
    'common.statusNotStarted' => 'В очереди',
    'common.statusCanceled' => 'Отменено',
    'common.progressDialogLink' => 'подробнее о статусе',
    'common.progressLabel' => '%%count%% выполняется',
    'common.successLabel' => '{count, plural, one {# успешная} other {# успешных}}',
    'common.successLabelTooltip' => 'Закрыть все уведомления об успешных задачах',
    'common.warningLabel' => '{count, plural, one {# предупреждение} few {# предупреждения} other {# предупреждений}}',
    'common.warningLabelTooltip' => 'Закрыть все уведомления о предупреждениях',
    'common.errorLabel' => '{count, plural, one {# ошибка} few {# ошибки} other {# ошибок}}',
    'common.errorLabelTooltip' => 'Закрыть все уведомления об ошибках',

    'database-check.queue' => 'Проверяются таблицы базы данных %%database%%...',
    'database-check.done' => 'В базе данных %%database%% ошибок не обнаружено.',
    'database-check.error' => 'Не удалось проверить базу данных %%database%% на наличие ошибок.',
    'database-check.done-with-errors' => "В базе данных %%database%% обнаружено %%number%% проблем. \n %%link%%",
    'database-check.info-link-title' => 'Посмотреть подробности и устранить',

    'database-download.queue' => 'Дамп базы данных %%database%% готовится к экспорту...',
    'database-download.done' => 'Дамп базы данных %%database%% готов. Можете его %%downloadLink%%.',
    'database-download.downloadLink' => 'скачать',
    'database-download.error' => 'Экспортировать дамп базы данных %%database%% не удалось:',

    'database-repair.queue' => 'Исправляются таблицы базы данных %%database%%...',
    'database-repair.done' => 'В базе данных %%database%% ошибок не обнаружено.',
    'database-repair.error' => 'Не удалось исправить базу данных %%database%%.',
    'database-repair.done-with-errors' => "В базе данных %%database%% обнаружено %%number%% проблем. \n %%link%%",
    'database-repair.info-link-title' => 'Посмотреть подробности',

    'database-upload.queue' => 'Импортируется дамп базы данных %%database%%...',
    'database-upload.done' => 'Дамп базы данных %%database%% импортирован.',
    'database-upload.error' => 'Импортировать дамп базы данных %%database%% не удалось :',
    'database-upload.done-with-errors' => "Дамп базы данных %%database%% импортирован с ошибками.",
    'database-upload.orphanedUsersSuccess' => 'База данных %%database%% была успешно импортирована. Однако некоторые пользователи были потеряны (не имеют проассоциированных логинов на сервере баз данных). Чтобы иметь доступ к базам данных, назначьте логины этим пользователям. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Следующие пользователи были потеряны (не имеют проассоциированных логинов на сервере баз данных). %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Посмотреть список пользователей',

    'domain-app-scan.queue' => 'Идет поиск приложений...',
    'domain-app-scan.done' => 'Поиск приложений завершен.',
    'domain-app-scan.error' => 'Поиск приложений завершен с ошибками.',

    'domain-move.queue' => 'Перемещение %%domainName%% в %%webspaceName%%',
    'domain-move.done' => '%%domainName%% перемещен в %%webspaceName%%',
    'domain-move.error' => '%%domainName%% не был перемещен в %%webspaceName%%',

    'domain-split.queue' => 'Перемещение %%domainName%% в новую подписку',
    'domain-split.done' => 'Домен %%domainName%% перемещен в новую подписку',
    'domain-split.error' => 'Домен %%domainName%% не был перемещен в новую подписку',

    'file-manager-import-file.done' => 'Файл %%fileName%% импортирован в <a href="%%listUrl%%">папку %%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Импортировать файл %%fileName%% не удалось: %%errorMessage%%.<br><a href="%%url%%">Скачать на мой компьютер</a>',
    'file-manager-import-file.queue' => 'Импортируется файл %%fileName%% с %%host%%.',
    'file-manager-import-file.progress' => 'Импортируется файл %%fileName%% с %%host%% (%%value%% Мб).',
    'file-manager-import-file.errors.auth' => 'Ошибка аутентификации. Убедитесь, что вы корректно указали имя пользователя и пароль',
    'file-manager-import-file.errors.resolve' => 'Не удалось распознать имя хоста %%host%%. Убедитесь, что вы корректно указали URL-адрес',
    'file-manager-import-file.errors.connect' => 'Не удалось подключиться к серверу %%host%%. Убедитесь, что вы корректно указали URL-адрес',
    'file-manager-import-file.errors.notFound' => 'Удаленный файл не найден или недоступен. Убедитесь, что вы корректно указали URL-адрес и файл доступен',
    'file-manager-import-file.errors.maxSize' => 'Ограничение места на диске или свободное место %%diskSpaceLimit%% превышено',
    'file-manager-import-file.errors.lowSpeedTime' => 'Не удалось импортировать файл из-за слишком низкой скорости передачи: в течение последних %%lowSpeedTime%% секунд передано менее %%lowSpeedLimit%% байтов. Возможно, в настоящий момент трафик сайта, на котором размещен этот файл, слишком высок. Попробуйте импортировать файл еще раз позже',
    'file-manager-import-file.errors.certificate' => 'Не удалось импортировать файл, так как SSL/TLS-сертификат сервера %%host%% не является доверенным. Убедитесь, что сайт, на котором размещен файл, защищен доверенным сертификатом',
    'file-manager-import-file.errors.redirects' => 'Максимальное количество перенаправлений (%%maxRedirects%%) превышено. Убедитесь, что сервер %%host%% работает',

    'force-log-rotation.queue' => 'Применение глобальных настроек ротации журналов',
    'force-log-rotation.done' => 'Глобальные настройки ротации журналов были применены.',
    'force-log-rotation.error' => 'Применение глобальных настроек ротации журналов завершилось с ошибками',
    'force-log-rotation.systemLogRotationError' => 'Системные журналы: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Тарифный план %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Домен %%name%%: %%error%%',

    'initial-setup.queue' => 'Инициализация Plesk...',
    'initial-setup.done' => 'Plesk инициализирован.',
    'initial-setup.doneWithErrors' => 'При инициализации Plesk возникла ошибка.',
    'initial-setup.error' => 'Не удалось инициализировать Plesk.',
    'initial-setup.step.setupPanel' => 'Настройка панели Plesk',
    'initial-setup.step.requestLicense' => 'Запрос лицензии',
    'initial-setup.step.configureServer' => 'Настройка веб-сервера',
    'initial-setup.step.secureServer' => 'Защита сервера',

    'ip-update.queue' => 'Идет обновление IP-адреса',
    'ip-update.done' => 'IP-адрес обновлен',
    'ip-update.error' => 'Обновление IP-адреса завершилось с ошибками',
    'ip-update.updating' => 'Идет обновление IP-адреса',
    'ip-update.updatingWebServer' => 'Идет обновление IP-адреса: обновляется веб-сервер',
    'ip-update.updatingFtpServer' => 'Идет обновление IP-адреса: обновляется сервер FTP',
    'ip-update.updatingDnsZones' => 'Идет обновление IP-адреса: обновляются зоны DNS',
    'ip-update.restartingDnsService' => 'Идет обновление IP-адреса: перезапускается сервер DNS',

    'ip-reload-public.queue' => 'Обновление публичные IP-адресов с использованием облачных метаданных',
    'ip-reload-public.done' => 'Публичные IP-адреса обновлены',

    'logrotate_anonymize_ips.queue' => 'Анонимизировать IP-адреса в журналах',
    'logrotate_anonymize_ips.queueRevert' => 'Деанонимизировать IP-адреса в журналах',
    'logrotate_anonymize_ips.done' => 'IP-адреса были анонимизированы.',
    'logrotate_anonymize_ips.doneRevert' => 'IP-адреса деанонимизированы.',
    'logrotate_anonymize_ips.error' => 'Анонимизация IP-адресов закончилась с ошибками',
    'logrotate_anonymize_ips.errorRevert' => 'Деанонимизация IP-адресов завершена с ошибками',

    'nginx_http3_configure.queue' => 'Настройка поддержки HTTP/3 в nginx',
    'nginx_http3_configure.done' => 'Поддержка HTTP/3 в nginx успешно настроена.',
    'nginx_http3_configure.error' => 'Не удалось настроить поддержку HTTP/3 в nginx.',

    'panel-components-install.queue' => 'Выполняется установка выбранных компонентов',
    'panel-components-install.done' => 'Выбранные компоненты успешно установлены.',
    'panel-components-install.error' => 'Не удалось установить компоненты. Описание ошибки отправлено на ваш адрес электронной почты.',

    'panel-update.queue' => 'Выполняется установка обновлений. Это может занять некоторое время. %%warning%%',
    'panel-update.warning' => 'Пожалуйста, не выполняйте никаких действий в Plesk до завершения обновления.',
    'panel-update.done' => 'Plesk обновлен. Более подробную информацию смотрите в %%changelog%%.',
    'panel-update.changelog' => 'журнале изменений Plesk',
    'panel-update.error' => 'Не удалось обновить Plesk. %%errorDetails%%',
    'panel-update.support' => 'Для устранения этой проблемы вы можете отправить журнал обновления в службу поддержки Plesk. %%failedLog%% Скопируйте этот журнал на свой компьютер прежде, чем закроете это сообщение.',
    'panel-update.failedLog' => 'Смотрите журнал обновления от %%date%%.',

    'pum-update-packages.queue' => 'Идет обновление %%count%% пакетов...',
    'pum-update-packages.done' => '%%count%% пакетов успешно обновлены.',
    'pum-update-packages.error' => 'Обновление не удалось.',

    'scheduler-run-task.queue' => 'Запускается задача "%%task%%"...',
    'scheduler-run-task.done' => 'Задача "%%task%%" успешно выполнена за %%seconds%% секунд.',
    'scheduler-run-task.error' => 'Задача "%%task%%" выполнена с ошибками за %%seconds%% секунд.',
    'scheduler-run-task.popupSeeDetails' => 'Посмотреть подробности',
    'scheduler-run-task.popupTitle' => 'Выполнить запланированную задачу',
    'scheduler-run-task.popupDone' => 'Задача "%%task%%" успешно выполнена за %%seconds%% секунд, вывод:',
    'scheduler-run-task.popupError' => 'Задача "%%task%%" выполнена с ошибками за %%seconds%% секунд, вывод:',
    'scheduler-run-task.popupClose' => 'Закрыть',

    'sdk.queue' => 'Задача "%%name%%" выполняется...',
    'sdk.error' => 'Не удалось выполнить задачу "%%name%%".',
    'sdk.done' => 'Задача "%%name%%" выполнена.',
    'sdk.canceled' => 'Задача "%%name%%" была отменена.',

    'sync-php-settings.queue' => 'Глобальные настройки PHP %%version%% применяются к доменам',
    'sync-php-settings.done' => 'Глобальные настройки PHP %%version%% были успешно применены к доменам',
    'sync-php-settings.error' => 'При применении глобальных настроек PHP %%version%% к доменам произошла ошибка',

    'sync-service-plan.queue' => 'Синхронизация тарифного плана %%name%% с подписками',
    'sync-service-plan.done' => 'Тарифный план %%name%% успешно синхронизирован с подписками',
    'sync-service-plan.doneWithErrors' => 'Синхронизация тарифного плана %%name%% выполнена. Некоторые подписки не были синхронизированы с планом',
    'sync-service-plan.error' => 'При синхронизации тарифного плана %%name%% с подписками произошла ошибка',

    'domain-create.queue' => 'Создание домена %%domainName%%',
    'domain-create.done' => 'Домен %%domainName%% создан',
    'domain-create.error' => 'Создать домен %%domainName%% не удалось',
    'domain-create.warning' => 'Домен %%domainName%% создан, но обнаружены проблемы:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Просмотреть',
    'domain-create.steps.createCustomer' => 'Создание клиента',
    'domain-create.steps.createSubscription' => 'Создание подписки',
    'domain-create.steps.createDomain' => 'Добавление домена',
    'domain-create.steps.configureDns' => 'Настройка зоны DNS',
    'domain-create.steps.createHosting' => 'Создание физического хостинга',
    'domain-create.steps.configurePhp' => 'Настройка PHP',
    'domain-create.steps.configureMail' => 'Настройка почты',

    'domain-delete.queue' => 'Выполняется удаление доменов',
    'domain-delete.done' => 'Домены удалены',
    'domain-delete.error' => 'Не удалось удалить домены',
    'domain-delete.step.domains' => 'Удаление доменов…',

    'domain-resolve-checking.warning' => 'При распознавании домена %%domainName%% обнаружены проблемы: <br> %%errors%%',

    'customer-create.queue' => 'Создается клиент %%customerName%%',
    'customer-create.done' => 'Клиент %%customerName%% создан',
    'customer-create.error' => 'Создать клиента %%customerName%% не удалось',
    'customer-create.warning' => 'Клиент %%customerName%% создан, но обнаружен ряд проблем:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Попробуйте выполнить синхронизацию вручную.',

    'customer-delete.queue' => 'Выполняется удаление клиентов',
    'customer-delete.done' => 'Клиенты удалены',
    'customer-delete.error' => 'Не удалось удалить клиентов',

    'reseller-delete.queue' => 'Выполняется удаление реселлеров',
    'reseller-delete.done' => 'Реселлеры удалены',
    'reseller-delete.error' => 'Не удалось удалить реселлеров',

    'subscription-create.queue' => 'Создается подписка %%subscriptionName%%',
    'subscription-create.done' => 'Подписка %%subscriptionName%% создана',
    'subscription-create.error' => 'Создать подписку %%subscriptionName%% не удалось',
    'subscription-create.warning' => 'Подписка %%subscriptionName%% создана, но обнаружен ряд проблем:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Попробуйте выполнить синхронизацию вручную.',

    'subscription-delete.queue' => 'Выполняется удаление подписок',
    'subscription-delete.done' => 'Подписки удалены',
    'subscription-delete.error' => 'Не удалось удалить подписки',

    'websites-diagnostic.queue' => 'Выполняется диагностика сайтов',
    'websites-diagnostic.done' => 'Диагностика сайтов завершена',
    'websites-diagnostic.error' => 'Диагностика сайтов завершена с ошибками',

    'install-php-extension.queue' => 'Установка пакета %%extensionName%% в обработчик PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'Пакет %%extensionName%% установлен в обработчик PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'Не удалось установить пакет %%extensionName%% в обработчик PHP %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Проверка требований',
    'install-php-extension.step.dependencies' => 'Сопоставление зависимостей',
    'install-php-extension.step.process' => 'Установка пакета',
    'install-php-extension.step.enable' => 'Активация расширения',
    'install-php-extension.step.sync' => 'Синхронизация сайтов',
    'install-php-extension.errorReason' => 'Список доступных пакетов предоставлен PECL. Наиболее частые причины ошибок установки:',
    'install-php-extension.errorReasonDependencies' => '- У пакета присутствует внешняя зависимость от дополнительных библиотек.',
    'install-php-extension.errorReasonRequirements' => '- Не соблюдены требования к установке пакета (ОС, версия PHP и т.д.).',
    'install-php-extension.errorReasonOutdated' => '- Пакет устарел.',
    'install-php-extension.errorOutput' => 'Чтобы определить причину неудачной установки, проверьте вывод утилиты.',

    'uninstall-php-extension.queue' => 'Удаление пакета %%extensionName%% из обработчика PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Пакет %%extensionName%% удален из обработчика PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Не удалось удалить пакет %%extensionName%% из обработчика PHP %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Проверка требований',
    'uninstall-php-extension.step.process' => 'Удаление пакета',
    'uninstall-php-extension.step.sync' => 'Синхронизация сайтов',

    'upgrade-database-server.queue' => 'Обновление сервера баз данных',
    'upgrade-database-server.error' => 'Не удалось обновить сервер баз данных',
    'upgrade-database-server.done' => 'Сервер баз данных обновлен',
    'upgrade-database-server.step.validate' => 'Проверка системы',
    'upgrade-database-server.step.dump' => 'Создание дампа баз данных',
    'upgrade-database-server.step.disableService' => 'Отключение старой системной службы',
    'upgrade-database-server.step.configureRepo' => 'Настройка нового репозитория',
    'upgrade-database-server.step.upgradePackages' => 'Обновление сервера баз данных',
    'upgrade-database-server.step.updateConfiguration' => 'Обновление конфигурации сервера',
    'upgrade-database-server.step.startService' => 'Запуск новой системной службы',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Обновление структуры всех таблиц',
    'upgrade-database-server.step.sync' => 'Синхронизация системных компонентов',
    'upgrade-database-server.step.validateInstallation' => 'Проверка установки',

    'update-spam-filter-individual-settings.queue' => 'Сохранение настроек антиспама',
    'update-spam-filter-individual-settings.done' => 'Настройки антиспама были обновлены',
    'update-spam-filter-individual-settings.error' => 'Не удалось обновить настройки антиспама',
    'update-spam-filter-individual-settings.mailNameError' => 'Почтовый адрес %%name%%: %%error%%',

    'update-default-cert.queue' => 'Обновление сертификата по умолчанию',
    'update-default-cert.done' => 'Сертификат по умолчанию обновлен.',
    'update-default-cert.error' => 'Обновление сертификата по умолчанию завершилось с ошибками.',
    'update-default-cert.step.updating' => 'Обновление сертификата по умолчанию…',

    'smarthost-attach-server-domains.queue' => 'Прикрепление доменов к промежуточному узлу',
    'smarthost-attach-server-domains.done' => 'Домены прикреплены к промежуточному узлу',
    'smarthost-attach-server-domains.doneWithErrors' => 'Прикрепление доменов к промежуточному узлу завершилось с ошибками',
    'smarthost-attach-server-domains.error' => 'Не удалось прикрепить домены к промежуточному узлу',
];
