<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Eigenschappen extra sleutel',
    'additional-key-info.update' => 'Extra sleutel ophalen',
    'additional-key-info.updateDescription' => 'De extra sleutel ophalen en deze installeren.',
    'additional-key-info.download' => 'Sleutel downloaden',
    'additional-key-info.downloadDescription' => 'De huidige licentiesleutel downloaden.',
    'additional-key-info.install' => 'Sleutel installeren',
    'additional-key-info.installDescription' => 'De huidige licentiesleutel installeren.',
    'additional-key-info.revert' => 'Sleutel terugplaatsen',
    'additional-key-info.revertDescription' => 'Terugkeren naar de eerder geïnstalleerde licentiesleutel.',
    'additional-key-info.revertNotAvailableDescription' => 'Geen sleutel geïnstalleerd.',
    'additional-key-info.installSuccess' => 'Installatie van licentiesleutel is gestart.',

    'additional-key-revert.title' => 'Terugplaatsen van extra sleutel',
    'additional-key-revert.success' => 'De extra sleutel is teruggeplaatst.',

    'additional-key-upload.title' => 'Een licentiesleutel installeren',
    'additional-key-upload.success' => 'De nieuwe extra sleutel is geüpload.',

    'additional-keys.title' => 'Extra licentiesleutels',

    'change-subscriptions-owner.title' => 'Opnieuw toewijzen van geselecteerde pakketten',
    'change-subscriptions-owner.success' => 'Abonnementhouder is gewijzigd',

    'customers.hint' => 'Op deze pagina kunt u de accounts van de klanten van uw hostingdiensten beheren: aanmaken van accounts met de bijbehorende abonnementen, beheer van bestaande cliënten en het verwijderen van accounts. Voor het beheer van websites, mail of andere diensten die u aan een cliënt levert, gaat u naar zijn of haar Hostingbeheer in de rechterkolom van de lijst.',

    'customer-domains.hint' => 'Hier kunt u websites instellen en beheren.',

    'customer-subscriptions.hint' => 'Op deze pagina kunt u de abonnementen van de cliënt beheren.',

    'domains.hint' => 'Hier kunt u informatie inzien over alle domeinnamen die in het systeem zijn geregistreerd en u kunt naar het beheer van hostingdiensten doorklikken. Om een domein toe te voegen voor uzelf of voor uw hostingcliënten, klikt u simpelweg op Domein toevoegen. U wordt gevraagd of u een nieuwe cliënt en een nieuw abonnement wilt toevoegen tijdens het aanmaken van het domein, maar u kunt ook bestaande selecteren.',

    'database-servers.title' => 'Database-servers',

    'database-server-create.title' => 'Nieuwe database-server',

    'database-server-properties.title' => 'Database-server',

    'database-server-upgrade.drawerTitle' => 'Upgrade MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Upgrade voltooid',
    'database-server-upgrade.drawerSubTitle.line1' => 'De drawer kan niet worden gesloten terwijl de upgrade wordt uitgevoerd.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Wanneer er tijdens de upgrade fouten optreden, lees dan %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'De MariaDB database-server is bijgewerkt naar versie %%releaseVersion%%. Mocht u tegen problemen aanlopen, volg dan de aanwijzingen in %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'U heeft de LTS-versie al geïnstalleerd.',
    'database-server-upgrade.troubleshootingArticle' => 'dit KB-artikel',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Gebruik %%troubleshootingArticle%% om problemen met de MariaDB-upgrade op te lossen.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Upgrade uw lokale MariaDB database-server naar de huidige versie met ondersteuning op lange termijn (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Het is sterk aan te raden een reservekopie van uw server te maken vóór u begint aan de upgrade; u kunt de upgrade het beste uitvoeren op een tijd waarop uw websites weinig worden bezocht.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Tijdens de upgrade van MariaDB zullen de Plesk-server en de websites die daarop worden gehost niet beschikbaar zijn. De upgrade van MariaDB verloopt doorgaans zonder problemen en duurt ongeveer 10 minuten, maar het is toch mogelijk dat het upgrade-proces invloed heeft op de server als geheel.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Opmerking: als u gebruik maakt van MariaDB 5.5, dan zal plesk deze eerst upgraden naar versie 10.5. Als deze upgrade is voltooid, dan kunt u deze Wizard opnieuw starten voor een upgrade naar de huidige LTS-versie van MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Huidige versie',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Selecteer de versie waarnaar u wilt upgraden',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Er zijn geen grote releases',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Opmerkingen bij deze release',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Release: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End of life: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Upgrades zijn alleen mogelijk voor MariaDB-forks die worden geleverd door OS-leveranciers of door de leverancier van MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Pre-upgrade controle',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Parseren van de MariaDB-configuratiebestanden',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Databases analyseren met mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'De pakketbeheer-configuratie analyseren',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Systeemcompatibiliteit controleren',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket controleren',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Om door te gaan met de upgrade selecteert u alle selectievakjes. Het is noodzakelijk dat u zeker weet dat u het eens bent met de configuratiewijzigingen die de upgrade zal doorvoeren en dat u toegang heeft tot herstelopties.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'De volgende variabelen zullen worden verwijderd voor compatibiliteit met de nieuwe versie:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'De volgende configuratiebestanden zullen worden verwijderd, omdat ze deel uitmaken van het pakket mariadb-server dat een upgrade krijgt:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} van {count, plural, one {het bestand {files}} other {de volgende # bestanden: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Toegang tot herstelopties (de opdrachtregel van de server en Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Ik bevestig dat ik beschik over SSH-toegang tot de server',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Gebruik een SSH-client of open de %%sshTerminalExtension%% in een nieuw tabblad van de browser (sluit het venster van de SSH Terminal-extensie niet voordat de upgrade is voltooid). Als de upgrade mislukt, kan SSH-toegang helpen bij het herstellen.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Extensie SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Ik bevestig dat ik toegang heb tot Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Open %%repairKit%% in een nieuw tabblad van de browser en meld u aan met de gebruikersnaam en het wachtwoord van de beheerder. Sluit het venster van de Repair Kit-extensie niet voordat de upgrade is afgerond.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Reservekopie maken van databases',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Een reservekopie maken van alle databases op de server, voorafgaand aan de upgrade',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk zal de reservekopieën van de databases opslaan in de map %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket in Plesk is niet beschikbaar',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Zonder WebSocket kunt u de uitvoering van het upgradeproces niet in realtime volgen.',

    'database-server-upgrade.submitPopover.title' => 'Om mogelijk dataverlies te voorkomen raden wij u ten zeerste aan een dump te maken van alle gehoste databases voordat u verder gaat. Wilt u doorgaan zonder een dump te maken?',

    'database-server-databases.title' => 'Databases',

    'database-server-change-password.title' => 'Wachtwoord van beheerder',

    'home.title' => 'Startpagina',

    'license.title' => 'Licentie-informatie',

    'primary-key-info.title' => 'Plesk-licentiesleutel',
    'primary-key-info.update' => 'Sleutels ophalen',
    'primary-key-info.updateDescription' => 'De bestelde sleutels ophalen en deze installeren.',
    'primary-key-info.upload' => 'Sleutel installeren',
    'primary-key-info.uploadDescription' => 'Een nieuwe licentiesleutel uploaden en installeren.',
    'primary-key-info.revert' => 'Sleutel terugplaatsen',
    'primary-key-info.revertDescription' => 'Terugkeren naar de eerder geïnstalleerde licentiesleutel.',
    'primary-key-info.expireTitle' => 'Uw Plesk-licentie is verlopen',
    'primary-key-info.header' => 'Hierdoor zijn een aantal belangrijke diensten niet langer beschikbaar. %%warning%%',
    'primary-key-info.headWarning' => 'Uw websites lopen mogelijk risico!',
    'primary-key-info.softwareUpdatesTitle' => 'Software-updates',
    'primary-key-info.softwareUpdates' => '%%title%% zijn uitgeschakeld; uw systeem is wellicht kwetsbaar voor gevaren.',
    'primary-key-info.websiteBackupsTitle' => 'Website-reservekopieën',
    'primary-key-info.websiteBackups' => '%%title%% zijn niet langer beschikbaar; u loopt het risico van gegevensverlies.',
    'primary-key-info.sslCertificatesTitle' => 'SSL/TLS-certificaten',
    'primary-key-info.sslCertificates' => '%%title%% worden niet meer automatisch verlengd; hierdoor lopen veiligheid en vertrouwen mogelijk gevaar.',
    'primary-key-info.monitoringTitle' => 'Monitoring',
    'primary-key-info.monitoring' => '%%title%% is niet langer beschikbaar; overbelasting en andere problemen met de server-prestaties kunnen zo onopgemerkt blijven.',
    'primary-key-info.fileDbManagementTitle' => 'Bestand- en database-beheer',
    'primary-key-info.fileDbManagement' => '%%title%% zijn uitgeschakeld. U kunt uw bestanden en databases daardoor niet efficiënt beheren.',
    'primary-key-info.technicalSupportTitle' => 'Technische ondersteuning',
    'primary-key-info.technicalSupport' => '%%title%% is niet beschikbaar. Het ontbreken van toegang tot de benodigde assistentie bij serverproblemen kan leiden tot langdurige uitval.',
    'primary-key-info.renewLicense' => 'Om deze diensten te herstellen, kunt u nu een nieuwe Plesk-licentie aanschaffen.',
    'primary-key-info.footer' => 'Voor vragen of assistentie, ',
    'primary-key-info.supportLink' => 'neemt u contact op met de ondersteuning van Plesk',

    'primary-key-revert.title' => 'Vorige licentiesleutel terugplaatsen',
    'primary-key-revert.success' => 'De Plesk-sleutel is teruggeplaatst.',

    'primary-key-upload.title' => 'Een licentiesleutel installeren',
    'primary-key-upload.success' => 'De nieuwe sleutel voor Plesk is geüpload.',

    'resellers.hint' => 'Hier kunt u de reselleraccounts beheren. Resellers zijn uw cliënten die hostingdiensten doorverkopen en hun eigen websites hosten. Hier kunt u accounts met abonnementen aanmaken, bestaande resellers beheren en accounts verwijderen.',

    'reseller-customers.hint' => 'Hier kunt u cliënten instellen en beheren.',

    'reseller-domains.hint' => 'Hier kunt u websites instellen en beheren.',

    'reseller-subscriptions.hint' => 'Hier beheert u de abonnementen van de reseller.',

    'subscriptions.hint' => 'Cliënten kunnen hostingdiensten van u afnemen door zich te abonneren op een hostingpakket. Hier kunt u deze abonnementen beheren, evenals uw eigen abonnementen die u voor het hosten van uw eigen websites hebt aangemaakt. Om websites, mail of andere met een abonnement geleverde diensten te beheren gaat u naar Hostingbeheer van de abonnementhouder door te klikken op de link in de rechterkolom van de lijst.',

    'server-mail-settings.title' => 'Instellingen',
    'server-mail-spam-filter.title' => 'Spamdetectie',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Zwarte lijst',
    'server-mail-white-list.title' => 'Whitelist',
    'server-mail-queue.title' => 'Mailwachtrij',
    'server-mail-statistics.title' => 'Statistieken',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Instellingen',
    'server-spam-filter.black-list' => 'Zwarte lijst',
    'server-spam-filter.white-list' => 'Whitelist',

    'firewall.title' => 'Beheer firewall',
    'firewall-general.title' => 'Algemeen',
    'firewall-general.toggleStatus' => 'Firewall-bescherming',
    'firewall-general.buttonDefault' => 'Standaardwaarden terugplaatsen',
    'firewall-general.buttonPanic' => 'Paniekmodus',
    'firewall-general.confirmationDefault' => 'De standaardinstellingen van de firewall terugplaatsen?',
    'firewall-general.confirmationPanic' => 'Wilt u de Paniekmodus inschakelen? Gebruikers hebben dan geen toegang meer tot hun domeinen en sommige netwerkdiensten zullen wellicht stoppen te werken.',
    'firewall-general.successDefault' => 'De standaardinstellingen van de firewall zijn teruggeplaatst.',
    'firewall-general.successPanic' => 'Paniekmodus is ingeschakeld.',
    'firewall-general.info' => 'Omwille van de veiligheid blokkeert de firewall alle verbindingen die niet expliciet zijn toegestaan. U kunt een verbinding toestaan door een regel aan te maken. Zie de documentatie voor meer informatie',
    'firewall-general.interfaces' => 'Netwerkkaarten',
    'firewall-icmp.title' => 'ICMP-protocol',
    'firewall-rules.title' => 'Firewall-regels',

    'dns.title' => 'DNS-instellingen',
    'dns-records.title' => 'Sjabloon voor zone-records',
    'dns-soa-record.title' => 'Zone-instellingssjabloon',

    'php-handler.title' => 'Instellingen voor %%name%%',
    'php-handler.extensions.title' => 'Uitbreidingen',
    'php-handler.extensions.description' => 'De instellingen van deze PHP-extensies gelden alleen voor deze handler.',
    'php-handler.extensions.descriptionShared' => 'Deze instellingen worden gedeeld door de volgende PHP-handlers: %%handlers%%. De instellingen zijn van toepassing op alle websites die deze handlers gebruiken.',
    'php-handler.extensions.buttonManage' => 'PECL-pakketten beheren',
    'php-handler.extensions.manage.title' => 'PECL-pakketten beheren',
    'php-handler.extensions.manage.risks' => 'PHP-extensies worden geleverd via PECL-pakketten van andere leveranciers; installeer deze op eigen risico!',
    'php-handler.extensions.manage.description' => 'Installeer, upgrade en verwijder PECL-pakketten. De wijzigingen zullen worden toegepast op alle websites die gebruik maken van %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Waarom staat het gewenste pakket niet in de lijst?',
    'php-handler.extensions.manage.limitations' => 'PHP-extensies die worden geleverd door de leverancier van het control panel of door OS-vendors worden niet in de lijst weergegeven.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Vernieuwen",
    'ServerInformation.sectionGeneral' => "Algemeen",
    'ServerInformation.cpu' => "Processor",
    'ServerInformation.version' => "versie",
    'ServerInformation.os' => "Besturingssysteem",
    'ServerInformation.key' => "Plesk-licentiesleutel",
    'ServerInformation.uptime' => "Uptime",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dagen}} {hours, plural, one {# uur} other {# uur}} {minutes, plural, one {# minuut} other {# minuten}}",
    'ServerInformation.sectionCpu' => "CPU-gebruik",
    'ServerInformation.la1min' => "Laatste 1 minuut",
    'ServerInformation.la5min' => "Laatste 5 minuten",
    'ServerInformation.la15min' => "Laatste 15 minuten",
    'ServerInformation.sectionMemory' => "Geheugengebruik",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Totaal (exclusief kernel)",
    'ServerInformation.memoryTotal' => "Totaal",
    'ServerInformation.memoryUsed' => "Gebruikt",
    'ServerInformation.memoryFree' => "Vrij",
    'ServerInformation.memoryShared' => "Gedeeld",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Opgeslagen in cache",
    'ServerInformation.memoryAvailable' => "Beschikbaar",
    'ServerInformation.memoryUsage' => "Gebruik",
    'ServerInformation.sectionSwap' => "Swapgebruik",
    'ServerInformation.sectionVirtualMemory' => "Gebruik van virtueel geheugen",
    'ServerInformation.swapTotal' => "Totaal",
    'ServerInformation.swapUsed' => "Gebruikt",
    'ServerInformation.swapFree' => "Vrij",
    'ServerInformation.swapUsage' => "Gebruik",
    'ServerInformation.sectionHarddisk' => "Schijfruimtegebruik",
    'ServerInformation.harddiskDirectory' => "Bestandssysteem",
    'ServerInformation.harddiskProtectedDir' => "Belangrijke mappen",
    'ServerInformation.harddiskTotal' => "Totaal",
    'ServerInformation.harddiskUsed' => "Gebruikt",
    'ServerInformation.harddiskAvailable' => "Beschikbaar",
    'ServerInformation.harddiskCapacity' => "Capaciteit",
    'ServerInformation.sectionDomains' => "Domeinen",
    'ServerInformation.activeDomains' => "Actief",
    'ServerInformation.inactiveDomains' => "Inactief",
    'ServerInformation.problemDomains' => "Problemen",
    'ServerInformation.refreshed' => "Informatie vernieuwd.",

    'ServerAbout.copyright' => '© 2026 WebPros International GmbH. Alle rechten voorbehouden.',
    'ServerAbout.linkLicenseManagement' => 'Ga naar licentie-informatie',
    'ServerAbout.panelVersion' => 'versie',
    'ServerAbout.installedPatchVersion' => '#%%patch%% bijwerken',
    'ServerAbout.licenseKey' => 'Licentiesleutel',
    'ServerAbout.productDescription' => 'Plesk is het leidende WebOps-platform waarmee u uw applicaties, websites en hostingdiensten kunt uitvoeren, automatiseren en laten groeien.',
    'ServerAbout.readEula' => 'Lees %%link%%.',
    'ServerAbout.linkEula' => 'Licentieovereenkomst voor eindgebruikers',
    'ServerAbout.visitForum' => 'Bezoek %%link%%',
    'ServerAbout.linkForum' => 'Plesk-forum',
    'ServerAbout.followUs' => 'Volg ons',
    'ServerAbout.visitSite' => 'Kom meer te weten via %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Vind inspiratie op %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',
    'ServerAbout.ip2locationCopyright' => 'Plesk maakt gebruik van de database van IP2Location LITE voor %%link%%.',
    'ServerAbout.linkGeolocation' => 'IP-geolocatie',

    'ServerAbout.darkThemePromoTitle' => 'Gefeliciteerd!',
    'ServerAbout.darkThemePromoDescription' => 'Je hebt een magische poes gevonden.',
    'ServerAbout.darkThemePromoButton' => 'Miauw! Kom naar de duistere zijde!',
    'ServerAbout.darkThemeTourDescription' => 'Gebruik deze optie om de donkere weergave voor uw scherm in of uit te schakelen.',
    'ServerAbout.darkThemeTourButton' => 'Ik snap het',

    'ts-sessions.title' => 'Terminal Server-sessies',
    'ts-sessions-properties.title' => 'Eigenschappen van sessie',

    'BandwidthLimiting.bandwidthThrottling' => 'U kunt geen tijdelijke verlaging van bandbreedte instellen omdat QoS niet is geïnstalleerd.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandbreedte-beperking is alleen beschikbaar voor domeinen met webhosting.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximaal gebruik van bandbreedte',
    'BandwidthLimiting.bandwidthHint' => 'De beperking van de verbruikte bandbreedte is alleen van toepassing op gegevens die via het HTTP-protocol worden overgedragen.',
    'BandwidthLimiting.maxConnectionLabel' => 'Verbindingen beperkt tot',
    'BandwidthLimiting.maxConnectionHint' => 'Als u de bandbreedte beperkt, raden wij u aan om ook het aantal gelijktijdige verbindingen met de website te beperken. De processen op de webserver zullen anders bij een groot aantal aanvragen zorgen voor een hoge belasting van de server.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'De instellingen van de bandbreedtebeperking zijn gewijzigd.',
    'BandwidthLimiting.unlimited' => 'Onbeperkt',

    'ip-address-domains.title' => 'Websites die %%type%% IP-adres %%ipAddress%% gebruiken',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Als standaard instellen',
    'ip-address-domains.type-SHARED' => 'gedeeld',
    'ip-address-domains.type-EXCLUSIVE' => 'exclusief',

    'HotlinkProtection.virtualHostingRequired' => 'Bescherming tegen hotlinking is alleen beschikbaar voor domeinen met webhosting.',
    'HotlinkProtection.enabledLabel' => 'Bescherming tegen hotlinking inschakelen',
    'HotlinkProtection.extensionsLabel' => 'Extensies beschermde bestanden',
    'HotlinkProtection.friendsLabel' => 'Adressen van bevriende websites',
    'HotlinkProtection.success' => 'Instellingen voor bescherming tegen hotlinking zijn gewijzigd.',

    'Odbc.add' => 'ODBC DSN toevoegen',
    'Odbc.resourceUsage' => '%%used%% aangemaakt / %%allowed%% toegestaan.',
    'Odbc.limitExceeded' => 'De beperking van het aantal ODBC DSN-koppelingen is overschreden.',
    'Odbc.unlimited' => 'Onbeperkt',
    'Odbc.addTooltip' => 'ODBC-gegevensbron toevoegen.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Naam van de koppeling',
    'Odbc.driver' => 'Stuurprogramma',
    'Odbc.description' => 'Omschrijving van de koppeling',
    'Odbc.hostname' => 'Hostnaam',
    'Odbc.statusSystem' => 'Het betreft een systeem-DSN.',
    'Odbc.statusConfigured' => 'DSN is geconfigureerd.',
    'Odbc.statusNotConfigured' => 'DSN is niet geconfigureerd.',
    'Odbc.noSelectionText' => 'Selecteer een of meer items om te verwijderen.',
    'Odbc.removeConfirmation' => 'Wilt u {count, plural, one {}=1 {de koppeling {name}} other {de # geselecteerde koppelingen}} verwijderen?',
    'Odbc.removeSuccess' => 'De geselecteerde koppelingen zijn verwijderd.',

    'DomainAliasSettings.title' => 'Instellingen domeinalias',
    'DomainAliasSettings.updateSuccess' => 'De eigenschappen van het domeinalias %%name%% zijn gewijzigd. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'De instellingen van de website zullen worden toegepast over %%restartInterval%% minuten.',

    'Home.Backup.offStatus' => 'Dit is geen geldige reservekopie. Gegevens uit dit bestand kunnen niet worden teruggeplaatst.',
    'Home.Backup.task-failedStatus' => 'Het reservekopie-taak is mislukt.',
    'Home.Backup.activeSchedule' => 'Rooster: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Roosters: %%schedules%%',
    'Home.Backup.noSchedule' => "Er is geen rooster voor reservekopieën ingesteld",
    'Home.Backup.period_hourly' => 'Elk uur %%schedule%%',
    'Home.Backup.period_daily' => 'Dagelijks %%schedule%%',
    'Home.Backup.period_weekly' => 'Wekelijks %%schedule%%',
    'Home.Backup.period_monthly' => 'Maandelijks %%schedule%%',
    'Home.Backup.create' => 'Een reservekopie maken',
    'Home.Backup.schedule' => 'Rooster',
    'Home.ChangeLog.seeHistory' => 'Bekijk wijzigingsgeschiedenis',
    'Home.CustomButtons.add' => 'Eigen knop toevoegen',
    'Home.CustomButtons.noButtons' => 'Er zijn geen Eigen knoppen',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => 'Kies welke opties u graag zou willen zien',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Beveiliging',
    'Home.Customization.backup' => 'Laatste reservekopie van server',
    'Home.Customization.ipBan' => 'Blokkeren IP-adressen',
    'Home.Customization.mailQueue' => 'Mailwachtrij',
    'Home.Customization.mySubscriptions' => 'Mijn abonnementen',
    'Home.Customization.overusedSubscriptions' => 'Abonnementen met meerverbruik',
    'Home.Customization.serverInfo' => 'Serverinformatie',
    'Home.Customization.updates' => 'Plesk-updates',
    'Home.Customization.promo' => 'Promo',
    'Home.Customization.changeLog' => 'Laatste nieuws',
    'Home.Customization.customButtons' => 'Eigen knoppen',
    'Home.Customization.drag' => 'Sleep om paneel te verplaatsen',
    'Home.EmptyView.title' => 'Haal het meeste uit uw dashboard door zelf aan te geven welke opties u hier wilt zien.',
    'Home.EmptyView.titleLocked' => 'Het dashboard is vergrendeld door uw provider.',
    'Home.EmptyView.customize' => 'Aanpassen',
    'Home.Extension.title' => 'Extensie',
    'Home.IpBan.banned' => 'Verbannen',
    'Home.IpBan.trusted' => 'Vertrouwd',
    'Home.IpBan.more' => 'Meer',
    'Home.MailQueue.total' => 'Totaal',
    'Home.MailQueue.deferred' => 'Uitgesteld',
    'Home.MailQueue.held' => 'Vastgehouden',
    'Home.MailQueue.more' => 'Meer',
    'Home.MailQueue.clean' => 'Mailwachtrij leegmaken',
    'Home.MailQueue.checkLogs' => 'Logbestanden controleren',
    'Home.MailQueue.repair' => 'Herstellen',
    'Home.MailQueue.cleanConfirmQuestion' => 'Mailwachtrij leegmaken?',
    'Home.MailQueue.cleanConfirmYes' => 'Ja',
    'Home.MailQueue.cleanConfirmNo' => 'Nee',
    'Home.MailQueue.queueCleaned' => 'Het leegmaken van de mailwachtrij is geslaagd.',
    'Home.OverusedSubscriptions.empty' => 'Geen abonnementen met meerverbruik gevonden',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% van %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Bekijk alle met meerverbruik: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'De lijst openen',
    'Home.ServerInfo.hostname' => 'Hostnaam',
    'Home.ServerInfo.copyHostname' => 'Hostnaam kopiëren',
    'Home.ServerInfo.ipAddress' => 'IP-adres',
    'Home.ServerInfo.copyIpAddress' => 'IP-adres kopiëren',
    'Home.ServerInfo.publicIpAddress' => 'Publiek IP-adress',
    'Home.ServerInfo.copyPublicIpAddress' => 'Publiek IP-adres kopiëren',
    'Home.ServerInfo.os' => 'Besturingssysteem',
    'Home.ServerInfo.copyOs' => 'OS kopiëren',
    'Home.ServerInfo.uptime' => 'Uptime',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dagen}} {hours, plural, one {# uur} other {# uur}} {minutes, plural, one {# minuut} other {# minuten}}",
    'Home.ServerInfo.more' => 'Meer',
    'Home.Subscriptions.add' => 'Nieuw toevoegen',
    'Home.Subscriptions.empty' => 'Maak abonnementen aan voor het hosten van verschillende websites in een geïsoleerde ruimte op de server. %%link%%',
    'Home.Subscriptions.help' => 'Meer weten?',
    'Home.Updates.title' => 'Product-updates',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Update #%%patch%%',
    'Home.Updates.manageComponents' => 'Componenten toevoegen of verwijderen',
    'Home.Updates.lastUpdated' => 'Laatste update op %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Update-controle',
    'Home.Updates.enableAutoupdate' => 'Automatische updates toestaan',
    'Home.Updates.lastChecked' => 'Laatst gecontroleerd op: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% is beschikbaar',
    'Home.Updates.installNewVersion' => 'Nu installeren',
    'Home.Updates.patchAvailable' => 'Er zijn minor updates beschikbaar',
    'Home.Updates.patchAvailableVersion' => 'Er zijn minor updates beschikbaar voor %%currentVersion%%',
    'Home.Updates.installPatch' => 'Nu bijwerken',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Er is een update beschikbaar voor {package}} other {Er zijn updates beschikbaar voor {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# website} other {# websites}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Nu bijwerken} other {Alles bijwerken}}',
    'Home.Promo.close' => 'Het blok sluiten',
    'Home.Promo.viewSlide' => 'Dia %%slideNumber%% bekijken',
    'Home.Promo.Customize.title' => 'Pas uw dashboard zelf aan!',
    'Home.Promo.Customize.content' => 'Uw meestgebruikte functies direct binnen handbereik met het nieuwe, aanpasbare dashboard',
    'Home.Promo.Customize.action' => 'Aanpassen',
    'Home.Promo.SwitchToPuv.title' => 'Heeft u al gehoord van de verschillende schermweergaves in Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Als u geen hostingdiensten aan uw klanten levert met behulp van hostingabonnementen, dan is het wellicht handiger voor u om de interface te proberen die speciaal is bedoeld voor het beheren van websites met hun bestanden, databases, e-mailaccounts en webapplicaties.',
    'Home.Promo.SwitchToPuv.action' => 'Nu uitproberen',
    'Home.Status.error' => 'Fout',
    'Home.Status.warning' => 'Waarschuwing',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Hostinginstellingen',
    'HostingSettings.updateSuccess' => 'De instellingen zijn bijgewerkt.',
    'HostingSettings.emptyLogin' => 'U moet een gebruikersnaam opgeven.',
    'HostingSettings.emptyPassword' => 'U moet een wachtwoord opgeven.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-server ondersteunt geen IPv6. Wijs ten minste één IPv4-adres toe, anders kan de gebruiker geen bestanden naar de server uploaden met FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domein-instellingen',
    'HostingSettings.domainSettingsSection.domainName' => 'Domeinnaam',
    'HostingSettings.domainSettingsSection.description' => 'Bijvoorbeeld voorbeeld.nl ',

    'HostingSettings.submitPopover.title' => 'De bestanden van %%website%% verwijderen',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Als u het hostingtype \'Website\' wijzigt naar \'%%type%%\', dan worden alle bestanden van de website permanent verwijderd, inclusief de volgende mappen:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Wilt u het type hosting voor uw website wijzigen?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Om toegang tot meer instellingen te krijgen, voert u de aanmeldgegevens van de systeemgebruiker in en klikt u vervolgens op "Webruimte aanmaken".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Om toegang tot meer instellingen te krijgen, klikt u op "Volgende" om hosting aan te maken.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Type hosting',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Website',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Doorsturen',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Geen webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Gebruik de DNS-zone van het domein voor postvakken onder deze domeinnaam',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Zoekpad naar de hoofdmap van de website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Voorkeursdomein',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Bezoekers worden hiernaartoe geleid via een SEO-vriendelijke HTTP 301-omleiding.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Bezoekers doorsturen naar',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Type doorschakeling',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Permanent verplaatst (code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Bezoekers doorschakelen naar een andere website, waarbij zij het adres van bestemming kunnen zien. Op deze manier blijft de waarde van de site in zoekmachines behouden',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Tijdelijk verplaatst (code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Leid bezoekers van de website om naar een tijdelijke kopie van de site als u niet wilt dat zoekmachines deze tijdelijke site in hun index opnemen.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Doorschakelen via frame',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Bezoekers doorschakelen naar een andere website, maar daarbij het adres van bestemming niet weergeven zodat de bezoekers niets van de doorschakeling weten.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Voorkeursdomein',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Geen',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Hoofdmap (root)',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Het is niet mogelijk om een hoofdmap (root) te wijzigen, omdat er op deze website webtoepassingen zijn geïnstalleerd.',
    'HostingSettings.domainSettingsSection.save' => 'Opslaan',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Compatibiliteitsmodus',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Voor de website uit in compatibiliteitsmodus voor de verouderde optie "SSL/TLS-bestanden en niet-SSL/TLS-bestanden scheiden"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Deze website wordt uitgevoerd in compatibiliteitsmodus en kan niet worden beheerd via Plesk. Dit komt omdat u voorafgaand aan de upgrade de (inmiddels verouderde) optie “SSL/TLS-bestanden en niet-SSL/TLS-bestanden scheiden” heeft gebruikt. Vanaf Plesk 11 slaan websites bestanden die via HTTP- en HTTPS-verbindingen beschikbaar zijn op in dezelfde map. We raden u aan alle bestanden in de map `httpsdocs/` naar `httpdocs/` te verplaatsen en vervolgens de compatibiliteitsmodus uit te schakelen. Hierdoor worden ook apps in de map `httpsdocs/` toegankelijk via internet. Houd er rekening mee dat u de compatibiliteitsmodus niet opnieuw kunt inschakelen.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Deze instelling wijzigen?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Het wijzigen van deze instelling gaat in tegen het beveiligingsbeleid van de server en kan de prestaties nadelig beïnvloeden of de server kwetsbaar maken voor aanvallen.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Wijzigen',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Ongedaan maken',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'De voorinstelling voor beveiligde instellingen wordt toegepast',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Pas voor een betere beveiliging de voorinstelling met veilige waarden toe. Houd er rekening mee dat abonnees met bepaalde machtigingen deze instellingen kunnen wijzigen.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Voorinstelling met veilige waarden toepassen',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Kom meer te weten over veilige hostinginstellingen',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-ondersteuning',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Ingeschakeld',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Verbindingen tussen de website en de browser van de bezoeker versleutelen.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificaat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Om HTTPS in te schakelen uploadt u een SSL/TLS-certificaat naar de opslag van het domein, waarna u het hier selecteert.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Bezoekers van HTTP naar HTTPS omleiden via een SEO-vriendelijke 301-omleiding',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'In uw opslag bevinden zich geen SSL/TLS-certificaten. Als u een certificaat wilt toevoegen gaat u naar %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'deze pagina',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (andere opslag)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Niet geselecteerd',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Webscripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selecteer welke programmeer- en scripttalen door de webserver moeten worden geïnterpreteerd.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'modus van map cgi-bin: inside %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'SSI gebruiken voor *.htm, *.html-bestanden',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versie Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Aangepaste foutmeldingdocumenten',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'modus van map cgi-bin: inside',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'www-hoofdmap van dit domein',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'hoofdmap van webruimte',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'de hoofdmap van dit domein, oude stijl',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Aangepaste foutmeldingdocumenten',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Aanvullende schrijf- en bewerkrechten',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publiceren met Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webstatistieken',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Hulpprogramma',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'De toegang tot uw webstatistieken afschermen met uw FTP-gebruikersnaam en wachtwoord',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Uitgeschakeld',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Instellingen webruimte',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-adressen',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Beperking schijfruimte',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Ingeschakeld',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Bewerkingen van de bestanden van de website verbieden als het schijfruimtequotum dat is ingesteld in de instellingen van het abonnement (indien van toepassing) wordt overschreden.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'De harde beperking van schijfruimte wordt niet ondersteund vanwege de manier waarop het bestandssysteem van de server is geconfigureerd.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Aanmeldgegevens systeemgebruiker',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'De bestanden en mappen van de website beheren via FTP of Bestandsbeheer. Ga naar de server via SSH indien toegestaan.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'De bestanden en mappen van de website beheren via FTP of Bestandsbeheer. Ga naar de server via Extern bureaublad indien toegestaan.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Gebruikersnaam',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Wachtwoord',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Geef hier een nieuw wachtwoord op om het wachtwoord van de systeemgebruiker te wijzigen.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-toegang',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Toegang via Extern bureaublad',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Ingeschakeld',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Ga naar de server met de aanmeldgegevens van de systeemgebruiker.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Type',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Uitgeschakeld',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Voor {count, plural, one {} other {# domeinen}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'De volgende instelllingen worden gedeeld voor alle {count, plural, one {}other {# domeinen in de webruimte {name}}}:',

    'OdbcAdd.title' => 'Een ODBC DSN toevoegen',
    'OdbcAdd.nameLabel' => 'Naam van de koppeling',
    'OdbcAdd.descriptionLabel' => 'Omschrijving van de koppeling',
    'OdbcAdd.driver' => 'Stuurprogramma',
    'OdbcAdd.submit' => 'ODBC DSN aanmaken',

    'OdbcEdit.title' => 'Een ODBC-verbinding instellen',
    'OdbcEdit.saveSuccess' => 'De verbindingsinstellingen zijn opgeslagen.',
    'OdbcEdit.test' => 'Verbinding testen',
    'OdbcEdit.connectSuccess' => 'Succesvolle koppeling.',

    'OdbcEdit.excel.driver.label' => 'Stuurprogramma',
    'OdbcEdit.excel.dbq.label' => 'Zoekpad naar databasebestand',
    'OdbcEdit.excel.defaultdir.label' => 'Standaard gegevensmap',
    'OdbcEdit.excel.fil.label' => 'Databaseversie',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max omvang van buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Pagina-timeout',

    'OdbcEdit.access.driver.label' => 'Stuurprogramma',
    'OdbcEdit.access.dbq.label' => 'Zoekpad naar databasebestand',
    'OdbcEdit.access.uid.label' => 'Aanmeldingskenmerk',
    'OdbcEdit.access.pwd.label' => 'Wachtwoord',
    'OdbcEdit.access.pagetimeout.label' => 'Pagina-timeout',
    'OdbcEdit.access.pagetimeout.description' => 'De tijdsduur, in tienden van seconden, dat een ongebruikte pagina in de buffer blijft. Deze optie is van toepassing op alle gegevensbronnen die gebruik maken van het stuurprogramma van Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max omvang van buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'De omvang van de interne buffer, in KB, in lijn gebracht met de 256 KB-grens.',
    'OdbcEdit.access.readonly.label' => 'Alleen lezen',
    'OdbcEdit.access.readonly.description' => 'Wijst de database aan als alleen-lezen om gedeelde updates te verbieden.',
    'OdbcEdit.access.exclusive.label' => 'Exclusief',
    'OdbcEdit.access.exclusive.description' => 'Wijst de database aan als exclusief om gedeelde updates te verbieden.',
    'OdbcEdit.access.safetransactions.label' => 'Safe transactions',
    'OdbcEdit.access.safetransactions.description' => 'Indien ingesteld op 0 (de standaardinstelling) worden alle transacties direct verwerkt. Indien ingesteld op 1 worden alle transacties pas op de schrijf opgeslagen bij een verwerkingsopdracht, maar daardoor worden de prestaties enigszins aangetast.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'Het aantal achtergrondthreads dat de engine kan gebruiken.',
    'OdbcEdit.access.maxscanrows.label' => 'Max aantal te scannen regels',
    'OdbcEdit.access.maxscanrows.description' => 'Het aantal rijen dat nagekeken moet worden als het datatype van een kolom wordt ingesteld aan de hand van bestaande gegevens.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Geeft aan hoe wijzigingen die buiten een transactie om worden gemaakt moeten worden weggeschreven in de database.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Geeft aan of het stuurprogramma van MS Access expliciet door de gebruiker ingestelde transacties asynchroon zal uitvoeren.',

    'OdbcEdit.mssql.driver.label' => 'Stuurprogramma',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Aanmeldingskenmerk',
    'OdbcEdit.mssql.pwd.label' => 'Wachtwoord',
    'OdbcEdit.mssql.database.label' => 'Standaard database',
    'OdbcEdit.mssql.app.label' => 'Naam van toepassing',
    'OdbcEdit.mssql.wsid.label' => 'Werkstation-id',
    'OdbcEdit.mssql.language.label' => 'Standaardtaal',
    'OdbcEdit.mssql.oemtoansi.label' => 'Omzetting van speciale karakters naar OEM-waarden',

    'OdbcEdit.mysql.driver.label' => 'ODBC-stuurprogramma MySQL',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'De hostnaam van de MariaDB/MySQL-server',
    'OdbcEdit.mysql.database.label' => 'Standaard database',
    'OdbcEdit.mysql.user.label' => 'Gebruikersnaam',
    'OdbcEdit.mysql.user.description' => 'De gebruikersnaam om verbinding te maken met MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Wachtwoord',
    'OdbcEdit.mysql.password.description' => 'Het wachtwoord voor het gebruikeraccount op de server',
    'OdbcEdit.mysql.port.label' => 'Poort',
    'OdbcEdit.mysql.port.description' => 'De TCP/IP-poort die gebruikt moet worden voor andere servers dan localhost',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows named pipe om verbinding te maken als de server \'localhost\' is',
    'OdbcEdit.mysql.option.label' => 'Opties',
    'OdbcEdit.mysql.option.description' => 'Opties die aangeven hoe MyODBC moet werken. Zie <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentatie</a>',

    'ProtectedDirectoryList.add' => 'Afgeschermde map toevoegen',
    'ProtectedDirectoryList.addTooltip' => 'Een beschermde map aanmaken.',
    'ProtectedDirectoryList.name' => 'Naam',
    'ProtectedDirectoryList.realmTitle' => 'Titel van de afgeschermde omgeving',
    'ProtectedDirectoryList.noSelectionText' => 'Selecteer een of meer items om te verwijderen.',
    'ProtectedDirectoryList.edit' => 'Bewerken',
    'ProtectedDirectoryList.remove' => 'Niet langer afschermen',
    'ProtectedDirectoryList.removeTooltip' => 'De geselecteerde mappen niet langer afschermen.',
    'ProtectedDirectoryList.removeConfirmation' => 'Deze handeling zal ertoe leiden dat de bescherming wordt verwijderd van {count, plural, one {}=1 {de map {name}} other {# geselecteerde mappen}}. {count, plural, one {}=1 {Deze map zal} other {De mappen zullen}} daardoor vrij toegankelijk worden voor iedereen op het internet.',
    'ProtectedDirectoryList.removeSuccess' => 'De geselecteerde mappen zijn verwijderd.',

    'ProtectedDirectoryAdd.title' => 'Een beschermde map aanmaken',
    'ProtectedDirectoryAdd.submit' => 'Aanmaken',
    'ProtectedDirectoryAdd.success' => 'Het aanmaken van afgeschermde map %%path%% is geslaagd',

    'ProtectedDirectoryEdit.title' => 'Instellingen afgeschermde map',
    'ProtectedDirectoryEdit.success' => 'Instellingen afgeschermde map zijn gewijzigd',

    'ProtectedDirectoryUserAdd.title' => 'Een gebruiker voor beschermde map aanmaken',
    'ProtectedDirectoryUserAdd.subtitle' => 'Map %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Gebruikersnaam',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Wachtwoord',
    'ProtectedDirectoryUserAdd.submit' => 'Aanmaken',
    'ProtectedDirectoryUserAdd.success' => 'Gebruiker %%login%% met toegang tot afgeschermde map is aangemaakt.',

    'ProtectedDirectoryUserPassword.title' => 'Wachtwoord voor gebruiker van afgeschermde map',
    'ProtectedDirectoryUserPassword.subtitle' => 'Gebruiker %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Wachtwoord',
    'ProtectedDirectoryUserPassword.submit' => 'Opslaan',
    'ProtectedDirectoryUserPassword.success' => 'De aanmeldgegevens van de gebruiker zijn opgeslagen.',

    'SummaryReport.Layout.title' => 'Eigenschappen van verslagindeling',
    'SummaryReport.Layout.success' => 'Verslagindeling %%name%% is bijgewerkt.',

    'SummaryReport.Layout.Add.title' => 'Verslagindeling aanmaken',
    'SummaryReport.Layout.Add.success' => 'Verslagindeling %%name%% is aangemaakt.',

    'SummaryReport.Report.buttonLayouts' => 'Indelingen',
    'SummaryReport.Report.buttonSchedule' => 'Rooster',
    'SummaryReport.Report.buttonProperties' => 'Eigenschappen',
    'SummaryReport.Report.buttonTrafficHistory' => 'Overzicht van verbruikt dataverkeer',
    'SummaryReport.Report.buttonPrint' => 'Afdrukken',
    'SummaryReport.Report.buttonSend' => 'Versturen per e-mail',
    'SummaryReport.Report.successSent' => 'Het verslag is verzonden aan %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Bezorgrooster voor %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Verslagbezorgrooster is bijgewerkt.',

    'SummaryReport.Schedule.Add.title' => 'Bezorgroosters aanmaken voor %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Verslagbezorgrooster is aangemaakt.',

    'VirtualDirectory.errNotExist' => 'Deze virtuele map is gekoppeld aan fysieke map die niet bestaat.',
    'VirtualDirectory.errNoPermissions' => 'U beschikt niet over de rechten om de inhoud van deze map te bekijken.',
    'VirtualDirectory.tabBrowse' => 'Mappen',
    'VirtualDirectory.tabBrowseHint' => 'Werken met fysieke en virtuele bestanden en mappen binnen de site %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME-typen',
    'VirtualDirectory.tabMimeTypesHint' => 'Geregistreerde MIME-types beheren.',
    'VirtualDirectory.tabErrorDocs' => 'Foutmeldingdocumenten',
    'VirtualDirectory.tabErrorDocsHint' => 'Foutmeldingdocumenten beheren.',
    'VirtualDirectory.tabProtection' => 'Afscherming',
    'VirtualDirectory.tabProtectionHint' => 'De toegang tot de map beperken door deze met een wachtwoord af te schermen.',

    'VirtualDirectory.errorDocType.default' => 'Standaard',
    'VirtualDirectory.errorDocType.file' => 'Bestand',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.Sidebar.buttonProperties' => 'Mapeigenschappen',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => 'Eigenschappen van virtuele map bekijken en wijzigen.',
    'VirtualDirectory.Sidebar.buttonPermissions' => 'Toegangsrechten tot map',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => 'Toegangsrechten voor map instellen.',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => 'ASP.NET-instellingen configureren.',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => 'PHP-instellingen configureren.',

    'VirtualDirectory.CreateDirectory.title' => 'Map aanmaken',
    'VirtualDirectory.CreateDirectory.name' => 'Mapnaam',
    'VirtualDirectory.CreateDirectory.success' => 'De map %%name%% is aangemaakt.',
    'VirtualDirectory.CreateDirectory.errExists' => 'De map %%name%% bestaat al.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Virtuele map aanmaken',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'De map %%name%% is aangemaakt.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Eigenschappen van virtuele map',
    'VirtualDirectory.EditVirtualDirectory.success' => 'De virtuele map is bewerkt.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Sluiten',

    'VirtualDirectory.MimeTypeList.add' => 'MIME-type toevoegen',
    'VirtualDirectory.MimeTypeList.edit' => 'MIME-type bewerken',
    'VirtualDirectory.MimeTypeList.addHint' => 'Een nieuw MIME-type registreren.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Extensie',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Inhoud',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Selecteer een of meer items om te verwijderen.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Wilt u {count, plural, =1 {het geselecteerde MIME-type} one {# geselecteerde MIME-typen} other {# geselecteerde MIME-typen}} verwijderen?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'De geselecteerde MIME-typen zijn verwijderd.',

    'VirtualDirectory.CreateMimeType.title' => 'MIME-type toevoegen',
    'VirtualDirectory.CreateMimeType.success' => 'Het nieuw MIME-type is geregistreerd.',

    'VirtualDirectory.EditMimeType.title' => 'MIME-type bewerken',
    'VirtualDirectory.EditMimeType.success' => 'Het MIME-type is bewerkt.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Fout',
    'VirtualDirectory.ErrorDocList.columnName' => 'Omschrijving',
    'VirtualDirectory.ErrorDocList.columnType' => 'Type',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Locatie',
    'VirtualDirectory.ErrorDocList.edit' => 'Bewerken',

    'VirtualDirectory.EditErrorDoc.title' => 'Foutmeldingdocument bewerken',
    'VirtualDirectory.EditErrorDoc.success' => 'Het foutmeldingsdocument is bewerkt.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Fout',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Type',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Locatie',

    'VirtualDirectory.Protection.notSupported' => 'Er is voor deze map geen afscherming mogelijk, omdat de naam van de map langer is dan 245 tekens of omdat de naam niet-ondersteunde karakters bevat.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Afschermen van virtuele map is uitgeschakeld',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Afschermen',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'De map %%path%% wordt nu afgeschermd.',
    'VirtualDirectory.Protection.tools' => 'Hulpprogramma\'s',
    'VirtualDirectory.Protection.removeProtection' => 'Niet langer afschermen',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Maak de URL naar deze map voor iedereen toegankelijk.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'De virtuele map niet langer afschermen? Hiermee verwijdert u ook alle gebruikers en instellingen van de afgeschermde map.',
    'VirtualDirectory.Protection.settings' => 'Instellingen',
    'VirtualDirectory.Protection.settingsTooltip' => 'Bekijk maplocatie en geef een titel het afgeschermde deel een titel.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET-instellingen configureren',

    'VirtualDirectory.Php.title' => 'PHP-versie',
    'VirtualDirectory.Php.version' => 'versie',
    'VirtualDirectory.Php.success' => 'PHP-versie is bijgewerkt.',


    'MassMailPage.sendEmail' => 'E-mail aan een grote groep versturen',
    'MassMailPage.selectAtLeastOneTemplate' => 'Selecteer ten minste één sjabloon',
    'MassMailPage.confirmRemoval' => 'Weet u zeker dat u {count, select, 1 {het geselecteerde sjabloon} other {de geselecteerde sjablonen}} wilt verwijderen?',
    'MassMailPage.remove' => 'Verwijderen',
    'MassMailPage.filters' => 'Filters',
    'MassMailPage.name' => 'Sjabloonnaam',
    'MassMailPage.sender' => 'Afzender',
    'MassMailPage.recipients' => 'Ontvangers',
    'MassMailPage.subject' => 'Onderwerp',
    'MassMailPage.created' => 'Datum van aanmaken',
    'MassMailPage.send' => 'Verzenden',
    'MassMailPage.recipientsNone' => 'Geen',
    'MassMailPage.recipientsAdmins' => 'Beheerder',
    'MassMailPage.recipientsResellers' => 'Alle resellers',
    'MassMailPage.recipientsResellersSelected' => 'Geselecteerde resellers',
    'MassMailPage.recipientsResellersExcept' => 'Alle resellers behalve de geselecteerde',
    'MassMailPage.recipientsClients' => 'Alle cliënten',
    'MassMailPage.recipientsClientsSelected' => 'Geselecteerde cliënten',
    'MassMailPage.recipientsClientsExcept' => 'Alle cliënten behalve de geselecteerde',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Sjabloon} other {Sjablonen}} verwijderd.',
    'MassMailPage.emptyViewTitle' => 'Geen sjablonen voor e-mailberichten aan een grote groep',
    'MassMailPage.addNew' => 'Sjabloon aanmaken',
    'CreateMassMailTemplatePage.templateCreated' => 'Het sjabloon is aangemaakt.',
    'EditMassMailTemplatePage.templateUpdated' => 'Het sjabloon is bijgewerkt.',
    'SendMassMailPage.emailSent' => 'De e-mail is verzonden.',
    'SendMassMailPage.fieldIsRequired' => 'Het veld mag niet leeg zijn',
    'SendMassMailPage.saveAsTemplate' => 'Het ingevoerde bericht opslaan als een nieuw sjabloon',
    'SendMassMailPage.newTemplateName' => 'Naam nieuw sjabloon',
    'SendMassMailPage.selectedTemplate' => 'Geselecteerd sjabloon',
    'SendMassMailPage.send' => 'Verzenden',
    'VirtualHostTemplatePage.name' => 'Naam',
    'VirtualHostTemplatePage.sizeInBytes' => 'Grootte',
    'VirtualHostTemplatePage.modified' => 'Datum van wijziging',
    'VirtualHostTemplatePage.permissions' => 'Rechten',
    'VirtualHostTemplatePage.user' => 'Gebruiker',
    'VirtualHostTemplatePage.group' => 'Groep',
    'VirtualHostTemplatePage.uploadTemplate' => 'Uploaden',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Het sjabloon is geüpload.',
    'VirtualHostTemplatePage.root' => 'Virtueel sjabloon',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Geen bestanden in sjabloon',
    'VirtualHostTemplatePage.total' => 'Totaal aantal items in map {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Standaard terugplaatsen',
    'VirtualHostTemplatePage.successfullyReset' => 'Het sjabloon is ingesteld op de standaardwaarden.',

    'TrafficUsageByDomain.List.service' => 'Dienst',
    'TrafficUsageByDomain.List.usage' => 'Gebruikt',
    'TrafficUsageByDomain.List.incoming' => 'in',
    'TrafficUsageByDomain.List.outgoing' => 'Uitgaand',
    'TrafficUsageByDomain.List.percentOfAll' => '% van Alle',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Domeinnaam',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Naam van houder",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Gebruikt',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Beperking',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Beschikbaar',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Gebruikt (in %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Alleen mijn domeinen',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Alleen reseller-domeinen',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Naam van houder',

    'TrafficUsageByReseller.emptyView' => 'De reseller beschikt niet over cliënten',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Eigen domeinen van reseller",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Domeinen van reseller-cliënten: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informatie en statistieken',
    'InfoAndStatistics.Main.overview' => 'Overzicht',
    'InfoAndStatistics.Main.domains' => 'Domeinen',
    'InfoAndStatistics.Main.trafficUsage' => 'Dataverkeerverbruik',
    'InfoAndStatistics.Main.reports' => 'Verslagen',
    'InfoAndStatistics.Main.serverSettings' => 'Server-instellingen',
    'InfoAndStatistics.TrafficUsage.customers' => 'Cliënten',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Resellers',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domeinen',

    'ConfigureMailClient.title' => 'Selecteer uw mailprogramma',
    'ConfigureMailClient.description' => 'Om uw e-mail %%email%% automatisch in te stellen',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Handmatig',
    'ConfigureMailClient.Common.email' => 'E-mail:',
    'ConfigureMailClient.Common.start' => 'Starten',
    'ConfigureMailClient.Common.finish' => 'Voltooien',
    'ConfigureMailClient.Common.next' => 'Volgende',
    'ConfigureMailClient.Common.prev' => 'Vorige',
    'ConfigureMailClient.Common.back' => 'Terug',
    'ConfigureMailClient.Common.manualLink' => 'Lukt het niet om uw e-mailaccount toe te voegen? Probeer het met de handmatige instellingen.',
    'ConfigureMailClient.Thunderbird.title' => 'Uw mailaccount instellen',
    'ConfigureMailClient.Thunderbird.description' => 'Volg de instructies om uw e-mailaccount aan Mozilla Thunderbird toe te voegen.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Open Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Open Thunderbird op uw computer en klik vervolgens op \'Accountinstellingen\' in het hoofdmenu van Thunderbird.',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Voeg uw account toe',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Klik op ‘Accountacties’ en klik vervolgens op ‘E-mailaccount toevoegen’.',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Geef uw gegevens op',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Geef uw naam op: deze verschijnt bij alle berichten die u verstuurt. Geef ook uw e-mailadres en het bijbehorende wachtwoord op en klik op "Doorgaan".',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Klaar!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird zal nu proberen uw e-mailaccount automatisch toe te voegen.',

    'ConfigureMailClient.Outlook.title' => 'Uw mailaccount instellen',
    'ConfigureMailClient.Outlook.warning' => 'Het is niet mogelijk om uw e-mailaccount automatisch toe te voegen aan Outlook 2019 of nieuwere versies.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'We gebruiken autodiscover om e-mailaccounts automatisch toe te voegen. Outlook 2019 en recentere versies gebruiken Microsoft-proxyservers voor autodiscover-aanvragen, iets wat niet wordt ondersteund door Plesk of door de extensie Plesk Premium Email.',
    'ConfigureMailClient.Outlook.description' => 'Volg de aanwijzingen om uw e-mailaccount aan Microsoft Office Outlook 2016 toe te voegen.',
    'ConfigureMailClient.Outlook.step1.title' => 'Een nieuw account toevoegen',
    'ConfigureMailClient.Outlook.step1.description' => 'Open Outlook 2016 op uw computer en ga naar het tabblad ‘Bestand’.',
    'ConfigureMailClient.Outlook.step2.title' => 'Een nieuw account toevoegen',
    'ConfigureMailClient.Outlook.step2.description' => 'Klik op \'Account toevoegen\'.',
    'ConfigureMailClient.Outlook.step3.title' => 'Geef uw e-mailadres op',
    'ConfigureMailClient.Outlook.step3.description' => 'Geef uw e-mailadres op.',
    'ConfigureMailClient.Outlook.step4.title' => 'Geef uw wachtwoord op',
    'ConfigureMailClient.Outlook.step4.description' => 'Geef het wachtwoord van uw mailaccount op en klik op \'Gereed\'.',
    'ConfigureMailClient.Outlook.step5.title' => 'Klaar!',
    'ConfigureMailClient.Outlook.step5.description' => 'Klik op "OK" om het instellen van uw account af te ronden.',

    'ConfigureMailClient.Outlook365.title' => 'Uw mailaccount instellen',
    'ConfigureMailClient.Outlook365.warning' => 'Het is niet mogelijk om uw e-mailaccount automatisch toe te voegen aan Outlook 2019 of nieuwere versies.',
    'ConfigureMailClient.Outlook365.warningTooltip' => 'We gebruiken autodiscover om e-mailaccounts automatisch toe te voegen. Outlook 2019 en recentere versies gebruiken Microsoft-proxyservers voor autodiscover-aanvragen, iets wat niet wordt ondersteund door Plesk of door de extensie Plesk Premium Email.',
    'ConfigureMailClient.Outlook365.description' => 'Volg de aanwijzingen om uw e-mailaccount aan Microsoft Outlook 365 toe te voegen.',
    'ConfigureMailClient.Outlook365.step1.title' => 'Een nieuw account toevoegen',
    'ConfigureMailClient.Outlook365.step1.description' => 'Open Outlook 365 op uw computer. Als u nog geen e-mailaccount in Outlook 365 hebt ingesteld, geef dan uw adres op in de wizard.',
    'ConfigureMailClient.Outlook365.step2.title' => 'Een nieuw account toevoegen',
    'ConfigureMailClient.Outlook365.step2.description' => 'Selecteer IMAP als uw e-mailprovider. Voer uw wachtwoord in, gebruik de aanbevolen instellingen, en klik op \'Doorgaan\'.',
    'ConfigureMailClient.Outlook365.step3.title' => 'Geef uw e-mailadres op',
    'ConfigureMailClient.Outlook365.step3.description' => 'Bevestig dat u uw IMAP-account wilt synchroniseren en wacht tot de installatie is voltooid.',
    'ConfigureMailClient.Outlook365.step4.title' => 'Meer accounts toevoegen',
    'ConfigureMailClient.Outlook365.step4.description' => 'Om meer e-mailaccounts aan Outlook 365 toe te voegen, klikt u op \'Account toevoegen\'.',
    'ConfigureMailClient.Outlook365.step5.title' => 'Klaar!',
    'ConfigureMailClient.Outlook365.step5.description' => 'Herhaal de bovenstaande stappen om een ​​nieuw account toe te voegen.',

    'ConfigureMailClient.Gmail.title' => 'Uw mailaccount instellen',
    'ConfigureMailClient.Gmail.description' => 'Volg de instructies om uw e-mailaccount aan de Gmail-app op uw mobiele apparaat toe te voegen.',
    'ConfigureMailClient.Gmail.step1.title' => 'Een nieuw account toevoegen',
    'ConfigureMailClient.Gmail.step1.description1' => 'Open de Gmail-app op uw Android-telefoon en tik op uw profielfoto in de rechterbovenhoek.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Klik op "Nog een account toevoegen".',
    'ConfigureMailClient.Gmail.step1.description3' => 'Klik op "Anders".',
    'ConfigureMailClient.Gmail.step2.title' => 'Geef uw e-mailadres op',
    'ConfigureMailClient.Gmail.step2.description' => 'Geef uw emailadres op en klik op "Volgende".',
    'ConfigureMailClient.Gmail.step3.title' => 'Selecteer het type account',
    'ConfigureMailClient.Gmail.step3.description' => 'Om een kopie van uw gedownloade e-mailberichten op de server te bewaren, tikt u op "Persoonlijk (IMAP)". Om gedownloade e-mailberichten van de server te verwijderen, tikt u op "Persoonlijk (POP3)".',
    'ConfigureMailClient.Gmail.step4.title' => 'Geef uw wachtwoord op',
    'ConfigureMailClient.Gmail.step4.description' => 'Geefhet wachtwoord van uw mailaccount op en tik op "Volgende".',
    'ConfigureMailClient.Gmail.step5.title' => 'Instellingen verwijderen van mail',
    'ConfigureMailClient.Gmail.step5.description' => 'Geef aan of het verwijderen van e-mails in de app ze ook meteen van de server moet verwijderen en tik op "Volgende".',
    'ConfigureMailClient.Gmail.step6.title' => 'Account-opties',
    'ConfigureMailClient.Gmail.step6.description1' => 'De app haalt automatisch de instellingen voor de uitgaande server op.',
    'ConfigureMailClient.Gmail.step6.description2' => 'U kunt als u wilt de standaardopties wijzigen en daarna tikt u weer op "Volgende".',
    'ConfigureMailClient.Gmail.step7.title' => 'Klaar!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Optioneel) Geef uw naam op, zoals u wilt dat deze wordt weergegeven in de berichten die u verstuurt.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Klik op "Volgende" om het instellen van uw account af te ronden.',

    'ConfigureMailClient.Ios.title' => 'Uw mailaccount instellen',
    'ConfigureMailClient.Ios.description' => 'Scan de QR-code of open de onderstaande link op uw iOS-apparaat om uw e-mailaccount automatisch aan de Mail-app van iOS toe te voegen.',
    'ConfigureMailClient.Ios.link'  =>  'Account aan iOS Mail toevoegen',

    'ConfigureMailClient.Manual.title' => 'Uw mailaccount handmatig instellen',
    'ConfigureMailClient.Manual.description' => 'Gebruik de volgende waarden wanneer u %%email%% aan uw e-mailprogramma toevoegt.',
    'ConfigureMailClient.Manual.username' => 'Gebruikersnaam mailserver:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Uitgaande mailserver (authenticatie vereist):',
    'ConfigureMailClient.Manual.incomingServer' => 'Server voor inkomende mail:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Ondersteunde protocollen voor inkomende mail:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Ondersteunde protocollen voor uitgaande mail:',


    'Databases.Page.title' => 'Databases voor %%database%%',
    'Databases.Page.databaseTab' => 'Databases',
    'Databases.Page.userTab' => 'Gebruikerbeheer',
    'Databases.Page.serversLink' => 'Database-servers',
    'Databases.Page.backupLink' => 'Reservekopieën beheren',

    'Databases.List.add' => 'Database toevoegen',
    'Databases.List.find' => 'Database zoeken...',
    'Databases.List.databaseColumn' => 'Database',
    'Databases.List.relatedToColumn' => 'Hoort bij',
    'Databases.List.relatedToDomains' => 'Gerelateerd aan %%domains%%',
    'Databases.List.noRelatedDomains' => 'Deze database aan een website toewijzen',
    'Databases.List.noDomainRelations' => 'Geen gerelateerde sites',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => 'Wijzigen',
    'Databases.List.connectionInfo' => 'Verbindingsinformatie',
    'Databases.List.downloadDump' => 'Dump exporteren',
    'Databases.List.uploadDump' => 'Dump importeren',
    'Databases.List.copy' => 'Database kopiëren',
    'Databases.List.checkDatabase' => 'Controle en herstel',
    'Databases.List.assignToSubscription' => 'Naar abonnement verplaatsen',
    'Databases.List.assignToSubscription_powerUser' => 'Naar webruimte verplaatsen',
    'Databases.List.remove' => 'Verwijderen',
    'Databases.List.removeConfirmation' => 'Wilt u de database %%name%% verwijderen?',
    'Databases.List.removeButtonDisabledHint' => 'Kan de database niet verwijderen omdat deze door een geïnstalleerde webtoepassing wordt gebruikt.',
    'Databases.List.databaseRemoved' => 'Deze database is verwijderd.',
    'Databases.List.downloadMsSqlClient' => 'Een lokale SQL-client downloaden',
    'Databases.List.downloadMsSqlClientHint' => 'Een lokale SQL-client downloaden',
    'Databases.List.webadmin' => 'Web Admin',
    'Databases.List.webadminHint' => 'Toegang tot deze server via de web-admin.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Kan geen dump %%action%%: het abonnement is opgeschort.',
    'Databases.List.dumpExport' => 'exporteren',
    'Databases.List.dumpImport' => 'importeren',
    'Databases.List.copyDatabaseName' => 'Databasenaam kopiëren',
    'Databases.List.copySuccess' => 'De %%name%% is naar het klembord gekopieerd',

    'Databases.DatabaseSummary.host' => 'Host',
    'Databases.DatabaseSummary.serverUnavailable' => 'De server is niet beschikbaar.',
    'Databases.DatabaseSummary.user' => 'Gebruiker',
    'Databases.DatabaseSummary.users' => 'Gebruikers',
    'Databases.DatabaseSummary.noUser' => 'Geen database-gebruikers',
    'Databases.DatabaseSummary.seeAll' => 'Alles',
    'Databases.DatabaseSummary.createUser' => 'Gebruiker aanmaken',
    'Databases.DatabaseSummary.calculatingSize' => 'De omvang berekenen...',
    'Databases.DatabaseSummary.tablesCount' => 'Tabellen',
    'Databases.DatabaseSummary.size' => 'Grootte',

    'Databases.InPlaceSelect.editButtonHint' => 'Bewerken',
    'Databases.InPlaceSelect.saveButtonHint' => 'Opslaan',
    'Databases.InPlaceSelect.closeButtonHint' => 'Annuleren',
    'Databases.InPlaceSelect.selectWebsiteAriaLabel' => 'een website selecteren',

    'Databases.ConnectionInfo.title' => 'Verbindingsinformatie',
    'Databases.ConnectionInfo.description' => 'voor database %%database%%',
    'Databases.ConnectionInfo.hint' => 'U kunt deze database-verbindingsgegevens bijvoorbeeld gebruiken bij de installatie van een webapplicatie.',
    'Databases.ConnectionInfo.host' => 'Host',
    'Databases.ConnectionInfo.copyHost' => 'Host naar klembord kopiëren',
    'Databases.ConnectionInfo.databaseName' => 'Databasenaam',
    'Databases.ConnectionInfo.copyDatabaseName' => 'Database-naam naar klembord kopiëren',
    'Databases.ConnectionInfo.user' => 'Gebruikersnaam',
    'Databases.ConnectionInfo.copyUser' => 'Gebruikersnaam naar klembord kopiëren',
    'Databases.ConnectionInfo.password' => 'Wachtwoord',
    'Databases.ConnectionInfo.noDefaultUser' => 'Geen standaardgebruiker',

    'Databases.Add.title' => 'Database toevoegen',
    'Databases.Add.name' => 'Databasenaam',
    'Databases.Add.server' => 'Database-server',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => 'Gerelateerde site',
    'Databases.Add.noDomainRelations' => 'Geen gerelateerde sites',
    'Databases.Add.userSection' => 'Gebruikers',
    'Databases.Add.userSectionDescription' => 'Een standaard databasegebruiker aanmaken. Plesk zal namens deze gebruiker verbinding met de database maken. Als er geen databasegebruikers aan de database zijn toegewezen is deze niet bereikbaar.',
    'Databases.Add.createUser' => 'Een Databasegebruiker aanmaken',
    'Databases.Add.username' => 'Gebruikersnaam voor database',
    'Databases.Add.password' => 'Wachtwoord',
    'Databases.Add.passwordConfirmation' => 'Bevestig wachtwoord',
    'Databases.Add.allDbAccess' => 'Gebruiker heeft toegang tot alle databases binnen het geselecteerde abonnement',
    'Databases.Add.aclRadio' => 'Toegangsbeheer',
    'Databases.Add.aclLocalhost' => 'Alleen lokale verbindingen toestaan',
    'Databases.Add.aclAny' => 'Externe verbindingen toestaan vanaf elke host',
    'Databases.Add.aclCustom' => 'Externe verbindingen toestaan vanaf',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe opgegeven hosts hebben toegang tot de database namens deze gebruiker.",
    'Databases.Add.aclHostsLabel' => 'Geef hier de hostnamen of IP-adressen op van externe hosts die u toegang wilt geven',
    'Databases.Add.remoteAccess' => 'Externe toegang',
    'Databases.Add.remoteAccessDenied' => 'Gebruik de regels van de firewall voor het systeem',
    'Databases.Add.remoteAccessAllowed' => 'Externe verbindingen toestaan vanaf',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe opgegeven IP-adressen hebben via een firewallregel toegang tot de databaseserver. Uw wijzigingen in deze lijst worden vooraf gemodereerd door uw hostingprovider.",
    'Databases.Add.remoteAccessHint' => 'Neem contact op met uw provider en zorg ervoor dat de optie die u hierboven hebt aangegeven voldoet aan de huidige firewall-regels voor inkomende toegang tot MariaDB/MySQL.',
    'Databases.Add.example' => "Bijvoorbeeld:\n%%example%%",
    'Databases.Add.denied' => 'Gebruik de regels van de firewall voor het systeem',
    'Databases.Add.allowed' => 'Externe verbindingen toestaan vanaf',
    'Databases.Add.databaseCreated' => 'De database %%name%% is aangemaakt.',
    'Databases.Add.create' => 'Database aanmaken',

    'Databases.Clone.title' => 'Database kopiëren',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Waarschuwing: als de namen van tabellen gelijk zijn, zal de tabel in de database van bestemming worden vervangen door die uit de bron-database.',
    'Databases.Clone.formDescription' => 'Kopieer de inhoud van de database naar een nieuwe of bestaande database. Bij het kopiëren naar een bestaande database worden tabellen van de bron-database toegevoegd aan de lijst met tabellen van de database van bestemming.',
    'Databases.Clone.copyData' => 'Een volledige kopie maken',
    'Databases.Clone.copyDataHint' => 'Als deze optie is geselecteerd, dan zal de gehele database, inclusief de data, worden gekopieerd. Als deze optie niet is geselecteerd, dan zal alleen de tabelstructuur worden gekopieerd.',
    'Databases.Clone.copyHint' => 'Je gaat de database %%databaseName%% kopiëren',
    'Databases.Clone.server' => 'Database-server van bestemming',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => 'Overig...',
    'Databases.Clone.database' => 'Database van bestemming',
    'Databases.Clone.newDatabase' => 'Database aanmaken met naam',
    'Databases.Clone.newDatabaseName' => 'Nieuwe database-naam',
    'Databases.Clone.existingDatabaseName' => 'Bestaande database-naam',
    'Databases.Clone.existingDatabase' => 'Kopiëren naar bestaande database',
    'Databases.Clone.externalDbHost' => 'Hostnaam of IP-adres',
    'Databases.Clone.externalDbLogin' => 'Gebruikersnaam',
    'Databases.Clone.externalDbPassword' => 'Wachtwoord',
    'Databases.Clone.subscription' => 'Abonnement van bestemming',
    'Databases.Clone.subscription_powerUser' => 'Webruimte van bestemming',
    'Databases.Clone.cloneInProgress' => 'Database %%source%% wordt gekloond naar database %%destination%%. U wordt van de voortgang op de hoogte gehouden via e-mail (%%email%%).',
    'Databases.Clone.unableToClone' => 'Kan de database "%%source%%" niet kopiëren.',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Kan geen database "%%destination%%" aanmaken op de opgegeven server.',
    'Databases.Clone.databaseCloned' => 'De database "%%source%%" is gekopieerd.',
    'Databases.Clone.emailSubjSuccess' => 'De database "%%sourceDatabase%%" is gekopieerd.',
    'Databases.Clone.emailSubjFailure' => 'Het kopiëren van database "%%sourceDatabase%%" is mislukt.',
    'Databases.Clone.emailBodySuccess' => 'De database "%%sourceDatabase%%" (%%sourceHost%%) is gekopieerd naar de database "%%destDatabase%%" (%%destHost%%).',
    'Databases.Clone.emailBodyFailure' => 'Kan database "%%sourceDatabase%%" (%%sourceHost%%) niet kopiëren naar de database "%%destDatabase%%" (%%destHost%%); het kopiëren is mislukt.',
    'Databases.Clone.localServer' => 'lokale server',

    "Databases.Import.confirm" => 'Dump importeren',
    'Databases.Import.recreateDatabase' => 'De database opnieuw aanmaken',
    'Databases.Import.rootDirectory' => 'Hoofdmap',
    'Databases.Import.uploadFromFile' => 'Een dump uploaden vanaf je lokale computer',
    'Databases.Import.uploadFromWebspace' => 'Een op uw hosting-server opgeslagen dump importeren',
    'Databases.Import.uploadHint' => 'U gaat een dump importeren naar %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => 'Database-dump importeren',
    'Databases.Import.uploading' => 'Importeren...',
    'Databases.Import.waitMessage' => 'Een ogenblik geduld...',

    "Databases.Export.confirm" => 'Dump exporteren',
    'Databases.Export.downloadDumpAutomatically' => 'De dump automatisch downloaden zodra deze is aangemaakt',
    'Databases.Export.downloadDumpName' => 'Bestandsnaam van dump',
    'Databases.Export.downloadHint' => 'U gaat nu een dump van %%database%% aanmaken en downloaden',
    'Databases.Export.downloadPopupTitle' => 'Dump exporteren',
    'Databases.Export.downloadRelativePath' => 'De dump opslaan in de volgende map',
    'Databases.Export.rootDirectory' => 'Hoofdmap',
    'Databases.Export.waitMessage' => 'Een ogenblik geduld...',

    'MoveDatabasePage.title' => 'Databases verplaatsen naar een ander abonnement',
    'MoveDatabasePage.title_powerUser' => 'Databases verplaatsen naar een andere webruimte',
    'MoveDatabasePage.description' => 'U gaat de database %%name%% verplaatsen',
    'MoveDatabasePage.hint' => 'De geselecteerde databases zullen naar het geselecteerde abonnement worden verplaatst. De databasegebruikers zullen ook worden verplaatst, tenzij ze ook toegang hebben tot andere databases. Let op: na het verplaatsen kunnen gebruikers die vóór de verplaatsing toegang hadden tot de database deze niet meer openen via de link in Plesk.',
    'MoveDatabasePage.subscriptionName' => 'Naar abonnement verplaatsen',
    'MoveDatabasePage.subscriptionName_powerUser' => 'Naar webruimte verplaatsen',
    'MoveDatabasePage.save' => 'Verplaatsen',

    'WebProsAccountPage.descriptionHead' => 'Toegang tot alle WebPros-diensten en tot uw Plesk-server met één veilige aanmeldmethode.',
    'WebProsAccountPage.descriptionBody' => 'Via uw WebPros-account heeft u toegang tot het Dashboard, Monitoring, Support Portal, Plesk University en KA Partner Central. Dit maakt het beheer van het complete WebPros-ecosysteem een stuk makkelijk!',
    'WebProsAccountPage.buttonLogin' => 'Aanmelden met WebPros-account',
    'WebProsAccountPage.buttonSkip' => 'Overslaan tot volgende aanmelding',
];
