<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subnet o indirizzo IP',
    'access-network.subnetOrIpAddressHint' => 'Per esempio, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletter',
    'admin.announcement-settings.getConsentLoading' => 'Recupero di informazioni sulle newsletter...',
    'admin.announcement-settings.getConsentWarning' => 'Impossibile recuperare lo stato dell’iscrizione.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Vorrei ricevere newsletter da WebPros. Tali comunicazioni potrebbero contenere informazioni tecniche, sulla sicurezza e generali sul prodotto. Fornisco il mio consenso e autorizzo WebPros a raccogliere, elaborare e utilizzare i miei dati personali (indirizzo e-mail), inclusa l\'elaborazione in altri Paesi, in conformità alle leggi applicabili e attualmente vigenti in materia di protezione dei dati, al fine di inviarmi newsletter direttamente o tramite il servizio di terze parti. Deselezionando questa casella di controllo revoco il mio consenso e richiedo a WebPros di non inviarmi altre Messaggi e-mail e di rimuovere permanentemente i miei dati personali dai suoi sistemi.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Le aziende WebPros qui elencate possano utilizzare il mio nome e il mio indirizzo e-mail (%%adminEmail%%) allo scopo di fornirmi contenuti di marketing personalizzati come newsletter e offerte relative ai prodotti WebPros. Le aziende che desiderano richiedere il consenso sono: WebPros International LLC e WebPros International GmbH. Le informazioni saranno utilizzate ai sensi della %%privacyPolicy%%% fino alla revoca del mio consenso e potranno essere condivise internamente con altre entità del gruppo WebPros. Posso modificare o ritirare il mio consenso in qualsiasi momento deselezionandoi la casella di controllo, facendo clic sul link presente in qualsiasi comunicazione ricevuta o inviando un\'e-mail a privacy@plesk.com',
    'admin.announcement-settings.privacyPolicy' => 'Informativa sulla privacy di WebPros',
    'admin.announcement-settings.noConsent' => 'Annulla la mia iscrizione alla newsletter di WebPros.',
    'admin.announcement-settings.reportConsentError' => 'Impossibile salvare le impostazioni per la ricezione di informazioni da Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Purtroppo non è possibile aggiornare il tuo profilo al momento. Riprova più tardi.',
    'admin.announcement-settings.invalidConsentType' => "Tipo di consenso sconosciuto: '%%type%%'",
    'admin.announcement-settings.retry' => 'Riprovare',
    'admin.announcement-settings.consentGivenInfo' => 'Speriamo che ti sia piaciuta la newsletter generica di WebPros. Ora possiamo fornirti un’alternativa migliore: personalizzata, con informazioni e suggerimenti utili, in base alle tue esigenze. Per ricevere la newsletter personalizzata di WebPros, scegli la prima affermazione di seguito e fai clic su OK.',

    'admin.personal-info.title' => 'Modifica del profilo dell\'amministratore',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Impostazioni di Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Impostazioni',

    'admin-alias.login' => 'Nome utente',
    'admin-alias.password' => 'Password',
    'admin-alias.passwordConfirmation' => 'Conferma la password',
    'admin-alias.email' => 'E-mail',
    'admin-alias.contact' => 'Nome di contatto',
    'admin-alias.comments' => 'Commenti',
    'admin-alias.emptyLogin' => 'Inserisci nome utente.',
    'admin-alias.loginTooLong' => 'La lunghezza del nome utente supera i 20 caratteri.',
    'admin-alias.emptyEmail' => 'Inserisci indirizzo e-mail.',
    'admin-alias.emptyContactName' => 'Indicare un nome di contatto.',
    'admin-alias.contactNameTooLong' => 'La lunghezza del nome di contatto supera i 255 simboli.',
    'admin-alias.emptyPassword' => 'Inserisci una password.',
    'admin-alias.commentsTooLong' => 'La lunghezza del commento supera i 255 simboli.',
    'admin-alias.emailActivation' => 'Attiva account via e-mail',
    'admin-alias.simplePanel' => 'Abilita la modalità limitata',
    'admin-alias.simplePanelHint' => 'Seleziona questa opzione per limitare il numero di azioni che l\'amministratore aggiuntivo può eseguire in Plesk. Per modificare le azioni disponibili, vai a %%link%%.',
    'admin-alias.simplePanelLink' => 'Strumenti e Impostazioni > Impostazioni modalità limitata',
    'admin-alias.lockPowerUser' => 'Forza la visualizzazione Power User per un amministratore aggiuntivo',
    'admin-alias.lockPowerUserHint' => 'Capacità di limitare la visualizzazione per un amministratore Plesk aggiuntivo (nessun accesso a clienti, rivenditori e piani di servizio).',

    'admin-info.plesk-settings.multiplyLogin' => 'Consente sessioni multiple con questo account',
    'admin-info.plesk-settings.adminLanguage' => 'Lingua dell\'interfaccia amministrativa',
    'admin-info.plesk-settings.password' => 'Password',
    'admin-info.plesk-settings.passwordConfirmation' => 'Conferma la password',
    'admin-info.plesk-settings.oldPassword' => 'Vecchia password',

    'admin-panel.form.contact-info.login' => 'Accedi',
    'admin-panel.form.contact-info.contactName' => 'Nome di contatto',
    'admin-panel.form.contact-info.emptyLogin' => 'Inserisci un nome utente.',
    'admin-panel.form.contact-info.emptyContactName' => 'Indicare un nome di contatto.',
    'admin-panel.form.contact-info.loginTooLong' => 'Il nome utente è troppo lungo (il massimo consentito è di %max% simboli).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Il nome di contatto è troppo lungo (sono consentiti %max% simboli massimi).',
    'admin-panel.form.contact-info.email' => 'Indirizzo e-mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Inserisci indirizzo e-mail.',
    'admin-panel.form.contact-info.companyName' => 'Nome della società',
    'admin-panel.form.contact-info.longCompanyName' => 'Questo nome di società è troppo lungo (massimo consentito: %max% simboli).',
    'admin-panel.form.contact-info.phone' => 'Numero di telefono',
    'admin-panel.form.contact-info.longPhone' => 'Questo numero di telefono è troppo lungo (massimo consentito: %max% simboli).',
    'admin-panel.form.contact-info.fax' => 'Numero di fax',
    'admin-panel.form.contact-info.imNumber' => 'Messaggistica istantanea',
    'admin-panel.form.contact-info.longFax' => 'Questo numero di fax è troppo lungo (massimo consentito: %max% simboli).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Il numero di telefono specificato non è valido.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Questo numero di fax non è valido.',
    'admin-panel.form.contact-info.address' => 'Indirizzo',
    'admin-panel.form.contact-info.longAddress' => 'Questo indirizzo e-mail è troppo lungo (massimo consentito: %max% simboli).',
    'admin-panel.form.contact-info.city' => 'Città',
    'admin-panel.form.contact-info.longCity' => 'Il nome di città specificato è troppo lungo.',
    'admin-panel.form.contact-info.shortCity' => 'Il nome di città specificato è troppo breve.',
    'admin-panel.form.contact-info.state' => 'Stato/Provincia',
    'admin-panel.form.contact-info.postalCode' => 'Codice di Avviamento Postale',
    'admin-panel.form.contact-info.country' => 'Paese',
    'admin-panel.form.contact-info.additionalInfo' => 'Informazioni aggiuntive',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Soltanto testo semplice: Tutti i tag HTML saranno ignorati.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Esiste già un utente con tale indirizzo e-mail nel sistema.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abbonamento',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Proprietà del sito web fornite insieme all\'abbonamento.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Proprietà del sito web fornite insieme all\'abbonamento.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Proprietà del sito web fornite insieme all\'abbonamento.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Crea abbonamento per il cliente',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Deseleziona questa casella di controllo se non vuoi creare un abbonamento di servizio di hosting o configurare un sito web per il cliente in questo momento. Senza un abbonamento, il cliente non sarà in grado di accedere al Pannello del Cliente.',
    'admin-panel.form.domain-info-section.domainName' => 'Nome del dominio',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'È necessario indicare un nome di dominio.',
    'admin-panel.form.domain-info-section.shared' => 'condiviso',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicato',
    'admin-panel.form.domain-info-section.userName' => 'Nome utente',
    'admin-panel.form.domain-info-section.userNameHint' => 'L\'account utente di sistema usato per gestire i file e le cartelle dei siti web creati nell\'abbonamento.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Devi fornire un nome utente.',
    'admin-panel.form.domain-info-section.password' => 'Password',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Devi fornire una password.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Conferma password',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "L'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell'host virtuale del sito web.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Indirizzi IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "L'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell'host virtuale del sito web.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Indirizzi IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Nessuno',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Impostazioni di abbonamento aggiuntive',
    'admin-panel.form.domain-info-section.credentials' => 'Credenziali dell\'utente di sistema',
    'admin-panel.form.domain-info-section.credentialsHint' => 'per accedere ai file ospitati tramite FTP e SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'per accedere ai file ospitati tramite FTP e RDP',

    'admin-panel.form.login-info.userName' => 'Nome utente',
    'admin-panel.form.login-info.emptyUserName' => 'Indicare un nome utente.',
    'admin-panel.form.login-info.oldPassword' => 'Vecchia password',
    'admin-panel.form.login-info.password' => 'Password',
    'admin-panel.form.login-info.emptyPassword' => 'Indicare una password.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Ripeti la password',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Modificando la password verrà modificata anche la password dell\'indirizzo e-mail interno',
    'admin-panel.form.login-info.emailActivation' => 'Attiva account via e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Un account creato rimane inattivo finché l\'utente non lo attiva mediante il link inviato via e-mail o l\'amministratore non lo attiva manualmente.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abbonamento',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Piano di servizio',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Piano di servizio corrente',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Nuovo piano di servizio',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Piano semplice',
    'admin-panel.form.subscription-info-section.none' => 'Nessuno',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Componenti aggiuntivi',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Procedi alla personalizzazione dei parametri dell\'abbonamento dopo aver modificato l\'associazione del piano. Tieni presente che questa azione bloccherà la capacità di sincronizzazione dell\'abbonamento.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Procedi alla personalizzazione dei parametri dell\'iscrizione dopo la sua creazione.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Procedi alla personalizzazione dei parametri dell'iscrizione dopo la creazione del cliente.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Procedi alla personalizzazione dei parametri dell\'abbonamento dopo la sua creazione. Tieni presente che questa azione bloccherà la capacità di sincronizzazione dell\'abbonamento.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Tieni presente che questa azione bloccherà la capacità di sincronizzazione dell\'iscrizione.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Aggiungi abbonamento',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Impossibile sincronizzare l\'iscrizione con il piano di servizio. Le seguenti impostazioni dell’abbonamento sono in conflitto con il piano di servizio: %%problems%%.',

    'app.configure.otherSettings' => 'Altro',
    'app.configure.passwordConfirmation' => 'Conferma la password',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Forza aggiornamenti per tutte le app installate',
    'app.update-settings.forceUpdatesHint' => 'Tutte le app dei clienti riceveranno aggiornamenti automaticamente quando gli aggiornamenti saranno disponibili. I clienti non saranno in grado di disattivare gli aggiornamenti automatici per le loro app. Attenzione: Usa questa opzione con cautela perché gli aggiornamenti possono incidere significativamente sulla funzionalità dell\'app. Ad esempio, le estensioni dell\'app potrebbero non funzionare con un\'altra versione dell\'app.',
    'app.update-settings.suggestUpdates' => 'Attiva l\'opzione "Aggiorna automaticamente questa app" per impostazione predefinita',
    'app.update-settings.suggestUpdatesHint' => 'Per le app di nuova installazione, verrà attivata l\'opzione "Aggiorna automaticamente questa app" nelle impostazioni dell\'app.',

    'backup.server-settings.rotation' => 'Numero massimo di file di backup completi da archiviare (inclusi i backup pianificati e manuali)',
    'backup.server-settings.rotationDescription' => 'Gli utenti possono memorizzare fino a questo numero di backup completi nell\'archivio del server.Se il numero di backup completi già archiviati supera il limite, vengono conservati solo i backup più recenti.I backup incrementali non sono interessati.',
    'backup.server-settings.maxProcesses' => 'Numero massimo di processi di backup pianificati simultaneamente in esecuzione',
    'backup.server-settings.niceScheduled' => 'Eseguire le procedure dei backup pianificati con bassa priorità',
    'backup.server-settings.niceScheduledPriority' => 'Priorità',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Inserisci un valore tra 1 e 19 inclusi, in cui un numero maggiore equivale a minore priorità.',
    'backup.server-settings.niceScheduledIoPriority' => 'Priorità IO',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Inserisci un valore tra 0 e 7 inclusi, in cui un numero maggiore equivale a minore priorità.',
    'backup.server-settings.niceAlways' => 'Esegui tutti i processi di backup con priorità bassa',
    'backup.server-settings.niceAlwaysPriority' => 'Priorità',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Inserisci un valore tra 1 e 19 inclusi, in cui un numero maggiore equivale a minore priorità.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Priorità IO',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Inserisci un valore tra 0 e 7 inclusi, in cui un numero maggiore equivale a minore priorità.',
    'backup.server-settings.compressionLevel' => 'Livello di compressione',
    'backup.server-settings.compressionLevelNoCompression' => 'Nessuna compressione',
    'backup.server-settings.compressionLevelFastest' => 'Velocità massima',
    'backup.server-settings.compressionLevelFast' => 'Veloce',
    'backup.server-settings.compressionLevelNormal' => 'Normale',
    'backup.server-settings.compressionLevelMaximum' => 'Massimo',
    'backup.server-settings.freeSpaceRequired' => 'Avvia il backup soltanto se il server presenta lo spazio su disco libero specificato (in megabyte)',
    'backup.server-settings.checkBackupDiskSpace' => 'Avvia il backup solo se lo spazio libero su disco del server è sufficiente',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Usa la funzionalità di backup MS SQL nativa (Per database remoti, accertati di aver configurato le impostazioni di backup del server MS SQL remoto in Strumenti & Impostazioni > Server database)',
    'backup.server-settings.localFtpRestriction' => 'Consenti la configurazione dell\'archiviazione di backup FTP sul server locale',
    'backup.server-settings.backupSecuritySettings' => 'Impostazioni di sicurezza di backup',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Salva backup nello storage del server se il caricamento nell’archivio remoto non riesce',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'I backup manuali e pianificati destinati all\'archiviazione remota saranno salvati nello storage del server locale se il caricamento nell’archivio remoto non riesce. Gli utenti devono avere il permesso per archiviare backup nello storage del server.',
    'backup.server-settings.AllowScheduleHourly' => 'Consenti a clienti e rivenditori di pianificare backup orari',

    'change-current-subscription.hint' => 'In questa sezione è possibile modificare l\'associazione ai piani di servizio per l\'abbonamento. Tieni presente che scegliere \'nessuno\' come un nuovo piano di servizio svincola l\'abbonamento dal piano di servizio e la rende \'Personalizzata\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Impossibile sincronizzare l\'iscrizione con il piano di servizio. Le seguenti impostazioni dell’abbonamento sono in conflitto con il piano di servizio: %%problems%%.',

    'change-password.oldPassword' => 'Vecchia password',
    'change-password.password' => 'Nuova password',
    'change-password.passwordConfirmation' => 'Conferma la password',
    'change-password.oldPasswordIsIncorrect' => 'La password specificata non è corretta.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Impossibile trovare l\'account amministratore aggiuntivo.',
    'change-password.warningAboutAdminPasswordSyntax' => "La password dovrebbe avere una lunghezza compresa tra %%min%% - %%max%% caratteri e non dovrebbe contenere il nome utente.\nNon usare virgolette, spazi e caratteri alfabetici nazionali nella password.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Non usare virgolette, spazi, punti e virgola e caratteri alfabetici nazionali nella password.\nLa password dovrebbe avere una lunghezza compresa tra %%min%% e %%max%% caratteri e non dovrebbe contenere il nome utente.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Norme sull\'overselling',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'L\'overselling è consentito',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'L\'overselling consente ad un rivenditore di vendere più risorse di quelle che gli sono state assegnate con un piano. Se l\'overselling è consentito, un rivenditore è retto dall\'utilizzo di risorse reale invece dell\'assegnazione di risorse iniziale.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'L\'overselling non è consentito',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Se l\'overselling non è consentito, un rivenditore può solo vendere tante risorse quante inizialmente assegnate con un piano, a prescindere da quante risorse siano in realtà usate.',

    'change-reseller-subscription.hint' => 'In questa sezione è possibile modificare l\'abbonamento al piano di servizio per l\'abbonamento del rivenditore. Tieni presente che scegliere \'nessuno\' come un nuovo piano di servizio svincola l\'abbonamento dai piani di servizio e la rende \'Personalizzata\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Impossibile sincronizzare l\'iscrizione con il piano di servizio. Le seguenti impostazioni dell’abbonamento sono in conflitto con il piano di servizio: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Nuovo piano',
    'change-reseller-subscription.oldSubscription' => 'Piano attuale',
    'change-reseller-subscription.none' => 'Nessuno',
    'change-reseller-subscription.infoSubscriptionChanged' => 'È stata aggiornata l\'associazione dell\'abbonamento al piano di servizio.',
    'change-reseller-subscription.customizeSubscription' => 'Procedi alla personalizzazione dei parametri dell\'abbonamento, una volta aggiornata la sua associazione al piano di servizio. Tieni presente che questa azione bloccherà la capacità di sincronizzazione dell\'abbonamento.',

    'change-subscription.hint' => 'In questa sezione è possibile modificare l\'associazione ai piani di servizio per gli abbonamenti selezionati.',
    'change-subscription.selectPlanLegend' => 'Piano di servizio',
    'change-subscription.selectPlanDescription' => 'Per passare ad un altro piano di servizio, scegli il nuovo piano dall\'elenco. Tieni presente che scegliere \'nessuno\' svincola gli abbonamenti dal piano di servizio e li rende \'Personalizzati\'.',
    'change-subscription.servicePlan' => 'Nuovo piano di servizio',
    'change-subscription.selectAddonPlansLegend' => 'Piani di componenti aggiuntivi',
    'change-subscription.selectAddonPlansDescription' => 'Aggiungi o rimuovi piani di componenti aggiuntivi.',
    'change-subscription.noChange' => 'nessuna modifica',
    'change-subscription.none' => 'Nessuno',
    'change-subscription.add' => 'aggiungi',
    'change-subscription.del' => 'Rimuovi',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subnet o indirizzo IP',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Per esempio, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Accedi a Plesk con privilegi di amministratore',
    'control-panel-access.settings.policyAllow' => 'Consentito, si stanno escludendo i network nella lista.',
    'control-panel-access.settings.policyDeny' => 'Negato dai network non elencati.',

    'create-subscription.title' => 'Aggiungere un abbonamento',
    'create-subscription.titleOwn' => 'Aggiungere il proprio abbonamento',
    'create-subscription.poolIsEmpty' => 'Impossibile creare un abbonamento poiché in Plesk non esistono indirizzi IP condivisi, né indirizzi IP dedicati liberi.',
    'create-subscription.infoNewSubscriptionCreated' => 'È stata creata l\'abbonamento %%name%%.',
    'create-subscription.createBeforeAppInstall' => 'È necessario disporre di un abbonamento per installare l\'applicazione.',

    'customer.hint' => 'In questa sezione è possibile registrare un nuovo cliente ai tuoi servizi di hosting. Con questa registrazione si crea un account cliente in Plesk e l\'abbonamento ad uno dei tuoi piani di hosting. Facoltativamente, verranno anche creati dei componenti aggiuntivi. L\'abbonamento può anche fornire un completo set personalizzato di risorse e servizi, senza essere collegati ad alcun piano —  a tale fine, seleziona \'Nessuno\' vicino al Piano di Servizio.',
    'customer.contactInfoSection' => 'Informazione di contatto',
    'customer.additionalInfoSection' => 'Informazione aggiuntiva del cliente',
    'customer.accessToPanelSection' => 'Accesso a Plesk',
    'customer.contactInfoSectionHint' => 'Inserisce l\'informazione di contatto del cliente.',
    'customer.accessToPanelSectionHint' => 'Credenziali che l\'utente userà per accedere al proprio pannello di controllo.',
    'customer.unableCreateSubscription' => 'Impossibile creare l\'abbonamento: %%reason%%',
    'customer.poolIsEmpty' => 'Il pool IP è vuoto',
    'customer.buttonOk' => 'Aggiungi cliente',

    'database-settings.dbPrefixRadio' => 'Aggiungi un prefisso e un trattino basso all\'inizio dei nomi di database',
    'database-settings.dbPrefixNone' => 'Nessuno',
    'database-settings.dbPrefixUsername' => 'Nome utente',
    'database-settings.dbPrefixExternalId' => 'ID esterno di un abbonamento',
    'database-settings.dbPrefixCustom' => 'Prefisso personalizzato',
    'database-settings.dbUserPrefixRadio' => 'Aggiungi un prefisso e un trattino basso all\'inizio dei nomi utenti dei database',
    'database-settings.dbUserPrefixHint' => 'I nomi utente dei database avranno questo aspetto: <prefix>_<database_username>. A causa della limitazione del database relativa alla lunghezza del nome utente, <prefix> sarà abbreviato.',
    'database-settings.grantAlterDatabase' => 'Concedi il permesso ALTER DATABASE a tutti gli utenti del database Microsoft SQL Server.',
    'database-settings.grantAlterDatabaseHint' => 'Questo permesso verrà concesso sia agli utenti nuovi che a quelli esistenti.',
    'database-settings.aclRadio' => 'Impostazioni predefinite per l\'accesso remoto agli utenti del database MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Consenti unicamente le connessioni locali',
    'database-settings.aclAny' => 'Consenti connessioni remote da qualunque host',
    'database-settings.aclCustom' => 'Consenti connessioni remote da',
    'database-settings.aclDescription' => 'Questa impostazione modifica solo le autorizzazioni degli utenti. Per attivare l’accesso remoto al server MariaDB/MySQL locale, seleziona l’opzione corrispondente qui: %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Impostazioni MariaDB/MySQL locali',
    'database-settings.example' => "Per esempio:",
    'database-settings.aclExampleDescription' => "Gli host indicati possono accedere al database per conto di questo utente.",
    'database-settings.dbPrefixAlphaNumeric' => 'Il valore del prefisso può contenere solo valori alfanumerici e il trattino basso.',

    'dns.add-acl-record.description' => 'Aggiungi un indirizzo IP di un server DNS autorizzato a ricevere una copia della zona DNS.',
    'dns.add-acl-record.ipAddress' => 'Indirizzo IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Indirizzo/maschera IP',

    'dns.settings.recursion' => 'Query DNS ricorsive',
    'dns.settings.recursionOn' => 'Consenti per tutte le richieste',
    'dns.settings.recursionLocal' => 'Consenti solo per le richieste locali',
    'dns.settings.recursionLocalnets' => 'Permetti solo per richieste da reti locali',
    'dns.settings.recursionOff' => 'Nega per tutte le richieste',
    'dns.settings.customConfiguration' => 'Impostazioni DNS aggiuntive',
    'dns.settings.customConfigurationPlaceholder' => 'Le impostazioni definite qui sostituiranno quelle valide a livello di server.',
    'dns.settings.customConfigurationHint' => 'Se non riesci a trovare delle impostazioni specifiche, aggiungile al campo in alto utilizzando la sintassi named.conf.',
    'dns.settings.customConfigurationExample' => 'Ad esempio, per nascondere il nome host del server DNS, aggiungi la seguente stringa: ',
    'dns.settings.restoreDefaultButton' => 'Usa impostazioni predefinite',

    'dns.template.synchronize-done' => 'Il modello di zona DNS è stato correttamente applicato.',
    'dns.template.synchronize-error' => 'Il modello di zona DNS non è stato applicato ad alcune zone DNS.',
    'dns.template.synchronize-progress' => 'Applicazione del modello di zona DNS.',

    'domain-restriction.name' => 'Nome di dominio',
    'domain-restriction.nameDescription' => 'È possibile indicare un modello jolly mediante il segno dell\'asterisco (*). Ad esempio, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Il nome di dominio specificato è già nell\'elenco.',

    'event-handler.eventLabel' => 'Evento',
    'event-handler.priorityLabel' => 'Priorità',
    'event-handler.userLabel' => 'Utente',
    'event-handler.commandLabel' => 'Comando',
    'event-handler.commandHint' => 'Per migliori risultati, inserisci un percorso completo per un file di script nel campo \'comando\'. Sconsigliamo di inserire comandi di sistema, poiché potrebbero non funzionare. Per esempio, comandi con operatori di reindirizzamento dell\'output > o < non funzioneranno.',
    'event-handler.priorityHighestText' => 'Massima',
    'event-handler.priorityHighText' => 'Alta',
    'event-handler.priorityNormalText' => 'normale',
    'event-handler.priorityLowText' => 'basso',
    'event-handler.priorityLowestText' => 'Minima',
    'event-handler.priorityCustomText' => 'personalizzato',
    'event-handler.priorityHighestOption' => 'massimo (%%value%%)',
    'event-handler.priorityHighOption' => 'alto (%%value%%)',
    'event-handler.priorityNormalOption' => 'normale (%%value%%)',
    'event-handler.priorityLowOption' => 'basso (%%value%%)',
    'event-handler.priorityLowestOption' => 'minimo (%%value%%)',

    'extension.upload.fileUpload' => 'Percorso al file del pacchetto dell\'estensione',

    'external-webmail.hint' => 'Una volta avrai registrato un webmail aggiuntivo in Plesk, diventerà disponibile ai clienti:comparirà come un\'opzione nelle proprietà di \'Posta\' negli abbonamenti e piani di hosting.Il nome webmail verrà visualizzato nella lista di opzioni di webmail e l\'URL si aprirà dopo aver fatto clic sull\'icona del webmail vicino alla casella postale nel Pannello del Cliente.',
    'external-webmail.name' => 'Nome del servizio webmail',
    'external-webmail.url' => 'URL del servizio webmail',
    'external-webmail.enabled' => 'Disponibile',

    'ftp-settings.generalSection' => 'Generale',
    'ftp-settings.portRange' => 'Porta o intervallo di porte per le connessioni della modalità ftp passiva',
    'ftp-settings.hintPortRange' => '(valore predefinito: %%defaultPortRange%%)',

    'health.upload.hint' => 'Carica la tua configurazione per il monitoraggio dello stato del server. La configurazione sarà applicata non appena sarà caricata.',
    'health.upload.selectFile' => 'File di configurazione',

    'install-local-package.selectUploadType' => 'Scegli uno dei seguenti:',
    'install-local-package.uploadAsFile' => 'Carica un pacchetto APS',
    'install-local-package.downloadFromCatalog' => 'Seleziona un\'applicazione dal Catalogo di Applicazioni',
    'install-local-package.formInfo' => "Amplia la lista di applicazioni disponibili caricando una nuova applicazione oppure aggiungi un'applicazione dal Catalogo di Applicazione per l'ulteriore configurazione.",
    'install-local-package.invalidFileExtension' => 'L\'applicazione caricata deve essere un archivio ZIP con l\'estensione .zip.',
    'install-local-package.packagesNotSelected' => 'Nessuno dei pacchetti è selezionato.',
    'install-local-package.fileNotUploaded' => 'Impossibile caricare il file.',
    'install-local-package.visible' => 'Rendi disponibile ai clienti',
    'install-local-package.isCommercial' => 'Questa app è commerciale e richiede l\'acquisto di una chiave di licenza.',
    'install-local-package.visibleDescription' => 'Rendi l\'applicazione disponibile all\'installazione dai clienti.',

    'ip-address.addTitle' => 'Aggiungi indirizzo IP',
    'ip-address.editTitle' => 'Indirizzo IP %%address%% sull\'interfaccia %%interface%%',
    'ip-address.generalSection' => 'Generale',
    'ip-address.interface' => 'Interfaccia',
    'ip-address.addressAndSubnetPrefixLength' => 'Maschera di sottorete e indirizzo IP',
    'ip-address.addressHintIPv4' => 'Per esempio, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Per esempio, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Indirizzo IP pubblico',
    'ip-address.hintPublicIp' => 'Puoi utilizzare un indirizzo IP pubblico se il tuo server Plesk è protetto da NAT',
    'ip-address.distributionType' => 'L\'indirizzo IP viene distribuito come',
    'ip-address.distributionTypeShared' => 'Condiviso',
    'ip-address.distributionTypeExclusive' => 'dedicato',
    'ip-address.certificate' => 'Certificato SSL/TLS',
    'ip-address.defaultSite' => 'Sito predefinito',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Il server FTP installato non supporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Il server FTP installato non supporta indirizzi IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Impossibile aggiungere l’indirizzo IP. Questa interfaccia di rete ottiene gli indirizzi IP automaticamente.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Nota: l\'URL personalizzato di Plesk è abilitato per tutti i domini sconosciuti; l\'interfaccia di Plesk sarà visualizzata al posto del sito predefinito su "https://%%ip%%/"',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'L\'adattatore di rete %%interface%% non esiste. Sposta questo indirizzo IP verso un altro adattatore di rete o rimuovilo dalla lista.',
    'ip-address.none' => 'Nessuno',

    'ip-ban.filter.name' => 'Nome',
    'ip-ban.filter.content' => 'Contenuto',
    'ip-ban.filter.filterExistsError' => 'Esiste già un filtro con questo nome.',

    'ip-ban.jail.name' => 'Nome',
    'ip-ban.jail.filter' => 'Filtro',
    'ip-ban.jail.filterDescription' => 'Seleziona il filtro.',
    'ip-ban.jail.action' => 'Azione',
    'ip-ban.jail.actionDescription' => 'Seleziona un\'azione e fai clic sul pulsante per aggiungerla.',
    'ip-ban.jail.logPath' => 'Percorso di accesso',
    'ip-ban.jail.banTime' => 'Periodo di proibizione di indirizzi IP',
    'ip-ban.jail.maxRetry' => 'I tentativi di accesso massimi non riusciti',
    'ip-ban.jail.timeUnit' => 'secondi',
    'ip-ban.jail.addAction' => 'Aggiungere',
    'ip-ban.jail.chooseAction' => 'Seleziona:',
    'ip-ban.jail.apache-auth-filter-description' => 'Errori di autorizzazione Apache (durante la registrazione nel file)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Errori di autorizzazione Apache (durante qualsiasi registrazione)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Errori di autorizzazione Apache (durante la registrazione nel registro di sistema)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bot e crawler web errati',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Errori di autenticazione POP 3 e Courier IMAP',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Errori di autenticazione IMAP, POP3 e Sieve di Dovecot',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Errori di autenticazione Dovecot IMAP, POP3 e Sieve (modalità aggressiva)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Errori di autenticazione del webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Violazioni della sicurezza e del controllo degli accessi di Web Application Firewall (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Errori di autenticazione per Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Errori di autenticazione SMTP di QMail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Errori di autenticazione del webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Errori di autenticazione di WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Filtro fittizio per l\'esclusione manuale',
    'ip-ban.jail.postfix-filter-description' => 'Errori client SMTP Postfix (inclusa RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Errori client e di autenticazione SMTP Postfix e attacchi DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Errori di autenticazione SMTP e SASL di Postfix',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Attacchi DDoS SMTP Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Errori client e di autenticazione SMTP Postfix',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Errori client SMTP Postfix (inclusa RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Errori client SMTP Postfix (solo RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Errori di accesso ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Host proibiti ripetutamente da Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Errori di accesso SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Errori di accesso e negoziazione SSH e attacchi DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Errori di accesso SSH e attacchi DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Errori di accesso e negoziazione SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Proibisci firewall via firewalld, su tutte le porte',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Proibisci firewall via firewalld, su multipli porte',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Proibisci firewall via firewalld, su una singola porta',
    'ip-ban.jail.iptables-action-description' => 'Proibisci firewall via iptables, su una singola porta',
    'ip-ban.jail.iptables-allports-action-description' => 'Proibisci firewall via iptables, su tutte le porte',
    'ip-ban.jail.iptables-multiport-action-description' => 'Proibisci firewall via iptables, su multipli porte',
    'ip-ban.jail.sendmail-action-description' => 'Invia una notifica e-mail via Sendmail',
    'ip-ban.jail.jailExistsError' => 'Esiste già un jail con questo nome.',
    'ip-ban.jail.invalidInteger' => 'Il valore specificato non è valido. Specifica un numero intero.',

    'ip-ban.settings.pageHint' => 'Qui è possibile configurare l\'esclusione di un indirizzo IP per proteggere il proprio server e siti web ospitati contro il traffico maligno.',
    'ip-ban.settings.detectionEnabled' => 'Abilita rilevamento intrusione',
    'ip-ban.settings.banPeriod' => 'Periodo di proibizione di indirizzi IP',
    'ip-ban.settings.banTimeWindow' => 'Intervallo di tempo per il rilevamento di attacchi successivi',
    'ip-ban.settings.maxRetries' => 'Numero di errori prima che l\'indirizzo IP sia escluso',
    'ip-ban.settings.timeUnit' => 'secondi',
    'ip-ban.settings.invalidInteger' => 'È stato fornito un valore non valido. Fornisci un numero intero positivo.',

    'ip-ban.trusted-ip.ipAddress' => 'Indirizzo IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Un indirizzo IP, una maschera CIDR o un nome host DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Descrizione',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Spiegazione del motivo per cui l\'indirizzo IP è stato aggiunto alla lista di fiducia.',

    'login-info.hint' => 'In questa sezione è possibile modificare il nome utente e la password che usa il cliente per accedere al proprio Pannello del Cliente.',
    'login-info.resellerHint' => 'In questa sezione è possibile modificare il nome utente e/o la password che usa il rivenditore per accedere a Plesk.',
    'login-info.myProfileHint' => 'In questa sezione è possibile modificare la password usata per accedere a Plesk.',

    'firewall-rule.titleEdit' => 'Modifica di una regola del firewall.',
    'firewall-rule.titleNew' => 'Aggiungi una regola',
    'firewall-rule.isEnabled' => 'Attiva la regola',
    'firewall-rule.name' => 'Nome regola',
    'firewall-rule.profiles' => 'Profili',
    'firewall-rule.profilesHint' => 'Devi selezionare almeno un profilo.',
    'firewall-rule.profileDomain' => 'Dominio',
    'firewall-rule.profilePrivate' => 'Privato',
    'firewall-rule.profilePublic' => 'Pubblico',
    'firewall-rule.action' => 'Azione',
    'firewall-rule.actionAllow' => 'Consenti',
    'firewall-rule.actionBlock' => 'Nega',
    'firewall-rule.port' => 'Consentire le connessioni alla seguente porta od intervallo di porte',
    'firewall-rule.portHint' => 'Ad esempio: 1000 o 1000-1051',
    'firewall-rule.protocolTcp' => 'Protocollo TCP',
    'firewall-rule.protocolUdp' => 'Protocollo UDP',
    'firewall-rule.remoteAddresses' => 'Indirizzi remoti',
    'firewall-rule.remoteAddressesHint' => 'Ad esempio: 192.168.0.1 o 192.168.0.0/16',
    'firewall-rule.newRule' => 'Nuova regola',
    'firewall-rule.successNew' => 'La regola firewall è stata aggiunta.',
    'firewall-rule.successEdit' => 'La regola firewall è stata aggiornata.',

    'mail.lists-server-settings.email' => "E-mail dell'amministratore della mailing list",
    'mail.lists-server-settings.emptyEmail' => 'Inserisci indirizzo e-mail.',
    'mail.lists-server-settings.newPassword' => 'Nuova password',
    'mail.lists-server-settings.emptyPassword' => 'Fornisci una password.',
    'mail.lists-server-settings.passwordConfirmation' => 'Conferma la password',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Il software della mailing list è stato configurato.',

    'mail.outgoing-messages.hint' => 'In questa sezione è possibile specificare un limite sui messaggi in uscita da una casella postale.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Il numero massimo di messaggi email in uscita',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Predefinito (%%domainOutgoingMessages%% messaggi l\'ora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valore predefinito per questa casella postale',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'messaggi per ora',

    'mail-gate-settings.host' => 'Nome host o indirizzo IP',
    'mail-gate-settings.port' => 'Porta',
    'mail-gate-settings.login' => 'Nome utente',
    'mail-gate-settings.password' => 'Password',
    'mail-gate-settings.encryption' => 'Il server SMTP richiede connessione crittografata',
    'mail-gate-settings.allowUsers' => 'Consenti agli script utente di inviare posta tramite questo server SMTP (usando il nome utente e la password specificati)',
    'mail-gate-settings.useDefaultSettings' => 'Usa il server di posta installato con Plesk e l\'account di posta predefinito creato da Plesk',

    'mail-gate.hint' => 'In questa sezione è possibile specificare il server SMTP da usare quando il server di posta Plesk non è installato o non è autorizzato all\'invio di posta in uscita. Questo server verrà usato come relay SMTP da Plesk e dagli script degli utenti per inviare posta in uscita, come le notifiche email.',
    'mail-gate.enableMailGate' => 'Consenti a Plesk di inviare notifiche email tramite questo server SMTP',
    'mail-gate.notifications' => 'Notifiche di posta dal server SMTP esterno',
    'mail-gate.smtpSettings' => 'Impostazioni del server SMTP esterno',

    'optimization-settings.apacheModulesSection' => 'Moduli Apache',
    'optimization-settings.nginxSettingsSection' => 'Impostazioni nginx',
    'optimization-settings.nginxHttp3Enabled' => 'Supporto HTTP/3',
    'optimization-settings.nginxHttp3EnabledHint' => 'Abilitare il supporto a HTTP/3 a livello globale in tutti i siti web presenti sul server migliora le prestazioni di questi ultimi sulle reti moderne. Tuttavia, se necessario, puoi disabilitare il supporto a HTTP/3 nelle impostazioni e optare per un abbonamento singolo. Il tempo di abilitazione o disabilitazione del supporto a HTTP/3 dipende dal numero di domini interessati, e potrebbe richiedere diversi minuti.',
    'optimization-settings.apacheSettingsSection' => 'Impostazioni Apache',
    'optimization-settings.additionalPageHint' => 'Attivare i moduli unicamente se si è consapevoli delle conseguenze delle proprie azioni. Alcune modifiche possono far diminuire le prestazioni di Apache o persino causare la relativa mancanza di operabilità.',
    'optimization-settings.pageHint' => 'In questa sezione è possibile ottimizzare Plesk disattivando i moduli Apache inutilizzati. Questa ottimizzazione migliora l\'utilizzo della memoria e consente di servire più clienti di hosting. Alcuni moduli sono interdipendenti e possono essere disattivati (attivati) soltanto quando i moduli da cui dipendono sono disattivati (attivati).',
    'optimization-settings.advancedUsersOnlyWarning' => 'La funzionalità è destinata unicamente a utenti esperti.',
    'optimization-settings.apacheRestartInterval' => 'Intervallo di riavvio di Apache (secondi)',
    'optimization-settings.apacheRestartIntervalHint' => 'Una volta nell\'intervallo specificato, Plesk verifica l\'esistenza di modifiche apportate ai domini e sottodomini. In caso che ci siano modifiche che richiedono il riavvio del server web, Plesk riavvierà Apache.',
    'optimization-settings.gracefulRestart' => 'Riavvio graceful di Apache',
    'optimization-settings.gracefulRestartHint' => 'Seleziona per evitare l’arresto di tutti i siti Web ospitati sul server, ogni volta che modifichi le impostazioni di hosting.',
    'optimization-settings.pipedLog' => 'Log reindirizzati',
    'optimization-settings.mpmMode' => 'Modo MPM',
    'optimization-settings.moduleDeprecated' => '(Deprecato)',

    'personal-info.contactInfoSection' => 'Informazioni di contatto',
    'personal-info.hint' => 'In questa sezione è possibile modificare l\'informazione di contatto dell\'utente.',
    'personal-info.hintMyProfile' => 'In questa sezione è possibile modificare la tua informazione di contatto.',

    'php-handler.extension.title' => 'Installare pacchetto PECL',
    'php-handler.extension.description' => "È possibile installare una versione beta di un'estensione specificando parametri aggiuntivi con il nome del pacchetto, ad esempio \"msgpack-beta\".",
    'php-handler.extension.name' => 'Nome pacchetto',

    'php-handler.ini.formHint' => 'Questo file php.ini viene unicamente usato da questo gestore.',
    'php-handler.ini.formHintSharedIni' => 'Questo file php.ini è anche usato dai seguenti gestori PHP: %%handlers%%. Le impostazioni vengono applicate a tutti i siti web che usano questi gestori.',
    'php-handler.ini.incorrectTextForIniFile' => "Le impostazioni specificate non sono corrette e non possono essere salvate nel file php.ini. Errore: %%message%%.",

    'plan-item-custom.planItemName' => 'Nome del servizio',
    'plan-item-custom.buttonLabel' => 'Questo nome verrà anche usato come etichetta per il pulsante personalizzato.',
    'plan-item-custom.planItemDescription' => 'Descrizione del servizio',
    'plan-item-custom.buttonTooltip' => 'Questo testo verrà anche usato come guida per il pulsante personalizzato.',
    'plan-item-custom.url' => 'URL associato al pulsante personalizzato',
    'plan-item-custom.backgroundImage' => 'Immagine di sfondo per il pulsante personalizzato',
    'plan-item-custom.emptyItemName' => 'Fornire un\'etichetta per il servizio.',
    'plan-item-custom.emptyItemDescription' => 'Fornire il testo come guida del servizio.',
    'plan-item-custom.emptyUrl' => 'Indicare un URL.',
    'plan-item-custom.longItemName' => 'L\'etichetta per questo servizio è troppo lungo. La lunghezza massima consentita è: %max% simboli.',
    'plan-item-custom.longItemDescription' => 'Il testo per questo servizio è troppo lungo. La lunghezza massima consentita è: %max% simboli.',
    'plan-item-custom.longUrl' => 'Questo URL è troppo lungo. La lunghezza massima consentita è: %max% simboli.',
    'plan-item-custom.useCustomButton' => 'Usa un pulsante personalizzato per il servizio',
    'plan-item-custom.useCustomButtonHint' => 'Situare un pulsante personalizzato nella Home page dell\'utente e le pagine del sito web.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Apri URL in Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Indicare se si deve aprire l\'URL in una pagina di Plesk o in una nuova finestra del browser.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Non utilizzare frame',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Se aggiungi un pulsante personalizzato che porta ad un\'estensione di Plesk o ad un\'app nel Pannello del Cliente, puoi specificare il modo in cui visualizzare tale estensione/app:in un frame o come parte della GUI di Plesk.',
    'plan-item-custom.includeDomId' => 'Comprende l\'ID dell\'abbonamento',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Comprendere un nome di dominio principale',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Comprendere un nome utente FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Comprendere una password FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Comprende l\'ID del cliente',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Comprende il nome della società del cliente",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Comprende il nome di contatto del cliente",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Includi e-mail del cliente",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',
    'plan-item-custom.fileNotUploaded' => 'Impossibile caricare il file.',

    'preview-domain-settings.previewType' => 'Scegli il modo in cui visualizzare i siti web',
    'preview-domain-settings.previewQuick' => 'Anteprima veloce predefinita',
    'preview-domain-settings.previewDisabled' => 'Disabilita Anteprima Veloce',
    'preview-domain-settings.previewQuickDescription' => 'Un\'opzione raccomandata, pronta all\'uso.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Anteprima veloce su un nome di dominio in Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Seleziona uno dei tuoi siti web serviti da Plesk perché sia usato dall\'anteprima.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Per usare questa funzionalità, %%link%% almeno un dominio.',
    'preview-domain-settings.subscriptionCreateLink' => 'creare',
    'preview-domain-settings.previewZoneTypeExternal' => 'Anteprima veloce su un nome di dominio esterno',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Usa un nome di dominio esterno (zona DNS). Se utilizzi questa opzione, aggiungi il seguente registro DNS (del tipo A) alla zona del dominio esterno: *.<Plesk_IP>.external.dom. Qui <Plesk_IP> è l\'IP del server Plesk dove i punti (.) per IPv4 o i due punti (:) per IPv6 vengono sostituiti con trattini (-). Per esempio, *.192-0-2-12.external.dom. Se Plesk ha più di un indirizzo IP registrato, aggiungi un registro per ogni indirizzo.',
    'preview-domain-settings.sitePreviewProtection' => 'Richiedi autenticazione',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Richiedi login e password FTP per accedere all\'anteprima.',
    'preview-domain-settings.nginxNotInstalled' => 'L\'Anteprima veloce predefinita non è disponibile perché il server web nginx non è installato.',
    'preview-domain-settings.nginxDisabled' => 'L\'Anteprima veloce predefinita non è disponibile perché il server web nginx è disabilitato.',

    'reseller-preferences.settingsSection' => 'Impostazioni',
    'reseller-preferences.multiLogin' => 'Permetti sessioni multiple',
    'reseller-preferences.language' => 'Lingua interfaccia',
    'reseller-preferences.interfaceView' => 'Seleziona la tua interfaccia',
    'reseller-preferences.serviceProviderView' => 'Visualizzazione Service Provider',
    'reseller-preferences.serviceProviderViewHint' => 'Questa modalità di visualizzazione è destinata agli amministratori del server che forniscono e vendono servizi di hosting web ai clienti tramite piani di servizio.',
    'reseller-preferences.powerUserView' => 'Visualizzazione Power User',
    'reseller-preferences.powerUserViewHint' => 'Questa modalità di visualizzazione è la più adatta per gestire siti web, file interni, database, account email, applicazioni web e altri servizi.',

    'reseller.hint' => 'In questa sezione è possibile registrare un nuovo rivenditore ai tuoi servizi di hosting.',
    'reseller.contactInfoSection' => 'Informazione di contatto',
    'reseller.contactInfoSectionHint' => 'Inserire le informazioni di contatto del rivenditore.',
    'reseller.accessToPanelSection' => 'Accesso a Plesk',
    'reseller.accessToPanelSectionHint' => 'Le credenziali che il rivenditore userà per accedere a Plesk e gestire i servizi ai quali è iscritto.',
    'reseller.subscription' => 'Abbonamento',
    'reseller.subscriptionSectionHint' => 'Scegli un piano di servizio al quale verrà iscritto il rivenditore.',
    'reseller.servicePlan' => 'Piano di servizio',
    'reseller.none' => 'Nessuno',
    'reseller.customizeSubscription' => 'Procedi alla personalizzazione dei parametri dell\'abbonamento dopo la creazione del rivenditore. Tieni presente che questa azione bloccherà la capacità di sincronizzazione dell\'abbonamento.',
    'reseller.subscriptionNotSynchronized' => 'Impossibile sincronizzare l\'iscrizione con il piano di servizio. Le seguenti impostazioni dell’abbonamento sono in conflitto con il piano di servizio: %%problems%%.',

    'security-policy.encryptionSection' => 'Modalità di sicurezza ottimizzata',
    'security-policy.encryptionSectionHint' => 'La modalità di sicurezza ottimizzata presenta la protezione avanzata di dati sensibili in Plesk. In tale modalità, Plesk impiega multipli meccanismi di sicurezza che non incidono assolutamente sulle operazioni degli utenti di Plesk. Per migliorare la sicurezza di Plesk, si consiglia di attivare tale modalità.',
    'security-policy.encryptionEnable' => 'Modalità di sicurezza ottimizzata',
    'security-policy.securePassword' => 'Modalità di sicurezza ottimizzata',
    'security-policy.strengthSection' => 'Sicurezza della password',
    'security-policy.strengthSectionHint' => 'La maggioranza delle password che gli utenti possono impostare o cambiare in Plesk sono verificate per assicurare che soddisfino i requisiti minimi di robustezza della password impostati qui. Le password robuste contengono almeno 9-12 caratteri e includono cifre, lettere maiuscole e minuscole, caratteri speciali e nessuna parola del dizionario. Sono più difficili da indovinare, ma anche da ricordare. <a href="%%link%%" target="_blank">Maggiori informazioni sulla forza delle password</a>.',
    'security-policy.passwordStrength' => 'Sicurezza password minima',
    'security-policy.secureFtpSection' => 'FTP protetta',
    'security-policy.ftpOverSsl' => 'Norme sull\'utilizzo FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS è usato per proteggere la comunicazione tra il server FTP e i clienti FTP esterni usando il protocollo SSL/TLS. Qui è possibile selezionare i tipi di connessioni che devono essere consentite.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS è usato per proteggere la comunicazione tra il server FTP e i clienti FTP esterni usando il protocollo SSL/TLS. Qui è possibile selezionare i tipi di connessioni che devono essere consentite. L\'opzione selezionata verrà applicata a tutti gli indirizzi IP sul server. Per usare impostazioni personalizzate per indirizzo IP, seleziona l\'opzione corrispondente e poi cambia le norme FTPS su Strumenti e Impostazioni> Indirizzi IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS è usato per proteggere la comunicazione tra il server FTP e i clienti FTP esterni usando il protocollo SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS è usato per proteggere la comunicazione tra il server FTP e i clienti FTP esterni usando il protocollo SSL/TLS. Se desideri regolare le impostazioni FTPS per indirizzo IP, seleziona prima l\'opzione "Usa impostazioni FTPS per indirizzo IP" in Strumenti e Impostazioni> Norme di sicurezza> FTP sicuro.',
    'security-policy.ftpOverSslOptionRequired' => 'Consenti solo connessioni FTPS protette',
    'security-policy.ftpOverSslOptionEnabled' => 'Consenti sia connessioni FTPS protette sia connessioni FTP non protette',
    'security-policy.ftpOverSslOptionDisabled' => 'Consenti solo connessioni FTP non protette. Non usare FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Usa normativa FTPS personalizzata per indirizzo IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Politica personalizzata gestori',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Abilita questa opzione per impedire ai clienti di ignorare i gestori IIS definiti a livello del server, tramite il file web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Proibisci la capacità di sovrascrivere i gestori tramite web.config',
    'security-policy.emailPasswordsSection' => 'Conservazione password delle e-mail',
    'security-policy.emailPasswordsSectionHint' => 'Le password degli account di posta possono essere protette tramite una crittografia simmetrica oppure una funzione di hash. Una volta modificata l\'impostazione, la nuova regola viene applicata a tutti i nuovi account creati da quel momento in poi; per gli account già esistenti, la regola viene applicata a partire dal successivo cambio di password.',
    'security-policy.emailPasswordHashingLabel' => 'Metodo di conservazione',
    'security-policy.emailPasswordSymmetric' => 'Crittografia simmetrica',
    'security-policy.emailPasswordHashing' => 'Hash',
    'security-policy.emailPasswordSymmetricHint' => 'Maggior comodità. Le password possono essere decrittografate.',
    'security-policy.emailPasswordHashingHint' => 'Maggior sicurezza. Le password non possono essere decrittografate.',

    'server-mail-antivirus.used' => 'Antivirus usato',
    'server-mail-antivirus.policy' => 'Usare le impostazioni globali del server',
    'server-mail-antivirus.policyOff' => 'Scansione disabilitata',
    'server-mail-antivirus.policyAny' => 'Fai la scansione della posta in ingresso e in uscita',
    'server-mail-antivirus.policyFrom' => 'Fai la scansione solo della posta in uscita',
    'server-mail-antivirus.policyTo' => 'Fai la scansione solo della posta in entrata',
    'server-mail-antivirus.allowPersonalSettings' => 'Consenti impostazioni personali',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Consenti di sovrascrivere le impostazioni dell\'intero server in tutti gli indirizzi email',
    'server-mail-antivirus.incoming' => 'per la posta in entrata',
    'server-mail-antivirus.outgoing' => 'per la posta in uscita',
    'server-mail-antivirus.success' => 'Le impostazioni dell\'antivirus sono state modificate.',

    'server-mail-black-list.title' => 'Aggiungi dominio alla lista nera',
    'server-mail-black-list.domainName' => 'Nome del dominio',
    'server-mail-black-list.emailAddress' => 'Indirizzi e-mail',
    'server-mail-black-list.emailAddressHint' => 'Non ci possono essere caratteri non-ASCII a sinistra del simbolo @. Gli indirizzi possono contenere i caratteri "*" e "?" (per esempio, *@domain.com, user?@*.com). Le parti non-ASCII del nome di dominio non possono contenere caratteri jolly.',
    'server-mail-black-list.action' => 'Cosa fare con la posta che soddisfa questo criterio:',
    'server-mail-black-list.actionDelete' => 'Cancella dal server',
    'server-mail-black-list.actionSpam' => 'Segna come spam',
    'server-mail-black-list.success' => 'Dominio aggiunto alla lista nera.',

    'server-mail-white-list.title' => 'Aggiungi rete alla lista bianca',
    'server-mail-white-list.descEmailAddress' => 'Gli indirizzi email indicati non saranno riconosciuti come spam da SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'Gli elementi IP indicati verranno aggiunti alle eccezioni del server di posta.',
    'server-mail-white-list.ipAddress' => 'Indirizzo/maschera IP',
    'server-mail-white-list.ipAddressHint' => 'L\'indirizzo IP può contenere caratteri jolly o maschere CIDR.',
    'server-mail-white-list.emailAddress' => 'Indirizzi e-mail',
    'server-mail-white-list.emailAddressHint' => 'Non ci possono essere caratteri non-ASCII a sinistra del simbolo @. Gli indirizzi possono contenere i caratteri "*" e "?" (per esempio, *@domain.com, user?@*.com). Le parti non-ASCII del nome di dominio non possono contenere caratteri jolly.',
    'server-mail-white-list.emailAddressOrIp' => 'Indirizzi email o IP',
    'server-mail-white-list.wildcardPattern' => 'Gli indirizzi IP possono contenere caratteri jolly (ad esempio, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Gli indirizzi IP possono contenere maschere CIDR (ad esempio, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Rete aggiunta alla lista bianca.',

    'server-mail-settings.general.title' => 'Opzioni generali',
    'server-mail-settings.general.mailUiEnabled' => 'Abilita le funzioni di gestione della posta di Plesk',
    'server-mail-settings.general.mailUiEnabledHint' => 'Deselezionare la casella di controllo rimuove l\'abilità di creare caselle postali e di modificare le impostazioni di posta per i domini tramite la GUI di Plesk. I servizi di posta e di webmail resteranno operativi e disponibili.',
    'server-mail-settings.general.serverName' => 'Server di posta installato',
    'server-mail-settings.general.changeServerName' => 'installare e utilizzare un altro server di posta',
    'server-mail-settings.general.imapServerName' => 'Server IMAP/POP3 installato',
    'server-mail-settings.general.changeImapServerName' => 'installare e usare un altro server IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Puoi %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Dimensione massima del messaggio',
    'server-mail-settings.general.kbytes' => 'KByte',
    'server-mail-settings.general.maxConnections' => 'Il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Il numero massimo di server (IMAP o POP3) avviati.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Il numero massimo di utenti di posta che possono essere connessi contemporaneamente.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Numero massimo di connessioni per indirizzo IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Numero massimo di connessioni per un utente per indirizzo IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS) da accettare dallo stesso indirizzo IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS) consentite per un utente di posta da ogni indirizzo IP.',
    'server-mail-settings.general.messageSubmission' => 'Abilita servizio SMTP sulla porta 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Abilita il servizio SMTP sulla porta 587 su tutti gli indirizzi IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Attivato',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'tutti gli indirizzi IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Modalità posta in uscita',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Invio da indirizzi IP del dominio',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Invia dagli indirizzi IP del dominio e utilizza nomi di dominio nel saluto SMTP.',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Invio da determinati indirizzi IP',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Nessuno',
    'server-mail-settings.general.subaddressing' => 'Abilita il subaddressing dell\'e-mail',
    'server-mail-settings.general.subaddressingHint' => 'Questa opzione consente di configurare gli indirizzi e-mail %%verpStyleLink%% per le mailing list',
    'server-mail-settings.general.verpStyleLink' => 'Stile VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Abilita l\'avviso sulla quota della casella postale',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Invia una notifica agli utenti di posta elettronica quando la loro quota di utilizzo della casella di posta supera il 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Personalizza l\'avviso sulla quota della casella postale predefinito',
    'server-mail-settings.general.fixSender' => 'Correggi il mittente impostato in modo errato per la posta in uscita',
    'server-mail-settings.general.fixSenderHint' => 'Imposta automaticamente intestazioni e-mail valide e indirizzo del mittente per la posta in uscita dai domini per ridurre le possibilità di essere trattata come spam',
    'server-mail-settings.general.maxMessageSizeHint' => 'Per le email con allegato, il valore dovrebbe essere superiore del 35-40% rispetto alla dimensione dell\'allegato. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Per maggiori informazioni, consulta l\'articolo sui KB',

    'server-mail-settings.autodiscover.title' => 'Rilevamento automatico della posta',
    'server-mail-settings.autodiscover.description' => 'Scopri come funziona, visita: %%link%%',
    'server-mail-settings.autodiscover.link' => 'base di conoscenza',
    'server-mail-settings.autodiscover.enabled' => 'Abilita rilevamento automatico della posta',
    'server-mail-settings.autodiscover.enabledHint' => 'Abilitando questa funzione si riconfigurano tutti i domini che hanno il rilevamento automatico attivato',
    'server-mail-settings.autodiscover.customServer' => 'Nome di dominio personalizzato',
    'server-mail-settings.autodiscover.customServerHint' => 'Indica il nome di un dominio personalizzato da usare come server per la posta in arrivo e in uscita per la configurazione del rilevamento automatico della posta.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'Nota: il nome del dominio deve essere protetto con un certificato SSL/TLS valido.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Riconfigurazione registri DNS di rilevamento automatico',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Abilitando questa funzione si riconfigurano tutti i registri DNS di rilevamento automatico di domini che hanno il rilevamento automatico attivato',

    'server-mail-settings.relay.title' => 'Opzioni di relay',
    'server-mail-settings.relay.type' => "Ritrasmissione",
    'server-mail-settings.relay.open' => "aperto",
    'server-mail-settings.relay.openSpamWarning' => "Aprire la ritrasmissione della posta espone il server di posta allo spam.",
    'server-mail-settings.relay.openSpamChange' => "Mantieni l’impostazione solo se desideri testare temporaneamente il server di posta o se il server Plesk è in una rete interna, non accessibile via Internet.",
    'server-mail-settings.relay.closed' => "chiuso",
    'server-mail-settings.relay.auth' => "e' richiesta l'autorizzazione:",
    'server-mail-settings.relay.notSupported' => "non supportato dal server di mail",
    'server-mail-settings.relay.change' => 'Per consentire che Plesk invii notifiche quando il relay è chiuso, è possibile %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'cambiare le impostazioni SMTP',
    'server-mail-settings.relay.pop3' => "POP3 prima di SMTP",
    'server-mail-settings.relay.lockTime' => "tempo di blocco",
    'server-mail-settings.relay.min' => "min.",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Non utilizzare restrizioni di relay per le reti seguenti:',
    'server-mail-settings.relay.noRelayNetworksHint' => "Indirizzo/maschera IP",

    'server-mail-settings.outgoing.title' => 'Limitazioni sui messaggi email in uscita',
    'server-mail-settings.outgoing.description' => 'I seguenti limiti sono predefiniti. Possono essere ignorati in ogni piano di servizio e abbonamento. I limiti non funzionano in tutto il server, ma agiscono come modello per i piani e gli abbonamenti per cui non è stato specificato alcun limite personalizzato. Tieni presente che l\'attivazione del limite sui messaggi email in uscita può incidere sulle prestazioni del server di posta. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Scopri di più sulle limitazioni della posta in uscita',
    'server-mail-settings.outgoing.enabled' => 'Attiva le limitazioni sui messaggi email in uscita',
    'server-mail-settings.outgoing.countRecipients' => 'Conta il numero di destinatari invece dei messaggi',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Abilita la modalità che conta il numero dei destinatari invece che dei messaggi quando vengono applicate limitazioni alla posta in uscita e vengono calcolate le statistiche. Per esempio, un messaggio inviato a 10 destinatari verrà contato come 10 messaggi.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Limite predefinito sui messaggi in uscita da una casella postale (l\'ora)',
    'server-mail-settings.outgoing.domainLimit' => 'Limite predefinito sui messaggi in uscita da un dominio (l\'ora)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Limite predefinito sui messaggi in uscita da un abbonamento (l\'ora)',
    'server-mail-settings.outgoing.unlimited' => 'Illimitato',
    'server-mail-settings.outgoing.sendmail' => 'Consenti agli utenti e agli script di usare Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Gli script e gli utenti saranno in grado di inviare messaggi email (da parte dell\'utente di sistema dell\'abbonamento) mediante Sendmail anche se i limiti di una casella postale e un dominio sono superati. Il massimo di messaggi che possono essere inviati tramite Sendmail verrà definito dal limite per un intero abbonamento. Questa impostazione non consente agli script di usare Sendmail in tutto il server, ma agisce come impostazione predefinita per i piani di servizio e gli abbonamenti.',
    'server-mail-settings.outgoing.reportPeriod' => 'Mostra report basati sulle statistiche durante l\'ultimo spazio temporale seguente',
    'server-mail-settings.outgoing.reportPeriodHint' => 'I report sono creati e l\'avviso viene mostrato sulla Home page sui tentativi di superare i limiti sulla posta in uscita durante il periodo specificato.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Invia una notifica email ogni',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Le notifiche forniscono le statistiche sui tentativi di oltrepassare i limiti sulla posta in uscita durante il periodo specificato.',
    'server-mail-settings.outgoing.periodP1D' => '1 giorno',
    'server-mail-settings.outgoing.periodP1W' => '1 settimana',
    'server-mail-settings.outgoing.periodP2W' => '2 settimane',
    'server-mail-settings.outgoing.periodP1M' => '1 mese',
    'server-mail-settings.outgoing.periodPT15M' => '15 minuti',
    'server-mail-settings.outgoing.periodPT1H' => '1 ora',
    'server-mail-settings.outgoing.periodPT6H' => '6 ore',
    'server-mail-settings.outgoing.periodPT12H' => '12 ore',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'I limiti di posta in uscita non avranno effetto per i mittenti di posta con indirizzi IP appartenenti alla lista bianca del server di posta. Ad esempio, se il localhost (127.0.0.0 / 8, ::1 / 128) è nella lista bianca, tutta la posta dal server locale sarà correttamente inviata indipendentemente dalle limitazioni. I mittenti di posta possono usare sia indirizzi IP locali (siti web e script personalizzati ospitati sul server locale) o quelli esterni (clienti che inviano messaggi da client di posta installati sui loro computer o dispositivi mobili). Affinché i limiti funzionino per tutti i mittenti di posta (sia locali sia esterni), rimuovere tutti gli indirizzi IP e network dalla lista bianca. Tieni presente che rimuovere il localhost (127.0.0.0 / 8, ::1 / 128) dalla lista bianca potrebbe interrompere il funzionamento dei siti web e script che inviano posta da questo server. Per maggiori informazioni sulle limitazioni della posta in uscita, consultare il Manuale di amministrazione, sezione Protezione da Outbound Spam.',
    'server-mail-settings.outgoing.relayIsOpen' => 'L\'inoltro della posta è aperto: I limiti della posta in uscita non funzioneranno.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Il limite dei messaggi in uscita per un dominio (%%value%%) non può essere maggiore del limite per un abbonamento (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Il limite dei messaggi in uscita per un indirizzo email (%%value%%) non può essere maggiore del limite per un dominio (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Il limite dei messaggi in uscita per un indirizzo email (%%value%%) non può essere maggiore del limite per un abbonamento (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Impostazioni Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Utilizzare link sicuri nelle mailing list',
    'server-mail-settings.mailman.secureLinksHint' => 'Attiva o disattiva la generazione di link sicuri (HTTPS) nelle mailing list.',
    'server-mail-settings.mailman.noLocalhost' => 'Per usare le mailing list, è necessario avere localhost (127.0.0.0/8, ::1/128) nella lista bianca del server di posta elettronica. Tuttavia, per usare il controllo della posta in uscita, non devi avere un localhost nella lista bianca. Come soluzione di compromesso, se attiverai il controllo della posta, potrai usare l\'inoltro della posta sulla casella di posta invece delle liste di posta.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Per utilizzare le liste di posta, hai bisogno di un localhost nella lista bianca del server di posta. Tuttavia, per usare il controllo della posta in uscita, non devi avere un localhost nella lista bianca. Come soluzione di compromesso, se attiverai il controllo della posta, potrai usare l\'inoltro della posta sulla casella di posta invece delle liste di posta. Tieni presente che attualmente non vi sono indirizzi di localhost IPv4 (127.0.0.0/8) nella lista bianca, per cui il controllo della posta in uscita funzionerà per gli indirizzi IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Per utilizzare le liste di posta, hai bisogno di un localhost nella lista bianca del server di posta. Tuttavia, per usare il controllo della posta in uscita, non devi avere un localhost nella lista bianca. Come soluzione di compromesso, se attiverai il controllo della posta, potrai usare l\'inoltro della posta sulla casella di posta invece delle liste di posta. Tieni presente che attualmente non vi sono indirizzi di localhost IPv6 (::1/128) nella lista bianca, per cui il controllo della posta in uscita funzionerà per gli indirizzi IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Abilita DMARC per controllare la posta in arrivo',
    'server-mail-settings.spam-filter.dmarcHint' => 'Questa opzione è disponibile quando DKIM e SPF sono attivati per la posta in arrivo.',
    'server-mail-settings.spam-filter.dkim' => 'Protezione spam DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Consentire la firma della posta in uscita',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Verificare la posta in arrivo',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Questa opzione non può essere disattivata quando DMARC è acceso per la posta in arrivo.',
    'server-mail-settings.spam-filter.spf' => 'Protezione antispam SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Attiva la protezione antispam SPF per controllare la posta in arrivo',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Questa opzione non può essere disattivata quando DMARC è acceso per la posta in arrivo.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'La verifica di SPF prosegue quando ci sono problemi di ricerca DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'In primo luogo, SPF esegue una ricerca DNS. Seleziona questa opzione per continuare la verifica se la ricerca DNS fallisce. Questa opzione viene deselezionata se non incide sull\'attuale modalità di verifica.',
    'server-mail-settings.spam-filter.behavior' => 'Modalità di controllo SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Poi, SPF applica le regole locali e ipotetiche. Il messaggio può essere rifiutato a seconda della modalità di verifica selezionata e il risultato di verifica.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Crea solo intestazioni Received-SPF, non bloccare mai',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Usare notifiche di errore temporanee davanti a problemi di ricerca di DNS',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Rifiuta i messaggi quando SPF risolve a "fail" (negare)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Rifiuta i messaggi quando SPF risolve a "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Rifiuta i messaggi quando SPF risolve a "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Rifiuta i messaggi quando SPF non risolve a "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Regole SPF locali',
    'server-mail-settings.spam-filter.guessRules' => 'Regole ipotetiche per SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Testo di spiegazione SPF',
    'server-mail-settings.spam-filter.rbl' => "Protezione antispam basata sugli elenchi blackhole DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Attiva la protezione antispam basata sugli elenchi blackhole DNS",
    'server-mail-settings.spam-filter.rblServer' => "Zone DNS per il servizio DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Separare le voci con un punto e virgola, per esempio: 'dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Intestazioni di risposta automatica aggiuntive',
    'server-mail-settings.auto-reply-headers.description' => 'Configura intestazioni aggiuntive per eventuali messaggi di risposta automatica in arrivo dal server Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Intestazioni aggiuntive',

    'server-mail-settings.pop3-names.title' => "Nomi per gli account POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Si possono utilizzare solo i nomi completi degli account di posta POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Si possono utilizzare solo i nomi brevi (webmaster) e completi  (webmaster@domain.com) degli account di posta POP3/IMAP.",

    'server-mail-settings.success' => 'Le impostazioni del server di posta sono state modificate.',

    'server-mail-spam-filter.general' => 'Generale',
    'server-mail-spam-filter.isEnabled' => 'Attiva il filtro spam SpamAssassin del server',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin non è installato.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Attivare la protezione spam di greylisting del server',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Applica le impostazioni personali al filtro antispam',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Il filtro antispam è disattivato: il server di posta non supporta il filtro antispam a livello di casella postale.",
    'server-mail-spam-filter.settings' => 'Impostazioni SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Procedure massime',
    'server-mail-spam-filter.maxChildrenDescription' => 'Il numero massimo di processi di lavoro di spamd da eseguire.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Punteggio richiesto',
    'server-mail-spam-filter.requiredHitsDescription' => 'Il punteggio che un messaggio deve ricevere per essere qualificato come spam.',
    'server-mail-spam-filter.maxMailLimit' => 'Non filtrare se la dimensione della mail eccede questo valore',
    'server-mail-spam-filter.maxMailLimitText' => 'limite dimensione',
    'server-mail-spam-filter.kbytes' => "KByte",
    'server-mail-spam-filter.maxThreadsLimit' => 'Numero di thread che può creare il filtro spam',
    'server-mail-spam-filter.tagTitle' => 'Tag Spam',
    'server-mail-spam-filter.tagDescription' => 'All\'inizio dell\'oggetto di tutti i messaggi considerati spam verrà aggiunto il seguente testo.',
    'server-mail-spam-filter.alarmMessage' => 'Testo di allarme rilevazione spam',
    'server-mail-spam-filter.languages' => 'Lingue autorizzate',
    'server-mail-spam-filter.locales' => 'Localizzazioni autorizzate',
    'server-mail-spam-filter.success' => 'Le impostazioni del filtro antispam sono state cambiate.',
    'server-mail-spam-filter.personalSettingsWarning' => 'La capacità di applicare impostazioni personali per il filtraggio spam è stata disattivata dall\'amministratore del server. Le impostazioni di filtraggio spam specificate sotto non verranno applicate',

    'service-plan.admin-plan.subscription_section' => 'Comune',
    'service-plan.admin-plan.tools_section' => 'Strumenti e Risorse',
    'service-plan.admin-plan.apps_section' => 'Applicazioni & Database',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Aspetto di Plesk',
    'service-plan.admin-plan.statistics_section' => 'Statistiche',
    'service-plan.admin-plan.general_section' => 'Generale',
    'service-plan.admin-plan.mail_section' => 'Posta',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Estensioni',
    'service-plan.admin-plan.troubleshooting_section' => 'Assistenza e risoluzione dei problemi',
    'service-plan.admin-plan.simplePanel' => 'Modalità limitata',
    'service-plan.admin-plan.enabled' => 'Abilita la modalità limitata',
    'service-plan.admin-plan.enabledDescription' => 'Seleziona questa opzione per limitare il numero di azioni che l\'amministratore può eseguire in Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Seleziona questa opzione per limitare il numero di azioni che l\'amministratore aggiuntivo può eseguire in Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Fornire solo le applicazioni che io scelgo',
    'service-plan.applications-subscription.useFilterDescription' => 'Usa questa opzione per selezionare le applicazioni che dovrebbero essere disponibili all\'abbonato.',
    'service-plan.applications-subscription.applications' => 'Applicazioni',
    'service-plan.applications-subscription.isCommercial' => 'Questa app è commerciale e richiede l\'acquisto di una chiave di licenza.',

    'service-plan.applications.useFilterLabel' => 'Fornire solo le applicazioni che io scelgo',
    'service-plan.applications.useFilterDescription' => 'Usa questa opzione per selezionare le applicazioni che dovrebbero essere disponibili agli abbonati.',
    'service-plan.applications.applications' => 'Applicazioni',
    'service-plan.applications.isCommercial' => 'Questa app è commerciale e richiede l\'acquisto di una chiave di licenza.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS del dominio',
    'service-plan.dns.dnsZoneTypeMaster' => 'Primario',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secondario',

    'service-plan.extras.groupOtherServices' => 'Altri servizi',
    'service-plan.extras.none' => 'Nessuno',

    'service-plan.hosting.enablePhysicalHosting' => 'Abilita l\'hosting',
    'service-plan.hosting.sectionCoreHosting' => 'Proprietà generali',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Server database predefinito',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avanzato',
    'service-plan.hosting.phpSettingsHelpLink' => 'Impara a scegliere le impostazioni PHP più adatte',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Lo stato dei siti Web dell\'abbonamento è sospeso',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Stato dei siti Web negli abbonamenti sospesi',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Lo stato selezionato verrà applicato a tutti i siti Web negli abbonamenti del piano, quando l\'abbonamento è sospeso (ad esempio, scade oppure termina il periodo pagato).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Lo stato selezionato verrà applicato a tutti i siti Web quando l\'abbonamento è sospeso (ad esempio, scade oppure termina il periodo pagato).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Disabilitato',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'I visitatori dei siti Web verranno reindirizzati alla pagina predefinita del server Web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Sospeso',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'I visitatori del sito web saranno reindirizzati con il codice HTTP 503 compatibile con il motore di ricerca verso la pagina del documento di errore personalizzato.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Attivo',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'I siti Web rimarranno accessibili da Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Assegna indirizzi IP condivisi',
    'service-plan.ip.allocateExclusiveIp' => 'Assegna indirizzi IP dedicati',
    'service-plan.ip.allocateExclusiveIpV4' => 'Assegna indirizzi IPv4 dedicati',
    'service-plan.ip.allocateExclusiveIpV6' => 'Assegna indirizzi IPv6 dedicati',

    'service-plan.mail.mailService' => 'Servizio di posta',
    'service-plan.mail.mailServiceDisabled' => 'Disabilitato',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Disattivato per la posta in arrivo',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk non fornisce servizi di posta per i domini.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'I domini possono solo inviare posta e solo tramite Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Abilitato',
    'service-plan.mail.mailServiceEnabledHint' => 'I domini possono inviare e ricevere posta.',
    'service-plan.mail.mailServiceNotConfigured' => 'Non configurato',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk non fornisce servizi di posta per i domini.',
    'service-plan.mail.webMail' => 'WebMail',
    'service-plan.mail.mailingLists' => 'Attiva liste di posta',
    'service-plan.mail.mailToNonExistentUser' => 'Norme sulla posta per utenti inesistenti',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Rimbalzo con messaggio',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Inoltra verso indirizzo',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rifiuta',
    'service-plan.mail.mailAutodiscovery' => 'Abilita rilevamento automatico della posta',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Scopri come funziona nella <a href="%%link%%" target="_blank">base di conoscenze</a>',
    'service-plan.mail.bounceMessage' => 'Questo indirizzo non accetta più posta.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Reindirizza a server di posta esterno con l\'indirizzo IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - disabilitato',
    'service-plan.mail.notConfiguredConfirm' => 'Rimuovi in maniera permanente tutti i domini interessati, incluse le e-mail inviate e ricevute.',
    'service-plan.mail.notConfiguredConfirmError' => 'Conferma',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Nota: l\'impostazione **Conservare le statistiche web e del traffico** non viene modificata negli abbonamenti quando si aggiorna per un piano di servizio. L\'unico modo di aggiornare questa impostazione per ogni dominio è cambiarla nel database Plesk. Per ulteriori informazioni, consulta <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">questo articolo della KB</a>.',
    'service-plan.misc.retainEnabled' => 'Conservare le statistiche web e del traffico per',
    'service-plan.misc.logRotation' => 'Rotazione di registri',
    'service-plan.misc.logRotationCondition' => 'Condizione della rotazione di registri',
    'service-plan.misc.logRotationBySize' => 'Per dimensione',
    'service-plan.misc.logRotationByTime' => 'Per ora',
    'service-plan.misc.logRotationDaily' => 'Ogni giorno',
    'service-plan.misc.logRotationWeekly' => 'Ogni settimana',
    'service-plan.misc.logRotationMonthly' => 'Ogni mese',
    'service-plan.misc.logRotationSizeDescription' => 'Il valore della dimensione deve essere tra %%min%% e %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Numero massimo di file di registro',
    'service-plan.misc.compress' => 'Comprimi i file di registro',
    'service-plan.misc.sendLogToEmail' => 'Una volta che Plesk avrà ripristinato i dati dai file di registro dei server web e FTP, invia per posta elettronica i registri a questo indirizzo',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'mesi',
    'service-plan.misc.logRotationPeriodGreater' => 'Il periodo di rotazione del registro non può superare il limite %%max%% per l’intero server.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Se disconnesso, tutti i siti web di un abbonamento useranno lo stesso pool di applicazioni IIS dedicato per l\'abbonamento.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Scegli i servizi e privilegi forniti nell\'abbonamento.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Visualizza altri permessi disponibili',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Visualizza meno permessi',
    'service-plan.permissions-subscription.noShellManagement' => 'Non consentito',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Gestione dell\'accesso al server su SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Consente ai clienti di attivare SSH per il loro utente di sistema. Fa in modo che i parametri di hosting "Accesso SSH alla shell del server come utente di sistema dell\'abbonamento" fungano da valori predefiniti.',

    'service-plan.permissions.permissionsTabDescription' => 'Seleziona i servizi e i permessi inclusi nel piano.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Scegli i servizi ed i privilegi che verranno aggiunti agli abbonamenti con il piano di questo componente aggiuntivo. Tieni presente che i permessi non selezionati nel componente aggiuntivo non modificheranno in alcun modo i parametri dell\'abbonamento.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'I permessi permettono ai clienti di modificare impostazioni specifiche dei loro abbonamenti. Quando viene creato un abbonamento, Plesk applica i valori predefiniti del piano alle impostazioni che il cliente può modificare. In seguito, aggiornare il piano o applicare un piano di componenti aggiuntivi non sovrascrive le modifiche effettuate dal cliente.',
    'service-plan.permissions.showMorePermissions' => 'Visualizza altri permessi disponibili',
    'service-plan.permissions.hideMorePermissions' => 'Visualizza meno permessi',
    'service-plan.permissions.noShellManagement' => 'Non consentito',
    'service-plan.permissions.systemAccessLabel' => 'Gestione dell\'accesso al server su SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Fa che il parametro di hosting "Accesso SSH alla shell del server come utente di sistema dell\'abbonamento" agisca da pre-impostazione.',

    'service-plan.resources-subscription.overusePolicy' => 'Norme sul sovrautilizzo',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Il sovrautilizzo non è consentito',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Non consentire il sovrautilizzo di risorse.Un abbonamento viene automaticamente sospeso se l\'utilizzo delle risorse supera i valori limite.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Il sovrautilizzo dello spazio su disco e del traffico è consentito',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Consenti il sovrautilizzo dello spazio su disco e del traffico. Non consentire il sovrautilizzo di altre risorse.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Il sovrautilizzo è consentito (non consigliato)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Consentire all\'abbonato di utilizzare più risorse di quelle inizialmente fornite con l\'abbonamento.',
    'service-plan.resources-subscription.overuseNotify' => 'Notificami via e-mail in caso di sovrautilizzo.',
    'service-plan.resources-subscription.oversellPolicy' => 'Norme sull\'overselling',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'L\'overselling è consentito',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'L\'overselling consente ad un rivenditore di vendere più risorse di quelle che gli sono state assegnate con un abbonamento. Se l\'overselling è consentito, un rivenditore è retto dall\'utilizzo di risorse reale invece dell\'assegnazione di risorse iniziale.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'L\'overselling non è consentito',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Se l\'overselling non è consentito, un rivenditore può solo vendere tante risorse quante inizialmente assegnate con un abbonamento, a prescindere da quante risorse siano in realtà usate.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Definisci i limiti sull\'utilizzo delle risorse fornite con l\'abbonamento.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Visualizza altre risorse disponibili',
    'service-plan.resources-subscription.hideMoreResources' => 'Visualizza meno risorse',

    'service-plan.resources.overusePolicy' => 'Norme sul sovrautilizzo',
    'service-plan.resources.overusePolicyNotAllowed' => 'Il sovrautilizzo non è consentito',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Non consentire il sovrautilizzo di risorse.Un abbonamento viene automaticamente sospeso se l\'utilizzo delle risorse supera i valori limite.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Il sovrautilizzo dello spazio su disco e del traffico è consentito',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Consenti il sovrautilizzo dello spazio su disco e del traffico. Non consentire il sovrautilizzo di altre risorse.',
    'service-plan.resources.overusePolicyAllowed' => 'Il sovrautilizzo è consentito (non consigliato)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Consenti ai clienti di utilizzare più risorse di quelle che inizialmente sono state fornite dal piano.',
    'service-plan.resources.overuseNotify' => 'Notificami via e-mail in caso di sovrautilizzo.',
    'service-plan.resources.oversellPolicy' => 'Norme sull\'overselling',
    'service-plan.resources.oversellPolicyAllowed' => 'L\'overselling è consentito',
    'service-plan.resources.oversellPolicyAllowedHint' => 'L\'overselling consente ad un rivenditore di vendere più risorse di quelle che gli sono state assegnate con un piano. Se l\'overselling è consentito, un rivenditore è retto dall\'utilizzo di risorse reale invece dell\'assegnazione di risorse iniziale.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'L\'overselling non è consentito',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Se l\'overselling non è consentito, un rivenditore può solo vendere tante risorse quante inizialmente assegnate con un piano, a prescindere da quante risorse siano in realtà usate.',
    'service-plan.resources.mainGroupTitle' => 'Definisci i limiti delle risorse fornite con il piano.',
    'service-plan.resources.additionalGroupTitle' => 'Visualizza altre risorse disponibili',
    'service-plan.resources.hideMoreResources' => 'Visualizza meno risorse',
    'service-plan.resources.allowSitebuilderUpsell' => 'Consenti ai clienti di creare siti web di prova con Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Questa impostazione permette ai clienti di creare più siti web di Presence Builder di quanti forniti dal piano di servizio. I clienti dovranno acquistare questi siti web per pubblicarli.',

    'service-plan.servicePlanName' => 'Nome del piano di servizio',
    'service-plan.resellerPlanName' => 'Nome del piano del rivenditore',
    'service-plan.addonPlanName' => 'Nome del piano del componente aggiuntivo',
    'service-plan.adminPlanPermissionsTab' => 'Strumenti amministrativi',
    'service-plan.adminPlanPermissionsTabDescription' => 'Seleziona le funzionalità disponibili per l’amministratore quando è attiva la modalità limitata.',
    'service-plan.hostingPermissionsTab' => 'Strumenti di hosting',
    'service-plan.hostingPermissionsTabDescription' => 'Seleziona gli strumenti di hosting web e le impostazioni disponibili all\'amministratore in visualizzazione Power User quando è attiva la modalità limitata.',
    'service-plan.resourcesTab' => 'Risorse',
    'service-plan.resourcesTabDescription' => 'Definisci le risorse fornite con il piano e le norme sull\'utilizzo delle risorse.',
    'service-plan.subscriptionResourcesTabDescription' => 'Definisci le risorse fornite con l\'abbonamentoe le norme sull\'utilizzo delle risorse.',
    'service-plan.hostingTab' => 'Parametri di hosting',
    'service-plan.hostingTabDescription' => 'Indica i parametri del servizio di hosting forniti nel piano. Si noti bene che le impostazioni di hosting specificate nel piano del componente aggiuntivo non sono applicate agli abbonamenti a cui sono concessi i permessi di "Gestione delle impostazioni di hosting" sia per il piano di servizio sia quello del componente aggiuntivo.',
    'service-plan.secureSettingsDescription' => 'Per rendere più sicuro l\'hosting fornito, %%link%%. Tieni presente che alcuni permessi, se sono stati concessi, consentono agli abbonati di modificare queste impostazioni. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'applica la preimpostazione per una configurazione protetta',
    'service-plan.secureSettingsHelpLink' => 'Informazioni sulle impostazioni di hosting protetto',
    'service-plan.mailTab' => 'Posta',
    'service-plan.mailTabDescription' => 'Indicare i parametri del servizio di posta fornito nel piano.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Indicare i parametri del servizio DNS fornito nel piano.',
    'service-plan.performanceTab' => 'Prestazioni',
    'service-plan.performanceTabDescription' => 'Indica i parametri di sistema che incidono sulla performance di tutti i servizi forniti nel piano.',
    'service-plan.permissionsTab' => 'Permessi',
    'service-plan.miscTab' => 'Registri & Statistiche',
    'service-plan.miscTabDescription' => 'Specificare come le statistiche e i registri degli abbonamenti del piano dovrebbero essere conservati. Si noti che queste impostazioni non vengono sincronizzate negli abbonamenti.',
    'service-plan.miscTabAdminPlanDescription' => 'Specifica come devono essere archiviati i registri e le statistiche degli abbonamenti.',
    'service-plan.extrasTab' => 'Servizi aggiuntivi',
    'service-plan.extrasTabDescription' => 'Seleziona i servizi che dovrebbero essere compresi nel piano oltre all\'hosting web, DNS e servizi di posta.',
    'service-plan.ipTab' => 'Indirizzi IP',
    'service-plan.ipTabDescription' => 'Indicare i parametri delle risorse IP fornite nel piano.',
    'service-plan.applicationsTab' => 'Applicazioni',
    'service-plan.applicationsTabDescription' => 'Seleziona le applicazioni che dovrebbero essere disponibili nel piano. È possibile scegliere di fornire tutte le applicazioni disponibili dal Catalogo di Applicazioni, oltre a quelle che hai caricato nel server oppure selezionare le applicazioni manualmente. Se desideri fornire tutte le applicazioni disponibili, allora non devi fare niente in questa scheda, semplicemente vai alla scheda Permessi e seleziona l\'opzione Accesso al Catalogo di Applicazioni. Se desideri selezionare le applicazioni manualmente, puoi farlo in questa scheda.',
    'service-plan.applicationsTabDescription-addon' => 'Seleziona le applicazioni che devono essere disponibili nel componente aggiuntivo.',
    'service-plan.applicationsTabDescription-subscription' => 'Seleziona le applicazioni che dovrebbero essere disponibili nell\'abbonamento. È possibile scegliere di fornire tutte le applicazioni disponibili dal Catalogo di Applicazioni, oltre a quelle che hai caricato nel server oppure selezionare le applicazioni manualmente. Se desideri fornire tutte le applicazioni disponibili, allora non devi fare niente in questa scheda, semplicemente vai alla scheda Permessi e seleziona l\'opzione Accesso al Catalogo di Applicazioni. Se desideri selezionare le applicazioni manualmente, puoi farlo in questa scheda.',
    'service-plan.planSyncSubsriptionWarning' => 'Alcuni abbonamenti non erano sincronizzati con il piano. Sono stati contrassegnati come \'Non sincronizzati\' nell\'elenco di abbonamenti. Per riprovare la sincronizzazione, accedi alla pagina informativa dell\'abbonamento e fai clic sul pulsante Sincronizza.',
    'service-plan.planSyncResellerWarning' => 'Alcuni rivenditori non erano sincronizzati con il piano. Sono stati contrassegnati come \'Non sincronizzati\' nell\'elenco di rivenditori. Per riprovare la sincronizzazione, accedi alla pagina informativa del rivenditore e fai clic sul pulsante Sincronizza.',
    'service-plan.planSyncAdminWarning' => 'Impossibile applicare modifiche agli abbonamenti perché Plesk non fornisce alcun servizio o risorsa coinvolti da tali modifiche. Il motivo: %%reason%%',
    'service-plan.duplicateName' => 'Esiste già un piano con questo nome.',
    'service-plan.phpSettingsTab' => 'Impostazioni PHP',
    'service-plan.phpHandlerNotFound' => 'Impossibile recuperare le informazioni della versione di PHP nel piano. Reinstallala o seleziona un\'altra versione di PHP per il piano di servizio.',
    'service-plan.phpHandlerNotRegistered' => "Versione di PHP %%fullVersion%% non installata. Scripting PHP non disponibile per i domini che usano questo piano di servizio. Installa la <nobr>versione di PHP %%fullVersion%%</nobr> o selezionane un'altra per il piano di servizio.",

    'service-plan.phpSettingsTabDescription' => 'In questa sezione è possibile specificare le impostazioni PHP specifiche di ogni abbonamento che sovrascrivono le impostazioni definite dal file php.ini a livello del server. Potrebbe essere utile, per esempio, quando si desidera limitare l\'utilizzo delle risorse di sistema dagli script PHP dei clienti. I clienti (se hanno tale diritto) possono sovrascrivere la configurazione PHP per la configurazione del proprio dominio. Quando un parametro viene impostato al valore predefinito, PHP usa il valore del parametro dalla configurazione PHP del server. I seguenti segnaposti sono supportati: {DOCROOT} e {WEBSPACEROOT}, che fanno riferimento alla directory radice dei documenti di un dominio e alla directory radice di un abbonamento a cui viene attribuita la configurazione PHP personalizzata; e {TMP}, che fa riferimento alla directory che memorizza i file temporanei. Nota bene: le impostazioni in basso possono essere sovrascritte dai parametri specificati nei file .htaccess, php.ini o .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'In questa sezione è possibile specificare le impostazioni PHP per ogni abbonamento che sovrascrivono le impostazioni definite dal piano di servizio principale. Potrebbe risultare utile, per esempio, quando si desidera rimuovere alcune limitazioni PHP impostate nel piano di servizio principale. Quando un parametro viene impostato al valore predefinito, PHP usa il valore del parametro dalla configurazione PHP del piano di servizio. I seguenti segnaposti sono supportati: {DOCROOT} e {WEBSPACEROOT}, che fanno riferimento alla directory radice dei documenti di un dominio e alla directory radice di un abbonamento a cui viene attribuita la configurazione PHP personalizzata e {TMP}, che fa riferimento alla directory che memorizza i file temporanei.',
    'service-plan.phpSettingsPhpVersion' => 'La tua corrente versione PHP è %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'In questa sezione è possibile specificare le impostazioni PHP specifiche di ogni abbonamento che sovrascrivono le impostazioni definite dal file php.ini a livello del server. Quando un parametro viene impostato al valore predefinito, PHP usa il valore del parametro dalla configurazione PHP del server.',
    'service-plan.webServerSettingsTab' => 'Server Web',
    'service-plan.webServerSettingsTabDescription' => 'In questa sezione è possibile specificare le impostazioni del server web Apache per questo piano di servizio. Se Apache è in esecuzione con nginx come server di frontend, sarà possibile specificare le impostazioni di nginx anche in questa pagina. Tutti i nuovi domini creati riceveranno le impostazioni specificate. Tuttavia, quando si modificheranno le impostazioni, i domini esistenti non otterranno le modifiche.',
    'service-plan.servicesTab' => 'Servizi',
    'service-plan.servicesTabDescription' => 'Qui è possibile specificare i servizi assegnati al piano di servizio.',
    'service-plan.servicePropertiesTab' => 'Proprietà %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Qui è possibile specificare le proprietà del servizio %%serviceName%% assegnate al piano di servizio.',
    'service-plan.longTaskWarning' => 'Hai %%subscriptionsCount%% abbonamenti in questo piano. Si noti bene che l\'attività di sincronizzazione potrebbe richiedere molto tempo e sarà eseguita in un secondo piano.',
    'service-plan.hostingParametersTab' => 'Parametri di hosting',
    'service-plan.adminInfoSection' => 'Informazione per l\'amministratore',
    'service-plan.descriptionInPanel' => 'Descrizione',
    'service-plan.longDescription' => 'La descrizione specificata è troppo lunga.',
    'service-plan.conflictPermissions' => 'Impossibile garantire i seguenti permessi non sono compatibili con il piano rivenditore: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipo di avvio',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatico',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuale',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Disattiva',
    'services.change-startup-type.autoActionError' => 'Non è stato possibile impostare tipo di avvio su \'automatico\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Non è stato possibile impostare tipo di avvio su \'manuale\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Non è stato possibile impostare tipo di avvio su \'disattivato\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Reimposta a predefinito',
    'sessions.settings.restoreDefaultButtonDescription' => 'Ripristina i parametri della sessione sui valori predefiniti.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'I parametri della sessione hanno valori predefiniti.',
    'sessions.settings.idleTime' => 'Tempo di inattività della sessione',
    'sessions.settings.disableCheckSessionIp' => 'Consente modifiche dell\'indirizzo IP durante una singola sessione',
    'sessions.settings.minuteShortTitle' => 'min.',

    'settings-ui.controls.title' => 'Controlli',

    'settings-ui.interface-views.description' => "Sono disponibili diverse visualizzazioni IU prodotto. A seconda di quella che userai, le caratteristiche e le impostazioni potrebbero apparire in posizioni diverse o potrebbero essere abilitate / disabilitate. Le differenti visualizzazioni si adattano a ogni tipo di utente.",
    'settings-ui.interface-views.panelSimpleLink' => 'Strumenti e Impostazioni > Impostazioni modalità limitata',
    'settings-ui.interface-views.useCustomView' => 'Abilita la modalità limitata',
    'settings-ui.interface-views.useCustomViewHint' => 'Seleziona questa opzione per limitare il numero di azioni che l\'amministratore può eseguire in Plesk Panel.Per modificare la disponibilità delle azioni, passa a %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Questa modalità di visualizzazione è la più adatta per gestire siti web, file interni, database, account email, applicazioni web e altri servizi.',
    'settings-ui.interface-views.selectUiModeTitle' => "Seleziona la tua interfaccia",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Visualizzazione Power User (per gli sviluppatori e le web agency)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Visualizzazione Service Provider (per i provider di hosting web)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Questa modalità di visualizzazione è destinata agli amministratori del server che forniscono e vendono servizi di hosting web ai clienti tramite piani di servizio.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Nascondi i controlli di rimbalzo',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Nasconde il pulsante che permette di configurare come elaborare la posta inviata a indirizzi e-mail inesistenti',

    'settings-ui.branding.description' => 'Personalizza l\'interfaccia di Plesk modificando come appare la pagina nella barra del titolo del browser e/o sostituendo il logo Plesk nell\'angolo superiore sinistro.',
    'settings-ui.branding.buttonDefault' => 'Logo di default',
    'settings-ui.branding.sectionTitle' => 'Titolo personalizzato',
    'settings-ui.branding.enableCustomTitle' => 'Abilita il titolo personalizzato sulle pagine di Plesk',
    'settings-ui.branding.customTitle' => 'Testo del titolo',
    'settings-ui.branding.sectionLogo' => 'Logo personalizzato',
    'settings-ui.branding.enableCustomLogo' => 'Abilita il logo personalizzato del pannello',
    'settings-ui.branding.logo' => 'File di registro',
    'settings-ui.branding.logoUrl' => 'URL del logo',
    'settings-ui.branding.logoUrlEnabled' => 'Personalizza',
    'settings-ui.branding.logoUrlDisabled' => 'Predefinito',
    'settings-ui.branding.sectionFavicon' => 'Favicon personalizzata',
    'settings-ui.branding.enableCustomFavicon' => 'Abilita la favicon personalizzata',
    'settings-ui.branding.sectionFaviconDesc' => 'La stessa favicon deve essere caricata in entrambi i formati per un migliore supporto nei diversi browser.',
    'settings-ui.branding.faviconSvg' => 'Favicon file SVG',
    'settings-ui.branding.faviconSvgHint' => 'Formato consentito: SVG',
    'settings-ui.branding.faviconIco' => 'Favicon file ICO',
    'settings-ui.branding.faviconIcoHint' => 'Formato consentito: ICO',
    'settings-ui.branding.show' => 'Mostra',
    'settings-ui.branding.updateSuccess' => 'Le proprietà di personalizzazione di Plesk sono state cambiate.',
    'settings-ui.branding.sectionBackground' => 'Sfondo personalizzato schermata di accesso',
    'settings-ui.branding.enableCustomBackground' => 'Abilita immagine di sfondo',
    'settings-ui.branding.backgroundFile' => 'Immagine di sfondo',
    'settings-ui.branding.backgroundColor' => 'Colore di sfondo',
    'settings-ui.branding.backgroundResetColor' => 'Reimposta',
    'settings-ui.branding.backgroundFit' => 'Posizione immagine',
    'settings-ui.branding.background.fit.fill' => 'Riempi',
    'settings-ui.branding.background.fit.fit' => 'Adatta',
    'settings-ui.branding.background.fit.center' => 'Centra',
    'settings-ui.branding.background.fit.tile' => 'Affianca',

    'sitebuilder.trial.description' => 'Questa pagina permette di configurare la modalità Prova e Acquista (in passato, Scenario di Acquisizione di Clienti). In questa modalità, il cliente può creare un sito web con tutte le funzionalità disponibili nell\'applicazione Presence Builder incorporata. Tuttavia, la pubblicazione di siti web di prova non sarà disponibile ai clienti finché non acquisteranno un piano di servizi di hosting o un componente aggiuntivo del piano. La modalità Prova e Acquista può anche essere disponibile ai clienti esistenti tramite un piano di hosting o il componente aggiuntivo di un piano. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Consultare la documentazione per maggiori informazioni.',
    'sitebuilder.trial.lifetimeLabel' => 'Ciclo di vita del sito web di prova',
    'sitebuilder.trial.lifetimeUnits' => 'giorni',
    'sitebuilder.trial.lifetimeDescription' => 'Questo è lo spazio di tempo che deve trascorrere prima che i siti web di prova che non sono stati acquistati dai clienti vengano rimossi dal server.',
    'sitebuilder.trial.signupLabel' => 'Habilitar acceso público a modo de prueba',
    'sitebuilder.trial.signupDescription' => 'Se desideri attirare i clienti mediante la pubblicità di hosting con Presence Builder e rendere disponibile una demo su Presence Builder, abilita l\'accesso pubblico alla modalità di prova e pubblica l\'URL di accesso alla modalità di prova sul tuo sito web.',
    'sitebuilder.trial.signupLinkLabel' => 'URL di accesso alla modalità di prova',
    'sitebuilder.trial.signupLinkDescription' => 'Questo URL aprirà Presence Builder in modalità di prova. Pubblica questo URL sul tuo sito web per fare pubblicità sull\'hosting con Presence Builder e attirare i clienti.',
    'sitebuilder.trial.promotionLabel' => 'Visualizza la notifica sulla modalità di prova nell\'editor di Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Usa questa opzione se desideri mostrare una notifica aggiuntiva riguardo il funzionamento della modalità di prova in Presence Builder.',

    'update-settings.policyHintForPum' => 'Qui è possibile impostare l\'installazione automatica degli aggiornamenti. È possibile inviare una e-mail di notifica quando sono disponibili gli aggiornamenti da installare manualmente o se sono stati installati automaticamente.',
    'update-settings.policyHint' => 'È possibile inviare una e-mail di notifica quando sono disponibili gli aggiornamenti da installare manualmente o se sono stati installati automaticamente.',
    'update-settings.branchDisabledDescription' => 'Non notificarmi sugli aggiornamenti disponibili',
    'update-settings.automaticPatchesInstallation' => 'Installazione automatica degli aggiornamenti Plesk (consigliato)',
    'update-settings.automaticPatchesThirdParty' => 'Installazione automatica degli aggiornamenti per i componenti di terzi inviati da Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Installazione automatica degli aggiornamenti del pacchetto di sistema',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Tieni presente che, in questo modo, si installano automaticamente anche gli aggiornamenti per i componenti di terzi inviati da Plesk',
    'update-settings.installerProxyMode' => 'Accedi all\'Installer di Plesk tramite il nome host e la porta di Plesk',
    'update-settings.installerProxyModeHint' => 'Accedi all\'interfaccia web dell\'Installer di Plesk senza dover aprire la porta 8447 TCP nel firewall.',
    'update-settings.automaticPatchesNotification' => 'Notifica gli aggiornamenti dei pacchetti di sistema disponibili e installati',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Indirizzo e-mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frequenza delle e-mail di notifica',
    'update-settings.daily' => 'Ogni giorno',
    'update-settings.weekly' => 'Settimanale',
    'update-settings.generalSection' => 'Generale',
    'update-settings.notificationsSection' => 'Notifiche',
    'update-settings.safeUpdatesSection' => 'Aggiornamenti sicuri',
    'update-settings.safeUpdatesSectionHint' => 'Plesk si accerta che gli aggiornamenti dei pacchetti di sistema vengano installati dallo stesso archivio da cui sono stati installati inizialmente.Questi aggiornamenti sono considerati sicuri. Se disabiliti gli aggiornamenti sicuri, il gestore dei pacchetti del sistema potrebbe installare gli aggiornamenti da qualsiasi archivio nel sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'Ti consigliamo di lasciare abilitati gli aggiornamenti sicuri, a meno che tu non sia un utente avanzato. Gli aggiornamenti indiscriminati di pacchetti di sistema da archivi diversi possono compromettere il funzionamento del server.',
    'update-settings.allowSafeUpdates' => 'Abilita aggiornamenti sicuri per i pacchetti di sistema',

    'requiredFields' => 'Campi obbligatori',

    'ip-ban.banned-ip.ipAddress' => 'Indirizzo IP',
    'ip-ban.banned-ip.hintIpAddress' => 'Un indirizzo IP o una maschera CIDR.',
    'ip-ban.banned-ip.banType' => 'Escludi l\'indirizzo IP: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'Per una settimana',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Per sempre',

    'server-mail-smarthost.settings.title' => 'Impostazioni smarthost',
    'server-mail-smarthost.settings.useSmarthost' => 'Invia la posta degli utenti tramite uno smarthost',
    'server-mail-smarthost.configuration.title' => 'Configurazione smarthost',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Nome host o indirizzo IP',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'Per disattivare le ricerche MX o SRV, racchiudi l\'hostname o l\'indirizzo IP tra parentesi quadre. Ad es. [esempio.com]',
    'server-mail-smarthost.configuration.checkConnection' => 'Verifica connessione',
    'server-mail-smarthost.configuration.port' => 'Porta',
    'server-mail-smarthost.configuration.username' => 'Nome utente',
    'server-mail-smarthost.configuration.password' => 'Password',
    'server-mail-smarthost.configuration.encryption' => 'Connessione criptata',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Richiesta',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'Non richiesta',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Nessuno',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Autenticazione richiesta',
    'server-mail-smarthost.configuration.checkConnection.success' => 'La connessione allo smarthost è stata stabilita.',
    'server-mail-smarthost.success' => 'La configurazione dello smarthost è stata modificata.',
    'server-mail-smarthost.settings.noteTitle' => 'Nota:',
    'server-mail-smarthost.settings.note' => '%%title%% configurando l\'invio delle e-mail tramite smarthost, dovrai aggiornare manualmente il SPF e i relativi record DNS presenti nel modello DNS e nelle zone DNS dei domini esistenti. Si tratta di un\'azione necessaria per prevenire errori di verifica delle e-mail inviate tramite lo smarthost. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'Vedi altri dettagli.',
];
