<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => '사이트가 전용 IP 주소에서 호스트되는 경우(다른 사용자 또는 사이트와 공유되지 않음) 사이트 내에서 다른 사용자가 FTP를 통해 익명으로 파일을 업로드하거나 다운로드할 수 있는 디렉터리를 설정할 수 있습니다. 익명 FTP의 사용이 설정되면 사용자가 "anonymous" 사용자 이름과 아무 암호를 이용하여 ftp://ftp.your-domain.com과 같은 주소를 통해 디렉터리에 로그인할 수 있습니다.',
    'anonymous-ftp.displayLogin' => '로그인 메시지 표시',
    'anonymous-ftp.loginText' => '메시지 텍스트',
    'anonymous-ftp.incomingDir' => '수신 디렉터리에 업로드 허용',
    'anonymous-ftp.incomingSubDir' => '수신 디렉터리에 디렉터리의 만들기 허용',
    'anonymous-ftp.incomingReadable' => '수신 디렉터리에서 다운로드 허용',
    'anonymous-ftp.quota' => '수신 디렉터리의 디스크 공간 제한',
    'anonymous-ftp.maxConnections' => '동시 연결 수 제한',
    'anonymous-ftp.bandwidth' => '이 가상 FTP 도메인의 다운로드 대역폭 제한',
    'anonymous-ftp.unlimited' => '제한 없음',

    'aps.catalog.loading' => '로드 중...',
    'aps.catalog.searchName' => '응용 프로그램',
    'aps.catalog.searchVendor' => '공급업체',
    'aps.catalog.searchPackager' => '패키지 생성자',
    'aps.catalog.searchLicenseType' => '라이센스 유형',
    'aps.catalog.searchLicenseTypeAny' => '모두',
    'aps.catalog.searchLicenseTypeFreeware' => '무료',
    'aps.catalog.searchLicenseTypeCommercial' => '상용',
    'aps.catalog.showSearch' => '검색 표시',
    'aps.catalog.hideSearch' => '검색 숨기기',
    'aps.catalog.buttonSearch' => '검색',
    'aps.catalog.buttonResetSearch' => '검색 재설정',
    'aps.catalog.showCategories' => '아래 카테고리를 선택하거나 검색 상자를 사용하여 앱을 검색합니다',
    'aps.catalog.searchResults' => '검색 결과',
    'aps.catalog.buttonInstall' => '설치',
    'aps.catalog.buttonInstallTooltip' => '최적의 기본값 매개 변수를 가지는 최신 버전의 응용 프로그램을 신속하게 설치합니다.',
    'aps.catalog.buttonAdvancedInstall' => '설치(사용자 지정)',
    'aps.catalog.buttonAdvancedInstallTooltip' => '모든 매개 변수가 사용자 정의된 최신 버전의 응용 프로그램을 설치합니다.',
    'aps.catalog.buttonInstallOldVersion' => '설치 버전',
    'aps.catalog.buttonInstallOldVersionTooltip' => '모든 매개 변수가 사용자 정의된 선택한 버전의 응용 프로그램을 설치합니다.',
    'aps.catalog.buttonInstallDescription' => '활성화 코드가 이미 있거나 사용해 보려는 경우 사이트에 응용 프로그램을 설치합니다.',
    'aps.catalog.buttonInstallDescriptionFree' => '사이트에 이 무료 응용 프로그램을 설치합니다.',
    'aps.catalog.version' => '버전',
    'aps.catalog.moreVersions' => '다른 버전',
    'aps.catalog.release' => '릴리스',
    'aps.catalog.overview' => '개요',
    'aps.catalog.noApplicationsInCategory' => '이 범주의 사용 가능한 응용 프로그램이 없습니다. 다른 범주를 선택합니다.',
    'aps.catalog.noCategoriesSelected' => '범주를 선택하여 이 범주의 사용 가능한 모든 응용 프로그램을 찾습니다.',
    'aps.catalog.noSearchResults' => '검색 결과 일치하는 응용 프로그램이 없습니다.',
    'aps.catalog.connectionFailed' => '응용 프로그램 카탈로그에 연결하지 못했습니다. %%retryLink%%.',
    'aps.catalog.retry' => '다시 시도',
    'aps.catalog.categoriesError' => '현재 범주 목록을 로드할 수 없습니다.',
    'aps.catalog.applicationsError' => '현재 응용 프로그램 목록을 로드할 수 없습니다.',
    'aps.catalog.detailsError' => '현재 응용 프로그램 세부 정보를 로드할 수 없습니다.',
    'aps.catalog.searchError' => '현재 검색 결과를 로드할 수 없습니다.',
    'aps.catalog.changelogEntry' => 'v%%version%%(릴리스 %%release%%) - %%description%%',
    'aps.catalog.changelog' => '변경 내역',
    'aps.catalog.officialApplicationSite' => '공급업체 정보',
    'aps.catalog.returnToCategories' => '<< 응용 프로그램 목록으로 돌아가기',
    'aps.catalog.buttonUninstall' => '제거',
    'aps.catalog.gotoHome' => '홈',
    'aps.catalog.all' => '모두',
    'aps.catalog.buttonDetails' => '자세히 알아보기',
    'aps.catalog.buttonBuy' => '지금 구입',
    'aps.catalog.buttonBuyTooltip' => '앱 구매',
    'aps.catalog.buttonBuyDescription' => 'Parallels 스토어를 방문하여 응용 프로그램 활성화 코드를 구입합니다.',
    'aps.catalog.buttonDownload' => '다운로드',
    'aps.catalog.buttonDownloadDescription' => '활성화 코드가 이미 있거나 사용해 보려는 경우 응용 프로그램을 다운로드합니다.',
    'aps.catalog.marketplaceMoreInfo' => '자세한 내용은 %%link%%를 방문하십시오.',
    'aps.catalog.marketplaceMoreInfoLink' => '응용 프로그램 공급업체 웹 사이트',

    'aps.configure.installedAt' => "설치 위치",
    'aps.configure.otherSettings' => "기타",
    'aps.configure.globalSettings' => '패키지 설정',
    'aps.configure.passwordConfirmation' => '암호 확인',
    'aps.configure.databaseParams' => '데이터베이스 매개 변수',
    'aps.configure.noInstallationUrlAvailable' => '없음(외부 응용 프로그램)',
    'aps.configure.updateSettingsSection' => '업데이트 설정',
    'aps.configure.forceUpdates' => '업데이트가 있을 때 이 응용 프로그램 자동 업데이트',
    'aps.configure.forceUpdatesHint' => '응용 프로그램에 새 버전의 업데이트가 자동으로 보내집니다. 경고: 업데이트는 응용 프로그램 기능에 중대한 영향을 미칠 수 있으므로 이 옵션을 신중하게 사용하십시오. 예를 들어 응용 프로그램 확장 기능이 다른 응용 프로그램 버전에서는 작동하지 않을 수 있습니다.',

    'aps.install.showAllSettings' => '모든 설정 표시',
    'aps.install.showLessSettings' => '최소 설정 표시',
    'aps.install.install' => '설치',
    'aps.install.otherSettings' => '기타 설정',
    'aps.install.globalSettings' => '패키지 설정',
    'aps.install.passwordConfirmation' => '암호 확인',
    'aps.install.provisionsSectionLabel' => '설치 경로',
    'aps.install.context' => '이 웹 응용 프로그램을 설치할 위치 지정',
    'aps.install.registerAsWebmailSection' => '웹 메일 등록',
    'aps.install.registerAsWebmailDescription' => "응용 프로그램이 웹 메일 클라이언트인 경우 이 옵션을 선택합니다. 그러면 응용 프로그램이 구독 및 서비스 플랜의 메일 설정에서 사용 가능한 웹 메일 서비스로 나타납니다. 관리자는 서비스 관리 > 설정 > 웹 메일에서 웹 메일의 공용 액세스 URL을 구성할 수 있습니다.",
    'aps.install.registerAsWebmailLabel' => '웹 메일 서비스로 등록',
    'aps.install.addItem' => '추가',
    'aps.install.removeItem' => '제거',
    'aps.install.updateSettingsSection' => '업데이트 설정',
    'aps.install.forceUpdates' => '업데이트가 있을 때 이 응용 프로그램 자동 업데이트',
    'aps.install.forceUpdatesHint' => '응용 프로그램에 새 버전의 업데이트가 자동으로 보내집니다. 경고: 업데이트는 응용 프로그램 기능에 중대한 영향을 미칠 수 있으므로 이 옵션을 신중하게 사용하십시오. 예를 들어 응용 프로그램 확장 기능이 다른 응용 프로그램 버전에서는 작동하지 않을 수 있습니다.',

    'aps.invalid-requirements.requirementsLegend' => '요구 사항',
    'aps.invalid-requirements.domainLegend' => '웹 사이트',
    'aps.invalid-requirements.context' => '다른 웹 사이트 선택',
    'aps.invalid-requirements.backToApplicationList' => '응용 프로그램 목록으로 돌아가기',

    'aps.license.title' => '설치 %%packageName%%',
    'aps.license.doYouAcceptLicense' => '이 응용 프로그램을 설치하려면 최종 사용자 라이센스 계약서를 읽고 그 내용에 동의해야 합니다.',
    'aps.license.licenseAgree' => '라이센스 계약서 내용에 동의함',

    'aps.services-list-customization.settings' => '설정',

    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET 프레임워크 버전',

    'asp-dot-net.settings.casSettingsSection' => "코드 액세스 보안",
    'asp-dot-net.settings.clientScriptsSection' => "스크립트 라이브러리 설정",
    'asp-dot-net.settings.connStringsSection' => "연결 문자열 관리자",
    'asp-dot-net.settings.customErrorsSection' => "사용자 지정 오류 설정",
    'asp-dot-net.settings.frameworkVersionSection' => "프레임워크 버전",
    'asp-dot-net.settings.globalizationSection' => "전역 설정",
    'asp-dot-net.settings.otherSection' => "세션 설정",
    'asp-dot-net.settings.pageAndRuntimeSection' => "컴파일 및 디버깅",
    'asp-dot-net.settings.authMode' => "인증 모드",
    'asp-dot-net.settings.connStrings' => "연결 문자열",
    'asp-dot-net.settings.connStringsInvalid' => "일부 필드가 비어 있거나 부적합한 값이 입력되었습니다.",
    'asp-dot-net.settings.connStringName' => "이름",
    'asp-dot-net.settings.connStringValue' => "연결 매개 변수",
    'asp-dot-net.settings.culture' => "문화권",
    'asp-dot-net.settings.customErrMode' => "사용자 지정 오류 모드",
    'asp-dot-net.settings.customErrorRedirect' => "리디렉션 URL",
    'asp-dot-net.settings.customErrorStatus' => "상태 코드",
    'asp-dot-net.settings.customErrorStatusInvalid' => "상태 코드는 정수여야 합니다.",
    'asp-dot-net.settings.customErrors' => "사용자 지정 오류",
    'asp-dot-net.settings.customErrorsInvalid' => "일부 필드가 비어 있거나 부적합한 값이 입력되었습니다.",
    'asp-dot-net.settings.debugMode' => "디버깅 설정",
    'asp-dot-net.settings.defLanguage' => "기본 웹 페이지 언어",
    'asp-dot-net.settings.tempDirectory' => "임시 디렉터리",
    'asp-dot-net.settings.fileEnc' => "파일 인코딩",
    'asp-dot-net.settings.fileEncInvalid' => "파일 인코딩 매개 변수에 대해 지정된 값이 유효하지 않습니다.",
    'asp-dot-net.settings.pathToLib' => "Microsoft 스크립트 라이브러리의 경로",
    'asp-dot-net.settings.pathToLibInstall' => "설치",
    'asp-dot-net.settings.reqEnc' => "요청 인코딩",
    'asp-dot-net.settings.reqEncInvalid' => "요청 인코딩 매개 변수에 대해 지정된 값이 유효하지 않습니다.",
    'asp-dot-net.settings.resEnc' => "응답 인코딩",
    'asp-dot-net.settings.resEncInvalid' => "응답 인코딩 매개 변수에 대해 지정된 값이 유효하지 않습니다.",
    'asp-dot-net.settings.sessTimeout' => "세션 시간 초과(분)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "세션 시간 초과 매개 변수에 대해 지정된 값이 유효하지 않습니다. %%max%%보다 작거나 같은 양의 정수를 입력하십시오.",
    'asp-dot-net.settings.trustLevel' => "CAS 신뢰 수준",
    'asp-dot-net.settings.uiCulture' => "UI 문화권",
    'asp-dot-net.settings.version' => "버전",
    'asp-dot-net.settings.trustLevelAllowOverride' => '웹 사이트에서 CAS 신뢰 수준 재정의 허용',
    'asp-dot-net.settings.addConnStrings' => '연결 문자열 추가',
    'asp-dot-net.settings.addCustomErrors' => '사용자 지정 오류 추가',
    'asp-dot-net.settings.buttonRemove' => '제거',

    'database.clone.formDescription' => '데이터베이스 내용을 새 데이터베이스 또는 기존 데이터베이스에 복사합니다. 기존 데이터베이스에 복사하는 경우, 소스 데이터베이스의 테이블이 대상 데이터베이스의 테이블에 추가됩니다. 경고: 테이블 이름이 동일한 경우 소스의 테이블이 대상의 테이블을 대체합니다.',
    'database.clone.copyData' => '전체 복사본 만들기',
    'database.clone.copyDataHint' => '선택할 경우 구조와 데이터를 포함한 전체 데이터베이스의 모든 내용이 복사됩니다. 선택 해제할 경우 테이블의 구조만 복사됩니다.',
    'database.clone.server' => '대상 데이터베이스 서버',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => '기타...',
    'database.clone.database' => '대상 데이터베이스',
    'database.clone.newDatabase' => '이름이 있는 데이터베이스 만들기',
    'database.clone.existingDatabase' => '기존 데이터베이스에 복사',
    'database.clone.externalDbHost' => '호스트 이름 또는 IP 주소',
    'database.clone.externalDbLogin' => '사용자 이름',
    'database.clone.externalDbPassword' => '암호',
    'database.clone.subscription' => '대상 구독',
    'database.clone.subscription_powerUser' => '대상 웹 공간',
    'database.clone.cloneInProgress' => '데이터베이스 %%source%%를 데이터베이스 %%destination%%에 복제하는 중입니다. 이메일(%%email%%)로 진행 상황이 통보됩니다.',
    'database.clone.unableToClone' => '"%%source%%" 데이터베이스를 복사할 수 없습니다.',
    'database.clone.unableToCreateExternalDatabase' => '지정된 서버에서 "%%destination%%" 데이터베이스를 만들 수 없습니다.',
    'database.clone.databaseCloned' => '"%%source%%" 데이터베이스가 복사 되었습니다.',
    'database.clone.emailSubjSuccess' => '데이터베이스 %%sourceDatabase%%이(가) 복사되었습니다.',
    'database.clone.emailSubjFailure' => '데이터베이스 %%sourceDatabase%%를 복사하지 못했습니다.',
    'database.clone.emailBodySuccess' => '데이터베이스 %%sourceDatabase%%(%%sourceHost%%)이(가) 데이터베이스 %%destDatabase%%(%%destHost%%)에 복사되었습니다.',
    'database.clone.emailBodyFailure' => '데이터베이스 %%sourceDatabase%%(%%sourceHost%%)를 데이터베이스 %%destDatabase%%(%%destHost%%)에 복사할 수 없습니다. 복사 절차가 실패했습니다.',
    'database.clone.localServer' => '로컬 서버',

    'database.repair-orphaned.formDescription' => '복원 프로세스가 끝나면 이 사용자는 분리됩니다. 이 문제를 해결하려면 이 사용자의 암호를 입력하십시오. 이 사용자가 암호가 없는 sys user인 경우, 암호 필드를 비워두고 복구 유틸리티를 실행합니다.',
    'database.repair-orphaned.login' => '데이터베이스 사용자 이름',
    'database.repair-orphaned.pass' => '암호',
    'database.repair-orphaned.pass2' => '암호 확인',
    'database.repair-orphaned.users' => '일부 사용자에 주의가 필요합니다. 여러 분리된 사용자를 복구해야 올바르게 작동합니다.',
    'database.repair-orphaned.orphaned' => '사용자가 분리되었습니다. %%gui begin:link%%지금 복구합니다%%gui end:link%%.',
    'database.repair-orphaned.repair' => '복구',

    'database.repair.fixSelected' => '선택된 복구',
    'database.repair.fix' => '복구',

    'database.user.password' => '암호',
    'database.user.passwordConfirmation' => '암호 확인',
    'database.user.server' => '데이터베이스 서버',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => '데이터베이스',
    'database.user.anyDatabase' => '모두',
    'database.user.dataAccess' => '데이터 액세스',
    'database.user.structureAccess' => '구조 액세스',
    'database.user.globalAccess' => '전역 권한',
    'database.user.globalAccessHint' => '전역 권한이 이 호스팅 계정 내의 모든 데이터베이스에 적합합니다.',
    'database.user.aclRadio' => '액세스 제어',
    'database.user.aclLocalhost' => '로컬 연결만 허용',
    'database.user.aclAny' => '모든 호스트로부터 원격 연결 허용',
    'database.user.aclCustom' => '다음으로부터 원격 연결 허용',
    'database.user.aclExample' => "thomas.loc.gov \n%.loc.gov \nx.y.% \n144.155.166.177 \n144.155.166.% \n144.155.166.0/255.255.255.0 \n\n지정된 호스트는 이 사용자를 대신하여 데이터베이스에 액세스가 허용되었습니다.",
    'database.user.remoteAccess' => '원격 액세스',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n지정된 IP 주소는 이 사용자를 대신하여 데이터베이스 액세스가 허용되었습니다. 이 목록에 대한 변경은 호스팅 공급자에 의해 사전 조정됩니다.",
    'database.user.example' => "예: \n%%example%%",
    'database.user.denied' => '시스템 방화벽 규칙 사용',
    'database.user.allowed' => '다음으로부터 원격 연결 허용',
    'database.user.default' => '이 사용자\\의 자격 증명을 기본적으로 %%webadmin%%에 액세스하는 데 사용합니다',
    'database.user.remoteAccessHint' => '호스팅 공급자에게 연락하고 위에서 지정한 옵션이 MySQL에 대한 수신 액세스에 현재 지정된 방화벽 규칙을 준수하는지 확인하십시오.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => '웹 관리',
    'database.user.role' => '역할',
    'database.user.roleReadWrite' => '읽기 및 쓰기',
    'database.user.roleWriteOnly' => '쓰기 전용',
    'database.user.roleReadOnly' => '읽기 전용',
    'database.user.roleCustom' => '사용자 지정',

    'database.generalSection' => '일반',
    'database.name' => '데이터베이스 이름',
    'database.server' => '데이터베이스 서버',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => '관련 사이트',
    'database.noDomainRelations' => '관련 사이트 없음',
    'database.userSection' => '사용자',
    'database.userSectionDescription' => '기본 데이터베이스 사용자를 생성합니다. Plesk가 이 사용자 대신 데이터베이스에 액세스합니다. 데이터베이스 사용자가 데이터베이스에 할당되어 있지 않으면 액세스가 불가능합니다.',
    'database.createUser' => '데이터베이스 사용자 생성',
    'database.username' => '데이터베이스 사용자 이름',
    'database.password' => '암호',
    'database.passwordConfirmation' => '암호 확인',
    'database.allDbAccess' => '사용자는 선택한 구독에 존재하는 모든 데이터베이스에 대한 액세스 권한을 가집니다.',
    'database.aclRadio' => '액세스 제어',
    'database.aclLocalhost' => '로컬 연결만 허용',
    'database.aclAny' => '모든 호스트로부터 원격 연결 허용',
    'database.aclCustom' => '다음으로부터 원격 연결 허용',
    'database.aclExample' => "thomas.loc.gov \n%.loc.gov \nx.y.% \n144.155.166.177 \n144.155.166.% \n144.155.166.0/255.255.255.0 \n\n지정된 호스트는 이 사용자를 대신하여 데이터베이스에 액세스가 허용되었습니다.",
    'database.remoteAccess' => '원격 액세스',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\n지정된 IP 주소는 이 사용자를 대신하여 데이터베이스 액세스가 허용되었습니다. 이 목록에 대한 변경은 호스팅 공급자에 의해 사전 조정됩니다.",
    'database.example' => "예: \n%%example%%",
    'database.denied' => '시스템 방화벽 규칙 사용',
    'database.allowed' => '다음으로부터 원격 연결 허용',

    'deployment-section.deploymentDisabledHint' => 'Git 리포지토리에서 파일 업로드',
    'deployment-section.deploymentEnabledHint' => 'Git 지원 활성화',
    'deployment-section.deploymentSectionLegend' => '호스팅에 파일 복사',
    'deployment-section.deploymentSectionDescriptionHint' => 'Git 지원을 비활성화 상태로 유지하면 루트 디렉터리(웹 사이트/응용 프로그램 루트 및 문서 루트)가 빈 상태로 생성되며 사이트는 브라우저의 기본 페이지를 표시합니다. FTP 또는 File Manager를 사용하여 문서 루트에 사이트의 파일을 업로드해야 합니다. 아니면, 지금 또는 나중에 Git를 활성화하고(웹 사이트 및 도메인에서) Git 리포지토리에서 파일을 업로드하십시오.',

    'dns-zone.add-acl-record.description' => 'DNS 영역의 사본을 수신할 수 있도록 DNS 서버의 IP 주소를 추가합니다.',
    'dns-zone.add-acl-record.ipAddress' => 'IP 주소',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP 주소/마스크',

    'dns-zone.record.type' => "레코드 유형",
    'dns-zone.record.domainName' => "도메인 이름",
    'dns-zone.record.nameServer' => "이름 서버",
    'dns-zone.record.protocol' => "프로토콜",
    'dns-zone.record.priority' => "우선 순위",
    'dns-zone.record.priorityLow' => "낮음(%%priority%%)",
    'dns-zone.record.priorityHigh' => "매우 높음(%%priority%%)",
    'dns-zone.record.weightLow' => "낮음(%%weight%%)",
    'dns-zone.record.weightHigh' => "매우 높음(%%weight%%)",
    'dns-zone.record.ipAddress' => "IP 주소",
    'dns-zone.record.ipAddressDescription' => "예를 들어, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 주소",
    'dns-zone.record.ipAddressV6Description' => "예를 들어, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "예: 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "예: 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "정식 이름",
    'dns-zone.record.mailDomain' => "메일 도메인",
    'dns-zone.record.mxServer' => "메일 Exchange Server",
    'dns-zone.record.mxServerPriority' => "메일 Exchange Server의 우선 순위 지정",
    'dns-zone.record.txtRecord' => "TXT 레코드",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "TXT 레코드에 대해 잘못된 값이 지정되었습니다.",
    'dns-zone.record.dsRecord' => "DS 레코드",
    'dns-zone.record.dsRecordDescription' => "예: 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "DS 레코드에 대해 잘못된 값이 지정되었습니다.",
    'dns-zone.record.serviceName' => "서비스 이름",
    'dns-zone.record.serviceNameDescription' => "예: SIP",
    'dns-zone.record.srvWeight' => "우선 순위가 같은 레코드의 상대 가중치",
    'dns-zone.record.targetHost' => "대상 호스트",
    'dns-zone.record.targetHostDescription' => "예: example.com",
    'dns-zone.record.targetPort' => "대상 포트",
    'dns-zone.record.retrieveDataError' => "레코드 데이터를 찾을 수 없습니다.",
    'dns-zone.record.unknownTypeError' => "알 수 없는 DNS 레코드 유형.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => '다른 NULL MX 레코드가 있는 상태에서 NULL MX 레코드를 설정할 수 없습니다.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'NULL MX 레코드가 있는 상태에서 비-NULL MX 레코드를 설정할 수 없습니다.',
    'dns-zone.record.masterShouldBeRemote' => "별도의 호스트에 서로 다른 두 개의 권한 이름이 있어야 합니다.",
    'dns-zone.record.caaTag' => "태그",
    'dns-zone.record.caaRecord' => "값",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.invalidValue' => '값이 잘못되었습니다. 이 값은 1초 ~ 2147483647초 범위일 수 있습니다.',
    'dns-zone.record.ttlDefaultValue' => '기본값: %%value%% 초',

    'dns-zone.restore-default.formHint' => "여기서 서버에 사용되는 기본 DNS 템플릿 설정에 따라 원래의 영역 구성을 복원할 수 있습니다. 영역 복원에 사용할 IP 주소를 선택하고 도메인에 www 별칭이 필요한지 여부를 지정합니다.",
    'dns-zone.restore-default.ipv4' => "IPv4 주소",
    'dns-zone.restore-default.ipv4Hint' => "예를 들어, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 주소",
    'dns-zone.restore-default.ipv6Hint' => "예를 들어, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => '잘못된 IP 주소를 지정했습니다.',
    'dns-zone.restore-default.customIpHint' => "이 IP 주소의 레코드는 사용자가 수정한 것으로 간주되며 서버 전체 DNS 템플릿과 동기화되지 않습니다.",
    'dns-zone.restore-default.wwwPrefix' => "www 접두사",
    'dns-zone.restore-default.previewRecords' => "사이트 미리 보기에 사용된 기록 복원",

    'dns-zone.soa-record.soaMnameSection' => '기본 이름 서버',
    'dns-zone.soa-record.soaMname' => '이름 서버',
    'dns-zone.soa-record.soaMnameAutoselect' => '(자동 선택)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA 레코드',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => '새로 고침',
    'dns-zone.soa-record.retry' => '다시 시도',
    'dns-zone.soa-record.expire' => '만료',
    'dns-zone.soa-record.minimum' => '최소',
    'dns-zone.soa-record.rnameType' => '이메일(RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => '도메인의 DNS 영역을 책임지는 사람의 이메일 주소. SOA 쿼리에 응답할 때 DNS 서버에서 반환되었습니다.',
    'dns-zone.soa-record.rnameTypeOwner' => '웹 사이트 소유자의 이메일 주소',
    'dns-zone.soa-record.rnameTypeDomain' => '도메인 이메일 주소',
    'dns-zone.soa-record.rnameTypeDomainHint' => '로컬 부분만 입력하십시오 (@<domain> 앞)',
    'dns-zone.soa-record.rnameTypeExternal' => '외부 이메일 주소',
    'dns-zone.soa-record.invalidValue' => '값이 잘못되었습니다. 이 값은 1초 ~ 68년 범위일 수 있습니다.',
    'dns-zone.soa-record.advancedSection' => '고급 DNS 기능',
    'dns-zone.soa-record.serialNumberFormat' => 'IETF 및 RIPE에서 권장하는 일련 번호 형식을 사용하십시오',
    'dns-zone.soa-record.serialNumberFormatHint' => '도메인에 등록 대행자의 SOA 검사를 통과하는 데 문제가 있을 경우 옵션을 선택하십시오. 많은 도메인 등록 대행자는 이 일련 번호 형식을 요구합니다.',
    'dns-zone.soa-record.restoreDefaultButton' => '기본 설정 사용',
    'dns-zone.soa-record.zoneDefaultsSection' => '영역 기본값',
    'dns-zone.soa-record.unitSeconds' => '초',
    'dns-zone.soa-record.unitMinutes' => '분',
    'dns-zone.soa-record.unitHours' => '시간',
    'dns-zone.soa-record.unitDays' => '일',
    'dns-zone.soa-record.unitWeeks' => '주',

    'domain-info-section.domainName' => '도메인 이름',
    'domain-info-section.emptyDomainName' => '도메인 이름을 입력하십시오.',
    'domain-info-section.ipAddress' => 'IP 주소',
    'domain-info-section.shared' => '공유',
    'domain-info-section.exclusive' => '전용',
    'domain-info-section.ipAddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다. 이 IP 주소는 구독 내 만들어진 모든 웹 사이트에 사용됩니다.",
    'domain-info-section.ipAddressHint_powerUser' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다. 이 IP 주소는 웹 공간 내 만들어진 모든 웹 사이트에 사용됩니다.",
    'domain-info-section.userName' => '사용자 이름',
    'domain-info-section.userNameHint' => '웹 공간과 연관된 시스템 사용자 계정, FTP 및 SSH를 통해 호스팅된 파일에 액세스하는 데 사용됨.',
    'domain-info-section.emptyLogin' => '사용자 이름을 입력하십시오.',
    'domain-info-section.password' => '암호',
    'domain-info-section.emptyPassword' => '암호를 입력하십시오.',
    'domain-info-section.passwordConfirmation' => '암호 반복',

    'email-address.generalTab' => '일반',
    'email-address.generalHint' => '이 이메일 계정을 추가 사용자와 연결하면(고객 패널에 대한 액세스 활성화) 이 페이지에서 수행한 변경 사항이 해당 사용자의 설정에 적용됩니다. 특히 이메일 주소와 암호를 변경할 경우, 추가 사용자의 로그인 및 암호도 새 값으로 변경됩니다.',
    'email-address.redirectTab' => '전달',
    'email-address.redirectHint' => '하나 이상의 이메일 주소로 이메일 메시지 전달을 설정합니다.',
    'email-address.aliasesTab' => '이메일 별칭',
    'email-address.autoResponderTab' => '자동 회신',
    'email-address.antispamTab' => '스팸 필터',
    'email-address.autoResponderHint' => '자신의 이메일 주소로 발송된 메일 메시지에 대한 자동 응답을 설정합니다. 자동 회신은 부재 중이거나 휴가 중인 경우에 이를 상대방에게 알려주는 일반적인 방법입니다.',
    'email-address.antivirusTab' => '안티 바이러스',
    'email-address.name' => '이메일 주소',
    'email-address.externalEmail' => '외부 이메일 주소',
    'email-address.externalEmailHint' => '기본 이메일 주소에 액세스할 수 없는 경우 암호를 재설정하는 데 사용됩니다.',
    'email-address.user' => '할당 대상',
    'email-address.password' => '암호',
    'email-address.passwordConfirmation' => '암호 확인',
    'email-address.responderEnable' => '자동 회신 설정',
    'email-address.responderSubject' => '자동 회신 메시지 제목',
    'email-address.responderContentType' => '메시지 형식',
    'email-address.responderContentTypeHint' => '일반 텍스트 형식은 모든 메일 클라이언트 프로그램에서 지원됩니다. 따라서 모든 수신자에게 발신자와 마찬가지로 메시지가 표시됩니다. HTML 메시지는 다른 글꼴 스타일로 서식이 지정된 텍스트를 입력할 수 있기 때문에 보기가 좋습니다. 단, 메일 클라이언트에 따라 HTML 메시지를 지원하지 않을 수 있으므로 일부 수신자에게는 서식이 지정된 텍스트가 표시되지 않을 수 있습니다.',
    'email-address.responderContentTypeTextPlain' => '일반 텍스트',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => '인코딩',
    'email-address.responderCodepageHint' => '인코딩은 텍스트 문자 표시 방법을 정의합니다. 권장 인코딩은 UTF-8입니다.',
    'email-address.responderReplyTo' => '전달 대상',
    'email-address.responderReplyToHint' => '자동 응답이 발송되는 경우, 원본 메시지가 지정된 이메일 주소로 전달됩니다.',
    'email-address.responderForwardAddress' => '전달 대상',
    'email-address.responderForwardAddressHint' => '자동 응답이 발송되는 경우, 원본 메시지가 지정된 이메일 주소로 전달됩니다.',
    'email-address.responderMessage' => '자동 회신 메시지 텍스트',
    'email-address.responderReplyToEqualsEmail' => '지정된 전달 주소가 이 이메일 주소와 같습니다.',
    'email-address.responderForwardAddressEqualsEmail' => '지정된 전달 주소가 이 이메일 주소와 같습니다.',
    'email-address.responderReplyLimit' => '고유 이메일 주소로 자동 응답 보내기 횟수 제한(하루당 횟수)',
    'email-address.buttonAddResponderAttachment' => '첨부 파일 추가',
    'email-address.buttonRemoveResponderAttachment' => '제거',
    'email-address.responderAttachment' => '파일 첨부',
    'email-address.redirectEnable' => '메일 전달 설정',
    'email-address.redirectRemoveEnable' => '전달된 이메일의 사본을 Plesk 사서함으로 배달하지 마십시오',
    'email-address.redirectAddress' => '다음 이메일 주소로 수신 메시지 전달',
    'email-address.redirectAddressHint' => '이메일 주소를 지정하십시오. 각 주소를 새 라인에 입력하거나 공백, 쉼표 및 세미콜론으로 구분하여 입력할 수 있습니다.',
    'email-address.role' => '사용자 역할',
    'email-address.roleHint' => '사용자 역할은 역할에 대한 선택된 응용 프로그램에 대한 액세스 권한과 관리자 권한을 사용자에게 부여합니다.',
    'email-address.errorRedirectAddress' => '유효하지 않은 이메일 주소를 지정했습니다: %value%.',
    'email-address.errorRedirectAddressMultiple' => '유효하지 않은 이메일 주소를 지정했습니다: %value%.',
    'email-address.mailAlias' => "이메일 별칭",
    'email-address.mailAliasNone' => '없음',
    'email-address.mailAliasHint' => "이메일 별칭은 기본 이메일 주소와 연관된 대체 이메일 주소입니다. 이메일 별칭으로 발송된 모든 메일은 기본 이메일 주소에서 수신됩니다.",
    'email-address.buttonAddMailAlias' => '이메일 별칭 추가',
    'email-address.buttonRemoveMailAlias' => '제거',
    'email-address.emptyEmail' => '모든 수신 메시지를 전달할 이메일 주소를 지정합니다.',
    'email-address.emailsIsEqual' => '외부 이메일 주소가 기본 이메일 주소와 일치합니다. 다른 외부 이메일 주소를 지정하십시오.',
    'email-address.emptyPassword' => '암호를 제공해야 합니다.',
    'email-address.emptyPasswordConfirmation' => '암호를 확인해야 합니다.',
    'email-address.emptyAlias' => "이 이메일 주소의 이메일 별칭을 지정합니다.",
    'email-address.aliasEqualsEmail' => '이메일 주소와 동일한 이메일 별칭을 지정했습니다.',
    'email-address.passwordHint' => '사서함에 액세스하고 Plesk에 로그인할 때 사용됩니다(해당 옵션이 활성화된 경우).',
    'email-address.cyclicRedirect' => '자신에게 이메일 메시지를 전달하도록 이메일 주소를 설정할 수 없습니다.',
    'email-address.errorMailnameReserved' => '지정된 이메일 주소가 이미 사용 중입니다.',
    'email-address.antivirusEnable' => '이 이메일 주소에 대한 안티 바이러스 보호 설정',
    'email-address.antivirusHint' => '안티 바이러스 서비스가 바이러스가 포함된 이메일 메시지를 차단하고 발신자와 수신자 모두에게 이를 알려줍니다.',
    'email-address.antivirusSettings' => '바이러스 검사',
    'email-address.antivirusSettingOnlyIncomingMail' => '수신 메일만',
    'email-address.antivirusSettingOnlyOutgoingMail' => '발신 메일만',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => '수신 메일 및 발신 메일',
    'email-address.antispamHint' => '스팸 필터링 서비스는 이 이메일 주소로 발송된 스팸 메시지를 탐지합니다. 스팸 메시지를 삭제하거나, 해당 제목을 변경하여 스팸으로 표시하거나, IMAP를 통해 메일 클라이언트에서 액세스 가능한 특별한 스팸 폴더로 이동하도록 스팸 필터를 설정할 수 있습니다. 스팸 필터는 다양한 로컬 및 네트워크 테스트를 사용하여 스팸 시그니처를 식별합니다.',
    'email-address.antispamEnable' => '이 이메일 주소에 대한 스팸 필터링 설정',
    'email-address.antispamSettings' => '스팸으로 분류된 메시지 처리 방법',
    'email-address.antispamSettingsMark' => '메시지 제목에 다음 텍스트를 추가하여 스팸 메시지로 표시',
    'email-address.antispamSettingsMarkHint' => '어떤 텍스트도 추가하지 않으려면 이 필드를 비워두십시오. 메시지 제목에 점수를 포함시키려는 경우 Type _SCORE_.',
    'email-address.antispamReportTextHint' => '스팸 이메일 메시지 본문에 추가할 텍스트를 입력합니다.',
    'email-address.antispamSettingsDelete' => '모든 스팸 메시지 삭제',
    'email-address.antispamSettingsDeleteHint' => '스팸 메시지가 사서함에서 삭제됩니다.',
    'email-address.antispamSettingsMove' => '스팸 폴더로 스팸 이동',
    'email-address.antispamSettingsMoveHint' => '모든 스팸 메시지를 스팸 폴더로 이동합니다. 이 폴더는 메일 클라이언트 프로그램 또는 웹 메일에서 액세스할 수 있습니다. IMAP 메일 계정을 사용하는 경우, 스팸 폴더를 사용하여 스팸 필터를 교육할 수 있습니다.',
    'email-address.antispamSettingsMoveWarning' => '"전달" 탭에서 "전달된 이메일의 사본을 배달하지 않음" 옵션을 비활성화하지 않으면 "스팸 폴더로 스팸 이동"이 작동하지 않습니다.',
    'email-address.antispamSettingsMoveJunk' => '스팸을 "정크 이메일" 폴더로 이동',
    'email-address.antispamSettingsMoveJunkHint' => '모든 스팸 메시지를 "정크 이메일" 폴더로 이동합니다. 이 폴더는 메일 클라이언트 프로그램 또는 웹 메일에서 액세스할 수 있습니다. IMAP 메일 계정을 사용하는 경우, "정크 이메일" 폴더를 사용하여 스팸 필터를 교육할 수 있습니다.',
    'email-address.antispamShowAdvancedSection' => '고급 설정 표시',
    'email-address.antispamHideAdvancedSection' => '고급 설정 숨기기',
    'email-address.antispamLearnMore' => '스팸 필터 교육 방법에 대해 알아봅니다.',
    'email-address.antispamFilterScoreTitle' => '필터 민감도',
    'email-address.antispamFilterScoreHint' => '스팸 필터는 각 메시지의 내용과 제목줄에 다양한 테스트를 수행합니다. 이에 따라 각각의 메시지에 점수가 매겨집니다. 점수가 높을수록 메시지가 스팸일 가능성이 높아집니다. 점수가 7점 이상인 모든 메시지를 스팸으로 분류하도록 필터 민감도가 기본 설정되어 있습니다. 현재 설정으로 많은 수의 스팸 메시지가 수신되어 필터 민감도를 높이려면 낮은 값(예: 6)을 설정합니다. 스팸 필터가 정크로 판단하여 이메일이 누락되면 높은 값(예: 8)을 설정하여 필터 민감도를 낮출 수 있습니다.',
    'email-address.antispamFilterScore' => '스팸 필터 민감도',
    'email-address.antispamWhiteListTitle' => '허용 목록',
    'email-address.antispamWhiteListHint' => '허용 목록에 있는 발신자가 보낸 이메일은 스팸 필터에서 검사하지 않습니다.',
    'email-address.antispamWhiteListField' => '허용 목록',
    'email-address.antispamWhiteListFieldHint' => '라인당 하나씩 도메인 이름을 입력합니다. 주소에는 *" 및 ?의 와일드카드 문자가 포함될 수 있습니다(예: *@domain.com, user?@*.com).',
    'email-address.antispamBlackListTitle' => '차단 목록',
    'email-address.antispamBlackListHint' => '금지 목록에 있는 발신자가 보낸 이메일은 스팸으로 분류됩니다.',
    'email-address.antispamBlackListField' => '차단 목록',
    'email-address.antispamBlackListFieldHint' => '라인당 도메인 하나씩 도메인 이름을 입력합니다. 주소에는 *" 및 ?의 와일드카드 문자가 포함될 수 있습니다(예: *@domain.com, user?@*.com).',
    'email-address.antispamTrustedLanguagesTitle' => '신뢰할 수 있는 언어',
    'email-address.antispamTrustedLanguagesHint' => '이러한 언어로 기록된 이메일 메시지가 항상 필터를 통과합니다.',
    'email-address.antispamTrustedLocalesTitle' => '신뢰할 수 있는 로캘',
    'email-address.antispamTrustedLocalesHint' => '지정한 로캘 그룹을 사용하는 이메일 메시지가 항상 필터를 통과합니다. 로캘 그룹에는 일반적으로 사용되는 문자 집합이 포함됩니다. 예를 들어 영어 문자 집합에는 영어 및 서유럽 언어에서 사용되는 문자 인코딩이 포함됩니다.',
    'email-address.antispamTrustedNetworksTitle' => '신뢰할 수 있는 네트워크',
    'email-address.antispamTrustedNetworksHint' => '신뢰할 수 있는 네트워크의 릴레이 호스트는 스팸 발송자가 작동하지 않는 것으로 간주되며, 공개 릴레이 또는 공개 프록시가 아닙니다.',
    'email-address.antispamIpAddressesField' => 'IP 주소',
    'email-address.antispamIpAddressesFieldHint' => '네트워크 IP 주소 및 마스크를 지정합니다.',
    'email-address.mailBoxQuotaDomainDefault' => '기본 크기(%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => '기본 크기',
    'email-address.mailBoxOutgoingMessages' => '나가는 이메일 메시지의 최대 수',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => '기본값(시간당 %%domainOutgoingMessages%% 메시지)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => '사서함에 대한 사용자 지정 값',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => '메시지',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => '기본값',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => '기본 크기',
    'email-address.mailBoxQuotaDomainSpecific' => '다른 크기',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => '사서함 크기',
    'email-address.mailBoxQuotaUnlimited' => '무제한',
    'email-address.mailBoxLimitReached' => '사서함 수 제한에 도달했습니다.',
    'email-address.postboxEnabled' => '사서함',
    'email-address.postboxEnabledYes' => '켜기',
    'email-address.postboxEnabledNo' => '끄기',
    'email-address.description' => 'Plesk의 설명',
    'email-address.descriptionHint' => '이 이메일 계정에 액세스하는 모든 사용자에게 설명이 표시됩니다.',
    'email-address.longDescription' => '지정한 설명이 너무 깁니다. 길이는 %%max%% 기호를 초과할 수 없습니다.',
    'email-address.loginAsUser' => 'Plesk에 로그인할 때 사용할 수 있습니다.',
    'email-address.loginAsUserDescription' => '(사용자 이름: %%username%%)',
    'email-address.maxCustomSizeDesc' => '사서함 크기는 기본 크기를 초과할 수 없습니다.',
    'email-address.endDateEnable' => '자동 회신 설정 끄기',

    'failed-request.enable-tracing.description' => '실패한 요청 추적은 리소스 집약적인 작업입니다. 추적은 %%days%%일 내에 자동으로 중지됩니다. 언제든시 수동으로 중지할 수 있습니다.',
    'failed-request.enable-tracing.statusCodes' => '상태 코드',
    'failed-request.enable-tracing.statusCodesDescription' => '예: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => '공급자',

    'file-manager.show.buttonReload' => '재로드',
    'file-manager.show.buttonSave' => '저장',
    'file-manager.show.buttonSaveAs' => '다른 이름으로 저장',
    'file-manager.show.buttonReset' => '재설정',
    'file-manager.show.buttonTextCodeEditor' => '코드 편집기에서 편집',
    'file-manager.show.buttonTextEdit' => '텍스트 편집기에서 편집',
    'file-manager.show.buttonWysiwygEdit' => 'HTML 편집기에서 편집',
    'file-manager.show.eolLabel' => '줄 바꿈 유형:',
    'file-manager.show.saveAs' => '다른 이름으로 저장:',
    'file-manager.show.saveCodepage' => '다음 인코딩으로 저장:',
    'file-manager.show.loadCodepage' => '다음 인코딩으로 원본 파일 보기:',
    'file-manager.show.loadCodepageHint' => '경고: 파일을 다시 로드하면 저장되지 않은 모든 변경 내용을 잃게 됩니다.',
    'file-manager.show.fileExists' => "파일 또는 폴더 %%fileName%%이(가) 이미 있습니다. 같은 이름의 폴더 및 파일을 사용할 수 없습니다.",
    'file-manager.show.popupTitle' => '다른 이름으로 저장',
    'file-manager.show.popupFilename' => '파일 이름:',

    'file-manager.permissions.filePermissions' => '파일 권한',
    'file-manager.permissions.directoryPermissions' => '디렉터리 권한',
    'file-manager.permissions.buttonSubmit' => '저장',
    'file-manager.permissions.buttonApply' => '저장하고 다시 시작',
    'file-manager.permissions.buttonCancel' => '취소',
    'file-manager.permissions.buttonAdvanced' => '고급',

    'file-manager.unix-file-permissions.group' => '그룹',
    'file-manager.unix-file-permissions.owner' => '소유자',
    'file-manager.unix-file-permissions.others' => '기타',
    'file-manager.unix-file-permissions.readMode' => '읽기',
    'file-manager.unix-file-permissions.writeMode' => '쓰기',
    'file-manager.unix-file-permissions.execMode' => '실행/검색',
    'file-manager.unix-file-permissions.changeRecursive' => '재귀 권한 변경',

    'file-manager.windows-permissions.allow' => '허용',
    'file-manager.windows-permissions.deny' => '거부',
    'file-manager.windows-permissions.inheritFromParent' => '상위 개체의 상속 가능한 권한이 이 개체와 모든 하위 개체에 전파되도록 허용합니다. 여기에 명시적으로 정의된 항목을 함께 포함합니다.',
    'file-manager.windows-permissions.replaceOnChildren' => '모든 하위 개체에 대한 권한 항목을 여기에 표시된 항목으로 대체합니다.',
    'file-manager.windows-permissions.buttonAdvanced' => '고급',
    'file-manager.windows-permissions.applyTo' => '적용 대상:',
    'file-manager.windows-permissions.folderOnly' => '이 폴더만',
    'file-manager.windows-permissions.subfolderOnly' => '하위 폴더만',
    'file-manager.windows-permissions.filesOnly' => '파일만',
    'file-manager.windows-permissions.permissionsFor' => '다음에 대한 권한',
    'file-manager.windows-permissions.applyOnto1' => '이 폴더만',
    'file-manager.windows-permissions.applyOnto2' => '하위 폴더만',
    'file-manager.windows-permissions.applyOnto3' => '이 폴더와 하위 폴더',
    'file-manager.windows-permissions.applyOnto4' => '파일만',
    'file-manager.windows-permissions.applyOnto5' => '이 폴더와 파일',
    'file-manager.windows-permissions.applyOnto6' => '하위 폴더와 파일만',
    'file-manager.windows-permissions.applyOnto7' => '이 폴더, 하위 폴더 및 파일',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => '텍스트 편집기',
    'file-manager.editor.titleCodeEditor' => '코드 편집기',
    'file-manager.editor.titleCodeViewer' => '보기',
    'file-manager.editor.buttonSubmit' => '저장',
    'file-manager.editor.buttonApply' => '저장하고 다시 시작',
    'file-manager.editor.buttonSaveAs' => '다른 이름으로 저장 ...',
    'file-manager.editor.buttonCancel' => '취소',
    'file-manager.editor.exitConfirmationYes' => '예',
    'file-manager.editor.exitConfirmationNo' => '아니오',
    'file-manager.editor.fileOverwrite' => '파일이 이미 있습니다.',
    'file-manager.editor.fileOverwriteDescription' => '같은 이름의 파일이 이미 있습니다. 덮어쓰시겠습니까?',
    'file-manager.editor.exitConfirmation' => '저장하지 않은 파일을 닫고 변경 사항을 삭제하시겠습니까?',
    'file-manager.editor.buttonCodeEditor' => '코드 편집기에서 편집',
    'file-manager.editor.buttonTextEditor' => '텍스트 편집기에서 편집',
    'file-manager.editor.buttonHtmlEditor' => 'HTML 편집기에서 편집',

    'file-manager.import-file.buttonSubmit' => '가져오기',
    'file-manager.import-file.fieldUrl' => '파일 URL',
    'file-manager.import-file.fieldUrlDescription' => '소스 URL을 명시하십시오. 예를 들면, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => '전체 URL 패턴은 \'https://user:password@example.com/example.tgz\'입니다. 사용자 이름과 패스워드는 선택 사항입니다. 지원되는 프로토콜은 http, https, ftp, ftps입니다. 특수문자 또는 공백이 포함된 URL에는 URL 인코딩을 사용하십시오.',
    'file-manager.import-file.failure' => '파일을 임포트할 수 없습니다.',

    'file-manager.rotation-settings.title' => '휴지통 순환 설정',
    'file-manager.rotation-settings.rotationBySize' => '크기 기준으로 순환',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => '이 옵션은 휴지통에 지정된 제한을 초과하는 한 새 파일을 삭제합니다.',
    'file-manager.rotation-settings.rotationByDate' => '날짜 기준으로 순환',
    'file-manager.rotation-settings.rotationByDateUnits' => '일',
    'file-manager.rotation-settings.rotationByDateHint' => '이 옵션은 지정된 일수 이상 동안 휴지통에 저장된 파일을 삭제합니다.',

    'ftp-user.description' => '다른 사람과 함께 웹 사이트에서 작업하거나 다른 사용자를 위한 하위 도메인을 호스트하는 경우, 이들을 위한 별도 FTP 계정을 만드는 것이 좋습니다.',
    'ftp-user.generalSection' => '일반',
    'ftp-user.login' => 'FTP 계정 이름',
    'ftp-user.home' => '홈 디렉터리',
    'ftp-user.systemArea' => '홈 디렉터리 외부의 파일에 액세스할 수 있는 FTP 계정을 생성합니다',
    'ftp-user.password' => '암호',
    'ftp-user.passwordConfirmation' => '암호 확인',
    'ftp-user.hardQuotaSection' => '하드 디스크 할당량',
    'ftp-user.hardQuota' => '하드 디스크 할당량',
    'ftp-user.hardQuotaUnlimited' => '제한 없음',
    'ftp-user.permissionsSection' => '권한',
    'ftp-user.permissionRead' => '읽기 권한',
    'ftp-user.permissionWrite' => '쓰기 권한',
    'ftp-user.popupTitle' => '디렉터리 선택',

    'mail-list.listName' => '메일링 리스트 주소',
    'mail-list.enabled' => '켜짐',
    'mail-list.administratorEmail' => '메일링 리스트 관리자의 이메일',
    'mail-list.password' => '암호',
    'mail-list.passwordConfirmation' => '암호 확인',
    'mail-list.subscribers' => '구독자',
    'mail-list.subscribersHint' => '이메일 주소를 지정하십시오. 각 주소를 새 라인에 입력하거나 공백, 쉼표 및 세미콜론으로 구분하여 입력할 수 있습니다.',
    'mail-list.notify' => '메일링 리스트 생성 시 관리자에게 알림',
    'mail-list.emptyPassword' => '암호를 제공해야 합니다.',
    'mail-list.emptyPasswordConfirmation' => '암호를 확인하십시오.',
    'mail-list.errorSubscribers' => '유효하지 않은 이메일 주소를 지정했습니다: %value%.',
    'mail-list.errorMaillistReserved' => '지정한 메일링 리스트 주소가 이미 사용 중입니다.',

    'mail-settings.hint' => '여기서 이 도메인에 대한 메일 서비스 설정을 변경할 수 있습니다.',
    'mail-settings.service' => '이 도메인에서 메일 서비스 활성화',
    'mail-settings.nonExist' => '존재하지 않는 사용자에 대한 메일의 처리',
    'mail-settings.nonExistBounceWithMessage' => '메시지를 포함하여 바운스',
    'mail-settings.nonExistBounce' => '바운스',
    'mail-settings.nonExistCatch' => '주소로 전달',
    'mail-settings.nonExistCatchDescription' => '주소가 선택한 도메인에 속해야 합니다. 여러 도메인에 하나의 주소 또는 외부 주소를 지정하려면 관리자만 가능합니다.',
    'mail-settings.nonExistExternal' => 'IP 주소를 사용하여 외부 메일 서버로 리디렉션',
    'mail-settings.nonExistReject' => '거부',
    'mail-settings.nonExistDiscard' => '거부',
    'mail-settings.webmail' => '웹 메일',
    'mail-settings.webmailNone' => '없음',
    'mail-settings.webmailComponentNotInstalled' => '웹 메일 구성 요소가 설치되지 않았습니다.',
    'mail-settings.webmailSubdomainAlreadyExists' => '이름이 %%subdomain%%인 하위 도메인이 있습니다.',
    'mail-settings.webmailCertificate' => '웹 메일용 SSL/TLS 인증서',
    'mail-settings.webmailCertificateNone' => '선택되지 않음',
    'mail-settings.mailCertificate' => '메일용 SSL/TLS 인증서',
    'mail-settings.mailCertificateNone' => '선택되지 않음',
    'mail-settings.serverCertificateNotSelected' => '인증서가 할당되었지만 도메인의 메일이 안전하지 않습니다. 도메인에서 메일을 보호하는 것을 완료하려면 %%certLink%%.',
    'mail-settings.serverCertificatesList' => '메일 서버 보호',
    'mail-settings.mailLists' => '메일링 리스트 활성화',
    'mail-settings.mailAutodiscovery' => '메일 자동 검색 활성화',
    'mail-settings.mailAutodiscoveryDescription' => '%%link%%에서 작동하는 방법 확인',
    'mail-settings.mailAutodiscoveryDescriptionLink' => '기술 자료',
    'mail-settings.domainKeys' => 'DKIM 스팸 보호 시스템을 사용하여 발신 이메일 메시지에 서명',
    'mail-settings.greyListing' => '이 도메인의 모든 메일 계정에 대해 의심되는 스팸 방지 기능 설정',
    'mail-settings.howToConfigureExternalDns' => '외부 DNS를 구성하는 방법',
    'mail-settings.howToConfigureExternalDnsAlways' => '외부 DNS 서버를 사용하는 경우, DKIM 서명을 활성화하려면 DNS 서버에서  DKIM DNS 레코드를 직접 구성해야 합니다.',
    'mail-settings.howToConfigureExternalDnsEnabled' => '이렇게 하려면, 아래 DKIM DNS 레코드를 사용하세요.',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => '메일을 보내는 데 사용하는 도메인 별칭이 있는 경우, DKIM DNS 레코드도 추가합니다. 기본 도메인과 동일한 레코드를 사용하지만 도메인 별칭 이름을 사용합니다.',
    'mail-settings.howToConfigureExternalDnsDisabled' => '구성해야 하는 DKIM DNS 레코드를 보려면 "%%option%%" 확인란을 선택하고 적용한 다음 팝업을 다시 엽니다.',

    'role.roleSection' => '일반',
    'role.name' => '사용자 역할 이름',
    'role.description' => '설명',
    'role.generalPermissionsSection' => 'Plesk 서비스에 액세스',
    'role.applicationsAccessSection' => '응용 프로그램에 액세스',
    'role.permissionAllow' => '허가됨',
    'role.permissionDeny' => '거부됨',
    'role.emptyRoleName' => '역할 이름을 입력하십시오.',
    'role.installedAt' => '설치 위치',
    'role.noInstallationUrlAvailable' => '외부 응용 프로그램',
    'role.invalidRoleName' => '잘못된 사용자 역할 이름을 지정했습니다. 역할 이름에 물음표와 인용 부호를 사용할 수 없습니다.',
    'role.longRoleName' => '지정한 역할 이름이 너무 깁니다.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => '다음 이유로 인해 일부 작업을 수행할 수 없습니다. 현재 선택한 구독에 작업 권한이 부여되지 않았거나 할당된 리소스 양이 작업을 수행하기에 부족합니다.',
    'role.servicesPermissionsDescription' => '설치된 응용 프로그램 또는 Plesk 서비스에 대한 이 역할의 모든 사용자 액세스를 정의합니다. 응용 프로그램에 대한 사용자 액세스 권한을 부여하면 해당 응용 프로그램이 고객 패널에 제공됩니다.',
    'role.emailActivation' => '이 역할의 계정을 이메일로 활성화',

    'service.admin-access.adminAccess' => '관리 액세스',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => '이러한 자격 증명은 이 응용 프로그램에 대한 관리자 액세스에 사용됩니다.',
    'service.admin-access.login' => '관리자 사용자 이름',
    'service.admin-access.password' => '관리자 암호',
    'service.admin-access.passwordConfirmation' => '암호 확인',

    'service.info.service-entry-point.availableAt' => '제공 위치',
    'service.info.service-entry-point.customize' => '바로 가기 사용자 지정',
    'service.info.service-entry-point.displayNameLabel' => '바로 가기 이름',
    'service.info.service-entry-point.displayNameDescription' => '이 바로 가기의 이름을 제공합니다. 이름은 바로 가기 아이콘 아래 표시됩니다. 바로 가기는 이 응용 프로그램에 대한 액세스 권한이 부여한 사용자의 내 서비스 페이지에 위치합니다.',
    'service.info.service-entry-point.descriptionLabel' => '바로 가기 설명',
    'service.info.service-entry-point.descriptionDescription' => '이 바로 가기에 대한 설명을 제공합니다. 마우스 커서를 바로 가기 위에 위치하면 설명이 도구 설명으로 표시됩니다.',
    'service.info.service-entry-point.iconLabel' => '바로 가기 아이콘을 선택하려면 클릭합니다.',
    'service.info.service-entry-point.iconCurrent' => '현재 아이콘',
    'service.info.service-entry-point.errorEmptyName' => '바로 가기 이름을 입력해야 합니다.',
    'service.info.service-entry-point.errorLongName' => '바로 가기 이름은 1 ~ 255자 사이여야 합니다.',
    'service.info.service-entry-point.errorLongDescription' => '바로 가기 설명은 0 ~ 255자 사이여야 합니다.',
    'service.info.service-entry-point.hiddenLabel' => '바로 가기 숨기기',
    'service.info.service-entry-point.hiddenDescription' => '이 바로 가기를 사용자에게 표시하지 않습니다.',

    'service.info.service-permission.assignedUser' => "이 사용자에게 관리자 액세스 권한 부여",
    'service.info.service-permission.assignedUserNone' => '사용자가 할당되지 않음',

    'shared-ssl.master-ssl.switchedOn' => '공유 SSL/TLS 설정',
    'shared-ssl.master-ssl.domainName' => '다른 사이트와 SSL/TLS 인증서를 공유할 사이트의 도메인 이름',
    'shared-ssl.master-ssl.none' => '없음',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'SSL/TLS 지원이 활성화된 도메인이 없어서 공유 SSL/TLS를 설정할 수 없습니다.',

    'user.email.email' => '이메일 주소',
    'user.email.emptyEmail' => '이메일 주소를 입력해야 합니다.',
    'user.email.internalEmailHint' => 'Plesk에서 새 이메일 주소를 만들거나 외부 이메일 주소를 사용하십시오.',
    'user.email.longInternalEmail' => '이메일 주소가 너무 깁니다.',
    'user.email.longInternalEmailMailboxAddressMailServer' => '이 메일 서버에 대한 이메일 주소의 사용자 이름 부분이 너무 깁니다. %%max%%개의 기호 이하의 사용자 이름을 지정하십시오.',
    'user.email.longInternalEmailFullAddressMailServer' => '이 메일 서버에 대한 이메일 주소가 너무 깁니다. %%max%%개의 기호 이하의 주소를 지정하십시오.',
    'user.email.externalEmail' => '외부 이메일 주소',
    'user.email.externalEmailHint' => '기본 이메일 주소에 액세스할 수 없는 경우 암호를 재설정하는 데 사용됩니다.',
    'user.email.emailsIsEqual' => '외부 이메일 주소가 기본 이메일 주소와 일치합니다. 다른 외부 이메일 주소를 지정하십시오.',
    'user.email.atLeastOneEmailShouldBeSet' => '내부 또는 외부 이메일 주소를 지정하십시오.',

    'user.profileSection' => '일반 정보',
    'user.contactName' => '연락처 이름',
    'user.email' => '이메일 주소',
    'user.role' => '사용자 역할',
    'user.accountSection' => 'Plesk 기본 설정',
    'user.login' => '사용자 이름',
    'user.password' => '암호',
    'user.buttonBack' => '뒤로',
    'user.generalTab' => '일반',
    'user.applicationsAccessSection' => '서비스',
    'user.generalPermissionsSection' => '권한',
    'user.contactsTab' => '연락처 세부 정보',
    'user.passwordConfirmation' => '암호 확인',
    'user.internalEmailPasswordChanged' => '비밀번호를 변경하면 내부 이메일 주소 비밀번호도 변경됩니다.',
    'user.emailName' => '이메일 주소',
    'user.emailType' => '이메일 유형',
    'user.companyName' => '회사 이름',
    'user.phone' => '전화 번호',
    'user.imNumber' => '인스턴트 메신저',
    'user.fax' => '팩스 번호',
    'user.address' => '주소',
    'user.city' => '도시',
    'user.state' => '주 또는 지방',
    'user.zip' => '우편 번호',
    'user.country' => '국가',
    'user.additionalInfo' => '추가 정보',
    'user.additionalInfoHint' => '일반 텍스트만: 모든 HTML 태그는 무시됩니다.',
    'user.language' => 'Plesk 언어',
    'user.buttonChangePassword' => '암호 변경',
    'user.permissionAllow' => '허가됨',
    'user.permissionDeny' => '거부됨',
    'user.permissionInherited' => '역할 기준으로 정의됨',
    'user.emptyContactName' => '연락처 이름을 입력해야 합니다.',
    'user.emptyLogin' => '사용자 이름을 입력해야 합니다.',
    'user.emptyPassword' => '암호를 제공해야 합니다.',
    'user.emptyPasswordConfirmation' => '암호를 확인해야 합니다.',
    'user.chooseDomainBoxTitle' => '다른 도메인 선택:',
    'user.userIsActive' => '사용자가 활성 상태입니다.',
    'user.userIsActiveHint' => '활성 사용자는 Plesk에 액세스할 수 있습니다.',
    'user.emailActivation' => '이메일로 계정 활성화',
    'user.emailHint' => '이 서버에 호스팅된 이메일 주소를 사용자에게 제공하려면 메일 탭으로 이동한 후 지정한 이메일 주소를 만들고 이 사용자와 연결합니다.',
    'user.emailContactHint' => '이 서버에 호스팅된 이메일 주소를 사용하려면 서비스 공급자에게 문의하십시오.',
    'user.personalEmailHint' => "이 사용자의 이메일 주소는 메일 탭에서 변경할 수 있습니다.",
    'user.externalMailRedirectHint' => '이 서버에 호스팅된 이메일 주소에 대해서만 전달을 활성화할 수 있습니다. 이메일 주소를 만들려면 ‘메일’ 탭으로 이동합니다.',
    'user.externalMailRedirectHint2' => '이 서버에 호스팅된 이메일 주소에 대해서만 전달을 활성화할 수 있습니다.',
    'user.externalMailAutoResponderHint' => '이 서버에 호스팅된 이메일 주소에 대해서만 자동 회신을 활성화할 수 있습니다. 이메일 주소를 만들려면 ‘메일’ 탭으로 이동합니다.',
    'user.externalMailAutoResponderHint2' => '이 서버에 호스팅된 이메일 주소에 대해서만 자동 회신을 활성화할 수 있습니다.',
    'user.roleHint' => '사용자 역할은 역할에 대한 선택된 응용 프로그램에 대한 액세스 권한과 관리자 권한을 사용자에게 부여합니다.',
    'user.cannotManageMail' => "메일 설정과 서비스를 관리할 권한이 없습니다.",
    'user.longCompanyName' => '지정한 회사 이름이 너무 깁니다.',
    'user.longPhone' => '지정한 전화 번호가 너무 깁니다.',
    'user.longFax' => '지정한 팩스 번호가 너무 깁니다.',
    'user.longAddress' => '지정한 주소가 너무 깁니다.',
    'user.longCity' => '지정한 도시 이름이 너무 깁니다.',
    'user.phoneRegexNotMatch' => '잘못된 전화 번호를 지정했습니다.',
    'user.faxRegexNotMatch' => '잘못된 팩스 번호를 지정했습니다:',
    'user.shortCity' => '지정한 도시 이름이 너무 짧습니다.',
    'user.limitSubscription' => '구독에 액세스',
    'user.limitSubscriptionHint' => '사용자가 지정된 구독에만 액세스하도록 허용합니다. 모두 값을 지정하면 호스팅 계정 내 모든 구독에 대한 액세스 권한이 사용자에게 부여됩니다.',
    'user.limitSubscriptionAll' => '모두',
    'user.deletedSubscription' => '제거된 구독',

    'web.add-domain-alias.title' => '도메인 별칭 추가',
    'web.add-domain-alias.createdSuccessfully' => "도메인 별칭 %%name%%이(가) 만들어졌습니다.",
    'web.add-domain-alias.domainAliasName' => '도메인 별칭 이름',
    'web.add-domain-alias.domainAliasNameHint' => '예: example.net',
    'web.add-domain-alias.forDomain' => '도메인용',
    'web.add-domain-alias.settingsSectionLegend' => '설정',
    'web.add-domain-alias.settingsDns' => 'DNS 영역을 기본 도메인과 동기화',
    'web.add-domain-alias.settingsMail' => '메일 서비스',
    'web.add-domain-alias.settingsWeb' => '웹 서비스',
    'web.add-domain-alias.settingsSeoRedirect' => 'HTTP 301 코드를 이용한 리디렉션',
    'web.add-domain-alias.settingsSeoRedirectHint' => '방문자가 별칭의 URL을 열면 기본 도메인의 URL로 리디렉션됩니다. Plesk는 검색 엔진에 친화적인 HTTP 301 리디렉션을 사용하므로 URL 사이에서 검색 엔진 순위가 분할되지 않습니다.',
    'web.add-domain-alias.settingsTomcat' => 'Java 웹 응용 프로그램',
    'web.add-domain-alias.invalidDomainGuid' => '잘못된 도메인',

    'web.add-domain.formTitle' => '새 도메인을 추가하고 있습니다',
    'web.add-domain.formRegistrationHint' => '%%link%%에서 새 도메인 이름을 등록할 수 있습니다.',
    'web.add-domain.portalLink' => '서비스 포털',
    'web.add-domain.domainName' => '도메인 이름',
    'web.add-domain.domainNameHint' => "예: example.com",
    'web.add-domain.assignToCustomer' => '이 도메인을 고객에게 할당',
    'web.add-domain.customer' => '고객 선택',
    'web.add-domain.createNewCustomer' => '새 고객 생성',
    'web.add-domain.selectExistingCustomer' => '기존 고객 선택:',
    'web.add-domain.customerContactInfoHint' => '고객 연락처 정보를 입력하십시오. 전화 번호와 주소와 같은 다른 모든 정보는 나중에 지정할 수 있습니다.',
    'web.add-domain.customerLoginInfoHint' => '고객 패널용 인증서',
    'web.add-domain.target' => '웹 공간',
    'web.add-domain.createNewTarget' => '새 구독 생성',
    'web.add-domain.createNewTarget_powerUser' => '새 작업 공간 생성',
    'web.add-domain.selectExistingTarget' => '기존 구독 선택:',
    'web.add-domain.selectExistingTarget_powerUser' => '기존 웹 공간 선택:',
    'web.add-domain.dns' => 'DNS 서비스를 활성화합니다.',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => '메일 서비스를 활성화합니다.',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => '구독 설정에서 도메인당 메일 관리 권한을 허용할 경우 작동합니다. 허용하지 않을 경우, 실제 메일 서비스 상태는 구독에서 가져오게 됩니다.',
    'web.add-domain.hostingManagementOptions' => '호스팅 유형',
    'web.add-domain.websiteHosting' => '웹 사이트 호스팅',
    'web.add-domain.websiteForwarding' => '전달',
    'web.add-domain.websiteNoHosting' => '호스팅 없음',
    'web.add-domain.hostingSettingsSectionLegend' => '호스팅 설정',
    'web.add-domain.domainCreatedSuccessfully' => '도메인 %%domainName%%이(가) 만들어졌습니다.',
    'web.add-domain.webspaceLegend' => '웹 공간 설정',
    'web.add-domain.addWhmWebsiteTitle' => '새 웹 사이트 추가 중',
    'web.add-domain.addWhmWebsiteHint' => "서버에서 웹 사이트의 호스팅을 선택할 수 있습니다.",
    'web.add-domain.selectWhmDomain' => '도메인 선택',
    'web.add-domain.customerLegend' => '고객 정보',
    'web.add-domain.credentials' => '시스템 사용자 자격 증명',
    'web.add-domain.credentialsHint' => 'FTP 및 SSH를 통해 호스팅된 파일에 엑세스하려면',
    'web.add-domain.credentialsHintWin' => 'FTP 및 RDP를 통해 호스팅된 파일에 액세스하려면',
    'web.add-domain.buttonAddDomain' => '도메인 추가',

    'web.add-subdomain.formTitle' => '새 하위 도메인 추가',
    'web.add-subdomain.formGeneralHint' => '하위 도메인은 웹 사이트의 서로 다른 섹션에 대한 인터넷 주소입니다. 하위 도메인은 주 도메인 이름과 접두사를 사용합니다. 예를 들어 도메인이 domain.com인 경우 하위 도메인이 store.domain.com일 수 있습니다.',
    'web.add-subdomain.formGeneralHintAdditional' => '이름 대신 *를 입력해도 와일드카드 하위 도메인을 생성할 수 있습니다. 브라우저에 입력하는 하위 도메인 이름에 관계없이 사이트 방문자가 이 하위 도메인으로 리디렉션됩니다.',
    'web.add-subdomain.subdomainName' => '하위 도메인 이름',
    'web.add-subdomain.subdomainNameHint' => '와일드카드 하위 도메인을 만들려면 *를 입력합니다.',
    'web.add-subdomain.forDomain' => '부모 도메인',
    'web.add-subdomain.subdomainCreatedSuccessfully' => '하위 도메인이 만들어졌습니다.',
    'web.add-subdomain.hostingSettingsSectionLegend' => '호스팅 설정',

    'web.change-hosting.formGeneralHint' => '이 서버에 웹 사이트를 호스팅하거나, 다른 웹 사이트로의 웹 전달을 설정하거나, 도메인 이름 아래 이메일 주소만 원하는 경우 도메인 DNS 영역을 설정(No hosting 옵션 사용)할 수 있습니다.',
    'web.change-hosting.changed' => '%%domainName%%에 대한 호스팅 유형이 성공적으로 변경되었습니다.',
    'web.change-hosting.hostingManagementOptions' => '호스팅 유형',
    'web.change-hosting.websiteHosting' => '웹 사이트 호스팅',
    'web.change-hosting.websiteForwarding' => '전달',
    'web.change-hosting.websiteNoHosting' => '웹 호스팅 없음',
    'web.change-hosting.hostingSettingsSectionLegend' => '호스팅 설정',
    'web.change-hosting.userName' => '사용자 이름',
    'web.change-hosting.userNameHint' => '구독 내에서 파일과 폴더를 관리하기 위한 시스템 사용자.',
    'web.change-hosting.userNameHint_powerUser' => '웹 공간 내에서 파일과 폴더를 관리하기 위한 시스템 사용자.',
    'web.change-hosting.emptyLogin' => '사용자 이름을 지정해야 합니다.',
    'web.change-hosting.password' => '암호',
    'web.change-hosting.emptyPassword' => '암호를 지정해야 합니다.',
    'web.change-hosting.passwordConfirmation' => '암호 확인',
    'web.change-hosting.warningInstalledApplications' => '사이트에 웹 응용 프로그램이 설치되어 있습니다. 호스팅 유형을 변경하면 이들 웹 응용 프로그램에 더 이상 액세스할 수 없게 됩니다.',
    'web.change-hosting.removeWebsiteHostingTitle' => '경고: 사이트의 콘텐츠가 삭제됩니다.',
    'web.change-hosting.removeWebsiteHostingDescription' => '웹 사이트의 호스팅 유형을 변경하시겠습니까?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => '다음 폴더와 전체 내용이 삭제됩니다.',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => '웹 스페이스 루트 폴더의 모든 내용이 삭제됩니다.',

    'web.change-status.changed' => '%%domainName%%에 대한 웹 사이트 상태가 성공적으로 변경되었습니다.',
    'web.change-status.statusManagementOptions' => '웹 사이트 상태',
    'web.change-status.statusDisabled' => '비활성화됨(이전에 일시 중지된 상태와 같음)',
    'web.change-status.statusSuspended' => '일시 중단됨',
    'web.change-status.statusActive' => '활성',
    'web.change-status.statusDisabledHint' => '웹 사이트가 더 이상 서버에서 호스팅되지 않으며 FTP 클라이언트 및 파일 관리자를 제외하고 사용할 수 없게 됩니다. 방문자는 서버\\의 기본 페이지를 보게 됩니다. 메일 서비스를 사용할 수 없게 됩니다.',
    'web.change-status.statusSuspendedHint' => '웹 사이트가 계속 서버에서 호스팅되지만, 방문자는 503 HTTP 코드로 리디렉션되어 사용자 지정 오류 문서 페이지로 이동됩니다. 메일 서비스를 계속 사용할 수 있습니다. 여기서 %%link%%할 수 있습니다.',
    'web.change-status.statusSuspendedHintNoLink' => '웹 사이트가 계속 서버에서 호스팅되지만, 방문자는 검색 엔진 친화적인 503 HTTP 코드로 리디렉션되어 사용자 지정 오류 문서 페이지로 이동됩니다. 메일 서비스를 계속 사용할 수 있습니다.',
    'web.change-status.error503PageLink' => '사용자 지정 오류 문서 편집',
    'web.change-status.statusActiveHint' => '웹 사이트가 평상시와 같이 작동합니다.',
    'web.change-status.notActivatedSuspended' => '호스트 공급자가 도메인 또는 웹 사이트 %%domainName%%를 일시 정지시켰기 때문에 이를 활성화시킬 수 없습니다.',
    'web.change-status.notActivatedDisabled' => '호스트 공급자가 도메인 또는 웹 사이트 %%domainName%%를 비활성화시켰기 때문에 이를 활성화시킬 수 없습니다.',

    'web.edit.formTitle' => '다음에 웹 호스팅 액세스 %%name%%',
    'web.edit.formGeneralHint' => '여기서 구독과 연관된 IP 주소를 보고 시스템 사용자의 사용자 이름과 암호를 변경할 수 있습니다.',
    'web.edit.formGeneralHint_powerUser' => '여기서 이 웹 공간과 연관된 IP 주소를 보고 시스템 사용자의 사용자 이름과 암호를 변경할 수 있습니다.',
    'web.edit.ipAddressesLegend' => 'IP 주소',
    'web.edit.ipAddresses' => 'IP 주소',
    'web.edit.certificateLegend' => '인증서',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (다른 사용자에 의해 소유됨)',
    'web.edit.userAccountLegend' => '시스템 사용자',
    'web.edit.systemUserHint' => '여기에서는 FTP 또는 파일 관리자로 구독 내에서 파일과 폴더를 관리하기 위해 사용되는 운영 시스템 사용자를 지정할 수 있습니다. 해당 권한이 부여되는 경우에는 SSH(Linux) 또는 RDP(Windows)에서 시스템 사용자를 사용하여 Plesk에 액세스할 수도 있습니다.',
    'web.edit.systemUserHint_powerUser' => '여기에서는 FTP 또는 파일 관리자로 구독 내에서 파일과 폴더를 관리하기 위해 사용되는 운영 시스템 사용자를 지정할 수 있습니다. 해당 권한이 부여되는 경우에는 SSH(Linux) 또는 RDP(Windows)에서 시스템 사용자를 사용하여 Plesk에 액세스할 수도 있습니다.',
    'web.edit.login' => '사용자 이름',
    'web.edit.emptyLogin' => '사용자 이름을 지정하십시오.',
    'web.edit.password' => '암호',
    'web.edit.passwordConfirmation' => '암호 확인',
    'web.edit.emptyPassword' => '암호를 지정하십시오.',
    'web.edit.emptyPasswordConfirmation' => '암호를 확인하십시오.',
    'web.edit.shellUnix' => "SSH를 통해 서버에 액세스",
    'web.edit.shellHintUnix' => "시스템 사용자 자격 증명을 사용하여 SSH를 통해 서버에 액세스합니다.",
    'web.edit.shellWin' => '원격 데스크탑을 통해 서버에 액세스',
    'web.edit.shellHintWin' => "시스템 사용자 자격 증명을 사용하여 원격 데스크탑을 통해 서버에 액세스합니다.",
    'web.edit.diskQuotaLegend' => '디스크 공간의 하드 할당량',
    'web.edit.diskQuotaHint' => '디스크 공간의 하드 할당량은 사용 가능한 디스크 공간 양에 대한 제한입니다. 하드 할당량을 설정하고 할당된 디스크 공간을 모두 사용하면 파일에 추가 작업을 수행할 수 없습니다.',
    'web.edit.diskQuota' => '디스크 공간의 하드 할당량',
    'web.edit.diskQuotaUnlimited' => '무제한',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => '무제한. 서버 파일 시스템의 구성으로 인해 하드 디스크 할당량이 지원되지 않습니다.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => '호스팅 설정이 업데이트되었습니다.',
    'web.edit.affectedDomainsLegend' => '이러한 설정이 적용되는 웹 사이트',
    'web.edit.affectedDomainsHint' => '다음 웹 사이트가 현재 시스템 사용자와 연관됩니다. 이 페이지에서 지정하는 웹 호스팅 액세스 설정의 변경 내용은 이러한 모든 웹 사이트에 적용됩니다.',

    'web.mobile.create.formTitle' => '모바일 사이트 만들기',
    'web.mobile.create.formGeneralHint' => '모바일 사이트 이름(모바일 사이트에 액세스할 URL)을 지정합니다. 대개 m", mob, mobi, mobile 등의 접두사를 사용합니다(예: mobile.example.com). 그런 다음 일반 사이트에서 모바일 버전과 같은 링크에 이 URL을 사용하여 사용자가 모바일 버전과 일반 버전 사이에 전환할 수 있도록 할 수 있습니다.',
    'web.mobile.create.prefix' => '사이트 이름',
    'web.mobile.create.emptySiteName' => '모바일 사이트 이름을 비워둘 수 없습니다. 일반 웹 사이트와 충돌합니다.',

    'web.security-section.securitySectionLegend' => '보안',
    'web.security-section.securitySectionHint' => '사이트와의 트랜잭션 시 보안을 유지하기 위해 모든 데이터를 암호화하고 보안 연결을 통해 이를 전송하는 SSL/TLS 프로토콜을 사용합니다. SSL/TLS를 사용하려면 전용 IP 주소로 이 사이트를 이동하고 사이트에 SSL/TLS 인증서를 설치한 다음 아래에서 이를 선택하십시오.',
    'web.security-section.securitySectionSniHint' => '사이트와의 트랜잭션 시 보안을 유지하기 위해 모든 데이터를 암호화하고 보안 연결을 통해 이를 전송하는 SSL/TLS 프로토콜을 사용합니다. SSL/TLS를 사용하려면 사이트에 SSL/TLS 인증서를 설치하고 아래에서 이를 선택하십시오.',
    'web.security-section.enableSslSupport' => 'SSL/TLS 지원',
    'web.security-section.enableSslRedirect' => '영구 SEO 안전 301이 HTTP에서 HTTPS로 리디렉션됨',

    'web.seo-settings.seoRedirectDirection' => '기본 도메인',
    'web.seo-settings.seoRedirectDirectionHint' => '사이트 방문자가 SEO-안전 HTTP 301 리디렉션을 통해 리디렉션될 URL(www. 접두사 포함 또는 제외)을 선택합니다.',
    'web.seo-settings.seoRedirectDirectionNone' => '없음',

    'web.settings.formGeneralHint' => '웹 사이트 호스팅 설정을 구성하고 사이트에 사용 가능한 기능을 선택할 수 있습니다.',
    'web.settings.hostingType' => '호스팅 유형',
    'web.settings.websiteHosting' => '웹 사이트',
    'web.settings.forwardingHosting' => '전달',
    'web.settings.noHosting' => '호스팅 없음',
    'web.settings.changeHosting' => '변경',
    'web.settings.websiteStatus' => '웹 사이트 상태',
    'web.settings.changeStatus' => '변경',
    'web.settings.active' => '활성',
    'web.settings.suspended' => '일시 중단됨',
    'web.settings.disabled' => '비활성화됨',
    'web.settings.webScriptingSectionLegend' => '웹 스크립팅 및 통계',
    'web.settings.webScriptingSectionHint' => '다음 프로그래밍 및 스크립팅 언어 중에서 웹 서버가 해석, 실행 또는 처리할 항목을 지정합니다.',
    'web.settings.__asp_win_support' => 'Microsoft ASP 지원',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET 지원',
    'web.settings.__asp_dot_net_version' => '버전',
    'web.settings.__asp_dot_net_version_readonly' => '버전 %%value%%',
    'web.settings.__ssi_support' => 'SSI 지원',
    'web.settings.__ssi_with_html' => '*.htm, *.html 파일에 SSI 사용',
    'web.settings.__php_support' => 'PHP 지원',
    'web.settings.__php_run_as' => 'PHP를 다음으로 실행',
    'web.settings.__php_served_by_apache' => 'Apache에 의해 서비스됨',
    'web.settings.__php_served_by_nginx' => 'nginx에 의해 서비스됨',
    'web.settings.__cgi_support' => 'CGI 지원',
    'web.settings.__cgi_bin_mode' => 'cgi-bin 디렉터리의 위치',
    'web.settings.__cgi_bin_mode_webspace' => '웹 공간의 루트 디렉터리',
    'web.settings.__cgi_bin_mode_www_root' => '이 도메인의 문서 루트',
    'web.settings.__cgi_bin_mode_old_style' => '이 도메인의 이전 스타일 루트',
    'web.settings.__cgi_bin_mode_readonly' => 'cgi-bin 디렉터리의 위치 %%value%%',
    'web.settings.__perl_unix_support' => 'Perl 지원',
    'web.settings.__perl_win_support' => 'Perl 지원',
    'web.settings.__python_unix_support' => 'Python 지원',
    'web.settings.__python_win_support' => 'Python 지원',
    'web.settings.__fastcgi_unix_support' => 'FastCGI 지원',
    'web.settings.__webstat_support' => '웹 통계',
    'web.settings.__plesk_stat_protect' => 'FTP 사용자 이름과 암호로 웹 통계에 대한 액세스 보호',
    'web.settings.__plesk_stat_protected' => 'FTP 사용자 이름과 암호로 웹 통계에 대한 액세스',
    'web.settings.__apache_errdocs' => '사용자 지정 오류 문서',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI 응용 프로그램',
    'web.settings.__php_cgi_handler' => 'CGI 응용 프로그램',
    'web.settings.__php_isapi_handler' => 'ISAPI 확장',
    'web.settings.__php_version' => 'PHP 버전',
    'web.settings.__hosting_write_modify' => '추가 쓰기/수정 권한',
    'web.settings.__hosting_webdeploy' => '웹 배포 게시',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => '없음',
    'web.settings.activate' => '활성화',
    'web.settings.deactivate' => '일시 중단',
    'web.settings.__php_support_readonly' => '버전: %%version%% 처리기: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => '등록되지 않음',
    'web.settings.domainName' => '도메인 이름',
    'web.settings.domainNameHint' => "예: example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => '레거시 옵션 "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 구분"에 대한 호환성 모드',
    'web.settings.sameSslCompatibilityModeCheckbox' => '레거시 옵션 "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 구분"에 대한 호환성 모드로 웹 사이트 실행',
    'web.settings.sameSslCompatibilityHint' => '업그레이드 전에 "SSL/TLS 콘텐츠와 SSL/TLS가 아닌 콘텐츠 구분" 옵션을 사용했기 때문에 이 섹션이 표시됩니다. Plesk 11에서는 이 옵션이 허용되지 않습니다. Plesk 11에서 만들어진 모든 웹 사이트는 동일한 디렉터리를 사용하여 HTTP 및 HTTPS 연결을 통해 제공되는 콘텐츠를 저장합니다. 즉, 이 사이트는 호환성 모드에서 계속 작동하지만 Plesk를 통해 이 사이트를 관리할 수 없습니다. httpsdocs/ 디렉터리에서 httpdocs/로 모든 데이터를 이동한 다음 호환성 모드를 해제하는 것이 좋습니다. 호환성 모드를 해제하면 다시 설정할 수 없으므로 이 섹션이 더 이상 표시되지 않습니다. 호환성 모드가 설정된 상태에서 응용 프로그램을 httpsdocs/ 디렉터리에 설치하면 인터넷을 통해 응용 프로그램에 액세스할 수 없습니다. 응용 프로그램을 httpsdocs/에 설치하려면 호환성 모드를 해제하십시오.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => '웹 사이트 설정이 %%restartInterval%%분 이내에 적용됩니다.',
    'web.settings.phpSettingsDescription' => '이 페이지는 웹 사이트에 대한 PHP 구성을 표시합니다. 이 설정은 웹 사이트에 한해 유효하며 구독 상의 다른 웹 사이트에 영향을 미치지 않습니다. 호스팅 공급자가 해당 권한을 부여한 경우 PHP 구성을 변경할 수 있습니다. PHP 스크립트를 통해 시스템 리소스 사용을 제한하거나 특정 웹 응용 프로그램의 요구 사항을 충족하려는 경우 사용자 지정 PHP 구성이 유용할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다.',
    'web.settings.phpSettingsAvailableVariables' => '매개 변수 값으로 다음 자리 표시자를 사용할 수 있습니다.',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} - 이 웹 사이트의 문서 루트 디렉터리. %%DOCROOT%%은(는) 현재 값입니다. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'HTTPS 문서 루트 디렉터리는 http의 경우와 같습니다.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'HTTPS 문서 루트 디렉터리는 %%DOCROOT%%입니다.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} - 구독의 기본 웹 사이트의 문서 루트 디렉터리.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} - 임시 파일을 저장하는 디렉터리.',
    'web.settings.phpSettingsPhpVersion' => '해당 PHP 버전은 %%version%%입니다.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP가 해제되었습니다.',
    'web.settings.phpHandlerTypeHint' => 'PHP 처리기 유형을 변경하면 이 웹 사이트에서 기존 PHP 스크립트의 작동에 문제가 생길 수 있습니다.',
    'web.settings.fpmDedicatedHandlerHint' => '이 처리기를 사용하면 웹사이트의 안정성이 향상되지만 추가 메모리 소비가 발생합니다.',
    'web.settings.phpHandlerChangeHint' => 'PHP 처리기 설정을 변경했습니다. 이러한 변경 사항을 저장하면 서버 구성으로 인해 웹사이트의 PHP 스크립트가 %%interval%%초간 중지될 수 있습니다.',
    'web.settings.phpHandlerTypeHelpLink' => '가장 적합한 PHP 설정 선택 방법 알아보기',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'PHP 지원은 이 도메인에 사용할 수 있는 PHP 버전이 현재 호스팅 구성에 없기 때문에 활성화할 수 없습니다.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => '다른 PHP 버전을 활성화하는 방법을 확인하십시오.',
    'web.settings.phpHandlerBroken' => '현재 선택한 PHP 처리기는 손상되었습니다. 다른 처리기를 선택하십시오.',
    'web.settings.phpHandlerOutdated' => '(기한 초과)',
    'web.settings.phpHandlerDeprecated' => '(사용되지 않음)',

    'web.setupService.formTitle' => '설정 서비스: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => '\'%%serviceReference%%\' 서비스가 성공적으로 업데이트되었습니다.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% 하위 도메인:',
    'web.site-copy.destinationTypeSection' => '복사 대상',
    'web.site-copy.destinationType' => '사이트 파일을 복사할 위치 선택',
    'web.site-copy.destinationTypeSite' => 'Plesk의 웹 사이트',
    'web.site-copy.destinationTypeSiteDescription' => '이 계정에 호스팅된 다른 사이트에 사이트 파일을 복사합니다. 이 서버의 다른 계정에 대한 FTP 액세스 권한이 있는 경우 FTP 저장소 옵션을 사용합니다.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => '이 서버에 호스팅된 다른 사이트에 사이트 파일을 복사합니다.',
    'web.site-copy.destinationTypeSiteSelect' => '사이트 이름',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "%%destination%%이(가) 해당 파일의 일부이므로(문서 루트가 %%source%% 문서 루트의 하위 디렉터리임) 사이트 %%source%%의 파일을 %%destination%%에 복사할 수 없습니다.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "%%source%%의 파일이 해당 파일의 일부이므로(%%source%% 문서 루트가 %%destination%%의 하위 디렉터리임) 사이트 %%destination%%의 파일을 제거할 수 없습니다.",
    'web.site-copy.destinationTypeFtp' => 'FTP 저장소',
    'web.site-copy.destinationTypeFtpDescription' => '이 서버 또는 외부 서버의 FTP 계정에 웹 사이트 파일을 복사합니다.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => '외부 서버의 FTP 계정에 웹 사이트 파일을 복사합니다.',
    'web.site-copy.destinationTypeFtpHost' => "서버 호스트 이름",
    'web.site-copy.destinationTypeFtpPort' => "포트",
    'web.site-copy.destinationTypeFtpFolder' => '디렉터리',
    'web.site-copy.destinationTypeFtpUser' => '사용자 이름',
    'web.site-copy.destinationTypeFtpPassword' => '암호',
    'web.site-copy.destinationTypeFtpMode' => 'FTP 연결 방법',
    'web.site-copy.destinationTypeFtpModeActive' => '활성 모드',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => '활성 모드에서 Plesk는 외부 서버에 대해 수신 대기할 IP 주소와 포트 번호를 전송하고 서버는 TCP 연결을 시작합니다. Plesk 관리 서버가 방화벽에 의해 보호되지 않는 경우에 이 모드를 사용하는 것이 좋습니다.',
    'web.site-copy.destinationTypeFtpModePassive' => '수동 모드',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Plesk 관리 서버가 방화벽 뒤에 위치하여 수신 TCP 연결을 수락할 수 없는 경우 수동 모드를 사용할 수 있습니다.',
    'web.site-copy.existingFiles' => '기존 파일 처리 방법',
    'web.site-copy.existingFilesKeep' => '대상 사이트의 기존 파일을 유지합니다.',
    'web.site-copy.existingFilesKeepDescription' => '파일 이름이 일치하는 대상 사이트의 기존 파일을 덮어씁니다.',
    'web.site-copy.existingFilesDelete' => '모든 기존 파일 삭제',
    'web.site-copy.existingFilesDeleteDescription' => '복사 전에 대상 사이트의 모든 파일을 삭제합니다.',
    'web.site-copy.emptyLogin' => 'FTP 계정 사용자 이름을 지정합니다.',
    'web.site-copy.emptyHost' => '서버 호스트 이름을 지정합니다.',
    'web.site-copy.emptyPort' => '서버 호스트 포트를 지정합니다.',
    'web.site-copy.copyInProgress' => '웹사이트 %%sourceName%%를 %%destinationName%%에 복사하는 중입니다. 이메일(%%email%%)로 진행 상황이 통보됩니다.',
    'web.site-copy.unableToCopy' => '웹 사이트 파일을 복사하지 못했습니다.',
    'web.site-copy.siteCopied' => '웹 사이트 파일이 복사되었습니다.',
    'web.site-copy.emailSubjSuccess' => '웹 사이트 %%source%% 파일이 복사되었습니다.',
    'web.site-copy.emailSubjFailure' => '웹 사이트 %%source%% 파일을 복사하지 못했습니다.',
    'web.site-copy.emailBodySuccess' => '웹 사이트 %%source%% 파일이 %%destination%%에 복사되었습니다.',
    'web.site-copy.emailBodyFailure' => '웹 사이트 %%source%% 파일을 %%destination%%에 복사하지 못했습니다. %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => '전달 설정',
    'web._shared.forwardDestination' => '대상 주소',
    'web._shared.forwardDestinationHint' => '대상 웹 사이트의 URL.',
    'web._shared.forwardingTypeOptions' => '전달 유형',
    'web._shared.forwardingFrame' => '프레임 전달',
    'web._shared.forwardingFrameHint' => '웹 사이트 방문자를 다른 사이트로 리디렉션하지만 방문자가 리디렉션 사실을 알지 못하도록 방문자에게 대상 주소를 표시하지 않습니다.',
    'web._shared.forwardingHttpCode301' => '영구적으로 이동됨(코드 301)',
    'web._shared.forwardingHttpCode301Hint' => '웹 사이트 방문자를 다른 사이트로 리디렉션하고 이들에게 대상 주소를 표시합니다. 이러한 리디렉션은 사이트의 검색 엔진 랭킹을 유지합니다.',
    'web._shared.forwardingHttpCode302' => '일시적으로 이동됨(코드 302)',
    'web._shared.forwardingHttpCode302Hint' => '검색 엔진이 이 임시 사이트를 인덱싱하는 것을 원하지 않는 경우 웹 사이트 방문자를 임시 사이트 사본으로 리디렉션합니다.',
    'web._shared.documentRoot' => '문서 루트',
    'web._shared.documentRootHint' => '웹 사이트 홈 디렉터리 경로.',
    'web._shared.documentRootHintDisabledDueApplications' => '이 웹 사이트에 웹 응용 프로그램이 설치되어 있어서 문서 루트를 변경할 수 없습니다.',
    'web._shared.ipAddress' => 'IP 주소',
    'web._shared.shared' => '공유',
    'web._shared.exclusive' => '전용',
    'web._shared.ipAddressHint' => "웹 사이트의 호스팅에 사용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (기타 리포지토리)',
    'web._shared.certificate' => '인증서',
    'web._shared.sameCertificatesHint' => '선택한 인증서가 같은 전용 IP 주소에 호스팅된 모든 사이트에 사용됩니다.',
    'web._shared.differentCertificatesHint' => '이 구독은 두 개의 서로 다른 인증서를 사용하는 두 개의 전용 IP 주소와 연관되어 있습니다. 선택한 인증서가 이러한 두 개의 IP 주소에 호스팅된 사이트에 설치되어 있는 모든 인증서를 대체합니다.',
    'web._shared.differentIpTypesCertificateHint' => '이 구독은 한 개의 공유 및 한 개의 전용 IP 주소와 연관되어 있습니다. 선택한 인증서가 전용 IP 주소에 호스팅된 다른 모든 사이트에도 사용됩니다.',
    'web._shared.certificateNotSelected' => '선택되지 않음',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => '리포지토리에 SSL/TLS 인증서가 없습니다. 인증서를 추가하려면 %%link%%(으)로 이동하십시오.',
    'web._shared.sslCertificatesRepositoryLink' => '이 페이지',

    'web-user.settings.allowScripts' => '웹 사용자가 스크립트를 사용하도록 허용',

    'web-user.name' => 'FTP 상에서 서버에 연결하기 위한 사용자 이름',
    'web-user.longName' => '이 사용자 이름은 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'web-user.password' => '암호',
    'web-user.passwordConfirmation' => '암호 확인',
    'web-user.hardDiskQuota' => '하드 디스크 할당량',
    'web-user.hardDiskQuotaUnlimited' => '무제한',
    'web-user.hardDiskQuotaIsNotSupported' => '(서버 파일 시스템의 구성으로 인해 하드 디스크 할당량이 지원되지 않습니다.)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => '필수 필드',
];