<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Dirección IP o subred',
    'access-network.subnetOrIpAddressHint' => 'Por ejemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'Recuperando la información sobre los newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'No pudo recuperarse el estado de su suscripción.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Deseo recibir los newsletters de Plesk. Estos proporcionan información general sobre el producto, además de otras informaciones de carácter técnico y de seguridad. Autorizo a Plesk a recopilar, procesar y usar mis datos personales (email), incluyendo procesamiento transversal, conforme a las leyes de protección de datos aplicables y vigentes para el envío de dichos newsletters de forma directa o mediante un servicio de terceros. De no seleccionar esta casilla, mi consentimiento se verá revocado, Plesk dejará de enviarme emails y este eliminará mis datos personales de sus sistemas de forma permanente.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Sí, acepto recibir mi newsletter personalizado de Plesk. Plesk International GmbH y sus afiliados pueden almacenar y procesar los datos proporcionados para la entrega del newsletter conforme a la %%privacyPolicy%%. Con el fin de poderle proporcionar las ofertas y mensajes más apropiados en su caso, Plesk también puede usar información adicional para rellenar automáticamente datos como puede ser el caso de datos de uso o de comportamiento. Puedo cancelar mi suscripción a las listas de correu en cualquier momento.',
    'admin.announcement-settings.privacyPolicy' => 'Directiva de privacidad de Plesk',
    'admin.announcement-settings.noConsent' => 'Cancelar mi suscripción al newsletter de Plesk.',
    'admin.announcement-settings.reportConsentError' => 'No pudo guardarse su configuración para la obtención de información de Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Lo sentimos, en este momento no podemos actualizar su perfil. Inténtelo de nuevo transcurridos unos minutos.',
    'admin.announcement-settings.invalidConsentType' => "Tipo de consentimiento desconocido: '%%type%%'",
    'admin.announcement-settings.retry' => 'Volver a intentar',
    'admin.announcement-settings.consentGivenInfo' => 'Esperamos que haya disfrutado de nuestro newsletter genérico. Ahora le proporcionamos una alternativa mejor aún si cabe - personalizada y con sugerencias e información sumamente útil conforme a sus necesidades particulares. Si desea recibir su newsletter personalizado, seleccione la primera opción que aparece a continuación y haga clic en ACEPTAR.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Parece que no está suscrito a nuestro newsletter genérico. Podemos proporcionarle una alternativa mejor aún si cabe - personalizada y con sugerencias e información sumamente útil conforme a sus necesidades particulares.',

    'admin.personal-info.title' => 'Editando el perfil del administrador',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Configuración de Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Configuración',

    'admin-alias.login' => 'Nombre de usuario',
    'admin-alias.password' => 'Contraseña',
    'admin-alias.passwordConfirmation' => 'Confirme la contraseña',
    'admin-alias.email' => 'Email',
    'admin-alias.contact' => 'Nombre de contacto',
    'admin-alias.comments' => 'Comentarios',
    'admin-alias.emptyLogin' => 'Proporcione un nombre de usuario.',
    'admin-alias.loginTooLong' => 'La longitud del nombre de usuario excede los 20 caracteres.',
    'admin-alias.emptyEmail' => 'Indique una dirección de email.',
    'admin-alias.emptyContactName' => 'Proporcione un nombre de contacto.',
    'admin-alias.contactNameTooLong' => 'La longitud del nombre de contacto excede los 255 símbolos.',
    'admin-alias.emptyPassword' => 'Proporcione una contraseña.',
    'admin-alias.commentsTooLong' => 'La longitud del comentario excede los 255 símbolos.',
    'admin-alias.emailActivation' => 'Activar cuenta por email',
    'admin-alias.simplePanel' => 'Activar modo restringido',
    'admin-alias.simplePanelHint' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador adicional en Plesk. Para modificar las acciones disponibles, vaya a %%link%%.',
    'admin-alias.simplePanelLink' => 'Herramientas y configuración > Configuración de modo restringido',
    'admin-alias.lockPowerUser' => 'Forzar vista Power User para el administrador adicional',
    'admin-alias.lockPowerUserHint' => 'Habilidad para restringir la visualización al administrador adicional de Plesk (sin acceso a planes de servicio, clientes y revendedores).',

    'admin-info.plesk-settings.multiplyLogin' => 'Permitir múltiples sesiones bajo esta cuenta',
    'admin-info.plesk-settings.adminLanguage' => 'Idioma del interfaz del administrador',
    'admin-info.plesk-settings.password' => 'Contraseña',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmar contraseña',

    'admin-panel.form.contact-info.contactName' => 'Nombre de contacto',
    'admin-panel.form.contact-info.emptyContactName' => 'Proporcione un nombre de contacto.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'El nombre de contacto es demasiado largo (se permiten un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.email' => 'Dirección de email',
    'admin-panel.form.contact-info.emptyEmail' => 'Indique una dirección de email.',
    'admin-panel.form.contact-info.companyName' => 'Nombre de la empresa',
    'admin-panel.form.contact-info.longCompanyName' => 'Este nombre de empresa es demasiado largo. Tenga en cuenta que se permite un máximo de %max% símbolos.',
    'admin-panel.form.contact-info.phone' => 'Nº de teléfono',
    'admin-panel.form.contact-info.longPhone' => 'Este número de teléfono es demasiado largo (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.fax' => 'Nº de fax',
    'admin-panel.form.contact-info.imNumber' => 'Mensajería instantánea',
    'admin-panel.form.contact-info.longFax' => 'Este número de fax es demasiado largo (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'El número de teléfono especificado no es válido.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'El número de fax indicado no es correcto.',
    'admin-panel.form.contact-info.address' => 'Dirección',
    'admin-panel.form.contact-info.longAddress' => 'Esta dirección es demasiado larga (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.city' => 'Ciudad',
    'admin-panel.form.contact-info.longCity' => 'El nombre de esta ciudad es demasiado largo.',
    'admin-panel.form.contact-info.shortCity' => 'El nombre de esta ciudad es demasiado corto.',
    'admin-panel.form.contact-info.state' => 'Estado/Provincia',
    'admin-panel.form.contact-info.postalCode' => 'Código postal',
    'admin-panel.form.contact-info.country' => 'País',
    'admin-panel.form.contact-info.additionalInfo' => 'Información adicional',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Solo texto sin formato − Se ignorarán todas las etiquetas HTML.',
    'admin-panel.form.contact-info.duplicateEmail' => 'En el sistema ya existe un usuario con esta dirección de email.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Suscripción',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Crear suscripción para el cliente',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Deseleccione esta casilla si ahora no desea crear una suscripción de servicio de hosting o un sitio web para el cliente. Si el cliente no dispone de una suscripción, no podrá acceder al panel del cliente.',
    'admin-panel.form.domain-info-section.domainName' => 'Nombre de dominio',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Indique un nombre de dominio.',
    'admin-panel.form.domain-info-section.shared' => 'compartida',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicada',
    'admin-panel.form.domain-info-section.userName' => 'Nombre de usuario',
    'admin-panel.form.domain-info-section.userNameHint' => 'Cuenta de usuario del sistema utilizada para administrar los archivos y carpetas de los sitios web creados dentro de la suscripción.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Indique un nombre de usuario.',
    'admin-panel.form.domain-info-section.password' => 'Contraseña',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Indique una contraseña.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirme la contraseña',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Dirección IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Dirección IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Ninguna',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Configuración de suscripción adicional',
    'admin-panel.form.domain-info-section.credentials' => 'Credenciales del usuario del sistema',
    'admin-panel.form.domain-info-section.credentialsHint' => 'para acceder a los archivos alojados mediante FTP y SSH',

    'admin-panel.form.login-info.userName' => 'Nombre de usuario',
    'admin-panel.form.login-info.emptyUserName' => 'Indique un nombre de usuario.',
    'admin-panel.form.login-info.password' => 'Contraseña',
    'admin-panel.form.login-info.emptyPassword' => 'Indique una contraseña.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Confirme la contraseña',
    'admin-panel.form.login-info.emailActivation' => 'Activar cuenta por email',
    'admin-panel.form.login-info.emailActivationHint' => 'Una cuenta creada no está activa hasta que el usuario la activa mediante el enlace enviado por email o hasta que el administrador la activa manualmente.',

    'admin-panel.form.subscription-info-section.subscription' => 'Suscripción',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plan de servicio',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Plan de servicio actual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Plan de servicio nuevo',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Plan simple',
    'admin-panel.form.subscription-info-section.none' => 'Ninguna',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Complementos',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Una vez cambiada la asociación del plan, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Personalice los parámetros de la suscripción una vez creada.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Proceed to customizing the subscription parameters after the customer is created.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Una vez creada, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Añadir suscripción',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'app.configure.otherSettings' => 'Otro',
    'app.configure.passwordConfirmation' => 'Confirme la contraseña',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Forzar las actualizaciones de todas las aplicaciones instaladas',
    'app.update-settings.forceUpdatesHint' => 'Las aplicaciones de todos los clientes se actualizarán de forma automática en cuanto las actualizaciones estén disponibles. Los clientes no podrán desactivar las actualizaciones automáticas de sus aplicaciones. Importante: tenga precaución al utilizar esta opción, ya que las actualizaciones pueden afectar a la funcionalidad de las aplicaciones de forma significativa. Por ejemplo, las extensiones de las aplicaciones pueden dejar de funcionar con otra versión de estas.',
    'app.update-settings.suggestUpdates' => 'Habilitar la opción "Actualizar esta aplicación automáticamente" de forma predeterminada',
    'app.update-settings.suggestUpdatesHint' => 'En el caso de aplicaciones instaladas recientemente, la opción "Actualizar esta aplicación automáticamente" será habilitada en la configuración de la aplicación.',

    'backup.server-settings.rotation' => 'Número máximo de archivos de backup completo a almacenar (incluyendo tanto los backups programados como los manuales)',
    'backup.server-settings.rotationDescription' => 'Los usuarios puede almacenar esta cantidad de backups completos en el almacenamiento del servidor. De superarse el límite, únicamente se conservaran los backups más recientes. Esto no afecta a los backups incrementales.',
    'backup.server-settings.maxProcesses' => 'Número máximo de procesos de backup programados ejecutados de forma simultánea',
    'backup.server-settings.niceScheduled' => 'Ejecutar procesos de backup programados con poca prioridad',
    'backup.server-settings.niceScheduledPriority' => 'Prioridad',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Indique un valor entre 1 y 19 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioridad de E/S',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Indique un valor entre 0 y 7 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceAlways' => 'Ejecutar todos los procesos de backup con prioridad baja',
    'backup.server-settings.niceAlwaysPriority' => 'Prioridad',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Indique un valor entre 1 y 19 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioridad de E/S',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Indique un valor entre 0 y 7 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.noCompression' => 'No comprimir archivos de backup',
    'backup.server-settings.freeSpaceRequired' => 'Iniciar el backup únicamente si su servidor dispone de la cantidad especificada de espacio en disco libre (en megabytes)',
    'backup.server-settings.checkBackupDiskSpace' => 'Iniciar el backup únicamente si su servidor dispone de suficiente espacio en disco libre',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Utilizar la funcionalidad de backups nativa de MS SQL. En el caso de bases de datos remotas, compruebe que ha configurado debidamente la configuración de backup del servidor MS SQL remoto en Herramientas y configuración>Servidores de bases de datos.',
    'backup.server-settings.localFtpRestriction' => 'Permitir la configuración de un almacenamiento de backups FTP en el servidor local',
    'backup.server-settings.backupSecuritySettings' => 'Configuración de seguridad de backups',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Guardar los backups en el almacenamiento del servidor en caso de que se produzca un error carga al almacenamiento remoto',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'En caso de que no fuera posible efectuar la carga al almacenamiento remoto, los backups manuales y programados se guardarán en el almacenamiento del servidor local. Los usuarios deben disponer de permisos para almacenar backups en el almacenamiento del servidor.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Clientes propiedad del Admin',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Todas las cuentas de clientes que pertenecían al administrador en la versión anterior de Plesk se convirtieron a cuentas de clientes propiedad del administrador: (1) Los recursos legacy de cada cliente se han conservado (los encontrará en la etiqueta \'Mis recursos\' presente en la parte superior de la lista de suscripciones del cliente). Estos serán eliminados una vez completada la transición; (2) Todos sus dominios se convirtieron a suscripciones (una suscripción nueva de cada dominio); (3) Los administradores de dominio se han convertido en usuarios del cliente que solo tienen acceso a la suscripción que contiene su dominio.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Estado anterior del cliente',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Nº de clientes',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Esquema de transición',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'Un dominio; ajuste de límites prohibido.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Los recursos de la suscripción nueva son iguales al mínimo de límites de dominio o cliente anterior.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'Un dominio; ajuste de límites permitido.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Los recursos de la suscripción nueva son iguales a los límites del cliente anterior.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Múltiples dominios; se prohibió la creación de dominios y el ajuste de límites.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Los recursos de la suscripción nueva se heredan de los límites de dominio anterior.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Múltiples dominios; se permitió la creación de dominios y el ajuste de límites.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Hacer transición como:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Revendedor. Un cliente anterior se actualiza a revendedor. Los recursos de la suscripción de revendedor se heredan de los límites del cliente anterior. Si la cuenta de administrador de dominio se habilitó para un dominio anterior, esta se actualiza como una cuenta de cliente y la suscripción correspondiente se asocia con esta. De lo contrario, las suscripciones pertenecen directamente al revendedor.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Cliente. Un cliente anterior sigue siendo cliente. Los recursos del cliente se distribuyen equitativamente entre sus suscripciones.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Revendedores',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Clientes',
    'business-model-upgrade.bunch.t1s6-apply' => 'Hacer transición de estos clientes como',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Clientes propiedad de Revendedores',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Todas las cuentas de cliente que pertenecían a un revendedor en Plesk 9 se han convertido en cuentas de cliente propiedad de los revendedores respectivos: (1) Los recursos legacy de cada cliente se han conservado (los encontrará bajo la etiqueta \'Mis recursos\' presente en la parte superior de la lista de suscripciones del cliente). Estos serán eliminados una vez se haya completado la transición. (2) Todos sus dominios se han convertido en suscripciones (una suscripción nueva de cada dominio). (3) Los administradores de dominio se han convertido en usuarios del cliente y solo tienen acceso a la suscripción que contiene su dominio.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Estado anterior del cliente',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Nº de clientes',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Esquema de transición',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'Un dominio; ajuste de límites prohibido.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Los recursos de la suscripción nueva son iguales al mínimo de límites de dominio o cliente anterior.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'Un dominio; ajuste de límites permitido.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Los recursos de la suscripción nueva son iguales a los límites del cliente anterior.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Múltiples dominios; se prohibió la creación de dominios y el ajuste de límites.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Los recursos de la suscripción nueva se heredan de los límites de dominio anterior.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Múltiples dominios; se permitió la creación de dominios y el ajuste de límites.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'Los recursos del cliente se distribuyen equitativamente entre sus suscripciones.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Hacer transición de estos clientes',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Suscripciones propiedad del Admin',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Todos los dominios propiedad del admin en una versión anterior de Plesk se convirtieron a suscripciones propias del admin.  Los administradores del dominio se han convertido en usuarios del panel del cliente y solo tienen acceso a la suscripción que contiene su dominio. Use las acciones recomendadas para realizar una transición de estas suscripciones o seleccione un esquema de transición personalizado para cada una en la pestaña \'Transición selectiva de suscripciones\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Estado anterior del dominio',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Número de suscripciones',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de transición',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'El dominio pertenecía al admin. La cuenta del administrador del dominio fue habilitada.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'El administrador del dominio anterior se actualiza a cliente y se convierte en un suscriptor, lo que significa que se le asigna la suscripción.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Realizar transición de estas suscripciones',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Suscripciones propiedad de Revendedores',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Todos los dominios que pertenecían a revendedores en una versión anterior de Plesk se convirtieron a suscripciones propias de los revendedores, conservando así la propiedad. Los administradores del dominio se han convertido en usuarios del panel del cliente y solo tienen acceso a la suscripción que contiene su dominio. Use las acciones recomendadas para realizar una transición de estas suscripciones o seleccione un esquema de transición personalizado para cada una en la pestaña \'Transición selectiva de suscripciones\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Estado anterior del dominio',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Número de suscripciones',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Esquema de transición',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'El dominio pertenecía a un revendedor. La cuenta del administrador del dominio fue habilitada.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'El administrador del dominio anterior se actualiza a cliente y se convierte en un suscriptor, lo que significa que se le asigna la suscripción.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Realizar transición de estas suscripciones',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'No se ha podido realizar la transición de algunos de los clientes y suscripciones seleccionados.',

    'change-current-subscription.hint' => 'Aquí puede cambiar la asociación con planes de servicio para la suscripción. Tenga en cuenta que la selección de \'ninguno\' como plan de servicio nuevo desvincula la suscripción del plan de servicio y la convierte en \'Personalizada\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'change-password.oldPassword' => 'Contraseña anterior',
    'change-password.password' => 'Contraseña nueva',
    'change-password.passwordConfirmation' => 'Confirme la contraseña',
    'change-password.oldPasswordIsIncorrect' => 'La contraseña anterior no es correcta. Inténtelo de nuevo.',
    'change-password.unableToFindAdditionalAdminAccount' => 'No se pudo encontrar la cuenta de administrador adicional.',
    'change-password.warningAboutAdminPasswordSyntax' => "La contraseña debería estar formada por %%min%% - %%max%% caracteres y no debería incluir el nombre de usuario.\nNo utilice interrogantes, espacios ni caracteres del alfabeto nacional en la contraseña.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "No utilice interrogantes, espacios, puntos y coma ni caracteres del alfabeto nacional en la contraseña.\nLa contraseña debería estar formada por %%min%% - %%max%% caracteres y no debería incluir el nombre de usuario.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Directiva de sobreuso',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Sobreuso permitido',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'El sobreuso permite a un revendedor vender más recursos de los asignados con un plan. En el caso de que se permita el sobreuso, un revendedor se regirá por el uso actual de recursos, en vez de regirse  por la asignación inicial de recursos.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Sobreuso no permitido',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita el sobreuso, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con un plan, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',

    'change-reseller-subscription.hint' => 'Aquí puede cambiar la asociación con el plan de servicio para la suscripción del revendedor. Tenga en cuenta que la selección de \'ninguno\' como plan de servicio nuevo desvincula la suscripción de los planes de servicio y la convierte en \'Personalizada\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Plan nuevo',
    'change-reseller-subscription.oldSubscription' => 'Plan actual',
    'change-reseller-subscription.none' => 'ninguna',
    'change-reseller-subscription.infoSubscriptionChanged' => 'La asociación de la suscripción con el plan de servicio ha sido actualizada.',
    'change-reseller-subscription.customizeSubscription' => 'Una vez actualizada la asociación con el plan de servicio, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',

    'change-subscription.hint' => 'Aquí puede cambiar la asociación con planes de servicio para las suscripciones seleccionadas.',
    'change-subscription.selectPlanLegend' => 'Plan de servicio',
    'change-subscription.selectPlanDescription' => 'Para cambiar a otro plan de servicio, seleccione el plan nuevo en la lista. Tenga en cuenta que la selección de \'ninguno\' desvincula las suscripciones del plan de servicio y las convierte en \'Personalizadas\'.',
    'change-subscription.servicePlan' => 'Plan de servicio nuevo',
    'change-subscription.selectAddonPlansLegend' => 'Planes complementarios',
    'change-subscription.selectAddonPlansDescription' => 'Añada o elimine planes complementarios.',
    'change-subscription.noChange' => 'no cambiar',
    'change-subscription.none' => 'ninguno',
    'change-subscription.add' => 'añadir',
    'change-subscription.del' => 'eliminar',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Dirección IP o subred',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Por ejemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Acceso a Plesk con privilegios de administrador',
    'control-panel-access.settings.policyAllow' => 'Permitido, excluyendo las redes presentes en la lista.',
    'control-panel-access.settings.policyDeny' => 'Denegado desde las redes que no aparecen en la lista.',

    'create-subscription.title' => 'Añadir una suscripción',
    'create-subscription.titleOwn' => 'Adición de su propia suscripción',
    'create-subscription.poolIsEmpty' => 'No se pudo crear una suscripción porque en Plesk no existe ninguna dirección IP compartida ni ninguna dirección IP dedicada disponible.',
    'create-subscription.infoNewSubscriptionCreated' => 'La suscripción %%name%% ha sido creada.',
    'create-subscription.createBeforeAppInstall' => 'Para instalar la aplicación es necesario disponer de una suscripción.',

    'customer.hint' => 'Aquí puede dar de alta clientes nuevos para sus servicios de hosting. Al dar de alta un cliente nuevo, creará una cuenta de cliente en Plesk así como una suscripción a uno de sus planes de hosting. Asimismo, también puede crear complementos adicionales. La suscripción también puede proporcionar un conjunto de recursos y servicios totalmente personalizado y no vinculado a ningún plan. En este caso, seleccione \'Ninguno\' al lado del plan de servicio.',
    'customer.contactInfoSection' => 'Información de contacto',
    'customer.additionalInfoSection' => 'Additional customer information',
    'customer.accessToPanelSection' => 'Acceso a Plesk',
    'customer.contactInfoSectionHint' => 'Introduzca la información de contacto del cliente.',
    'customer.accessToPanelSectionHint' => 'Credenciales que usará el cliente para acceder a su panel del cliente.',
    'customer.unableCreateSubscription' => 'La suscripción no puede ser creada − %%reason%%',
    'customer.poolIsEmpty' => 'El grupo de direcciones IP está vacío',
    'customer.buttonOk' => 'Añadir cliente',

    'database-settings.dbPrefixRadio' => 'Añadir el prefijo y un guión bajo al principio de los nombres de las bases de datos',
    'database-settings.dbPrefixNone' => 'Ninguno',
    'database-settings.dbPrefixUsername' => 'Nombre de usuario',
    'database-settings.dbPrefixExternalId' => 'ID externa de una suscripción',
    'database-settings.dbUserPrefix' => 'Añadir el nombre de usuario y un guión bajo al principio de los nombres de usuario de las bases de datos',
    'database-settings.dbUserPrefixHint' => 'Los nombres de usuario de las bases de datos tendrán el formato <plesk_username>_<database_user_name>. Debido a las restricciones de longitud de los nombres de usuario de la base de datos, es necesario abreviar <plesk_username>.',
    'database-settings.grantAlterDatabase' => 'Conceder el permiso ALTER DATABASE a todos los usuarios de la base de datos Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Este permiso será concedido a usuarios nuevos y también a los usuarios existentes.',
    'database-settings.enableBackupOperator' => 'Activar la pertenencia al rol  db_backupoperator para todos los usuarios de bases de datos Microsoft SQL Server',
    'database-settings.enableBackupOperatorHint' => 'Los usuarios nuevos y existentes serán miembros de este rol.',
    'database-settings.aclRadio' => 'Configuración predeterminada para el acceso remoto de los usuarios de la base de datos',
    'database-settings.aclLocalhost' => 'Solo permitir conexiones locales',
    'database-settings.aclAny' => 'Permitir conexiones remotas desde cualquier host',
    'database-settings.aclCustom' => 'Permitir conexiones remotas desde',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nLos hosts especificados pueden acceder a la base de datos en nombre de este usuario.",
    'database-settings.aclDescription' => 'Este parámetro solo modifica los permisos de los usuarios. Si desea activar el acceso remoto al servidor MySQL local, seleccione la opción correspondiente en <a href="/server/db_server_edit.php?db_server_id=%d">Configuración local de MySQL</a>.',
    'database-settings.example' => "Por ejemplo:\n%%example%%",

    'dns.template.synchronize-done' => 'La plantilla de zona DNS se ha aplicado correctamente.',
    'dns.template.synchronize-error' => 'La plantilla de zona DNS no se ha aplicado a algunas zonas DNS.',
    'dns.template.synchronize-progress' => 'Aplicando la plantilla de zona DNS.',

    'domain-restriction.name' => 'Nombre de dominio',
    'domain-restriction.nameDescription' => 'Puede especificar un patrón wildcard usando el signo de asterisco (*). Por ejemplo, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'El nombre de dominio especificado ya está en la lista.',

    'event-handler.eventLabel' => 'Evento',
    'event-handler.priorityLabel' => 'Prioridad',
    'event-handler.userLabel' => 'Usuario',
    'event-handler.commandLabel' => 'Comando',
    'event-handler.commandHint' => 'Para un resultado óptimo, introduzca la ruta completa a un archivo script en el campo \'command\'. En ningún caso le recomendamos introducir comandos de sistema, puesto que es posible que no funcionen. Por ejemplo, los comandos con operadores de redirección de salida > o < no funcionarán.',
    'event-handler.priorityHighestText' => 'la más alta',
    'event-handler.priorityHighText' => 'alta',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'baja',
    'event-handler.priorityLowestText' => 'la más baja',
    'event-handler.priorityCustomText' => 'personalizada',
    'event-handler.priorityHighestOption' => 'la más alta (%%value%%)',
    'event-handler.priorityHighOption' => 'alta (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'baja (%%value%%)',
    'event-handler.priorityLowestOption' => 'la más baja (%%value%%)',

    'extension.upload.fileUpload' => 'Ruta al archivo del paquete de la extensión',

    'external-webmail.hint' => 'Cuando registre otro webmail en Plesk, este estará a disposición de sus clientes apareciendo como opción en las propiedades \'Correo\' de las suscripciones y los planes de hosting. En la lista de opciones de webmail se mostrará el nombre del webmail y al hacer clic en el icono del webmail que aparece al lado de un buzón en el panel del cliente se abrirá la URL correspondiente.',
    'external-webmail.name' => 'Nombre del servicio de webmail',
    'external-webmail.url' => 'URL del servicio de webmail',
    'external-webmail.enabled' => 'Disponible',

    'ftp-settings.generalSection' => 'General',
    'ftp-settings.portRange' => 'Puerto o rango de puertos para conexiones pasivas en modo FTP',
    'ftp-settings.hintPortRange' => '(valor predeterminado: %%defaultPortRange%%)',

    'health.upload.hint' => 'Cargue su configuración de Health Server Monitor. La configuración se aplicará tan pronto como se haya cargado.',
    'health.upload.selectFile' => 'Archivo de configuración',

    'install-local-package.selectUploadType' => 'Seleccione una de las siguientes opciones:',
    'install-local-package.uploadAsFile' => 'Cargar un paquete APS',
    'install-local-package.downloadFromCatalog' => 'Seleccionar una aplicación del catálogo de aplicaciones',
    'install-local-package.formInfo' => "Amplíe la lista de aplicaciones disponibles cargando una aplicación nueva o añada una aplicación del catálogo disponible para su posterior configuración.",
    'install-local-package.invalidFileExtension' => 'La aplicación cargada debe ser un archivo ZIP con extensión .zip.',
    'install-local-package.packagesNotSelected' => 'No se ha seleccionado ninguno de los paquetes.',
    'install-local-package.visible' => 'Hacerlo disponible para los clientes',
    'install-local-package.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una llave de licencia.',
    'install-local-package.visibleDescription' => 'Haga que esta aplicación esté disponible para que los clientes puedan instalarla.',

    'ip-address.generalSection' => 'General',
    'ip-address.interface' => 'Interfaz',
    'ip-address.addressAndSubnetPrefixLength' => 'Máscara subred y dirección IP',
    'ip-address.publicIp' => 'Dirección IP pública',
    'ip-address.hintPublicIp' => 'Si su servidor Plesk se encuentra detrás de NAT, puede usar una dirección IP pública',
    'ip-address.distributionType' => 'La dirección IP se distribuye como',
    'ip-address.distributionTypeShared' => 'Compartida',
    'ip-address.distributionTypeExclusive' => 'Dedicada',
    'ip-address.certificate' => 'Certificado SSL/TLS',
    'ip-address.defaultSite' => 'Sitio predeterminado',
    'ip-address.ftpOverSslNotSupportedByServer' => 'El servidor FTP instalado no soporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'El servidor FTP instalado no dispone de soporte para direcciones IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'No es posible añadir la dirección IP. Este interfaz de red obtiene direcciones IP de forma automática.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Nota: La URL personalizada de Plesk está activada para todos los dominios desconocidos. En vez de mostrarse el sitio predeterminado presente en "https://%%ip%%/", se mostrará el interfaz de Plesk',

    'ip-ban.filter.name' => 'Nombre',
    'ip-ban.filter.content' => 'Contenido',
    'ip-ban.filter.filterExistsError' => 'Ya existe un filtro con este nombre.',

    'ip-ban.jail.name' => 'Nombre',
    'ip-ban.jail.filter' => 'Filtro',
    'ip-ban.jail.filterDescription' => 'Seleccione el filtro.',
    'ip-ban.jail.action' => 'Acción',
    'ip-ban.jail.actionDescription' => 'Seleccione una acción y haga clic en el botón para añadirla.',
    'ip-ban.jail.logPath' => 'Ruta del registro',
    'ip-ban.jail.banTime' => 'Periodo de prohibición de la dirección IP',
    'ip-ban.jail.maxRetry' => 'El número máximo de intentos fallidos de inicio de sesión',
    'ip-ban.jail.timeUnit' => 'segundos',
    'ip-ban.jail.addAction' => 'Añadir',
    'ip-ban.jail.chooseAction' => 'Seleccionar:',
    'ip-ban.jail.apache-auth-filter-description' => 'Errores de autorización de Apache (al acceder al archivo)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Errores de autorización de Apache (cualquier acceso)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Errores de autorización de Apache (al acceder al syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bots y bad web crawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Errores de autenticación de Courier IMAP y POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Errores de autenticación de Dovecot IMAP, POP3 y Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Errores de autenticación de Dovecot IMAP, POP3 y Sieve (modo agresivo)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Errores de autenticación de webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Vulneraciones de control de acceso y seguridad del firewall para aplicaciones web (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Errores de autenticación de Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Errores de autenticación de Qmail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Errores de autenticación de webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Errores de autenticación de WordPress',
    'ip-ban.jail.postfix-filter-description' => 'Errores del cliente SMTP de Postfix (incluyendo RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Errores del cliente SMTP de Postfix, errores de autenticación y ataques DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Errores de autenticación de Postfix SMTP y SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Ataques DDoS del SMTP de Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Errores de autenticación y del cliente SMTP de Postfix',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Errores del cliente SMTP de Postfix (incluyendo RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Errores del cliente SMTP de Postfix (solo RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Errores de inicio de sesión de ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosts prohibidos de forma reiterada por Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Errores de inicio de sesión SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Errores de acceso SSH, errores de negociación y ataques DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Errores de acceso SSH y ataques DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Errores de negociación y de acceso SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Prohibir mediante firewall firewalld, en todos los puertos',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Prohibir mediante firewall firewalld, en múltiples puertos',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Prohibir mediante firewall firewalld, en un único puerto',
    'ip-ban.jail.iptables-action-description' => 'Prohibir mediante firewall iptables, en un único puerto',
    'ip-ban.jail.iptables-allports-action-description' => 'Prohibir mediante firewall iptables, en todos los puertos',
    'ip-ban.jail.iptables-multiport-action-description' => 'Prohibir mediante firewall iptables, en múltiples puertos',
    'ip-ban.jail.sendmail-action-description' => 'Enviar notificación por email mediante sendmail',
    'ip-ban.jail.jailExistsError' => 'Ya existe un jail con este nombre.',
    'ip-ban.jail.invalidInteger' => 'El valor especificado no es válido. Indique un número entero.',

    'ip-ban.settings.pageHint' => 'Aquí puede configurar la prohibición de direcciones IP para así proteger su servidor y los sitios web alojados frente a un posible tráfico malintencionado.',
    'ip-ban.settings.detectionEnabled' => 'Activar detección de intrusiones',
    'ip-ban.settings.banPeriod' => 'Periodo de prohibición de la dirección IP',
    'ip-ban.settings.banTimeWindow' => 'Intervalo de tiempo para la detección de ataques subsiguientes',
    'ip-ban.settings.maxRetries' => 'Número de errores antes de proceder con la prohibición de la dirección IP',
    'ip-ban.settings.timeUnit' => 'segundos',
    'ip-ban.settings.invalidInteger' => 'Se ha proporcionado un valor que no es válido. Indique un número entero positivo.',

    'ip-ban.trusted-ip.ipAddress' => 'Dirección IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Proporcione una dirección IP, una máscara CIDR o el nombre de host del DNS.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'La dirección IP, la dirección de red o el nombre de host indicado no es válido.',

    'login-info.hint' => 'Aquí puede editar el nombre de usuario y la contraseña utilizados por el usuario para acceder a su panel del cliente.',
    'login-info.resellerHint' => 'Aquí puede cambiar el nombre de usuario y/o la contraseña utilizada por el revendedor para acceder a su Plesk.',
    'login-info.myProfileHint' => 'Aquí puede cambiar la contraseña que utiliza para acceder a su Plesk.',

    'mail.lists-server-settings.email' => "Email del administrador de la lista de correo",
    'mail.lists-server-settings.emptyEmail' => 'Indique una dirección de email.',
    'mail.lists-server-settings.newPassword' => 'Contraseña nueva',
    'mail.lists-server-settings.emptyPassword' => 'Indique una contraseña.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirme la contraseña',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'El software de listas de correo ha sido configurado.',

    'mail.outgoing-messages.hint' => 'Aquí puede especificar un límite de correos salientes desde un buzón de correo.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'El número máximo de emails salientes',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Predeterminado (%%domainOutgoingMessages%% mensajes por hora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalizado para este buzón',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensajes por hora',

    'mail-gate-settings.host' => 'Dirección IP o nombre de host',
    'mail-gate-settings.port' => 'Puerto',
    'mail-gate-settings.login' => 'Nombre de usuario',
    'mail-gate-settings.password' => 'Contraseña',
    'mail-gate-settings.encryption' => 'El servidor SMTP requiere una conexión cifrada',
    'mail-gate-settings.allowUsers' => 'Permitir a los scripts de los usuarios enviar correo mediante este servidor SMTP (usando las credenciales especificadas)',
    'mail-gate-settings.useDefaultSettings' => 'Usar el servidor de correo instalado con Plesk y la cuenta de correo predeterminada creada por Plesk',

    'mail-gate.hint' => 'Aquí puede especificar el servidor SMTP que debe usarse cuando el servidor de correo de Plesk no esté instalado o no se le permita enviar correos. Plesk y los scripts de los usuarios usarán este servidor como una retransmisión SMTP para el envío de correos, como puede ser el caso de las notificaciones por email.',
    'mail-gate.enableMailGate' => 'Permitir a Plesk enviar notificaciones por email mediante este servidor SMTP',
    'mail-gate.notifications' => 'Notificaciones por email a través de un servidor SMTP externo',
    'mail-gate.smtpSettings' => 'Configuración de servidor SMTP externo',

    'optimization-settings.apacheModulesSection' => 'Módulos Apache',
    'optimization-settings.apacheSettingsSection' => 'Configuración general',
    'optimization-settings.additionalPageHint' => 'Realice modificaciones en los módulos únicamente en el caso de entender totalmente las consecuencias de sus acciones. Tenga en cuenta que algunas modificaciones pueden reducir el rendimiento de Apache o incluso ocasionar que no esté operativo.',
    'optimization-settings.pageHint' => 'Aquí puede optimizar Plesk desactivando módulos Apache que no se estén utilizando. Esta optimización mejora el uso de la memoria y le permite dar servicio a más clientes de hosting. Tenga en cuenta que algunos módulos tienen dependencias entre ellos y que solo pueden activarse o desactivarse cuando los módulos de los que dependen están activados o desactivados.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Esta prestación solo va dirigida a usuarios avanzados.',
    'optimization-settings.apacheRestartInterval' => 'Intervalo de reinicio de Apache (segundos)',
    'optimization-settings.apacheRestartIntervalHint' => 'Una vez en el intervalo especificado, Plesk comprueba los cambios realizados en los dominios y subdominios. En el caso de que alguno de los cambios requiera el reinicio del servidor web, Plesk reiniciará Apache.',
    'optimization-settings.gracefulRestart' => 'Reinicio estable de Apache',
    'optimization-settings.gracefulRestartHint' => 'Selecciónelo para evitar que todos los sitios web alojados en el servidor queden inoperativos cada vez que modifique la configuración de hosting.',
    'optimization-settings.pipedLog' => 'Registros redireccionados',
    'optimization-settings.mpmMode' => 'Modo MPM',
    'optimization-settings.moduleDeprecated' => '(En desuso)',

    'personal-info.contactInfoSection' => 'Información de contacto',
    'personal-info.hint' => 'Aquí puede editar la información de contacto del usuario.',
    'personal-info.hintMyProfile' => 'Aquí puede editar su información de contacto.',

    'php-handler.ini.formHint' => 'Este archivo php.ini solo es usado por este controlador.',
    'php-handler.ini.formHintSharedIni' => 'Este archivo php.ini también es usado por los siguientes controladores PHP: %%handlers%%. La configuración se aplica a todos aquellos sitios web que utilicen estos controladores.',
    'php-handler.ini.incorrectTextForIniFile' => "La configuración especificada no es correcta y no puede guardarse en el archivo php.ini. Error: %%message%%.",

    'php-handler.modules.formHint' => 'La configuración de estas extensiones PHP es únicamente aplicable a este controlador.',
    'php-handler.modules.formHintSharedModules' => 'Esta configuración es aplicable a los siguientes controladores PHP: %%handlers%%. La configuración se aplica a todos aquellos sitios web que utilicen estos controladores.',

    'plan-item-custom.planItemName' => 'Nombre del servicio',
    'plan-item-custom.buttonLabel' => 'Este nombre también se usará como etiqueta para el botón personalizado.',
    'plan-item-custom.planItemDescription' => 'Descripción del servicio',
    'plan-item-custom.buttonTooltip' => 'Este texto también se mostrará como un tooltip para el botón personalizado',
    'plan-item-custom.url' => 'URL vinculada al botón personalizado',
    'plan-item-custom.backgroundImage' => 'Imagen de fondo para el botón personalizado',
    'plan-item-custom.emptyItemName' => 'Proporcione una etiqueta para el servicio.',
    'plan-item-custom.emptyItemDescription' => 'Proporcione un texto para el tooltip del servicio.',
    'plan-item-custom.emptyUrl' => 'Especifique una URL.',
    'plan-item-custom.longItemName' => 'La etiqueta para este servicio es demasiado larga. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.longItemDescription' => 'El texto para este servicio es demasiado largo. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.longUrl' => 'Esta URL es demasiado larga. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.useCustomButton' => 'Usar botón personalizado para el servicio',
    'plan-item-custom.useCustomButtonHint' => 'Añada un botón personalizado a la página principal del usuario y en las páginas del sitio web.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Abrir la URL en Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Especifique si desea abrir la URL en una página de Plesk o en una ventana nueva del navegador.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'No usar marcos',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Si añade un botón personalizado que redirecciona a una extensión de Plesk o a una aplicación del panel del cliente, puede indicar cómo desea que se muestre esta extensión o aplicación: en un marco o como parte del GUI de Plesk.',
    'plan-item-custom.includeDomId' => 'Incluir ID de suscripción',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Incluir el nombre del dominio principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Incluir el nombre de usuario FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Incluir la contraseña FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Incluir ID del cliente',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Incluir el nombre de la empresa del cliente",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Incluir nombre de contacto del cliente",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Incluir el email del cliente",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Seleccione cómo desea previsualizar los sitios web',
    'preview-domain-settings.previewQuick' => 'Previsualización rápida predeterminada',
    'preview-domain-settings.previewDisabled' => 'Desactivar la previsualización rápida',
    'preview-domain-settings.previewQuickDescription' => 'Una opción recomendada que puede usarse de inmediato.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Vista previa rápida de un nombre de dominio en Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Seleccione uno de sus sitios web servidos por Plesk para realizar la previsualización.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Para usar esta prestación, %%link%% al menos un dominio.',
    'preview-domain-settings.subscriptionCreateLink' => 'cree',
    'preview-domain-settings.previewZoneTypeExternal' => 'Vista previa rápida en un nombre de dominio externo',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Usar un nombre de dominio externo (zona DNS). Si selecciona esta opción, añada el siguiente registro DNS (de tipo A) a la zona de dominio externa: *.<Plesk_IP>.external.dom. Aquí, <Plesk_IP> es la dirección IP del servidor Plesk, donde los puntos (.) para IPv4 o los dos puntos (:) para IPv6 se reemplazan por guiones (-). Por ejemplo, *.192-0-2-12.external.dom. Si en Plesk se ha registrado más de una dirección IP, añada un registro para cada una de las direcciones.',
    'preview-domain-settings.sitePreviewProtection' => 'Requerir autenticación',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Requerir nombre de usuario FTP y contraseña para acceder a la previsualización.',
    'preview-domain-settings.nginxNotInstalled' => 'La previsualización rápida predeterminada no está disponible porque no se ha instalado el servidor web nginx.',
    'preview-domain-settings.nginxDisabled' => 'La previsualización rápida predeterminada no está disponible porque el servidor web nginx está desactivado.',

    'reseller-preferences.settingsSection' => 'Configuración',
    'reseller-preferences.multiLogin' => 'Permitir múltiples sesiones',
    'reseller-preferences.language' => 'Idioma del interfaz',
    'reseller-preferences.interfaceView' => 'Seleccione su interfaz',
    'reseller-preferences.serviceProviderView' => 'Vista de proveedor de servicios',
    'reseller-preferences.serviceProviderViewHint' => 'Esta vista va dirigida a revendedores que disponen de clientes. En este modo de visualización, además de gestionar clientes, también puede administrar sus propios sitios web y servicios de hosting.',
    'reseller-preferences.powerUserView' => 'Vista Power User',
    'reseller-preferences.powerUserViewHint' => 'Esta vista proporciona un interfaz sumamente intuitivo que permite a los revendedores gestionar sus propios sitios web, cuentas de correo y otros servicios de hosting. En este modo de visualización no puede gestionar clientes.',

    'reseller.hint' => 'Aquí puede dar de alta un revendedor nuevo para sus servicios de hosting.',
    'reseller.contactInfoSection' => 'Información de contacto',
    'reseller.contactInfoSectionHint' => 'Introduzca la información de contacto del revendedor.',
    'reseller.accessToPanelSection' => 'Acceso a Plesk',
    'reseller.accessToPanelSectionHint' => 'Credenciales que usará el revendedor para acceder a Plesk para la administración de los servicios a los que está suscrito.',
    'reseller.subscription' => 'Suscripción',
    'reseller.subscriptionSectionHint' => 'Seleccione el plan de servicio al que se suscribirá el revendedor.',
    'reseller.servicePlan' => 'Plan de servicio',
    'reseller.none' => 'ninguno',
    'reseller.customizeSubscription' => 'Una vez creado el revendedor, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'reseller.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'security-policy.encryptionSection' => 'Modo de seguridad mejorada',
    'security-policy.encryptionSectionHint' => 'El modo de seguridad mejorada proporciona protección avanzada de los datos confidenciales presentes en Plesk. En este modo, Plesk emplea múltiples mecanismos de seguridad totalmente transparentes para los usuarios de Plesk. Para mejorar la seguridad de Plesk, le recomendamos activar este modo.',
    'security-policy.encryptionEnable' => 'Modo de seguridad mejorada',
    'security-policy.securePassword' => 'Modo de seguridad mejorada',
    'security-policy.strengthSection' => 'Seguridad de contraseñas',
    'security-policy.strengthSectionHint' => 'Cuando los usuarios establecen una contraseña nueva en el sistema (crean una contraseña nueva o bien actualizan una contraseña existente), estos deben cumplir los requisitos de seguridad mínima especificados en esta página. El nivel de seguridad de una contraseña se calcula en función de toda su longitud y complejidad (uso de dígitos, caracteres en mayúsculas y minúsculas y símbolos especiales). Le recomendamos que inste a sus usuarios a utilizar contraseñas más seguras.',
    'security-policy.passwordStrength' => 'Seguridad mínima de contraseñas',
    'security-policy.passwordStrengthVeryWeakHint' => 'Estas contraseñas suelen ser cortas y solo usan un tipo de carácter (en mayúsculas o minúsculas o dígitos). Ejemplo: contraseña. Este nivel de seguridad impide los ataques más sencillos de adivinación de contraseñas.',
    'security-policy.passwordStrengthWeakHint' => 'Estas contraseñas suelen ser cortas y en la mayoría de los casos utilizan un tipo de caracteres (caracteres en mayúsculas o minúsculas o dígitos) con un par de caracteres de otro tipo. Ejemplo: contraseña12. Este tipo de contraseñas proporciona protección básica frente a intentos de adivinación de contraseñas.',
    'security-policy.passwordStrengthMediocreHint' => 'Estas contraseñas suelen ser cortas e incluir caracteres de al menos dos tipos (en mayúsculas o minúsculas, dígitos o caracteres especiales). Ejemplo: Contraseña12. Dichas contraseñas proporcionan una protección fiable frente a ataques de captura de contraseñas.',
    'security-policy.passwordStrengthStrongHint' => 'Estas contraseñas tienen una longitud mínima de 8 caracteres e incluyen al menos un caso de caracteres en mayúsculas y minúsculas, dígitos y caracteres especiales. Ejemplo: P@ssw0rd12. Dichas contraseñas proporcionan una protección segura frente a ataques directos.',
    'security-policy.passwordStrengthStrongerHint' => 'Estas contraseñas tienen una longitud mínima de 16 caracteres e incluyen múltiples casos de caracteres en mayúsculas y minúsculas, dígitos y caracteres especiales. Ejemplo: ~!my_P@$$w0rD123. Aunque dichas contraseñas son bastante difíciles de recordar, sin duda proporcionan un nivel de seguridad óptimo.',
    'security-policy.secureFtpSection' => 'FTP seguro',
    'security-policy.ftpOverSsl' => 'Directiva de uso de FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Aquí puede seleccionar las conexiones que desea permitir.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Aquí puede seleccionar las conexiones que desea permitir. La opción seleccionada se aplicará a todas las direcciones IP del servidor. Si desea utilizar ajustes personalizados para cada dirección IP, seleccione la opción correspondiente y modifique la directiva FTPS en Herramientas y configuración> Direcciones IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Si desea ajustar la configuración FTPS para cada dirección IP, en primer lugar seleccione la opción "Utilizar ajustes de FTPS personalizados para cada dirección IP" en Herramientas y configuración> Directiva de seguridad> FTP seguro.',
    'security-policy.ftpOverSslOptionRequired' => 'Permitir únicamente conexiones FTPS seguras',
    'security-policy.ftpOverSslOptionEnabled' => 'Permitir tanto conexiones FTPS seguras como conexiones FTP no seguras',
    'security-policy.ftpOverSslOptionDisabled' => 'Permitir únicamente conexiones FTP no seguras. No utilizar FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utilizar directiva FTPS personalizada para cada dirección IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Directiva de controladores personalizada',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Active esta opción para que los clientes no puedan sobrescribir los controladores IIS definidos a nivel del servidor mediante el archivo web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Permitir la invalidación de controladores web.config',

    'service-instance.setup-instance.resourcesSection' => 'Recursos del servicio',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Ya está instalado',
    'service-instance.setup-instance.requirementsSection' => 'Servicios necesarios',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'No seleccionado',

    'service-node.ipAddress' => 'Dirección IP del nodo de servicio',
    'service-node.ipAddressLocal' => 'Nodo de servicio local',
    'service-node.description' => 'Descripción del nodo de servicio',
    'service-node.accessKey' => 'Contraseña',
    'service-node.useAccessKey' => 'Usar autenticación',
    'service-node.useAccessKeyDescription' => 'Recomendación acerca del uso de autenticación.',
    'service-node.oldAccessKey' => 'Contraseña anterior',
    'service-node.newAccessKey' => 'Contraseña nueva',
    'service-node.noAccessKeySpecified' => 'No ha especificado la contraseña',

    'service-plan.admin-plan.subscription_section' => 'Común',
    'service-plan.admin-plan.tools_section' => 'Herramientas y recursos',
    'service-plan.admin-plan.apps_section' => 'Aplicaciones y bases de datos',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Apariencia de Plesk',
    'service-plan.admin-plan.statistics_section' => 'Estadísticas',
    'service-plan.admin-plan.general_section' => 'General',
    'service-plan.admin-plan.mail_section' => 'Correo',
    'service-plan.admin-plan.server_section' => 'Servidor',
    'service-plan.admin-plan.modules_section' => 'Extensiones',
    'service-plan.admin-plan.simplePanel' => 'Modo restringido',
    'service-plan.admin-plan.enabled' => 'Activar modo restringido',
    'service-plan.admin-plan.enabledDescription' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador en Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador adicional en Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Proporcionar sólo las aplicaciones que yo seleccione',
    'service-plan.applications-subscription.useFilterDescription' => 'Use esta opción para seleccionar las aplicaciones que deberían estar disponibles para el suscriptor.',
    'service-plan.applications-subscription.applications' => 'Aplicaciones',
    'service-plan.applications-subscription.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una llave de licencia.',

    'service-plan.applications.useFilterLabel' => 'Proporcionar sólo las aplicaciones que yo seleccione',
    'service-plan.applications.useFilterDescription' => 'Use esta opción para seleccionar las aplicaciones que deberían estar disponibles para los suscriptores.',
    'service-plan.applications.applications' => 'Aplicaciones',
    'service-plan.applications.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una llave de licencia.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS del dominio',
    'service-plan.dns.dnsZoneTypeMaster' => 'Principal',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secundaria',

    'service-plan.extras.groupOtherServices' => 'Otros servicios',
    'service-plan.extras.none' => 'Ninguno',

    'service-plan.hosting.enablePhysicalHosting' => 'Habilitar hosting',
    'service-plan.hosting.sectionCoreHosting' => 'Propiedades generales',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Servidor de bases de datos predeterminado',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avanzado',
    'service-plan.hosting.phpSettingsHelpLink' => 'Descubra cómo seleccionar la configuración PHP más adecuada',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Estado de los sitios web si se suspende la suscripción',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Estado de los sitios web en suscripciones suspendidas',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'El estado seleccionado se aplicará a todos los sitios web bajo las suscripciones del plan cuando se suspenda la suscripción, como por ejemplo en el caso de que esta expire o haya vencido su periodo de pago.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'El estado seleccionado se aplicará a los sitios web cuando se suspenda la suscripción, como por ejemplo en el caso de que esta expire o haya vencido su periodo de pago.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Desactivado',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Los visitantes de los sitios web serán redireccionados a la página predeterminada del servidor web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspendido',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Los visitantes de los sitios web serán redireccionados a la página de documentos de error personalizados mediante un código HTTP 503 del motor de búsqueda.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Activo',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Los sitios web seguirán siendo accesibles mediante Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Asignar direcciones IP compartidas',
    'service-plan.ip.allocateExclusiveIp' => 'Asignar direcciones IP dedicadas',
    'service-plan.ip.allocateExclusiveIpV4' => 'Asignar direcciones IPv4 dedicadas',
    'service-plan.ip.allocateExclusiveIpV6' => 'Asignar direcciones IPv6 dedicadas',

    'service-plan.mail.mailService' => 'Activar el servicio de correo',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Activar listas de correo',
    'service-plan.mail.mailToNonExistentUser' => 'Directiva relacionada con mensajes para usuarios no existentes',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Devolver con mensaje',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Reenviar a la dirección',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rechazar',
    'service-plan.mail.mailAutodiscovery' => 'Activar detección automática de correo',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Descubra cómo funciona en la <a href="%%link%%" target="_blank">base de conocimiento</a>',
    'service-plan.mail.bounceMessage' => 'Esta dirección ya no acepta correo.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redireccionar a un servidor de correo externo con la dirección IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - desactivado',

    'service-plan.misc.retainEnabled' => 'Conservar estadísticas de tráfico y web durante',
    'service-plan.misc.logRotation' => 'Rotación de registros',
    'service-plan.misc.logRotationCondition' => 'Condición de rotación de registros',
    'service-plan.misc.logRotationBySize' => 'Por tamaño',
    'service-plan.misc.logRotationByTime' => 'Por hora',
    'service-plan.misc.logRotationDaily' => 'Diariamente',
    'service-plan.misc.logRotationWeekly' => 'Semanalmente',
    'service-plan.misc.logRotationMonthly' => 'Mensualmente',
    'service-plan.misc.logRotationSizeDescription' => 'El valor de tamaño debe estar entre %%min%% y %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Número máximo de archivos de registro',
    'service-plan.misc.compress' => 'Comprimir archivos de registro',
    'service-plan.misc.sendLogToEmail' => 'Una vez Plesk haya recuperado los datos presentes en los archivos de registro de los servidores FTP y web, enviar los registros por email a esta dirección',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'meses',
    'service-plan.misc.logRotationPeriodGreater' => 'El periodo de rotación de registros no puede ser superior al límite a nivel del servidor de %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'De estar desactivado, todos los sitios web de la suscripción usarán el mismo grupo de aplicaciones IIS dedicado para la suscripción.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Seleccione los servicios y privilegios proporcionados con la suscripción.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Mostrar más permisos disponibles',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Mostrar menos permisos',
    'service-plan.permissions-subscription.noShellManagement' => 'No permitido',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Administración del acceso al servidor a través de SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Los clientes pueden activar SSH para su usuario de sistema. El parámetro de hosting "Acceso SSH al shell del servidor bajo el usuario de sistema de la suscripción" actúa como predeterminado.',

    'service-plan.permissions.permissionsTabDescription' => 'Selecciones los servicios y permisos proporcionados con el plan.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Seleccione los servicios y privilegios que se añadirán a las suscripciones con este plan complementario. Tenga en cuenta que los permisos no seleccionados en el complemento no modificarán los parámetros de la suscripción de ninguna manera.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Los permisos permiten a los clientes cambiar algunas opciones de sus suscripciones. Cuando se crea una suscripción, Plesk aplica los valores predeterminados del plan a la configuración que el cliente puede cambiar. A posteriori, la actualización del plan o la aplicación de un plan complementario no invalida los cambios efectuados por el cliente.',
    'service-plan.permissions.showMorePermissions' => 'Mostrar más permisos disponibles',
    'service-plan.permissions.hideMorePermissions' => 'Mostrar menos permisos',
    'service-plan.permissions.noShellManagement' => 'No permitido',
    'service-plan.permissions.systemAccessLabel' => 'Administración del acceso al servidor a través de SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Hace que el parámetro de hosting "Acceso SSH al shell del servidor bajo la suscripción del usuario del sistema" actúe como un valor predeterminado.',

    'service-plan.resources-subscription.overusePolicy' => 'Directiva de sobreuso',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'No permita el sobreuso de recursos. En el caso de que se supere el límite establecido de uso de recursos, la suscripción se suspenderá de forma automática.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Se permite el sobreuso de espacio en disco y tráfico',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Permita el sobreuso de espacio en disco y tráfico pero no permita el sobreuso de otros recursos.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Sobreuso permitido (no recomendado)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Permita al suscriptor usar más recursos de los proporcionados inicialmente con la suscripción.',
    'service-plan.resources-subscription.overuseNotify' => 'Notificarme por email en caso de sobreuso.',
    'service-plan.resources-subscription.oversellPolicy' => 'Directiva de sobreventa de recursos',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Sobreuso permitido',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'El sobreuso permite a un revendedor vender más recursos de los asignados con una suscripción. En el caso de que se permita el sobreuso, un revendedor se regirá por el uso actual de recursos, en vez de regirse  por la asignación inicial de recursos.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita la sobreventa, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con una suscripción, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Defina los límites acerca del uso de los recursos proporcionados con la suscripción.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Mostrar más recursos disponibles',
    'service-plan.resources-subscription.hideMoreResources' => 'Mostrar menos recursos',

    'service-plan.resources.overusePolicy' => 'Directiva de sobreuso',
    'service-plan.resources.overusePolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'No permita el sobreuso de recursos. En el caso de que se supere el límite establecido de uso de recursos, la suscripción se suspenderá de forma automática.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Se permite el sobreuso de espacio en disco y tráfico',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Permita el sobreuso de espacio en disco y tráfico pero no permita el sobreuso de otros recursos.',
    'service-plan.resources.overusePolicyAllowed' => 'Sobreuso permitido (no recomendado)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Permita a los clientes utilizar más recursos de los proporcionados inicialmente por el plan.',
    'service-plan.resources.overuseNotify' => 'Notificarme por email en caso de sobreuso.',
    'service-plan.resources.oversellPolicy' => 'Directiva de sobreventa de recursos',
    'service-plan.resources.oversellPolicyAllowed' => 'Sobreuso permitido',
    'service-plan.resources.oversellPolicyAllowedHint' => 'El sobreuso permite a un revendedor vender más recursos de los asignados con un plan. En el caso de que se permita el sobreuso, un revendedor se regirá por el uso actual de recursos, en vez de regirse  por la asignación inicial de recursos.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita el sobreuso, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con un plan, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',
    'service-plan.resources.mainGroupTitle' => 'Defina los recursos proporcionados con el plan.',
    'service-plan.resources.additionalGroupTitle' => 'Mostrar más recursos disponibles',
    'service-plan.resources.hideMoreResources' => 'Mostrar menos recursos',
    'service-plan.resources.allowSitebuilderUpsell' => 'Permitir al cliente crear sitios web Presence Builder de prueba.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Este parámetro permite al cliente crear más sitios web Presence Builder que los proporcionados por el plan de servicio. Para poder publicarlos, el cliente deberá comprar estos sitios web.',

    'service-plan.servicePlanName' => 'Nombre del plan de servicio',
    'service-plan.resellerPlanName' => 'Nombre del plan de revendedor',
    'service-plan.addonPlanName' => 'Nombre del plan complementario',
    'service-plan.adminPlanPermissionsTab' => 'Herramientas administrativas',
    'service-plan.adminPlanPermissionsTabDescription' => 'Seleccione las prestaciones a disposición del administrador cuando está activado el modo restringido.',
    'service-plan.hostingPermissionsTab' => 'Herramientas de hosting',
    'service-plan.hostingPermissionsTabDescription' => 'Seleccione las herramientas de hosting web y la configuración a disposición del administrador en el modo de visualización Power User cuando el modo restringido está activado.',
    'service-plan.resourcesTab' => 'Recursos',
    'service-plan.resourcesTabDescription' => 'Defina los recursos proporcionados con el plan y la directiva acerca del uso de los recursos.',
    'service-plan.subscriptionResourcesTabDescription' => 'Defina los recursos proporcionados con la suscripción y la directiva acerca del uso de los recursos.',
    'service-plan.hostingTab' => 'Parámetros de hosting',
    'service-plan.hostingTabDescription' => 'Especifique los parámetros del servicio de hosting proporcionados con el plan. Tenga en cuenta que la configuración de hosting indicada en el plan complementario no se aplicará a aquellas suscripciones a las que el plan de servicio o el plan complementario concedió el permiso "Administración de la configuración de hosting".',
    'service-plan.secureSettingsDescription' => 'Si desea que el hosting proporcionado sea más seguro, %%link%%. Tenga en cuenta que algunos de los permisos, de haberse concedido, permiten a los suscriptores cambiar estos parámetros de configuración. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'aplicar configuración de seguridad predeterminada',
    'service-plan.secureSettingsHelpLink' => 'Más info acerca de la configuración de hosting seguro',
    'service-plan.mailTab' => 'Correo',
    'service-plan.mailTabDescription' => 'Indique los parámetros del servicio de correo proporcionado con el plan.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Indique los parámetros del servicio DNS proporcionado con el plan.',
    'service-plan.performanceTab' => 'Rendimiento',
    'service-plan.performanceTabDescription' => 'Indique los parámetros del sistema que afectan al rendimiento de todos los servicios proporcionados con el plan.',
    'service-plan.permissionsTab' => 'Permisos',
    'service-plan.miscTab' => 'Registros  y estadísticas',
    'service-plan.miscTabDescription' => 'Indique la cantidad de registros y estadísticas de las suscripciones del plan que deberían guardarse. Tenga en cuenta que estas opciones no se sincronizan en las suscripciones.',
    'service-plan.miscTabAdminPlanDescription' => 'Especifique cómo deberían guardarse las estadísticas y los registros de las suscripciones.',
    'service-plan.extrasTab' => 'Servicios adicionales',
    'service-plan.extrasTabDescription' => 'Seleccione los servicios que deberían incluirse en el plan además de hosting web, DNS y servicios de mensajería.',
    'service-plan.ipTab' => 'Direcciones IP',
    'service-plan.ipTabDescription' => 'Defina los parámetros de los recursos IP proporcionados con el plan.',
    'service-plan.applicationsTab' => 'Aplicaciones',
    'service-plan.applicationsTabDescription' => 'Seleccione las aplicaciones que deberían estar disponibles en el plan. Puede escoger proporcionar todas las aplicaciones disponibles en el Catálogo de Aplicaciones, además de aquellas que usted haya cargado al servidor, o escoger las aplicaciones manualmente. Si desea proporcionar todas las aplicaciones disponibles, no deberá realizar ninguna acción en esta pestaña. Simplemente vaya a la pestaña Permisos y seleccione la opción Acceso al catálogo de aplicaciones. Si desea seleccionar las aplicaciones manualmente, puede hacerlo en esta pestaña.',
    'service-plan.applicationsTabDescription-addon' => 'Seleccione las aplicaciones que desea que estén disponibles en el complemento.',
    'service-plan.applicationsTabDescription-subscription' => 'Seleccione las aplicaciones que deberían estar disponibles en la suscripción. Puede escoger proporcionar todas las aplicaciones disponibles en el Catálogo de Aplicaciones, además de aquellas que usted haya cargado al servidor, o escoger las aplicaciones manualmente. Si desea proporcionar todas las aplicaciones disponibles, no deberá realizar ninguna acción en esta pestaña. Simplemente vaya a la pestaña Permisos y seleccione la opción Acceso al catálogo de aplicaciones. Si desea seleccionar las aplicaciones manualmente, puede hacerlo en esta pestaña.',
    'service-plan.planSyncSubsriptionWarning' => 'Algunas suscripciones no han sido sincronizadas con el plan. Estas se han marcado como \'No sincronizadas\' en la lista de suscripciones. Si desea volver a intentar realizar la sincronización, vaya a la página general de una suscripción y haga clic en el botón Sincr.',
    'service-plan.planSyncResellerWarning' => 'Algunos revendedores no han sido sincronizados con el plan. Estos se han marcado como \'No sincronizados\' en la lista de revendedores. Si desea volver a intentar realizar la sincronización, vaya a la página general de un revendedor y haga clic en el botón Sincr.',
    'service-plan.planSyncAdminWarning' => 'No se pudieron aplicar los cambios a las suscripciones porque Plesk no proporciona algunos de los servicios o recursos afectados por dichos cambios. Motivo: %%reason%%',
    'service-plan.duplicateName' => 'Ya existe un plan con este nombre.',
    'service-plan.phpSettingsTab' => 'Configuración de PHP',
    'service-plan.phpSettingsTabDescription' => 'Aquí puede especificar la configuración PHP para cada suscripción que invalidará la configuración definida por el archivo php.ini a nivel del servidor. Esto puede resultar útil si desea limitar el consumo de los recursos del sistema por parte de los scripts PHP de los clientes. De permitirse, los clientes pueden reemplazar esta configuración PHP por su propia configuración individualizada por dominio. Cuando usted defina un parámetro al valor predeterminado, PHP usará el valor del parámetro de la configuración PHP a nivel de servidor. Tenga en cuenta que se soportan los siguientes marcadores de posición: {DOCROOT}y {WEBSPACEROOT} corresponden al directorio raíz de documentos de un dominio y al directorio raíz de una suscripción que obtiene una configuración personalizada de PHP; {TMP} corresponde al directorio que almacena los archivos temporales.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aquí puede especificar la configuración PHP para cada suscripción, que invalidará la configuración definida por el plan de servicio principal. Esto puede resultarle útil si desea eliminar algún grupo de limitaciones PHP en el plan de servicio principal. Al definir un parámetro al valor predeterminado, PHP usará el valor del parámetro de la configuración PHP del plan de servicio. Tenga en cuenta que se soportan los siguientes marcadores de posición: {DOCROOT}y {WEBSPACEROOT} corresponden al directorio raíz de documentos de un dominio y al directorio raíz de una suscripción que obtiene una configuración personalizada de PHP; {TMP} corresponde al directorio que almacena los archivos temporales.',
    'service-plan.phpSettingsPhpVersion' => 'Su versión actual de PHP es %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aquí puede especificar la configuración PHP para cada suscripción que invalidará la configuración definida por el archivo php.ini a nivel del servidor. Cuando usted defina un parámetro al valor predeterminado, PHP usará el valor del parámetro de la configuración PHP a nivel de servidor.',
    'service-plan.webServerSettingsTab' => 'Servidor web',
    'service-plan.webServerSettingsTabDescription' => 'Aquí puede especificar los parámetros de configuración del servidor web Apache para este plan de servicio. Si Apache se está ejecutando con nginx como servidor frontend, en esta página también puede indicar los parámetros de configuración de nginx. Dicha configuración se aplicará a todos los dominios nuevos. De todos modos, cuando realice alguna modificación en esta configuración, los cambios efectuados no se aplicarán a los dominios existentes.',
    'service-plan.servicesTab' => 'Servicios',
    'service-plan.servicesTabDescription' => 'Aquí puede indicar los servicios que desea asignar al plan de servicio.',
    'service-plan.servicePropertiesTab' => 'Propiedades de %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Aquí puede especificar las propiedades del servicio %%serviceName%% asignado al plan de servicio.',
    'service-plan.longTaskWarning' => 'Dispone de %%subscriptionsCount%% suscripciones en este plan. Tenga en cuenta que la tarea de sincronización puede tardar bastante en completarse y que esta se realizará en segundo plano.',
    'service-plan.hostingParametersTab' => 'Parámetros de hosting',
    'service-plan.adminInfoSection' => 'Información para el administrador',
    'service-plan.descriptionInPanel' => 'Descripción',
    'service-plan.longDescription' => 'La descripción proporcionada es demasiado larga.',
    'service-plan.conflictPermissions' => 'No se pudieron conceder los siguientes permisos porque estos entran en conflicto con el plan de revendedor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipo de inicio',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automático',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Desactivar',
    'services.change-startup-type.autoActionError' => 'No se pudo configurar el tipo de inicio a \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'No se pudo establecer el tipo de inicio a \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'No se pudo establecer el tipo de inicio a \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Restablecer los valores predeterminados',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restaure los parámetros de sesión a los valores predeterminados.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Los parámetros de sesión tienen los valores predeterminados.',
    'sessions.settings.idleTime' => 'Tiempo de inactividad de la sesión',
    'sessions.settings.disableCheckSessionIp' => 'Permitir cambios de dirección IP durante una única sesión',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controles',

    'settings-ui.interface-views.description' => "Puede ver el IU usando distintos modos de visualización. En función de la vista usada, las funciones y las opciones de configuración estarán en sitios distinto, incluso puede que estén desactivados o activados. La finalidad de las distintas vistas es ofrecer la mejor experiencia posible a los distintos perfiles de usuario.",
    'settings-ui.interface-views.panelSimpleLink' => 'Herramientas y configuración > Configuración de modo restringido',
    'settings-ui.interface-views.useCustomView' => 'Activar modo restringido',
    'settings-ui.interface-views.useCustomViewHint' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador en Plesk. Si desea cambiar la disponibilidad de las acciones, vaya a %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => "Esta vista proporciona un único interfaz simplificado a aquellos administradores de servidores y les permite administrar sus propios sitios web y cuentas de correo, entre otros servicios.",
    'settings-ui.interface-views.selectUiModeTitle' => "Selección de su interfaz",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vista Power User",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vista de proveedor de servicios",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Este modo de visualización proporciona interfaces para su uso por parte de administradores de servidores, revendedores y usuarios finales de hosting.",

    'sitebuilder.trial.description' => 'Aquí puede configurar el modo Probar y comprar (anteriormente denominado escenario de adquisición de clientes). En este modo, el cliente puede crear un sitio web con todas las funciones disponibles en la aplicación incluida Presence Builder. En cualquier caso, la publicación de sitios web de prueba no está disponible para los clientes hasta que estos contraten un plan de servicio de hosting o adquieran un complemento para el plan. El modo Probar y comprar también puede concederse a los clientes ya existentes a través de un plan de hosting o un complemento de plan. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Para más información, consulte la documentación.',
    'sitebuilder.trial.lifetimeLabel' => 'Vigencia de sitios web de prueba',
    'sitebuilder.trial.lifetimeUnits' => 'días',
    'sitebuilder.trial.lifetimeDescription' => 'Esto es el tiempo que debería transcurrir antes de que estos sitios de prueba no adquiridos por los clientes fueran eliminados del servidor.',
    'sitebuilder.trial.signupLabel' => 'Habilitar acceso público a modo de prueba',
    'sitebuilder.trial.signupDescription' => 'Si desea ampliar su cartera de clientes publicitando hosting con Presence Builder y proporcionándoles una demo de este software, habilite el acceso público al modo de pruebas y publique la URL de acceso del modo de pruebas en su sitio web.',
    'sitebuilder.trial.signupLinkLabel' => 'URL de acceso al modo de pruebas',
    'sitebuilder.trial.signupLinkDescription' => 'Esta URL abrirá Presence Builder en modo de pruebas. Publique esta URL en su sitio web para publicitar hosting con Presence Builder y ampliar su cartera de clientes.',
    'sitebuilder.trial.promotionLabel' => 'Mostrar notificación de modo de prueba en el editor de Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Use esta opción si desea mostrar una notificación adicional sobre la ejecución de Presence Builder en modo de prueba.',

    'update-settings.policyHintForPum' => 'Aquí puede configurar la instalación automática de actualizaciones. El email de notificación puede enviarse cuando existan actualizaciones que puedan instalarse manualmente o bien cuando se hayan instalado actualizaciones de forma manual.',
    'update-settings.policyHint' => 'El email de notificación puede enviarse cuando existan actualizaciones que puedan instalarse de forma manual o que se instalaron de forma automática.',
    'update-settings.branchDisabledDescription' => 'No notificarme cuando existan actualizaciones',
    'update-settings.automaticPatchesInstallation' => 'Instalar actualizaciones de Plesk automáticamente (Recomendado)',
    'update-settings.automaticPatchesInstallationHint' => 'Las actualizaciones críticas de seguridad siempre se instalan automáticamente.',
    'update-settings.automaticPatchesThirdParty' => 'Instalar actualizaciones para componentes de terceros incluidos en Plesk automáticamente',
    'update-settings.automaticSystemPackageUpdates' => 'Instalar actualizaciones de paquetes de sistema de forma automática',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Tenga en cuenta que esto instalará automáticamente los componentes de terceros incluidos en Plesk',
    'update-settings.automaticPatchesNotification' => 'Notificar sobre actualizaciones de paquetes de sistema instalados y disponibles',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Dirección de email',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frecuencia de notificaciones',
    'update-settings.daily' => 'Cada día',
    'update-settings.weekly' => 'Cada semana',
    'update-settings.generalSection' => 'General',
    'update-settings.notificationsSection' => 'Notificaciones',
    'update-settings.safeUpdatesSection' => 'Actualizaciones seguras',
    'update-settings.safeUpdatesSectionHint' => 'Plesk se encarga de que las actualizaciones de paquetes del sistema se instalen desde el mismo repositorio desde el que inicialmente se instalaron los paquetes. Este tipo de actualizaciones se consideran seguras. Si las desactiva, es posible que su administrador de paquetes del sistema instale actualizaciones desde cualquier repositorio del sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'A menos que sea un usuario avanzado, le recomendamos dejar activadas las actualizaciones seguras. Las actualizaciones indiscriminadas de los paquetes del sistema desde otros repositorios pueden afectar negativamente al funcionamiento de su servidor.',
    'update-settings.allowSafeUpdates' => 'Activar actualizaciones seguras para paquetes del sistema',

    'requiredFields' => 'Campos obligatorios',
];