<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Om din webbplats värdbaseras på en IP-adress (som inte delas med andra användare eller webbplatser), kan du konfigurera en katalog inom webbplatsen där andra användare kommer att anonymt kunna ladda ned eller ladda upp filer via FTP. När anonym FTP är påslagen, kan användare logga in på katalogen på en adress i likhet med ftp://ftp.your-domain.com med användarnamnet "anonymous" og ett valfritt lösenord.',
    'anonymous-ftp.displayLogin' => 'Visa inloggningsmeddelande',
    'anonymous-ftp.loginText' => 'Meddelandetext',
    'anonymous-ftp.incomingDir' => 'Tillåt överföring till inkommande katalog',
    'anonymous-ftp.incomingSubDir' => 'Tillåt skapande av kataloger i den inkommande katalogen',
    'anonymous-ftp.incomingReadable' => 'Tillåt nedladdning från den inkommande katalogen',
    'anonymous-ftp.quota' => 'Begränsa diskutrymmet i den inkommande katalogen',
    'anonymous-ftp.maxConnections' => 'Begränsa antalet samtidiga anslutningar',
    'anonymous-ftp.bandwidth' => 'Begränsa nerladdningsbandvidden för denna virtuella FTP-domän',
    'anonymous-ftp.unlimited' => 'Obegränsat',

    'aps.catalog.loading' => 'Laddar',
    'aps.catalog.searchName' => 'Program',
    'aps.catalog.searchVendor' => 'Leverantör',
    'aps.catalog.searchPackager' => 'Paketeraren',
    'aps.catalog.searchLicenseType' => 'Licenstyp',
    'aps.catalog.searchLicenseTypeAny' => 'Valfri',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Kommersiell',
    'aps.catalog.showSearch' => 'Visa sökning',
    'aps.catalog.hideSearch' => 'Dölj sökning',
    'aps.catalog.buttonSearch' => 'Sök',
    'aps.catalog.buttonResetSearch' => 'Återställ sökning',
    'aps.catalog.showCategories' => 'Välj en kategori nedan eller sök appar genom att använda sökrutan',
    'aps.catalog.searchResults' => 'Sökresultat',
    'aps.catalog.buttonInstall' => 'Installera',
    'aps.catalog.buttonInstallTooltip' => 'Installera snabbt den senaste versionen av appen med optimala standardparametrar.',
    'aps.catalog.buttonAdvancedInstall' => 'Installera (anpassad)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Installera den senaste versionen av appen och anpassa alla parametrar.',
    'aps.catalog.buttonInstallOldVersion' => 'Installationsversion',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Installera vald version av appen och anpassa alla parametrar.',
    'aps.catalog.buttonInstallDescription' => 'Installera appen på en site om du redan har en aktiveringskod, eller om du bara vill prova den.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Installera denna gratis app på en site.',
    'aps.catalog.version' => 'Version',
    'aps.catalog.moreVersions' => 'Fler versioner',
    'aps.catalog.release' => 'Släppa',
    'aps.catalog.overview' => 'Översikt',
    'aps.catalog.noApplicationsInCategory' => 'Inga program finns tillgängliga i denna kategori. Välj en annan kategori.',
    'aps.catalog.noCategoriesSelected' => 'Markera en kategori för att bläddra bland alla program som är tillgängliga i denna kategori.',
    'aps.catalog.noSearchResults' => 'Din sökning matchar inga appar.',
    'aps.catalog.connectionFailed' => 'Anslutningen till katalogprogrammet misslyckades. %%retryLink%%.',
    'aps.catalog.retry' => 'Försök igen',
    'aps.catalog.categoriesError' => 'Listan över kategorier kunde inte laddas för ögonblicket.',
    'aps.catalog.applicationsError' => 'Listan med program kunde inte laddas för närvarande.',
    'aps.catalog.detailsError' => 'Programdetaljerna kunde inte laddas för närvarande.',
    'aps.catalog.searchError' => 'Sökresultaten kunde inte laddas för ögonblicket.',
    'aps.catalog.changelogEntry' => 'v%%version%% (utgåva %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Ändringshistorik',
    'aps.catalog.officialApplicationSite' => 'Leverantörsinfo',
    'aps.catalog.returnToCategories' => '<<< Tillbaka till progamlistan',
    'aps.catalog.buttonUninstall' => 'Ta bort',
    'aps.catalog.gotoHome' => 'Hem',
    'aps.catalog.all' => 'Alla',
    'aps.catalog.buttonDetails' => 'Mer information',
    'aps.catalog.buttonBuy' => 'Köp nu',
    'aps.catalog.buttonBuyTooltip' => 'Köp appen',
    'aps.catalog.buttonBuyDescription' => 'Besök vår butik för att köpa en aktiveringskod för appen.',
    'aps.catalog.buttonDownload' => 'Hämta',
    'aps.catalog.buttonDownloadDescription' => 'Ladda ner appen om du redan har en aktiveringskod, eller bara vill testa den själv.',
    'aps.catalog.marketplaceMoreInfo' => 'För mer information, besök %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'appsäljarens webbplats',

    'aps.configure.installedAt' => "Installerat på",
    'aps.configure.otherSettings' => "Övrigt",
    'aps.configure.globalSettings' => 'Paketinställningar',
    'aps.configure.passwordConfirmation' => 'Bekräfta lösenord',
    'aps.configure.databaseParams' => 'Databasparametrar',
    'aps.configure.noInstallationUrlAvailable' => 'Inga (extern app)',
    'aps.configure.updateSettingsSection' => 'Uppdatera inställningar',
    'aps.configure.forceUpdates' => 'Uppdatera automatiskt denna app när uppdateringar är tillgängliga',
    'aps.configure.forceUpdatesHint' => 'Appen kommer att ta emot automatiska uppdateringar till nyare versioner. Varning: Använd detta alternativ försiktigt eftersom uppdateringar märkbart kan påverka app-funktionaliteten. Exempelvis kan app-tillägg sluta fungera med en annan version av appen.',

    'aps.install.showAllSettings' => 'Visa alla inställningar',
    'aps.install.showLessSettings' => 'Visa minimala inställningar',
    'aps.install.install' => 'Installera',
    'aps.install.otherSettings' => 'Övriga inställningar',
    'aps.install.globalSettings' => 'Paketinställningar',
    'aps.install.passwordConfirmation' => 'Bekräfta lösenord',
    'aps.install.provisionsSectionLabel' => 'Installationssökväg',
    'aps.install.context' => 'Specificera platsen där detta webbprogram ska installeras',
    'aps.install.registerAsWebmailSection' => 'Webbmail-registrering',
    'aps.install.registerAsWebmailDescription' => "Välj detta alternativ om appen är en webbmailklient. Detta gör att appen visas bland tillgängliga webbposttjänster i postinställningarna för abonnemangen och tjänsteplanerna. Adminsitratören kan konfigurera den offentliga åtkomst-URL för webbposten i Serverhantering > Inställningar > Webbpost.",
    'aps.install.registerAsWebmailLabel' => 'Registrera som webbposttjänst',
    'aps.install.addItem' => 'Lägg till',
    'aps.install.removeItem' => 'Ta bort',
    'aps.install.updateSettingsSection' => 'Uppdatera inställningar',
    'aps.install.forceUpdates' => 'Uppdatera automatiskt denna app när uppdateringar är tillgängliga',
    'aps.install.forceUpdatesHint' => 'Appen kommer att ta emot automatiska uppdateringar till nyare versioner. Varning: Använd detta alternativ försiktigt eftersom uppdateringar märkbart kan påverka app-funktionaliteten. Exempelvis kan app-tillägg sluta fungera med en annan version av appen.',

    'aps.invalid-requirements.requirementsLegend' => 'Krav',
    'aps.invalid-requirements.domainLegend' => 'Webbplats',
    'aps.invalid-requirements.context' => 'Markera en annan webbplats',
    'aps.invalid-requirements.backToApplicationList' => 'Tillbaka till progamlistan',

    'aps.license.title' => 'Installation av %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'För att installera detta program, måste du läsa slutanvändarens licensavtal och godkänna dess villkor.',
    'aps.license.licenseAgree' => 'Jag accepterar villkoren i licensavtalet',

    'aps.services-list-customization.settings' => 'Inställningar',

    'asp-dot-net.change-version.title' => 'Markerar ASP.NET-versionen',
    'asp-dot-net.change-version.frameworkVersion' => 'ASP.NET framework versionen',
    'asp-dot-net.change-version.success' => 'ASP.NET-versionen ändrades.',

    'asp-dot-net.settings.casSettingsSection' => "Kodåtkomstsäkerhet",
    'asp-dot-net.settings.clientScriptsSection' => "Skriptbiblioteksinställningar",
    'asp-dot-net.settings.connStringsSection' => "Anslutningsstränghanteraren",
    'asp-dot-net.settings.customErrorsSection' => "Inställningar för anpassade felsidor",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework-version",
    'asp-dot-net.settings.globalizationSection' => "Globaliseringsinställningar",
    'asp-dot-net.settings.otherSection' => "Sessionsinställningar",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilering och felsökning",
    'asp-dot-net.settings.authMode' => "Autentiseringsläge",
    'asp-dot-net.settings.connStrings' => "Anslutningssträngar",
    'asp-dot-net.settings.connStringsInvalid' => "Vissa fält är tomma eller innehåller ett felaktigt värde.",
    'asp-dot-net.settings.connStringName' => "Namn",
    'asp-dot-net.settings.connStringValue' => "Anslutningsparametrar",
    'asp-dot-net.settings.connStringsDescription' => "Namn / anslutningsparametrar",
    'asp-dot-net.settings.culture' => "Kultur",
    'asp-dot-net.settings.customErrMode' => "Läge för anpassade felsidor",
    'asp-dot-net.settings.customErrorRedirect' => "Hänvisningsadressen",
    'asp-dot-net.settings.customErrorStatus' => "Statuskod",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Statuskoden måste vara ett heltal.",
    'asp-dot-net.settings.customErrors' => "Anpassade felsidor",
    'asp-dot-net.settings.customErrorsDescription' => "Statuskod / Omdirigerings-URL",
    'asp-dot-net.settings.customErrorsInvalid' => "Vissa fält är tomma eller innehåller ett felaktigt värde.",
    'asp-dot-net.settings.debugMode' => "Slå på felsökning.",
    'asp-dot-net.settings.defLanguage' => "Grundspråk för webbsidan",
    'asp-dot-net.settings.tempDirectory' => "Temporär katalog",
    'asp-dot-net.settings.fileEnc' => "Filkodning",
    'asp-dot-net.settings.fileEncInvalid' => "Det angivna värdet för filkodningsparametern är ogiltigt.",
    'asp-dot-net.settings.pathToLib' => "Sökväg till Microsofts skriptbibliotek",
    'asp-dot-net.settings.pathToLibInstall' => "Installera",
    'asp-dot-net.settings.reqEnc' => "Kodning för begäran",
    'asp-dot-net.settings.reqEncInvalid' => "Det angivna värdet för kodning av förfrågan-parametern är ogiltigt.",
    'asp-dot-net.settings.resEnc' => "Kodning för svar",
    'asp-dot-net.settings.resEncInvalid' => "Det angivna värdet för kodning av respons-parametern är ogiltigt.",
    'asp-dot-net.settings.sessTimeout' => "Tidsgräns för session (minuter)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Det angivna värdet för sessionens tidsgränsparameter är ogiltigt. Ange ett positivt heltal som är mindre än eller lika med %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Strängnamn för anslutning används redan.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Statuskoden måste vara mellan 100 och 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Statuskoden används redan.",
    'asp-dot-net.settings.trustLevel' => "CAS-förtroendenivå",
    'asp-dot-net.settings.uiCulture' => "UI-kultur",
    'asp-dot-net.settings.version' => "Version",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Tillåt överstyrning CAS-förtroendenivå på webbplatsen',
    'asp-dot-net.settings.updateSuccess' => 'Uppdatering utförd',

    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.cloneInProgress' => 'Klonar databasen %%source%% till databasen %%destination%%. Du kommer att meddelas om förloppet via e-post (%%email%%).',
    'database.clone.unableToClone' => 'Kunde inte kopiera databasen "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Kunde inte skapa databasen "%%destination%%" på den angivna servern.',
    'database.clone.databaseCloned' => 'Databasen "%%source%%" kopierades.',
    'database.clone.emailSubjSuccess' => 'Databasen "%%sourceDatabase%%" haar kopierats.',
    'database.clone.emailSubjFailure' => 'Kopiering av databasen "%%sourceDatabase%%" misslyckades.',
    'database.clone.emailBodySuccess' => 'Databasen "%%sourceDatabase%%" (%%sourceHost%%) har kopierats till databasen "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Kan inte kopiera databas "%%sourceDatabase%%" (%%sourceHost%%) till databasen "%%destDatabase%%" (%%destHost%%). Kopieringsproceduren misslyckades.',
    'database.clone.localServer' => 'lokal server',

    'database.repair-orphaned.formDescription' => 'Denna användare blev ägarlös efter återställningsprocessen. Ange ett lösenord för denna användare för att lösa problemet. Om denna användare ska vara en systemanvändare utan lösenord, kör reparationsnyttoprogrammet med tomt lösenordsfält.',
    'database.repair-orphaned.login' => 'Databasanvändarnamn',
    'database.repair-orphaned.pass' => 'Lösenord',
    'database.repair-orphaned.pass2' => 'Bekräfta lösenord',
    'database.repair-orphaned.users' => 'Några användare behöver din uppmärksamhet. Det finns flera ägarlösa användare som ska repareras för att fungera ordentligt.',
    'database.repair-orphaned.orphaned' => 'Användare är ägarlös. %%gui begin:link%%Reparera nu%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparera',

    'database.repair.fixSelected' => 'Reparation vald',
    'database.repair.fix' => 'Reparera',

    'database.user.username' => 'Databas användarnamn',
    'database.user.password' => 'Lösenord',
    'database.user.passwordConfirmation' => 'Bekräfta lösenord',
    'database.user.server' => 'Databasserver',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Databas',
    'database.user.anyDatabase' => 'Valfri',
    'database.user.dataAccess' => 'Dataåtkomst',
    'database.user.structureAccess' => 'Strukturåtkomst',
    'database.user.globalAccess' => 'Globala befogenheter',
    'database.user.globalAccessHint' => 'Globala befogenheter fungerar för alla databaser i detta hostingkonto.',
    'database.user.aclRadio' => 'Åtkomstkontroll',
    'database.user.aclLocalhost' => 'Tillåt endast lokala anslutningar',
    'database.user.aclAny' => 'Tillåt fjärranslutningar från valfri värd',
    'database.user.aclCustom' => 'Tillåt fjärranslutningar från',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe specificerade värdarna tillåtas åtkomst till databasen å vägnar av denna användaren.",
    'database.user.remoteAccess' => 'Fjärråtkomst',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivna IP-adresserna tillåts åtkomst till databasservern via en brandväggsregel. Dina ändringar i denna lista kommer att modereras i förväg av din värdtjänstleverantör.",
    'database.user.example' => "Till exempel:\n%%example%%",
    'database.user.denied' => 'Använd systemets brandväggsregler',
    'database.user.allowed' => 'Tillåt fjärranslutningar från',
    'database.user.default' => 'Anvànd dessa registreringsuppgifter som standard för åtkomst till %%webadmin%%',
    'database.user.remoteAccessHint' => 'Kontakt din värdtjänstleverantör och försäkra dig om att det val du specificerade ovanför är kompatibelt med aktuella brandväggsregler för inkommande åtkomst till MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'WebAdmin',
    'database.user.role' => 'Roll',
    'database.user.roleReadWrite' => 'Läs och skriv',
    'database.user.roleWriteOnly' => 'Endast skrivning',
    'database.user.roleReadOnly' => 'Endast läsning',
    'database.user.roleCustom' => 'Anpassad',

    'database.versionCut' => 'v%%version%%',

    'deployment-section.deploymentDisabledHint' => 'Ladda upp filer från en Git-katalog',
    'deployment-section.deploymentEnabledHint' => 'Aktivera Git-support',
    'deployment-section.deploymentSectionLegend' => 'Dina filer att kopiera till värddatorn',
    'deployment-section.deploymentSectionDescriptionHint' => 'Om du lämnar Git-stödet inaktiverat, kommer rotkataloger (hemsida/programroten och dokumentroten) att skapas tomt, och platsen kommer att visa standardsidan i webbläsaren. Du kommer att behöva ladda upp filer på din webbplats till dokumentroten via FTP eller File Manager. Alternativt aktivera Git nu eller senare (på webbplatser och domäner) och ladda upp filer från en Git-katalog.',

    'dns-zone.add-acl-record.description' => 'Lägg till en IP-adress för en DNS-server som kan ta emot en kopia av DNS-zonen.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-adress',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-adress/mask',

    'dns-zone.record.add-title' => "Lägg till en ny resurspost till zonmallen",
    'dns-zone.record.add-ns-title' => "Lägg till namnserver",
    'dns-zone.record.edit-title' => "Redigera resursposten",
    'dns-zone.record.edit-success' => "DNS-post uppdaterad.",
    'dns-zone.record.add-success' => "DNS-post skapad.",
    'dns-zone.record.type' => "Inlägg typ",
    'dns-zone.record.domainName' => "Domännamn",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Namnserver",
    'dns-zone.record.optionOff' => 'Av',
    'dns-zone.record.optionOn' => 'På',
    'dns-zone.record.protocol' => "Protokoll",
    'dns-zone.record.priority' => "Prioritet",
    'dns-zone.record.priorityLow' => "låg (%%priority%%)",
    'dns-zone.record.priorityHigh' => "mycket hög (%%priority%%)",
    'dns-zone.record.weightLow' => "låg (%%weight%%)",
    'dns-zone.record.weightHigh' => "mycket hög (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-adress",
    'dns-zone.record.ipAddressDescription' => "Till exempel, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Till exempel <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-adress",
    'dns-zone.record.ipAddressV6Description' => "Till exempel, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Till exempel <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Till exempel, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Till exempel <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Till exempel, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Canonical namn",
    'dns-zone.record.mailDomain' => "E-postdomän",
    'dns-zone.record.mxServer' => "E-postutväxlingsserver",
    'dns-zone.record.mxServerPriority' => "Specificera prioritet för e-postutväxlingsservern",
    'dns-zone.record.txtRecord' => "TXT-post",
    'dns-zone.record.txtRecordString' => "Ange en strängpost",
    'dns-zone.record.txtSpfSyntax' => "SPF-post",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Fel värde för TXT-posten blev angivet.",
    'dns-zone.record.quotedTxtRecord' => "TXT-registervärdet måste vara en enda sträng utan citattecken.",
    'dns-zone.record.dsRecord' => "DS-post",
    'dns-zone.record.dsRecordDescription' => "Till exempel, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "Fel värde för DS-posten blev angivet.",
    'dns-zone.record.serviceName' => "Tjänstnamn",
    'dns-zone.record.serviceNameDescription' => 'Till exempel SIP (utan understreckstecknet).',
    'dns-zone.record.protocolNameDescription' => 'Till exempel tcp (utan understreckstecknet).',
    'dns-zone.record.portDescription' => 'Till exempel 25 (utan understreckstecknet).',
    'dns-zone.record.srvWeight' => "Relativ vikt för poster med samma prioritet",
    'dns-zone.record.targetHost' => "Målvärddator",
    'dns-zone.record.targetHostDescription' => "Exempelvis, example.com",
    'dns-zone.record.targetPort' => "Målport",
    'dns-zone.record.targetPortDescription' => 'Till exempel, 8443.',
    'dns-zone.record.retrieveDataError' => "Datavärdet har inte hittats.",
    'dns-zone.record.unknownTypeError' => "Okänd DNS-posttyp.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Kan inte ställa in NULL MX-värdet medan andra MX-uppgifter är närvarande',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Kan inte ställa in icke-NULL MX-värdet medan andra NULL MX-uppgiften är närvarande',
    'dns-zone.record.masterShouldBeRemote' => "Du måste ha två olika auktoritativa namnservrar på separata värdar.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Värde",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokoll',
    'dns-zone.record.tlsaUsage' => 'Användning',
    'dns-zone.record.tlsaSelector' => 'Selektor',
    'dns-zone.record.tlsaMatching' => 'Matchningstyp',
    'dns-zone.record.tlsaCertData' => 'Associeringsdata för certifikat',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Se %%link%% för detaljer',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, sektion 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, sektion 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, sektion 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, sektion 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Till exempel example.com. Ett tomt värde innebär att värdtjänsten är samma som domännamnet.',
    'dns-zone.record.httpsProtocols' => 'Protokoll',
    'dns-zone.record.httpsProtocolsDescription' => 'En kommaseparerad lista över protokoll som stöds av målet. Till exempel: h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Tvinga enbart med hjälp av de angivna protokollen. Protokollistan ovan får inte vara tom.',
    'dns-zone.record.httpsIpv4hint' => 'IPv4-adresstips',
    'dns-zone.record.httpsIpv4hintDescription' => 'En kommaseparerad lista över IPv4-adresser som kan användas av en klient för att nå tjänsten.',
    'dns-zone.record.httpsIpv6hint' => 'IPv6-adresstips',
    'dns-zone.record.httpsIpv6hintDescription' => 'En kommaseparerad lista över IPv6-adresser som kan användas av en klient för att nå tjänsten.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Visaconds",
    'dns-zone.record.invalidValue' => 'Värdet är ogiltigt. Det kan vara från 1 sekund till 2147483647 sekunder.',
    'dns-zone.record.ttlDefaultValue' => 'Standardvärde: %%value%% sekunder',
    'dns-zone.record.invalidTTL' => 'Angivet TTL-värde är ogiltigt.',
    'dns-zone.record.invalidIpAddress' => 'Den angivna IP-adressen är ogiltig.',
    'dns-zone.record.invalidIpMaskPair' => 'Angivet par med IP-adress/nätmask är ogiltigt.',
    'dns-zone.record.invalidCName' => 'Angivet kanoniskt namn är ogiltigt.',
    'dns-zone.record.invalidPort' => 'Angiven port är ogiltig.',
    'dns-zone.record.invalidTLSACertData' => 'Den angivna associeringsdata för certifikatet är ogiltig.',
    'dns-zone.record.invalidTLSAProtocol' => 'Det angivna protokollet är ogiltigt.',
    'dns-zone.record.invalidTLSAUsage' => 'Den angivna användningen är ogiltig.',
    'dns-zone.record.invalidTLSASelector' => 'Den angivna selektorn är ogiltig.',
    'dns-zone.record.invalidTLSAMatching' => 'Den angivna matchningstypen är ogiltig.',

    'dns-zone.restore-default.formHint' => "Här kan du återställa den originala zon konfigurationen i enlighet med standard DNS mall inställningarna som används på servern. Välj IP-adresser som skall används för att återställa zonen och specificera om en ny alias krävs för domänen.",
    'dns-zone.restore-default.ipv4' => "IPv4-adress",
    'dns-zone.restore-default.ipv4Hint' => "Till exempel, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-adress",
    'dns-zone.restore-default.ipv6Hint' => "Till exempel, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Den angivna IP-adressen är ogiltig.',
    'dns-zone.restore-default.customIpHint' => "Poster med denna IP-adress anses som användarmodifierade och synkroniseras inte med serveromfattande DNS-mallar.",
    'dns-zone.restore-default.wwwPrefix' => "WWW-prefix",
    'dns-zone.restore-default.previewRecords' => "Återställ uppgifterna som användes för webbpaltsens förhandsgranskning",

    'dns-zone.soa-record.soaMnameSection' => 'Primär Namnserver',
    'dns-zone.soa-record.soaMname' => 'Namnserver',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatiskt val)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA-post',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Uppdatera',
    'dns-zone.soa-record.retry' => 'Försök igen',
    'dns-zone.soa-record.expire' => 'Upphör att gälla',
    'dns-zone.soa-record.minimum' => 'Lägsta',
    'dns-zone.soa-record.rnameType' => 'E-post (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'E-postadress till personen som ansvarar för domänens DNS-zon. Returnerad av DNS-servern som svar på SOA-anrop.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Webbplatsägarens e-postadress',
    'dns-zone.soa-record.rnameTypeDomain' => 'Domänens e-postadress',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Ange bara den lokala delen (innan @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Extern e-postadress',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Förbud att ändra RNAME e-postadressen per domänbas',
    'dns-zone.soa-record.invalidValue' => 'Värdet är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns-zone.soa-record.advancedSection' => 'Avancerade DNS-funktioner',
    'dns-zone.soa-record.serialNumberFormat' => 'Använd serienummerformatet som rekommenderas av IETF och RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Välj alternativet om din domän har problem att gå igenom registratorns SOA-kontroll. Många domänregistratorer kräver detta serienummerformat.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Använd standardinställningar',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Zonstandardinställningar',
    'dns-zone.soa-record.unitSeconds' => 'sekunder',
    'dns-zone.soa-record.unitMinutes' => 'minuter',
    'dns-zone.soa-record.unitHours' => 'timmar',
    'dns-zone.soa-record.unitDays' => 'dagar',
    'dns-zone.soa-record.unitWeeks' => 'veckor',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Uppdateringsintervallet är mindre än en timme, vilket kan öka servertrafiken och resursanvändningen kritiskt.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Om du ställer in minimi-TTL-värdet till mer än 3 timmar kan detta göra dina domäner otillgängliga för några av domänadministratörerna. Det rekommenderas att ställa in ett sådant värde endast om din domännamnsregistrator insisterar på det.',
    'dns-zone.soa-record.success' => 'Egenskaperna för SOA-post uppdaterades.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Standard-SOA-post återställdes.',

    'domain-info-section.domainName' => 'Domännamn',
    'domain-info-section.emptyDomainName' => 'Ange ett domännamn.',
    'domain-info-section.ipAddress' => 'IP-adress',
    'domain-info-section.shared' => 'delad',
    'domain-info-section.exclusive' => 'dedikerad',
    'domain-info-section.ipAddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd. Denna IP-adress används till alla webbplatser som skapats inom abonnemanget.",
    'domain-info-section.ipAddressHint_powerUser' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd. Denna IP-adress används till alla webbplatser som skapats inom webbutrymmet.",
    'domain-info-section.userName' => 'Användarnamn',
    'domain-info-section.userNameHint' => 'Ett systemanvändarkonto som är kopplat till prenumerationen används för åtkomst till filer som finns inom filer på servern via FTP och SSH.',
    'domain-info-section.emptyLogin' => 'Ange ett användarnamn.',
    'domain-info-section.password' => 'Lösenord',
    'domain-info-section.emptyPassword' => 'Ange ett lösenord.',
    'domain-info-section.passwordConfirmation' => 'Upprepa lösenordet',

    'email-address.generalTab' => 'Allmänt',
    'email-address.generalHint' => 'Om detta e-postkonto är associerat med en extra användare (åtkomsten till Kundpanelen är aktiverad) påverkar ändringarna du gör på denna sida användarinställningarna. I synnerhet, om du ändrar e-postadressen och lösenordet, ändras den extra användarens inloggning och lösenord till de nya värdena.',
    'email-address.redirectTab' => 'Vidarebefordran',
    'email-address.redirectHint' => 'Ställ in vidarebefordran av e-postmeddelanden till en eller flera e-postadresser.',
    'email-address.aliasesTab' => 'E-postaliaser',
    'email-address.autoResponderTab' => 'Autosvar',
    'email-address.antispamTab' => 'Skräppostfilter',
    'email-address.autoResponderHint' => 'Ställ in ett automatiskt svar på alla e-postmeddelanden som kommer till din e-postadress. Autosvar är en standardmetod för att meddela dina kontakter att du är frånvarande eller på semester.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'E-postadress',
    'email-address.externalEmail' => 'Extern e-postadress',
    'email-address.externalEmailHint' => 'Används för att återställa ditt lösenord om du förlorar åtkomst till den primära e-postadressen.',
    'email-address.user' => 'Tilldelad till',
    'email-address.password' => 'Lösenord',
    'email-address.passwordConfirmation' => 'Bekräfta lösenord',
    'email-address.clientConfigurationLink' => 'E-posta konfiguratorlänk',
    'email-address.responderEnable' => 'Slå på autosvar',
    'email-address.responderSubject' => 'Meddelandeämne för autosvar',
    'email-address.responderContentType' => 'Meddelandeformat',
    'email-address.responderContentTypeHint' => 'Formatet för enkel text stöds av alla e-postklientprogram och därför kommer alla mottagare att se meddelandet på samma sätt som du. HTML-meddelanden ser bättre ut eftersom dig låter dig mata in formaterad txt med olika teckensnittstilar. Men vissa e-postklienter stödjer inte HTML-meddelanden och vissa mottagare kanske inte ser formaterad text.',
    'email-address.responderContentTypeTextPlain' => 'Oformaterad text',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kodning',
    'email-address.responderCodepageHint' => 'Kodningen definierar hur texttecknet visas. Den rekommenderade kodningen är UTF-8.',
    'email-address.responderReplyTo' => 'Vidarebefordra till',
    'email-address.responderReplyToHint' => 'När automatsvar har skickats, kommer originalmeddelandet att vidarebefordras till den specificerade e-postadressen.',
    'email-address.responderForwardAddress' => 'Vidarebefordra till',
    'email-address.responderForwardAddressHint' => 'När automatsvar har skickats, kommer originalmeddelandet att vidarebefordras till den specificerade e-postadressen.',
    'email-address.responderMessage' => 'Meddelandetext för autosvar',
    'email-address.responderReplyToEqualsEmail' => 'Den specificerade adressen för vidarebefordran är densamma som en annan e-postadress.',
    'email-address.responderForwardAddressEqualsEmail' => 'Den specificerade adressen för vidarebefordran är densamma som en annan e-postadress.',
    'email-address.responderReplyLimit' => 'Skicka ett automatsvar till en unik e-postadress men inte mer än (gånger per dag)',
    'email-address.buttonAddResponderAttachment' => 'Lägg till bifogad fil',
    'email-address.buttonRemoveResponderAttachment' => 'Ta bort',
    'email-address.responderAttachment' => 'Bifoga en fil',
    'email-address.redirectEnable' => 'Sätt på vidarebefordran av e-post',
    'email-address.redirectRemoveEnable' => 'Leverera inte kopior av vidarebefordrad e-post till Plesks inkorg',
    'email-address.redirectAddress' => 'Vidarebefordra inkommande meddelanden till följande e-postadress',
    'email-address.redirectAddressHint' => 'Specificera e-postadresser Du kan skriva varje adress på en ny rad eller separera adresser med blanksteg, komman eller semikolon.',
    'email-address.role' => 'Användarroll',
    'email-address.roleHint' => 'Användarroller ger användarna administrativa privilegier och åtkomst till program du var valt för rollen.',
    'email-address.errorRedirectAddress' => 'Du specificerade en ogiltig e-postadress: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Du specificerade ogiltiga e-postadresser: %value%.',
    'email-address.mailAlias' => "E-postalias",
    'email-address.mailAliasNone' => 'Ingen',
    'email-address.mailAliasHint' => "E-postaliaser är alternativa e-postadresser som är associerade med en huvudsaklig e-postadress. All post som skickas till e-postaliaser kommer att tas emot av den huvudsakliga e-postadressen.",
    'email-address.buttonAddMailAlias' => 'Lägg till e-postalias',
    'email-address.buttonRemoveMailAlias' => 'Ta bort',
    'email-address.emptyEmail' => 'Specificera e-postadressen till vilka alla inkommande meddelanden ska vidarebefordras.',
    'email-address.emailsIsEqual' => 'Den externa e-postadressen matchar den primära. Specificera en annan extern e-postadress.',
    'email-address.emptyPassword' => 'Du måste ange ett lösenord.',
    'email-address.emptyPasswordConfirmation' => 'Du måste bekräfta lösenordet.',
    'email-address.emptyAlias' => "Specificera e-postalias för denna e-postadress.",
    'email-address.aliasEqualsEmail' => 'Den specificerade e-postaliasen är densamma som e-postadressen.',
    'email-address.passwordHint' => 'Kommer att användas för att komma åt brevlådan och för att logga in på Plesk (om motsvarande alternativ är aktiverat).',
    'email-address.cyclicRedirect' => 'E-postmeddelanden kan inte ställas in för att vidarebefordra e-postmeddelande till sig själva.',
    'email-address.errorMailnameReserved' => 'Den angivna e-postadressen används redan.',
    'email-address.antivirusEnable' => 'Sätt på antivirusskyddet för denna e-postadress',
    'email-address.antivirusHint' => 'Antivirustjänsten blockerar e-postmeddelanden som innehåller virus och meddelar både avsändaren och mottagaren om det.',
    'email-address.antivirusSettings' => 'Kontrollera med avseende på virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'endast inkommande e-post',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'endast utgående e-post',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'inkommande och utgåend e-post.',
    'email-address.antispamHint' => 'Spamfiltreringstjänsten detekterar skräppostmeddelanden som skickats till e-postadressen. Du kan ställa in skräppostfiltret för att radera skräppostmeddelanden, markera dem som skräppost genom att ändra ämne eller flytta dem till den speciella skräpostmallppoppen som är tillgängliga för e-postklienter via IMAP. Skräppostfilter använder ett flertal lokala och nätverksbaserade tester för att identifiera skräppostkännetecken.',
    'email-address.antispamEnable' => 'Sätt på skräppostfitlreringen för denna e-postadress',
    'email-address.antispamSettings' => 'Vad gör du med meddelanden som klassificeras som skräppost',
    'email-address.antispamSettingsMark' => 'Markera skräppostmeddelanden genom att lägga till följande text till meddelandets ämne',
    'email-address.antispamSettingsMarkHint' => 'Lämna detta fält tomt om du inte vill lägga till valfri text. Skriv _SCORE_ om du vill inkludera poängen i meddelandets ämnesrad.',
    'email-address.antispamReportTextHint' => 'Skriv in texten du vill ägga till i skräppostens e-postmeddelande.',
    'email-address.antispamSettingsDelete' => 'Radera alla skräppostmeddelanden',
    'email-address.antispamSettingsDeleteHint' => 'Skräppostmeddelanden kommr att raderas ur din e-postlåda.',
    'email-address.antispamSettingsMove' => 'Flytta skräppost till skräppostmappen',
    'email-address.antispamSettingsMoveHint' => 'Flytta alla skräppostmeddelanden till mappen som kallas Skräpost. Denna mapp är tillgänglig från ditt e-postklientprogram eller webbpost. Om du använder ett IMAP-epostkonto, kan du använda skräppostfiltret för att träna skräppostfiltret.',
    'email-address.antispamSettingsMoveWarning' => '"Flytta skräppost till skräppostmappen" fungerar inte om du inte inaktiverar alternativet "Leverera inte kopior av vidarebefordrad e-post" i fliken "Vidarebefordring".',
    'email-address.antispamSettingsMoveJunk' => 'Flytta spam till mappen "Skräppost"',
    'email-address.antispamSettingsMoveJunkHint' => 'Flytta alla spammeddelanden i mappen som kallas "Skräppost". Denna mapp är tillgänglig från ditt e-postklientprogram eller webbpost. Om du använder ett IMAP-epostkonto, kan du använda mappen "Skräppost" för att träna skräppostfiltret.',
    'email-address.antispamShowAdvancedSection' => 'Visa avancerade inställningar',
    'email-address.antispamHideAdvancedSection' => 'Dölj avancerade inställningar',
    'email-address.antispamLearnMore' => 'Lär dig hur du instruerar skräppostfiltret.',
    'email-address.antispamFilterScoreTitle' => 'Filterkänslighet',
    'email-address.antispamFilterScoreHint' => 'Skräppostfiltret utför ett antal olika tester på innehållet och ämnet i varje meddelande. Som en följd får varje meddelande ett antal poäng. Ju högre numret är, desto mer sannolikt är ett meddelande skräppost. Som standard ställs filtrets känslighet in så att meddelanden som får 7 eller mer poäng klassificeras som skräppost. Om du får mycket skräppostmeddelanden med den aktuella inställningen, försök ställa in ett lägre värde, till exempel 6. Om du saknar e-post eftersom ditt skräppostfilter tror att det är skräp, försök reducera filterkänsligheten genom att ställa in ett högre värde, till exempel 8.',
    'email-address.antispamFilterScore' => 'Skräppostfilterkänslighet',
    'email-address.antispamWhiteListTitle' => 'White List',
    'email-address.antispamWhiteListHint' => 'E-post som kommer från avsändare i den vita listan kontrolleras inte av skräppostfiltret.',
    'email-address.antispamWhiteListField' => 'Vita listan',
    'email-address.antispamWhiteListFieldHint' => 'Ange domännamn, ett domännamn per rad. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com).',
    'email-address.antispamBlackListTitle' => 'Svarta listan',
    'email-address.antispamBlackListHint' => 'E-post som kommer från avsändare på svarta listan klassificeras som spam.',
    'email-address.antispamBlackListField' => 'Svarta listan',
    'email-address.antispamBlackListFieldHint' => 'Ange domännamn, en domän per rad. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com).',
    'email-address.antispamTrustedLanguagesTitle' => 'Betrodda språk',
    'email-address.antispamTrustedLanguagesHint' => 'E-postmeddelanden som skrivs på dessa språk kommer alltid att passera detta filter.',
    'email-address.antispamTrustedLocalesTitle' => 'Betrodda språkversioner',
    'email-address.antispamTrustedLocalesHint' => 'E-postmeddelanden som använder de specificerade locale-grupperna kommer att passera filtret. Språkversionsgrupperna omfattar de oftast använda teckenuppsättningarna. Exempelvis omfattar Västerländsk teckenuppsättning koder för bokstäver som används i engelska och västeuropeiska språk.',
    'email-address.antispamTrustedNetworksTitle' => 'Betrodda nätverk',
    'email-address.antispamTrustedNetworksHint' => 'Vidaresändningsvärdarna på betrodda nätverk betraktas inte som potentiellt styrda av spammare, och de är inte öppna vidaresändare eller öppna proxyservrar.',
    'email-address.antispamIpAddressesField' => 'IP-adresser',
    'email-address.antispamIpAddressesFieldHint' => 'Specificera nätverks-IP-adress och -mask.',
    'email-address.mailBoxQuotaDomainDefault' => 'Standardstorlek (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Standardstorlek',
    'email-address.mailBoxOutgoingMessages' => 'Maximalt antal utgående e-postmeddelanden',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% meddelanden per timme)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Anpassat värde för denna postlåda',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'meddelanden',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Standard',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Standardstorlek',
    'email-address.mailBoxQuotaDomainSpecific' => 'Annan storlek',
    'email-address.mailBoxQuotaDomainSpecificValue' => 'Annat storleksvärde',
    'email-address.mailBoxQuotaDomainSpecificMultiplier' => 'Storlesenheter',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Storlek på postlåda',
    'email-address.mailBoxQuotaUnlimited' => 'Obegränsat',
    'email-address.mailBoxLimitReached' => 'Gränsen för antalet e-postlådor har nåtts.',
    'email-address.postboxEnabled' => 'E-postkonto',
    'email-address.postboxEnabledYes' => 'På',
    'email-address.postboxEnabledNo' => 'Av',
    'email-address.description' => 'Beskrivning i Plesk',
    'email-address.descriptionHint' => 'Beskrivningen är synbar för alla som har åtkomst till detta e-postkonto.',
    'email-address.longDescription' => 'Den angivna beskrivningen är för lång. Det kan blev inte längre än %%max%% symboler.',
    'email-address.loginAsUser' => 'Kan användas för att logga in på Plesk',
    'email-address.loginAsUserDescription' => '(användarnamn: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'E-postkontostorleken kan inte överstiga standardstorleken.',
    'email-address.endDateEnable' => 'Stänga av autosvar',

    'failed-request.enable-tracing.description' => 'Misslyckade begäran om spårning är en åtgärd som kräver resurser. Spårningen stoppas automatiskt om %%days%% dagar. Du kan stänga av den manuellt när som helst.',
    'failed-request.enable-tracing.statusCodes' => 'Statuskoder',
    'failed-request.enable-tracing.statusCodesDescription' => 'Exempel: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Leverantör',

    'file-manager.permissions.filePermissions' => 'Filbehörigheter',
    'file-manager.permissions.directoryPermissions' => 'Katalogbehörigheter',
    'file-manager.permissions.buttonSubmit' => 'Spara',
    'file-manager.permissions.buttonApply' => 'Spara och återuppta',
    'file-manager.permissions.buttonCancel' => 'Avbryt',
    'file-manager.permissions.buttonAdvanced' => 'Avancerat',

    'file-manager.unix-file-permissions.group' => 'Grupp',
    'file-manager.unix-file-permissions.owner' => 'Ägare',
    'file-manager.unix-file-permissions.others' => 'andra',
    'file-manager.unix-file-permissions.readMode' => 'Läsa',
    'file-manager.unix-file-permissions.writeMode' => 'Skriva',
    'file-manager.unix-file-permissions.execMode' => 'Exekverings-/sökläge',
    'file-manager.unix-file-permissions.changeRecursive' => 'Ändra tillstånd rekursivt',

    'file-manager.windows-permissions.allow' => 'Tillåt',
    'file-manager.windows-permissions.deny' => 'Förneka',
    'file-manager.windows-permissions.inheritFromParent' => 'Låt ärftliga behörigheter från det överordnade objektet spridas till det här objektet och underordnade objekt. Inkludera dessa med de poster som uttryckligen är definierade här',
    'file-manager.windows-permissions.replaceOnChildren' => 'Ersätt behörighetsposter på alla barnobjekt med posterna som visas här',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avancerat',
    'file-manager.windows-permissions.applyTo' => 'Använd för:',
    'file-manager.windows-permissions.folderOnly' => 'Endast den här mappen',
    'file-manager.windows-permissions.subfolderOnly' => 'Endast undermappar',
    'file-manager.windows-permissions.filesOnly' => 'Endast filer',
    'file-manager.windows-permissions.permissionsFor' => 'Behörigheter för',
    'file-manager.windows-permissions.applyOnto1' => 'Endast den här mappen',
    'file-manager.windows-permissions.applyOnto2' => 'Endast undermappar',
    'file-manager.windows-permissions.applyOnto3' => 'Den här mappen och undermappar',
    'file-manager.windows-permissions.applyOnto4' => 'Endast filer',
    'file-manager.windows-permissions.applyOnto5' => 'Den här mappen och filer',
    'file-manager.windows-permissions.applyOnto6' => 'Endast undermappar och filer',
    'file-manager.windows-permissions.applyOnto7' => 'Den här mappen, undermappar och filer',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => 'Textredigerare',
    'file-manager.editor.titleCodeEditor' => 'Kodredigerare',
    'file-manager.editor.titleHtmlEditor' => 'HTML-redigerare',
    'file-manager.editor.titleCodeViewer' => 'Visa',
    'file-manager.editor.buttonSubmit' => 'Spara',
    'file-manager.editor.buttonApply' => 'Spara och återuppta',
    'file-manager.editor.buttonSaveAs' => 'Spara som...',
    'file-manager.editor.buttonCancel' => 'Avbryt',
    'file-manager.editor.exitConfirmationYes' => 'Ja',
    'file-manager.editor.exitConfirmationNo' => 'Nej',
    'file-manager.editor.fileOverwrite' => 'Filen finns redan.',
    'file-manager.editor.fileOverwriteDescription' => 'En fil med samma namn existerar redan. Vill du skriva över den?',
    'file-manager.editor.exitConfirmation' => 'Är du säker på att du vill stänga filen och inte spara dina osparade ändringar?',
    'file-manager.editor.buttonCodeEditor' => 'Redigera i kodredigeraren',
    'file-manager.editor.buttonTextEditor' => 'Redigera i textredigeraren',

    'file-manager.html-editor.toolbar.textStyle' => 'Textstil',
    'file-manager.html-editor.toolbar.textStyleDesc' => 'Textstil',
    'file-manager.html-editor.toolbar.insert' => 'Infoga',
    'file-manager.html-editor.toolbar.insertDesc' => 'Lägg till bilder, videor, länkar eller tabeller',
    'file-manager.html-editor.toolbar.paste' => 'Klistra in från urklipp',

    'file-manager.import-file.buttonSubmit' => 'Importera',
    'file-manager.import-file.fieldUrl' => 'URL för filen',
    'file-manager.import-file.fieldUrlDescription' => 'Specificera käll-URL, till exempel \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Det fullständiga URL-mönstret är som följer: \'https://user:password@example.com/example.tgz\'. Användarnamnet och lösenordet är valfria. De stödda protokollen är http, https, ftp, ftps. Använd URL-kodning för URL-delar som innehåller specialtecken eller mellanslag.',
    'file-manager.import-file.failure' => 'Kan inte importera filen.',

    'file-manager.rotation-settings.title' => 'Rotationsinställningar för papperskorg',
    'file-manager.rotation-settings.rotationBySize' => 'Rotation efter storlek',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Alternativet raderar nya filer så länge den angivna gränsen för papperskorgen överskrids.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotation efter datum',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dagar',
    'file-manager.rotation-settings.rotationByDateHint' => 'Alternativet raderar filer som ligger i papperskorgen i mer än ett angivet antal dagar.',
    'file-manager.rotation-settings.save' => 'Spara',
    'file-manager.rotation-settings.cancel' => 'Avbryt',

    'ftp-user.description' => 'Om du arbetar på din webbplats tillsammans med några andra eller är värd för underdomän för andra användare, vill du möjligen skapa individuella FTP-konton för dom.',
    'ftp-user.generalSection' => 'Allmänt',
    'ftp-user.login' => 'FTP-kontonamnet',
    'ftp-user.home' => 'Hemkatalog',
    'ftp-user.systemArea' => 'Skapa ett FTP-konto med tillgång till filer utanför huvudkatalogen',
    'ftp-user.password' => 'Lösenord',
    'ftp-user.passwordConfirmation' => 'Bekräfta lösenord',
    'ftp-user.hardQuotaSection' => 'Hårddiskkvot',
    'ftp-user.hardQuota' => 'Hårddiskkvot',
    'ftp-user.hardQuotaUnlimited' => 'Obegränsat',
    'ftp-user.permissionsSection' => 'Behörigheter',
    'ftp-user.permissionRead' => 'Läsbehörighet',
    'ftp-user.permissionWrite' => 'Skrivbehörighet',
    'ftp-user.selectButtonLabel' => 'Välj katalog',
    'ftp-user.popupTitle' => 'Välj katalog',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'E-postlistaadress',
    'mail-list.enabled' => 'Påkopplad',
    'mail-list.administratorEmail' => 'E-postlistans administratörspost',
    'mail-list.password' => 'Lösenord',
    'mail-list.passwordConfirmation' => 'Bekräfta lösenord',
    'mail-list.subscribers' => 'Abonnenter',
    'mail-list.subscribersHint' => 'Specificera e-postadresser Du kan skriva varje adress på en ny rad eller separera adresser med blanksteg, komman eller semikolon.',
    'mail-list.notify' => 'Meddela administratör om skapande av e-postlista',
    'mail-list.emptyPassword' => 'Ange ett lösenord.',
    'mail-list.emptyPasswordConfirmation' => 'Bekräfta lösenordet.',
    'mail-list.errorSubscribers' => 'Ogiltig e-post adress: %value%.',
    'mail-list.errorMaillistReserved' => 'Den angivna utskickslistans adress används redan.',

    'mail-settings.copyToClipboard' => 'Kopiera DNS-posten till urklippen.',
    'mail-settings.copySuccess' => 'DNS-posten kopierades till urklippen.',
    'mail-settings.hint' => 'Här kan du ändra inställningar för e-posttjänster för detta domänet.',
    'mail-settings.service' => 'E-posttjänsten på denna domän',
    'mail-settings.nonExist' => 'Vad gör man med e-post som skickas till obefintliga användare',
    'mail-settings.nonExistBounceWithMessage' => 'Returnera med meddelande',
    'mail-settings.nonExistBounceWithMessagePlaceholder' => 'Denna adress accepterar ingen e-post längre.',
    'mail-settings.nonExistBounce' => 'Studsa',
    'mail-settings.nonExistCatch' => 'Vidarebefordra till adressen',
    'mail-settings.nonExistCatchAddressPlaceholder' => 'Ange adress för vidarebefordran',
    'mail-settings.nonExistCatchDescription' => 'Postadressen måste tillhöra vald domän. Endast administratören kan specificera en extern adress eller en adress för flera domäner.',
    'mail-settings.nonExistExternal' => 'Omdirigera till extern e-postserver med IP-adress',
    'mail-settings.nonExistReject' => 'Avvisa',
    'mail-settings.nonExistDiscard' => 'Avvisa',
    'mail-settings.webmail' => 'Webbpost',
    'mail-settings.webmailNone' => 'Ingen',
    'mail-settings.webmailComponentNotInstalled' => 'Webmail komponenten är inte installerat',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Det finns en underdomän med namnet %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-certifikat för webmail',
    'mail-settings.webmailCertificateNone' => 'Inte valt',
    'mail-settings.mailCertificate' => 'SSL/TLS Certifikat för e-post',
    'mail-settings.mailCertificateNone' => 'Inte valt',
    'mail-settings.serverCertificateNotSelected' => 'Certifikatet har tilldelats, men posten för domänen har inte säkrats. För att slutföra säkringen av e-post för domänen, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'säkra mailservern',
    'mail-settings.mailLists' => 'Aktivera utskickslistor',
    'mail-settings.mailAutodiscovery' => 'Aktivera e-postens automatiska detektering',
    'mail-settings.mailAutodiscoveryDescription' => 'Se hur det fungerar i %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'kunskapsbas',
    'mail-settings.domainKeys' => 'Använd DKIM spamskyddssystem för att signera utgående e-postmeddelanden',
    'mail-settings.activeDkimSelector' => 'Aktiv DKIM-selektor',
    'mail-settings.defaultDkimSelector' => ' (Plesks standard)',
    'mail-settings.dkimSelectorName' => 'Selektornamn',
    'mail-settings.buttonCreateSelector' => 'Skapa ny DKIM-selektor',
    'mail-settings.createSelectorDialogTitle' => 'Skapa DKIM-selektor',
    'mail-settings.removeSelectorDialogTitle' => 'Ta bort DKIM-selektor',
    'mail-settings.removeSelectorConfirmation' => "Ta bort selektorn \"%%selector%%\" tillsammans med dess associerade nycklar och DNS-poster?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Skapa',
    'mail-settings.buttonCancel' => 'Avbryt',
    'mail-settings.labelRemoveSelector' => 'Ta bort',
    'mail-settings.labelActiveSelector' => 'Aktiv',
    'mail-settings.greyListing' => 'Sätt på skyddet mot skräppost på grålistan för alla e-postkonton under denna domän',
    'mail-settings.howToConfigureExternalDns' => 'Hur man konfigurerar extern DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'För att aktivera DKIM-signering om du använder en extern DNS-server måste du själv konfigurera DKIM DNS-poster på DNS-servern.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'För att göra det, använd DKIM DNS-posterna nedan:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Om du har domänalias du använder för att skicka e-post, lägg till DKIM DNS-posterna även för dem. Använd samma poster som för huvuddomänen men med domänens aliasnamn.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'För att se DKIM DNS-posterna du behöver konfigurera, välj kryssrutan "%%option%%", applicera den och öppna denna popup igen.',
    'mail-settings.mailServiceDisabled' => 'Inaktiverad',
    'mail-settings.mailServiceDisabledIncoming' => 'Inaktiverat för inkommande e-post',
    'mail-settings.mailServiceDisabledHint' => 'Plesk kommer inte att tillhandahålla några e-posttjänster på denna domän.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Denna domän kan bara skicka e-post, och endast med Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Aktiverad',
    'mail-settings.mailServiceEnabledHint' => 'Denna domän kan skicka och ta emot e-post.',
    'mail-settings.mailServiceNotConfigured' => 'Inte konfigurerad',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk kommer inte att tillhandahålla några e-posttjänster på denna domän.',
    'mail-settings.warning' => 'Detta kommer generellt att ta bort domänens inkorgar med all mottagen och skickad e-post.',
    'mail-settings.show.title' => 'Ta bort alla inkorgar och e-postmeddelanden för %%domain%%',
    'mail-settings.show.checkbox' => 'Ta permanent bort alla inkorgar för %%domain%%, inklusive mottagen och skickad e-post.',

    'role.roleSection' => 'Allmänt',
    'role.name' => 'Användarrollsnamn',
    'role.description' => 'Beskrivning',
    'role.generalPermissionsSection' => 'Tillgång till Plesk-tjänster',
    'role.applicationsAccessSection' => 'Åtkomst till appar',
    'role.permissionAllow' => 'Beviljade',
    'role.permissionDeny' => 'Nekad',
    'role.emptyRoleName' => 'Ange ett rollnamn.',
    'role.installedAt' => 'Installerat på',
    'role.noInstallationUrlAvailable' => 'Extern app',
    'role.invalidRoleName' => 'Det specificerade användarrollnamnet är ogiltigt. Frågetecken och citationstecken kan inte användas i rollnamnet.',
    'role.longRoleName' => 'Det angivna användarrollnamnet är för långt.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Vissa åtgärder kanske inte är tillgängliga för följande orsaker: ett tillstånd för åtgärden ges inte för det aktuellt valda abonnemanget eller mängden tilldelade resurser räcker inte för att utföra åtgärden.',
    'role.servicesPermissionsDescription' => 'Definiera åtkomst till installerade appar eller Plesk-tjönster för alla användare med denna roll. Om du ger en användare tillgång till en app, kommer den att vara tillgänglig för honom i Kundpanelen.',
    'role.emailActivation' => 'Aktivera denna rolls konton via e-post',

    'service.admin-access.adminAccess' => 'Administrativ åtkomst',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Dessa autentiseringsuppgifter kommer att användas för administrativ tillgång till detta program.',
    'service.admin-access.login' => 'Administrativt användarnamn',
    'service.admin-access.password' => 'Administrativt lösenord',
    'service.admin-access.passwordConfirmation' => 'Bekräfta lösenord',

    'service.info.service-entry-point.availableAt' => 'Tillgänglig ¨på',
    'service.info.service-entry-point.customize' => 'Anpassa genvägar',
    'service.info.service-entry-point.displayNameLabel' => 'Genvägens namn',
    'service.info.service-entry-point.displayNameDescription' => 'Skriv ett namn för denna genväg. Namnet visas under genvägsikonen. Genvägarna placeras på sidorna Mina tjänster för användare som fått tillgång till programmet.',
    'service.info.service-entry-point.descriptionLabel' => 'Genvägsbeskrivning',
    'service.info.service-entry-point.descriptionDescription' => 'Skriv en beskrivning för denna genväg. Beskrivningen visas som en knappbeskrivning när muspekaren befinner sig över genvägen.',
    'service.info.service-entry-point.iconLabel' => 'Klicka för att välja genvägsikonen',
    'service.info.service-entry-point.iconCurrent' => 'Aktuell ikon',
    'service.info.service-entry-point.errorEmptyName' => 'Du måste ange ett genvägsnamn',
    'service.info.service-entry-point.errorLongName' => 'Genvägsnamnet ska vara mellan 1 och 255 tecken.',
    'service.info.service-entry-point.errorLongDescription' => 'Genvägsbeskrivningen ska vara mellan 0 och 255 tecken.',
    'service.info.service-entry-point.hiddenLabel' => 'Dölj genväg',
    'service.info.service-entry-point.hiddenDescription' => 'Visa inte denna genväg för användare.',

    'service.info.service-permission.assignedUser' => "Ge administratörsåtkomst till denna användare",
    'service.info.service-permission.assignedUserNone' => 'Ingen användare har tilldelats',

    'shared-ssl.master-ssl.switchedOn' => 'Slå på delad SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Domännamn på en site vars SSL/TLS-certifikat kommer att delas med andra webbplatser',
    'shared-ssl.master-ssl.none' => 'Ingen',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Delad SSL/TLS  kan inte slås på eftersom det inte finns domäner med aktiverat SSL/TLS-stöd.',

    'smarthost.configuration.checkConnection.success' => 'Anslutningen till smarthosten har upprättats.',
    'smarthost.settings.title' => 'Smarthost-inställningar',
    'smarthost.settings.useSmarthost' => 'Skicka e-post via en smarthost',
    'smarthost.success' => 'Smarthost-konfigurationen för %%domain%% uppdaterades.',

    'user.email.email' => 'E-postadress',
    'user.email.emptyEmail' => 'Du måste ange en e-postadress.',
    'user.email.internalEmailHint' => 'Skapa en ny e-postadress i Plesk eller använd en extern e-postadress.',
    'user.email.longInternalEmail' => 'E-postadressen är för lång.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Användarnamnet för e-postadressen är för lång för denna e-postserver. Specificera ett användarnamn som inte är längre än %%max%% symboler.',
    'user.email.longInternalEmailFullAddressMailServer' => 'E-postadressen är för lång för denna postserver. Specificera en adress som inte är längre än %%max%% symboler.',
    'user.email.externalEmail' => 'Extern e-postadress',
    'user.email.externalEmailHint' => 'Används för att återställa ditt lösenord om du förlorar åtkomst till den primära e-postadressen.',
    'user.email.emailsIsEqual' => 'Den externa e-postadressen matchar den primära. Specificera en annan extern e-postadress.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Vänligen ange antingen intern eller extern e-postadress.',

    'user.profileSection' => 'Allmän information',
    'user.contactName' => 'Kontakt namn',
    'user.email' => 'E-postadress',
    'user.role' => 'Användarroll',
    'user.accountSection' => 'Plesk preferenser',
    'user.login' => 'Användarnamn',
    'user.password' => 'Lösenord',
    'user.oldPassword' => 'Gammalt lösenord',
    'user.buttonBack' => 'Tillbaka',
    'user.generalTab' => 'Allmänt',
    'user.applicationsAccessSection' => 'Tjänster',
    'user.generalPermissionsSection' => 'Privilegier',
    'user.contactsTab' => 'Kontaktinformation',
    'user.passwordConfirmation' => 'Bekräfta lösenord',
    'user.internalEmailPasswordChanged' => 'Att byta lösenord byter även lösenordet för den interna e-postadressen.',
    'user.emailName' => 'E-postadress',
    'user.emailType' => 'E-posttyp',
    'user.companyName' => 'Företagsnamn',
    'user.phone' => 'Telefonnummer',
    'user.imNumber' => 'Snabbmeddelande',
    'user.imType' => 'Applikation för direktmeddelanden',
    'user.fax' => 'Faxnummer',
    'user.address' => 'Adress',
    'user.city' => 'Stad',
    'user.state' => 'Region',
    'user.zip' => 'Postnummer',
    'user.country' => 'Land',
    'user.additionalInfo' => 'Ytterligare information',
    'user.additionalInfoHint' => 'Endast oformaterad text: Alla HTML-taggar kommer att ignoreras.',
    'user.language' => 'Plesk språk',
    'user.buttonChangePassword' => 'Ändra lösenord',
    'user.permissionAllow' => 'Beviljade',
    'user.permissionDeny' => 'Nekad',
    'user.permissionInherited' => 'Definierat av roll',
    'user.emptyContactName' => 'Du måste ange ett kontaktnamn.',
    'user.emptyLogin' => 'Du måste ange ett användarnamn.',
    'user.emptyPassword' => 'Du måste ange ett lösenord.',
    'user.emptyPasswordConfirmation' => 'Du måste bekräfta lösenordet.',
    'user.oldPasswordIsIncorrect' => 'Det gamla lösenordet är felaktigt. Försök igen.',
    'user.chooseDomainBoxTitle' => 'Välj en annan domän:',
    'user.userIsActive' => 'Användaren är aktiv',
    'user.userIsActiveHint' => 'En aktiv användare kan få tillgång till Plesk.',
    'user.emailActivation' => 'Aktivera kontot via e-post',
    'user.emailHint' => 'För att ge användaren en e-postadress som är webbaserad på denna server, gå till fliken E-post, skapa den specificerade e-postadressen och associera den med denna användare.',
    'user.emailContactHint' => 'Kontakta din tjänsteleverantör om du vill använda en e-postadress som är webbaserad på denna server.',
    'user.personalEmailHint' => "Denna användares e-postadress kan ändras på fliken E-pos.",
    'user.externalMailRedirectHint' => 'Vidarebefordran kan endast aktiveras för e-postadresser som är webbaserade på denna server. För att skapa en e-postadress, gå till fliken E-post.',
    'user.externalMailRedirectHint2' => 'Vidarebefordran kan endast aktiveras för e-postadresser som är webbaserade på denna server.',
    'user.externalMailAutoResponderHint' => 'Autosvaret kan endast aktiveras för e-postadresser som är webbaserade på denna server. För att skapa en e-postadress, gå till fliken E-post.',
    'user.externalMailAutoResponderHint2' => 'Autosvaret kan endast aktiveras för e-postadresser som är webbaserade på denna server.',
    'user.roleHint' => 'Användarroller ger användarna administrativa privilegier och åtkomst till program du var valt för rollen.',
    'user.cannotManageMail' => "Du saknar behörighet att hantera e-postinställningarna och tjänsterna.",
    'user.longCompanyName' => 'Det angivna företagsnamnet är för långt.',
    'user.longPhone' => 'Det angivna telefonnumret är för långt.',
    'user.longFax' => 'Det angivna faxnumret är för långt.',
    'user.longAddress' => 'Den angivna adressen är för lång.',
    'user.longCity' => 'Det angivna stadsnamnet är för långt.',
    'user.phoneRegexNotMatch' => 'Det angivna telefonnumret är ogiltigt.',
    'user.faxRegexNotMatch' => 'Det specificerade faxnumret är ogiltigt.',
    'user.shortCity' => 'Det angivna stadsnamnet för kort.',
    'user.limitSubscription' => 'Åtkomst till abonnemang',
    'user.limitSubscriptionHint' => 'Tillåta användare att få tillgång endast till ett specificerat abonnemang. Värdet "Alla" ger dem tillgång till alla abonnemang på ditt värddatorkonto.',
    'user.limitSubscriptionAll' => 'Alla',
    'user.deletedSubscription' => 'Borttaget abonnemang',

    'web.add-domain-alias.title' => 'Lägg till ett domänalias',
    'web.add-domain-alias.createdSuccessfully' => "Domänaliaset %%name%% skapades.",
    'web.add-domain-alias.domainAliasName' => 'Domänens aliasnamn',
    'web.add-domain-alias.domainAliasNameHint' => 'Exempelvis, example.net',
    'web.add-domain-alias.forDomain' => 'för domänen',
    'web.add-domain-alias.settingsSectionLegend' => 'Inställningar',
    'web.add-domain-alias.settingsDns' => 'Synkronisera DNS-zonen med den primära domänen',
    'web.add-domain-alias.settingsMail' => 'Posttjänst',
    'web.add-domain-alias.settingsWeb' => 'Webbtjänst',
    'web.add-domain-alias.settingsSeoRedirect' => 'Omdirigera med HTTP 301-koden',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'När besökare öppnar aliasets URL, kommer de omdirigeras till URL:en för den primära domänen. Plesk använder sökmotorvänlig HTTP 301-omdirigering, vilket betyder att sökmotorrankningen inte kommer att delas mellan URL:erna.',
    'web.add-domain-alias.settingsTomcat' => 'Java webbprogram',
    'web.add-domain-alias.invalidDomainGuid' => 'Ogiltig domän',

    'web.add-domain.formTitle' => 'Lägger till ny domän',
    'web.add-domain.portalLink' => 'Tjänsteportal',
    'web.add-domain.domainName' => 'Domännamn',
    'web.add-domain.domainNameHint' => "Exempelvis, example.com",
    'web.add-domain.assignToCustomer' => 'Tilldela denna databas till en kund',
    'web.add-domain.customer' => 'Välj en kunder',
    'web.add-domain.createNewCustomer' => 'Skapa en ny kund',
    'web.add-domain.selectExistingCustomer' => 'Välj en befintlig kund:',
    'web.add-domain.customerContactInfoHint' => 'Ange kundens kontaktinformation. Du kan specificera all annan information som telefonnummer och adress senare.',
    'web.add-domain.customerLoginInfoHint' => 'Uppgifter för kundpanelen',
    'web.add-domain.target' => 'Webbutrymme',
    'web.add-domain.createNewTarget' => 'Skapa en ny prenumeration',
    'web.add-domain.createNewTarget_powerUser' => 'Skapa nytt webbutrymme',
    'web.add-domain.selectExistingTarget' => 'Välj ett befintligt abonnemang:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Välj ett befintligt webbutrymme:',
    'web.add-domain.dns' => 'Aktivera DNS-tjänsten',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktivera e-posttjänsten',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Fungerar om prenumerationens inställningar tillåter hantering av mailrättigheter per domän. Om de inte tillåter detta kommer den faktiska statusen på e-posttjänsten att tas bort från prenumerationen.',
    'web.add-domain.hostingManagementOptions' => 'Hosting typ',
    'web.add-domain.websiteHosting' => 'Webbplatshosting',
    'web.add-domain.websiteForwarding' => 'Vidarebefordran',
    'web.add-domain.websiteNoHosting' => 'Inga värdtjänster',
    'web.add-domain.hostingSettingsSectionLegend' => 'Värdtjänst-inställningar',
    'web.add-domain.domainCreatedSuccessfully' => 'Domänen %%domainName%% har skapats korrekt.',
    'web.add-domain.webspaceLegend' => 'Webbutrymme inställningar',
    'web.add-domain.addWhmWebsiteTitle' => 'Lägg till ny webbplats',
    'web.add-domain.addWhmWebsiteHint' => "Du kan välja att värdbasera en webbplats på servern.",
    'web.add-domain.selectWhmDomain' => 'Välj domän',
    'web.add-domain.customerLegend' => 'KundInfo',
    'web.add-domain.credentials' => 'Uppgifter för systemanvändare',
    'web.add-domain.credentialsHint' => 'för åtkomst till hostade filer över FTP och SSH',
    'web.add-domain.credentialsHintWin' => 'för åtkomst till hostade filer över FTP och RDP',
    'web.add-domain.buttonAddDomain' => 'Lägg till domän',

    'web.add-subdomain.formTitle' => 'Lägg till subdomän',
    'web.add-subdomain.formGeneralHint' => 'Underdomäner är Internet-adresser för olika sektioner på din webbplats. De använder ditt huvuddomännamn och ett prefix. Exempelvis, om domänen är domain.com, kan en subdomän vara butik.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Du kan också skapa en jokertecken-subdomän genom att ange tecknet * istället för namnet. Sitens besökare kommer att omdirigeras till denna subdomän oavsett subdomännamnet de anger i en webbläsare.',
    'web.add-subdomain.subdomainName' => 'Subdomän namn',
    'web.add-subdomain.subdomainNameHint' => 'Skriv in * för att skapa en joker-subdomän.',
    'web.add-subdomain.forDomain' => 'Huvuddomän',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Subdomänen har skapats.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Värdtjänst-inställningar',

    'web.setupService.formTitle' => 'Inställningstjänst: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Tjänsten \'%%serviceReference%%\' har uppdaterats korrekt.',

    'web.site-copy.subdomainsGroup' => '%%siteName%%-subdomäner:',
    'web.site-copy.destinationTypeSection' => 'Kopiera mål',
    'web.site-copy.destinationType' => 'Välj vart filerna ska kopieras',
    'web.site-copy.destinationTypeSite' => 'Webbplats i Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Kopiera webbplatsens filer till en annan av dina webbplatser som värdbaseras på detta konto. Om duhar FTP-åtkomst till ett annat konto på denna server, ska du använda tillvalet FTP-lagring.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Kopiera sitens filer till en annan site som hostas på denna server.',
    'web.site-copy.destinationTypeSiteSelect' => 'Webplatsnamn',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Filerna på siten %%source%% kan inte kopieras till %%destination%% eftersom %%destination%% också är en del av de filerna - dess dokumentrot är en underkatalog till dokumentroten för %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Filer på siten %%destination%% kan inte tas bort eftersom %%source%%-filer är en del av dem - dokumentroten %%source%% är en underkatalog till %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP-lagring',
    'web.site-copy.destinationTypeFtpDescription' => 'Kopierar filerna på webbplatsen till ett FTP-konto i denna eller en extern server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Kopierar filerna på webbplatsen till ett FTP-konto i en extern server.',
    'web.site-copy.destinationTypeFtpHost' => "Serverns värddatornamn",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Katalog',
    'web.site-copy.destinationTypeFtpUser' => 'Användarnamn',
    'web.site-copy.destinationTypeFtpPassword' => 'Lösenord',
    'web.site-copy.destinationTypeFtpMode' => 'FTP-anslutningsmetod',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktivt läge',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'I aktivt läge skickar Plesk sin IP-adress och portnumret där Plesk lyssnar, till en extern server och servern påbörjar TCP-anslutningen. Detta läge rekommenderas när den Plesk-styrda servern inte skyddas av en brandvägg.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passivt läge',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Det passiva läget kan användas när den Plesk-styrda servern är bakom en brandvägg och inte kan acceptera inkommande TCP-anslutningar.',
    'web.site-copy.existingFiles' => 'Vad göra med befintliga filer?',
    'web.site-copy.existingFilesKeep' => 'Behåll befintliga filer på målplatsen',
    'web.site-copy.existingFilesKeepDescription' => 'Skriv över befintliga filer med identiska filnamn på målplatsen.',
    'web.site-copy.existingFilesDelete' => 'Ta bort alla befintliga filer',
    'web.site-copy.existingFilesDeleteDescription' => 'Ta bort alla filer på målsiten före kopiering.',
    'web.site-copy.emptyLogin' => 'Specificera FTP-kontots användarnamn.',
    'web.site-copy.emptyHost' => 'Specificera ett servervärddatornamn.',
    'web.site-copy.emptyPort' => 'Specificera en servervärddatorport.',
    'web.site-copy.copyInProgress' => 'Kopierar webbplatsen %%sourceName%% till %%destinationName%%. Du kommer att meddelas om förloppet via e-post (%%email%%).',
    'web.site-copy.unableToCopy' => 'Kopieringen av webbplatsens misslyckades.',
    'web.site-copy.siteCopied' => 'Webbplatsens filer har kopierats.',
    'web.site-copy.emailSubjSuccess' => 'Webbplatsens "%%source%%" filer kopierades.',
    'web.site-copy.emailSubjFailure' => 'Kopieringen av webbplatsens "%%source%%" filer misslyckades.',
    'web.site-copy.emailBodySuccess' => 'Webbplatsens "%%source%%" filer kopierades till "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Kopieringen av webbplatsens "%%source%%" filesr till "%%destination%%" misslyckades: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Vidarekopplingsinställningar',
    'web._shared.forwardDestination' => 'Måladress',
    'web._shared.forwardDestinationHint' => 'URL för mål-webbplatsen.',
    'web._shared.forwardingTypeOptions' => 'Vidarebefordringstyp',
    'web._shared.forwardingFrame' => 'Frame vidarebefordran',
    'web._shared.forwardingFrameHint' => 'Omdirigera webbplatsbesökare till en annan webbplats, men visa dem inte destinationsadressen så att de inte får reda på omdirigeringen.',
    'web._shared.forwardingHttpCode301' => 'Flyttade permanent (kod 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Omdirigera webbplatsbesökare till en annan webbplats, och visa dem destinationsadressen. En sådan omdirigering kommer att behålla sitens sökmotorrankningar.',
    'web._shared.forwardingHttpCode302' => 'Flyttade temporärt (kod 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Omdirigera besökare till en tillfällig webbplatskopia, när du inte vill att sökmotorer indexerar denna tillfälliga webbplats.',
    'web._shared.documentRoot' => 'Dokumentrot',
    'web._shared.documentRootHint' => 'Sökvägen till webbplatsens startkatalog.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Det går inte att ändra dokumentroten eftersom det finns webbprogram installerade på denna webbplats.',
    'web._shared.ipAddress' => 'IP-adress',
    'web._shared.shared' => 'delad',
    'web._shared.exclusive' => 'dedikerad',
    'web._shared.ipAddressHint' => "IP-adressen som webbplatsen värdbaseras på är en nätverksadress för webbplatsens virtuella värd.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (annan katalog)',
    'web._shared.certificate' => 'Certifikat',
    'web._shared.sameCertificatesHint' => 'Det valda certifikatet kommer att använda alla webbplatser som är hostade på samma dedikerade IP-adress.',
    'web._shared.differentCertificatesHint' => 'Detta abonnemang är associerat med två dedikerade IP-adresser med två olika certifikat. Det valda certifikatet kommer att ersätta ev. certifikat installerade på siter som är hostade på dessa två IP-adresser.',
    'web._shared.differentIpTypesCertificateHint' => 'Detta abonnemang är associerat med en delad och en dedikerad IP-adress. Det valda certifikatet kommer också att användas för alla andra siter som hostas på den dedikerade IP-adressen.',
    'web._shared.certificateNotSelected' => 'Inte valt',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Det finns inga SSL/TLS-certifikat i din katalog. För att lägga till ett certifikat, gå till %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'Den här sidan',
    'web._shared.seoRedirectDirection' => 'Prioriterad domän',
    'web._shared.seoRedirectDirectionHint' => 'Välj URL (med eller utan prefixet www.) som besökarna ska omdirigeras till via en SEO-säker HTTP 301-omdirigering.',
    'web._shared.seoRedirectDirectionNone' => 'Ingen',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Låt webbanvändare använda skript',

    'web-user.name' => 'Användarnamn för att ansluta till servern över FTP',
    'web-user.longName' => 'Detta användarnamn är för långt (maximalt %max% tecken är tillåtet).',
    'web-user.password' => 'Lösenord',
    'web-user.passwordConfirmation' => 'Bekräfta lösenord',
    'web-user.hardDiskQuota' => 'Hårddiskkvot',
    'web-user.hardDiskQuotaUnlimited' => 'Obegränsat',
    'web-user.hardDiskQuotaIsNotSupported' => '(hårddiskkvot stöds inte till följd av konfigurationen av serverfilsystemet)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Microsoft ASP-stöd',
    'web-user.__asp_dot_net_support' => 'Microsoft ASP.NET 2.0',
    'web-user.__ssi_support' => 'SSI-stöd',
    'web-user.__php_support' => 'PHP-stöd',
    'web-user.__cgi_support' => 'CGI-stöd',
    'web-user.__perl_unix_support' => 'Perl-stöd',
    'web-user.__perl_win_support' => 'Perl-stöd',
    'web-user.__python_unix_support' => 'Python-stöd',
    'web-user.__python_win_support' => 'Python-stöd',
    'web-user.__fastcgi_unix_support' => 'Snabb CGI-support',
    'web-user.__webstat_support' => 'Webbstatistik',
    'web-user.__apache_errdocs' => 'Anpassade feldokument',
    'web-user.__hosting_write_modify' => 'Ytterligare behörigheter för att skriva/ändra',
    'web-user.__hosting_webdeploy' => 'Web Deploy-publicering',


    'requiredFields' => 'Obligatoriska fält',
];
