<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Если ваш сайт размещен на выделенном IP-адресе, вы можете создать каталог на сайте, к которому другие пользователи смогут подключаться анонимно для скачивания и загрузки файлов по FTP. После включения анонимного доступа по FTP пользователи смогут зайти на адрес ftp://ftp.ваш-домен.com, указав имя "anonymous" (анонимный) и любой пароль.',
    'anonymous-ftp.displayLogin' => 'Показывать сообщение при входе',
    'anonymous-ftp.loginText' => 'Текст сообщения',
    'anonymous-ftp.incomingDir' => 'Разрешить загрузку в папку Incoming',
    'anonymous-ftp.incomingSubDir' => 'Разрешить создание папок в папке Incoming',
    'anonymous-ftp.incomingReadable' => 'Разрешить скачивание из папки Incoming',
    'anonymous-ftp.quota' => 'Ограничить размер папки Incoming',
    'anonymous-ftp.maxConnections' => 'Ограничить количество одновременных подключений',
    'anonymous-ftp.bandwidth' => 'Ограничить пропускную способность',
    'anonymous-ftp.unlimited' => 'Без ограничений',

    'aps.catalog.loading' => 'Загрузка...',
    'aps.catalog.searchName' => 'Приложение',
    'aps.catalog.searchVendor' => 'Разработчик',
    'aps.catalog.searchPackager' => 'Упаковщик',
    'aps.catalog.searchLicenseType' => 'Тип лицензии',
    'aps.catalog.searchLicenseTypeAny' => 'Любая',
    'aps.catalog.searchLicenseTypeFreeware' => 'Бесплатно',
    'aps.catalog.searchLicenseTypeCommercial' => 'Коммерческая',
    'aps.catalog.showSearch' => 'Показать поиск',
    'aps.catalog.hideSearch' => 'Скрыть поиск',
    'aps.catalog.buttonSearch' => 'Поиск',
    'aps.catalog.buttonResetSearch' => 'Очистить',
    'aps.catalog.showCategories' => 'Выберите категорию ниже или найдите приложение с помощью поля поиска',
    'aps.catalog.searchResults' => 'Результаты поиска',
    'aps.catalog.buttonInstall' => 'Установить',
    'aps.catalog.buttonInstallTooltip' => 'Быстро установить последнюю версию приложения с оптимальными настройками всех параметров по умолчанию.',
    'aps.catalog.buttonAdvancedInstall' => 'Выборочная установка',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Установить последнюю версию приложения и настроить все параметры.',
    'aps.catalog.buttonInstallOldVersion' => 'Установить версию',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Установить выбранную версию приложения и настроить все параметры.',
    'aps.catalog.buttonInstallDescription' => 'Установите приложение на вашем домене, если у вас уже есть ключ активации или вы просто хотите оценить пробную версию.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Установите это бесплатное приложение на сайт.',
    'aps.catalog.version' => 'Версия',
    'aps.catalog.moreVersions' => 'Другие версии',
    'aps.catalog.release' => 'Выпуск',
    'aps.catalog.overview' => 'Обзор',
    'aps.catalog.noApplicationsInCategory' => 'В этой категории нет ни одного приложения. Выберите другую категорию.',
    'aps.catalog.noCategoriesSelected' => 'Выберите категорию, чтобы увидеть список соответствующих ей приложений.',
    'aps.catalog.noSearchResults' => 'По вашему запросу не найдено ни одного приложения.',
    'aps.catalog.connectionFailed' => 'Не удалось подключиться к каталогу приложений. %%retryLink%%.',
    'aps.catalog.retry' => 'Повторить попытку',
    'aps.catalog.categoriesError' => 'В данный момент список категорий недоступен.',
    'aps.catalog.applicationsError' => 'Список приложений в данный момент недоступен.',
    'aps.catalog.detailsError' => 'Подробная информация о приложении на данный момент не доступна.',
    'aps.catalog.searchError' => 'Результаты поиска в данный момент недоступны.',
    'aps.catalog.changelogEntry' => 'версия %%version%% (выпуск %%release%%) — %%description%%',
    'aps.catalog.changelog' => 'История изменений',
    'aps.catalog.officialApplicationSite' => 'Информация о разработчике',
    'aps.catalog.returnToCategories' => '<< Назад к списку приложений',
    'aps.catalog.buttonUninstall' => 'Удалить',
    'aps.catalog.gotoHome' => 'Домашняя страница',
    'aps.catalog.all' => 'Все',
    'aps.catalog.buttonDetails' => 'Подробнее',
    'aps.catalog.buttonBuy' => 'Купить',
    'aps.catalog.buttonBuyTooltip' => 'Купить это приложение',
    'aps.catalog.buttonBuyDescription' => 'Посетите наш магазин, чтобы купить код активации для приложения.',
    'aps.catalog.buttonDownload' => 'Скачать',
    'aps.catalog.buttonDownloadDescription' => 'Скачайте приложение, если у вас уже есть код активации, или просто для ознакомления.',
    'aps.catalog.marketplaceMoreInfo' => 'Для получения более подробной информации посетите %%link%%',
    'aps.catalog.marketplaceMoreInfoLink' => 'веб-сайт поставщика приложения',

    'aps.configure.installedAt' => "Установлено в",
    'aps.configure.otherSettings' => "Другое",
    'aps.configure.globalSettings' => 'Настройки пакета',
    'aps.configure.passwordConfirmation' => 'Подтверждение пароля',
    'aps.configure.databaseParams' => 'Параметры базы данных',
    'aps.configure.noInstallationUrlAvailable' => 'Нет (внешнее приложение)',
    'aps.configure.updateSettingsSection' => 'Настройки обновлений',
    'aps.configure.forceUpdates' => 'Автоматически обновлять это приложение по мере выхода обновлений',
    'aps.configure.forceUpdatesHint' => 'Это приложение будет автоматически обновляться до новых версий. Предупреждение: пожалуйста, учтите, что обновления могут серьезно повлиять на работу приложений. Например, после перехода на новую версию приложения могут перестать работать некоторые из его расширений.',

    'aps.install.showAllSettings' => 'Показать дополнительные настройки',
    'aps.install.showLessSettings' => 'Скрыть дополнительные настройки',
    'aps.install.install' => 'Установить',
    'aps.install.otherSettings' => 'Другие настройки',
    'aps.install.globalSettings' => 'Настройки пакета',
    'aps.install.passwordConfirmation' => 'Подтверждение пароля',
    'aps.install.provisionsSectionLabel' => 'Путь установки',
    'aps.install.context' => 'Укажите, куда вы хотите установить это веб-приложение',
    'aps.install.registerAsWebmailSection' => 'Регистрация веб-почты',
    'aps.install.registerAsWebmailDescription' => "Выберите эту опцию, если приложение является почтовым веб-клиентом. Это добавит приложение в список доступных почтовых опций в подписках и тарифных планах. Настроить URL этого приложения можно на странице Управление сервером > Настройки > Веб-почта.",
    'aps.install.registerAsWebmailLabel' => 'Зарегистрировать как почтовый веб-сервис',
    'aps.install.addItem' => 'Добавить',
    'aps.install.removeItem' => 'Удалить',
    'aps.install.updateSettingsSection' => 'Настройки обновлений',
    'aps.install.forceUpdates' => 'Автоматически обновлять это приложение по мере выхода обновлений',
    'aps.install.forceUpdatesHint' => 'Это приложение будет автоматически обновляться до новых версий. Предупреждение: пожалуйста, учтите, что обновления могут серьезно повлиять на работу приложений. Например, после перехода на новую версию приложения могут перестать работать некоторые из его расширений.',

    'aps.invalid-requirements.requirementsLegend' => 'Требования',
    'aps.invalid-requirements.domainLegend' => 'Веб-сайт',
    'aps.invalid-requirements.context' => 'Выберите другой веб-сайт',
    'aps.invalid-requirements.backToApplicationList' => 'Назад к списку приложений',

    'aps.license.title' => 'Установка %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Чтобы установить это приложение, вам необходимо ознакомиться с лицензионным соглашением для конечных пользователей и подтвердить свое согласие с его условиями.',
    'aps.license.licenseAgree' => 'Я принимаю условия Лицензионного соглашения',

    'aps.services-list-customization.settings' => 'Настройки',

    'asp-dot-net.change-version.title' => 'Выбор версии ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Версия ASP.NET',
    'asp-dot-net.change-version.success' => 'Версия ASP.NET была изменена.',

    'asp-dot-net.settings.casSettingsSection' => "Управление доступом для кода (CAS)",
    'asp-dot-net.settings.clientScriptsSection' => "Параметры библиотеки скриптов",
    'asp-dot-net.settings.connStringsSection' => "Управление строками подключения",
    'asp-dot-net.settings.customErrorsSection' => "Параметры пользовательских ошибок",
    'asp-dot-net.settings.frameworkVersionSection' => "Версия платформы",
    'asp-dot-net.settings.globalizationSection' => "Параметры глобализации",
    'asp-dot-net.settings.otherSection' => "Параметры сеанса",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Компиляция и отладка",
    'asp-dot-net.settings.authMode' => "Режим аутентификации",
    'asp-dot-net.settings.connStrings' => "Строки подключения",
    'asp-dot-net.settings.connStringsInvalid' => "Некоторые поля пусты или содержат недопустимые значения.",
    'asp-dot-net.settings.connStringName' => "Имя",
    'asp-dot-net.settings.connStringValue' => "Параметры подключения",
    'asp-dot-net.settings.connStringsDescription' => "Имя / Параметры подключения",
    'asp-dot-net.settings.culture' => "Язык и региональные параметры",
    'asp-dot-net.settings.customErrMode' => "Режим пользовательских ошибок",
    'asp-dot-net.settings.customErrorRedirect' => "URL-адрес перенаправления",
    'asp-dot-net.settings.customErrorStatus' => "Код состояния",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Код состояния должен быть целым числом.",
    'asp-dot-net.settings.customErrors' => "Пользовательские ошибки",
    'asp-dot-net.settings.customErrorsDescription' => "Код состояния / URL-адрес перенаправления",
    'asp-dot-net.settings.customErrorsInvalid' => "Некоторые поля пусты или содержат недопустимые значения.",
    'asp-dot-net.settings.debugMode' => "Включить отладку",
    'asp-dot-net.settings.defLanguage' => "Язык страниц по умолчанию",
    'asp-dot-net.settings.tempDirectory' => "Временная папка",
    'asp-dot-net.settings.fileEnc' => "Кодировка файлов",
    'asp-dot-net.settings.fileEncInvalid' => "Указана недопустимая кодировка файлов.",
    'asp-dot-net.settings.pathToLib' => "Путь к библиотеке скриптов Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Установить",
    'asp-dot-net.settings.reqEnc' => "Кодировка запросов",
    'asp-dot-net.settings.reqEncInvalid' => "Указана недопустимая кодировка запросов.",
    'asp-dot-net.settings.resEnc' => "Кодировка ответов",
    'asp-dot-net.settings.resEncInvalid' => "Указана недопустимая кодировка ответов.",
    'asp-dot-net.settings.sessTimeout' => "Таймаут сеанса (в минутах)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Указан недопустимый таймаут сеанса. Введите положительное целое число не более %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Имя строки подключения уже используется.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Значение кода статуса должно быть в диапазоне 100-999",
    'asp-dot-net.settings.customErrorDuplicate' => "Этот код состояния уже используется.",
    'asp-dot-net.settings.trustLevel' => "Уровень доверия CAS",
    'asp-dot-net.settings.uiCulture' => "Язык и региональные параметры интерфейса",
    'asp-dot-net.settings.version' => "Версия",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Разрешить переопределение уровня доверия CAS на сайте',
    'asp-dot-net.settings.updateSuccess' => 'Успешно обновлено',

    'database.clone.versionCut' => 'версия %%version%%',
    'database.clone.cloneInProgress' => 'Выполняется клонирование базы данных %%source%% в базу данных %%destination%%. Вы будете получать уведомления о ходе этой операции на адрес %%email%%.',
    'database.clone.unableToClone' => 'Не удалось скопировать базу данных: "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Не удалось создать базу данных "%%destination%%" на указанном сервере.',
    'database.clone.databaseCloned' => 'База данных "%%source%%" скопирована.',
    'database.clone.emailSubjSuccess' => 'База данных "%%sourceDatabase%%" скопирована.',
    'database.clone.emailSubjFailure' => 'Копирование базы данных "%%sourceDatabase%%" не удалось.',
    'database.clone.emailBodySuccess' => 'База данных "%%sourceDatabase%%" (%%sourceHost%%) скопирована в базу данных "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Невозможно скопировать базу данных "%%sourceDatabase%%" (%%sourceHost%%) в базу данных "%%destDatabase%%" (%%destHost%%). Копирование не удалось.',
    'database.clone.localServer' => 'локальный сервер',

    'database.repair-orphaned.formDescription' => 'Этот пользователь был потерян в процессе восстановления. Пожалуйста, укажите пароль этого пользователя, чтобы устранить проблему. Если данный пользователь является системным и у него нет пароля, запустите процесс исправления, оставив поле пароля пустым.',
    'database.repair-orphaned.login' => 'Имя пользователя базы данных',
    'database.repair-orphaned.pass' => 'Пароль',
    'database.repair-orphaned.pass2' => 'Подтверждение пароля',
    'database.repair-orphaned.users' => 'В отношении некоторых пользователей баз данных требуется ваше вмешательство. Имеется несколько потерянных пользователей, которых необходимо восстановить для корректной работы.',
    'database.repair-orphaned.orphaned' => 'Пользователь потерян. %%gui begin:link%%Исправить%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Исправить',

    'database.repair.fixSelected' => 'Исправить выбранные',
    'database.repair.fix' => 'Исправить',

    'database.user.username' => 'Имя пользователя базы данных',
    'database.user.password' => 'Пароль',
    'database.user.passwordConfirmation' => 'Подтверждение пароля',
    'database.user.server' => 'Сервер баз данных',
    'database.user.versionCut' => 'версия %%version%%',
    'database.user.database' => 'База данных',
    'database.user.anyDatabase' => 'Все',
    'database.user.dataAccess' => 'Доступ к данным',
    'database.user.structureAccess' => 'Доступ к структуре',
    'database.user.globalAccess' => 'Глобальные права',
    'database.user.globalAccessHint' => 'Глобальные права действуют для всех баз данных этой учетной записи хостинга.',
    'database.user.aclRadio' => 'Управление доступом',
    'database.user.aclLocalhost' => 'Разрешить только локальные подключения',
    'database.user.aclAny' => 'Разрешить удаленные подключения с любого компьютера',
    'database.user.aclCustom' => 'Разрешить удаленные подключения с указанных компьютеров',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nУказанным здесь компьютерам разрешено подключаться к базе данных от лица этого пользователя.",
    'database.user.remoteAccess' => 'Удаленный доступ',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nУказанным здесь IP-адресам разрешено подключаться к базе данных через правила брандмауэра. Изменения, которые вы внесете в этот список, будут предварительно проверены вашим хостинг-провайдером.",
    'database.user.example' => "Пример:\n%%example%%",
    'database.user.denied' => 'Использовать правила системного брандмауэра',
    'database.user.allowed' => 'Разрешить удаленные подключения с указанных компьютеров',
    'database.user.default' => 'Использовать учетные данные пользователя по умолчанию для доступа к %%webadmin%%',
    'database.user.remoteAccessHint' => 'Пожалуйста, уточните у своего хостинг-провайдера, не противоречит ли указанный вами адрес текущим правилам брандмауэра относительно входящих подключений к MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Веб-администратор',
    'database.user.role' => 'Роль',
    'database.user.roleReadWrite' => 'Чтение и запись',
    'database.user.roleWriteOnly' => 'Только запись',
    'database.user.roleReadOnly' => 'Только чтение',
    'database.user.roleCustom' => 'Персональный',

    'database.versionCut' => 'версия %%version%%',

    'deployment-section.deploymentDisabledHint' => 'Загрузить файлы из репозитория Git',
    'deployment-section.deploymentEnabledHint' => 'Включить поддержку Git',
    'deployment-section.deploymentSectionLegend' => 'Ваши файлы для копирования на хостинг',
    'deployment-section.deploymentSectionDescriptionHint' => 'Если вы оставите поддержку Git отключенной, корневые папки (корневая папка сайта или приложения, а также корневая папка домена) будут созданы пустыми, а сайт будет показывать в браузере страницу по умолчанию. Вам нужно будет загрузить файлы вашего сайта в корневую папку домена по FTP или с помощью менеджера файлов. Другой вариант ― включить Git сейчас или позже (в разделе "Сайты и домены") и загрузить файлы из репозитория Git.',

    'dns-zone.add-acl-record.description' => 'Добавить IP-адрес сервера DNS, которому разрешено получить копию зоны DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-адрес',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-адрес/маска',

    'dns-zone.record.add-title' => "Добавить запись в шаблон зоны.",
    'dns-zone.record.add-ns-title' => "Добавить сервер имен",
    'dns-zone.record.edit-title' => "Редактировать запись",
    'dns-zone.record.edit-success' => "Запись DNS обновлена.",
    'dns-zone.record.add-success' => "Запись DNS создана.",
    'dns-zone.record.type' => "Тип записи",
    'dns-zone.record.domainName' => "Имя домена",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Сервер имен",
    'dns-zone.record.optionOff' => 'Выключен',
    'dns-zone.record.optionOn' => 'Включен',
    'dns-zone.record.protocol' => "Протокол",
    'dns-zone.record.priority' => "Приоритет",
    'dns-zone.record.priorityLow' => "низкий (%%priority%%)",
    'dns-zone.record.priorityHigh' => "очень высокий (%%priority%%)",
    'dns-zone.record.weightLow' => "низкий (%%weight%%)",
    'dns-zone.record.weightHigh' => "очень высокий (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-адрес",
    'dns-zone.record.ipAddressDescription' => "Например, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Например, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-адрес",
    'dns-zone.record.ipAddressV6Description' => "Например, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Например, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Например, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Например, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Например, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Каноническое имя",
    'dns-zone.record.mailDomain' => "Почтовый домен",
    'dns-zone.record.mxServer' => "Почтовый сервер",
    'dns-zone.record.mxServerPriority' => "Укажите приоритет почтового сервера",
    'dns-zone.record.txtRecord' => "TXT-запись",
    'dns-zone.record.txtRecordString' => "Укажите строку записи",
    'dns-zone.record.txtSpfSyntax' => "Запись SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Указаны недопустимые значения для записи TXT.",
    'dns-zone.record.quotedTxtRecord' => "Значение TXT-записи должно быть одной текстовой строкой без кавычек.",
    'dns-zone.record.dsRecord' => "Запись DS",
    'dns-zone.record.dsRecordDescription' => "Например, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "Указано недопустимое значение для записи DS.",
    'dns-zone.record.serviceName' => "Имя службы",
    'dns-zone.record.serviceNameDescription' => 'Например: SIP (без символа подчеркивания).',
    'dns-zone.record.protocolNameDescription' => 'Например: tcp (без символа подчеркивания).',
    'dns-zone.record.portDescription' => 'Например: 25 (без символа подчеркивания).',
    'dns-zone.record.srvWeight' => "Относительный вес для записей с таким же приоритетом",
    'dns-zone.record.targetHost' => "Целевой компьютер",
    'dns-zone.record.targetHostDescription' => "Например, example.com",
    'dns-zone.record.targetPort' => "Целевой порт",
    'dns-zone.record.targetPortDescription' => 'Например, 8443.',
    'dns-zone.record.retrieveDataError' => "Данные этой записи не найдены.",
    'dns-zone.record.unknownTypeError' => "Неизвестный тип записи DNS.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Не удалось настроить нулевую MX-запись, так как присутствует другая MX-запись.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Не удалось настроить ненулевую MX-запись, так как присутствует нулевая MX-запись.',
    'dns-zone.record.masterShouldBeRemote' => "У вас должно быть два разных полномочных сервера имен на разных хостах.",
    'dns-zone.record.caaTag' => "Тег",
    'dns-zone.record.caaRecord' => "Значение",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Порт',
    'dns-zone.record.tlsaProtocol' => 'Протокол',
    'dns-zone.record.tlsaUsage' => 'Использование',
    'dns-zone.record.tlsaSelector' => 'Селектор',
    'dns-zone.record.tlsaMatching' => 'Совпадающий тип',
    'dns-zone.record.tlsaCertData' => 'Данные ассоциации сертификата',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Подробнее см. в %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, раздел 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, раздел 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, раздел 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, раздел 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "псевдоним (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Например, example.com. Пустое значение означает, что хост совпадает с именем домена.',
    'dns-zone.record.httpsProtocols' => 'Протоколы',
    'dns-zone.record.httpsProtocolsDescription' => 'Разделенный запятыми список протоколов, которые поддерживаются целевым сервером. Например, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Принудительно использовать только указанные протоколы. Список протоколов выше не должен быть пустым.',
    'dns-zone.record.httpsIpv4hint' => 'Подсказка по IPv4-адресам',
    'dns-zone.record.httpsIpv4hintDescription' => 'Разделенный запятыми список IPv4-адресов, которые могут использоваться клиентом для доступа к службе.',
    'dns-zone.record.httpsIpv6hint' => 'Подсказка по IPv6-адресам',
    'dns-zone.record.httpsIpv6hintDescription' => 'Разделенный запятыми список IPv6-адресов, которые могут использоваться клиентом для доступа к службе.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Секунд",
    'dns-zone.record.invalidValue' => 'Недопустимое значение. Значение должно быть в диапазоне от 1 до 2147483647 секунд.',
    'dns-zone.record.ttlDefaultValue' => 'Значение по умолчанию: %%value%% секунд',
    'dns-zone.record.invalidTTL' => 'Недопустимое значение TTL.',
    'dns-zone.record.invalidIpAddress' => 'Указан недопустимый IP-адрес.',
    'dns-zone.record.invalidIpMaskPair' => 'Недопустимый IP-адрес или комбинация маски сети.',
    'dns-zone.record.invalidCName' => 'Недопустимое каноническое имя.',
    'dns-zone.record.invalidPort' => 'Указан недопустимый порт.',
    'dns-zone.record.invalidTLSACertData' => 'Указанные данные ассоциации сертификата недопустимы.',
    'dns-zone.record.invalidTLSAProtocol' => 'Указанный протокол недопустим.',
    'dns-zone.record.invalidTLSAUsage' => 'Указанное использование недопустимо.',
    'dns-zone.record.invalidTLSASelector' => 'Указанный селектор недопустим.',
    'dns-zone.record.invalidTLSAMatching' => 'Указанный совпадающий тип недопустим.',

    'dns-zone.restore-default.formHint' => "Здесь вы можете восстановить исходные настройки зоны в соответствии со стандартным шаблоном DNS, используемым на сервере. Выберите IP-адреса, которые следует использовать для восстановления зоны, и укажите, требуется ли этому домену псевдоним с префиксом www.",
    'dns-zone.restore-default.ipv4' => "IPv4-адрес",
    'dns-zone.restore-default.ipv4Hint' => "Например, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-адрес",
    'dns-zone.restore-default.ipv6Hint' => "Например, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Указан недопустимый IP-адрес.',
    'dns-zone.restore-default.customIpHint' => "Записи с этим IP-адресом будут считаться измененными пользователем и не будут синхронизироваться с серверным шаблоном DNS.",
    'dns-zone.restore-default.wwwPrefix' => "Префикс www",
    'dns-zone.restore-default.previewRecords' => "Восстановить записи, служащие для предварительного просмотра сайта",

    'dns-zone.soa-record.soaMnameSection' => 'Первичный сервер имен',
    'dns-zone.soa-record.soaMname' => 'Сервер имен',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Автовыбор)',
    'dns-zone.soa-record.soaRecordSection' => 'Запись SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Обновить',
    'dns-zone.soa-record.retry' => 'Повторить',
    'dns-zone.soa-record.expire' => 'Истечение',
    'dns-zone.soa-record.minimum' => 'Минимум',
    'dns-zone.soa-record.rnameType' => 'Электронная почта (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Адрес электронной почты лица, ответственного за зону DNS домена. Возвращается сервером DNS в ответ на запросы SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Адрес электронной почты владельца сайта',
    'dns-zone.soa-record.rnameTypeDomain' => 'Адрес электронной почты домена',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Введите только локальную часть адреса (перед @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Внешний адрес электронной почты',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Запретить изменение адреса электронной почты RNAME для отдельных доменов',
    'dns-zone.soa-record.invalidValue' => 'Недопустимое значение. Значение должно быть от 1 секунды до 68 лет.',
    'dns-zone.soa-record.advancedSection' => 'Расширенные функции DNS',
    'dns-zone.soa-record.serialNumberFormat' => 'Использовать формат серийного номера, рекомендуемый IETF и RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Выберите эту опцию, если не удается пройти у регистратора проверку SOA-записи для домена. Многие регистраторы доменов требуют такой формат серийного номера.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Использовать настройки по умолчанию',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Настройки зоны по умолчанию',
    'dns-zone.soa-record.unitSeconds' => 'секунд',
    'dns-zone.soa-record.unitMinutes' => 'минут',
    'dns-zone.soa-record.unitHours' => 'часов',
    'dns-zone.soa-record.unitDays' => 'дней',
    'dns-zone.soa-record.unitWeeks' => 'недель',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Значение интервала Refresh меньше чем один час, что может привести к увеличению трафика и нагрузки на сервер.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Если для параметра Minimum TTL будет установлено значение более 3 часов, то ваш домен может стать недоступным для некоторых администраторов домена. Рекомендуется устанавливать такое значение только в том случае, если на этом настаивает орган, который зарегистрировал ваше доменное имя.',
    'dns-zone.soa-record.success' => 'Свойства записи SOA обновлены.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Запись SOA по умолчанию восстановлена.',

    'domain-info-section.domainName' => 'Имя домена',
    'domain-info-section.emptyDomainName' => 'Пожалуйста, укажите имя домена.',
    'domain-info-section.ipAddress' => 'IP-адрес',
    'domain-info-section.shared' => 'общий',
    'domain-info-section.exclusive' => 'выделенный',
    'domain-info-section.ipAddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта. Этот IP-адрес будет использоваться для всех сайтов, созданных в рамках этой подписки.",
    'domain-info-section.ipAddressHint_powerUser' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта. Этот IP-адрес будет использоваться для всех сайтов, созданных в рамках этого веб-пространства.",
    'domain-info-section.userName' => 'Имя пользователя',
    'domain-info-section.userNameHint' => 'Системная учетная запись, закрепленная за веб-пространством, которая служит для доступа к файлам подписки по FTP и SSH.',
    'domain-info-section.emptyLogin' => 'Пожалуйста, укажите имя пользователя.',
    'domain-info-section.password' => 'Пароль',
    'domain-info-section.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'domain-info-section.passwordConfirmation' => 'Повторите пароль',

    'email-address.generalTab' => 'Общие',
    'email-address.generalHint' => 'Если эта почтовая учетная запись привязана к дополнительному пользователю (доступ в Панель клиента включен), то изменения, вносимые на этой странице, будут распространяться и на настройки этого пользователя. Например, если вы измените адрес электронной почты и пароль, они соответствующим образом изменятся и у дополнительного пользователя.',
    'email-address.redirectTab' => 'Перенаправление',
    'email-address.redirectHint' => 'Настройте перенаправление писем на один или несколько адресов электронной почты.',
    'email-address.aliasesTab' => 'Почтовые псевдонимы',
    'email-address.autoResponderTab' => 'Автоответчик',
    'email-address.antispamTab' => 'Антиспам',
    'email-address.autoResponderHint' => 'Настройте автоматическую отправку ответов на все сообщения, приходящие на ваш адрес электронной почты. Автоответчик — это стандартный способ уведомления пишущих вам людей о том, что вас нет в офисе или вы в отпуске.',
    'email-address.antivirusTab' => 'Антивирус',
    'email-address.name' => 'Адрес электронной почты',
    'email-address.externalEmail' => 'Внешний адрес электронной почты',
    'email-address.externalEmailHint' => 'Будет использоваться для сброса вашего пароля в случае, если у вас не будет доступа к основному адресу электронной почты.',
    'email-address.user' => 'Владелец',
    'email-address.password' => 'Пароль',
    'email-address.passwordConfirmation' => 'Подтверждение пароля',
    'email-address.clientConfigurationLink' => 'Ссылка на конфигуратор почты',
    'email-address.responderEnable' => 'Включить автоответчик',
    'email-address.responderSubject' => 'Тема сообщения',
    'email-address.responderContentType' => 'Формат сообщения',
    'email-address.responderContentTypeHint' => 'Текст в обычном формате поддерживается всеми почтовыми программами, поэтому все получатели будут видеть сообщения так же, как вы. HTML-сообщения смотрятся лучше, так как они позволяют форматировать текст разными шрифтами и стилями. Однако некоторые почтовые программы не поддерживают HTML-сообщения, и есть риск, что некоторые получатели не смогут увидеть форматированный текст.',
    'email-address.responderContentTypeTextPlain' => 'Обычный текст',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Кодировка',
    'email-address.responderCodepageHint' => 'Кодировка определяет, как отображаются текстовые символы. Рекомендуемая кодировка — UTF-8.',
    'email-address.responderReplyTo' => 'Перенаправлять на',
    'email-address.responderReplyToHint' => 'При отправке автоматического ответа исходное сообщение будет перенаправлено на указанный адрес электронной почты.',
    'email-address.responderForwardAddress' => 'Перенаправлять на',
    'email-address.responderForwardAddressHint' => 'При отправке автоматического ответа исходное сообщение будет перенаправлено на указанный адрес электронной почты.',
    'email-address.responderMessage' => 'Текст сообщения',
    'email-address.responderReplyToEqualsEmail' => 'Указанный адрес перенаправления совпадает с исходным адресом электронной почты.',
    'email-address.responderForwardAddressEqualsEmail' => 'Указанный адрес перенаправления совпадает с исходным адресом электронной почты.',
    'email-address.responderReplyLimit' => 'Отправлять автоматический ответ на уникальный адрес электронной почты не более (раз в день)',
    'email-address.buttonAddResponderAttachment' => 'Добавить прикрепляемый файл',
    'email-address.buttonRemoveResponderAttachment' => 'Удалить',
    'email-address.responderAttachment' => 'Прикрепить файл',
    'email-address.redirectEnable' => 'Включить перенаправление почты',
    'email-address.redirectRemoveEnable' => 'Не доставлять копии перенаправленных писем в почтовый ящик Plesk',
    'email-address.redirectAddress' => 'Перенаправлять входящие сообщения на следующий адрес электронной почты',
    'email-address.redirectAddressHint' => 'Укажите адреса электронной почты. Адреса можно ввести отдельными строками или через пробел, запятую или точку с запятой.',
    'email-address.role' => 'Роль пользователя',
    'email-address.roleHint' => 'Роли обеспечивают пользователям администраторский доступ к указанным вами приложениям.',
    'email-address.errorRedirectAddress' => 'Вы указали недопустимый адрес электронной почты: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Вы указали недопустимые адреса электронной почты: %value%.',
    'email-address.mailAlias' => "Почтовый псевдоним",
    'email-address.mailAliasNone' => 'Нет',
    'email-address.mailAliasHint' => "Почтовые псевдонимы — это дополнительные адреса, прикрепленные к основному адресу электронной почты. Все сообщения, отправляемые на псевдонимы, будут приходить на основной почтовый ящик.",
    'email-address.buttonAddMailAlias' => 'Добавить почтовый псевдоним',
    'email-address.buttonRemoveMailAlias' => 'Удалить',
    'email-address.emptyEmail' => 'Укажите адрес электронной почты, на который должны перенаправляться все входящие сообщения.',
    'email-address.emailsIsEqual' => 'Внешний адрес электронной почты совпадает с основным. Укажите другой внешний адрес.',
    'email-address.emptyPassword' => 'Укажите пароль.',
    'email-address.emptyPasswordConfirmation' => 'Подтвердите пароль.',
    'email-address.emptyAlias' => "Укажите почтовый псевдоним для этого адреса электронной почты.",
    'email-address.aliasEqualsEmail' => 'Указанный почтовый псевдоним совпадает с самим адресом электронной почты.',
    'email-address.passwordHint' => 'Будет использоваться для доступа к почтовому ящику и входу в Plesk (если соответствующая опция включена).',
    'email-address.cyclicRedirect' => 'Исходный и конечный адреса для перенаправления электронной почты не должны совпадать.',
    'email-address.errorMailnameReserved' => 'Указанный адрес электронной почты уже используется.',
    'email-address.antivirusEnable' => 'Включить защиту от вирусов для этого адреса электронной почты',
    'email-address.antivirusHint' => 'Антивирус блокирует почтовые сообщения, содержащие вирусы, и уведомляет об этом отправителя и получателя.',
    'email-address.antivirusSettings' => 'Проверять на вирусы',
    'email-address.antivirusSettingOnlyIncomingMail' => 'только входящую почту',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'только исходящую почту',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'входящую и исходящую почту',
    'email-address.antispamHint' => 'Антиспам распознает спам-сообщения, отправляемые на адрес электронной почты. Вы можете настроить антиспам таким образом, чтобы он удалял спам-сообщения, добавлял к их теме пометку "спам" или перемещал их в специальную папку, доступную почтовым клиентам по IMAP. Антиспам использует множество различных локальных и сетевых тестов для идентификации спама.',
    'email-address.antispamEnable' => 'Включить антиспам для этого адреса электронной почты',
    'email-address.antispamSettings' => 'Что делать с сообщениями, отнесенными к спаму',
    'email-address.antispamSettingsMark' => 'Помечать спам-сообщения, добавляя к их теме следующий текст',
    'email-address.antispamSettingsMarkHint' => 'Если вы не хотите добавлять никакой текст, оставьте это поле пустым. Если вы хотите, чтобы в тему письма добавлялось количество баллов, введите _SCORE_.',
    'email-address.antispamReportTextHint' => 'Введите текст, который будет добавляться в текст спам-сообщений.',
    'email-address.antispamSettingsDelete' => 'Удалять все спам-сообщения',
    'email-address.antispamSettingsDeleteHint' => 'Все спам-сообщения будут удаляться из вашего почтового ящика.',
    'email-address.antispamSettingsMove' => 'Перемещать спам в папку "Спам"',
    'email-address.antispamSettingsMoveHint' => 'Все спам-сообщения будут переноситься в папку с именем Спам. Эта папка доступна из вашего почтового клиента и через веб-интерфейс. Если вы пользуетесь почтовой учетной записью IMAP, вы можете использовать папку Спам для обучения антиспама.',
    'email-address.antispamSettingsMoveWarning' => 'Опция "Перемещать спам в папку Спам" не будет работать, пока вы не отключите опцию "Не доставлять копии перенаправленных писем в почтовый ящик Plesk" на вкладке "Перенаправление".',
    'email-address.antispamSettingsMoveJunk' => 'Перемещать спам в папку "Спам"',
    'email-address.antispamSettingsMoveJunkHint' => 'Перемещать все спам-сообщения в папку с именем "Спам". Эта папка доступна из вашего почтового клиента и через веб-интерфейс. Если вы используете почтовую учетную запись IMAP, вы можете использовать папку "Спам" для обучения антиспама.',
    'email-address.antispamShowAdvancedSection' => 'Показать расширенные настройки',
    'email-address.antispamHideAdvancedSection' => 'Скрыть расширенные настройки',
    'email-address.antispamLearnMore' => 'Узнайте, как обучать антиспам.',
    'email-address.antispamFilterScoreTitle' => 'Чувствительность антиспама',
    'email-address.antispamFilterScoreHint' => 'Антиспам выполняет несколько различных проверок содержимого и темы каждого сообщения. В результате каждому сообщению присваивается определенное количество баллов. Чем больше это число, тем больше вероятность того, что сообщение является спамом. По умолчанию чувствительность антиспама настроена таким образом, что все сообщения, имеющие 7 и более баллов, классифицируются как спам. Если при таких настройках вы получаете много спама, попробуйте увеличить чувствительность антиспама, указав более низкое значение, например 6. Если вы пропускаете письма из-за того, что ваш антиспам ошибочно распознает их как спам, попробуйте уменьшить его чувствительность, указав более высокое значение, например 8.',
    'email-address.antispamFilterScore' => 'Чувствительность антиспама',
    'email-address.antispamWhiteListTitle' => 'Белый список',
    'email-address.antispamWhiteListHint' => 'Почтовые сообщения от отправителей из белого списка не проверяются антиспамом.',
    'email-address.antispamWhiteListField' => 'Белый список',
    'email-address.antispamWhiteListFieldHint' => 'Введите доменные имена по одному в каждой строке. Адреса могут содержать замещающие символы "*" и "?", например, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Черный список',
    'email-address.antispamBlackListHint' => 'Почтовые сообщения от отправителей из черного списка считаются спамом.',
    'email-address.antispamBlackListField' => 'Черный список',
    'email-address.antispamBlackListFieldHint' => 'Введите доменные имена по одному в каждой строке. Адреса могут содержать замещающие символы "*" и "?", например, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Надежные языки',
    'email-address.antispamTrustedLanguagesHint' => 'Письма, написанные на этих языках, всегда будут проходить антиспам.',
    'email-address.antispamTrustedLocalesTitle' => 'Надежные группы локалей',
    'email-address.antispamTrustedLocalesHint' => 'Письма, использующие указанные группы локалей, всегда будут проходить антиспам. Группы локалей включают наиболее распространенные наборы символов. Например, западный набор символов включает кодировки для букв, используемых в английском и западно-европейских языках.',
    'email-address.antispamTrustedNetworksTitle' => 'Надёжные сети',
    'email-address.antispamTrustedNetworksHint' => 'Промежуточные узлы из надежных сетей исключаются из списка потенциально находящихся под управлением спамеров и не являются открытыми ретрансляторами или открытыми прокси-серверами.',
    'email-address.antispamIpAddressesField' => 'IP-адреса',
    'email-address.antispamIpAddressesFieldHint' => 'Укажите сетевой IP-адрес и маску.',
    'email-address.mailBoxQuotaDomainDefault' => 'Размер по умолчанию (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Размер по умолчанию',
    'email-address.mailBoxOutgoingMessages' => 'Максимальное количество исходящих сообщений',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'По умолчанию (%%domainOutgoingMessages%% сообщений в час)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Отдельное значение',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'сообщений',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'По умолчанию',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Размер по умолчанию',
    'email-address.mailBoxQuotaDomainSpecific' => 'Другой размер',
    'email-address.mailBoxQuotaDomainSpecificValue' => 'Другое значение размера',
    'email-address.mailBoxQuotaDomainSpecificMultiplier' => 'Единицы измерения размера',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Размер почтового ящика',
    'email-address.mailBoxQuotaUnlimited' => 'Без ограничения',
    'email-address.mailBoxLimitReached' => 'Ограничение на количество почтовых ящиков исчерпано.',
    'email-address.postboxEnabled' => 'Почтовый ящик',
    'email-address.postboxEnabledYes' => 'Вкл.',
    'email-address.postboxEnabledNo' => 'Выкл.',
    'email-address.description' => 'Описание в Plesk',
    'email-address.descriptionHint' => 'Это описание видно всем, у кого есть доступ к этой учетной записи почты.',
    'email-address.longDescription' => 'Слишком длинное описание. Максимальное количество символов ‒ %%max%%.',
    'email-address.loginAsUser' => 'Может использоваться для входа в Plesk',
    'email-address.loginAsUserDescription' => '(имя пользователя: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Размер почтового ящика не может превышать размер по умолчанию.',
    'email-address.endDateEnable' => 'Выключить автоответчик',

    'failed-request.enable-tracing.description' => 'Отслеживание невыполненных запросов является ресурсоемкой операцией. Отслеживание автоматически остановится через %%days%% дней. Вы можете остановить его вручную в любое время.',
    'failed-request.enable-tracing.statusCodes' => 'Коды состояния',
    'failed-request.enable-tracing.statusCodesDescription' => 'Пример: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Провайдер',

    'file-manager.permissions.filePermissions' => 'Права на файл',
    'file-manager.permissions.directoryPermissions' => 'Права на папку',
    'file-manager.permissions.buttonSubmit' => 'Сохранить',
    'file-manager.permissions.buttonApply' => 'Сохранить и возобновить',
    'file-manager.permissions.buttonCancel' => 'Отмена',
    'file-manager.permissions.buttonAdvanced' => 'Дополнительно',

    'file-manager.unix-file-permissions.group' => 'Группа',
    'file-manager.unix-file-permissions.owner' => 'Владелец',
    'file-manager.unix-file-permissions.others' => 'Остальные',
    'file-manager.unix-file-permissions.readMode' => 'Чтение',
    'file-manager.unix-file-permissions.writeMode' => 'Запись',
    'file-manager.unix-file-permissions.execMode' => 'Выполнение/поиск',
    'file-manager.unix-file-permissions.changeRecursive' => 'Изменять права рекурсивно',

    'file-manager.windows-permissions.allow' => 'Разрешить',
    'file-manager.windows-permissions.deny' => 'Запретить',
    'file-manager.windows-permissions.inheritFromParent' => 'Разрешить передачу наследуемых прав от родительского объекта к этому объекту и всем дочерним объектам. Добавлять их к явно заданным здесь',
    'file-manager.windows-permissions.replaceOnChildren' => 'Заменить права для всех дочерних объектов на заданные здесь',
    'file-manager.windows-permissions.buttonAdvanced' => 'Дополнительно',
    'file-manager.windows-permissions.applyTo' => 'Применять к:',
    'file-manager.windows-permissions.folderOnly' => 'Только эта папка',
    'file-manager.windows-permissions.subfolderOnly' => 'Только подпапки',
    'file-manager.windows-permissions.filesOnly' => 'Только файлы',
    'file-manager.windows-permissions.permissionsFor' => 'Права для',
    'file-manager.windows-permissions.applyOnto1' => 'Только эта папка',
    'file-manager.windows-permissions.applyOnto2' => 'Только подпапки',
    'file-manager.windows-permissions.applyOnto3' => 'Эта папка и вложенные папки',
    'file-manager.windows-permissions.applyOnto4' => 'Только файлы',
    'file-manager.windows-permissions.applyOnto5' => 'Эта папка и файлы',
    'file-manager.windows-permissions.applyOnto6' => 'Вложенные папки и файлы',
    'file-manager.windows-permissions.applyOnto7' => 'Эта папка, вложенные папки и файлы',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => 'Редактор текста',
    'file-manager.editor.titleCodeEditor' => 'Редактор кода',
    'file-manager.editor.titleHtmlEditor' => 'Редактор HTML',
    'file-manager.editor.titleCodeViewer' => 'Просмотреть',
    'file-manager.editor.buttonSubmit' => 'Сохранить',
    'file-manager.editor.buttonApply' => 'Сохранить и возобновить',
    'file-manager.editor.buttonSaveAs' => 'Сохранить как ...',
    'file-manager.editor.buttonCancel' => 'Отмена',
    'file-manager.editor.exitConfirmationYes' => 'Да',
    'file-manager.editor.exitConfirmationNo' => 'Нет',
    'file-manager.editor.fileOverwrite' => 'Файл уже существует.',
    'file-manager.editor.fileOverwriteDescription' => 'Файл с таким именем уже существует. Перезаписать его?',
    'file-manager.editor.exitConfirmation' => 'Вы уверены, что хотите закрыть файл и потерять несохраненные изменения?',
    'file-manager.editor.buttonCodeEditor' => 'Редактировать как код',
    'file-manager.editor.buttonTextEditor' => 'Редактировать как текст',

    'file-manager.html-editor.toolbar.textStyle' => 'Стиль текста',
    'file-manager.html-editor.toolbar.textStyleDesc' => 'Стиль текста',
    'file-manager.html-editor.toolbar.insert' => 'Вставить',
    'file-manager.html-editor.toolbar.insertDesc' => 'Добавьте изображения, видео, ссылки или таблицы',
    'file-manager.html-editor.toolbar.paste' => 'Вставить из буфера обмена',

    'file-manager.import-file.buttonSubmit' => 'Импортировать',
    'file-manager.import-file.fieldUrl' => 'URL-адрес файла',
    'file-manager.import-file.fieldUrlDescription' => 'Укажите исходный URL-адрес, например, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Полный шаблон URL-адреса: \'https://user:password@example.com/example.tgz\'. Имя пользователя и пароль указывать необязательно. Поддерживаемые протоколы: http, https, ftp, ftps. Используйте кодирование URL для частей URL-адреса, содержащих специальные символы или пробелы.',
    'file-manager.import-file.failure' => 'Импортировать файл не удалось.',

    'file-manager.rotation-settings.title' => 'Настройки ротации корзины',
    'file-manager.rotation-settings.rotationBySize' => 'Ротация по размеру',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'Мб',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Эта опция приводит к удалению новых файлов, после того как корзина будет заполнена.',
    'file-manager.rotation-settings.rotationByDate' => 'Ротация по дате',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Дн.',
    'file-manager.rotation-settings.rotationByDateHint' => 'Эта опция удаляет файлы, хранящиеся в корзине дольше указанного количества дней.',
    'file-manager.rotation-settings.save' => 'Сохранить',
    'file-manager.rotation-settings.cancel' => 'Отмена',

    'ftp-user.description' => 'Если вы работаете над своим сайтом совместно с кем-то или размещаете субдомены для других пользователей, рекомендуем создать для них отдельные учетные записи FTP.',
    'ftp-user.generalSection' => 'Общие',
    'ftp-user.login' => 'Имя учетной записи FTP',
    'ftp-user.home' => 'Домашняя папка',
    'ftp-user.systemArea' => 'Создать учетную запись FTP с доступом к файлам за пределами домашней папки',
    'ftp-user.password' => 'Пароль',
    'ftp-user.passwordConfirmation' => 'Подтверждение пароля',
    'ftp-user.hardQuotaSection' => 'Дисковая квота',
    'ftp-user.hardQuota' => 'Дисковая квота',
    'ftp-user.hardQuotaUnlimited' => 'Без ограничений',
    'ftp-user.permissionsSection' => 'Права',
    'ftp-user.permissionRead' => 'Чтение',
    'ftp-user.permissionWrite' => 'Запись',
    'ftp-user.selectButtonLabel' => 'Выбрать папку',
    'ftp-user.popupTitle' => 'Выбрать папку',
    'ftp-user.limitMbUnits' => 'Mб',

    'mail-list.listName' => 'Адрес рассылки',
    'mail-list.enabled' => 'Включено',
    'mail-list.administratorEmail' => 'Адрес электронной почты администратора рассылки',
    'mail-list.password' => 'Пароль',
    'mail-list.passwordConfirmation' => 'Подтверждение пароля',
    'mail-list.subscribers' => 'Подписчики',
    'mail-list.subscribersHint' => 'Укажите адреса электронной почты. Адреса можно ввести отдельными строками или через пробел, запятую или точку с запятой.',
    'mail-list.notify' => 'Уведомить администратора о создании рассылки',
    'mail-list.emptyPassword' => 'Укажите пароль.',
    'mail-list.emptyPasswordConfirmation' => 'Пожалуйста, подтвердите пароль.',
    'mail-list.errorSubscribers' => 'Недопустимые адреса: %value%.',
    'mail-list.errorMaillistReserved' => 'Указанный адрес рассылки уже используется.',

    'mail-settings.copyToClipboard' => 'Скопировать запись DNS в буфер обмена.',
    'mail-settings.copySuccess' => 'Запись DNS скопирована в буфер обмена.',
    'mail-settings.hint' => 'Здесь вы можете изменить настройки почты для выбранного домена.',
    'mail-settings.service' => 'Почтовая служба на этом домене',
    'mail-settings.nonExist' => 'Что делать с почтой для несуществующих пользователей',
    'mail-settings.nonExistBounceWithMessage' => 'Возвращать с уведомлением',
    'mail-settings.nonExistBounceWithMessagePlaceholder' => 'Этот адрес больше не принимает почту.',
    'mail-settings.nonExistBounce' => 'Возвращать',
    'mail-settings.nonExistCatch' => 'Пересылать на адрес',
    'mail-settings.nonExistCatchAddressPlaceholder' => 'Введите адрес для перенаправления',
    'mail-settings.nonExistCatchDescription' => 'Этот адрес должен принадлежать выбранному домену. Только администратор может указать внешний адрес или один адрес для нескольких доменов.',
    'mail-settings.nonExistExternal' => 'Перенаправлять на внешний почтовый сервер с IP-адресом',
    'mail-settings.nonExistReject' => 'Отклонять',
    'mail-settings.nonExistDiscard' => 'Отклонять',
    'mail-settings.webmail' => 'Веб-почта',
    'mail-settings.webmailNone' => 'Нет',
    'mail-settings.webmailComponentNotInstalled' => 'Компонент веб-почты не установлен.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Субдомен с именем %%subdomain%% уже существует.',
    'mail-settings.webmailCertificate' => 'SSL/TLS-сертификат для веб-почты',
    'mail-settings.webmailCertificateNone' => 'Не выбран',
    'mail-settings.mailCertificate' => 'SSL/TLS-сертификат для почты',
    'mail-settings.mailCertificateNone' => 'Не выбран',
    'mail-settings.serverCertificateNotSelected' => 'Сертификат был присвоен, но почта на этом домене не была защищена. Чтобы завершить защиту почты на этом домене, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'защитите почтовый сервер',
    'mail-settings.mailLists' => 'Включить списки рассылки',
    'mail-settings.mailAutodiscovery' => 'Включить автообнаружение почты',
    'mail-settings.mailAutodiscoveryDescription' => 'Читайте о том, как это работает, в %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'базе знаний',
    'mail-settings.domainKeys' => 'Использовать систему защиты от спама DKIM для подписи исходящих сообщений',
    'mail-settings.activeDkimSelector' => 'Активный селектор DKIM',
    'mail-settings.defaultDkimSelector' => ' (по умолчанию в Plesk)',
    'mail-settings.dkimSelectorName' => 'Имя селектора',
    'mail-settings.buttonCreateSelector' => 'Создать новый селектор DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Создать селектор DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Удалить селектор DKIM',
    'mail-settings.removeSelectorConfirmation' => "Удалить селектор \"%%selector%%\" и связанные с ним ключи и записи DNS?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Создать',
    'mail-settings.buttonCancel' => 'Отмена',
    'mail-settings.labelRemoveSelector' => 'Удалить',
    'mail-settings.labelActiveSelector' => 'Активный',
    'mail-settings.greyListing' => 'Включить защиту от спама на основе серого списка для всех почтовых учетных записей на этом домене',
    'mail-settings.howToConfigureExternalDns' => 'Как настроить внешний DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Чтобы включить поддержку подписи DKIM при использовании внешнего сервера DNS, вам необходимо настроить DNS-записи DKIM на сервере DNS самостоятельно.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Для этого используйте следующие DNS-записи DKIM:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Если для отправки почты вы используете псевдонимы доменов, добавьте DNS-записи DKIM и для этих псевдонимов. Используйте те же самые записи, что и для основного домена, но с указанием имени псевдонима домена.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Чтобы посмотреть, какие DNS-записи DKIM вам необходимо настроить, выберите опцию "%%option%%", примените ее и откройте это всплывающее окно еще раз.',
    'mail-settings.mailServiceDisabled' => 'Отключено',
    'mail-settings.mailServiceDisabledIncoming' => 'Отключено для входящих писем',
    'mail-settings.mailServiceDisabledHint' => 'Plesk не будет предоставлять почтовые сервисы на этом домене.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Этот домен может только отправлять почту и только с помощью Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Включено',
    'mail-settings.mailServiceEnabledHint' => 'Этот домен может отправлять и получать почту.',
    'mail-settings.mailServiceNotConfigured' => 'Не настроено',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk не будет предоставлять почтовые сервисы на этом домене.',
    'mail-settings.warning' => 'Это безвозвратно удалит почтовые ящики домена вместе с полученными и отправленными письмами.',
    'mail-settings.show.title' => 'Удалить все почтовые ящики и письма %%domain%%',
    'mail-settings.show.checkbox' => 'Безвозвратное удаление всех почтовых ящиков домена %%domain%% вместе с отправленными и полученными письмами.',

    'role.roleSection' => 'Общие',
    'role.name' => 'Роль пользователя',
    'role.description' => 'Описание',
    'role.generalPermissionsSection' => 'Доступ к опциям Plesk',
    'role.applicationsAccessSection' => 'Доступ к приложениям',
    'role.permissionAllow' => 'Разрешить',
    'role.permissionDeny' => 'Запретить',
    'role.emptyRoleName' => 'Пожалуйста, укажите название роли.',
    'role.installedAt' => 'Установлено в',
    'role.noInstallationUrlAvailable' => 'Внешнее приложение',
    'role.invalidRoleName' => 'Указанное название роли пользователя недействительно. В названии роли нельзя использовать знаки вопроса и кавычки.',
    'role.longRoleName' => 'Указанное название роли пользователя слишком длинное.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Некоторые операции могут быть недоступны по следующим причинам: недостаточно прав на выполнение операции с выбранной в данный момент подпиской, или для выполнения операции недостаточно ресурсов.',
    'role.servicesPermissionsDescription' => 'Настройте доступ к установленным приложениям или опциям Plesk для всех пользователей с этой ролью. Приложения, к которым вы откроете доступ, будут доступны пользователям в их Панели клиента.',
    'role.emailActivation' => 'Активировать учетные записи этой роли по электронной почте',

    'service.admin-access.adminAccess' => 'Администраторский доступ',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Для администраторского доступа к приложению будут использоваться указанные учетные данные.',
    'service.admin-access.login' => 'Логин администратора',
    'service.admin-access.password' => 'Пароль администратора',
    'service.admin-access.passwordConfirmation' => 'Подтверждение пароля',

    'service.info.service-entry-point.availableAt' => 'Точка доступа',
    'service.info.service-entry-point.customize' => 'Настроить ярлык',
    'service.info.service-entry-point.displayNameLabel' => 'Название ярлыка',
    'service.info.service-entry-point.displayNameDescription' => 'Укажите название ярлыка. Это название будет отображаться под иконкой ярлыка. Пользователи, имеющие доступ к этому приложению, могут видеть эти ярлыки на странице Мои услуги.',
    'service.info.service-entry-point.descriptionLabel' => 'Описание ярлыка',
    'service.info.service-entry-point.descriptionDescription' => 'Введите описание ярлыка. Оно будет показываться в виде всплывающей подсказки при наведении курсора.',
    'service.info.service-entry-point.iconLabel' => 'Нажмите, чтобы выбрать иконку ярлыка',
    'service.info.service-entry-point.iconCurrent' => 'Текущая иконка',
    'service.info.service-entry-point.errorEmptyName' => 'Укажите название ярлыка',
    'service.info.service-entry-point.errorLongName' => 'Длина названия ярлыка должна составлять от 1 до 255 символов.',
    'service.info.service-entry-point.errorLongDescription' => 'Длина описания ярлыка может составлять от 0 до 255 символов.',
    'service.info.service-entry-point.hiddenLabel' => 'Скрыть ярлык',
    'service.info.service-entry-point.hiddenDescription' => 'Не показывать этот ярлык пользователям.',

    'service.info.service-permission.assignedUser' => "Наделить этого пользователя правами администратора",
    'service.info.service-permission.assignedUserNone' => 'Не зарегистрировано ни одного пользователя',

    'shared-ssl.master-ssl.switchedOn' => 'Включить общий SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Имя домена сайта, чей SSL/TLS-сертификат будет совместно использоваться другими сайтами',
    'shared-ssl.master-ssl.none' => 'Нет',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Общий SSL/TLS не может быть включен, так как нет ни одного домена с включенной поддержкой SSL/TLS.',

    'smarthost.configuration.checkConnection.success' => 'Подключение к промежуточному узлу установлено.',
    'smarthost.settings.title' => 'Настройки промежуточного узла',
    'smarthost.settings.useSmarthost' => 'Отправлять почту через промежуточный узел',
    'smarthost.success' => 'Конфигурация промежуточного узла для %%domain%% обновлена.',

    'user.email.email' => 'Адрес электронной почты',
    'user.email.emptyEmail' => 'Необходимо указать адрес электронной почты.',
    'user.email.internalEmailHint' => 'Создайте новый адрес электронной почты в Plesk или используйте внешний адрес.',
    'user.email.longInternalEmail' => 'Слишком длинный адрес электронной почты.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Имя пользователя, используемое в этом почтовом адресе, слишком длинное для этого почтового сервера. Пожалуйста, укажите имя пользователя не длиннее %%max%% символов.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Адрес электронной почты слишком длинный для этого почтового сервера. Пожалуйста, укажите адрес не длиннее %%max%% символов.',
    'user.email.externalEmail' => 'Внешний адрес электронной почты',
    'user.email.externalEmailHint' => 'Будет использоваться для сброса вашего пароля в случае, если у вас не будет доступа к основному адресу электронной почты.',
    'user.email.emailsIsEqual' => 'Внешний адрес электронной почты совпадает с основным. Укажите другой внешний адрес.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Пожалуйста, укажите внутренний или внешний адрес электронной почты.',

    'user.profileSection' => 'Общая информация',
    'user.contactName' => 'Контактное имя',
    'user.email' => 'Адрес электронной почты',
    'user.role' => 'Роль пользователя',
    'user.accountSection' => 'Параметры Plesk',
    'user.login' => 'Имя пользователя',
    'user.password' => 'Пароль',
    'user.oldPassword' => 'Старый пароль',
    'user.buttonBack' => 'Назад',
    'user.generalTab' => 'Общие',
    'user.applicationsAccessSection' => 'Службы',
    'user.generalPermissionsSection' => 'Привилегии',
    'user.contactsTab' => 'Контактная информация',
    'user.passwordConfirmation' => 'Подтверждение пароля',
    'user.internalEmailPasswordChanged' => 'Смена пароля приведет также к смене пароля внутреннего почтового адреса.',
    'user.emailName' => 'Адрес электронной почты',
    'user.emailType' => 'Тип электронной почты',
    'user.companyName' => 'Название компании',
    'user.phone' => 'Номер телефона',
    'user.imNumber' => 'Программа для мгновенного обмена сообщениями',
    'user.imType' => 'Программа для мгновенного обмена сообщениями',
    'user.fax' => 'Факс',
    'user.address' => 'Адрес',
    'user.city' => 'Город',
    'user.state' => 'Республика, область или край',
    'user.zip' => 'Индекс',
    'user.country' => 'Страна',
    'user.additionalInfo' => 'Дополнительная информация',
    'user.additionalInfoHint' => 'Только текст: все HTML-теги будут опущены.',
    'user.language' => 'Язык Plesk',
    'user.buttonChangePassword' => 'Изменить пароль',
    'user.permissionAllow' => 'Разрешено',
    'user.permissionDeny' => 'Запрещено',
    'user.permissionInherited' => 'Определяется ролью',
    'user.emptyContactName' => 'Укажите контактное имя.',
    'user.emptyLogin' => 'Укажите имя пользователя.',
    'user.emptyPassword' => 'Укажите пароль.',
    'user.emptyPasswordConfirmation' => 'Подтвердите пароль.',
    'user.oldPasswordIsIncorrect' => 'Неверный старый пароль. Пожалуйста, попробуйте еще раз.',
    'user.chooseDomainBoxTitle' => 'Выбрать другой домен:',
    'user.userIsActive' => 'Пользователь активен',
    'user.userIsActiveHint' => 'Активные пользователи имеют доступ к Plesk.',
    'user.emailActivation' => 'Активировать учетную запись по электронной почте',
    'user.emailHint' => 'Чтобы предоставить пользователю адрес электронной почты, размещенный на этом сервере, перейдите на вкладку Почта, создайте указанный адрес электронной почты и присвойте его этому пользователю.',
    'user.emailContactHint' => 'Если вы хотите использовать адрес электронной почты, размещенный на этом сервере, обратитесь к своему сервис-провайдеру.',
    'user.personalEmailHint' => "Адрес электронной почты этого пользователя можно изменить на вкладке Почта.",
    'user.externalMailRedirectHint' => 'Перенаправление можно включить только для почтовых ящиков, размещенных на этом сервере. Чтобы создать почтовый ящик, перейдите на вкладку Почта.',
    'user.externalMailRedirectHint2' => 'Перенаправление можно включить только для почтовых ящиков, размещенных на этом сервере.',
    'user.externalMailAutoResponderHint' => 'Автоответчик можно включить только для почтовых ящиков, размещенных на этом сервере. Чтобы создать почтовый ящик, перейдите на вкладку Почта.',
    'user.externalMailAutoResponderHint2' => 'Автоответчик можно включить только для почтовых ящиков, размещенных на этом сервере.',
    'user.roleHint' => 'Роли обеспечивают пользователям администраторский доступ к указанным вами приложениям.',
    'user.cannotManageMail' => "Вам запрещено управлять настройками почты и услугами.",
    'user.longCompanyName' => 'Слишком длинное название компании.',
    'user.longPhone' => 'Указанный номер телефона слишком длинный.',
    'user.longFax' => 'Указанный номер факса слишком длинный.',
    'user.longAddress' => 'Указанный адрес слишком длинный.',
    'user.longCity' => 'Слишком длинное название города.',
    'user.phoneRegexNotMatch' => 'Недопустимый номер телефона.',
    'user.faxRegexNotMatch' => 'Указанный номер факса недействителен.',
    'user.shortCity' => 'Слишком короткое название города.',
    'user.limitSubscription' => 'Доступ к подпискам',
    'user.limitSubscriptionHint' => 'Пользователи будут иметь доступ только к указанной подписке. Если вы выберете вариант "Все", пользователи будут иметь доступ ко всем подпискам вашей учетной записи хостинга.',
    'user.limitSubscriptionAll' => 'Все',
    'user.deletedSubscription' => 'Удаленная подписка',

    'web.add-domain-alias.title' => 'Добавить псевдоним домена',
    'web.add-domain-alias.createdSuccessfully' => "Псевдоним домена %%name%% создан.",
    'web.add-domain-alias.domainAliasName' => 'Псевдоним домена',
    'web.add-domain-alias.domainAliasNameHint' => 'Например, example.net',
    'web.add-domain-alias.forDomain' => 'для домена',
    'web.add-domain-alias.settingsSectionLegend' => 'Настройки',
    'web.add-domain-alias.settingsDns' => 'Синхронизировать зону DNS с основным доменом',
    'web.add-domain-alias.settingsMail' => 'Почтовая служба',
    'web.add-domain-alias.settingsWeb' => 'Веб-служба',
    'web.add-domain-alias.settingsSeoRedirect' => 'Перенаправлять с кодом HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'При попытке открыть URL-адрес псевдонима домена посетители будут перенаправляться на URL-адрес основного домена. Plesk использует код перенаправления HTTP 301, что позволяет избежать разделения поискового рейтинга между такими URL-адресами.',
    'web.add-domain-alias.settingsTomcat' => 'Веб-приложения на Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Недопустимый домен',

    'web.add-domain.formTitle' => 'Добавление нового домена',
    'web.add-domain.portalLink' => 'Портал услуг',
    'web.add-domain.domainName' => 'Имя домена',
    'web.add-domain.domainNameHint' => "Например, example.com",
    'web.add-domain.assignToCustomer' => 'Назначить этот домен клиенту',
    'web.add-domain.customer' => 'Выберите клиента',
    'web.add-domain.createNewCustomer' => 'Создать нового клиента',
    'web.add-domain.selectExistingCustomer' => 'Выбрать существующего клиента:',
    'web.add-domain.customerContactInfoHint' => 'Введите контактные данные клиента. Остальную информацию, такую как телефон и адрес, можно указать позже.',
    'web.add-domain.customerLoginInfoHint' => 'Данные для входа в Панель клиента',
    'web.add-domain.target' => 'Веб-пространство',
    'web.add-domain.createNewTarget' => 'Создать новую подписку',
    'web.add-domain.createNewTarget_powerUser' => 'Создать новое веб-пространство',
    'web.add-domain.selectExistingTarget' => 'Выбрать существующую подписку:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Выбрать существующее веб-пространство:',
    'web.add-domain.dns' => 'Активировать службу DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Активировать почтовую службу',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Применимо, если настройки подписки разрешают управлять правом использования почты для каждого домена. Если же они не разрешают это делать, актуальный статус почтовой службы будет получен из настроек подписки.',
    'web.add-domain.hostingManagementOptions' => 'Тип хостинга',
    'web.add-domain.websiteHosting' => 'Хостинг веб-сайтов',
    'web.add-domain.websiteForwarding' => 'Перенаправление',
    'web.add-domain.websiteNoHosting' => 'Без хостинга',
    'web.add-domain.hostingSettingsSectionLegend' => 'Настройки хостинга',
    'web.add-domain.domainCreatedSuccessfully' => 'Домен %%domainName%% успешно создан.',
    'web.add-domain.webspaceLegend' => 'Настройки веб-пространства',
    'web.add-domain.addWhmWebsiteTitle' => 'Добавление сайта',
    'web.add-domain.addWhmWebsiteHint' => "Вы можете разместить сайт на этом сервере.",
    'web.add-domain.selectWhmDomain' => 'Выберите домен',
    'web.add-domain.customerLegend' => 'Информация о клиенте',
    'web.add-domain.credentials' => 'Учетные данные системного пользователя',
    'web.add-domain.credentialsHint' => 'для доступа к размещенным файлам по FTP и SSH',
    'web.add-domain.credentialsHintWin' => 'для доступа к размещенным файлам по FTP и RDP',
    'web.add-domain.buttonAddDomain' => 'Добавить домен',

    'web.add-subdomain.formTitle' => 'Добавить субдомен',
    'web.add-subdomain.formGeneralHint' => 'Субдомены — это интернет-адреса для разных разделов вашего сайта. Они используют имя и префикс вашего главного домена. Например, если ваш домен — domain.com, субдоменом может быть store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Кроме того, вы можете создать подстановочный субдомен, указав символ * вместо имени. Посетители сайта будут перенаправляться на этот субдомен независимо от того, какое имя субдомена они введут в браузере.',
    'web.add-subdomain.subdomainName' => 'Имя субдомена',
    'web.add-subdomain.subdomainNameHint' => 'Чтобы создать подстановочный субдомен, введите *.',
    'web.add-subdomain.forDomain' => 'Родительский домен',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Субдомен создан.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Настройки хостинга',

    'web.setupService.formTitle' => 'Настроить услугу: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Услуга \'%%serviceReference%%\' успешно обновлена.',

    'web.site-copy.subdomainsGroup' => 'Субдомены %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Назначение копии',
    'web.site-copy.destinationType' => 'Выберите, куда скопировать файлы сайта',
    'web.site-copy.destinationTypeSite' => 'Сайт в Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Копировать файлы сайта в другой ваш сайт, размещенный в рамках этой учетной записи. Если у вас есть FTP-доступ к другой учетной записи на этом сервере, используйте опцию FTP-хранилище.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Копировать файлы сайта в другой сайт, размещенный на этом сервере.',
    'web.site-copy.destinationTypeSiteSelect' => 'Имя сайта',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Файлы сайта %%source%% не могут быть скопированы в %%destination%%, так как %%destination%% является частью этих файлов — его корневая папка является подпапкой корневой папки %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Файлы сайта %%destination%% не могут быть удалены, так как файлы %%source%% являются их частью — корневая папка %%source%% является подпапкой %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP-хранилище',
    'web.site-copy.destinationTypeFtpDescription' => 'Скопировать файлы сайта в учетную запись FTP на этом или внешнем сервере.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Скопировать файлы сайта в учетную запись FTP на внешнем сервере.',
    'web.site-copy.destinationTypeFtpHost' => "Имя сервера",
    'web.site-copy.destinationTypeFtpPort' => "Порт",
    'web.site-copy.destinationTypeFtpFolder' => 'Папка',
    'web.site-copy.destinationTypeFtpUser' => 'Имя пользователя',
    'web.site-copy.destinationTypeFtpPassword' => 'Пароль',
    'web.site-copy.destinationTypeFtpMode' => 'Способ FTP-подключения',
    'web.site-copy.destinationTypeFtpModeActive' => 'Активный режим',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'В активном режиме Plesk посылает свой IP-адрес и номер прослушиваемого порта внешнему серверу, а этот сервер инициирует TCP-подключение. Этот режим рекомендуется использовать, если сервер с Plesk не защищен брандмауэром.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Пассивный режим',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Пассивный режим подходит для случаев, когда сервер с Plesk защищен брандмауэром и не может принимать входящие TCP-подключения.',
    'web.site-copy.existingFiles' => 'Что делать с существующими файлами',
    'web.site-copy.existingFilesKeep' => 'Сохранить существующие файлы конечного сайта',
    'web.site-copy.existingFilesKeepDescription' => 'Перезаписать существующие файлы с одинаковыми именами.',
    'web.site-copy.existingFilesDelete' => 'Удалить все существующие файлы',
    'web.site-copy.existingFilesDeleteDescription' => 'Удалить все файлы конечного сайта перед копированием.',
    'web.site-copy.emptyLogin' => 'Укажите имя пользователя FTP.',
    'web.site-copy.emptyHost' => 'Укажите имя сервера.',
    'web.site-copy.emptyPort' => 'Укажите порт сервера.',
    'web.site-copy.copyInProgress' => 'Выполняется копирование сайта %%sourceName%% в %%destinationName%%. Вы будете получать уведомления о ходе этой операции на адрес %%email%%.',
    'web.site-copy.unableToCopy' => 'Копирование файлов сайта не удалось.',
    'web.site-copy.siteCopied' => 'Файлы сайта скопированы.',
    'web.site-copy.emailSubjSuccess' => 'Файлы сайта "%%source%%" скопированы.',
    'web.site-copy.emailSubjFailure' => 'Скопировать файлы сайта "%%source%%" не удалось.',
    'web.site-copy.emailBodySuccess' => 'Файлы сайта "%%source%%" скопированы в "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Скопировать файлы сайта "%%source%%" в "%%destination%%" не удалось: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Настройки перенаправления',
    'web._shared.forwardDestination' => 'Конечный адрес',
    'web._shared.forwardDestinationHint' => 'URL-адрес целевого сайта.',
    'web._shared.forwardingTypeOptions' => 'Тип перенаправления',
    'web._shared.forwardingFrame' => 'Перенаправление во фрейме',
    'web._shared.forwardingFrameHint' => 'Перенаправлять посетителей веб-сайта на другой сайт, но не показывать им целевой адрес, чтобы они не знали о перенаправлении.',
    'web._shared.forwardingHttpCode301' => 'Окончательно перенесен (код 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Перенаправлять посетителей на другой сайт и показывать им его адрес. Это позволит сохранить поисковый рейтинг сайта.',
    'web._shared.forwardingHttpCode302' => 'Временно перенесен (код 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Перенаправлять посетителей на временный экземпляр сайта, если не хотите, чтобы он индексировался поисковыми системами.',
    'web._shared.documentRoot' => 'Корневая папка',
    'web._shared.documentRootHint' => 'Путь к домашней папке этого сайта.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Невозможно изменить корневую папку сайта, так как на сайте установлены веб-приложения.',
    'web._shared.ipAddress' => 'IP-адрес',
    'web._shared.shared' => 'общий',
    'web._shared.exclusive' => 'выделенный',
    'web._shared.ipAddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (другое хранилище)',
    'web._shared.certificate' => 'Сертификат',
    'web._shared.sameCertificatesHint' => 'Выбранный сертификат будет использоваться для всех сайтов, размещенных на одном и том же выделенном IP-адресе.',
    'web._shared.differentCertificatesHint' => 'Эта подписка имеет два выделенных IP-адреса с двумя различными сертификатами. Выбранный сертификат заменит все сертификаты, установленные на сайтах, размещенных на этих двух IP-адресах.',
    'web._shared.differentIpTypesCertificateHint' => 'Эта подписка имеет один общий и один выделенный IP-адрес. Выбранный сертификат будет также использоваться для всех сайтов, размещенных на этом выделенном IP-адресе.',
    'web._shared.certificateNotSelected' => 'Не выбран',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'В вашем хранилище нет ни одного SSL/TLS-сертификата. Чтобы добавить сертификат, откройте %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'эту страницу',
    'web._shared.seoRedirectDirection' => 'Предпочтительный домен',
    'web._shared.seoRedirectDirectionHint' => 'Выберите URL (с префиксом "www." или без него), на который посетители будут перенаправляться с кодом HTTP 301 без ущерба для поисковой оптимизации.',
    'web._shared.seoRedirectDirectionNone' => 'Нет',
    'web._shared.limitMbUnits' => 'Mб',

    'web-user.settings.allowScripts' => 'Разрешить веб-пользователям использовать скрипты',

    'web-user.name' => 'Имя пользователя для подключения к серверу по FTP',
    'web-user.longName' => 'Слишком длинное имя пользователя (максимальная длина — %max% символов).',
    'web-user.password' => 'Пароль',
    'web-user.passwordConfirmation' => 'Подтверждение пароля',
    'web-user.hardDiskQuota' => 'Квота на дисковое пространство',
    'web-user.hardDiskQuotaUnlimited' => 'Без ограничений',
    'web-user.hardDiskQuotaIsNotSupported' => '(квота жесткого диска не поддерживается из-за конфигурации файловой системы сервера)',
    'web-user.megabytes' => 'Mб',

    'web-user.__asp_win_support' => 'Поддержка Microsoft ASP',
    'web-user.__asp_dot_net_support' => 'Поддержка Microsoft ASP.NET',
    'web-user.__ssi_support' => 'Поддержка SSI',
    'web-user.__php_support' => 'Поддержка PHP',
    'web-user.__cgi_support' => 'Поддержка CGI',
    'web-user.__perl_unix_support' => 'Поддержка Perl',
    'web-user.__perl_win_support' => 'Поддержка Perl',
    'web-user.__python_unix_support' => 'Поддержка Python',
    'web-user.__python_win_support' => 'Поддержка Python',
    'web-user.__fastcgi_unix_support' => 'Поддержка FastCGI',
    'web-user.__webstat_support' => 'Веб-статистика',
    'web-user.__apache_errdocs' => 'Пользовательские страницы ошибок',
    'web-user.__hosting_write_modify' => 'Дополнительные права на запись/редактирование',
    'web-user.__hosting_webdeploy' => 'Публикация с помощью инструмента веб-развертывания',


    'requiredFields' => 'Обязательные поля',
];
