<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Número da chave',
    'additional-keys.keyName' => 'Nome da chave',
    'additional-keys.keyApp' => 'Aplicativo',
    'additional-keys.addGroup' => 'Adicionar',
    'additional-keys.upload' => 'Instalar Nova Chave',
    'additional-keys.uploadDescription' => 'Fazer upload e instalar uma nova chave de licença.',
    'additional-keys.actionsGroup' => 'Ações',
    'additional-keys.install' => 'Instalar',
    'additional-keys.installAll' => 'Instalar Tudo',
    'additional-keys.installDescription' => 'Instalar as chaves de licença selecionadas.',
    'additional-keys.installNoSelection' => 'Selecione uma ou mais chaves de licença adicionais para instalar ou clique em "Instalar Tudo".',
    'additional-keys.installSuccess' => 'A instalação da chave de licença foi iniciada.',
    'additional-keys.removeGroup' => 'Remover',
    'additional-keys.remove' => 'Remover',
    'additional-keys.removeDescription' => 'Remover as chaves de licença selecionadas.',
    'additional-keys.removeNoSelection' => 'Selecione uma ou mais chaves de licença adicionais para remover.',
    'additional-keys.removeConfirmation' => 'Remover {count, plural, =1 {a chave de licença {name}} one {a # chave de licença selecionada} other {as # chaves de licença selecionadas}}?',
    'additional-keys.removeSuccess' => 'As chaves de licença selecionadas foram removidas.',
    'additional-keys.download' => 'Fazer download da chave',
    'additional-keys.downloadDescription' => 'Baixe a chave de licença.',
    'additional-keys.emptyViewTitle' => 'Sem chaves de licença adicionais',

    'backup.tasks.startDate' => 'Iniciado em',
    'backup.tasks.targetRepo' => 'Armazenamento-alvo',
    'backup.tasks.progress' => 'Progresso da tarefa',
    'backup.tasks.repoTypeLocal' => 'Servidor',
    'backup.tasks.repoTypeFtp' => 'FTP pessoal',
    'backup.tasks.buttonRemoveTask' => 'Remover',
    'backup.tasks.hintRemoveTask' => 'Remover as tarefas selecionadas.',
    'backup.tasks.buttonReload' => 'Recarregar',
    'backup.tasks.hintReload' => 'Recarregue a lista de tarefas para obter o status real.',
    'backup.tasks.statusTaskWarnings' => 'Avisos',
    'backup.tasks.statusTaskInfo' => 'Informações',
    'backup.tasks.statusTaskFailed' => 'Falhou',

    'backup.disabledSelectHint' => 'O backup não pode ser removido porque faz parte de um servidor, revendedor ou backup do cliente.',
    'backup.buttonBackup' => 'Fazer backup',
    'backup.hintBackup' => 'Crie um backup.',
    'backup.buttonSchedule' => 'Cronograma',
    'backup.hintSchedule' => 'Especificar as configurações para uma tarefa de backup agendada.',
    'backup.buttonReload' => 'Recarregar',
    'backup.hintReload' => 'Recarregar a lista de backup.',
    'backup.buttonUpload' => 'Upload',
    'backup.hintUpload' => 'Efetuar o upload do arquivo de backup de seu computador para o armazenamento de backup do servidor.',
    'backup.buttonSettings' => 'Configurações',
    'backup.hintSettings' => 'Configurar as definições globais de backup de dados para reduzir a carga de CPU no servidor.',
    'backup.buttonRemoteStorages' => 'Configurações de Armazenamento Remoto',
    'backup.hintRemoteStorages' => 'Configure seu armazenamento remoto pessoal para armazenar arquivos de backup.',
    'backup.buttonRemove' => 'Remover',
    'backup.hintRemove' => 'Remover os backups selecionados do armazenamento do servidor.',
    'backup.systemNotes' => 'Notas do sistema',
    'backup.incremental' => 'Acréscimo.',
    'backup.multiVolume' => 'Multivolume.',
    'backup.remoteStorage' => 'No armazenamento: %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Este não é um backup válido. Os dados não podem ser restaurados a partir desse arquivo. Clique no nome do backup para mais detalhes.',
    'backup.statusWarning' => 'Este backup não é inteiramente válido. Clique no nome do backup para mais detalhes.',
    'backup.statusInfo' => 'Este é um backup válido. Os dados podem ser restaurados a partir deste backup, mas alguns pequenos problemas podem ocorrer com a forma como os dados são armazenados.',
    'backup.statusOn' => 'Este é um backup válido. Os dados desse arquivo podem ser restaurados.',
    'backup.date' => 'Data de criação',
    'backup.name' => 'Nome',
    'backup.comment' => 'Comentários',
    'backup.size' => 'Tamanho',
    'backup.download' => 'Efetue o download do arquivo de backup para seu computador local.',
    'backup.downloadDisabled' => 'O download do arquivo de backup está indisponível temporariamente. Tente novamente mais tarde ou entre em contato com seu prestador de serviços.',
    'backup.total' => 'Backups totais: %%total%%, tamanho: %%totalSize%%',
    'backup.totalFound' => '%%found%% backups encontrados (total de %%total%%), tamanho: %%totalSize%%',
    'backup.confirmOnDelete' => 'Você deseja remover os backups selecionados?',
    'backup.incrementsRemovalLoading' => 'Carregando...',
    'backup.incrementsRemovalConfirmation' => 'Confirmo que desejo remover os backups selecionados.',
    'backup.backupHasIncrements' => 'O backup %%backupName%% será removido junto com seus incrementos: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Nome de usuário ou senha incorretos para o armazenamento FTP',
    'backup.ftpStorageErrorResolveHost' => "Não é possível resolver o nome de host.",
    'backup.ftpStorageErrorConnection' => "Não foi possível conectar com o servidor remoto",
    'backup.unableToGetFtpDumpList' => 'Não é possível exibir a lista de backups no armazenamento FTP: %%errorMessage%%. Verifique <a href="%%ftpSettingsUrl%%">as configurações de armazenamento FTP </a>.',
    'backup.unableToGetExtDumpList' => 'Não é possível exibir a lista de backups no armazenamento %%storageTitle%%: %%errorMessage%%. Verifique as configurações de armazenamento.',
    'backup.unableToGetLocalDumpList' => 'Não é possível exibir a lista de backups armazenados no servidor: %%errorMessage%%',
    'backup.skippedFilesAtExtStorage' => 'Alguns dos arquivos no armazenamento %%storageTitle%% não são exibidos na lista porque os nomes desses arquivos não estão em conformidade com a convenção da nomenclatura dos arquivos de backup. Se tiver certeza de que esses arquivos são backups válidos, renomeie-os para corresponder ao seguinte padrão: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Mostrar volumes',
    'backup.multiVolumeHide' => 'Ocultar volumes',
    'backup.backEncryptionRequired' => 'Por motivos de segurança, recomendamos que você proteja os dados contidos em backups. Vá para %%link%% e atualize as configurações de segurança do backup.',
    'backup.backupSettingPage' => 'Configurações de backup',
    'backup.statusTaskProgress' => 'A tarefa de backup está em andamento.',
    'backup.statusTaskWarnings' => 'A tarefa de backup terminou sem alertas.',
    'backup.statusTaskInfo' => 'Informação.',
    'backup.statusTaskFailed' => 'Falha na tarefa de backup.',
    'backup.statusTaskStopping' => 'A tarefa de backup está interrompida.',
    'backup.statusTaskStopped' => 'A tarefa de backup foi interrompida.',

    'backup.schedule.columnSchedule' => 'Cronograma',
    'backup.schedule.columnContent' => 'Conteúdo',
    'backup.schedule.columnStorage' => 'Armazenamento',
    'backup.schedule.periodHourly' => 'Por hora',
    'backup.schedule.periodHourlySchedule' => 'a cada {period, plural, one {# hora} other {# horas}}',
    'backup.schedule.periodDaily' => 'Diário',
    'backup.schedule.periodDailySchedule' => 'às %%hours%%:%%minutes%%',
    'backup.schedule.periodWeekly' => 'Semanal',
    'backup.schedule.periodWeeklySchedule' => 'na(o) %%day%% às %%hours%%:%%minutes%%',
    'backup.schedule.periodMonthly' => 'Mensal',
    'backup.schedule.periodMonthlySchedule' => 'no %%day%% dia às %%hours%%:%%minutes%%',
    'backup.schedule.periodCustom' => 'Customizar',
    'backup.schedule.dayFirst' => 'primeiro',
    'backup.schedule.dayLast' => 'último',
    'backup.schedule.day' => '{day, selectordinal, other {#º}}',
    'backup.schedule.storageLocal' => 'Armazenamento do servidor',
    'backup.schedule.storageBoth' => 'Armazenamento do servidor e %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'O backup agendado foi desativado',

    'custombuttons.buttonAdd' => 'Adicionar o link ao serviço',
    'custombuttons.buttonAddDescription' => 'Acrescentar um link a um serviço on-line e coloque-o no Plesk.',
    'custombuttons.buttonRemove' => 'Remover',
    'custombuttons.buttonRemoveDescription' => 'Excluir os links selecionados.',
    'custombuttons.removeConfirmMessage' => 'Remover os links selecionados?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Imagem',
    'custombuttons.headerPriority' => 'Prioridade',
    'custombuttons.headerLabel' => 'Rótulo',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Descrição',
    'custombuttons.publicEnabledDescription' => 'O link é visível para os usuários.',
    'custombuttons.publicDisabledDescription' => 'O link não é visível para os usuários.',
    'custombuttons.altPublicEnabledIcon' => 'Público',
    'custombuttons.altPublicDisabledIcon' => 'Particular',
    'custombuttons.placeNavigationDescription' => 'O link está localizado em todas as páginas.',
    'custombuttons.placeAdminDescription' => 'O link está localizado na página inicial do administrador.',
    'custombuttons.placeAdminSettingsDescription' => 'O link está localizado na página de configurações e ferramentas do administrador.',
    'custombuttons.placeResellerDescription' => 'O link está localizado na página inicial do revendedor',
    'custombuttons.placeResellerSettingsDescription' => 'O link está localizado na página de configurações e ferramentas do revendedor.',
    'custombuttons.placeClientDescription' => 'O link está localizado na página inicial do cliente.',
    'custombuttons.placeDomainDescription' => 'O link está localizado na página Websites e Domínios da Assinatura.',
    'custombuttons.placeDomainPropertiesDescription' => 'O link está localizado na área de ferramentas do site, que abre na página Websites e Domínios clicando em Mostrar Mais abaixo de um nome de domínio.',

    'databaseservers.addGroup' => 'Adicionar',
    'databaseservers.addDatabaseServer' => 'Adicionar servidor de banco de dados',
    'databaseservers.addDatabaseServerDescription' => 'Adicionar um servidor de base de dados.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'A chave de licença não suporta hospedagem remota de banco de dados.',
    'databaseservers.actionsGroup' => 'Ações',
    'databaseservers.hostingSettings' => 'Configurações',
    'databaseservers.hostingSettingsDescription' => 'Configurações de hospedagem de banco de dados.',
    'databaseservers.refresh' => 'Atualizar',
    'databaseservers.refreshDescription' => 'Atualize as informações sobre servidores de banco de dados.',
    'databaseservers.removeGroup' => 'Remover',
    'databaseservers.remove' => 'Remover',
    'databaseservers.removeDescription' => 'Excluir servidores de banco de dados selecionados.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Tipo de servidor',
    'databaseservers.host' => 'Nome do host',
    'databaseservers.hostLink' => 'Exibir ou modificar as propriedades do servidor de banco de dados.',
    'databaseservers.port' => 'Porta',
    'databaseservers.version' => 'Versão',
    'databaseservers.databasesCount' => 'Bancos de dados',
    'databaseservers.databasesCountLink' => 'Gerenciar os bancos de dados hospedados neste servidor.',
    'databaseservers.databaseUpgradeLink' => 'Atualizar o servidor do banco de dados hospedado neste servidor.',
    'databaseservers.databasesLTSVersion' => 'Você já tem a versão LTS. O Plesk atualizará automaticamente sua instalação do MariaDB/MySQL para versões pontuais mais recentes.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Acessar este servidor via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Baixe um Cliente SQL local',
    'databaseservers.downloadMsSqlClientHint' => 'Baixe um Cliente SQL local',
    'databaseservers.changePassword' => 'Alterar Senha do Administrador',
    'databaseservers.changePasswordHint' => 'Altere a senha do administrador do servidor de banco de dados.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'padrão para o MySQL',
    'databaseservers.default_for_mssql' => 'padrão para MS SQL',
    'databaseservers.default_for_postgresql' => 'padrão para PostgreSQL',
    'databaseservers.default_for_mariadb' => 'padrão para MariaDB',
    'databaseservers.default_for_percona' => 'padrão para Percona',
    'databaseservers.status_no_error' => 'A última tentativa para se conectar a esse servidor foi bem-sucedida.',
    'databaseservers.status_connection_failed' => 'A última tentativa para se conectar a esse servidor falhou por causa de problemas de rede.',
    'databaseservers.status_permission_denied' => 'Durante a última tentativa para se conectar a esse servidor, o acesso foi negado. Verifique as credenciais de administrador para o servidor.',
    'databaseservers.status_other_error' => 'Durante a última tentativa para se conectar a esse servidor, ocorreu um erro.',
    'databaseservers.status_credentials_not_set' => 'Você precisa fornecer um nome de usuário e senha de administrador válidos antes que o Plesk possa se conectar a esse servidor.',
    'databaseservers.mssqlServerPortUndefined' => 'Não é possível determinar o número da porta TCP usada pelo servidor Microsoft SQL \'%%host%%\': o protocolo TCP/IP não está habilitado na configuração de rede do servidor ou o servidor está configurado para usar portas TCP dinâmicas.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Para permitir que seus clientes configurem automaticamente o firewall para acesso remoto ao banco de dados, configure manualmente o servidor SQL para escutar em uma porta TCP fixa específica.',
    'databaseservers.removeEmptySelection' => 'Nenhum servidor de banco de dados selecionado.',
    'databaseservers.removeConfirmation' => 'Tem certeza de remover {count, plural, =1 {o {name} servidor de banco de dados} one {os # servidores de banco de dados selecionados} other {os # servidores de banco de dados selecionados}}?',
    'databaseservers.removeSuccess' => 'Os servidores de banco de dados selecionados foram removidos com sucesso.',
    'databaseservers.upgradeNow' => 'Faça o upgrade agora',


    'databaseserverdatabases.actionsGroup' => 'Ações',
    'databaseserverdatabases.assignToSubscription' => 'Mover para a Assinatura',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Mova os bancos de dados selecionados para outra assinatura.',
    'databaseserverdatabases.removeGroup' => 'Remover',
    'databaseserverdatabases.remove' => 'Remover',
    'databaseserverdatabases.removeDescription' => 'Excluir os bancos de dados selecionados.',
    'databaseserverdatabases.name' => 'Nome',
    'databaseserverdatabases.subscription' => 'Assinatura',
    'databaseserverdatabases.client' => 'Assinante',
    'databaseserverdatabases.manageDatabase' => 'Gerenciar hospedagem',
    'databaseserverdatabases.manageDatabaseDescription' => 'Gerenciar a base de dados.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Abrir no Painel do Revendedor',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Gerencie o banco de dados no Painel de Revendedores do assinante.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Abrir em Painel do Cliente',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Gerenciar a base de dados no Painel do Cliente do assinante.',
    'databaseserverdatabases.emptySelection' => 'Nenhum banco de dados selecionado.',
    'databaseserverdatabases.removeConfirmation' => 'Tem certeza de remover {count, plural, =1 {o {name} banco de dados} one {o # banco de dado selecionado} other {os # bancos de dados selecionados}}?',
    'databaseserverdatabases.removeSuccess' => 'Os servidores de banco de dados selecionados foram removidos com sucesso.',

    'logbrowser.issuesFoundInTheLogs' => 'Problemas nos logs do website',
    'logbrowser.learnAboutProblemsFaster' => 'Detecte problemas no website mais rapidamente',
    'logbrowser.noProblemsFound' => 'Sem problemas nos logs do website',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%% a verificação dos logs detectou problemas que podem afetar a operação do seu website. Para ver os detalhes e as possíveis soluções, clique em “Abrir relatório de verificação”.',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%% a verificação do log não detectou problemas que possam afetar a operação do seu website.',
    'logbrowser.noChecksResults' => 'Uma verificação automática diária está ativada e será executada nas próximas 24 horas.',
    'logbrowser.manual' => 'Manual',
    'logbrowser.regular' => 'Manual diário',
    'logbrowser.enableRegularCheck' => 'Uma verificação diária dos logs detecta problemas que podem afetar a operação do seu website. Se algum problema aparecer, o Plesk o informará e fornecerá possíveis soluções.',
    'logbrowser.new' => 'NOVO',
    'logbrowser.openCheckReport' => 'Abrir relatório de verificação',
    'logbrowser.openCheckSettings' => 'Abrir configurações de verificação',

    'logbrowser.buttonStartRealtime' => 'Iniciar atualizações em tempo real',
    'logbrowser.buttonStartRealtimeHint' => 'Atualizar os dados do log em tempo real.',
    'logbrowser.buttonStopRealtime' => 'Interromper as atualizações em tempo real',
    'logbrowser.buttonStopRealtimeHint' => 'Interromper a atualização dos dados do log em tempo real.',
    'logbrowser.buttonRefresh' => 'Atualizar',
    'logbrowser.buttonRefreshHint' => 'Atualizar os dados de log.',
    'logbrowser.buttonClear' => 'Remover',
    'logbrowser.buttonClearHint' => 'Ocultar entradas já carregadas.',
    'logbrowser.buttonAddCustom' => 'Adicionar ao Registro do Navegador como arquivo Personalizado',
    'logbrowser.buttonAddCustomHint' => 'O arquivo será exibido no Navegador de Registro com outros arquivos.',
    'logbrowser.date' => 'Data',
    'logbrowser.dateFilterPlaceholder' => 'De',
    'logbrowser.type' => 'Tipo',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Código',
    'logbrowser.codeFilterPlaceholder' => 'Código',
    'logbrowser.message' => 'Mensagem',
    'logbrowser.messageFilterPlaceholder' => 'Mensagem',
    'logbrowser.source' => 'Fonte',
    'logbrowser.sourceFilterFiles' => '%%count%% arquivos',
    'logbrowser.sourceFilterAllLogs' => 'Todos os logs',
    'logbrowser.sourceFilterNoLogs' => 'Nenhum log',
    'logbrowser.manageLogFiles' => 'Gerenciar arquivos de log',
    'logbrowser.addCustomLogFile' => 'Adicionar um registro personalizado',
    'logbrowser.customLogPopupTitle' => 'Adicionar um registro personalizado',
    'logbrowser.invalidLogFormat' => 'O arquivo de registro tem formato não suportado',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Consultor',
    'logbrowser.agent' => 'Agente',
    'logbrowser.agentHint' => 'Agente de Usuário',
    'logbrowser.size' => 'Tamanho',
    'logbrowser.unknown' => 'Desconhecido',
    'logbrowser.more' => 'Mais ',
    'logbrowser.less' => ' Menos',
    'logbrowser.any' => 'Qualquer',
    'logbrowser.none' => 'Nenhum',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% ou usar filtros para reduzir a lista das entradas.',
    'logbrowser.loadMore' => 'Carregar as entradas anteriores',
    'logbrowser.clear' => 'Remover',
    'logbrowser.hourAgo' => 'Hora Atrás',
    'logbrowser.prevDay' => 'Dia Anterior',
    'logbrowser.linkInMessageToViewFile' => 'Clique para visualizar o arquivo.',
    'logbrowser.buttonUnlinkHint' => 'Clique para parar o rastreamento das atualizações neste arquivo no Registro do Navegador',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Tem certeza que deseja parar de rastrear as atualizações neste arquivo no Registro do Navegador?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Sim',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Não',
    'logbrowser.logRotation' => 'Rotação do Logs',
    'logbrowser.logRotationHint' => 'Configure as configurações de  rotação de log do site.',
    'logbrowser.logRotationTitle' => 'Configurar rotação de log',

    'notifications.title' => 'Configure o envio de avisos por e-mail sobre eventos do sistema',
    'notifications.legendNotifications' => 'Notificações',
    'notifications.legendSettings' => 'Configurações',
    'notifications.headerEvent' => 'Evento',
    'notifications.headerSendTo' => 'Enviar aviso para:',
    'notifications.headerText' => 'Texto',
    'notifications.headerPreview' => 'Visualização',
    'notifications.headerAdmin' => 'Administrador',
    'notifications.headerReseller' => 'Revendedor',
    'notifications.headerClient' => 'Cliente',
    'notifications.headerEmailAddress' => 'Endereço de e-mail',
    'notifications.expirationTime' => 'Enviar advertências de expiração',
    'notifications.days' => ' dias de antecedência',
    'notifications.smtpSettings' => 'Para habilitar o envio de notificações do Plesk quando o relé estiver fechado, você pode %%link%%',
    'notifications.smtpSettingsLink' => 'alterar as configurações de SMTP',
    'notifications.editHint' => 'Editar o texto de aviso.',
    'notifications.previewHint' => 'Veja como a notificação aparece nos e-mails.',
    'notifications.reseller_creation' => 'Criação de conta de revendedor',
    'notifications.reseller_limits_exceed' => 'Limites de uso do recurso ultrapassados pela conta de revendedor',
    'notifications.reseller_blocked' => 'Conta de revendedor suspensa por causa do uso excessivo de recursos',
    'notifications.reseller_overuse_block' => 'Limites de uso de recursos do revendedor atingidos pelas assinaturas do revendedor por causa de excesso de vendas',
    'notifications.client_creation' => 'Criação de conta de cliente',
    'notifications.domain_creation' => 'Criação do site',
    'notifications.domain_exp_warning' => 'Advertência de expiração de assinatura',
    'notifications.domain_expiration' => 'Expiração da assinatura',
    'notifications.domain_limits_exceed' => 'Limites de uso do recurso ultrapassados pela assinatura',
    'notifications.domain_blocked' => 'Assinatura suspensa por causa do uso excessivo de recursos',
    'notifications.admin_aps_app_updates' => 'Atualizações da aplicação APS (Resumo do administrador)',
    'notifications.reseller_aps_app_updates' => 'Atualizações da aplicação APS (Resumo do revendedor)',
    'notifications.client_aps_app_updates' => 'Atualizações da aplicação APS (Resumo do cliente)',
    'notifications.admin_pum_updates' => 'Atualizações do sistema: notificações sobre novas atualizações.',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'E-mail de saída excedeu os limites',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU, e Disk I/O (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Lembrete de feedback',
    'notifications.errorInvalidEmail' => 'Endereço de e-mail incorreto.',
    'notifications.errorInvalidExpTime' => 'Número de dias é inválido.',
    'notifications.errorUpdate' => 'Não é possível atualizar notificação: %%error%%',
    'notifications.updated' => 'As configurações de notificações foram atualizadas',

    'outgoingmail.name' => 'Nome',
    'outgoingmail.maxOutgoingMessages' => 'Limite por hora',
    'outgoingmail.numOfExceedingAttempts' => 'Tentativas depois de atingir o limite',
    'outgoingmail.lastAttemptAt' => 'Última tentativa',
    'outgoingmail.mailStatus' => 'Status de e-mail',
    'outgoingmail.mailStatusSending' => 'Enviando',
    'outgoingmail.mailStatusNotSending' => 'Não está enviando',
    'outgoingmail.mailStatusSendingDesc' => 'E-mail está sendo enviado.',
    'outgoingmail.mailStatusNotSendingDesc' => 'E-mail não está sendo enviado.',
    'outgoingmail.limitValueUnlimited' => 'Ilimitado',

    'scheduler.tasks.headerCommand' => 'Comando',
    'scheduler.tasks.headerSchedule' => 'Cronograma',
    'scheduler.tasks.headerSubscription' => 'Assinatura',
    'scheduler.tasks.headerSubscription_powerUser' => 'Espaço web',
    'scheduler.tasks.buttonToggleHintOn' => 'A tarefa está ativada. Clicar para desativar a tarefa.',
    'scheduler.tasks.buttonToggleHintOff' => 'A tarefa está desativada. Clicar para ativar a tarefa.',
    'scheduler.tasks.add' => 'Adicionar tarefa',
    'scheduler.tasks.hintAdd' => 'Agendar uma nova tarefa.',
    'scheduler.tasks.remove' => 'Remover',
    'scheduler.tasks.hintRemove' => 'Remover as tarefas selecionadas.',
    'scheduler.tasks.confirmOnDelete' => 'Você quer remover as tarefas selecionadas?',
    'scheduler.tasks.sync' => 'Atualizar',
    'scheduler.tasks.hintSync' => 'Recarregar a lista de tarefas para obter os dados reais.',
    'scheduler.tasks.settings' => 'Configurações',
    'scheduler.tasks.hintSettings' => 'Editar as configurações das tarefas agendadas.',
    'scheduler.tasks.deleteSuccess' => 'As tarefas agendadas oram removidas.',
    'scheduler.tasks.serverTask' => 'servidor (user:%%user%%)',
    'scheduler.tasks.unknownUser' => 'desconhecido',
    'scheduler.tasks.runTaskNow' => 'Executar agora',
    'scheduler.tasks.runTaskNowHint' => 'Executar a tarefa agora.',
    'scheduler.tasks.runningTask' => 'Executando a tarefa "%%task%%"...',

    'server-components.bcTitle' => 'Componentes do servidor',
    'server-components.title' => 'Componentes Plesk',
    'server-components.name' => 'Nome do componente',
    'server-components.version' => 'Versão do componente',
    'server-components.refresh' => 'Atualizar',
    'server-components.componentName' => 'Digite o nome do componente...',
    'server-components.noComponents' => 'Nenhum componente encontrado',
    'server-components.componentsListUpdated' => 'A lista de componentes foi atualizada',

    'server-components.componentName.urlrewrite' => 'Reescreva a URL',
    'server-components.componentName.dbconnector' => "Conector do Banco de Dados",
    'server-components.componentName.mysqlserver' => 'Servidor MariaDB/MySQL',
    'server-components.componentName.troubleshooting' => 'Resolução de problemas',
    'server-components.componentName.waf' => 'Firewall de aplicativo web',
    'server-components.componentName.vcs' => 'Sistema de Controle de Versão',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Inicialização do Aplicativo",
    'server-components.componentName.cors' => "Compartilhamento de Recursos Entre Origens",
    'server-components.componentName.httpcompression' => 'Compressão de Conteúdo HTTP',
    'server-components.componentName.antivirus' => "Antivírus",
    'server-components.componentName.database' => "Servidor SQL",
    'server-components.componentName.sqladmin' => "Administrador Web MariaDB/MySQL",
    'server-components.componentName.sqladminmysql' => "Administrador Web MariaDB/MySQL",
    'server-components.componentName.dnsserver' => "Servidor DNS",
    'server-components.componentName.firewall' => "Firewall",
    'server-components.componentName.ftpserver' => "Servidor de FTP",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Servidor de e-mail",
    'server-components.componentName.local_mailserver' => "Servidor de e-mail local",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Web Scripting",
    'server-components.componentName.spamfilter' => "Filtro de spam",
    'server-components.componentName.stats' => "Estatísticas da web",
    'server-components.componentName.stunnel' => "Invólucro SSL/TLS",
    'server-components.componentName.webmail' => "WebMail",
    'server-components.componentName.webpublish' => "Publicação na Web",
    'server-components.componentName.webserver' => "Servidor Web",
    'server-components.componentName.network' => 'Rede',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Hospedagem do Plesk",
    'server-components.componentName.savi' => 'Interface Antivírus Sophos',

    'server-components.tooltip.disabled' => 'Desativado',
    'server-components.tooltip.active' => 'Ativo',
    'server-components.tooltip.notConfigured' => 'Não configurado',
    'server-components.tooltip.notStarted' => 'Não iniciado, checar as configurações do componente',

    'server-components.defaultComponents.circularDependencies' => "Foram encontradas dependências circulares entre as categorias %%cat1%% e %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(não instalado)",
    'server-components.defaultComponents.not_configured' => "(não configurado)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Algumas categorias de serviços contêm seleções inválidas ou nenhuma seleção foi feita.",
    'server-components.defaultComponents.depends_on' => "(exige %%name%%)",
    'server-components.defaultComponents.not_activated' => 'não ativado',
    'server-components.defaultComponents.imap_required' => '(O servidor de e-mail atual não suporta IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(O servidor de FTP não suporta endereços IPv6).",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(a regra de delegação exigida \'appPoolPipeline, appPoolNetFx\' não existe)',
    'server-components.defaultComponents.not_supported_version' => '(versão não suportada)',
    'server-components.defaultComponents.no_license' => '(não permitido pela chave de licença)',
    'server-components.defaultComponents.license_expired' => '(chave de licença expirou)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(limite de caixas de e-mail de chave de licença excedido)',
    'server-components.defaultComponents.title' => 'Selecione o componente-padrão %%name%%',
    'server-components.defaultComponents.none' => 'Nenhum',
    'server-components.defaultComponents.yes' => 'Sim',
    'server-components.defaultComponents.no' => 'Não',
    'server-components.defaultComponents.warning' => 'Advertência!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parâmetros do %%component%%',
    'server-components.defaultComponents.success' => 'O componente padrão foi atualizado',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "A alteração do servidor de e-mail destina-se apenas à configuração inicial e, se o servidor já estiver em uso, causa os seguintes problemas: perda de configurações e conteúdo das caixas de e-mail e, nos casos em que o servidor para o qual você alterna já está configurado, vários conflitos.\nSe este servidor estiver em uso agora e você tiver certeza de mudar para outro, poderá notificar seus clientes sobre a operação para que eles possam baixar e salvar seus e-mails.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Apenas os primeiros 254 endereços IP de sub-redes com máscaras /8 e /16 localizados na Lista de controle de acesso serão transferidos. Eles serão transferidos como endereços IP separados. Você deseja continuar?",

    'server-components.componentConf.title' => 'Parâmetros do %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'O parâmetro é obrigatório',
    'server-components.componentConf.parameterShouldBeNumber' => 'O parâmetro deve ser um número',
    'server-components.componentConf.success' => 'Os parâmetros foram atualizados',

    'spam-filter.groupAdd' => 'Adicionar',
    'spam-filter.buttonAdd' => 'Adicionar Domínio',
    'spam-filter.buttonAddAddress' => 'Adicionar Endereço',
    'spam-filter.buttonAddToBlackListHint' => 'Adicionar domínio à lista negra',
    'spam-filter.buttonAddToWhiteListHint' => 'Adicionar um domínio à lista branca',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Adicionar endereço à black list',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Adicionar endereços à white list',
    'spam-filter.groupActions' => 'Ações',
    'spam-filter.buttonRemove' => 'Remover',
    'spam-filter.entries' => 'Entradas',
    'spam-filter.removeEmptySelection' => 'Não há entradas selecionadas.',
    'spam-filter.removeConfirmation' => 'Remover {count, plural, =1 {a entrada {name}} one {a # entrada selecionada} other {as # entradas selecionadas}}?',
    'spam-filter.removeSuccess' => 'As entradas selecionadas foram removidas.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'Lista de endereços de spam conhecidos',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'Lista de endereços confiáveis',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'Mensagens de endereços de e-mail nesta lista são tratadas como spam.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'Os e-mails de endereços de e-mail desta lista ignoram o filtro de spam.',

    'tasks.pollingOff' => 'Desligar',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Tem certeza de que deseja interromper a tarefa?',
    'tasks.stopTaskError' => 'Falha ao parar a tarefa',
    'tasks.stopTask' => 'Parar tarefa',
    'tasks.buttonStopConfirm' => 'Sim, parar',
    'tasks.processedLoadFailed' => 'Falha ao carregar a lista de processos',
    'tasks.retryTask' => 'Repetir tarefa',
    'tasks.retryTaskFailed' => 'Falha ao tentar novamente a tarefa',
    'tasks.taskCreated' => 'Nova tarefa criada com sucesso',
    'tasks.moreDetails' => 'Consulte o registro do painel para obter detalhes',
    'tasks.searchTitle' => 'Buscar',
    'tasks.searchPlaceholder' => 'Pesquisar string',
    'tasks.refresh' => 'Atualizar',
    'tasks.refreshDescription' => 'Atualizar lista de tarefas',
    'tasks.createTask' => 'Criar Tarefa',
    'tasks.openSwagger' => 'Swagger Aberto',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Criado',
    'tasks.descriptionTitle' => 'Descrição',
    'tasks.processes.dataLoadFailed' => 'Falha ao obter dados do servidor',
    'tasks.processes.commandLineLoadFailed' => 'Falha ao obter a linha de comando da tarefa',
    'tasks.processes.buttonStopConfirm' => 'Sim, parar',
    'tasks.processes.stopProcess' => 'Parar processo',
    'tasks.processes.stopProcessFailed' => 'Falha ao parar o processo',
    'tasks.processes.stopProcessConfirm' => 'Tem certeza de que deseja interromper o processo?',
    'tasks.processes.copyToClipboard' => 'Copiar para área de transferência',
    'tasks.processes.concurrency' => 'Simultaneidade',
    'tasks.processes.taskIdSection' => 'ID da tarefa',
    'tasks.processes.requestorIdSection' => 'ID do solicitante',
    'tasks.processes.timeoutSection' => 'Tempo esgotado',
    'tasks.processes.createdSection' => 'Criado',
    'tasks.processes.updatedSection' => 'Atualizado',
    'tasks.processes.environmentSection' => 'Ambiente',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Iniciado',
    'tasks.processes.completedTitle' => 'Concluído',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Código de Saída',

    'ts-sessions.columnStateTitle' => 'Status',
    'ts-sessions.columnUserTitle' => 'Usuário',
    'ts-sessions.columnNameTitle' => 'Nome',
    'ts-sessions.refresh' => 'Atualizar',
    'ts-sessions.logoff' => 'Sair',
    'ts-sessions.logoffConfirmation' => 'Sair de %%count%% sessão(ões)?',
    'ts-sessions.logoffConfirmationSingle' => 'Sair da sessão %%name%%?',
    'ts-sessions.logoffConfirmationButton' => 'Sim, sair',
    'ts-sessions.logoffNoSelection' => 'Selecione uma ou mais sessões para deslogar',
    'ts-sessions.logoffSuccess' => 'As sessões selecionadas foram desconectadas.',
    'ts-sessions.disconnect' => 'Desconectar',
    'ts-sessions.disconnectConfirmation' => 'Desconectar %%count%% sessão(ões)?',
    'ts-sessions.disconnectConfirmationSingle' => 'Desconectar a sessão %%name%%?',
    'ts-sessions.disconnectConfirmationButton' => 'Sim, desconecte',
    'ts-sessions.disconnectSuccess' => 'As sessões selecionadas foram desconectadas.',
    'ts-sessions.disconnectNoSelection' => 'Selecione uma ou mais sessões para desconectar',
    'ts-sessions.disconnectNotAvailable' => 'Você só pode desconectar sessões ativas ou conectadas.',

    'client-ip-address.title' => 'Endereços IP',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Tipo',
    'client-ip-address.ipAddress' => 'Endereço IP',
    'client-ip-address.certificate' => 'Certificado',
    'client-ip-address.hosting' => 'Hospedagem',
    'client-ip-address.adminCertificateRepository' => "Repositório do administrador",
    'client-ip-address.domainCertificateRepository' => 'Repositório de domínio %%owner%%',
    'client-ip-address.typeShared' => 'Compartilhado',
    'client-ip-address.typeExclusive' => 'Dedicado',
    'client-ip-address.removeConfirmation' => 'Remover {count, plural, =1 {os {name} endereços IP} one {os # endereços IP selecionados} other {os # endereços IP selecionados}} do pool de IP do usuário?',
    'client-ip-address.noItemsToRemove' => 'Selecione um ou mais itens para remover.',
    'client-ip-address.ftpOverSSL' => 'FTP sobre SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Sim',
    'client-ip-address.ftpOverSSL-no' => 'Não',
    'client-ip-address.ftpOverSSL-allow' => 'Permitir',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Não permitido',
    'client-ip-address.add' => 'Adicionar endereço IP',
    'client-ip-address.noAvailableIps' => 'Não há endereços IP disponíveis.',
    'client-ip-address.isOk' => 'O endereço IP funciona corretamente.',
    'client-ip-address.isBroken' => 'O endereço IP não está presente na interface.',
    'client-ip-address.properties.title' => 'Endereço IP %%address%% na interface %%interface%%',
    'client-ip-address.properties.distributedType' => 'Endereços IP distribuídos como',
    'client-ip-address.properties.allocatedType' => 'Endereço IP alocado como',
    'client-ip-address.properties.none' => 'Nenhum',
    'client-ip-address.properties.certificate' => 'Certificado SSL/TLS',
    'client-ip-address.properties.defaultSite' => 'Website padrão',
    'client-ip-address.assign.title' => 'Selecionar endereços IP',
    'client-ip-address.assign.description' => 'IPs vagos',
    'client-ip-address.assign.success' => '{count, plural, =1 {o {name} endereço IP } one {o # endereço IP selecionado} other {os # endereços IP selecionados}} foi adicionado com sucesso ao pool de IP do usuário',

    'ip-address-reseller-usage.title' => 'Revendedores que usam %%type%% endereço IP %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Revendedores',
    'ip-address-reseller-usage.assignButton' => 'Atribuir ao revendedor',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Este endereço IP já está atribuído a todos os usuários.',
    'ip-address-reseller-usage.removeButton' => 'Remover',
    'ip-address-reseller-usage.removeSuccess' => 'O endereço IP foi removido do(s) {count, plural, =1 {pool {name}} one {# pools de revendedores selecionados} other {# pools de IP dos revendedores selecionados}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Remova o endereço IP do(s) {count, plural, =1 {pool de IP {name}} one {# pools de IP dos revendedores selecionados} other {# pools de IP dos revendedores selecionados}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Compartilhado',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dedicado',
    'ip-address-reseller-usage.assign.title' => "Adicione %%ipAddress%% ao pool de IP do revendedor",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Revendedores para adicionar',
    'ip-address-reseller-usage.assign.success' => 'O endereço IP foi adicionado ao(s) {count, plural, =1 {pool de IP {name}} one {# pools de IP dos revendedores selecionados} other {# pools de IP dos revendedores selecionados}}.',

    'ProtectedDirectoryUser.emptyViewTitle' => 'Adicionar uma conta de usuário para permitir o acesso ao diretório protegido',
    'ProtectedDirectoryUser.addTooltip' => 'Crie contas de usuários que possam acessar o diretório protegido %%directory%%',
    'ProtectedDirectoryUser.add' => 'Adicionar um usuário',
    'ProtectedDirectoryUser.login' => 'Nome',
    'ProtectedDirectoryUser.changePassword' => 'Alterar senha',
    'ProtectedDirectoryUser.noSelectionText' => 'Selecione um ou mais usuários para remover.',
    'ProtectedDirectoryUser.remove' => 'Remover',
    'ProtectedDirectoryUser.removeTooltip' => 'Remova os usuários selecionados.',
    'ProtectedDirectoryUser.removeConfirmation' => 'Remover {count, plural, one {}=1 {o usuário {login}} other {# usuários selecionados}}?',
    'ProtectedDirectoryUser.removeSuccess' => 'Os usuários selecionados foram removidos.',

    'TrafficUsageByClients.customerName' => 'Nome do cliente',
    'TrafficUsageByClients.resellerName' => 'Nome do revendedor',
    'TrafficUsageByClients.totalUsage' => 'Utilizado',
    'TrafficUsageByClients.limit' => 'Limite',
    'TrafficUsageByClients.limitRemaining' => 'Disponível',
    'TrafficUsageByClients.limitUsagePercent' => 'Usado (em %)',
];
