<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Instalowanie %%name%% na %%path%%...',
    'aps-install.queueNoPath' => 'Instalowanie %%name%%...',
    'aps-install.done' => 'Zainstalowano %%name%% pod %%path%%. Możesz zobaczyć dane do logowania do aplikacji poniżej. %%additionalMessage%%',
    'aps-install.doneNoPath' => 'Zainstalowano %%name%%. Możesz zobaczyć dane do logowania do aplikacji poniżej. %%additionalMessage%%',
    'aps-install.doneAdvanced' => 'Zainstalowano %%name%% pod %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => 'Zainstalowano %%name%%. %%additionalMessage%%',
    'aps-install.error' => 'Nieudana instalacja %%name%% pod %%path%%. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Instalacja %%name%% nie powiodła się. %%errorMessage%%',

    'aps-update.queueDownload' => 'Pobieranie %%packageName%%...',
    'aps-update.errorDownload' => 'Pobieranie %%packageName%% nie powiodło się:',
    'aps-update.queueInstall' => 'Aktualizowanie instalacji %%name%% dla %%domainName%%...',
    'aps-update.doneInstall' => 'Instalacja %%name%% dla %%domainName%% została zaktualizowana.',
    'aps-update.errorInstall' => 'Aktualizowanie instalacji %%name%% dla %%domainName%% nie powiodło się:',
    'aps-update.queueInstallMulti' => 'Aktualizowanie %%instances%% instalacji %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% instalacji z %%name%% zostało zaktualizowanych.',
    'aps-update.errorInstallMulti' => 'Aktualizowanie %%failures%% instalacji %%name%% nie powiodło się:',
    'aps-update.incorrectUpdateInformation' => 'Informacja o aktualizacji jest niepoprawna.',

    'common.hideCompletedTasks' => 'Ukryj Zakończone',
    'common.progressBarHide' => 'Ukryj',
    'common.progressBarShow' => 'Pokaż',
    'common.close' => 'Zamknij',
    'common.refresh' => 'Odśwież stronę',
    'common.taskInProgress' => '%%count%% zadania/ń w toku…',
    'common.percentCompleted' => '%%percent%%% ukończono',
    'common.allTasksCompleted' => 'Wszystkie %%num%% zadania zostały zakończone.',
    'common.minimize' => 'Minimalizuj',
    'common.statusDone' => 'Wykonano',
    'common.statusError' => 'Nieudane',
    'common.statusNotStarted' => 'W kolejce',
    'common.statusCanceled' => 'Anulowane',
    'common.progressDialogLink' => 'szczegółowe postępy',

    'database-check.queue' => 'Sprawdzanie tabel bazy danych %%database%%...',
    'database-check.done' => 'Baza danych %%database%% nie ma błędów.',
    'database-check.error' => 'Nie udało się sprawdzić bazy danych %%database%% w poszukiwaniu błędów.',
    'database-check.done-with-errors' => "Baza danych %%database%% ma %%number%% problem(y). \n %%link%%",
    'database-check.info-link-title' => 'Zobacz szczegóły i rozwiąż',

    'database-download.queue' => 'Przygotowywanie zrzutu %%database%% do eksportowania...',
    'database-download.done' => 'Zrzut %%database%% jest gotowy. Możesz go pobrać %%downloadLink%%.',
    'database-download.downloadLink' => 'Pobierz',
    'database-download.error' => 'Nie udało się wyeksportować zrzutu %%database%%:',

    'database-repair.queue' => 'Naprawianie tabeli bazy danych %%database%%...',
    'database-repair.done' => 'Baza danych %%database%% nie ma błędów.',
    'database-repair.error' => 'Nie udało się naprawić bazy danych %%database%%.',
    'database-repair.done-with-errors' => "Baza danych %%database%% ma %%number%% problem(y). \n %%link%%",
    'database-repair.info-link-title' => 'Zobacz szczegóły',

    'database-upload.queue' => 'Importuj zrzut %%database%%...',
    'database-upload.done' => 'Zrzut %%database%% został zaimportowany.',
    'database-upload.error' => 'Nie udało się zaimportować zrzutu %%database%%:',
    'database-upload.done-with-errors' => "Zrzut %%database%% został zaimportowany z błędami.",
    'database-upload.orphanedUsersSuccess' => 'Baza danych %%database%% zostałą zaimportowana. Jednak niektórzy użytkownicy zostali osieroceni (nie mają żadnych powiązanych loginów na serwerze bazy danych). Aby móc uzyskać dostęp do swojej bazy danych, przypisz loginy do tych użytkowników. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Następujący użytkownicy zostali osieroceni (nie mają powiązanych loginów na serwerze bazy danych): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Zobacz użytkowników',

    'domain-app-scan.queue' => 'Skanowanie w poszukiwaniu aplikacji...',
    'domain-app-scan.done' => 'Skanowanie w poszukiwaniu aplikacji zakończyło się.',
    'domain-app-scan.error' => 'Skanowanie w poszukiwaniu aplikacji zakończyło się z błędem.',

    'domain-move.queue' => 'Przenoszenie %%domainName%% do %%webspaceName%%',
    'domain-move.done' => '%%domainName%% została przeniesiona do %%webspaceName%%',
    'domain-move.error' => '%%domainName%% nie została przeniesiona do %%webspaceName%%',

    'domain-split.queue' => 'Przeniesienie %%domainName%% do nowej subskrypcji',
    'domain-split.done' => '%%domainName%% została przeniesiona do nowej subskrypcji',
    'domain-split.error' => '%%domainName%% nie została przeniesiona do nowej subskrypcji',

    'file-manager-import-file.done' => 'Plik %%fileName%% został zaimportowany do <a href="%%listUrl%%">folderu %%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Nie można zaimportować pliku %%fileName%%: %%errorMessage%%. <br><a href="%%url%%">Pobierz na swój komputer</a>',
    'file-manager-import-file.queue' => 'Importowanie pliku %%fileName%% z %%host%%.',
    'file-manager-import-file.progress' => 'Importowanie pliku %%fileName%% z %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Wystąpił błąd uwierzytelniania. Upewnij się, że podajesz poprawny login i hasło',
    'file-manager-import-file.errors.resolve' => 'Nie można rozwiązać nazwy hosta %%host%%. Upewnij się, że podajesz poprawny adres URL',
    'file-manager-import-file.errors.connect' => 'Nie można połączyć się z serwerem %%host%%. Upewnij się, że podajesz poprawny adres URL',
    'file-manager-import-file.errors.notFound' => 'Plik zdalny nie został znaleziony lub nie jest dostępny. Upewnij się, że podajesz poprawny adres URL, a plik jest dostępny',
    'file-manager-import-file.errors.maxSize' => 'Przekroczono limit miejsca na dysku lub ilość wolnego miejsca (%%diskSpaceLimit%%)',
    'file-manager-import-file.errors.lowSpeedTime' => 'Nie można zaimportować pliku, ponieważ prędkość przesyłania była zbyt niska: w ciągu ostatnich %%lowSpeedTime%% sekund przesłano mniej niż %%lowSpeedLimit%% bajtów. Witryna, na której jest hostowany plik, może w tej chwili mieć duży ruch. Spróbuj zaimportować plik później',
    'file-manager-import-file.errors.certificate' => 'Nie można zaimportować pliku, ponieważ certyfikat SSL/TLS serwera %%host%% nie jest zaufany. Upewnij się, że witryna internetowa, na której jest hostowany plik, jest zabezpieczona zaufanym certyfikatem',
    'file-manager-import-file.errors.redirects' => 'Maksymalna liczba przekierowań (%%maxRedirects%%) została przekroczona. Upewnij się, że serwer %%host%% działa poprawnie',

    'force-log-rotation.queue' => 'Stosowanie globalnych ustawień rotacji dzienników',
    'force-log-rotation.done' => 'Zastosowano globalne ustawienia rotacji dzienników.',
    'force-log-rotation.error' => 'Stosowanie globalnej rotacji dzienników zakończone błędami',
    'force-log-rotation.systemLogRotationError' => 'Dzienniki systemowe: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Plan usługi %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domena %%name%%: %%error%%',

    'initial-setup.queue' => 'Inicjowanie Plesk...',
    'initial-setup.done' => 'Plesk został zainicjowany.',
    'initial-setup.doneWithErrors' => 'Wystąpił błąd podczas inicjowania Plesk.',
    'initial-setup.error' => 'Inicjowanie Plesk nie powiodło się.',
    'initial-setup.step.setupPanel' => 'Konfigurowanie panelu Plesk',
    'initial-setup.step.requestLicense' => 'Pobieranie licencji',
    'initial-setup.step.configureServer' => 'Konfigurowanie serwera WWW',
    'initial-setup.step.secureServer' => 'Zabezpieczanie serwera',

    'ip-update.queue' => 'Aktualizacja adresu IP',
    'ip-update.done' => 'Adres IP zaktualizowany.',
    'ip-update.error' => 'Aktualizacja adresu IP zakończona z błędami',
    'ip-update.updating' => 'Aktualizacja adresu IP',
    'ip-update.updatingWebServer' => 'Aktualizacja adresu IP: aktualizacja serwera WWW',
    'ip-update.updatingFtpServer' => 'Aktualizacja adresu IP: aktualizacja serwera FTP',
    'ip-update.updatingDnsZones' => 'Aktualizacja adresu IP: aktualizacja stref DNS',
    'ip-update.restartingDnsService' => 'Aktualizacja adresu IP: restart serwera DNS',

    'ip-reload-public.queue' => 'Aktualizowanie publicznych adresów IP przy użyciu metadanych w chmurze',
    'ip-reload-public.done' => 'Zaktualizowano publiczne adresy IP',

    'logrotate_anonymize_ips.queue' => 'Anonimizuj adresy IP w dziennikach',
    'logrotate_anonymize_ips.queueRevert' => 'Usuwaj anonimowość adresów IP w dziennikach',
    'logrotate_anonymize_ips.done' => 'Adresy IP zostały zanonimizowane.',
    'logrotate_anonymize_ips.doneRevert' => 'Adresy IP zostały pozbawione anonimowości.',
    'logrotate_anonymize_ips.error' => 'Anonimizowanie adresów IP zakończone błędami',
    'logrotate_anonymize_ips.errorRevert' => 'Usuwanie anonimowości adresów IP zakończone błędami',

    'panel-components-install.queue' => 'Instalowanie wybranych komponentów',
    'panel-components-install.done' => 'Wybrane komponenty zostały zainstalowane.',
    'panel-components-install.error' => 'Nie udało się zainstalować komponentów. Powiadomienie z opisem błedu zostało wysłane na twój adres e-mail.',

    'panel-update.queue' => 'Plesk instaluje aktualizacje. To może potrwać. %%warning%%',
    'panel-update.warning' => 'Proszę nie wykonywać żadnych czynności zarządzania w Plesku, dopóki nie zakończy się aktualizacja.',
    'panel-update.done' => 'Plesk został zaktualizowany. Sprawdź więcej informacji w %%changelog%%.',
    'panel-update.changelog' => 'Lista zmian Plesk',
    'panel-update.error' => 'Nie udało się zaktualizować Plesk. %%errorDetails%%',
    'panel-update.support' => 'Aby rozwiązać ten problem, możesz wysłać aktualizację logu do obsługi Pleska. %%failedLog%% Przed zamknięciem tej wiadomości skopiuj plik dziennika do komputera.',
    'panel-update.failedLog' => 'Wyświetl dziennik aktualizacji z %%date%%.',

    'pum-update-packages.queue' => 'Aktualizowanie %%count%% pakietu/ów.',
    'pum-update-packages.done' => '%%count%% pakiety zostały zaktualizowane.',
    'pum-update-packages.error' => 'Aktualizacja nie powiodła się.',

    'scheduler-run-task.queue' => 'Uruchamianie zadania "%%task%%"...',
    'scheduler-run-task.done' => 'Zadanie "%%task%%" zakończone z powodzeniem w %%seconds%% sekund(y).',
    'scheduler-run-task.error' => 'Zadanie "%%task%%" zakończone z błędem w %%seconds%% sekund(y).',
    'scheduler-run-task.popupSeeDetails' => 'Zobacz szczegóły',
    'scheduler-run-task.popupTitle' => 'Uruchom zaplanowane zadanie',
    'scheduler-run-task.popupDone' => 'Zadanie "%%task%%" zakończone z powodzeniem w %%seconds%% sekund(y), dane wyjściowe:',
    'scheduler-run-task.popupError' => 'Zadanie "%%task%%" zakończone z błędem w %%seconds%% sekund(y), dane wyjściowe:',
    'scheduler-run-task.popupClose' => 'Zamknij',

    'sdk.queue' => 'Zadanie "%%name%%" jest w toku...',
    'sdk.error' => 'Zadanie "%%name%%" nie powiodło się.',
    'sdk.done' => 'Zadanie "%%name%%" zostało zakończone.',
    'sdk.canceled' => 'Zadanie "%%name%%" zostało anulowane.',

    'sync-php-settings.queue' => 'Stosowanie globalnych ustawień PHP %%version%% do domen',
    'sync-php-settings.done' => 'Globalne ustawienia PHP %%version%% zostały pomyślnie zastosowane do domen',
    'sync-php-settings.error' => 'Wystąpił błąd podczas stosowania globalnego ustawienia PHP %%version%% do domen',

    'sync-service-plan.queue' => 'Synchronizacja planu usług %%name%% z subskrypcjami',
    'sync-service-plan.done' => 'Plan serwisowy %%name%% został pomyślnie zsynchronizowany z subskrypcjami',
    'sync-service-plan.doneWithErrors' => 'Synchronizacja planu serwisowego %%name%% została zakończona. Niektóre subskrypcje nie zostały zsynchronizowane z planem',
    'sync-service-plan.error' => 'Wystąpił błąd podczas synchronizacji planu usług %%name%% z subskrypcjami',

    'domain-create.queue' => 'Tworzenie domeny %%domainName%%',
    'domain-create.done' => 'Domena %%domainName%% została utworzona',
    'domain-create.error' => 'Nie udało się utworzyć domeny %%domainName%%',
    'domain-create.warning' => 'Domena %%domainName%% została utworzona z kilkoma problemami:<br>%%problems%%',
    'domain-create.refreshUrl' => 'Widok',
    'domain-create.steps.createCustomer' => 'Tworzenie klienta',
    'domain-create.steps.createSubscription' => 'Tworzenie subskrypcji',
    'domain-create.steps.createDomain' => 'Dodawanie domeny',
    'domain-create.steps.configureDns' => 'Konfigurowanie strefy DNS',
    'domain-create.steps.createHosting' => 'Tworzenie fizycznego hostingu',
    'domain-create.steps.configurePhp' => 'Konfigurowanie PHP',
    'domain-create.steps.configureMail' => 'Konfiguracja poczty',

    'domain-delete.queue' => 'Procesowanie usuwania domen',
    'domain-delete.done' => 'Domeny usunięte',
    'domain-delete.error' => 'Usuwanie domen nie powiodło się',
    'domain-delete.step.domains' => 'Usuwanie domen…',

    'domain-resolve-checking.warning' => 'Rozwiązanie domeny %%domainName%% powoduje następujące błędy:<br>%%errors%%',

    'customer-create.queue' => 'Trwa tworzenie klienta %%customerName%%',
    'customer-create.done' => 'Klient %%customerName%% został utworzony',
    'customer-create.error' => 'Nie udało się utworzyć klienta %%customerName%%',
    'customer-create.warning' => 'Klient %%customerName%% został utworzony z kilkoma problemami:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Możesz spróbować zsynchronizować go ręcznie.',

    'customer-delete.queue' => 'Procesowanie usuwania klientów',
    'customer-delete.done' => 'Klienci usunięci',
    'customer-delete.error' => 'Usuwanie klientów nie powiodło się',

    'reseller-delete.queue' => 'Usuwanie przetwarzania przez sprzedawców',
    'reseller-delete.done' => 'Sprzedawcy usunięci',
    'reseller-delete.error' => 'Nie udało się usunąć sprzedawców',

    'subscription-create.queue' => 'Trwa tworzenie subskrypcji %%subscriptionName%%',
    'subscription-create.done' => 'Subskrypcja %%subscriptionName%% została utworzona',
    'subscription-create.error' => 'Nie udało się utworzyć subskrypcji %%subscriptionName%%',
    'subscription-create.warning' => 'Subskrypcja %%subscriptionName%% została utworzona z kilkoma problemami:<br>%%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Możesz spróbować zsynchronizować go ręcznie.',

    'subscription-delete.queue' => 'Procesowanie usuwania subskrypcji',
    'subscription-delete.done' => 'Usunięto subskrypcje',
    'subscription-delete.error' => 'Usunięcie subskrypcji nie powiodło się',

    'websites-diagnostic.queue' => 'Trwa diagnostyka stron internetowych',
    'websites-diagnostic.done' => 'Diagnostyka stron internetowych została zakończona',
    'websites-diagnostic.error' => 'Diagnostyka stron zakończona z błędami',

    'install-php-extension.queue' => 'Instalowanie pakietu %%extensionName%% na module obsługi PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'Pakiet %%extensionName%% został zainstalowany w module obsługi PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'Nie udało się zainstalować pakietu %%extensionName%% w module obsługi PHP %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Sprawdzanie wymagań',
    'install-php-extension.step.dependencies' => 'Rozwiązywanie zależności',
    'install-php-extension.step.process' => 'Instalowanie pakietu',
    'install-php-extension.step.enable' => 'Włączanie rozszerzenia',
    'install-php-extension.step.sync' => 'Synchronizacja witryn',
    'install-php-extension.errorReason' => 'Listę dostępnych pakietów dostarcza PECL. Najczęstsze przyczyny niepowodzenia instalacji są następujące:',
    'install-php-extension.errorReasonDependencies' => '- Pakiet ma zewnętrzne zależności od dodatkowych bibliotek.',
    'install-php-extension.errorReasonRequirements' => '- Pakiet nie spełnia wymagań instalacyjnych (system operacyjny, wersja PHP itd.).',
    'install-php-extension.errorReasonOutdated' => '- Pakiet jest przestarzały.',
    'install-php-extension.errorOutput' => 'Aby zidentyfikować przyczynę niepowodzenia instalacji, sprawdź dane wyjściowe narzędzia.',

    'uninstall-php-extension.queue' => 'Odinstalowanie pakietu %%extensionName%% z modułu obsługi PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Pakiet %%extensionName%% został odinstalowany z modułu obsługi PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Nie udało się odinstalować pakietu %%extensionName%% z modułu obsługi PHP %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Sprawdzanie wymagań',
    'uninstall-php-extension.step.process' => 'Odinstalowanie pakietu',
    'uninstall-php-extension.step.sync' => 'Synchronizacja stron internetowych',

    'upgrade-database-server.queue' => 'Aktualizacja serwera bazy danych',
    'upgrade-database-server.error' => 'Nie udało się zaktualizować serwera bazy danych',
    'upgrade-database-server.done' => 'Serwer bazy danych został zaktualizowany',
    'upgrade-database-server.step.validate' => 'Sprawdzanie systemu',
    'upgrade-database-server.step.dump' => 'Tworzenie zrzutu baz danych',
    'upgrade-database-server.step.disableService' => 'Wyłączanie starej usługi systemowej',
    'upgrade-database-server.step.configureRepo' => 'Konfiguracja nowego repozytorium',
    'upgrade-database-server.step.upgradePackages' => 'Aktualizacja serwera bazy danych',
    'upgrade-database-server.step.updateConfiguration' => 'Aktualizuję konfigurację serwera',
    'upgrade-database-server.step.startService' => 'Uruchomienie nowej usługi systemowej',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Uaktualnij strukturę wszystkich tabel',
    'upgrade-database-server.step.sync' => 'Synchronizacja komponentów systemu',

    'update-spam-filter-individual-settings.queue' => 'Aktualizowanie ustawień filtra spamu',
    'update-spam-filter-individual-settings.done' => 'Zaktualizowano ustawienia filtra spamu',
    'update-spam-filter-individual-settings.error' => 'Nie udało się zaktualizować ustawień filtra spamu',
    'update-spam-filter-individual-settings.mailNameError' => 'Adres e-mail %%name%%: %%error%%',

    'update-default-cert.queue' => 'Aktualizowanie certyfikatu domyślnego',
    'update-default-cert.done' => 'Domyślny certyfikat został zaktualizowany.',
    'update-default-cert.error' => 'Aktualizacja domyślnego certyfikatu zakończyła się błędami.',
    'update-default-cert.step.updating' => 'Aktualizuję domyślny certyfikat…',
];