<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Εσφαλμένη πύλη: το upstream έστειλε πολύ μεγάλη επικεφαλίδα κατά την ανάγνωση της επικεφαλίδας απάντησης"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Εσωτερικό σφάλμα διακομιστή 500: Δεν επιτρέπεται η επιλογή FollowSymLinks εδώ"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "Ο διακομιστής έφτασε στη ρύθμιση max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Συμπτώματα</h4><ul><li><p>Ιστότοποι που έχουν οριστεί ως χειριστής PHP <strong>Εφαρμογή FPM που εξυπηρετείται από το Apache</strong> ή <strong>Εφαρμογή FPM που εξυπηρετείται από το nginx</strong> στους <strong>Τομείς</strong> &gt; <strong>example.com</strong> &gt; <strong>Ρυθμίσεις PHP</strong> παρουσιάζουν ένα από τα ακόλουθα προβλήματα:</p><ul><li><p>φορτώνουν αργά</p></li><li><p>δεν είναι προσβάσιμες (μόνιμα ή περιοδικά) με σφάλμα 50x σε ένα πρόγραμμα περιήγησης ιστού: </p><pre>502 Εσφαλμένη πύλη</pre><hr><pre>503 Η υπηρεσία δεν είναι διαθέσιμη προσωρινά.</pre><hr><pre>504 Χρονικό όριο πύλης</pre></li></ul></li><li><p>Στο αρχείο καταγραφής σφαλμάτων PHP-FPM εμφανίζεται το ακόλουθο μήνυμα <code>/var/log/plesk-php<strong>XX</strong>-fpm/error. log</code> (όπου <em>XX</em> είναι η έκδοση PHP που χρησιμοποιείται από τους ιστότοπους):</p><pre>ΠΡΟΕΙΔΟΠΟΙΗΣΗ: [pool example.com] ο διακομιστής έφτασε τη ρύθμιση max_children (*), εξετάστε το ενδεχόμενο να την αυξήσετε</pre><ul><li><p>Το παραπάνω μήνυμα συνοδεύεται συνήθως από αυτό το σφάλμα:</p><pre>δεν είναι δυνατή η ανάγνωση του τι λένε τα θυγατρικά: Περιγραφή κατεστραμμένου αρχείου (9)</pre></li></ul></li><li><p>Εάν το nginx είναι ενεργοποιημένο στον διακομιστή, ένα από τα ακόλουθα μηνύματα σφάλματος μπορεί να εμφανιστεί στο αρχείο καταγραφής σφαλμάτων του τομέα <code>/var/www/vhosts/system/example. com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 η σύνδεση() στο unix:///var/www/vhosts/system/example.com/php-fpm.sock απέτυχε (11: Πόρος προσωρινά μη διαθέσιμος) κατά τη σύνδεση στο upstream, πελάτης: 203.0.113.2, διακομιστής: example.com, αίτημα: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", κεντρικός υπολογιστής: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 Το upstream έκλεισε πρόωρα τη σύνδεση ενώ διάβαζε την επικεφαλίδα απάντησης από το upstream, πελάτης: 203.0.113.2, διακομιστής: example.com, αίτημα: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Το PHP-FPM <code>pm.max_children</code> έχει επιτευχθεί από τον ιστότοπο (τους ιστότοπους).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Αύξηση του ορίου pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Αυξήστε το όριο <code>pm.max_children</code> για τους επηρεαζόμενους τομείς:</p><ol><li><p>Συνδεθείτε στον διακομιστή Plesk μέσω <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>. </p></li><li><p>Εντοπίστε τους επηρεαζόμενους τομείς χρησιμοποιώντας την παρακάτω εντολή:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6 bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Σημείωση:</strong> Ο αριθμός στα αριστερά δείχνει πόσες φορές το όριο <code>pm. max_children</code> έχει επιτευχθεί από τον ιστότοπο.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Είσοδος στο Plesk</a>. </p></li><li><p>Μεταβείτε στους <strong>Τομείς</strong> &gt; <strong>example.com</strong> &gt; <strong>Ρυθμίσεις PHP</strong> &gt; <strong>Ρυθμίσεις PHP-FPM</strong>.</p></li><li><p>Αυξήστε την τιμή <code>pm.max_children</code> για τον τομέα και εφαρμόστε τις αλλαγές. Αυξήστε αυτήν την τιμή για όλους τους τομείς που αναφέρονται στο βήμα 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Πάρα πολλά ανοιχτά αρχεία"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Το nginx αποτυγχάνει να ξεκινήσει/επαναφορτώσει σε διακομιστή Plesk: Πάρα πολλά ανοικτά αρχεία</p><h4>Συμπτώματα</h4><ul><li><p>Η υπηρεσία nginx αποτυγχάνει να ξεκινήσει/επαναφορτώσει με το ακόλουθο σφάλμα στο αρχείο <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] ανοιχτό() Το "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" απέτυχε (24: Πάρα πολλά ανοικτά αρχεία)</pre></li><li><p>Μερικοί ή όλοι οι ιστότοποι δεν είναι προσβάσιμοι</p></li><li><p>Η προειδοποίηση εμφανίζεται στο <strong>Εργαλεία &amp; Ρυθμίσεις &gt; Διάγνωση &amp; επισκευή</strong>:</p><pre style="white-space: pre-wrap;">Έλεγχος για την τιμή nginx ULIMIT N domains have been found on server. Πιθανό πρόβλημα με το προεπιλεγμένο όριο του nginx για τα ανοιχτά αρχεία</pre></li><li><p>Οι εφαρμογές web NodeJS και Ruby εμφανίζουν σφάλμα 502 Εσφαλμένη πύλη κατά την εκτέλεση ορισμένων εργασιών του Plesk, όπως δημιουργία τομέων, συνδρομές, αλλαγές στο Apache ή το Nginx κ.λπ:</p><pre style="white-space: pre-wrap;">Σφάλμα διακομιστή<br>502 Εσφαλμένη πύλη <br>Ο διακομιστής ιστού έλαβε άκυρη απάντηση ενώ ενεργούσε ως διακομιστής πύλης ή διακομιστής μεσολάβησης. </pre></li><li><p>Μετά την <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">εγκατάσταση ενός νέου πιστοποιητικού για τον τομέα</a>, το παλιό εξακολουθεί να εμφανίζεται σε ένα πρόγραμμα περιήγησης ιστού, ωστόσο, το σωστό πιστοποιητικό έχει επιλεγεί στη σελίδα <strong>Τομείς &gt; example.com &gt; Ρυθμίσεις φιλοξενίας</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Ο εικονικός κεντρικός υπολογιστής του nginx ανοίγει 4 αρχεία καταγραφής για κάθε εικονικό κεντρικό υπολογιστή με φυσική φιλοξενία:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Απόρροια αυτού του γεγονότος είναι η υπέρβαση του μέγιστου αριθμού ανοιχτών αρχείων από τον διακομιστή nginx λόγω μεγάλου αριθμού τομέων (συνήθως, πάνω από 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Αύξηση του ορίου ανοιχτών αρχείων',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6 bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Προειδοποίηση:</strong> Η εκτέλεση του βοηθητικού προγράμματος <code>websrv_ulimits</code> χωρίς την επιλογή <strong>--χωρίς επανεκκίνηση</strong> ξεκινά την αναδημιουργία των αρχείων ρυθμίσεων ιστού για όλους τους τομείς και μπορεί να προκαλέσει σημαντικό χρόνο διακοπής λειτουργίας σε περίπτωση μεγάλου αριθμού φιλοξενούμενων ιστότοπων. <br><br>Εκτελέστε την εντολή κατά τη διάρκεια του χρονικού πλαισίου συντήρησης.</div><p>Είναι καλή πρακτική να ορίσετε τιμή ορίου ανοιχτών αρχείων μεγαλύτερη από τον <strong>αριθμό τομέων στο Plesk * 16</strong> τουλάχιστον. Στο παρακάτω παράδειγμα παρέχονται ενέργειες για το πώς να ορίσετε το όριο σε 4096:</p><ol><li><p>Συνδεθείτε στον διακομιστή μέσω <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ορίστε το όριο ανοιχτών αρχείων σε 4096 τόσο για το Apache όσο και για το Nginx: </p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Επανεκκίνηση των υπηρεσιών Apache και nginx στη διεύθυνση <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ρυθμίσεις &amp; εργαλείων &gt; Διαχείριση υπηρεσιών</strong> για να εφαρμόσετε τις αλλαγές.</p></li><li><p>Ελέγξτε ότι το \'Μέγιστο όριο ανοιχτών αρχείων\' εφαρμόστηκε σωστά, μετά την επανεκκίνηση των υπηρεσιών ιστού:</p><pre># grep \'Μέγιστο όριο ανοιχτών αρχείων\' /proc/$(cat /var/run/nginx. pid)/limits<br>Μέγιστο όριο ανοιχτών αρχείων 4096 4096 file</pre></li><li><p>Εάν η παραπάνω λύση δεν βοήθησε, ορίστε το όριο χρησιμοποιώντας το βοηθητικό πρόγραμμα <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Το σώμα της απάντησης είναι πολύ μεγάλο"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Άρνηση πρόσβασης με κωδικό 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Συμπτώματα</h4><ul><li><p>Το ModSecurity είναι εγκατεστημένο και ενεργοποιημένο στην ενότητα <strong>Εργαλεία και ρυθμίσεις > Τείχος προστασίας εφαρμογής Web (ModSecurity) > Λειτουργία τείχους προστασίας εφαρμογής Web > Ενεργοποιημένο</strong>.</p></li><li> Μια τοποθεσία web που φιλοξενείται στο Plesk δεν μπορεί να φορτώσει. Δεν είναι δυνατή η εκτέλεση λειτουργιών στην τοποθεσία web, όπως η διαχείριση του WordPress, η πρόσβαση στο webmail ή η πρόσβαση στο αρχείο <code>robots.txt</code>. Το πρόγραμμα περιήγησης μπορεί να εμφανίσει ένα από τα ακόλουθα σφάλματα:
<pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Απαγορεύεται (403 Forbidden)</pre><hr><pre>500 Εσωτερικό σφάλμα διακομιστή (500 Internal Server Error)</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Ένα μήνυμα σφάλματος του ModSecurity, όπως το παρακάτω, εμφανίζεται στο αρχείο καταγραφής <code>/var/log/modsec_audit.log</code> ή στη σελίδα Αρχεία καταγραφής στο Plesk (<strong>Τομείς</strong> &gt; <strong>example.com</strong> &gt; <strong>Αρχεία καταγραφής</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Το τείχος προστασίας εφαρμογής Web του ModSecurity είναι ενεργοποιημένο με ένα πολύ περιοριστικό σύνολο κανόνων, όπως το OWASP ή Comodo, ή ένα προσαρμοσμένο σύνολο κανόνων, όπως το Imunify360. Τα περιοριστικά σύνολα κανόνων μπορούν να αποκλείσουν ορισμένες λειτουργίες στην τοποθεσία web.</p><p><Strong>Σημείωση:</strong> Το σφάλμα του ModSecurity μπορεί να υποδεικνύει επίθεση στον διακομιστή σας. Χρησιμοποιήστε τις παρακάτω λύσεις, μόνο εάν είστε σίγουροι ότι το ModSecurity αποκλείει την έγκυρη χρήση της τοποθεσίας web σας.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Απενεργοποίηση του συνόλου κανόνων του ModSecurity με αναγνωριστικό ή ετικέτα',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Βρείτε το αναγνωριστικό του κανόνα που αποκλείει την αποδεκτή χρήση της τοποθεσίας web σας. Μπορείτε να βρείτε τα αναγνωριστικά στα μηνύματα σφαλμάτων στο αρχείο καταγραφής <code>/var/log/modsec_audit.log</code>. Το αναγνωριστικό είναι ένας ακέραιος αριθμός σε εισαγωγικά με το πρόθεμα <code>id</code> σε αγκύλες, για παράδειγμα <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Απενεργοποιήστε συγκεκριμένα σύνολα κανόνων στο Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Μετάβαση σε άλλο σύνολο κανόνων του ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Μεταβείτε σε ένα λιγότερο περιοριστικό σύνολο κανόνων του ModSecurity, για παράδειγμα στο "Atomic ModSecurity Ruleset". Για να το κάνετε αυτό, μεταβείτε στην ενότητα <strong>Εργαλεία και ρυθμίσεις</strong> ><strong>Τείχος προστασίας εφαρμογής Web (ModSecurity)</strong> ><strong>Ρυθμίσεις</strong>, επιλέξτε το <strong>Atomic Standard</strong> και, στη συνέχεια, κάντε κλικ στο <strong>OK</strong> για να εφαρμόσετε τις αλλαγές.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Εσωτερικό σφάλμα διακομιστή 500: Εξαντλήθηκε το επιτρεπόμενο μέγεθος μνήμης XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Συμπτώματα</h4><ul><li><p> Η πρόσβαση δεν είναι δυνατή σε μια τοποθεσία web που φιλοξενείται στο Plesk: </p><pre>500 Εσωτερικό σφάλμα διακομιστή (500 Internal Server Error)</pre></li><li><p>Το ακόλουθο σφάλμα εμφανίζεται στο αρχείο καταγραφής της τοποθεσίας web:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Η τοποθεσία web δεν διαθέτει επαρκή εκχωρημένη μνήμη προς επεξεργασία.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Αύξηση του memory_limit της τοποθεσίας web',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "περιορισμός open_basedir σε ισχύ"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Συμπτώματα</h4><ul><li><p>Μια τοποθεσία web δεν είναι προσβάσιμη με ένα από τα ακόλουθα σφάλματα στο πρόγραμμα περιήγησης Web:</p><pre>404 Το αρχείο δεν βρέθηκε</pre><hr><pre>500 Εσωτερικό σφάλμα διακομιστή</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Το ακόλουθο μήνυμα σφάλματος εμφανίζεται στη σελίδα Αρχεία καταγραφής τομέα (<strong>Τομείς</strong> > <strong>example.com</strong> > <strong>Αρχεία καταγραφής</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Η δέσμη ενεργειών PHP επιχειρεί να αποκτήσει πρόσβαση στον κατάλογο στον οποίο δεν επιτρέπεται η πρόσβαση. Αυτός ο περιορισμός ορίζεται από την οδηγία της PHP <code>open_basedir</code> μεμονωμένα για κάθε τομέα. Από προεπιλογή, η οδηγία <code>open_basedir</code> επιτρέπει την πρόσβαση στους καταλόγους <code>tmp</code> και της ρίζας εγγράφων του τομέα, καθώς και στο μονοπάτι των προεπιλεγμένων περιόδων λειτουργίας του συστήματος.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Προσθήκη της πρόσθετης διαδρομής στην οδηγία open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Απενεργοποίηση της οδηγίας open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Μεταβείτε στη σελίδα <strong>Τομείς &gt example.com &gt Ρυθμίσεις PHP</strong> και ρυθμίστε την οδηγία <code>open_basedir</code> σε "καμία".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Απαγορεύεται AH01797: ο πελάτης απορρίπτεται από τις ρυθμίσεις του διακομιστή"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Συμπτώματα</h4><ul><li><p>Η τοποθεσία web εμφανίζει ένα σφάλμα παρόμοιο με το ακόλουθο:</p><pre>Σφάλμα διακομιστή 403<br>Απαγορεύεται</pre></li><li><p>Το αρχείο καταγραφής <code>/var/www/vhosts/system/example.com/logs/error_log</code> περιέχει σφάλματα όπως το παρακάτω:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Η τρέχουσα ρύθμιση παραμέτρων του Apache δεν επιτρέπει την πρόσβαση στην τοποθεσία web.</p><p>Για αρχεία όπως τα .htaccess και .htpasswd, αυτό είναι αναμενόμενο, καθώς τα αρχεία αυτά δεν πρέπει να είναι προσβάσιμα μέσω του διακομιστή web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Ελέγξτε τη ρύθμιση του διακομιστή και τα αρχεία .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Δεν είναι δυνατή η πρόσβαση σε κατάλογο ιστότοπου στο Plesk: 403 Απαγορεύεται"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Συμπτώματα</h4><ul><li><p>Δεν είναι δυνατή η πρόσβαση σε μια συγκεκριμένη θέση μιας τοποθεσίας web, για παράδειγμα στο <code>http://example.com/some_folder</code>. Προκύπτει το ακόλουθο σφάλμα:</p><pre>Σφάλμα διακομιστή 403<br>Απαγορεύεται</pre></li><li><p>Το ακόλουθο σφάλμα εμφανίζεται στο αρχείο <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Ο κατάλογος που ζητήθηκε δεν περιέχει τα αρχεία ευρετηρίου ή δεν είναι ενεργοποιημένη η αναζήτηση στους καταλόγους.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Προσθήκη ενός αρχείου ευρετηρίου στον κατάλογο',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Ενεργοποίηση της αναζήτησης στους καταλόγους',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Δεν είναι δυνατή η πρόσβαση σε κατάλογο ιστότοπου στο Plesk: 403 Απαγορεύεται"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Συμπτώματα</h4><ul><li><p>Δεν είναι δυνατή η πρόσβαση σε μια συγκεκριμένη θέση της τοποθεσίας web, για παράδειγμα, στο <code>http://example.com/some_folder</code>. Προκύπτει το ακόλουθο σφάλμα:</p><pre>Σφάλμα διακομιστή 403<br>Απαγορεύεται</pre></li><li><p>Το ακόλουθο σφάλμα εμφανίζεται στο αρχείο <code>/var/www/vhosts/example.com/logs/error_log</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Ο κατάλογος που ζητήθηκε δεν περιέχει τα αρχεία ευρετηρίου ή δεν είναι ενεργοποιημένη η αναζήτηση στους καταλόγους.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Προσθήκη ενός αρχείου ευρετηρίου στον κατάλογο',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Ενεργοποίηση της αναζήτησης στους καταλόγους',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "ο διακομιστής έχει τη ρύθμιση MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Όριο σώματος αίτησης PHP "ο πελάτης σκόπευε να στείλει πολύ μεγάλο σώμα"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Όριο σώματος αίτησης PHP "ο πελάτης σκόπευε να στείλει πολύ μεγάλο σώμα"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Συνεδρίες PHP "503 Εσωτερικό σφάλμα διακομιστή" ή "Αποτυχία ανάγνωσης δεδομένων περιόδου λειτουργίας"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Θα είναι έτοιμο σύντομα.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Απαγορεύεται: pcfg_openfile: αδυναμία ελέγχου του αρχείου htaccess, βεβαιωθείτε ότι είναι αναγνώσιμο"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Συμπτώματα</h4><ul><li><p>Μια τοποθεσία web που φιλοξενείται στο Plesk δεν λειτουργεί:</p><pre>Δεν έχετε δικαίωμα πρόσβασης / σε αυτόν τον διακομιστή. <br> Επιπλέον, εντοπίστηκε το σφάλμα 403 Απαγορεύεται (403 Forbidden), ενώ γινόταν προσπάθεια να χρησιμοποιηθεί ένα ErrorDocument για τη διαχείριση της αίτησης.</pre><p>Αντί του παραπάνω σφάλματος, μπορείτε επίσης να δείτε την κενή σελίδα.</p></li><li><p>Το αρχείο καταγραφής σφαλμάτων του τομέα στην ενότητα <strong>Τομείς &gt example.com &gt Αρχεία καταγραφής</strong> περιέχει τα ακόλουθα:</p><pre>(13)Δεν έχετε δικαίωμα πρόσβασης: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: δεν είναι δυνατός ο έλεγχος του αρχείου htaccess, βεβαιωθείτε ότι είναι αναγνώσιμο και ότι το "/var/www/vhosts/example.com/httpdocs/" είναι εκτελέσιμο</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Εσφαλμένα δικαιώματα για τα αρχεία ή τους φακέλους του τομέα.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Επιδιόρθωση δικαιωμάτων για το περιεχόμενο της τοποθεσίας web',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Διαβάστε το άρθρο της γνωσιακής βάσης και ακολουθήστε τις οδηγίες</a>.</p></li></ol>',
];