<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Проходить встановлення %%name%% в %%path%%...',
    'aps-install.queueNoPath' => 'Проходить процес встановлення %%name%%...',
    'aps-install.done' => '%%name%% успішно встановлено у %%path%%. Нижче наведено ваші ідентифікаційні дані для входу в застосунок. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% успішно встановлено у %%path%%. Нижче наведено ваші ідентифікаційні дані для входу в застосунок. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% було успішно встановлено в %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% було успішно встановлено. %%additionalMessage%%',
    'aps-install.error' => 'Встановлення %%name%% в %%path%% не вдалося. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Встановлення %%name%% не вдалося. %%errorMessage%%',

    'aps-update.queueDownload' => 'Завантаження %%packageName%%...',
    'aps-update.errorDownload' => 'Завантаження %%packageName%% не вдалося:',
    'aps-update.queueInstall' => 'Оновлення інсталяції %%name%% для %%domainName%%...',
    'aps-update.doneInstall' => 'Інсталяцію %%name%% для %%domainName%% успішно оновлено.',
    'aps-update.errorInstall' => 'Оновлення інсталяції %%name%% для %%domainName%% не вдалося:',
    'aps-update.queueInstallMulti' => 'Оновлення %%instances%% інсталяцій %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% установок %%name%% успішно оновлено.',
    'aps-update.errorInstallMulti' => 'Оновлення %%failures%% інсталяцій %%name%% не вдалося:',
    'aps-update.incorrectUpdateInformation' => 'Інформація щодо оновлення є невірною.',

    'common.hideCompletedTasks' => 'Приховати завершене завдання',
    'common.progressBarHide' => 'Приховати',
    'common.progressBarShow' => 'Показати',
    'common.close' => 'Закрити',
    'common.refresh' => 'Оновити сторінку',
    'common.taskInProgress' => '%%count%% завдань в процесі...',
    'common.percentCompleted' => '%%percent%%% завершено',
    'common.allTasksCompleted' => 'Успішно завершено всі %%num%% завдання.',
    'common.minimize' => 'Зменшити',
    'common.statusDone' => 'Завершено',
    'common.statusError' => 'Не вдалося',
    'common.statusNotStarted' => 'Поставлено в чергу',
    'common.statusCanceled' => 'Скасовано',
    'common.progressDialogLink' => 'докладний перебіг',

    'database-check.queue' => 'Перевірка таблиць %%database%% бази даних...',
    'database-check.done' => '%%database%% база даних не містить помилок.',
    'database-check.error' => 'Неможливо перевірити %%database%% базу даних на наявність помилок.',
    'database-check.done-with-errors' => "%%database%% база даних налічує %%number%% проблем. \n %%link%%",
    'database-check.info-link-title' => 'Переглянути деталі та вирішити проблему',

    'database-download.queue' => 'Підготовка дампу до експорту %%database%%...',
    'database-download.done' => 'Готовий дамп для %%database%%. Ви можете його %%downloadLink%%.',
    'database-download.downloadLink' => 'завантажити',
    'database-download.error' => 'Неможливо імпортувати дамп %%database%%:',

    'database-repair.queue' => 'Ремонт таблиць бази даних %%database%%...',
    'database-repair.done' => 'База даних %%database%% не містить помилок.',
    'database-repair.error' => 'Неможливо відремонтувати базу даних %%database%%.',
    'database-repair.done-with-errors' => "База даних %%database%% налічує %%number%% проблем. \n %%link%%",
    'database-repair.info-link-title' => 'Переглянути деталі',

    'database-upload.queue' => 'Імпорт дампу %%database%%...',
    'database-upload.done' => 'Дамп %%database%% імпортовано.',
    'database-upload.error' => 'Неможливо імпортувати дамп %%database%%:',
    'database-upload.done-with-errors' => "Дамп %%database%% імпортовано з помилками.",
    'database-upload.orphanedUsersSuccess' => 'Базу даних %%database%% успішно імпортовано. При цьому деяких користувачів було втрачено (не мають імені користувача, прив’язаного до серверу бази даних). Щоб ці користувачі отримали доступ до ваших баз даних, призначте їм імена користувачів. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Було втрачено таких користувачів (які не мають пов\'язаних входів на сервері бази даних): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Переглянути користувачів',

    'domain-app-scan.queue' => 'Сканування для застосунків...',
    'domain-app-scan.done' => 'Сканування для застосунків завершено.',
    'domain-app-scan.error' => 'Сканування для застосунків завершено з помилками.',

    'domain-move.queue' => 'Переміщення %%domainName%% до %%webspaceName%%',
    'domain-move.done' => '%%domainName%% переміщено до %%webspaceName%%',
    'domain-move.error' => '%%domainName%% не переміщено до %%webspaceName%%',

    'domain-split.queue' => 'Переміщення %%domainName%% до нової підписки',
    'domain-split.done' => '%%domainName%% переміщено до нової підписки',
    'domain-split.error' => '%%domainName%% не переміщено до нової підписки',

    'file-manager-import-file.done' => 'Файл %%fileName%% був імпортований до <a href="%%listUrl%%">папки %%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Не вдається імпортувати файл %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Завантажити на мій комп\'ютер</a>',
    'file-manager-import-file.queue' => 'Імпортуємо файл %%fileName%% з %%host%%.',
    'file-manager-import-file.progress' => 'Імпортуємо файл %%fileName%% з %%host%% (%%value%% МБ).',
    'file-manager-import-file.errors.auth' => 'Виникла помилка автентифікації. Переконайтеся, що ви ввели правильні логін та пароль',
    'file-manager-import-file.errors.resolve' => 'Не вдалося вирішити назву розміщувача %%host%%. Переконайтеся, що ви надали правильний УЛР',
    'file-manager-import-file.errors.connect' => 'Не вдалося підключитися до сервера %%host%%. Переконайтеся, що ви надали правильний УЛР',
    'file-manager-import-file.errors.notFound' => 'Віддалений файл не був знайдений, або недоступний. Переконайтеся, що ви надали правильний УЛР, а файл доступний',
    'file-manager-import-file.errors.maxSize' => 'Обмеження дискового місця або вільне місце %%diskSpaceLimit%% було перевищено',
    'file-manager-import-file.errors.lowSpeedTime' => 'Не вдалося імпортувати файл, тому що швидкість передачі була занизькою: менше за %%lowSpeedLimit%% байтів передавалося протягом останніх %%lowSpeedTime%% секунд. Вебсайт, на якому розміщено файл, може зараз знаходитися під значним навантаженням. Спробуйте імпортувати файл пізніше',
    'file-manager-import-file.errors.certificate' => 'Не вдалося імпортувати файл, тому що SSL/TLS-сертифікат сервера %%host%% не має довіри. Переконайтеся, що вебсайт, на якому розміщено файл, убезпечений сертифікатом з довірою',
    'file-manager-import-file.errors.redirects' => 'Перевищено максимальну кількість перенаправлень (%%maxRedirects%%). Переконайтеся, що сервер %%host%% працює належним чином',

    'force-log-rotation.queue' => 'Застосовуємо налаштування глобальної ротації логів',
    'force-log-rotation.done' => 'Налаштування глобальної ротації логів були застосовані.',
    'force-log-rotation.error' => 'Застосування глобальної ротації логів завершена з помилками.',
    'force-log-rotation.systemLogRotationError' => 'Системні логи: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Сервісний план %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Домен %%name%%: %%error%%',

    'initial-setup.queue' => 'Ініціалізація Plesk...',
    'initial-setup.done' => 'Plesk ініціалізовано.',
    'initial-setup.doneWithErrors' => 'Під час ініціалізації Plesk сталася помилка.',
    'initial-setup.error' => 'Ініціалізація Plesk не вдалася.',
    'initial-setup.step.setupPanel' => 'Налаштування панелі Plesk',
    'initial-setup.step.requestLicense' => 'Запит ліцензії',
    'initial-setup.step.configureServer' => 'Налаштування мережевого сервера',
    'initial-setup.step.secureServer' => 'Убезпечення сервера',

    'ip-update.queue' => 'Оновлення IP-адреси',
    'ip-update.done' => 'IP-адресу оновлено.',
    'ip-update.error' => 'Оновлення IP-адреси закінчилося з помилками',
    'ip-update.updating' => 'Оновлення IP-адреси',
    'ip-update.updatingWebServer' => 'Оновлення IP-адреси: оновлення веб-сервера',
    'ip-update.updatingFtpServer' => 'Оновлення IP-адреси: оновлення FTP-сервера',
    'ip-update.updatingDnsZones' => 'Оновлення IP-адреси: оновлення DNS-зон',
    'ip-update.restartingDnsService' => 'Оновлення IP-адреси: перезапуск DNS-сервера',

    'ip-reload-public.queue' => 'Оновлення публічних ІП-адрес, використовуючи хмарні метадані',
    'ip-reload-public.done' => 'Публічні ІП-адреси були оновлені',

    'logrotate_anonymize_ips.queue' => 'Анонімізувати IP-адреси у логах',
    'logrotate_anonymize_ips.queueRevert' => 'Скасувати анонімізацію IP-адрес у журналах реєстрації',
    'logrotate_anonymize_ips.done' => 'IP-адреси були анонімізовані.',
    'logrotate_anonymize_ips.doneRevert' => 'Анонімізацію IP-адрес скасовано.',
    'logrotate_anonymize_ips.error' => 'Анонімізація IP-адрес завершилася з помилками',
    'logrotate_anonymize_ips.errorRevert' => 'При скасуванні анонімізації IP-адрес виникли помилки',

    'panel-components-install.queue' => 'Установка вибраних компонентів',
    'panel-components-install.done' => 'Вибрані компоненти успішно встановлено.',
    'panel-components-install.error' => 'Неможливо встановити компоненти. Сповіщення з описом помилки надіслано на вашу електронну пошту.',

    'panel-update.queue' => 'Plesk встановлює оновлення. Це може зайняти деякий час. %%warning%%',
    'panel-update.warning' => 'Будь ласка, не виконуйте операцій управління у Plesk до завершення оновлення.',
    'panel-update.done' => 'Plesk було оновлено. Більше інформації у %%changelog%%.',
    'panel-update.changelog' => 'Журнал змін Plesk',
    'panel-update.error' => 'Не вдалося оновити Plesk. %%errorDetails%%',
    'panel-update.support' => 'Для вирішення цієї проблеми ви можете надіслати файл журналу реєстрації оновленя у службу підтримки Plesk. %%failedLog%% Скопіюйте файл реєстрації на свій комп\'ютер перш ніж закрити це повідомлення.',
    'panel-update.failedLog' => 'Переглянути журнал реєстрації оновлення від %%date%%.',

    'pum-update-packages.queue' => 'Проходить оновлення %%count%% пакета(ів)...',
    'pum-update-packages.done' => 'Успішно встановлено %%count%% пакетів.',
    'pum-update-packages.error' => 'Оновлення не вдалося.',

    'scheduler-run-task.queue' => 'Запуск завдання "%%task%%"...',
    'scheduler-run-task.done' => 'Завдання "%%task%%" успішно завершено за %%seconds%% секунд.',
    'scheduler-run-task.error' => 'Завдання "%%task%%" завершено з помилкою за %%seconds%% секунд.',
    'scheduler-run-task.popupSeeDetails' => 'Докладніше',
    'scheduler-run-task.popupTitle' => 'Запустити заплановане завдання',
    'scheduler-run-task.popupDone' => 'Завдання "%%task%%" успішно завершено за %%seconds%% секунд, вихід:',
    'scheduler-run-task.popupError' => 'Завдання "%%task%%" завершено з помилкою за %%seconds%% секунд, вихід:',
    'scheduler-run-task.popupClose' => 'Закрити',

    'sdk.queue' => 'Завдання "%%name%%" ще виконується...',
    'sdk.error' => 'Завдання "%%name%%" не вдалося.',
    'sdk.done' => 'Завдання "%%name%%" завершено.',
    'sdk.canceled' => 'Завдання "%%name%%" скасовано.',

    'sync-php-settings.queue' => 'Застосування глобальних налаштувань PHP %%version%% на доменах',
    'sync-php-settings.done' => 'Глобальні налаштування PHP %%version%% успішно застосовано на доменах',
    'sync-php-settings.error' => 'Сталася помилка при застосуванні глобальних налаштувань PHP %%version%% на доменах',

    'sync-service-plan.queue' => 'Синхронізація плану послуг %%name%% з підписками',
    'sync-service-plan.done' => 'План послуг %%name%% успішно синхронізовано з підписками',
    'sync-service-plan.doneWithErrors' => 'Синхронізацію плану послуг %%name%% завершено. Деякі підписки не вдалося синхронізувати',
    'sync-service-plan.error' => 'Сталася помилка при синхронізації плану послуг %%name%% з підписками',

    'domain-create.queue' => 'Створення домену %%domainName%%',
    'domain-create.done' => 'Створено домен %%domainName%%',
    'domain-create.error' => 'Створення домену %%domainName%% не вдалося',
    'domain-create.warning' => 'Домен %%domainName%% створено з деякими проблемами:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Переглянути',
    'domain-create.steps.createCustomer' => 'Створення клієнта',
    'domain-create.steps.createSubscription' => 'Створення підписки',
    'domain-create.steps.createDomain' => 'Додавання домену',
    'domain-create.steps.configureDns' => 'Налаштування зони СДІ',
    'domain-create.steps.createHosting' => 'Створення фізичного розміщення',
    'domain-create.steps.configurePhp' => 'Налаштування PHP',
    'domain-create.steps.configureMail' => 'Налаштовуємо пошту',

    'domain-delete.queue' => 'Обробка видалення доменів',
    'domain-delete.done' => 'Домени видалено',
    'domain-delete.error' => 'Збій видалення доменів',
    'domain-delete.step.domains' => 'Видалення доменів…',

    'domain-resolve-checking.warning' => 'Виявлені проблеми вирішення домену %%domainName%%: <br> %%errors%%',

    'customer-create.queue' => 'Створення клієнта %%customerName%% в обробці',
    'customer-create.done' => 'Клієнта %%customerName%% створено',
    'customer-create.error' => 'Створення клієнта %%customerName%% не вдалося',
    'customer-create.warning' => 'Клієнта %%customerName%% створено з кількома проблемами:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Ви можете спробувати синхронізувати вручну.',

    'customer-delete.queue' => 'Обробка видалення клієнтів',
    'customer-delete.done' => 'Клієнтів видалено',
    'customer-delete.error' => 'Збій видалення клієнтів',

    'reseller-delete.queue' => 'Обробка видалення посередників',
    'reseller-delete.done' => 'Посередників видалено',
    'reseller-delete.error' => 'Збій видалення посередників',

    'subscription-create.queue' => 'Створення підписки %%subscriptionName%% в обробці',
    'subscription-create.done' => 'Підписку %%subscriptionName%% створено',
    'subscription-create.error' => 'Створення підписки %%subscriptionName%% не вдалося',
    'subscription-create.warning' => 'Підписку %%subscriptionName%% створено з кількома проблемами:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Ви можете спробувати синхронізувати вручну.',

    'subscription-delete.queue' => 'Обробка видалення підписок',
    'subscription-delete.done' => 'Підписки видалено',
    'subscription-delete.error' => 'Збій видалення підписок',

    'websites-diagnostic.queue' => 'Працює діагностика вебсайтів',
    'websites-diagnostic.done' => 'Діагностику вебсайтів завершено',
    'websites-diagnostic.error' => 'Діагностику вебсайтів завершено з помилками',

    'install-php-extension.queue' => 'Установлення пакета %%extensionName%% на PHP-обробник %%phpHandlerName%%',
    'install-php-extension.done' => 'Пакет %%extensionName%% установлено на PHP-обробник %%phpHandlerName%%',
    'install-php-extension.error' => 'Збій установлення пакета %%extensionName%% на PHP-обробник %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Перевіряння вимог',
    'install-php-extension.step.dependencies' => 'Вирішення залежностей',
    'install-php-extension.step.process' => 'Установлення пакета',
    'install-php-extension.step.enable' => 'Увімкнення розширення',
    'install-php-extension.step.sync' => 'Синхронізація сайтів',
    'install-php-extension.errorReason' => 'Список доступних пакетів надає PECL. Найпоширеніші причини збою встановлення:',
    'install-php-extension.errorReasonDependencies' => '— Пакет має зовнішні залежності від додаткових бібліотек.',
    'install-php-extension.errorReasonRequirements' => '— Пакет не відповідає вимогам установлення (версія ОС, PHP тощо).',
    'install-php-extension.errorReasonOutdated' => '— Пакет застарів.',
    'install-php-extension.errorOutput' => 'Аби визначити причину збою встановлення, перегляньте вихідні дані утиліти.',

    'uninstall-php-extension.queue' => 'Видалення пакета %%extensionName%% з PHP-обробника %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Пакет %%extensionName%% видалено з PHP-обробника %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Збій видалення пакета %%extensionName%% з PHP-обробника %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Перевіряння вимог',
    'uninstall-php-extension.step.process' => 'Видалення пакета',
    'uninstall-php-extension.step.sync' => 'Синхронізація вебсайтів',

    'upgrade-database-server.queue' => 'Оновлення сервера бази даних',
    'upgrade-database-server.error' => 'Не вдалося оновити сервер бази даних',
    'upgrade-database-server.done' => 'Сервер бази даних оновлено',
    'upgrade-database-server.step.validate' => 'Перевірка системи',
    'upgrade-database-server.step.dump' => 'Створення дампа баз даних',
    'upgrade-database-server.step.disableService' => 'Відключення старої системної служби',
    'upgrade-database-server.step.configureRepo' => 'Налаштування нового репозиторію',
    'upgrade-database-server.step.upgradePackages' => 'Оновлення сервера бази даних',
    'upgrade-database-server.step.updateConfiguration' => 'Оновлення конфігурації сервера',
    'upgrade-database-server.step.startService' => 'Запуск нової системної служби',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Оновіть структуру всіх таблиць',
    'upgrade-database-server.step.sync' => 'Синхронізація компонентів системи',

    'update-spam-filter-individual-settings.queue' => 'Оновлення налаштувань спам-фільтра',
    'update-spam-filter-individual-settings.done' => 'Налаштування спам-фільтра оновлено',
    'update-spam-filter-individual-settings.error' => 'Не вдалося оновити налаштування спам-фільтра',
    'update-spam-filter-individual-settings.mailNameError' => '%%name%%: %%error%% адреси електронної пошти',

    'update-default-cert.queue' => 'Оновлення сертифіката за замовчуванням',
    'update-default-cert.done' => 'Сертифікат за замовчуванням оновлено.',
    'update-default-cert.error' => 'Сертифікат за замовчуванням оновлено з помилками.',
    'update-default-cert.step.updating' => 'Оновлення сертифіката за замовчуванням…',
];