<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Номер ключа',
    'additional-keys.keyName' => 'Имя ключа',
    'additional-keys.keyApp' => 'Приложение',
    'additional-keys.addGroup' => 'Добавить',
    'additional-keys.upload' => 'Установить новый ключ',
    'additional-keys.uploadDescription' => 'Загрузить и установить новый ключ лицензии.',
    'additional-keys.actionsGroup' => 'Действия',
    'additional-keys.install' => 'Установить',
    'additional-keys.installAll' => 'Установить все',
    'additional-keys.installDescription' => 'Установить выбранные ключи лицензии.',
    'additional-keys.installNoSelection' => 'Выберите один или более дополнительных ключей лицензии для установки или нажмите "Установить все".',
    'additional-keys.installSuccess' => 'Процедура установки лицензионного ключа запущена.',
    'additional-keys.removeGroup' => 'Удалить',
    'additional-keys.remove' => 'Удалить',
    'additional-keys.removeDescription' => 'Удалить выбранные лицензионные ключи.',
    'additional-keys.removeNoSelection' => 'Выберите один или более дополнительных ключей лицензии для удаления.',
    'additional-keys.removeConfirmation' => 'Удалить {count, plural, =1 {ключ лицензии {name}} one {# выбранный ключ лицензии} few {# выбранных ключа лицензии} many {# выбранных ключей лицензии} other {# выбранных ключей лицензии}}?',
    'additional-keys.removeSuccess' => 'Выбранные ключи лицензии удалены.',
    'additional-keys.download' => 'Скачать ключ',
    'additional-keys.downloadDescription' => 'Загрузить ключ лицензии.',
    'additional-keys.emptyViewTitle' => 'Нет дополнительных ключей лицензии',

    'backup.tasks.startDate' => 'Запущено в',
    'backup.tasks.targetRepo' => 'Целевое хранилище',
    'backup.tasks.progress' => 'Статус задачи',
    'backup.tasks.repoTypeLocal' => 'Сервер',
    'backup.tasks.repoTypeFtp' => 'Личный FTP-хранилище',
    'backup.tasks.buttonRemoveTask' => 'Удалить',
    'backup.tasks.hintRemoveTask' => 'Удалить выбранные задачи.',
    'backup.tasks.buttonReload' => 'Обновить',
    'backup.tasks.hintReload' => 'Обновить список задач.',
    'backup.tasks.statusTaskWarnings' => 'Предупреждения',
    'backup.tasks.statusTaskInfo' => 'Информация',
    'backup.tasks.statusTaskFailed' => 'Не удалась',

    'backup.disabledSelectHint' => 'Эту резервную копию нельзя удалить, так она входит в резервную копию сервера, реселлера или клиента.',
    'backup.buttonBackup' => 'Создать резервную копию',
    'backup.hintBackup' => 'Создать резервную копию.',
    'backup.buttonSchedule' => 'Расписание',
    'backup.hintSchedule' => 'Настроить запланированное резервное копирование.',
    'backup.buttonReload' => 'Обновить',
    'backup.hintReload' => 'Обновить список резервных копий.',
    'backup.buttonUpload' => 'Загрузить',
    'backup.hintUpload' => 'Загрузить резервную копию с локального компьютера в серверное хранилище.',
    'backup.buttonSettings' => 'Настройки',
    'backup.hintSettings' => 'Настроить глобальные параметры резервного копирования.',
    'backup.buttonRemoteStorages' => 'Настройки удаленного хранилища',
    'backup.hintRemoteStorages' => 'Настройте свое персональное удаленное хранилище для хранения резервных копий.',
    'backup.buttonRemove' => 'Удалить',
    'backup.hintRemove' => 'Удалить выбранные резервные копии из серверного хранилища.',
    'backup.systemNotes' => 'Системные оповещения',
    'backup.incremental' => 'Инкрементный.',
    'backup.multiVolume' => 'Многотомный.',
    'backup.remoteStorage' => 'В хранилище: %%storage%%',
    'backup.status' => 'С',
    'backup.statusOff' => 'Некорректная резервная копия. Входящие в нее данные не подлежат восстановлению. Нажмите на имя резервной копии, чтобы посмотреть подробности.',
    'backup.statusWarning' => 'Резервная копия не полностью корректна. Нажмите на имя резервной копии, чтобы посмотреть подробности.',
    'backup.statusInfo' => 'Исправная резервная копия. Данные можно восстановить из этой резервной копии, но могут возникнуть мелкие неполадки, связанные со способом хранения данных.',
    'backup.statusOn' => 'Исправная резервная копия. Входящие в нее данные могут быть успешно восстановлены.',
    'backup.date' => 'Дата создания',
    'backup.name' => 'Имя',
    'backup.comment' => 'Комментарии',
    'backup.size' => 'Размер',
    'backup.download' => 'Скачать эту резервную копию на локальный компьютер.',
    'backup.downloadDisabled' => 'Скачивание файла резервной копии временно недоступно. Пожалуйста, повторите попытку позднее или обратитесь к своему сервис-провайдеру.',
    'backup.total' => 'Всего копий: %%total%%, размер: %%totalSize%%',
    'backup.totalFound' => 'Найдено копий: %%found%% (%%total%% всего), размер: %%totalSize%%',
    'backup.confirmOnDelete' => 'Удалить выбранные копии?',
    'backup.incrementsRemovalLoading' => 'Загрузка...',
    'backup.incrementsRemovalConfirmation' => 'Я подтверждаю, что хочу удалить выбранные копии.',
    'backup.backupHasIncrements' => 'Резервная копия %%backupName%% будет удалена вместе с инкрементами: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Неверно указано имя пользователя или пароль для хранилища FTP',
    'backup.ftpStorageErrorResolveHost' => "Не удалось определить имя хоста",
    'backup.ftpStorageErrorConnection' => "Не удалось подключиться к удаленному серверу",
    'backup.unableToGetFtpDumpList' => 'Не удалось отобразить список резервных копий, находящихся в FTP-хранилище: %%errorMessage%%. Пожалуйста, проверьте <a href="%%ftpSettingsUrl%%">настройки FTP-хранилища</a>.',
    'backup.unableToGetExtDumpList' => 'Не удалось отобразить список резервных копий, находящихся в хранилище %%storageTitle%%: %%errorMessage%%. Пожалуйста, проверьте настройки хранилища.',
    'backup.unableToGetLocalDumpList' => 'Не удалось отобразить список резервных копий, сохраненных на сервере: %%errorMessage%%',
    'backup.skippedFilesAtExtStorage' => 'Некоторые файлы, находящиеся в хранилище %%storageTitle%%, не показываются в списке, потому что их названия не соответствуют правилам именования резервных копий. Если вы уверены, что это действительные резервные копии, переименуйте их следующим образом: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Показать тома',
    'backup.multiVolumeHide' => 'Скрыть тома',
    'backup.backEncryptionRequired' => 'В целях безопасности мы рекомендуем защитить конфиденциальные данные в резервных копиях. Пожалуйста, перейдите на страницу %%link%% и обновите настройки безопасности резервного копирования.',
    'backup.backupSettingPage' => 'Настройки резервного копирования',
    'backup.statusTaskProgress' => 'Задача резервного копирования выполняется.',
    'backup.statusTaskWarnings' => 'Задача резервного копирования завершилась, есть предупреждения.',
    'backup.statusTaskInfo' => 'Информация.',
    'backup.statusTaskFailed' => 'Не выполнена задача резервного копирования.',
    'backup.statusTaskStopping' => 'Остановка выполнения задачи резервного копирования.',
    'backup.statusTaskStopped' => 'Задача резервного копирования остановлена.',

    'backup.schedule.columnSchedule' => 'Расписание',
    'backup.schedule.columnContent' => 'Содержимое',
    'backup.schedule.columnStorage' => 'Хранилище',
    'backup.schedule.periodHourly' => 'По часам',
    'backup.schedule.periodHourlySchedule' => '(кажд. {period, plural, one {# ч.} few {# ч.} many {# ч.} other {# ч.}})',
    'backup.schedule.periodDaily' => 'Ежедневно',
    'backup.schedule.periodDailySchedule' => '(в %%hours%%:%%minutes%%)',
    'backup.schedule.periodWeekly' => 'Еженедельно',
    'backup.schedule.periodWeeklySchedule' => '(в %%day%% в %%hours%%:%%minutes%%)',
    'backup.schedule.periodMonthly' => 'Ежемесячно',
    'backup.schedule.periodMonthlySchedule' => '(в %%day%% д. в %%hours%%:%%minutes%%)',
    'backup.schedule.periodCustom' => 'Персональный план',
    'backup.schedule.dayFirst' => 'первый',
    'backup.schedule.dayLast' => 'последний',
    'backup.schedule.day' => '{day, selectordinal, other {#-й}}',
    'backup.schedule.storageLocal' => 'Серверное хранилище',
    'backup.schedule.storageBoth' => 'Серверное хранилище и %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Запланированное резервное копирование было отключено',

    'custombuttons.buttonAdd' => 'Добавить ссылку на услугу',
    'custombuttons.buttonAddDescription' => 'Добавить ссылку на онлайн-услугу в интерфейс Plesk.',
    'custombuttons.buttonRemove' => 'Удалить',
    'custombuttons.buttonRemoveDescription' => 'Удалить выбранные ссылки.',
    'custombuttons.removeConfirmMessage' => 'Удалить выбранные ссылки?',
    'custombuttons.headerPublic' => 'В',
    'custombuttons.headerLocation' => 'Р',
    'custombuttons.headerImage' => 'Изображение',
    'custombuttons.headerPriority' => 'Приоритет',
    'custombuttons.headerLabel' => 'Название кнопки',
    'custombuttons.headerUrl' => 'URL-адрес',
    'custombuttons.headerDescription' => 'Описание',
    'custombuttons.publicEnabledDescription' => 'Ссылка видна пользователям.',
    'custombuttons.publicDisabledDescription' => 'Ссылка не видна пользователям.',
    'custombuttons.altPublicEnabledIcon' => 'Общий',
    'custombuttons.altPublicDisabledIcon' => 'Частный',
    'custombuttons.placeNavigationDescription' => 'Ссылка присутствует на всех страницах.',
    'custombuttons.placeAdminDescription' => 'Ссылка расположена на домашней странице администратора.',
    'custombuttons.placeAdminSettingsDescription' => 'Эта ссылка расположена на странице "Инструменты и настройки" в панели администратора.',
    'custombuttons.placeResellerDescription' => 'Ссылка расположена на домашней странице реселлера',
    'custombuttons.placeResellerSettingsDescription' => 'Ссылка расположена на странице "Инструменты и утилиты" в панели реселлера.',
    'custombuttons.placeClientDescription' => 'Ссылка расположена на домашней странице клиента.',
    'custombuttons.placeDomainDescription' => 'Ссылка расположена на странице "Сайты и домены".',
    'custombuttons.placeDomainPropertiesDescription' => 'Ссылка расположена на странице "Сайты и домены", в списке инструментов, который появляется по нажатию кнопки "Развернуть" под именем домена.',

    'databaseservers.addGroup' => 'Добавить',
    'databaseservers.addDatabaseServer' => 'Добавить сервер баз данных',
    'databaseservers.addDatabaseServerDescription' => 'Добавить сервер баз данных.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Удаленный хостинг баз данных не поддерживается лицензионным ключом.',
    'databaseservers.actionsGroup' => 'Действия',
    'databaseservers.hostingSettings' => 'Настройки',
    'databaseservers.hostingSettingsDescription' => 'Настройки хостинга баз данных.',
    'databaseservers.refresh' => 'Обновить',
    'databaseservers.refreshDescription' => 'Обновить информацию о серверах баз данных.',
    'databaseservers.removeGroup' => 'Удалить',
    'databaseservers.remove' => 'Удалить',
    'databaseservers.removeDescription' => 'Удалить выбранные серверы баз данных.',
    'databaseservers.lastError' => 'С',
    'databaseservers.type' => 'Тип сервера',
    'databaseservers.host' => 'Имя сервера',
    'databaseservers.hostLink' => 'Просмотр и изменение свойств сервера баз данных.',
    'databaseservers.port' => 'Порт',
    'databaseservers.version' => 'Версия',
    'databaseservers.databasesCount' => 'Базы данных',
    'databaseservers.databasesCountLink' => 'Управление базами данных, размещенными на этом сервере.',
    'databaseservers.databaseUpgradeLink' => 'Обновление сервера баз данных, размещенного на этом сервере.',
    'databaseservers.databasesLTSVersion' => 'У вас уже имеется версия LTS. Plesk автоматически обновляет вашу установку MySQL/MariaDB до более новых версий с исправлениями.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Войти на этот сервер через DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Скачайте локальный SQL-клиент',
    'databaseservers.downloadMsSqlClientHint' => 'Скачайте локальный SQL-клиент',
    'databaseservers.changePassword' => 'Изменить пароль администратора',
    'databaseservers.changePasswordHint' => 'Измените пароль администратора сервера баз данных.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Сервер Microsoft SQL',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'по умолчанию для MySQL',
    'databaseservers.default_for_mssql' => 'по умолчанию для MS SQL',
    'databaseservers.default_for_postgresql' => 'по умолчанию для PostgreSQL',
    'databaseservers.default_for_mariadb' => 'по умолчанию для MariaDB',
    'databaseservers.default_for_percona' => 'по умолчанию для Percona',
    'databaseservers.status_no_error' => 'Последняя попытка установить соединение с данным сервером завершилась успешно.',
    'databaseservers.status_connection_failed' => 'Последняя попытка установить соединение с данным сервером не удалась из-за сетевых проблем.',
    'databaseservers.status_permission_denied' => 'При последней попытке установить соединение с этим сервером было отказано в доступе. Пожалуйста, проверьте правильность учетных данных администратора.',
    'databaseservers.status_other_error' => 'Произошла ошибка при последней попытке установить соединение с данным сервером.',
    'databaseservers.status_credentials_not_set' => 'Для подключения Plesk к этому серверу необходимо указать правильное имя пользователя и пароль администратора.',
    'databaseservers.mssqlServerPortUndefined' => 'Не удается определить номер TCP-порта, используемый сервером Microsoft SQL \'%%host%%\': в сетевых настройках сервера не включен протокол TCP/IP, или этот сервер использует динамические TCP-порты.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'Чтобы вашим клиентам была доступна автоматическая настройка брандмауэра на удаленный доступ к базам данных, вам нужно вручную указать в настройках сервера SQL конкретный фиксированный TCP-порт.',
    'databaseservers.removeEmptySelection' => 'Серверы баз данных не выбраны.',
    'databaseservers.removeConfirmation' => 'Вы уверены, что хотите удалить {count, plural, =1 {сервер баз данных {name}} one {# выбранный сервер баз данных} few {# выбранных сервера баз данных} many {# выбранных серверов баз данных} other {# выбранных серверов баз данных}}?',
    'databaseservers.removeSuccess' => 'Выбранные серверы баз данных успешно удалены.',

    'databaseserverdatabases.actionsGroup' => 'Действия',
    'databaseserverdatabases.assignToSubscription' => 'Перенести в подписку',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Перенести выбранные базы данных в другую подписку.',
    'databaseserverdatabases.removeGroup' => 'Удалить',
    'databaseserverdatabases.remove' => 'Удалить',
    'databaseserverdatabases.removeDescription' => 'Удалить выбранные базы данных.',
    'databaseserverdatabases.name' => 'Имя',
    'databaseserverdatabases.subscription' => 'Подписка',
    'databaseserverdatabases.client' => 'Подписчик',
    'databaseserverdatabases.manageDatabase' => 'Управление хостингом',
    'databaseserverdatabases.manageDatabaseDescription' => 'Управлять базой данных.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Открыть в Панели реселлера',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Управлять базой данных в Панели реселлера подписчика.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Открыть в Панели клиента',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Управлять базой данных в Панели клиента подписчика.',
    'databaseserverdatabases.emptySelection' => 'Базы данных не выбраны.',
    'databaseserverdatabases.removeConfirmation' => 'Вы уверены, что хотите удалить {count, plural, =1 {базу данных {name}} one {# выбранную базу данных} few {# выбранных базы данных} many {# выбранных баз данных} other {# выбранных баз данных}}?',
    'databaseserverdatabases.removeSuccess' => 'Выбранные серверы баз данных успешно удалены.',

    'logbrowser.issuesFoundInTheLogs' => 'В журналах сайта обнаружены проблемы',
    'logbrowser.learnAboutProblemsFaster' => 'Быстрее выявляйте проблемы с сайтом',
    'logbrowser.noProblemsFound' => 'В журналах сайта не обнаружено проблем',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%% проверка журналов выявила проблемы, которые могут повлиять на работу вашего сайта. Чтобы увидеть подробности и возможные решения, нажмите "Открыть отчет о проверке".',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%% проверка журнала не выявила проблем, которые могут повлиять на работу вашего сайта.',
    'logbrowser.noChecksResults' => 'Автоматическая ежедневная проверка включена, но проверки не проводились.',
    'logbrowser.manual' => 'Ручная',
    'logbrowser.regular' => 'Автоматическая ежедневная',
    'logbrowser.enableRegularCheck' => 'Ежедневная проверка журналов выявляет проблемы, которые могут повлиять на работу вашего сайта. Если возникнут какие-либо проблемы, Plesk сообщит вам об этом и предложит возможные решения.',
    'logbrowser.new' => 'НОВИНКА',
    'logbrowser.openCheckReport' => 'Открыть отчет о проверке',
    'logbrowser.openCheckSettings' => 'Открыть настройки проверки',

    'logbrowser.buttonStartRealtime' => 'Начать обновления в режиме реального времени',
    'logbrowser.buttonStartRealtimeHint' => 'Обновлять данные журнала в режиме реального времени.',
    'logbrowser.buttonStopRealtime' => 'Прекратить обновления в режиме реального времени',
    'logbrowser.buttonStopRealtimeHint' => 'Прекратить обновление данных журнала в режиме реального времени.',
    'logbrowser.buttonRefresh' => 'Обновить',
    'logbrowser.buttonRefreshHint' => 'Обновить данные журнала.',
    'logbrowser.buttonClear' => 'Очистить',
    'logbrowser.buttonClearHint' => 'Скрыть уже загруженные объекты.',
    'logbrowser.buttonAddCustom' => 'Добавить в браузер журналов как персональный файл',
    'logbrowser.buttonAddCustomHint' => 'Этот файл будет показываться в браузере журналов вместе с другими файлами журналов.',
    'logbrowser.date' => 'Дата',
    'logbrowser.dateFilterPlaceholder' => 'От',
    'logbrowser.type' => 'Тип',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Код',
    'logbrowser.codeFilterPlaceholder' => 'Код',
    'logbrowser.message' => 'Сообщение',
    'logbrowser.messageFilterPlaceholder' => 'Сообщение',
    'logbrowser.source' => 'Исходный сервер',
    'logbrowser.sourceFilterFiles' => '%%count%% файлов',
    'logbrowser.sourceFilterAllLogs' => 'Все журналы',
    'logbrowser.sourceFilterNoLogs' => 'Нет журналов',
    'logbrowser.manageLogFiles' => 'Управление журналами',
    'logbrowser.addCustomLogFile' => 'Добавить персональный журнал',
    'logbrowser.customLogPopupTitle' => 'Добавить персональный журнал',
    'logbrowser.invalidLogFormat' => 'Формат файла журнала не поддерживается',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Реферер',
    'logbrowser.agent' => 'Агент',
    'logbrowser.agentHint' => 'Агент пользователя',
    'logbrowser.size' => 'Размер',
    'logbrowser.unknown' => 'Неизвестно',
    'logbrowser.more' => 'Еще ',
    'logbrowser.less' => ' Меньше',
    'logbrowser.any' => 'Все',
    'logbrowser.none' => 'Нет',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% или использовать фильтры для выбора из списка записей.',
    'logbrowser.loadMore' => 'Загрузить предыдущие записи',
    'logbrowser.clear' => 'Очистить',
    'logbrowser.hourAgo' => 'Час назад',
    'logbrowser.prevDay' => 'День назад',
    'logbrowser.linkInMessageToViewFile' => 'Нажмите для просмотра файла.',
    'logbrowser.buttonUnlinkHint' => 'Нажмите, чтобы прекратить отслеживать обновления этого файла в браузере журналов',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Вы уверены, что хотите прекратить отслеживать обновления этого файла в браузере журналов?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Да',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Нет',
    'logbrowser.logRotation' => 'Ротация журналов',
    'logbrowser.logRotationHint' => 'Задайте настройки ротации журнала для сайта.',
    'logbrowser.logRotationTitle' => 'Настройки ротации журналов',

    'notifications.title' => 'Настройка уведомлений о системных событиях',
    'notifications.legendNotifications' => 'Уведомления',
    'notifications.legendSettings' => 'Настройки',
    'notifications.headerEvent' => 'Событие',
    'notifications.headerSendTo' => 'Получатель уведомления:',
    'notifications.headerText' => 'Текст',
    'notifications.headerPreview' => 'Предпросмотр',
    'notifications.headerAdmin' => 'Администратор',
    'notifications.headerReseller' => 'Реселлер',
    'notifications.headerClient' => 'Клиент',
    'notifications.headerEmailAddress' => 'Адрес электронной почты',
    'notifications.expirationTime' => 'Отправлять предупреждения об истечении срока за',
    'notifications.days' => ' дней',
    'notifications.smtpSettings' => 'Чтобы включить отправку уведомлений Plesk при закрытом релее, вы можете %%link%%',
    'notifications.smtpSettingsLink' => 'изменить настройки SMTP',
    'notifications.editHint' => 'Редактировать текст уведомления.',
    'notifications.previewHint' => 'Посмотрите, как будут выглядеть уведомления в письмах.',
    'notifications.reseller_creation' => 'Создан новый реселлер',
    'notifications.reseller_limits_exceed' => 'Реселлер превысил ограничения на ресурсы',
    'notifications.reseller_blocked' => 'Учетная запись реселлера приостановлена за перерасход ресурсов',
    'notifications.reseller_overuse_block' => 'Подписка реселлера пыталась использовать больше ресурсов, чем доступно реселлеру',
    'notifications.client_creation' => 'Создан новый клиент',
    'notifications.domain_creation' => 'Создан новый сайт',
    'notifications.domain_exp_warning' => 'Заканчивается срок действия подписки',
    'notifications.domain_expiration' => 'Закончился срок действия подписки',
    'notifications.domain_limits_exceed' => 'Подписка превысила ограничения на ресурсы',
    'notifications.domain_blocked' => 'Подписка приостановлена из-за перерасхода ресурсов',
    'notifications.admin_aps_app_updates' => 'Доступны обновления к APS-приложениям (дайджест администратора)',
    'notifications.reseller_aps_app_updates' => 'Доступны обновления к APS-приложениям (дайджест реселлера)',
    'notifications.client_aps_app_updates' => 'Доступны обновления к APS-приложениям (дайджест клиента)',
    'notifications.admin_pum_updates' => 'Системные обновления: уведомления о новых обновлениях',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Превышены ограничения на исходящую почту',
    'notifications.subscription_cgroups_limits_exceed' => 'Память, процессор, ввод-вывод диска (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Напоминание оставить отзыв',
    'notifications.errorInvalidEmail' => 'Неверный адрес электронной почты.',
    'notifications.errorInvalidExpTime' => 'Недопустимое количество дней.',
    'notifications.errorUpdate' => 'Не удалось обновить уведомление: %%error%%',
    'notifications.updated' => 'Настройки уведомлений обновлены',

    'outgoingmail.name' => 'Имя',
    'outgoingmail.maxOutgoingMessages' => 'Ограничение в час',
    'outgoingmail.numOfExceedingAttempts' => 'Попытки сверх ограничения',
    'outgoingmail.lastAttemptAt' => 'Последняя попытка',
    'outgoingmail.mailStatus' => 'Состояние почты',
    'outgoingmail.mailStatusSending' => 'Отправляется',
    'outgoingmail.mailStatusNotSending' => 'Не отправляется',
    'outgoingmail.mailStatusSendingDesc' => 'Почта отправляется.',
    'outgoingmail.mailStatusNotSendingDesc' => 'Почта не отправляется.',
    'outgoingmail.limitValueUnlimited' => 'Без ограничений',

    'scheduler.tasks.headerCommand' => 'Команда',
    'scheduler.tasks.headerSchedule' => 'Расписание',
    'scheduler.tasks.headerSubscription' => 'Подписка',
    'scheduler.tasks.headerSubscription_powerUser' => 'Веб-пространство',
    'scheduler.tasks.buttonToggleHintOn' => 'Задача включена. Нажмите, чтобы выключить задачу.',
    'scheduler.tasks.buttonToggleHintOff' => 'Задача выключена. Нажмите, чтобы включить задачу.',
    'scheduler.tasks.add' => 'Добавить задачу',
    'scheduler.tasks.hintAdd' => 'Запланировать новую задачу.',
    'scheduler.tasks.remove' => 'Удалить',
    'scheduler.tasks.hintRemove' => 'Удалить выбранные задачи.',
    'scheduler.tasks.confirmOnDelete' => 'Удалить выбранные задачи?',
    'scheduler.tasks.sync' => 'Обновить',
    'scheduler.tasks.hintSync' => 'Обновить список задач.',
    'scheduler.tasks.settings' => 'Настройки',
    'scheduler.tasks.hintSettings' => 'Изменить настройки планировщика задач.',
    'scheduler.tasks.deleteSuccess' => 'Запланированные задачи были удалены.',
    'scheduler.tasks.serverTask' => 'сервер (user:%%user%%)',
    'scheduler.tasks.unknownUser' => 'неизвестно',
    'scheduler.tasks.runTaskNow' => 'Запустить',
    'scheduler.tasks.runTaskNowHint' => 'Запустить задачу сейчас.',
    'scheduler.tasks.runningTask' => 'Запускается задача "%%task%%"...',

    'server-components.bcTitle' => 'Серверные компоненты',
    'server-components.title' => 'Компоненты Plesk',
    'server-components.name' => 'Название компонента',
    'server-components.version' => 'Версия компонента',
    'server-components.refresh' => 'Обновить',
    'server-components.componentName' => 'Введите название компонента Plesk...',
    'server-components.noComponents' => 'Компонентов не найдено',
    'server-components.componentsListUpdated' => 'Список компонентов обновлен',

    'server-components.componentName.urlrewrite' => 'URL Rewrite',
    'server-components.componentName.dbconnector' => "Средство подключения к базе данных",
    'server-components.componentName.mysqlserver' => 'Сервер MySQL',
    'server-components.componentName.troubleshooting' => 'Устранение неисправностей',
    'server-components.componentName.waf' => 'Брандмауэр для веб-приложений',
    'server-components.componentName.vcs' => 'Система контроля версий',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Инициализация приложения",
    'server-components.componentName.httpcompression' => 'Сжатие содержимого HTTP',
    'server-components.componentName.antivirus' => "Антивирус",
    'server-components.componentName.database' => "Сервер SQL",
    'server-components.componentName.sqladmin' => "MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MySQL Webadmin",
    'server-components.componentName.dnsserver' => "Сервер DNS",
    'server-components.componentName.firewall' => "Брандмауэр",
    'server-components.componentName.ftpserver' => "Сервер FTP",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "Почтовый сервер",
    'server-components.componentName.local_mailserver' => "Локальный почтовый сервер",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Веб-скрипты",
    'server-components.componentName.spamfilter' => "Антиспам",
    'server-components.componentName.stats' => "Веб-статистика",
    'server-components.componentName.stunnel' => "Оболочка SSL/TLS",
    'server-components.componentName.webmail' => "Веб-почта",
    'server-components.componentName.webpublish' => "Веб-публикация",
    'server-components.componentName.webserver' => "Веб-сервер",
    'server-components.componentName.network' => 'Сеть',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Хостинг Plesk",
    'server-components.componentName.savi' => 'Интерфейс антивируса Sophos',

    'server-components.tooltip.disabled' => 'Отключить',
    'server-components.tooltip.active' => 'Активен',
    'server-components.tooltip.notConfigured' => 'Не настроено',
    'server-components.tooltip.notStarted' => 'Не запущен, проверьте настройки компонента',

    'server-components.defaultComponents.circularDependencies' => "Обнаружены циклические зависимости между категориями %%cat1%% и %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(не установлен)",
    'server-components.defaultComponents.not_configured' => "(не настроен)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Некоторые категории сервисов содержат некорректный выбор, либо выбор не сделан.",
    'server-components.defaultComponents.depends_on' => "(требуется %%name%%)",
    'server-components.defaultComponents.not_activated' => 'компонент не активирован',
    'server-components.defaultComponents.imap_required' => '(Текущий почтовый сервер не поддерживает IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP-сервер не поддерживает IPv6-адреса.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(необходимое правило делегирования \'appPoolPipeline, appPoolNetFx\' не существует)',
    'server-components.defaultComponents.not_supported_version' => '(версия не поддерживается)',
    'server-components.defaultComponents.no_license' => '(не разрешено лицензионным ключом)',
    'server-components.defaultComponents.license_expired' => '(лицензионный ключ истек)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(превышен лимит почтовых ящиков с лицензионными ключами)',
    'server-components.defaultComponents.title' => 'Выбрать компонент %%name%% по умолчанию',
    'server-components.defaultComponents.none' => 'Нет',
    'server-components.defaultComponents.yes' => 'Да',
    'server-components.defaultComponents.no' => 'Нет',
    'server-components.defaultComponents.warning' => 'Внимание!',
    'server-components.defaultComponents.parametersOfComponent' => 'Параметры %%component%%',
    'server-components.defaultComponents.success' => 'Компонент по умолчанию обновлен',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Операция смены почтового сервера предназначена только для первоначальной настройки системы и, в случае изменения уже работающего почтового сервера, приведет к потере настроек и содержимого почтовых ящиков, а также, если новый сервер уже сконфигурирован — к различным конфликтам.\nЕсли текущий сервер используется и вы уверены, что хотите переключиться на другой, вы можете уведомить своих клиентов о предстоящей операции с тем, чтобы они имели возможность загрузить и сохранить свою почту.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Только первые 254 IP-адреса подсетей с масками /8 и /16, находящиеся в ACL, будут перенесены. Они будут перенесены как отдельные IP-адреса. Вы хотите продолжить?",

    'server-components.componentConf.title' => 'Параметры %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Необходим параметр',
    'server-components.componentConf.parameterShouldBeNumber' => 'Параметр должен быть числом',
    'server-components.componentConf.success' => 'Параметры обновлены',

    'spam-filter.groupAdd' => 'Добавить',
    'spam-filter.buttonAdd' => 'Добавить домен',
    'spam-filter.buttonAddAddress' => 'Добавить адрес',
    'spam-filter.buttonAddToBlackListHint' => 'Добавить домен в черный список',
    'spam-filter.buttonAddToWhiteListHint' => 'Добавить домен в белый список',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Добавить адрес в черный список',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Добавить адрес в белый список',
    'spam-filter.groupActions' => 'Действия',
    'spam-filter.buttonRemove' => 'Удалить',
    'spam-filter.entries' => 'Записи',
    'spam-filter.removeEmptySelection' => 'Не выбрано записей.',
    'spam-filter.removeConfirmation' => 'Удалить {count, plural, =1 {запись {name}} one {# выбранную запись} few {# выбранные записи} many {# выбранных записей} other {# выбранных записей}}?',
    'spam-filter.removeSuccess' => 'Выбранные записи были удалены.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'List of known spam addresses',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'List of trusted addresses',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'Mail from email addresses on this list is treated as spam.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'Mail from email addresses on this list skips the spam filter.',

    'tasks.pollingOff' => 'Выкл.',
    'tasks.pollingDelay' => '%%delay%% сек.',
    'tasks.stopTaskConfirm' => 'Вы точно хотите остановить задачу?',
    'tasks.stopTaskError' => 'Не удалось остановить задачу',
    'tasks.stopTask' => 'Остановить задачу',
    'tasks.processedLoadFailed' => 'Не удалось загрузить список процессов',
    'tasks.retryTask' => 'Повторить задачу',
    'tasks.retryTaskFailed' => 'Не удалось повторить задачу',
    'tasks.taskCreated' => 'Новая задача успешно создана',
    'tasks.moreDetails' => 'Смотрите подробности в журнале панели',
    'tasks.searchTitle' => 'Поиск',
    'tasks.searchPlaceholder' => 'Строка поиска',
    'tasks.refresh' => 'Обновить',
    'tasks.refreshDescription' => 'Обновить список задач',
    'tasks.createTask' => 'Создать задачу',
    'tasks.openSwagger' => 'Открыть Swagger',
    'tasks.statusTitle' => 'Статус',
    'tasks.createdTitle' => 'Создано',
    'tasks.descriptionTitle' => 'Описание',
    'tasks.processes.dataLoadFailed' => 'Не удалось получить данные с сервера',
    'tasks.processes.commandLineLoadFailed' => 'Не удалось получить командную строку задачи',
    'tasks.processes.stopProcess' => 'Остановить процесс',
    'tasks.processes.stopProcessFailed' => 'Не удалось остановить процесс',
    'tasks.processes.stopProcessConfirm' => 'Вы точно хотите остановить процесс?',
    'tasks.processes.copyToClipboard' => 'Скопировать в буфер обмена',
    'tasks.processes.concurrency' => 'Параллельная обработка',
    'tasks.processes.taskIdSection' => 'ID задачи',
    'tasks.processes.requestorIdSection' => 'ID инициатора запроса',
    'tasks.processes.timeoutSection' => 'Timeout',
    'tasks.processes.createdSection' => 'Создано',
    'tasks.processes.updatedSection' => 'Обновлено',
    'tasks.processes.environmentSection' => 'Окружение',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Статус',
    'tasks.processes.startedTitle' => 'Запущено',
    'tasks.processes.completedTitle' => 'Завершено',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Код выхода',

    'ts-sessions.columnStateTitle' => 'Статус',
    'ts-sessions.columnUserTitle' => 'Пользователь',
    'ts-sessions.columnNameTitle' => 'Имя',
    'ts-sessions.refresh' => 'Обновить',
    'ts-sessions.logoff' => 'Выйти',
    'ts-sessions.logoffConfirmation' => 'Завершить сеансы: %%count%%?',
    'ts-sessions.logoffConfirmationSingle' => 'Завершить сеанс %%name%%?',
    'ts-sessions.logoffConfirmationButton' => 'Да, выйти',
    'ts-sessions.logoffNoSelection' => 'Выберите один или несколько сеансов для выхода',
    'ts-sessions.logoffSuccess' => 'Выбранные сеансы завершены.',
    'ts-sessions.disconnect' => 'Отключить',
    'ts-sessions.disconnectConfirmation' => 'Отключить сеансы: %%count%%?',
    'ts-sessions.disconnectConfirmationSingle' => 'Отключить сеанс %%name%%?',
    'ts-sessions.disconnectConfirmationButton' => 'Да, отключить',
    'ts-sessions.disconnectSuccess' => 'Выбранные сеансы отключены.',
    'ts-sessions.disconnectNoSelection' => 'Выберите один или несколько сеансов для отключения',
    'ts-sessions.disconnectNotAvailable' => 'Отключить можно только активные или подключенные сеансы.',

    'client-ip-address.title' => 'IP-адреса',
    'client-ip-address.status' => 'Статус',
    'client-ip-address.type' => 'Тип',
    'client-ip-address.ipAddress' => 'IP-адрес',
    'client-ip-address.certificate' => 'Сертификат',
    'client-ip-address.hosting' => 'Хостинг',
    'client-ip-address.adminCertificateRepository' => "Репозиторий администратора",
    'client-ip-address.domainCertificateRepository' => 'Репозиторий домена %%owner%%',
    'client-ip-address.typeShared' => 'Общие',
    'client-ip-address.typeExclusive' => 'Выделенный',
    'client-ip-address.removeConfirmation' => 'Удалить {count, plural, =1 {IP-адрес {name}} one {# выбранный IP-адрес} few {# выбранных IP-адреса} many {# выбранных IP-адресов} other {# выбранных IP-адресов}} из пула IP-адресов пользователя?',
    'client-ip-address.noItemsToRemove' => 'Выберите один или несколько элементов для удаления.',
    'client-ip-address.ftpOverSSL' => 'FTP через SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Да',
    'client-ip-address.ftpOverSSL-no' => 'Нет',
    'client-ip-address.ftpOverSSL-allow' => 'Разрешить',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Запрещено',
    'client-ip-address.add' => 'Добавить IP-адрес',
    'client-ip-address.noAvailableIps' => 'Нет доступных IP-адресов.',
    'client-ip-address.isOk' => 'IP-адрес функционирует исправно.',
    'client-ip-address.isBroken' => 'IP-адрес отсутствует на интерфейсе.',
    'client-ip-address.properties.title' => 'IP-адрес %%address%% в интерфейсе %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP-адрес поставлен как',
    'client-ip-address.properties.allocatedType' => 'IP-адрес выделен как',
    'client-ip-address.properties.none' => 'Нет',
    'client-ip-address.properties.certificate' => 'SSL/TLS-сертификат',
    'client-ip-address.properties.defaultSite' => 'Сайт по умолчанию',
    'client-ip-address.assign.title' => 'Выберите IP-адреса.',
    'client-ip-address.assign.description' => 'Свободные IP-адреса',
    'client-ip-address.assign.success' => '{count, plural, =1 {IP-адрес {name}} one {# выбранный IP-адрес} few {# выбранных IP-адреса} many {# выбранных IP-адресов} other {# выбранных IP-адресов}} успешно добавили в пул IP-адресов пользователя',

    'ip-address-reseller-usage.title' => 'Реселлеры, использующие %%type%% IP-адрес %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Реселлеры',
    'ip-address-reseller-usage.assignButton' => 'Назначить реселлеру',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Данный IP-адрес уже назначен всем пользователям.',
    'ip-address-reseller-usage.removeButton' => 'Удалить',
    'ip-address-reseller-usage.removeSuccess' => 'IP-адрес удален из {count, plural, =1 {пула {name}} one {# выбранного IP-пула реселлера} few {# выбранных IP-пулов реселлеров} many {# выбранных IP-пулов реселлеров} other {# выбранных IP-пулов реселлеров}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Удалить IP-адрес из {count, plural, =1 {IP-пула {name}} one {# выбранного IP-пула реселлеров} few {# выбранных IP-пулов реселлеров} many {# выбранных IP-пулов реселлеров} other {# выбранных IP-пулов реселлеров}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Общие',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Выделенный',
    'ip-address-reseller-usage.assign.title' => "Добавить %%ipAddress%% в IP-пул реселлера",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Реселлеры для добавления',
    'ip-address-reseller-usage.assign.success' => 'IP-адрес добавлен в {count, plural, =1 {IP-пул {name}} one {# выбранного IP-пула реселлера} few {# выбранных IP-пула реселлеров} many {# выбранных IP-пулов реселлеров} other {# выбранных IP-пулов реселлеров}}.'
];