<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Proprietà della chiave addizionale',
    'additional-key-info.update' => 'Recupera chiave addizionale',
    'additional-key-info.updateDescription' => 'Recupera le chiavi addizionali e installale.',
    'additional-key-info.download' => 'Download Chiave di licenza',
    'additional-key-info.downloadDescription' => 'Scarica la chiave di licenza attuale.',
    'additional-key-info.install' => 'Installa Chiave',
    'additional-key-info.installDescription' => 'Installa la chiave di licenza attuale.',
    'additional-key-info.revert' => 'Riattiva vecchia chiave',
    'additional-key-info.revertDescription' => 'Riutilizza la chiave di licenza precedente.',
    'additional-key-info.revertNotAvailableDescription' => 'Nessuna chiave installata.',
    'additional-key-info.installSuccess' => 'La procedura d\'installazione della chiave di licenza è stata inizializzata.',

    'additional-key-revert.title' => 'Ripristino chiave precedente addizionale',
    'additional-key-revert.success' => 'Ripristino chiave precedente addizionale riuscito.',

    'additional-key-upload.title' => 'Installa una chiave di licenza',
    'additional-key-upload.success' => 'È stata caricata la nuova chiave addizionale.',

    'additional-keys.title' => 'Chiavi di licenza addizionali',

    'change-owner.title' => 'Assegna di nuovo gli abbonamenti selezionati',

    'customers.hint' => 'In questa sezione è possibile gestire gli account dei tuoi clienti di servizi di hosting: crea account insieme agli abbonamenti di servizi, gestisci i clienti esistenti e rimuovi account. Per amministrare siti web, la posta e qualsiasi altro servizio fornito a un cliente, vai sul Pannello del Cliente facendo clic sul link nella colonna a destra nell\'elenco.',

    'customer-domains.hint' => 'Qui è possibile impostare e gestire siti web.',

    'customer-subscriptions.hint' => 'In questa sezione è possibile gestire gli abbonamenti del cliente.',

    'domains.hint' => 'Questa sezione ti permette di visualizzare le informazioni su tutti i nomi di dominio registrati nel sistema e procedere alla gestione dei servizi di hosting. Per aggiungere un dominio per utilizzo personale o per i clienti di hosting, fai clic su Aggiungi dominio. Durante la creazione di un dominio, ti verrà richiesto di creare un nuovo cliente e un nuovo abbonamento, o di selezionarne uno tra quelli esistenti.',

    'database-servers.title' => 'Server Database',

    'database-server-create.title' => 'Nuovo server database',

    'database-server-properties.title' => 'Server database',

    'database-server-upgrade.title' => 'Aggiornamento del server database',
    'database-server-upgrade.currentVersion' => 'Versione attuale',
    'database-server-upgrade.selectVersion' => 'Seleziona versione',
    'database-server-upgrade.noMajorReleases' => 'Non ci sono nuovi rilasci più consistenti',
    'database-server-upgrade.information' => 'Informazione',
    'database-server-upgrade.releaseNotes' => 'Note di release',
    'database-server-upgrade.releaseDate' => 'Data di rilascio',
    'database-server-upgrade.unable' => 'Impossibile effettuare l\'aggiornamento',
    'database-server-upgrade.endOfLifeDate' => 'Data End of Life',
    'database-server-upgrade.withDump' => 'Effettua il dump dei database prima di aggiornare',
    'database-server-upgrade.withDumpDescription' => 'Prima di avviare la procedura di aggiornamento, verranno creati dei dump di tutti i database ospitati sul server.',
    'database-server-upgrade.preUpgradeCheckers' => 'Presta attenzione alle seguenti informazioni',
    'database-server-upgrade.preUpgradeCheckersDescription' => 'Sono stati individuati degli errori. Seleziona tutte le caselle di controllo di seguito per confermare che hai compreso e desideri proseguire con l\'aggiornamento.',
    'database-server-upgrade.preUpgradeCheckerShouldBeConfirmed' => 'Seleziona tutte le caselle di controllo prima di procedere con l\'aggiornamento.',
    'database-server-upgrade.preUpgradeCheckerNotDetected' => 'È possibile aggiornare solamente fork di MariaDB inviati da produttori OS o produttori MariaDB.',
    'database-server-upgrade.sshAccess' => 'Assicurati di avere accesso SSH al server',
    'database-server-upgrade.sshAccessDescription' => 'Utilizza un client SSH o apri l\'estensione %%sshTerminalExtension%% in una nuova scheda del browser (non chiudere la finestra dell\'estensione del terminale SSH prima del termine dell\'aggiornamento). Se l\'aggiornamento non riesce, l\'accesso SSH contribuirà al recupero.',
    'database-server-upgrade.sshTerminalExtension' => 'Estensione terminale SSH',
    'database-server-upgrade.repairKitAccess' => 'Assicurati di avere accesso a Repair Kit',
    'database-server-upgrade.repairKitAccessDescription' => 'Apri %%repairKit%% in una nuova scheda del browser, quindi effettua l\'accesso usando le credenziali da amministratore. Non chiudere la finestra dell\'estensione Repair Kit prima del termine dell\'aggiornamento.',
    'database-server-upgrade.repairKit' => 'Repair Kit',
    'database-server-upgrade.troubleshootingArticle' => 'Articolo della KB',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Utilizza il nostro %%troubleshootingArticle%% per risolvere i problemi di aggiornamento di MariaDB.',
    'database-server-upgrade.removedSystemVariables' => 'Le seguenti variabili verranno rimosse per motivi di compatibilità con la nuova versione:',
    'database-server-upgrade.webSocketNotAvailable' => 'WebSocket non è disponibile in Plesk',
    'database-server-upgrade.webSocketNotAvailableDescription' => 'Senza WebSocket, non potrai seguire in tempo reale l\'output della procedura di aggiornamento.',
    'database-server-upgrade.checkConsistency' => 'Report strumento mariadb-check',
    'database-server-upgrade.checkConsistencyDescription' => 'Lo strumento mariadb-check ha individuato uno o più problemi.',
    'database-server-upgrade.chooseReleaseStep' => '1° passaggio: versioni disponibili',
    'database-server-upgrade.preUpgradeStep' => '2° passaggio: verifiche pre-aggiornamento',
    'database-server-upgrade.upgradeStep' => '3° passaggio: aggiornamento',
    'database-server-upgrade.fromFiles' => '{variable} {count, plural, one {dal file {files}} other {dai # file: {files}}}',
    'database-server-upgrade.description' => 'MySQL/MariaDB è un sistema di gestione di database relazionali molto utilizzato, che costituisce uno dei servizi principali sulla maggior parte dei sistemi Plesk. L\'interfaccia ti consente di aggiornare il tuo server MySQL/MariaDB alla versione 10.11. Plesk aggiornerà automaticamente l\'installazione di MySQL/MariaDB ai rilasci più recenti (la terza cifra nella stringa della versione), perché questi aggiornamenti non implicano rischi notevoli per i dati degli utenti. Gli aggiornamenti ai nuovi rilasci più consistenti (le prime due cifre nella stringa della versione) prevedono invece un maggiore coinvolgimento, in quanto implicano un rischio sostanziale di perdite di dati. L\'interfaccia è pensata per illustrarti la procedura di aggiornamento per i rilasci più importanti.',
    'database-server-upgrade.warning' => 'Anche se gli aggiornamenti in loco sono solitamente sicuri, ti consigliamo fortemente di effettuare un backup completo del database prima dell\'aggiornamento. Non supportiamo il downgrade a versioni precedenti: dopo aver aggiornato il server database, potrebbe non essere possibile tornare a una versione precedente. La sostituzione di MariaDB con MySQL 8 è considerata un downgrade e non è supportata.',

    'database-server-databases.title' => 'Database',

    'database-server-change-password.title' => 'Password dell\'amministratore',

    'home.title' => 'Home',

    'license.title' => 'Informazioni sulla licenza',

    'primary-key-info.title' => 'Chiave di licenza Plesk',
    'primary-key-info.update' => 'Recupera le chiavi',
    'primary-key-info.updateDescription' => 'Recupera le chiavi di licenza ordinate ed installale.',
    'primary-key-info.upload' => 'Installa Chiave',
    'primary-key-info.uploadDescription' => 'Carica e installa una nuova chiave di licenza.',
    'primary-key-info.revert' => 'Riattiva vecchia chiave',
    'primary-key-info.revertDescription' => 'Riutilizza la chiave di licenza precedente.',

    'primary-key-revert.title' => 'Chiave di licenza precedente',
    'primary-key-revert.success' => 'Ripristino chiave Plesk precedente riuscito.',

    'primary-key-upload.title' => 'Installa una chiave di licenza',
    'primary-key-upload.success' => 'È stata caricata la nuova chiave Plesk.',

    'resellers.hint' => 'Questa sezione ti permette di gestire gli account dei rivenditori, ossia i tuoi clienti che rivendono i servizi di hosting e ospitano i loro siti web. Qui potrai creare account e abbonamenti ai servizi, gestire i rivenditori esistenti e rimuovere account.',

    'reseller-customers.hint' => 'Questa sezione ti permette di configurare e gestire i clienti.',

    'reseller-domains.hint' => 'Qui è possibile impostare e gestire siti web.',

    'reseller-subscriptions.hint' => 'Questa sezione ti permette di gestire gli abbonamenti del rivenditore.',

    'subscriptions.hint' => 'I clienti ottengono i servizi di hosting da te forniti grazie alla sottoscrizione di un abbonamento a un piano di hosting. Questa sezione ti permette di gestire tali abbonamenti, nonché quelli creati da te per ospitare i tuoi siti web. Per amministrare i siti web, la posta o qualsiasi altro servizio fornito con un abbonamento, vai al Pannello del Cliente dell\'abbonato facendo clic sulla colonna a destra nell\'elenco.',

    'server-mail-settings.title' => 'Impostazioni',
    'server-mail-spam-filter.title' => 'Filtraggio dello spam',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Lista Nera',
    'server-mail-white-list.title' => 'Lista Bianca',
    'server-mail-queue.title' => 'Coda messaggi',
    'server-mail-statistics.title' => 'Statistiche',

    'server-spam-filter.title' => 'Impostazioni del filtro antispam',
    'server-spam-filter.settings' => 'Impostazioni',
    'server-spam-filter.black-list' => 'Lista nera',
    'server-spam-filter.white-list' => 'Lista bianca',

    'firewall.title' => 'Gestione del firewall',
    'firewall-general.title' => 'Generale',
    'firewall-general.toggleStatus' => 'Protezione del firewall',
    'firewall-general.buttonDefault' => 'Reimposta a predefinito',
    'firewall-general.buttonPanic' => 'Panico',
    'firewall-general.confirmationDefault' => 'Vuoi ripristinare le impostazioni predefinite del firewall?',
    'firewall-general.confirmationPanic' => 'Vuoi attivare la modalità Panico? Gli utenti non potranno accedere ai loro domini e alcuni servizi di rete potrebbero smettere di funzionare.',
    'firewall-general.successDefault' => 'Il firewall è tornato alle impostazioni di fabbrica.',
    'firewall-general.successPanic' => 'La modalità Panico è stata attivata.',
    'firewall-general.info' => 'Per ragioni di sicurezza, il firewall blocca tutte le connessioni tranne quelle esplicitamente consentite. Puoi consentire una connessione creando una regola. Per maggiori informazioni consulta la documentazione',
    'firewall-general.interfaces' => 'Interfacce di rete',
    'firewall-icmp.title' => 'Protocollo ICMP',
    'firewall-rules.title' => 'Regole del Firewall',

    'dns.title' => 'Impostazioni DNS',
    'dns-records.title' => 'Modello di record di zona',
    'dns-soa-record.title' => 'Template di impostazione della zona',

    'php-handler.title' => 'Impostazioni per %%name%%',
    'php-handler.extensions.title' => 'Estensioni',
    'php-handler.extensions.description' => 'Le impostazioni di queste estensioni PHP sono unicamente per questo gestore.',
    'php-handler.extensions.descriptionShared' => 'Queste impostazioni sono comuni ai seguenti gestori PHP: %%handlers%%. Le impostazioni vengono applicate a tutti i siti web che usano questi gestori.',
    'php-handler.extensions.buttonManage' => 'Gestire pacchetti PECL',
    'php-handler.extensions.manage.title' => 'Gestire pacchetti PECL',
    'php-handler.extensions.manage.risks' => 'Le estensioni PHP sono fornite da pacchetti PECL di terze parti. Installali a tuo rischio e pericolo.',
    'php-handler.extensions.manage.description' => 'Installa, aggiorna e disinstalla pacchetti PECL. I cambiamenti verranno applicati a tutti i siti Web in esecuzione su %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Perché il pacchetto desiderato non è sulla lista?',
    'php-handler.extensions.manage.limitations' => 'Le estensioni PHP fornite dal pannello di controllo del provider e dai produttori di sistemi operativi non sono mostrate sulla lista.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Informazioni sul server",
    'ServerInformation.refresh' => "Aggiorna",
    'ServerInformation.sectionGeneral' => "Generale",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versione",
    'ServerInformation.os' => "Sistemi operativi",
    'ServerInformation.key' => "Chiave di licenza Plesk",
    'ServerInformation.uptime' => "Tempo di attività",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# giorno} other {# giorni}} {hours, plural, one {# ora} other {# ore}} {minutes, plural, one {# minuto} other {# minuti}}",
    'ServerInformation.sectionCpu' => "Uso della CPU",
    'ServerInformation.la1min' => "Ultimo minuto",
    'ServerInformation.la5min' => "Ultimi 5 minuti",
    'ServerInformation.la15min' => "Ultimi 15 minuti",
    'ServerInformation.sectionMemory' => "Utilizzo memoria",
    'ServerInformation.memoryTotal' => "Totale",
    'ServerInformation.memoryUsed' => "Usato",
    'ServerInformation.memoryFree' => "Gratis",
    'ServerInformation.memoryShared' => "Condivisi",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cached",
    'ServerInformation.memoryAvailable' => "Disponibile",
    'ServerInformation.memoryUsage' => "Utilizzo",
    'ServerInformation.sectionSwap' => "Utilizzo di Swap",
    'ServerInformation.sectionVirtualMemory' => "Utilizzo della memoria virtuale",
    'ServerInformation.swapTotal' => "Totale",
    'ServerInformation.swapUsed' => "Usato",
    'ServerInformation.swapFree' => "Gratis",
    'ServerInformation.swapUsage' => "Utilizzo",
    'ServerInformation.sectionHarddisk' => "Utilizzo dell'Hard Disk",
    'ServerInformation.harddiskDirectory' => "Sistema di file",
    'ServerInformation.harddiskProtectedDir' => "Directory protette",
    'ServerInformation.harddiskTotal' => "Totale",
    'ServerInformation.harddiskUsed' => "Usato",
    'ServerInformation.harddiskAvailable' => "Disponibile",
    'ServerInformation.harddiskCapacity' => "Capacità",
    'ServerInformation.sectionDomains' => "Domini",
    'ServerInformation.activeDomains' => "Attivo",
    'ServerInformation.inactiveDomains' => "Inattivo",
    'ServerInformation.problemDomains' => "Problemi",
    'ServerInformation.refreshed' => "Informazioni aggiornate.",

    'ServerAbout.title' => 'Informazioni su Plesk',
    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. Tutti i diritti riservati.',
    'ServerAbout.linkLicenseManagement' => 'Vai alle Informazioni sulla licenza',
    'ServerAbout.panelVersion' => 'Versione',
    'ServerAbout.installedPatchVersion' => 'Aggiorna #%%patch%%',
    'ServerAbout.licenseKey' => 'Chiave di licenza',
    'ServerAbout.productDescription' => 'Plesk è la piattaforma WebOps leader per eseguire, automatizzare e sviluppare applicazioni, siti web e attività di hosting.',
    'ServerAbout.readEula' => 'Leggi %%link%%.',
    'ServerAbout.linkEula' => 'Contratto di licenza per utenti finali',
    'ServerAbout.visitForum' => 'Visita %%link%%',
    'ServerAbout.linkForum' => 'Forum di Plesk',
    'ServerAbout.followUs' => 'Seguici',
    'ServerAbout.visitSite' => 'Maggiori informazioni all\'indirizzo %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Trova ispirazione in %%link%%',
    'ServerAbout.linkBlog' => 'Blog di Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Complimenti!',
    'ServerAbout.darkThemePromoDescription' => 'Hai trovato un magatto nella versione di anniversario di Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Abracadabra! Passa al lato oscuro',
    'ServerAbout.darkThemeTourDescription' => 'Usa questa opzione per attivare o disattivare il tema scuro dell\'interfaccia.',
    'ServerAbout.darkThemeTourButton' => 'OK',

    'ts-sessions.title' => 'Sessioni server terminale',
    'ts-sessions-properties.title' => 'Proprietà sessione',

    'BandwidthLimiting.title' => 'Limitazione di larghezza di banda per %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Non puoi controllare la larghezza di banda perché il servizio QoS non è installato.',
    'BandwidthLimiting.virtualHostingRequired' => 'La limitazione di larghezza di banda è disponibile solo per i domini con hosting web.',
    'BandwidthLimiting.bandwidthLabel' => 'Utilizzo massimo di larghezza di banda',
    'BandwidthLimiting.bandwidthHint' => 'Il limite sull\'utilizzo della larghezza di banda viene applicato solo ai dati trasferiti tramite il protocollo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Connessioni limitate a',
    'BandwidthLimiting.maxConnectionHint' => 'Se limiti la larghezza di banda, ti consigliamo di limitare anche il numero di connessioni simultanee al sito web. Altrimenti, in caso di richieste frequenti al sito, le elaborazioni del server web aumenteranno il carico del server.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Impostazioni della limitazione di larghezza di banda modificate.',
    'BandwidthLimiting.unlimited' => 'Illimitato',

    'ip-address-domains.title' => 'Siti web che usano %%type%% l\'indirizzo IP %%ipAddress%%',
    'ip-address-domains.site' => 'Sito',
    'ip-address-domains.setAsDefault' => 'Imposta come predefinito',
    'ip-address-domains.type-SHARED' => 'condiviso',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicato',

    'HotlinkProtection.title' => 'Protezione hotlink per %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'La protezione hotlink è disponibile solo per i domini con hosting web.',
    'HotlinkProtection.enabledLabel' => 'Abilita protezione hotlink',
    'HotlinkProtection.extensionsLabel' => 'Estensioni dei file protetti',
    'HotlinkProtection.friendsLabel' => 'Indirizzi di siti web attendibili',
    'HotlinkProtection.success' => 'Impostazioni protezione hotlink modificate.',

    'Odbc.serverTitle' => 'Connessioni ODBC DSN',
    'Odbc.domainTitle' => 'Connessioni DSN ODBC per %%domainName%%',
    'Odbc.add' => 'Aggiungi DSN ODBC',
    'Odbc.resourceUsage' => '%%used%% creato / %%allowed%% consentito.',
    'Odbc.limitExceeded' => 'Limite della connessione DSN ODBC superato.',
    'Odbc.unlimited' => 'Illimitato',
    'Odbc.addTooltip' => 'Aggiungi sorgente ODBC.',
    'Odbc.status' => 'Stato',
    'Odbc.name' => 'Nome connessione',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrizione della connessione',
    'Odbc.hostname' => 'Nome host',
    'Odbc.statusSystem' => 'Questo e\' un sistema DSN.',
    'Odbc.statusConfigured' => 'DSN configurato.',
    'Odbc.statusNotConfigured' => 'DSN non configurato.',
    'Odbc.noSelectionText' => 'Seleziona uno o più elementi da rimuovere.',
    'Odbc.removeConfirmation' => 'Rimuovere {count, plural, =1 {la connessione {name}} other {# connessioni selezionate}}?',
    'Odbc.removeSuccess' => 'Le connessioni selezionate sono state rimosse.',

    'DomainAliasSettings.title' => 'Impostazioni alias di dominio',
    'DomainAliasSettings.updateSuccess' => 'Le proprietà dell\'alias di dominio %%name%% sono state modificate. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Le impostazioni del sito web saranno applicate entro %%restartInterval%% minuti.',

    'HostingSettings.title' => 'Impostazioni di hosting',
    'HostingSettings.updateSuccess' => 'Impostazioni aggiornate.',
    'HostingSettings.emptyLogin' => 'È necessario specificare un nome utente.',
    'HostingSettings.emptyPassword' => 'È necessario specificare una password.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Il server FTP non supporta IPv6. Assegna almeno un indirizzo IPv4, altrimenti l\'utente non sarà in grado di caricare file nel server su FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Impostazioni del dominio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nome del dominio',
    'HostingSettings.domainSettingsSection.description' => 'Per esempio, example.com ',

    'HostingSettings.submitPopover.title' => 'Rimuovi il contenuto di %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Cambiare il tipo di hostind del "sito web" in "%%type%%" rimuoverà in modo permanente l\'intero contenuto del sito web, incluse le seguenti directory:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Vuoi cambiare il tipo di hosting del tuo sito web?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Per accedere a ulteriori impostazioni, inserisci le credenziali dell\'utente di sistema, quindi fai clic su "Crea spazio web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Per accedere a ulteriori impostazioni, fai clic su "Avanti" per creare l\'hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipologia di hosting',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Sito web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Inoltro',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Nessun hosting web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Usa la zona DNS del dominio per avere caselle di posta sotto questo nome di dominio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Il percorso alla home directory del sito web',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Dominio preferito',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'I visitatori verranno reindirizzati qui tramite un reindirizzamento HTTP 301 SEO-friendly.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Reindirizza i visitatori a',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipologia d\'inoltro',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Spostato permanentemente (codice 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Reindirizza i visitatori del sito web verso un altro sito e mostra loro l\'indirizzo di destinazione. Tale reindirizzamento conserverà il ranking del sito nei risultati di ricerca',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Spostato temporaneamente (codice 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Reindirizza i visitatori del sito web verso una copia del sito temporanea quando non vorrai che i motori di ricerca indicizzino il sito temporaneo.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Inoltro frame',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Reindirizza i visitatori del sito web verso un altro sito, senza mostrare l\'indirizzo di destinazione, in modo che non siano al corrente del reindirizzamento.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Dominio preferito',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nessuno',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Root del documento',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'È impossibile modificare la directory principale perché non sono presenti applicazioni web installate su questo sito web.',
    'HostingSettings.domainSettingsSection.save' => 'Salva',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Cambiare questa impostazione?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'La modifica di questa impostazione va in contrasto con le norme di sicurezza del server e può compromettere le prestazioni o rendere il server vulnerabile agli attacchi.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Cambia',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Ripristina',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Preset di impostazioni sicuro applicato',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Per una maggiore sicurezza, applica la preimpostazione per una configurazione protetta. Nota che alcuni permessi consentono agli iscritti di modificare queste impostazioni.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Applica la preimpostazione sicura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Informazioni sulle impostazioni di hosting protetto',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Supporto SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Abilitato',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Crittografa le connessioni tra il sito web e il browser del visitatore.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificato',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Per abilitare HTTPS, installa un certificato SSL/TLS nell\'archivio del dominio, poi selezionalo qui.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Reindirizza i visitatori da HTTP a HTTPS tramite un reindirizzamento 301 SEO-friendly',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Non ci sono certificati SSL/TLS nel tuo archivio. Per aggiungere un certificato, vai a %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'questa pagina',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (altro archivio)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Non selezionato',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Scripting web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Seleziona quale linguaggio di programmazione e scripting deve essere interpretato dal server web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'la directory cig-bin si trova in %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Usa SSI per i file *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versione di Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documenti di errore personalizzati',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'la directory cgi-bin si trova in',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'la directory principale di questo dominio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'la directory principale dello spazio web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'la radice precedente di questo dominio',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documenti di errore personalizzati',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permessi aggiuntivi di scrittura/modifica',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Pubblicazione implementazione web',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Statistiche web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Strumento',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteggi l\'accesso alle statistiche web con il proprio nome utente e password FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Disabilitato',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Impostazioni webspace',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Indirizzi IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Quota spazio su disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Abilitata',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Vieta le operazioni sui file del sito web se la quota di spazio su disco impostata nelle impostazioni dell\'abbonamento (se presente) viene superata.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'La quota del disco rigido non è supportata a causa della configurazione del file system del server.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenziali dell\'utente di sistema',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gestisci i file e le cartelle del sito web tramite FTP o Manager di File. Accedere al server tramite SSH, se consentito.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gestisci i file e le cartelle del sito web tramite FTP o Manager di File. Accedere al server tramite Desktop remoto, se consentito.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nome utente',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Password',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Indica qui una nuova password per modificare la password dell\'utente di sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Accesso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Accesso Desktop remoto',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Abilitato',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Accedi al server con le credenziali dell'utente di sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Disabilitato',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Per {count, plural, other {# domini}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Le seguenti impostazioni si applicano a {count, plural, other {# domini nello spazio web {name}}}:',

    'OdbcAdd.title' => 'Aggiungi un DSN ODBC',
    'OdbcAdd.nameLabel' => 'Nome connessione',
    'OdbcAdd.descriptionLabel' => 'Descrizione della connessione',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Crea DSN ODBC',

    'OdbcEdit.title' => 'Configura una connessione ODBC',
    'OdbcEdit.saveSuccess' => 'Le impostazioni della connessione sono state salvate.',
    'OdbcEdit.test' => 'Test connessione',
    'OdbcEdit.connectSuccess' => 'Connessione riuscita.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Percorso del file del database',
    'OdbcEdit.excel.defaultdir.label' => 'Directory dati predefinita',
    'OdbcEdit.excel.fil.label' => 'Versione del database',
    'OdbcEdit.excel.maxbuffersize.label' => 'Dimensione massima del buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Timeout della pagina',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Percorso del file del database',
    'OdbcEdit.access.uid.label' => 'ID Login',
    'OdbcEdit.access.pwd.label' => 'Password',
    'OdbcEdit.access.pagetimeout.label' => 'Timeout della pagina',
    'OdbcEdit.access.pagetimeout.description' => 'Il periodo di tempo, in decimi di secondo, durante il quale una pagina non utilizzata rimane nel buffer. Questa opzione si applica in tutte le sorgenti dati che utilizzano il driver di Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Dimensione massima del buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'La dimensione del buffer interno, in KB, allineato a multipli di 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Sola lettura',
    'OdbcEdit.access.readonly.description' => 'Designa il database come sola lettura per proibire qualsiasi aggiornamento.',
    'OdbcEdit.access.exclusive.label' => 'Esclusiva',
    'OdbcEdit.access.exclusive.description' => 'Designa il database come esclusivo, per proibire aggiornamenti condivisi.',
    'OdbcEdit.access.safetransactions.label' => 'Transazioni sicure',
    'OdbcEdit.access.safetransactions.description' => 'Se impostato a 0 (l\'impostazione predefinita), tutte le transazioni vengono eseguite immediatamente. Se impostato a 1, tutte le transazioni vengono salvate sul disco solo dopo l\'operazione di commit, ma la performance risulta leggermente degradata.',
    'OdbcEdit.access.threads.label' => 'Thread',
    'OdbcEdit.access.threads.description' => 'Il numero di thread in background utilizzabili dal modulo.',
    'OdbcEdit.access.maxscanrows.label' => 'Numero max di righe da analizzare',
    'OdbcEdit.access.maxscanrows.description' => 'Il numero delle righe da esaminare quando viene impostato il tipo di dati della colonna sulla base di dati esistenti.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Specifica come sono scritte nel database le modifiche fatte fuori da una transazione.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Specifica se il driver di MS Access esegue in modo asincrono transazioni esplicite definite dall\'utente.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'ID Login',
    'OdbcEdit.mssql.pwd.label' => 'Password',
    'OdbcEdit.mssql.database.label' => 'Database predefinito',
    'OdbcEdit.mssql.app.label' => 'Nome dell\'applicazione',
    'OdbcEdit.mssql.wsid.label' => 'ID della workstation',
    'OdbcEdit.mssql.language.label' => 'Lingua predefinita',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversione di caratteri estesi a valori OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver di MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Il nome host del server MySQL',
    'OdbcEdit.mysql.database.label' => 'Database predefinito',
    'OdbcEdit.mysql.user.label' => 'Nome utente',
    'OdbcEdit.mysql.user.description' => 'Il nome utente usato per la connessione a MySQL',
    'OdbcEdit.mysql.password.label' => 'Password',
    'OdbcEdit.mysql.password.description' => 'La password per l\'account utente nel server',
    'OdbcEdit.mysql.port.label' => 'Porta',
    'OdbcEdit.mysql.port.description' => 'La porta TCP/IP da usare se il server non è l\'host locale',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Named pipe di Windows da connettere se il server è l\'host locale',
    'OdbcEdit.mysql.option.label' => 'Opzione',
    'OdbcEdit.mysql.option.description' => 'Opzioni per specificare il funzionamento di MyODBC. Consulta la <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentazione.</a>',

    'ProtectedDirectoryList.title' => 'Directory protette di %%domainName%%',
    'ProtectedDirectoryList.add' => 'Aggiungere Directory Protetta',
    'ProtectedDirectoryList.addTooltip' => 'Crea directory protetta.',
    'ProtectedDirectoryList.name' => 'Nome',
    'ProtectedDirectoryList.realmTitle' => 'Titolo dell\'area protetta',
    'ProtectedDirectoryList.noSelectionText' => 'Seleziona uno o più elementi da rimuovere.',
    'ProtectedDirectoryList.edit' => 'Modifica',
    'ProtectedDirectoryList.remove' => 'Rimuovi la Protezione',
    'ProtectedDirectoryList.removeTooltip' => 'Rimuovi la protezione dalla directory selezionate.',
    'ProtectedDirectoryList.removeConfirmation' => 'L\'operazione comporterà la rimozione della protezione {count, plural, =1 {dalla directory {name}} other {da # directory selezionate}}. {count, plural, =1 {Questa directory sarà accessibile} other {Le directory saranno accessibili}} liberamente da qualsiasi utente su Internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Le directory selezionate sono state rimosse.',

    'ProtectedDirectoryAdd.title' => 'Crea Directory Protetta',
    'ProtectedDirectoryAdd.submit' => 'Crea',
    'ProtectedDirectoryAdd.success' => 'La directory protetta %%path%% è stata creata con successo',

    'ProtectedDirectoryEdit.title' => 'Impostazioni della Directory Protetta',
    'ProtectedDirectoryEdit.success' => 'Le impostazioni della directory protetta sono cambiate',

    'ProtectedDirectoryUserList.title' => 'Utenti della directory protetta %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Aggiungi Utente',
    'ProtectedDirectoryUserList.addTooltip' => 'Crea degli account utente in grado di accedere alla directory protetta %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Nome',
    'ProtectedDirectoryUserList.changePassword' => 'Cambiare Password',
    'ProtectedDirectoryUserList.noSelectionText' => 'Seleziona uno o più utenti da rimuovere.',
    'ProtectedDirectoryUserList.remove' => 'Rimuovi',
    'ProtectedDirectoryUserList.removeTooltip' => 'Rimuovi gli utenti selezionati.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Vuoi rimuovere {count, plural, =1 {l\'utente {login}} other {# utenti selezionati}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Gli utenti selezionati sono stati rimossi.',

    'ProtectedDirectoryUserAdd.title' => 'Crea utente directory protetta',
    'ProtectedDirectoryUserAdd.subtitle' => 'Directory %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nome utente',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Password',
    'ProtectedDirectoryUserAdd.submit' => 'Crea',
    'ProtectedDirectoryUserAdd.success' => 'L\'utente della directory protetta %%login%% è stato creato.',

    'ProtectedDirectoryUserPassword.title' => 'Password per l\'utente della directory protetta',
    'ProtectedDirectoryUserPassword.subtitle' => 'Utente %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Password',
    'ProtectedDirectoryUserPassword.submit' => 'Salva',
    'ProtectedDirectoryUserPassword.success' => 'Le credenziali dell\'utente sono state salvate.',

    'SummaryReport.Layout.title' => 'Proprietà di Layout di Report',
    'SummaryReport.Layout.success' => 'Il layout di report %%name%% è stato aggiornato.',
    'SummaryReport.Layouts.title' => 'Layout di Report',

    'SummaryReport.Layout.Add.title' => 'Creare Layout di Report',
    'SummaryReport.Layout.Add.success' => 'Il layout di report %%name%% è stato creato.',

    'SummaryReport.Report.title' => 'Rapporto riassuntivo',
    'SummaryReport.Report.buttonLayouts' => 'Layout',
    'SummaryReport.Report.buttonSchedule' => 'Pianifica',
    'SummaryReport.Report.buttonProperties' => 'Proprietà',
    'SummaryReport.Report.buttonTrafficHistory' => 'Cronologia del traffico',
    'SummaryReport.Report.buttonPrint' => 'Stampa',
    'SummaryReport.Report.buttonSend' => 'Inviato per e-mail',
    'SummaryReport.Report.successSent' => 'Il rapporto è stato inviato a %%email%%',

    'SummaryReport.Schedule.title' => 'Invii programmati per %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Invio programmato per %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Il piano di consegna del report è stato aggiornato.',

    'SummaryReport.Schedule.Add.title' => 'Crea invii programmati per %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Il piano di consegna di report è stato creato.',

    'SummaryReport.TrafficHistory.title' => 'Cronologia del traffico',
];