<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subnet or IP address',
    'access-network.subnetOrIpAddressHint' => 'For example, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'Retrieving information about newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'Could not retrieve your subscription status.',
    'admin.announcement-settings.sendAnnounceConsent' => 'I would like to receive newsletters from Plesk. They may contain security-related, technical, and general product information. I consent and authorize Plesk to collect, process and use my personal data (email), including cross-border processing, in accordance with the applicable data protection laws currently in effect for sending me newsletters either directly or through a 3rd party service. Unchecking this checkbox revokes my consent and orders Plesk to stop sending me emails and permanently remove my personal data from its systems.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Yes, please, I agree to receiving my personalized Plesk Newsletter. Plesk International GmbH and its affiliates may store and process the data I provide for the purpose of delivering the newsletter according to the %%privacyPolicy%%. In order to tailor its messages and offers to me, Plesk may also use additional information for profiling, like usage and behavior data. I can unsubscribe from the mailing list(s) at any time.',
    'admin.announcement-settings.privacyPolicy' => 'Plesk Privacy Policy',
    'admin.announcement-settings.noConsent' => 'Unsubscribe me from the Plesk newsletter.',
    'admin.announcement-settings.reportConsentError' => 'Could not save your settings for receiving information from Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Sorry, we cannot update your profile at the moment. Please try again later.',
    'admin.announcement-settings.invalidConsentType' => "Unknown consent type: '%%type%%'",
    'admin.announcement-settings.retry' => 'Retry',
    'admin.announcement-settings.consentGivenInfo' => 'We hope you\'ve been enjoying our generic Plesk newsletter. We can now provide you with an improved alternative - personalized with useful information and handy tips, according to your needs. To receive your personalized Plesk newsletter, please choose the first statement below and click OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'It seems that your are not subscribed to our generic newsletter. We can provide you with a better alternative - a personalized newsletter, with useful information and tips according to your needs.',

    'admin.personal-info.title' => 'Editing Administrator Profile',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk Settings',
    'admin.personal-info.settingsSectionLegend' => 'Settings',

    'admin-alias.login' => 'Username',
    'admin-alias.password' => 'Password',
    'admin-alias.passwordConfirmation' => 'Confirm password',
    'admin-alias.email' => 'Email',
    'admin-alias.contact' => 'Contact name',
    'admin-alias.comments' => 'Comments',
    'admin-alias.emptyLogin' => 'Please provide a username.',
    'admin-alias.loginTooLong' => 'The username length exceeds 20 characters.',
    'admin-alias.emptyEmail' => 'Please provide an email.',
    'admin-alias.emptyContactName' => 'Please provide a contact name.',
    'admin-alias.contactNameTooLong' => 'The contact name length exceeds 255 symbols.',
    'admin-alias.emptyPassword' => 'Please provide a password.',
    'admin-alias.commentsTooLong' => 'The comment\'s length exceeds 255 symbols.',
    'admin-alias.emailActivation' => 'Activate account by email',
    'admin-alias.simplePanel' => 'Enable Restricted Mode',
    'admin-alias.simplePanelHint' => 'Select this option to limit the number of actions the additional administrator can take in Plesk. To change which actions are available, go to %%link%%.',
    'admin-alias.simplePanelLink' => 'Tools & Settings > Restricted Mode Settings',
    'admin-alias.lockPowerUser' => 'Force Power User view for additional administrator',
    'admin-alias.lockPowerUserHint' => 'Ability to restrict view for additional Plesk administrator (no access to customers, resellers and service plans).',

    'admin-info.plesk-settings.multiplyLogin' => 'Allow multiple sessions under this account',
    'admin-info.plesk-settings.adminLanguage' => 'Administrator\'s interface language',
    'admin-info.plesk-settings.password' => 'Password',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirm password',

    'admin-panel.form.contact-info.contactName' => 'Contact name',
    'admin-panel.form.contact-info.emptyContactName' => 'Please provide a contact name.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Contact name is too long (maximum %max% symbols are allowed).',
    'admin-panel.form.contact-info.email' => 'Email address',
    'admin-panel.form.contact-info.emptyEmail' => 'Please provide an email address.',
    'admin-panel.form.contact-info.companyName' => 'Company name',
    'admin-panel.form.contact-info.longCompanyName' => 'This company name is too long (maximum %max% symbols are allowed).',
    'admin-panel.form.contact-info.phone' => 'Phone number',
    'admin-panel.form.contact-info.longPhone' => 'This phone number is too long (maximum %max% symbols are allowed).',
    'admin-panel.form.contact-info.fax' => 'Fax number',
    'admin-panel.form.contact-info.imNumber' => 'Instant messenger',
    'admin-panel.form.contact-info.longFax' => 'This fax number is too long (maximum %max% symbols are allowed).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'The specified phone number is not valid.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'This fax number is incorrect.',
    'admin-panel.form.contact-info.address' => 'Address',
    'admin-panel.form.contact-info.longAddress' => 'This address is too long (maximum %max% symbols are allowed).',
    'admin-panel.form.contact-info.city' => 'City',
    'admin-panel.form.contact-info.longCity' => 'This city name is too long.',
    'admin-panel.form.contact-info.shortCity' => 'This city name is too short.',
    'admin-panel.form.contact-info.state' => 'State/Province',
    'admin-panel.form.contact-info.postalCode' => 'Postal/ZIP code',
    'admin-panel.form.contact-info.country' => 'Country',
    'admin-panel.form.contact-info.additionalInfo' => 'Additional information',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Plain text only: All HTML tags will be ignored.',
    'admin-panel.form.contact-info.duplicateEmail' => 'A user with such an email address already exists in the system.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Subscription',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Properties of the website provisioned together with the subscription.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Properties of the website provisioned together with the subscription.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Properties of the website provisioned together with the subscription.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Create subscription for the customer',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Clear this checkbox if you do not want to create a hosting service subscription or set up a website for the customer at this moment. Without a subscription, the customer will not be able to log in to Customer Panel.',
    'admin-panel.form.domain-info-section.domainName' => 'Domain name',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'You must provide a domain name.',
    'admin-panel.form.domain-info-section.shared' => 'shared',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicated',
    'admin-panel.form.domain-info-section.userName' => 'Username',
    'admin-panel.form.domain-info-section.userNameHint' => 'System user account used to manage files and folders of the websites created within the subscription.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'You must provide a username.',
    'admin-panel.form.domain-info-section.password' => 'Password',
    'admin-panel.form.domain-info-section.emptyPassword' => 'You must provide a password.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirm password',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP address on which the website is hosted is a network address of the website's virtual host.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 address',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP address on which the website is hosted is a network address of the website's virtual host.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 address',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'None',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Additional subscription settings',
    'admin-panel.form.domain-info-section.credentials' => 'System user credentials',
    'admin-panel.form.domain-info-section.credentialsHint' => 'to access hosted files over FTP and SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'to access hosted files over FTP and RDP',

    'admin-panel.form.login-info.userName' => 'Username',
    'admin-panel.form.login-info.emptyUserName' => 'Please provide a username.',
    'admin-panel.form.login-info.password' => 'Password',
    'admin-panel.form.login-info.emptyPassword' => 'Please provide a password.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Repeat password',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Changing the password will also change the internal email address password',
    'admin-panel.form.login-info.emailActivation' => 'Activate account by e-mail',
    'admin-panel.form.login-info.emailActivationHint' => 'A created account is inactive until the user activates it with the link sent by email or the administrator activates the account manually.',

    'admin-panel.form.subscription-info-section.subscription' => 'Subscription',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Service plan',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Current service plan',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'New service plan',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Simple plan',
    'admin-panel.form.subscription-info-section.none' => 'None',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Add-ons',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Proceed to customizing parameters of the subscription after the plan association is changed. Note that doing this will lock the subscription for syncing.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Proceed to customizing the subscription parameters after it is created.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Proceed to customizing the subscription parameters after the customer is created.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Proceed to customizing the subscription parameters after it is created. Note that doing this will lock the subscription for syncing.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Note that doing this will lock the subscription for syncing.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Add Subscription',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Could not sync the subscription with the service plan. The following settings of the subscription conflict with the service plan: %%problems%%.',

    'app.configure.otherSettings' => 'Other',
    'app.configure.passwordConfirmation' => 'Confirm password',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Force updates for all installed apps',
    'app.update-settings.forceUpdatesHint' => 'All customers\' apps will be updated automatically as soon as the updates are available. Customers will be unable to turn off automatic updates for their apps. Warning: Use this option with care because updates can significantly affect the app functionality. For example, app extensions may stop working with another version of the app.',
    'app.update-settings.suggestUpdates' => 'Turn on the option "Automatically update this app" by default',
    'app.update-settings.suggestUpdatesHint' => 'For newly installed apps, the option "Automatically update this app" in the app\'s settings will be turned on.',

    'backup.server-settings.rotation' => 'Maximum number of full backup files to store (including both scheduled and manual backups)',
    'backup.server-settings.rotationDescription' => 'Users can store this many full backups in the server storage. If the number of full backups already in storage exceeds the limit, only the most recent backups are kept. Incremental backups are unaffected.',
    'backup.server-settings.maxProcesses' => 'Maximum number of simultaneously running scheduled backup processes',
    'backup.server-settings.niceScheduled' => 'Run scheduled backup processes with low priority',
    'backup.server-settings.niceScheduledPriority' => 'Priority',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Enter value between 1 and 19 inclusively with a higher number being lower priority.',
    'backup.server-settings.niceScheduledIoPriority' => 'IO priority',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Enter value between 0 and 7 inclusively with a higher number being lower priority.',
    'backup.server-settings.niceAlways' => 'Run all backup processes with low priority',
    'backup.server-settings.niceAlwaysPriority' => 'Priority',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Enter value between 1 and 19 inclusively with a higher number being lower priority.',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO priority',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Enter value between 0 and 7 inclusively with a higher number being lower priority.',
    'backup.server-settings.compressionLevel' => 'Compression level',
    'backup.server-settings.compressionLevelNoCompression' => 'No compression',
    'backup.server-settings.compressionLevelFastest' => 'Fastest',
    'backup.server-settings.compressionLevelFast' => 'Fast',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Maximum',
    'backup.server-settings.freeSpaceRequired' => 'Start the backup only if your server has the specified amount of free disk space (in megabytes)',
    'backup.server-settings.checkBackupDiskSpace' => 'Start the backup only if your server has the sufficient amount of free disk space',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Use native MS SQL backup functionality (For remote databases, make sure you configured the backup settings of the remote MS SQL server in Tools & Settings > Database Servers)',
    'backup.server-settings.localFtpRestriction' => 'Allow setting up FTP backup storage on the local server',
    'backup.server-settings.backupSecuritySettings' => 'Backup security settings',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Save backups in the server storage if the upload to remote storage fails',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Manual and scheduled backups intended for remote storage will be saved in the local server storage if uploading to remote storage fails. Users must have the permission to store backups in the server storage.',
    'backup.server-settings.AllowScheduleHourly' => 'Allow customer and reseller accounts to schedule hourly backups',

    'change-current-subscription.hint' => 'This is where you change the association with service plans for the subscription. Note that selecting \'none\' as a new service plan unbinds the subscription from the service plan and makes it \'Custom\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Could not sync the subscription with the service plan. The following settings of the subscription conflict with the service plan: %%problems%%.',

    'change-password.oldPassword' => 'Old password',
    'change-password.password' => 'New password',
    'change-password.passwordConfirmation' => 'Confirm password',
    'change-password.oldPasswordIsIncorrect' => 'The old password is incorrect. Please try again.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Unable to find the additional administrator account.',
    'change-password.warningAboutAdminPasswordSyntax' => "The password should be %%min%% - %%max%% characters long and should not contain the username.\nDo not use quotation marks, spaces, and national alphabetic characters in the password.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Do not use quotation marks, spaces, semicolons, and national alphabet characters in the password.\nThe password should be between %%min%% and %%max%% characters  long, and it should not contain the username.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Oversell policy',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Overselling is allowed',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Overselling allows a reseller to sell more resources than is allocated to them with a plan. If overselling is allowed, a reseller is governed by actual resource usage instead of initial resource allocation.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Overselling is not allowed',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'If overselling is not allowed, a reseller can only sell as much resources as initially allocated to them with a plan, disregarding of how much of those resources are actually used.',

    'change-reseller-subscription.hint' => 'This is where you change the association with service plan for the reseller subscription. Note that selecting \'none\' as a new service plan unbinds the subscription from service plans and makes it \'Custom\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Could not sync the subscription with the service plan. The following settings of the subscription conflict with the service plan: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'New plan',
    'change-reseller-subscription.oldSubscription' => 'Current plan',
    'change-reseller-subscription.none' => 'none',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Subscription association with service plan was updated.',
    'change-reseller-subscription.customizeSubscription' => 'Proceed to customizing the subscription parameters after its association with service plan is updated. Note that doing this will lock the subscription for syncing.',

    'change-subscription.hint' => 'This is where you change the association with service plans for the selected subscriptions.',
    'change-subscription.selectPlanLegend' => 'Service plan',
    'change-subscription.selectPlanDescription' => 'To switch to another service plan, choose the new plan from the list. Note that selecting \'none\' unbinds the subscriptions from the service plan and makes them \'Custom\'.',
    'change-subscription.servicePlan' => 'New service plan',
    'change-subscription.selectAddonPlansLegend' => 'Add-on plans',
    'change-subscription.selectAddonPlansDescription' => 'Add or remove add-on plans.',
    'change-subscription.noChange' => 'no change',
    'change-subscription.none' => 'none',
    'change-subscription.add' => 'add',
    'change-subscription.del' => 'remove',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subnet or IP address',
    'control-panel-access.network.subnetOrIpAddressHint' => 'For example, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Access to Plesk with administrator\'s privileges',
    'control-panel-access.settings.policyAllow' => 'Allowed, excluding the networks in the list.',
    'control-panel-access.settings.policyDeny' => 'Denied from the networks that are not listed.',

    'create-subscription.title' => 'Adding a Subscription',
    'create-subscription.titleOwn' => 'Adding Your Own Subscription',
    'create-subscription.poolIsEmpty' => 'Unable to create a subscription because there are no shared IP addresses and no free dedicated IP addresses in Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'Subscription %%name%% was created.',
    'create-subscription.createBeforeAppInstall' => 'You need to have a subscription to install the app.',

    'customer.hint' => 'This is where you sign up a new customer to your hosting services. By this sign-up, you create a customer account in Plesk and a subscription to one of your hosting plans and, optionally, add-ons. The subscription can also provide a completely custom set of resources and services, not bound with any plans — for this, select \'None\' next to the Service Plan.',
    'customer.contactInfoSection' => 'Contact Information',
    'customer.additionalInfoSection' => 'Additional customer information',
    'customer.accessToPanelSection' => 'Access to Plesk',
    'customer.contactInfoSectionHint' => 'Enter the customer contact information.',
    'customer.accessToPanelSectionHint' => 'Credentials that the customer will use to access their Customer Panel.',
    'customer.unableCreateSubscription' => 'The subscription cannot be created: %%reason%%',
    'customer.poolIsEmpty' => 'IP pool is empty',
    'customer.buttonOk' => 'Add Customer',

    'database-settings.dbPrefixRadio' => 'Add a prefix and underscore to the beginning of database names',
    'database-settings.dbPrefixNone' => 'None',
    'database-settings.dbPrefixUsername' => 'Username',
    'database-settings.dbPrefixExternalId' => 'External ID of a subscription',
    'database-settings.dbPrefixCustom' => 'Custom prefix',
    'database-settings.dbUserPrefixRadio' => 'Add a prefix and underscore to the beginning of database user names',
    'database-settings.dbUserPrefixHint' => 'Database user names will look like <prefix>_<database_user_name>. Due to the database restriction of the user name length, <prefix> may be abbreviated.',
    'database-settings.grantAlterDatabase' => 'Grant the ALTER DATABASE permission to all Microsoft SQL Server database users',
    'database-settings.grantAlterDatabaseHint' => 'New and existing users will be granted this permission.',
    'database-settings.enableBackupOperator' => 'Enable the db_backupoperator role membership for all Microsoft SQL Server database users',
    'database-settings.enableBackupOperatorHint' => 'New and existing users will be a member of this role.',
    'database-settings.aclRadio' => 'Default settings for remote access of MySQL database users',
    'database-settings.aclLocalhost' => 'Allow local connections only',
    'database-settings.aclAny' => 'Allow remote connections from any host',
    'database-settings.aclCustom' => 'Allow remote connections from',
    'database-settings.aclDescription' => 'This setting modifies only the users\' permissions. To enable remote access to Local MySQL server, select the corresponding option in %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Local MySQL Settings',
    'database-settings.example' => "For example:",
    'database-settings.aclExampleDescription' => "The specified hosts are allowed to access the database on behalf of this user.",
    'database-settings.dbPrefixAlphaNumeric' => 'The prefix value can contain only alphanumeric values and underscore.',

    'dns.add-acl-record.description' => 'Add an IP address of a DNS server allowed to receive a copy of the DNS zone.',
    'dns.add-acl-record.ipAddress' => 'IP address',
    'dns.add-acl-record.ipAddressWithMask' => 'IP address/mask',

    'dns.settings.recursion' => 'Recursive DNS queries',
    'dns.settings.recursionOn' => 'Allow for all requests',
    'dns.settings.recursionLocal' => 'Allow for local requests only',
    'dns.settings.recursionLocalnets' => 'Allow for requests from local network(s) only',
    'dns.settings.recursionOff' => 'Deny for all requests',
    'dns.settings.customConfiguration' => 'Additional DNS settings',
    'dns.settings.customConfigurationPlaceholder' => 'The settings you specify here will override the server-wide ones.',
    'dns.settings.customConfigurationHint' => 'If you cannot find particular settings, add them to the field above using the syntax of named.conf.',
    'dns.settings.customConfigurationExample' => 'For example, to hide hostname of the DNS server, add the following line: ',
    'dns.settings.restoreDefaultButton' => 'Use Default Settings',

    'dns.template.synchronize-done' => 'The DNS zone template was successfully applied.',
    'dns.template.synchronize-error' => 'The DNS zone template was not applied to some DNS zones.',
    'dns.template.synchronize-progress' => 'Applying the DNS zone template.',

    'domain-restriction.name' => 'Domain name',
    'domain-restriction.nameDescription' => 'You can specify a wildcard pattern by using the asterisk sign (*). For example, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'The specified domain name is already in the list.',

    'event-handler.eventLabel' => 'Event',
    'event-handler.priorityLabel' => 'Priority',
    'event-handler.userLabel' => 'User',
    'event-handler.commandLabel' => 'Command',
    'event-handler.commandHint' => 'For best results, enter a full path to a script file in the \'command\' field. We do not recommend entering system commands as they may not work. For example, commands with output redirection operators > or < will not work.',
    'event-handler.priorityHighestText' => 'highest',
    'event-handler.priorityHighText' => 'high',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'low',
    'event-handler.priorityLowestText' => 'lowest',
    'event-handler.priorityCustomText' => 'custom',
    'event-handler.priorityHighestOption' => 'highest (%%value%%)',
    'event-handler.priorityHighOption' => 'high (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'low (%%value%%)',
    'event-handler.priorityLowestOption' => 'lowest (%%value%%)',

    'extension.upload.fileUpload' => 'Path to the extension package file',

    'external-webmail.hint' => 'Once you register an additional webmail in Plesk, it will become available to your customers: it will appear as an option in the \'Mail\' properties of hosting plans and subscriptions. The webmail name will be displayed in the list of webmail options, and the URL will open upon clicking the webmail icon next to a mailbox in Customer Panel.',
    'external-webmail.name' => 'Webmail service name',
    'external-webmail.url' => 'Webmail service URL',
    'external-webmail.enabled' => 'Available',

    'ftp-settings.generalSection' => 'General',
    'ftp-settings.portRange' => 'Port or port range for passive FTP mode connections',
    'ftp-settings.hintPortRange' => '(default value: %%defaultPortRange%%)',

    'health.upload.hint' => 'Upload your configuration of the health server monitor. The configuration will be applied as soon as it is uploaded.',
    'health.upload.selectFile' => 'Configuration file',

    'install-local-package.selectUploadType' => 'Choose one of the following:',
    'install-local-package.uploadAsFile' => 'Upload an APS package',
    'install-local-package.downloadFromCatalog' => 'Select an app from Application Catalog',
    'install-local-package.formInfo' => "Extend the list of available apps by uploading a new app, or add an app from Application Catalog for further configuration.",
    'install-local-package.invalidFileExtension' => 'The uploaded app must be a ZIP archive with the .zip extension.',
    'install-local-package.packagesNotSelected' => 'None of the packages is selected.',
    'install-local-package.visible' => 'Make available to customers',
    'install-local-package.isCommercial' => 'This app is commercial and requires purchasing a license key.',
    'install-local-package.visibleDescription' => 'Make the app available for installation by customers.',

    'ip-address.addTitle' => 'Add IP address',
    'ip-address.editTitle' => 'IP address %%address%% on the interface %%interface%%',
    'ip-address.generalSection' => 'General',
    'ip-address.interface' => 'Interface',
    'ip-address.addressAndSubnetPrefixLength' => 'IP address and subnet mask',
    'ip-address.addressHintIPv4' => 'For example, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'For example, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Public IP address',
    'ip-address.hintPublicIp' => 'You can use a public IP address if your Plesk server is behind NAT',
    'ip-address.distributionType' => 'The IP address is distributed as',
    'ip-address.distributionTypeShared' => 'Shared',
    'ip-address.distributionTypeExclusive' => 'Dedicated',
    'ip-address.certificate' => 'SSL/TLS certificate',
    'ip-address.defaultSite' => 'Default site',
    'ip-address.ftpOverSslNotSupportedByServer' => 'The installed FTP server does not support FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'The installed FTP server does not support IPv6 addresses.',
    'ip-address.interfaceDHCPEnabled' => 'Cannot add the IP address. This network interface obtains IP addresses automatically.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Note: Custom Plesk URL is enabled for all unknown domains; Plesk interface will be displayed instead of the default site on "https://%%ip%%/"',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Network adapter %%interface%% does not exist. Move this IP address to another network adapter or remove it from the list.',
    'ip-address.none' => 'none',

    'ip-ban.filter.name' => 'Name',
    'ip-ban.filter.content' => 'Content',
    'ip-ban.filter.filterExistsError' => 'A filter with such a name already exists.',

    'ip-ban.jail.name' => 'Name',
    'ip-ban.jail.filter' => 'Filter',
    'ip-ban.jail.filterDescription' => 'Select the filter.',
    'ip-ban.jail.action' => 'Action',
    'ip-ban.jail.actionDescription' => 'Select an action and click the button to add it.',
    'ip-ban.jail.logPath' => 'Log path',
    'ip-ban.jail.banTime' => 'IP address ban period',
    'ip-ban.jail.maxRetry' => 'The maximum number of failed login attempts',
    'ip-ban.jail.timeUnit' => 'seconds',
    'ip-ban.jail.addAction' => 'Add',
    'ip-ban.jail.chooseAction' => 'Select:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache authorization failures (when logging into file)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache authorization failures (any logging)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache authorization failures (when logging into syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bots and bad web crawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP and POP3 authentication failures',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3, and Sieve authentication failures',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3, and Sieve authentication failures (aggressive mode)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde webmail authentication failures',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Web Application Firewall (ModSecurity) security and access control violations',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk authentication failures',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP authentication failures',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube webmail authentication failures',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress authentication failures',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP client errors (including RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP client errors, authentication failures, and DDoS attacks',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP and SASL authentication failures',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS attacks',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP client errors and authentication failures',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP client errors (including RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP client errors (RBL only)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD login failures',
    'ip-ban.jail.recidive-filter-description' => 'Hosts repeatedly banned by Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'SSH login failures',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH login failures, negotiation failures, and DDoS attacks',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH login failures and DDoS attacks',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH login and negotiation failures',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Ban via firewalld firewall, on all ports',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Ban via firewalld firewall, on multiple ports',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Ban via firewalld firewall, on a single port',
    'ip-ban.jail.iptables-action-description' => 'Ban via iptables firewall, on a single port',
    'ip-ban.jail.iptables-allports-action-description' => 'Ban via iptables firewall, on all ports',
    'ip-ban.jail.iptables-multiport-action-description' => 'Ban via iptables firewall, on multiple ports',
    'ip-ban.jail.sendmail-action-description' => 'Send an email notification via Sendmail',
    'ip-ban.jail.jailExistsError' => 'A jail with such a name already exists.',
    'ip-ban.jail.invalidInteger' => 'The specified value is invalid. Specify an integer.',

    'ip-ban.settings.pageHint' => 'Here you can set up IP address banning to protect your server and hosted websites from malicious traffic.',
    'ip-ban.settings.detectionEnabled' => 'Enable intrusion detection',
    'ip-ban.settings.banPeriod' => 'IP address ban period',
    'ip-ban.settings.banTimeWindow' => 'Time interval for detection of subsequent attacks',
    'ip-ban.settings.maxRetries' => 'Number of failures before the IP address is banned',
    'ip-ban.settings.timeUnit' => 'seconds',
    'ip-ban.settings.invalidInteger' => 'An invalid value was provided. Provide a positive integer.',

    'ip-ban.trusted-ip.ipAddress' => 'IP address',
    'ip-ban.trusted-ip.hintIpAddress' => 'An IP address, a CIDR mask, or a DNS hostname.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'The provided IP address, network address, or hostname is invalid.',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'An IP address must be no longer than %max% characters.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Description',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'The explanation why the IP address was added to the trusted list.',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => 'The description must be no longer than %max% characters.',

    'login-info.hint' => 'This is where you change the username and password that the customer uses to access their Customer Panel.',
    'login-info.resellerHint' => 'This is where you change the username and/or password that the reseller uses to access their Plesk.',
    'login-info.myProfileHint' => 'This is where you change the password you use to access your Plesk.',

    'firewall-rule.titleEdit' => 'Editing a Firewall Rule',
    'firewall-rule.titleNew' => 'Adding a Rule',
    'firewall-rule.isEnabled' => 'Turn on the rule',
    'firewall-rule.name' => 'Rule name',
    'firewall-rule.profiles' => 'Profiles',
    'firewall-rule.profilesHint' => 'You must select at least one profile.',
    'firewall-rule.profileDomain' => 'Domain',
    'firewall-rule.profilePrivate' => 'Private',
    'firewall-rule.profilePublic' => 'Public',
    'firewall-rule.action' => 'Action',
    'firewall-rule.actionAllow' => 'Allow',
    'firewall-rule.actionBlock' => 'Deny',
    'firewall-rule.port' => 'Allow connections to the following port or port range',
    'firewall-rule.portHint' => 'For example: 1000 or 1000-1051',
    'firewall-rule.protocolTcp' => 'TCP protocol',
    'firewall-rule.protocolUdp' => 'UDP protocol',
    'firewall-rule.remoteAddresses' => 'Remote addresses',
    'firewall-rule.remoteAddressesHint' => 'For example: 192.168.0.1 or 192.168.0.0/16',
    'firewall-rule.newRule' => 'New Rule',
    'firewall-rule.successNew' => 'The firewall rule was added.',
    'firewall-rule.successEdit' => 'The firewall rule was updated.',

    'mail.lists-server-settings.email' => "Mailing list administrator's email",
    'mail.lists-server-settings.emptyEmail' => 'Please provide an email address.',
    'mail.lists-server-settings.newPassword' => 'New password',
    'mail.lists-server-settings.emptyPassword' => 'Please provide a password.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirm password',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'The mailing list software was configured.',

    'mail.outgoing-messages.hint' => 'Here you can specify a limit on outgoing messages from a mailbox.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'The maximum number of outgoing email messages',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Default (%%domainOutgoingMessages%% messages per hour)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Custom value for this mailbox',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'messages per hour',

    'mail-gate-settings.host' => 'Host name or IP address',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Username',
    'mail-gate-settings.password' => 'Password',
    'mail-gate-settings.encryption' => 'SMTP server requires encrypted connection',
    'mail-gate-settings.allowUsers' => 'Allow user scripts to send mail through this SMTP server (using the specified username and password)',
    'mail-gate-settings.useDefaultSettings' => 'Use the mail server installed with Plesk and the default mail account created by Plesk',

    'mail-gate.hint' => 'Here you can specify the SMTP server to be used when the Plesk mail server is not installed or prohibited from sending outgoing mail. This server will be used as an SMTP relay by Plesk and user scripts to send outgoing mail such as email notifications.',
    'mail-gate.enableMailGate' => 'Allow Plesk to send email notifications through this SMTP server',
    'mail-gate.notifications' => 'Mail notifications by external SMTP server',
    'mail-gate.smtpSettings' => 'External SMTP server settings',

    'optimization-settings.apacheModulesSection' => 'Apache modules',
    'optimization-settings.apacheSettingsSection' => 'General settings',
    'optimization-settings.additionalPageHint' => 'Toggle modules only if you completely understand the consequences of your actions. Note that some modifications may decrease the Apache performance or even lead to its inoperability. ',
    'optimization-settings.pageHint' => 'Here you can optimize Plesk by switching off unused Apache modules. This optimization improves memory utilization and allows you to serve more hosting customers. Note that some modules are interdependent and can be switched off (on) only when the modules they depend on are off (on).',
    'optimization-settings.advancedUsersOnlyWarning' => 'This feature is for advanced users only. ',
    'optimization-settings.apacheRestartInterval' => 'Apache restart interval (seconds)',
    'optimization-settings.apacheRestartIntervalHint' => 'Once in a specified interval, Plesk checks for changes made to domains and subdomains. In case there are changes that require web server restarting, Plesk restarts Apache.',
    'optimization-settings.gracefulRestart' => 'Apache graceful restart',
    'optimization-settings.gracefulRestartHint' => 'Select to avoid downtime of all websites hosted on the server, each time you change hosting settings.',
    'optimization-settings.pipedLog' => 'Piped logs',
    'optimization-settings.mpmMode' => 'MPM mode',
    'optimization-settings.moduleDeprecated' => '(Deprecated)',

    'personal-info.contactInfoSection' => 'Contact information',
    'personal-info.hint' => 'This is where you edit the user contact information.',
    'personal-info.hintMyProfile' => 'This is where you edit your contact information.',

    'php-handler.extension.title' => 'Install PECL package',
    'php-handler.extension.description' => "You can install a beta version of an extension by specifying additional parameters with the package name, for example, 'msgpack-beta'.",
    'php-handler.extension.name' => 'Package name',

    'php-handler.ini.formHint' => 'This php.ini file is used by this handler only.',
    'php-handler.ini.formHintSharedIni' => 'This php.ini file is also used by the following PHP handlers: %%handlers%%. The settings apply to all websites that use these handlers.',
    'php-handler.ini.incorrectTextForIniFile' => "The specified settings are incorrect and cannot be saved to the php.ini file. Error: %%message%%.",

    'plan-item-custom.planItemName' => 'Service name',
    'plan-item-custom.buttonLabel' => 'This name will also be used as a label for the custom button.',
    'plan-item-custom.planItemDescription' => 'Service description',
    'plan-item-custom.buttonTooltip' => 'This text will also be used as a tooltip for the custom button',
    'plan-item-custom.url' => 'URL attached to the custom button',
    'plan-item-custom.backgroundImage' => 'Background image for the custom button',
    'plan-item-custom.emptyItemName' => 'Please provide a label for the service.',
    'plan-item-custom.emptyItemDescription' => 'Please provide a text for the service tooltip.',
    'plan-item-custom.emptyUrl' => 'Please specify a URL.',
    'plan-item-custom.longItemName' => 'This service label is too long. The maximum allowed length is %max% symbols.',
    'plan-item-custom.longItemDescription' => 'This service text is too long. The maximum allowed length is %max% symbols.',
    'plan-item-custom.longUrl' => 'This URL is too long. The maximum allowed length is %max% symbols.',
    'plan-item-custom.useCustomButton' => 'Use custom button for the service',
    'plan-item-custom.useCustomButtonHint' => 'Place a custom button on User\'s home page and Website pages.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Open the URL in Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Specify whether to open the URL on a Plesk page or in a new browser window.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Do not use frames',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'If you add a custom button which leads to a Plesk extension or an app in the Customer Panel, you can specify how this extension/app should be displayed: in a frame or as a part of the Plesk GUI.',
    'plan-item-custom.includeDomId' => 'Include subscription ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Include the main domain name',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Include FTP username',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Include FTP password',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Include customer ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Include customer's company name",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Include customer's contact name",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Include customer's email",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Choose how to preview websites',
    'preview-domain-settings.previewQuick' => 'Default Quick Preview',
    'preview-domain-settings.previewDisabled' => 'Disable Quick Preview',
    'preview-domain-settings.previewQuickDescription' => 'A recommended option that works out of the box.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Quick Preview on a domain name in Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Select one of your websites served by Plesk to be used for the preview.',
    'preview-domain-settings.previewZoneDomainCreate' => 'To use this feature, %%link%% at least one domain.',
    'preview-domain-settings.subscriptionCreateLink' => 'create',
    'preview-domain-settings.previewZoneTypeExternal' => 'Quick Preview on an external domain name',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Use an external domain name (DNS zone). If you use this option, add the following DNS record (of type A) to the external domain zone: *.<Plesk_IP>.external.dom. Here <Plesk_IP> is the Plesk server IP where dots (.) for IPv4 or colons (:) for IPv6 are replaced with dashes (-). For example, *.192-0-2-12.external.dom. If Plesk has more than one registered IP address, add a record for each address.',
    'preview-domain-settings.sitePreviewProtection' => 'Require authentication',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Require FTP login and password to access the preview.',
    'preview-domain-settings.nginxNotInstalled' => 'Default Quick Preview is not available because the nginx web server is not installed.',
    'preview-domain-settings.nginxDisabled' => 'Default Quick Preview is not available because the nginx web server is disabled.',

    'reseller-preferences.settingsSection' => 'Settings',
    'reseller-preferences.multiLogin' => 'Allow multiple sessions',
    'reseller-preferences.language' => 'Interface language',
    'reseller-preferences.interfaceView' => 'Select your interface',
    'reseller-preferences.serviceProviderView' => 'Service Provider view',
    'reseller-preferences.serviceProviderViewHint' => 'This view is intended for server administrators who provide and sell web hosting services to their customers using service plans.',
    'reseller-preferences.powerUserView' => 'Power User view',
    'reseller-preferences.powerUserViewHint' => 'This view is best suited for managing websites, their files, databases, email accounts, web applications, and other services.',

    'reseller.hint' => 'This is where you sign up a new reseller to your hosting services.',
    'reseller.contactInfoSection' => 'Contact Information',
    'reseller.contactInfoSectionHint' => 'Enter the reseller contact information.',
    'reseller.accessToPanelSection' => 'Access to Plesk',
    'reseller.accessToPanelSectionHint' => 'Credentials that the reseller will use to access the Plesk to manage services to which they are signed up.',
    'reseller.subscription' => 'Subscription',
    'reseller.subscriptionSectionHint' => 'Select a service plan to which the reseller will be subscribed.',
    'reseller.servicePlan' => 'Service plan',
    'reseller.none' => 'none',
    'reseller.customizeSubscription' => 'Proceed to customizing the subscription parameters after the reseller is created. Note that doing this will lock the subscription for syncing.',
    'reseller.subscriptionNotSynchronized' => 'Could not sync the subscription with the service plan. The following settings of the subscription conflict with the service plan: %%problems%%.',

    'security-policy.encryptionSection' => 'Enhanced security mode',
    'security-policy.encryptionSectionHint' => 'The enhanced security mode introduces advanced protection of sensitive data in Plesk. In this mode, Plesk employs multiple security mechanisms which are absolutely transparent to Plesk users. In order to improve Plesk security, we recommend that you turn the mode on.',
    'security-policy.encryptionEnable' => 'Enhanced security mode',
    'security-policy.securePassword' => 'Enhanced security mode',
    'security-policy.strengthSection' => 'Password strength',
    'security-policy.strengthSectionHint' => 'Most passwords users can set or change in Plesk are validated to make sure they meet the minimum password strength requirements set here. Strong passwords are at least 9-12 characters long and include digits, upper and lower-case letters, special characters, and no dictionary words. They are harder to guess, but also to remember. <a href="%%link%%" target="_blank">Learn more about password strength</a>.',
    'security-policy.passwordStrength' => 'Minimum password strength',
    'security-policy.secureFtpSection' => 'Secure FTP',
    'security-policy.ftpOverSsl' => 'FTPS usage policy',
    'security-policy.ftpOverSslHint' => 'FTPS is used to protect communication between the FTP server and external FTP clients using SSL/TLS protocol. Here you can select what kinds of connections should be allowed.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS is used to protect communication between the FTP server and external FTP clients using SSL/TLS protocol. Here you can select what kinds of connections should be allowed. The selected option will be applied to all IP addresses on the server. To use custom settings per IP address, select the corresponding option and then change the FTPS policy in Tools & Settings > IP Addresses.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS is used to protect communication between the FTP server and external FTP clients using SSL/TLS protocol.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS is used to protect communication between the FTP server and external FTP clients using SSL/TLS protocol. If you want to adjust the FTPS settings per IP address, first select the option "Use custom FTPS settings per IP address" in Tools & Settings > Security Policy > Secure FTP.',
    'security-policy.ftpOverSslOptionRequired' => 'Allow only secure FTPS connections',
    'security-policy.ftpOverSslOptionEnabled' => 'Allow both secure FTPS and non-secure FTP connections',
    'security-policy.ftpOverSslOptionDisabled' => 'Allow only non-secure FTP connections. Do not use FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Use custom FTPS policy per IP address',
    'security-policy.prohibitWebConfigHandlersSection' => 'Custom handlers policy',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Enable this option to prohibit customers from overriding the IIS handlers defined on the server level via the web.config file.',
    'security-policy.prohibitWebConfigHandlers' => 'Prohibit the ability to override handlers via web.config',

    'server-mail-antivirus.used' => 'Used antivirus',
    'server-mail-antivirus.policy' => 'Use server-wide settings',
    'server-mail-antivirus.policyOff' => 'Scanning turned off',
    'server-mail-antivirus.policyAny' => 'Scan both incoming and outgoing mail',
    'server-mail-antivirus.policyFrom' => 'Scan outgoing mail only',
    'server-mail-antivirus.policyTo' => 'Scan incoming mail only',
    'server-mail-antivirus.allowPersonalSettings' => 'Allow personal settings',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Allow override server-wide settings in each email address',
    'server-mail-antivirus.incoming' => 'for incoming mail',
    'server-mail-antivirus.outgoing' => 'for outgoing mail',
    'server-mail-antivirus.success' => 'Antivirus settings were changed.',

    'server-mail-black-list.title' => 'Add Domain to the Black List',
    'server-mail-black-list.domainName' => 'Domain name',
    'server-mail-black-list.emailAddress' => 'Email addresses',
    'server-mail-black-list.emailAddressHint' => 'There must be no non-ASCII characters to the left of the @ sign. Addresses can contain "*" and "?" wildcards (for example, *@domain.com, user?@*.com). Non-ASCII parts of domain names must not contain wildcards.',
    'server-mail-black-list.action' => 'What to do with mail that fits the criteria:',
    'server-mail-black-list.actionDelete' => 'Delete from server',
    'server-mail-black-list.actionSpam' => 'Mark as spam',
    'server-mail-black-list.success' => 'Domain was added to the black list.',

    'server-mail-white-list.title' => 'Add Network to the White List',
    'server-mail-white-list.descEmailAddress' => 'Email addresses specified here will not be recognized as spam by SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'IP entries specified here will be added to the mail server\'s exceptions.',
    'server-mail-white-list.ipAddress' => 'IP address/mask',
    'server-mail-white-list.ipAddressHint' => 'IP address can contain wildcard or CIDR mask.',
    'server-mail-white-list.emailAddress' => 'Email addresses',
    'server-mail-white-list.emailAddressHint' => 'There must be no non-ASCII characters to the left of the @ sign. Addresses can contain "*" and "?" wildcards (for example, *@domain.com, user?@*.com). Non-ASCII parts of domain names must not contain wildcards.',
    'server-mail-white-list.emailAddressOrIp' => 'Email or IP addresses',
    'server-mail-white-list.wildcardPattern' => 'IP addresses can contain wildcards (for example, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP addresses can contain CIDR masks (for example, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Network was added to the white list.',

    'server-mail-settings.general.title' => 'General options',
    'server-mail-settings.general.mailUiEnabled' => 'Enable mail management functions in Plesk',
    'server-mail-settings.general.serverName' => 'Installed mail server',
    'server-mail-settings.general.changeServerName' => 'install and use another mail server',
    'server-mail-settings.general.imapServerName' => 'Installed IMAP/POP3 server',
    'server-mail-settings.general.changeImapServerName' => 'install and use another IMAP/POP3 server',
    'server-mail-settings.general.changeServerHint' => 'You can %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Maximum message size',
    'server-mail-settings.general.kbytes' => 'KBytes',
    'server-mail-settings.general.maxConnections' => 'Maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'The maximum number of servers (IMAP or POP3) started.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'The maximum number of mail users that can be logged in at the same time.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Maximum number of connections per IP address',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Maximum number of connections for a user per IP address',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) to accept from the same IP address.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) allowed for a mail user from each IP address.',
    'server-mail-settings.general.messageSubmission' => 'Enable SMTP service on port 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Enable SMTP service on port 587 on all IP addresses',
    'server-mail-settings.general.messageSubmissionBindTo' => 'On',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'all IP addresses',
    'server-mail-settings.general.outgoingEmailMode' => 'Outgoing mail mode',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Send from domain IP addresses',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Send from domain IP addresses and use domain names in SMTP greeting',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Send from the specified IP addresses',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'None',
    'server-mail-settings.general.subaddressing' => 'Enable email subaddressing',
    'server-mail-settings.general.subaddressingHint' => 'This option enables an ability to configure %%verpStyleLink%% email addresses for mail lists',
    'server-mail-settings.general.verpStyleLink' => 'VERP-style',
    'server-mail-settings.general.mboxQuotaWarning' => 'Enable mailbox quota warning',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Send a notification to mail users when their mailbox quota usage exceeds 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Customize the default mailbox quota warning',
    'server-mail-settings.general.fixSender' => 'Fix incorrectly set sender for outgoing mail',
    'server-mail-settings.general.fixSenderHint' => 'Automatically set valid email headers and sender envelope address for outgoing mail from domains to reduce chances of being treated as spam',

    'server-mail-settings.autodiscover.title' => 'Mail autodiscover',
    'server-mail-settings.autodiscover.description' => 'See how it works in the %%link%%',
    'server-mail-settings.autodiscover.link' => 'knowledge base',
    'server-mail-settings.autodiscover.enabled' => 'Enable mail autodiscover',
    'server-mail-settings.autodiscover.enabledHint' => 'Enabling this feature reconfigures all domains that have autodiscover turned on',
    'server-mail-settings.autodiscover.customServer' => 'Specify a custom domain name for mail autodiscover',
    'server-mail-settings.autodiscover.customServerHint' => 'Note: The domain name must be secured with a valid SSL/TLS certificate.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Reconfigure autodiscover DNS records',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Enabling this feature reconfigures all domains autodiscover DNS records that have autodiscover turned on',

    'server-mail-settings.relay.title' => 'Relay options',
    'server-mail-settings.relay.type' => "Relaying",
    'server-mail-settings.relay.open' => "open",
    'server-mail-settings.relay.openSpamWarning' => "Opening your mail relay exposes your mail server to spam.",
    'server-mail-settings.relay.openSpamChange' => "Keep the setting only if you want to temporarily test the mail server or your Plesk server is inside internal network not accessible via the Internet.",
    'server-mail-settings.relay.closed' => "closed",
    'server-mail-settings.relay.auth' => "authorization is required: ",
    'server-mail-settings.relay.notSupported' => "not supported by the mail server",
    'server-mail-settings.relay.change' => 'To enable Plesk to send notifications when the relay is closed, you can %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'change SMTP settings',
    'server-mail-settings.relay.pop3' => "POP3 before SMTP",
    'server-mail-settings.relay.lockTime' => "lock time",
    'server-mail-settings.relay.min' => "min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Use no relay restrictions for the following networks:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP address/mask",

    'server-mail-settings.outgoing.title' => 'Limitations on outgoing email messages',
    'server-mail-settings.outgoing.description' => 'The following limits are default. They can be overridden in each service plan and subscription. The limits do not work server-wide, but act as a template for the plans and subscriptions for which no custom limits were specified. Note that switching on the limitation of outgoing email messages can affect the mail server performance. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Learn more about limiting outgoing mail',
    'server-mail-settings.outgoing.enabled' => 'Turn on limitations on outgoing email messages',
    'server-mail-settings.outgoing.countRecipients' => 'Count the number of recipients instead of messages',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Enables mode that counts the number of recipients rather than messages when limiting Outgoing mail and counting statistics. For example, one message sent to 10 recipients will be counted as ten messages.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Default limit on outgoing messages from a mailbox (per hour)',
    'server-mail-settings.outgoing.domainLimit' => 'Default limit on outgoing messages from a domain (per hour)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Default limit on outgoing messages from a subscription (per hour)',
    'server-mail-settings.outgoing.unlimited' => 'Unlimited',
    'server-mail-settings.outgoing.sendmail' => 'Allow users and scripts to use Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Scripts and users will be able to send email messages (on behalf of the subscription\'s system user) by using Sendmail even if the limits for a mailbox and domain are exceeded. The maximum number of messages that can be sent through Sendmail will be defined by the limit for an entire subscription. This setting does not allow scripts to use Sendmail server-wide, but it acts as a default setting for service plans and subscriptions.',
    'server-mail-settings.outgoing.reportPeriod' => 'Show reports based on statistics for the last',
    'server-mail-settings.outgoing.reportPeriodHint' => 'The reports are created and the alert is shown on the Home page about attempts to exceed limits on outgoing mail during the specified period.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Send an email notification every',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'The notifications provide statistics on attempts to exceed limits on outgoing mail during the specified period.',
    'server-mail-settings.outgoing.periodP1D' => '1 day',
    'server-mail-settings.outgoing.periodP1W' => '1 week',
    'server-mail-settings.outgoing.periodP2W' => '2 weeks',
    'server-mail-settings.outgoing.periodP1M' => '1 month',
    'server-mail-settings.outgoing.periodPT15M' => '15 minutes',
    'server-mail-settings.outgoing.periodPT1H' => '1 hour',
    'server-mail-settings.outgoing.periodPT6H' => '6 hours',
    'server-mail-settings.outgoing.periodPT12H' => '12 hours',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'The limits on outgoing mail will not work for mail senders whose IP addresses are in the mail server\'s white list. For example, if there is localhost (127.0.0.0 / 8, ::1 / 128) in the white list, all mail from the local server will be successfully sent regardless of the limitations. Mail senders can use either local IP addresses (websites and custom scripts hosted on the local server) or external ones (customers who send mail from mail clients installed on their computers or mobile devices). To make the limits work for all mail senders (both local and external), remove all IP addresses and networks from the white list. Note that removing localhost (127.0.0.0 / 8, ::1 / 128) from the white list might disrupt the operation of websites and scripts that send mail from this server. For details about limitations on outgoing mail, see the Administrator\'s Guide, Protection from Outbound Spam.',
    'server-mail-settings.outgoing.relayIsOpen' => 'The mail relay is open: The limits on outgoing mail will not work.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'The limit on outgoing messages for a domain (%%value%%) cannot be greater than the limit for a subscription (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'The limit on outgoing messages for an email address (%%value%%) cannot be greater than the limit for a domain (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'The limit on outgoing messages for an email address (%%value%%) cannot be greater than the limit for a subscription (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Mailman settings',
    'server-mail-settings.mailman.secureLinks' => 'Use secure links in maillists',
    'server-mail-settings.mailman.secureLinksHint' => 'Enable or disable secure (HTTPS) link generation in mailing lists.',
    'server-mail-settings.mailman.noLocalhost' => 'To use mailing lists, you need to have localhost (127.0.0.0/8, ::1/128) in the mail server\'s white list. However, to use outgoing mail control, you should not have localhost in the white list. As a compromise, if you activated outgoing mail control, you can use mail forwarding on the mailbox instead of mailing lists.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'To use mailing lists, you need to have localhost in the mail server\'s white list. However, to use outgoing mail control, you should not have localhost in the white list. As a compromise, if you activated outgoing mail control, you can use mail forwarding on the mailbox instead of mailing lists. Note that there are no IPv4 localhost addresses (127.0.0.0/8) in the white list now, so outgoing mail control will work for IPv4 addresses.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'To use mailing lists, you need to have localhost in the mail server\'s white list. However, to use outgoing mail control, you should not have localhost in the white list. As a compromise, if you activated outgoing mail control, you can use mail forwarding on the mailbox instead of mailing lists. Note that there are no IPv6 localhost addresses (::1/128) in the white list now, so outgoing mail control will work for IPv6 addresses.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Enable DMARC to check incoming mail',
    'server-mail-settings.spam-filter.dmarcHint' => 'This option is available when DKIM and SPF are switched on for incoming mail.',
    'server-mail-settings.spam-filter.dkim' => 'DKIM spam protection',
    'server-mail-settings.spam-filter.singOutgoing' => 'Allow signing outgoing mail',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Verify incoming mail',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'This option cannot be switched off while DMARC is switched on for incoming mail.',
    'server-mail-settings.spam-filter.spf' => 'SPF spam protection',
    'server-mail-settings.spam-filter.spfEnabled' => 'Enable SPF spam protection to check incoming mail',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'This option cannot be switched off while DMARC is switched on for incoming mail.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'SPF checking continues when there are DNS lookup problems',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'First, SPF performs a DNS lookup. Select this option to continue checking if the DNS lookup fails. This option is cleared if it has no effect in the current checking mode.',
    'server-mail-settings.spam-filter.behavior' => 'SPF checking mode',
    'server-mail-settings.spam-filter.behaviorHint' => 'Then, SPF applies local and guess rules. The message can be rejected depending on the selected checking mode and checking result.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Only create Received-SPF headers, never block',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Use temporary error notices when you have DNS lookup problems',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Reject mail when SPF resolves to "fail" (deny)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Reject mail when SPF resolves to "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Reject mail when SPF resolves to "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Reject mail when SPF does not resolve to "pass"',
    'server-mail-settings.spam-filter.localRules' => 'SPF local rules',
    'server-mail-settings.spam-filter.guessRules' => 'SPF guess rules',
    'server-mail-settings.spam-filter.explanationText' => 'SPF explanation text',
    'server-mail-settings.spam-filter.rbl' => "Spam protection based on DNS blackhole lists",
    'server-mail-settings.spam-filter.rblEnabled' => "Turn on spam protection based on DNS blackhole lists",
    'server-mail-settings.spam-filter.rblServer' => "DNS zones for DNSBL service",
    'server-mail-settings.spam-filter.rblServerHint' => "Separate entries with a semicolon, for example: 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Extra auto-reply headers',
    'server-mail-settings.auto-reply-headers.description' => 'Set up extra headers for any auto-reply message coming from Plesk server.',
    'server-mail-settings.auto-reply-headers.extra' => 'Extra headers',

    'server-mail-settings.pop3-names.title' => "Names for POP3/IMAP mail accounts",
    'server-mail-settings.pop3-names.disabled' => "Only full names of POP3/IMAP mail accounts can be used",
    'server-mail-settings.pop3-names.enabled' => "Short (webmaster) and full (webmaster@domain.com) names of POP3/IMAP mail accounts can be used.",

    'server-mail-settings.success' => 'Mail server settings were changed.',

    'server-mail-spam-filter.general' => 'General',
    'server-mail-spam-filter.isEnabled' => 'Turn on server-wide SpamAssassin spam filtering',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Apply individual settings to spam filtering',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Spam Filter is turned off: the mail server does not support spam filter settings on the mailbox level.",
    'server-mail-spam-filter.settings' => 'SpamAssassin Settings',
    'server-mail-spam-filter.requiredHits' => 'The score that a message must receive to qualify as spam',
    'server-mail-spam-filter.maxMailLimit' => 'Do not filter if the mail size exceeds this value',
    'server-mail-spam-filter.maxMailLimitText' => 'size limit',
    'server-mail-spam-filter.kbytes' => "KBytes",
    'server-mail-spam-filter.maxThreadsLimit' => 'Number of threads that spam filter can create',
    'server-mail-spam-filter.tag' => 'Add the following text to the beginning of the subject of each message recognized as spam',
    'server-mail-spam-filter.byTag' => 'by tag',
    'server-mail-spam-filter.alarmMessage' => 'Spam detection alert text',
    'server-mail-spam-filter.languages' => 'Trusted languages',
    'server-mail-spam-filter.locales' => 'Trusted locales',
    'server-mail-spam-filter.success' => 'Spam filter settings were changed.',

    'service-instance.setup-instance.resourcesSection' => 'Service Resources',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Already installed',
    'service-instance.setup-instance.requirementsSection' => 'Required Services',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Not selected',

    'service-node.ipAddress' => 'Service node IP address',
    'service-node.ipAddressLocal' => 'Local service node',
    'service-node.description' => 'Service node description',
    'service-node.accessKey' => 'Password',
    'service-node.useAccessKey' => 'Use authentication',
    'service-node.useAccessKeyDescription' => 'Hint about using authentication.',
    'service-node.oldAccessKey' => 'Old password',
    'service-node.newAccessKey' => 'New password',
    'service-node.noAccessKeySpecified' => 'Password is not specified',

    'service-plan.admin-plan.subscription_section' => 'Common',
    'service-plan.admin-plan.tools_section' => 'Tools & Resources',
    'service-plan.admin-plan.apps_section' => 'Applications & Databases',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk Appearance',
    'service-plan.admin-plan.statistics_section' => 'Statistics',
    'service-plan.admin-plan.general_section' => 'General',
    'service-plan.admin-plan.mail_section' => 'Mail',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Extensions',
    'service-plan.admin-plan.troubleshooting_section' => 'Assistance and Troubleshooting',
    'service-plan.admin-plan.simplePanel' => 'Restricted Mode',
    'service-plan.admin-plan.enabled' => 'Enable Restricted Mode',
    'service-plan.admin-plan.enabledDescription' => 'Select this option to limit the number of actions the administrator can take in Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Select this option to limit the number of actions the additional administrator can take in Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Provide only applications that I select',
    'service-plan.applications-subscription.useFilterDescription' => 'Use this option to select the applications that should be available to the subscriber.',
    'service-plan.applications-subscription.applications' => 'Applications',
    'service-plan.applications-subscription.isCommercial' => 'This app is commercial and requires purchasing a license key.',

    'service-plan.applications.useFilterLabel' => 'Provide only applications that I select',
    'service-plan.applications.useFilterDescription' => 'Use this option to select the applications that should be available to subscribers.',
    'service-plan.applications.applications' => 'Applications',
    'service-plan.applications.isCommercial' => 'This app is commercial and requires purchasing a license key.',

    'service-plan.dns.dnsZoneType' => 'Domain DNS zone',
    'service-plan.dns.dnsZoneTypeMaster' => 'Primary',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secondary',

    'service-plan.extras.groupOtherServices' => 'Other Services',
    'service-plan.extras.none' => 'None',

    'service-plan.hosting.enablePhysicalHosting' => 'Enable hosting',
    'service-plan.hosting.sectionCoreHosting' => 'General Properties',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Default Database Server',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Advanced',
    'service-plan.hosting.phpSettingsHelpLink' => 'Learn how to choose the most suitable PHP settings',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Status of websites if this subscription is suspended',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status of websites in suspended subscriptions',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'The selected status will be applied to all websites under the plan\'s subscriptions when the supscription is suspended (for example, it expires or its paid period expires).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'The selected status will be applied to websites when the supscription is suspended (for example, it expires or its paid period expires).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Disabled',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Websites visitors will be redirected to the web server\'s default page.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspended',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Websites visitors will be redirected with the search engine-friendly 503 HTTP code to the custom error document page.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Active',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Websites will stay accessible from the Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Allocate shared IP addresses',
    'service-plan.ip.allocateExclusiveIp' => 'Allocate dedicated IP addresses',
    'service-plan.ip.allocateExclusiveIpV4' => 'Allocate dedicated IPv4 addresses',
    'service-plan.ip.allocateExclusiveIpV6' => 'Allocate dedicated IPv6 addresses',

    'service-plan.mail.mailService' => 'Mail service',
    'service-plan.mail.mailServiceDisabled' => 'Disabled',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Disabled for incoming mail',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk will not provide any mail services on domains.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Domains can only send mail, and only using Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Enabled',
    'service-plan.mail.mailServiceEnabledHint' => 'Domains can send and receive mail.',
    'service-plan.mail.mailServiceNotConfigured' => 'Not configured',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk will not provide any mail services on domains.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Switch on mailing lists',
    'service-plan.mail.mailToNonExistentUser' => 'Policy on mail for non-existent users',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Bounce with message',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Forward to address',
    'service-plan.mail.mailToNonExistentUserReject' => 'Reject',
    'service-plan.mail.mailAutodiscovery' => 'Enable mail autodiscover',
    'service-plan.mail.mailAutodiscoveryDescription' => 'See how it works in the <a href="%%link%%" target="_blank">knowledge base</a>',
    'service-plan.mail.bounceMessage' => 'This address no longer accepts mail.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redirect to an external mail server with the IP address',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - disabled',

    'service-plan.misc.retainEnabled' => 'Retain web and traffic statistics for',
    'service-plan.misc.logRotation' => 'Log rotation',
    'service-plan.misc.logRotationCondition' => 'Log rotation condition',
    'service-plan.misc.logRotationBySize' => 'By size',
    'service-plan.misc.logRotationByTime' => 'By time',
    'service-plan.misc.logRotationDaily' => 'Daily',
    'service-plan.misc.logRotationWeekly' => 'Weekly',
    'service-plan.misc.logRotationMonthly' => 'Monthly',
    'service-plan.misc.logRotationSizeDescription' => 'Size value must be between %%min%% and %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maximum number of log files',
    'service-plan.misc.compress' => 'Compress log files',
    'service-plan.misc.sendLogToEmail' => 'After Plesk retrieves data from log files of web and FTP servers, email the logs to this address',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'months',
    'service-plan.misc.logRotationPeriodGreater' => 'The log rotation period cannot be longer than the server-wide limit %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'If switched off, all websites of a subscription use the same IIS application pool dedicated for the subscription.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Select services and privileges provided with the subscription.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Show more available permissions',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Show less permissions',
    'service-plan.permissions-subscription.noShellManagement' => 'Not allowed',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Management of access to the server over SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Allows customers to switch SSH on for their system user. Makes the "SSH access to the server shell under the subscription\'s system user" hosting parameter act as a preset.',

    'service-plan.permissions.permissionsTabDescription' => 'Select the services and permissions provided with the plan.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Select services and privileges that will be added to subscriptions with this add-on plan. Note that the permissions which are not selected in the add-on will not modify subscription parameters in any way.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Permissions enable customers to change specific settings of their subscriptions. When a subscription is created, Plesk applies the preset values from the plan to the settings the customer can change. Afterwards, updating the plan or applying an add-on plan does not override changes made by the customer.',
    'service-plan.permissions.showMorePermissions' => 'Show more available permissions',
    'service-plan.permissions.hideMorePermissions' => 'Show less permissions',
    'service-plan.permissions.noShellManagement' => 'Not allowed',
    'service-plan.permissions.systemAccessLabel' => 'Management of access to the server over SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Makes the hosting parameter "SSH access to the server shell under the subscription\'s system user" act as a preset.',

    'service-plan.resources-subscription.overusePolicy' => 'Overuse policy',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Overuse is not allowed',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Disallow overuse of resources. A subscription is automatically suspended if the resource usage exceeds the limit values.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Overuse of disk space and traffic is allowed',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Allow overuse of disk space and traffic. Disallow overuse of other resources.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Overuse is allowed (not recommended)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Allow the subscriber to use more resources than initially provided with the subscription.',
    'service-plan.resources-subscription.overuseNotify' => 'Notify me by email in cases of overuse.',
    'service-plan.resources-subscription.oversellPolicy' => 'Overselling policy',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Overselling is allowed',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Overselling allows a reseller to sell more resources than is allocated to them with a subscription. If overselling is allowed, a reseller is governed by actual resource usage instead of initial resource allocation.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Overselling is not allowed',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'If overselling is not allowed, a reseller can only sell as much resources as initially allocated to them with a subscription, regardless of how much of those resources are actually used.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Define limits on usage of resources provided with the subscription.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Show more available resources',
    'service-plan.resources-subscription.hideMoreResources' => 'Show less resources',

    'service-plan.resources.overusePolicy' => 'Overuse policy',
    'service-plan.resources.overusePolicyNotAllowed' => 'Overuse is not allowed',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Disallow overuse of resources. A subscription is automatically suspended if the resource usage exceeds the limit values.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Overuse of disk space and traffic is allowed',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Allow overuse of disk space and traffic. Disallow overuse of other resources.',
    'service-plan.resources.overusePolicyAllowed' => 'Overuse is allowed (not recommended)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Allow customers to use more resources than initially provided by the plan.',
    'service-plan.resources.overuseNotify' => 'Notify me by email in cases of overuse.',
    'service-plan.resources.oversellPolicy' => 'Overselling policy',
    'service-plan.resources.oversellPolicyAllowed' => 'Overselling is allowed',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Overselling allows a reseller to sell more resources than is allocated to them with a plan. If overselling is allowed, a reseller is governed by actual resource usage instead of initial resource allocation.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Overselling is not allowed',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'If overselling is not allowed, a reseller can only sell as much resources as initially allocated to them with a plan, disregarding of how much of those resources are actually used.',
    'service-plan.resources.mainGroupTitle' => 'Define the resources provided with the plan.',
    'service-plan.resources.additionalGroupTitle' => 'Show more available resources',
    'service-plan.resources.hideMoreResources' => 'Show less resources',
    'service-plan.resources.allowSitebuilderUpsell' => 'Allow customer to create trial Presence Builder websites.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'This setting allows customer to create more Presence Builder websites than provided by the service plan. Customer will have to purchase these websites in order to publish them.',

    'service-plan.servicePlanName' => 'Service plan name',
    'service-plan.resellerPlanName' => 'Reseller plan name',
    'service-plan.addonPlanName' => 'Add-on plan name',
    'service-plan.adminPlanPermissionsTab' => 'Administrative Tools',
    'service-plan.adminPlanPermissionsTabDescription' => 'Select the features available to the administrator when Restricted Mode is enabled.',
    'service-plan.hostingPermissionsTab' => 'Hosting Tools',
    'service-plan.hostingPermissionsTabDescription' => 'Select the web hosting tools and settings available to the administrator in Power User view when Restricted Mode is enabled.',
    'service-plan.resourcesTab' => 'Resources',
    'service-plan.resourcesTabDescription' => 'Define the resources provided with the plan, and policy on the resource usage.',
    'service-plan.subscriptionResourcesTabDescription' => 'Define the resources provided with the subscription, and policy on the resource usage.',
    'service-plan.hostingTab' => 'Hosting Parameters',
    'service-plan.hostingTabDescription' => 'Specify the parameters of the hosting service provided with the plan. Note that hosting settings specified in the add-on plan are not applied to subscriptions that were granted the "Hosting settings management" permission either by the service plan or the add-on plan.',
    'service-plan.secureSettingsDescription' => 'If you want the provided hosting to be the most secure, %%link%%. Note that some of the permissions, if granted, let subscribers change these settings. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'apply secure settings preset',
    'service-plan.secureSettingsHelpLink' => 'Learn about secure hosting setting',
    'service-plan.mailTab' => 'Mail',
    'service-plan.mailTabDescription' => 'Specify parameters of the mail service provided with the plan.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Specify parameters of the DNS service provided with the plan.',
    'service-plan.performanceTab' => 'Performance',
    'service-plan.performanceTabDescription' => 'Specify system parameters that affect performance of all services provided with the plan.',
    'service-plan.permissionsTab' => 'Permissions',
    'service-plan.miscTab' => 'Logs & Statistics',
    'service-plan.miscTabDescription' => 'Specify how statistics and logs of the plan\'s subscriptions should be stored. Note that these settings do not sync in subscriptions.',
    'service-plan.miscTabAdminPlanDescription' => 'Specify how statistics and logs of the subscriptions should be stored.',
    'service-plan.extrasTab' => 'Additional Services',
    'service-plan.extrasTabDescription' => 'Select the services that should be included in the plan in addition to web hosting, DNS, and mail services.',
    'service-plan.ipTab' => 'IP Addresses',
    'service-plan.ipTabDescription' => 'Define parameters of IP resources provided with the plan.',
    'service-plan.applicationsTab' => 'Applications',
    'service-plan.applicationsTabDescription' => 'Select the applications that should be available in the plan. You can choose to provide all applications available from the Application Catalog, plus those that you uploaded to the server, or select the applications manually. If you want to provide all available applications, then you do not need to do anything on this tab, just go to the Permissions tab and select the Access to Application Catalog option. If you want to select applications manually, you can do it on this tab.',
    'service-plan.applicationsTabDescription-addon' => 'Select the applications that should be available in the add-on.',
    'service-plan.applicationsTabDescription-subscription' => 'Select the applications that should be available in the subscription. You can choose to provide all applications available from the Application Catalog, plus those that you uploaded to the server, or select the applications manually. If you want to provide all available applications, then you do not need to do anything on this tab, just go to the Permissions tab and select the Access to Application Catalog option. If you want to select applications manually, you can do it on this tab.',
    'service-plan.planSyncSubsriptionWarning' => 'Some subscriptions were not synced with the plan. They were marked as \'Unsynced\' in the subscriptions list. To retry syncing, go to a subscription overview page and click the Sync button.',
    'service-plan.planSyncResellerWarning' => 'Some resellers were not synced with the plan. They were marked as \'Unsynced\' in the resellers list. To retry syncing, go to a reseller overview page and click the Sync button.',
    'service-plan.planSyncAdminWarning' => 'Unable to apply the changes to subscriptions because Plesk does not provide some of the services or resources affected by these changes. The reason: %%reason%%',
    'service-plan.duplicateName' => 'A plan with such a name already exists.',
    'service-plan.phpSettingsTab' => 'PHP Settings',
    'service-plan.phpHandlerNotFound' => 'Unable to retrieve information about the plan\'s PHP version. Reinstall it or select another PHP version for the service plan.',
    'service-plan.phpHandlerNotRegistered' => "PHP version %%fullVersion%% is not installed. PHP scripting for the domains using this service plan will be unavailable. Install PHP <nobr>version %%fullVersion%%</nobr> or select another PHP version for the service plan.",

    'service-plan.phpSettingsTabDescription' => 'Here you can specify per-subscription PHP settings that override the settings defined by the server-wide php.ini file. This may be useful, for example, when you want to limit the system resources consumption by customers\' PHP scripts. Customers (if allowed) can override this PHP configuration by their own per-domain configuration. When you set a parameter to the Default value, PHP will use the parameter\'s value from the server-wide PHP configuration. Note that the following placeholders are supported: {DOCROOT} and {WEBSPACEROOT} stand for the document root directory of a domain and a root directory of a subscription which gets custom PHP configuration; {TMP} stands for the directory which stores temporary files.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Here you can specify per-subscription PHP settings that override the settings defined by the main service plan. This may be useful, for example, when you want to remove some PHP limitations set in the main service plan. When you set a parameter to the Default value, PHP will use the parameter\'s value from the service plan PHP configuration. Note that the following placeholders are supported: {DOCROOT} and {WEBSPACEROOT} stand for the document root directory of a domain and a root directory of a subscription which gets custom PHP configuration; {TMP} stands for the directory which stores temporary files.',
    'service-plan.phpSettingsPhpVersion' => 'Your current PHP version is %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Here you can specify per-subscription PHP settings that override the settings defined by the server-wide php.ini file. When you set a parameter to the Default value, PHP will use the parameter\'s value from the server-wide PHP configuration.',
    'service-plan.webServerSettingsTab' => 'Web Server',
    'service-plan.webServerSettingsTabDescription' => 'Here you can specify Apache web server settings for this service plan. If Apache is running with nginx as a frontend server, you can specify the nginx settings on this page as well. All newly created domains will receive the specified settings. However, when you change these settings, existing domains will not receive the changes.',
    'service-plan.servicesTab' => 'Services',
    'service-plan.servicesTabDescription' => 'Here you can specify services assigned to the service plan.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% Properties',
    'service-plan.servicePropertiesTabDescription' => 'Here you can specify the properties of %%serviceName%% service assigned to the service plan.',
    'service-plan.longTaskWarning' => 'You have %%subscriptionsCount%% subscriptions on this plan. Note that the sync task may require significant time and will be performed in the background.',
    'service-plan.hostingParametersTab' => 'Hosting Parameters',
    'service-plan.adminInfoSection' => 'Information for the administrator',
    'service-plan.descriptionInPanel' => 'Description',
    'service-plan.longDescription' => 'The specified description is too long.',
    'service-plan.conflictPermissions' => 'Unable to grant the following permissions because they conflict with the reseller plan: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Startup type',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatic',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Switch off',
    'services.change-startup-type.autoActionError' => 'Unable to set startup type to \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Unable to set startup type to \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Unable to set startup type to \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Reset to Default',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restore session parameters to default values.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Session parameters have default values.',
    'sessions.settings.idleTime' => 'Session idle time',
    'sessions.settings.disableCheckSessionIp' => 'Allow IP address changes during a single session',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controls',

    'settings-ui.interface-views.description' => "There are several product UI views available to you. Depending on which view you use, features and settings may be located in different places or even enabled / disabled. Different views are better suited to different types of users.",
    'settings-ui.interface-views.panelSimpleLink' => 'Tools & Settings > Restricted Mode Settings',
    'settings-ui.interface-views.useCustomView' => 'Enable Restricted Mode',
    'settings-ui.interface-views.useCustomViewHint' => 'Select this option to limit the number of actions the administrator can take in the Plesk Panel. To change the availability of the actions, go to %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'This view is best suited for managing websites, their files, databases, email accounts, web applications, and other services.',
    'settings-ui.interface-views.selectUiModeTitle' => "Select your interface",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Power User view (for developers and web agencies)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Service Provider view (for web hosting providers)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'This view is intended for server administrators who provide and sell web hosting services to their customers using service plans.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Hide bounce controls',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Hides the button that allows to set up how to process mail sent to non-existent email addresses',

    'settings-ui.branding.description' => 'Brand the Plesk interface by changing how the page appears in the browser\'s title bar and/or replacing the Plesk logo in the top-left corner.',
    'settings-ui.branding.buttonDefault' => 'Default Logo',
    'settings-ui.branding.sectionTitle' => 'Custom title',
    'settings-ui.branding.enableCustomTitle' => 'Enable custom title on Plesk pages',
    'settings-ui.branding.customTitle' => 'Title text',
    'settings-ui.branding.sectionLogo' => 'Custom logo',
    'settings-ui.branding.enableCustomLogo' => 'Enable custom panel logo',
    'settings-ui.branding.logo' => 'Logo file',
    'settings-ui.branding.logoUrl' => 'Logo URL',
    'settings-ui.branding.logoUrlEnabled' => 'Custom',
    'settings-ui.branding.logoUrlDisabled' => 'Default',
    'settings-ui.branding.sectionFavicon' => 'Custom favicon',
    'settings-ui.branding.enableCustomFavicon' => 'Enable custom favicon',
    'settings-ui.branding.sectionFaviconDesc' => 'The same favicon has to be uploaded in both formats for a better support in different browsers.',
    'settings-ui.branding.faviconSvg' => 'Favicon file SVG',
    'settings-ui.branding.faviconSvgHint' => 'Allowed format: SVG',
    'settings-ui.branding.faviconIco' => 'Favicon file ICO',
    'settings-ui.branding.faviconIcoHint' => 'Allowed format: ICO',
    'settings-ui.branding.show' => 'Show',
    'settings-ui.branding.updateSuccess' => 'Plesk branding properties were changed.',

    'sitebuilder.trial.description' => 'This page allows you to configure the Try and Buy mode (former Customer Acquisition Scenario). In this mode, the customer can create a website with all available functionality in the included Presence Builder application. However, publishing of trial websites is not available to customers until they purchase a hosting service plan or buy a plan add-on. The Try and Buy mode can also be granted to your existing customers through a hosting plan or a plan add-on. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Refer to documentation for more information.',
    'sitebuilder.trial.lifetimeLabel' => 'Trial website lifetime',
    'sitebuilder.trial.lifetimeUnits' => 'days',
    'sitebuilder.trial.lifetimeDescription' => 'This is how much time should pass before those trial websites that were not purchased by customers are removed from the server.',
    'sitebuilder.trial.signupLabel' => 'Enable public access to trial mode',
    'sitebuilder.trial.signupDescription' => 'If you want to attract customers by advertising hosting with Presence Builder and providing Presence Builder demo to them, enable public access to trial mode and publish trial mode access URL on your website.',
    'sitebuilder.trial.signupLinkLabel' => 'Trial mode access URL',
    'sitebuilder.trial.signupLinkDescription' => 'This URL will open Presence Builder in trial mode. Publish this URL on your website to advertise hosting with Presence Builder and attract customers.',
    'sitebuilder.trial.promotionLabel' => 'Display trial mode notification in Presence Builder editor',
    'sitebuilder.trial.promotionDescription' => 'Use this option if you want to display additional notification about Presence Builder working in trial mode.',

    'update-settings.policyHintForPum' => 'You can set up automatic installation of updates here. Notification email can be sent when updates are available for manual installation or were installed automatically.',
    'update-settings.policyHint' => 'Notification email can be sent when updates are available for manual installation or were installed automatically.',
    'update-settings.branchDisabledDescription' => 'Do not notify me about available upgrades',
    'update-settings.automaticPatchesInstallation' => 'Automatically install Plesk updates (Recommended)',
    'update-settings.automaticPatchesThirdParty' => 'Automatically install updates for third-party components shipped by Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Automatically install system package updates',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Note that this will also automatically install updates for third-party components shipped by Plesk',
    'update-settings.automaticPatchesNotification' => 'Notify about available and installed system package updates',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Email address',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Notification email frequency',
    'update-settings.daily' => 'Daily',
    'update-settings.weekly' => 'Weekly',
    'update-settings.generalSection' => 'General',
    'update-settings.notificationsSection' => 'Notifications',
    'update-settings.safeUpdatesSection' => 'Safe Updates',
    'update-settings.safeUpdatesSectionHint' => 'Plesk makes sure that system package updates are installed from the same repository that the packages were initially installed from. Such updates are considered safe. If you disable safe updates, your system packages manager might install updates from any repository in the system.',
    'update-settings.safeUpdatesSectionWarn' => 'We recommend that you leave safe updates enabled unless you are an advanced user. Indiscriminate updates of system packages from different repositories can negatively affect the functioning of your server.',
    'update-settings.allowSafeUpdates' => 'Enable safe updates for system packages',

    'requiredFields' => 'Required fields',
];
