<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
/**
 * Plesk-specific phpMyAdmin configuration.
 *
 * Do not modify this file, as your changes would be lost on Plesk update.
 *
 * All directives are explained in documentation in the doc/ folder
 * or at <https://docs.phpmyadmin.net/>.
 *
 * @package PhpMyAdmin
 */
declare(strict_types=1);

if (defined('CONFIG_FILE_USER') && is_readable(CONFIG_FILE_USER)) {
    include CONFIG_FILE_USER;
}

/**
 * This is needed for cookie based authentication to encrypt password in
 * cookie. Needs to be 32 chars long.
 */
$cfg['blowfish_secret'] = isset($GLOBALS['db_admin_secret']) ? $GLOBALS['db_admin_secret'] : '';

/**
 * Servers configuration
 */
$i = 1;
/* Authentication type */
$cfg['Servers'][$i]['auth_type'] = isset($GLOBALS['db_auth_type']) ? $GLOBALS['db_auth_type'] : 'cookie';
/* Server parameters */
$cfg['Servers'][$i]['host'] = isset($GLOBALS['db_host']) ? $GLOBALS['db_host'] : 'localhost';
$cfg['Servers'][$i]['port'] = isset($GLOBALS['db_port']) ? $GLOBALS['db_port'] : '';
/* User/password-pair used to connect to the MySQL server (when 'auth_type' is 'config') */
$cfg['Servers'][$i]['user'] = isset($GLOBALS['db_user']) ? $GLOBALS['db_user'] : '';
$cfg['Servers'][$i]['password'] = isset($GLOBALS['db_pass']) ? $GLOBALS['db_pass'] : '';
$cfg['Servers'][$i]['only_db'] = isset($GLOBALS['db_name']) ? $GLOBALS['db_name'] : '';
/**
 * End of servers configuration
 */

/**
 * Directories for temporary files
 */
$cfg['TempDir'] = TEMP_DIR;
$cfg['SessionSavePath'] = TEMP_DIR;

/**
 * Other general settings
 */
$cfg['PmaNoRelation_DisableWarning'] = true;
$cfg['MysqlMinVersion'] = [
    'internal' => 50015,
    'human' => '5.0.15',
];

/* Do not check for updates */
$cfg['VersionCheck'] = false;
