<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'edit.title' => 'Mail Settings for %%domain%%',
    'edit.updatedSuccessfully' => 'Mail settings for %%domain%% were successfully updated.',
    'edit.invalidEmailAddressLocalWarning' => 'Since the outgoing mail control is switched on, the email address specified for mail forwarding (%%address%%) should belong to the selected domain. If it does not, then the messages sent to this address will not be counted in Outgoing Mail Control.',

    'list.title' => 'Mail',
    'list.tabTitle' => 'Mail Settings',
    'list.hint' => 'This is where you can change the mail service settings for domains or webspaces.',
    'list.buttonSwitchService' => 'Activate/Deactivate Services',
    'list.hintSwitchService' => 'Enable or disable mail services for the selected domains.',
    'list.buttonWebmail' => 'Webmail',
    'list.hintWebmail' => 'Change webmail for the selected domains.',
    'list.buttonBounceSettings' => 'Mail for Non-Existent Users',
    'list.hintBounceSettings' => 'Set up how to handle mail sent to non-existent email addresses under the selected domains.',
    'list.buttonOutgoingSpamSettings' => 'Limit Outgoing Messages',
    'list.hintOutgoingSpamSettings' => 'Set up the limit on the number of outgoing messages for the selected domains. From each domain, it will not be possible to send more messages than you specify.',
    'list.selectedDomainsHint' => 'Applied to domains',
    'list.switchServicePopupFormTitle' => 'Mail Services for Selected Domains',
    'list.switchServicePopupFormHint' => 'Here you can enable or disable mail services for the selected domains.',
    'list.fieldMailService' => 'Mail service',
    'list.fieldMailingLists' => 'Mailing lists',
    'list.fieldDomainKeys' => 'DKIM spam protection system to sign outgoing email messages',
    'list.fieldGreylisting' => 'Greylisting spam protection for all mail accounts under this domain',
    'list.confirmMailServiceNotConfigured' => 'Permanently remove all mailboxes of the affected domains, including received and sent emails.',
    'list.onService' => 'Enabled',
    'list.offService' => 'Disabled',
    'list.disabledIncomingService' => 'Disabled for incoming mail',
    'list.notConfigured' => 'Not configured',
    'list.intactService' => 'Do not change',
    'list.webmailPopupFormTitle' => 'Webmail for Selected Domains',
    'list.webmailPopupFormHint' => 'Here you can select a webmail app for the selected domains.',
    'list.fieldWebmail' => 'Webmail',
    'list.bounceSettingsPopupFormTitle' => 'Mail for Non-Existent Users for Selected Domains',
    'list.bounceSettingsPopupFormHint' => 'Here you can set up how to process mail sent to non-existent email addresses under the selected domains.',
    'list.fieldBounce' => 'What to do with mail for non-existent users',
    'list.optionBounceWithMessage' => 'Bounce with message',
    'list.optionBounceForward' => 'Forward to address',
    'list.optionBounceForwardDescription' => 'The address should belong to the selected domain. Only the administrator can specify an external address or one address for several domains.',
    'list.optionBounceReject' => 'Reject',
    'list.optionCatchIp' => 'Redirect to an external mail server with the IP address',
    'list.bounceMessage' => 'This address no longer accepts mail.',

    'outgoing-mail.title' => 'Outgoing Mail Control',
    'outgoing-mail.description' => 'When Plesk objects, such as mail accounts, domains, or subscriptions, are sending too many email messages, these might be spam messages. To see detailed statistics and edit limits on outgoing messages, go to %%link%%.',
    'outgoing-mail.linkTitle' => 'Outgoing Mail Control',

    'outgoing-messages.title' => 'Limiting Outgoing Messages for %%domain%%',
    'outgoing-messages.updatedSuccessfully' => 'The limit on the number of outgoing messages for %%domain%% was updated.',
    'outgoing-messages.domainOutgoingMessagesLimitIsNotSupported' => 'Limiting the number of outgoing messages is not supported for the domain %%domain%%.',

    'update-bounce-settings.stateChanged' => 'Mail bounce settings were successfully changed for the selected domains.',
    'update-bounce-settings.emptyBounceMessage' => 'The bounce message cannot be empty.',
    'update-bounce-settings.invalidEmailAddress' => 'The specified email address is not valid.',
    'update-bounce-settings.invalidEmailAddressLocalError' => 'The specified email address (%%address%%) is not allowed. Since the outgoing mail control is switched on, the address should belong to the selected domain. Only the administrator can specify an external email address in this case.',
    'update-bounce-settings.invalidEmailAddressLocalWarning' => 'Since the outgoing mail control is switched on, the email address specified for mail forwarding (%%address%%) should belong to the selected domain. If it does not, then the messages sent to this address will not be counted in Outgoing Mail Control.',
    'update-bounce-settings.invalidIpAddress' => 'The specified IP address is not valid.',

    'update-outgoing-messages.stateChanged' => 'The limit on the number of outgoing messages was changed for the selected domains.',
    'update-outgoing-messages.outgoingMessagesLimitValueInvalid' => 'The value must be in the range %%min%%..%%max%% for the domain %%domain%%. Only the Plesk administrator can adjust this setting.',
    'update-outgoing-messages.domainOutgoingMessagesLimitIsNotSupported' => 'Limiting the number of outgoing messages is not supported for the domain %%domain%%.',
    'update-outgoing-messages.mailSettingsManagementIsNotAllowed' => 'Mail settings management is not allowed for the domain %%domain%%.',

    'update-switch-service.stateChanged' => 'Mail service settings were successfully changed for the selected domains.',

    'update-webmail.stateChanged' => 'The webmail app was changed for the selected domains.',
    'update-webmail.mailServiceOff' => 'Could not change the webmail app for %%domain%%: The mail service is switched off.',
];
