<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Invalid value: "%value%". The value must be equal to or greater than %unitMin%, smaller or equal to %unitMax%, and cannot be 0.',
    'cgroups.unlimited' => 'Unlimited',
    'cgroups.period' => 'Invalid value: "%value%". The value must be 5 minutes, an hour, or a day, specified in seconds (300, 3600, or 86400).',

    'file.fileIsImageFalseType' => 'The file you are trying to upload is not image.',
    'file.fileUploadErrorIniSize' => 'The file you are trying to upload exceeds the defined ini size.',
    'file.fileUploadErrorFormSize' => 'The file you are trying to upload exceeds the defined form size.',
    'file.fileUploadErrorPartial' => 'The file was uploaded only partially.',
    'file.fileUploadErrorNoFile' => 'The file was not uploaded.',
    'file.fileUploadErrorNoTmpDir' => 'No temporary directory was found for the file you are trying to upload.',
    'file.fileUploadErrorCantWrite' => 'The file you are trying to upload cannot be written.',
    'file.fileUploadErrorExtension' => 'The extension returned an error while uploading the file.',
    'file.fileUploadErrorAttack' => 'The file was uploaded illegally; this can be an intrusion attempt.',
    'file.fileUploadErrorFileNotFound' => 'The file you are trying to upload was not found.',
    'file.fileUploadErrorUnknown' => 'An unknown error occurred while uploading the file.',
    'file.fileExtensionFalse' => 'The file you are trying to upload has an extension which is not allowed.',
    'file.fileExistsDoesNotExist' => 'The specified file or directory does not exist.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' appears to be an IP address, but IP addresses are not allowed",
    'hostname.hostnameUnknownTld' => "'%value%' appears to be a DNS hostname but cannot match TLD against known list",
    'hostname.hostnameDashCharacter' => "'%value%' appears to be a DNS hostname but contains a dash (-) in an invalid position",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' appears to be a DNS hostname but cannot match against hostname schema for TLD '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' appears to be a DNS hostname but cannot extract TLD part",
    'hostname.hostnameInvalidHostname' => "'%value%' does not match the expected structure for a DNS hostname",
    'hostname.hostnameInvalidLocalName' => "'%value%' does not appear to be a valid local network name",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' appears to be a local network name but local network names are not allowed",

    'port.notBetween' => 'The specified port value is invalid. It should be between 1 and 65535, inclusively',

    'isEmpty' => 'This required field is empty. You need to specify a value.',
    'stringLengthTooShort' => "'%value%' is less than %min% characters.",
    'stringLengthTooLong' => "'%value%' is greater than %max% characters.",
    'regexNotMatch' => "'%value%' does not match the pattern '%pattern%'.",
    'notAlnum' => "'%value%' has non-alphanumeric characters. Make sure you are using only alphanumeric characters.",
    'stringEmpty' => "'%value%' is empty.",
    'loginSyntax' => 'You can use alphanumeric, dash (-), dot (.), single quote (\'), percent (%) and underscore (_) symbols in the user name. The user name should start with an alphanumeric symbol.',
    'loginExists' => 'User account %value% already exists.',
    'cu_admin_alias__login_exists' => 'User account already exists.',
    'loginPassword' => 'The password should not contain the username.',
    'passwordSyntax' => 'The password contains the characters that are not allowed: %chars%.',
    'passwordLength' => 'The password length must be between %minLength% and %maxLength% characters.',
    'domain_invalid_name' => 'The specified domain name is not valid. You need to specify a valid domain name like domain.com.',
    'dns_domain_invalid_name' => 'The specified domain name is not valid.',
    'dns_domain_template_invalid_name' => 'The specified domain name template is not valid.',
    'not_ascii_string' => 'Value is not a valid ASCII string.',
    'virtual_directory_name_invalid' => 'Use only alphanumeric, underscore and dash characters in directory name.',
    'virtual_directory_name_reserved' => 'This name is reserved.',
    'invalid_city_name' => 'The city name entered is not valid',
    'invalid_country_code' => 'Invalid country code',
    'not_specified_country_code' => 'Country is a required field, it should be specified explicitly.',
    'invalid_system_user_login' => 'System user login is invalid',
    'invalid_rfc_domain_name' => 'The specified domain name is not a valid RFC domain',
    'idn_name_conversion' => 'Failed to convert domain name from IDN to Punycode',
    'domain_label_too_long' => 'None of the parts of the domain\'s name can exceed 63 characters in length.',
    'domain_label_too_long_idn' => 'The domain uses an internationalized domain name. None of the parts of its name, when converted to Punycode, can exceed 63 characters in length.',
    'domain_starts_with_www' => 'Please enter a domain name without the \'www\' prefix. The www prefix for the domain will be automatically added to the web server configuration.',
    'domain_already_exists' => 'This domain name already exists.',
    'domain_without_www_already_exists' => 'This domain name already exists without the \'www\' prefix.',
    'domain_with_www_already_exists' => 'This domain name already exists with the \'www\' prefix.',
    'subdomain_conflicts_with_existing_domain' => 'There is a domain with the same name as the subdomain \'%value%\'.',
    'restrict_domain_creation' => 'The specified domain name is prohibited by the server-wide policy. If this domain belongs to you, please contact your hosting provider.',
    'dns_record_already_exists' => 'This DNS record already exists.',
    'domain_like_hostname' => 'This domain name is the same as hostname of the server.',
    'passwordsNotMatch' => 'The passwords you entered do not match each other.',
    'stringsNotEqual' => 'The values are not equal.',
    'equalMailAliases' => 'The specified email alias is the same as another email alias.',
    'mailAliasExist' => 'The specified email alias already exists.',
    'mailNameExist' => 'The specified email address already exists.',
    'mailListExist' => 'The specified address is already assigned to a mailing list.',
    'mailAutoReplyHeadersSpaceError' => "Auto-reply headers mustn't contain space",
    'mailAutoReplyHeadersInvalidValueError' => 'Some fields are empty or contain an improper value.',
    'sysUserExist' => 'The specified username is already used by another system user. Please specify another username.',
    'emailAddressInvalid' => 'The specified email address is not valid. Specify a valid one that matches the following pattern: johndoe@example.com.',
    'emailAddressInvalidLocal' => 'The specified email address is not valid. The email address must belong to the selected domain. Only the administrator can specify external email addresses in this case.',
    'emailAddressSpecialNames' => 'The specified email address is invalid. The username part of the address must not start with a reserved system name (like con, lpt1, prn) separated by the dot (.) symbol from the rest of the username.',
    'longAddress' => 'The email address is too long.',
    'longMailboxAddressMailServer' => 'The username part of the email address is too long for this mail server. Please specify a username no longer than %%max%% symbols.',
    'longFullAddressMailServer' => 'The email address is too long for this mail server. Please specify an address no longer than %%max%% symbols.',
    'dir_invalid_name' => 'Invalid destination directory.',
    'directoryHidesDomain' => 'This directory cannot be used because it would overlap website located at %path%. Such overlapping would make the website unavailable.',
    'directoryHidesAnotherApplication' => 'This directory cannot be used because it would overlap another app installed at %path%. Such overlapping would make the installed app unavailable.',
    'directoryIsBehindAnotherApplication' => 'This directory cannot be used because it would be overlapped by another app installed at %path%. Such overlapping would make the app unavailable.',
    'domainLoginSyntaxWindows' => 'The username must start with an alphabetic character and cannot exceed %%maxlength%% characters in length. All but first characters can be lowercase alphanumeric, the dash, the dot, and the underscore. The username cannot end with the dot.',
    'domainLoginSyntaxUnix' => 'The username must be no longer than %%maxlength%% characters and contain only lowercase alphanumeric characters, the dash, and the underscore. The username should start with a lowercase alphabetic character',
    'notLocalMssqlHost' => 'Not a local MSSQL host name',
    'invalidMailTo' => 'Not a valid mailto: link',
    'passwordsNotEqual' => 'The passwords you entered do not match each other.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "The image '%value%' you are trying to upload is too wide ('%width%'). Uploaded images cannot be wider than '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "The image '%value%' you are trying to upload is not wide enough ('%width%'). Uploaded images should be at least '%minwidth%' wide.",
    'fileImageSizeHeightTooBig' => "The height of image '%value%' you are trying to upload is too big ('%height%'). Uploaded images cannot exceed '%maxheight%' in height.",
    'fileImageSizeHeightTooSmall' => "The height of image '%value%' you are trying to upload is too small ('%height%'). Uploaded images cannot be less than '%minheight%' in height.",
    'fileImageSizeNotDetected' => "The size of image '%value%' you are trying to upload could not be detected.",
    'fileImageSizeNotReadable' => "The image '%value%' you are trying to upload cannot be read.",
    'passwordConfirmation' => 'Confirm password',
    'databaseUserNameExists' => 'A database username with the name %value% already exists.',
    'invalidUserName' => 'Database user name contains not allowed characters.',
    'longUserName' => 'Database user name is greater than %%max%% characters.',
    'forbiddenName' => 'Database user name "%value%" is not permitted.',
    'invalidAdminLogin' => 'Unable to use the selected user\'s credentials for administrator\'s access. The specified username is not valid: %%cause%%',
    'invalidAdminPassword' => 'Unable to use the selected user\'s credentials for administrator\'s access. The specified password is not valid: %%cause%%',
    'passwordLengthTooShort' => "the password is shorter than %min% characters.",
    'passwordLengthTooLong' => "the password is longer than %max% characters.",
    'passwordRegexNotMatch' => "the password does not match the pattern '%pattern%'.",
    'fileSharingEmptyFolderName' => "You need to specify a folder name.",
    'fileSharingInvalidFolderName' => "The specified folder name is not valid. It cannot contain any of the following characters: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Cannot create a folder with the specified name because a folder with such a name already exists.",
    'invalidUrl' => 'The specified address is not valid. You need to specify a valid address like http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'This directory name is reserved. Please specify another name for your virtual directory.',
    'domainVirtualdirectoryInvalidName' => 'A directory name should contain only alphanumeric, underscore, and dash characters.',
    'filesharingPathUnavailable' => 'A directory with such a name already exists under the specified domain. Please use another directory name.',
    'filesharingSslNotAvailableOnDomain' => 'You selected to use secure links but the domain has no SSL/TLS enabled. Please either select a domain with SSL/TLS support or clear the Generate secure links check box.',
    'filesharingSslRedirectOnDomain' => 'The selected domain has the "Permanent SEO-safe 301 redirect from HTTP to HTTPS" option enabled. To set up file sharing, either select a domain that has this option disabled or select the "Generate secure links to files and folders" checkbox.',
    'filesharingSslNotAvailableOnDefaultDomain' => 'You selected to use secure links on IP address or host name of the server, but such links can be created only on websites with SSL/TLS support. Please either set up a website with SSL/TLS support or clear the Generate secure links check box.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'You selected the server IP address to which a default domain is assigned. Please select a website as a root URL instead of the IP address.',
    'physicalPathOnDomainAlreadyExists' => 'A directory with such a name already exists.',
    'virtualPathOnDomainAlreadyExists' => 'A virtual directory with such a name already exists.',
    'sysUserLoginSyntaxWindows' => 'You can use alphanumeric, dash (-), dot (.), and underscore (_) symbols in the user name. The user name must start with an alphanumeric symbol.',
    'sysUserLoginSyntaxUnix' => 'You can use lowercase alphanumeric, dash (-), dot (.), and underscore (_) symbols in the user name. The user name must start with an alphanumeric symbol.',
    'docrootNotInWebspaceRoot' => 'The specified directory is not located within the subscription\'s root directory.',
    'docrootContainsSpecialCharacters' => 'The specified directory name contains symbols that cannot be used.',
    'docrootWithinProhibitedDirectory' => 'The specified directory contains a service directory.',
    'docrootWithinInstalledApplication' => 'The specified directory is overlapped by a web application installed at %path%.',
    'docrootIsNotDirectory' => 'The specified path cannot be used because its part refers to a file.',
    'docrootTooLongPart' => 'The specified directory name is too long.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'Wrong domain was selected.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Incorrect phone number was specified, it contained not allowed symbols.',
    'stateInvalid' => 'Incorrect state or province was specified.',
    'zipRegexNotMatch' => 'Incorrect postal or ZIP code was specified.',
    'limitValueInvalid' => 'The specified limit is invalid.',
    'softLimitValueInvalid' => 'The value must be in the range %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'The value must be in the range %%MIN%%..%%MAX%%. Only the Plesk administrator can adjust this setting.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'The size of an MS SQL database file must be an integer number between 0 and 16 TB.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'The size of an MS SQL database log file must be an integer number between 0 and 2 TB.',
    'limitDiskspaceValueInvalid' => 'The disk space limit must be an integer number between 0 and 4095 TB.',
    'limitTrafficValueInvalid' => 'The traffic limit must be an integer number between 0 and 4095 TB/month.',
    'limitMboxQuotaValueInvalid' => 'The mailbox size limit must be an integer number between 0 and 4095 TB.',
    'limitRetainPeriodValueInvalid' => 'The value for "Retain web and traffic statistics" in service plans cannot be less than the value for "Retain web and traffic statistics" in Tools & Settings > Server Settings. Specify an integer number greater than or equal to %%MIN%% and less than %%MAX%%.',
    'limitValueOverused' => 'The currently used amount of resources exceeds the specified limit value. You cannot specify a value less than %%used%%',
    'limitValueOverselled' => 'The resource usage limit of %%reserved%% is already assigned to subscriptions. You cannot specify a value less than %%reserved%%',
    'lessThan' => "'%value%' is less than '%min%'",
    'greaterThan' => "'%value%' is greater than '%max%'",
    'greaterThanDiskQuota' => "%value% is greater than disk quota (%max%)",
    'notDigits' => 'The value must be an integer number.',
    'digitsInvalid' => 'The value must be an integer number.',
    'digitsStringEmpty' => 'The value must be an integer number.',
    'isEqual' => "The value must not be equal to '%invalidValue%'.",
    'notInt' => 'The value must be an integer number.',
    'maillistNameInvalid' => 'The specified mailing list address is not valid.',
    'maillistReservedNameAlreadyExists' => 'The specified address is already reserved.',
    'maillistAlreadyExists' => 'The specified address is already used by a mailing list.',
    'maillistAlreadyExistsOnServer' => 'The specified name of mailing list is already used by other subscription',
    'mailnameAlreadyExists' => 'The specified email address already exists.',
    'mailaliasAlreadyExists' => 'The specified address is already used by an email alias.',
    'autoresponderEndDateIsInvalid' => 'The specified date should be in the future.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'legacyEstimator.passwordStrength' => 'Your password is not complex enough. According to the server policy, the minimal password strength is %strength%. Strong passwords must contain at least all of the following: %%length%% characters; one upper- or lowercase character; three numbers and one special character (!, @, #, $, %, ^, &, *, ?, _, ~) or one number and two special characters.',
    'legacyEstimator.passwordStrengthVeryWeak' => 'Very weak (not recommended, such a password could be brute-forced within 3 minutes)',
    'legacyEstimator.passwordStrengthWeak' => 'Weak (not recommended, such a password could be brute-forced within 5 minutes)',
    'legacyEstimator.passwordStrengthMediocre' => 'Medium (not recommended, such a password could be brute-forced within 7 minutes)',
    'legacyEstimator.passwordStrengthStrong' => 'Strong',
    'legacyEstimator.passwordStrengthStronger' => 'Very strong',
    'legacyEstimator.passwordStrengthVeryWeakHint' => 'These passwords are typically short and use only one type of characters (lower or upper-case characters or digits). Example: password. This security level prevents simplest password-guessing attacks.',
    'legacyEstimator.passwordStrengthWeakHint' => 'These passwords are typically short and mostly use one type of characters (lower or upper-case characters or digits) with a couple of characters of a different type. Example: password12. These passwords provide basic protection from password guessing.',
    'legacyEstimator.passwordStrengthMediocreHint' => 'These passwords are typically short and contain characters of at least two types (lower or upper-case characters, digits, or special characters). Example: Password12. Such passwords provide reliable protection from attacks that capture passwords.',
    'legacyEstimator.passwordStrengthStrongHint' => 'These passwords are at least 8 characters long and have at least one occurrence of upper and lower-case characters, digits, and special characters. Example: P@ssw0rd12. Such passwords provide strong protection from brute-force attacks.',
    'legacyEstimator.passwordStrengthStrongerHint' => 'These passwords are at least 16 characters long and include multiple occurrences of upper and lower-case characters, digits, and special characters. Example: ~!my_P@$$w0rD123. Such passwords provide the best possible protection, though they are rather hard to remember.',

    'zxcvbnEstimator.passwordStrength' => 'Your password is not complex enough. According to the server policy, the minimal password strength is %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Very weak (not recommended)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Weak (not recommended)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Medium',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Strong (recommended)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Very strong',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Can be easily brute forced. Vulnerable to credential stuffing and dictionary attacks.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Can be easily brute forced. Less vulnerable to credential stuffing and dictionary attacks.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Can be brute forced.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Hard to brute force. Some protection against offline attacks.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Impractical to brute force. Reasonable protection against offline attacks.',

    'emailCantBeRenamed' => "The server does not support renaming mail accounts.",
    'emailOwnedByAnotherUser' => "This email address is owned by another user.",
    'maillistAdminEmailShouldExistsOnDomain' => 'The email address of the mailing list administrator should be registered on the same domain as the mailing list.',
    'webmailExists' => "Webmail service '%value%' already exists.",
    'invalidDbName' => 'Database name can contain only alphanumeric, dot, dash, and underscore symbols.',
    'longDbName' => 'Database name is too long.',
    'dbNameClash' => 'Database name and database user name should be different.',
    'dbConnectFailed' => 'Unable to connect to the database server. Please check the database user credentials and access restrictions.',
    'databaseNameAlreadyExists' => 'A database with the name %value% already exists.',
    'wrongUrlSyntax' => 'The specified address is not valid. You need to specify a valid address like http://domain.com, relative/path or mailto:address',
    'connectionRefused' => 'Connection refused.',
    'loginIncorrect' => 'Wrong username',
    'failedToChangeDirectory' => 'Directory does not exist',
    'failedToChangeMode' => 'Failed to change mode',
    'failedToCreateDirectory' => 'File creation not allowed',
    'failedToRenameDirectory' => 'File renaming not allowed',
    'failedToDeleteDirectory' => 'File deletion not allowed',
    'ipInvalid' => "'%value%' does not appear to be a valid IP address or it belongs to a wrong type.",
    'ipMaskInvalid' => "'%value%' does not appear to be a valid IP address mask.",
    'ipInvalidForInterface' => 'The specified IP address cannot be used on network interface. You need to specify a valid IP address with subnet prefix range or mask.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'The specified IP address cannot be used on selected network interface because IPv6 support is switched off for this interface.',
    'ipAlreadyExists' => 'IP address %value% already exists.',
    'notInArray' => 'This option is not supported.',
    'ipAddressIsNotSelected' => 'At least one IP address must be selected.',
    'noServiceNodeSpecified' => 'Internal error: no service node specified.',
    'serviceNodeInvalidName' => 'Invalid service node name "%value%".',
    'serviceNodeNameAlreadyExists' => 'The service node with the name "%value%" already exists.',
    'serviceNodeIpUsed' => "Unable to remove the service node: the IP address is registered.",
    'serviceNodeIpAddressAlreadyExists' => 'The service node with the IP address "%value%" already exists.',
    'serviceNodeInvalidTransport' => 'Invalid transport name "%value%".',
    'app_non_unique_setting_value' => 'Another object has the same setting value. This setting must be unique for this object.',
    'wrongLocalUrlSyntax' => 'The specified address is invalid. Please specify a valid local address like /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'The ISAPI handler type is not supported by the current PHP version.',
    'dbNameNotExist' => 'The specified database does not exist.',
    'invalidBooleanValue' => 'The allowed values are "true" or "false".',
    'invalidMimeType' => 'The specified MIME type is invalid: "%value%".',
    'invalidHeaders' => 'The specified header is invalid: "%value%".',
    'invalidHandler' => 'The specified handler is invalid: "%value%".',
    'invalidAllowDeny' => 'The specified Allow/Deny directive is invalid: "%value%".',
    'nonUniqueAllowDeny' => 'The specified value for the Allow/Deny directive already exists: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'The number of IP addresses in the list must be less than or equal to %value%.',
    'invalidDirectoryIndex' => 'The specified root directory index file is invalid.',
    'invalidNginxProxyMode' => 'The specified value for the nginxProxyMode property is invalid. The allowed values are "true" or "false".',
    'invalidNginxTransparentMode' => 'The specified value for the nginxTransparentMode property is invalid. The allowed values are "true" or "false".',
    'invalidNginxServeStatic' => 'The specified value for the nginxServeStatic property is invalid. The allowed values are "true" or "false".',
    'invalidStaticFilesExtensions' => 'The specified static files extensions are invalid: "%value%".',
    'invalidNginxServePhp' => 'The specified value for the nginxServePhp property is invalid. The allowed values are "true" or "false".',
    'invalidDocuments' => 'The document name must not contain commas (",").',
    'duplicateDocuments' => 'The following documents already exist in the list of default documents: "%value%"',
    'protected_directory_invalid_login' => 'The login of a password protected directory user must be no longer than 20 alphanumeric characters. The login can also contain the dash symbol ("-"), but cannot start with it.',
    'notARelativePath' => 'The path must be relative',
    'cannotUseJunctions' => 'Cannot use junctions outside webspace as compilation temporary directory',
    'notBetween' => '"%value%" is not between "%min%" and "%max%", inclusively',
    'notBetweenStrict' => '"%value%" is not strictly between "%min%" and "%max%"',
    'redirectToMyself' => 'The website cannot be forwarded to itself. Enter the destination address different from the main website\'s URL.',
    'redirectToAlias' => 'The website cannot be forwarded to its alias. Enter the destination address different from the main website alias\'s address.',
    'relativePathInvalid' => 'The specified path is invalid.',
    'aspDotNetSettingsInvalid' => 'One or more of the specified values for ASP.NET settings are invalid.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'The value of the limit on outgoing messages for a mailbox must be greater than "%%MIN%%".',
    'domainOutgoingMessagesLimitValueInvalid' => 'The value of the limit on outgoing messages for a domain must be greater than "%%MIN%%".',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'The value of the limit on outgoing messages for a subscription must be greater than "%%MIN%%".',
    'iisAuthNotEnabled' => 'Anonymous or Windows authentication must be switched on in the web server settings for the domain.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'The value of the limit on outgoing messages for a mailbox must be a positive integer number or \'default\'. It can also be \'-1\' for the \'Unlimited\' value.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'The value of the limit on outgoing messages for a domain must be a positive integer number or \'default\'. It can also be \'-1\' for the \'Unlimited\' value.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'The value of the limit on outgoing messages for a subscription must be a positive integer number or \'default\'. It can also be \'-1\' for the \'Unlimited\' value.',
    'outgoingMessagesReportPeriodValueInvalid' => 'The specified value for the reporting period is not supported.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'The specified value for the notification period is not supported.',
    'textItemsListInvalid' => 'The specified item is invalid: "%value%".',
    'textItemsListInvalidMulti' => 'The specified items are invalid: "%value%".',
    'textItemsListNonUnique' => 'The specified value already exists: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'The number of items should not exceed %value%.',
    'invalidAcl' => 'The specified host is invalid: "%value%".',
    'nonUniqueAcl' => 'The specified value for host already exists: "%value%".',
    'httpInvalidStatusFormat' => 'Status codes must be numbers in the form 400 or 400.1',
    'httpInvalidStatusCode' => 'Status codes must be between %%minCode%% and %%maxCode%%',
    'httpInvalidStatusSubCode' => 'Sub-status codes must be between %%minSubCode%% and %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Status ranges should specify a range from a minimum to maximum value',
    'phpSettingValueByteRegexNotMatch' => 'An incorrect value was specified. Type in an integer number and a shorthand character (K for kilobyte, M for megabyte, G for gigabyte, for example, 128M) ',
    'phpFpmServersAmountNotPositive' => "The value must be a positive number",
    'phpFpmServersAmountLessThan' => "'%value%' is less than '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' is greater than '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Invalid INI syntax detected on line %%line%%: '%%text%%'",
    'portRangeInvalid' => 'The specified port range is invalid. The left value must be smaller than the right one.',
    'portRangeValueInvalid' => 'The %value% value in the port range is invalid. It must be in %min% - %max%.',
    'domainResolvesToAnotherIp' => 'The domain resolves to the incorrect IP address (%value%). To put your website online, correct %%dnsSettingsLink%%.',
    'domainNotResolved' => 'The domain is not resolvable. To put your website online, correct %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'DNS Settings',
    'backupPathInvalidCharacters' => '"%value%" contains invalid characters.',
    'backupPathInvalidDot' => '"%value%" contains an invalid path "." or "..".',
    'networkAccessAlreadyExists' => 'The network is already in the IP access restriction list.',
    'codeRegexNotMatch' => 'The activation code is not valid.',
    'nameUsedForPlesk' => 'Unable to create the domain because its name is found in the URL you used to log in to Plesk. To create the domain, log in to Plesk via https://%value%:8443 or https://plesk.%value%.',
    'invalidNameDirectory' => 'The specified name is invalid.',
    'invalidPasswordCharacters' => 'Password cannot contain quotes, spaces or national characters.',
    'invalidPasswordLength' => 'Password should be %%min%%-%%max%% characters length.',
    'passwordContainsLogin' => 'Password should not contain login.',
];
