<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'system-time.title' => "Systemets datum och tid",
    'system-time.timezone' => "Tidszon",
    'system-time.yourTimezone' => "Din tidszon",
    'system-time.dateAndTime' => "Datum och tid",
    'system-time.date' => "Datum",
    'system-time.time' => "Tid",
    'system-time.networkTime' => "Nätverkstid",
    'system-time.synchronizedSystemTime' => "Synkronisera systemtiden",
    'system-time.domainNameOrIp' => "Domännamn eller IP",
    'system-time.updateSystemTime' => "Uppdatera systemtid",
    'system-time.daylight' => "Justera klockan automatiskt för ändringar av sommartid",
    'system-time.hoursMinutesSeconds' => "Hours:Minutes:Seconds",
    'system-time.yearMonthDay' => "Year-Month-Day",

    'action-log.title' => "Åtgärdslogg inställningar",
    'action-log.logFiles' => "Loggfiler",
    'action-log.fromDate' => "Från:",
    'action-log.toDate' => "Till:",
    'action-log.clearLog' => "Rensa logg",
    'action-log.downloadLog' => "Hämta",
    'action-log.loggedActions' => "Loggade åtgärder",
    'action-log.storeLogsInDb' => "Lagra poster i databasen",
    'action-log.storeNumber' => "Poster",
    'action-log.dontRemoveRecs' => "Do not remove records",
    'action-log.confirmCleanLog' => "Vill du verkligen ta bort de valda åtgärdslogguppgifterna?",
    'action-log.incorrectDate' => "Felaktigt datum angavs.",
    'action-log.incorrectNumPeriods' => "Ogiltig rotationsperiod angiven.",
    'action-log.incorrectNumRecords' => "Ogiltigt antal poster angivna.",
    'action-log.yes' => "Ja",
    'action-log.no' => "Nej",
    'action-log.mixed' => "(mixed)",
    'action-log.period' => "Period",
    'action-log.invalidDatePeriod' => "Invalid date period",
    'action-log.submitDone' => "Förändringarna i åtgärdslogginställningarna har sparats.",
    'action-log.clearDone' => "Action log cleared.",
    'action-log.periodDay' => "dagar",
    'action-log.periodWeek' => "veckor",
    'action-log.periodMonth' => "månader",

    'admin-info.adminInfoSection' => 'Information för administratören',
    'admin-info.description-admin' => 'Administratörens beskrivning',
    'admin-info.description-reseller' => 'Återförsäljarens beskrivning',
    'admin-info.description-owner' => 'Ägarens beskrivning',
    'admin-info.description' => 'Beskrivning',
    'admin-info.descriptionSuccess' => 'Beskrivningen har uppdaterats.',
    'admin-info.longDescription' => 'Den angivna beskrivningen är för lång. Det kan blev inte längre än %%max%% symboler.',
    'admin-info.add' => 'Lägg till beskrivning',
    'admin-info.edit' => 'Redigera',
    'admin-info.remove' => 'Ta bort',
    'admin-info.confirmOnRemove' => 'Vill du verkligen ta bort beskrivningen?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% till kund %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% till återförsäljaren %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% till abonnemanget %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% av %%name%%',
    'admin-info.popupHint-admin' => 'Denna beskrivningen är synlig endast för administratören.',
    'admin-info.popupHint-reseller' => 'Denna beskrivningen är synlig endast för återförsäljaren och administratören.',
    'admin-info.popupHint-owner' => 'Denna beskrivningen är synlig endast för författaren och författarens värdtjänstleverantör.',
    'admin-info.customerDescriptionHint' => 'Kunder kan inte se denna beskrivningen.',
    'admin-info.subscriptionDescriptionHint' => "Denna informationen är synlig endast för värdtjänstleverantören (Plesk administratör eller återförsäljare).",

    'apache-settings.formGeneralHint' => 'Här kan du specificera Apache webbserverinställningar för denna webbplats. En anpassad Apache-konfiguration är användbar, till exempel när du vill använda en ny typ av indexfiler på din webbplats eller associera en viss MIME-typ med vissa filnamnstillägg. Standardvärdet innebär att Apache kommer att använda motsvarande direktiv från dess serveromfattande konfiguration. Om Apache körs med nginx som en frontend-server, kan du ange nginx-inställningar på denna sida också.',
    'apache-settings.general' => 'Vanliga Apache-inställningar',
    'apache-settings.example' => "Till exempel:\n%%example%%",
    'apache-settings.settingOn' => 'På',
    'apache-settings.settingOff' => 'Av (standard)',
    'apache-settings.settingDefault' => 'Standard',
    'apache-settings.settingCustom' => 'Ange anpassade värde',
    'apache-settings.mimeTypes' => 'MIME-typer',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME-typer associerar filnamnstillägg med filtyper. Vanligtvis används detta för att skapa en egen filnamnsförlängning för vanliga filtyper.',
    'apache-settings.handlers' => 'Hanterare',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache-hanterare definierar hur webbservern behandlar filer med vissa förlängningar när de begärs. Exempelvis betyder strängen \"php-script .script\" att Apache kommer att behandla .script-filer som php-skript.",
    'apache-settings.deny' => 'Neka åtkomst till webbplatsen',
    'apache-settings.allow' => 'Förutom',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivna värdarna och nätverken är förbjudna att komma åt siten. Använd '*' för att neka alla anslutningar.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe specificerade värddatorerna och nätverken får tillgng till webbplatsen.",
    'apache-settings.directoryIndex' => 'Index-filer',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache kommer att söka efter de angivna filerna när indexsidan för webbplatsen anropas.",
    'apache-settings.expires' => 'Expires (går ut)',
    'apache-settings.expiresStaticOnly' => 'svar med "Expires"-rubriker (går ut) endast för statiska filer',
    'apache-settings.expiresFullDescription' => 'Webbservern lägger till svarsrubriken "Expires" (går ut) på webbsidorna. Tidsstämpeln för detta får man genom att lägga till tidsintervallen ovanför tiden vid vilken man begär en webbsida.',
    'apache-settings.expiresStaticOnlyDescription' => 'Rubriken "Expires" (går ut) läggs endast till statiska filer. De filer som behandlas som statiska styrs av alternativen "Smart static files processing"  (Smart processning av statiska filer) och&#10;"Serve static files directly by nginx" (Serva statiska filer direkt genom nginx).',
    'apache-settings.expiresUnitDays' => 'dagar',
    'apache-settings.expiresUnitHours' => 'timmar',
    'apache-settings.expiresUnitMinutes' => 'minuter',
    'apache-settings.expiresUnitSeconds' => 'sekunder',
    'apache-settings.headers' => 'Ytterligare rubriker',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Webbservern kommer att lägga till de angivna HTTP-svarsrubriker.",
    'apache-settings.restrictFollowSymLinks' => 'Begränsa möjligheterna till att följa symboliska länkar',
    'apache-settings.restrictFollowSymLinksDescription' => "Markera detta valet för att förbjuda användare att använda FollowSymLink direktivet i  .htaccess  och för att förbättra säkerheten på servern.",
    'apache-settings.nginx' => 'nginx-inställningar',
    'apache-settings.nginxProxyMode' => 'Proxy-läge',
    'apache-settings.nginxProxyModeDescription' => 'Nginx-proxy-begäranden till Apache. Stäng av för att sluta använda Apache.',
    'apache-settings.nginxTransparentMode' => 'Smart processning av statiska filer',
    'apache-settings.nginxTransparentModeDescription' => 'Om avslaget, kommer Apache att processa alla förfrågningar för statiska filer. nginx kommer endast vidarebefordra förfrågningar och svar utan modifiering. Stäng av detta alternativ endast för felsökning.',
    'apache-settings.nginxServeStatic' => 'Serva statiska filer direkt genom nginx',
    'apache-settings.nginxStaticExtensions' => 'Ange filnamnstillägg separerade av blanksteg eller "|"-tecknet. Förfrågningar om dessa filer kommer att hanteras av nginx och når aldrig Apache. Obs: Apaches omskrivningsregler kommer inte att tillämpas.',
    'apache-settings.nginxServePhp' => 'Processa PHP med nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP-filer (.php) kommer att hanteras av nginx och PHP-FPM. Om det är avslaget, kommer PHP-filer att processas av Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maximal tillåten HTTP-anropstext',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Requests with body above the limit will be discarded with HTTP 413 Payload Too Large (configures the "client_max_body_size" nginx directive value).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Option is disabled globally via an empty/zero value of the directive "clientMaxBodySize" in panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Aktivera nginx caching',
    'apache-settings.nginxCacheEnabledDescription' => 'Caching kan reducera webbplatsens svarstid och serverbelastningen, men ska användas försiktigt.',
    'apache-settings.nginxCacheSize' => 'Cache-storlek',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Cache-tidsgräns',
    'apache-settings.nginxCacheTimeoutDays' => 'dagar',
    'apache-settings.nginxCacheTimeoutHours' => 'timmar',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minuter',
    'apache-settings.nginxCacheTimeoutSeconds' => 'sekunder',
    'apache-settings.nginxCacheKey' => 'Cache-nyckel',
    'apache-settings.nginxCacheCookies' => 'Cachebegäranden med kakor',
    'apache-settings.nginxCacheBypassLocations' => 'Inaktivera cacheminnet för platser',
    'apache-settings.nginxCacheBypass' => 'Förbikoppla cachen då',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'HTTP no-cache rubriker tas emot på begäran',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'HTTP auktoriseringsrubriker tas emot på begäran',
    'apache-settings.nginxCacheBypassGetNocache' => 'GET no-cache parametern tas emot på begäran',
    'apache-settings.nginxCacheUseStale' => 'Återställ inaktuella cache-register',
    'apache-settings.nginxCacheUseStale5xx' => 'Uppströms returnerar 5xx serverfel',
    'apache-settings.nginxCacheUseStale4xx' => 'Uppströms returnerar 4xx klientfel',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cacheminnet uppdateras',
    'apache-settings.additional' => 'Ytterligare Apache-direktiv',
    'apache-settings.additionalSettingsDescription' => 'Om det inte går att hitta särskilda inställningar, lägga till dem till fälten nedan. Dessa inställningar får företräde framför serveromfattande Apache-direktiv. Direktiven från det första fältet används när en besökare besöker siten över HTTP. Det andra fältet innehåller direktiven för HTTPS. I allmänhet ska du lägga till dina direktiv till båda fälten. Använd samma syntax som du använder för httpd.include. Exempelvis, om du vill konfigurera en anpassa felsida, lägg till raden: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Ytterligare direktiv för HTTP',
    'apache-settings.additionalSslSettings' => 'Ytterligare direktiv för HTTPS',
    'apache-settings.additionalSettingsError' => 'Ogiltig Apache-konfiguration: %%error%%',
    'apache-settings.rollbackFailed' => 'Kan inte använda den aktuella Apache-konfigurationsfilen och återskapa till tidigare version av filen, eftersom de innehåller ogiltiga konfigurationer.',
    'apache-settings.additionalNginx' => 'Ytterligare nginx-direktiv',
    'apache-settings.additionalNginxSettingsDescription' => 'Här kan du ange inställningar för nginx reverse proxy-server som körs framför Apache. Dina direktiv får företräde framför den serveromfattande nginx-konfigurationen. Exempelvis kanske du vill ändra tidsgränsen för anslutningen eller packa förfrågningar med gzip. Använd samma syntax som du använder för nginx.conf. Exempelvis, om du vill packa alla proxade förfrågningar med gzip, lägg till raden: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Ytterligare nginx-direktiv',
    'apache-settings.additionalNginxSettingsError' => 'Ogiltig nginx-konfiguration: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Kan inte använda den aktuella nginx-konfigurationsfilen och återskapa till tidigare version av filen, eftersom de båda innehåller ogiltiga konfigurationer.',
    'apache-settings.clearCache' => 'Clear cache',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Cache has cleared successfuly',

    'backup.backup-password-protection.securitySettingsSection' => 'Säkerhetsinställningar för säkerhetskopieringar',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Skaffa lösenordet från inställningarna för fjärrstyrd lagring',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Ange lösenord manuellt',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Ange lösenord',
    'backup.backup-password-protection.backupPassword' => 'Lösenord',
    'backup.backup-password-protection.inputPasswordType' => 'Lösenordstyp',
    'backup.backup-password-protection.confirmBackupPassword' => 'Upprepa lösenordet',
    'backup.backup-password-protection.backupPasswordHint' => 'Om du har glömt ditt lösenord, avmarkera detta alternativ. Notera att i detta fall, kommer vissa känsliga data inte att återställas ordentligt. Exempelvis ersätts användarlösenord med slumpmässiga lösenord, information om redan installerade APS-appar går förlorad och så vidare.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Om du använde lösenordsskydd för denna säkerhetskopia, ange lösenordet i fälten nedan. Notera att om du anger ett felaktigt lösenord, kommer Plesk inte att återställa säkerhetskopian. I stället kommer säkerhetskopian att kopieras till den lokala lagringen.',

    'backup.conflict-database.dbMappingLegend' => 'Databasservermappning',
    'backup.conflict-database.serverType' => 'Servertyp',
    'backup.conflict-database.hostName' => 'Värdnamn',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Destinationens databasserver',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Databasen kommer inte att återställas: det finns inte någon lämplig databasserver',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Ladda upp IP-mappningsfil',
    'backup.conflict-ip.ipMappingLegend' => 'IP-mappning',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Spara aktuell IP-mappning till fil',
    'backup.conflict-ip.ipAddressNotFound' => 'Det finns inga lediga IP-adresser av denna typ.',
    'backup.conflict-ip.sharedIp' => 'delad',
    'backup.conflict-ip.dedicatedIp' => 'dedikerad',
    'backup.conflict-ip.fileNotFound' => 'Filen får inte vara tom.',
    'backup.conflict-ip.invalidIpToMap' => 'Ett ogiltig värde för en gammal IP-adress: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Ett ogiltig värde för en ny IP-adress: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'Det gick inte att hitta IP-adressen %%ip%% på datorn.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Ladda upp IP-mappningsfil',
    'backup.conflict-ip.ipMappingFileHint' => 'IP-mappningsfil är en vanlig textfil. Varje rad av denna fil innehåller IP-mappning i format: <gammal IP-adress> <ny IP-adress>',
    'backup.conflict-ip.oldIp' => 'Gamla IP-adresser',
    'backup.conflict-ip.newIp' => 'Nya IP-adresser',

    'backup.copy-to-server.ignoreBackupSign' => 'Ladda upp säkerhetskopior utan en giltig signatur',
    'backup.copy-to-server.wrongPassword' => 'Det specificerade lösenordet är felaktigt. Under återställningen av säkerhetskopian, kommer Plesk be dig ange lösenordet igen.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Den uppladdade säkerhetskopiefilen %%fileName%% har modifierats, skadats eller skapats på en annan server eller i en äldre Plesk-version som inte stödjer signering av säkerhetskopior. Innan du återställer data från denna säkerhetskopiefil, se till att du kan lita på filens källa.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Kan inte ladda upp den säkerhetskopierade filen %%fileName%%. Filen innehåller antingen modifierade eller skadade data, eller så har den skapats på en annan server eller i en äldre Plesk-version. För att återställa data från denna fil, kontakta din värddatorleverantör.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Kan inte ladda upp den säkerhetskopierade filen %%fileName%%. Filen har modifierats, skadats eller skapats på en annan server eller i en äldre Plesk-version som inte stödjer signering av säkerhetskopior. Om du litar på denna säkerhetskopia, välj då alternativet "Ladda upp säkerhetskopior utan giltiga signaturer" och upprepa uppladdningen.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Kan inte flytta den valda säkerhetskopian %%fileName%% till serverns lagring. Fel: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Följande delar av den inkrementella säkerhetskopieringen kopierades inte:%%endl%%%%missedParts%%%%endl%%Kopiera delarna som saknas.",

    'backup.ftp-settings.isActive' => 'Använd FTP(S)-lagring',
    'backup.ftp-settings.host' => 'FTP-servervärdnamn eller IP',
    'backup.ftp-settings.directory' => 'Katalog för lagring av säkerhetskopieringsfiler',
    'backup.ftp-settings.directoryHint' => 'Exempelvis /minmapp/minasäkerhetskopior/',
    'backup.ftp-settings.ftpLogin' => 'FTP-användarnamn',
    'backup.ftp-settings.ftpPassword' => 'FTP lösenord',
    'backup.ftp-settings.usePassiveMode' => 'Använd passivt läge',
    'backup.ftp-settings.useFtps' => 'Använd FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Det är förbjudet att använda den lokala Plesk FTP-servern som en fjärrlagring. Specificera en fjärrplats.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S-lagringsinställningar har konfigurerats för att lagra säkerhetskopior i servern där dina abonnemangsfiler finns. En sådan konfiguration rekommenderas inte på grund av risken för dataförlust och överanvändning av diskutrymmet.',
    'backup.ftp-settings.enterFtpLogin' => 'Ange korrekt användarnamn.',
    'backup.ftp-settings.enterFtpPassword' => 'Ange korrekt lösenord.',

    'backup.remote-settings.isActive' => 'Använd lagringen',
    'backup.remote-settings.initError' => 'Det gick inte att initialisera %%extName%%-inställningssidan: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Säkerhetsinställningar för säkerhetskopieringar',

    'backup.restore.detailsSection' => 'Detaljer',
    'backup.restore.contentInfoSection' => 'Innehåll säkerhetskopia',
    'backup.restore.restorationOptionsSection' => 'Återställningsalternativ',
    'backup.restore.emailNotification' => 'När återställningsuppgiften är klar, skicka ett meddelande via e-post till',
    'backup.restore.comments' => 'Kommentarer',
    'backup.restore.creationDate' => 'Skapandedatum',
    'backup.restore.systemNotes' => 'Systemanteckningar',
    'backup.restore.ownerAdmin' => 'Skapad av administratören.',
    'backup.restore.ownerReseller' => 'Skapad av en återförsäljare.',
    'backup.restore.ownerCustomer' => 'Skapad av en kund.',
    'backup.restore.ownerServiceUser' => 'Skapad av en extraanvändare.',
    'backup.restore.partOfParentBackup' => 'Del av %%type%% säkerhetskopiering.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'återförsäljare',
    'backup.restore.client' => 'kund',
    'backup.restore.incremental' => 'Inkrementell.',
    'backup.restore.multiVolume' => 'Multivolym.',
    'backup.restore.backupSize' => 'Säkerhetskopians storlek',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (detta tillägg) + %%base%% (inledande säkerhetskopiering) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (detta tillägg) + %%prev%% (föregående tillägg) + %%base%% (inledande säkerhetskopiering) = %%total%%',
    'backup.restore.download' => 'Hämta',
    'backup.restore.downloadHint' => 'Ladda ner säkerhetskopiefil till din lokala dator.',
    'backup.restore.downloadDisabled' => 'Nerladdningen av säkerhetskopierade filer är inte tillgänglig för tillfället. Försök igen senare eller kontakta din serviceleverantör.',
    'backup.restore.copy' => 'Kopiera till serverlagringen',
    'backup.restore.copyHint' => 'Kopiera valda säkerhetskopierade filer till serverlagringen.',
    'backup.restore.contentInfo' => 'Säkerhetskopian innehåller',
    'backup.restore.restoreButton' => 'Återställ',
    'backup.restore.mail' => 'E-post',
    'backup.restore.domainConfiguration' => 'Domänkonfiguration',
    'backup.restore.virtualHost' => 'Den virtuella värdsserverns innehåll',
    'backup.restore.database' => 'DatabaVisar',
    'backup.restore.serverConfiguration' => 'Serverinställningar',
    'backup.restore.serverConfigurationLicense' => 'Licensnyckel',
    'backup.restore.serverPersonalConfiguration' => 'Administratörskontots konfiguration',
    'backup.restore.serverPersonalDomains' => 'Administratörs domäner',
    'backup.restore.serverPersonalClients' => 'Administratörens kunder',
    'backup.restore.resellers' => 'Återförsäljare',
    'backup.restore.resellerPersonalConfiguration' => 'Återförsäljarens kontokonfiguration',
    'backup.restore.resellerPersonalDomains' => 'Återförsäljarens domäner',
    'backup.restore.resellerPersonalClients' => 'Återförsäljarens kunder',
    'backup.restore.clientPersonalConfiguration' => 'Kundkontots konfiguration',
    'backup.restore.clientPersonalDomains' => 'Kundens domäner',
    'backup.restore.restoreModifiedSection' => 'Återställ säkerhetskopian trots en korrupt signatur',
    'backup.restore.restoreModifiedDump' => 'Återställa denna säkerhetskopia, trots att den inte har en giltig signatur',
    'backup.restore.resolutionPolicy' => 'Lösningspolicy',
    'backup.restore.resolutionPolicyDescription' => 'Timingkonflikter inträffar antingen när det återställda objektet redan finns i systemet med ett senare ändringsdatum, eller när det återställda objektet för närvarande inte finns i systemet.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Det specificerade lösenordet är felaktigt. Den säkerhetskopierade filen att kopieras till serverns lokala lagring.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Kan inte återställa backup. Det specificerade lösenordet är felaktigt.',
    'backup.restore.serverContentAndConfiguration' => 'Serverkonfiguration och -innehåll',
    'backup.restore.serverConfigurationOnly' => 'Serverkonfiguration',
    'backup.restore.resellerContentAndConfiguration' => 'Återförsäljarkontots konfiguration och innehåll',
    'backup.restore.resellerConfigurationOnly' => 'Återförsäljarens kontokonfiguration',
    'backup.restore.clientContentAndConfiguration' => 'Kundkontots konfiguration och innehåll',
    'backup.restore.clientConfigurationOnly' => 'Kundkontots konfiguration',
    'backup.restore.domainContentAndConfiguration' => 'Domänkonfiguration och -innehåll',
    'backup.restore.domainConfigurationOnly' => 'Domänkonfiguration',
    'backup.restore.restoreType' => 'Vad vill du återställa?',
    'backup.restore.restoreTypeFull' => 'Alla objekt (hela systemet)',
    'backup.restore.restoreTypeGranular' => 'Valda objekt',
    'backup.restore.restoreObjectType' => 'Typ objekt att återställa',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abonnemang',
    'backup.restore.restoreObjectTypeCustomers' => 'Kund',
    'backup.restore.restoreObjectTypeResellers' => 'Återförsäljare',
    'backup.restore.restoreObjectTypeMailUsers' => 'E-postkonto',
    'backup.restore.restoreObjectTypeDatabases' => 'Databas',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS-certifikat',
    'backup.restore.restoreObjectTypeSites' => 'Platser',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS-zon',
    'backup.restore.restoreObjectTypeMailLists' => 'E-postlistor',
    'backup.restore.restoreObjectTypeWebContent' => 'Filer från domäner',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Markerade filer',
    'backup.restore.restoreSubscriptionLookup' => 'Abonnemang',
    'backup.restore.restoreComponents' => 'Komponenter att återställa',
    'backup.restore.errorLog' => 'Fellogg',
    'backup.restore.backupDetailsLogDoesntExist' => 'Säkerhetskopia loggfilen är inte tillgänglig.',
    'backup.restore.dumpFailedSection' => 'Fellogg',
    'backup.restore.dumpFailed' => 'Kan inte återställa uppgifterna: den säkerhetskopierade filen är ogiltig.',
    'backup.restore.granularNotSupported' => 'Du kan välja objekt att återställa bara när du återställae från säkerhetskopior skapade i Plesk 12.0 eller senare.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Återställning av alla data från säkerhetskopior stödjas inte i återförsäljarens Power User View. Välj objekten för återställning. Du kan ändra din gränssnittsvy i %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Gränssnittsinställningar',
    'backup.restore.contentRestoreType' => 'Återställ',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Bara konfiguration av de valda objekten',
    'backup.restore.contentRestoreTypeFull' => 'Konfiguration och innehåll i de markerade objekten.',
    'backup.restore.errorWrongFormat' => 'Kan inte återställa backup: filen innehåller fel formatering.',
    'backup.restore.errorContentError' => 'All data kanske inte återställs: säkerhetskopian har innehållsfel.',
    'backup.restore.warningSignError' => 'Kan inte validera säkerhetskopians signatur. Säkerhetskopian kan modifieras, korrumperas, skapas på en annan server eller i en tidigare Plesk-version.',
    'backup.restore.warningSignErrorNotAdmin' => 'Denna säkerhetskopia kan endast återställas av Plesk-administratören.',
    'backup.restore.warningPartial' => "Följande delar av den inkrementella säkerhetskopieringen hittades inte:%%endl%%%%missedParts%%%%endl%%Inte alla filer kan återställas. Ladda upp delarna som saknas och försök med återställningen igen.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Säkerhetskopian du försöker återställa skapades med en Plesk-version det inte finns stöd för och kan inte återställas. Använd Plesk Migrator-ändelsen för att överföra data från tidigare Plesk-versioner.',
    'backup.restore.encryptionKeyError' => 'Lösenorden för ett eller flera konton i denna säkerhetskopia kan inte återställas och kommer att nollställas. Antagligen skapades denna säkerhetskopia på en annan Plesk-server och kodades med dess krypteringskod.',
    'backup.restore.errorCorruptedContent' => 'Följande filer hittades inte eller var korrupta: ',
    'backup.restore.statusSection' => 'Säkerhetskopieringsstatus',
    'backup.restore.statusDetails' => 'Statusinformation',
    'backup.restore.restoreBlocked' => 'Uppbackningen kan inte återställas.',
    'backup.restore.restoreBlockedDescription' => 'Uppbackningen av typen %%backupType%% kan inte återställas nu. För att återställa den, logga in som backup-ägare och klicka på detta säkerhetskopieringsnamn i Backup Manager.',

    'backup.schedule.scheduleSection' => 'Schema',
    'backup.schedule.backupEnable' => 'Aktivera denna säkerhetskopieringsuppgift',
    'backup.schedule.backupPeriod' => 'Kör denna säkerhetskopieringsuppgift',
    'backup.schedule.on' => 'i',
    'backup.schedule.at' => 'på',
    'backup.schedule.useIncremental' => 'Använd en inkrementell säkerhetskopia',
    'backup.schedule.fullBackupPeriod' => 'Utför hela säkerhetskopieringen',
    'backup.schedule.daily' => 'Dagens',
    'backup.schedule.weekly' => 'Veckovis',
    'backup.schedule.monthly' => 'Månadsvis',
    'backup.schedule.yearly' => 'Årlig',
    'backup.schedule.days' => 'dagar',
    'backup.schedule.weeks' => 'veckor',
    'backup.schedule.months' => 'månader',
    'backup.schedule.years' => 'år',
    'backup.schedule.backupTimeDescription' => 'Tidszon: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Standardsystemets tidszon',
    'backup.schedule.first' => 'första',
    'backup.schedule.last' => 'sist',
    'backup.schedule.dayOfMonth' => 'dag',
    'backup.schedule.email' => 'Om några fel inträffade under utförandet av denna säkerhetskopieringen, skicka avisering via e-post till',
    'backup.schedule.invalidFields' => 'Vissa fält är tomma eller innehåller ett felaktigt värde: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maximalt antal fullständiga säkerhetskopieringsfiler att lagra (inklusive schemalagda och manuella säkerhetskopior)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Lämna detta fält tomt om du inte vill ta bort hela säkerhetskopior automatiskt.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Den gräns som specificeras av värddatorleverantören för serverlagringen är %%max%%. Din gräns måste vara lägre eller samma som %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Lagring av schemalagda säkerhetskopieringar i ett system för fjärrlagring i moln är en premiumfunktion som man måste köpa från Plesks webbutik',

    'backup.secure-backup.hint' => 'Du kan använda ett lösenord för att kryptera användares lösenord i Plesk-databasen i en säkerhetskopiering. Observera att återställningen av ett lösenordsskyddad säkerhetskopiering utan angivelse av lösenordet gör att Plesk genererar slumpmässiga lösenord åt användarna.',
    'backup.secure-backup.hintAdmin' => 'Du kan kryptera lösenord för Plesk-databaser som finns i säkerhetskopieringar med en Plesk krypteringsnyckel eller med ett lösenord. Nyckeln är unik för varje Pleskinstallation. Säkerhetskopieringar som är krypterade med nyckeln kan endast återställas i den installation där de skapades. Observera att Plesk inte skyddar alla känsliga data i en säkerhetskopiering. Vi rekommenderar att du lagrar dina filer i molnet och aktiverar dess krypteringsfunktion.',
    'backup.secure-backup.usePasswordProtection' => 'Använd lösenordsskydd (rekommenderas)',
    'backup.secure-backup.backupPasswordSource' => 'Lösenordstyp',
    'backup.secure-backup.pleskKey' => 'Plesks krypteringskod',
    'backup.secure-backup.userPassword' => 'Specificerat lösenord',
    'backup.secure-backup.password' => 'Lösenord',
    'backup.secure-backup.passwordConfirmation' => 'Upprepa lösenordet',

    'backup.subform.settingsSection' => 'Inställningar för säkerhetskopiering',
    'backup.subform.prefix' => 'Lägg till prefix till säkerhetskopienamn',
    'backup.subform.comment' => 'Kommentarer',
    'backup.subform.splitSize' => 'Skapa en säkerhetskopiering med flera volymer, volymstorlek (MB)',
    'backup.subform.repository' => 'Lagra i',
    'backup.subform.repositoryDescription' => 'FTP(S)-lagringsinställningar har inte specificerats. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Både serverlagring och %%name%%',
    'backup.subform.remoteRepository' => 'fjärrlagring',
    'backup.subform.remoteRepositoryText' => 'Välj fjärrlagring i molnet',
    'backup.subform.configureRemoteRepositories' => 'Du kan <a href="%%url%%">konfigurera fjärrlagringen</a> för att spara dina säkerhetskopior i molnet',
    'backup.subform.configureFtpRepository' => 'Du kan <a href="%%url%%">konfigurera FTP-lagringen</a> för att spara dina säkerhetskopior där',
    'backup.subform.repositoryConfigure' => 'Anpassa',
    'backup.subform.email' => 'När säkerhetskopieringen är klar, skicka ett meddelande via e-post till',
    'backup.subform.contentSection' => 'Innehåll säkerhetskopia',
    'backup.subform.domainConfiguration' => 'Konfiguration',
    'backup.subform.domainConfigurationVhost' => 'Användarfiler och databaser',
    'backup.subform.domainConfigurationMail' => 'E-postmeddelanden',
    'backup.subform.content' => 'Säkerhetskopiera',
    'backup.subform.backupAll' => 'Hela konfigurationen och innehållet',
    'backup.subform.backupConfiguration' => 'Endast konfiguration',
    'backup.subform.backupVhost' => 'All konfiguration och innehåll förutom e-postmeddelanden',
    'backup.subform.backupMail' => 'Endast konfiguration och e-postmeddelanden',
    'backup.subform.mssqlNativeBackup' => 'Använd den integrerade MS SQL säkerhetsfunktionen om möjligt',
    'backup.subform.mssqlNativeBackupAdmin' => 'Använd den integrerade MS SQL säkerhetskopieringsfunktionen (För fjärrstyrda databaser, se till att du har konfigurerat säkerhetskopieringsinställningarna för den fjärrstyrda MS SQL-servern i Verktyg och inställningar> Databasservrar)',
    'backup.subform.localRepository' => 'Serverlagring',
    'backup.subform.localRepositoryPath' => 'Serverlagring i %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S)-lagring på %%uri%% <a href="%%link%%">Ändra inställningar</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S)-lagring på %%uri%%',
    'backup.subform.type' => 'Typ',
    'backup.subform.typeFullBackup' => 'Full',
    'backup.subform.typeIncremental' => 'Inkrementell',
    'backup.subform.typeIncrementalDescription' => 'Säkerhetskopieringsnät och e-post värddatordata som har ändrats sedan den senaste säkerhetskopieringen (databaserna säkerkopieras alltid i sin helhet).',
    'backup.subform.incrementalNotAvailable' => 'För att öka de inkrementella säkerhetskopieringarna, skapa först en fullständig säkerhetskopiering.',
    'backup.subform.excludeLogs' => 'Uteslut loggfilerna',
    'backup.subform.excludeFiles' => 'Uteslut vissa filer från säkerhetskopieringen',
    'backup.subform.excludeFilesDescription' => 'Du kan endast utesluta filer inom webbutrymmen. Specificera sökvägen eller sökvägarna som gäller webbutrymmets rot och separera individuella filer med kommatecken. Det är tillåtet att använda masksymbolen (t ex. /somedir/log*).',

    'backup.upload.uploadHint' => 'Här kan du ladda upp säkerhetskopierade filer till Plesk-lagringen. Maximal filstorlek är begränsad till två gigabyte.',
    'backup.upload.backupFile' => 'Säkerhetskopia',
    'backup.upload.removeLink' => 'Ta bort',
    'backup.upload.addFileLink' => 'Överför fler filer',
    'backup.upload.backupSecuritySettings' => 'Säkerhetsinställningar för säkerhetskopieringar',
    'backup.upload.signatureHint' => 'Plesk kontrollerar säkerhetskopiorna efter giltig struktur och signatur. Filer som modifierats, skadats eller skapats i en annan server misstros. Alternativet nedan gör det möjligt att återställ data från sådana filer. Välj detta alternativ endast om du litar på säkerhetskopians källa, eftersom uppladdning av en sådan fil kan äventyra säkerheten eller störa serverfunktionen. Obs: Säkerhetskopior gjorda i Plesk-versioner före 11.5 betraktas som otillförlitliga eftersom de saknar signaturer. Se till att återställa sådana filer om du litar på deras källa.',
    'backup.upload.ignoreSign' => 'Ladda upp säkerhetskopior utan en giltig signatur',
    'backup.upload.passwordHint' => 'Om du använde lösenordsskydd för denna säkerhetskopia, ange lösenordet i fälten nedan. Notera att om du anger ett felaktigt lösenord, kommer Plesk att varna dig, men ändå ladda upp säkerhetskopian till servern. Under återställningen av säkerhetskopian, kommer du ombes ange lösenordet igen.',
    'backup.upload.alreadyExistsWarning' => 'Den säkerhetskopierade filen %%fileName%% finns redan i serverns lokala lagring.',
    'backup.upload.incorrectPasswordWarning' => 'Det specificerade lösenordet är felaktigt. Under återställningen av säkerhetskopian, kommer Plesk be dig ange lösenordet igen.',
    'backup.upload.deprecatedDumpError' => 'Säkerhetskopian du försöker ladda upp skapades med en Plesk-version det inte finns stöd för och kan inte importeras. Använd Plesk Migrator-ändelsen för att överföra data från tidigare Plesk-versioner.',
    'backup.upload.mailFormatWarning' => 'Den säkerhetskopierade filen %%fileName%% har laddats upp till lagringen. Viktigt: den säkerhetskopierade filen %%fileName%% innehåller e-postinnehåll som inte återställs på grund av att dess format iPlesk 8.3 - 8.6) inte stöds. För att kunna återställa detta e-postinnehåll, säkerhetskopiera det genom att använda Plesk Säkerhetskopieringsverktyg och välj alternativet Säkerhetskopiera e-postlådans innehåll &gt; med dump återställd till vilken e-postserver som helst.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Den uppladdade säkerhetskopiefilen (%%fileName%%) har modifierats, skadats eller skapats på en annan server eller i en äldre Plesk-version som inte stödjer signering av säkerhetskopior. Innan du återställer data från denna säkerhetskopiefil, se till att du kan lita på filens källa.',
    'backup.upload.corruptedSignatureAdminError' => 'Kan inte ladda upp den säkerhetskopierade filen (%%fileName%%). Filen har modifierats, skadats eller skapats på en annan server eller i en äldre Plesk-version som inte stödjer signering av säkerhetskopior. Om du litar på denna säkerhetskopia, välj då alternativet "Ladda upp säkerhetskopior utan giltiga signaturer" och upprepa uppladdningen.',
    'backup.upload.corruptedSignatureUserWarning' => 'Den uppladdade säkerhetskopiefilen (%%fileName%%) innehåller antingen modifierade eller skadade data, eller så har den skapats på en annan server eller i en äldre Plesk-version.',
    'backup.upload.corruptedSignatureUserError' => 'Kan inte ladda upp den säkerhetskopierade filen (%%fileName%%). Filen innehåller antingen modifierade eller skadade data, eller så har den skapats på en annan server eller i en äldre Plesk-version. För att återställa data från denna fil, kontakta din värddatorleverantör.',
    'backup.upload.uploadError' => 'Kan inte ladda upp %%fileName%% till serverns lagring: %%error%%',
    'backup.upload.fileNotSelected' => 'Inga filer har valts för uppladdning. Välj minst en fil.',
    'backup.upload.missedPartsWarning' => "Följande delar av den inkrementella säkerhetskopieringen laddades inte upp:%%endl%%%%missedParts%%%%endl%%Ladda upp delarna som saknas.",
    'backup.upload.unknownType' => 'Okänd objekttyp',
    'backup.upload.storageLink' => 'annan lagring',
    'backup.upload.anotherStorage' => 'Dumpen har laddats upp till %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Återförsäljaren %%name%% hittas inte. Skapa den först för att återställa den uppladdade dumpen.',
    'backup.upload.clientNotFound' => 'Kunden %%name%% hittas inte. Skapa den först för att återställa den uppladdade dumpen.',
    'backup.upload.domainNotFound' => 'Domänen %%name%% hittas inte. Skapa den först för att återställa den uppladdade dumpen.',

    'backup.web-content-dynamic.addButtonTitle' => 'Lägg till fil',
    'backup.web-content-dynamic.noItems' => 'Inga filer har valts',
    'backup.web-content-dynamic.hint' => 'Använd kryssrutorna till att välja filer och kataloger.',
    'backup.web-content-dynamic.title' => 'Markera filer',
    'backup.web-content-dynamic.columnName' => 'Namn',
    'backup.web-content-dynamic.columnChangeDate' => 'Ändrad',
    'backup.web-content-dynamic.columnSize' => 'Storlek',
    'backup.web-content-dynamic.columnPermissions' => 'Behörigheter',
    'backup.web-content-dynamic.columnUser' => 'Användare',
    'backup.web-content-dynamic.columnGroup' => 'Grupp',
    'backup.web-content-dynamic.waitButtonTitle' => 'Vänta',
    'backup.web-content-dynamic.loadingTitle' => 'Vänta. Laddar',

    'backup.invalidFields' => 'Vissa fält är tomma eller innehåller ett felaktigt värde.',
    'backup.notEnoughDiskSpace' => 'Det finns inte tillräckligt med ledigt diskutrymme på %%path%% för säkerhetskopiering. Minst %%required%% GB ledigt utrymme krävs (%%available%% GB finns tillgängligt)',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Ställer in gränser för systemresursernas förbrukning av en prenumeration. Plesk använder en Linux kärnfunktion som kallas kontrollgrupper (cgroups) för att garantera att gränserna inte överskrids.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Gräns för individuella prenumerationer enligt den specificerade mängden CPU-användning.',
    'cgroups-settings.cpuPeriodLimit' => 'Period för att kontrollera CPU-användningen',
    'cgroups-settings.percentUsageDescription' => 'Den totala CPU-tiden motsvarar %%total%%%%units%% för din server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Gräns för individuella prenumerationer enligt den specificerade mängden RAM-användning. Observera att om prenumerationen överskrider denna gräns, kommer processen som förbrukar mest att stoppas.',
    'cgroups-settings.ramPeriodLimit' => 'Period för att kontrollera RAM-användningen',
    'cgroups-settings.diskSettings' => 'Disk-I/O',
    'cgroups-settings.diskReadSettings' => 'Diskavläsning',
    'cgroups-settings.diskReadSettingsDescription' => 'Gör att individuella prenumerationer kan använda diskens avläsningsbandbredd endast inom den specificerade gränsen.',
    'cgroups-settings.diskReadPeriodLimit' => 'Period för att kontrollera diskavläsningsanvändningen',
    'cgroups-settings.diskWriteSettings' => 'Diskskrivning',
    'cgroups-settings.diskWriteSettingsDescription' => 'Gör att individuella prenumerationer kan använda diskens skrivbandbredd endast inom den specificerade gränsen.',
    'cgroups-settings.diskWritePeriodLimit' => 'Period för att kontrollera diskskrivningsanvändningen',
    'cgroups-settings.limit' => 'Gräns',
    'cgroups-settings.threshold' => 'Meddela överskridningar',
    'cgroups-settings.limitNotificationEnabled' => 'Meddelande aktiverat',
    'cgroups-settings.periodFiveMinutes' => '5 minuter',
    'cgroups-settings.periodHour' => '1 timma',
    'cgroups-settings.periodDay' => '1 dag (24 timmar)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sek',

    'custom-button.privateLabel' => 'Visa endast för mig',
    'custom-button.textLabel' => 'Knappetikett',
    'custom-button.tooltipLabel' => 'Knappbeskrivningstext',
    'custom-button.iconLabel' => 'Bakgrundsbild',
    'custom-button.priorityLabel' => 'Prioritet',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Lägg till parametrar till URL',
    'custom-button.placeLabel' => 'Plats',
    'custom-button.internalLabel' => 'Öppna URL:en i Plesk',
    'custom-button.internalDescription' => 'Ange huruvida URL:en ska öppnas på en Plesk-sida eller i ett nytt webbläsarfönster.',
    'custom-button.noFrameLabel' => 'Använd inte ramar',
    'custom-button.noFrameDescription' => 'Om du lägger till en anpassad knapp som leder till ett Plesk-tillägg eller en app på Kundpanelen, kan du specificera hur denna ändelse/app ska visas: i en ram eller som en del av Plesk GUI.',
    'custom-button.urlParamLabel_dom_id' => 'Inkludera abonnemang ID, domän ID och domänalias ID',
    'custom-button.urlParamLabel_dom_name' => 'Inkludera primärt domännamn',
    'custom-button.urlParamLabel_ftp_user' => 'Inkludera FTP-användarnamn',
    'custom-button.urlParamLabel_ftp_pass' => 'Inkludera FTP-lösenord',
    'custom-button.urlParamLabel_cl_id' => 'Inkludera kund-ID',
    'custom-button.urlParamLabel_cname' => 'Inkludera kundens företagsnamn',
    'custom-button.urlParamLabel_pname' => 'Inkludera kundens kontaktnamn',
    'custom-button.urlParamLabel_email' => 'Inkludera kundens e-post',
    'custom-button.buttonPlace_navigation' => 'Vanlig tillgång',
    'custom-button.buttonPlace_admin' => 'Administratörens startsida',
    'custom-button.buttonPlace_admin-settings' => 'Administratörssidan Verktyg & inställningar',
    'custom-button.buttonPlace_reseller' => "Återförsäljarens startsida",
    'custom-button.buttonPlace_reseller-settings' => 'Sida med återförsäljarens verktyg och hjälpprogram',
    'custom-button.buttonPlace_client' => 'Kundens startsida',
    'custom-button.buttonPlace_domain' => "Abonnemangsida för webbplatser och domäner",
    'custom-button.buttonPlace_domain_powerUser' => "Webbutrymmessida för webbplatser och domäner",
    'custom-button.buttonPlace_domain-properties' => 'Webbplatsverktyg',

    'database-server-change-password.adminPassword' => 'Administratörslösenord',
    'database-server-change-password.success' => 'Administratörslösenordet har uppdaterats.',

    'database-server-create.general' => 'Allmänt',
    'database-server-create.type' => 'Databasservertyp',
    'database-server-create.host' => 'Värddatornamn eller IP-adress',
    'database-server-create.port' => 'Portnummer',
    'database-server-create.portDescription' => 'Lämna tomt för standardportnummer',
    'database-server-create.default' => 'Use this server as default for %%type%%',
    'database-server-create.authentication' => 'Verifiering',
    'database-server-create.authenticationDescription' => 'Specificera databasadministratörens autentiseringsuppgifter som Plesk kommer att använda för att få tillgång till databasservern. Ett administratörskonto med dessa autentiseringsuppgifterna måste finnas på databasservern.',
    'database-server-create.adminLogin' => 'Användarnamn',
    'database-server-create.adminPassword' => 'Lösenord',
    'database-server-create.success' => 'Database server was successfully created.',

    'domain.connection-info.title' => 'Anslutningsinfo',
    'domain.connection-info.systemUserCredentials' => 'Uppgifter för systemanvändare',
    'domain.connection-info.systemUserCredentialsHint' => 'Åtkomst via FTP är alltid aktiverad, åtkomst via SSH eller fjärrskrivbord – endast om %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'tillstånd har getts',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Din SSH- eller fjärrskrivbordsåtkomst är aktiverad och du kan inte hantera dess tillstånd.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Din SSH- eller fjärrskrivbordsåtkomst är inaktiverad och du kan inte hantera dess tillstånd.',
    'domain.connection-info.ipAddress' => 'IP-adress',
    'domain.connection-info.copyToClipboard' => 'Kopiera till urklipp',
    'domain.connection-info.username' => 'Användarnamn',
    'domain.connection-info.password' => 'Lösenord',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Ändring av systemets användarlösenord',
    'domain.connection-info.changePasswordTooltip' => 'Ändra lösenord',
    'domain.connection-info.newPassword' => 'Nytt lösenord',
    'domain.connection-info.manageAccess' => 'Hantera åtkomst',
    'domain.connection-info.additionalFtpAccounts' => 'Extra FTP-konton',
    'domain.connection-info.database' => 'Databas',
    'domain.connection-info.databaseHint' => '1 av %%number%% databaser som tillhör prenumerationen.',
    'domain.connection-info.databaseNotCreatedHint' => 'Databas ej skapad.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Värd',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Databasnamn',
    'domain.connection-info.addDatabase' => 'Lägg till databas',
    'domain.connection-info.manageDatabases' => 'Hantera databaser',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Ändring av databasens användarlösenord',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Glöm inte att uppdatera lösenordet i konfigurationsfilerna för din applikation efter att ha ändrat det här.',
    'domain.connection-info.buttonSave' => 'Spara',
    'domain.connection-info.buttonSaving' => 'Sparar...',
    'domain.connection-info.buttonCancel' => 'Avbryt',

    'domain.move.title' => 'Flytta domänen %%name%%',
    'domain.move.hint' => 'Domänen flyttas till en ny prenumeration med innehåll, konfigurationsfiler, loggfiler och APS-applikationer.',
    'domain.move.hintMain' => 'Domänen flyttas till en ny prenumeration med innehåll, konfigurationsfiler, loggfiler, databaser, databasanvändare, ytterligare FTP-användare, schemalagda uppgifter, smb-användare och APS-applikationer.',
    'domain.move.hintSubdomains' => 'Underdomänen(-erna) %%subdomains%% flyttas tillsammans med föräldradomänen.',
    'domain.move.hintAliases' => 'Domänalias(-er) %%aliases%% flyttas tillsammans med föräldradomänen.',
    'domain.move.hintSubdomainsAndAliases' => 'Underdomänen(-erna) %%subdomains%% och domänalias(er) %%aliases%% flyttas tillsammans med föräldradomänen.',
    'domain.move.labelDatabases' => 'Efter att ha flyttat domänen, öppnar du fliken "Databaser" för att flytta associerade databaser.',
    'domain.move.hintDatabases' => 'Flytta vid behov databaserna separat.',

    'domain.move.Form.submitButton' => 'Flytta',
    'domain.move.Form.cancelButton' => 'Avbryt',

    'domain.move.selectTarget' => 'Tillgängliga abonnemang',
    'domain.move.nothingFound' => 'Inget hittades',
    'domain.move.targetIsRequred' => 'Välj prenumerationen som domänen ska flyttas till.',
    'domain.move.selectNewSubscription' => 'Skapa en ny prenumeration',
    'domain.move.ipv4Address' => 'IPv4-adress',
    'domain.move.ipv4AddressHint' => 'IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.',
    'domain.move.ipv6Address' => 'IPv6-adress',
    'domain.move.ipv6AddressHint' => 'IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.',
    'domain.move.ipAddressIsNotSelected' => 'Minst en IP-adress måste väljas.',
    'domain.move.username' => 'Användarnamn',
    'domain.move.usernameHint' => 'Systemanvändarens konto som är associerat med webbutrymmet. Används för att få tillgång till hostade filer via FTP och SSH.',
    'domain.move.usernameIsRequred' => 'Du måste ange ett användarnamn.',
    'domain.move.password' => 'Lösenord',
    'domain.move.passwordIsRequred' => 'Du måste ange ett lösenord.',
    'domain.move.noAvailableSubscriptions' => 'Inga tillgängliga abonnemang',
    'domain.move.noWebHosting' => 'Ingen systemanvändare kommer att skapas för närvarande, eftersom domänen inte har någon webbhosting.',

    'domain.rename.title' => 'Ändra domännamn',
    'domain.rename.titleAlias' => 'Ändra domänaliasnamn',
    'domain.rename.hint' => 'Du byter nu domännamnet %%domainName%%',
    'domain.rename.hintAlias' => 'Du byter nu domänaliasnamnet %%domainName%%',
    'domain.rename.name' => 'Nytt domännamn',
    'domain.rename.nameAlias' => 'Nytt domänaliasnamn',
    'domain.rename.domainNameIsRequired' => 'Det obligatoriska fältet är tomt. Du måste ange ett värde.',
    'domain.rename.submitButton' => 'Ändra',
    'domain.rename.submitButtonProgress' => 'Ändrar',
    'domain.rename.successMessage' => 'Domännamnet %%oldName%% ändrades till %%newName%%.',
    'domain.rename.successMessageAlias' => 'Domänaliasnamnet %%oldName%% ändrades till %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Avbryt',

    'domain.outgoing-messages.hint' => 'Här kan du konfigurera gränsen på antal utgående meddelanden för denna domänen. Det kommer inte att vara möjlig att skicka flera meddelanden än den specificerade gränsen.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Standard (%%domainOutgoingMessages%% meddelanden per timme)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'meddelanden per timme',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Gräns för utgående meddelanden',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Anpassat värde för denna domänen',

    'domain.tech-domain-name.title' => 'Välj ditt domännamn',
    'domain.tech-domain-name.techDomainTitle' => 'Temporärt domännamn',
    'domain.tech-domain-name.customDomainTitle' => 'Registrerat domännamn',
    'domain.tech-domain-name.techDomainText' => 'Jag har inget registrerat domännamn än',
    'domain.tech-domain-name.customDomainText' => 'Jag har redan ett registrerat domännamn',
    'domain.tech-domain-name.techDomain' => 'Ditt temporära domännamn',
    'domain.tech-domain-name.customDomain' => 'Registrerat domännamn',
    'domain.tech-domain-name.domainName' => 'Domännamn',
    'domain.tech-domain-name.techDomainDesc' => 'Temporära domännamn används för att komma åt din sida innan du registrerar och köper ett faktiskt domännamn. De tillhandahålls gratis med följande villkor:',
    'domain.tech-domain-name.techDomainRandom' => 'Namnen genereras slumpmässigt',
    'domain.tech-domain-name.techDomainDns' => 'De hostas i DNS-zonen .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Du kan byta till ett registrerat domännamn när som helst genom att döpa om din domän i domäninställningarna.',
    'domain.tech-domain-name.error' => 'Ett oväntat fel inträffade.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Du måste välja IP-adress.',
    'domain.tech-domain-name.generating' => 'Genererar...',

    'get-password.label' => 'Återställ lösenord',
    'get-password.text' => 'Ange din e-postadress eller ditt användarnamn som registrerats i Plesk så skickar vi e-post för återställning av lösenord.',
    'get-password.emailLabel' => 'E-postadress',
    'get-password.loginLabel' => 'Användarnamn',
    'get-password.send' => 'Skicka',
    'get-password.cancel' => 'Avbryt',
    'get-password.errorInvalidEmail' => 'E-postadressen kändes inte igen. Dubbelkontrollera och försök igen.',
    'get-password.messageSend' => "E-postmeddelandet för återställning av lösenord skickades till den associerade e-postadressen.\nOm e-postmeddelandet inte anländer, var god kontakta din Plesk-administratör.",

    'iis-settings.formGeneralHint' => 'Här kan du specificera IIS webbserverinställningarna för din webbplats genom att ändra standardvärdena. En anpassad IIS-konfiguration är användbar, till exempel när du vill använda en ny typ av indexfiler på din webbplats eller associera en viss MIME-typ med vissa filnamnstillägg. Standardvärdena definieras av din värdtjänstleverantör.',
    'iis-settings.formGeneralHint_powerUser' => 'Här kan du specificera IIS-webbserverinställningar för denna webbplats. En anpassad IIS-konfiguration är användbar, till exempel när du vill använda en ny typ av indexfiler på din webbplats eller associera en viss MIME-typ med vissa filnamnstillägg. Standardvärden betyder att IIS kommer att använda motsvarande direktiv från sin standardkonfiguration.',
    'iis-settings.virtualDirectoryLoadError' => 'Kan inte få egenskaperna för den specificerade virtuella katalogen: %%errorMessage%%',
    'iis-settings.general' => 'Standardinställningar',
    'iis-settings.example' => "Till exempel:\n%%example%%",
    'iis-settings.settingOn' => 'På',
    'iis-settings.settingOff' => 'Av (standard)',
    'iis-settings.settingDefault' => 'Standard',
    'iis-settings.settingCustom' => 'Ange anpassade värde',
    'iis-settings.mimeTypes' => 'MIME-typer',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME-typer associerar filnamnstillägg med filtyper. Vanligtvis används detta för att skapa en egen filnamnsförlängning för vanliga filtyper.',
    'iis-settings.documents' => 'Standard dokument',
    'iis-settings.documentsOff' => 'Inaktiverad',
    'iis-settings.documentsCustom' => 'Ange värdena',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsExampleFullDescription' => 'När webbläsare inte ger namnet på ett dokument på din webbplats kommer IIS att leta efter de angivna standarddokumenten och betjäna det första som hittas. Om du inte anger standarddokumenten, utan slår på Katalogbläddring, kommer katalogförteckningen att visas i webbläsaren istället för indexsidan.',
    'iis-settings.expires' => 'Expires (går ut)',
    'iis-settings.expiresFullDescription' => 'Webbservern lägger till svarsrubriken "Expires" (går ut) på webbsidorna. Tidsstämpeln för detta får man genom att lägga till tidsintervallen ovanför tiden vid vilken man begär en webbsida.',
    'iis-settings.expiresUnitDays' => 'dagar',
    'iis-settings.expiresUnitHours' => 'timmar',
    'iis-settings.expiresUnitMinutes' => 'minuter',
    'iis-settings.expiresUnitSeconds' => 'sekunder',
    'iis-settings.headers' => 'Ytterligare rubriker',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Webbservern kommer att lägga till de angivna HTTP-svarsrubriker.',
    'iis-settings.directoryBrowsing' => 'Katalogsökning',
    'iis-settings.directoryBrowsingDescription' => 'Låt användare se sitens katalogförteckning i webbläsare, exempelvis när den vanliga index-sidan inte är tillgänglig.',
    'iis-settings.securityTabDirectory' => 'Katalogens säkerhetsinställningar',
    'iis-settings.allowAnonymous' => 'Anonym autentisering',
    'iis-settings.allowAnonymousDescription' => 'Anonym autentisering gör att användare kan få tillgång till offentligt innehåll på din webbplats. Lösenordsskyddat innehåll på din site, liksom innehåll som är skyddat på en filsystemnivå, kommer inte att vara tillgängligt för anonyma användare.',
    'iis-settings.allowWindows' => 'Windows-autentisering',
    'iis-settings.allowWindowsDescription' => 'Windows-autentisering (tidigare kallat NTLM) skyddar innehåll på din webbplats på ett filsystem nivå.',
    'iis-settings.requireSsl' => 'Kräv SSL/TLS',
    'iis-settings.requireSslDescription' => 'Om du har aktiverat SSL/TLS-stöd för siten, kommer detta alternativ att tvinga webbklienter (webbläsare) att endast använda säkra HTTPS-anslutningar.',
    'iis-settings.securityTabIpDeny' => 'Åtkomstbegränsningens inställningar',
    'iis-settings.deny' => 'Neka åtkomst till webbplatsen',
    'iis-settings.denyOff' => 'Standard',
    'iis-settings.denyCustom' => 'Ange anpassade värde',
    'iis-settings.allow' => 'Förutom',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nDe angivna värdarna och nätverken är förbjudna att komma åt siten. Använd '*' för att neka alla anslutningar.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nDe specificerade värddatorerna och nätverken får tillgng till webbplatsen.",
    'iis-settings.dynamicIpSecurity' => 'Förhindring av DoS-attacker genom IIS Dynamisk IP begränsning',
    'iis-settings.isDenyByConcurrentRequests' => 'Neka IP-adresser baserad på antal samtidiga förfrågningar från en unik IP-adress.',
    'iis-settings.maxConcurrentRequests' => 'Maximalt antal samtidiga förfrågningar',
    'iis-settings.isDenyByRequestRate' => 'Neka IP-adresser baserad på antal förfrågningar över en tidsperiod',
    'iis-settings.maxRequests' => 'Maximalt antal förfrågningar',
    'iis-settings.requestInterval' => 'Tidsperiod (i millisekunder)',

    'ip-addresses-selector.ipAddress' => 'IP-adress',
    'ip-addresses-selector.ipv4Address' => 'IPv4-adress',
    'ip-addresses-selector.ipv4AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'ip-addresses-selector.ipv6Address' => 'IPv6-adress',
    'ip-addresses-selector.ipv6AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'ip-addresses-selector.noIpAddressHint' => 'Ingen',
    'ip-addresses-selector.shared' => 'delad',
    'ip-addresses-selector.exclusive' => 'dedikerad',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP-servern stödjer inte IPv6. Tilldela åtminstone en IPv4-adress, annars kommer användaren inte kunna ladda upp filer till servern över FTP.',

    'log-rotation.customLogsDescription' => 'Observera att dina egna loggar inte roteras.',
    'log-rotation.logRotation' => 'Loggrotering',
    'log-rotation.logRotationCondition' => 'Loggroteringsvillkor',
    'log-rotation.logRotationBySize' => 'Efter storlek',
    'log-rotation.logRotationByTime' => 'Efter tid',
    'log-rotation.logRotationDaily' => 'Dagens',
    'log-rotation.logRotationWeekly' => 'Veckovis',
    'log-rotation.logRotationMonthly' => 'Månadsvis',
    'log-rotation.logRotationSizeDescription' => 'Storleksvärdet måste vara mellan %%min%% och %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maximalt antal loggfiler',
    'log-rotation.compress' => 'Komprimera loggfilerna',
    'log-rotation.sendLogToEmail' => 'Efter Plesk hämtat data från loggfilen i webben och FTP-servrarna, skicka loggarna via e-post till denna adress',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Perioden får inte vara större än serverns gränsvärde %%max%%.',

    'login.loginLabel' => 'Användarnamn',
    'login.passwdLabel' => 'Lösenord',
    'login.localeLabel' => 'Gränssnittsspråk',
    'login.defaultLocale' => 'Standard',
    'login.loginButtonLabel' => 'Logga in',
    'login.enterLoginAndPasswd' => 'Ange ditt användarnamn {0} och lösenord.',
    'login.whatUsernamePassword' => 'Vilket användarnamn och lösenord ska man använda?',
    'login.forgotPasswordLabel' => 'Har du glömt lösenordet?',
    'login.cookies' => 'Cookies-policy i Plesk',
    'login.avoidSSLWarningsMsg' => 'Använd %%link%% för att undvika SSL-varningar vid inloggning på Plesk',
    'login.digitalOceanMsg' => 'Ny inom Plesk på DigitalOcean? Använd "root" och lösenordet som angavs vid skapandet av denna droppe för att logga in. %%link%%',
    'login.amazonLightsailMsg' => 'Ny inom Plesk på LIghtsail? För att logga in på Plesk, öppna servern via SSH och använd kommandot "plesk login". %%link%%',
    'login.readGuide' => 'Läs hela guiden.',

    'panel-access.title' => 'Anpassar Plesk-URL',
    'panel-access.hint' => 'Välj anpassade URL-er för inloggning till Plesk. Detta tar inte bort möjligheten att logga in via port %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Mer detaljer',
    'panel-access.proxyEnabled' => 'Alla domäner eller underdomäner som tolkar serverns IP-adress men inte används som värd',
    'panel-access.proxyDomain' => 'Den angivna domänen eller underdomänen som tolkar serverns IP-adress men inte används som värd',
    'panel-access.proxyDisabled' => 'Inga anpassade URL-er. Endast https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Spara',
    'panel-access.Form.cancelButton' => 'Avbryt',

    'panel-access.domainNameIsRequired' => 'Du  måste ange ett domännamn.',
    'panel-access.successMessage' => 'Den valda metoden för inloggning har applicerats.',
    'panel-access.notSupported' => 'Ditt Plesk stödjer inte den valda inloggningsmetoden.',
    'panel-access.notViaDomainName' => 'För att använda den här inloggningsmetoden, välj först alternativet (Alla domäner och underdomäner...”), logga in på Plesk via https://%%domainName%% och välj sedan det andra alternativet.',
    'panel-access.notViaPort' => 'För att använda den här metoden, logga in på Plesk via https://<server-IP-or-hostname>:%%httpsPort%% först.',

    'php-settings.performance' => 'Prestanda- och säkerhetsinställningar',
    'php-settings.settings' => 'Standardinställningar',
    'php-settings.fastCgiSettings' => 'FastCGI-inställningar',
    'php-settings.fpmSettings' => 'PHP-FPM-inställningar',
    'php-settings.enableFastcgi' => 'Aktivera FastCGI-inställningar',
    'php-settings.plainTextEditing' => 'Ytterligare direktiv',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Du kan definiera eventuella PHP-parametrar genom att skriva in dem i fältet nedan. Direktiven kommer att inkluderas i PHP-konfigurationen. Använd samma syntax som du använder för php.ini. Exempelvis, om du automatiskt vill ladda mSQL-tillägget, lägg till raden: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Om du inte kan hitta särskilda PHP-parametrar, lägg till dem till fältet nedan. Dessa extra direktiv kommer att sammanföras med direktiven för den huvudsakliga serviceplanen. Använd samma syntax som du använder för php.ini. Exempelvis, om du automatiskt vill ladda mSQL-tillägget, lägg till raden: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Du kan definiera eventuella PHP-parametrar genom att skriva in dem i fältet nedan. Direktiven kommer att inkluderas i PHP-konfigurationen. Använd samma syntax som du använder för php.ini. Exempelvis, om du automatiskt vill ladda mSQL-tillägget, lägg till raden: extension=msql.so. För att anpassa PHP-FPM pool-inställningarna och separatorn [php-fpm-pool-settings] och skriv önskade inställningar nedan.',
    'php-settings.additionalConfigurationDirectives' => 'Extra konfigurationsdirektiv',
    'php-settings.defaultValue' => 'Standard',
    'php-settings.predefinedValue' => 'Välj värde',
    'php-settings.customValue' => 'Ange anpassade värde',
    'php-settings.phpSettingDescription_memory_limit' => 'Den maximala mängden minne i byte som ett skript tillåts tilldela.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Den maximala tiden i sekunder ett skript tillåts köras innan det avslutas.',
    'php-settings.phpSettingDescription_max_input_time' => 'Den maximala tiden i sekunder som ett skript tillåts parsa inmatad data.',
    'php-settings.phpSettingDescription_post_max_size' => 'Maximal storlek i databytes som kan publiceras med POST-metoden. Ska typiskt sett vara större än upload_max_filesize och mindre än memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Den maximal storleken i bytes av en överförd fil.',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP säkert läge ställer ett antal restriktioner på utförandet av skript huvudsakligen av säkerhetsskäl.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Filerna i den specificerade katalogen är tillgängliga via PHP-script när det säkra läget är aktiverat. Katalogen måste också finnas i include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programmen i den specificerade katalogen kan utföras via PHP-script när det säkra läget är aktiverat.',
    'php-settings.phpSettingDescription_include_path' => 'Listan över kataloger där skript letar efter filer (liknande systemets PATH-variabel). För att separera kataloger, använd ett kolon (:) i Linux och ett semikolon (;) i Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Katalogen för att lagra PHP-sessionsfilerna.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Extra parametrar för e-post() funktionen.',
    'php-settings.phpSettingDescription_register_globals' => 'Registrera innehållet i EGPCS-variablerna (Environment, GET, POST, Cookie, Server) som globala variabler.',
    'php-settings.phpSettingDescription_open_basedir' => 'Filerna i de specificerade katalogerna är tillgängliga via PHP-script. För att separera kataloger, använd ett kolon (:) i Linux och ett semikolon (;) i Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Felrapporteringsnivå.',
    'php-settings.phpSettingDescription_display_errors' => 'Avgör om felen ska visas som del av uteffekten.',
    'php-settings.phpSettingDescription_log_errors' => 'Aktivera loggningen av PHP-fel.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Möjliggör PHP-filfunktioner för att hämta data från fjärrplatser över FTP eller HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Möjliggör uppladdning av filer över HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Möjliggör kortformen () av PHP:s öppna tag.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Ställer in magic_quotes-tillståndet för GPC-åtgärder (Get/Post/Cookie). När magic_quotes är på, föregås alla enkelcitat-, dubbelcitat-, omvänt snedstreck och NULL-specialtecken automatiskt med omvänt snedstreck.',
    'php-settings.phpSettingDescription_disable_functions' => 'Detta direktiv låter dig inaktivera vissa funktioner. Man behöver en kommabegränsad lsta av funktionsnamn',
    'php-settings.phpSupport' => 'PHP-stöd',
    'php-settings.phpRunAs' => 'Kör PHP som',
    'php-settings.phpVersion' => 'PHP-version',
    'php-settings.phpHandlerOutdated' => '(Föråldrad)',
    'php-settings.phpHandlerDeprecated' => '(Avrådd)',
    'php-settings.phpServedByApache' => 'som servas av Apache',
    'php-settings.phpServedByNginx' => 'som servas av ngnix',
    'php-settings.phpSettingsPhpVersion' => 'Din PHP-version är %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP är avslaget.',
    'php-settings.phpHandlerTypeHint' => 'Nedan följer alla detaljer om webbplatsens PHP-konfiguration. Du kan ändra PHP-konfiguration om hostingleverantören ger dig motsvarande tillstånd.',
    'php-settings.fpmDedicatedHandlerHint' => 'Att använda denna hanterare ökar webbplatsens stabilitet, men orsakar även ytterligare minnesförbrukning.',
    'php-settings.phpHandlerChangeHint' => 'Du har ändrat PHP-inställningar. Om du sparar dessa ändringar kan PHP-skripten på din webbplats sluta fungera i %%interval%% sekunder, p.g.a. din serverkonfiguration.',
    'php-settings.phpHandlerTypeHelpLink' => 'Lär dig att välja de mest lämpliga PHP-inställningarna',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP-stödet kan inte aktiveras eftersom den aktuella hostingkonfigurationen inte inkluderar några PHP-versioner som är tillgängliga för denna domän.',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP-stödet kan inte aktiveras eftersom den aktuella hostingkonfigurationen inte inkluderar några PHP-versioner som är tillgängliga.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Läs mer om hur du aktiverar andra PHP-versioner.',
    'php-settings.phpSupportEditable' => '(PHP-version %%version%%, kör PHP som %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(version: %%version%%; hanteringsverktyg: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(inte registrerad) %%link%%',
    'php-settings.showPhpInfo' => 'Visa sidan phpinfo()',
    'php-settings.phpSettingsFormError' => 'Kan inte återställa PHP-inställningarna eftersom uppgifterna som behövs saknas.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Kan inte återställa PHP-inställningarna eftersom denna hanterare är korrupt.',
    'php-settings.showPhpInfoTitle' => 'Visa phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Några av dina PHP-inställningar har ändrats men ändringarna har inte sparats ännu. För att visa nya värden på sidan phpinfo(), tillämpa ändringarna först. Annars ser du de aktuella värdena.',
    'php-settings.showPhpInfoButton' => 'Visa phpinfo()',
    'php-settings.onState' => 'På',
    'php-settings.offState' => 'Av',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent söker efter uppdateringar.',
    'pmm.agent.sync.updating' => 'Synkronisering och nedladdning Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent har synkroniserats.',
    'pmm.agent.sync.downloadLink' => 'Klicka för att ladda ner Migration & Transfer Agent-filen som du ska installera i källvärddatorn innan migreringen startar.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent misslyckades med att hämta uppdateringar. Var god försök igen senare.',

    'restore-password.title' => 'Ändra ditt lösenord',
    'restore-password.passwordLabel' => 'Nytt lösenord',
    'restore-password.buttonRestore' => 'Spara',
    'restore-password.buttonCancel' => 'Avbryt',
    'restore-password.isEmpty' => 'Det obligatoriska fältet är tomt. Du måste ange ett värde.',
    'restore-password.errorInvalidSecret' => 'Ogiltig hemlig kod',
    'restore-password.errorNotFoundSecret' => 'Be om en ny hemlig kod',
    'restore-password.restoreSuccess' => 'Ditt lösenord uppdaterades. Använd det nya lösenordet för att logga in på Plesk eller till din e-postadress.',

    'scheduler.settings.schedulerNotification' => 'Schemaläggarens meddelande',
    'scheduler.settings.notificationOff' => "Avstängd",
    'scheduler.settings.notificationDefault' => "Skicka till standard-postadressen (%%email%%)",
    'scheduler.settings.notificationCustom' => "Skicka till e-postadressen jag anger",
    'scheduler.settings.crontabSecureShell' => 'Crontab-skal',
    'scheduler.settings.schedulerTimezoneSelector' => 'Visa uppgiftsschemat genom att använda en tidszon',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Använd systemets standard tidszon (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Använd systemets standard tidszon',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Använd tidszon I specificera',

    'scheduler.task.active' => 'Aktiva',
    'scheduler.task.subscription' => 'Abonnemang',
    'scheduler.task.subscription_powerUser' => 'Webbutrymme',
    'scheduler.task.type' => 'Uppgiftstyp',
    'scheduler.task.typeCommand' => 'Kör ett kommando',
    'scheduler.task.typeUrl' => 'Hämta en URL',
    'scheduler.task.typeScript' => 'Kör ett PHP-skript',
    'scheduler.task.command' => 'Kommando',
    'scheduler.task.arguments' => 'med argument',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'För att specificera en absolut URL, till exempel, http://example.com. Om svarstatuskoden är 2xx eller 3xx anses uppgiften ha genomförts korrekt.',
    'scheduler.task.script' => 'Skriptets sökväg',
    'scheduler.task.scriptRelativePathDescription' => 'Exempel: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Specificera hela sökvägen till skriptet. Exempel: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Använd PHP-versionen',
    'scheduler.task.scriptPathPopupTitle' => 'Skriptets sökväg',
    'scheduler.task.run' => 'Kör',
    'scheduler.task.on' => 'i',
    'scheduler.task.at' => 'på',
    'scheduler.task.sysUser' => 'Systemanvändare',
    'scheduler.task.hourly' => 'Varje timme',
    'scheduler.task.daily' => 'Dagens',
    'scheduler.task.weekly' => 'Veckovis',
    'scheduler.task.monthly' => 'Månadsvis',
    'scheduler.task.yearly' => 'Årlig',
    'scheduler.task.cronStyle' => 'Cron-stil',
    'scheduler.task.cronStyleError' => 'Ogiltig crontab-syntax.',
    'scheduler.task.cronStyleErrorWin' => 'Snedstreck (/) och bindestreck (-) tillåts inte.',
    'scheduler.task.cronStyleHint' => 'Använd UNIX crontabformatet &quot;minuter timmar dag i månaden månad veckodag&quot;. Exempel "0 22 * * 1-5". Plesk använder standardsystemets tidszon för att köra uppgiften.',
    'scheduler.task.cronStyleWinHint' => 'Anvànd formatet &quot;minuter timmar dag månad veckodag&quot; till exempel "0 22 * * 6,7". Plesk använder standardsystemets tidszon för att köra uppgiften.',
    'scheduler.task.notify' => 'Meddela',
    'scheduler.task.notifyIgnore' => 'Meddela inte',
    'scheduler.task.notifyErrors' => 'Endast fel',
    'scheduler.task.notifyAlways' => 'Varje gång',
    'scheduler.task.notifyErrorsHint' => 'Meddelanden innehåller standardfelströmmen för kommandot. Om strömmen är tom, skickas inget meddelande.',
    'scheduler.task.notifyErrorsHintWin' => 'Meddelanden innehåller kommandoutgången och skickas endast om utgångskoden inte är noll.',
    'scheduler.task.notifyAlwaysHint' => 'Meddelanden innehåller kommandoutgången. Om utgången är tom, skickas inget meddelande.',
    'scheduler.task.notifyAlwaysHintWin' => 'Meddelanden innehåller kommandoutgången och skickas oavsett kommando utgångskoden.',
    'scheduler.task.emailType' => 'Skicka meddelanden till',
    'scheduler.task.emailTypeDefault' => 'Standard systemanvändare (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Abonnemangets ägare (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administratör (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Andra användare',
    'scheduler.task.emailTypeCustomDescription' => 'Du kan specificera flera adresser separerade av komman.',
    'scheduler.task.minute' => 'minut',
    'scheduler.task.shortMinute' => 'Min',
    'scheduler.task.dayOfMonth' => 'dag',
    'scheduler.task.description' => 'Beskrivning',
    'scheduler.task.scheduleTimezoneHint' => 'Tidszonen för att köra uppgiften är %%timezone%%',
    'scheduler.task.runTaskNow' => 'Kör nu',
    'scheduler.task.runningTask' => 'Kör uppgiften &quot;%%task%%&quot;...',

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Standard serveromfattande värde (%%default%% meddelanden per timme)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Anpassad värde för planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Anpassad värde för abonnemanget',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'meddelanden',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Utgående meddelanden från en postlåda (per timme)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Utgående meddelanden från ett domän (per timme)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Utgående meddelanden från ett abonnemang (per timme)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Procentandelen av meddelanden över per-time gränsen som skall skickas den nästa timmen',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Om gränsen för utgående e-post meddelanden från en postlåda är 100 per timme och procentsatsen är 10%, så är användaren tillåten att skicka in 110 meddelanden per timme; 100 meddelanden kommer att skickas i loppet av en timme, och 10 meddelanden läggs i e-post kön och schemaläggs till sändning den nästa timmen.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail användningspolicy',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Standard serveromfattande inställningar (Sendmail är tillåtet)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Standard serveromfattande inställningar (Sendmail är inte tillåtet)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Anpassade inställningar för planen',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Anpassade inställningar för abonnemangen',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Tillåt användning av Sendmail för skript och användare i detta abonnemang',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Skripts och användare kan skicka e-postmeddelanden (å abonnemangets systemanvändares vägnar) genom att använda Sendmail även om gränserna för en postlåda och ett domän har överskridits. Maximalt antal meddelanden som kan sändas genom Sendmail vill definieras av gränsen för ett helt abonnemang.',

    'setup.hint' => 'Välkommen till Plesk, en kontrollpanel som hjälper dig hantera din server. Plesk tillhandahåller en miljö som är redo för kodning och ger dig kraftfulla ändelser för att hjäöåa dig utveckla webbplatser och appar. Komplettera inställningsprocessen för att börja använda Plesk (det tar bara en minut).',
    'setup.contactInfoSection' => 'Kontaktinformation',
    'setup.contactInfoSectionHint' => 'Uppge namn och e-postadress för att identifiera dig som ägare  servern och få viktiga meddelanden om servern. Om du är en företagsserveradministratör, ange inte ditt personliga namn eller e-postadress. Använd din jobbtitel och företags e-postadress i stället för att undvika potentiellt brott mot dataskyddslagen.',
    'setup.contactName' => 'Ditt kontaktnamn',
    'setup.emptyContactName' => 'Ange ett kontaktnamn.',
    'setup.contactNameTooLong' => 'Kontaktnamnet är för långt (maximalt %max% tecken är tillåtet).',
    'setup.email' => 'E-post',
    'setup.emptyEmail' => 'Ange en e-postadress.',
    'setup.passwordSection' => 'Lösenord',
    'setup.passwordSectionHint' => 'Nästa gång du loggar in till Plesk, använd \'admin\' användarnamn och lösenordet som anges nedan.',
    'setup.password' => 'Lösenord',
    'setup.licenseSection' => 'Licens',
    'setup.licenseSectionHint' => 'Du behöver installera en ny licens för att börja använda Plesk.',
    'setup.licenseType' => 'Välj licenstyp',
    'setup.licenseTypePaid' => 'Sätt igång med den betalda licensen',
    'setup.onlineStoreLink' => 'Webbutik',
    'setup.licenseTypeTrial' => 'Sätt igång med testlicensen med alla funktioner',
    'setup.activationCodeHint' => 'Om du redan har köpt en Plesk-licens, klistra in aktiveringskoden du fick här. Annars, kan du köpa en ny licens i vår %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Plesk Sekretesspolicy',
    'setup.trialLicenseAgreement' => 'För att utfärda en provlicens kommer Plesk International GmbH att använda och behandla informationen som tillhandahålls i de egna interna systemen, enligt %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Jag bekräftar att jag har läst och godkänner %%link%%',
    'setup.eula' => 'Licensavtal (EULA)',
    'setup.invalidEulaAgreementValue' => 'Du måste godkänna slutanvändarens licensavtal',
    'setup.sendButton' => 'Öppna Plesk >>',

    'ssl-certificate.add.name' => 'Certifikatnamn',
    'ssl-certificate.add.longName' => 'Det specificerade certifikatnamnet är för långt (maximalt %max% tecken är tillåtet).',
    'ssl-certificate.add.certificateNameUsed' => 'Ett certifikat med namnet %%name%% existerar redan.',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS-certifikatet har utfärdats. För att få det att fungera, tilldela certifikatet för att säkra en domän, e-post eller webbmail.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS-certifikatet uppdaterades korrekt.',
    'ssl-certificate.add.settings' => 'Inställningar',
    'ssl-certificate.add.settingsHint' => 'Använd detta formulär för att generera en begäran om certifikat, köpa ett certifikat från din leverantör eller generera ett självsignerat certifikat.',
    'ssl-certificate.add.settingsHint2' => 'En förfrågan är en CSR-fil som innehåller informationen om din domän som du specificerade i formuläret. Du kan skicka förfrågan till en certifikatutfärdare så att de kan utfärda ett certifikat till dig. Du laddar sedan upp det med hjälp av en av uppladdningsformulären nedan.',
    'ssl-certificate.add.settingsHint3' => 'Ett självsignerat certifikat är ett identitets-certifikat signerad av dets skapare. Om du användar ett sådant certifikat, betyder detta att du själv verifierar identiteten till din webbplats. Även om självsignerade certifikat tillåter användning av SSL/TLS, är de mindre anförtrodda och betraktas som mindre säkra.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Land',
    'ssl-certificate.add.state' => 'Region',
    'ssl-certificate.add.longState' => 'Det angivna namnet på län eller ort är för långt.',
    'ssl-certificate.add.city' => 'Ort (stad)',
    'ssl-certificate.add.longCity' => 'Det angivna stadsnamnet är för långt.',
    'ssl-certificate.add.shortCity' => 'Det angivna stadsnamnet för kort.',
    'ssl-certificate.add.companyName' => 'Organisationsnamn (företag)',
    'ssl-certificate.add.longCompanyName' => 'Det angivna företagsnamnet är för långt.',
    'ssl-certificate.add.companyUnitName' => 'Namn på organisationens avdelning eller division',
    'ssl-certificate.add.longCompanyUnitName' => 'Det specificerade organisations avdelningsnamnet är för långt (maximalt %max% tecken är tillåtet).',
    'ssl-certificate.add.domainName' => 'Domännamn',
    'ssl-certificate.add.email' => 'Email',
    'ssl-certificate.add.request' => 'Begära',
    'ssl-certificate.add.buyCertificate' => 'Köp SSL/TLS-certifikat',
    'ssl-certificate.add.selfSigned' => 'Självsignerat',
    'ssl-certificate.add.invalidCertificateParams' => 'Vissa fält är tomma eller innehåller ett felaktigt värde. Värdena ska begränsas till 64 tecken. Om du använder ett internationaliserat domännamn, se till att ingen del av domännamnet mellan punkterna överstiger 63 tecken när de omvandlas till ASCII-format. Kontrollera fälten:',
    'ssl-certificate.add.unableCreateCsr' => 'Det går inte att skapa ett CSR: %%error%%.',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Det går inte att skapa ett självsignerat certifikat: %%error%%.',
    'ssl-certificate.add.unableCreateUpload' => 'Det gick inte att ställa in certifikat data: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Det gick inte att spara certifikatet i databasen: %%error%%.',
    'ssl-certificate.add.uploadFiles' => 'Ladda upp certifikatfiler',
    'ssl-certificate.add.uploadFilesHint' => 'Använd detta formulär för att ladda upp komponenterna för ett certifikat som ingående filer.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Privat nyckel (*.key)",
    'ssl-certificate.add.certificate' => "Certifikat (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA-certifikat (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Ladda upp certifikat",
    'ssl-certificate.add.fileNotUploaded' => 'Kan inte ladda upp certifikatfilen: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Det gick inte att ställa in den privata nyckeln: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Det gick inte att ställa in certifikatet: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Det gick inte att ställa in CA-certifikatet: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Kan inte kontrollera om CA-certifikatet signerar certifikatet: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Ta bort',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Vill du verkligen ta bort CA-certifikatet?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Det gick inte att ställa in CA-certifikatet: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'CA-delen av certifikatet blev borttaget.',
    'ssl-certificate.add.rename' => 'Byt namn',
    'ssl-certificate.add.unableRenameCertificate' => 'Det gick inte att byta namn på certifikatet: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Certifikatet byttade namn till %%name%%.',
    'ssl-certificate.add.uploadText' => "Ladda upp certifikat som text",
    'ssl-certificate.add.uploadTextHint' => 'Använd detta formulär för att ladda upp komponenterna för ett certifikat som text. Kopiera innehållet av en fil och klistra in i ett korresponderande fält.',
    'ssl-certificate.add.sendText' => "Ladda upp certifikat",
    'ssl-certificate.add.componentIsMissing' => 'Komponenten saknas.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Ladda upp certifikatet här',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Om du skapade en begäran om tecknande av certifikatet på denna server och mottog certifikatfilen, ska du ladda upp det här. Om du vill ladda upp ett certifikat och ett privat kodpar har genererats på en annan server eller för att generera ett självsignerat certifikat, klicka på <b>Lägg till SSL/TLS-certifikat</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Efter att ha lagt till ett SSL/TLS-certifikat till en domän, behöver du aktivera SSL/TLS-support och välja det certifikatet i webbplatsens värdtjänstinställningar:  <b> Webbplatser och domäner</b>> <b>Värdtjänst-inställningar</b> för  denna domän> <b>Säkerhet</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certifikat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Ladda upp certifikat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Kan inte ladda upp certifikatfilen.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Ogiltigt format på certifikat.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Det gick inte att hitta den privata nyckeln för certifikatet.',

    'ssl-certificate.secure.certificate' => 'Välj certifikat',
    'ssl-certificate.secure.serverPool' => 'serverpool',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'web-app-firewall.pageHint' => 'Brandvägg för webbapplikationer skyddar webbapplikationer mot attacker genom att kontrollera och filtrera inkommande HTTP-förfrågningar baserat på användardefinierade regler.',
    'web-app-firewall.webSitePageHint' => 'Här kan du konfigurera webbprogram brandväggen (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Webbprogram brandvägg modus',
    'web-app-firewall.ruleEngineOn' => 'På',
    'web-app-firewall.ruleEngineOnDescription' => 'Varje inkommande HTTP-begäran och det relaterade svaret kontrolleras mot en uppsättning regler. Om kontrollen godkänns så överförs HTTP-begäran till webbplatsinnehållet. Om kontrollen inte lyckas så loggas händelsen, ett meddelande skickas och HTTP-svaret tillhandahålls med en felkod.',
    'web-app-firewall.ruleEngineOff' => 'Av',
    'web-app-firewall.ruleEngineOffDescription' => 'Inkommande HTTP-begäran och relaterade svar kontrolleras inte.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Bara detektering',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Varje inkommande HTTP-begäran och det relaterade svaret kontrolleras mot en uppsättning regler. Om kontrollen godkänns så överförs HTTP-begäran till webbplatsinnehållet. Om kontrollen inte lyckas så loggas händelsen och ModSecurity utför inga andra handlingar. Andra tjänster (som Fail2ban) kan fortfarande utföra egna åtgärder på HTTP-begäranden som misslyckas i kontrollen.',
    'web-app-firewall.ruleSetsSection' => 'Regeluppsättning',
    'web-app-firewall.ruleSetsSectionHint' => 'Välj vilken regeluppsättning (ett paket med filer som innehåller säkerhetsregler) att använda för kontroll av inkommande HTTP-förfrågningar.',
    'web-app-firewall.ruleSet' => 'Regeluppsättning',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratis)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set är mycket restriktiv och kan blockera vissa funktioner (till exempel fildelning, webbmail) och vissa funktioner i webbapplikationer (till exempel WordPress insticksprogram).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Verkställ ändringar?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP regler kan vara för restriktiva och därigenom blockera några funktioner, så som fildelning, webmail och vissa webbapplikationer.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratis, kan uppgraderas till Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'En startversion av ModSecurity-reglerna av Atomicorp. De ger grundläggande skydd och uppdateras varje månad.',
    'web-app-firewall.ruleSetTortixHowTo' => 'För att uppgradera denna regeluppsättning till Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Köp %%linkPleskStore%% från Plesks webbplats och %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules by Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'installera den köpta extra licensnyckeln',
    'web-app-firewall.ruleSetTortixSelect' => 'Välj den här regelsatsen, som ändrar sitt namn till "Atomic Advanced (köps från Plesk)"',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (köps från Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules by Atomicorp inkluderar Atomic standardregler plus ett antal avancerade funktioner.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (köps från Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules by Atomicorp inkluderar Atomic standardregler plus ett antal avancerade funktioner.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Byt till ett annat Atomicorp-konto.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Regelverk är aktiverat.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Om du redan har ett Atomicorp-konto med köpta Atomic Advanced-regler, ska du ange kontots inloggningsuppgifter nedan för att aktivera denna regeluppsättning.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Om du redan har ett Atomicorp-konto med de köpta Atomic Advanced-reglerna, ange kontouppgifterna nedan för att byta konto.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Användarnamn',
    'web-app-firewall.ruleSetAtomicPassword' => 'Lösenord',
    'web-app-firewall.ruleSetComodo' => 'Comodo (gratis prenumeration)',
    'web-app-firewall.ruleSetComodoDescription' => 'Gratis ModSecurityregler från Comodo. De ger grundläggande skydd.',
    'web-app-firewall.ruleSetComodoInstall' => 'Byt till ett annat Comodo-konto.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Regelverk är aktiverat.',
    'web-app-firewall.ruleSetComodoHowTo' => 'För att aktivera denna samligen regler:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'För att byta till ett annat konto:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrera dig på Comodo:s webbplats.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Ange ditt användarnamn och lösenord från den webbplatsen.',
    'web-app-firewall.ruleSetComodoLogin' => 'Användarnamn',
    'web-app-firewall.ruleSetComodoPassword' => 'Lösenord',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratis)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Gratis ModSecurityregler från Comodo. De ger grundläggande skydd.',
    'web-app-firewall.ruleSetCustom' => 'Samling av anpassade regler',
    'web-app-firewall.ruleSetCustomDescription' => 'Ladda upp en anpassad brandväggsuppsättning för webbapplikationen. Format som stödjas: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Välj en annan fil',
    'web-app-firewall.ruleSetError' => 'Det gick inte att installera regeluppsättningen för ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP-regeluppsättningen saknas. Installera om ModSecurity med Plesk-installeraren.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Den anpassade regeluppsättningen saknas. Installera om regeluppsättningen.',
    'web-app-firewall.ruleSetAuthError' => 'Det specificerade användarnamn eller lösenord är ogiltigt.',
    'web-app-firewall.ruleSetInvalid' => 'Den valda regeluppsättningen kan inte köras på %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Den valda regeluppsättningen kan inte köras på den valda webbservern.',
    'web-app-firewall.webServer' => 'Kör regler på',
    'web-app-firewall.webServerHint' => 'Välj önskad kombination av webbserver och ModSecurity-version för att se kompatibla regeluppsättningar.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Omvänd proxyserver (nginx) är inaktiverad och kan inte användas för att bearbeta förfrågningar. Välj <a href="%%serverUrl%%">en annan webbserver</a> eller aktivera den omvända proxyservern på <a href="%%servicesUrl%%">sidan för Tjänstehantering</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Att välja en annan ModSecurity-version kan resultera i att vissa inställningar inte längre är giltiga (du kan till exempel inte använda reguljära uttryck för att inaktivera säkerhetsregler med ModSecurity 3). Se till att dina inställningar fungerar som väntat efter att du verkställt ändringarna. Alternativt kan du återställa inställningarna som inaktiverar säkerhetsreglerna till standardvärdena.',
    'web-app-firewall.nginxResetCustomizations' => 'Återställ server- och domäninställningarna som slår av säkerhetsregler till standardvärden.',
    'web-app-firewall.ruleSetUpdate' => 'Regel samlingar för uppdatering',
    'web-app-firewall.ruleSetUpdateDaily' => 'Dagens',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Veckovis',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Månadsvis',
    'web-app-firewall.currentRuleSet' => 'Regeluppsättning',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% körs på %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Ändra regeluppsättning',
    'web-app-firewall.ruleSetRollbackFailed' => 'Kan inte använda den aktuella ModSecurity-regelsatsen och återskapa de tidigare version av filen, eftersom den innehåller ogiltiga konfigurationer.',
    'web-app-firewall.configurationSection' => 'Konfiguration',
    'web-app-firewall.configurationSectionHint' => 'Konfigurera brandväggen för webbapplikationer med hjälp av antingen en förbestämd uppsättning parametrar eller dina anpassade ModSecurity-direktiv.',
    'web-app-firewall.configPreset' => 'Fördefinierad samling av värden',
    'web-app-firewall.configPresetFast' => 'Snabbt',
    'web-app-firewall.configPresetFastDescription' => 'HTTP-begäran URI och delar av rubriker  kommer att analyseras.',
    'web-app-firewall.configPresetTradeOff' => 'Balanserat',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP-begäran URI, rubriker och delar förfrågningens POST data kommer att analyseras.',
    'web-app-firewall.configPresetThrough' => 'Grundig',
    'web-app-firewall.configPresetThroughDescription' => 'Hela HTTP-begäran rubrikerna, förfrågningens POST data och innehållet av HTTP svaret kommer att analyseras.',
    'web-app-firewall.configCustom' => 'Anpassade direktiv',
    'web-app-firewall.configCustomDescription' => "Ange ett ModSecurity direktiv här. Det kommer att överstyra tidigare specificerade direktiv (regeluppsättningar, specifika regler, förhandsdefinierade värdesätt, osv.).§Till exempel: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Ogiltig ModSecurity-konfiguration: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Kan inte använda den aktuella ModSecurity-konfigurationsfilen och återskapa till tidigare version av filen, eftersom de innehåller ogiltiga konfigurationer.',
    'web-app-firewall.rulesSection' => 'Stäng av säkerhetsregler.',
    'web-app-firewall.rulesSectionHint' => 'Här kan du stänga av säkerhetsregler. Det är bra om du får reda på att en säkerhetsregel är för restriktiv för vissa webbplatser. För att inaktivera säkerhetsregler, specificera deras ID (till exempel 340003), taggar (till exempel CVE-2011-4898) eller reguljära uttryck som används i regelmeddelandena (till exempel XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Här kan du stänga av säkerhetsregler. Det är bra om du får reda på att en säkerhetsregel är för restriktiv för vissa webbplatser. För att inaktivera säkerhetsregler, specificera deras ID (till exempel 340003), taggar (till exempel CVE-2011-4898) eller regelmeddelande (till exempel, Hittade användaragent associerad med säkerhets-scanner).',
    'web-app-firewall.filterById' => 'Säkerhetsregel ID\'er',
    'web-app-firewall.filterByIdInvalid' => 'Följande värden är inte giltiga: %%values%%. Regel-ID bör bestå av siffror eller ett intervall av siffror, som 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Följande värden är inte giltiga: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Märkningar',
    'web-app-firewall.filterByTagActive' => 'Aktiva:',
    'web-app-firewall.filterByTagDeactivated' => 'Inaktiverad:',
    'web-app-firewall.filterByTagInvalid' => 'Följande valda värden är inte giltiga: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Reguljära uttryck i regelmeddelanden',
    'web-app-firewall.filterByRegexpInvalid' => 'Följande värden är inte giltiga: %%values%%. De får inte innehålla symbolerna \',"',
    'web-app-firewall.filterByRegexpNginx' => 'Regelmeddelanden',
    'web-app-firewall.filterByRegexpNginxHint' => 'Endast strikta matchningar stöds.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Följande värden är inte giltiga: %%values%%. Värdemeddelandet måste bestå av bokstäver, siffror, mellanslag eller tecknen -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'ModSecurity granskningslogg',
    'web-app-firewall.auditLogHint1' => 'ModSecurity granskningsloggfil är den mäst användbara del av informationen i systemet. När ModSecurity upptäcker att en händelse inträffar, skapar den en post i granskningsloggfilen.',
    'web-app-firewall.auditLogHint2' => 'En webbplats kan upphöra att fungera som förväntat efter att du ändrar webbprogram brandvägg moduset till På från Av eller Detektion bara. I detta tilfället, analysera ModSecurity granskningsloggfilen för att se vad som händer. Du kan stänga av överkänsliga säkerhetsregler eller justera webbplatsen.',
    'web-app-firewall.auditLogHint3' => 'För att ta reda på varför en HTTP-begäran inte kan fullföljas för en webbplats:',
    'web-app-firewall.auditLogPoint1' => 'Klicka på ModSecurity loggfil länken nedanför och öppna granskningsloggfilen i ett nytt webbläsarfönster.',
    'web-app-firewall.auditLogPoint2' => 'Använd Sök (Ctrl+F i de flästa webbläsare) för att hitta händelser för webbplatsen (domännamnet) som har problem. Till exempel, your_domain.tld. Webbläsaren kommer att markera poster som till exempel HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'Sök efter en sträng tre linjer ovanför den markerade posten, som kan se ut som --eece5138-B--. De åtta tecknen mellan bindestreckarnar (i vårat exempel, eece5138) är ID för händelsen triggad av HTTP-begäran.',
    'web-app-firewall.auditLogPoint4' => 'Sök vidare efter andra poster med samma händelse-ID. Sök efter en post med bokstaven H efter händelse-ID (i vårat exempel, eece5138-H--). Denna posten innehåller ID och beskrivning av säkerhetsregeln som blev triggad under kontrollen av HTTP-begäran. Säkerhetsregelns ID är ett heltal  som startar med 3, i anförselstecken, och står med prefix ID i hakparentes. Till exempel, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Sök en säkerhetsregel ID i händelsen genom att använda en substräng [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Stäng av säkerhetsregeln med detta ID i sektionen för säkerhetsregler nedanför: ange säkerhetsregel ID (bara siffror) i säkerhetsregelns ID fält och klicka på OK.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity granskningsloggfil',
    'web-app-firewall.auditLogListLink' => 'Loggarkiv',
    'web-app-firewall.errorLogSection' => 'Fellogg',
    'web-app-firewall.errorLogSectionHint' => 'En webbplats kan upphöra att fungera som förväntat efter att du ändrar webbprogram brandvägg moduset till På från Av eller Detektion bara. I detta tilfället, analysera granskningsloggfilen för att se vad som händer. Du kan stänga av överkänsliga säkerhetsregler eller justera webbplatsen.',
    'web-app-firewall.errorLogViewLink' => 'Felloggfilen',
    'web-app-firewall.notificationStateEnabled' => 'Aviseringar från Plesk UI om uppdateringar av regeluppsättningen är påslagna. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Aviseringar från Plesk UI om uppdateringar av regeluppsättningen är avstängda. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Hantera dem på aviseringssidan',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Selecting the "Tradeoff" or "Thorough" options may cause WordPress sites to malfunction, among other unwanted side effects, because of the following <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity issue</a>.',
];