<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '子網或 IP 地址',
    'access-network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '時事通訊',
    'admin.announcement-settings.getConsentLoading' => '正在檢索有關時事通訊的資訊...',
    'admin.announcement-settings.getConsentWarning' => '無法檢索您的訂閱狀態。',
    'admin.announcement-settings.sendAnnounceConsent' => '我想要接收來自 Plesk 的時事通訊。這些訊息可能包括安全相關的、技術和常規產品方面的資訊。我同意並授權 Plesk 根據現行適用的資料保護法收集、處理和使用我的個人資料（郵箱），包括跨境處理，直接或通過協力廠商服務給我發送時事通訊。取消勾選該核取方塊則表示撤銷同意並令 Plesk 停止向我發送郵件以及從其系統中永久移除我的個人資料。',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '是，我同意接收個性化的 Plesk 通訊。Plesk International GmbH 和其附屬公司可以根據 %%privacyPolicy%% 以提供通訊為目的而存儲和處理我提供的資料。為了定制其消息和向我提供的幫助提示，Plesk 還可以使用用於分析的其它資訊，例如使用和行為資料。我可以隨時取消訂閱郵寄清單。',
    'admin.announcement-settings.privacyPolicy' => 'Plesk 隱私權原則',
    'admin.announcement-settings.noConsent' => '取消訂閱 Plesk 通訊。',
    'admin.announcement-settings.reportConsentError' => '無法保存您從 Plesk 接收資訊的設定：%%error%%。',
    'admin.announcement-settings.profileUpdateError' => '很抱歉，我們目前無法更新您的個人資料。請稍後再試。',
    'admin.announcement-settings.invalidConsentType' => "未知同意類型：'%%type%%'",
    'admin.announcement-settings.retry' => '重新嘗試',
    'admin.announcement-settings.consentGivenInfo' => '我們希望您一直喜歡我們的 Plesk 通用通訊。我們現在可以為您提供更為完善的方案，能夠根據您的需要來提供有用資訊和幫助提示，更具個性化。欲接收個性化的 Plesk 通訊，請選擇下面的第一條聲明，然後點按“確定”。',
    'admin.announcement-settings.consentNotGivenInfo' => '似乎您尚未訂閱我們的通用通訊。我們可以為您提供更為完善的方案，即個性化的通訊，能夠根據您的需要來提供有用資訊和幫助提示。',

    'admin.personal-info.title' => '編輯管理員資訊',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 設定',
    'admin.personal-info.settingsSectionLegend' => '設定',

    'admin-alias.login' => '用戶名',
    'admin-alias.password' => '密碼',
    'admin-alias.passwordConfirmation' => '確認密碼',
    'admin-alias.email' => '電郵地址',
    'admin-alias.contact' => '聯繫名稱',
    'admin-alias.comments' => '備註',
    'admin-alias.emptyLogin' => '請提供一個用戶名。',
    'admin-alias.loginTooLong' => '該用戶名的長度超過了 20 個字元。',
    'admin-alias.emptyEmail' => '請提供一個電郵地址。',
    'admin-alias.emptyContactName' => '請提供一個聯繫名稱。',
    'admin-alias.contactNameTooLong' => '此聯繫名稱的長度超過了 255 個字元。',
    'admin-alias.emptyPassword' => '請提供一個密碼。',
    'admin-alias.commentsTooLong' => '該備註的長度超過了 255 個字元。',
    'admin-alias.emailActivation' => '通過電子郵件啟動帳戶',
    'admin-alias.simplePanel' => '啟用限制模式',
    'admin-alias.simplePanelHint' => '選擇此選項來限制其它管理員可以在Plesk中採取操作的次數。若要更改可用的操作，請點按%%link%%。',
    'admin-alias.simplePanelLink' => '工具 & 設定> 限制模式設定',
    'admin-alias.lockPowerUser' => '為其他管理員提供高級用戶試圖',
    'admin-alias.lockPowerUserHint' => '限制查看其它Plesk管理員的能力（無法連接客戶、經銷商和服務計畫）。',

    'admin-info.plesk-settings.multiplyLogin' => '允許在該帳戶下進行多個會話',
    'admin-info.plesk-settings.adminLanguage' => '管理員的介面語言',
    'admin-info.plesk-settings.password' => '密碼',
    'admin-info.plesk-settings.passwordConfirmation' => '確認密碼',

    'admin-panel.form.contact-info.contactName' => '連絡人姓名',
    'admin-panel.form.contact-info.emptyContactName' => '請提供連絡人姓名。',
    'admin-panel.form.contact-info.contactNameTooLong' => '連絡人姓名太長 (最大允許%max%)。',
    'admin-panel.form.contact-info.email' => '電郵地址',
    'admin-panel.form.contact-info.emptyEmail' => '請提供電郵地址。',
    'admin-panel.form.contact-info.companyName' => '公司名稱',
    'admin-panel.form.contact-info.longCompanyName' => '公司名太長(最長%max%。',
    'admin-panel.form.contact-info.phone' => '電話號碼',
    'admin-panel.form.contact-info.longPhone' => '電話號碼太長(最長%max%)。',
    'admin-panel.form.contact-info.fax' => '傳真號碼',
    'admin-panel.form.contact-info.imNumber' => '即時通訊',
    'admin-panel.form.contact-info.longFax' => '傳真號太長(最長%max%',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '指定的電話號碼無效。',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '該傳真號不正確。',
    'admin-panel.form.contact-info.address' => '地址',
    'admin-panel.form.contact-info.longAddress' => '地址太長(最長%max%)。',
    'admin-panel.form.contact-info.city' => '城市',
    'admin-panel.form.contact-info.longCity' => '城市名太長。',
    'admin-panel.form.contact-info.shortCity' => '此城市名稱太短。',
    'admin-panel.form.contact-info.state' => '省/市/自治區',
    'admin-panel.form.contact-info.postalCode' => '郵遞區號',
    'admin-panel.form.contact-info.country' => '國家/地區',
    'admin-panel.form.contact-info.additionalInfo' => '其他資訊',
    'admin-panel.form.contact-info.additionalInfoHint' => '僅純文字：將忽略所有 HTML 標記。',
    'admin-panel.form.contact-info.duplicateEmail' => '系統中已存在帶有相同電郵地址的用戶。',

    'admin-panel.form.domain-info-section.domainInfoSection' => '訂閱',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '網站屬性',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '網站屬性',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '網站屬性',
    'admin-panel.form.domain-info-section.createSubscription' => '為客戶創建訂閱',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '如果您此刻不想為客戶創建主機服務訂閱或設定網站請清空該核取方塊。沒有訂閱，客戶將無法登入到客戶面板。',
    'admin-panel.form.domain-info-section.domainName' => '域名',
    'admin-panel.form.domain-info-section.emptyDomainName' => '您必須提供一個域名。',
    'admin-panel.form.domain-info-section.shared' => '共用',
    'admin-panel.form.domain-info-section.exclusive' => '獨立',
    'admin-panel.form.domain-info-section.userName' => '用戶名',
    'admin-panel.form.domain-info-section.userNameHint' => '用於管理在訂閱內創建的網站檔和資料夾的系統使用者帳戶。',
    'admin-panel.form.domain-info-section.emptyLogin' => '您必須提供一個用戶名。',
    'admin-panel.form.domain-info-section.password' => '密碼',
    'admin-panel.form.domain-info-section.emptyPassword' => '您必須提供一個密碼。',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '確認密碼',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "託管網站的 IP 位址是網站的虛擬主機的網路位址。",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 地址',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "託管網站的 IP 位址是網站的虛擬主機的網路位址。",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 地址',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '無',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '其它的訂閱設定',
    'admin-panel.form.domain-info-section.credentials' => '系統使用者驗證憑據',
    'admin-panel.form.domain-info-section.credentialsHint' => '通過 FTP 和 SSH 存取託管的檔',
    'admin-panel.form.domain-info-section.credentialsHintWin' => '以通過 FTP 和 RDP 存取託管的檔',

    'admin-panel.form.login-info.userName' => '用戶名',
    'admin-panel.form.login-info.emptyUserName' => '請提供用戶名。',
    'admin-panel.form.login-info.password' => '密碼',
    'admin-panel.form.login-info.emptyPassword' => '請提供密碼。',
    'admin-panel.form.login-info.passwordConfirmation' => '重複密碼',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '更改密碼也將更改內部電子郵寄地址密碼',
    'admin-panel.form.login-info.emailActivation' => '通過電子郵件啟動帳戶',
    'admin-panel.form.login-info.emailActivationHint' => '除非使用者通過電子郵件中所發送的連結啟動帳戶，或管理員手動啟動該帳戶，創建的帳號便會處於非活動狀態。',

    'admin-panel.form.subscription-info-section.subscription' => '訂閱',
    'admin-panel.form.subscription-info-section.servicePlan' => '服務方案',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '當前服務方案',
    'admin-panel.form.subscription-info-section.newServicePlan' => '新服務方案',
    'admin-panel.form.subscription-info-section.adminPlan' => '簡單方案',
    'admin-panel.form.subscription-info-section.none' => '無',
    'admin-panel.form.subscription-info-section.addonPlans' => '附加方案',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '方案關聯性更改後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '創建後繼續自訂訂閱參數。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "創建客戶後繼續自訂訂閱參數。",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '創建後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '注意執行此操作將鎖定訂閱不能同步。',
    'admin-panel.form.subscription-info-section.buttonOk' => '添加訂閱',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'app.configure.otherSettings' => '其他',
    'app.configure.passwordConfirmation' => '確認密碼',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '強制更新所有安裝的應用程式',
    'app.update-settings.forceUpdatesHint' => '允許客戶的應用程式在更新發行時自動接收更新。客戶將無法關閉應用程式的自動更新。警告：謹慎使用此選項，因為更新對應用程式功能影響很大。例如，應用程式擴展可能無法用於該應用程式的其它版本。',
    'app.update-settings.suggestUpdates' => '預設打開選項“自動更新該應用程式”',
    'app.update-settings.suggestUpdatesHint' => '對於新安裝的應用程式，將會打開應用程式設定中的“自動更新該應用程式”選項。',

    'backup.server-settings.rotation' => '可以進行存儲的完整備份檔案的最大數量（包括計畫和手動備份）',
    'backup.server-settings.rotationDescription' => '用戶可以在伺服器存儲中存儲這麼多完整的備份。如果存儲中完整備份的數量已超出限制，僅能保存最近的備份。增量備份不會影響。',
    'backup.server-settings.maxProcesses' => '同時運行計畫備份進程的最大數量',
    'backup.server-settings.niceScheduled' => '運行低優先順序的計畫備份進程',
    'backup.server-settings.niceScheduledPriority' => '優先順序',
    'backup.server-settings.niceScheduledPriorityDescription' => '輸入 1 到 19 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 優先順序',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '輸入 0 到 7 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceAlways' => '運行所有低優先順序的備份進程',
    'backup.server-settings.niceAlwaysPriority' => '優先順序',
    'backup.server-settings.niceAlwaysPriorityDescription' => '輸入 1 到 19 之間的值，數值越高優先順序越低。',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 優先順序',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '輸入 0 到 7 之間的值，數值越高優先順序越低。',
    'backup.server-settings.compressionLevel' => '壓縮層級',
    'backup.server-settings.compressionLevelNoCompression' => '無壓縮',
    'backup.server-settings.compressionLevelFastest' => '最快',
    'backup.server-settings.compressionLevelFast' => '快速',
    'backup.server-settings.compressionLevelNormal' => '正常',
    'backup.server-settings.compressionLevelMaximum' => '中等',
    'backup.server-settings.freeSpaceRequired' => '只有您的伺服器有指定容量的可用磁碟空間才開始備份（以 MB 為單位）',
    'backup.server-settings.checkBackupDiskSpace' => '僅在您的伺服器有足夠的可用磁碟空間容量時啟動備份',
    'backup.server-settings.mssqlNativeBackupEnabled' => '請使用本地 MS SQL 備份功能（對於遠端資料庫，請確保您已在 工具與設定> 資料庫伺服器 中配置了遠端 MS SQL 伺服器的備份設定）',
    'backup.server-settings.localFtpRestriction' => '允許在本機伺服器上設定 FTP 備份存儲',
    'backup.server-settings.backupSecuritySettings' => '備份安全設定',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '如果上傳到遠端存放失敗請把備份保存在伺服器存儲中',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '將要進行遠端存放的手動和計畫備份如果上傳到遠端存放失敗則將被保存在本機伺服器存儲中。使用者必須有在伺服器存儲中存儲備份的許可權。',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => '管理員的客戶',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => '所有屬於 Plesk 之前版本管理員的帳戶被轉換為管理員擁有的客戶帳戶：(1) 客戶原有的資源仍然保留（可以在客戶訂閱清單頂部的\'我的資源\'標籤裡找到），轉換成功後這些資源將被移除；(2) 所有的域名都被轉換為訂閱（每個域名對應一個新訂閱）；(3) 域名管理者轉換為客戶的使用者，只能存取包含自己域名的訂閱。',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => '原客戶狀態',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => '客戶號',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => '轉換方案',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => '一個域名；禁止調整限額。',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => '新的訂閱資源等同于原客戶最小量或域名上限。',
    'business-model-upgrade.bunch.t1s1-apply' => '轉換這些客戶',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => '一個域名；允許調整限額。',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => '新訂閱的資源等同于原客戶資源上限。',
    'business-model-upgrade.bunch.t1s2-apply' => '轉換這些客戶',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => '多個域名；禁止域名創建和限額調整。',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => '新訂閱的資源從原域名繼承，等同於其上限。',
    'business-model-upgrade.bunch.t1s3-apply' => '轉換這些客戶',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => '多個域名；允許域名創建和限額調整。',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => '轉換為：',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => '代理商，原客戶升級為代理商。原客戶的資源上限演變成現在的代理商訂閱資源。如果之前域名的域名管理員帳戶已啟用，管理員帳戶將升級為客戶帳戶，並與相應的訂閱關聯。否則，訂閱將直接屬於代理商。',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => '客戶。原客戶仍然稱為客戶。原客戶資源平均分配到各個訂閱當中。',
    'business-model-upgrade.bunch.t1s6r-solutionName' => '代理商',
    'business-model-upgrade.bunch.t1s6c-solutionName' => '客戶',
    'business-model-upgrade.bunch.t1s6-apply' => '轉換這些客戶為',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => '代理商的客戶',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => '在 Plesk 9 版本裡所有屬於代理商的客戶帳戶都轉換為各自代理商所有的客戶帳戶：(1) 每個原客戶的舊有資源已被保留（可在客戶訂閱清單頂部的 \'我的資源\' 標籤下找到），轉換一旦完成就會把原客戶移除；(2) 其所有的域名都會被轉換為訂閱（每個訂閱轉換為一個新訂閱）； (3) 域名管理員被轉換為客戶使用者，他們只能存取包含其域名的訂閱。',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => '原客戶狀態。',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => '客戶號',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => '轉換方案',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => '一個域名；禁止限額調整。',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => '新的訂閱資源等同于原客戶最小量或域名上限。',
    'business-model-upgrade.bunch.t2s1-apply' => '轉換這些客戶。',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => '一個域名；禁止限額調整。',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => '新的訂閱資源等同于原客戶的資源上限。',
    'business-model-upgrade.bunch.t2s2-apply' => '轉換這些客戶。',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => '多個域名；禁止域名創建和限額調整。',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => '新的訂閱資源繼承于原客戶的域名資源，且等同於其上限。',
    'business-model-upgrade.bunch.t2s3-apply' => '轉換這些客戶',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => '多個域名；允許域名創建和限額調整。',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => '原客戶的資源平均分配給他們的訂閱。',
    'business-model-upgrade.bunch.t2s6-apply' => '轉換這些客戶',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => '管理員的訂閱',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Plesk 舊版本中屬於 admin 的所有域名都被轉換為 admin 的訂閱。域名管理員被轉換為客戶面板使用者且只能存取包含其域名的訂閱。使用推薦的操作轉換訂閱，或在 \'選擇性訂閱轉換\' 標籤為每個訂閱選擇一個自訂轉換方案。',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => '先前域名狀態',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => '訂閱號',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => '轉換方案',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => '屬於管理者的域名；域名管理員帳號已啟用。',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => '原域名管理者升級為客戶並成為訂戶，也就是說訂閱已分配給他們。',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => '轉換這些訂閱',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => '代理商的訂閱',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Plesk 以前版本中屬於代理商的所有域名轉換代理商自己的訂閱，保留所有權。域名管理員被轉換為客戶面板使用者且只能存取包含其域名的訂閱。使用推薦的操作轉換訂閱，或在 \'選擇性訂閱轉換\' 標籤為每個訂閱選擇一個自訂轉換方案。',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => '原域名狀態',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => '服務號',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => '轉換方案',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => '屬於代理商的域名；域名管理員帳號已啟用。',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => '原域名管理者升級為客戶並成為訂戶，也就是說訂閱已分配給他們。',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => '轉換這些訂閱',
    'business-model-upgrade.bunch.thereWereSomeErrors' => '某些選定的客戶和訂閱未能轉換。',

    'change-current-subscription.hint' => '您可以在此處更改訂閱服務方案的關聯性。注意，選擇"無"作為新服務方案將從服務方案取消綁定訂閱，並設定成"自訂"。',
    'change-current-subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'change-password.oldPassword' => '舊密碼',
    'change-password.password' => '新密碼',
    'change-password.passwordConfirmation' => '確認密碼',
    'change-password.oldPasswordIsIncorrect' => '舊密碼不正確。請重試。',
    'change-password.unableToFindAdditionalAdminAccount' => '無法找到其它管理員帳戶。',
    'change-password.warningAboutAdminPasswordSyntax' => "該密碼應介於 %%min%% - %%max%% 之間且不得包含用戶名。密碼中不得使用引號、空格以及國家字母字元。",
    'change-password.warningAboutWinAdminPasswordSyntax' => "密碼中不得使用引號、空格、分號以及國家字母字元。該密碼應介於 %%min%% 和 %%max%% 之間且不得包含用戶名。",

    'change-reseller-oversell-policy.oversellPolicy' => '超額銷售策略',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '允許超額銷售',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過方案分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '不允許超額銷售',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過方案初始分配給他們的資源。',

    'change-reseller-subscription.hint' => '您可以在此處更改與代理商訂閱關聯的服務方案。注意，選擇"無"作為新服務方案會將訂閱從服務方案取消綁定，並設定為"自訂"。',
    'change-reseller-subscription.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',
    'change-reseller-subscription.servicePlan' => '新方案',
    'change-reseller-subscription.oldSubscription' => '當前方案',
    'change-reseller-subscription.none' => '無',
    'change-reseller-subscription.infoSubscriptionChanged' => '訂閱相關服務方案已更新。',
    'change-reseller-subscription.customizeSubscription' => '與服務方案的關聯更新後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',

    'change-subscription.hint' => '您可在此更改所選訂閱與服務方案的相關性。',
    'change-subscription.selectPlanLegend' => '服務方案',
    'change-subscription.selectPlanDescription' => '若要切換到其它服務方案，請從清單中選擇新方案。注意，若選擇\'無\'則取消訂閱和服務方案的綁定，使其成為\'自訂\'訂閱。',
    'change-subscription.servicePlan' => '新服務方案',
    'change-subscription.selectAddonPlansLegend' => '附加方案',
    'change-subscription.selectAddonPlansDescription' => '添加或移除附加方案。',
    'change-subscription.noChange' => '無變更',
    'change-subscription.none' => '無',
    'change-subscription.add' => '添加',
    'change-subscription.del' => '移除',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '子網或 IP 地址',
    'control-panel-access.network.subnetOrIpAddressHint' => '例如，2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '使用管理員許可權存取 Plesk',
    'control-panel-access.settings.policyAllow' => '允許，清單中的網路除外。',
    'control-panel-access.settings.policyDeny' => '拒絕不在清單中的網路。',

    'create-subscription.title' => '添加一個訂閱',
    'create-subscription.titleOwn' => '創建自己的訂閱',
    'create-subscription.poolIsEmpty' => '無法創建訂閱因為沒有共用 IP 地址且 Plesk 中沒有可用的獨立 IP 地址。',
    'create-subscription.infoNewSubscriptionCreated' => '已創建訂閱 %%name%%。',
    'create-subscription.createBeforeAppInstall' => '您需要有一個訂閱來安裝應用程式。',

    'customer.hint' => '您可在此新增客戶並為其訂閱主機服務。首先在 Plesk 中創建客戶帳戶然後訂閱主機方案以及附加方案。訂閱也可以不與任何方案綁定，提供自訂的資源和服務 — 具體操作是選擇服務方案旁邊的\'無\'。',
    'customer.contactInfoSection' => '聯繫資訊',
    'customer.additionalInfoSection' => '其它的客戶資訊',
    'customer.accessToPanelSection' => '存取 Plesk',
    'customer.contactInfoSectionHint' => '輸入客戶聯繫資訊。',
    'customer.accessToPanelSectionHint' => '客戶將用於存取其客戶面板的驗證憑據。',
    'customer.unableCreateSubscription' => '無法創建訂閱: %%reason%%',
    'customer.poolIsEmpty' => 'IP池為空',
    'customer.buttonOk' => '添加客戶',

    'database-settings.dbPrefixRadio' => '添加首碼和底線到資料庫名稱的開頭',
    'database-settings.dbPrefixNone' => '無',
    'database-settings.dbPrefixUsername' => '用戶名',
    'database-settings.dbPrefixExternalId' => '訂閱的外部 ID',
    'database-settings.dbUserPrefix' => '添加用戶名和底線到資料庫用戶名稱的開頭',
    'database-settings.dbUserPrefixHint' => '資料庫用戶名稱如：<plesk_username>_<database_user_name>。因資料庫用戶名長度的限制，<plesk_username> 可能被縮寫。',
    'database-settings.grantAlterDatabase' => '授予所有 Microsoft SQL Server 資料庫使用者修改資料庫的許可權',
    'database-settings.grantAlterDatabaseHint' => '新的和現有的用戶都將被授予該許可權',
    'database-settings.enableBackupOperator' => '使所有 Microsoft SQL 伺服器資料庫使用者擁有 db_backupoperator 角色成員身份。',
    'database-settings.enableBackupOperatorHint' => '新的和現有的用戶都將成為該角色的成員。',
    'database-settings.aclRadio' => '資料庫使用者遠端存取許可權的預設設定',
    'database-settings.aclLocalhost' => '僅允許本地連接',
    'database-settings.aclAny' => '允許來自任何主機的遠端連接',
    'database-settings.aclCustom' => '允許遠端連接來自',
    'database-settings.aclDescription' => '此設定僅可修改用戶的許可權。要啟用對本地MySQL伺服器的遠端存取，請在%%serverLink%%中選擇相應的選項',
    'database-settings.aclDescriptionLink' => '本地 MySQL 設定',
    'database-settings.example' => "例如：",
    'database-settings.aclExampleDescription' => "所指定的主機可以代表此使用者存取該資料庫。",

    'dns.add-acl-record.description' => '添加允許接收 DNS 區域副本的 DNS 伺服器 IP 位址。',
    'dns.add-acl-record.ipAddress' => 'IP 地址',
    'dns.add-acl-record.ipAddressWithMask' => 'IP 地址/遮罩',

    'dns.settings.recursion' => '遞迴DNS查詢',
    'dns.settings.recursionOn' => '允許所有請求',
    'dns.settings.recursionLocal' => '僅允許本地請求',
    'dns.settings.recursionLocalnets' => '僅允許執行來自本地網路的請求',
    'dns.settings.recursionOff' => '拒絕所有請求',
    'dns.settings.customConfiguration' => '其它 DNS 設定',
    'dns.settings.customConfigurationPlaceholder' => '您在此處指定的設定將覆蓋伺服器範圍內的設定。',
    'dns.settings.customConfigurationHint' => '如果無法找到指定的設定，請使用 named.conf 的語法將它們添加到上面的欄位中。',
    'dns.settings.customConfigurationExample' => '例如，要隱藏 DNS 伺服器的主機名稱，請添加以下行： ',
    'dns.settings.restoreDefaultButton' => '使用默認設定',

    'dns.template.synchronize-done' => '已成功應用該 DNS 區域範本。',
    'dns.template.synchronize-error' => '該 DNS 區域範本未應用至一些 DNS 區域。',
    'dns.template.synchronize-progress' => '應用該 DNS 區域範本。',

    'domain-restriction.name' => '域名',
    'domain-restriction.nameDescription' => '您可以使用星號 (*) 指定一個萬用字元模式。例如，*.example.com',
    'domain-restriction.domainAlreadyExists' => '列表中已存在指定的域名。',

    'event-handler.eventLabel' => '事件',
    'event-handler.priorityLabel' => '優先順序',
    'event-handler.userLabel' => '用戶',
    'event-handler.commandLabel' => '命令',
    'event-handler.commandHint' => '為了獲取最佳結果，請在 \'命令\' 欄位中輸入指令檔的完整路徑。不建議輸入系統命令，因為可能無效。例如，帶有輸出重定向操作符 /&gt; or &lt; 的命令可能無效。',
    'event-handler.priorityHighestText' => '低',
    'event-handler.priorityHighText' => '最高',
    'event-handler.priorityNormalText' => '自訂',
    'event-handler.priorityLowText' => '低',
    'event-handler.priorityLowestText' => '正常',
    'event-handler.priorityCustomText' => '自訂',
    'event-handler.priorityHighestOption' => '最高 (%%value%%)',
    'event-handler.priorityHighOption' => '高 (%%value%%)',
    'event-handler.priorityNormalOption' => '正常 (%%value%%)',
    'event-handler.priorityLowOption' => '低 (%%value%%)',
    'event-handler.priorityLowestOption' => '最低 (%%value%%)',

    'extension.upload.fileUpload' => '進入擴展套裝程式檔的路徑',

    'external-webmail.hint' => '您在 Plesk 中註冊了其它的 web 郵箱後，該 web 郵箱即會以一個選項的形式在主機方案和訂閱的 \'郵件\' 屬性中出現，從而供客戶使用。該 web 郵箱名稱將會在 web 郵箱選項清單中顯示，點按 客戶面板 中郵箱旁邊的 web 郵箱圖示即會打開其 URL。',
    'external-webmail.name' => 'web 郵箱服務名稱',
    'external-webmail.url' => 'web 郵箱服務URL',
    'external-webmail.enabled' => '可用',

    'ftp-settings.generalSection' => '常規',
    'ftp-settings.portRange' => '適用於被動FTP模式連接的埠或埠範圍',
    'ftp-settings.hintPortRange' => '（預設值：%%defaultPortRange%%）',

    'health.upload.hint' => '上傳健康伺服器監控配置。上傳後，即會應用配置。',
    'health.upload.selectFile' => '設定檔',

    'install-local-package.selectUploadType' => '選擇下面的一項：',
    'install-local-package.uploadAsFile' => '上傳一個 APS 包',
    'install-local-package.downloadFromCatalog' => '從應用程式目錄選擇應用程式',
    'install-local-package.formInfo' => "通過上傳新的應用程式或從應用程式目錄添加應用程式以擴展可用應用程式清單。",
    'install-local-package.invalidFileExtension' => '上傳的應用程式必須是 ZIP 壓縮檔，副檔名為.zip。',
    'install-local-package.packagesNotSelected' => '未選定套裝軟體。',
    'install-local-package.visible' => '設定客戶可用',
    'install-local-package.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',
    'install-local-package.visibleDescription' => '設定客戶可安裝此應用程式。',

    'ip-address.generalSection' => '通用',
    'ip-address.interface' => '介面',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 地址與子網路遮罩',
    'ip-address.publicIp' => '公共 IP 地址',
    'ip-address.hintPublicIp' => '如果您的 Plesk 伺服器部署在 NAT 後則可使用公共 IP 位址',
    'ip-address.distributionType' => '該 IP 地址被分配為',
    'ip-address.distributionTypeShared' => '共用',
    'ip-address.distributionTypeExclusive' => '獨立',
    'ip-address.certificate' => 'SSL/TLS 證書',
    'ip-address.defaultSite' => '默認網站',
    'ip-address.ftpOverSslNotSupportedByServer' => '已安裝的 FTP 伺服器不支援 FTPS。',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '安裝的 FTP 伺服器不支援 IPv6 位址',
    'ip-address.interfaceDHCPEnabled' => '無法添加 IP 地址。該網路介面會自動獲取 IP 位址。',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '注意：為所有未知的域名啟用了自訂 Plesk URL；將會在 "https://%%ip%%/" 上顯示 Plesk 介面而不是預設的網站',

    'ip-ban.filter.name' => '名稱',
    'ip-ban.filter.content' => '內容',
    'ip-ban.filter.filterExistsError' => '相同名稱的篩檢程式已經存在。',

    'ip-ban.jail.name' => '名稱',
    'ip-ban.jail.filter' => '篩檢程式',
    'ip-ban.jail.filterDescription' => '選擇篩檢程式。',
    'ip-ban.jail.action' => '操作',
    'ip-ban.jail.actionDescription' => '在此處選擇一項操作並點按按鈕以添加該操作。',
    'ip-ban.jail.logPath' => '日誌路徑',
    'ip-ban.jail.banTime' => 'IP 地址禁止時段',
    'ip-ban.jail.maxRetry' => '登錄嘗試失敗最多次數。',
    'ip-ban.jail.timeUnit' => '秒',
    'ip-ban.jail.addAction' => '添加',
    'ip-ban.jail.chooseAction' => '選擇：',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 驗證失敗（當登入到檔時）',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 驗證失敗（任何日誌記錄）',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 驗證失敗（當登入到系統日誌時）',
    'ip-ban.jail.apache-badbots-filter-description' => '垃圾郵件機器人程式和惡劣的網路爬蟲',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 和 POP3 驗證失敗',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 驗證失敗',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP、POP3 和 Sieve 驗證失敗（主動模式）',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde web 郵箱驗證失敗',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '違反 Web 應用程式防火牆 (ModSecurity) 安全和存取控制',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 驗證失敗',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 驗證失敗',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube web 郵箱驗證失敗',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 驗證失敗',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 用戶端錯誤（包括 RBL）',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 用戶端錯誤、驗證失敗和 DDoS 攻擊',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 和 SASL 驗證失敗',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 攻擊',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 用戶端錯誤和驗證失敗',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 用戶端錯誤（包括 RBL）',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 用戶端錯誤（僅 RBL）',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 登錄失敗',
    'ip-ban.jail.recidive-filter-description' => 'Fail2Ban 禁止重複託管',
    'ip-ban.jail.sshd-filter-description' => 'SSH 登錄失敗',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 登入失敗、協商失敗和 DDoS 攻擊',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 登入失敗和 DDoS 攻擊',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 登入和協商失敗',
    'ip-ban.jail.firewallcmd-allports-action-description' => '通過 firewalld 防火牆禁止，在所有埠上',
    'ip-ban.jail.firewallcmd-multiport-action-description' => '通過 firewalld 防火牆禁止，在多個埠上',
    'ip-ban.jail.firewallcmd-new-action-description' => '通過 firewalld 防火牆禁止，在一個埠上',
    'ip-ban.jail.iptables-action-description' => '通過 iptables 防火牆禁止，在單個埠上',
    'ip-ban.jail.iptables-allports-action-description' => '通過 iptables 防火牆禁止，在所有埠上',
    'ip-ban.jail.iptables-multiport-action-description' => '通過 iptables 防火牆禁止，在多個埠上',
    'ip-ban.jail.sendmail-action-description' => '通過 sendmail 發送郵件通知',
    'ip-ban.jail.jailExistsError' => '相同名稱的 jail 已經存在。',
    'ip-ban.jail.invalidInteger' => '指定的值無效。請指定一個整數。',

    'ip-ban.settings.pageHint' => '您可在此設定禁止 IP 位址以保護您的伺服器和託管的網站免受惡意流量的入侵。',
    'ip-ban.settings.detectionEnabled' => '啟用入侵檢測',
    'ip-ban.settings.banPeriod' => 'IP 地址禁止時段',
    'ip-ban.settings.banTimeWindow' => '檢測後續攻擊的時間間隔',
    'ip-ban.settings.maxRetries' => '禁止 IP 地址前失敗的次數',
    'ip-ban.settings.timeUnit' => '秒',
    'ip-ban.settings.invalidInteger' => '提供的值無效。請提供一個正整數。',

    'ip-ban.trusted-ip.ipAddress' => 'IP 地址',
    'ip-ban.trusted-ip.hintIpAddress' => '提供一個 IP 位址、一個 CIDR 遮罩或一個 DNS 主機名稱',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '提供的 IP 地址、網路位址或主機名稱無效。',

    'login-info.hint' => '在此處您可以修改客戶用於存取其客戶面板的用戶名和密碼。',
    'login-info.resellerHint' => '在此處您可以修改代理商用於存取其 Plesk 的用戶名和/或密碼。',
    'login-info.myProfileHint' => '您可在此修改用於存取 Plesk 的密碼。',

    'mail.lists-server-settings.email' => "郵寄清單管理員的電郵地址",
    'mail.lists-server-settings.emptyEmail' => '請提供電郵地址。',
    'mail.lists-server-settings.newPassword' => '新密碼',
    'mail.lists-server-settings.emptyPassword' => '請提供一個密碼。',
    'mail.lists-server-settings.passwordConfirmation' => '確認密碼',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '已配置郵寄清單軟體。',

    'mail.outgoing-messages.hint' => '在此處您可以指定一個郵箱的傳出資訊的限制。',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '傳出郵件資訊的最大數量',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '默認（每小時 %%domainOutgoingMessages%% 條資訊）',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '該郵箱的自訂值',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '條資訊（每小時）',

    'mail-gate-settings.host' => '主機名稱稱或 IP 地址',
    'mail-gate-settings.port' => '埠',
    'mail-gate-settings.login' => '用戶名',
    'mail-gate-settings.password' => '密碼',
    'mail-gate-settings.encryption' => 'SMTP 伺服器需要加密連接',
    'mail-gate-settings.allowUsers' => '允許用戶腳本通過該 SMTP 伺服器 （使用指定的用戶名和密碼）發送郵件。',
    'mail-gate-settings.useDefaultSettings' => '使用與 Plesk 一起安裝的郵件伺服器和 Plesk 創建的默認郵件帳戶',

    'mail-gate.hint' => '您可在此指定當未安裝 Plesk 郵件伺服器或 Plesk 郵件伺服器被禁止外發郵件時該使用的 SMTP 伺服器。該伺服器將被 Plesk 用作 SMTP 中繼以及用於發送如郵件通知之類等外發郵件的用戶腳本。',
    'mail-gate.enableMailGate' => '允許 Plesk 通過該 SMTP 伺服器發送郵件通知',
    'mail-gate.notifications' => '由外部 SMTP 伺服器發送的郵件通知',
    'mail-gate.smtpSettings' => '外部的 SMTP 伺服器設定',

    'optimization-settings.apacheModulesSection' => 'Apache 模組',
    'optimization-settings.apacheSettingsSection' => '通用設定',
    'optimization-settings.additionalPageHint' => '只有在您完全瞭解所做操作帶來的後果影響後再切換模組。注意某些修改可能會降低 Apache 的性能或甚至會導致其無法正常運行。',
    'optimization-settings.pageHint' => '在此處您可以通過關閉未使用的 Apache 模組優化 Plesk。該優化會提升記憶體利用率而能夠讓您服務更多主機客戶。注意，一些模組是相互依附的，只有關閉（啟用）其依附的模組才能關閉（啟用）該模組。',
    'optimization-settings.advancedUsersOnlyWarning' => '該功能僅適用於高級用戶。',
    'optimization-settings.apacheRestartInterval' => 'Apache 重啟間隔（秒）',
    'optimization-settings.apacheRestartIntervalHint' => 'Plesk 會對域名和子域名所做的修改在指定的間隔時間內檢查一次。如果有些修改需要重啟 web 伺服器，Plesk 會重啟 Apache。',
    'optimization-settings.gracefulRestart' => 'Apache 平滑重啟',
    'optimization-settings.gracefulRestartHint' => '選中此核取方塊以避免每次更改主機設定時伺服器上託管的所有網站出現停機情況。',
    'optimization-settings.pipedLog' => '管道日誌',
    'optimization-settings.mpmMode' => 'MPM 模式',
    'optimization-settings.moduleDeprecated' => '（已棄用）',

    'personal-info.contactInfoSection' => '聯繫資訊',
    'personal-info.hint' => '您可以在此處編輯使用者聯繫信息。',
    'personal-info.hintMyProfile' => '您可以在此處編輯聯繫資訊。',

    'php-handler.ini.formHint' => '該 php.ini 檔僅被該處理常式使用。',
    'php-handler.ini.formHintSharedIni' => '該 php.ini 檔還被以下 PHP 處理常式使用：%%handlers%%。該設定應用到使用這些處理常式的所有網站。',
    'php-handler.ini.incorrectTextForIniFile' => "指定的設定不正確且無法被保存到 php.ini 文件。錯誤：%%message%%。",

    'php-handler.modules.formHint' => '這些 PHP 擴展設定僅針對該處理常式。',
    'php-handler.modules.formHintSharedModules' => '這些設定通用於以下 PHP 處理常式：%%handlers%%。該設定應用到使用這些處理常式的所有網站。',

    'plan-item-custom.planItemName' => '服務名稱',
    'plan-item-custom.buttonLabel' => '此名稱還將用作自訂按鈕的標籤。',
    'plan-item-custom.planItemDescription' => '服務訂閱',
    'plan-item-custom.buttonTooltip' => '此文本還將用作自訂按鈕的工具提示',
    'plan-item-custom.url' => '連接到自訂按鈕的 URL',
    'plan-item-custom.backgroundImage' => '自訂按鈕的背景圖片',
    'plan-item-custom.emptyItemName' => '請提供服務標籤。',
    'plan-item-custom.emptyItemDescription' => '請提供用於服務工具提示的文本。',
    'plan-item-custom.emptyUrl' => '請指定一個URL。',
    'plan-item-custom.longItemName' => '此服務標籤太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.longItemDescription' => '此服務文本太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.longUrl' => '此 URL 太長。允許的最大長度為 %max% 符號。',
    'plan-item-custom.useCustomButton' => '使用自訂按鈕',
    'plan-item-custom.useCustomButtonHint' => '將自訂按鈕置於使用者的首頁與網站頁面。',
    'plan-item-custom.openCustomButtonInSameWindow' => '在 Plesk 中打開 URL',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => '指定是否在 Plesk 頁面上或新的流覽器視窗中打開 URL。',
    'plan-item-custom.openCustomButtonWithoutFrame' => '不要使用幀',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '若您添加一個自訂按鈕，通過該按鈕能夠進入客戶面板中的 Plesk 擴展或某個應用程式，則可以指定顯示該擴展/應用程式的方式：在幀中或作為 Plesk GUI 的一部分顯示。',
    'plan-item-custom.includeDomId' => '包含訂閱 ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '包含主域名',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => '包含 FTP 用戶名',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => '包含 FTP 密碼',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '包含客戶ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "包含客戶的公司名稱",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "包含客戶的聯繫名稱",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "包含客戶的電子郵箱",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => '選擇如何預覽網站',
    'preview-domain-settings.previewQuick' => '默認的快速預覽',
    'preview-domain-settings.previewDisabled' => '禁用快速預覽',
    'preview-domain-settings.previewQuickDescription' => '即刻預覽，推薦此選項。',
    'preview-domain-settings.previewZoneTypeInternal' => '在 Plesk 中的一個域名上快速預覽',
    'preview-domain-settings.previewZoneDomainIdDescription' => '選擇一個 Plesk 網站用於預覽。',
    'preview-domain-settings.previewZoneDomainCreate' => '若要使用該功能，至少%%link%%一個域名。',
    'preview-domain-settings.subscriptionCreateLink' => '創建',
    'preview-domain-settings.previewZoneTypeExternal' => '在一個外部域名上快速預覽',
    'preview-domain-settings.previewZoneDomainNameDescription' => '使用外部域名（DNS 區域）。如果您使用該選項，添加以下 DNS 記錄（A 類型）至外部域名區域： *.<Plesk_IP>.external.dom。此處的 <Plesk_IP> 是 Plesk 伺服器 IP，其中代表 IPv4 的點號（.）或代表 IPv6 的冒號（:）都由破折號（-）代替。如，*.192-0-2-12.external.dom。如果 Plesk 有多個註冊的 IP 位址，請為每一個位址添加一個記錄。',
    'preview-domain-settings.sitePreviewProtection' => '需要驗證',
    'preview-domain-settings.sitePreviewProtectionDescription' => '需要 FTP 登入名和密碼才能預覽。',
    'preview-domain-settings.nginxNotInstalled' => '無法進行默認的快速預覽因為未安裝 nginx web 伺服器。',
    'preview-domain-settings.nginxDisabled' => '無法進行默認的快速預覽因為 nginx web 伺服器已被禁用。',

    'reseller-preferences.settingsSection' => '設定',
    'reseller-preferences.multiLogin' => '允許多個會話',
    'reseller-preferences.language' => '介面語言',
    'reseller-preferences.interfaceView' => '選擇介面',
    'reseller-preferences.serviceProviderView' => '服務提供者視圖',
    'reseller-preferences.serviceProviderViewHint' => '該視圖面向有客戶的代理商。代理商可以在該視圖中管理客戶和自己的網站以及主機服務。',
    'reseller-preferences.powerUserView' => '高級使用者視圖',
    'reseller-preferences.powerUserViewHint' => '該視圖會給代理商提供一個簡單的介面，幫助他們管理自己的網站、郵件帳戶和其它主機服務。代理商無法在該視圖中管理客戶。',

    'reseller.hint' => '您可在此新增代理商並為其訂閱主機服務。',
    'reseller.contactInfoSection' => '聯繫資訊',
    'reseller.contactInfoSectionHint' => '輸入代理商聯繫資訊。',
    'reseller.accessToPanelSection' => '存取 Plesk',
    'reseller.accessToPanelSectionHint' => '代理商將用於存取 Plesk 管理其註冊的服務的驗證憑據。',
    'reseller.subscription' => '訂閱',
    'reseller.subscriptionSectionHint' => '選擇代理商要訂閱的服務方案。',
    'reseller.servicePlan' => '服務方案',
    'reseller.none' => '無',
    'reseller.customizeSubscription' => '創建代理商後，繼續自訂訂閱參數。注意，執行此操作會鎖定訂閱而不能同步。',
    'reseller.subscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'security-policy.encryptionSection' => '增強安全模式',
    'security-policy.encryptionSectionHint' => '增強安全模式引入了對 Plesk 中敏感性資料的增強保護。在這種模式下，Plesk 採用了多個安全機制，這些機制對 Plesk 用戶來說是絕對透明的。為了提升 Plesk 的安全度，我們建議您打開該模式。',
    'security-policy.encryptionEnable' => '增強安全模式',
    'security-policy.securePassword' => '增強安全模式',
    'security-policy.strengthSection' => '密碼強度',
    'security-policy.strengthSectionHint' => '當使用者在系統中設定新密碼（創建新的或更改現有的）時，需要根據此頁面上指定的最小強度要求調整密碼。密碼的強度是根據其總體長度和複雜性（使用數位、大小寫字母和特殊字元）來計算的。我們建議您強制您的用戶使用較強式密碼。',
    'security-policy.passwordStrength' => '最小密碼強度',
    'security-policy.secureFtpSection' => '安全 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 使用策略',
    'security-policy.ftpOverSslHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。您可在此選擇允許哪種連接。',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。您可在此選擇允許哪種連接。選定的選項將應用到伺服器上所有的 IP 地址。若要按每 IP 位址使用自訂設定，請選擇相應的選項，然後在 工具與設定> IP 地址 中更改 FTPS 策略。',
    'security-policy.ftpOverSslCustomHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS 用於使用 SSL/TLS 協定保護 FTP 伺服器與外部 FTP 用戶端之間的通信安全。如果要按每 IP 位址調整 FTPS 設定，請首先進入 工具與設定 > 安全性原則 > 安全 FTP 中選擇選項 "按每 IP 位址使用自訂 FTPS 設定"。',
    'security-policy.ftpOverSslOptionRequired' => '僅允許安全 FTPS 連接',
    'security-policy.ftpOverSslOptionEnabled' => '允許安全 FTPS 和非安全 FTP 連接',
    'security-policy.ftpOverSslOptionDisabled' => '僅允許非安全 FTP 連接。不使用 FTPS',
    'security-policy.ftpOverSslOptionCustom' => '每 IP 位址使用自訂 FTPS 策略',
    'security-policy.prohibitWebConfigHandlersSection' => '自訂處理常式策略',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '啟用此選項以禁止客戶通過 web.config 檔覆蓋在伺服器級別定義的 IIS 處理常式。',
    'security-policy.prohibitWebConfigHandlers' => '禁止通過 web.config 覆蓋處理常式',

    'service-instance.setup-instance.resourcesSection' => '服務資源',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => '已安裝',
    'service-instance.setup-instance.requirementsSection' => '需要的服務',
    'service-instance.setup-instance.requiredServiceNotSelected' => '未選擇',

    'service-node.ipAddress' => '服務節點 IP 位址',
    'service-node.ipAddressLocal' => '本機服務節點',
    'service-node.description' => '服務節點描述',
    'service-node.accessKey' => '密碼',
    'service-node.useAccessKey' => '使用驗證',
    'service-node.useAccessKeyDescription' => '關於使用驗證的提示。',
    'service-node.oldAccessKey' => '舊密碼',
    'service-node.newAccessKey' => '新密碼',
    'service-node.noAccessKeySpecified' => '未指定密碼',

    'service-plan.admin-plan.subscription_section' => '通用',
    'service-plan.admin-plan.tools_section' => '工具與資源',
    'service-plan.admin-plan.apps_section' => '應用程式與資料庫',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 外觀',
    'service-plan.admin-plan.statistics_section' => '統計',
    'service-plan.admin-plan.general_section' => '常用',
    'service-plan.admin-plan.mail_section' => '郵件',
    'service-plan.admin-plan.server_section' => '伺服器',
    'service-plan.admin-plan.modules_section' => '擴展',
    'service-plan.admin-plan.simplePanel' => '限制模式',
    'service-plan.admin-plan.enabled' => '啟用限制模式',
    'service-plan.admin-plan.enabledDescription' => '選擇此選項來限制管理員可以在Plesk中採取操作的次數。',
    'service-plan.admin-plan.aliasEnabledDescription' => '選擇此選項來限制其它管理員可以在Plesk中採取操作的次數。',

    'service-plan.applications-subscription.useFilterLabel' => '只提供我選擇的應用程式',
    'service-plan.applications-subscription.useFilterDescription' => '使用該選項選擇訂戶可用的應用程式。',
    'service-plan.applications-subscription.applications' => '應用程式',
    'service-plan.applications-subscription.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',

    'service-plan.applications.useFilterLabel' => '只提供我選擇的應用程式',
    'service-plan.applications.useFilterDescription' => '使用該選項選擇訂戶可用的應用程式。',
    'service-plan.applications.applications' => '應用程式',
    'service-plan.applications.isCommercial' => '該應用程式為商業應用程式需要購買許可證金鑰。',

    'service-plan.dns.dnsZoneType' => '域名 DNS 區域',
    'service-plan.dns.dnsZoneTypeMaster' => '主控',
    'service-plan.dns.dnsZoneTypeSlave' => '從屬',

    'service-plan.extras.groupOtherServices' => '其它服務',
    'service-plan.extras.none' => '無',

    'service-plan.hosting.enablePhysicalHosting' => '啟用主機',
    'service-plan.hosting.sectionCoreHosting' => '常規屬性',
    'service-plan.hosting.sectionScripting' => '腳本',
    'service-plan.hosting.defaultDatabaseServer' => '預設的資料庫伺服器',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '高級',
    'service-plan.hosting.phpSettingsHelpLink' => '瞭解如何選擇最適合的PHP設定',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '訂閱被掛起時網站的狀態',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '已被掛起訂閱中的網站狀態',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '當訂閱被掛起（例如，訂閱到期）時選定的狀態將被應用到方案訂閱下的所有網站。',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '當訂閱被掛起（例如，訂閱到期）時選定的狀態將被應用到網站。',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '禁用',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '網站訪客將被重定向至 web 伺服器的預設頁面。',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '掛起',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '網站訪客將會被重定向至自訂的錯誤文檔頁面（帶有搜尋引擎友好 503 HTTP 代碼）。',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '活動',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '將繼續可以通過互聯網存取網站。',

    'service-plan.ip.sharedIpAddresses' => '分配共用 IP 地址',
    'service-plan.ip.allocateExclusiveIp' => '分配獨立 IP 位址',
    'service-plan.ip.allocateExclusiveIpV4' => '分配獨立 IPv4 位址',
    'service-plan.ip.allocateExclusiveIpV6' => '分配獨立 IPv6 位址',

    'service-plan.mail.mailService' => '啟用郵件服務',
    'service-plan.mail.webMail' => 'web 郵箱',
    'service-plan.mail.mailingLists' => '啟用郵寄清單',
    'service-plan.mail.mailToNonExistentUser' => '關於不存在的用戶的郵件策略',
    'service-plan.mail.mailToNonExistentUserBounce' => '退信通知',
    'service-plan.mail.mailToNonExistentUserRedirect' => '轉發到地址',
    'service-plan.mail.mailToNonExistentUserReject' => '拒絕',
    'service-plan.mail.mailAutodiscovery' => '啟用郵件 autodiscover',
    'service-plan.mail.mailAutodiscoveryDescription' => '請在 <a href="%%link%%" target="_blank">knowledge base</a> 中查看該功能是如何運行的',
    'service-plan.mail.bounceMessage' => '此位址不再接收郵件。',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => '重定向到該 IP 位址的外部郵件伺服器：',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 禁用',

    'service-plan.misc.retainEnabled' => '保留網站和流量統計',
    'service-plan.misc.logRotation' => '日誌迴圈',
    'service-plan.misc.logRotationCondition' => '日誌迴圈條件',
    'service-plan.misc.logRotationBySize' => '按大小',
    'service-plan.misc.logRotationByTime' => '按時間',
    'service-plan.misc.logRotationDaily' => '每日',
    'service-plan.misc.logRotationWeekly' => '每週',
    'service-plan.misc.logRotationMonthly' => '每月',
    'service-plan.misc.logRotationSizeDescription' => '大小值必須在 %%min%% 與 %%max%% kB 之間。',
    'service-plan.misc.maximumNumberOfFiles' => '日誌檔最大數量',
    'service-plan.misc.compress' => '壓縮日誌檔',
    'service-plan.misc.sendLogToEmail' => 'Plesk 從 web 和 FTP 伺服器的日誌檔檢索資料後，會通過郵件發送日誌到該位址',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '月',
    'service-plan.misc.logRotationPeriodGreater' => '日志轮转周期不能比服务器范围内的限制%%max%%长。',

    'service-plan.performance.iisAppPoolAddonsHint' => '如未啟用，訂閱的所有網站都會使用專用於該訂閱的同一 IIS 應用程式池。',

    'service-plan.permissions-subscription.permissionsTabDescription' => '選擇訂閱的服務及許可權。',
    'service-plan.permissions-subscription.showMorePermissions' => '顯示更多可用許可權',
    'service-plan.permissions-subscription.hideMorePermissions' => '顯示較少許可權',
    'service-plan.permissions-subscription.noShellManagement' => '不允許',
    'service-plan.permissions-subscription.systemAccessLabel' => '管理通過SSH存取伺服器',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '允許客戶為其系統使用者啟用 SSH。請設定主機參數 “通過 SSH 在訂閱的系統使用者的名下存取伺服器 shell” 為預設參數。',

    'service-plan.permissions.permissionsTabDescription' => '選擇方案提供的服務和許可權。',
    'service-plan.permissions.permissionsAddonTabDescription' => '選擇將作為附加方案而添加到訂閱的服務及許可權。注意，在附加方案中未選的許可權不會影響到訂閱參數。',
    'service-plan.permissions.permissionsBehaviorDescription' => '許可權能夠讓客戶更改其訂閱的特定設定。當創建了一個訂閱時，Plesk 會將方案的預設值應用到客戶可以更改的設定。之後，更新方案或應用附加方案不會覆蓋客戶所做的更改。',
    'service-plan.permissions.showMorePermissions' => '顯示更多可用許可權',
    'service-plan.permissions.hideMorePermissions' => '顯示較少許可權',
    'service-plan.permissions.noShellManagement' => '不允許',
    'service-plan.permissions.systemAccessLabel' => '管理通過SSH存取伺服器',
    'service-plan.permissions.systemAccessLabel_hint' => '請設定主機參數 “通過 SSH 在訂閱的系統使用者的名下存取伺服器 shell” 為預設參數。',

    'service-plan.resources-subscription.overusePolicy' => '超額使用策略',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '不允許超額使用',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '阻止超額使用資源。如果資源使用超過了上限值，訂閱會自動被掛起。',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '允許超額使用磁碟空間與流量',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '允許超額使用磁碟空間與流量。不允許超額使用其他資源。',
    'service-plan.resources-subscription.overusePolicyAllowed' => '允許超額使用（不建議）',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '允許訂戶超額使用訂閱資源。',
    'service-plan.resources-subscription.overuseNotify' => '超額使用時通過郵件通知我。',
    'service-plan.resources-subscription.oversellPolicy' => '超額銷售策略',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '允許超額銷售',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過訂閱分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '不允許超額銷售',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過訂閱初始分配給他們的資源。',
    'service-plan.resources-subscription.mainGroupTitle' => '定義訂閱的資源使用限制。',
    'service-plan.resources-subscription.additionalGroupTitle' => '顯示更多可用資源',
    'service-plan.resources-subscription.hideMoreResources' => '顯示較少資源',

    'service-plan.resources.overusePolicy' => '超額使用策略',
    'service-plan.resources.overusePolicyNotAllowed' => '不允許超額使用',
    'service-plan.resources.overusePolicyNotAllowedHint' => '阻止超額使用資源。如果資源使用超過上限值，訂閱會自動掛起。',
    'service-plan.resources.overusePolicySoftAllowed' => '允許超額使用磁碟空間與流量',
    'service-plan.resources.overusePolicySoftAllowedHint' => '允許超額使用磁碟空間與流量。不允許超額使用其他資源。',
    'service-plan.resources.overusePolicyAllowed' => '允許超額使用（不建議）',
    'service-plan.resources.overusePolicyAllowedHint' => '允許客戶使用比初始分配給方案的更多的資源。',
    'service-plan.resources.overuseNotify' => '超額使用時通過郵件通知我。',
    'service-plan.resources.oversellPolicy' => '超額銷售策略',
    'service-plan.resources.oversellPolicyAllowed' => '允許超額銷售',
    'service-plan.resources.oversellPolicyAllowedHint' => '超額銷售允許代理商超額出售通過方案分配給他們的資源。若允許超額銷售，代理商則可支配實際使用的資源而不是初始分配的資源。',
    'service-plan.resources.oversellPolicyNotAllowed' => '不允許超額銷售',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '若不允許超額銷售，不管實際使用的資源是多少，代理商都只能出售通過方案初始分配給他們的資源。',
    'service-plan.resources.mainGroupTitle' => '定義方案的資源。',
    'service-plan.resources.additionalGroupTitle' => '顯示更多可用資源',
    'service-plan.resources.hideMoreResources' => '顯示較少資源',
    'service-plan.resources.allowSitebuilderUpsell' => '允許客戶創建試用的 Presence Builder 網站。',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '此設定允許客戶創建更多 Presence Builder 網站，不受服務方案的限制。但是客戶將需要購買這些網站才能發佈。',

    'service-plan.servicePlanName' => '服務方案名稱',
    'service-plan.resellerPlanName' => '代理商方案名稱',
    'service-plan.addonPlanName' => '附加方案名稱',
    'service-plan.adminPlanPermissionsTab' => '管理工具',
    'service-plan.adminPlanPermissionsTabDescription' => '選項當啟用了限制模式時，管理員可以使用的功能。',
    'service-plan.hostingPermissionsTab' => '主機工具',
    'service-plan.hostingPermissionsTabDescription' => '選擇當啟用了限制模式時，高級使用者視圖中的管理員可以使用的web主機工具和設定。',
    'service-plan.resourcesTab' => '資源',
    'service-plan.resourcesTabDescription' => '定義方案資源以及資源使用策略。',
    'service-plan.subscriptionResourcesTabDescription' => '定義訂閱資源以及資源使用策略。',
    'service-plan.hostingTab' => '主機參數',
    'service-plan.hostingTabDescription' => '指定主機服務的參數。注意在附加方案中指定的主機設定不會應用到通過服務方案或附加方案授以“主機設定管理”許可權的訂閱。',
    'service-plan.secureSettingsDescription' => '如果您希望提供的主機是最安全的，請%%link%%。如果訂戶享有某些許可權，則可以更改這些設定。請%%helpLink%%。',
    'service-plan.secureSettingsLink' => '應用預設的安全設定',
    'service-plan.secureSettingsHelpLink' => '瞭解安全主機設定',
    'service-plan.mailTab' => '郵件',
    'service-plan.mailTabDescription' => '指定方案的郵件服務參數。',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '指定方案的 DNS 服務參數。',
    'service-plan.performanceTab' => '性能',
    'service-plan.performanceTabDescription' => '請指定影響方案所有服務性能的系統參數。',
    'service-plan.permissionsTab' => '許可權',
    'service-plan.miscTab' => '日誌與統計',
    'service-plan.miscTabDescription' => '指定如何存儲方案訂閱的統計及日誌。注意這些設定在訂閱中不同步。',
    'service-plan.miscTabAdminPlanDescription' => '請指定如何存儲訂閱的統計和日誌。',
    'service-plan.extrasTab' => '其它服務',
    'service-plan.extrasTabDescription' => '選擇除了網站託管、DNS與郵件服務外的包含在方案裡的其它服務。',
    'service-plan.ipTab' => 'IP地址',
    'service-plan.ipTabDescription' => '定義方案的 IP 資源參數。',
    'service-plan.applicationsTab' => '應用程式',
    'service-plan.applicationsTabDescription' => '為方案選擇可供使用的應用程式。您可選擇應用程式目錄中所有的應用程式，外加您上傳到伺服器中的應用程式，或者手動選擇應用程式。如果您要選擇所有可用的應用程式，則不必在此標籤上做任何操作，只需進入 許可權 標籤選擇 存取應用程式目錄 選項即可。如果您想要手動選擇應用程式，您可在此標籤上操作。',
    'service-plan.applicationsTabDescription-addon' => '選擇可用作附加方案的應用程式',
    'service-plan.applicationsTabDescription-subscription' => '為訂閱選擇可供使用的應用程式。您可選擇應用程式目錄中所有的應用程式，外加您上傳到伺服器中的應用程式，或者手動選擇應用程式。如果您要選擇所有可用的應用程式，則不必在此標籤上做任何操作，只需進入 許可權 標籤選擇 存取應用程式目錄 選項即可。如果您想要手動選擇應用程式，您可在此標籤上操作。',
    'service-plan.planSyncSubsriptionWarning' => '部分訂閱未與方案同步。在訂閱清單中標誌為"未同步"。若要重試同步，轉到訂閱概要頁，並按一下同步按鈕。',
    'service-plan.planSyncResellerWarning' => '部分代理商未與方案同步。代理商清單中都標記為"未同步"。若要重新嘗試同步，轉到代理商概要頁，並按一下同步按鈕。',
    'service-plan.planSyncAdminWarning' => '無法應用更改到訂閱因為 Plesk 不提供這些更改所影響的某些服務或資源。原因：%%reason%%',
    'service-plan.duplicateName' => '相同名稱的方案已經存在。',
    'service-plan.phpSettingsTab' => 'PHP 設定',
    'service-plan.phpSettingsTabDescription' => '您可在此為每個訂閱指定 PHP 設定，覆蓋伺服器級的 php.ini 檔定義的設定。例如，當您想要限制客戶 PHP 腳本佔用的系統資源時，可進行此設定。客戶（如果允許）可使用其為每個域名自行調整的配置覆蓋此 PHP 配置。當您設定一個參數為預設值時，PHP 將會使用來自伺服器級的 PHP 配置的參數值。注意支援使用以下預留位置：{DOCROOT} 和 {WEBSPACEROOT} 代表獲取自訂 PHP 配置的某個域名的文檔根目錄和某個訂閱的根目錄；{TMP} 代表存儲暫存檔案的目錄。',
    'service-plan.phpSettingsTabDescriptionAddon' => '您可在此為每個訂閱指定 PHP 設定，覆蓋主要服務方案定義的設定。例如，當您想要移除在主要服務方案中設定的一些 PHP 限制時，可進行此設定。當您設定一個參數為預設值時，PHP 將會使用來自服務方案 PHP 配置的參數值。注意支援使用以下預留位置：{DOCROOT} 和 {WEBSPACEROOT} 代表獲取自訂 PHP 配置的某個域名的文檔根目錄和某個訂閱的根目錄；{TMP} 代表存儲暫存檔案的目錄。',
    'service-plan.phpSettingsPhpVersion' => '您目前 PHP 版本是 %%version%%。',
    'service-plan.phpSettingsTabAdminPlanDescription' => '您可在此為每個訂閱指定 PHP 設定，覆蓋伺服器級的 php.ini 檔定義的設定。當您設定一個參數為預設值時，PHP 將會使用來自伺服器級的 PHP 配置的參數值。',
    'service-plan.webServerSettingsTab' => 'Web 伺服器',
    'service-plan.webServerSettingsTabDescription' => '在此處您可以指定該服務方案的 Apache web 伺服器設定。如果 Apache正在使用 nginx 作為前端伺服器。您也可在該頁面上指定 nginx 設定。所有新創建的域將會接收指定的設定。但是，當您更改這些設定時，現有域將不會接收修改。',
    'service-plan.servicesTab' => '服務',
    'service-plan.servicesTabDescription' => '在此處您可以指定分配給服務方案的服務。',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 屬性',
    'service-plan.servicePropertiesTabDescription' => '在此處您可以指定分配給服務方案的 %%serviceName%% 服務的屬性。',
    'service-plan.longTaskWarning' => '在該方案上您有 %%subscriptionsCount%% 個訂閱。注意同步任務可能需要大量時間而將要在後臺執行。',
    'service-plan.hostingParametersTab' => '主機參數',
    'service-plan.adminInfoSection' => '管理員的資訊',
    'service-plan.descriptionInPanel' => '描述',
    'service-plan.longDescription' => '指定的描述太長。',
    'service-plan.conflictPermissions' => '無法授予以下許可權因為它們與代理商方案相衝突：%%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '啟動類型',
    'services.change-startup-type.autoStartupTypeLabel' => '自動',
    'services.change-startup-type.manualStartupTypeLabel' => '手動',
    'services.change-startup-type.disabledStartupTypeLabel' => '禁用',
    'services.change-startup-type.autoActionError' => '無法設定啟動類型為 \'自動\'：%%error%%',
    'services.change-startup-type.manualActionError' => '無法設定啟動類型為 \'手動\'：%%error%%',
    'services.change-startup-type.disableActionError' => '無法設定啟動類型為 \'禁用\'：%%error%%',

    'sessions.settings.restoreDefaultButton' => '重設為預設值',
    'sessions.settings.restoreDefaultButtonDescription' => '恢復會話參數為預設值。',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '會話參數有預設值。',
    'sessions.settings.idleTime' => '會話閒置時間',
    'sessions.settings.disableCheckSessionIp' => '允許在單個會話期間更改 IP 位址',
    'sessions.settings.minuteShortTitle' => '分鐘',

    'settings-ui.controls.title' => '控制項',

    'settings-ui.interface-views.description' => "有多個產品 UI 視圖供您使用。因您使用視圖的不同，各個功能與設定所處的位置會不同，甚至啟用/禁用的狀態也會不同。不同的視圖適合不同類型的用戶。",
    'settings-ui.interface-views.panelSimpleLink' => '工具 & 設定> 限制模式設定',
    'settings-ui.interface-views.useCustomView' => '啟用限制模式',
    'settings-ui.interface-views.useCustomViewHint' => '選擇此選項來限制管理員可以在Plesk面板中採取操作的次數。若要更改操作的可用性，請轉到%%customViewSettingsLink%%。',
    'settings-ui.interface-views.powerUserViewHint' => "此視圖面向伺服器管理員，配置一個簡單介面，供伺服器管理員管理自己的網站、郵件帳戶和其它服務。",
    'settings-ui.interface-views.selectUiModeTitle' => "選擇介面",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "高級使用者視圖（面向開發者和 web 代理）",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "服務提供者視圖（面向 web 主機提供商）",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "此視圖有供伺服器管理員、代理商與主機最終使用者使用的介面。",

    'settings-ui.branding.description' => 'Brand the Plesk interface by changing how the page appears in the browser\'s title bar and/or replacing the Plesk logo in the top-left corner.',
    'settings-ui.branding.buttonDefault' => '默認徽標',
    'settings-ui.branding.sectionTitle' => 'Custom title',
    'settings-ui.branding.enableCustomTitle' => 'Enable custom title on Plesk pages',
    'settings-ui.branding.customTitle' => '標題文本',
    'settings-ui.branding.sectionLogo' => 'Custom logo',
    'settings-ui.branding.enableCustomLogo' => 'Enable custom panel logo',
    'settings-ui.branding.logo' => '徽標文件',
    'settings-ui.branding.logoUrl' => '徽標 URL',
    'settings-ui.branding.logoUrlEnabled' => '自訂',
    'settings-ui.branding.logoUrlDisabled' => '默認',
    'settings-ui.branding.sectionFavicon' => 'Custom favicon',
    'settings-ui.branding.enableCustomFavicon' => 'Enable custom favicon',
    'settings-ui.branding.sectionFaviconDesc' => 'The same favicon has to be uploaded in both formats for a better support in different browsers.',
    'settings-ui.branding.faviconSvg' => 'Favicon file SVG',
    'settings-ui.branding.faviconSvgHint' => 'Allowed format: SVG',
    'settings-ui.branding.faviconIco' => 'Favicon file ICO',
    'settings-ui.branding.faviconIcoHint' => 'Allowed format: ICO',
    'settings-ui.branding.show' => '顯示',
    'settings-ui.branding.updateSuccess' => 'Plesk 品牌自訂屬性已更改。',

    'sitebuilder.trial.description' => '您可在此配置 試用後購買 方案。通過此方案客戶能夠使用 Presence Builder 裡所有可用的功能創建網站。但是他們若要發佈試用網站，則必須購買主機服務方案或附加方案。現有客戶也可通過一個主機方案或一個附加方案享用 試用後購買 模式。%%link%%',
    'sitebuilder.trial.descriptionLink' => '參閱文檔瞭解更多資訊。',
    'sitebuilder.trial.lifetimeLabel' => '試用網站期限',
    'sitebuilder.trial.lifetimeUnits' => '天',
    'sitebuilder.trial.lifetimeDescription' => '在這顯示這些未購買的試用網站多長時間將從伺服器上移除。',
    'sitebuilder.trial.signupLabel' => '啟用公共存取試用模式',
    'sitebuilder.trial.signupDescription' => '如果您想要通過推廣配置有 Presence Builder 的主機或通過提供 Presence Builder 演示來吸引客戶，則可以啟用公共存取試用模式，在您的網站上發佈存取試用模式的 URL。',
    'sitebuilder.trial.signupLinkLabel' => '存取試用模式的 URL',
    'sitebuilder.trial.signupLinkDescription' => '此 URL 將在試用模式裡打開 Presence Builder。在您的網站上發佈URL 以吸引客戶。',
    'sitebuilder.trial.promotionLabel' => '在 Presence Builder 編輯器裡顯示試用模式提示',
    'sitebuilder.trial.promotionDescription' => '如果您想要顯示有關 Presence Builder 試用模式的其它通知可使用該選項。',

    'update-settings.policyHintForPum' => '您可以在此設定自動安裝更新。當有可進行手動安裝的更新或更新已被自動安裝時發送通知郵件。',
    'update-settings.policyHint' => '當有可進行手動安裝的更新或更新已被自動安裝時發送通知郵件。',
    'update-settings.branchDisabledDescription' => '不要通知我有關升級版的資訊',
    'update-settings.automaticPatchesInstallation' => '自動安裝 Plesk 更新（推薦）',
    'update-settings.automaticPatchesInstallationHint' => '總是會自動安裝關鍵的安全更新。',
    'update-settings.automaticPatchesThirdParty' => '自動為 Plesk 附帶的協力廠商組件安裝更新',
    'update-settings.automaticSystemPackageUpdates' => '自動安裝系統套裝程式更新',
    'update-settings.automaticSystemPackageUpdatesHint' => '注意這將自動為 Plesk 附帶的協力廠商組件安裝更新',
    'update-settings.automaticPatchesNotification' => '通知有關可用的和已安裝的系統包更新的資訊',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '電郵地址',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '通知郵件頻率',
    'update-settings.daily' => '每天',
    'update-settings.weekly' => '每週',
    'update-settings.generalSection' => '常規',
    'update-settings.notificationsSection' => '通知',
    'update-settings.safeUpdatesSection' => '安全更新',
    'update-settings.safeUpdatesSectionHint' => 'Plesk 保證了會從初始安裝系統包的相同 repository 安裝系統包更新。此類更新比較安全。如果您禁用了安全更新，您的系統包管理器可能會從系統中的任一 repository 安裝更新。',
    'update-settings.safeUpdatesSectionWarn' => '我們建議您保留啟用安全更新，除非您是高級用戶。從其它任意 repositories 更新系統包可能會對您的伺服器的正常運行產生不利影響。',
    'update-settings.allowSafeUpdates' => '啟用安全更新系統包',

    'requiredFields' => '必填欄位',
];