<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Внутренняя ошибка сервера 500: опция FollowSymLinks не разрешена здесь"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Симптомы</h4><ul><li><p>На сайтах, где обработчик PHP установлен как <strong>приложение FPM, обслуживаемое Apache,</strong> или <strong>приложение FPM, обслуживаемое nginx,</strong> на странице <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> возникает одна из следующих проблем:</p><ul><li><p>медленная загрузка</p></li><li><p>отсутствие доступа (постоянно или периодически) с ошибкой 50x в ​​веб-браузере:</p><pre>502 Недопустимый шлюз</pre><hr><pre>503 Сервис временно недоступен</pre><hr><pre>504 Таймаут соединения со шлюзом</pre></li></ul></li><li><p>Следующее сообщение появляется в файле журнала ошибок PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (где <em>XX</em> – версия PHP, используемая сайтами):</p><pre>ВНИМАНИЕ: для сервера [pool example.com] достигнуто значение настройки max_children (*), рассмотрите возможность его увеличения</pre><ul><li><p>Сообщение выше обычно сопровождается этой ошибкой:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Если на сервере включен nginx, в файле журнала ошибок домена может появиться одно из следующих сообщений об ошибке <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Сайты достигли PHP-FPM <code>pm.max_children</code>.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Увеличить лимит pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Увеличьте ограничение <code>pm.max_children</code> для затронутых доменов:</p><ol><li><p>Подключитесь к серверу Plesk через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Найдите затронутые домены с помощью команды ниже:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Примечание:</strong> Число слева показывает, сколько раз сайт достиг предела <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Войдите в Plesk</a>.</p></li><li><p>Перейдите на страницу <strong>Домены</strong> &gt; <strong>example.com</strong> &gt; <strong>Настройки PHP</strong> &gt; <strong>Настройки PHP-FPM</strong>.</p></li><li><p>Увеличьте значение <code>pm.max_children</code> для домена и примените изменения. Увеличьте это значение для всех доменов, перечисленных на шаге 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Слишком много открытых файлов"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx не запускается/не перезагружается на сервере Plesk: слишком много открытых файлов</p><h4>Симптомы</h4><ul><li><p>Служба nginx не запускается/не перезагружается со следующей ошибкой в файле <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Некоторые или все сайты недоступны</p></li><li><p>Предупреждение отображается в разделе <strong>Инструменты и настройки &gt; Диагностировать и исправить</strong>:</p><pre style="white-space: pre-wrap;">Проверка значения ULIMIT nginx На сервере найдено N доменов. Возможна проблема с лимитом nginx по умолчанию для открытых файлов</pre></li><li><p>Веб-приложения NodeJS и Ruby показывают ошибку 502 Недопустимый шлюз при выполнении некоторых задач Plesk, таких как создание доменов, подписок, изменения в Apache или Nginx и т. д.:</p><pre style="white-space: pre-wrap;">Ошибка сервера<br>502 Недопустимый шлюз <br>Веб-сервер получил неверный ответ, выступая в качестве шлюза или прокси-сервера.</pre></li><li><p>После <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">установки нового сертификата для домена</a>, старый по-прежнему отображается в браузере, однако правильный сертификат можно выбрать на странице <strong>Домены &gt; example.com &gt; Настройки хостинга</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Виртуальный хост nginx открывает 4 файла журнала для каждого виртуального хоста с физическим хостингом:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>В результате сервер nginx превышает максимальное количество открытых файлов из-за большого количества доменов (обычно более 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Увеличить лимит открытых файлов',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Внимание!</strong> Выполнение утилиты <code>websrv_ulimits</code> без опции <strong>--no-restart</strong> запускает пересборку файлов веб-конфигурации для всех доменов и может привести к значительному простою в случае большого количества размещенных сайтов.<br><br>Выполните команду в течение периода обслуживания.</div><p>Рекомендуется установить значение лимита открытых файлов по меньшей мере больше, чем <strong>количество доменов в Plesk * 16</strong>. В приведенном ниже примере приведены действия, как установить ограничение на 4096:</p><ol><li><p>Подключитесь к серверу через <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Установите ограничение на количество открытых файлов до 4096 для Apache и Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Перезапустите службы Apache и nginx в <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Инструменты и настройки &gt; Управление службами</strong>, чтобы применить изменения.</p></li><li><p>Проверьте правильность применения параметра "Максимальное ограничение количества открытых файлов" после перезапуска веб-служб:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Если приведенное выше решение не поможет, установите ограничение с помощью утилиты <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Слишком большое тело ответа"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Отказано в доступе с кодом 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Внутренняя ошибка сервера 500: допустимый размер памяти XXX исчерпан"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "действует ограничение open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Доступ запрещен AH01797: клиент отклонен конфигурацией сервера"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Не удается получить доступ к каталогу сайта в Plesk: 403 Доступ запрещен"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "сервер достиг настройки MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Ограничение тела запроса PHP "клиент намеревался отправить слишком большой запрос"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Сеансы PHP "503 Внутренняя ошибка сервера" или "Не удалось прочитать данные сеанса"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Доступ запрещен: pcfg_openfile: невозможно проверить файл htaccess, убедитесь, что он читаем"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];