<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sendte for stor header under læsning af responsheader"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 intern serverfejl: Valgmuligheden FollowSymLinks er ikke tilladt her"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server nåede max_children-indstillingen"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomer</h4><ul><li><p>Websteder, der har PHP-handleren indstillet som <strong>FPM-applikation tjent af Apache</strong> eller <strong>FPM-applikation betjent af nginx</strong> på <strong>Domæner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-indstillinger</strong> oplever et af følgende problemer:</p><ul><li><p>indlæser langsomt</p></li><li><p>ikke tilgængelig (permanent eller periodisk) med en 50x fejl i en webbrowser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service midlertidigt ikke tilgængelig</pre><hr><pre>504 Gateway-timeout</pre></li></ul></li><li><p>Følgende meddelelse vises i PHP-FPM fejllogfilen <code>/var/log/plesk-php<strong>XX</strong>-fpm/fejl.log</code> (hvor <em>XX</em> er en PHP-version, der anvendes af webstederne):</p><pre>ADVARSEL: [pool example.com]-serveren har nået max_children-indstillingen (*), overvej at hæve den</pre><ul><li><p>Meddelelsen ovenfor er normalt ledsaget af denne fejl:</p><pre>kan ikke læse, hvad barnet siger: Dårlig filbeskrivelse (9)</pre></li></ul></li><li><p>Hvis nginx er aktiveret på serveren, vises en af ​​følgende fejlmeddelelser muligvis i domænets fejllogfil <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 opret forbindelse() til unix:///var/www/vhosts/system/example.com/php-fpm.sock mislykkedes (11: Ressource midlertidigt ikke tilgængelig) under oprettelse af forbindelse til upstream, client: 203.0.113.2, server: example.com, anmodning: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream afbrød forbindelsen for tidligt under læsning af responsheader fra upstream, client: 203.0.113.2, server: example.com, anmodning: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> er blevet nået af webstedet/webstederne.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Forøg grænseværdien for pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Forøg <code>pm.max_children</code>-grænsen for de berørte domæber:</p><ol><li><p>Opret forbindelse til Plesk-serveren via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Find berørte domæner vha. kommandoen nedenfor:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Bemærk:</strong> Tallet til venstre angiver, hvor mange gange grænsen <code>pm.max_children</code> er nået af webstedet.</div><pre style="white-space: pre-wrap;"># grep -r "serveren har nået max_children-indstillingen" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Log ind på Plesk</a>.</p></li><li><p>Gå til <strong>Domæner</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-indstillinger</strong> &gt; <strong>PHP-FPM-indstillinger</strong>.</p></li><li><p>Forøg værdien <code>pm.max_children</code> for domænet, og anvend ændringerne. Forøg denne værdi for alle domæner, der er angivet i trin 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "For mange åbne filer"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx kan ikke startes/genindlæses på en Plesk-server: For mange åbne filer</p><h4>Symptomer</h4><ul><li><p>Nginx-tjenesten kan ikke startes/genindlæses med følgende fejl i filen <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" mislykkedes (24: For mange åbne filer)</pre></li><li><p>Nogle eller alle websteder er ikke tilgængelige</p></li><li><p>Advarsel vises i <strong>Værktøjer &amp; Indstillinger &gt; Diagnose &amp; reparation</strong>:</p><pre style="white-space: pre-wrap;">Kontrollerer for nginx ULIMIT-værdi N domæner er fundet på serveren. Problem med nginx-standardgrænsen for åbne filer er mulig</pre></li><li><p>NodeJS- og Ruby-webapplikationer viser 502 Bad Gateway-fejl, når de udfører nogle Plesk-opgaver, såsom oprettelse af domæner, abonnementer, ændringer på Apache eller Nginx osv.:</p><pre style="white-space: pre-wrap;">Serverfejl<br>502 Bad Gateway <br>Webserveren modtog et ugyldigt respons, mens den fungerede som gateway eller proxyserver.</pre></li><li><p>Efter <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">installationen af et nyt certifikat for domænet</a>, vises det gamle stadig i en webbrowser, dog er det korrekte certifikat valgt på siden <strong>Domæner &gt; example.com &gt; Hosting-indstillinger</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx\'s virtuelle host åbner fire logfiler for hver virtuel host med fysisk hosting</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Som et resultat af dette faktum overskrides det maksimale antal åbne filer af nginx-serveren på grund af et stort antal domæner (normalt mere end 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Forøg grænseværdien for åbne filer',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advarsel:</strong> Udførelse af værktøjet <code>websrv_ulimits</code> uden muligheden <strong>--ingen-genstart</strong> starter gendannelsen af webkonfigurationsfiler for alle domæner og kan forårsage betydelig nedetid i tilfælde af et stort antal hostede websteder.<br><br>Udfør kommandoen under vedligeholdelsesperioden</div><p>Det er god praksis at indstille grænseværdien for åbne filer til mere end <strong>antallet af domæner i Plesk * 16</strong> som minimum. I eksemplet nedenfor angives handlinger til hvordan man indstiller grænsen til 4096:</p><ol><li><p>Opret forbindelse til serveren via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Indstil grænsen for åbne filer til 4096 for både Apache og Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --ingen-genstart</pre></li><li><p>Genstart Apache- og nginx-tjenester på <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong >Værktøjer &amp; Indstillinger &gt; Serviceadministration</strong> for at tilføje ændringer.</p></li><li><p>Tjek, at \'Grænsen for maks. åbne filer\' blev tilføjet korrekt efter webtjenester genstarter:</p><pre># grep \'Maks. åbne filer\' /proc/$(cat /var/run/nginx.pid)/limits<br>Maks. åbne filer 4096 4096 fil</pre></li><li><p>Hvis løsningen ovenfor ikke afhjalp problemet, skal grænsen indstilles ved hjælp af <code>ulimit</code>-værktøjet:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Responstekst for stor"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Adgang nægtet med kode 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Intern serverfejl 500: Tilladt hukommelsesstørrelse på XXX opbrugt"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir-begrænsning aktiveret"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbudt AH01797: client afvist af serverkonfigurationen"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Kan ikke få adgang til en webstedsmappe i Plesk: 403 Forbudt"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Kan ikke få adgang til en webstedsmappe i Plesk: 403 Forbudt"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server har nået MaxRequestWorkers-indstillingen"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP-anmodningstekstgrænse "klient havde til hensigt at sende for stor tekst"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP-anmodningstekstgrænse "klient havde til hensigt at sende for stor tekst"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-sessioner "503 intern serverfejl" eller "Kunne ikke læse sessionsdata"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbudt: pcfg_openfile: ude af stand til at tjekke htaccess-filen, sørg for, at den er læsbar"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];