<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'admin-plan.title' => 'Restricted Mode Settings',
    'admin-plan.hint' => 'Here you can choose:<ul><li>Which server administration tools and settings are available to the administrator when Restricted Mode is enabled (the "Administration Tools" tab).</li><li>Which web hosting administration tools and settings are available to the administrator in Power User view when Restricted Mode is enabled (the "Hosting Tools" tab).</li><li>Which services and resources on subscriptions are available to the administrator in Power User view when Restricted Mode is enabled. You do so by configuring the custom hosting plan Plesk applies to all subscriptions created in Power User view (the remaining tabs).</li></ul>',
    'admin-plan.adminPlanSaved' => 'Restricted Mode settings were saved.',

    'ftp-settings.title' => 'FTP Settings',
    'ftp-settings.success' => 'To make sure that the new passive FTP mode port range is accessible via the firewall, check it on the <a href="%%url%%">firewall settings page</a>.',
    'ftp-settings.algWarning' => 'Due to active Windows Firewall and Windows Application Layer Gateway Service (ALGS) not allowing to use a custom passive FTP ports range, it is recommended to switch ALGS off. If ALGS service is switched on, passive FTP ports range will be set to default 5001-65535, ignoring any custom values. Refer to Microsoft Windows help files for the information on how to switch ALGS off.',

    'optimization-settings.title' => 'Apache Web Server Settings',
    'optimization-settings.pageHint_powerUser' => 'Here you can toggle Apache modules. Use this feature to optimize memory utilization, turn on modules required by your apps, or turn off problem modules. Note that some modules are interdependent and can be switched off (on) only when the modules they depend on are off (on).',
    'optimization-settings.optimizationSettingsSaved' => 'Apache modules configuration was saved.',

    'preview-domain-settings.title' => 'Website Preview Settings',
    'preview-domain-settings.pageHint' => 'Quick Preview allows customers to preview websites before their DNS settings are configured and propagated.',
    'preview-domain-settings.previewDomainSettingsSaved' => 'Website preview settings were updated.',

    'secure-passwords.title' => 'Security Policy',
    'secure-passwords.passwordsSecuritySettingsSaved' => 'Security settings were successfully saved.',
    'secure-passwords.hintInfo' => '(?)',
    'secure-passwords.hintTitle' => 'Security Mode',
    'secure-passwords.disabledDisclamer' => 'Important Notes:',
    'secure-passwords.disabledDisclamerItem1' => 'Turning the mode on is an irrevocable operation. Therefore, if for some reason you want to be able to restore the default security configuration, back up all server data before turning the mode on.',
    'secure-passwords.disabledDisclamerItem2' => 'The mode may affect third-party software which is integrated with Plesk by means of the remote API. Specifically, in the enhanced security mode, Plesk prohibits obtaining sensitive data (such as user passwords) through the API. If you use such software, contact its vendor to ensure they provide the full support for Plesk 11.',
    'secure-passwords.disabledDisclamerItem3' => 'If you use Odin Business Automation Standard (OBAs) as an accompanying billing solution, the enhanced security mode should be turned on.',
    'secure-passwords.enabledHeader' => 'The enhanced security mode is turned on.',
    'secure-passwords.enabledExplanation' => 'This means the following:',
    'secure-passwords.enabledExplanationItem1' => 'All sensitive data in Plesk are reliably protected from unauthorized access.',
    'secure-passwords.enabledExplanationItem2' => 'If you employ third-party software which uses the Plesk remote API, note that it may be affected by the mode. Specifically, in the enhanced security mode, Plesk prohibits obtaining sensitive data (such as user passwords) through the API.',
    'secure-passwords.enabledNote' => 'Note that the enhanced security mode cannot be turned off.',

    'tools.title' => 'Tools & Settings',
    'tools.pageHint' => 'This is where you manage the server, and configure Plesk, system services, and resources.',
    'tools.resourcesPanel' => 'Tools & Resources',
    'tools.summaryReport' => 'Summary Report',
    'tools.summaryReportDescription' => 'View a report on resource usage by users and websites.',
    'tools.summaryReportKeywords' => 'information amount delivery traffic statistics stats',
    'tools.ipAddresses' => 'IP Addresses',
    'tools.ipAddressesDescription' => 'View, add, and remove server IP addresses.',
    'tools.ipAddressesDescriptionWithResellers' => 'View, add, and remove server IP addresses, and assign IP addresses to resellers.',
    'tools.ipAddressesKeywords' => 'address host IPv4 IPv6 network dedicated shared pool',
    'tools.applicationsVault' => 'Application Vault',
    'tools.applicationsVaultDescription' => 'Manage APS web apps: Install, configure, and remove app packages, check for package updates, make apps available to your customers in Customer Panel.',
    'tools.applicationsVaultKeywords' => 'catalog storefront repository upload',
    'tools.databaseServers' => 'Database Servers',
    'tools.databaseServersDescription' => 'Configure and manage database servers used by Plesk.',
    'tools.databaseServersKeywords' => 'remote DB MySQL SQL MSSQL postgres',
    'tools.odbcDataSources' => 'ODBC Data Sources',
    'tools.odbcDataSourcesDescription' => 'Configure ODBC data sources for connections to external databases.',
    'tools.iisApplicationPool' => 'IIS Application Pool',
    'tools.iisApplicationPoolDescription' => 'Configure and manage IIS application pool.',
    'tools.virtualHostTemplate' => 'Virtual Host Template',
    'tools.virtualHostTemplateDescription' => 'Define a set of directories and files that should be created for each site on the server.',
    'tools.virtualHostTemplateKeywords' => 'custom default',
    'tools.sslCertificates' => 'SSL/TLS Certificates',
    'tools.sslCertificatesDescription' => 'View and manage SSL/TLS certificates, and secure connections to Plesk.',
    'tools.sslCertificatesKeywords' => 'certificate repository self-sign encrypt protect authority sign security CSR',
    'tools.setupMailingListsServer' => 'Set Up Mailing Lists Server',
    'tools.setupMailingListsServerDescription' => 'Set up Mailman mailing lists server.',
    'tools.setupMailingListsServerKeywords' => 'mail list mailing list maillist group',
    'tools.mailQueue' => 'Mail Queue',
    'tools.mailQueueDescription' => 'View and manage mail queue',
    'tools.mailQueueKeywords' => 'mail queue',
    'tools.downloadSmarterMail' => 'Download SmarterMail',
    'tools.downloadSmarterMailDescription' => 'Download the SmarterMail mail server package for installing it on the server.',
    'tools.trafficUsageByDomains' => 'Traffic Usage by Domains',
    'tools.trafficUsageByDomainsDescription' => 'View reports on traffic usage by domains.',
    'tools.trafficUsageByDomainsKeywords' => 'statistics stats',
    'tools.trafficUsageByResellers' => 'Traffic Usage by Resellers',
    'tools.trafficUsageByResellersDescription' => 'View reports on traffic usage by resellers.',
    'tools.trafficUsageByResellersKeywords' => 'statistics stats',
    'tools.trafficUsageByUsers' => 'Traffic Usage by Customers',
    'tools.trafficUsageByUsersDescription' => 'View reports on traffic usage by customers.',
    'tools.trafficUsageByUsersKeywords' => 'statistics stats',
    'tools.massEmailMessages' => 'Mass Email Messages',
    'tools.massEmailMessagesDescription' => 'Send an email message to a number of Plesk users at once.',
    'tools.massEmailMessagesKeywords' => 'mail template',
    'tools.scheduledTasks' => 'Scheduled Tasks (Cron jobs)',
    'tools.scheduledTasksDescription' => 'Schedule execution of scripts or utilities on the server.',
    'tools.scheduledTasksKeywords' => 'command cron jobs',
    'tools.taskManager' => 'Task Manager',
    'tools.taskManagerDescription' => 'View and manage task queue',
    'tools.taskManagerKeywords' => 'task manager queue',
    'tools.eventManager' => 'Event Manager',
    'tools.eventManagerDescription' => 'Set up execution of custom commands and scripts when specific events are registered in Plesk.',
    'tools.eventManagerKeywords' => 'handler variable command',
    'tools.backupManager' => 'Backup Manager',
    'tools.backupManagerDescription' => 'Back up and restore data related to websites, Plesk services, and user accounts.',
    'tools.backupManagerKeywords' => 'archive',
    'tools.panelPanel' => 'Plesk',
    'tools.additionalAdministratorAccounts' => 'Additional Administrator Accounts',
    'tools.additionalAdministratorAccountsDescription' => 'Set up additional administrator accounts if you need to delegate system administration tasks to other users.',
    'tools.activePanelSessions' => 'Active Plesk Sessions',
    'tools.activePanelSessionsDescription' => 'See who is currently working in Plesk and close user sessions if required.',
    'tools.activeFtpSessions' => 'Active FTP Sessions',
    'tools.activeFtpSessionsDescription' => 'See who is currently connected to the server using FTP and close sessions if required.',
    'tools.activeTerminalServiceSessions' => 'Active Terminal Services Sessions',
    'tools.activeTerminalServiceSessionsDescription' => 'See who is currently connected to the server using Terminal Services and close sessions if required.',
    'tools.licenseManagement' => 'License Management',
    'tools.licenseManagementDescription' => 'View the options provided by your license. Order and install license keys for Plesk and add-ons.',
    'tools.licenseManagementKeywords' => 'renew prolong expiration revert roll activation code',
    'tools.support' => 'Support',
    'tools.supportDescription' => 'Submit a request for technical support assistance.',
    'tools.supportKeywords' => 'bug help issue error troubleshooting',
    'tools.forum' => 'Forum',
    'tools.forumDescription' => 'Plesk Forums',
    'tools.helpCenter' => 'Help Center',
    'tools.helpCenterDescription' => 'Plesk Help Center',
    'tools.healthMonitor' => 'Health Monitoring',
    'tools.healthMonitorDescription' => 'See detailed reports on the server health.',
    'tools.updates' => 'Updates',
    'tools.updatesDescription' => 'Update your Plesk and install additional components.',
    'tools.serverManagementPanel' => 'Server Management',
    'tools.securityPanel' => 'Security',
    'tools.servicesPanel' => 'Service installations',
    'tools.troubleshootingPanel' => 'Assistance and Troubleshooting',
    'tools.serviceNodes' => 'Service Nodes',
    'tools.serviceNodesDescription' => 'Service Nodes Management',
    'tools.packageUpdateManager' => 'System Updates',
    'tools.packageUpdateManagerDescription' => 'View and install available updates for operating system packages.',
    'tools.serverInformation' => 'Server Information',
    'tools.serverInformationDescription' => 'View detailed statistics on usage of system resources, such as CPU, memory, and disk space.',
    'tools.serverInformationKeywords' => 'stats utilization performance process load RAM',
    'tools.servicesManagement' => 'Services Management',
    'tools.servicesManagementDescription' => 'View and manage system services.',
    'tools.servicesManagementKeywords' => 'start stop restart tomcat java dns bind apache kaspersky spamassassin qmail imap pop smtp courier postgres mysql task ftp firewall nginx reverse proxy',
    'tools.remoteDesktop' => 'Remote Desktop',
    'tools.remoteDesktopDescription' => 'Use an integrated Web-based client to open a remote desktop connection to the server.',
    'tools.remoteDesktopKeywords' => 'rdp terminal session',
    'tools.rebootServer' => 'Restart Server',
    'tools.rebootServerDescription' => 'Restart the server.',
    'tools.rebootServerKeywords' => 'reboot restart',
    'tools.domainRestriction' => 'Prohibited Domain Names',
    'tools.domainRestrictionDescription' => 'Turn on or off the checking for prohibited domain names. Manage the list of prohibited domain names.',
    'tools.domainRestrictionKeywords' => 'prohibited domain names',
    'tools.buttonServerRebootConfirmationTitle' => 'Do you really want to restart server?',
    'tools.buttonServerRebootConfirmationDescription' => 'This operation will restart the server.',
    'tools.shutdownServer' => 'Shut Down Server',
    'tools.shutdownServerDescription' => 'Shut down the server. If you shut down the server using this button, you will not be able to start it remotely.',
    'tools.buttonShutdownConfirmationTitle' => 'Do you really want to shut the server down?',
    'tools.buttonShutdownConfirmationDescription' => 'This operation will shut the server down. The server cannot be restarted remotely by means of this software.',
    'tools.vzpp' => 'Manage Your Container',
    'tools.vzppDescription' => 'Open Power Panel with your container in a new window.',
    'tools.vzppKeywords' => 'virtuozzo vps virtual environment',
    'tools.myPleskPanel' => 'External Services',
    'tools.toolsFromMyPlesk' => 'View Services',
    'tools.toolsFromMyPleskDescription' => 'View online services available from your provider.',
    'tools.toolsFromMyPleskKeywords' => 'buy purchase order',
    'tools.registerDomain' => 'Register Domain Names',
    'tools.registerDomainDescription' => 'Register domain names with a domain name registrar recommended by your provider.',
    'tools.registerDomainKeywords' => 'buy purchase order',
    'tools.manageDomain' => 'Manage Domain Names',
    'tools.manageDomainDescription' => 'Update registration information for your domain names, specify name servers, and renew domain registration.',
    'tools.registerServer' => 'Register Your Server',
    'tools.registerServerDescription' => 'Register your server with MyPlesk.com portal to participate in the affiliate program and earn commissions.',
    'tools.buySslCert' => 'Buy SSL/TLS Certificate',
    'tools.buySslCertDescription' => 'Purchase SSL/TLS certificates to secure connections to Plesk and to the hosted websites.',
    'tools.buySslCertKeywords' => 'order',
    'tools.businessModelUpgrade' => 'Complete Switching to the new Plesk business model',
    'tools.businessModelUpgradeDescription' => 'After upgrading to Plesk 11, transition former clients, domains and domain administrators to fit in the new model.',
    'tools.statisticsPanel' => 'Statistics',
    'tools.generalPanel' => 'General Settings',
    'tools.serverComponents' => 'Server Components',
    'tools.serverComponentsDescription' => 'View the software components installed on the server.',
    'tools.serverComponentsKeywords' => 'package',
    'tools.serverSettings' => 'Server Settings',
    'tools.serverSettingsDescription' => 'Set the server\'s host name, statistics calculation preferences, and restrict creation of DNS zones for users.',
    'tools.systemTime' => 'System Time',
    'tools.systemTimeDescription' => 'Adjust system date and time, and enable time synchronization with a time server on the Internet.',
    'tools.serverStatistics' => 'Server Statistics Settings',
    'tools.serverStatisticsDescription' => 'Configure global statistics settings.',
    'tools.serverStatisticsKeywords' => 'stats usage calculation',
    'tools.ftpSettings' => 'FTP Settings',
    'tools.ftpSettingsDescription' => 'Configure port ranges for passive FTP connections to the server.',
    'tools.previewDomainSettings' => 'Website Preview',
    'tools.previewDomainSettingsDescription' => 'Specify one of your domains under which websites of your customers will be previewed.',
    'tools.dnsTemplate' => 'DNS Settings',
    'tools.dnsTemplateDescription' => 'Configure the global DNS zone template that predefines DNS zone settings for all domain DNS zones served by the name server.',
    'tools.restrictCreationOfSubzones' => 'Restrict Creation of Subzones',
    'tools.restrictCreationOfSubzonesDescription' => 'Restrict creation of subdomains and domain aliases in DNS zones belonging to other users.',
    'tools.restrictAdministrativeAccess' => 'IP Access Restriction Management',
    'tools.restrictAdministrativeAccessDescription' => 'Specify IP addresses of computers or networks from which the administrative access to Plesk must be allowed.',
    'tools.restrictAdministrativeAccessKeywords' => 'deny grant',
    'tools.firewall' => 'Firewall',
    'tools.firewallDescription' => 'Configure the firewall to allow or forbid network connections to the hosting services.',
    'tools.firewallKeywords' => 'rule panic port tcp udp protect connection icmp block',
    'tools.sessionIdleTime' => 'Session Idle Time',
    'tools.sessionIdleTimeDescription' => 'Configure the period that a user session is allowed to remain idle before it is closed.',
    'tools.applicationsAndDatabasesPanel' => 'Applications & Databases',
    'tools.databaseHostingPreferences' => 'Database Hosting Preferences',
    'tools.databaseHostingPreferencesDescription' => 'Specify whether Plesk should add usernames to database names and whether it should allow installation of web applications that cannot use remote databases.',
    'tools.databaseHostingPreferencesKeywords' => 'DB MySQL SQL MSSQL postgres',
    'tools.aspNetSettings' => 'ASP.NET Settings',
    'tools.aspNetSettingsDescription' => 'Configure the global settings for execution of ASP.NET applications on the server.',
    'tools.sitebuilderSettings' => 'Try and Buy Mode Settings',
    'tools.sitebuilderSettingsDescription' => 'Configure scenarios for acquiring new customers to your hosting services.',
    'tools.googleServicesForWebsitesSettings' => 'Settings of Google Services for Websites',
    'tools.googleServicesForWebsitesSettingsDescription' => 'Integrate Google Services for Websites with Plesk.',
    'tools.optimizationSettings' => 'Apache Web Server',
    'tools.optimizationSettingsDescription' => 'Optimize Plesk by switching off unused service modules.',
    'tools.optimizationSettingsKeywords' => 'apache module advanced vps optimized piped',
    'tools.phpSettings' => 'PHP Settings',
    'tools.phpSettingsDescription' => 'Manage PHP settings.',
    'tools.phpSettingsKeywords' => 'PHP handler module',
    'tools.securePasswords' => 'Security Policy',
    'tools.securePasswordsDescription' => 'Configure various security settings like passwords strength or secure FTP.',
    'tools.securePasswordsKeywords' => 'password security policy FTPS secure ftp',
    'tools.mailPanel' => 'Mail',
    'tools.mailServerSettings' => 'Mail Server Settings',
    'tools.mailServerSettingsDescription' => 'Set up email services and protection from spam and viruses.',
    'tools.mailServerSettingsKeywords' => 'email email message relay outgoing',
    'tools.virusProtectionSettings' => 'Antivirus',
    'tools.virusProtectionSettingsDescription' => 'Set up protection from viruses and other malicious software.',
    'tools.virusProtectionSettingsKeywords' => 'kaspersky antivirus anti-virus email email mail',
    'tools.spamFilterSettings' => 'Spam Filter',
    'tools.spamFilterSettingsDescription' => 'Set up protection from unsolicited commercial email.',
    'tools.spamFilterSettingsKeywords' => 'spamassassin antispam anti-spam email email mail',
    'tools.outgoingMailControl' => 'Outgoing Mail Control',
    'tools.outgoingMailControlDescription' => 'Monitor attempts to exceed limits on outgoing mail.',
    'tools.outgoingMailControlKeywords' => 'outgoing mail outgoing anti spam outgoing mail control outgoing mail limits',
    'tools.commTouch' => 'Outgoing Spam Filter',
    'tools.commTouchDescription' => 'Odin Premium Outbound Antispam is a high performance solution that supports real-time spam classifications, allowing fast detection and blocking of outbound spam.',
    'tools.commTouchKeywords' => 'spam outgoing anti-spam antispam',
    'tools.webmailSettings' => 'Webmail',
    'tools.webmailSettingsDescription' => 'Register additional webmail services, and set up webmail options available to your customers.',
    'tools.mailGateSettings' => 'External SMTP Server',
    'tools.mailGateSettingsDescription' => 'Set custom SMTP relay for outgoing mail',
    'tools.mailGateSettingsKeywords' => 'outgoing mail email notifications custom smtp server',
    'tools.uiPanel' => 'Plesk Appearance',
    'tools.controlPanelBranding' => 'Branding',
    'tools.controlPanelBrandingDescription' => 'Set your own logo image, text in the browser\'s title bar, or apply a custom branding theme.',
    'tools.controlPanelBrandingKeywords' => 'skin look',
    'tools.languages' => 'Languages',
    'tools.languagesDescription' => 'View and manage installed language packs.',
    'tools.languagesKeywords' => 'localize interface',
    'tools.skins' => 'Skins',
    'tools.skinsDescription' => 'View and manage visual styles for Plesk.',
    'tools.interfaceManagement' => 'Interface Management',
    'tools.interfaceManagementDescription' => 'Select a Plesk UI view, a language, or specify which buttons need to be removed from Plesk.',
    'tools.interfaceManagementKeywords' => 'GUI',
    'tools.customButtons' => 'Custom Buttons',
    'tools.customButtonsDescription' => 'Add shortcuts to your apps or any other resources available at external URLs.',
    'tools.notifications' => 'Notifications',
    'tools.notificationsDescription' => 'Set up Plesk to automatically send resource overuse and account expiration warnings to users.',
    'tools.notificationsKeywords' => 'notice event',
    'tools.actionLog' => 'Action Log',
    'tools.actionLogDescription' => 'Set up logging of actions performed by Plesk users.',
    'tools.actionLogKeywords' => 'event',
    'tools.fileSharingSettings' => 'File Sharing',
    'tools.fileSharingSettingsDescription' => 'Configure file sharing on your subscriptions.',
    'tools.fileSharingSettingsKeywords' => 'share folder public',
    'tools.automaticUpdatesSettings' => 'Update Settings',
    'tools.automaticUpdatesSettingsDescription' => 'Set up Plesk to automatically install updates.',
    'tools.automaticUpdatesSettingsKeywords' => 'stable testing release upgrade',
    'tools.adminPlan' => 'Restricted Mode Settings',
    'tools.adminPlanDescription' => 'Select actions available to the administrator and limit resources allotted to new subscriptions in this view.',
    'tools.adminPlanKeywords' => 'admin plan power user permissions interface customization view actions subscription simple custom',
    'tools.selectServiceNode' => 'Select Service Node',
    'tools.additionalServices' => 'Additional Services',
    'tools.serverProtection' => 'IP Address Banning (Fail2Ban)',
    'tools.serverProtectionDescription' => 'Set up Plesk to automatically ban IP addresses and networks that generate malicious traffic for your server.',
    'tools.webAppFirewall' => 'Web Application Firewall (ModSecurity)',
    'tools.webAppFirewallDescription' => 'ModSecurity provides protection from a range of attacks against web applications.',
    'tools.webAppFirewallKeywords' => 'modsecurity mod_security waf',
    'tools.about' => 'About Plesk',
    'tools.aboutDescription' => 'View details about your Plesk installation.',
    'tools.cookies' => 'Cookies in Plesk',
    'tools.cookiesDescription' => 'Set up cookie preferences.',
    'tools.customizePanelAccess' => 'Customize Plesk URL',
    'tools.customizePanelAccessDescription' => 'Customize URLs used for logging in to Plesk.',
    'tools.customizePanelAccessKeywords' => 'url logging login access port',
    'tools.websitesDiagnostic' => 'Websites diagnostic',
    'tools.websitesDiagnosticDescription' => 'Analyze the website logs to detect unavailability or incorrect work of your websites.',
    'tools.websitesDiagnosticKeywords' => 'website domain log diagnostic check',
];
