<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Åtkomst nekad.  Ditt konto är tillfälligt upphävt.",
    'login_up__login_has_been_locked' => "Du har försökt logga in med hjälp av ett felaktigt lösenord för många gånger. Av säkerhetsskäl kommer du inte kunna logga in under detta användarnamn under en viss tid.",
    'login_up__login_label_plesk' => "Logga in på %1", // PFU
    'login_up__login_label_parallels' => "Logga in på Plesk %1",
    'login_up__login_text' => "Ange ditt användarnamn {0} och lösenord.",
    'login_up__unable_to_check_pass' => "Kan inte kontrollera lösenordet %1.",
    'login_up__warning_limits_licence_key' => "En av följande poster har överskridit gränsen som definieras med din licensnyckel: antal användarkonton, domäner, e-postkonton eller webbanvändare som använder din server.\nKontakta Plesk försäljningsavdelning för att koden som ger dig möjlighet att ha önskat antal användare och domäner. Kontakta Plesk tekniska supportavdelning om du tror att du har fått detta meddelande av misstag.\nDen licensierade gränsen för användarkonton/domäner/e-postkonton/webbanvändare/språkpaket: %2.\nAntalet användarkonton/domäner/e-postkonton/webbanvändare/språkpaket som tillåts för närvarande: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Mängden resurser du kör med har överskridit gränserna som definieras av din aktuella produktlicens. Kontakta Plesk försäljningsavdelning och köp en ny licensnyckel.",
    'login_up__grace_period' => 'Du nyttjar för närvarande prövoperioden av produktlicensen. För att uppdatera produktlicensen, välj Hämta nycklar-alternativet på %1sidan Licenshantering%2.',
    'login_up__partner_license_message' => 'Du för använder närvarande en begränsad produktlicens som kräver registrering innan den fullständiga funktionsuppsättningen aktiveras. För att uppdatera produktlicensen, välj Hämta nycklar-alternativet på %1sidan Licenshantering%2.',
    'login_up__system_admin_disabled' => 'Superanvändaren (rot- eller administratörskontot) får inte logga in på Plesk av säkerhetsskäl.',
    'login_up__mobile_application_message' => 'För en bättre upplevelse rekommenderar vi att du installerar applikationen %%name%%.',
    'login_up__mobile_application_install' => 'Installera nu',
    'login_up__mobile_application_hide' => 'Nej tack',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk administratörsguide",
    'plesk_guide_reseller' => "Plesk återförsäljarvägledning",
    'plesk_guide_client' => "Plesk kundvägledning",
    'plesk_guide_domain_admin' => "Plesk domänadministratörsguide",
    'plesk_guide_mailuser' => "Plesk e-post kundvägledning",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Sök', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Kunder',
    'ui__reseller_unknown__quick-search' => 'Återförsäljare',
    'ui__client/domain_unknown__quick-search' => 'Domäner',
    'nav__general' => 'Huvudmeny',
    '__home' => 'Hem',
    '__resellers' => 'Återförsäljare',
    '__clients' => 'Kunder',
    '__domains' => 'Domäner',
    '__applications' => 'Program',
    '__settings' => 'Inställningar',
    'nav__system' => 'System',
    '__master' => 'Huvud',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Upp nivå',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Ta bort',
    'bt_make_default' => 'Ange som standard',

    // common list object operation errors
    'class_cList__empty_selection' => 'inga objekt har valts.',

    // common list object search keys
    'clist__search_show' => 'Visa sökning',
    'clist__search_hide' => 'Dölj sökning',

    'bt_show_all' => "Återställ sökning",

    // common object list info keys
    'clist__first' => 'Första',
    'clist__last' => 'Sista',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Sidor',
    'clist__page_size' => 'Poster per sida',
    'clist__info' => 'Totalt %1: %4',
    'clist__info_empty' => 'Nr %1',
    'clist__info_filter' => '%5 %1 funna (%4 totalt)',
    'clist__info_paging' => '%2-%3 %1 av %4 totalt',
    'clist__info_paging_filter' => '%2-%3 %1 av %5 funna (%4 totalt)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktiva',
    '__object_off' => 'Avstängd',

    '__home_description' => 'Tillbaka till startsidan.',
    'indicator_title' => '%1% använt, %2% fritt', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Felaktig URL har begärts.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "ÅF-konton",
    'ui__reseller_unknown__title' => "ÅF-konton",
    'ui__reseller_unknown__description' => "Hantera återförsäljarkonton.",
    'ui__reseller/client_unknown__short-title' => 'Kund-konton',
    'ui__reseller/client_unknown__title' => 'Kund-konton',
    'ui__reseller/client_unknown__description' => 'Hantera kundkonton.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Tilldela ny ägare för kundkonton',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Tilldela ny ägare',
    'ui__reseller/client/chowner_multi-select__description' => 'Tilldela en ny ägare för valda kundkonton.',
    'ui__client/to-reseller_multi__title' => 'Omvandla kundkonton till återförsäljarkonton',
    'ui__client/to-reseller_multi__short-title' => 'Omvandla till återförsäljare',
    'ui__client/to-reseller_multi__description' => 'Omvandla valda kundkonton till återförsäljarkonton.',
    'ui__reseller/to-client_multi__title' => 'Omvandla återförsäljarkonton till kundkonton',
    'ui__reseller/to-client_multi__short-title' => 'Omvandla till kunder',
    'ui__reseller/to-client_multi__description' => 'Omvandla valda återförsäljarkonton till kundkonton',
    'ui__admin-alias_unknown__title' => "Extra administratörskonton", // PFW
    'ui__admin-alias_unknown__short-title' => "Extra administratörskonton", // PFW
    'ui__admin-alias_unknown__description' => "Visa och hantera extra administratörskonton.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "E-postinställningar",
    'ui__server/mail__title' => "E-postinställningar",
    'ui__server/mail__description' => "Ställ in din e-postserver och konfigurera serveromfattande e-postinställningar.",
    'ui__server/dns__short-title' => 'DNS-inställningar',
    'ui__server/dns__title' => 'DNS-inställningar',
    'ui__server/dns__description' => 'Gå igenom och uppdatera serveromfattande inställningar för DNS.',
    'ui__server/components__short-title' => 'Serverkomponenter',
    'ui__server/components__title' => 'Serverkomponenter',
    'ui__server/components__description' => 'Visa information om systemkomponenterna installerade på servern och som används i Plesk.',
    'ui__server/services__short-title' => 'Tjänstehantering',
    'ui__server/services__title' => 'Tjänstehantering',
    'ui__server/services__description' => 'Starta, stoppa eller starta om Plesk-tjänsterna.',
    'ui__server/db__short-title' => 'Databasservrar',
    'ui__server/db__title' => 'Databasservrar',
    'ui__server/db__description' => 'Visa och hantera serveromfattande databasservrar.',
    'ui__server/crontab/task_unknown__short-title' => 'Schemalagda aktiviteter',
    'ui__server/crontab/task_unknown__title' => 'Schemalagda aktiviteter',
    'ui__server/crontab/task_unknown__description' => 'Lägg till och ta bort serveromfattande schemalagda uppgifter.',
    'ui__server/ip-address_unknown__short-title' => 'IP-adresser',
    'ui__server/ip-address_unknown__title' => 'IP-adresser',
    'ui__server/ip-address_unknown__description' => 'Visa, lägg till och ta bort IP-adresser, tilldela IP-adresser till återförsäljare.',
    'ui__promotion/smartermail__short-title' => 'Ladda ner SmarterMail',
    'ui__promotion/smartermail__title' => 'Ladda ner SmarterMail',
    'ui__promotion/smartermail__description' => 'Öppna ett nytt fönster med SmarterMail-webbplatsen där du kan ladda ner den senaste versionen av SmarterMail postserver. SmarterMail-webbplatsen tillverkas och stöds av SmarterTools Inc. Plesk ansvarar inte för innehållet på SmarterMail-webbplatsen och ger heller inget stöd till SmarterMail Lite-postservern.',
    // dropdowns
    'ui__server/tsclient__short-title' => 'Fjärrskrivbord',
    'ui__server/tsclient__title' => 'Fjärrskrivbord',
    'ui__server/tsclient__description' => 'TIllgång till servern via fjärrskrivbord.',
    'ui__server/time__title' => 'Systemtid',
    'ui__server/time__short-title' => 'Systemtid',
    'ui__server/time__description' => 'Ändra systemdatum och -tid, ställ in synkronisering med en NTP-server.',
    'ui__server/odbc__title' => 'ODBC-datakällor', // PFW
    'ui__server/odbc__short-title' => 'ODBC-datakällor', // PFW
    'ui__server/odbc__description' => 'Konfigurera ODBC-datakällor.', // PFW
    'ui__server/ftp-settings__short-title' => "FTP-inställningar", // PFW
    'ui__server/ftp-settings__title' => "FTP-inställningar", // PFW
    'ui__server/ftp-settings__description' => "Konfigurera serveromfattande FTP-inställningar.", // PFW
    'ui__server/maillists__title' => 'Konfigurera server för e-postlistor', // PFU
    'ui__server/maillists__short-title' => 'Konfigurera server för e-postlistor', // PFU
    'ui__server/maillists__description' => 'Konfigurera Mailman e-postlisteservern.', // PFU
    'ui__mass-email__short-title' => "E-postmeddelanden för massutskick", // PFW
    'ui__mass-email__title' => "E-postmeddelanden för massutskick", // PFW
    'ui__mass-email__description' => "Skicka e-postmeddelanden till flera användare samtidigt.", // PFW
    'ui__mass-mail__title' => 'E-postmeddelanden för massutskick', // PFU
    'ui__mass-mail__short-title' => 'E-postmeddelanden för massutskick', // PFU
    'ui__mass-mail__description' => 'Skicka e-postmeddelanden till flera användare samtidigt.', // PFU
    'ui__server/spam-filter__title' => 'Skräppostfilterinställningar',
    'ui__server/spam-filter__short-title' => 'Skräppostfilterinställningar',
    'ui__server/spam-filter__description' => 'Konfigurera serveromfattande skräppostfilter.',
    'ui__server/preferences__title' => "Serverinställningar",
    'ui__server/preferences__short-title' => "Serverinställningar",
    'ui__server/preferences__description' => "Ställa in serveromfattande statistiska beräkningar, ändra serverns värddatornamn och ändra andra serverinställningar.",

    // interface
    // icons
    'ui__logo__short-title' => 'Plesk branding',
    'ui__logo__title' => 'Plesk branding',
    'ui__logo__description' => 'Branda om Plesk, ändra logotypbilden och titelraden i webbläsarens.',

    // help & support
    // icons
    'ui__support__short-title' => 'Stöd',
    'ui__support__title' => 'Stöd',
    'ui__support__description' => 'Skicka in en begäran om teknisk support eller revidera supportförfrågningar som görs av dina kunder.',
    'ui__license__short-title' => 'Licenshantering',
    'ui__license__title' => 'Licenshantering för Plesk',
    'ui__license__description' => 'Visa information om din Plesk-licens och beställ nya licensnycklar.',
    'ui__help__short-title' => 'Hjälp',
    'ui__help__title' => 'Direkthjälp',
    'ui__help__description' => 'Visa direkthjälp.',
    'ui__news__short-title' => "Senaste aktivitet",
    'ui__news__title' => "Senaste aktivitet",
    'ui__news__description' => "Se listan med ändringar i denna version av Plesk.",
    'ui__server/autoinstaller__short-title' => 'Uppdateringar',
    'ui__server/autoinstaller__title' => 'Uppdateringar',
    'ui__server/autoinstaller__description' => 'Uppdatera Plesk och dess komponenter.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domäner',
    'ui__client/domain_unknown__title' => 'Domäner',
    'ui__client/domain_unknown__description' => 'Hantera domäner.',
    'ui__server/skeleton__short-title' => 'Virtuell värdsservers innehåll',
    'ui__server/skeleton__title' => 'Virtuell värdsservers innehåll',
    'ui__server/skeleton__description' => 'Ange filer och mappar som ska placeras i kataloger i nyligen skapade domäner.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Skapa domän',
    'ui__client/domain/properties_unknown-new__short-title' => 'Skapa domän',
    'ui__client/domain/properties_unknown-new__description' => 'Skapa och konfigurera en domän.',
    'ui__client/domain/chowner_multi-select__title' => 'Tilldela ny ägare för abonnemang',
    'ui__client/domain/chowner_multi-select__short-title' => 'Tilldela ny abonnemangsägare',
    'ui__client/domain/chowner_multi-select__description' => 'Tilldela ny ägare för markerade abonnemang',
    'ui__client/domain/to-client_multi__title' => 'Omvandla valda domänadministratörkonton till kundkonton',
    'ui__client/domain/to-client_multi__short-title' => 'Omvandla till kunder',
    'ui__client/domain/to-client_multi__description' => 'Omvandla valda domänadministratörkonton till kundkonton.',
    'ui__client/domain/disable_multi__title' => 'Stäng av domäner',
    'ui__client/domain/disable_multi__short-title' => 'Stäng av domäner',
    'ui__client/domain/disable_multi__description' => 'Stäng av de valda domänerna.',
    'ui__client/domain/enable_multi__title' => 'Aktivera domäner',
    'ui__client/domain/enable_multi__short-title' => 'Aktivera domäner',
    'ui__client/domain/enable_multi__description' => 'Aktivera valda domäner',

    // icons
    'ui__admin/extras-domain__short-title' => 'Verktyg från MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Verktyg från MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'ASP.NET-inställningar', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET-inställningar', // PFW
    'ui__server/aspdotnet__description' => 'Konfigurera serveromfattande ASP.NET-inställningar.', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder-inställningar', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder-inställningar', // PFU
    'ui__server/sitebuilder__description' => 'Ställ in Presence Builder för att redigera webbplatser som är värdbaserade på denna server.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registrera domän',
    'ui__admin/register-domain__short-title' => 'Registrera domän',
    'ui__admin/register-domain__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Hantera domän',
    'ui__admin/manage-domain__short-title' => 'Hantera domän',
    'ui__admin/manage-domain__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',
    'ui__server/register__title' => 'Registrera din server',
    'ui__server/register__short-title' => 'Registrera server',
    'ui__server/register__description' => 'Registrera din server för att ansluta till ett partnerprogram',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Åtgärdslogg',
    'ui__actionlog__title' => 'Åtgärdslogg',
    'ui__actionlog__description' => 'Ladda ner åtgärdslogg och hantera åtgärdslogginställningar.',
    'ui__notification_unknown__short-title' => 'Meddelanden',
    'ui__notification_unknown__title' => 'Meddelanden',
    'ui__notification_unknown__description' => 'Visa och redigera meddelanden som skickas vid viktiga Plesk-händelser.',
    'ui__server/resources__short-title' => 'Resurs-användning',
    'ui__server/resources__title' => 'Resurs-användning',
    'ui__server/resources__description' => 'Visa systemresursanvändning.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Serverinformation',
    'ui__server/statistics__title' => 'Serverinformation',
    'ui__server/statistics__description' => 'Statistik om tjänsterna som hanteras av Plesk.',
    'ui__admin/report__title' => 'Sammanfattningsrapport',
    'ui__admin/report__short-title' => 'Sammanfattningsrapport',
    'ui__admin/report__description' => 'Visa rapport om användning av trafik och resurser för återförsäljare, kunder och domäner.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Sessionens inaktivitetstid',
    'ui__sessions/properties__title' => 'Sessionens inaktivitetstid',
    'ui__sessions/properties__description' => 'Ställ in sessionens inaktivitetstid för Plesk-sessioner.',
    'ui__cp-access__short-title' => 'Åtkomst till Plesk-tjänster',
    'ui__cp-access__title' => 'Åtkomst till Plesk-tjänster',
    'ui__cp-access__description' => 'Begränsa åtkomsten till Plesk.',
    'ui__sessions__short-title' => 'Aktiva sessioner',
    'ui__sessions__title' => 'Aktiva sessioner',
    'ui__sessions__description' => 'Visa aktiva Plesk-sessioner.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-certifikat',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-certifikat',
    'ui__server/certificate_unknown__description' => 'Lista över SSL/TLS-certifikat.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Personuppgifter',
    'ui__admin-info__title' => 'Personuppgifter',
    'ui__admin-info__description' => 'Ändra personuppgifter för ditt konto.',
    'ui__admin-password__short-title' => 'Ändra lösenord',
    'ui__admin-password__title' => 'Ändra lösenord',
    'ui__admin-password__description' => 'Ändra lösenord för ditt konto.',
    'ui__admin/interface__short-title' => 'Gränssnittsinställningar',
    'ui__admin/interface__title' => 'Gränssnittsinställningar administratör',
    'ui__admin/interface__description' => 'Ändra gränssnittsinställningar för serveradministratör.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Filhanteraren',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Filhanteraren',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Arbeta med filer och kataloger genom filhanteraren.',
    'ui__client/domain/hosting/tsclient_unknown__short-title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient_unknown__title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient_unknown__description' => 'TIllgång till servern via fjärrskrivbord.', // PFW
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Använd SSH-terminalen för tillgång till servern.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Skydda åtkomsten till valda webbplatsområden.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Skapa och hantera virtuella kataloger på en domän.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Arbeta med fysiska och virtuella filer och kataloger på en webbplats.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats_unknown__title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats_unknown__description' => 'Visa webbplatsens besöksstatistik.',
    'ui__reseller/limits__short-title' => 'Resurs-användning',
    'ui__reseller/limits__title' => 'Resurs-användning',
    'ui__reseller/limits__description' => 'Visa och hantera resursanvändningen för återförsäljaren %1.',
    'ui__reseller/limits_unknown__short-title' => 'Resurs-användning',
    'ui__reseller/limits_unknown__title' => 'Resurs-användning',
    'ui__reseller/limits_unknown__description' => 'Visa och hantera resursanvändningen för återförsäljaren.',
    'ui__reseller/limits_self__short-title' => 'Resurs-användning',
    'ui__reseller/limits_self__title' => 'Resurs-användning',
    'ui__reseller/limits_self__description' => "Visa och hantera din resursanvändning.",
    'ui__reseller/limits_readonly-self__short-title' => 'Resurs-användning',
    'ui__reseller/limits_readonly-self__title' => 'Resurs-användning',
    'ui__reseller/limits_readonly-self__description' => "Visa din resursanvändning.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Trafikanvändning av kunder',
    'ui__reseller/client/traffic_unknown__title' => 'Visa trafikanvändning av kunder',
    'ui__reseller/client/traffic_unknown__description' => 'Visa trafikanvändningsrapporter för kundkonton.',
    'ui__client/traffic_unknown__short-title' => "Trafikanvändning av kunder", // temporary for presets
    'ui__client/traffic_unknown__title' => "Visa trafikanvändning av kunder", // temporary for presets
    'ui__client/traffic_unknown__description' => "Visa trafikanvändningsrapporter för kundkonton.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs_unknown__title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs_unknown__description' => 'Visa loggar och konfigurera loggrotering.',
    // dropdowns
    'ui__reseller/report__title' => 'Sammanfattningsrapport',
    'ui__reseller/report__short-title' => 'Sammanfattningsrapport',
    'ui__reseller/report__description' => 'Visa rapport om användning av trafik och resurser för denna återförsäljare.',
    'ui__reseller/report_unknown__title' => 'Sammanfattningsrapport',
    'ui__reseller/report_unknown__short-title' => 'Sammanfattningsrapport',
    'ui__reseller/report_unknown__description' => 'Visa rapport om användning av trafik och resurser för återförsäljaren.',
    'ui__reseller/report_self__title' => 'Sammanfattningsrapport',
    'ui__reseller/report_self__short-title' => 'Sammanfattningsrapport',
    'ui__reseller/report_self__description' => 'Visa rapport om din användning av trafik och resurser.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk branding',
    'ui__client/logo_reseller__short-title' => 'Plesk branding',
    'ui__client/logo_reseller__description' => 'Branda om Plesk för återförsäljare %1.',
    'ui__client/logo_unknown__title' => 'Plesk branding', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk branding', // temporary for presets
    'ui__client/logo_unknown__description' => 'Branda om Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk branding',
    'ui__client/logo_self-reseller__short-title' => 'Plesk branding',
    'ui__client/logo_self-reseller__description' => 'Branda om din Plesk.',
    'ui__reseller/permissions__title' => 'Behörigheter',
    'ui__reseller/permissions__short-title' => 'Behörigheter',
    'ui__reseller/permissions__description' => "Visa eller ändra åtgärderna som återförsäljaren %1 kan utföra i Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Behörigheter',
    'ui__reseller/permissions_unknown__title' => 'Behörigheter',
    'ui__reseller/permissions_unknown__description' => "Visa eller ändra åtgärderna som kunden kan utföra i Plesk.",
    'ui__reseller/permissions_self__title' => 'Behörigheter',
    'ui__reseller/permissions_self__short-title' => 'Behörigheter',
    'ui__reseller/permissions_self__description' => 'Visa listan över åtgärder du kan utför i Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Behörigheter',
    'ui__reseller/permissions_readonly-self__short-title' => 'Behörigheter',
    'ui__reseller/permissions_readonly-self__description' => 'Visa listan över åtgärder du kan utför i Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Omvandla återförsäljarkonto till kundkonto',
    'ui__reseller/to-client__short-title' => 'Omvandla återförsäljare till kund',
    'ui__reseller/to-client__description' => 'Omvandla detta återförsäljarkonto till ett kundkonto.',
    'ui__reseller/to-client_unknown__title' => 'Omvandla återförsäljarkonto till kundkonto',
    'ui__reseller/to-client_unknown__short-title' => 'Omvandla återförsäljare till kund',
    'ui__reseller/to-client_unknown__description' => 'Omvandla återförsäljarkonto till ett kundkonto.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton__short-title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton__description' => 'Ange filer och mappar som ska placeras i kataloger i nyligen skapade domäner.',
    'ui__client/skeleton_unknown__short-title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton_unknown__title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton_unknown__description' => 'Ange filer och mappar som ska placeras i kataloger i nyligen skapade domäner.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Skapa domän',
    'ui__client/domain/properties_new__short-title' => 'Skapa domän',
    'ui__client/domain/properties_new__description' => "Skapa en domän för %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domänalias',
    'ui__client/domain/domain-alias_unknown__title' => 'Domänalias',
    'ui__client/domain/domain-alias_unknown__description' => 'Visa listan över alternativa namn för din domän.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-inställningar',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_unknown__description' => 'Hantera DNS-zoninställningar för en domän.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-unknown__description' => 'Visa DNS-zoninställningar för en domän.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Verktyg från MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc_unknown__title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Konfigurera ODBC-datakällor för en domän.', // PFW
    'ui__reseller/register-domain__short-title' => 'Registrera domän',
    'ui__reseller/register-domain__title' => 'Registrera domän',
    'ui__reseller/register-domain__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registrera domän',
    'ui__reseller/register-domain_unknown__title' => 'Registrera domän',
    'ui__reseller/register-domain_unknown__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registrera domän',
    'ui__reseller/register-domain_self__title' => 'Registrera domän',
    'ui__reseller/register-domain_self__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Hantera domän',
    'ui__reseller/manage-domain__short-title' => 'Hantera domän',
    'ui__reseller/manage-domain__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Hantera domän',
    'ui__reseller/manage-domain_unknown__short-title' => 'Hantera domän',
    'ui__reseller/manage-domain_unknown__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Hantera domän',
    'ui__reseller/manage-domain_self__short-title' => 'Hantera domän',
    'ui__reseller/manage-domain_self__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__description' => 'Hantera IP-adresser',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-certifikat',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-certifikat',
    'ui__client/domain/certificate_unknown__description' => 'Installera och hantera SSL/TLS-certifikat.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Skydda filerna mot hotlinking.', // PFW
    'ui__reseller/sessions__short-title' => 'Aktiva sessioner',
    'ui__reseller/sessions__title' => 'Aktiva sessioner',
    'ui__reseller/sessions__description' => 'Visa aktiva Plesk-sessioner.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktiva sessioner',
    'ui__reseller/sessions_unknown__title' => 'Aktiva sessioner',
    'ui__reseller/sessions_unknown__description' => 'Visa aktiva Plesk-sessioner.',
    'ui__reseller/sessions_self__short-title' => 'Aktiva sessioner',
    'ui__reseller/sessions_self__title' => 'Aktiva sessioner',
    'ui__reseller/sessions_self__description' => 'Visa aktiva Plesk-sessioner.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_unknown__title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_unknown__description' => 'Visa och justera  gränsen för bandbreddsanvändning och antal samtidiga anslutningar till en webbplats.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Visa gränsen för bandbreddsanvändning och antal samtidiga anslutningar till en webbplats.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Konfigurera PHP på en domän.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'E-postkonton under användarkonto %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton_self__title' => 'Virtuell värdsservers innehåll',
    'ui__client/skeleton_self__description' => 'Ange filer och mappar som ska placeras i kataloger i nyligen skapade domäner.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // Remote desktop - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Resurs-användning',
    'ui__client/limits__title' => 'Resurs-användning',
    'ui__client/limits__description' => "Visa och hantera resursanvändningen för kund %1.",
    'ui__client/limits_unknown__short-title' => 'Resurs-användning',
    'ui__client/limits_unknown__title' => 'Resurs-användning',
    'ui__client/limits_unknown__description' => 'Visa och hantera resursanvändningen för kunden.',
    'ui__client/limits_readonly__short-title' => 'Resurs-användning',
    'ui__client/limits_readonly__title' => 'Resurs-användning',
    'ui__client/limits_readonly__description' => 'Visa resursanvändning för kund %1.',
    'ui__client/limits_self__short-title' => 'Resurs-användning',
    'ui__client/limits_self__title' => 'Resurs-användning',
    'ui__client/limits_self__description' => "Visa och hantera din resursanvändning.",
    'ui__client/limits_readonly-self__short-title' => 'Resurs-användning',
    'ui__client/limits_readonly-self__title' => 'Resurs-användning',
    'ui__client/limits_readonly-self__description' => "Visa din resursanvändning.",
    'ui__client/domain/traffic_unknown__short-title' => "Trafikanvändning efter domäner %1",
    'ui__client/domain/traffic_unknown__title' => "Visa trafikanvändning efter domäner",
    'ui__client/domain/traffic_unknown__description' => "Visa trafikanvändningsrapporter för domäner.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Sammanfattningsrapport',
    'ui__client/report__short-title' => 'Sammanfattningsrapport',
    'ui__client/report__description' => 'Visa rapport om användning av trafik och resurser för denna kund.',
    'ui__client/report_unknown__short-title' => 'Sammanfattningsrapport',
    'ui__client/report_unknown__title' => 'Sammanfattningsrapport',
    'ui__client/report_unknown__description' => 'Visa rapport om användning av trafik och resurser för kunden.',
    'ui__client/report_self__short-title' => 'Sammanfattningsrapport',
    'ui__client/report_self__title' => 'Sammanfattningsrapport',
    'ui__client/report_self__description' => 'Visa rapport om användning av trafik och resurser.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Gränssnittsinställningar',
    'ui__client/preferences__title' => 'Gränssnittsinställningar',
    'ui__client/preferences__description' => 'Ställ in Plesk-gränssnittspreferenser för kund %1.',
    'ui__client/preferences_unknown__short-title' => 'Gränssnittsinställningar',
    'ui__client/preferences_unknown__title' => 'Gränssnittsinställningar',
    'ui__client/preferences_unknown__description' => "Ställ in gränssnittspreferenserna för kundens Plesk.",
    'ui__client/preferences_self__short-title' => 'Gränssnittsinställningar',
    'ui__client/preferences_self__title' => 'Gränssnittsinställningar',
    'ui__client/preferences_self__description' => 'Ställ in gränssnittsinställningar för din Plesk.',
    'ui__client/logo__title' => 'Plesk branding',
    'ui__client/logo__short-title' => 'Plesk branding',
    'ui__client/logo__description' => "Branda om Plesk på kund %1.",
    'ui__client/logo_self__title' => 'Plesk branding',
    'ui__client/logo_self__short-title' => 'Plesk branding',
    'ui__client/logo_self__description' => 'Branda om Plesk, ändra logotypbilden och titelraden i webbläsarens.',
    'ui__client/permissions__title' => 'Behörigheter',
    'ui__client/permissions__short-title' => 'Behörigheter',
    'ui__client/permissions__description' => "Visa eller ändra åtgärderna som kunden %1 kan utföra i Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Behörigheter',
    'ui__client/permissions_unknown__title' => 'Behörigheter',
    'ui__client/permissions_unknown__description' => "Visa eller ändra åtgärderna som kunden kan utföra i Plesk.",
    'ui__client/permissions_self__title' => 'Behörigheter',
    'ui__client/permissions_self__short-title' => 'Behörigheter',
    'ui__client/permissions_self__description' => "Visa listan över åtgärder du kan utför i Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Behörigheter',
    'ui__client/permissions_readonly-self__short-title' => 'Behörigheter',
    'ui__client/permissions_readonly-self__description' => "Visa listan över åtgärder du kan utför i Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Tilldela ny ägare för kundkontot',
    'ui__client/chowner_select__short-title' => 'Tilldela ny ägare för kunden',
    'ui__client/chowner_select__description' => 'Tilldela en ny ägare för detta kundkonto.',
    'ui__client/chowner_unknown-select__short-title' => 'Tilldela ny ägare för kundkontot',
    'ui__client/chowner_unknown-select__title' => 'Tilldela ny ägare för kunden',
    'ui__client/chowner_unknown-select__description' => 'Tilldela ny ägare för kundkontot.',
    'ui__client/to-reseller__title' => 'Omvandla kundkonto till återförsäljarkonto',
    'ui__client/to-reseller__short-title' => 'Omvandla kunden till återförsäljare',
    'ui__client/to-reseller__description' => 'Omvandla detta kundkonto till återförsäljarkonto.',
    'ui__client/to-reseller_unknown__title' => 'Omvandla kundkonto till återförsäljarkonto',
    'ui__client/to-reseller_unknown__short-title' => 'Omvandla kunden till återförsäljare',
    'ui__client/to-reseller_unknown__description' => 'Omvandla detta kundkonto till återförsäljarkonto.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain__title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Verktyg från MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registrera domän',
    'ui__client/register-domain__short-title' => 'Registrera domän',
    'ui__client/register-domain__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registrera domän',
    'ui__client/register-domain_unknown__short-title' => 'Registrera domän',
    'ui__client/register-domain_unknown__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registrera domän',
    'ui__client/register-domain_self__short-title' => 'Registrera domän',
    'ui__client/register-domain_self__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Hantera domän',
    'ui__client/manage-domain__short-title' => 'Hantera domän',
    'ui__client/manage-domain__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Hantera domän',
    'ui__client/manage-domain_unknown__short-title' => 'Hantera domän',
    'ui__client/manage-domain_unknown__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Hantera domän',
    'ui__client/manage-domain_self__short-title' => 'Hantera domän',
    'ui__client/manage-domain_self__description' => 'Hantera registrerade domännamn genom MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown__short-title' => "IP-adresser",
    'ui__client/ipaddress_unknown__description' => "Hantera IP-adresser",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domänalias',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domänalias',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Visa listan över alternativa namn för din domän.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Aktiva sessioner',
    'ui__client/sessions__title' => 'Aktiva sessioner',
    'ui__client/sessions__description' => 'Visa aktiva Plesk-sessioner.',
    'ui__client/sessions_unknown__short-title' => 'Aktiva sessioner',
    'ui__client/sessions_unknown__title' => 'Aktiva sessioner',
    'ui__client/sessions_unknown__description' => 'Visa aktiva Plesk-sessioner.',
    'ui__client/sessions_self__short-title' => 'Aktiva sessioner',
    'ui__client/sessions_self__title' => 'Aktiva sessioner',
    'ui__client/sessions_self__description' => 'Visa aktiva Plesk-sessioner.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Filhanteraren',
    'ui__client/domain/hosting/file-manager__title' => 'Hantera filer på domän %1',
    'ui__client/domain/hosting/file-manager__description' => "Arbeta med filer och kataloger på domän %1 genom filhanteraren.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Filhanteraren',
    'ui__client/domain/hosting/file-manager_self__title' => 'Filhanteraren',
    'ui__client/domain/hosting/file-manager_self__description' => "Arbeta med dina filer och kataloger genom filhanteraren.",
    'ui__client/domain/hosting/tsclient__short-title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient__title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient__description' => 'TIllgång till servern via fjärrskrivbord.', // PFW
    'ui__client/domain/hosting/tsclient_self__short-title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient_self__title' => 'Fjärrskrivbord', // PFW
    'ui__client/domain/hosting/tsclient_self__description' => 'TIllgång till servern via fjärrskrivbord.', // PFW
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Använd SSH-terminalen för tillgång till servern.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'SSH-terminal', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Använd SSH-terminalen för tillgång till servern.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories__title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories__description' => 'Skydda åtkomsten till valda webbplatsområden.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Lösenordsskyddade kataloger',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Skydda åtkomsten till valda webbplatsområden.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Skapa och hantera virtuella kataloger på domän %1.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Skapa och hantera virtuella kataloger på din domän.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Arbeta med fysiska och virtuella filer och kataloger på webbplatsen %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuella kataloger', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Arbeta med fysiska och virtuella filer och kataloger på din webbplats.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats__title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats__description' => 'Visa webbplatsens besöksstatistik.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats_self__title' => 'Webbstatistik',
    'ui__client/domain/report/web-stats_self__description' => 'Visa webbplatsens besöksstatistik.',
    'ui__client/domain/traffic__short-title' => '%1 trafikanvändning',
    'ui__client/domain/traffic__title' => 'Dataöverföringsstatistik för domän %1',
    'ui__client/domain/traffic__description' => 'Visa dataöverföringsstatistik för domänen %1.',
    'ui__client/domain/traffic_self__short-title' => 'Trafikanvändning',
    'ui__client/domain/traffic_self__title' => 'Visa trafikanvändning för din domän.',
    'ui__client/domain/traffic_self__description' => 'Visa trafikanvändningsrapport för din domän.',
    'ui__client/domain/hosting/logs__short-title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs__title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs__description' => 'Visa loggar och konfigurera loggrotering.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs_self__title' => 'Log Hanterare',
    'ui__client/domain/hosting/logs_self__description' => 'Visa loggar och konfigurera loggrotering.',
    // dropdowns
    'ui__client/domain/report__title' => 'Sammanfattningsrapport',
    'ui__client/domain/report__short-title' => 'Sammanfattningsrapport',
    'ui__client/domain/report__description' =>  'Visa rapport om användning av trafik och resurser.',
    'ui__client/domain/report_unknown__short-title' => 'Sammanfattningsrapport',
    'ui__client/domain/report_unknown__title' => 'Sammanfattningsrapport',
    'ui__client/domain/report_unknown__description' => 'Visa rapport om användning av trafik och resurser.',
    'ui__client/domain/report_self__short-title' => 'Sammanfattningsrapport',
    'ui__client/domain/report_self__title' => 'Sammanfattningsrapport',
    'ui__client/domain/report_self__description' => 'Visa rapport om användning av trafik och resurser.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Personuppgifter',
    'ui__client/domain/properties__title' => 'Personuppgifter',
    'ui__client/domain/properties__description' => 'Ändra personliga data för domänens administratörskonto.',
    'ui__client/domain/properties_unknown__short-title' => 'Personuppgifter',
    'ui__client/domain/properties_unknown__title' => 'Personuppgifter',
    'ui__client/domain/properties_unknown__description' => 'Ändra personliga data för kontot.',
    'ui__client/domain/properties_self__short-title' => 'Personuppgifter',
    'ui__client/domain/properties_self__title' => 'Personuppgifter',
    'ui__client/domain/properties_self__description' => 'Ändra personuppgifter för ditt konto.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Byt namn på domän',
    'ui__client/domain/rename__short-title' => 'Byt namn på domän',
    'ui__client/domain/rename__description' => 'Byt namn på domänen %1',
    'ui__client/domain/rename_unknown__short-title' => 'Byt namn på domän',
    'ui__client/domain/rename_unknown__title' => 'Byt namn på domän',
    'ui__client/domain/rename_unknown__description' => 'Byt namn på en domän',
    'ui__client/domain/chowner_select__title' => 'Tilldela ny ägare för domän',
    'ui__client/domain/chowner_select__short-title' => 'Tilldela ny ägare för abonnemang',
    'ui__client/domain/chowner_select__description' => 'Tilldela ny ägare till abonnemanget',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Tilldela ny ägare för abonnemang',
    'ui__client/domain/chowner_unknown-select__title' => 'Tilldela ny ägare för abonnemang',
    'ui__client/domain/chowner_unknown-select__description' => 'Tilldela ny ägare till ett abonnemang.',
    'ui__client/domain/to-client__title' => 'Omvandla domänadministratörkonton till kundkonto',
    'ui__client/domain/to-client__short-title' => 'Omvandla domänadministratören till kund',
    'ui__client/domain/to-client__description' => 'Omvandla detta domänadministratörkonto till ett kundkonto',
    'ui__client/domain/to-client_unknown__short-title' => 'Omvandla domänadministratören till kund',
    'ui__client/domain/to-client_unknown__title' => 'Omvandla domänadministratörkonton till kundkonto',
    'ui__client/domain/to-client_unknown__description' => 'Omvandla domänens administratörkonton till ett kundkonto',
    'ui__client/domain/toggle__title' => 'Stäng av eller aktivera domän.', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Stäng av eller aktivera domän.', // for HP customization
    'ui__client/domain/toggle__description' => 'Stäng av eller aktivera domän %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Stäng av eller aktivera domän.', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Stäng av eller aktivera domän.', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Stäng av eller aktivera en domän.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktivera domän',
    'ui__client/domain/toggle_enable__short-title' => 'Aktivera domän',
    'ui__client/domain/toggle_enable__description' => 'Aktivera domän %1.',
    'ui__client/domain/toggle_disable__title' => 'Stäng av domän',
    'ui__client/domain/toggle_disable__short-title' => 'Stäng av domän',
    'ui__client/domain/toggle_disable__description' => 'Avbryt domänen %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-inställningar',
    'ui__client/domain/dns__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns__description' => 'Hantera DNS-zoninställningar för domän %1.',
    'ui__client/domain/dns_self__title' => 'DNS-inställningar',
    'ui__client/domain/dns_self__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_self__description' => 'Hantera DNS-zoninställningar för din domän.',
    'ui__client/domain/dns_disabled__title' => 'DNS-inställningar',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_disabled__description' => 'Hantera DNS-zoninställningar för domän %1.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-inställningar',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_self-disabled__description' => 'Hantera DNS-zoninställningar för din domän.',
    'ui__client/domain/dns_readonly__title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly__description' => 'Visa DNS-zoninställningar för domän %1.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self__description' => 'Visa DNS-zoninställningar för din domän.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Visa DNS-zoninställningar för din domän.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Visa DNS-zoninställningar för din domän.',
    'ui__client/domain/dns_slave__title' => 'DNS-inställningar',
    'ui__client/domain/dns_slave__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_slave__description' => 'Hantera DNS-zoninställningar för domän %1.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-inställningar',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-inställningar',
    'ui__client/domain/dns_self-slave__description' => 'Hantera DNS-zoninställningar för din domän.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras__title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Verktyg från MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Hämta ytterligare verktyg och tjänster från MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc__title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc__description' => 'Konfigurera ODBC-datakällor för domän %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc_self__title' => 'ODBC-datakällor', // PFW
    'ui__client/domain/odbc_self__description' => 'Konfigurera ODBC-datakällor för din domän.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registrera domän',
    'ui__client/domain/register__title' => 'Registrera domän',
    'ui__client/domain/register__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registrera domän',
    'ui__client/domain/register_unknown__title' => 'Registrera domän',
    'ui__client/domain/register_unknown__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registrera domän',
    'ui__client/domain/register_self__title' => 'Registrera domän',
    'ui__client/domain/register_self__description' => 'Registrera ett domännamn genom MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Skydda filer på domän %1 från hotlinking.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Hotlink skydd', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Skydda dina filer mot hotlinking.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance__title' => 'Gräns för bandbreddsanvändning och antalet tillåtna anslutningar till din webbplats.',
    'ui__client/domain/hosting/performance__description' => 'Visa och justera gränsen för bandbreddsanvändning för domän %1 och antalet samtidiga anslutningar till den.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_readonly__title' => 'Gränser för bandbreddsanvändning och antalet tillåtna anslutningar till din webbplats.',
    'ui__client/domain/hosting/performance_readonly__description' => 'Visa gränsen för bandbreddsanvändning för domän %1 och antalet samtidiga anslutningar till den.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_self__title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_self__description' => 'Visa och justera gränsen för bandbreddsanvändning för din domän och antalet samtidiga anslutningar till den.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Bandbreddsbegränsning',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Visa gränsen för bandbreddsanvändning för din domän och antalet samtidiga anslutningar till den.',
    'ui__client/domain/hosting/php__short-title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php__title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php__description' => 'Konfigurera PHP på domän %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php_self__title' => 'PHP-inställningar', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Konfigurera PHP på din domän.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'Du måste välja de kundkonton du vill omvandla till återförsäljarkonton',
    'ui__client/chowner__empty_selection' => 'Du behöver välja de kundkonton du vill tilldela till en ny ägare',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Verktyg",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Visa statistik',
    'ui__client/domain-summary-report_unknown__title' => 'Visa statistik',
    'ui__client/domain-summary-report_unknown__description' => 'Visa information om resursanvändning av domäner.',
    'ui__client/domain-summary-report__short-title' => "Visa statistik",
    'ui__client/domain-summary-report__title' => "Visa statistik",
    'ui__client/domain-summary-report__description' => "Visa information om resursanvändning av domäner.",
    'ui__client/domain-summary-report_self__short-title' => "Visa statistik",
    'ui__client/domain-summary-report_self__title' => "Visa statistik",
    'ui__client/domain-summary-report_self__description' => "Visa information om resursanvändning av dina domäner.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domäner", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Kontrollera behörigheter',
    'ui__client/domain/check-permissions_multi__title' => 'Behörighetskontroll',
    'ui__client/domain/check-permissions_multi__description' => 'Kontrollera filens och mappens åtkomsttillstånd i en domän. Om fel påträffas, kommer de att korrigeras automatiskt.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Du måste välja domänerna som du vill ta bort',
    'ui__client/domain/properties__empty_selection' => 'Du måste välja domänerna som du vill modifiera',
    'ui__client/domain/chowner__empty_selection' => 'Du måste markera domänerna som du vill tilldela en ny ägare',
    'ui__client/domain/check-permissions__empty_selection' => 'Du måste markera domänerna vars fil- och mappbehörigheter du vill kontrollera',
    'ui__client/domain/to-client__empty_selection' => 'Du behöver välja domäner vars administratörskonton du vill omvandla till kundkonton',

    // list objects filtering
    'domains_list__name__filter_title' => 'Namn',
    'domains_list__state__filter_title' => 'Resurs-användning',
    'domains_list__filter_state_any' => 'Valfri',
    'domains_list__filter_state_overuse' => 'Överanvändning',
    'domains_list__filter_state_normal' => 'Inom gränserna',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Valfri',
    'domains_list__filter_status_blocked' => 'Avstängd',
    'domains_list__filter_status_active' => 'Aktiva',
    'domains_list__ownership__filter_title' => 'Ägarskap',
    'domains_list__filter_ownership_all' => 'Alla domäner',
    'domains_list__filter_ownership_personal' => 'Endast mina domäner',
    'domains_list__filter_owner_pname__filter_title' => 'Ägarens namn',
    'domains_list__subrows__filter_title' => 'Visa',
    'domains_list__subrows_off' => 'Domäner endast',
    'domains_list__subrows_subdomain_domainaliases' => 'Med subdomäner och alias',
    'domains_list__subrows_subdomain' => 'Med subdomäner',
    'domains_list__subrows_domainaliases' => 'Med alias',

    // objects list
    'domains_list__owner__title' => 'Ägare',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Bläddra efter program",
    'site_apps__promo_main_text' => "Programpaketets standardkatalog (APS) innehåller en förteckning över program som kan tillhandahållas till en domän eller ett webbutrymme. Om du vill tillhandahålla program som just nu inte finns i katalogen, kan du lätt göra det genom följande APS-förpackningssinstruktioner på www.apsstandard.com",
    'site_apps__promo_download_now' => "Ladda ner program:",
    'site_apps__promo_close' => "Stäng detta block",
    'site_apps__promo_preset__mostused' => '%1 Populärast',
    'site_apps__promo_preset__lessused' => '%1:e näst populärast',
    'site_apps__promo_preset__all' => "Alla",
    'site_apps__promo_disclaimer_note' => 'Observera att program som installeras från APS-katalogen tillhandahålls av tredje part och stöds inte av Plesk.',
    'site_apps__promo_preset__page_title' => '%1 APS-program',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Lägger till program...',

    // Errors
    'site_apps__no_applications_for_update' => 'Du har inga applikationer installerade i applikationsvalvet.',
    'site_apps__incorrect_download_preset_configuration' => 'Fel hittades i konfigurationen av förinställningen av APS-katalognedladdningen.',
    'site_apps__aps_catalog_url_is_invalid' => 'Angiven URL är ogiltig.',
    'site_apps__no_updates_at_the_moment' => 'Det finns inga programuppdateringar tillgängliga just nu.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Felaktig information har mottagits från APS-programkatalogen. Var god försök igen senare.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS-kataloginställningarna har sparats, men Plesk kunde inte upprätta en anslutning till APS-katalogen som anges i APS-kataloginställningarna (%1). Se till att APS-katalogadressen är korrekt och att APS-katalogen på denna adress är aktiv.',
    'site_apps__cannot_retrieve_updates' => 'Kan inte ladda ner programuppdateringar just nu: kan inte upprätta anslutning till APS-katalogen (%1). Se till att APS-katalogadressen är korrekt och att APS-katalogen på denna adress är aktiv.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Det finns inga webbprogram tillgängliga för installation.',
    'site_apps__site_applications_already_installed_in_root' => 'Andra webbprogram har redan installerats i rotkatalogerna i dessa virtuella värddatorer',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET-webbapplikationerna stöds inte på Unix-Linux-plattformen",
    'site_apps__server_wide_packages_not_supported' => 'Serveromfattande webbapplikatinoer stöds inte',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 mer webbprogram är schemalagda för tillägg i applikationsvalvet.",
    'site_apps__applications_all_in_vault' => "Valda webbprogram finns redan i applikationsvalvet.",
    'site_apps__applications_already_in_download_queue' => "%1 valda webbapplikationer läggs till i applikationsvalvet just nu.",
    'site_apps__applications_already_in_valut' => "%1 valda webbprogram finns redan i applikationsvalvet.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Annat (ej kategoriserat)',

    // Errors
    'site_apps__no_applications_in_category' => 'Det finns inga tillgängliga applikationer i denna kategori. Välj en annan kategori.',
    'site_apps__no_category_selected__please_specify' => 'Välj en kategori i vänster meny. Alla applikationer som är tillgängliga i den valda kategorin kommer att listas i detta fönster.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Administratörskonto',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Allmänt',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Ändra värddatornamn',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Säkerhet',
    'bt_setup_firewall' => 'Konfigurera brandvägg',
    'bt_manage_firewall_rules' => 'Hantera brandväggsregeln',
    'cu_firewall__rule' => 'Skapa en brandväggsregel',
    'cu_firewall__protocol' => 'Ställ in ett protokoll för regeln (\'TCP\' eller \'UDP\')',
    'cu_firewall__name' => "Ange ett regelnamn",
    'cu_firewall__disabled' => 'Om \'true\', inaktiveras regeln efter skapande',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Markera DNS-server', // PFW
    'bt_soa_records_template' => 'SOA-datamall',
    'bt_restrict_creation_of_subzones' => 'Begränsa skapande av subzoner',

    'databases' => 'DatabaVisar',
    'bt_select_mssqlwebadmin' => 'Välj MS SQL Webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Applikationer',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-post',
    'bt_select_mailserver' => 'Markera e.postserver', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Välj antivirus', // PFW
    'bt_virus_protection_settings' => 'Inställningar för visursskydd',
    'bt_select_spamfilter' => 'Välj skräppostfilter', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Välj webbmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Loggar & statistik',
    'bt_server_statistics_settings' => 'Inställningar för serverstatistik',
    'bt_select_web_statistics' => 'Tillgänglig webbstatistikmjukvara', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk gränssnitt',

    'components_and_modules' => 'Komponenter & moduler',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Konfigurera Watchdog', // PFU
    'bt_setup_vpn' => 'Ställ in VPN', // PFU
    'bt_setup_samba' => 'Konfigurera Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Inställningar',
    'ui__client/domain/settings_self__short-title' => 'Inställningar',
    'ui__client/domain/settings_self__description' => 'Visa och ändra domäninställningar.',

    'domain_administrator_account' => 'Domänens administratörskonto',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Kontoinställningar',

    'domain' => 'Domän',
    'bt_dns_soa_records' => 'DNS SOA-poster',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Schemaläggarens inställningar',

    'website' => 'Webbsida',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting för webbanvändare',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Välj SSL/TLS-certifikat',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webbstatistik',
    'bt_log_rotation_settings' => 'Inställningar för loggrotering',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Gränser", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Överanvändnings- och överförsäljningspolicy",
    'limits__overuse_policy_legend' => "Överanvändning",
    'limits__oversell_policy_legend' => "Överförsäljning",
    'limits__reseller_overuse_description' => "Överanvändningspolicyn säger åt Plesk vad det ska göra när resurser överanvänds.",
    'limits__overuse_text' => "Överanvändningspolicy",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Diskutrymme och trafik',
    'limit__disk_space' => 'Utrymme',
    'limit__max_traffic' => 'Trafik',
    'limit_group__client' => 'Kunder',
    'limit__max_cl' => 'Kunder',
    'limit_group__domain' => 'Domäner',
    'limit__max_dom' => 'Domäner',
    'limit__max_dom_powerUser' => 'Abonnemanger',
    'limit__max_subdom' => 'Subdomäner',
    'limit__max_dom_aliases' => 'Domänalias',
    'limit__max_wu' => 'Webbanvändare',
    'limit__max_subftp_users' => 'Extra FTP-konton', // PFW
    'limit_group__mail' => 'E-post',
    'limit__max_box' => 'E-postlådor',
    'limit__mbox_quota' => 'Storlek på postlåda',
    'limit__total_mboxes_quota' => 'Total e-postkontokvot', // PFW
    'limit__max_maillists' => 'E-postlistor',
    'limit_group__database' => 'DatabaVisar',
    'limit__max_mssql_db' => 'Microsoft SQL Server-databas', // PFW
    'limit__mssql_dbase_space' => 'Totalt MS SQL databasvärde', // PFW
    'limit__max_odbc' => 'ODBC-anslutningar', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL-databaskvot', // PFW?
    'limit_group__application' => 'Program',
    'limit__max_iis_app_pools' => 'IIS-programpooler', // PFW
    'limit_group__security' => 'Säkerhet',
    'limit_group__validity' => 'Utgångsdatum',
    'limit__expiration' => 'Utgångsdatum',
    'limit__validity' => 'Giltighetsperiod',
    'limit__max_site_builder' => 'Webbplatser publicerade med Presence Builder',
    'limit__max_site' => 'Domäner',
    'limit__mssql_dbase_filesize' => 'MS SQL databasfilens storlek',
    'limit__mssql_dbase_log_filesize' => 'MS SQL databasloggfilens storlek',
    'limit__mssql_dbase_filesize_hint' => 'Den maximala storleken för en fil i en Microsoft SQL-databas.',
    'limit__mssql_dbase_log_filesize_hint' => 'Den maximala storleken för en loggfil i en Microsoft SQL-databas.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Ogiltig domängräns. Minimivärde är 1.',

    'property__has_wrong_value' => 'Egenskapen %1  har ett felaktigt värde.',
    'property__name_outgoing_messages_domain_limit' => 'Anger gränsen på utgående meddelanden från ett domän (per timme). För att ange ett obegränsat värde, uppge "-1". Uppge "default" för att ange värdet specificerad i serveromfattande inställningar.',
    'property__name_outgoing_messages_mbox_limit' => 'Anger gränsen på utgående meddelanden från en postlåda (per timme). För att ange ett obegränsat värde, uppge "-1". Uppge "default" för att ange värdet specificerad i serveromfattande inställningar.',
    'property__name_outgoing_messages_subscription_limit' => 'Anger gränsen på utgående meddelanden från ett abonnemang (per timme). För att ange ett obegränsat värde, uppge "-1". Uppge "default" för att ange värdet specificerad i serveromfattande inställningar.',

    // for CLI report & email notifications
    '__resource_notify' => 'Meddela',
    '__general' => 'Allmänt',
    '__template_shared' => 'Delad mall',
    'limit__overuse' => 'Överanvändningspolicy',
    'limit__max_traffic_soft' => 'Meddela när trafikanvändningen når',
    'limit__disk_space_soft' => 'Meddela när användning av diskutrymme når',
    '__overuse' => 'Överanvändningspolicy',
    'performance__title' => 'Uppträdande',
    'performance__bandwidth' => 'Maximal bandbreddsanvändning (kB/s)',
    'performance__max_connections' => 'Begränsa anslutningar till',

    'gch__hosting_php_isapi' => 'Kör PHP som ett ISAPI-filnamnstillägg',
    'gch__hosting_ssi_html' => 'Använd SSI för *.htm- och *.html-filer',
    'gch__hosting_php_handler_type' => 'Kör PHP som',
    'gch__hosting_php_handler_id' => 'Kör PHP som',
    'gch__hosting_php_served_by_nginx' => 'PHP som servas av ngnix',
    'gch__hosting_unpaid_website_status' => 'Status för webbplatserna i abonnemang som upphävts tillfälligt',
    'gch__mn_no_autoresponder' => 'Det finns inga automatsvar inställda för e-postkontot.',
    'gch__no_clients_selected' => "Inga kundkonton har valts",
    'gch__no_domains_selected' => "Inga domäner utangiven",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/månad",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Resursnamn',
    '__resource_usage' => 'Används',
    '__resource_limit' => 'Gräns',

    '__used' => 'Används',
    '__limit' => 'Gräns',

    '__never_expires' => 'Upphör aldrig att gälla',
    '__resource_free' => '%1 ledigt av %2',
    '__resource_unlimited' => '%1 används av obegränsat',

    '__value' => 'Värde',
    '__unlimited' => 'Obegränsat',
    '__increment' => "Öka (+)",
    '__decrement' => "Minska (-)",
    '__pt' => 'enheter',
    '__procent' => '%',
    '__overused' => 'Överanvänd',
    '__left' => 'vänster',
    '__available' => 'tillgängliga',
    '__not_available' => 'Ej inkluderat',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Visa trafikhistorik',
    'ui__admin/report/traffic-history__title' => 'Visa trafikhistorik',
    'ui__admin/report/traffic-history__description' => 'Visa trafikhistorik för återförsäljare, kunder och domäner.',
    'admin_traffic_history__title' => 'Trafikhistorik',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Leveransschema',
    'ui__admin/report/layout/auto_unknown__title' => 'Rapportleveransschema.',
    'ui__admin/report/layout/auto_unknown__description' => 'Välj rapportleveransschema för en rapportlayout.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Lägg till rapportleveransegenskaper',
    'ui__admin/report/layout/auto/properties_new__title' => 'Lägg till rapportleveransegenskaper',
    'ui__admin/report/layout/auto/properties_new__description' => 'Lägg till ett rapportleveransschema för rapporten %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Rapportleveransschema.',
    'ui__admin/report/layout/auto/properties__title' => 'Rapportleveransschema.',
    'ui__admin/report/layout/auto/properties__description' => 'Visa och modifiera egenskaper för rapportleveransschema.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Ta bort rapportleveransegenskaper',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Ta bort rapportleveransegenskaper',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Ta bort markerade rapportleveransscheman.',

    'ui__admin/report/layout_unknown__short-title' => 'Rapportlayouter',
    'ui__admin/report/layout_unknown__title' => 'Rapportlayouter',
    'ui__admin/report/layout_unknown__description' => 'Visa och hantera rapportlayouter.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Skapa rapportlayout',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Skapa rapportlayout',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Skapa en rapportlayout.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Ta bort rapportlayouter',
    'ui__admin/report/layout/delete_multi__title' => 'Ta bort rapportlayouter',
    'ui__admin/report/layout/delete_multi__description' => 'Ta bort valda rapportlayouter',
    'ui__admin/report/layout/properties__short-title' => 'Egenskaper',
    'ui__admin/report/layout/properties__title' => 'Redigera egenskaper för layout',
    'ui__admin/report/layout/properties__description' => 'Redigera egenskaper för rapportlayout.',

    // reseller
    'reseller_traffic_history__title' => "Trafikhistorik för återförsäljaren %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Visa trafikanvändningen för återförsäljare %1.',
    'ui__reseller/traffic__description' => 'Visa trafikanvändningsrapporter för återförsäljarkontot %1.',
    'ui__reseller/traffic_self__short-title' => 'Min',
    'ui__reseller/traffic_self__title' => 'Visa trafikanvändning av kunder',
    'ui__reseller/traffic_self__description' => 'Visa trafikanvändningsrapporter för dina kundkonton.',

    'ui__reseller/report/traffic-history__short-title' => 'Visa trafikhistorik',
    'ui__reseller/report/traffic-history__title' => 'Visa trafikhistorik',
    'ui__reseller/report/traffic-history__description' => "Visa trafikhistoriken för återförsäljaren %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Visa trafikhistorik',
    'ui__reseller/report/traffic-history_self__title' => 'Visa trafikhistorik',
    'ui__reseller/report/traffic-history_self__description' => 'Visa din trafikhistorik.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Leveransschema',
    'ui__reseller/report/layout/auto_unknown__title' => 'Rapportleveransschema.',
    'ui__reseller/report/layout/auto_unknown__description' => 'Välj rapportleveransschema för en rapportlayout.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Lägg till rapportleveransegenskaper',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Lägg till rapportleveransegenskaper',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Lägg till ett rapportleveransschema för rapporten %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Rapportleveransschema.',
    'ui__reseller/report/layout/auto/properties__title' => 'Rapportleveransschema.',
    'ui__reseller/report/layout/auto/properties__description' => 'Visa och modifiera egenskaper för rapportleveransschema.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Ta bort rapportleveransegenskaper',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Ta bort rapportleveransegenskaper',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Ta bort markerade rapportleveransscheman.',

    'ui__reseller/report/layout_unknown__short-title' => 'Rapportlayouter',
    'ui__reseller/report/layout_unknown__title' => 'Rapportlayouter',
    'ui__reseller/report/layout_unknown__description' => 'Visa och hantera rapportlayouter.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Skapa rapportlayout',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Skapa rapportlayout',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Skapa en rapportlayout.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Skapa rapportlayout',
    'ui__reseller/report/layout/properties_new__title' => 'Skapa rapportlayout',
    'ui__reseller/report/layout/properties_new__description' => 'Skapa en rapportlayout.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Ta bort rapportlayouter',
    'ui__reseller/report/layout/delete_multi__title' => 'Ta bort rapportlayouter',
    'ui__reseller/report/layout/delete_multi__description' => 'Ta bort valda rapportlayouter',
    'ui__reseller/report/layout/properties__short-title' => 'Egenskaper',
    'ui__reseller/report/layout/properties__title' => 'Redigera egenskaper för layout',
    'ui__reseller/report/layout/properties__description' => 'Redigera egenskaper för rapportlayout.',

    // customer
    'cl_traffic_history__title' => "Trafikhistorik för kunden %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Visa trafikanvändningen för kund %1.',
    'ui__client/traffic__description' => 'Visa trafikanvändningsrapporter för kundkonto %1.',
    'ui__client/traffic_self__short-title' => 'Trafikanvändning',
    'ui__client/traffic_self__title' => 'Trafikanvändning efter domäner',
    'ui__client/traffic_self__description' => 'Visa trafikanvändningsrapporter för dina domäner.',

    'ui__client/report/traffic-history__short-title' => 'Visa trafikhistorik',
    'ui__client/report/traffic-history__title' => 'Visa trafikhistorik',
    'ui__client/report/traffic-history__description' => 'Visa trafikhistoriken för kund %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Visa trafikhistorik',
    'ui__client/report/traffic-history_self__title' => 'Visa trafikhistorik',
    'ui__client/report/traffic-history_self__description' => 'Visa din trafikhistorik.',



    // domain
    'dom_traffic_history__title' => "Trafikhistorik för domän %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Visa trafikhistorik',
    'ui__client/domain/report/traffic-history__title' =>  'Visa trafikhistorik',
    'ui__client/domain/report/traffic-history__description' => 'Visa trafikhistorik för domän %1.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Visa trafikhistorik',
    'ui__client/domain/report/traffic-history_self__title' =>  'Visa trafikhistorik',
    'ui__client/domain/report/traffic-history_self__description' => 'Visa trafikhistorik för din domän.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Statistik om säkra sitebesök',
    'ui__client/domain/report/web-stats-ssl__title' => 'Statistik om säkra besök på siten %1.',
    'ui__client/domain/report/web-stats-ssl__description' => 'Statistik om säkra besök på siten %1.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'Webbstatistik SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Statistik om säkra besök på din site',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Statistik om säkra besök på din site.',
    'ui__client/domain/report/ftp-stats__short-title' => 'FTP-statistik',
    'ui__client/domain/report/ftp-stats__title' => 'FTP-statistik för domän %1',
    'ui__client/domain/report/ftp-stats__description' => 'FTP-statistik för domän %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'FTP-statistik',
    'ui__client/domain/report/ftp-stats_self__title' => 'FTP-statistik för din domän',
    'ui__client/domain/report/ftp-stats_self__description' => 'FTP-statistik för din domän.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Anonym FTP-statistik',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Anonym FTP-statistik för domän %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Anonym FTP-statistik för domän %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Anonym FTP-statistik',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Anonym FTP-statistik för domän %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Anonym FTP-statistik för domän %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Webalizer-inställningar',
    'ui__client/domain/report/webalizer-preferences__title' => 'Webalizer-inställningar för %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Justera presentationen av statistiska rapporter av Webalizer för %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Webalizer-inställningar',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Webalizer-inställningar för %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Justera presentationen av statistiska rapporter av Webalizer för %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Återförsäljarens namn', // reseller report
    'report__full_client_name' => 'Kundens namn', // customer report
    'report__full_domain_name' => 'Domännamn', // domain report
    'report__full_owner' => 'Ägare', // customer & domain reports
    'report__full_creation_date' => 'Skapandedatum',
    'report__full_size' => 'Storlek',
    'report__full_traffic' => 'Trafik',
    'report__full_active_clients' => 'Aktiva kunder', // reseller report
    'report__full_clients' => 'Kunder', // reseller report
    'report__full_active_domains' => 'Aktiva domäner', // reseller & customer reports
    'report__full_domains' => 'Domäner', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'MBoxes',
    'report__full_disk_space' => 'Utrymme',
    'report__full_mail_groups' => 'Vidarebef. e-post',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'E-postlist',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Allmänt',
    'report__version' => 'Produktversion',
    'report__build' => 'Produkt-build',
    'report__status' => 'Status',
    'report__company_name' => 'Företagsnamn',
    'report__personal_name' => 'Namn',
    'report__login' => 'Användarnamn',
    'report__phone' => 'Telefon',
    'report__fax' => 'Fax',
    'report__email' => 'E-post',
    'report__address' => 'Adress',
    'report__city' => 'Stad',
    'report__state' => 'Län',
    'report__zip_code' => 'Postnummer',
    'report__country' => 'Land',
    'report__creation_date' => 'Skapandedatum',
    'report__expiration_date' => 'Utgångsdatum',
    'report__dumps_total_size' => 'Total filstorlek på säkerhetskopian',
    'report__section_resellers' => 'Återförsäljare',
    'report__active_resellers' => 'Återförsäljare med aktiva abonnemang',
    'report__resellers' => 'Återförsäljare',
    'report__section_full_resellers' => 'Återförsäljare',
    'report__section_clients' => 'Kunder',
    'report__active_clients' => 'Kunder med aktiva abonnemang',
    'report__clients' => 'Kunder',
    'report__section_full_clients' => 'Kunder',
    'report__section_personal_clients' => 'Egna kunder',
    'report__active_personal_clients' => 'Dina egna kunder med aktiva abonnemang',
    'report__personal_clients' => 'Egna kunder',
    'report__section_full_personal_clients' => 'Egna kunder',
    'report__section_domains' => 'Domäner',
    'report__disk_usage' => 'Diskanvändning',
    'report__traffic' => 'Trafik',
    'report__active_domains' => 'Aktiva domäner',
    'report__domains' => 'Domäner',
    'report__subdomains' => 'Subdomäner',
    'report__mboxes' => 'E-postlådor',
    'report__mail_groups' => 'Vidarebefordran av e-post',
    'report__mail_autoresp' => 'Autosvar',
    'report__mail_lists' => 'E-postlistor',
    'report__web_users' => 'Webbanvändare',
    'report__mysql_databases' => 'MySQL-databaVisar',
    'report__mssql_databases' => 'MSSQL-databaser',
    'report__section_full_domains' => 'Domäner',
    'report__section_personal_domains' => 'Personal domains',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Personal domains',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Webbplatser publicerade med Presence Builder',
    'report__invalid_email' => 'Ange en giltig e-postadress.',


    // CLI-specific sections
    'report__section_hosting' => 'Värding',
    'report__section_webusers' => 'Webbanvändare',
    'report__section_mailnames' => 'E-postkonton',
    'report__section_maillists' => 'E-postlistor',
    'report__section_databases' => 'DatabaVisar',
    'report__section_siteapps' => 'Webbapplikationer',
    'report__section_aspnetapps' => 'ASP.NET-tillämpningar', // PFW
    'report__owner_pname' => "Leverantörens personnamn",
    'report__owner_login' => "Leverantörens användarnamn",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Det specificerade språkpaketet är installerad, men inte aktiverad på systemet.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Radera sessioner',
    'ui__sessions/delete__title' => 'Radera sessioner',
    'ui__sessions/delete__description' => 'Radera valda sessioner.',
    'ui__ftp-sessions__short-title' => 'FPT-sessioner',
    'ui__ftp-sessions__title' => 'FPT-sessioner',
    'ui__ftp-sessions__description' => 'Visa FPT-sessioner.',
    'ui__ftp-sessions/delete__short-title' => 'Radera FPT-sessioner.',
    'ui__ftp-sessions/delete__title' => 'Radera FPT-sessioner.',
    'ui__ftp-sessions/delete__description' => 'Radera valda FPT-sessioner.',
    'ui__ts-sessions__short-title' => 'TS-sessioner',
    'ui__ts-sessions__title' => 'TS-sessioner',
    'ui__ts-sessions__description' => 'Visa terminaltjänstsessioner.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Radera sessioner',
    'ui__reseller/sessions/delete__title' => 'Radera sessioner',
    'ui__reseller/sessions/delete__description' => 'Radera valda sessioner.',
    'ui__reseller/sessions/delete_self__short-title' => 'Radera sessioner',
    'ui__reseller/sessions/delete_self__title' => 'Radera sessioner',
    'ui__reseller/sessions/delete_self__description' => 'Radera valda sessioner.',
    'ui__reseller/ftp-sessions__short-title' => 'FPT-sessioner',
    'ui__reseller/ftp-sessions__title' => 'FPT-sessioner',
    'ui__reseller/ftp-sessions__description' => 'Visa FPT-sessioner.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FPT-sessioner',
    'ui__reseller/ftp-sessions_self__title' => 'FPT-sessioner',
    'ui__reseller/ftp-sessions_self__description' => 'Visa FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Radera FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete__title' => 'Radera FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete__description' => 'Radera valda FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Radera FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Radera FPT-sessioner.',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Radera valda FPT-sessioner.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Radera sessioner',
    'ui__client/sessions/delete__title' => 'Radera sessioner',
    'ui__client/sessions/delete__description' => 'Radera valda sessioner.',
    'ui__client/sessions/delete_self__short-title' => 'Radera sessioner',
    'ui__client/sessions/delete_self__title' => 'Radera sessioner',
    'ui__client/sessions/delete_self__description' => 'Radera valda sessioner.',

    // domain administrator

    'forgery_token_expired' => 'Sessionstoken har gått ut.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Följande återförsäljarkonton kommer att omvandlas till kundkonton',
    'downgradeResellers__downgrade' => 'Återförsäljarekonton som kommer att omvandlas',
    // controls
    'downgradeResellers__submit_downgrade' => 'Utför kontoomvandlingen.',
    'downgradeResellers__cancel_downgrade' => 'Radera kontoomvandlingen.',
    'downgradeResellers__confirm' => 'Bekräfta omräkning',
    'downgradeResellers__confirm_message' => 'Bekräfta kontoomvandlingen för att fortsätta',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Markera kundkonton',
    'upgradeClients__upgrade_clients' => 'Följande kundkonton kommer att omvandlas till återförsäljarkonton',
    'upgradeClients__upgrade' => 'Kundkonton som kommer att omvandlas',
    // controls
    'upgradeClients__submit_upgrade' => 'Utför kontoomvandlingen.',
    'upgradeClients__cancel_upgrade' => 'Radera kontoomvandlingen.',
    'upgradeClients__confirm' => 'Bekräfta omräkning',
    'upgradeClients__confirm_message' => 'Bekräfta kontoomvandlingen för att fortsätta',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Kan inte ändra kontot \'%1\' ttill ett återförsäljarkonto: \'%1\' är redan en återförsäljare.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Följande domänadministratörskonton kommer att omvandlas till kundkonton',
    'upgradeDomainUser__upgrade' => 'Domänadministratörskonton som kommer att omvandlas',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Utför kontoomvandlingen.',
    'upgradeDomainUser__cancel_upgrade' => 'Radera kontoomvandlingen.',
    'upgradeDomainUser__confirm' => 'Bekräfta omräkning',
    'upgradeDomainUser__confirm_message' => 'Bekräfta kontoomvandlingen för att fortsätta',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Domänadministratörskonton som inte kan omvandlas',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Följande Domänadministratörskonton kunde inte omvandlas till kundkonton:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Flera domänadministratörskonton kunde inte omvandlas till kundkonton. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Domänadministratörskontot finns inte',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domänen ska direkt tillhöra serveradministratören eller en återförsäljare.",
    'upgradeDomainUser__all_logins_already_used' => 'Kan inte skapa ett konto för den resulterande kunden.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Domänadministratörskontot har omvandlats',
    'upgradeDomainUser__upgrade_notification_body' => 'Ditt domänadministratörskonto har omvandlats till ett kundkonto med användarnamnet \'%%login%%\' och lösenordet \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Tilldela ny ägare för kundkonto %1', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Tilldela ny ägare för valda kundkonton.', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Tilldela ny ägare för valda användarkonton', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Markera kundkonton',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Markera de kundkonton du vill överföra till en annan ägare.',
    //  owner selection
    'client_chown__select_title' => 'Välj ny ägare för kundkonton',
    'client_chown__select-multi_title' => 'Välj ny ägare för kundkonton',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Välj ny ägare för valda kundkonton.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Välj ny ägare för valda kundkonton.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Välj ny ägare för valda kundkonton.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Granska ändringar och slutför guide',
    'ui__client/chowner__wizard__2' => 'Gå igenom ändringarna och klicka på Slutför för att avsluta guiden.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Gå igenom ändringarna och klicka på Slutför för att avsluta guiden.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Gå igenom ändringarna och klicka på Slutför för att avsluta guiden.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Du måste välja en ny ägare till valda kundkonton',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'En eller flera av de valda användarkontona kan överföras till den nya ägaren.',
    'client_chown__client_warn' => 'Beskrivning',

    'clientOwnerChanger__owner_has_no_permission' => 'Den valde återförsäljaren har inte behörighet \'%1\', men några av kunderna har denna behörighet.',
    'clientOwnerChanger__application_not_allowed' => 'Programmet \'%1\' är inte tillgängligt för den valde återförsäljaren, men är tillgänglig för några av kunderna.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Tilldela om markerade abonnemang',
    // errors
    'domain_chown__empty_selection' => 'Du har valt en ny ägare av valda domäner',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Uppträdande',
    'hosting_performance__traffic_bandwidth_legend' => 'Slå på bandbreddsbegränsning',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Bandbreddsbegränsning',
    'hosting_performance__traffic_bandwidth_label' => 'Maximal bandbreddsanvändning (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'Bandbreddsanvändningsgränsen gäller bara data överförd genom HTTP-protokoll.',
    'hosting_performance__max_connection_legend' => 'Slå på anslutningsbegränsning',
    'hosting_performance__max_connection_legend_ro' => 'Anslutningsbegränsningar',
    'hosting_performance__max_connection_label' => 'Begränsa anslutningar till',
    'hosting_performance__max_connection_hint' => 'Om du begränsar användningen av bandbredd, rekommenderar vi att du också begränsar antalet samtidiga anslutningar till siten. Annars, i händelse av frekventa förfrågningar till siten, kommer webbserverprocesser att öka serverbelastningen.',

    // errors:
    'performance__qos_not_installed' => 'Funktion avstängd eftersom QoS inte är installerat',
    'performance__bandwidth_throttling' => 'Du kan inte kontrollera bandbreddsbegränsningen eftersom QoS (tjänstkvalitet) inte är installerat.',
    'performance__invalid_value' => "Värdet är ogiltigt. Värdet måste vara i intervallet mellan %1 och %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webbpost',
    'webmail__server_text' => 'Tillgängliga webbmailklienter',
    'webmail__none' => 'Ingen',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Serverns IP-pool',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Databasen kommer inte att återställas: det finns inte någon lämplig databasserver',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Säkerhetskopiering av server.",
    '__default_backup_comment_reseller' => "Säkerhetskopia av återförsäljarkontona skapades av %1.",
    '__default_backup_comment_client' => "Säkerhetskopia av kundkontona skapades av %1.",
    '__default_backup_comment_domain' => "Säkerhetskopia av abonnemangen skapades av %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Definiera IP-adressmappning',
    'backup__ip_mapping__download' => 'Spara aktuell IP-mappning till fil',
    'b_backup__ip_mapping__download' => 'Klicka för att ladda ner IP-mappningskonfiguration.',
    'b_backup__ip_mapping__download_is_empty' => 'IP-mappningskonfiguration är tom.',
    'backup__ip_mapping_upload__title' => 'Ladda upp IP-mappningsfil',
    'backup__ip_mapping__upload' => 'Ladda upp IP-mappningsfil',
    'b_backup__ip_mapping__upload' => 'Klicka för att ladda upp IP-mappningskonfiguration.',
    'backup__ip_mapping__list__header' => 'IP-mappning',
    'backup__ip_mapping__list__adddress' => 'Gamla IP-adresser',
    'backup__ip_mapping__list__select_ip' => 'Nya IP-adresser',
    'backup__ip_mapping__clients_ip' => "IP-pool för kunden %1",
    'backup__ip_mapping__resellers_ip' => "IP-pool för återförsäljaren %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Dedikerade IP-adresser ska mappas till unika IP-adresser. Välj en unik IP-adress för varje dedikerad IP-adress i listan.',
    'backup__ip_mapping__legend' => 'IP-mappning',
    'backup__ip_mapping__upload_legend' => 'Ladda upp',
    'backup__ip_mapping__upload_file_text' => 'IP-mappningsfil',
    'backup__ip_mapping__upload_file_hint' => 'IP-mappningsfil är en vanlig textfil. Varje rad av denna fil innehåller IP-mappning i följande format: <gammal IP-adress> <ny IP-adress>',
    'backup__ip_mapping__ip_address_not_found' => 'Inga gratis IP-adresser av denna typ tillgängliga.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Kan inte utföra dataöverföringen: kartläggningen av IP-adresserna är ofullständig eftersom det inte finns några lediga IP-adresser i poolen i destinationsservern.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Icke-säkra FTPS-anslutningar kommer att förbjudas för domäner med denna IP-adress.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Säkra FTPS-anslutningar kommer att förbjudas för domäner med denna IP-adress.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Konflikter',
    'backup__restore__object_vhost' => 'Virtuell värd',
    'backup__restore__object_plesk_admin' => 'Plesk administrator',
    'backup__restore__object_ftpuser' => 'FTP-konto',
    'backup__restore__object_frontpageuser' => 'FrontPage-konto',
    'backup__restore__object_webuser' => 'webbanvändare',
    'backup__restore__object_domain' => 'domän',
    'backup__restore__object_subdomain' => 'subdomän',
    'backup__restore__object_domainalias' => 'domänalias',
    'backup__restore__object_client' => 'kund',
    'backup__restore__object_reseller' => 'återförsäljare',
    'backup__restore__object_autoresponder' => 'autosvar',
    'backup__restore__object_mailalias' => 'e-post alias',
    'backup__restore__object_database' => 'databas',
    'backup__restore__object_mailname' => 'E-postkonto',
    'backup__restore__object_db_user' => 'Databas användare',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-certifikat',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Följande återförsäljare kan inte återställas beroende på att de är omvandlade till kunder: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Följande kunder kan inte återställas beroende på att de är omvandlade till återförsäljare: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Följande kunder kan inte återställas beroende på att de är flyttade till en annan ägare: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Inte tillräckligt ledigt diskutrymme på målservern för att överföra alla valda abonnemang. Tillgängligt: %1 MB. Nödvändigt: %2 MB. Observera att det nödvändiga utrymmet beräknas som en summa av webb-, e-post- och databasinnehållet av domänerna. Det nödvändiga utrymmet beräknas en gång per dag och lagras i cache, så att den faktiska storleken av domänerna kan vara en annan än den beräknade storleken. Om du säkerställer att de valda domänerna inte upptar mer utrymme än det som är tillgänglig, kan du fortsätta med överföringen.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Frigör diskutrymme på målservern.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Inte tillräckligt ledigt diskutrymme på källservern för att lagra temporära filer för överföringen. Tillgängligt: %1 MB. Nödvändigt: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Frigör diskutrymme på källservern.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Serverinformation',

    'backup__restore__capability_not_installed_component_text' => 'Komponenten %1 har inte installerats i destinationens server. %1 kommer att vara otillgängligt för alla återställda objekt.',
    'backup__restore__capability_not_installed_component_resolution' => 'Installera %1. Det kan ta några minuter.',
    'backup__restore__capability_existing_sys_user_text' => 'En systemanvändare med namnet %1 finns redan på målservern.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Ändra namn på den befintliga systemanvändaren på målservern.',
    'backup__restore__capability_license_usage_text' => 'Följande resursbegränsningar (definierade av licensnyckeln) kommer att överskridas på målservern efter dataöverföring:',
    'backup__restore__capability_license_usage_resolution' => 'Installera en annan licensnyckel på målservern som erbjuder den begärda mängden resurser.',
    'backup__restore__capability_max_allowed_packet_text' => "'max_allowed_packet'-parametern på källdatabasservern är %1, vilket är större än på målservern, där det är %2. Vissa databasobjekt för domänerna angivna nedan kanske inte återställs.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Öka 'max_allowed_packet'-värdet på måldatabasservern.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Kan inte överföra PostgreSQL-databaser eftersom PostgreSQL-versionen på målservern är lägre än på källservern. Den aktuella versionen är %1, den begärda versionen är %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Installera den nödvändiga versionen av PostgreSQL på målservern.',
    'backup__restore__capability_db_server_connection_problems' => 'Det gick inte att ansluta till PostgreSQL-måldatabasservern. Databaser kommer inte att överföras om du inte återställer anslutningen.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Kontrollera anslutningsinställningarna på måldatabasservern.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponenten %1 är avstängd på målservern.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Slå på %1 på målservern.',
    'backup__restore__capability_not_configured_component_text' => 'Komponenten %1 har inte konfigurerats i destinationens server.',
    'backup__restore__capability_not_configured_component_resolution' => 'Konfigurera %1 på sidn Verktyg & inställningar.',

    'backup__restore__capability_webmail_is_not_available' => '%1 webbpost-tjänster är inte tillgängliga i destinationens server. I stället använder Plesk följande webbpost-tjänst: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'För att använda samma webbpost som i källservern, måste du installera den i denna server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'För att använda samma webbmail som på källservern, ska du installera det på målservern.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1'-webbmailen är inte tillgänglig på målservern. I stället använder Plesk följande webbpost-tjänst: %2 i följande abonnemang: %3.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Installera den nödvändiga webbmailen på målservern.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webbmailinställningar',

    'backup__restore__capability_shell_is_not_available' => 'Kommandoskalet %1 är inte tillgängligt i destinationens server. Ett av de tillgängliga skalprogram kommer att användas istället.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'För att använda samma skalprogram som på källservern, ska du slå på det (in etc/shells) eller installera det på målservern.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Destinationens DNS-server stödjer inte nätverk i Mallen för Överföringsbegränsningar. Posterna med nätverkets IP-adresser i DNS-överföringsrestriktioner kommer inte att återställas.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Destinationens DNS-server stödjer inte nätverk i Mallen för Överföringsbegränsningar, men vissa abonnemang har nätverk i DNS-överföringsbegränsningarna. Posterna med nätverkets IP-adresser i DNS-överföringsrestriktioner kommer inte att återställas.',

    'backup__restore__capability_wrong_php_handler_text' => 'PHP-hanteraren %1 är inte tillgänglig på målservern. Istället kommer Plesk använda följande PHP-hanterare: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'För att använda samma PHP-hanterare som på källservern, ska du starta den eller installera den på målservern.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP-hanteraren %1 är inte tillgänglig. I stället använder Plesk %2 till följande serviceplaner: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP-hanteraren %1 är inte tillgänglig. I stället använder Plesk %2 till följande webbplatser: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP-hanteraren %1 är inte tillgänglig. Den kommer inte att finnas tillgänglig för följande webbplatser: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Kommandoskalet %1 %2 är inte tillgängligt i destinationens server. Standardversionen kommer att användas istället.',
    'backup__restore__capability_wrong_component_version_resolution' => 'För att använda samma %1 som på källservern, ska du slå på det eller installera det på målservern.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Denna antivirus-policy som används i destinationens server tillåter inte personliga antivirusinställningar (via e-post) för utgående e-post. De här inställningarna kommer inte att överföras.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'En antivirus-policy som används i destinationens server tillåter inte personliga antivirusinställningar (via e-post) för inkommande e-post. De här inställningarna kommer inte att överföras.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Denna antivirus-policy som används i destinationens server tillåter inte personliga antivirusinställningar (via e-post). De här inställningarna kommer inte att överföras.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "För att överföra personliga antivirusinställningar (via e-post), aktivera motsvarande alternativ i Verktyg och inställningar > Antivirus-inställningar.",
    'backup__restore__capability_antivirus_not_active_text' => 'Ingen antivirus-mjukvara aktiverad. All antivirusinställningar från källservern kommer inte fungera förrän du väljer antivirusmjukvaran på målservern.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Välj antivirusmjukvara i avsnittet Verktyg & inställningar > Virusskyddsinställningar > Antivirusinställningar.',

    'backup__restore__capability_antivirus_another_active_text' => 'Antivirus-mjukvaran %2 är inte tillgänglig på målservern. %1 kommer att användas istället.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'För att använda samma antivirus som på källservern, installera det och välj det i avsnittet Verktyg & inställningar > Virusskyddsinställningar > Antivirus-inställningar.',
    'backup__restore__capability_not_available_sni_text' => 'SNI är inte tillgängligt på målservern. Webbplatser som har samma IP-adress kommer inte att kunna använda individuella SSL/TLS-certifikat.',
    'backup__restore__capability_not_available_sni_resolution' => "Vänligen kontrollera att operativsystemet i destinationsservern stödjer SNI och att stödet för SNI är aktiverat på Plesk (kryssrutan 'Aktivera SNI-support, som tillåter individuella SSL/TLS-certifikat på webbplatser med samma IP-adress' i Verktyg och inställningar> Serverinställningar)",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Serverinställningar',

    'backup__restore__capability_vhost_already_exists_text' => 'Webbplatsen %1 kan inte överföras: en webbplats med samma namn finns redan i destinationens server.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Byt namn eller ta bort webbplatsen med samma namn från servern.',
    'backup__restore__capability_removed_vhosts' => 'Följande abonnemang kommer inte att återställas eftersom de innehåller domännamn som redan finns på målservern: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'På källservern finns det %3 olika PHP-hanterare av typen %1 och versionen %2. Istället för dem, kommer en hanterare av lämplig typ och version att användas på målservern. Tänk på att PHP-inställningar på käll- och målserver kan vara olika.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer stödjer inte Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer stödjer inte Python. Installera Python manuellt.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'E-postinställningar',

    'backup__restore__capability_ftps_disabled' => 'Att använda säkra FTPS är tillåtet på källservern men förbjudet på målservern. Användares appar som använder FTP kanske inte fungerar korrekt.',
    'backup__restore__capability_ftps_required' => 'Att använda icke-säkra FTP är tillåtet på källservern men förbjudet på målservern. Användares appar som använder FTP kanske inte fungerar korrekt.',
    'backup__restore__capability_ftps_policy_resolution' => 'Ändra Säker FTP-policyn i Verktyg & inställningar > Säkerhetspolicy.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte data kommer att flyttas från källservern till målet under %2 timmar.',
    'backup__restore__capability_too_much_download_time_resolution' => 'För en snabbare överföring, kontrollera nätverksanslutningen mellan käll- och målserver och lös ev. problem.',
    'backup__restore__too_low_download_speed' => "mindre än 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'För en snabbare överföring, kontrollera nätverksanslutningen mellan käll- och målserver och lös ev. problem.',
    'backup__restore__capability_zero_download_speed_text' => 'Den minsta acceptabla nedladdningshastigheten är %1 MBps. Nedladdningshastigheten mellan käll- och målservern är 0 MBps. Detta kan bero på anslutningsproblem i nätverket. Överföring är inte möjligt.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Kontrollera din nätverksanslutning mellan käll- och destinationsservrarna och lös problem.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Den minsta acceptabla nedladdningshastigheten är %2 MBps. Nedladdningshastigheten mellan käll- och målservern är %1 MBps. Detta kan öka överföringstiden. I din aktuella miljö kommer migrering av %3 MB till att ta %4 timmar.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Den minsta acceptabla nedladdningshastigheten är %2 MBps. Nedladdningshastigheten mellan käll- och målservern är %1 MBps. Detta kan öka överföringstiden.',

    'backup__restore__capability_remote_database_migration' => "Följande domäner använder fjärrdatabaser: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Ta inte bort dessa domäner från källservern efter överföringen, om Plesk-versionen på källserver är tidigare än 11.5! Stäng av dem istället. Om du tar bort domänerna, kommer databaserna att avlägsnas från fjärrservern. Notera: Dumpfilerna av fjärrdatabaser kommer att lagras på källservern i katalogen %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Säkerhetskopior av MySQL-databasservrar tidigare än 5.1 (%1) kan inte återställas på MySQL 5.1.x, eftersom MySQL 5.1.x hanterar Unicode-tecken annorlunda.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Läs den relaterade kunskapsartikeln nr 136850',

    'backup__restore__capability_firewall_not_installed_text' => 'Brandväggen har inte installerats på målservern. Om du etablerade åtkomst begränsningsregler, kommer reglerna inte att fungera.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Installera Firewall extension genom att använda Plesk Installer.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP har inte installerats på målservern.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Installera Courier-IMAP genom att använda Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot har inte installerats på målserver.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Installera Dovecot genom att använda Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Kvarhållningstiden för trafikstatistiken i konfigurationer av följande objekt är mindre än det serveromfattandet värdet på målservern.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Ändra det serveromfattande värdet för kvarhållningstiden för statistik på målservern. Ställ in denna tid till lika med eller mindre än det minsta värdet i domänernas konfigurationer.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Kvarhållningstid för trafikstatistik på vissa domäner är mindre än det serveromfattandet värdet (%1). Värdet kommer att ändras till %1 för dessa domäner.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Trafikstatistikens kvarhållningstid i vissa abonnemangstyper är mindre än det serveromfattande värdet (%1). Värdet ändras till %1 för dessa abonnemangstyper.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mappning av en exklusiv IP-adress till en delad kommer att inaktivera anonym FTP och HTTPS (såvida inte SNI-stöd är aktiverat).',

    'backup__restore__no_postgresql_commands_text' => 'Abonnemanget använder en PostgreSQL fjärrdatabas, och den temporära säkerhetskopiefilen av denna kan inte skapas beroende på att pg_dump och psql kommandon saknas på källservern.',
    'backup__restore__no_postgresql_commands_resolution' => 'Installera en PostgreSQL-klientpaket som stödjer dessa kommandon.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Följande Apache-moduler är inaktiverade på målservern: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Aktivera dessa moduler för att förhindra eventuella problem.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Följande Apache-moduler är inte installerade på målservern: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Installera och aktivera dessa moduler för att förhindra eventuella problem.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Begränsningen av utgående meddelanden stöds inte av din licens. De motsvarande  konfigurationställningarna kommer inte att överföras.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Installera en annan licensnyckel på målservern som erbjuder den begärda mängden funktioner.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Begränsningen av utgående meddelanden är avstängd på målservern. De motsvarande  konfigurationställningarna kommer inte att överföras.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Slå på begränsningen av utgående meddelanden på målservern.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Serveromfattande e-postinställningar',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Begränsningen av utgående meddelanden från en postlåda stöds inte av e-post servern som används på målservern. Värdet av denna gränsen kommer inte att överföras.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Ändra e-postservern till det samma som du använder på källservern.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Serveromfattande e-postinställningar',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Begränsningen av utgående meddelanden från en domän stöds inte av e-post servern som används på målservern. Värdet av denna gränsen kommer inte att överföras.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Ändra e-postservern till det samma som du använder på källservern.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Serveromfattande e-postinställningar',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Begränsningen av utgående meddelanden från ett abonnemang stöds inte av e-post servern som används på målservern. Värdet av denna gränsen kommer inte att överföras.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Ändra e-postservern till det samma som du använder på källservern.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Serveromfattande e-postinställningar',

    'bu_conflict_resolver_absent_phosting' => 'Kan inte återställa de specificerade filerna beroende på att fysisk värdtjänst för att återställa dom inte finns. Skapa en domän med fysisk värdtjänst först och starta återställandet av säkerhetskopian igen.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Återförsäljarens uppgifter återställs inte eftersom det inte finns stöd för återsäljarhantering.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Komponenten ModSecurity har inte installerats i målservern.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Installera ModSecurity om du vill behålla webbprogram brandväggen i gång för de överförda webbplatserna. Observera att installationen kan ta några minuter.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installera ModSecurity om du vill överföra inställningarna från webbprogram brandväggen. Observera att installationen kan ta några minuter.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Komponenten ModSecurity har inte konfigurerats i målservern.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfigurera ModSecurity om du vill behålla webbprogram brandväggen i gång för de överförda webbplatserna.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Webbprogram brandvägg (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity är avstängd på målservern.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktivera ModSecurity om du vill behålla webbprogram brandväggen i gång för de överförda webbplatserna.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Webbprogram brandvägg (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ModSecurity komponenten är inte installerat Webbprogram brandvägg inställningarna kommer inte att återställas för följande objekt: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Webbplatser kan inte återställas beroende på abonnemanget %1 som inte hittas i Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponenten %1 har inte installerats i destinationens server. DNS-tjänsten är otillgänglig och DNS-inställningarna raderas, Alla kunders webbplatser stängs ner.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS-tjänsten är inte installerad. DNS-inställningarna kommer inte att återställas för följande objekt: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Följande abonnemang kan inte återställas beroende på att de är flyttade till andra ägare: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Följande abonnemang kan inte återställas beroende på att de är flyttade till andra ägare: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Kan inte hitta återställningsprogrammet för Web Presence Builder för att återställa uppgifterna för Web Presence Builder. Web Presence Builder har antagligen inte installerats.',
    'backup__restore__capability_renamed_db' => 'Databasnamnet "%1" används redan av ett annat abonnemang. Namnet på den återställda databasen ändras till "%2".',
    'backup__restore__capability_renamed_db_user' => 'Databasens användarnamn "%1" används redan av ett annat abonnemang. Namnet på den återställda databasen kommer att ändras till "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer stödjer inte Perl. Installera ActiveState Perl manuellt.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% som servas av Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% som servas av ngnix (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Timingkonflikter',
    'backup__restore__hint_timing_conflicts' => 'Timingkonflikter inträffar antingen när det återställda objektet redan finns i systemet med ett senare ändringsdatum, eller när det återställda objektet för närvarande inte finns i systemet.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Använd konfiguration och data från säkerhetskopian',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Skriv fullständigt över objektkonfiguration och data som för närvarande finns i systemet, med konfiguration och data från säkerhetskopian. Om det återställda objektet för närvarande tillhör en annan ägare, återställs objektet under den förre ägaren.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Använd konfiguration från aktuellt system och data från säkerhetskopian',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Skriv över aktuell objektdata med data från säkerhetskopiefilen, men behåll objektkonfigurationen som för närvarande finns i systemet. Om det återställda objektet för närvarande tillhör en annan ägare, återställs objektet under den aktuella ägaren.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Återställ inte',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Återställ inte objekt som har timingkonflikter.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Resursens användningskonflikter',
    'backup__restore__hint_resource_usage_conflicts' => 'Resursanvändningskonflikter inträffar när resursanvändningsgränserna för det återställda objektet överskrids vid återställningen.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Tillåt överanvändning',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Återställ objektet och tillåt det att använda fler resurser än som tillhandahålls initialt.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Återställ inte',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Återställ inte objekt som har resursanvändningskonflikter.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konfigurationskonflikter',
    'backup__restore__hint_configuration_conflicts' => 'Konfigurationskonflikter uppstår när det återställda objektet har inställningar och webbprogram som inte är tillgängliga eller som är förbjudna av den aktuella servern eller objektägarens policy. Till exempel, konfigurationskonflikter uppstår om återställda e-postkonton har individuella skräppostsinställningar medan den aktuella serveromfattande policyn förbjuder e-postkonton med dessa inställningar.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatisk',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Återställ objekt och slå automatiskt på alla motstridiga konfigurationsalternativ som din behörighet låter dig hantera.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Återställ inte',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Återställ inte objekt som har konfigurationskonflikter.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Dedikerade IIS-programpooler är inte tillåtna i IIS-programpoolens inställningar.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Ändra dina IIS-programpoolinställningar i Verktyg och inställningar > IIS-programpool > Globala inställningar.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Delade IIS-programpooler är inte tillåtna i IIS-programpoolens inställningar.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Ändra dina IIS-programpoolinställningar i Verktyg och inställningar > IIS-programpool > Globala inställningar.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Korta POP3/IMAP e-postkontonamn är inte tillåtna i destinationens server.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Korta namn för e-postkonton kommer inte att vara tillgängliga efter dataåterställningen.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Kan inte öppna loggfilen.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Kan inte återställa abonnemanget %1: det har tagits bort från kontot och Du saknar behörighet att skapa abonnemang. Om du behöver återställa det, kontakta din tjänsteleverantör.',

    'backup__error11' => 'Det finns inte tillräckligt med diskutrymme för säkerhetskopia.',
    'backup__error3011' => 'Anslutningen ble nekad: Ingen program lyssnar på den specificerade adress och port.',
    'backup__error3012' => 'Tidsgräns för anslutning.',
    'backup__error3013' => 'Nätverket kan inte nås.',
    'backup__error3014' => 'Ingen väg till värddatorn.',
    'backup__error3015' => 'Det gick inte att ansluta.',
    'backup__error3016' => 'Det gick inte att lösa värddatornamnet.',
    'backup__error3017' => 'Felaktigt användarnamn eller lösenord',
    'backup__error3018' => 'SSH-anslutningen har misslyckats.',

    'backup__error3110' => 'Det gick inte att ansluta till fjärr-migrationsagenten: Anslutning till värddatorn är inte tillgänglig.',
    'backup__error3111' => 'Migrationsagenten är låst av en migrationsuppgift som misslyckades eller är i bruk av en annan migrationsprocess. Starta om migrationsagenten på källservern.',
    'backup__error3112' => 'Det finns ingen tillgänglig anslutning till värddatorn, eller migrationsagenten körs inte på källvärden.',
    'backup__error3113' => 'Det går inte att distribuera migrationsagenten till en Linux värddator. Kontrollera SSH anslutningen till värddatorn.',
    'backup__error3114' => 'Det går inte att distribuera migrationsagenten till en Linux värddator: SSSH anslutningen misslyckades.',
    'backup__error3115' => 'Felaktigt användarnamn eller lösenord',
    'backup__error3116' => 'Angiven användare har inte administrationsrättigheter.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Hela konfigurationen och innehållet',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'All konfiguration och allt innehåll utom e-post',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Endast e-postkonfiguration och innehåll',

    'dns_t__unable_to_remove_ns_record' => 'Kan inte ta bort NS-data från DNS-mallen: varje DNS-zon måste ha minst en NS-uppgift.',
    'dns__unsupported_server_zone_transfer' => 'Kan inte överföra mallen med överföringsrestriktioner pga. den serveromfattande DNS-konfigurationen: i källtjänsten har följande nätverksadresser tillstånd till zonöverföring, men dessa adresser är förbjudna av Microsofts DNS-server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Kan inte överföra mallen med överföringsrestriktioner pga. domänerna\' DNS-konfiguration: i vissa domäner har följande nätverksadresser tillstånd till zonöverföring, men dessa adresser är förbjudna av Microsofts DNS-server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Definiera databasservermappning',
    'dbbackup__check_network_settings_failed' => 'Kan inte få tillgång till den delade temporära nätverk katalogen för säkerhetskopierade filer. Kontrollera nätverk katalogen, användarnamn och lösenord inställningar. Fel: %1',

    'migration_select_exist_db_server' => 'Välj destinationens databasserver',

    'dbbackup__temp_dir_wrong_value' => 'Det ogiltiga värdet för den tillfälliga katalogen har angetts.',
    'dbbackup__network_temp_dir_wrong_value' => 'Det ogiltiga värdet för den tillfälliga nätverkskatalogen har angetts.',
    'dbbackup__server_backup_not_configured' => 'Databasens säkerhetskopieringsinställningar är inte konfigurerade på servern.',
    'dbbackup__temp_dir' => 'Temporär katalog',
    'dbbackup__temp_dir_hint' => 'Vägen till en fysisk mapp på fjärrservern där MS SQL-servern finns. MS SQL-servern måste kunna få tillgång till denna mapp för att läsa och skriva tillfälliga säkerhetskopierade filer. Till exempel, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Vägen till nätverksdelningen av mappen till den fysiska mappen som specificeras ovan. Plesk får åtkomst till den delade mappen för nerladdning och uppladdning av säkerhetskopierade filer. Till exempel, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Användarnamnet för en nätverksanvändare som skapats i fjärrservern. Till exempel, ServerName\\UserName. Användaren måste ha tillgång till den delade mappen som anges ovan.',
    'dbbackup__network_password_hint' => 'Nätverkets användarlösenord',

    'dbbackup__success_import_without_dublicate_users' => 'Följande användare importerades inte: %1. De finns redan i databasservern.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Komprimera loggfilerna",
    'log_rot__log_rot_status' => "Loggrotationsstatus",
    'log_rot__log_rot_period' => "Loggroteringsvillkor",
    'log_rot__log_rot_size' => "efter storlek",
    'log_rot__log_rot_time' => "med tid",
    'log_rot__logrotation_enable' => "Slå på loggrotering",
    'log_rot__mail' => "Skicka bearbetade loggfiler till e-post",
    'log_rot__max_number_of_logfiles' => "Maximalt antal loggfiler",
    'log_rot__time_period' => "period",
    'log_rot__unable_turn_off' => 'Kan inte stänga av loggrotationen eftersom den är forcerad på servernivå',
    'log_rot__unable_set_period' => 'Kan inte ställa in loggrotationsperioder som skiljer sig från \'daily\', eftersom de är forcerade på servernivå',
    'log_rot__unable_set_max_log_files' => 'Kan inte ställa in maximalt antal loggfiler över servergränsen %1',

    /// action log
    // common/various
    'actionlog__confirm_clean_log' => "Vill du verkligen ta bort de valda åtgärdslogguppgifterna?",
    'actionlog__digit_expected' => "Ett tal förväntas: %1",
    'actionlog__dont_remove_recs' => "ta inte bort poster",
    'actionlog__from_date' => "Från:",
    'actionlog__incorrect_rotation' => "Ogiltiga loggroteringsparametrar angivna: %1",
    'actionlog__js_incorrect_date' => "Felaktigt datum angavs.",
    'actionlog__js_incorrect_num_periods' => "Ogiltig rotationsperiod angiven.",
    'actionlog__js_incorrect_num_records' => "Ogiltigt antal poster angivna.",
    'actionlog__logged_actions' => "Loggade åtgärder",
    'actionlog__period_day' => "dagar",
    'actionlog__period_month' => "månader",
    'actionlog__period_week' => "veckor",
    'actionlog__settings' => "Åtgärdslogg inställningar",
    'actionlog__store_logs_in_db' => "Lagra poster i databasen",
    'actionlog__store_number' => "poster",
    'actionlog__to_date' => "Till:",
    'actionlog__unknown_rot_period' => "Okänd rotationsperiod: %1",
    'actionlog__unknown_rot_type' => "Okänd uppräkningstyp: %1",
    'actionlog__wrong_date_period' => "Ogiltigt datum",
    'actionlog__session_preferences' => 'Sessionsinställningar',
    // items (PFU schema)
    'actionlog__admin_info' => 'Administratörsinformation',
    'actionlog__admin_preferences' => "Administratörsinställningar",
    'actionlog__service' => 'Tjänst',
    'actionlog__ip_addr' => 'IP-adress',
    'actionlog__client' => 'Kund-ID',
    'actionlog__client_status' => 'Kundens kontostatus',
    'actionlog__client_preferences' => "Kundens gränssnittspreferenser",
    'actionlog__client_ip_pool' => "Kundens IP-pool",
    'actionlog__client_siteapp' => "Kundens webbprogrampool",
    'actionlog__client_guid' => "Kund-GUID",
    'actionlog__domain' => 'Standarddomän (den första domänen som lagts till ett abonnemang)',
    'actionlog__domain_owner' => 'Abonnemangets ägare',
    'actionlog__domain_plan' => 'Serviceplan för abonnemanget',
    'actionlog__domain_status' => 'Standarddomän, status',
    'actionlog__domain_dns' => 'Standarddomän, DNS-zon',
    'actionlog__subdomain' => 'Subdomän av en standarddomän',
    'actionlog__domain_alias' => 'Standarddomän, alias',
    'actionlog__domain_alias_dns' => 'Standarddomän, alias DNS-zon',
    'actionlog__site' => 'Domän',
    'actionlog__site_status' => 'Domänstatus',
    'actionlog__site_dns' => 'Domänens DNS-namn',
    'actionlog__site_guid' => 'Domän GUID',
    'actionlog__site_subdomain' => 'Subdomän',
    'actionlog__site_alias' => 'Domänalias',
    'actionlog__site_alias_dns' => 'Domänalias DNS-zon',
    'actionlog__domain_limits' => 'Abonnemangsbegränsningar',
    'actionlog__domain_limit_size' => 'Diskutrymmets gräns för abonnemanget',
    'actionlog__domain_limit_traffic' => 'Trafikgräns för abonnemanget',
    'actionlog__domain_limits_powerUser' => 'Abonnemangsbegränsningar',
    'actionlog__domain_limit_size_powerUser' => 'Diskutrymmets gräns för abonnemanget',
    'actionlog__domain_limit_traffic_powerUser' => 'Trafikgräns för abonnemanget',
    'actionlog__domain_guid' => "Standarddomän, GUID",
    'actionlog__cp_user' => 'Plesk användare',
    'actionlog__mailname' => 'E-postkonto',
    'actionlog__maillist' => 'E-postlista',
    'actionlog__phosting' => 'Värdtjänst-inställningar',
    'actionlog__forwarding' => 'Standard-värdtjänst eller bildvidarebefordran värdtjänst',
    'actionlog__webuser' => 'Webbanvändarkonto',
    'actionlog__site_application' => 'Webbprogram',
    'actionlog__license' => 'Licensnyckel',
    'actionlog__additional_license' => 'Extra licensnyckel',
    'actionlog__template_domain' => "Abonnemangstyp för återförsäljaren",
    'actionlog__template_admin' => "Abonnemangstyp för administratören",
    'actionlog__template_reseller' => 'Återförsäljarplan',
    'actionlog__admin_alias' => 'Extra administratörskonto', // PFW
    'actionlog__ftpuser' => 'Extra FTP-konto', // PFW
    'actionlog__db_server' => 'Databasserver',
    'actionlog__db' => 'Databas',
    'actionlog__db_user' => 'Databasens användarkonto',
    'actionlog__client_sapppkg_pool' => "Användarens webbprogram", // PFW, not used?
    'actionlog__remote_dns' => 'Fjärrstyrd status för DNS-servern', // PFW
    'actionlog__reseller' => 'ÅF-konto',
    'actionlog__reseller_guid' => 'Återförsäljar-GUID',
    'actionlog__reseller_ip_pool' => "Återförsäljarens IP-pool",
    'actionlog__reseller_limit_size' => 'Diskutrymmets gräns för återförsäljarkontot',
    'actionlog__reseller_limit_traffic' => 'Trafikgräns för återförsäljarkontot',
    'actionlog__reseller_limits' => 'Återförsäljarens kontogränser',
    'actionlog__reseller_permissions' => 'Återförsäljartillstånd',
    'actionlog__reseller_preferences' => "Återförsäljarens gränssnittspreferenser",
    'actionlog__reseller_siteapp' => "Webbapplikationer i återförsäljarpoolen",
    'actionlog__reseller_status' => 'Återförsäljarens kontostatus',
    'actionlog__health_status' => 'Serverns hälsotillstånd',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'nådd',
    'actionlog__added' => 'tillagd',
    'actionlog__removed' => 'borttagen',
    'actionlog__change' => 'ändrad',
    'actionlog__update' => 'uppdaterad',
    'actionlog__move' => 'flyttad',
    'actionlog__upgrade' => 'uppgraderat', // PFU?
    'actionlog__update_or_add' => 'uppdaterat eller tillagt',
    'actionlog__expired' => 'avslutad',
    'actionlog__create' => 'skapad',
    'actionlog__delete' => 'borttaget',
    'actionlog__service_stop' => 'stoppad',
    'actionlog__service_restart' => 'omstartad',
    'actionlog__service_start' => 'startad',
    'actionlog__login' => 'inloggad',
    'actionlog__logout' => 'utloggad',
    'actionlog__install' => 'installerad',
    'actionlog__uninstall' => 'avinstallerat',
    'actionlog__reconfigure' => 'omkonfigurerad',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Förfrågan om återställning av lösenord',
    'actionlog__event_admin_update' => 'Uppdaterad administrationsinformation',
    'actionlog__event_admin_preferences_update' => "Administratörspreferenser uppdaterade",
    'actionlog__event_service_restart' => 'Tjänsten har startats om',
    'actionlog__event_service_start' => 'Tjänsten har startats',
    'actionlog__event_service_stop' => 'Tjänsten har stoppats',
    'actionlog__event_ip_address_create' => 'IP-adress har skapats',
    'actionlog__event_ip_address_delete' => 'IP-adresstyp har raderats',
    'actionlog__event_ip_address_update' => 'IP-adresstyp har uppdaterats',
    'actionlog__event_client_create' => 'Kundens kontostatus har skapats',
    'actionlog__event_client_delete' => 'Kundens kontostatus har raderats',
    'actionlog__event_client_update' => 'Kundens konto uppdaterat',
    'actionlog__event_client_status_update' => 'Kundens kontostatus uppdaterad',
    'actionlog__event_client_preferences_update' => "Kundens gränssnittspreferenser uppdaterade",
    'actionlog__event_client_siteapp_added' => "Webbapplikation lagd till kundkontots applikationspool",
    'actionlog__event_client_siteapp_removed' => "Webbapplikation borttagen från kundkontots applikationspool",
    'actionlog__event_domain_limit_size_reached' => 'Diskutrymmets gräns för abonnemanget har nåtts',
    'actionlog__event_domain_limit_traffic_reached' => 'Trafikgräns för abonnemanget har nåtts',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Diskutrymmets gräns för abonnemanget har nåtts',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Trafikgräns för abonnemanget har nåtts',

    'actionlog__domain_limit_database' => 'Databasernas värde för abonnemanget',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MySQL databasvärde för abonnemanget har nåtts',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MySQL databas mjukt värde för abonnemanget har nåtts',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Microsoft SQL serverdatabasvärden för abonnemanget har nåtts',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Microsoft SQL serverdatabas mjuka värden för abonnemanget har nåtts',
    'actionlog__event_plesk_component_upgrade' => 'Plesk-komponenten har uppdaterats',
    'actionlog__event_plesk_component_install' => 'Plesk-komponenten har installerats',
    'actionlog__event_plesk_component_uninstall' => 'Plesk-komponenten har avinstallerats',
    'actionlog__event_domain_create' => 'Standarddomän (den första domänen som lagts till ett abonnemang) etablerad',
    'actionlog__event_domain_delete' => 'Standarddomän (den första domänen som lagts till ett abonnemang) raderad',
    'actionlog__event_domain_update' => 'Standarddomän (den första domänen som lagts till ett abonnemang) uppdaterad',
    'actionlog__event_domain_owner_change' => 'Abonnemangets ägare har ändrats',
    'actionlog__event_domain_plan_change' => 'Serviceplanen för abonnemanget har ändrats',
    'actionlog__event_domain_status_update' => 'Standarddomän, status uppdaterad',
    'actionlog__event_domain_dns_update' => 'Standarddomän, DNS-zon uppdaterad',
    'actionlog__event_subdomain_create' => 'Subdomän av en standarddomän skapad',
    'actionlog__event_subdomain_delete' => 'Subdomän av en standarddomän borttagen',
    'actionlog__event_subdomain_update' => 'Subdomän av en standarddomän uppdaterad',
    'actionlog__event_domain_alias_create' => 'Standarddomän, alias skapat',
    'actionlog__event_domain_alias_delete' => 'Standarddomän, alias borttaget',
    'actionlog__event_domain_alias_update' => 'Standarddomän, alias uppdaterat',
    'actionlog__event_domain_limits_update' => 'Abonnemang gränser uppdaterade',
    'actionlog__event_cp_user_login' => 'Plesk-användare inloggad',
    'actionlog__event_cp_user_logout' => 'Plesk-användare utloggad',
    'actionlog__event_mailname_create' => 'E-postkonto har skapats',
    'actionlog__event_mailname_delete' => 'E-postkonto har raderats',
    'actionlog__event_mailname_update' => 'E-postkonto har uppdaterats',
    'actionlog__event_maillist_create' => 'E-postlista skapad',
    'actionlog__event_maillist_delete' => 'E-postlista raderad',
    'actionlog__event_maillist_update' => 'E-postlista uppdaterad',
    'actionlog__event_phys_hosting_create' => 'Fysisk värdtjänst skapad',
    'actionlog__event_phys_hosting_delete' => 'Fysisk värdtjänst raderad',
    'actionlog__event_phys_hosting_update' => 'Fysisk värdtjänst uppdaterad',
    'actionlog__event_forwarding_create' => 'Standard-värdtjänst eller bildvidarebefordran skapad',
    'actionlog__event_forwarding_delete' => 'Standard-värdtjänst eller bildvidarebefordran raderad',
    'actionlog__event_forwarding_update' => 'Standard-värdtjänst eller bildvidarebefordran uppdaterad',
    'actionlog__event_webuser_create' => 'Webbanvändarkonto skapat',
    'actionlog__event_webuser_delete' => 'Webbanvändarkonto raderat',
    'actionlog__event_webuser_update' => 'Webbanvändarkonto uppdaterat',
    'actionlog__event_siteapp_install' => 'Webbprogram installerat',
    'actionlog__event_siteapp_reconfigure' => 'Webbprogram återkonfigurerat',
    'actionlog__event_siteapp_uninstall' => 'Webbprogram avinstallerat',
    'actionlog__event_license_update' => 'Licensnyckel har uppdaterats',
    'actionlog__event_admin_alias_create' => 'Extra administratörskonto skapat',
    'actionlog__event_admin_alias_delete' => 'Extra administratörskonto raderat',
    'actionlog__event_admin_alias_update' => 'Extra administratörskonto uppdaterat',
    'actionlog__event_ftpuser_create' => 'Extra FTP-konto har skapats',
    'actionlog__event_ftpuser_update' => 'Extra FTP-konto har uppdaterats',
    'actionlog__event_ftpuser_delete' => 'Extra FTP-konto har raderats',
    'actionlog__event_template_domain_create' => "Abonnemangstyp för återförsäljaren skapad",
    'actionlog__event_template_domain_update' => "Abonnemangstyp för återförsäljaren uppdaterad",
    'actionlog__event_template_domain_delete' => "Abonnemangstyp för återförsäljaren raderad",
    'actionlog__event_template_admin_create' => "Abonnemangstyp för administratören skapad",
    'actionlog__event_template_admin_update' => "Abonnemangstyp för administratören uppdaterad",
    'actionlog__event_template_admin_delete' => "Abonnemangstyp för administratören raderad",
    'actionlog__event_database_server_create' => 'Databasserver skapad',
    'actionlog__event_database_server_update' => 'Databasserver uppdaterad',
    'actionlog__event_database_server_delete' => 'Databasserver borttagen',
    'actionlog__event_remote_dns_status_update' => 'Status på DNS-fjärrservern uppdaterad',
    'actionlog__event_session_preferences_update' => 'Sessionens inställningar uppdaterade',
    'actionlog__event_domain_alias_dns_update' => 'Standarddomän, DNS-zon av domänalias uppdaterad',
    'actionlog__event_domain_move' => 'Standarddomänen flyttades till en ny prenumeration',
    'actionlog__event_site_move' => 'Domän flyttades till en ny prenumeration',
    'actionlog__event_site_subdomain_move' => 'Underdomän flyttades till en ny prenumeration',
    'actionlog__event_subdomain_move' => 'Underdomänen i en standarddomän flyttades till en ny prenumeration',
    'actionlog__event_license_expired' => 'Plesk-licensen har gått ut',
    'actionlog__event_database_create' => 'Databas skapad',
    'actionlog__event_database_delete' => 'Databas borttagen',
    'actionlog__event_database_user_create' => 'Databasens användarkonto skapat',
    'actionlog__event_database_user_update' => 'Databasens användarkontoinställningar uppdaterade',
    'actionlog__event_database_user_delete' => 'Databasens användarkonto borttaget',
    'actionlog__event_client_guid_update' => "Kund-GUID uppdaterad",
    'actionlog__event_domain_guid_update' => 'Standarddomän, GUID uppdaterad',
    'actionlog__event_reseller_create' => 'Återförsäljarkonto skapat',
    'actionlog__event_reseller_delete' => 'Återförsäljarkonto raderat',
    'actionlog__event_reseller_update' => 'Återförsäljarens konto uppdaterat',
    'actionlog__event_reseller_guid_update' => 'Återförsäljarens GUID uppdaterad',
    'actionlog__event_reseller_ip_pool_update' => "Återförsäljarens IP-pool uppdaterad",
    'actionlog__event_reseller_limit_size_reached' => 'Diskutrymmets gräns för återförsäljarkontot har nåtts',
    'actionlog__event_reseller_limit_traffic_reached' => 'Trafikgräns för återförsäljarkontot har nåtts',
    'actionlog__event_reseller_limits_update' => 'Återförsäljarens kontogränser uppdaterade',
    'actionlog__event_reseller_permissions_update' => 'Återförsäljarens kontogränser uppdaterade',
    'actionlog__event_reseller_preferences_update' => "Återförsäljarens gränssnittspreferenser uppdaterade",
    'actionlog__event_reseller_siteapp_added' => "Applikation lagd till återförsäljarkontots applikationspool",
    'actionlog__event_reseller_siteapp_removed' => "Applikation borttagen från återförsäljarkontots applikationspool",
    'actionlog__event_reseller_status_update' => 'Återförsäljarens kontostatus uppdaterad',
    'actionlog__event_template_reseller_create' => 'Återförsäljarplan skapat',
    'actionlog__event_template_reseller_delete' => 'Återförsäljarplan raderad',
    'actionlog__event_template_reseller_update' => 'Återförsäljarplan uppdaterad',
    'actionlog__event_health_status_change' => 'Serverns hälsotillstånd ändrades',
    'actionlog__event_siteapp_upgrade' => 'Webbapp uppgraderad',
    'actionlog__event_extension_install' => 'Ändelsen har installerats',
    'actionlog__event_extension_uninstall' => 'Ändelsen har avinstallerats',
    'actionlog__event_extension_upgrade' => 'Ändelsen har uppgraderats',
    'actionlog__event_extension_status_update' => 'Ändelsens status har uppdaterats',
    'actionlog__event_additional_license_expired' => 'Den extra licensen har löpt ut',
    'actionlog__event_hostname_changed' => 'Serverns värdnamn har ändrats',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC har inte installerats på fjärrvärddatorn. Kontakta din serverleverantör för assistans.",
    'rsession_no_account_errmsg' => "Kan inte få tillgång till fjärrservern med dit tkonto. De flesta skälen är att tjänsten för ditt konto inte har aktiverats ännu. Vänta i ett antal minuter och försök sedan igen. Om du träffar på detta fel igen, kontakta systemadministratören.",
    'rsession_no_domain_errmsg' => "Kan inte få tillgång till fjärrtjänsten för denna domän. Den vanligaste orsaken är att tjänsten för denna domän inte har aktiverats ännu. Vänta i ett antal minuter och försök sedan igen. Om du träffar på detta fel igen, kontakta systemadministratören.",
    'rsession_unknown_errmsg' => "Fjärrservern har avvisat försöket att etablera en session. Kontakta din systemadministratör om du behöver hjälp. Felet var: %1",
    'rsession_unknown2_errmsg' => "Okänt fel medan man försökte upprätta en fjärrsession. Mest troligt svarar inte fjärrservern ordentligt eller svarar inte alls. Be din systemadministratör kontrollera felinformationen i webbserverns fellogg.",
    'rsession_no_connect_errmsg' => "Kan inte få tillgång till fjärrtjänsten: anslutningen till fjärrsessionen misslyckades. Kontakta din systemadministratör om du behöver hjälp.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Tillåt överföring till inkommande katalog",
    'anonftp__allow_create_dirs' => 'Tillåt skapande av kataloger i den inkommande katalogen',
    'anonftp__allow_download_incoming' => 'Tillåt nedladdning från den inkommande katalogen',
    'anonftp__display_login' => 'Visa inloggningsmeddelande',
    'anonftp__login_text' => 'Meddelandetext',
    'anonftp__limit_incoming_disk_space' => "Begränsa diskutrymmet i den inkommande katalogen",
    'anonftp__limit_maximum_bandwidth' => "Begränsa nerladdningsbandvidden för denna virtuella FPT-domän",
    'anonftp__limit_maximum_connections' => "Begränsa antalet samtidiga anslutningar",
    'anonftp__unable_init' => "Kan inte initialisera ett anonymt FPT-konto: %1",
    'anonftp__unable_set_quota' => "Kan inte ställa in diskutrymmesgräns för inkommande katalog: %1",
    'anonftp__unable_update' => "Kan inte uppdatera ett anonymt FPT-kontos egenskaper: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-certifikat', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA-certifikatet matchar inte certifikatet",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Inkompatibelt privat nyckel/certifikat-par.",
    'class_sslcertificate__invalid_cert_format' => "Ogiltigt format på certifikat.",
    'class_sslcertificate__invalid_private_key_format' => "Ogiltig format på den privata nyckeln.",
    'class_sslcertificate__prob_invalid_priv_key' => "Troligen är den privata nyckelns format ogiltigt.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Skapa virtuell katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Skapa virtuell katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Skapa en virtuell katalog.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Skapa virtuell katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Skapa virtuell katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Skapa en virtuell katalog.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Skapa katalog',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Skapa katalog',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Skapa en katalog.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Skapa katalog',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Skapa katalog',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Skapa en katalog.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Katalogegenskaper',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Virtuella katalogens egenskaper',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Visa och ändra den virtuella katalogens egenskaper.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Katalogegenskaper',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Virtuella katalogens egenskaper',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Visa och ändra den virtuella katalogens egenskaper.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Katalogens åtkomstbehörigheter',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Katalogens åtkomstbehörigheter',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Ställ in katalogens åtkomstbehörigheter.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Katalogens åtkomstbehörigheter',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Katalogens åtkomstbehörigheter',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Ställ in katalogens åtkomstbehörigheter.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET-inställningar',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'ASP.NET-inställningar för %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Konfigurera ASP.NET-inställningarna för den virtuella katalogen %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET-inställningar',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'ASP.NET-inställningar för %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Konfigurera ASP.NET-inställningarna för den virtuella katalogen %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Ändra version',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Ändra version',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Ändra ASP.Net-versionen som används av den virtuella katalogen %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Ändra version',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Ändra version',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Ändra ASP.Net-versionen som används av den virtuella katalogen %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP-inställningar',
    'ui__client/domain/hosting/web-directories/php__title' => 'PHP-inställningar för %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Konfigurera PHP-inställningarna för den virtuella katalogen %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP-inställningar',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'PHP-inställningar för %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Konfigurera PHP-inställningarna för den virtuella katalogen %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Ta bort',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Ta bort virtuella kataloger',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Ta bort valda virtuella kataloger.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Ta bort',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Ta bort virtuella kataloger',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Ta bort valda virtuella kataloger.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Följande virtuella kataloger kommer att tas bort:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Du måste välja kataloger att ta bort.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Visa listan över registrerade MIME-typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Lägg till MIME-typ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Lägg till en MIME-typ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registrera en ny MIME-typ.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Feldokument',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Feldokument',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Visa och ändra feldokument.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Skydd',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Katalogskydd',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Begränsa åtkomsten till katalogen med lösenordsskydd.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Skydd',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Katalogskydd',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Begränsa åtkomsten till katalogen med lösenordsskydd.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Inställningar',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Visa katalogplats och ange en titel för det skyddade området.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Lägg till användare',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Lägg till ett användarkonto för att ge tillgång till den skyddade katalogen.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'De nya inställningarna har tillämpats.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Användarkontot har lagts till.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Ta bort',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Ta bort användare från den skyddade katalogen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Ta bort användarkonton',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Bekräfta borttagningen av användarkonton.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Användarkonton har tagits bort.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Processen att kontrollera behörigheter påbörjades. Vid slutförandet av kontrollprocessen, skickas en avisering till följande e-postadress: %1', // PFW
    'additional_keys__install_done' => 'Licensnyckelinstallationen påbörjades.',

    // UI
    'ui____done' => 'Operationen har slutförts riktigt.',
    'ui__actionlog__done' => "Förändringarna i åtgärdslogginställningarna har sparats.",
    'ui__admin/extras-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__admin/interface__done' => 'Förändringar i gränssnittsinställningarna för serveradministratören har sparats.',
    'ui__admin/report/layout/delete_multi__done' => 'Valda rapportlayouter har tagits bort.',
    'ui__admin/report/traffic-history__done' => 'Operationen har slutförts riktigt.',
    'ui__admin/report__done' => 'Operationen har slutförts riktigt.',
    'ui__admin-alias/delete_multi__done' => "De valda administratörskontona har tagits bort.",
    'ui__admin-alias/properties__done' => "Extra administratörskontots egenskaper har uppdaterats.",
    'ui__admin-alias/properties_new__done' => "Extra administratörskonto har skapats.",
    'ui__admin-alias/properties_unknown__done' => "Extra administratörskontots egenskaper har uppdaterats.",
    'ui__admin-alias__done' => "Extra administratörskontons information har uppdaterats korrekt.",
    'ui__admin/manage-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__admin/register-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Markerade rapportleveransscheman har tagits bort.',
    'ui__admin/report/layout/auto/properties__done' => 'Rapportleveransschema har uppdaterats.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Rapportleveransschema har skapats.',
    'ui__admin/report/layout/properties__done' => 'Rapportlayout %1 har uppdaterats.',
    'ui__admin/report/layout/properties_new__done' => 'Rapportlayout %1 har skapats.',
    'ui__client/chowner__done' => 'Den nya ägaren till kundkonto %1 har tilldelats.',
    'ui__client/chowner_multi__done' => "De valda användarkontona har överförts till en annan ägare.",
    'ui__client/chowner_multi-select__done' => 'Operationen har slutförts riktigt.',
    'ui__client/chowner_select__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS-certifikategenskaperna har uppdaterats.',
    'ui__client/domain/certificate/properties_new__done' => 'Nya SSL/TLS-certifikat har lagts till. För att det ska fungera, se till att välja den i webbplatsens värdtjänstinställningar (i fliken Webbplatser och domäner> domännamn).',
    'ui__client/domain/certificate__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/certificate_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/check-permissions_multi__done' => 'Behörighetskontrollen för valda domäner har slutförts.', // PFW
    'ui__client/domain/chowner__done' => 'Abonnemanget %1 tillhör redan en annan användare.',
    'ui__client/domain/chowner_multi__done' => 'Abonnemangets ägarskap har ändrats.',
    'ui__client/domain/chowner_multi-select__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/chowner_select__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/dbbackup/create__done' => "Databasen har säkerhetskopierats med framgång.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Databasen har säkerhetskopierats med framgång.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Ägarlös användare har reparerats.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Säkerhetskopior har tagits bort.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Databasinnehållet har återställts.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__client/domain/dbbackup__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__client/domain/delete__done' => "Domänen %1 har tagits bort.",
    'ui__client/domain/delete_multi__done' => "Domänerna har tagits bort.",
    'ui__client/domain/disable__done' => 'Domän %1 har stängts av.',
    'ui__client/domain/disable_multi__done' => 'Valda domäner har stängts av.',
    'ui__client/domain/enable__done' => 'Webbplatsen %1 har aktiverats.',
    'ui__client/domain/enable_multi__done' => 'Valda webbplatser har aktiverats.',
    'ui__client/domain/extras__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Markerade filer och kataloger har kopierats eller flyttats.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Katalogen har skapats.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Filen har skapats.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Filen har uppdaterats.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Filens eller katalogens åtkomstbehörigheter uppdaterades.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Katalogen eller filen har bytt namn.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Markerade filer och kataloger har tagits bort.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Markerade filer och kataloger har tagits bort.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/file-manager__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Inställningar för loggrotering har förändrats.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Inställningar för loggrotering har förändrats.',
    'ui__client/domain/hosting/logs__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/logs_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/performance__done' => 'Värdtjänstens prestandainställningar för webbplats %1 har justerats.',
    'ui__client/domain/hosting/performance_self__done' => 'Värdtjänstens prestandainställningar för din webbplats har justerats.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Webbvärdtjänstens prestandainställningar har justerats.',
    'ui__client/domain/hosting/php__done' => 'PHP-inställningarna har ändrats.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/hosting/setup__done' => 'Värdtjänsten för %1 har konfigurerats.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__client/domain/hosting/tsclient__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/tsclient_self__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/virtual-directories__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET-versionen har ändrats.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'ASP.NET-inställningar för %1 har ändrats.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Den virtuella katalogen skapades på webbplatsen %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Den virtuella katalogen har skapats.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Valda kataloger har tagits bort.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Valda kataloger har tagits bort.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Anpassade feldokument har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Valda MIME-typer har tagits bort', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Ny MIME-typ har registrerats.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Katalogens åtkomstbehörigheter uppdaterades.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Katalogens åtkomstbehörigheter uppdaterades.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP-inställningar för %1 har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'PHP-inställningar för %1 har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Katalogegenskaper har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Katalogegenskaper har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Katalogskyddsinställningarna har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Katalogskyddsinställningarna har uppdaterats.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS-certifikat tillgängligt i online-butiken',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS-certifikat tillgängligt i online-butiken',
    'ui__client/domain/odbc__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/odbc_self__done' => 'Operationen har slutförts riktigt.', // PFW
    'ui__client/domain/properties__done' => "Domänens administratörskonto har ändrats.",
    'ui__client/domain/properties_new__done' => "Domänen %1 skapades.",
    'ui__client/domain/properties_self__done' => "Egenskaperna för din domän har förändrats.",
    'ui__client/domain/register__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/domain/register_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/domain/rename__done' => 'Domännamnet har ändrats.',
    'ui__client/domain/rename_self__done' => "Domännamnets ändring lyckades.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report/ftp-stats__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report/traffic-history__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report/traffic-history_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Webbstatistiksidan öppnades.',
    'ui__client/domain/report/web-stats_self__done' => 'Webbstatistiksidan öppnades.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Webbstatistiksidan öppnades.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Webbstatistiksidan öppnades.',
    'ui__client/domain/report__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/report_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/settings_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/to-client__done' => 'Domänadministratörkonto %1 har omvandlats till ett kundkonto.',
    'ui__client/domain/to-client_multi__done' => 'Domänadministratörkonton har omvandlats till kundkonton.',
    'ui__client/domain/toggle_disable__done' => "Domänen %1 stängdes av.",
    'ui__client/domain/toggle_enable__done' => "Domänen %1 aktiverades.",
    'ui__client/domain/traffic__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/traffic_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/traffic_unknown__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain/web-stats__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain-summary-report__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain-summary-report_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/domain-summary-report_unknown__done' => 'Operationen har slutförts riktigt.',
    'ui__client/extras-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/ipaddress/delete_multi__done' => 'Operationen har slutförts riktigt.',
    'ui__client/ipaddress/properties__done' => 'Operationen har slutförts riktigt.',
    'ui__client/ipaddress/properties_new__done' => 'Operationen har slutförts riktigt.',
    'ui__client/ip-pool/properties__done' => "Kundens %1 IP-pool har uppdaterats.",
    'ui__client/ip-pool/properties_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/limits__done' => "Resursgränser för kund %1 har ändrats.",
    'ui__client/limits_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/logo__done' => 'De nya märkesinställningarna för kunden %1 har tillämpats.',
    'ui__client/logo_reseller__done' => 'Kontrollpanelen nya branding-inställningar har tillämpats.',
    'ui__client/logo_self__done' => 'Branding-inställningar har tillämpats.',
    'ui__client/logo_self-reseller__done' => 'Dina kontrollpanelen branding-inställningar har tillämpats.',
    'ui__client/manage-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/permissions__done' => "Behörigheterna för kund %1 har ändrats.",
    'ui__client/permissions_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/preferences__done' => "Preferenserna för kund %1 har ändrats.",
    'ui__client/preferences_self__done' => "Dina inställningar har ändrats.",
    'ui__client/register-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/register-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__client/report/traffic-history__done' => 'Operationen har slutförts riktigt.',
    'ui__client/report/traffic-history_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/report__done' => 'Operationen har slutförts riktigt.',
    'ui__client/report_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/sessions/delete__done' => 'Operationen har slutförts riktigt.',
    'ui__client/sessions/delete_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/sessions__done' => 'Operationen har slutförts riktigt.',
    'ui__client/sessions_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/skeleton__done' => 'Operationen har slutförts riktigt.',
    'ui__client/skeleton_self__done' => 'Operationen har slutförts riktigt.',
    'ui__client/to-reseller__done' => 'Kundkonto %1 har omvandlats till ett återförsäljarkonto.',
    'ui__client/to-reseller_multi__done' => "De valda kundkontona har omvandlats till återförsäljarkonton.",
    'ui__client/traffic__done' => "Operationen har slutförts riktigt.",
    'ui__client/traffic_unknown__done' => 'Operationen har slutförts riktigt.',
    'ui__cp-access__done' => 'Operationen har slutförts riktigt.',
    'ui__cp-session/properties__done' => 'Operationen har slutförts riktigt.',
    'ui__cp-session__done' => 'Operationen har slutförts riktigt.',
    'ui__ftp-sessions__done' => 'Operationen har slutförts riktigt.',
    'ui__license__done' => 'Operationen har slutförts riktigt.',
    'ui__logo__done' => "Plesk-brandingegenskaper var ändrats.",
    'ui__longtasks/longtask/properties__done' => "Bakgrundsuppgiftsinställningarna har ändrats.",
    'ui__mass-email/delete__done' => "Meddelandemall %1 har tagits bort.", // PFW
    'ui__mass-email/delete_multi__done' => "Meddelandemallar har tagits bort.",  // PFW
    'ui__mass-email/send_main__done' => "Operationen har slutförts riktigt.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Kundkonton har valts korrekt.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Domänadministratörskonton har valts korrekt.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Återförsäljarkonton har valts korrekt.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Ändringar i meddelandemallen för massutskick har sparats.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Meddelandemallen för massutskick har skapats.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Kundkonton för meddelandemallen för massutskick har valts.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Domänadministratörskonton för meddelandemallen för massutskick har valts.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Återförsäljarkonton för meddelandemallen för massutskick har valts.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Meddelandemallen för massutskick har ändrats.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Ogiltiga värden har angetts.', // PFW
    'ui__mass-email__done' => "Operationen har slutförts riktigt.", // PFW
    'ui__mass-mail__done' => "Operationen har slutförts riktigt.", // PFU
    'ui__mass-mail/delete__done' => 'Meddelandemall %1 har tagits bort.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Meddelandemallar har tagits bort.', // PFU
    'ui__mass-mail/properties__done' => 'Mallen %1 har ändrats.', // PFU
    'ui__mass-mail/properties_new__done' => 'Mallen %1 har skapats.', // PFU
    'ui__mass-mail/send__done' => 'Meddelandena har skickats.', // PFU
    'ui__mass-mail/send_new__done' => 'Meddelandena har skickats.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Meddelandena har skickats.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Meddelandena har skickats.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'En ny meddelandemall har skapats.', // PFU
    'ui__mass-mail/template/properties__done' => 'Meddelandemallen har ändrats.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'De nya diskövervakningsinställningarna har tillämpats.', // PFU
    'ui__modules__done' => 'Operationen har slutförts riktigt.',
    'ui__modules__short-title' => 'Anknytningar',
    'ui__modules__title' => 'Anknytningar',
    'ui__reseller/client/chowner_multi__done' => 'De valda kundkontona har överförts till en annan ägare.',
    'ui__reseller/client/chowner_multi-select__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/client/traffic_unknown__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/ftp-sessions_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/limits__done' => "Återförsäljarens resursgränser och resursanvändningspolicier har ändrats.",
    'ui__reseller/limits_readonly-self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/limits_self__done' => 'Dina resursbegränsningar och resursanvändningsriktlinjer har ändrats.',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/permissions__done' => 'Behörigheterna för återförsäljaren %1 har ändrats.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/register-domain__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Markerade rapportleveransscheman har tagits bort.',
    'ui__reseller/report/layout/auto/properties__done' => 'Rapportleveransschema har uppdaterats.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Rapportleveransschema har lagts till.',
    'ui__reseller/report/layout/properties__done' => 'Rapportlayout %1 har ändrats.',
    'ui__reseller/report/layout/properties_new__done' => 'Ny rapportlayout har skapats.',
    'ui__reseller/report/traffic-history__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/report/traffic-history_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/report__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/report_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/sessions/delete__done' => 'Operationen har slutförts riktigt',
    'ui__reseller/sessions/delete_self__done' => 'Operationen har slutförts riktigt',
    'ui__reseller/sessions__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/sessions_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/to-client__done' => 'Återförsäljarkontot %1 har omvandlats till ett kundkonto.',
    'ui__reseller/to-client_multi__done' => "De valda återförsäljarkontona har omvandlats till kundkonton.",
    'ui__reseller/traffic__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/traffic_self__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/traffic_unknown__done' => 'Operationen har slutförts riktigt.',
    'ui__reseller/logo_self__title' => 'Plesk branding',
    'ui__reseller/logo_self__done' => 'Dina Plesk branding-inställningar har tillämpats.',
    'ui__server/aspdotnet__done' => 'De serveromfattande ASP.NET-inställningarna har ändrats.', // PFW
    'ui__server/certificate/default_multi__done' => 'Valt SSL/TLS-certifikat har ställts in för användning för att säkra anslutningarna till nya värdbaserade webbplatser.',
    'ui__server/certificate/delete_multi__done' => 'Valda SSL/TLS-certifikat har tagits bort.',
    'ui__server/certificate/download__done' => 'SSL/TLS-certifikatet har hämtats.',
    'ui__server/certificate/properties__done' => 'SSL/TLS-certifikategenskaperna har uppdaterats.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-certifikat %1 skapat.',
    'ui__server/certificate/setup_multi__done' => 'Valt SSL/TLS-certifikat har konfigurerats för att användas för att säkra anslutningar till Plesk.',
    'ui__server/certificate__done' => 'Operationen har slutförts riktigt.',
    'ui__server/components__done' => 'Operationen har slutförts riktigt.',
    'ui__server/cp-certificate-download__done' => "SSL/TLS-certifikat för Plesk har laddats ned.",
    'ui__server/crontab/properties__done' => 'Schemalagda uppgifter för %1 har ändrats.',
    'ui__server/crontab/task/delete__done' => 'Uppgiften har tagits bort.',
    'ui__server/crontab/task/delete_multi__done' => 'Uppgifterna har tagits bort.',
    'ui__server/crontab/task/properties__done' => 'De schemalagda uppgifterna har uppdaterats.',
    'ui__server/crontab/task/properties_new__done' => 'Den nya uppgiften har schemalagts.',
    'ui__server/crontab/task/toggle_disable__done' => 'Den schemalagda uppgiften %1 har inaktiverats.',
    'ui__server/crontab/task/toggle_enable__done' => 'Den schemalagda uppgiften %1 har aktiverats.',
    'ui__server/crontab__done' => 'Operationen har slutförts riktigt.',
    'ui__server/db__done' => 'Operationen har slutförts riktigt.',
    'ui__server/dns__done' => 'Operationen har slutförts riktigt.',
    'ui__server/ftp-settings__done' => "FTP-inställningarna har ändrats.",
    'ui__server/ip-address/client/delete__done' => "IP-adressen har tagits bort från användarens ' IP-pool.",
    'ui__server/ip-address/client/delete_multi__done' => "IP-adressen har tagits bort från användarens ' IP-pooler.",
    'ui__server/ip-address/client/properties_new__done' => 'IP-adressen har tilldelats användare.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-addressen %1 tilldelades till valda kunder.',
    'ui__server/ip-addresses__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/spam/summary__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/spam__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/virus/summary__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics/virus__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail/statistics__done' => "Operationen har slutförts riktigt.",
    'ui__server/mail__done' => 'E-postinställningarna har ändrats.',
    'ui__server/maillists__done' => 'Operationen har slutförts riktigt.',
    'ui__server/mpc-certificates__done' => 'Online-butikssidan som listar tillgängliga SSL/TLS-certifikat har öppnats.',
    'ui__server/odbc__done' => 'Serveromfattande ODBC-inställningar har ändrats.', // PFW
    'ui__server/pmm__done' => 'Operationen har slutförts riktigt.',
    'ui__server/preferences__done' => "Serverinställningarna har ändrats.",
    'ui__server/register__done' => 'MyPlesk.com-sidan öppnades.',
    'ui__server/resources__done' => 'Operationen har slutförts riktigt.',
    'ui__server/services__done' => 'Operationen har slutförts riktigt.',
    'ui__server/sitebuilder__done' => 'Operationen har slutförts riktigt.',
    'ui__server/skeleton__done' => 'Operationen har slutförts riktigt.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adressen %1 har tagits bort från den serveromfattande svarta listan.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adresserna har tagits bort från den serveromfattande svarta listan.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adresserna har lagts till i den svarta listan.',
    'ui__server/spam-filter/black-list/address__done' => 'Adresserna har lagts till i den svarta listan.',
    'ui__server/spam-filter/black-list__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__server/spam-filter/properties__done' => 'Skräppostfilterinställningarna har ändrats.',
    'ui__server/spam-filter/toggle_disable__done' => 'Skräppostfiltrering har inaktiverats för hela systemet.',
    'ui__server/spam-filter/toggle_enable__done' => 'Skräppostfiltrering har aktiverats för hela systemet.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adressen %1 har tagits bort från den serveromfattande vita listan.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adresserna har tagits bort från den serveromfattande vita listan.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adresserna har lagts till i den vita listan.',
    'ui__server/spam-filter/white-list/address__done' => 'Adresserna har lagts till i den vita listan.',
    'ui__server/spam-filter/white-list__done' => 'Operationen har slutförts riktigt.', // PFU
    'ui__server/spam-filter__done' => 'Operationen har slutförts riktigt.',
    'ui__server/statistics__done' => 'Operationen har slutförts riktigt.',
    'ui__server/time__done' => "Systemets datum och tid har ändrats.",
    'ui__server/tsclient__done' => 'Fjärrskrivbordets session har startat.', // PFW
    'ui__server__done' => "Operationen har slutförts riktigt.",
    'ui__sessions/properties__done' => 'Operationen har slutförts riktigt.',
    'ui__sessions__done' => 'Operationen har slutförts riktigt.',
    'ui__sessions/delete__done' => 'Valda sessioner har raderats.',
    'ui__start-page__done' => 'Operationen har slutförts riktigt.',
    'ui__support__done' => 'Formuläret för hjälpförfrågan har öppnats i ett nytt webbläsarfönster eller ny flik.',
    'ui__ts-sessions__done' => 'Operationen har slutförts riktigt.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Inga filer att överföra.',
    'login_up__access_denied_no_permission' => "Åtkomst nekad.  Du saknar behörighet att hantera värdtjänstinställningarna.",
    'mail__unable_remove_pattern' => "Kan inte ta bort adress från serverns svarta lista: %1", // PFW
    'mail__incorrect_network_format' => 'Felaktigt nätverksformat: %1', // PFW
    'dbbackup__new_remote_backup_available' => 'Denna MS SQL-databasserver fungerar nu på den fjärrstyrda värddatorn. För att kunna importera och exportera databaserna genom att använda originalkoddumpar , måste du specificera korrekta säkerhetskopieringsinställningar för denna databasserver.', // PFW
    'dbbackup__local_to_remote_backup_available' => 'Denna MS SQL-databasserver fungerar nu på den fjärrstyrda värddatorn. Du kan ange inställningar för säkerhetskopiering för denna databasserver på dess %1-sida.', // PFW
    'initconf__unable_change_passwd' => "Kan inte ändra administratörens lösenord: %1",
    'initconf__unable_get_passwd' => 'Kan inte få aktuellt administratörslösenord: %1 failed: %2',
    'initconf__invalid_hostname' => 'Fel i värdnamnet "%1"',
    'initconf__unable_reconfig' => 'Kan inte konfigurera Plesk: reconfig misslyckad: %1',
    'initconf__unable_update_admin' => 'Kan inte uppdatera administratörens kontaktinformation: %1',
    '__refresh' => 'Uppdatera',
    '__dalias_not_exist' => 'Domänaliasen finns inte.',
    '__bug146523_explanation' => 'Tidigare versioner av Plesk tilläts använda upp till 16 tecken för FTP-användarnamn. Denna version av Plesk begränsar det maximala antalet tecken som tillåts i FTP-användarnamn till 15. För att lösa detta problem, reducera FTP-användarnamnets längd till 15 tecken för de respektive FTP-användarnamnen och ändra minst ett tecken i dessa FTP-användarnamn, för att undvika problem med användarnamnskrockar. Vi beklagar de störningar denna förändring kan medföra.',
    'domain__cannot_change_webmail' => 'Kan inte ändra webbmail för domänen: %1',
    'sb_publish_disable_warning' => 'Om du stänger av webbplatsskapandet med Presence Builder, kommer webbplatsen som tidigare skapades i Presence Builder att tas bort och alla uppgifter påp webbplatsen kommer att försvinna. Klicka på OK för att fortsätta.',
    '__sbnet_client_use_sbnet' => "Skapa ett motsvarande användarkonto i Presence Builder",
    'mail_resp_activate' => 'Aktivera autosvar',
    'limitsManger__limit_available_error' => 'Kan inte tillldela begärd mängd resurser ("%%limitName%%"): endast %%available%% är tillgänglig fär ditt konto.',
    'limitsManger__limit_reserved_error' => 'Kan inte tilldela mindre resurser ("%%limitName%%") än som redan används.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Kan inte byta namn på domänen: en virtuell katalog med det specificerade namnet finns redan.',
    'domain_unable_to_rename' => 'Kan inte byta namn på domänen.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Allmänt',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin skräppostfiltrering',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin-inställningar',
    'spamfilter__spamassassin_server_status_legend' =>  "Slå på serveromfattande SpamAssassin-skräppostfiltrering",
    'spamfilter__spamassassin_user_status_legend' => 'Slå på SpamAssassin skräppostfiltrering',
    'spamfilter__greylisting_status_legend' => 'Aktivera ett serveromfattande grå lista-skräppostskydd',
    'spamfilter__personal_settings_not_allowed' => 'Användningen av individuella skräppostfiltreringsinställningar tillåts inte av systemets policy.',
    'spamfilter__required_score' => 'Poängen som ett meddelande måste få för att klassas som skräppost',
    'spamfilter__rewrite_header_subject' => 'Lägg till följande text till början av ämnet för varje meddelande som identifierats som skräppost',
    'spamfilter__use_mailuser_prefs' => 'Applicera individuella inställningar på skräppostfiltrering',
    'spamfilter_addresses__text_hint' => 'Separera flera adresser med ny rad, blanksteg, tab, kommatecken eller semikolon. Det får inte finnas några icke-ASCII-tecken till vänster om @-tecknet. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com). Icke-ASCII-delar av domännamn får inte innehålla jokertecken.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Använd serveromfattande inställningar',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Tillåt personliga inställningar',
    'spamfilter__score_error' => 'Poängen ska inte vara negativ, delen före decimalpunkten måste vara mindre än 100 och den kan omfatta högst två siffror efter decimalpunkten.',
    'spamfilter__rewrite_header_error' => 'Meddelandets ämne kan innehålla alla utskrivbara tecken förutom fyrkant (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Studsa',
    'nonexistent_mail__mode_discard' => 'Släng',
    'nonexistent_mail__mode_catch_addr' => 'Vidarebefordra till e-postadress',
    'nonexistent_mail__mode_catch_ip' => 'Vidarebefordra till IP',
    'nonexistent_mail__bounce_not_supported' => 'Studsläget stöds inte',
    'nonexistent_mail__discard_not_supported' => 'Bortkastningsläget stöds inte',
    'nonexistent_mail__catch_not_supported' => 'Vidarebefordran till e-postadress stöds inte',
    'nonexistent_mail__redirect_not_supported' => 'Vidarebefordran till IP stöds inte',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-adressen kopplar till localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Eftersom funktionen för kontroll av utgående post är på, måste postadressen %1 för obefintliga mottagare tillhöra vald domän. Om så inte sker, kommer policyn "Avvisa" att tillämpas i stället för vidarebefordran.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Eftersom kontrollen för utgående post är på, ska e-postadressen som specificerats för vidarebefordran av e-post (%1) tillhöra den valda domänen. Om den inte gör det, kommer meddelanden som skickas till denna adress inte att ränkas i kontrollen för utgående e-post.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // additional keys
    'additional_keys__select_to_install' => 'Inga nycklar valdes. Markera vilka nycklar du vill installera',
    'additional_key_update__title' => "Uppdaterar ytterligare nyckel",
    'additional_key_update__legend' => "Status för uppdatering av ytterligare nyckel",
    'additional_key_update__new_key' => "Extra nyckelegenskaper",
    'bt_additional_key_install' => "Installera nyckel",
    'b_additional_key_install' => 'Klicka för att installera den aktuella licensnyckeln.',
    'bt_additional_key_update' => "Återhämta extranyckel",
    'bt_additional_key_revert' => "Återskapa nyckel",
    'b_additional_key_upload' => 'Ladda upp en ny licensnyckel.',
    'b_additional_key_download' => 'Ladda ner den aktuella licensnyckeln.',
    'b_additional_key_remove' => 'Ta bort den aktuella licensnyckeln.',
    'b_additionalkeyslist_install' => 'Installera valda licensnycklar',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Det finns inga extra administratörskonton tillgängliga.', // PFW
    'ui__client/domain/certificate__none-available' => 'Kunden har inga SSL/TLS-certifikat.',
    'ui__client/domain/certificate__none-available__1' => 'Kunden har inga domäner med SSL/TLS-certifikat.',
    'ui__client/domain/certificate__none-available__2' => 'Domänen har inget SSL/TLS-certifikat.',
    'ui__reseller/client__none-available' => 'Det finns inga återförsäljare med kunder.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Du behöver välja IP-adresserna du vill ta bort från IP-poolen.',
    'ui__reseller/client/chowner__empty_selection' => 'Du måste välja de kundkonton du vill tilldela till en ny ägare.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Du behöver välja återförsäljarkonton från vilkas IP-pooler du vill återkalla en IP-adress.',
    'ui__server/crontab/task/delete__empty_selection' => 'Du måste välja uppgiften som du vill avbryta.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'PHP-stödet har stängts av för denna webbplats.',
    'phosting__aspdotnet_not_enabled' => 'ASP-NET-stödet har stängts av för denna webbplats.',
    'phosting__php_forced_by_site_isolation' => 'Det går inte att ändra PHP-inställningarna: behörighet att åsidosätta den serveromfattande säkerhetsprincipen har inte getts.',
    'phosting__option_forced_by_site_isolation' => 'Det går inte att ändra %1-inställningarna: behörighet att åsidosätta den serveromfattande säkerhetsprincipen har inte getts.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__python_disabled_by_vps_optimized' => 'Python är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi är inaktiverat eftersom Plesk körs i VPS-optimerat läge.',
    'phosting__php_handler_id_not_registered' => 'PHP-hanteraren är inte tillåten i webbplatsens isoleringsinställningar. Standard-PHP-hanteraren kommer att användas.',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP-hanteraren (FPM-applikation som servas av nginx) är inte tillåten i webbplatsens isoleringsinställningar. Standard-PHP-hanteraren kommer att användas.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Visa listan över IP-adresser',
    'ui__client/ipaddress/properties_readonly__title' => 'Visa listan över IP-adresser',
    'ui__client/ipaddress/properties_readonly__description' => 'Visa listan över IP-adresser som är tillgängliga för denna användare.',
    'ui__server/certificate__short-title' => 'SSL/TLS-certifikat',
    'ui__server/certificate__title' => 'SSL/TLS-certifikat',
    'ui__server/certificate__description' => 'Visa och hantera SSL/TLS-certifikat.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Ta bort MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Ta bort MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Ta bort valda MIME-typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Lägg till MIME-typ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Lägg till MIME-typ',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registrera en MIME-typ.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Ta bort IP-adresser',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Markera IP-adresser du vill ta bort från IP-poolen för kund %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Skapa fil',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Skapa fil',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Skapa en fil.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Skapa mapp',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Skapa mapp',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Skapa en mapp.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Redigera fil eller mapp',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Redigera fil eller mapp',
    'ui__client/domain/hosting/file-manager/edit__description' => 'redugera den markerade filen eller mappen.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Byt namn på fil eller mapp',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Byt namn på fil eller mapp',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Byter namn på den markerade filen eller mappen.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Ändra behörigheter',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Ändra behörigheter',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Ändra åtkomstbehörigheter för en fil eller mapp.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Ta bort fil eller mapp',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Ta bort fil eller mapp',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Ta bort denna fil eller mapp.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Ta bort fil eller mapp',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Ta bort fil eller mapp',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Ta bort denna fil eller mapp.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Kopiera eller flytta fil eller katalog',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Kopiera eller flytta fil eller katalog',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Kopiera eller flytta markerade filer eller kataloger.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Visa fil',
    'ui__client/domain/hosting/file-manager/view__title' => 'Visa fil',
    'ui__client/domain/hosting/file-manager/view__description' => 'Visa vald fil.',

    'ui__client/ipaddress__short-title' => 'IP-adress',
    'ui__client/ipaddress__title' => 'IP-adress',
    'ui__client/ipaddress__description' => 'Visa information om IP-adress.',
    'ui__server/ip-address__short-title' => 'IP-adress',
    'ui__server/ip-address__title' => 'IP-adress',
    'ui__server/ip-address__description' => 'Visa information om IP-adress.',
    'ui__client/domain/hosting/setup__short-title' => 'Webbhostinginställningar',
    'ui__client/domain/hosting/setup__title' => 'Webbhostinginställningar',
    'ui__client/domain/hosting/setup__description' => 'Ställ in webbvärdtjänst inställningar för webbplatsen %1.',
    'ui__reseller/client/chowner_multi__description' => 'Välj ny ägare för valda kundkonton.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME-typ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MME-typens egenskaper', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Visa egenskaperna för MIME-typen.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Feldokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Feldokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Feldokumentegenskaper.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Ta bort den valda rapportlayouten.',
    'b_resellerreportslist_search' => 'Ange ett sökmönster och klicka för att söka rapportlayouter.',
    'b_resellerreportslist_show_all' => 'Visa alla tillgängliga rapportlayouter.',

    'l_resellerreportslist_auto' => 'Sortera rapportlayouter efter leveransautomation.',
    'l_resellerreportslist_clients' => 'Sortera rapportlayouterna genom information om kunderna.',
    'l_resellerreportslist_domains' => 'Sortera rapportlayouter efter närvaro av information om domäner.',
    'l_resellerreportslist_general' => 'Sortera rapportlayouter efter närvaro av allmän information.',
    'l_resellerreportslist_name' => 'Sortera rapportlayouter efter rapportnamn.',
    'l_resellerreportslist_personal_domains' => 'Sortera rapportlayouter efter förekomst av information om personliga domäner.',

    'b_adminreportslist_remove' => 'Ta bort den valda rapportlayouten.',
    'b_adminreportslist_search' => 'Ange ett sökmönster och klicka för att söka rapportlayouter.',
    'b_adminreportslist_show_all' => 'Visa alla tillgängliga rapportlayouter.',

    'l_adminreportslist_auto' => 'Sortera rapportlayouter efter leveransautomation.',
    'l_adminreportslist_clients' => 'Sortera rapportlayouterna genom information om kunderna.',
    'l_adminreportslist_domains' => 'Sortera rapportlayouter efter närvaro av information om domäner.',
    'l_adminreportslist_general' => 'Sortera rapportlayouter efter närvaro av allmän information.',
    'l_adminreportslist_name' => 'Sortera rapportlayouter efter rapportnamn.',
    'l_adminreportslist_personal_clients' => 'Sortera rapportlayouterna genom information om dina egna kunder.',
    'l_adminreportslist_personal_domains' => 'Sortera rapportlayouter efter närvaro av information om  dina egna domäner.',
    'l_adminreportslist_resellers' => 'Sortera rapportlayouterna genom information om återförsäljarna.',

    'b_clientsonlylist_remove' => 'Ta bort valda kundkonton.',
    'b_clientsonlylist_search' => 'Ange sökmönster och klicka för att hitta kundkonton.',
    'b_clientsonlylist_show_all' => 'Visa alla kundkonton.',
    'l_clientsonlylist_cname' => 'Sortera kundkonton efter företagsnamn.',
    'l_clientsonlylist_date' => 'Sortera kundkonton efter datum för skapande.',
    'l_clientsonlylist_domains' => 'Sortera kundkonton efter antalet domäner.',
    'l_clientsonlylist_name' => 'Sortera kundkonton efter namn.',
    'l_clientsonlylist_owner' => 'Sortera kundkonton efter ägare.',
    'l_clientsonlylist_type' => 'Sortera kundkonton efter typ.',

    'b_get_password_cancel' => 'Återgå till föregående skärm utan att skicka e-postmeddelande.',
    'b_get_password_send' => 'Klicka på OK för att skicka ett meddelande om återställning av lösenordet till e-postadressen som registrerats i systemet.',



    'b_personaltrafficlist_search' => 'Ange ett sökmönster och klicka för att hitta domäner.',
    'b_personaltrafficlist_show_all' => 'Visa alla domäner.',

    'b_back' => 'Gå tillbaka till den föregående sidan.',
    'b_next' => 'Gå till nästa sida.',

    'b_dnsnstemplatelist_remove' => 'Ta bort de valda namnservrarna.',
    'b_dnsnstemplatelist_search' => 'Ange ett sökmönster och klicka för att hitta namnservrar.',
    'b_dnsnstemplatelist_show_all' => 'Visa alla namnservrar.',

    'l_dnsnstemplatelist_ns' => 'Sortera DNS-malluppgifter efter namnserver.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Generera säkra länkar till filer och mappar',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Aktivera offentliga filer',
    'cu__serverfilesharing_fsPublicFolder' => 'Mapp för lagring av publika filer',
    'cu__serverfilesharing_fsPublicUrl' => 'URL för besöksåtkomst till offentliga filer',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Aktivera lösenordsskydd av publika filer',
    'cu__serverfilesharing_fsPartnerFolder' => 'Mapp för lösenordsskyddad fillagring',
    'cu__serverfilesharing_fsPartnersLogin' => 'Användarnamn för filåtkomst',
    'cu__serverfilesharing_fsPartnersPassword' => 'Lösenord för filåtkomst',
    'cu__serverfilesharing_fsDomain' => 'Webbmapprot-URL Domännamn',
    'cu__serverfilesharing_fsPrefix' => 'Webbmapprot-URL Prefix',
    'cu__serverfilesharing_commandUpdate' => 'Uppdatera fildelningsinställningar',
    'cu__serverfilesharing_commandInfo' => 'Visa aktuella fildelningsinställningar',
    'server_preferences_include_admin_dumps_into_client_usage' => 'säkerhetskopior skapade av administratören',
    'server_preferences__forbid_subscription_rename' => 'Förbjud kunder och återförsäljare från att ändra sina huvudsakliga domännamn',
    'subscription_rename_is_forbidden' => 'Namnbyte på abonnemang tillåtes inte av den serveromfattande policyn.',
    'server_preferences__allow_sys_user_rename' => 'Kunder kan ändra namnet på deras systemanvändare.',
    'server_preferences__allow_sys_user_rename_false' => 'Alltid',
    'server_preferences__allow_sys_user_rename_true' => 'Bara om behörighet för hantering av värdtjänsten ges',
    'server_preferences__allow_sys_user_rename_forced' => 'Aldrig',
    'server_preferences__preferred_domain' => 'Favoritdomän för webbplatser',
    'server_preferences__preferred_domain_none' => 'Ingen',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'Anonymisera IP-adresser',
    'server_preferences__anonymize_ips_text' => 'Anonymisera IP-adresser under loggrotationen och insamling av webbstatistik',
    'server_preferences__anonymize_ips_description' => 'Scriptet efter rotationen ersätter den sista gruppen på åtta IPv4 adresser i roterade loggfiler med "0" före arkiveringen. I IPv6-adresser ersätter skriptet sista delen av adressen (två oktetter efter sista kolonet) med "0000" (i hela formen) eller "0" (i kort form)',
    'server_preferences__logrotate' => 'Loggrotation',
    'server_preferences__logrotate_force' => 'Forcera daglig loggrotation för alla domäner',
    'server_preferences__logrotate_period' => 'Möjliggör lagring av webbplatsens loggfiler för',
    'server_preferences__logrotate_period_days' => 'dagar',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Hantera schemalagda uppgifter på servern',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Välj systemanvändaren vars schemalagda uppgifter du vill hantera.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Schemalagd aktivitet %1',
    'ui__server/crontab/task__description' => 'Visa egenskaperna för den schemalagda uppgiften %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Systemanvändare',
    'ui__server/crontab_unknown__title' => 'Systemanvändare',
    'ui__server/crontab_unknown__description' => 'Systemanvändare som kan vara ägare till schemalagda uppgifter.',


    'ui__server/crontab__none-available' => 'Du har inga systemanvändarkonton.',
    'ui__server/crontab_readonly-unknown__description' => 'Visa schemalagda aktiviteter.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Schemalagda aktiviteter',
    'ui__server/crontab_readonly-unknown__title' => 'Visa schemalagda aktiviteter',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Visa schemalagda aktiviteter.',
    'ui__server/crontab_readonly__description' => 'Visa schemalagda uppgifter för %1.',
    'ui__server/crontab_readonly__short-title' => 'Schemalagd aktivitet för %1',
    'ui__server/crontab_readonly__title' => 'Visa schemalagda uppgifter för %1',
    'ui__server/crontab_unknown__wizard-title' => 'Hantera schemalagda aktiviteter.',

    'ui__server/crontab/properties__description' => 'Redigera schemalagda uppgifter för %1.',

    'ui__server/crontab/properties__short-title' => 'Inställningar',
    'ui__server/crontab/properties__title' => 'Redigera schemalagda uppgifter för %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Visa schemalagda aktiviteter.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Inställningar',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Visa schemalagda aktiviteter',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Visa schemalagda aktiviteter.',
    'ui__server/crontab/properties_readonly__description' => 'Visa schemalagda uppgifter för %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Inställningar',
    'ui__server/crontab/properties_readonly__title' => 'Visa schemalagda uppgifter för %1',
    'ui__server/crontab/properties_unknown__description' => 'Redigera schemalagda aktiviteter.',
    'ui__server/crontab/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/properties_unknown__title' => 'Redigera schemalagda aktiviteter',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Redigera schemalagda aktiviteter.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Välj systemanvändaren vars aktiviteter du vill se.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Markera systemanvändare vars aktiviteter du vill ändra.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klicka på Slutför för att tillämpa ändringarna och avsluta guiden.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klicka på Slutför för att avsluta guiden.',

    'ui__server/crontab/task__none-available' => 'Du har inga schemalagda uppgifter.',
    'ui__server/crontab/task__none-available__2' => 'Systemanvändare %1 har inte några schemalagda uppgifter.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Schemalagda aktiviteter.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Aktiviteter',
    'ui__server/crontab/task_readonly-unknown__title' => 'Schemalagda aktiviteter',

    'ui__server/crontab/task/delete__description' => 'Ta bort den schemalagda uppgiften %1',

    'ui__server/crontab/task/delete__short-title' => 'Ta bort',
    'ui__server/crontab/task/delete__title' => 'Ta bort den schemalagda uppgiften %1',
    'ui__server/crontab/task/delete_multi__description' => 'Ta bort schemalagda aktiviteter.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Ta bort',
    'ui__server/crontab/task/delete_multi__title' => 'Ta bort schemalagda aktiviteter',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Ta bort schemalagda aktiviteter.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Välj systemanvändaren vars aktiviteter du vill ta bort.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Markera vilka aktiviteter du vill ta bort.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Bekräfta borttagning av uppgiften genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',
    'ui__server/crontab/task/delete_unknown__description' => 'Ta bort en schemalagd aktivitet.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Ta bort',
    'ui__server/crontab/task/delete_unknown__title' => 'Ta bort en schemalagd aktivitet',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Ta bort en schemalagd aktivitet.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Välj systemanvändaren vars aktivitet du vill ta bort.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Markera vilken aktivitet du vill ta bort.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Bekräfta borttagning av uppgiften genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',

    'ui__server/crontab/task/properties__description' => 'Redigera schemalagda aktiviteter.',

    'ui__server/crontab/task/properties__short-title' => 'Redigera uppgiften %1',
    'ui__server/crontab/task/properties__title' => 'Redigera schemalagda aktiviteter',
    'ui__server/crontab/task/properties_new__description' => 'Skapa schemalagda uppgifter för %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Lägg till uppgift',
    'ui__server/crontab/task/properties_new__title' => 'Skapa schemalagda uppgifter för %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Skapa en schemalagd aktivitet.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Välj systemanvändare för vilken du vill skapa den schemalagda uppgiften.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klicka på Slutför för att tillämpa ändringarna och avsluta guiden.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Visa de schemalagda uppgifterna.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Visa de schemalagda uppgifterna',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Visa de schemalagda uppgifterna.',
    'ui__server/crontab/task/properties_readonly__description' => 'Visa schemalagda aktiviteter.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Visa aktivitet %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Visa schemalagda aktiviteter',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Skapa schemalagda aktiviteter.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Lägg till uppgift',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Skapa schemalagda aktiviteter',
    'ui__server/crontab/task/properties_unknown__description' => 'Redigera schemalagda aktiviteter.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/task/properties_unknown__title' => 'Redigera schemalagda aktiviteter',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Redigera schemalagda aktiviteter.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Välj systemanvändaren vars aktiviteter du vill se.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Markera systemanvändare vars aktiviteter du vill ändra.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Välj den schemalagda uppgiften.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Markera vilken schemalagd aktivitet du vill ändra.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klicka på Slutför för att tillämpa ändringarna och avsluta guiden.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klicka på Slutför för att avsluta guiden.',

    'ui__server/crontab/task/toggle_disable__description' => 'Inaktivera den schemalagda uppgiften %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Inaktivera',
    'ui__server/crontab/task/toggle_disable__title' => 'Inaktivera den schemalagda uppgiften %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Aktivera den schemalagda uppgiften %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Aktivera',
    'ui__server/crontab/task/toggle_enable__title' => 'Aktivera den schemalagda uppgiften %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Aktivera eller inaktivera schemalagda uppgifter.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktivera eller inaktivera',
    'ui__server/crontab/task/toggle_unknown__title' => 'Aktivera eller inaktivera schemalagda uppgifter',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Aktivera eller inaktivera schemalagda uppgifter',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Markera systemets användarkonto vars aktiviteter du vill aktivera eller inaktivera.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Markera vilken aktivitet du vill aktivera eller inaktivera.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Kund-konton', // not used on HP?
    'ui__client_unknown__title' => 'Kund-konton', // not used on HP?
    'ui__client_unknown__description' => 'Hantera kundkonton.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Stäng av domän', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Stäng av domän', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Stäng av en domän.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktivera domän', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktivera domän', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktivera en domän.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Tilldela ny ägare för kundkonton',
    'ui__client/chowner_multi-select__short-title' => 'Tilldela ny ägare',
    'ui__client/chowner_multi-select__description' => 'Tilldela en ny ägare för valda kundkonton.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Välj mapp',
    'ftp__management_domain' => "FTP-konton under domänen %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-konton",
    'ftp__user_name' => "FTP-kontonamnet",
    'ftp__user_home' => "Hemkatalog",
    'ftp__invalid_path' => "En ogiltig sökväg har angetts",
    'ftp__physical_path_not_exist' => "Fysisk sökväg finns inte",
    'i_ftp_ses_sub_user' => 'FTP-kontosession.',
    '__new_passwd' => "Nytt %1 lösenord",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Kan inte konfigurera en webbserver i värddatorn <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Kan inte generera webbserverns konfigurationsfil i serverdatorn <%%host%%> på grund av följande fel:\n\n%%error%%\n\nFörsök lösa felen i webbserverns konfigurationsmallar och generera filen igen.",

    'apacheConfigurationMessageAdminTitle' => 'Generering från webbserverkonfiguration misslyckades',
    'apacheConfigurationMessageClientTitle' => 'Varning',

    'apacheConfigurationFailedAdminHomeMessage' => 'Den nya konfigurationsfilen skapades inte på grund av fel i konfigurationsmallarna. Ett detaljerat felmeddelande skickades till din e-post, så kontrollera meddelandet, åtgärda felen och klicka på %1 för att försöka generera konfigurationen igen.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'här', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Den nya konfigurationen för domän %1 skapades inte på grund av fel i konfigurationsmallarna. Ett detaljerat felmeddelande skickades till din e-post, så kontrollera meddelandet, åtgärda felen och klicka på %2 för att försöka generera konfigurationen igen.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'här', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Webbserverkonfigurationen för domänen %1 kan vara inkonsekvent. Kontakta serveradministratören för att lösa detta problem.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Den nya konfigurationen för en del domäner skapades inte på grund av fel i konfigurationsmallarna. Ett detaljerat felmeddelande skickades till din e-post, så kontrollera meddelandet, åtgärda felen och klicka på %1 för att försöka generera konfigurationen igen.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'här', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Webbserverkonfigurationen för vissa av dina domäner kan vara inkonsekvent. Kontakta serveradministratören för att lösa detta problem.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Anpassade feldokument",
    'dom_pref__webusers_script' => "Låt webbanvändare använda skript",
    '__seoRedirect' => 'Konfigurera den prioriterade domänen som',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Ingen',

    '__sites' => 'Domäner',
    'domain_plan__perm_denied_manage_phosting' => 'Du saknar behörighet att hantera värdtjänstinställningarna.',
    '__owned_by_client' => 'ägs av kunden',
    'ui__client/permissions_readonly__description' => "Visa åtgärderna som kunden %1 kan utföra i Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'Kunderna kommer inte att kunna uppsäga abonnemanget från sina aktuella abonnemangstyper.',
    'backup__restore__object_client_template' => 'Kundmall',
    '__template_name' => 'Namn på servicenplan',
    'template__not_exists' => 'Det finns ingen sådan tjänsteplan',
    'template__exists' => 'En plan med namnet %1 existerar redan.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'Kunden har domäner på abonnemang i %1:s abonnemangstyper.',
    'clientOwnerChanger__ip_not_in_pool' => 'Den specificerade IP-adressen finns inte i återförsäljarens pool.',

    //// Change owner of subscription
    'chown__select_title' => "Markera Ny Abonnent",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Välj en ny ägare för de markerade abonnemang och klicka på Nästa >>.',
    'domains__client_info' => "%1 abonnemang, %2 aktiva abonnemang, %3 använt diskutrymme, %4 använd trafik",
    '__possible_owners' => 'Möjliga nya ägare av abonnemang',

    'clients_list__filter_owner__filter_title' => 'Leverantör',
    'clients_list__filter_owner_any' => 'Alla användare',
    'clients_list__filter_owner_my' => 'Endast mina abonnenter',
    'clients_list__filter_owner_name__filter_title' => 'Leverantörens namn',

    '__owner' => "Leverantör",
    'l_clientslist_owner' => 'Sortera användarkonton efter leverantör.',
    'l_clientslist_date' => 'Sortera användarkonton efter datum för skapande.',
    'l_clientslist_name' => 'Sortera användarkonton efter namn.',
    'l_clientslist_domains' => 'Sortera användarkonton efter domäner.',
    'l_clientslist_cname' => 'Sortera användarkonton efter företagsnamn.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Tilldela om markerade abonnemang',
    'chown__check_title' => 'Ändra abonnent',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klicka på Slutför för att slutföra återtilldelningen. När det är klart, kommer de valda abonnemangen att tilldelas den nya ägaren. Leverantören kommer att ändras till den nya leverantören och de kommer att lösas från sina tjänsteplaner och bli 'Anpassade'.",

    'chown__error_check' => 'Några problem hittades när du försökte distribuera några av abonnemangen till en ny ägare.',
    'domain_chown_subscription_will_be_anonymous' => "Abonnemang kommer att frigöras från de aktuella abonnemanplanerna och bli 'Anpassade'.",
    'chown__error_domains_exclude' => "Några problem hittades när du försökte distribuera några av abonnemangen till en ny ägare. Dessa abonnemang är markerade.",
    'chown__ip_not_in_client_pool' => "IP-adressen som är associerad med detta abonnemang har inte lagts till IP-poolen för den nya ägaren.",
    'chown__already_owned_by_client' => "Detta abonnemang tillhör redan denna användare.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Skyddad katalog /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Skyddad katalog /%1-hantering',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Skapa en skyddad katalog under webbplatsen %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Lägg till Skyddad katalog',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Skapa en skyddad katalog.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Den skyddade katalogen /%1 har skapats korrekt.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Inställningar för den skyddade katalogen /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Kataloginställningar',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Ändra plats, namn och områdestitel för den skyddade katalogen.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Skyddade kataloginställningar har förändrats.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Bekräftelse av borttagande',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Ta bort skydd',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Ta bort skyddet från de valda katalogerna.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Välj en katalog som du vill ta bort skyddet från.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Denna åtgärd kommer att resultera i att skyddet tas bort från katalogerna. Katalogerna blir fritt åtkomliga för internetanvändare.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Skyddet har avlägsnats från de valda katalogerna.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Lägg till en användare',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Lägg till en användare',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Ställ in ett användarkonto för åtkomst till den skyddade katalogen %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Användarkontot för tillgång till den skyddade katalogen har skapats.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Användarens inloggningsuppgifter har sparats.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Borttagning av skyddad katalog-användare',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Markera vilka användare du vill ta bort.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Ta bort',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Ta bort kataloganvändare.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Följande användare av skyddad katalog kommer att tas bort:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'De valda användarkontona har tagits bort.',

    '__redirect_hint' => 'Du omdirigeras till den nya adressen om 15 sekunder... Om du inte automatiskt kommer till den nya platsen, aktivera då javascript eller klicka på hyperlänken %%link%%.',

    'backup__restore__object_maillist' => 'E-postlista',
    'backup__restore__object_site' => 'Plats',
    'backup__restore__object_user' => 'Användare',
    'backup__restore__object_role' => 'Roll',

    'limit__name_max_site' => 'platser',

    'iis_pool__unable_rename_client' => "Kan inte byta namn på IIS programpool: %1",

    'anonftp__is_not_supported_for_addon_domains' => 'Den anonyma FPT-tjänsten stöds endast för huvuddomänen i abonnemanget.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Den anonyma FPT-tjänsten stöds endast för huvuddomänen i prenumerationen.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/månad',
    '__tb_month' => 'TB/månad',

    '__customers' => 'Kunder',
    '__customer_name' => 'Kundens namn',
    '__customer_total' => 'Kundtotal',
    '__site' => 'Plats',
    '__def_site' => 'Standardplats',
    '__subscription_name' => 'Abonnemangsnamn',
    '__subscription_name_powerUser' => 'Abonnemangsnamn',

    'limit__units_max_traffic_suffix' => '/månad',

    'dom_pref__discard' => "Avvisa",

    'mail__pattern_already_exists' => 'Mönster "%1" finns redan på svarta listan.',

    '__not_supported' => 'Stöds inte',

    'plesk_key__sitebuilder' => 'Webbplatser publicerade med Presence Builder',
    'limit__name_max_site_builder' => 'Webbplatser publicerade med Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Support för webbplatser på flera språk i Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Dataöverföringsstatistik för domän %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Dataöverföringsstatistik för domän %1',
    'ui__client/domain/traffic-hosting#list__title' => "Dataöverföring via tjänster",

    'login_up__access_denied_no_subscriptions' => "Åtkomst nekad.  Det finns inga abonnemang tillgängliga för detta konto.",

    'interval__day' => '%1 dag(ar)',
    'interval__hour' => '%1 timma(r)',
    'interval__minute' => '%1 minut(er)',
    'interval__second' => '%1 sekund(er)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Du försöker använda en licensnyckel skapad för en annan version av Plesk. Kontakta Plesk säljare för att erhålla en riktig licensnyckel.',
    //Standalone or virtualization
    'virtualization_any' => "Fysisk server eller någon virtualiseringslösning",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-server",
    'plesk_key__virtualization' => "Gäller för följande miljöer:",
    'plesk_key__virtualization_only_key' => 'Licensnyckeln är avsedd endast för användning med Plesk som fungerar i en %1 virtuell miljö.',
    'plesk_key__virtualizations_only_key' => 'Licensnyckeln är avsedd endast för användning med Plesk som fungerar i följande virtuella miljöer: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Det är förbjudet att använda specialanpassade språkpaket.',
    'plesk_key__allowed-locales' => 'Tillgängliga språk',
    'plesk_key__allowed-locales-any' => 'Alla språk',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin-katalogen finns i',
    '_cgi_bin_mode_webspace' => 'rotkatalogen för prenumerationen',
    '_cgi_bin_mode_www_root' => 'dokumentroten för denna domän',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Lägg till en OBDC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Lägg till ODBC-datakälla.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Ta bort',
    'ui__server/odbc/dsn/delete_multi__title' => 'Bekräftelse av borttagande',
    'ui__server/odbc/dsn/delete_multi__description' => 'Ta bort markerade ODBC DSN-datakällor.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Följande ODBC DSN-anslutningar kommer att tas bort',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Inga ODBC DSN-anslutningar markerade.',
    'ui__server/odbc/dsn/delete_multi__done' => 'De markerade datakällorna har tagits bort.',
    'ui__server/odbc/dsn__title' => 'ODBC DSN-anslutning %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Lägg till en OBDC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Lägg till ODBC-datakälla.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Ta bort',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Bekräftelse av borttagande',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Ta bort markerade ODBC DSN-datakällor.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Följande ODBC DSN-anslutningar kommer att tas bort',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Inga ODBC DSN-anslutningar markerade.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'De markerade datakällorna har tagits bort.',
    'ui__client/domain/odbc/dsn__title' => 'ODBC DSN-anslutning %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Prioritet',
    'custom_button__place' => 'Plats',
    'custom_button__place_navigation' => 'Vanlig tillgång',
    'custom_button__place_admin' => 'Administratörens startsida',
    'custom_button__place_admin-settings' => 'Administratörssidan Verktyg & inställningar',
    'custom_button__place_reseller' => "Återförsäljarens startsida",
    'custom_button__place_reseller-settings' => 'Sida med återförsäljarens verktyg och hjälpprogram',
    'custom_button__place_client' => 'Kundens startsida',
    'custom_button__place_domain' => "Abonnemangsida för webbplatser och domäner",
    'custom_button__place_domain_powerUser' => "Abonnemangsida för webbplatser och domäner",
    'custom_button__place_domain-properties' => 'Webbplats verktyg',
    'custom_button__private' => 'Visa endast för mig',
    'custom_button__image' => 'Bakgrundsbild',
    'custom_button__conhelp' => "Knappbeskrivningstext",
    'custom_button__edit' => "Inställningar för en länk till en extra tjänst",
    'custom_button__include_client_cname' => "Inkludera kundens företagsnamn",
    'custom_button__include_client_email' => "Inkludera kundens e-post",
    'custom_button__include_client_id' => "Inkludera kund-ID",
    'custom_button__include_client_pname' => "Inkludera kundens kontaktnamn",
    'custom_button__include_domain_id' => "Inkludera abonnemang ID, domän ID och domänalias ID",
    'custom_button__include_domain_id_powerUser' => "Inkludera abonnemang ID, domän ID och domänalias ID",

    'custom_button__include_domain_name' => "Inkludera primärt domännamn",
    'custom_button__include_ftp_user' => "Inkludera FTP-användarnamn",
    'custom_button__include_ftp_pass' => "Inkludera FTP-lösenord",
    'custom_button__internal_open' => "Öppna URL:en i Plesk",
    'custom_button__text' => "Knappetikett",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'FIlen är inte en bildfil.',
    'custom_button__big_image' => 'Filstorleken ska inte överskrida 100 KB.',
    'custom_button__failed_copy_image' => 'Kan inte kopiera den filen: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Kan inte återställa en icke-Power-User-säkerhetskopia i Power User-vyn.',
    '__unknown_network_interface' => 'Okänt nätverksgränssnitt',

    'init_conf__ip_address' => 'IP-adress',

    //Confirmation page
    'bt_confirm' => 'Bekräfta',
    'b_confirm' => 'Bekräfta ägarskap av dina siter.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Denna Plesk-instans är installerad i en Virtuozzo container. De aktuella offline-hanteringsinställningarna för Container gör Plesk otillgängligt.',
    '__vzpp_integration_contact_admin' => 'Om du har tillräckliga befogenheter att ändra Container-konfigurationen, %1. Annars ska du kontakta din leverantör för att göra det.',
    '__vzpp_integration_help_link' => 'ändra offline-hanteringsinställningar',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Inställningarna för den dedikerade IIS-programpoolen ställs in enligt denserveromfattande säkerhetspolicyn (webbplatsens isolerinskonfiguration).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Inställningarna för den dedikerade IIS-programpoolen ställs in enligt de serveromfattande prestandainställningarna.',

    '__current' => 'Nuvarande',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Användaregenskaperna har uppdaterats.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Du har använt nästan alla domäner tillhandahållna genom din Plesk-licens (90 % eller fler).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Du har använt nästan alla domäner.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Du har använt nästan alla Presence Builder-siter tillhandahållna genom din Plesk-licens (90 % eller fler).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Du har använt nästan alla Presence Builder-siter.',
    'promo__button_hide' => 'Dölj',
    'promo__button_next' => 'Nästa>>',
    'promo__button_prev' => '<< Föregående',
    'promo__button_license' => 'Uppdatera licens',

    'promo__google_integration_title' => 'Integrering med Google-tjänster',
    'promo__google_integration' => 'Konfigurera integreringen med Google-tjänster som AdSense, Google Apps och webbadministratörsverktyg.',
    'promo__google_integration_button' => 'Anpassa',

    'promo__button_learn_more' => 'Mer information',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Du kan anpassa gränssnittsutseende och branding-inställningar genom egna anpassade teman. För instruktioner om att anpassa Plesk-teman, se %1.',
    'panel_branding__description_link' => 'följande dokument',
    'mail__enable_mail_ui_label' => 'Aktivera posthanteringsfunktionerna på Plesk',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extrahera filer',
    'b_filemanager__extract' => 'Extrahera filer från valda arkiv till den aktuella katalogen. Notera att filnamn kan visas felaktigt efter extraheringen om de innehåller nationella specialtecken.',
    'filemanager_error_extracting_files' => 'Det uppstod ett fel vid extrahering av arkivfilerna: %1',
    'filemanager_no_archive_files_specified' => 'Ange vilka filer du vill extrahera.',
    'filemanager_not_zip_archive_specified' => '%1 kan inte extraheras, det är inte ett ZIP-arkiv.',
    'filemanager_files_successfully_extracted' => 'Arkivfilerna har extraherats.',
    'filemanager_error_file_download' => 'Nedladdning av filen misslyckades: %1',
    'filemanager__user_poolgrp' => 'Programpool grupp',

    'loading' => 'Laddar',
    'bt_create_archive' => 'Lägg till Arkiv',
    'filemanager__pack' => "Sökväg till arkivet: %1",
    'filemanager__archive_name' => 'Arkivera filnamnet',
    'filemanager__empty_filename' => 'Ange arkivets filnamn.',
    'filemanager_archive_created' => 'Arkivet har skapats korrekt.',
    'filemanager_error_creating_archive' => 'Det gick inte att skapa arkivet: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "AAAA-post står i strid med klisterposten för zonen.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-servern stödjer inte IPv6-adresser.)",
    'cmd_dns__glue_dns_record_conflict' => 'Denna post står i strid med klisterposten för zonen \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP-servern stödjer inte IPv6-adresser.)",
    '__ipv6_not_supported' => 'IPv6 stöds inte.',
    'mail__ipv6_not_supported' => 'IPv6 stöds inte av e-postservern.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6-reläets vitlista stöds inte av e-postservern.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Maskvärdet måste vara en multipel av 16.',
    'mail__ip_or_mask_is_invalid' => 'IP-adress eller masken är ogiltig.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Vidarebefordran till IPv6 IP-adresser stöds inte.',
    'sa__invalid_trusted_networks' => 'Felaktigt angivna betrodda nätverk: %1',
    'dns_add__enter_ipv6_address' => "IPv6-adress",
    'license_trial_days_left' => 'Din Plesk körs med en testlicens som kommer att löpa ut om %1 dagar.',
    'excl_ipv6_num' => 'Dedikerad IPv6-adress',
    '__ip_mask' => "Subnätmask",
    '__ipv4_addr' => 'IPv4-adress',
    '__ipv6_addr' => 'IPv6-adress',
    'template__num_excl_ipv6s' => 'Allokera dedikerade IPv6-adresser till återförsäljaren',
    'anonftp__exclusive_ipv4_required' => 'En dedikerad IPv4-adress krävs för att ställa in och använda den anonyma FPT-tjänsten.',
    'anonftp__ipv4_already_used' => 'Du kan inte ställa in den anonyma FPT-tjänsten för denna webbplats eftersom den redan har konfigurerats i en annan domän på samma IPv4-adress.',


    'restart__kav' => "Kaspersky Antivirus",
    'panel_branding__page_description_admin' => 'Märk Plesk-gränssnittet genom att ändra sidotiteln som visas på webbläsarens titelfält och/eller byta ut Plesk-logotypen i den övre vänstra hörnan.',
    '__view_migration_log_detailed_info' => 'Visa loggen',

    'chown__ip_address_warn' => 'Innan du flyttar abonnemanget till den nya ägaren, måste du välja en ny IP-adress för detta abonnemang.',
    'chown__no_ip_address' => 'Ingen',
    'chown__no_ipv4_address' => 'Ingen IPv4-adress',
    'chown__no_ipv6_address' => 'Ingen IPv6-adress',
    'chown__domain_exclude_already_owned_by_client' => 'Abonnemanget %1 tillhör redan den användaren.',
    'chown__error_ip_absent_in_ip_pool' => 'IP-adressen %1 finns inte i IP-poolen för målanvändaren.',
    'chown__error_ip_not_exist' => 'IP-adressen med ID \'%1\' finns inte.',
    'chown__error_domain_ip_not_selected' => 'Åtminstone en IP-adress för domänen %1 ska väljas. Kontrollera värdena som valts för IP-mappning.',

    '__new_passwd_single' => "Lösenord",
    '__confirm_passwd_single' => "Bekräfta lösenord",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6-adress eller mask är ogiltig: IP-adressen ska vara en giltig unicast-adress.',

    '__subscriptions' => 'Abonnemang',

    '__owned_by_reseller' => 'ägs av återförsäljaren',
    '__owned_by_provider' => 'ägs av leverantören',

    'service_plan__anonymous' => 'Anpassad',
    'subscription_not_locked__change_limits_warning' => 'Abonnemanget är inte låst: gränserna för resursanvändning kommer att ändras under synkroniseringen med tjänsteplanen.',
    'subscription_not_locked__change_permissions_warning' => 'Abonnemanget är inte låst: behörigheterna  kommer att ändras under synkroniseringen med tjänsteplanen.',

    'subscription__conflict_resolution_policy' => 'Konfliktlösningspolicy',
    'subscription__conflict_resolution_policy_lock' => "Lås abonnemang",

    'backup__list__backup_warnings' => 'Varningar',
    'backup__list__backup_info' => 'Information',
    'backup__restore__object_reseller_template' => 'Återförsäljarens mall',
    'backup__restore__object_domain_template' => 'Domänmall',

    'ui__client/permissions_readonly__title' => 'Behörigheter',
    'ui__client/permissions_readonly__short-title' => 'Behörigheter',

    'subscription__unable_lock_anonymous' => 'Detta abonnemang är inte bundet till en tjänsteplan och kan därför inte låsas upp.',
    'subscription__unable_sync_anonymous' => 'Detta abonnemang är inte bundet till en tjänsteplan och kan därför inte synkroniseras.',
    'subscription__unable_sync_locked' => 'Detta abonnemang är bundet och kan därför inte synkroniseras.',
    'subscription__locked' => 'Abonnemanget är låst,',
    'component_name__urlrewrite' => "URL-omskrivning",
    '__quantity' => 'Kvantitet',
    'hst__www_root_dir_absent' =>  'Varning: Den specificerade katalogen som en dokumentrot finns inte.',
    'object_creation__domain_is_not_a_webspace' => 'Detta objekt kan skapas bara i en prenumeration.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Prenumerationen innehåller webbplatser och därför kan du inte ändra hostingtyp eller radera den.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Fel: kunde inte uppdatera iP-adressen. TIlläggsdomäner kan inte tilldelas en IP-adress som inte tilldelats prenumerationens huvuddomän.',
    'domain_plan__unable_change' => 'Kan inte ändra abonnemangplan: %1.',
    'domain_plan__different_hosting_type' => 'Den aktuella typen av värdtjänst skiljer sig från typen som specificeras i serviceplanen.',
    'domain_plan__addon_text' => 'Tilläggsplan',
    'domain_plan__addon_description' => 'Tilläggsplanen används som tillägg till en värdtjänstplan.',
    'asp_net__managed_runtime_version' => 'ASP.NET-hanterad körningsmiljöversion',
    'plan__can_not_change_hosting_type' => 'Det är inte möjligt att ändra värdtjänsttyp när man redigerar en plan.',
    'plan__apply_problems' => 'Planen tillämpades inte på grund av problem med följande funktion: %1',
    'plan_save__subscription_update_problem' => 'Kan inte tillämpa planändringar på %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Abonnemanget är tillfälligt avbrutet tills säkerhetskopieringen eller återställningsprocessen har slutförts. Återkom senare.",
    'mail__whitenet_exists' => "Vit lista med prefixet %1 finns redan.",
    '__login_incorrect_plain_shadow_password' => 'Du har angett fel lösenord för administratörskontot. Använd systemadministratörens (rot)-inloggningsuppgifter, eller erhåll ett korrekt lösenord. För mer information om att erhålla lösenordet, läs filen /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Du kan inte skicka en IP-adress du inte äger',

    'dns__dns_zone_not_synchronized' => 'DNS-zonen modifierades. Om du vill tillämpa DNS-mallens ändringar till detta område klicka på knappen \'Tillämpa DNS-malländringar\' på denna sida eller välj alternativet \'Tillämpa ändringarna på alla områden\' på serveradministrationspanelen > Verktyg och inställningar > DNS-mallinställningar > Tillämpa DNS-malländringarna.',
    'dns__dns_zone_synchronize_link' => 'Klicka',
    'dns__dns_zone_synchronize_done' => 'DNS-zonen synkades med framgång.',

    'dns__dns_zone_template_not_synchronized' => 'DNS-zonen har ändrats och kommer att tillämpas på alla nyskapade domäner. Du kan även %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'SOA-mallen ändrades och kommer att tillämpas på alla nyskapade domäner. Du kan även %1.',
    'dns__dns_zone_template_synchronize_link' => 'tillämpa ändringarna på alla värdserverdomäner',
    'dns__dns_zone_template_error_details' => 'Detaljer',
    'dns__dns_zone_template_error' => 'Det uppstod problem i synkroniseringen av DNS-zoner med DNS-mall.%1',

    'dns__soa_rname_type_owner' => 'Webbplatsägarens e-postadress',
    'dns__soa_rname_type_domain' => 'Domänens e-postadress',
    'dns__soa_rname_type_external' => 'Extern e-postadress',
    'dns__soa_rname_enforce_email' => 'Förbud att ändra RNAME e-postadressen per domänbas',
    'dns__soa_rname_label' => 'E-post (RNAME)',
    'dns__soa_rname_hint' => 'E-postadress till personen som ansvarar för domänens DNS-zon. Returnerad av DNS-servern som svar på SOA-frågor.',

    'dns__dns_zone_soa_sync_title' => 'Uteslut SOA-inställningarna för alla befintliga domäner',
    'dns__dns_zone_soa_sync_legend' => 'Bekräftelse krävs',
    'dns__dns_zone_soa_sync_text' => 'Uppdatera SOA-poster av alla värddomäner genom att använda de ändringar som gjorts i SOA-mallen?',

    'cu_db__repair_mysql_dbus' => "Reparera MySQL-användarlösenord. Denna åtgärd behövs om du uppgraderat till Plesk 11 från tidigare versioner.",

    'scheduled_backup_settings__start_at_hint' => 'Kontrollintervallet för schemalagda säkerhetskopieringsuppgifter är 15 minuter. Om du vill att Plesk ska börja säkerhetskopieringen vid en särskild tidpunkt, schemalägg aktiviteten minst 15 minuter tidigare än den önskade tidpunkten.',
    'cu_scheduled_backup_comment' => 'Schemalagd säkerhetskopiering',
    'cu_scheduled_backup_error' => 'Ett fel inträffade under säkerhetskopieringen: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Ett fel inträffade under den schemalagda säkerhetskopieringen.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk-ingångspunkt: %2\n\nFöljande fel inträffade under den schemalagda säkerhetskopieringen:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Schemalagd säkerhetskopiering. Hela konfigurationen och innehållet.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Schemalagd säkerhetskopiering. All konfiguration och allt innehåll utom e-post.',
    'cu_scheduled_backup_comment_backup_mail' => 'Schemalagd säkerhetskopiering. Endast e-postkonfiguration och innehåll.',
    'cu_scheduled_backup_comment_backup_domain' => 'Schemalagd säkerhetskopiering. Domänkonfiguration.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Att lagra schemalagda säkerhetskopior i molnlagring är en premiumfunktion. Kontakta ditt webbhotell för att låsa upp det.',

    'i_backup_invalid_file' => 'Detta är en ogiltig säkerhetskopia. Kan inte hämta data från den här filen. Klicka på säkerhetskopians namn för närmare uppgifter.',

    'ui__server/migration/download-agent__short-title' => 'Ladda ner Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Ladda ner Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Ladda ner den senaste versionen av Migration & Transfer Agent från Plesk webbplats.',

    'filemanager_resulting_archive_exists' => 'Filen %1 finns redan i målkatalogen.',

    'agent_unable_to_connect' => 'Kunde inte ansluta till agenten i  \'%2\'. Vänligen se till att agenten är installerad och igång och att det inte finns anslutningsproblem till värddatorn \'%2\'.',
    'agent_test_connection_failed' => 'Anslutningen till {agenten i \'%2\'.',

    'agent_unable_to_resolve_host' => 'Kan inte autentisera vid fjärrvärddatorn  \'%1\'. Se till att det inte finns några anslutningsproblem till värddatorn.',
    'agent_unknown_curl_error' => 'Felet \'%1\' uppstod under anslutningen till agenten vid \'%2\'.',
    'agent_unexpected_htp_code' => 'Den oväntade HTTP-koden \'%1\' mottogs på HTTP-begäran till agenten vid \'%2\'.',
    'agent_unable_to_auth' => 'Kan inte autentisera vid värddatorn \'%1\'. För att lösa detta problem, var god se instruktionerna på http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Ett internt serverfel inträffade under kommandots utförande i fjärrservern \'%1\'.',
    'agent_response_is_empty' => 'Ett tomt svar mottogs på HTTP-begäran till agenten på \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Kan inte hitta Migration & Transfer Agent i lokal cache. Öppna Migration &Transfer Manager för att åtgärda problemet.',

    '__hosting_webdeploy' => "Web Deploy-publicering",
    'cu_domain__webdeploy' => "Web Deploy-publicering (standard: %1)",
    'cu_dom_tpl__webdeploy' => "Web Deploy-publicering (standard: %1)",
    'cu_subdomain__webdeploy' => "Web Deploy-publicering (standard: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy har inte installerats på servern.",
    'webdeploy__forced_by_site_isolation' => "Kan inte förändra Web Deploy-publiceringsinställningarna: Du har inte tillstånd att överträda den serveromfattande säkerhetspolicyn. Kontakta din leverantör för detaljer.",



    'backup__restore_options__admin__server_configuration_license' => 'Licensnyckel',
    'migration_start_migrate_server_license' => 'Överför licensnyckel',

    'defaultcomponents__delegation_rule_not_exist' => '(den nödvändiga delegeringsregeln \'appPoolPipeline, appPoolNetFx\' finns inte)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Säkerhetskopian skapades av administratören.',
    'i_backup_created_by_reseller' => 'En säkerhetskopia skapades av en återförsäljare.',
    'i_backup_created_by_client' => 'En säkerhetskopia skapades av en kund.',

    'migration__object_exists_on_target_host' => '(finns redan i målvärddatorn)',

    '__customers_total' => 'Totalt av kunderna',
    '__resellers_total' => 'Totalt av återförsäljare',
    '__reseller_total' => 'Återförsäljare totalt',


    'cu__mailserver_update_webmail_command' => "Anger en webbmailklient du vill aktivera eller inaktivera",
    'cu__mailserver_webmail_state' => "Anger tillståndet för vald webbmailklient (sant aktiverar klienten, falskt inaktiverar den)",

    'cu_db_set_default_user' => 'Ange en specificerad användare som standard för databasen. Alternativet används med kommandona: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Låta användare få tilllgång endast till ett specificerat abonnemang',
    'cu_role__opt_for_all_subscription' => 'Låta användare få tillgång till alla abonnemang inom ett värdtjänstkonto',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Kan inte tillämpa ändringarna på rollen: abonnemanget %1 hittades inte.',

    'cu_cl_pref__manage_website_maintenance' => 'Åtkomst till avancerade funktioner: Webbplatskopiering',
    'cu_cl_pref__manage_protected_dirs' => 'Hantering av lösenordsskyddade kataloger',
    'cu_cl_pref__manage_mail_settings' => 'Förmåga att ändra postinställningar',


    'cu__command_update_php_settings' => 'Uppdaterar PHP-inställningar.',
    'cu__php_settings_option' => 'Anger sökvägen till filen med  PHP-inställningar.',

    'cu__additional_php_settings_option' => 'Anger sökvägen till filen med ytterligare PHP-direktiv.',
    'cu__command_show_php_settings' => 'Visar de aktuella PHP-inställningarna.',
    'cu__general_settings' => 'Allmänna inställningar:',
    'cu__performance_settings' => 'Prestandainställningar:',
    'cu__php_fpm_settings' => 'PHP-FPM-inställningar',
    'cu__additional_directives' => 'Ytterligare direktiv:',

    'b_filemanager__pack' => 'Lägg till valda filer till ett arkiv.',

    'php_settings_permission_required' => 'Hantering av gemensamma PHP-inställningar',
    'php_settings_performance_permission_required' => 'Inställningshantering av värdtjänstprestanda',
    'php_settings_customized' => 'PHP-inställningar har anpassats.',
    'php_settings_synchronized_with_plan' => 'PHP-inställningarna måste synkroniseras med planen.',
    'phosting__unknown_shell_type' => 'Otillgängligt skal',

    'login_up__access_denied_subscription_deleted' => 'Åtkomst nekad: ditt abonnemang har tagits bort.',

    'role_restricted_to_subscription' => '(överförs med abonnemanget: %1)',

    'filemanager__extract' => "Extrahera filer till: %1",

    'cu__license_command_check_installed_license' => 'Kontrollera giltigheten av den installerade licensnyckeln (returnerar utgångskoden 0 om nyckeln är giltig och 1 om den är ogiltig)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Utöka Plesk-funktioner till att kontrollera och övervaka servern från mobila enheter (BlackBerry, iPhone och Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Få den viktigaste informationen om Plesk-servrar när och var som helst från en mobil enhet (BlackBerry, iPhone och Android).',
    'promo__mobile_button' => 'Mer information',

    'ui__server/migration/video__short-title' => 'Videoövningar',
    'ui__server/migration/video__title' => 'Titta på videoövningar',
    'ui__server/migration/video__description' => 'Titta på videoövningar',

    'auto_install_updates_moved_to_separate_page' => 'Konfigurera uppdateringspolicy',

    '__system_preferences' => 'Systeminställningar',
    'subDomainNameHint' => 'Ange * som ett subdomännamn för att skapa en jokerteckensubdomän. Sitebesökare omdirigeras till denna subdomän, oavsett vilket subdomännamn de anger i webbläsaren.',
    'subdomains__wildcard_name_invalid' => "Subdomänens namn är ogiltigt. Du kan endast använda alfanumeriska tecken, ett bindestreck (-), och en asterisk (*) som jokertecken för subdomännamn.",
    'subdomains__name_invalid' => "Subdomänens namn är ogiltigt. Du kan endast använda alfanumeriska tecken och ett bindestreck (-) för subdomännamn.",

    'domain__wildcard_no_www_prefix' => 'Det är inte möjligt att använda www-prefixet för jokertecken-subdomäner.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix e-postfilter",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3-server",
    'restart__pop3s' => "Courier POP3-server med SSL/TLS-stöd",
    'restart__imap' => "Courier IMAP-server",
    'restart__imaps' => "Courier IMAP3-server med SSL/TLS-stöd",
    'restart__authdaemon' => "Courier IMAP-autentiseringsdaemon",
    'restart__imap-pop3' => "Dovecot IMAP och POP3 server",


    'addon_packages_not_supported' => 'Tilläggsprogram för APS-förpackade webappar stöds inte.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Kan inte automatiskt tilldela en IP-adress till domänen. Ange en IP-adress med hjälp av tilläggsalternativet -ip.',

    'plesk_key__mb_accounts' => 'Användarkonton (återförsäljare och kunder) i Customer & Business Manager',

    'actionlog__subdomain_dns' => 'Subdomän DNS-zon',
    'actionlog__site_subdomain_dns' => 'DNS-zon av en subdomän under en extra domän',

    // PfW only
    'actionlog__event_site_create' => 'Domän skapad',
    'actionlog__event_site_delete' => 'Domän som raderats',
    'actionlog__event_site_update' => 'Domän uppdaterad',

    'actionlog__event_site_status_update' => 'Domänstatus uppdaterad',
    'actionlog__event_site_dns_update' => 'Domänens DNS-namnzon uppdaterad',
    'actionlog__event_site_guid_update' => 'Domänens GUID uppdaterad',

    'actionlog__event_site_subdomain_create' => 'Subdomän skapad',
    'actionlog__event_site_subdomain_delete' => 'Subdomän borttagen',
    'actionlog__event_site_subdomain_update' => 'Subdomän uppdaterad',

    'actionlog__event_site_alias_create' => 'Domänalias skapat',
    'actionlog__event_site_alias_delete' => 'Domänalias har raderats',
    'actionlog__event_site_alias_update' => 'Domänalias uppdaterat',

    'actionlog__event_site_alias_dns_update' => 'DNS-zon av ett domänalias uppdaterad',
    'actionlog__event_subdomain_dns_update' => 'DNS-zon av en subdomän under standarddomänen uppdaterades',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-zon av en subdomän uppdaterad',
    // End of PfW only

    'rdp_app__type' => 'Terminalsessionprogram',
    'rdp_app__msactivex' => 'Microsoft RDP ActiveX',
    'rdp_info__prop_title' => "Anslut till servern via fjärrskrivbord",
    'rdp_info__session_title' => 'Terminalsession med server %1 (%2)',
    'rdp_info__prop_legend' => "Terminalsessionegenskaper",
    'rdp_screen_resolution' => 'Skärmupplösning för terminalsession',
    'rdp_user_name' => 'Terminalsessionens användarnamn',

    'win_policy__bad_password' => 'Validering misslyckad. Lösenordet är ogiltigt.',
    'win_policy__password_too_short' => 'Validering misslyckad. Lösenordet uppfyller inte lösenordsprincipen eftersom det är för kort.',
    'win_policy__password_too_long' => 'Validering misslyckad. Lösenordet uppfyller inte lösenordskraven eftersom det är för långt.',
    'win_policy__password_not_complex_enough' => 'Validering misslyckades. Ditt lösenord är inte tillräckligt komplext och möter inte kraven hos lösenordspolicyn. Starka lösenord måste innehålla minst samtliga av följande: åtta tecken; ett versalt eller gement tecken; tre siffror och ett specialtecken (!, @, #, $, %, ^, &, *, ?, _, ~) eller en siffra och två specialtecken.',

    //// Activation Code feature
    'key__tabs_activation' => 'Licensnyckel-aktivering',
    'key__description' => 'Här kan du installera din licensnyckel, antingen genom att ange en aktiveringskod eller genom att ladda upp en licensnyckelfil.',
    'key__description_code_only' => 'Här kan du installera din licensnyckel genom att ange en aktiveringskod.',
    'key__license_key' => 'Välj något av följande:',
    'key__code_text' => 'Ange en aktiveringskod',
    'key__code_hint' => 'Klistra in aktiveringskoden du har mottagit.',
    'key__file_text' => 'Ladda upp en licensnyckelfil',
    'key__file_hint' => 'Ange sökvägen till filen som innehåller licensnyckeln.',
    'plesk_key__code_check_wrong' => 'Aktiveringskoden är inte giltig.',
    'plesk_key__license_update_failed' => 'Kan inte uppdatera produktlicensen.',


    'filemanager__error_path_is_not_allowed' => 'Sökvägen är inte tillåten',
    'filemanager__error_path_is_invalid' => 'Sökvägen är ogiltig',
    'filemanager__error_path_not_found' => 'Sökvägen hittades inte',
    'filemanager__error_path_already_exists' => 'Sökvägen finns redan',
    'filemanager__error_access_is_denied' => 'Åtkomst nekad',
    'filemanager__error_directory_not_empty' => 'Mappen är inte tom',
    'filemanager__error_sharing_violation' => 'Fildelningsfel',
    'filemanager__error_not_same_device' => 'Målsökvägen är inte på samma enhet',
    'filemanager__binary_data_access' => 'Denna fil kan vara en binär fil. Vill du öppna den?',
    'filemanager__unable_to_resolve_realpath' => "Det gick inte att hitta filen %1 på angiven plats",
    'filemanager__access_to_realpath_denied' => "Tillgång till realsökvägen nekad: %1 till %2.",
    'bt_exit' => 'Avsluta',

    'filemanager__chdir_error__' => "Kan inte ändra katalog till %1: %2",
    'filemanager__chmod_dir' => "Ändra behörighet för katalog %1",
    'filemanager__chmod_error__' => "Det går inte att ändra behörigheter för filen %1: %2",
    'filemanager__chmod_file' => "Ändra behörigheter för filen %1",
    'filemanager__copy_error__' => "Kan inte kopiera %1 %2: %3",
    'filemanager__copy_move' => "Kopiera (flytta) filer från %1",
    'filemanager__count_size__' => 'Vald storlek: %1',
    'filemanager__count_size_error__' => 'Kan inte beräkna storlek för %1: %2',
    'filemanager__create_dir' => "Katalogskapande",
    'filemanager__create_dir_error__' => "Kan inte skapa katalog %1: %2",
    'filemanager__dir_not_exists' => "Katalogen %1 finns inte.",
    'filemanager__dirname' => "Katalognamn",
    'filemanager__filename' => "Filnamn",
    'filemanager__is_no_such' => "Det finns ingen fil eller katalog med namn %1",
    'filemanager__empty_selection' => "Ingen/a fil(er) har valts.",
    'filemanager__file_exists' => "Filen %1 finns redan.",
    'filemanager__move_error__' => "Kan inte flytta %1 till %2: %3",
    'filemanager__new_dir' => "Katalognamn",
    'filemanager__not_allowed' => "Du har inte tillåtelse att ändra behörigheter för denna fil.",
    'filemanager__r_perm_dir' => "Kataloglista",
    'filemanager__r_perm_file' => "Läsa data",
    'filemanager__remove' => "Ta bort filer från %1",
    'filemanager__remove_error__' => "Kan inte ta bort filen %1: %2",
    'filemanager__rename_dir' => "Byt namn på katalogen %1",
    'filemanager__rename_error__' => "Kan inte flytta %1 till %2: %3",
    'filemanager__rename_file' => "Byt namn på filen %1",
    'filemanager__set_win_permissions_dir' => "Ställ in behörighet för mapp %1",
    'filemanager__set_win_permissions_file' => "Ställ in behörighet för fil %1",
    'filemanager__touch_confirm' => "Är du säker på att du vill ändra tidsstämpeln för de valda filerna?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Kan inte läsa filen eller filformatet stöds inte.',
    'filemanager__upload_error__' => "Kunde inte ladda upp %1 till %2: %3",
    'filemanager__upload_file' => "Ladda upp fil",
    'filemanager__upload_file_src' => "Sökväg till fil",
    'filemanager__username' => "Användare",
    'filemanager__w_perm_dir' => "Skapa filer",
    'filemanager__w_perm_file' => "Skriva data",
    'filemanager__x_perm_dir' => "Gå igenom katalog",
    'filemanager__x_perm_file' => "Exekvera fil",
    'filemanager__max_image_size_exceeded' => 'Kan inte visa bilden.  Bildstorleken får inte vara större än %2 bytes',

    '__fastcgi_unix_support' => 'Snabb CGI-support',

    'ts_sessions_list' => 'Denna sida visar listan med alla terminaltjänstsessioner..',
    'b_tssessionslist_search' => 'Sök efter sessioner enligt namn.',
    'b_tssessionslist_show_all' => 'Visa alla Terminaltjänstsessionern',
    'l_tssessionslist_state' => 'Sortera efter status.',
    'l_tssessionslist_name' => 'Sortera efter namn.',
    'l_tssessionslist_user' => 'Sortera efter användare.',
    'b_tssessionslist_logoff' => 'Klicka för att logga ut ifrån valda sessioner.',
    'b_tssessionslist_disconnect' => 'Klicka för att koppla ifrån valda sessioner.',
    'tssessions_info' => 'Visa sessionsegenskaperna.',
    'tssessions_disconnect' => 'Markera kryssrutan Bekräfta borttagning och klicka på OK för att koppla ifrån den valda terminalens serversessioner.',
    'tssessions_logoff' => 'Markera kryssrutan Bekräfta borttagning och klicka på OK för att logga av från den valda terminalens serversessioner.',
    'b_tssession_disconnect_submit' => 'Klicka för att skicka in ändringarna.',
    'b_tssession_logoff' => 'Klicka för att logga ut ifrån sessionen.',
    'b_tssession_logoff_submit' => 'Klicka för att skicka in ändringarna.',
    'i_tssession_active' => 'Aktiva',
    'i_tssession_connected' => 'Connected',
    'i_tssession_disconnected' => 'Frånkopplad',
    'i_tssession_listen' => 'Lyssnar',
    'tssessions__tssessionslist' => 'Sessioner',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => 'Namn',
    'tssessionslist__user' => 'Användare',
    'bt_logoff_selected' => 'Logga ut',
    'bt_logoff' => "Logga ut",
    'bt_disconnect_selected' => 'Koppla från',
    'bt_tssession_logoff' => 'Logga ut',
    'bt_tssession_disconnect' => 'Koppla från',
    'bt_tssession_disconect' => 'Koppla från',
    'b_tssession_disconnect' => 'Klicka för att koppla ifrån sessionen.',
    'b_tssession_logoff_disabled' => 'Kan inte logga ut ifrån sessionen.',
    'b_tssession_disconnect_disabled' => 'Kan inte koppla ifrån sessionen.',
    'tssessions_info__title' => 'Session %1 egenskaper',
    'tssessions_info__property_name' => 'Namn på egenskap',
    'tssessions_info__property_value' => 'Värde på egenskap',
    'tssessions__disconnect_title' => 'Följande terminaltjänstsessioner kommer att kopplas ifrån:',
    'tssessions__session_cant_disconnect' => 'det går inte att koppla ifrån sessionen',
    'tssessions__logoff_title' => 'Följande terminaltjänstsessioner kommer att loggas av:',
    'tssessions__session_cant_logoff' => 'det går inte att logga av från sessionen',
    'tssessions__select_sessions_to_logoff' => 'Markera sessioner som ska loggas av.',
    'tssessions__select_sessions_to_disconnect' => 'Markera sessioner som ska kopplas ifrån.',
    'dns__subdomain_dns_zone_parent' => 'DNS-posterna för denna subdomän är lagrade i föräldra-DNS-zonen. Du kan modifiera föräldrazonen %1 eller skapa en separat zon för subdomänen.',
    'dns__subdomain_dns_zone_parent_link' => 'här',
    'dns__no_dns_zone' => 'Ingen DNS-zon tilldelad med domänen. För att hantera DNS-zonen för din domän, tryck på knappen \' Återställ standardvärden\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Kan inte sätta på underdomänens område, eftersom det finns en CNAME-post för denna underdomän i dess huvuddomäns område.',

    '__hosting_write_modify' => 'Ytterligare behörigheter för att skriva/ändra',


    'aspdotnet__title' => "Serveromfattande ASP.NET-konfiguration",
    'aspdotnet__dom_title' => "ASP.NET-konfiguration för webbplatsen",
    'aspdotnet__wdir_title' => "ASP.NET-konfiguration för den virtuella katalogen %1",
    'aspdotnet__group_cas_settings' => "Kodåtkomstsäkerhet",
    'aspdotnet__group_client_scripts' => "Skriptbiblioteksinställningar",
    'aspdotnet__group_conn_strings' => "Anslutningsstränghanteraren",
    'aspdotnet__group_custom_errors' => "Inställningar för anpassade felsidor",
    'aspdotnet__group_framework_version' => "Framework-version",
    'aspdotnet__group_globalization' => "Globaliseringsinställningar",
    'aspdotnet__group_other' => "Sessionsinställningar",
    'aspdotnet__group_page_and_runtime' => "Kompilering och felsökning",
    'aspdotnet__invalid_dom_config_file' => "ASP.NET konfigurationsfil för denna webbplats är korrupt.  För att återställa den, applicera serverns standard-ASP.NET-konfiguration när du klickat på Sätt som standardvärde.",
    'aspdotnet__invalid_file_enc' => "Ogiltigt värde för filkodningsparametern.",
    'aspdotnet__invalid_req_enc' => "Ogiltigt värde för parametern kodning av förfrågan.",
    'aspdotnet__invalid_res_enc' => "Ogiltigt värde för parametern kodning av svar.",
    'aspdotnet__invalid_parent_wdir_config_file' => "ASP.NET-konfigurationsfilen är korrupt till följd av skadan på ASP.NET-konfigurationen för föräldrakatalogen %1. \nFör att lösa detta problem, återställ %1 ASP.NET-konfigurationen.",
    'aspdotnet__invalid_global_config_file_admin' => "ASP.NET-konfigurationen är korrupt till följd av skada på ASP.NET-konfigurationsfilen på servern.",
    'aspdotnet__invalid_global_config_file' => "ASP.NET-konfigurationen är korrupt till följd av skada på ASP.NET-konfigurationsfilen på servern. Kontakta din serverleverantör för assistans.",
    'aspdotnet__invalid_sess_timeout' => "Ogiltigt värde för sessionens tidsgränsparameter. Ange ett positivt heltal som är mindre än eller lika med %1.",
    'aspdotnet__invalid_wdir_config_file' => "ASP.NET konfigurationsfil för denna virtuella katalog är korrupt. För att återställa den, tillämpa den virtuella huvudkatalogens ASP.NET-konfiguration genom att klicka på Ställ in på standardinställning.",
    'aspdotnet__param_auth_mode' => "Autentiseringsläge",
    'aspdotnet__param_conn_strings' => "Anslutningssträngar",
    'aspdotnet__param_conn_string_name' => "Namn",
    'aspdotnet__param_conn_string_value' => "Anslutningsparametrar",
    'aspdotnet__param_culture' => "Kultur",
    'aspdotnet__param_custom_err_mode' => "Läge för anpassade felsidor",
    'aspdotnet__param_custom_error_redirect' => "Hänvisningsadressen",
    'aspdotnet__param_custom_error_status' => "Statuskod",
    'aspdotnet__param_custom_errors' => "Anpassade felsidor",
    'aspdotnet__param_debug_mode' => "Slå på felsökning.",
    'aspdotnet__param_def_language' => "Grundspråk för webbsidan",
    'aspdotnet__param_temp_directory' => "Temporär katalog",
    'aspdotnet__param_file_enc' => "Filkodning",
    'aspdotnet__param_req_enc' => "Kodning för begäran",
    'aspdotnet__param_res_enc' => "Kodning för svar",
    'aspdotnet__param_sess_timeout' => "Tidsgräns för session (minuter)",
    'aspdotnet__param_trust_level' => "CAS-förtroendenivå",
    'aspdotnet__param_ui_culture' => "UI-kultur",
    'aspdotnet__param_version' => "Version",
    'aspdotnet__param_trust_level_allow_override' => 'Tillåt ändring av CAS-förtroendenivå för individuella webbplatser',
    'aspdotnet__restore_default_confirm' => "Återställ de förvalda ASP.NET-inställningarna?",

    'bt_restore_default' => "Ställ in standardvärden",
    'b_aspdotnet' => 'Redigera konfigurationsinställningarna för ASP.NET.',
    'b_aspdotnet__restore_default' => 'Återställ de förvalda ASP.NET-inställningarna.',
    'b_aspdotnet__restore_wdir_default' => "Återställ den överordnade katalogens ASP.NET-inställningar för denna virtuella katalog.",
    'b_aspdotnet__restore_default_disabled' => 'Återställning av den förvalda ASP.NET-standardkonfigurationen är inte tillgängligt: ASP.NET-konfigurationen är skadad, antingen på servern eller på en föräldrakatalognivå.',
    'b_autoinstaller' => 'Uppdatera Plesk eller dess komponenter.',
    'b_autoinstaller_configure' => 'Uppdatera inställningar.',
    'b_autoinstaller_install' => 'Installera valda komponenter.',

    '__iis_app_pool__use_dedicated' => 'Dedikerad IIS-programpool',
    '__iis_app_pool__use_dedicated_addons' => 'Dedikerad IIS-programpol för varje webbplats',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Aktivera 32-bitars applikationer',
    'bt_iis_app_pool' => "IIS-programpool",

    'performance__cpu_usage' => 'Högsta CPU-användning (%)',
    'performance__cpu_usage_action' => 'Åtgärd vid gräns',
    'performance__cpu_usage_interval' => 'Gränsintervall (minuter)',
    'performance__cpu_usage_action_not_supported' => 'Den angivna åtgärden stöds inte av webbservern.',

    'performance__idle_timeout_action_not_supported' => 'Den angivna åtgärden vid tidsgräns för inaktivitet stöds inte av webbservern.',
    'performance__max_worker_processes' => 'Högsta antal arbetsprocesser',
    'performance__idle_timeout' => 'Tidsgräns för inaktivitet (minuter)',
    'performance__idle_timeout_action' => 'Åtgärd vid tidsgräns för inaktivitet',
    'performance__recycling_by_time' => 'Återvinning med regelbundna tidsintervall (minuter)',
    'performance__recycling_by_requests' => 'Återvinning när det maximala antalet förfrågningar är uppnådd.',
    'performance__recycling_by_virtual_memory' => 'Återvinning när maximal mängd virtuellt minne är förbrukad',
    'performance__recycling_by_private_memory' => 'Återvinning när maximal mängd privat minne är förbrukad',
    'performance__managed_pipeline_mode' => 'Förvaltat pipelineläge',
    'performance__managed_pipeline_mode_not_supported' => 'Det angivna läget stöds inte av webbservern.',

    'iis_app_pool' => 'IIS-programpoolhantering',
    'b_iis_app_pool' => 'Hantera IIS-programpoolen.',
    'iis_app_pool_cl_dom' => 'IIS-programpoolhantering',

    'i_webdirs_not_protected' => 'Den här katalogen är inte skyddad.',
    'i_webdirs_protected' => 'Denna katalog är skyddad.',
    'i_webdirs_manage_protection' => 'Hantera skydd.',
    'i_webdirs_open' => 'Öppna katalogen/filen i webbläsaren',
    'i_webdirs_preferences_disabled' => 'Denna katalog är inte en virtuell katalog.',
    'i_webdirs_permissions' => 'Hantera behörigheter.',
    'i_webdirs_permissions_disabled' => 'Katalogtillståndshanteringen är inte tillgänglig.',
    'i_webdirs_type_dir' => 'Fysisk katalog',
    'i_webdirs_type_vdir' => 'Virtuell katalog',
    'i_webdirs_browse' => 'Bläddra i kataloginnehållet.',
    'i_webdirs_preferences' => 'Hantering av webbkataloginställningar.',

    'l_webdirslist_type' => 'Sortera kataloger efter typ.',
    'l_webdirslist_protected' => 'Sortera kataloger efter skyddsstatus.',
    'l_webdirslist_name' => 'Sortera kataloger efter namn.',

    'b_webdirslist_remove' => 'Radera valda virtuella kataloger.',
    'b_webdirslist_search' => 'Ange ett sökmönster och klicka för att hitta virtuella kataloger.',
    'b_webdirslist_show_all' => 'Visa alla kataloger.',

    'l_webdirerrordocslist_code' => 'Sortera feldokument efter felkodsnummer.',
    'l_webdirerrordocslist_name' => 'Sortera feldokument efter felbeskrivning.',
    'l_webdirerrordocslist_type' => 'Sortera feldokument efter feldokumenttyp.',
    'l_webdirerrordocslist_location' => 'Sortera feldokument efter feldokumentets plats.',

    'b_webdirerrordocslist_search' => 'Ange ett sökmönster och klicka för att hitta felaktiga dokument.',
    'b_webdirerrordocslist_remove' => 'Radera valda feldokument,',
    'b_webdirerrordocslist_show_all' => 'Visa alla felaktiga dokument',

    'l_webdirmimetypeslist_name' => 'Sortera MIME-typer efter tillägg.',
    'l_webdirmimetypeslist_content' => 'Sortera MIME-typer efter innehåll.',

    'b_webdirmimetypeslist_remove' => 'Radera valda MIME-typer.',
    'b_webdirmimetypeslist_search' => 'Ange ett sökmönster och klicka för att hitta MIME-typer.',
    'b_webdirmimetypeslist_show_all' => 'Visa alla MIME-typer.',

    'b_webdir_preferences' => "Inställningar för den virtuella katalogen",
    'b_webdir_permissions' => "Tillstånd till virtuella kataloger",
    'b_webdir_permissions_disabled' => "Katalogtillståndshanteringen är inte tillgänglig.",
    'b_to_webdirs' => 'Återgå till att hantera katalogerna.',
    'b_to_webdir_mime_types' => 'Återgå till att hantera MIME-typer.',
    'b_to_webdir_error_docs' => 'Återgå till att hantera feldokument.',
    'b_to_webdir_protection' => 'Återgå till hanteringen av det virtuella katalogskyddet.',

    'webdirs__title' => 'Virtuell katalog %1',
    'webdirs__preferences_title' => 'Virtuella kataloginställningar',
    'webdirs__list_legend' => 'Virtuella kataloger',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Namn',
    'webdirs__list_header' => '%1 objekt',
    'webdirs__tabs_general' => 'Allmänt',
    'webdirs__tabs_mime_types' => 'MIME-typer',
    'webdirs__tabs_error_docs' => 'Feldokument',

    'webdirs__tabs_permissions' => 'Behörigheter',
    'webdir__remove_vdirs' => 'Följande virtuella kataloger kommer att raderas:',
    'webdir__remove_mime_types' => 'Följande MIME-typer kommer att raderas:',
    'webdir__mime_types_title' => 'MIME-typer',
    'webdir__protection_disable_confirm' => 'Vill du verkligen ta bort skyddet från katalogen?',
    'webdir__protect_title' => 'Skyddad URL-användare',
    'webdirs__permissions_title' => 'Tillstånd till virtuell katalog',
    'webdirs__browse_content_permission_denied' => 'Du har inte behörighet för att se denna katalogs innehåll.',
    'error_doc__list_code' => 'Fel',
    'error_doc__list_code_description' => 'Beskrivning',
    'error_doc__list_type' => 'Typ',
    'error_doc__list_location' => 'Plats',
    'error_doc__code' => 'Fel',
    'error_doc__type' => 'Typ',
    'error_doc__type_file' => 'Fil',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Plats',
    'error_doc__legend' => 'Feldokument',
    'error_doc__edit_title' => 'Redigera felokument',
    'error_doc_erorr_invalid_url_location' => 'URL-adressen är ogiltig. Ange korrekt URL.',
    'error_doc_erorr_invalid_file_location' => 'Filsökvägen är ogiltig. Ange korrekt filsökväg.',
    'error_doc__type_default' => 'Standard',

    'webdirs__tabs_protection' => 'Skydd',
    'pb_webdirs' => 'Virtuella kataloger',

    'webdirs_remove_title' => 'Följande virtuella kataloger kommer att tas bort:',
    'webdirs_mime_types_remove_title' => 'Följande MIME-typer kommer att tas bort:',
    'webdirs_preferences_title' => 'Virtuella kataloginställningar',
    'webdirs_permissions_title' => 'Särskilda behörigheter för filer och mappar',
    'webdi_protection_disable_confirm' => 'Vill du verkligen ta bort skyddet från den virtuella katalogen? Detta kommer också ta bort alla skyddad katalog-användare och katalogskyddsinställningar.',
    'bt_protect' => 'Skydda',
    'bt_unprotect' => 'Ta bort skydd',
    'bt_show_additional_users' => 'Visa flera användare',
    'bt_hide_additional_users' => 'Visa färre användare.',
    'error_doc__list_title' => 'Feldokument',
    'error_doc__list_header' => 'Feldokument',
    'error_doc__code_400' => 'Felaktig begäran',
    'error_doc__code_401' => 'Inte auktoriserad',
    'error_doc__code_401.1' => 'Obehörig - inloggningen misslyckades.',
    'error_doc__code_401.2' => 'Obehörig - inloggningen misslyckades till följd av serverkonfigurationen',
    'error_doc__code_401.3' => 'Obehörig - obehörig till följd av ACL på resurs',
    'error_doc__code_401.4' => 'Obehörig - auktoriseringen misslyckades pga. filter',
    'error_doc__code_401.5' => 'Obehörig - auktoriseringen misslyckades genom ISAPI/CI-appen',
    'error_doc__code_401.7' => 'Obehörig - nekat till följd av URL-auktoriseringspolicyn',
    'error_doc__code_403' => 'Förbjuden',
    'error_doc__code_403.1' => 'Förbjudet - Åtkomst för utförande nekad',
    'error_doc__code_403.2' => 'Förbjudet - Åtkomst för läsning nekad',
    'error_doc__code_403.3' => 'Förbjudet - Åtkomst för skrivning nekad',
    'error_doc__code_403.4' => 'Förbjudet - SSL krävs',
    'error_doc__code_403.5' => 'Förbjudet - SSL 128 krävs',
    'error_doc__code_403.6' => 'Förbjudet - IP-adress avvisad',
    'error_doc__code_403.7' => 'Förbjudet - Klientcertifikat återkallat',
    'error_doc__code_403.8' => 'Förbjudet - Åtkomst till webbplatsen nekad',
    'error_doc__code_403.9' => 'Förbjudet - För många användare',
    'error_doc__code_403.10' => 'Förbjudet - Ogiltig konfiguration',
    'error_doc__code_403.11' => 'Förbjudet - Lösenordsändring',
    'error_doc__code_403.12' => 'Förbjudet - Åtkomst för kartläggaren nekad',
    'error_doc__code_403.13' => 'Förbjudet - Klientcertifikat återkallat',
    'error_doc__code_403.14' => 'Förbjudet - Katalogbläddring nekas.',
    'error_doc__code_403.15' => 'Förbjudet - Kundens åtkomstlicenser har överskridits',
    'error_doc__code_403.16' => 'Förbjudet - Klientcertifikat obetrott eller felformaterat',
    'error_doc__code_403.17' => 'Ej tillåtet - Klientcertifikatet har förfallit eller är ännu inte giltigt',
    'error_doc__code_403.18' => 'Förbjudet - Kan inte utföra begäran från denna programpool',
    'error_doc__code_403.19' => 'Förbjudet - Åtkomst CGI nekad',
    'error_doc__code_403.20' => 'Förbjuden - Passinloggning misslyckades',
    'error_doc__code_404' => 'Hittades inte',
    'error_doc__code_404.2' => 'Kunde inte hittas - nekat till följd av låsningspolicy',
    'error_doc__code_404.3' => 'Kunde inte hittas - Nekat till följd av MIMEMAP-policy',
    'error_doc__code_405' => 'Metoden är inte tillåten',
    'error_doc__code_406' => 'Inte accepterat',
    'error_doc__code_407' => 'Proxy-autentisering krävs',
    'error_doc__code_412' => 'Precondition misslyckades',
    'error_doc__code_414' => 'Begärande-URI var för lång',
    'error_doc__code_415' => 'Medietypen stöds inte',
    'error_doc__code_500' => 'Internt serverfel',
    'error_doc__code_500.12' => 'Internt serverfel - Omstart av programmet',
    'error_doc__code_500.13' => 'Internt serverfel - Servern för upptagen.',
    'error_doc__code_500.15' => 'Internt serverfel - Direkta förfrågningar för GLOBAL.ASA förbjudna',
    'error_doc__code_500.16' => 'Internet serverfel - UNC-åtkomstfel',
    'error_doc__code_500.17' => 'Internt serverfel - URL-auktoriseringsarkiv hittades inte',
    'error_doc__code_500.18' => 'Internt serverfel - URL-auktoriseringsarkiv kan inte öppnas',
    'error_doc__code_500.19' => 'Internt serverfel - felaktig filmetadata',
    'error_doc__code_500.100' => 'Internt serverfel - ASP-fel',
    'error_doc__code_501' => 'Inte implementerad',
    'error_doc__code_502' => 'Felaktig gateway',
    'error_doc__code_503' => 'Tjänsten är inte tillgänglig för närvarande',

    'mimetype__extension' => 'Anknytning',
    'mimetype__content' => 'Innehåll',
    'mimetypeslist__title' => 'MIME-typer',
    'mimetypes__title' => 'MIME-typer',
    'mimetypes__select_to_remove' => 'Markera vilka MIME-typer du vill ta bort.',
    'mimetypes__select_for_remove' => "Välj de MIME-typer som ska tas bort.",
    'mimetypes_remove__title' => 'Ta bort MIME-typ',
    'mimetype__legend' => 'MIME-typ',
    'mimetype_edit__title' => 'Redigera MIME-typ',
    'mimetype_edit__already_exists' => 'MIME-typen är redan definierad för detta tillägg.',
    'mimetype_edit__not_exists' => 'MIME-typen finns inte.',
    'mimetype__content_type_other' => 'Anpassad...',

    'b_webdir_protection_enable' => 'Gör URL som svarar mot katalogen som är lösenordsskyddad.',
    'b_webdir_protection_disable' => 'Gör URL som svarar mot katalogen som är åtkomlig för alla.',
    'b_webdir_protection_disabled' => 'Det virtuella katalogskyddet är inaktiverat.',

    'b_pd_usr_create' => 'Klicka för att skapa denna skyddade URL-användare.',
    'php__changeversion_title' => "Markera PHP-version",
    'php__group_php_version' => "PHP-version",

    'virtualdir__name' => 'Namn',
    'virtualdir__path' => 'Sökväg',
    'virtualdir__read' => 'Läsbehörighet',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Skrivbehörighet',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Script källa åtkomst',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Katalogsökning',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Köra',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Åtkomst till loggfil',
    'virtualdir__app_create' => 'Skapa program',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Byter till anonym autentisering.',
    'virtualdir__auth_windows' => 'Sätter på Windows-autentisering.',
    'virtualdir__auth_not_enabled' => 'Anonym eller Windows-autentisering måste sättas på.',
    'virtualdir__require_ssl' => 'Kräv SSL/TLS',
    'virtualdir__enable_default_doc' => 'Använd standarddokument',
    'virtualdir__default_doc' => 'Sökordning standarddokument',
    'virtualdir__enable_parent_paths' => 'Tillåt föräldrasökvägar att användas',
    'virtualdir__execute_in_mta' => 'Tillåt programmets utförande i MTA-läget (Multi-Threaded Apartment)',
    'virtualdir_create__title' => 'Skapa virtuell katalog i %1',
    'virtualdir_edit__title' => 'Egenskaper för den virtuella katalogen %1',
    'virtualdir_edit__legend' => 'Virtuell katalog',
    'virtualdir_edit__application_legend' => 'Programinställningar',
    'virtualdir_edit__security_legend' => 'Katalogsäkerhet',
    'virtualdir_edit__documents_legend' => 'Dokument',
    'virtualdir_edit__list_legend' => 'Kapslade virtuella kataloger',
    'virtualdir_error__path_not_in__' => 'En ogiltig sökväg har angetts',
    'virtualdir_error__already_exists' => 'En katalog med det namnet finns redan.',
    'virtualdir_root' => 'Virtuella kataloger',
    'virtualdir_root__title' => 'Virtuella kataloger',
    'virtualdir_root__list_legend' => 'Virtuella kataloger',
    'virtualdir_se__none' => 'Ingen',
    'virtualdir_se__script' => 'Scripts bara',
    'virtualdir_se__script_execute' => 'Skript och körbara filer',
    'virtualdirs__title' => 'Virtuella kataloger',
    'virtualdirs__path_not_exists' => 'Ogiltig sökväg.',
    'virtualdirs__select_for_remove' => "Markera de virtuella kataloger som ska tas bort.",
    'virtualdirs_remove__title' => 'Ta bort virtuella kataloger',
    'virtualdirs_phys_dir_exist' => 'En fysisk katalog med det namnet existerar redan. Om du fortsätter kommer det bli otillgängligt. Vill du fortsätta?',
    'virtualdir_auto_create_dir' => "Skapa en fysisk katalog med samma namn som den virtuella katalogen",

    'asp_max_default_text' => 'Definierat av föräldrakatalogen (%1 KB)',
    'asp_max_default_text_site' => 'Definierat av IIS (%1 KB)',
    'asp_max_buffer_text' =>'Maximal storlek på ASP-bufferten (KB)',
    'asp_max_body_text' => 'Maximal storlek på enhetskroppen för en ASP-förfrågan (kB)',
    'asp_buffers_legend' =>'ASP-inställningar',

    'asp_debug_default_text' =>'Definierat av föräldrakatalogen',
    'asp_debug_default_text_site' =>'Definierat av IIS',
    'asp_client_debug_text' =>'Aktivera felsökning av ASP-klientskriptkörning',
    'asp_server_debug_text' =>'Aktivera felsökning av ASP-serverskriptkörning',

    'webdirs__list_with_broken_dirs' => "Det finns virtuella kataloger som är kopplade till obefintliga fysiska mappar.",
    'webdirs__vdir_physical_path_not_exist' => "Den virtuella katalogen är kopplad till en fysisk mapp som inte finns.",
    'webdirs__physical_path_not_exist' => "Den angivna sökvägen finns inte.",

    'filemanager__new_dir_title' => 'Skapa katalog',
    'php__configuration_title' => "PHP-konfiguration",

    'permissions__title' => 'Inställning av åtkomstbehörigheter',
    'permissions__title_advanced' => 'Inställning av avancerade åtkomstbehörigheter',
    'permissions__inherit_from_parent' => 'Låt ärftliga behörigheter från det överordnade objektet spridas till det här objektet och underordnade objekt. Inkludera dessa med de poster som uttryckligen är definierade här.',
    'permissions__replace_on_children' => 'Ersätt behörighetsposter på alla barnobjekt med posterna som visas här.',
    'permissions__group_or_user_name' => 'Grupp- eller användarnamn',
    'permissions__Permissions_for' => 'Behörigheter för',
    'permissions__allow' => 'Tillåt',
    'permissions__deny' => 'Förneka',
    'permissions__FullControl' => 'Fullständig behörighet',
    'permissions__Modify' => 'Ändra',
    'permissions__ReadAndExecute' => 'Läsa och köra',
    'permissions__ListFolderContents' => 'Visa mappinnehåll',
    'permissions__Read' => 'Läsa',
    'permissions__Write' => 'Skriva',
    'permissions__ReadControl' => 'Läsa behörigheter',
    'permissions__WriteControl' => 'Skrivkontroll',
    'permissions__ExecuteControl' => 'Körkontroll',
    'permissions__TraverseFolderOrExecuteFile' => 'Bläddra mapp/köra fil',
    'permissions__ListFolderOrRead' => 'Lista mapp/läsa data',
    'permissions__CreateFilesOrWrite' => 'Skapa filer/skriva data',
    'permissions__CreateFoldersOrAppend' => 'Skapa mappar/lägga till data',
    'permissions__DeleteSubfoldersandFiles' => 'Ta bort undermappar och filer',
    'permissions__Delete' => 'Ta bort',
    'permissions__ChangePermissions' => 'Ändra behörigheter',
    'permissions__TakeOwnership' => 'Bli ägare',
    'permissions__inherited_from' => 'Ärvs från',
    'permissions__not_inherited' => '<ärvs inte>',
    'permissions__apply_to' => 'Använd för',
    'permissions__apply_onto' => 'Använd för:',
    'permissions__apply_onto1' => 'Endast den här mappen',
    'permissions__apply_onto2' => 'Endast undermappar',
    'permissions__apply_onto3' => 'Den här mappen och undermappar',
    'permissions__apply_onto4' => 'Endast filer',
    'permissions__apply_onto5' => 'Den här mappen och filer',
    'permissions__apply_onto6' => 'Endast undermappar och filer',
    'permissions__apply_onto7' => 'Den här mappen, undermappar och filer',

    'filemanager__not_allowed_dir' => "Det är inte tillåtet att ändra tillstånd för denna mapp.",

    'filemanager__allow' => "Tillåt",
    'filemanager__deny' => "Förneka",
    'filemanager__user_domusr' => 'Webbplatsens administratör',
    'filemanager__user_webusr' => 'Webbanvändare',
    'filemanager__user_admins' => 'Administreraistratörer',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'ASP.NET-användare',
    'filemanager__user_poolusr' => 'Programmets poolanvändare',
    'filemanager__user_sysaccount' => 'Ytterligare systemanvändare',

    'bt_permissions_advanced' => 'Avancerat',
    'b_permissions_advanced' => 'Klicka här för att visa och ange särskilda behörigheter.',

    'b_hotlinkprotection' => 'Ställ in ett hotlink-skydd för webbplatsen.',
    'b_hotlinkprotection_on' => 'Aktivera hotlink-skyddet för webbplatsens innehåll.',
    'b_hotlinkprotection_off' => 'Inaktivera hotlink-skyddet för webbplatsens innehåll.',

    'bt_hotlinkprotection' => 'Hotlink skydd',
    'hotlinkprotection__title' =>'Hotlink skydd',
    'hotlinkprotection__friend_domains' => 'Adresser till vänliga webbplatser',
    'hotlinkprotection__extensions' => 'Skyddade filtillägg',

    'hotlinkprotection_invalid_friend_domains' => 'Felaktiga namn för vänliga domäner.',
    'hotlinkprotection_invalid_extensions' => 'Filnamnstillägget innehåller felaktiga tecken.',

    'i_domain_alias_status_on' => 'Domänalias är aktiverat.',
    'i_domain_alias_status_off' => 'Domänalias är inaktiverat.',
    'i_domain_alias_status_with_parent' => 'Domänalias är inaktiverat eftersom domänen är avstängd.',
    'i_domain_alias_turn_off' => 'Klicka för att inaktivera.',
    'i_domain_alias_turn_on' => 'Klicka för att aktivera.',
    'i_domain_alias_mail_on' => 'E-posttjänsten är aktiverad för denna domänalias.',
    'i_domain_alias_mail_off' => 'E-posttjänsten är inaktiverad för denna domänalias.',
    'i_domain_alias_mail_with_parent' => 'E-posttjänsten är inaktiverad efersom domänaliasen är avstängd.',
    'i_domain_alias_web_on' => 'Webbtjänsten är aktiverad för denna domänalias.',
    'i_domain_alias_web_off' => 'Webbtjänsten är inaktiverad för denna domänalias.',
    'i_domain_alias_web_with_parent' => 'Webbtjänsten är inaktiverad efersom domänaliasen är avstängd.',
    'i_domain_alias_dns_on' => 'DNS aliastjänst är påkopplad för denna domänalias.',
    'i_domain_alias_dns_off' => 'DNS aliastjänst är avstängd för denna domänalias.',
    'i_domain_alias_dns_with_parent' => 'DNS-synkroniseringen med den överordnade domänen är inaktiverad eftersom domänaliaset är avstängt.',
    'i_domain_alias_seoRedirect_on' => 'Omdirigering med HTTP 301-koden slås på för detta domänalias.',
    'i_domain_alias_seoRedirect_off' => 'Omdirigering med HTTP 301-koden är avstängd för detta domänalias.',
    'i_domain_alias_seoRedirect_with_parent' => 'Omdirigering med HTTP 301-koden stängs av eftersom domänaliasen är avstängd.',

    'domain_alias__control_title' => 'Domänalias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Tjänstnamn',
    'domain_alias__control_details_title' => 'Detaljer',

    'domain_alias__invalid_values' => 'Domännamnet du har specificerat är ogiltigt. Domännamn kan omfatta bokstäver, siffror och bindestreck. Ingen del av domännamnet mellan punkter får överstiga 63 tecken.',
    'domain_alias__domain_already_exists' => "Oriktigt namn på domänalias %1. Domänen %1 finns redan.",
    'domain_alias__www_prefix_domain_already_exists' => "Oriktigt namn på domänaliaset www.%1. Detta alias är redan skapat för domänen %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Oriktigt namn på domänaliaswebbmail.%1. Detta alias är redan skapat för domänen %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Oriktigt namn på domänaliaslistorna.%1. Detta alias är redan skapat för domänen %1.',
    'domain_alias__dns_record_already_exists' => 'Kan inte ställa in domänalias %1 eftersom en DNS-post som pekar på värddatorn %1 redan finns.',
    'domain_alias__domain_alias_already_exists' => "En domänalias med ett sådant namn finns redan.",
    'domain_aliases__mail_server_not_support_aliases' => 'E-postservern stödjer inte domänens alias-funktion Domänalias kanske inte fungerar korrekt.',
    'domain_alias__restrict_domain_creation' => 'Det specificerade namnet för ett domänalias är förbjudet av den serveromfattande policyn. Om detta domänaliaset tillhör dig, ta kontakt med din värdtjänstleverantör.',
    'domain_alias__restrict_creation_with_www' => 'Ange domännamnet utan prefixet \'www\'. WWW-prefixet för domänen läggs automatiskt till webbserverns konfiguration.',
    'domain_unable_to_set_name' => 'Felaktigt namn %1.',

    'domain_alias__domain_service_dns_disabled' => 'Denna domän betjänas av en annan DNS-server.',
    'domain_alias__domain_service_dns_enabled_master' => 'Denna DNS-server fungerar som en master-namnserver för denna DNS-zon.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Denna DNS-server fungerar som en slav-namnserver för denna DNS-zon.',
    'domain_alias__domain_service_mail_enabled' => 'Posttjänsten är påsatt för domänen.',
    'domain_alias__domain_service_mail_disabled' => 'Posttjänsten är avstängd för domänen.',
    'domain_alias__domain_service_mail_mx' => '%1 används som postserver.',

    'domain_alias__service_seoRedirect_hint' => 'När besökare öppnar aliasets URL, kommer de omdirigeras till URL:en för den primära domänen. Plesk använder sökmotorvänlig HTTP 301-omdirigering, vilket betyder att sökmotorrankningen inte kommer att delas mellan URL:erna.',

    'bt_task_run_now' => 'Kör nu',
    'ftp__read_perm' => "Läsbehörighet",
    'ftp__write_perm' => "Skrivbehörighet",

    'filemanager__upload_backup_file_hint' => 'Här kan du ladda upp säkerhetskopierade filer till Plesk-lagringen. Maximal filstorlek är begränsad till två gigabyte.',

    'additional_key__used' => 'aktiverad',

    '__default_for_mssql' => 'standard för MS SQL',

    '__login_does_not_pass_validation' => "Användarnamnet är ogiltigt. Se till att det uppfyller följande krav: %1",
    '__login_allowed_symbols' => 'Bara alfanumeriska tecken inklusive punkter, streck och understrykningstecken är tillåtna. Det första tecknet ska vara alfanumeriskt.',

    'restart__nginx' => 'Reverse-proxyserver (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Jag vill få allmän produktinformation och meddelanden från Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Jag vill få säkerhetsrelaterad information och andra tekniska meddelanden från Plesk.",

    'server_preferences__webdeploy_include_password' => 'Inkluderar användarens lösenord i filen med Web Deploy-publiceringsinställningar',

    '__login_status_inactive' => 'Ditt konto är inaktivt. Kontakta Plesk-administratören.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Återgå till sidan Verktyg & inställningar. Migreringen fortsätter i bakgrunden.',

    'ui__admin-alias-info__description' => "Redigera kontaktinformationen för det ytterligare administratörskontot.",
    'ui__admin-alias-info__short-title' => "Kontaktinformation",
    'ui__admin-alias-info__title' => "Extra administratörskontoinformation uppdaterad",
    'ui__admin-alias-password__description' => "Ändra den extra administratörens lösenord.",

    'ui__admin-alias-password__short-title' => "Ändra lösenord",
    'ui__admin-alias-password__title' => "Extra administratörs lösenord",
    'ui__admin-alias__description' => "Visa och hantera extra administratörskontons information.",

    'chk_js__warning_about_login_syntax' => "Du kan använda alfanumeriska gemener, bindestreck och understrykningstecken i användarnamnet. Användarnamnet ska starta med ett alfabetiskt tecken. Lösenordet ska inte innehålla användarnamn och citattecken.",
    'chk_js__warning_about_ftp_login_syntax' => "Du kan använda alfanumeriska tecken, bindestreck och understreck i användarnamnet.",
    'chk_js__warning_about_login_syntax_win' => "Du kan använda alfanumeriska gemener, bindestreck, punkt och understreck i användarnamnet. Användarnamnet ska starta med ett alfabetiskt tecken eller en siffra. Lösenordet ska inte innehålla användarnamn och citattecken.",
    'chk_js__warning_about_passwd_syntax' => "Använd inte citattecken, mellanslag och nationella bokstäver i ett lösenord.\nLösenordets längd bör vara mellan %1 och %2 tecken långt och bör inte innehålla användarnamnet.",
    'chk_js__warning_about_plesk_login_syntax' => "Du kan använda alfanumeriska gemener, punkt, bindestreck och understrykningstecken i användarnamnet.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Du kan använda alfanumeriska gemener, bindestreck och understrykningstecken i användarnamnet. Användarnamnet ska starta med ett alfabetiskt tecken.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Använd inte citattecken, mellanslag och nationella bokstäver i ett lösenord.\nLösenordets längd bör vara mellan %1 och %2 tecken långt och bör inte innehålla användarnamnet.",
    'chk_js__warning_about_pam_passwd_error' => "Fel systemanvändarkonto har specificerats: %1",

    'cmd_server__admin_alias_not_found' => "Kan inte hitta det extra administratörskontot.",

    'panel_branding__skins_already_exists' => "Obs: Temat '%1' finns redan. Det ersätts med det tema du nu installerar.",
    'panel_branding__skins_file_exists' => "Kan inte skapa en katalog för temat '%1': en fil med ett sådant namn finns redan.",

    'actionlog__login_failed' => 'lyckades inte logga in',
    'actionlog__event_cp_user_login_failed' => 'Plesk-användare lyckades inte logga in',
    'actionlog__api_login_failed' => 'Lyckades inte logga in genom API',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk-användare lyckades inte logga in genom API',
    'actionlog__pw_reset' => 'begärde återställning av lösenord',

    'ch_pass_by_secret__email_subject' => "Lösenordspåminnelse i Plesk",
    'ch_pass_by_secret__email_body' => "Hej %2,\n\nFör att skapa ett nytt lösenord, följ länken: %1\n\nDin inloggning: %3",
    'ch_pass_by_secret__message_send_error' => 'Kunde inte skicka den hemliga koden: %1',
    'ch_pass_by_secret__title' => 'Ändra ditt lösenord',
    'ch_pass_by_secret__secret' => 'Hemlig kod',

    'custom_button__noframe' => "Använd inte ramar",

    'custom_button__internal_hint' => 'Ange huruvida URL:en ska öppnas på en Plesk-sida eller i ett nytt webbläsarfönster.',
    'custom_button__noframe_hint' => 'Om du lägger till en anpassad knapp som leder till ett Plesk-tillägg eller en app på Kundpanelen, kan du specificera hur denna ändelse/app ska visas: i en ram eller som en del av Plesk GUI.',


    'actionlog__patch' => 'Uppdatera',
    'actionlog__patch_available' => 'tillgängliga',
    'actionlog__event_patch_available' => 'Uppdatering tillgänglig',
    'actionlog__patch_installed' => 'installerad',
    'actionlog__event_patch_installed' => 'Uppdatering installerad',

    'actionlog__extension' => 'Anknytning',
    'actionlog__extension_status' => 'Ändelsens status',
    'actionlog__cloning' => 'Serverkloning',
    'actionlog__cloning_complete' => 'klar',
    'actionlog__event_cloning_complete' => 'Serverkloning klar',

    'actionlog__ssl_web_binding' => 'SSL/TLS certifikat på domänen',
    'actionlog__ssl_web_binding_update' => 'tilldelad/otilldelad',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS-certifikat på domänen tilldelat/otilldelat',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-certifikat på webbmail',
    'actionlog__ssl_web_mail_binding_update' => 'tilldelad/otilldelad',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-certifikat på webbmail tilldelat/otilldelat',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-certifikat på e-postservern',
    'actionlog__ssl_mail_binding_update' => 'tilldelad/otilldelad',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-certifikat på e-postservern tilldelad/otilldelad',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-certifikat på Plesk',
    'actionlog__ssl_panel_binding_update' => 'tilldelad/otilldelad',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-certifikat på e-postservern tilldelad/otilldelad',

    'actionlog__hostname' => 'Serverns värdnamn',
    'actionlog__hostname_changed' => 'ändrad',

    'actionlog__event_mail_management_status_update' => 'Statusuppdatering för mail-hantering',
    'actionlog__mail_management' => 'Status för mail-hantering',
    'actionlog__mail_management_status_update' => 'uppdaterad',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Totalt efter domäner',

    'chk_js__warning_about_admin_passwd_syntax' => "Använd inte citationstecken, mellanslag, semikolon och nationella alfabetstecken i lösenordet.\nLösenordet ska vara mellan %1 och %2 tecken långt, och det ska inte innehålla användarnamnet.",

    'passwordSecurityLevelCheckFailed' => 'Lösenordet är inte tillräckligt komplicerat. Enligt serverpolicyn är den minsta lösenordsstyrkan %1. För att förbättra lösenordsstyrkan, använd siffror, versaler och gemener och specialtecken som !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Mycket svagt',
    'passwordSecurityLevelCheckFailedWeak' => 'Svagt',
    'passwordSecurityLevelCheckFailedMediocre' => 'Medium',
    'passwordSecurityLevelCheckFailedStrong' => 'Stark',
    'passwordSecurityLevelCheckFailedStronger' => 'Mycket starkt',

    'cu__php_settings__command_update_all' => "Uppdatera PHP-inställningar per domän för alla domäner, i enlighet med den serveromfattande php.ini-filen.",
    'cu__php_settings__update_all_done' => "PHP-inställningar per domän för alla domäner har uppdaterats.",

    'filemanager__invalid_path' => "En ogiltig sökväg har angetts",

    'rdp_app__msactivex_comment' => 'Vi rekommenderar att du använder Internet Explorer eftersom Microsoft RDP ActiveX-komponenten inte fungerar med andra webbläsare.',

    'additional_key__descr_app' => 'Applikation',
    'additional_keys__used_keys' => ', %1 nycklar använda',
    'additional_key__descr_key_mailboxes' => 'E-postlådor',

    'ui__client/domain/dns/sync__description' => 'Tillämpa ändringarna från den serveromfattande DNS-mallen till zonen.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Kan inte tillämpa DNS-mallens ändringar i zonen eftersom den betjänas av en annan DNS_server.',
    'ui__client/domain/dns/sync__short-title' => 'Tillämpa DNS-malländringarna',
    'ui__client/domain/dns/sync__done' => 'Ändringarna från DNS-mallen har tillämpats korrekt på zonen.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Tillämpa ändringarna från den serveromfattande DNS-mallen till zonen.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Kan inte tillämpa DNS-mallens ändringar i zonen eftersom den betjänas av en annan DNS_server.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Tillämpa DNS-malländringarna',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Ändringarna från DNS-mallen har tillämpats korrekt på zonen.',
    'dns__dns_zone_sync_form' => 'Tillämpa DNS-malländringarna',
    'dns__dns_zone_sync_legend' => 'Alternativ',
    'dns__dns_zone_sync_ways' => 'Välj ett av följande alternativ',
    'dns__dns_zone_sync_way_safe' => 'Applicera ändringarna på oförändrade zoner. Om ett område har anpassats (nya poster har tillagts eller befintliga poster har ändrats), tillämpar inte Plesk ändringarna från mallen till sådana områden.',
    'dns__dns_zone_sync_way_forced' => 'Applicera förändringarna till alla zoner. Plesk tillämpar ändringarna från mallen till alla DNS-zoner inklusive de anpassade. Tänk på att användarmodifierade poster alltid förblir intakta. Till exempel, om mallen innehåller en ny post som redan har tillagts av en kund, sparar Plesk-kundens post.',
    'dns__dns_default_ipv4_modified' => 'Poster med denna IP-adress anses som användarmodifierade och synkroniseras inte med serveromfattande DNS-mallar.',
    'dns__dns_default_ipv6_modified' => 'Poster med denna IP-adress anses som användarmodifierade och synkroniseras inte med serveromfattande DNS-mallar.',

    'dns__view_dns_record_master_title' => 'Visa resursposter',
    'dns__view_dns_record_off_title' => 'Visa namnserverposter',
    'dns__view_dns_record_slave_title' => 'Visa primär DNS-server-poster',

    'dns_unable_to_resolve_hostname' => "Det går inte att lösa värdnamnet \"%1\": %2\nKontrollera att driftsystemets DNS-resolver är inställd och fungerar.",

    'no_database_server_available' => 'Det finns inga databasservrar tillgängliga för detta abonnemang.',

    'database_server_edit_form__admin_add_hint' => "Specificera databasadministratörens autentiseringsuppgifter som Plesk kommer att använda för att få tillgång till databasservern. Ett administratörskonto med dessa autentiseringsuppgifterna måste finnas på databasservern.",
    'database_server_edit_form__admin_edit_hint' => "Här kan du ändra autentiseringsuppgifterna som Plesk använder för att få tillgång till databasservern. Dessa inloggningsuppgifter måste överensstämma med databasadministratörens. Exempelvis: efter att du ändrat administratörens inloggningsuppgifter på databasservern, är det nödvändigt att ändra dem också i Plesk.",
    'database_server_edit_form__admin_change_hint' => 'Här kan du ändra autentiseringsuppgifterna som Plesk använder för att få tillgång till databasservern. Om du ändrar användarnamn eller lösenord nedan, kommer databasanvändare kontot med administrativa rättigheter att uppdateras både på databasservern och i Plesk..',
    'database_server_edit_form__version' => 'Databasserverversion',
    'database_used_by_application_can_not_be_moved' => 'Kan inte flytta databasen: en webbplatsapplikation använder denna databas.',
    'database_server_database_list__subscription' => 'Abonnemang',
    'database_server_database_list__webspace' => 'Abonnemang',
    'bt_assign_subscription_selected' => 'Flytta till abonnemanget',
    'bt_cp_login' => 'Öppna i Kundpanelen',
    'bt_cp_login_classic_mode' => 'Hantera värdtjänster',
    'hint_cp_login' => 'Hantera databasen i abonnentens Kundpanel.',
    'hint_cp_admin_login' => 'Hantera databasen.',
    'hint_cp_login_classic_mode' => 'Hantera databasen.',
    'database_user_update_orphaned_is_restricted' => 'Uppdatering av icke-relaterad databasers användarkonton är förbjuden. Du kan endast radera eller reparera dem.',

    'database_unable_to_get_max_filesize_default_message' => 'Kan inte bestämma den maximala filstorleken för databasen: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Kan inte ställa in maximal filstorlek för databasen: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Kan inte bestämma den maximala loggfilstorlek för databasen: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Kan inte ställa in maximal loggfilstorlek för databasen: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Kan inte bestämma den aktuella gränsen för filstorleken för Microsoft SQL-databas \'%1\'. Det går inte att ställa in en ny gräns.',
    'database_unable_to_set_max_filesize' => 'Kan inte ställa in gränsvärdet för filsstorleken för Microsoft SQL-databas \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Kan inte bestämma den aktuella gränsen för loggfilstorleken för Microsoft SQL-databas \'%1\'. Det går inte att ställa in en ny gräns.',
    'database_unable_to_set_max_log_filesize' => 'Kan inte ställa in gränsvärdet för loggfilsstorleken för Microsoft SQL-databas \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Kan inte skapa Microsoft SQL-databas \'%1\': dess filstorlek överstiger maximalt tillåten storlek.',
    'database_unable_to_move_because_max_filesize' => 'Kan inte flytta Microsoft SQL-databasen \'%1\': dess filstorlek överstiger maximalt tillåten storlek: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Kan inte skapa Microsoft SQL-databas \'%1\': dess loggfilstorlek är större än maximalt tillåten storlek.',
    'database_unable_to_move_because_max_log_filesize' => 'Kan inte flytta Microsoft SQL-databasen \'%1\': dess loggfilstorlek är större än maximalt tillåten storlek: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Kan inte återställa Microsoft SQL-databasen \'%1\': dess filstorlek överstiger maximalt tillåten storlek.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'En identisk MS SQL-server har redan registrerats i Plesk. Specificera en annan MS SQL-server som sandlåda.',
    'database_server__mssql_server_registered_as_sandbox' => 'En identisk sandlåda MS SQL-server har redan registrerats i Plesk. Specificera en annan MS SQL-server som sandlåda.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Kunde ej ansluta till servern via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Funktionen %1 stöds inte av följande tjänstenoder: %2. Denna funktion kommer att vara inaktiverad för alla objekt som har skapats i dessa noder.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Funktionen %1 stöds inte av denna server. Denna funktion kommer att inaktiveras för alla återställda objekt.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponenten %1 har inte installerats. Den kommer inte att finnas tillgänglig för följande webbplatser:{{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponenten %1 har inte installerats. Den kommer att ersättas med %2 för följande webbplatser: {{objekt}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Aktuell Plesk-version stödjer inte användarnamn med punkt (.) tecken. Kunder och återförsäljare med sådana användarnamn kommer inte att återställas.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Kan inte hitta en säkerhetskopia med datan för %1 %2. Datan för %1 %2 kommer inte att återställas.',

    'bu_conflict_resolver_zone_master_removed' => "Kan inte återställa master-DNS-posten: posten i slavzonen pekar på den befintliga IP-adressen %1. Master-DNS-posten kommer att tas bort från slavzonen.",

    'bu_conflict_resolver_not_available_scripting' => '%1 stöds inte.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 stöds inte. Den kommer inte att finnas tillgänglig för följande webbplatser:{{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponenten %1 har inte installerats.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Den kommer inte att finnas tillgänglig för följande servicenoder: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Den kommer inte att finnas tillgänglig för följande objekt:{{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Följande databasservrar är inte tillgängliga på denna server: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL-databasens säkerhetskopierade fil sparas i internt MS SQL-format, vilket kan återställas endast till den lokala MS SQL-servern eller till den fjärrstyrda MS SQL-servern med helt konfigurerade säkeringskopieringsinställningarna. Några av databaserna återställdes inte eftersom det inte finns någon lämplig MS SQL server registrerad i Plesk. Följande domäner påverkades: {{objects}}. Kontakta din värddatorleverantör.',

    'bu_conflict_resolver_not_available_webmail' => 'E-posttjänsten %1 är otillgänglig.  Den kommer att ersättas med %2 för följande objekt: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'E-posttjänsten %1 är otillgänglig. Den kommer att ersättas med %2 för följande Abonnemangstyper: {{objekt}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Databaser av typen '%1' stödjer inte användarnamn som sammanfaller med databasnamn. Användaren '%2' kommer att byta namn till '%3' för databasen '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Begränsningen av diskutrymmesanvändningen är inte angiven i målserverkonfigurationen. Värdet för denna inställning kommer att ändras till "Obegränsat".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Begränsningen av antalet anslutningar är inte angiven i målserverkonfigurationen. Värdet för denna inställning kommer att ändras till "Obegränsat".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Begränsningen av trafikanvändning är inte angiven i målserverkonfigurationen. Värdet för denna inställning kommer att ändras till "Obegränsat".',
    'cu__pleskrestore_backup_file_extracted' => 'Säkerhetskopiefilen extraherades till "%1".',
    '__mod_bw_not_supported' => 'Modulen mod_bw för Apache-webbservern stöds inte till följd av filsystemets konfiguration. Gränserna för trafikanvändning och maximalt antal anslutningar kommer inte att fungera.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'POP3-auktorisering för vidarebefordran av e-post stöds inte, POP3 kommer att användas i stället före SMTP-auktoriseringen. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Abonnemangstyp \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 stöds inte. Den kommer att ersättas med %2 för följande Abonnemangstyper: {{objekt}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 stöds inte. Den kommer att ersättas med %2 för följande webbplatser: {{objekt}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Det gick inte att hitta följande objekt i den säkerhetskopierade filen: %1',
    'bu_conflict_resolver_absent_domains' => 'Några objekt kan inte återställas beroende på att de tillhör följande domäner som inte hittas i Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Några webbplatser kan inte återställas beroende på att de följande överordnade domänen inte hittas i Plesk: %1§%1",
    'bu_conflict_resolver_dns_not_supported' => 'Kan inte återställa DNS-zonen: DNS-tjänsten är avstängd i serverkonfigurationen.',
    'bu_conflict_resolver_mail_not_supported' => 'Kan inte återställa e-postlådor: E-posttjänster är avstängd i serverkonfigurationen.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Den specificerade tidsgräns för inaktivitet stödjas inte av IIS webbservern. Värdet kommer att återställas till %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Den specificerade CPU limit action stödjas inte av IIS webbservern. Värdet kommer att återställas till %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'server SSL/TLS-certifikat %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-certifikat %2 av domänen %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-certifikat %1',
    'bu_conflict_resolver_absent_objects' => 'Innehållet av följande objekt kan inte återställas beroende på att objekten inte hittas i Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Innehållet av följande e-postlådor kan inte återställas beroende på att e-postlådorna inte hittas i Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Innehållet av följande e-postlistor kan inte återställas beroende på att e-postlistorna inte hittas i Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Innehållet av följande objekt kan inte återställas beroende på att objekten inte hittas i Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Återställningen av applikationen "%1" i "%2" misslyckades eftersom en annan applikation redan har installerats på "%3". Du kan ta bort den installerade applikationen och försöka igen.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Inget stöd för postens automatiska svarsfunktion.',
    'bu_conflict_resolver_not_available_mail_content' => 'Inget stöd för e-postens innehållsåterställning.',
    'bu_conflict_resolver_invalid_mail_name' => 'Följande e-postkonton har inte återställs, då underadresser är aktiverade och vissa e-postadresser innehåller tecknet "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Följande användare har inte återställs, då underadresser är aktiverade och vissa e-postadresser innehåller tecknet "%1": %2',
    'expiration_unsupported' => "Gränsen 'expiration' stöds inte.",

    'component_name__dbconnector' => "Databasanslutare",
    'component_name__mysqlserver' => 'MySQL-server',
    'component_name__troubleshooting' => 'Felsökning',

    '__subscription_has_no_license_key' => 'Abonnemangsresurserna tillhandahålls av servicenoden #%1 som inte har någon tillhörande licensnyckel.',
    '__subscription_has_expired_license_key' => 'Abonnemangsresurserna tillhandahålls av servicenoden #%1 vars licensnyckel %2 har upphört att gälla.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Kan inte spara konfigurationsfilerna',
    '__cfgmonConfigurationFileSaveErrorBody' => "Kan inte spara vissa konfigurationsfiler i värddatorn <%%host%%>: Följande fel inträffade:\n\n%%errors%%",

    'mail__allow_short_pop3_names' => "Namn för POP3/IMAP e-postkonton",
    'mail__allow_short_pop3_names_disabled' => "Endast fullständiga namn på POP3/IMAP e-postkonton kan användas",
    'mail__allow_short_pop3_names_enabled' => "Korta (webmaster) och fullständiga (webmaster@domain.com) namn på POP3/IMAP postkonton kan användas",
    'mail__baddomain_exists' => "Den här domänen finns redan på svarta listan.",
    'mail__block_mail_from_doms' => "Svarta listan",
    'mail__blockers' => "Blockerade domäner",
    'mail__blockers_remove' => "Ta bort blockerade domäner",
    'mail__blocker_add' => "Lägg till domäner i svarta listan",
    'mail__closed' => "stängd",
    'mail__crypted_passwd_match' => "Det finns e-postkonton som matchar de krypterade lösenorden.",
    'mail__enable_email_subaddressing' => 'Aktivera underadresser av e-post',
    'mail__enable_email_subaddressing_hint' => 'Det här alternativet aktiverar möjlighet att konfigurera e-postadresser för e-postlistor av typen %%verpStyleLink%%',
    'mail__enable_email_subaddressing_cli_desc' => 'Det här alternativet aktiverar möjlighet att konfigurera e-postadresser för e-postlistor av VERP-typ',
    'mail__dom_in_list' => "Den här domänen finns redan på svarta listan.",
    'mail__enable_rbl' => "Aktivera skräppostskydd baserat på DNS-svarta hållistor",
    'mail__enter_rbl_server' => "Skriv in DNS-zonen.",
    'mail__enter_right_ip_mask' => "Ange IP-masken mellan 1 och 32",
    'mail__enter_right_ip_mask_24' => "Ange IP-masken mellan 24 och 32",
    'mail__install_rblsmtpd_program' => "Installera rblsmtp-mjukvaran.",
    'mail__invalid_dom_name' => "Domännamnet %1 är ogiltigt.",
    'mail__invalid_pop_lock_time' => "POP3-låstidpunkt är ogiltig.",
    'mail__invalid_rbl_server' => "DNS-zonnamnet är ogiltigt.",
    'mail__ip_and_mask' => "IP-adress/mask",
    'mail__ip_and_mask_exists' => "Detta IP-adress/nätmaskpar finns redan.",
    'mail__lock_time' => "låstidpunkt",
    'mail__general_options' => 'Allmänna alternativ',
    'mail__relay_options' => 'Vidaresändningsalternativ',
    'mail__mailnames_passwd_match' => "Det finns e-postkonton och lösenordspar som matchar.",
    'mail__select_domains_for_remove' => "Markera de domäner som ska tas bort.",
    'mail__max_size' => "Största meddelandestorlek",
    'mail__mbox_quota' => "E-postkvot",
    'mail__min' => "Min",
    'mail__total_files_size' => "Total katalogstorlek: %1",
    'mail__filename_already_in_repository' => "En fil med samma namn finns redan i katalogen",
    'mail__no_white_list_mask_feature_24' => "Du ska använda ett maskvärde på 24 eller högre.\nDin e-postserver stöder inte inställningsmasker. Vi kan bara emulera inställningsmask för värden som inte är mindre än 24.",
    'mail__open' => "öppen",
    'mail__open_relay_warning' => "Om du öppnar ditt postrelä utsätter du mailservern för spam.\n\nSpara inställningen endast om du tillfälligt vill testa mailservern eller om din Plesk-server befinner sig i ett intranätverk som inte är tillgängligt via Internet.\n\nBehålla inställningen?",
    'mail__pop3' => "POP3 före SMTP",
    'mail__rbl_zones' => "DNS-zoner för DNSBL-tjänsten",
    'mail__rbl_zones_hint' => "Separera posterna med ett semikolon, exempelvis: 'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "White List",
    'mail__relaying' => "Reläskifte",
    'mail__reqr_auth' => "auktorisering krävs:",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "Kunde inte lägga till e-postkontot: %1",
    'mail_server_is_not_installed' => 'E-postservern (Postfix eller Qmail) har inte installerats. Installera den för att kunna fortsätta arbeta.',
    'mail_server_not_available' => 'Det finns inga e-postservrar som stöds tillgängliga i servicenoden.',
    '__not_installed' => '(inte installerad)',
    'mail__server_name_label' => 'Installerad e-postserver',
    'mail__imap_server_name_label' => 'Installerad IMAP/POP3-server',
    'mail__server_change_hint' => 'Du kan %%serverChangeLink%%',
    'mail__server_change_link' => 'installera och använd en annan e-postserver',
    'mail__imap_server_change_link' => 'installera och använd en annan IMAP/POP3 server',
    'mail__message_submission' => 'Aktivera SMTP-tjänsten i port 587',
    'mail__message_submission_on_all_ips' => 'Aktivera SMTP-tjänsten för port 587 för alla IP-adresser',
    'mail__message_submission_bind_to' => 'På',
    'mail__message_submission_all_ip_addresses' => 'Alla IP-adresser',
    'mail__service_node_outgoing_messages_is_disabled' => 'Skräppostfiltrering för utgående e-postmeddelanden är inaktiverat.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Tjänstenoden stödjer inte begränsning av antal utgående e-postmeddelanden från en domän för domänen %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Tjänstenoden stödjer inte begränsning av antal utgående e-postmeddelanden från en postlåda för domänen %1.',
    'mail__max_outgoing_messages_enable_text' => 'Aktivera begränsningar för utgående e-postmeddelanden',
    'mail__max_outgoing_messages_enable_hint' => 'Följande gränser är standard. De kan uteslutas i varje serviceplan och abonnemang. Gränserna fungerar inte serveromfattande, men agerar som en mall för de värdtjänstplanerna och abonnnemangen som blev specificerade utan anpassade gränser. Observera att aktivering av begränsning av utgående e-postmeddelanden kan påvärka e-post serverprestanda.',
    'mail__outgoing_messages_mbox_limit_text' => 'Standardgräns på utgående meddelanden från en postlåda (per timme)',
    'mail__outgoing_messages_domain_limit_text' => 'Standardgräns på utgående meddelanden från ett domän (per timme)',
    'mail__outgoing_messages_subscription_limit_text' => 'Standardgräns på utgående meddelanden från ett abonnemang (per timme)',
    'mail__outgoing_messages_enable_sendmail_text' => 'Tillåt användare och skripts att använda Sendmail',
    'mail__outgoing_messages_enable_sendmail_hint' => 'Skripts och användare kan skicka e-postmeddelanden (å abonnemangets systemanvändares vägnar) genom att använda Sendmail även om gränserna för en postlåda och ett domän har överskridits. Maximalt antal meddelanden som kan sändas genom Sendmail vill definieras av gränsen för ett helt abonnemang. Denna inställningen tillåter inte serveromfattande bruk av skripts för Sendmail, men den agerar som en standardinställning för tjänsteplaner och abonnemang.',
    'mail__outgoing_messages_report_period_text' => 'Visa rapporter baserade på statistik för senaste',
    'mail__max_outgoing_messages_period_P1D' => '1 dag',
    'mail__max_outgoing_messages_period_P1W' => '1 vecka',
    'mail__max_outgoing_messages_period_P2W' => '2 veckor',
    'mail__max_outgoing_messages_period_P1M' => '%1 månad',
    'mail__outgoing_messages_report_period_hint' => 'Rapporterna är skapade och avisering visas på startsidan om försök att överskrida gränserna för utgående e-postmeddelanden i den specificerade perioden.',
    'mail__outgoing_messages_notification_period_text' => 'Sänd ett e-postmeddelande varje',
    'mail__max_outgoing_messages_period_PT15M' => '15 minuter',
    'mail__max_outgoing_messages_period_PT1H' => '1 timma',
    'mail__max_outgoing_messages_period_PT6H' => '6 timmar',
    'mail__max_outgoing_messages_period_PT12H' => '12 timmar',
    'mail__outgoing_messages_notification_period_hint' => 'Meddelanden ger statistik över försök till att överskrida gränserna för utgående e-postmeddelanden i den specificerade perioden.',
    'mail__outgoing_count_number_recipients_text' => 'Count the number of recipients instead of messages',
    'mail__outgoing_count_number_recipients_hint' => 'Enables mode that counts the number of recipients rather than messages when limiting Outgoing mail and counting statistics. For example, one message sent to 10 recipients will be counted as ten messages.',

    'mail__outgoing_email_mode_explicit_ip_none' => 'Ingen',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Specificera en adress av åtminstone en typ (IPv4 eler IPv6).',

    'mail__max_connections_text_courier' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS)',
    'mail__max_connections_text_dovecot' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS)',
    'mail__max_connections_hint_courier' => 'Maximalt antal servrar (IMAP eller POP3) startat.',
    'mail__max_connections_hint_dovecot' => 'Maximalt antal e-postanvändare som kan vara inloggade samtidigt.',

    'mail__max_connections_per_ip_text_courier' => 'Maximalt antal anslutningar per IP adress.',
    'mail__max_connections_per_ip_text_dovecot' => 'Maximalt antal anslutningar för en användare per IP adress.',
    'mail__max_connections_per_ip_hint_courier' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) tillåtet från samma IP adress.',
    'mail__max_connections_per_ip_hint_dovecot' => 'Maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) tillåtet från en e-postanvändare på varje IP adress.',

    'mail__outgoing_email_mode' => 'Utgående e-post modus',
    'mail__outgoing_email_mode_domain_ip' => 'Sänd från domän IP adresser',
    'mail__outgoing_email_mode_domain_name' => 'Sänd från domänens IP-adresser och använd domännamnen i SMTP-hälsningen',
    'mail__outgoing_email_mode_explicit_ip' => 'Sänd från de specificerade IP adresserna',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => 'Ett ogiltig modus för utgående e-postmeddelanden angavs.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'En ogiltig IPv4 adress angavs.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'En ogiltig IPv6-adress angavs.',
    'mail__outgoing_email_mode_unavailable' => 'Ändringar av läget för utgående epost tillåts inte, antagligen eftersom Postfix-mailservern inte har installerats i denna server.',

    'mail__smtp_settings_change_hint' => 'För att Plesk ska kunna skicka meddelanden när reläet är stängt, kan du %%changeLink%%',
    'mail__smtp_settings_change_link' => 'ändra SMTP-inställningarna',

    'mail__autoresponder_attachment_not_supported' => 'Den aktuellt använda e-postservern har inget stöd för den extra förvaltningen med automatisk svarsmekanism.',

    'mail__autoresponder_headers' => 'Extra sidhuvud för auto-svar',
    'mail__autoresponder_headers_hint' => 'Upprätta extra sidhuvuden för alla auto-svarsmeddelanden från Plesk-servern.',
    'mail__autoresponder_headers_label' => 'Extra sidhuvuden',

    'mail__smtp_white_list_not_supported' => 'Den mail-server som nu används stödjer inte vitlistning av IP-adresser.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR-masker stöds inte av den mail-server som nu är vald. Ange IP-adress i formatet "192.*0.*".',
    'mail__smtp_whitelist_mask_not_supported' => 'IP-mönster med jokertecken stöds inte av den mail-server som nu är vald. Ange IP-adress i formatet "192.0.0.0/8".',

    'sfdk_server_wide_legend' => 'DKIM skydd mot skräppost',
    'sfdk_server_wide_sign_text' => 'Tillåt signering av utgående e-post',
    'sfdk_server_wide_verify_text' => 'Kontrollera inkommande e-post',
    'sfdk_server_wide_verify_failed' => 'Kan inte ändra inställningarna för DKIM kontrolltjänst',

    'sfdk_domain__serverwide_disabled' => 'Avstängd enligt serverns policy',
    'feature__domainkeys__serverwide_disabled' => 'Det serveromfattande DKIM-skräppostskyddet är avstängt',

    'defaultcomponents__error_set_default' => 'Kan inte ställa in %1 som standard %2',
    'defaultcomponents__required_package_not_default' => 'Komponenten %1 krävs för dess funktion är inte standard.',

    '__percentage' => '%',
    '__seconds' => 'Visaconds',
    '__resource_remain' => 'Återstående',

    '__not_registered' => '(inte registrerad)',
    '__php_handler_id' => 'PHP-version',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP-hanteraren "%1" är inte registrerad. Den har troligen tagits bort från servern. Registrera en hanterare med samma egenskaper och försök igen.',
    '__php_handler_not_registered_on_domain' => 'Domän "%1": PHP-hanteraren "%2" är inte registrerad. Den har troligen tagits bort från servern. Registrera en hanterare med samma egenskaper och försök igen.',
    '__php_fpm_handler' => 'FPM-program',
    '__php_fpm-dedicated_handler' => 'Dedikerad FPM-applikation',

    'mailname_create_assigned_user_dublicate_error' => 'Kan inte skapa en användare för e-postlådan. Användaren med användarnamn %1 finns redan och har ett annat e-postkonto.',
    'mailname_create_assigned_user_role_absent_error' => 'Kan inte skapa en användare för e-postlådan. Standardrollen %1 för användaren finns inte.',

    'gphd__mime_types' => 'MIME-typer',
    'gphd__handlers' => 'Apache-hanterare',
    'gphd__ip_restrictions_allow' => 'Tillåt åtkomst till webbplatsen för specificerade värddatorer och nätverk (exklusive de som nekas)',
    'gphd__ip_restrictions_deny' => 'Neka åtkomst till webbplatsen för specificerade värddatorerna och nätverken',
    'gphd__directory_index' => 'Index-filer',
    'gphd__nginx_transparent_mode' => 'Det läge där Apache hanterar både statiskt och dynamiskt innehåll, medan nginx bara vidarebefordrar HTTP-förfrågningar och svar utan modifiering.',
    'gphd__nginx_serve_static' => 'Serva statiska filer direkt genom nginx',
    'gphd__nginx_static_extensions' => 'Statiska filtillägg som måste hanteras av: nginx',
    'gphd__nginx_serve_php' => 'Processa PHP-filer av nginx',
    'gphd__www_root' => 'WWW rotkatalog',

    'eol__none' => 'ändra inte',
    'eol__lf' => 'konvertera till Unix-stil',
    'eol__cr' => 'konvertera till MacOS-stil',
    'eol__crlf' => 'konvertera till Windows-stil',

    'ui__dns_bad_zone' => 'inkonsistent zon "%1":',
    'ui__dns_ns_has_no_address_records' => 'NS posten "%1" har ingen adresspost (A eller AAAA).',
    '__dns_bad_zone' => 'inkonsistent zon "%1":',
    '__dns_ns_has_no_address_records' => 'NS posten "%1" har ingen adresspost (A eller AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR posten "%1" är ogiltig: Posten pekar till en joker-domän.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Tillåta fjärråtkomst för databasanvändare \'%3\' hos kunden \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Kan inte tillåta fjärranslutningar för databasanvändare \'%1\': Kan inte fastställa TCP port nummer användt av Microsoft SQL server \'%2\'. De möjliga orsakerna är följande: TCP/IP protokollet är inte aktiverad i server nätverk konfigurationen eller servern är konfigurerad till att använda dynamiska TCP protokoller. Konfigurera servern till att lyssna på en specificerad TCP port och försöka att tillåta fjärranslutningar igen.',

    'command__convertResellerHasCustomer' => 'Återförsäljarkontot  \'%1\' har en eller flera kundkonton. För att omvandla detta återförsäljarkonto till ett kundkonto ska du först överföra dessa kundkonton till en ny ägare eller omvandla dem till återförsäljarkonton.',
    'command__convertResellerNotReseller' => 'Bara återförsäljarkonton kan omvandlas till kundkonton \'%1\' är inte en återförsäljare.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Kontot \'%1\' är en återförsäljarkonto. Återförsäjarkonton kan inte flyttas till en ny ägare eftersom de ägs av serveradministratören.',
    'moveCustomer__wrong_owner_type' => "Kundkontot  '%1' kan flyttas till en återförsäljare eller admin, inte till en annan kund.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Kundkontot  \'%1\' tillhör redan den markerade ägaren.',
    'upgradeClient__user_is_admin' => 'Kontot \'%1\' kan inte ändras till ett återförsäljarkonto på grund av att det är ett administratörskonto.',

    'mail__error_setting_max_connections_courier' => 'Kan inte ställa in maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Kan inte ställa in maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Kan inte ställa in maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) per IP adress: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Kan inte ställa in maximalt antal anslutningar (IMAP, POP3, IMAP över SSL/TLS, eller POP3 över SSL/TLS) per IP adress för en specifik e-postanvändare: %1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => 'För att använda utskickslistor, behöver du ha localhost (127.0.0.0/8, ::1/128) i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => 'För att använda utskickslistor, behöver du ha localhost i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor. Observera att det inte finns några IPv4 localhost-adresser (127.0.0.0/8) i vitlistan nu, så den utgående postkontrollen fungerar för IPv4-adresser.',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => 'För att använda utskickslistor, behöver du ha localhost i webbserverns vitlista. Men för att använda utgående e-postkontroll, ska du inte ha localhost i vitlistan. Om du har aktiverat utgående postkontroll kan du som kompromiss använda vidarebefordran av e-post till brevlådan i stället för postlistor. Observera att det inte finns några IPv6 localhost-adresser (::1/128) i vitlistan nu, så den utgående postkontrollen fungerar för IPv6-adresser.',
    'mail__outgoing_messages_with_open_relay_error' => 'För korrekt begränsning av antalet utgående meddelanden, stäng vidaresändningen.',
    'outgoing_messages_limit_value_invalid' => 'Värdet måste vara i området %%MIN%%..%%MAX%%. Bara Plesk administratören kan ändra denna inställningen.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Följande domäner använder externa e-postadresser för vidarebefordran av e-post som skickats till adresser som inte finns. Meddelandena som skickas till dessa adresser kommer inte att räknas i kontrollen för utgående post:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Gränserna för utgående post fungerar inte för e-postsändare vars IP-adresser fins på e-postserverns vita lista. Til exempel, om det finns en lokal värddator (127.0.0.0 / 8, ::1 / 128) i den vita listan, skickas alla e-postmeddelanden korrekt från den lokala servern oavsett begränsningarna. E-postsändare kan använda antingen lokala IP-adresser (webbplatser och anpassade script som finns i den lokala värddatorn) eller externa adresser (kunder som skickar e-post från e-postklienter som har installerats i deras datorer eller mobila enheter). För att gränserna ska fungera för alla e-postsändare (både lokala och externa), ta bort alla IP-adresser och nätverk från den vita listan. Observera att om du tar bort den lokala värddatorn (127.0.0.0 / 8, ::1 / 128) från den vita listan, kan åtgärden på webbplatser och script som skickar e-post från denna server avbrytas. För ytterligare detaljer om begränsningarna för utgående e-post, se Administratörsvägledningen, Skydd mot utgående spam.',
    'outgoing_messages_relay_open' => 'Huvudreläet är öppet: gränserna för utgående post fungerar inte.',

    'spf_dsnignore' => 'SPF-kontroll fortsättar om det finns problem med DNS-sökning.',
    'spf_dnsignore_hint' => 'Först utför SPF en DNS-sökning. Markera detta alternativ om du vill fortsätta kontrollera om DNS-sökningen misslyckas. Detta alternativ är avmarkerad om det inte har någon effekt i det aktuella komtrollmodus.',
    'spf_behavior_hint' => 'Då använder SPF lokala och gissnings regler. Meddelandet kan avvisas avhängig av det valde kontrolläget och kontrollresultat.',

    'notification_aps_app_updates_available' => 'Uppdateringar finns tillgängliga för följande program:',
    'notification_aps_app_updates_installed' => 'Uppdateringar blev automatiskt installerade för följande program:',
    'notification_aps_app_updates_requirements' => 'Uppdateringar är tillgängliga för följande program men kan inte installeras beroende på att värdtjänst-inställningar för motsvarande webbplatser inte uppfyller installationskraven:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Din version: %%from%%. Tillgänglig version: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Din version: %%from%%. Tillgänglig version: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Din version: %%from%%. Tillgänglig version: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny version: %%to%%. Tidigare version: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny version: %%to%%. Tidigare version: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny version: %%to%%. Tidigare version: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). installerat version %%from%%. Tillgänglig version: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Din version: %%from%%. Tillgänglig version: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'extern app',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domäner',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-postadresser',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnemang',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 meddelanden per timme',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Obegränsat',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, gränsen är %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 försök på att överskrida gränser från %2 till %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 försök på att överskrida gränser från %2 till nu',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Bannlysning av IP-adresser (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Komponenten Fail2ban har inte installerats på målservern.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installera Fail2ban. Observera att detta kan ta några minuter.',

    'plesk_key__no_reseller_support' => 'Du kan inte hantera återförsäljare på grund av licensbegränsningar.',
    'plesk_key__no_customers_support' => 'Du kan inte hantera kunder på grund av licensbegränsningar.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Kan inte växla till Internetleverantörens vy på grund av licensbegränsningar.',
    'plesk_key__no_security_core_support' => 'Centrala säkerhetsfunktioner (ModSecurity och Fail2Ban) är inte tillgängliga på grund av licensbegränsningar.',
    'plesk_key__outgoing-antispam' => 'Kontroll för utgående e-post',
    'plesk_key__security-core' => 'Säkerhetskärna (ModSecurity och Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Kontohantering',
    'plesk_key__can-manage-subscriptions' => 'Hantering av abonnemang',
    'plesk_key__can-manage-customers' => 'Kundhantering',
    'plesk_key__can-manage-resellers' => 'Hantering av återförsäljare',
    'plesk_key__can-manage-custom-view' => 'Begränsat läge tillgängligt',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Hantering av abonnemang är stängd av men du har många abonnemang (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Hantering av återförsäljare är stängd av men du har många återförsäljare (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Kundhanteringen är avstängd men du har många kunder (%1).',
    'plesk_key__no_subscriptions_support' => 'Du kan inte hantera abonnemang på grund av licensbegränsningar.',
    'plesk_key__no_custom_view_support' => 'Du kan inte använda Begränsat läge på grund av licensbegränsningar.',
    'plesk_key__trial_forbidden_region' => 'Tyvärr, är Plesk för närvarande inte tillgängligt i din region.',
    'additional_key__main_key' => 'Nyckeln är en huvudnyckel: Du kan inte ladda upp en huvudnyckel som en tilläggsnyckel.',

    'gch__hosting_waf_rule_engine' => 'Webbprogram brandvägg modus',

    'backup__fieldset__restoration_options' => 'Återställningsalternativ',
    'backup__restore_options__restore' => 'Återställ',
    'backup__restore_options__domain__domain_configuration' => 'Domänkonfiguration',
    'backup__restore_options__domain__virtual_host_content' => 'Den virtuella värdsserverns innehåll',
    'backup__restore_options__domain__mail' => 'E-post',
    'backup__restore_options__domain__databases' => 'DatabaVisar',
    'backup__restore_options__client__client_configuration' => 'Kundkontots konfiguration',
    'backup__restore_options__client__domains' => "Kundens domäner",
    'backup__restore_options__reseller__reseller_configuration' => 'Återförsäljarens kontokonfiguration',
    'backup__restore_options__reseller__personal_domains' => "Återförsäljarens domäner",
    'backup__restore_options__reseller__clients' => "Återförsäljarens kunder",
    'backup__restore_options__admin__server_configuration' => 'Serverinställningar',
    'backup__restore_options__admin__administrator_configuration' => 'Administratörskontots konfiguration',
    'backup__restore_options__admin__personal_domains' => "Administratörs domäner",
    'backup__restore_options__admin__personal_clients' => "Administratörens kunder",
    'backup__restore_options__admin__resellers' => 'Återförsäljare',

    'badge_new' => 'Ny',
    'upgrade_php_on_subscription' => 'Uppgradera PHP i ditt abonnemang till version 5.3.0 eller senare.',

    'pkey_notify__body_expiration_notification' => 'Licensnyckeln har slutat gälla. Vissa funktioner kanske är otillgängliga. Kontakta din värddatorleverantör.',

    'crontab__crontab_entry_exists' => "Den schemalagda aktiviteten finns redan.",
    'crontab__crontab_entry_not_exists' => "Den schemalagda aktiviteten finns inte.",
    'crontab__invalid_values_found' => "Felaktiga parametervärden.",
    'crontab__cmd_max_len' => "Kommandot får inte vara längre än %1 tecken.",

    'domain__domain_exists' => "Det finns en domän med 'www' prefix och samma namn: %1.%2.",
    'domain__subdomain_exists' => "Det finns en underdomän med 'www' prefix och samma namn: %1.%2.",
    'domain__dalias_exists' => "Det finns ett domänalias med 'www' prefix och samma namn: %1.%2.",
    'domain__record_exists' => "Det finns en DNS-post som pekar mot värden %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certifikatet '%1' kan inte ställas in som standardvärde: den privata koden saknas.",
    'ip_addr__update_dns_error' => 'Problem uppstod under uppdateringen av IP-adressen i DNS-zonerna. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Kunde inte reparera IP-adressen. Detta nätverksgränssnitt får IP-adresser automatiskt.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Kan inte ta bort IP-adress %1. Detta nätverksgränssnitt får IP-adresser automatiskt.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Kunde inte reparera IP-adress %1. Detta nätverksgränssnitt får IP-adresser automatiskt.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Kan inte ändra gränssnittet för IP-adressen %1 eftersom nätverksgränssnittet %2 får IP-adresser automatiskt.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Abonnemangets gräns på antalet %%type%% har överskridits. Gränsen är %%limit%%, och %%usage%% används för närvarande.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Skapandet av %%type%% är inte tillåtet för detta abonnemang.',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL-databaVisar',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-databaser',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-databaser',
    'shm_lmsg__resource_title__db-user' => 'databasanvändare',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-programpooler',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Extra FTP-konton',

    'db_user_unable_remove_mysql_global_privileges' => 'Kan inte ta bort MySQL globala privilegier från databasanvändare %1. Skäl: %2',
    'report__client_description' => 'Beskrivning',

    'db__user_role_error' => 'Felaktig databas för användarens roll har specificerats: %1. Välj en av följande roller: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Kan inte ställa in filens storleksgräns följande Microsoft SQL serverdatabaser eftersom det finns en större filsstorlek: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Kan inte ställa in loggfilens storleksgräns följande Microsoft SQL serverdatabaser eftersom det finns en större loggfilsstorlek: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Kan inte ställa in en offentlig IP-adress: det måste finnas en privat adress.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Kan inte ställa in en offentlig IPv4-adress för IPv6-adressen.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Kan inte ställa in en offentlig IPv6-adress för IPv4-adressen.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Kan inte ställa in en offentlig IP-adress: ogiltig IP-adress.',

    '__user_already_exists' => "Användare %1 finns redan.",
    '__user_name_is_empty' => "Ange ett användarnamn.",

    'upgrade_php_on_domain' => 'Kan inte skapa version 5.3.0 eller senare i en av WordPress-domänerna. Försök att uppgradera PHP.',

    'component_name__waf' => 'Webbprogram brandvägg',
    'component_name__vcs' => 'Versionens kontrollsystem',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Ett möjligt försök till spoofing har detekterats: länken försökte visa irrelevant innehåll.',

    'php_handlers_error_no_available_instance' => 'Kan inte skapa en domän: det finns inga tillgängliga PHP-hanterare.',
    'domain_error_unable_to_apply_hosting_settings' => 'Kan inte tillämpa värdtjänstinställningarna: %1',

    'plesk_not_configured' => 'Plesk är inte konfigurerad. Gå till kontrollpanelen för att utföra konfigurationen av efterinstallationen.',
    'cmd_mail__mail_password_duplicated' => 'Det specificerade paret med e-postadress och lösenord finns redan på e-postservern. Specificera en annan e-postadress eller lösenord.',

    'extensionRequirementOs' => 'Operativsystemet (%1) stöds inte av paketet.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 är den tidigaste versionen som stöds av paketet.',
    'extensionRequirementPleskMaxVersion' => 'Versioner från och Plesk %1 stöds inte av paketet.',
    'extensionBlacklisted' => 'Ändelsen %1 är inte tillåten för installation.',
    'extensionDisabled' => 'Ändelsen är inaktiverad.',


    'optimization_settings__unable_set_mpm_event' => 'Det går inte att ställa in mpm_event-läge: det kräver att Apache PHP5-modulen är avstängd men denna modul används av domäner.',
    'optimization_settings__unable_turn_off_php' => 'Det går inte att stänga av Apache PHP5-modulen: den används av domäner.',

    'hst_def__fp_admin_login' =>  'FTP-användarnamn',
    'hst_def__fp_admin_passwd' =>  'FTP lösenord',

    'database_user_orphaned_old_password_wrong' => "Kan inte reparera en ensam användare \\’%1\\’: lösenordet är felaktigt.",
    'cannot_load_partner_central_property_key_no_exist' => "Kan inte hämta anpassade egenskaper: licensnyckeln finns inte.",
    'extensionScriptFailure' => "Utförandet av %1 misslyckades med följande meddelande:\n%3",
    '__ssl_redirect' => "Permanent SEO-säker 301 omdirigerad från HTTP till HTTPS",
    'component_name__dotnetcore' => '.NET kärna',
    'mail__dkim_not_supported' => 'DKIM-hantering stöds inte.',
    'mail__dmarc_not_supported' => 'DMARK-hantering stöds inte.',
    'mail__relay_white_list_not_supported' => 'Koppling till vitlistehanteringen stöds inte.',
    'mail__black_list_not_supported' => 'Svartlistehantering stöds inte.',
    'mail__autoresponder_not_supported' => 'Den automatiska svarshanteringen stöds inte.',
    'defaultcomponents__not_supported_version' => '(Versionen stöds inte)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Det gick inte att hitta certifikatet \'%1\'',
    'certificate__unable_setup_certificate' => 'Det gick inte att installera certifikatet: Den privata nyckeln och certifikatsinnehållet saknas.',
    'certificate__used_by_panel' => 'Ett av certifikaten du är på väg att ta bort används för att säkra Plesk.',
    'certificate__used_by_mail_server' => 'Ett av certifikaten du är på väg att ta bort används för att säkra postservern.',
    'certificate__used_by_domain_service' => 'Ett av certifikaten du är på väg att ta bort används av domäntjänsten.',
    'mail_server__not_installed' => 'Kan inte installera certifikatet för postservern eftersom postservern inte har installerats',

    'email_activation_mail_subject' => 'Aktivera ditt konto i Plesk',
    'email_activation_mail_body' => "Ett konto skapades på Pleskserver %1 \n\nKontouppgifter: \nNamn: %2 \nE-postadress: %3 \n\nOm denna information är korrekt och kontot har skapats för dig, aktivera det med följande länk: \n\n%4 \n\nGenom att aktivera kontot tillåter du serverinnehavaren att samla in, lagra, behandla och använda dina personuppgifter (namn och e-post) för att skapa och stödja ditt konto i enlighet med gällande lagar om skydd av personuppgifter som en del av ett kontrakt.",

    'backup_transport_permission_name' => '%1 hantering',
    'backup_transport_permission_description' => 'Gör att man kan använda %1 för att lagra säkerhetskopior.',

    'domain_move_err_target_no_hosting' => 'Det gick inte att flytta domänen till en prenumeration utan hosting.',
    'domain_move_err_already_in_target' => 'Domänen hör redan till målabonnemanget.',
    'domain_move_err_main_domain' => 'Huvuddomänen kan inte flyttas.',
    'domain_move_err_subdomain_without_parent' => 'Det går inte att flytta underdomänen %1 utan huvuddomänen %2.',
    'domain_move_err_root_exists' => 'Målvägen för www_root %1 finns redan.',
    'domain_move_err_nested_roots' => 'Det går inte att flytta domänen eftersom den delar dokumentroten med en annan domän: %1.',
    'domain_move_err_no_mail_service' => 'Kunde inte ta bort domänen eftersom posttjänsten inte är aktiv i målprenumerationen.',
    'domain_move_err_app' => "Programmet som är installerat i %1 flyttades inte till prenumerationen '%2\\’: %3",
    'domain_move_database_used_by_app' => "Databasen '%1' på %2 används av den flyttade applikationen. För att omfördela databasen för '%3', kör `plesk bin-databas --tilldela till prenumerationen`",
    'domain_move_target_locked' => "Målabonnemanget '%1' var låst för synkronisering.",
    'domain_move_filesharing_disabled' => 'Fildelning har inaktiverats.',
    'domain_move_website_preview_disabled' => 'Webbplatsens förhandsgranskning var inaktiverad.',
    'domain_move_additional_webserver_settings' => "Granska domänens ytterligare webbserverdirektiv för att förhindra en felaktig konfiguration.",
    'domain_move_no_permission' => "%1 tillåts inte för prenumerationen '%2'.",
    'domain_move_no_access' => "Ingen åtkomst till prenumerationen '%1'.",
    'domain_split_no_create_permission' => "Domänskapande är inte tillåtet.",
    'domain_split_empty_login' => 'Systemanvändarinloggning krävs.',
    'domain_split_empty_password' => 'Systemanvändarlösenordet krävs.',
    'domain_split_err_home_exists' => 'Domänen %1 kan inte flyttas eftersom målhemsidans sökväg redan finns i %2. Byt namn på domänen för att flytta den till en ny prenumeration.',
    'domain_split_err_no_hosting_subdomains' => 'Domänen kan inte flyttas till en ny prenumeration eftersom domänen inte är värdbefogenheter utan underdomäner. För att flytta domänen, ändra värdet "Typ av värddator" till "Webbhotell" (i värddatorinställningarna).',
    'domain_split_target_locked' => "Målabonnemanget '%1' är låst för synkronisering.",
    'domain_split_target_unsynced' => "Målprenumerationen '%1' synkroniserades inte med planen på grund av: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Schemalagd säkerhetskopiering inaktiverades den '%1'.",
    'domain_merge_database_error' => "Databasen '%1' i %2 flyttades inte till prenumerationen '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonym FTP på '%1' stängdes av.",
    'domain_merge_smb_user_access' => "Den ytterligare användaren '%1' flyttades till prenumerationen '%2' men hans tillgång till prenumerationen drogs in.",
    'domain_merge_scheduled_tasks' => "Schemalagda uppgifter flyttades till målprenumerationen. Granska uppgiftskonfigurationen",
    'domain_merge_scheduled_tasks_deactivated' => "Schemalagda uppgifter flyttades till målprenumerationen och inaktiverades. Granska uppgiftskonfigurationen",
    'domain_merge_no_remove_permission' => "Det går inte att ta bort prenumerationer.",
    'domain_merge_err_has_addons' => 'Kan inte flytta huvuddomänen med extradomäner; flytta först %1 domän(er).',
    'domain_merge_err_has_webusers' => 'Kan inte flytta huvuddomänen med dess webbanvändare.',
    'domain_merge_err_root_exists' => 'Målsökvägen %1 finns redan.',

    'database_server_edit_used_for_psa' => 'Uppdatering av lokal MySQL-databasserver är inte tillåtet.',
    'suggest_repair_main_suggestion_ui' => '<b>Du kan åtgärda felet</b> med verktyget ”plesk reparation”.',
    'suggest_repair_main_suggestion_cli' =>  'Du kan åtgärda felet med verktyget ”plesk reparation”.',
    'suggest_repair_repair_kit_link_title' => 'gå till Diagnos & Reparation',
    'suggest_repair_using_cli_and_ui' => 'För att göra det anger du antingen kommandot ”plesk reparation %1” via CLI eller %2 klickar på Reparera intill “Pleskdatabas”',
    'suggest_repair_using_cli' => 'För att göra det anger du kommandot ”plesk repair %1” via CLI',
    'verp_style_link' => 'VERP-typ',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'DNS-tjänsten var inte tillgänglig när säkerhetskopian skapades. Det finns dock aktiva DNS-zoner i säkerhetkopian som kommer att aktiveras för följande objekt: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resurskontrollenhet (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Stöd för fjärrstyrd SmarterMail',
    'plesk_key__complete-backup-solution' => 'Säkerhetskopiera till Cloud Pro',
    'defaultcomponents__no_license' => '(inte tillåtet enligt licensnyckeln)',
    'plesk_key__validation_failed' => '%1 (Felkod: %2)',
    'promo__button_details' => 'Information',
    'promo__extension_catalog_title' => 'Tilläggskatalog',
    'promo__extension_catalog_description' => 'Kolla in den nya tilläggskatalogen och superladda din Plesk med ett antal kraftfulla tillägg!',
    'promo__button_open_catalog' => 'Öppna katalogen',

    'backup__repository_check_login' => "Det gick inte att få åtkomst till lagringsutrymmet: %1 Kontrollera så att du har angett korrekt uppgifter.",
    'backup__repository_check_error_list' => "Det gick inte att få åtkomst till lagringsutrymmet: %1 Kontrollera så att du har korrekt inställningar.",
    'backup__repository_check_error_mkdir' => "Det gick inte att skapa katalogen: %1 Kontrollera så att du har rättigheter att skapa mappar i lagringsutrymmet.",
    'backup__repository_check_error_upload' => "Det gick inte att ladda upp filen: %1 Kontrollera så att du har rättigheter att ladda upp filer till lagringsutrymmet.",
    'backup__repository_check_error_download' => "Det gick inte att ladda ner filen från lagringen: %1 Kontrollera så att du har rättigheter att ladda upp och ner filer från lagringsutrymmet.",
    'backup__repository_check_error_resume-upload' => "Det gick inte att återuppta uppladdningen av filen: %1 Kontrollera så att du har rättigheter att återuppta uppladdningar.",
    'backup__repository_check_error_resume-download' => "Det gick inte att återuppta nedladdningen av filen: %1 Kontrollera så att du har rättigheter att återuppta nedladdningar.",
    'backup__repository_check_error_enable-utf8' => "Det gick inte att hantera lagringsutrymmet: %1 Kontrollera så att lagringen har stöd för UTF8-kodning.",
    'backup__repository_check_error_rm' => "Det gick inte att hantera lagringsutrymmet: %1 Kontrollera så att du har rättigheter att radera filer från lagringsutrymmet.",
    'backup__repository_check_error_rmdir' => "Det gick inte att hantera lagringsutrymmet: %1 Kontrollera så att du har rättigheter att radera mappar från lagringsutrymmet.",

    'backup__ftp_repository_check_login' => "%1 Du kan kontrollera dem oberoende med följande kommando: %2",
    'backup__ftp_repository_check_error_list' => "%1 Du kan kontrollera dem oberoende med följande kommando: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Du kan kontrollera det oberoende med följande kommando: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Du kan kontrollera det oberoende med följande kommando: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Du kan kontrollera det oberoende med följande kommandon: %2 %3",

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => 'Aktivera DMARC för att kontrollera inkommande post',
    'sfdmarc_server_wide_enable_failed' => 'Det fick inte att ändra inställningarna för DMARC. Aktivera DKIM och SPF-spamskydd för att aktivera det här alternativet.',
    'sfdmarc_server_wide_enable_hint' => 'Det här alternativet är tillgängligt när DKIM och SPF är aktiverade för inkommande e-post.',
    'spf_server_wide_enable_hint' => 'Det här alternativet kan inte stängas av medan DMARC är aktiverat för inkommande e-post.',
    'spf_server_wide_disable_failed' => 'Det gick inte att ändra inställningarna för spamskydd. Stäng av DMARC för att inaktivera funktionen för inkommande e-post.',
    'sfdk_server_wide_enable_hint' => 'Det här alternativet kan inte stängas av medan DMARC är aktiverat för inkommande e-post.',
    'sfdk_server_wide_verify_disable_failed' => 'Det gick inte att ändra inställningarna för DKIM-spamskydd. Stäng av DMARC för att inaktivera funktionen.',

    'ccs_not_supported' => 'IIS Central Certificate Store är inte konfigurerat på systemet.',
    'ccs_not_enabled' => 'IIS Central Certificate Store-hantering är inte aktiverad i Plesk.',
    'ad_not_supported' => 'Servern är inte kopplad till en domän.',

    'component_name__appinit' => "Applikationsinitiering",
    'component_name__httpcompression' => 'Kompression av HTTP-innehåll',
    'common_feature_is_not_supported' => 'Den här funktionen stöds inte längre.',
    'common_feature_is_not_supported_in_proto' => 'Den här funktioner stöds inte för protokollversion %1.',
    'autoinstaller__plesk_component' => 'Plesk-komponent',
    'plesk_key__key_expired' => 'Din licensnyckel har upphört att gälla För att fortsätta använda Plesk, måste du köpa en permanent gällande kommersiell %1.',
    'plesk_key__key_purchase' => 'licensnyckel',

    'sa_action_move' => 'Flytta spam till mappen "Skräppost"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-program stöds inte längre. De kommer inte att finnas tillgängliga för följande webbplatser: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobila versioner av webbplatser som körs med Unity Mobile stöds inte längre. De kommer att inte att finnas tillgängliga för följande webbplatser: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Användarpolicyn för servern tillåter inte personliga inställningar för antivirus. DE kommer att återstället helt för e-postkonton på följande domäner: {{objects}}',

    'server_preferences__ip_logging' => 'IP-loggning',
    'server_preferences__disable_ip_logging' => 'Inaktivera IP-inloggningar i IIS, FTP och e-postloggar',
    'server_preferences__disable_ip_logging_description' => 'Om aktiverat, loggar IIS och MailEnable inte längre IP-adresser',

    'module__not_installed' => "Tillägget %1 är inte installerat",

    'mail__mailbox_quota_warning_text' => 'Aktivera standardvarning för postlådekvot',
    'mail__mailbox_quota_warning_hint' => 'Skicka avisering till e-postanvändare när deras brevlådas kvotanvändning överstiger 95 %',
    'mail__mailbox_quota_warning_customization_text' => 'Anpassa standardvarning för postlådekvot',
    'mail__mailbox_fix-incorrectly-set-sender-text' => 'Korrigera inkorrekt angiven avsändare för utgående e-post',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => 'Ange automatiskt giltiga e-postrubriker och avsändarkuvertadress för utgående e-post från domäner för att minska risken för att behandlas som skräppost',
    'mail__mail_autodiscovery' => 'Automatisk upptäckt för e-post',
    'mail__mail_autodiscovery_description_text' => 'Se hur det fungerar i %%link%%',
    'mail__mail_autodiscovery_description_text_link' => 'kunskapsbas',
    'mail__mail_autodiscovery_text' => 'Aktiva automatisk upptäckt för e-post',
    'mail__mail_autodiscovery_hint' => 'Aktivering av den här funktionen konfigurerar om alla domäner som har automatisk upptäckt aktiverad',
    'mail__mail_autodiscovery_server_text' => 'Ange ett anpassat domännamn på automatisk upptäckt för e-post',
    'mail__mail_autodiscovery_server_hint' => 'OBS: Domännamnet måste vara skyddat med ett giltigt SSL/TLS-certifikat.',
    'mail__mail_autodiscovery_server_error' => 'Ange ett anpassat domännamn på automatisk upptäckt för e-post',
    'mail__mail_autodiscovery_reconfigure_dns_text' => 'Konfigurera om automatisk upptäckt för DNS-poster',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => 'Aktivering av den här funktionen konfigurerar om DNS-poster som har automatisk upptäckt aktiverad',
    'mail__error_mail_autodiscovery_enable' => 'Det gick inte att ange automatisk upptäckt för e-post: %1',
    'mail__error_mail_autodiscovery_server' => 'Det gick inte att ange ett anpassat domännamn på automatisk upptäckt för e-post: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Det går inte att konfigurera om automatisk upptäckt för DNS-poster: %1',

    '__invalid_url' => 'URL-en ”%1” är ogiltig',
    'actionlog__cloning_start' => 'start',
    'actionlog__event_cloning_start' => 'Serverkloning inleds',

        '__show_hide_title' => 'Minimera/återställ',
    '__show_hide_navigation_pane' => 'Visa/dölj navigeringsfönstret',
    '__UPLOAD_ERR_FORM_SIZE' => "Överförd fil överstiger tillåten storlek",
    '__UPLOAD_ERR_INI_SIZE' => "Överförd fil överstiger tillåten storlek",
    '__UPLOAD_ERR_NO_FILE' => "Ingen fil har tagits emot",
    '__UPLOAD_ERR_OK' => "Fil uppladdad",
    '__UPLOAD_ERR_PARTIAL' => "Fil uppladdad delvis, försök igen",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Tillfällig mapp saknas',
    '__UPLOAD_ERR_CANT_WRITE' => 'Lyckades inte skriva filen till disken',
    '__UPLOAD_ERR_UNKNOWN' => 'Ett okänt filöverföringsfel uppstod',
    '__accounts' => "Konton",
    '__access' => "Åtkomst",
    '__address' => "Adress",
    '__addresses' => "Adresser",
    '__acl_records' => 'ACL-poster',
    '__admin_repository' => "Adminsitratörsmagasin",
    '__all' => 'Alla',
    '__allowed' => "Tillåten",
    '__anonftp_status' => "Anonym FTP",
    '__antispam' => "Antispam",
    '__apache_restart' => "...%1-webbservern håller på att återstartas. Vänta...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET 2.0",
    '__asp_win_support' => "Microsoft ASP-stöd",
    '__attachments' => "Bilagor",
    '__attachments_list' => "Bilagor",
    '__author' => 'Författare',
    '__autoresp_name_already_exists' => "Autosvar med namnet %1 finns redan.",
    '__autoresponder' => "Autosvar",
    '__autoresponders' => "Autosvar",
    '__autoresponders_list' => "Autosvar",
    '__autoresponder_attachment_files' => "Bifogade filer till autosvar",
    '__auto_updates_list' => 'Tillgängliga uppdateringar',
    '__avail' => "Tillgänglig",
    '__backup_utilites' => "Säkerhetskopieringsverktyg",
    '__bind_status' => "Status på DNS-servern",
    '__bu_is_not_installed' => "Tjänsten är inte tillgänglig för närvarande, eftersom nyttoprogrammen för säkerhetskopiering inte har installerats.",
    '__bu_not_support_in_key' => "Säkerhetskopiefunktionalitet stöds inte av licensnyckeln.",
    '__notifications_not_support_in_key' => 'Meddelanden stöds inte av licensnyckeln.',
    'disabled_by_key' => 'Stöds inte av licensnyckeln',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "Du kan inte använda reserverade ord.",
    '__certificate' => "Certifikat",
    '__cgi_support' => "CGI-stöd",
    '__change_date' => "Ändringsdatum",
    '__choose_logo' => "Logotyp-fil",
    '__city' => "Stad",
    '__cl_not_exist' => "Kundens konto finns inte.",
    '__client' => 'Kund',
    '__client_card' => "Kundkort",
    '__client_contact_name' => "Kundens kontaktnamn",
    '__client_form' => "Personlig information",
    '__client_ip_pool' => "Kundens IP-pool",
    '__client_limits' => "Kundkontots gränser",
    '__client_permissions' => "Kundbehörigheter",
    '__client_preferences' => "Kundens preferenser",
    '__client_status' => "Kundens status",
    '__client_name' => "Kundens namn",
    '__client_total' => "Kundtotal",
    '__client_with_login_name_already_exists' => "En användare med användarnamnet \"%1\" finns redan.",
    '__client_domuser_with_login_already_exists' => "Användarnamnet '%1' är redan i bruk av administratören av domän '%1'.",
    '__clients_global_changes' => "Modifiera markerade kundkonton.",
    '__clients_list' => "Kunder",
    '__cmd_not_found' => "Okänt kommando: %1",
    '__comments' => "Kommentarer",
    '__company_name' => "Företagsnamn",
    '__component_version' => "Komponentversion",
    '__component_not_installed' => "Komponenten %1 har inte installerats",
    '__confirm_del' => "Du måste bekräfta raderingen.",
    '__confirm_overwrite' => "Bekräfta överskrivning.",
    '__confirm_stop' => "Du måste bekräfta stopp av processen.",
    '__confirm_passwd' => "Bekräfta lösenordet %1",
    '__confirm_removal' => "Bekräfta borttagning",
    '__conhelp' => "Beskrivning",
    '__contact_name' => "Kontakt namn",
    '__country' => "Land",
    '__countries' => 'Land',
    '__country_unknown' => 'Kunde inte känna igen landets underkod.',
    '__courier-imap' => 'Kurirserver',
    '__create_domain' => 'Skapa en domän',
    '__crypted' => 'krypterat',
    '__cp_access' => "Åtkomst till Plesk-tjänster",
    '__cp_user' => "Plesk användare",
    '__create' => "Skapa",
    '__create_client_template_without_template' => "Skapa användarkonto utan mall",
    '__create_domain_for' => "Skapa en domän för <b />%1</b>",
    '__create_domain_template_without_template' => "Skapa domän utan mall",
    '__creation_date' => "Skapandedatum",
    '__crontab_unix' => "Scheduler",
    '__crontab_win' => "Scheduler",
    '__ct_month_jan' => 'Januari',
    '__ct_month_feb' => 'Februari',
    '__ct_month_mar' => 'Mars',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Maj',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'Augusti',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'December',
    '__custom_button' => "Anpassad knapp",
    '__custom_buttons_list' => "Länkar till ytterligare tjänster",
    '__daily' => "Dagens",
    '__database_not_activated' => "%1 har inte aktiverats på serverns administrationssida.",
    '__database_not_installed' => "Databasen %1 har inte installerats.",
    '__database_not_run' => "Databasen %1 är inte igång.",
    '__database_is_corrupt' => "Plesk-databasen är korrupt. Starta omkonfigurator-verktyget för att åtgärda det.",
    '__databases' => "DatabaVisar",
    '__databases_list' => "DatabaVisar",
    '__database_type_not_supported_by_key' => 'För att använda %1 servern, måste du ha stöd för den i din licensnyckel. Kontakta din Plesk säljrepresentant.',
    '__date_immediately' => "idag",
    '__date_never' => "aldrig",
    '__day(s)' => "Dag(ar)",
    '__day0' => "Sön",
    '__day1' => "Mån",
    '__day2' => "Tis",
    '__day3' => "Ons",
    '__day4' => "Tor",
    '__day5' => "Fre",
    '__day6' => "Lör",
    '__days' => "%1 dag(ar)",
    '__db_admin_login_empty' => "Du har angett ett tomt användarnamn, och stänger så av kontrollen av %1 i gränssnittet. Vill du fortsätta?",
    '__db_unable_to_unregister' => 'Kan inte ta bort parametrar för databasanslutning',
    '__db_db_exists' => 'Det finns åtminstone en databas på servern',
    '__db_unable_to_change_server_name' => 'Namn för servern kan inte ändras',
    '__db_unable_to_change_port' => 'Port för servern kan inte ändras',
    '__db_already_exist' => "Databasen %1 finns redan.",
    '__db_credentials_invalid' => "Databasinloggningsuppgifterna är ogiltiga.",
    '__db_invalid_password_characters' => 'Lösenordet innehåller ogiltiga tecken',
    '__db_engine' => "Databasmotor", // indirect
    '__db_type' => "Databastyp",
    '__db_user' => "DatabaVisa användare",
    '__db_server' => 'Databasserver',
    '__def_domain' => "Standarddomän",
    '__default_for_mysql' => 'standard för MySQL',
    '__default_for_mariadb' => 'standard för MariaDB',
    '__default_for_percona' => 'standard för Percona',
    '__default_for_postgresql' => 'som standard för PostgreSQL',
    '__delete' => "Ta bort",
    '__demo' => "Den här funktionen är inte tillgänglig i demoversionen.",
    '__directory' => "Katalog",
    '__disable_lock_screen' => 'Förhindra användare att arbeta med Plesk innan gränssnittskärmarna är fullständigt laddade',
    '__dismiss_news?' => "Är du säker på att du vill stänga dessa nyhetsblock helt?\n\nDu kommer inte kunna besök nyhetsblocket förrän mer nyheter finns tillgängligt.",
    '__description' => "Beskrivning",
    '__disabled' => "avstängd",
    '__disk_space_limit' => "Disktutrymmets begränsning",
    '__cgroups_cpu_usage_limit' => 'CPU-användningsgräns',
    '__cgroups_ram_usage_limit' => 'RAM-användningsgräns',
    '__cgroups_disk_read_usage_limit' => 'Avläsning av skivans bandbreddsgräns',
    '__cgroups_disk_write_usage_limit' => 'Skrivning av skivans bandbreddsgräns',
    '__disk_usage_by' => "Diskutrymme som används av %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS-posten '%1' finns redan.",
    '__dns_master_should_be_remote' => "Du ska ha två olika auktoritativa namnservrar på separata värdar.",
    '__dns_record_not_exist' => "DNS-posten finns inte.",
    '__dns_server' => "DNS-server", // indirect
    '__dom_id_is_undefined' => "Domän-ID är odefinierat.",
    '__dom_name' => "Domännamn",
    '__dom_name_is_invalid' => "Felaktigt domännamn. Se till att ditt domännamn innefattar endast alfanumeriska tecken, punkt och bindestreck, samt inte är längre än 255 tecken långt. Ingen del av domännamnet mellan punkter får överstiga 63 tecken.",
    '__dom_not_exist' => "Domänen finns inte.",
    '__domain' => "Domän",
    '__domain_' => 'Domän: %1',
    '__domain_form' => "Domänformulär",
    '__domain_id' => "Domän-ID",
    '__domain_is_turned_off_for_backup' => "Webbplatsen %1 är tillfälligt avstängd för säkerhetskopiering eller återställning och är inte tillgänglig för närvarande.",
    '__domain_limits' => "Domängränser",
    '__domain_name' => "Domännamn",
    '__mail_name_in_ASCII_form' => "E-postkontonamnet i ASCII-format",
    '__message_error' => 'Fel',
    '__message_warning' => 'Varning',
    '__message_info' => 'Information',
    '__domain_name_in_ASCII_form' => "Domännamn i ASCII-format",
    '__domain_repository' => "Katalog för domän %1",
    '__domain_status' => "Domänstatus",
    '__domain_dns' => 'Domänens DNS-namn',
    '__domain_total' => "Totalt belopp för abonnemanget",
    '__domain_total_powerUser' => "Totalt belopp för abonnemanget",
    '__domain_user' => "Domänadministratör",
    '__domains_global_changes' => "Ändra valda domäner",
    '__mailnames_global_changes' => "Modifiera markerade e-postkonton",
    '__backup_manager' => 'Hantering av säkerhetskopior',
    '__domains_list' => "Domäner",
    'domains_list__list_header' => "domäner", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Domännamnet börjar med www, även om WWW-prefixet används.\nFortsätt ändå?",
    '__dovecot' => 'Dovecot IMAP och POP3-server',
    '__dsmail' => "Posttjänst",
    '__dsmaillist' => "E-postlistans tjänst",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Domännamn",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "Vidarebef.",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Kundens namn",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Total storlek på de säkerhetskopierade filerna i den lokala lagringen",
    '__email' => "E-post",
    '__email_addr_is_invalid' => "E-postadressen är ogiltig.",
    '__enabled' => "påkopplad",
    '__enter_cert_text' => "Ange certifikattext",
    '__enter_logo_url' => "Logotyp URL",
    '__enter_size' => "Ange storlek",
    '__exclusive' => "Dedikerad",
    '__expiration_date' => "Utgångsdatum",
    '__fax' => "Fax",
    '__file' => "Fil",
    '__file_is_empty' => "Filen är tom.",
    '__file_name' => "Filnamn",
    '__file_type' => 'Filtyp',
    '__filemanager' => "Filhanteraren",
    '__filepath_is_empty' => "Sökvägen till filen är tom",
    '__files_list' => "Filer",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-inställningar",
    '__ftp_serv' => "FTP server", // indirect
    '__ftp_server_parameters_are_empty' => "Du måste först ställa in FTP-kontots egenskaper!",
    '__ftp_status' => "FTP-serverns status",
    '__full_day0' => "Söndag",
    '__full_day1' => "Måndag",
    '__full_day2' => "Tirsdag",
    '__full_day3' => "Onsdag",
    '__full_day4' => "Torsdag",
    '__full_day5' => "Fredag",
    '__full_day6' => "Lördag",
    '__full_month1' => "Januari",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "December",
    '__full_month2' => "Februari",
    '__full_month3' => "Mars",
    '__full_month4' => "April",
    '__full_month5' => "Maj",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "Augusti",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Grupp",
    '__h' => "H",
    '__hard_disk_quota' => "Hårddiskkvot",
    '__hard_disk_quota_not_supported' => 'hårddiskkvot stöds inte till följd av konfigurationen av serverfilsystemet',
    '__header_text_is_invalid' => "Titeln på det skyddade området är ogiltig.",
    '__help_topic_not_found' => 'Hjälpämnet du begärde (%1) finns INTE.',
    '__hosting' => "Värding",
    '__hosting_ip_dns_ip_not_equiv' => "Ingen av de IP-adresser du specificerade i A DNS-post matchar IP-adressen som används för värdbaseringen.",
    '__hosting_scripting' => "Värdbaseringens skriptsupport",
    '__hosting_setup_page_title' => "Värdtjänsttypen för domän %1",
    '__hosting_title' => "Värdtjäns (%1)",
    '__hosting_type' => "Hosting typ",
    '__hostname' => "Värdnamn",
    '__hostname_is_empty' => "Värdnamnet är tomt.",
    '__hour(s)' => 'Timmar',
    '__hst_type_incorrect' => "Värdtjänsttypen är felaktig.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Inaktivitet",
    '__iface' => "Gränssnitt",
    '__image' => "Bild",
    '__imap_status' => "Status på IMAP-servern",
    '__in' => "Inne",
    '__in_%' => "i %",
    '__incorrect_databases_login_pass' => "Inloggningsuppgifterna du angav för åtkomst till PostgreSQL är felaktiga.",
    '__incorrect_ip_or_network_address' => 'Felaktig IP-adress eller nätverk.',
    '__info' => 'Info',
    '__install' => "Installera",
    '__install_prefix' => "Installera prefix",
    '__invalid_cert_id' => "Ogiltiga certifikat-ID",
    '__invalid_context' => "Ogiltigt sammanhang: %1",
    '__invalid_db_usr_name' => "Databasens användarnamn är ogiltigt.",
    '__invalid_dir_name' => "Katalogens namn är ogiltigt",
    '__invalid_dom_name' => "Felaktigt domännamn.",
    '__invalid_filename' => "Ogiltigt filnamn. Använd inte enkla citattecken och/eller kombinationen \"../\".",
    '__invalid_id' => "Ogiltig identifierare.",
    '__invalid_lines_num' => "Felaktigt värde för antal rader, endast siffror är tillåtet.",
    '__invalid_max_letter_size' => "Största meddelandestorlek är ogiltig.",
    '__invalid_pdir_name' => "Den skyddade katalogens namn är ogiltigt.",
    '__invalid_restart_apache_interval' => "Apache-omstartintervallet är ogiltigt.",
    '__invalid_tmpl_name' => "Mallens namn är ogiltigt.",
    '__invalid_value' => "Felaktigt värde.",
    '__ip_addr' => "IP-adress",
    '__ip_address_and_mask' => "IP-adress och nätmask",
    '__ip_alias__mask' => "IP-adress och nätmask",
    '__ip_addr_form' => "IP-adressens formulär",
    '__ip_addr_is_invalid' => "IP-adress är ogiltig.",
    '__ip_addr_list' => "IP-adresser",
    '__ip_address_does_not_exist' => "IP-adressen finns inte.",
    '__ip_addresses' => "IP-adresser",
    '__ip_address_and_mask_hint' => 'Till exempel, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "kB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Din licensnyckel är avsedd att användas enbart i Virtuozzo containers.",
    '__key_limits_exceeding' => "Denna åtgärd överskrider gränserna definierade av din mjukvarulicens. Om du fick detta meddelande kan du kontakta din leverantör eller tillverkare för att klargöra eller förlänga gränserna för denna licens.",
    '__kilo' => "K",
    '__keywords' => 'Nyckelord',
    '__lang_unknown' => 'Kan inte känna igen språket.',
    '__languages' => 'Språk',
    '__learn_more' => 'Läs mer',
    '__loading' => 'Laddar…',
    '__locales' => "Språkpaket",
    '__link_url_is_invalid' => "URL-logotypen är ogiltig.",
    '__lists' => "E-postlistor",
    '__literal_bytes' => "B",
    '__processing' => "Väntar.<br>Läser in...",
    '__locale' => "Gränssnittsspråk",
    '__locale_is_not_defined' => "Gränssnittsspråk är inte definierat.",
    '__local_server_mysql' => 'Lokal MySQL-server',
    '__local_server_postgresql' => 'Lokal PostgreSQL-server',
    '__log_files' => "Loggfiler",
    '__log_and_statistics_files' => 'Loggfiler och statistiska rapporter',
    '__config_files' => 'Konfigurationsfiler',
    '__chroot_files' => 'Chrootad miljö',
    '__login' => "%1 inloggning",
    '__login1' => "Inloggning",
    '__login_disabled' => "Inloggning förbjudet",
    '__login_enabled' => "Inloggning tillåtet",
    '__login_incorrect' => "Du har angett ett felaktigt användarnamn eller lösenord.",
    '__login_name' => "%1 användarnamn",
    '__login_name_is_invalid' => "%1 användarnamnet är ogiltigt.",
    '__logon_time' => "Inloggningstid",
    '__ma' => "E-postaliaser",
    '__mail' => "E-post",
    '__mail_alias_name' => "E-postens aliasnamn",
    '__mail_autodiscovery' => 'Automatisk upptäckt för e-post',
    '__mail_exchanger_name_is_invalid' => "E-postutväxlarnamnet är ogiltigt.",
    '__mail_groups' => "E-postgrupper",
    '__mail_list_engine' => "E-postlista-mjukvara",
    '__mail_name' => "E-postkonto",
    '__mail_name_form' => "Egenskaper för e-postkonto",
    '__mail_names' => "E-postkonton",
    '__mail_serv' => "E-postserver",
    '__mail_user' => 'E-postanvändare',
    '__mailgroup' => "E-postgrupp",
    '__maillist' => "E-postlista",
    '__maillists' => "E-postlistor",
    '__maillist_member' => 'E-postlista-medlem',
    '__mailname' => "E-postkonto",
    '__mailname_redir_self' => "E-postkontot kan inte vidarebefordra meddelande till sig själv",
    '__max_dom_num_reached_for_cl' => "Gränsen för antalet domäner har nåtts för detta kundkonto.",
    '__max_file_size_available' => "Maximalt tillåten filstorlek %1",
    '__max_subdom_num_reached_for_cl' => "Gränsen för antalet underdomäner har nåtts för detta kundkonto.",
    '__max_subdom_num_reached_for_dom' => "Gränsen för antal subdomäner har nåtts för domänen.",
    '__max_subdom_num_reached_for_key' => "Gränsen för antalet subdomäner som tillåts av licensnyckeln har uppnåtts.",
    '__max_traffic_limit' => "Trafikgräns",
    '__maximum_excl_ip_num' => "E-postkonton",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/månad",
    '__mb_sec' => "MB/sek",
    '__gb_sec' => "GB/sek",
    '__tb_sec' => "TB/sek",
    '__mega' => "M",
    '__minute(s)' => 'Minute (s)',
    '__mls_not_in_key' => "Din produktnyckel stödjer inte flerspråkiga gränssnitt.",
    '__modification_date' => "Ändringsdatum",
    '__module' => "Anknytning",
    '__month' => "Månad",
    '__month(s)' => "Månad (s)",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Dec",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "April",
    '__month5' => "Maj",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Aug",
    '__month9' => "Sept",
    '__monthly' => "Månadsvis",
    '__months' => "Månader",
    '__moved_permanently' => 'Flyttades permanent',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Microsoft SQL Server-namn",
    'mssql__unable_to_change_server_name_db_exists' => "namnet för servern kan inte ändras: det finns åtminstone en databas på den.",
    '__mssql_status' => "Microsoft SQL serverstatus",
    '__multiply_login_deny' => "Kan inte logga in dig. En annan användare med samma användarnamn (%1) är redan inloggad på Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL-serverstatus",
    '__mysql_version' => "Mysql-version",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB serverstatus",
    '__mariadb_version' => "MariaDB-version",
    '__percona' => "Percona",
    '__percona_status' => "Percona serverstatus",
    '__percona_version' => "Percona-version",
    '__name' => "Namn",
    '__name_invalid' => "Namnet är ogiltigt.",
    '__nameserver' => "namnserver",
    '__network' => "Nätverk",
    '__networks' => "Nätverk",
    '__no' => "Nej",
    '__no_ip_address_with_properly_type_available' => "Kan inte återställa den säkerhetskopierade datan eftersom det inte finns de lämpliga IP-adresser som krävs för återställning.",
    '__no_clients_specified' => "Inga kundkonton har specificerats",
    '__no_comments' => "Inga kommentarer.",
    '__no_ip_specified' => "Ingen IP har specificerats.",
    '__nologin' => "Förbjuden",
    '__none' => "Ingen",
    '__not_configured' => "Inte konfigurerad",
    '__not_implemented_yet' => "Har inte implementerats ännu",
    '__not_supported_by_ftp' => "(stöds inte av FTP-servern)",
    '__not_supported_by_mailmng' => "stöds inte av e-postservern",
    '__notification' => "Anmälan",
    '__num_displayed' => "%1 av %2 visas",
    '__num_is_invalid' => "Siffran är ogiltig.",
    '__object_not_found' => 'Kan inte hitta objektet: %1',
    '__of_all' => "% av alla",
    '__off' => "Av",
    '__ok' => "OK",
    '__old_passwd' => "Gammalt %1 lösenord",
    '__on' => "På",
    '__others' => "andra",
    '__other_ip__will_be_added' => 'Andra tillgängliga IP-adresser (läggs till i kundens IP-pool)',
    '__out' => "Ut",
    '__p' => "P",
    '__passwd' => "%1 lösenord",
    '__passwd_is_invalid' => "%1 Lösenordet är ogiltigt.",
    '__passwd_not_match' => "Lösenorden matchar inte!",
    '__path' => "Sökväg",
    '__perl_unix_support' => "Perl-stöd",
    '__perl_win_support' => "Perl-stöd",
    '__perm_denied' => "Åtkomst nekad.",
    '__permissions' => "Behörigheter",
    '__personal_name' => "Namn",
    '__pg_admin_not_activated' => "PostgreSQL aktiverades inte på serverns administrationssida.",
    '__pg_not_inst' => "PostgreSQL installerades inte",
    '__pg_not_run_or_inst' => "PostgreSQL installerades inte eller körs inte.",
    '__pg_not_support_in_key' => "PostgreSQL stöds inte av licensnyckeln.",
    '__phone' => "Telefon",
    '__phosting' => "Fysisk hosting",
    '__php_support' => "PHP-stöd",
    '__php_run_as_isapi' => "Kör som ett ISAPI-tillägg",
    '__php_safe_mode' => "PHP 'safe_mode' på",
    '__php_version' => "PHP-version",
    '__physical' => "Fysisk hosting",
    '__plesk_stat_pdir' => "Skydda katalog '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Domänstatistik",
    '__plesk_stat_protect' => "Skydda åtkomsten till webbstatistiken med användarens FTP-användarnamn och lösenord",
    '__plesk_stat_protect_install' => "åtkomligt via lösenordsskyddad katalog '/Plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "Du valde inte ett webbstatistikprogram att använda för denna webbplats.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-serverstatus",
    '__popen_error' => "Det uppstod ett fel när popen-funktionen återkallades.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL-status",
    '__preferences' => "Inställningar",
    '__account_preferences' => "Kontoinställningar",
    '__interface_preferences_general' => 'Allmänt',
    '__interface_preferences_default' => 'Standardgränssnittspreferenser',
    '__interface_preferences_admin' => "Administratörs gränssnittsinställningar",
    '__interface_template' => 'Mall för gränssnittsanpassning',
    '__interface_preferences' => "Gränssnittsinställningar",
    '__proceed?' => "Vill du fortsätta?",
    '__protect_dir_user' => "Skyddad katalog-användare",
    '__protect_dir_users' => "Skyddad katalog-användare",
    '__protect_dirs' => "Skyddade kataloger",
    '__provider_contact_name' => "Ägarens kontaktnamn",
    '__python_unix_support' => "Python-stöd",
    '__python_win_support' => "Python-stöd",
    '__quota' => "Kvot",
    '__r' => "R",
    '__reconfigure' => "Omkonfigurera",
    '__record_type' => "Inlägg typ",
    '__release' => "Släppa",
    '__remote_db_not_supported_by_key' => 'Fjärrdatabasens värdtjänst stöds inte av din licensnyckel.',
    '__remove' => "Ta bort",
    '__remove_confirmation' => "Bekräfta borttagning",
    '__remove_protection' => 'Ta bort skydd',
    '__report' => "Rapport",
    '__report_auto' => 'Leveransschema',
    '__report_form' => "Rapportformulär",
    '__report_size_na' => "Tjänsten är inte tillgänglig",
    '__reports_list' => "Rapporter",
    '__requested' => "Begärd",
    '__required_fields' => "Obligatoriska fält",
    '__resp_name_invalid' => "Autosvarets namn är ogiltigt. Använd endast alfanumeriska tecken, punkter, understreck och blanksteg.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Serverns namn är ogiltigt.",
    '__screenshots' => 'Skärmbilder',
    '__script_warning' => "Genom att ta bort scripting-förmågan från den här domänen, kommer alla påverkade skript att visas som oformaterad text när de anropas av en webbläsare. Det rekommenderas för administratören, att ta bort alla beroende skript från den givna domänen.",
    '__sec' => "Visaconds",
    '__second(s)' => "Sekund(er)",
    '__see_list_of_logged_in' => "Se listan över nu inloggade användare.",
    '__select_certs_to_remove' => "Markera det certifikat som ska tas bort",
    '__select_domains_to_default_host' => "Välj en domän att ange som standard.",
    '__select_domains_to_remove' => "Välj domäner att ta bort.",
    '__type_domain_name_to_add' => "Ange ett domännamn att läggas till.",
    '__select_files_to_remove' => "Välj filer att ta bort.",
    '__select_ip' => "Tilldela IP-adress",
    '__select_ip_to_remove' => "Välj en IP-adress att ta bort.",
    '__select_domain_template' => "Använd domänens mallinställningar",
    '__select_templates_to_remove' => "Markera mallar att ta bort.",
    '__server' => "Server",
    '__server_total' => "Server total",
    '__service' => "Tjänst",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL-databasserver",
    '__service_description__mysql' => "MySQL-databasserver",
    '__service_title__web' => "Webbserver",
    '__service_description__web' => "Webbserver",
    '__service_title__smtp' => "SMTP-server",
    '__service_description__smtp' => "SMTP-server",
    '__service_title__mail' => "IMAP/POP3-server",
    '__service_description__mail' => "IMAP/POP3-server",
    '__service_title__dns' => "DNS-server",
    '__service_description__dns' => "DNS-server",
    '__service_title__postgresq' => "PostgreSQL-databasserver",
    '__service_description__postgresq' => "PostgreSQL-databasserver",
    '__service_title__spamassassin' => "SpamAssassin spamfiltretingstjänst",
    '__service_description__spamassassin' => "SpamAssassin spamfiltretingstjänst",
    '__services' => "Tjänster",
    '__all_services' => "Alla tjänster",
    '__sessions' => "Sessioner",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP-sessionsfunktionen stöds inte av aktuell FTP-server.",
    '__sessions_list' => "Sessioner",
    '__set' => "Slå på",
    '__setup_logo_pref' => "Logotyp",
    '__shared' => "Delad",
    '__shell_access_warning' => "Att tillåta skalåtkomst till systemet är mycket farligt för systemets säkerhet. Tillåt åtkomst till systemet endast om du verkligen vet vad du gör och endast till användare du litar på. Vill du verkligen tillåta åtkomst?",
    '__siteapp_not_support_in_key' => "Webbprogrammen stöds inte av licensnyckeln.",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurationen av detta webbprogram har ändrats manuellt. För att skydda de manuella modifieringarna, har omkonfiguration genom Plesk gjorts otillgängligt.',
    '__site_management' => "Webbpublicering", // indirect
    '__size' => "Storlek",
    '__skeleton' => 'Virtuell värdsservers innehåll',
    '__skins' => 'Skalutseenden',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-serverns status",
    '__some_fields_are_empty_or_invalid' => "Vissa fält är tomma eller innehåller ett felaktigt värde.",
    '__spamassassin' => "Skräppostfilter",
    '__spamassassin_status' => "SpamAssassin-status",
    '__spamd_status' => 'Skräppostfilterstatus',
    '__splited_backup' => "(multivolym-säkerhetskopia)",
    '__split_backup_file' => "Skapa en säkerhetskopia med flera volymer",
    '__split_backup_size' => "Volymstorlek",
    '__split_backup_less_than_500' => "Volymstorlekar mindre än 500 MB stöds inte",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-stöd",
    '__ssi_with_html' => "Använd SSI för *.htm- och *.html-filer",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-stöd",
    '__same_ssl' => "Använd en enda katalog för att lagra SSL/TLS- och icke-SSL/TLS-innehåll",
    '__same_ssl_cu' => "Gemensamt SSL/TLS- och icke-SSL/TLS-innehåll",
    '__state' => "Län",

    '__status__Active' => 'Aktiva',
    '__status__active' => 'aktiva',
    '__status__Passive' => 'Avstängd',
    '__status__passive' => 'avstängd',
    '__status__off' => 'avstängd',
    '__status__with_parent' => 'avstängd',
    '__status__backup_restore' => 'tillfälligt inaktiverad för säkerhetskopiering eller återställning',
    '__status__admin' => 'avstängt av serveradministratören',
    '__status__resseler' => 'upphävd av återförsäljaren',
    '__status__client' => 'upphävd av kunden',
    '__status__unknown' => 'Status är okänd',

    '__status_of' => "Status för %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel-server", // indirect
    '__subdomain' => "Subdomän",
    '__subdomain_name' => "Subdomän namn",
    '__subdomain_name_in_ASCII_form' => "Subdomännamn i ASCII-format",
    '__subdomains' => "Subdomäner",
    '__domainaliases' => "Domänalias",
    '__subdomains_list' => "Subdomäner",
    '__subdomains_not_support_in_key' => "Subdomänåtgärder stöds inte av licensnyckeln.",
    '__sys_user_type' => "FTP-användare",
    '__sys_user_type_main' => "Använd FTP-användarkontot i huvuddomänen",
    '__sys_user_type_native' => "Skapa ett separat FTP-användarkonto för denna underdomän",
    '__t' => "T",
    '__target_domain' => "Måldomän",
    '__template' => "Mall",
    '__template_not_accepted' => "Kan inte acceptera mallen: följande begränsningar har överskridits.",
    '__templates' => "Mallar",
    '__templates_list' => "Mallar",
    '__tera' => "T",
    '__title' => "Titel",
    '__tools' => "Verktyg",
    '__total' => "Totalt %1",
    '__total_size' => "Total storlek",
    '__total_used' => "Totalt använt",
    '__traffic' => "Trafik",
    '__traffic_by_client' => "Trafik för kunden",
    '__traffic_by_domain' => "Trafik efter domän",
    '__traffic_by_service' => "Trafik för tjänsten",
    '__traffic_history' => "Trafikhistorik",
    '__unable_change_locale' => "Kan inte ändra gränssnittsspråk: %1",
    '__unable_create_new_dom' => "Kan inte skapa en domän: %1",
    '__unable_define_dom_name' => "Kan inte definiera domännamn: %1",
    '__unable_define_necessary_properties' => "Kan inte definiera allt obligatoriska egenskaper.",
    '__unable_define_properties' => "Kan inte definiera egenskaper: %1",
    '__unable_exec_util' => "Kan inte köra verktyg: %1",
    '__unable_get_dns_a_recs' => "Kan inte hämta IP-adresser för A DNS-data för detta värddatorkonto: %1",
    '__unable_get_mbox_quota' => "Det gick inte att hämta information om storlek på e-postkontot.",
    '__unable_redirect_to_myself' => "Kan inte vidarebefordra till samma konto.",
    '__unable_redirect_to_my_alias' => "Kan inte vidarebefordra e-posten till e-postmailalias.",
    '__default_domain_redirect_to_myself' => "Kan inte sätta domän som standard för IP-adress:\n omdirigering till sig själv upptäckt.",
    '__unable_remove_client' => "Kan inte ta bort kund: %1",
    '__unable_set_up_mbox_quota' => "Kan inte ange gräns för postlådestorlek för domänen: %1",
    '__unable_setup_pass' => "Kan inte ange lösenord: %1",
    '__unable_to_create_new_account' => "Kan inte skapa en konto: %1",
    '__unable_to_define_db_size' => "Kan inte definiera databasstorleken.",
    '__unable_to_enable_short_names' => "Kan inte tillåta användningen av korta e-postkontonamn för konton POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Kan inte hämta skickad data: %1",
    '__unable_to_open_file' => "Kan inte öppna filen %1: %2",
    '__unable_to_update_subdomain' => "Kan inte att göra ändringar av subdomänen: %1",
    '__unable_update_cl_data' => "Kan inte spara ändringarna i användarkontot: %1",
    '__unable_update_db_params' => "Det gick inte att uppdatera databasparametrarna: %1.",
    '__unable_update_dom_data' => "Kan inte uppdatera domändata: %1",
    '__undefined' => "odefinierad",
    '__uninstall' => "Avinstallera",
    '__unknown_error' => "Okänt fel",
    '__unlimited_lower' => "Obegränsat",
    '__unset' => "Stänga av",
    '__update' => "Uppdatera",
    '__uploaded_file_is_invalid' => "Överförd fil är ogiltig: %1",
    '__url' => "URL",
    '__usage' => "Diskanvändning",
    '__user' => 'Användare',
    '__user_already_logged' => "En annan användare med samma användarnamn (%1) är redan inloggad på Plesk.",
    '__version' => "Version",
    '__aps_license' => "Licensnyckel",
    '__vh_type' => "Virtuell värddatortyp",
    '__vhosts_apache_status' => "Webbserverns status",
    '__wrong_charset_conversion' => 'Felaktig teckenuppsättning, omvandling från "%1" till "%2" är inte tillåtet',
    '__warning_' => "Varning!",
    '__warning_excl_ip_num' => "Dedikerad IP-adress",
    '__warning_expiration' => "Utgångsdatum",
    '__web_scripting' => "Skript för webben", // indirect
    '__web_serv' => "Webbserver", // indirect
    '__web_statistic' => "Webbstatistik", // indirect
    '__webmail' => "Webbpost", // +indirect
    '__webstat_not_installed' => "Webalizer har inte installerats på servern. Kontakta din tjänsteleverantör för assistans med Webaliser-installationen.",
    '__webstat_support' => "Webbstatistik",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "När du växlar från ett statistikprogram till ett annat, raderas alla rapporter skapade av det tidigare använda statistikprogrammet och nya rapporter skapas i enlighet med informationen som läses från loggfiler som lagras på servern. Detta betyder att om du konfigurerat systemet (under Domäner > Domännamn > Logghanterare > Loggrotering) till att behålla Loggfiler endast för den senaste månaden, kommer webbstatistiken att vara tillgänglig endast för den senaste månaden. Vill du byta till ett annat statistikpaket?",
    '__webstat_perm_denied' => 'Du saknar behörighet att hantera webbstatistik.',
    '__webuser' => "Webbanvändare",
    '__sysusers_list' => "Systemanvändare",
    '__sysuser' => "Systemanvändare",
    '__weekly' => "Veckovis",
    '__whats_new_in_version' => "Vad är nytt i Plesk %1?",
    '__wrong_hosting_type__none' => 'Det finns ingen webbvärdbasering konfigurerad på domän %1.',
    '__wrong_hosting_type__std_fwd' => 'Domän %1 har konventionell vidarebefordring konfigurerat. Denna åtgärd är tillgänglig endast för domäner med webbvärdbasering.',
    '__wrong_hosting_type__frm_fwd' => 'Domän %1 har frame-vidarebefordring konfigurerat. Denna åtgärd är tillgänglig endast för domäner med webbvärdbasering.',
    '__wu' => "Webbanvändare",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW-prefix har ändrats. Se till att modifiera SSL/TLS-certifikat på motsvarande sätt.",
    '__year' => "År",
    '__year(s)' => "År",
    '__yes' => "Ja",
    '__you' => "Du",
    '__zip_code' => "Postnummer",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avancerat",

    'admin_ed__edit_administrator_info' => "Redigera administratörsprofil",
    'admin_ed__create_default_client' => "Jag skulle vilja skapa ett standard kundkonto.",
    'admin_ed__unable_update' => "Kan inte uppdatera administratörsinformationen: %1.",

    'auth__update_admin_info' => "Ange administratörens information. Denna information krävs för att köra %1.",
    'auth__you_not_have_perm' => "Du har inte behörighet att hantera denna domän.",
    'auth__key_expired_admin' => 'Din Plesk-licens har gått ut. För att fortsätta använda Plesk, förnya din licens eller köp en ny.',
    'auth__key_expired_admin_restricted' => 'Din Plesk-licens har gått ut. Kontakta din tjänsteleverantör.',
    'auth__key_expired_client' => 'Plesk-licensen har gått ut. Kontakta din värddatorleverantör.',
    'autoinstaller__not_installed' => 'Autostaller-komponenten har inte installerats.',
    'autoinstaller__release_action' => 'Tillgängliga operationer',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Uppgradera till den nya Plesk-versionen',
    'autoinstaller__release_action_update' => 'Uppdatera eller lägga till nya komponenter',
    'autoinstaller__release_action_up2date' => 'Du har en uppdaterad version',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Inte installerat',
    'autoinstaller__component_action_update' => 'Uppdateringar är tillgängliga',
    'autoinstaller__component_action_upgrade' => 'En uppdatering är tillgänglig',
    'autoinstaller__component_action_up2date' => 'Du har en uppdaterad version',
    'autoinstaller__component_action_error' => 'Uppdateringar är inte tillgängliga',
    'autoinstaller__component_serverbuildtime' => 'Senaste utgåva',
    'autoinstaller__component_localbuildtime' => 'Din utgåva',
    'autoinstaller__component_installed_version' => 'Din version',
    'autoinstaller__component_available_version' => 'Senaste versionen',
    'autoinstaller__component' => 'Komponent',
    'autoinstaller__components' => 'Komponenter',
    'autoinstaller__components_title' => '%1-komponenter',
    'autoinstaller__component_dependency_note' => 'krävs för installation av de komponenter du valt',
    'autoinstaller__install_confirm' => 'Ja, jag vill installera dessa komponenter',
    'autoinstaller__install_confirm_request' => 'Markera kryssrutan för att bekräfta',
    'autoinstaller__install_title' => 'Bekräfta installation av markerade komponenter',
    'autoinstaller__key_update_confirm' => 'Bekräfta att hoppa över nyckeluppdatering och installera standardnyckeln',
    'autoinstaller__key_update_confirm_request' => 'Markera kryssrutan för att bekräfta.',
    'autoinstaller__key_update_failed' => '<p>Plesk kan inte uppdatera din produktlicens.</p><p>%1</p><p>Att fortsätta med uppgradering utan att ha rätt produktlicens resulterar i installation av en standardlicens med begränsad funktion. Administratörer rekommenderas att först skaffa en lämplig licensnyckel innan de fortsätter med produktuppgraderingen.</p>',
    'autoinstaller__email' => 'Sänd meddelande till',
    'autoinstaller__email_admin' => "Administratörens e-post",
    'autoinstaller__email_email' => 'Anpassad e-postadress...',
    'autoinstaller__release' => 'Utgåvans namn',
    'autoinstaller__releases' => 'Tillgängliga utgåvor',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Markera de komponenter som ska installeras',
    'autoinstaller__status_error' => 'Fel: %1',
    'autoinstaller__status_install_error' => 'Installation kunde inte startas: %1',
    'autoinstaller__status_install_busy' => 'Installationen kunde inte startas: en annan installationsprocedur körs för närvarande.',
    'autoinstaller__status_install_ok' => 'Installationen startade. Du kommer att meddelas om installationsförloppet via e-post (%1).',
    'autoinstaller__status_query_busy' => 'Installationen pågår.',
    'autoinstaller__status_query_error' => 'Det gick inte att hämta installationsstatusen: %1',
    'autoinstaller__status_unknown' => 'Det gick inte att hämta autoinstallarens status.',
    'autoinstaller__status_busy' => 'Autoinstalleraren är upptagen, vänta.',
    'autoinstaller__configure_title' => 'Uppdaterarens inställningar',
    'autoinstaller__preferences_legend' => 'Inställningar',
    'autoinstaller__target' => 'Tillfällig katalog för hämtade filer',
    'autoinstaller__target_invalid' => "Ange absolut sökväg",
    'autoinstaller__check_updates' => 'Sök efter uppdateringar vid administratörsinloggning i Plesk',
    'autoinstaller__check_updates_warning' => 'Nya <a href="%1">uppdateringar</a> är tillgängliga för %2',
    'autoinstaller__source_type' => 'Källtyp',
    'autoinstaller__source' => 'Käll-URL',
    'autoinstaller_source__preferences_legend' => 'Inställningar',
    'autoinstaller_source__type' => 'Källtyp',
    'autoinstaller_source__url_invalid' => 'Ogiltig källa',
    'autoinstaller_source__url_invalid_network' => 'Ogiltig käll-URL (exempel: http://källa, ftp://källa)',
    'autoinstaller_source__url' => 'Käll-URL',
    'autoinstaller__source_invalid_network' => 'Du har angett en ogiltig nätverksadress',
    'backup__repository' => 'Säkerhetskopierade filernas lagringsplats',
    'backup__error_notify_email' => 'Om felet inträffar under säkerhetskopieringen, skicka meddelande till e-post',
    'backup__dump_info' => "Säkerhetskopieringsinformation",
    'backup__dump_file_name_not_defined' => "Den säkerhetskopierade filens namn har inte specificerats.",
    'backup__local_file' => 'Lokal säkerhetskopiefil',
    'backup__domain_ftp' => 'fjärr-FTP-server',
    'backup__wrong_path' => "Felaktig sökväg till de säkerhetskopierade filernas lagring: använd inte teckensekvensen ../../",
    'backup__unable_to_connect_to_ftp_server' => "Kunde inte ansluta till FTP-servern: %1",
    'backup__unable_to_read_file' => 'Kan inte läsa den säkerhetskopierade filen.',
    'backup__backup_task_does_not_exist' => "Säkerhetskopieringsaktiviteten finns inte, du ska skapa den innan du startar.",
    'backup__restore_params' => "Återställningsparametrar",
    'backup__confirmation' => "Varning: domänen kommer inte att vara tillgänglig under säkerhetskopiering/återställning.",
    'backup__backup_method' => 'Säkerhetskopieringsmetod',
    'backup__dumpfile_name' => "Den säkerhetskopierade filens namn",
    'backup__dumpfile_name_is_invalid' => "Säkerhetskopiefilens namn är ogiltigt: Använd endast alfanumeriska tecken, bindestreck, punkt och understreck. Använd inte namn som beskrivning.* som filnamn för säkerhetskopian.",
    'backup__email_required' => "Din e-postadress krävs för att hålla dig informerad om säkerhetskopieringen och återställningsförloppet. Specificera din e-post i kontodetaljerna.",
    'backup__error_during_backup' => "Kan inte skapa den säkerhetskopierade filen: %1",
    'backup__input_email_warning' => "Du måste antingen specificera en e-postadress för meddelande eller radera kryssrutan.",
    'backup__make_download' => "lagra inte den säkerhetskopierade filen i lagringen, ladda bara ner den",
    'backup__make_dump' => 'skapa säkerhetskopierad fil och lagra på lokalt lagringsställe',
    'backup__makedump_to_ftp' => 'Skapa säkerhetskopia och lagra på fjärr-FTP-server',
    'backup__restore_ip' => "IP-adress för återställning",
    'backup__select_dumpfile' => "Markera en säkerhetskopierad fil.",
    'backup__time' => "Säkerhetskopieringstid",
    'backup__day' => 'Säkerhetskopia dag',
    'backup__view_dump_info' => "Visa säkerhetskopieringsinformation för domän %1",
    'backup__wrong_domain_name' => "Säkerhetskopiefilen innehåller data för domän %1 och därför kan den inte återställas på domän %2",
    'backup__incorrect_ftp_user_or_passwd' => "Felaktig FTP-användare eller lösenord. Korrigera FTP-kontots egenskaper",
    'backup__access_denied' => "Åtkomst nekad. Korrigera FTP-kontots egenskaper",
    'backup__restore_from' => "Återställ %1",
    'backup__domain_session_failed' => 'Domän %1 har inte säkerhetskopierats',
    'backup__client_session_failed' => 'Kunden %1 har inte säkerhetskopierats',
    'backup__domain_session_restore_failed' => 'Domän %1 återställdes inte',
    'backup__client_session_restore_failed' => 'Kundkontot %1 har inte återställts.',
    'backup__domain_session_complete' => 'Domän %1 har säkerhetskopierats',
    'backup__domain_session_backup' => 'Säkerhetskopia av domän %1',
    'backup__client_session_backup' => 'Säkerhetskopiering av kund %1',
    'backup__domain_stop_title' => 'Avbryter säkerhetskopiering av domän %1',
    'backup__client_stop_title' => 'Radering av återställningen av kundkonto %1',
    'backup__domain_restore_stop_title' => 'Avbryter återställning av domän %1',
    'backup__client_restore_stop_title' => 'Radering av återställningen av kundkonto %1.',
    'backup__domain_session_backup_stop' => 'Följande aktiva säkerhetskopieringsförlopp kommer att avbrytas. Säkerhetskopia kommer inte att skapas.',
    'backup__backup_stop_confirm' => 'Ja, jag vill stoppa säkerhetskopieringsprocessen',
    'backup__restore_stop_confirm' => 'Ja, jag vill stoppa återställningsprocessen',
    'backup__domain_session_restore' => 'Återställning av domän %1',
    'backup__domain_session_restore_stop' => 'Du är i begrepp att avbryta den aktiva återställningsprocessen.',
    'backup__domain_backup_file_info' => 'Information om domänsäkerhetskopia',
    'backup__domain_backup_file_list' => 'befintliga säkerhetskopierade filer',
    'backup__domain_backup_progress' => 'Förlopp för säkerhetskopieringen av webbplatsen %1',
    'backup__domain_restore_progress' => 'Förlopp för återställningen av webbplatsen %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tidsförbrukning: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tidsförbrukning: %1',
    'backup__ip_map_legend' => 'IP-mappning',
    'backup__ip_map_list_count' => 'IP-adresser',
    'backup__domain_restore_session_complete' => 'Domän %1 återställs.',
    'backup__domain_restore_session_complete_message' => 'Domän %1 återställdes.',
    'backup__domain_backup_file_delete' => 'Följande säkerhetskopior kommer att tas bort:',
    'backup__domain_backup_file_for_remove' => 'Välj säkerhetskopiefiler du önskar ta bort',
    'backup__backup_overwrite_file_confirm' => 'Ersättningsbekräftelse',
    'backup__backup_overwrite_file_confirm_text' => 'Det finns redan en säkerhetskopierad fil med namnet "%1". Vill du ersätta den?',
    'backup__backup_confirm_overwrite' => 'Bekräfta filersättning',
    'backup__backup_overwrite_legeng' => 'Ersätt',
    'backup__backup_not_contain_domain' => 'Säkerhetskopiefilen innehåller inte information om domän %1',
    'backup__backup_not_contain_client' => 'Den säkerhetskopierade filen innehåller ingen information om kundkonto %1',
    'backup__backup_client_info' => "Säkerhetskopiera kundens inställningar och kontodetaljer",
    'backup__client_backup_progress' => 'Förlopp för säkerhetskopieringen av kundkontot %1',
    'backup__client_session_complete' => 'Kundkontot %1 har säkerhetskopierats',
    'backup__client_backup_file_info' => 'Information om kundens säkerhetskopierade fil',
    'backup__restore_client_info' => "Återställ kundens inställningar och kontodetaljer",
    'backup__client_session_restore' => 'Återställer kundkonto %1',
    'backup__client_db_server_map' => 'Databasservermappning',
    'backup__domain_db_server_map' => 'Databasservermappning',
    'backup__client_restore_session_complete_message' => 'Kundkontot %1 har återställts.',
    'backup__client_restore_session_complete' => 'Kundkontot %1 har återställts.',
    'backup__restore_select_some' => 'Välj objekt att återställa.',
    'backup__client_restore_progress' => 'Återställningsförlopp för kundkontot %1',
    'backup__new_backup' => 'Skapa ny säkerhetskopia',
    'backup__done' => 'Klart:',
    'backup__done_domains' => '%1 domän(er) av %2',
    'backup__done_clients' => '%1 kund(er) av %2',
    'backup__remaining' => 'Återstående:',
    'backup__remaining_domains' => '%1 domän(er)',
    'backup__remaining_clients' => '%1 kund(er)',
    'backup__overall_backup_progress' => 'Övergripande säkerhetskopieringsprocess',
    'backup__comment_n_a' => 'gäller inte',
    'backup__command_ignore' => 'Kommando "%1" är ignorerat',
    'backup__no_objects' => 'det finns inga objekt att säkerhetskopiera',
    'backup__cli_warning_not_enough_ip' => 'VARNING: inte tillräckligt med IP-adresser för att göra standard-IP-mappning:',
    'backup__local_repository' => "Plesk lagring",
    'backup__ftp_repository' => 'FTP-lagring',
    'backup__ftp_login' => 'Användarnamn',
    'backup__ftp_password' => 'Lösenord',
    'backup__ftp_directory_hint' => 'Exempel: /minmapp/minasäkerhetskopior/',
    'backup__ftp_account_settings' => 'FTP-kontoinställningar',
    'backup__ftp_account_preferences' => 'FTP-kontoinställningar',
    'backup__repository_not_exist' => 'Katalogen finns inte',
    'backup__repository_not_readable' => 'Den angivna katalogen kan inte läsas',
    'backup__ftp_repository_not_configure' => 'För att använda en FTP-säkerhetskopieringslagring, <a href="%1">specificera först FTP-kontot</a>',
    'backup__ftp_repository_list_not_configure' => 'Kontoinställningarna har inte specificerats',
    'backup__repository_list_unable_listing' => 'Kan inte hämta fillistan',
    'backup__ftp_repository_unable_listing' => 'Det gick inte att hämta förteckning över katalog "%1":',
    'backup__repository_legend' => 'Lagring för säkerhetskopierade filer',
    'backup__store_in_repository' => 'Lagra filer i',
    'backup__local_repository_lable' => 'Lokal lagring',
    'backup__ftp_repository_lable' => 'FTP-lagring',
    'backup__ftp_repository_not_configure_hint' => '(kontoinställningarna har inte specificerats)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-kontot har inte specificerats eller stöds inte)',
    'backup__ftp_directory_not_exist' => 'Den angivna katalogen finns inte',
    'backup__other_user_process_modified' => 'En annan användare har stoppat säkerhetskopieringen eller migreringsprocessen.',
    'backup__another_user_exist' => 'Den pågående åtgärden initierades av en annan Plesk-användare. Denna användare är fortfarande inloggad i Plesk.',
    'backup__ftp_repository_wait' => 'Vänta under hämtning av information om FTP-lagringen',
    'backup__ftp_write_test_failed' => 'Kunde inte skriva testdata till FTP-kontot %1:',
    'bt_upload_to_repository' => 'Ladda upp filer till lokal lagring',
    'bt_new_restore' => "Återställ",
    'bt_backup_schedule' => "Schemalagd säkerhetskopiering",
    'backup_exist_backups' => "Befintliga säkerhetskopierade filer",
    'backup_dialog__page_title' => "Skapa säkerhetskopierad fil.",
    'backup_dialog__please_wait' => "Säkerhetskopieringen är redo att påbörjas. Denna åtgärd kan ta en viss tid.  Var god vänta...",
    'backup_conf__page_title' => 'Konfigurera säkerhetskopiering',
    'bt_accept' => "Acceptera",
    'bt_access' => "Åtkomst",
    'bt_action_log' => "Åtgärdslogg",
    'bt_add' => "Lägg till",
    'bt_add_client' => "Tilldela till användare",
    'bt_database_server_add' => 'Lägg tilll databasserver',
    'bt_add_services' => "Lägg till tjänster",
    'bt_anonftp_stats' => "Anon.FTP-statistik",
    'bt_anonymous_ftp' => "Anonym FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Bifoga",
    'bt_autoinstaller' => 'Uppdaterare',
    'bt_auto-updates' => 'Uppdaterare',
    'bt_back' => "<< Tillbaka",
    'bt_backup' => "Säkerhetskopiera",
    'bt_backup_configure' => "Inställningar för säkerhetskopiering",
    'bt_buy_certs' => "Köp certifikat",
    'bt_blocked_domains' => 'Svarta listan',
    'bt_blocked_domain_add' => 'Lägg till domän',
    'bt_card' => "Kort",
    'bt_cert' => "Certifikat",
    'bt_certificates' => "Certifikat",
    'bt_change_passwd' => "Ändra lösenord",
    'bt_clean_log' => "Rensa logg",
    'bt_clear' => "Rensa",
    'bt_client_templates' => "Kundmallar",
    'bt_clients' => "Kunder",
    'bt_codepage_change' => 'Ändra Encoding',
    'bt_comp_info' => "Komponenthantering",
    'bt_configure_maillists' => "Konfigurera Mailman",
    'bt_configure_odbc' => "ODBC-datakällor",
    'bt_configure' => 'Anpassa',
    'bt_copy' => "Kopiera",
    'bt_copy_move' => "Kopiera/flytta",
    'bt_create' => "Skapa",
    'bt_create_account' => "Skapa ett konto",
    'bt_create_dir' => "Lägga till en katalog",
    'bt_create_file' => "Lägg till fil",
    'bt_count_size' => "Beräkna storlek",
    'bt_crontab_unix' => "Schema",
    'bt_crontab_win' => "Schemaläggaren",
    'bt_custom_button_new' => "Lägg till en knapp",
    'bt_custom_buttons' => "Anpassade knappar",
    'bt_customize' => "Anpassa",
    'bt_databases' => "DatabaVisar",
    'bt_database_servers' => 'Databasservrar',
    'bt_sqlservers' => "Databasservrar",
    'bt_db_usr_new' => "Lägg till en databasanvändare",
    'bt_db_new' => "Lägg till en databas",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Ange som standard för DB Webadmin",
    'bt_decline' => "Avböj",
    'bt_default' => "Standard",
    'bt_defaultcomponents' => "Tredje parts tjänster",
    'bt_defaults' => "Standard",
    'bt_delete' => "Ta bort",
    'bt_directories' => "Skyddade kataloger",
    'bt_disable' => "Stänga av",
    'bt_dns' => "DNS-inställningar",
    'bt_dns_enable' => 'Aktivera',
    'bt_dns_disable' => 'Inaktivera',
    'bt_dns_default' => 'Återställ till standard',
    'bt_dns_zone_sync' => 'Tillämpa DNS-malländringarna',
    'bt_dnsrecord_add' => 'Lägg till post',
    'bt_do_backup' => "Säkerhetskopiera",
    'bt_do_restore' => "Återställ",
    'bt_do_upload' => "Ladda upp",
    'bt_domain_aliases' => "Domänalias",
    'bt_domain_templates' => "Domänmallar",
    'bt_domain_user' => "Domänadministratör",
    'bt_domain_user_passwd' => "Domänadministratörslösenord",
    'bt_domains' => "Domäner",
    'bt_domain_alias_add' => 'Lägg till domänalias',
    'bt_download' => "Hämta",
    'bt_download_log' => "Hämta",
    'bt_edit' => "Redigera",
    'bt_enable' => "Slå på",
    'bt_export' => 'Exportera',
    'bt_extras' => "Tillägg",
    'bt_file_manager' => "Filhanteraren",
    'bt_finish' => "Slutför",
    'bt_ftp_account' => "FTP-kontoegenskaper",
    'bt_forget_password' => "Glömt lösenordet?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP-status",
    'bt_get_password' => "Hämta lösenord",
    'bt_global_changes' => "Ändra",
    'bt_help' => "Hjälp",
    'bt_hide_aliases' => "Dölj alias",
    'bt_hide_toolbar' => 'Dölj verktygsfält',
    'bt_hide_subdomains' => "Dölj subdomäner",
    'bt_hide_domainaliases' => "Dölj domänaliaser",
    'bt_home' => "Hem",
    'bt_hosting' => "Värding",
    'bt_icf' => 'Brandvägg',
    'bt_install' => "Installera",
    'bt_ip_aliasing' => "IP-adresser",
    'bt_ip_add' => "Lägg till IP-adress",
    'bt_ip_pool' => "IP-pool",
    'bt_key_info' => "Licenshantering",
    'bt_key_buyonline_addons' => 'Beställ Plesk-tillägg.',
    'bt_key_buyonline_upgrades' => 'Beställ Plesk-uppgraderingar.',
    'bt_key_buyonline_new' => 'Beställ ny nyckel',
    'bt_key_update' => 'Hämta nycklar',
    'bt_key_upload' => 'Installera nyckel',
    'bt_key_download' => 'Hämtningsnyckel',
    'bt_key_revert' => 'Återskapa nyckel',
    'bt_limits' => "Gränser",
    'bt_locale_add' => 'Lägg till språkversion',
    'bt_locales' => 'Språk',
    'bt_log_manager' => "Log Hanterare",
    'bt_login' => "Logga in",
    'bt_login_vzpp' => "Logga in på Power Panel",
    'bt_logo' => "Branding",
    'bt_logo_default' => "Standardlogotyp",
    'bt_logo_send_link' => "Bifoga länk",
    'bt_logo_send_logo' => "Bifoga logotyp",
    'bt_logout' => "Logga ut",
    'bt_logrotation' => "Loggrotering",
    'bt_mail' => "E-post",
    'bt_mail_alias_add' => "Lägg till e-postalias",
    'bt_mail_aliases' => "E-postaliaser",
    'bt_mail_group_add' => "Lägg till medlem",
    'bt_mail_groups' => "Grupper",
    'bt_mail_name_add' => "Lägg till E-postkonto",
    'bt_mail_preferences' => "Inställningar",
    'bt_mail_group' => "E-postgrupp",
    'bt_mail_mailbox' => "E-postkonto",
    'bt_mail_redirect' => "Sändare",
    'bt_mail_resp_add' => "Lägg till automatsvar",
    'bt_mail_resp_attach_add' => "Lägg till bifogad fil",
    'bt_mail_resp_files' => "Bifogade filer",
    'bt_mail_responders' => "Autosvar",
    'bt_mail_spamfilter' => "Skräppostfilter",
    'bt_mail_webmail' => "Webbpost",
    'bt_maillist_new' => "Lägg till e-postlista",
    'bt_maillists' => "E-postlistor",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Skapa säkerhetskopia",
    'bt_manage' => "Hantera",
    'bt_master' => "Huvud",
    'bt_migrate' => 'Migrera',
    'bt_modules_add' => 'Lägg till ett tillägg',
    'bt_modules_manage' => 'Hantera tillägg',
    'bt_move' => "Flytta",
    'bt_mimetypes' => 'MIME-typer',
    'bt_mimetype_new' => 'Lägg till MIME-typ',
    'bt_new_client' => "Lägg till Kundkonto",
    'bt_new_domain' => "Lägg till domän",
    'bt_next' => "Nästa>>",
    'bt_next_page' => "Nästa",
    'bt_network_add' => "Lägg till nätverk",
    'bt_notifications' => "Meddelanden",
    'bt_odbc_dsn_add' => "Lägg till OBDC DSN",
    'bt_off' => "Av",
    'bt_on' => "På",
    'bt_on_off' => "På/Av",
    'bt_pd_new' => "Lägg till Skyddad katalog",
    'bt_pd_user_new' => "Lägg till användare",
    'bt_performance' => 'Uppträdande',
    'bt_permissions' => "Behörigheter",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Inställningar",
    'bt_prev_page' => "Föreg",
    'bt_preview' => 'Förhandsgranska webplats',
    'bt_print' => "Skriv ut",
    'bt_reboot' => "Starta om",
    'bt_reload' => "Läsa in igen",
    'bt_refresh' => "Uppdatera",
    'bt_register' => "Registrera",
    'bt_remove' => "Ta bort",
    'bt_enable_selected' => 'Slå på',
    'bt_disable_selected' => 'Stänga av',
    'bt_repair_ip' => "Reparation IP",
    'bt_report' => "Rapport",
    'bt_report_auto' => 'Rapportleverans',
    'bt_report_auto_new' => 'Lägg till leveransschema',
    'bt_report_new' => "Lägg till layout",
    'bt_reset' => "Återställ",
    'bt_restart_services' => "Tjänstehantering",
    'bt_save' => "Spara",
    'bt_send_by_email' => "Skicka med e-post",
    'bt_send_file' => "Skicka fil",
    'bt_send_mail' => "Skicka e-post",
    'bt_send_passwd' => "Skicka lösenord",
    'bt_send_text' => "Skicka Text",
    'bt_server' => "Server",
    'bt_server_add' => "Lägg till server",
    'bt_server_preferences' => "Serverinställningar",
    'bt_servers_list' => "Servrar",
    'bt_sessions' => "Sessioner",
    'bt_set' => "Ställ in",
    'bt_set_as_default' => "Ange som standard",
    'bt_setup' => 'Installation',
    'bt_show_aliases' => "Visa alias",
    'bt_show_subdomains' => "Visa subdomäner",
    'bt_show_domainaliases' => "Visa domänaliaser",
    'bt_shutdown' => "Stäng av",
    'bt_site_apppkgs' => "Applikationsvalv",
    'bt_site_apppool' => "applikation Pool",
    'bt_application-pool' => "Webbapplikationer",
    'bt_site_apps' => "Webbapplikationer",
    'bt_site_app_add' => "Installera applikationen",
    'bt_additional_key_upload' => 'Ladda upp en ny nyckel',
    'bt_additional_key_download' => 'Hämtningsnyckel',
    'bt_additional_key_remove' => 'Ta bort nyckel',
    'bt_additional_key_activate' => 'Aktivera',
    'bt_site_builder' => "Presence Builder-stöd",
    'bt_skeleton' => 'Virtuell värdsservers innehåll',
    'bt_skins' => 'Skalutseenden',
    'bt_skin_add' => 'Lägg till skal',
    'bt_skin_manual' => 'Referens för anpassade Plesk-skal', // not used
    'bt_skin_download' => 'Ladda ner skal',
    'bt_skin_replace' => 'Uppdatera skal',
    'bt_skip' => 'Hoppa över',
    'bt_spamassassin' => "Skräppostfilter",
    'bt_spamassassin_train' => "Utbildning",
    'bt_spamfilter' => "Skräppostfilter",
    'bt_sshterm' => 'SSH-terminal',
    'bt_start' => "Start",
    'bt_stop' => "Stopp",
    'bt_recycle' => "Återvinna",
    'bt_statistics' => "Statistik",
    'bt_subdomain_new' => "Lägg till subdomän",
    'bt_subdomains' => "Subdomäner",
    'bt_submit' => "Skicka",
    'bt_summary_report' => "Sammanfattningsrapport",
    'bt_support' => "Stöd",
    'bt_switch' => "Kontakt",
    'bt_system_time' => "Systemtid",
    'bt_task_new' => "Lägg till uppgift",
    'bt_dom_tmpl_add' => 'Lägg till Domänmall',
    'bt_cl_tmpl_add' => 'Lägg till kundmall',
    'bt_cron_backup' => 'Inställningar för schemalagd säkerhetskopiering',
    'bt_test' => "Test-anslutning",
    'bt_text' => "Text",
    'bt_touch' => "Ändra tidsstämpel",
    'bt_traffic' => "Trafik",
    'bt_traffic_history' => "Trafikhistorik",
    'bt_tsclient' => "Fjärrskrivbord",
    'bt_update' => "Uppdatera",
    'bt_upload' => "Ladda upp",
    'bt_upload_from_ftp' => "FTP-överföringar",
    'bt_virtualdirs' => 'Virtuella kataloger',
    'bt_virtualdir_new' => 'Lägg till Virtuell Katalog',
    'bt_virtualdir_add' => 'Lägg till Virtuell Katalog',
    'bt_web_app_new' => "Installera Java-program",
    'bt_web_stats' => "Webbstatistik",
    'bt_web_stats_ssl' => "Webbstatistik SSL/TLS",
    'bt_web_user_add' => "Lägg till webbanvändare",
    'bt_web_users' => "Webbanvändare",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Webbstatistikinställningar",
    'bt_hidden-referrer-add' => 'Dölj poster',
    'bt_group-referrer-add' => 'Gruppreferenter',
    'bt_whats_new_full' => "Se fullständig lista över ändringar",
    'bt_white_list' => "White List",
    'bt_white_list_add' => "Lägg till nätverk",
    'cert_add__unable_set_ca_cert' => "Det gick inte att ställa in CA-certifikatet: %1",
    'cert_add__unable_set_cert' => "Det gick inte att ställa in certifikatet: %1",
    'cert_add__unable_set_private_key' => "Det gick inte att ställa in den privata nyckeln: %1",
    'certificates_list__certificate_used_as_default' => "Ett av certifikaten du är på väg att ta bort används som standardcertifikat.",
    'certificates_list__certificates_assigned_on_ip' => "ett eller flera certifikat är tilldelade till IP-adresserna/domänerna.",
    'ch_pass__admin_pass' => "Ändra administratörens lösenord",
    'ch_pass__old_pass' => "Gammalt lösenord",
    'ch_pass__pass_confirm' => "Bekräfta",
    'ch_pass__unable_change_admin_pass' => "Kan inte ändra administratörens lösenord: %1",
    'check_mail_cycle__aliases' => "E-postcykling detekteras och adressen \"%1\" finns i aliaserna för detta e-postkonto.",
    'check_mail_cycle__autoresponders' => "E-postcykling detekteras och adressen \"%1\" finns i automatsvaret för detta e-postkonto.",
    'check_mail_cycle__mail_groups' => "E-postcykling detekteras och adressen \"%1\" finns i e-postgruppen för detta e-postkonto.",
    'check_mail_cycle__mail_name' => "E-postcykling detekteras och adressen \"%1\" sammanfaller detta e-postkonto.",
    'check_mail_cycle__redirect' => "E-postcykling detekteras och adressen \"%1\" sammanfaller med adressen för vidarebefordran för detta e-postkonto.",
    'check_mail_dup__redirect' => "En dubbel vidarebefordran detekteras och adressen \"%1\" sammanfaller med adressen för vidarebefordran för detta e-postkonto.",
    'check_mail_dup__mail_groups' => "En dubbel vidarebefordran detekteras och adressen \"%1\" finns i e-postgruppen för detta e-postkonto.",
    'check_maillist_cycle__admin' => "E-postcykling detekteras och administratörens e-postadress \"%1\" sammanfaller med adressen för e-postlistan.",
    'check_maillist_cycle__member' => "E-postcykling detekteras och adressen \"%1\" sammanfaller med adressen för e-postlistan.",
    'chk_js__enter_login_and_passwd' => "Ange användarnamn och lösenord.",
    'chk_js__enter_login_name' => "Ange användarnamn.",
    'chk_js__enter_passwd' => "Ange lösenord.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1 kontouppgifter",
    'cl_limits__cl' => "Kundens %1 gränser",
    'cl_logo__setup_logo_pref' => "Ställ in logoegenskaper för kund %1",
    'cl_new__enter_new_cl_data' => "Ange informationen om den nya kunden",
    'cl_new__unable_to_sent_notification' => 'Användarkontot har skapats, men sändningen av en avisering till kunden misslylckades: %1',
    'cl_perm__all_ip' => "Alla tillgängliga IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Alla IP-baserade värdtjänstkonton för kunder kommer att överföras till namnbaserade.",
    'cl_perm__allow_client_create_domain' => "Fälten du försöker välja är endast tillämpbara på kunder som får skapa domäner.",
    'cl_perm__allow_create_nb_w_ip' => "Kunden kan skapa namnbaserad värdtjänst genom att använda %1",
    'cl_perm__allow_creation_ip_based_hosting' => "TIllåt IP-baserade värdtjänst-kontoskapanden",
    'cl_perm__available_ips' => "Tillgängliga IPn",
    'cl_perm__change_limits' => "Gränsjusteringar",
    'cl_perm__cl_disk_space' => "Totalt tillgängligt diskutrymme",
    'cl_perm__cl_expiration' => "Kundkontots giltighetsperiod",
    'cl_perm__cl_max_box' => "E-postlådor",
    'cl_perm__cl_max_db' => "DatabaVisar",
    'cl_perm__cl_max_dom' => "Domäner",
    'cl_perm__cl_max_maillists' => "E-postlistor",
    'cl_perm__cl_max_subdom' => "Subdomäner",
    'cl_perm__cl_max_traffic' => "Total mängd tillgänglig trafik",
    'cl_perm__cl_max_wu' => "Webbanvändare",
    'cl_perm__cl_mbox_quota' => "E-postlådans storleksgräns för detta användarkonto",
    'cl_perm__current_maximum_exp_date' => "Aktuellt maximalt värde för domänens giltighetsperiod är %1; begärt %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Den aktuellt definierade gränsen för mängden diskutrymme som allokeras för e-postlådor i detta användarkonto är %1; begärt %2",
    'cl_perm__current_total_requested' => "Aktuellt totalt värde av domängränser för %1 är %2; begärt %3.",
    'cl_perm__current_total_requested_dom' => "Aktuellt antal %1 som tillhör denna kund är %2: begärt %3.",
    'cl_perm__disk_space' => "max mängd diskutrymme",
    'cl_perm__dashboard_stdgui' => 'Användargränssnitt',
    'cl_perm__dashboard' => 'Startsidevy',
    'cl_perm__stdgui' => 'Standardvy',
    'cl_perm__manage_dashboard' => 'Hantering av startsidan',
    'cl_perm__dashboard_and_stdgui' => 'Startsidevy och standardvy tillåts',
    'cl_perm__dashboard_only' => 'Endast Startsidevy tillåts',
    'cl_perm__stdgui_only' => 'Bara standardvy är tillåtet',
    'cl_perm__edit_cl' => "Kundens %1 behörigheter",
    'cl_perm__exp_date_exceeded' => "Giltighetsperioden du försöker ställa in överskrider den gräns som har specificerats inom de individuella domäner som gäller denna kund.",
    'cl_perm__invalid_value' => "Ogiltigt värde, bara siffror är tillåtet.",
    'cl_perm__limit_disk_space' => "%1 Begränsa den totala mängden diskutrymme",
    'cl_perm__limit_expiration' => "%1 Begränsa giltighetsperioden för kundkontot",
    'cl_perm__limit_max_box' => "%1 Begränsa maximalt antal e-postkonton",
    'cl_perm__limit_max_db' => "%1 Begränsa maximalt antal databaser",
    'cl_perm__limit_max_dom' => "%1 Begränsa maximalt antal domäner",
    'cl_perm__limit_max_maillists' => "%1 Begränsa maximalt antal e-postlistor",
    'cl_perm__limit_max_subdom' => "%1 Begränsa maximalt antal subdomäner",
    'cl_perm__limit_max_traffic' => "%1 Begränsa den totala mängden trafik",
    'cl_perm__limit_max_wu' => "%1 Begränsa maximalt antal webbanvändare",
    'cl_perm__limit_mbox_quota' => "%1 Ställ in e-postkvoten",
    'cl_perm__limits_exceeded' => "En eller flera gränser du försöker ställa in överskrider de gränser som har specificerats inom de individuella domäner som gäller denna kund.\nDen totala gränsen för kunden måste vara högre än eller lika med totalsumman för domängränserna som anges för detta kundkonto.",
    'cl_perm__mailbox_quota_exceeded' => "Gränsen för mängden diskutrymme som allokerats för e-postlådorna du försöker ställa in överskrider gränsen som definierats inom de individuella domäner som gäller detta kundkonto.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Gränsen för mängden diskutrymme reserverat för e-postkonton som du försöker ställa in överstiger begränsningen som angetts på servernivån.",
    'cl_perm__make_dumps' => "Säkerhetskopiera och återställ datafiler",

    'cl_perm__max_box' => "maximalt antal e-postkonton",
    'cl_perm__max_db' => "maximalt antal databaser",
    'cl_perm__max_dom' => "domäner",
    'cl_perm__max_maillists' => "maximalt antal e-postlistor",
    'cl_perm__max_subdom' => "subdomäner",
    'cl_perm__max_traffic' => "maximal trafikmängd",
    'cl_perm__max_wu' => "maximalt antal webbanvändare",
    'cl_perm__max_dom_aliases' => "domänalias",
    'cl_perm__mbox_quota' => "e-postkvot",
    'cl_perm__not_allow_create_nb_hst' => "Kunden kan inte skapa namnbaserad värdtjänst.",
    'cl_perm__select_ip_addrs' => "Välj IP-adresser",
    'cl_perm__this_ip_used_vrt_hst' => "Denna IP-adress används av virtuell värdtjänst.\nFör att radera IP-adressen, ta bort värdtjänsttjänsten eller ändra dess typ till namnbaserad.",
    'cl_perm__unable_off_ipb_creating' => "Kunden har redan IP-baserad värdtjänsttjänst inställd. För att inaktivera denna funktion för kunden, radera kryssrutan \"Domänskapande\" eller ta bort alla IP-baserade värdtjänstkonton.",
    'cl_perm__unable_off_nb_creating' => "Kunden har redan en namnbaserad värdtjänsttjänst inställd. För att inaktivera denna funktion för kunden, radera kryssrutan \"Domänskapande\" eller ta bort alla namnbaserade värdtjänstkonton.",
    'cl_perm__unable_set_domain_limit' => "Kan inte begräns adet maximala antalet domäner: kunden har redan %1 domäner",
    'cl_perm__unable_update_client_limitations' => "Kan inte ändra gränserna för kundkontot: %1",
    'cl_pref__edit_cl' => "Kundens %1 preferenser",
    'class_anonftp__create_ftp_domain' => "Ingen virtuell FTP-domän för detta dom_id. Försök skapa det först.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Diskutrymmesgränsen som du försöker ange (%1) får inte överstiga den totala diskutrymmesgränsen definierad på domännivån (%2).",
    'class_anonftp__invalid_input_only_digits' => "Ogiltigt värde har angetts, bara siffror är tillåtet.",
    'class_anonftp__unable_change_ownerships' => "Kan inte ändra ägarskap eller behörigheter för kvotfilen: %1",
    'class_anonftp__unable_copy_quota_file' => "Kan inte kopiera den angivna filen: %1",
    'class_anonftp__unable_get_disk_usage' => "Det gick inte att hämta diskanvändningsinformation om den inkommande katalogen: %1",
    'class_anonftp__unable_parse_quota_file' => "Kan inte analysera kvotfilen.",
    'class_anonftp__unable_read_quota_file' => "Kan inte läsa kvotfilen: %1",
    'class_anonftp__unable_update_quota' => "Det gick inte att uppdatera kvoten: filerna i den inkommande katalogen använder %1 KB diskutrymme, vilket överstiger det nya kvotvärdet.",
    'class_anonftp__unable_write_temp_file' => "Kan inte skriva till den tillfälliga filen: %1",
    'class_bsdomain__warn_max_date__' => "Utgångsdatum har angetts till %1",
    'class_cList__empty' => "Inga objekt.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Inga matchningar hittades för <b>\"%1\"</b> i %2 (%3 av %4).",
    'class_cList__search_result' => "Sökresultat för  <b>\"%1\"</b> in %2 (%3 av %4).",
    'class_client__client_creation_notification' => "Kundens skapande av meddelande.",
    'class_client__client_with_contact_name_already_exists' => "Kunden med namnet %1 finns redan.",
    'class_client__disk_space' => "Utrymme",
    'class_client__invalid_max_dom' => "Ogiltigt värde för antal domäner, endast siffror är tillåtet.",
    'class_client__limit_exceed' => "Den begärda andelen för %1 kan inte tilldelas eftersom det gör att kundens tilldelning överskrids i %2 kontot (%3). Om du vill allokera flera resurser, gå till Kunder > kundnamn > Gränser och ändra tilldelningarna vid behov. Återgå sedan till denna skärm och försök justera tilldelningarna igen.",
    'class_client__limit_exceed_unlimited' => "Om du vill allokera en obegränsad mängd resurser (%1), ska du först gå till Kunder > kundnamn > Gränser och välja kryssrutan Obegränsad som motsvarar önskad resurstyp. Återgå sedan till denna skärm och försök justera tilldelningarna igen.",
    'class_client__max_box' => "E-postlådor",
    'class_client__max_db' => "DatabaVisar",
    'class_client__max_maillists' => "E-postlistor",
    'class_client__max_subdom' => "Subdomäner",
    'class_client__max_traffic' => "Maximal trafik",
    'class_client__max_wu' => "Webbanvändare",
    'class_client__max_dom_aliases' => "Domänalias",
    'class_client__mbox_quota' => "E-postkvot",
    'class_client__unable_define_cl_status' => "Kan inte definiera status för kundkontot: %1",
    'class_client__unable_define_inactive_dom' => "Kan inte till definiera inaktiv domän %1.",
    'class_client__unable_del_ip' => "Kan inte ta bort IP: %1",
    'class_db__db_name_not_set' => "Databasens namn är inte angett.",
    'class_db__db_not_exist_for_curr_dom' => "Databasen finns inte för denna domän.",
    'class_db__invalid_db_or_dom_name' => "Domänen eller databas-ID är ogiltigt eller databasnamnet är inte definierat.",
    'class_db__invalid_pass' => "Lösenordet är ogiltigt.",
    'class_db__mailgrp_member_exist' => "E-postgruppens medlemm finns redan",
    'class_db__access_hosts_notsupport' => 'Åtkomsten till värdinställningen stöds inte för denna databastyp',
    'class_db__unable_add' => 'Det gick inte att lägga till åtkomstvärd-posten: %1',
    'class_db__unable_del' => 'Det gick inte att radera åtkomstvärd-posten: %1',
    'class_db__inc_user_not_exist' => 'Databasanvändaren "%1" finns inte',
    'class_db__inc_access_record_exist' => 'Denna åtkomstpost finns redan',
    'class_db__inc_access_record_not_exist' => 'Den givna åtkomstposten existerar inte',
    'class_db__inc_unable_del_last_record' => 'Kan inte radera den senaste åtkomstvärdens post',
    'class_domtmpleditform__dns_master' => "Huvud",
    'class_domtmpleditform__dns_slave' => "Slav",
    'class_domtmpleditform__dns_type' => "Typ av domän-DNS-zon",
    'class_traffichistory__no_data_available' => "Inga data tillgängliga.",
    'class_traffichistory__reten_pref' => 'Inställningar om lagring av webb- och trafikstatistik',
    'class_traffichistory__traffic_usage' => "Trafikanvändning",
    'clienttrafficlist_header' => "Trafik på domäner",
    'clienttrafficlist_header_of_client__' => "Trafik vid domänerna för kund %1",
    'cmd_dns__a_dns_record_already_exist' => "A-post står i strid med klisterposten för zonen.",
    'cmd_dns__domain_last_ns' => 'Kan inte radera den senaste NS DNS-posten för domänen.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Det kanoniska domännamnet är ogiltigt.",
    'cmd_dns__cname_dns_record_already_exist' => "CNAME-post står i strid med klisterposten för zonen.",
    'cmd_dns__cname_in_rr_combination' => 'Felaktig kombination av DNS-poster finns i DNS-zonen',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS-zonposten kan inte samexistera med andra DNS-poster i samma zon.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS-posttypen är ogiltig.",
    'cmd_dns__ext_host_is_not_resolved' => "Det kanoniska namnet %1 kan inte lösas med A eller AAAA uppgiften.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Kan inte lägga till uppgiften %1 till zonen %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "E-postutväxlarnamnet är ogiltigt.",
    'cmd_dns__mx_priority_is_invalid' => "MX-prioriteten är ogiltig.",
    'cmd_dns__name_server_is_invalid' => "Namnserver är ogiltig.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Nätverksmaskens värde ska vara 24, 16 eller 8.",
    'cmd_dns__this_dns_record_already_exists' => "En sådan DNS-post finns redan.",
    'cmd_dns__unable_add_record' => "Kan inte lägga till '%1'-posten: %2",
    'cmd_dns__unable_add_a_record' => "Kan inte lägga till A-posten: %1",
    'cmd_dns__unable_add_cname_record' => "Det gick inte att lägga till CNAME-posten: %1",
    'cmd_dns__unable_add_dns_record' => "Det gick inte att lägga till DNS-posten: %1",
    'cmd_dns__unable_add_ext_ns_record' => "Kan inte lägga till EXT_NS-posten: %1",
    'cmd_dns__unable_add_ns_record' => "Det gick inte att lägga till NS-posten: %1",
    'cmd_dns__unable_add_ptr_record' => "Det gick inte att lägga till PTR-posten: %1",
    'cmd_dns__unable_add_txt_record' => "Det gick inte att läggaTXT-posten: %1",
    'cmd_dns__unable_create_dns_zone' => "Kan inte skapa DNS-zonen %1",
    'cmd_dns__unable_define_dns_record' => "Kan inte definiera DNS-posten %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Det gick inte att hämta status för standard-DNS-zon: %1",
    'cmd_dns__unable_insert_a_record' => "Det gick inte att infoga A-post: %1",
    'cmd_dns__unable_insert_mx_record' => "Det gick inte att infoga MX-post: %1",
    'cmd_dns__unable_insert_ns_record' => "Det gick inte att infoga NS-post: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Det gick inte att ange status för standard-DNS-zon: %1",
    'cmd_domains__dom_already_exists' => "Domänen %1 finns redan.",
    'cmd_domains__dns_record_already_exists' => "Kan inte skapa domänen %1 eftersom en DNS-post som pekar på värddatorn %1 redan finns.",
    'cmd_domains__dom_already_exists1' => "Det finns %2 subdomäner i denna domän. Domänen %1 finns redan.",
    'cmd_domains__dom_already_exists2' => "underdomänen %1 finns redan.",
    'cmd_domains__dalias_already_exists' => "Denna alias finns redan.",
    'cmd_domains__domain_alias_already_exists' => 'En domänalias med ett sådant namn finns redan.',
    'cmd_domains__unable_del_mail_for_dom' => "Kan inte radera e-posttjänsterna för domänen: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Kan inte radera ett anonymt FPT-kontos egenskaper: %1",
    'cmd_domains__unable_update_dom_param' => "Det gick inte att uppdatera domänparametrarna: %1.",
    'cmd_domains__unable_rename_client_exist' => "domänens administratörsanvändarnamnet används redan.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Värdtjänsttypen är inte fysisk.",
    'cmd_hosting__unable_create_user' => "Kan inte skapa användare %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Kan inte definiera IP-adressen för namnbaserade virtuella värdar: %1",
    'cmd_hosting__unable_del_old_hst' => "Kan inte radera den tidigare inställda värdtjänsten: %1",
    'cmd_hosting__unable_del_protected_directory' => "Det går inte att ta bort skyddade katalog: %1.",
    'cmd_hosting__unable_del_web_user' => "Det går inte att ta bort webbanvändare: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Kan inte skapa eller uppdatera den virtuella värden: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Kan inte ställa in ramens vidarebefordran-värdtjänst.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Kan inte återuppbygga proftpd-konfigurationsfilen %1.",
    'cmd_hosting__unable_set_up_ssl' => "Det går inte att konfigurera SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Det går inte att ta bort skydd från SSL/TLS-katalog: %1",
    'cmd_hosting__unable_update_dest_url' => "Kan inte uppdatera destinations-URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Det går inte att uppdatera DNS-zonen för domänen: verktygsexekveringen misslyckades.",
    'cmd_hosting__unable_update_ftp_passwd' => "Kan inte uppdatera FTP-lösenordet %1.",
    'cmd_hosting__unable_update_user' => "Kan inte uppdatera användare %2: %1",
    'cmd_hosting__unknown_hst_type' => "Okänd värdtjänsttyp.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Du saknar behörighet att avsluta värdtjänsttjänsten.",
    'cmd_mail__autoresponder__not_configured' => "Autosvar för detta e-postkonto har inte konfigurerats.",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adressen %1 används redan för vidarebefordran av e-post.",
    'cmd_mail__alias_already_exists' => "alias finns redan.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Autosvarets ID och e-postkontots ID matchar inte.",
    'cmd_mail__autoresp_id_is_undefined' => "Autosvar-ID är odefinierat.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "E-postalias med ett sådant namn finns redan för e-postkonto %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "E-postkontot %1 är redan abonnerat på denna utskickslista av e-post.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "E-postkontot %1 finns redan i denna domän.",
    'cmd_mail__mail_name_not_exist' => "E-postkontot finns inte.",
    'cmd_mail__mail_name_passwd_part' => "Lösenordet får inte innehålla e-postkontonamnet som en del av det.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "E-postlista %1 finns redan på denna domän.",
    'cmd_mail__mailname_already_exist_in_mg' => "E-postkontot %1 är redan med i en e-postgrupp.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "E-postkontot %1 finns redan i denna domän.",
    'cmd_mail__mailname_already_exists' => "E-postkontot finns redan.",
    'cmd_mail__mailname_is_invalid' => "E-postkontonamnet %1 är ogiltigt.",
    'cmd_mail__mailname_unable_update' => "Kan inte uppdatera e-postkontos egenskaper:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Maximalt antal autosvar har nåtts för denna domän.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Maximalt antal e-postgrupper har nåtts för denna domän.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Maximalt antal vidarebefordrare har nåtts för denna domän.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Maximalt antal e-postlådor har nåtts.",
    'cmd_mail__no_members_specified' => "inga medlemmar har specificerats.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Lösenordet är för enkelt, välj ett annat.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Denna e-postadress används redan.",
    'cmd_mail__unable_define_autoresp_id' => "Kan inte definiera autosvar-ID: %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Kunde inte radera e-posttjänsterna för domänen: %1",
    'cmd_mail__unable_del_mail_for_dom' => "Kan inte ta bort e-posttjänsten från domänen: %1.",
    'cmd_mail__unable_del_mail_redirection' => "Kan inte ta bort e-postsändningstjänsten %1",
    'cmd_mail__unable_remove_autoresp' => "Kan inte ta bort autosvar: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Kan inte ta bort e-postgruppmedlemmarna: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Klicka för att stänga av e-postgruppen: %1",
    'cmd_mail__unable_update_mail_redirect' => "Kan inte omkonfigurera e-postsändningstjänsten %1",
    'cmd_mail__uploaded_file_is_too_big' => "Den uppladdade filstorleken är för stor.",
    'cmd_mail__additionally' => "Dessutom:",
    'cmd_pd__invalid_login' => "Felaktigt användarnamn.",
    'cmd_pd__this_user_already_exist' => "Denna användaren finns redan.",
    'cmd_pd__unable_define_hst_type' => "Kan inte definiera värdtjänsttyp.",
    'cmd_pd__unable_upd_pd_usr' => "Kan inte uppdatera egenskaper för skyddad katalog-användare: %1.",
    'cmd_pd__user_is_undefined' => "Användaren är odefinierad.",
    'cmd_server__no_enough_free_disk_space' => "Det finns inte tillräckligt med ledigt diskutrymme.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "det gamla lösenordet är felaktigt. Försök igen.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "gräns för maximalt antal webbanvändare har nåtts för denna domän.",
    'cmd_web_usr__unable_create_user' => "kan inte skapa systemanvändare: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "kan inte definiera gräns för maximalt antal webbanvändare: %1",
    'cmd_web_usr__user_already_exists' => "Användaren finns redan.",
    'cmd_web_usr__web_user_name_is_invalid' => "webbanvändarnamnet %1 är ogiltigt.",
    'cmd_web_usr__web_user_not_exist' => "webbanvändaren finns inte.",
    'common_func__exec_bad_argument' => "exec-argumentet ska inte innehålla enkelt citattecken.",
    '__eol' => 'Radbrytningar',
    'eol__binary_file' => 'Kan inte ändra radbrytningsstil i binär fil.',
    'comp_info__header' => 'Komponenter',
    'comp_info__comp_name' => "Komponentnamn",
    'comp_info__comp_disabled' => 'Avstängd',
    'comp_info__comp_active' => 'Aktiva',
    'comp_info__comp_not_configured' => 'Inte konfigurerad',
    'comp_info__comp_not_started' => 'Inte startat, kontrollera komponentinställningar',
    'comp_info__comp_version' => "Komponentversion",
    'comp_info__integration_error' => "Fel vid integrering",
    'comp_info__title' => "Plesk Components",
    'comp_info__service_name' => "Tjänst",
    'comp_info__last_updated' => '(senast uppdaterad: %1)',
    'configure__full_hostname' => "Fullständigt värdnamn",
    'cp_access_admin_deny' => "Åtkomst för administratören från adressen '%1'  är begränsad enligt IP-åtkomstens begränsningspolicy som tillämpas för närvarande.",
    'create_domain_warn__' => "Följande undantag gjordes under domänskapande:",
    'create_domain__client_select' => 'Markera kunden du vill skapa domänen för',

    'dashboard__nav_button_name' => "Hem",
    'dalias__list_title' => 'Domänalias för domänen %1',
    'dalias__list_legend' => 'Domänalias',
    'dalias__list_header' => 'Domänalias',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Domänens aliasnamn',
    'dalias__list_ascii_name' => 'I ASCII-format',
    'dalias__remove_title' => 'Följande domänalias för domänen %1 kommer att tas bort:',
    'dalias__select_domain_aliases_to_remove' => 'Välj domänalias som ska tas bort.',
    'dalias__mail_turn_on_failed' => 'Kan inte aktivera e-posttjänsten: %1',
    'dalias__web_turn_on_failed' => 'Kan inte aktivera webbtjänsten: %1',
    'db_usr_edit__db_usr_name_old' => "Den tidigare databasens användarnamn",
    'databases__db_title' => "MS SQL Server-administratörens inloggningsuppgifter och verktyg",
    'databases__server_title' => "%1-administratörens lösenord",
    'databases__connection' => "Anslutning",
    'databases__db_server' => "Servernamn",
    'databases__db_admin_login' => "Administratörs användarnamn",
    'databases__db_admin_passwd' => "Administratörslösenord",
    'databases__db_confirm_passwd' => "Bekräfta lösenord",
    'databases__can_not_manage' => "Du kan inte hantera databasserver",
    'databases__not_installed' => "(inte installerad)",
    'databases__not_supported_license' => "(stöds inte av din licensnyckel)",
    'databases__title' => "Databasadministration och administratörs inloggningsuppgifter",
    'databases__unable_connect' => "Det gick inte att komma åt databasen. Felaktiga parametrar.",
    'databases__incorrect_db_admin_login' => 'Användarnamnet kan innehålla endast alfanumeriska tecken, bindestreck och understreck, och måste börja med ett alfabetiskt tecken.',
    'databases__incorrect_db_admin_passwd' => 'Lösenordet ska inte innehålla användarnamnet.',
    'database_servers_form__title' => 'Databasservrar',
    'database_servers_form__server_list_legend' => 'Databasservrar',
    'database_servers_form__remove_empty_selection' => 'Inga databasservrar valda.',
    'database_servers_form__remove_title' => 'Följande databasservrar kommer att tas bort:',
    'database_server_database_list__client' => 'Kund',
    'database_server_database_list__domain' => 'Domän',
    'database_server_database_list__header' => 'DatabaVisar',
    'database_server_database_list__name' => 'Namn',
    'database_server_databases_form__databases_list_legend' => 'DatabaVisar',
    'database_server_databases_form__remove_empty_selection' => 'Inga databaser har valts.',
    'database_server_databases_form__remove_title' => 'Följande databaser kommer att tas bort:',
    'database_server_databases_form__tab' => 'Databaser (%1)',
    'database_server_edit_form__admin_login' => "Användarnamn",
    'database_server_edit_form__admin_password' => "Lösenord",
    'database_server_edit_form__admin_password2' => "Bekräfta lösenord",

    'database_server_edit_form__default' => 'Använd denna server som standard för %1',
    'database_server_edit_form__duplicate' => 'En databasserver med denna kombination av värddatoradresser och portnummer har redan registrerats.',
    'database_server_edit_form__host' => 'Värddatornamn eller IP-adress',
    'database_server_edit_form__legend_authentication' => 'Verifiering',
    'database_server_edit_form__legend_general' => 'Allmänt',
    'database_server_edit_form__port' => 'Portnummer',
    'database_server_edit_form__port_hint' => 'Lämna tomt för standardportnummer',
    'database_server_edit_form__tab' => 'Databasserver',
    'database_server_edit_form__title_new' => 'Nytt databasservernamn',
    'database_server_edit_form__title_edit' => 'Databasserver på %1',
    'database_server_edit_form__type' => 'Databasservertyp',
    'database_server_edit_form__unix_socket' => '(lokal anslutning)',
    'database_server_edit_form__external_connection' => 'Tillåt att en lokal MySQL-server får acceptera externa anslutningar',
    'database_server_edit_form__external_connection_hint' => 'Om du ändrar den här inställningen kommer den lokala MySQL-servern att startas om. För att aktivera fjärråtkomst till andra MySQL-servrar som är registrerade i Plesk, ändra deras konfiguration manuellt.',
    'database_server_edit_form__external_connection__configured_to_local' => 'Lokal MySQL-server konfigurerades för att avvisa fjärranslutningar',
    'database_server_edit_form__external_connection__configured_to_remote' => 'Lokal MySQL-server konfigurerades för att acceptera fjärranslutningar',
    'database_server_error__consult_admin' => 'Kontakta serveradministratören.',
    'database_server_error__last__connection_failed' => 'Det senaste försöket att kontrollera denna databasserver misslyckades till följd av nätproblem.',
    'database_server_error__last__permission_denied' => 'Det senaste försöket att kontrollera denna databassserver misslyckades på grund av att kontot ifråga inte har administrativa behörigheter.',
    'database_server_error__last__credentials_not_set' => "Det senaste försöket att ansluta till denna server misslyckades eftersom giltigt användarnamn och lösenord för administratören ej angetts.",
    'database_server_error__last__other_error' => 'Det senaste försöket att kontrollera denna databasserver misslyckades.',
    'database_server_error__real__connection_failed' => 'Anslutningen till databasservern misslyckades till följd av nätverksproblem:',
    'database_server_error__real__permission_denied' => 'Anslutningen till databasservern misslyckades eftersom kontot ifråga inte har administrativa behörigheter.',
    'database_server_error__real__duplicate_object' => 'Anslutningen till databasservern misslyckades till följd av en namnkonflikt',
    'database_server_error__real__unacceptable_name' => 'Anslutningen till databasservern misslyckades till följd av ett ogiltigt objektsnamn:',
    'database_server_error__real__unacceptable_password' => 'Anslutningen till databasservern misslyckades till följd av ett icke godkänt lösenord:',
    'database_server_error__real__credentials_not_set' => "Plesk kan inte ansluta till databasservern eftersom giltigt användarnamn och lösenord för administratören ej angetts.",
    'database_server_error__real__other_error' => 'Anslutningen till databasservern misslyckades:',
    'database_server_error__test__connection_failed' => 'Testanslutningen till databasservern misslyckades till följd av nätverksproblem:',
    'database_server_error__test__permission_denied' => 'Testanslutningen till databasservern misslyckades eftersom kontot ifråga inte har administrativa behörigheter:',
    'database_server_error__test__duplicate_object' => 'Testanslutningen till databasservern misslyckades till följd av en namnkonflikt:',
    'database_server_error__test__unacceptable_name' => 'Testanslutningen till databasservern misslyckades till följd av ett ogiltigt objektsnamn:',
    'database_server_error__test__unacceptable_password' => 'Testanslutningen till databasservern misslyckades till följd av ett icke godkänt lösenord:',
    'database_server_error__test__credentials_not_set' => "Testanslutningen till denna server misslyckades eftersom giltigt användarnamn och lösenord för administratören ej angetts.",
    'database_server_error__test__other_error' => 'Testanslutningen till databasservern misslyckades:',
    'database_server_list__header' => 'Databasservrar',
    'database_server_list__last_error' => 'S',
    'database_server_list__type' => 'Servertyp',
    'database_server_list__host' => 'Värdnamn',
    'database_server_list__port' => 'Port',
    'database_server_list__version' => 'Version',
    'database_server_list__dbcount' => 'DatabaVisar',
    'db__create_new_db' => "Lägg till en databas",
    'db__db_add' => "Lägg till databas",
    'db__db_for_dom' => "Databaser på webbplatsen %1",
    'db__db_id_undefined' => "Databas-ID är odefinierat.",
    'db__db_name' => "Databasnamn",
    'db__db_not_exist' => "Databasen finns inte.",
    'db__db_type' => "Typ",
    'db__db_server' => "Databasserver",
    'db_server_not_exist' => "Databasservern finns inte.",
    'db__db_user_not_exist' => "Databasanvändaren finns inte.",
    'db__domain_not_exist' => "Domänen finns inte.",
    'db__enter_db_name' => "Ange den nya databasens namn.",
    'db__invalid_db_id' => "Databasidentifierare är ogiltig.",
    'db__invalid_db_name' => "Databasens namn är ogiltigt. Databasens namn får bara innehålla latinska bokstäver, siffror, understreck och bindestreck. Det kan blev inte längre än 63 symboler.",
    'db__max_db_reached_for_dom' => "Gränsen för antalet databaser har nåtts för denna domän.",
    'db__max_mssql_db_reached_for_dom' => "Gränsen för antalet Microsoft SQL Server-databaser har nåtts för denna domän.",
    'db__postgres_not_connect_for_admin' => "Kan inte ansluta till PostgreSQL. Slå på PostgreSQL-stöd på serveradministrationssidan.",
    'db__postgres_not_connect_for_client' => "Kan inte ansluta till PostgreSQL. Kontakta din systemadministratör om du behöver hjälp.",
    'db__remove_db_on_domain' => "Följande databaser för webbplats %2 som ägs av kunden %1 kommer att tas bort:",
    'db__remove_db_on_domain_of_cl' => "Följande databaser för domän %2 som ägs av kunden %1 kommer att tas bort:",
    'db__remove_db_linked_resource' => 'Denna databas används i ett webbprogram. Den kan tas bort endast efter avinstallationen av detta webbprogram.',
    'db__remove_db_users' => "Följande användare av databasen %3 på webbplats %2 som ägs av kunden %1 kommer att tas bort:",
    'db__remove_db_users_of_cl' => "Följande användare av databasen %3 på webbplats %2 som ägs av kunden %1 kommer att tas bort:",
    'db__select_db_for_remove' => "Markera de databaser som ska tas bort.",
    'db__select_db_users_for_remove' => "Välj de databasanvändare som ska tas bort.",
    'db__unable_create_db_user' => "Kan inte skapa databasanvändare: %1",
    'db__unable_define_db_name' => "Kan inte definiera databasnamnet: %1.",
    'db__unable_define_db_user' => "Kan inte definiera databasanvändaren: %1",
    'db__unable_define_db_users' => "Kan inte definiera databasanvändarna: %1.",
    'db__unable_select_dom_name' => "Kan inte välja domännamn: %1",
    'db_edit__db_for_dom' => "Användare för databas %1 på domän %2",
    'db_edit__invalid_db_name' => "Databasens namn är ogiltigt.",
    'db_edit__no_users' => "Det finns inga användare med inloggningsuppgifter för denna databas.",
    'db_edit__unable_define_db_usrs' => "Kan inte definiera databasanvändarna: %1",
    'db_edit__unable_select_db_usr' => "Kan inte markera databasanvändare.",
    'db_edit__db_user_password_for_' => "Skriv in lösenordet för att logga in som databasanvändare %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Lägg en databasanvändare",
    'db_usr_edit__db_usr_name' => "Databas användarnamn",
    'db_usr_edit__edit_db_usr' => "Ställ in autentiseringsuppgifter för databassens användarkonto",
    'db_usr_edit__for_db' => ": %1 databasen",
    'db_usr_edit__not_create_pass' => "Denna åtgärd leder till att ett användarkonto skapas i databasen utan lösenord.\nVill du skapa användare utan att tilldela ett lösenord?",
    'dbuser__only_one_user_can_be_default' => "Endast en användare kan ställas in som standard.",
    'db_server__cannot_delete_default' => "Standard databasservern kan inte raderas.",
    'db_server__cannot_delete_local' => "Den lokala databasen kan inte tas bort.",
    'db_server__cannot_delete_used' => 'En databasserver kan inte raderas när det finns databaser eller dataanvändare hostade på den.',
    'demo__disabled_in_demo' => "Denna åtgärd stöds inte i demo-versionen.",
    'defaultcomponents__title' => "Välja standardkomponenter",
    'defaultcomponents__select_default' => "Välj standard %1-komponent",//to check
    'defaultcomponents__not_installed' => "(inte installerad)",
    'defaultcomponents__not_configured' => "(inte konfigurerat)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Vissa tjänstekategorier innehåller ogiltiga markeringar eller inga markeringar har gjorts.",
    'defaultcomponents__depends_on' => "(kräver %1 )",
    'defaultcomponents__parameters' => "Parametrar för %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-server",
    'component_name__firewall' => "Brandvägg",
    'component_name__ftpserver' => "FTP server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "E-postserver",
    'component_name__local_mailserver' => "Lokal-e-postserver",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Skript för webben",
    'component_name__spamfilter' => "Skräppostfilter",
    'component_name__stats' => "Webbstatistik",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webbpost",
    'component_name__webpublish' => "Webbpublicering",
    'component_name__webserver' => "Webbserver",
    'dns__dns_record_invalid_values' => 'Felaktiga DNS-post värden har angetts: %1: %2',
    'dns__dns_zone_invalid_values' => 'Felaktiga DNS-zonsparametrar har angetts.',

    'dns__soa_mname_title' => 'Primär Namnserver',
    'dns__soa_mname_legend' => 'Namnserver',
    'dns__soa_mname_autoselect' => '(Automatiskt val)',

    'dns__dns_zone_default' => 'Zonstandardinställningar',
    'dns__dns_soa_legend' => 'SOA-post',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Uppdatera',
    'dns__dns_soa_retry' => 'Försök igen',
    'dns__dns_soa_expire' => 'Upphör att gälla',
    'dns__dns_soa_minimum' => 'Lägsta',
    'dns__dns_soa_ttl_error' => 'TTL-värdet är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns__dns_soa_refresh_error' => 'Uppdateringsvärdet är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns__dns_soa_retry_error' => 'Återförsöksvärdet är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns__dns_soa_expire_error' => 'Utgångsvärdet är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns__dns_soa_minimum_error' => 'Minsta värde är ogiltigt. Det kan vara från 1 sekund till 68 år.',
    'dns__dns_default_title' => 'Återställ DNS-zonen',
    'dns__dns_default_legend' => "Zonåterställningsalternativ",
    'dns__dns_default_text' => "Välj inställningar för DNS-zonåterställningen, bekräfta dem och klicka på OK.",
    'dns__dns_default_confirm' => "Bekräfta återställning av DNS-zonen",
    'dns__dns_default_confirm_required' => "Var god, bekräfta återställning av DNS-zonen",
    'dns__dns_default_invalid_ip_address' => 'Ogiltig IP-adress',

    'dns_t__dns_default_title' => 'Återställ standard DNS-zonmallen.',
    'dns_t__dns_default_legend' => "Återställningsalternativ",
    'dns_t__dns_default_text' => 'Bekräfta att du vill återställa standardkonfigurationen för DNS-zonmallen.',
    'dns_t__dns_default_confirm' => "Bekräfta återställning",
    'dns_t__dns_default_confirm_required' => "Bekräfta återställning av DNS-zonmallen",
    'dns_t__dns_zone_off_remove_title' => "Följande resursdata för DNS-zonmallen kommer att tas bort:",
    'dns_t__dns_zone_master_remove_title' => "Följande resursdata kommer att tas bort från DNS-zonmall:",
    'dns_t__add_dns_record_master_title' => 'Lägg till en ny resurspost till zonmallen',
    'dns_t__add_dns_record_off_title' => 'Lägg till namnserver',
    'dns_t__edit_dns_record_master_title' => 'Redigera resursposten',
    'dns_t__edit_dns_record_off_title' => 'Redigera namnserver',
    'dns_t__select_record_to_remove' => "Valda poster som ska tas bort från DNS-zonmallen",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Följande resursposter kommer att tas bort från zonen %1:",
    'dns__dns_zone_master_remove_title' => "Tar bort resursposter från DNS-zonen %1",
    'dns__dns_zone_slave_remove_title' => "Följande primära namnserverposter för %1 kommer att tas bort:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Ange en strängpost',
    'dns_add__is_spf_syntax' => 'SPF-post',
    'dns_add__spf_value_is_invalid' => "SPF-postens värde är fel, det måste börja med 'v=spf'",
    'dns__dns_zone_status' => "DNS-zonens status.",
    'dns__dns_zone_template' => 'DNS-inställningar',
    'dns__host' => "Värd",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "IP-adressen till den nya master-DNS-servern är ogiltig eller tom.",
    'dns__ip_address' => "IP-adress",
    'dns__master_dns_type' => "är en master-DNS-server",
    'dns__masters' => "DNS-masterservrar",
    'dns__soa_minimum_too_large' => 'Att cachelagra negativa svar i mer än tre timmar rekommenderas inte.',
    'dns__select_masters_to_remove' => "Välj primära DNS-servrar som ska tas bort.",
    'dns__select_template_record_to_remove' => 'Markera DNS-mallposter att ta bort.',
    'dns__select_record_to_remove' => 'Välj DNS-poster som ska tas bort.',
    'dns__nameservers_for_domain' => "Namnservrar för domänen",
    'dns__ns' => "Namnserver",
    'dns__ns_record' => "Namn servrar",
    'dns__remove_dns_zone_of_domain__' => "DNS-postborttagande från domän %1",
    'dns__remove_dns_zone_template__' => "Följande DNS-poster kommer att tas bort från mallen:",
    'dns__remove_this_dns_record?' => "Är du säker på att du vill ta bort DNS-posten?",
    'dns__restore_default' => "Återställning av DNS-zonen via mallen.",
    'dns__restore_default_confirm' => "Återställning av DNS-zonen kommer att rensa den aktuella DNS-zonkonfigurationen. Fortsätt ändå?",
    'dns__restore_default_error' => "Fel vid återställning av DNS-zon:",
    'dns__slave_dns_type' => "är en sekundär DNS-server",
    'dns__soa_refresh_value_is_small' => 'Uppdateringsintervallet är mindre än en timme, vilket kan kritiskt öka servertrafiken och resursanvändningen. Fortsätt att använda detta värde?',
    'dns__subdomain_dns_rec_removed' => "A-posten har tagits bort från subdomänzonen %1.",
    'dns__zone_switched_off_no_ns' => "Zonen kan inte slås på eftersom det inte finns någon NS-post %1, vilket måste finnas i zonen.  För att lägga till posten till zonen, klicka på Lägg till post-knappen.",
    'dns__cant_switch_on_no_ns' => "Zonen kan inte slås på eftersom det inte finns någon NS-post %1, vilket måste finnas i zonen. För att lägga till posten till zonen, klicka på Lägg till post-knappen.",
    'dns__type' => "Inlägg typ",
    'dns__unable_activate/deactivate_dns' => "Kan inte aktivera/inaktivera DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Kan inte lägga till DNS-masterserver: Dubblettpost.",
    'dns__unable_add_dns_master_local_ip' => "Det gick inte att lägga till IP-adressen (%1) för master-DNS-server: denna post ska skapas på en fjärrserver.",
    'dns__unable_define_dns_record' => "Kan inte definiera DNS-posten: %1",
    'dns__unable_get_dns_template_status' => "Kan inte hämta DNS-mallstatusen.",
    'dns__unable_remove_dns_rec' => "Kan inte ta bort DNS-posten: %1",
    'dns__val' => "Värde",
    'dns__warnings__' => "Resultatet av DNS-zonmodifiering:",
    'dns__you_not_have_perm_manage_dns' => "Du har inte behörighet att hantera DNS-zonen för denna domän.",
    'dns__zone_record' => "DNS-poster",
    'dns__cant_create_record_with_server_ip' => "Kan inte lägga till denna IP-adress eftersom den matchar IP-adressen för denna Plesk-hanterade servern.",

    'dns__tabs_acl' => "Zonöverföringar",
    'dns__acl_add_network_legend' => "Lägg till nätverk",
    'dns__acl_add_ip_legend' => "Lägg till IP-adress",
    'dns__acl_network_not_allowed' => "Denna nätverksadress tillåts inte av DNS i Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP-adress/mask",
    'dns__acl_enter_ip_address' => "IP-adress",
    'dns__acl_list_network_legend' => "Nätverk tillåtna att få en kopia av DNS-zon",
    'dns__acl_list_ip_legend' => "IP-adresser tillåtna att få en kopia av DNS-zon",
    'bt_dns_acl_add_network' => "Lägg till nätverk",
    'bt_dns_acl_add_ip' => "Lägg till IP-adress",

    'dns_add__add_rec_for_zone' => "Lägg till %1 för zon %2",
    'dns_add__canonical_dom_name_is_invalid' => "Det kanoniska domännamnet är ogiltigt.",
    'dns_add__enter_canonical_name' => "Canonical namn",
    'dns_add__enter_dom_name' => "Domännamn",
    'dns_add__enter_ip_address' => "IP-adress",
    'dns_add__enter_ip_mask' => "IP-adress och nätverksmask",
    'dns_add__enter_mail_domain' => "E-postdomän",
    'dns_add__enter_mail_exchanger' => "E-postutväxlingsserver",
    'dns_add__enter_nameserver' => "Namnserver",
    'dns_add__enter_txt_record' => "TXT-post",
    'dns_add__enter_service_name' => "Tjänstnamn",
    'dns_add__hint_service_name' => "Exempel: SIP",
    'dns_add__enter_protocol' => "Protokoll",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritet",
    'dns_add__specify_weight_of_service' => "Relativ vikt för poster med samma prioritet",
    'dns_add__enter_target_host' => "Målvärddator",
    'dns_add__hint_target_host' => "Exempel: exemple.com",
    'dns_add__enter_target_port' => "Målport",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Värde",

    'dns_add__invalid_ip' => "IP-adress är ogiltig.",
    'dns_add__low' => "låg",
    'dns_add__mail_dom_name_is_invalid' => "E-postens domännamn är ogiltigt.",
    'dns_add__nameserver_is_invalid' => "Namnserver är ogiltig.",
    'dns_add__record' => "%1 post",
    'dns_add__select_prefer_for_mail_exchange_server' => "Specificera prioritet för e-postutväxlingsservern",
    'dns_add__unable_insert_new_dns_rec' => "Det gick inte att infoga ny DNS-post: %1",
    'dns_add__very_high' => "Mycket hög",
    'dns_check__test_dns_zone' => "Testa DNS-zon %1 på %2",
    'dns_check__unable_get_dom_properties' => "Det gick inte att hämta domänegenskaper: %1",
    'dom_ctrl__allowed' => "Tillåten",
    'dom_ctrl__db' => "MySQL-databaVisar",
    'dom_ctrl__mssql_db' => "MS SQL-databaser",
    'dom_ctrl__disk_space' => "Utrymme",
    'dom_ctrl__dom_adm' => "Domän %1 av %2",
    'dom_ctrl__dom_cl' => "Domän: %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domän har vidarebefordring konfigurerat med odefinierad vidarebefordrings-URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Domän har frame-vidarebefordran till URL:en %1",
    'dom_ctrl__domain_has_no_hosting' => "Domänen har ingen värdtjänst konfigurerad",
    'dom_ctrl__domain_has_physical_hosting' => "Webbvärdtjänsten konfigureras för denna domän på IP-adress %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domän har standard-vidarebefordran till URL:en %1",
    'dom_ctrl__maillists' => "E-postlistor",
    'dom_ctrl__mboxes' => "E-postlådor",
    'dom_ctrl__mg' => "Vidarebefordran av e-post",
    'dom_ctrl__resource_name' => "Resurs",
    'dom_ctrl__resp' => "Autosvar",
    'dom_ctrl__subdom' => "Subdomäner",
    'dom_ctrl__dom_aliases' => "Domänalias",
    'dom_ctrl__traffic' => "Trafik",
    'dom_ctrl__unable_activate/deactivate_dom' => "Kan inte aktivera/inaktivera domän: %1",
    'dom_ctrl__used' => "Används",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webbanvändare",
    'dom_pref__bounce_with_phrase' => "Returnera med meddelande",
    'dom_pref__bounce' => "Studsa",
    'dom_pref__catch_addr' => "Vidarebefordra till adressen",
    'dom_pref__reject' => 'Avvisa',
    'dom_pref__confirm_domain_removing' => "Glöm inte att informera domänbesökare om domännamnsförändringen. Är du säker på att du vill byta namn på domänen?",
    'dom_pref__db_inconsystency' => "databasinkonsekvens.",
    'dom_pref__dbs' => "databaser",
    'dom_pref__delete_traffic_stat' => "Behåll webb- och trafikstatistik",
    'dom_pref__delete_traffic_stat_older' => "Behåll webb- och trafikstatistik",
    'dom_pref__dom_level_name_conflict' => "Domänadministratörens användarnamn är i konflikt med ett användarnamn för en av kunderna.",
    'dom_pref__invalid_disk_space_limit' => "Ogiltig diskutrymmesgräns. Maxvärde: %1",
    'dom_pref__invalid_expiration_date_limit' => "Ogiltig giltighetsperiod.",
    'dom_pref__invalid_max_traffic_limit' => "Ogiltig trafikgräns. Maxvärde: %1",
    'dom_pref__limits_of_dom' => "Gränser för domän %1",
    'dom_pref__mail_grps' => "e-postgrupper",
    'dom_pref__mail_nonexistent_user' => "Vad gör man med e-post som skickas till obefintliga användare",
    'dom_pref__mail_redirs' => "e-postsändare",
    'dom_pref__mail_resps' => "automatsvar för e-post",
    'dom_pref__max_limit_is_invalid' => "%1 är ogiltig.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maximalt antal för %1 är ogiltigt.",
    'dom_pref__new_limit_less_currently_used' => "%1: begärt - %2, för närvarande använt - %3",
    'dom_pref__older_that' => "för",
    'dom_pref__postboxes' => "E-postkonton",
    'dom_pref__preferences_of_dom' => "Inställningar för domän %1",
    'dom_pref__redirect_to_itself' => "Domänen kommer att ha vidarebefordringen inställd till sig själv",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Du har angett lagringstiden för domäntrafikstatistik till mindre än det totala värdet som är definierat för servern (%1 månad(er)). Statistiklagringstiden är angiven till samma som standardvärdet för servern (%1 månad(er).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Kan inte lägga till ett www-prefix till domän: %1",
    'dom_pref__unable_define_physical_hst_param' => "Kan inte definiera fysiska värdtjänstparametrar: %1",
    'dom_pref__unable_rename_domain' => "Kan inte byta namn på domänen",
    'dom_pref__unable_set_up_mbox_quota' => "Kan inte ställa in e-postkvot för denna domän: %1",
    'dom_pref__unable_set_up_web_user_script' => "Kan inte konfigurera scripting för webbanvändare: %1",
    'dom_pref__unlimited' => "Obegränsat",
    'dom_pref__web_usrs' => "webbanvändare",
    'dom_pref__you_already_have_%object' => "Du har redan %1",
    'dom_cli__warning_ignore_quota' => 'VARNING!: Alternativet "-hard_quota" ignoreras: hårddiskkvot stöds inte',
    'dom_user_client_login_exist' => "Kan inte ge domänadministratörens åtkomst till Plesk i domänen %1: detta användarnamn används redan.",
    'domain__unable_to_turn_on_service' => "Kunde inte växla till tjänsten %1.",
    'domains__change_the_status_of_domain?' => "Är du säker på att du vill ändra tidsstämpeln för den valda domänen %1?",
    'domains__client_info_hiding_traffic' => "%1 domäner, %2 aktiva domäner, %3 använt diskutrymme",
    'domains__unable_to_change_client_status' => "Kan inte ändra kundens kontostatus: %1",
    'domains__unable_update_apache_settings' => "Kan inte uppdatera Apache-inställningarna.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Du har inte behörighet att radera domäner.",
    'domains__you_want_change_the_status_of_the_cl??' => "Är du säker på att du vill ändra status för kundkontot?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Vill du verkligen utföra denna åtgärd?",
    'domains_list__unable_remove_doms' => "Kan inte ta bort domäner: %1",
    'domaintrafficlist_header_of_domain__' => "Trafik på domän %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Välj domänalias som ska tas bort.',
    'domain_aliases_remove__title' => 'Ta bort domänalias',
    'domain_aliases__max_aliases_reached_for_dom' => "Gränsen för antalet alias har nåtts för denna domän.",
    'domain_edit__edit_title' => 'Redigera domänaliasnamn',
    'domain_alias_edit__type' => 'Domänens aliastyp',
    'domain_aliases__list_header' => 'Domänalias',
    'domain_aliases__name' => 'Namn',
    'domain_aliases__type' => 'Typ',
    'domain_aliases__type_full' => 'Webb+FTP+e-post',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domänalias',
    'domain_aliases__legend' => 'Domänalias',
    'domain_alias__domain_exists' => 'Domän med ett sådant namn finns redan',
    'domain_alias__subdomain_exists' => 'Underdomän med ett sådant namn finns redan',
    'domain_alias__dns_record_exists' => 'DNS-post med angett domänaliasnamn finns redan',
    'domain_alias__domain_alias_exists' => "Domänalias med ett sådant namn finns redan.",
    'domain_alias__invalid_type_full' => 'E-postservern stödjer inte domänens aliaser',
    'domain_alias__redirect_exists' => 'Omdirigering till sig själv upptäcktes.',

    'ds__anonymous_ftp' => "Anonym FTP",
    'drweb__pagetitle' => 'Antivirusinställningar',
    'drweb__drweb' => 'Antivirus e-postkontroll',
    'drweb__drweb_direction' => 'Kontrollera om det finns virus i e-posten',
    'drweb__drweb_direction_off' => 'Sök inte efter virus',
    'drweb__drweb_direction_any' => 'Inkommande och utgåend e-post.',
    'drweb__drweb_direction_from' => 'Endast utgående e-post',
    'drweb__drweb_direction_to' => 'Endast inkommande e-post',
    'drweb__disable_reason_key' => 'Antivirus stöds inte av licensnyckeln.',
    'drweb__disable_reason_perm' => 'Du har inte tillstånd att hantera antivirus.',
    'drweb__disable_reason_install' => 'Antivirus är inte installerat.',
    'drweb__filters' => 'Antivirus-filter',
    'ds__dns' => "DNS-zon",
    'ds__mail' => "E-post",
    'dsr__of_client_title' => "Domänsammanfattningsrapport för %1",
    'dsr__report_has_been_sent_email' => "Rapporten skickades till e-posten: %1",
    'dsr__title' => "Domänsammanfattningsrapport",
    'dumps_list__deletion_page_title' => "Följande säkerhetskopiefiler för domänen %1 kommer att tas bort:",
    'dumps_list__dumpfile_is_invalid' => "Filen %1 är inte en giltig domänsäkerhetskopierad fil.",
    'dumps_list__page_title' => "Lagring för säkerhetskopierade filer",
    'dumps_upload__page_title' => "Ladda upp säkerhetskopierade filer till lagringen",
    'dumps_list__repository_is_not_exist' => "Lagringen för säkerhetskopierade filer finns inte.",
    'dumps_list__unable_to_remove' => "Kan inte ta bort den säkerhetskopierade filen: %1.",
    'dumps_list__dumpfile_can_conflict' => "Filnamnet du angett står i konflikt med filen %1. Ange ett annat filnamn.",
    'dusr_ed__allow_dl_usr_access' => "Tillåt domänadministratörens åtkomst",
    'dusr_ed__information' => "Egenskaper för domänen %1s administratör",
    'dusr_ed__locale' => "Domänadministratörens språk",
    'dusr_ed__skin' => "Domänadministratörs gränssnittsskal",
    'dusr_ed__personal_information' => 'Personlig information',
    'ess__error' => "Fel",
    'example__' => "Exempelvärde: %1",
    'extras__allow_certificate_purchasing' => "Tillåt certifikatköp",
    'extras__allow_domain_registration' => "Tillåt domänregistrering",
    'extras__allow_extras' => "Tillåt extratjänster",
    'extras__buy_new_key' => "Din aktuella licens tillåter inte att du modifierar dessa objekt.",
    'extras__setup_services' => "Ställ in extratjänster",

    'firewallmainform__title' => 'Brandväggshantering',
    'firewallmainform__interfaces_list_legend' => 'Nätverksgränssnittslista',
    'firewall__interfacelist' => 'Nätverksgränssnitt',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'Gränssnittsnamn',
    'interfacelist__type' => 'Gränssnittstyp',
    'bt_rule_add' => 'Lägg till brandväggsregel',
    'bt_panic' => 'Panikläge',
    'firewallmainform__rules_list_legend' => 'Regellista',
    'firewall__rulelist' => 'Regler',
    'rulelist__enable' => 'S',
    'rulelist__name' => 'Namn',
    'rulelist__allow_input_from_any_port_profiles' => '[Tillåt] inkommande anslutningar från [alla] på port [%1], profiler: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Tillåt] inkommande anslutningar från  [%1] på port [%2], profiler: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Tillåt] inkommande anslutningar från [alla] på port [%1], profiler: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Tillåt] inkommande anslutningar från [%1] på port [%2], profiler: [%3]',
    'rulelist__description' => 'Beskrivning',
    'ruleeditform__add_title' => 'Lägger till ny regel',
    'ruleeditform__properties' => 'Regelegenskaperna',
    'ruleeditform__name' => 'Regelnamnet',
    'ruleeditform__port' => 'Tillåt anslutningar till följande port eller portintervall',
    'ruleeditform__protocol_tcp' => 'TCP-protokoll',
    'ruleeditform__protocol_udp' => 'UDP-protokoll',
    'ruleeditform__edit_title' => 'Redigera brandväggsregeln',
    'ruleeditform__newrule' => 'Ny regel',
    'ruleeditform__enabled' => 'Slå på regeln',
    'ruleeditform__profiles_text' => 'Profiler',
    'ruleeditform__profiles_domain_text' => 'Domän',
    'ruleeditform__profiles_private_text' => 'Privat',
    'ruleeditform__profiles_public_text' => 'Publik',
    'ruleeditform__action' => 'Action',
    'ruleeditform__action_allow' => 'Tillåt',
    'ruleeditform__action_deny' => 'Förneka',
    'ruleeditform__from' => 'Fjärradresser',
    'ruleeditform__from_add' => 'Lägg till IP-adress eller nät:',
    'ruleeditform__profiles_hint' => 'Du måste välja minst en profil.',
    'ruleeditform__port_hint' => 'Till exempel: 1000 eller 1000-1051',
    'ruleeditform__from_hint' => 'Till exempel: 192.168.0.1 eller 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Alla',
    'firewall_from_add' => 'Lägg till',
    'firewall_from_remove' => 'Ta bort',
    'firewall_from_clear' => 'Rensa lista',
    'bt_firewall_from_add' => 'Lägg till',
    'bt_firewall_from_remove' => 'Ta bort',
    'bt_firewall_from_clear' => 'Rensa lista',
    'ruleeditform__name_is_required' => 'Specificera regelnamnet.',
    'ruleeditform__profiles_is_required' => 'Välj minst en profil.',
    'ruleeditform__invalid_action' => 'Den angivna åtgärden är ogiltig. Möjliga värden är "Tillåt " eller "Neka".',
    'ruleeditform__invalid_ip' => 'Den angivna P-adress eller nätverk är ogiltig.',
    'ruleeditform__invalid_protocol' => 'Det angivna protokollet är ogiltigt. Möjliga värden är "udp" eller "tcp".',
    'ruleeditform__invalid_port' => 'Den specificerade porten är ogiltig. Möjliga värden är 1000 eller 1000-1051',
    'firewall__panic_configuration' => 'Är du säker att du vill slå på panikläge? Användare kommer inte att kunna komma åt sina domäner.',
    'firewall__reset_configuration' => 'Är du säker att du vill återställa brandväggsinställningarna till standardläget?',
    'rulelist__remove_selected' => 'Vill du verkligen ta bort markerade regler?',

    'filemanager__items' => 'poster i katalogen %1',
    'filemanager__items_paging' => 'poster i katalogen %1',

    'get_password__encrypted_password' => "Kan inte sända lösenordsinformationen: lösenordet är lagrat i krypterad form.",
    'get_password__mail_error' => "Ett fel inträffade under försöket att skicka lösenordet till e-postadressen %1: %2",
    'get_password__mail_ok' => "Lösenordet skickades korrekt till e-posten: %1",
    'get_password__message' => "Ditt användarnamn för åtkomst till systemet: %1\nDitt lösenord är %2",
    'get_password__subject' => "Lösenord för åtkomst till systemet",
    'groups__available' => "Tillgängliga e-postgrupper",
    'groups__groups_for_mailname' => "E-postgrupper som e-postkontot %1 abonnerar på",
    'groups__member_of' => "Medlemmar av följande e-postgrupper",
    'help__help_area' => "Hjälpområde.",
    'hst_def__auth_disabled' => "förbjuden",
    'hst_def__auth_enabled' => "tillåten",
    'hst_def__change_curr_dns_ip' => "Aktuell IP-adress för A DNS-posten kommer att ändras",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Inga av IP-adresserna för A DNS-posten matchar med IP-adressen som tilldelats värdtjänstkontot som nyss skapats",
    'hst_def__dest_url' => "Destinationsadress",
    'hst_def__disk_quota' => "Diskkvot",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Diskutrymmesgränsen du försöker ställa in överskrids av diskutrymmesgränsen i den ingående anonym-FTP-katalogen. Diskutrymmesgränsen i den ingående anonym-FTP-katalogen får inte överstiga domänens diskutrymmesgräns.",
    'hst_def__frame_forwarding_definition' => "Frame-vidarebefordransuppdrag för domän %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Varning: FTP-användare %1 används i värdtjänst-kontoinställningarna men den finns inte i systemet.",
    'hst_def__hst_type_is_not_defined' => "Värdtjänsttypen är inte definierad.",
    'hst_def__ip_based' => "IP-baserade",
    'hst_def__name_based_power_anonymous_ftp_down' => "Överföringen av detta värdtjänstkonto till delad IP-adress gör att den anonyma FTP-tjänsten blir otillgänglig på denna domän. Fortsätt ändå?",
    'hst_def__password_is_invalid_password_syntax' => "Lösenordet är ogiltigt.\nAnvänd inte enkla citationstecken och nationella alfabetstecken i lösenordet.\nLösenordets längd ska vara mellan 5 och 14 tecken. Lösenordet ska inte innehålla användarnamnet.",
    'hst_def__shell' => "SSH-åtkomsten till serverskalet under abonnemangets systemanvändare",
    'hst_def__shell_windows' => "Fjärråtkomsten till servern under abonnemangets systemanvändare",
    'hst_def__standard_forwarding_definition' => "Standardvidarebefordran-uppdrag för domän %1",
    'hst_def__title_name_based' => "Namnbaserat",
    'hst_def__unable_create/update_physic_hst' => "Kan inte skapa/uppdatera den fysiska värdtjänsten: %1",
    'hst_def__unable_create/update_std_fwd' => "Kan inte skapa/uppdatera standardvidarebefordran: %1",
    'hst_def__unable_create_forwarding_myself' => "Kan inte skapa vidarebefordran till domänen självt.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Kan inte tillåta användning av en enskild katalog för att lagra SSL/TLS- och icke-SSL/TLS-innehåll: SSL/TLS-stöd är inte påslaget.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Kan inte slå på SSL/TLS-stöd: Inget SSL/TLS-certifikat installerat.",
    'hst_def__url_is_invalid' => "Webbadressen är ogiltig.",
    'hst_def__virtual_host_access' => "Virtuell värddator för åtkomst till domän %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "VARNING. Denna virtuella värddator använder en obefintlig IP-adress för värdtjänsten.",
    'hst_def__you_have_no_ips' => "Du har inga IP-adresser tillgängliga och du får inte skapa namnbaserada värdtjänster.",
    'hst_sel__header' => "För att få en webbplats värdbaserad på denna server, välj den fysiska värdtjänsten.\n För att ställa in domän-vidarebefordran till en site på en annan maskin, välj alternativen Frame- eller Standard-vidarebefordran.\nMed standard-vidarebefordran, omdirigeras en användare till denna site och den faktiska sitens URL visas i användarens webbläsare, så att användaren vet om omdirigeringen. Med frame-vidarebefordran, omdirigeras en användare till siten utan att märka att siten faktiskt ligger på en annan plats.",
    'hst_sel__physical_hst' => "Fysisk hosting",
    'hst_sel__select_hst_type' => "Markera typ av värdtjänst för domänen",
    'hst_sel__select_hst_type_warning' => "Markera typ av värdtjänst för domänen",
    'hst_sel__hosting_exists' => "Kan inte skapa värdtjänst, eftersom den redan är konfigurerad för denna domän. Du kommer att omdirigeras till värdtjänstens hanteringssida.",
    'hst_sel__standard_frw' => "Standard vidarebefordran",
    'hst_sel__frame_frw' => "Frame vidarebefordran",
    '__frame_frw' => "Frame vidarebefordran",
    '__hosting_exists' => "Kan inte skapa värdtjänst, eftersom den redan är konfigurerad för denna domän. Du kommer att omdirigeras till värdtjänstens hanteringssida.",
    '__choose_hst_type' => "Markera den önskade värdtjänsttypen.",
    '__no_hst_conf' => "Det finns ingen värdtjänst konfigurerad för din domän.",
    '__physical_hst' => "Fysisk hosting",
    '__select_hst_type' => "Markera typ av värdtjänst för domänen",
    '__standard_frw' => "Standard vidarebefordran",
    '__warning' => "Varning! Alla de tidigare angivna parametrarna kommer att ignoreras. Vill du verkligen ändra markerad värdtjänsttyp?",
    'i_cl_off' => "Kunden är inaktiv.",
    'i_cl_off_by_admin' => "Kundkontot har tillfälligt upphävts av serveradministratören.",
    'i_cl_off_expired' => "Kundkontot har löpt ut.",
    'i_cl_on' => "Kunden är aktiv.",

    'icf__title' => 'Inställningar för brandväggen',
    'icf__if_legend' => 'Gränssnitt',
    'icf__mode' => 'Läge',

    'invalid_value' => 'Värdet är ogiltigt',

    'ip_addr__already_exists' => "IP-adressen %1 finns redan.",
    'ip_addr__cant_add' => "IP %1 finns inte eller tillhör en IP-pool för en annan kund",
    'ip_addr__cl_list_for_ip' => "Återförsäljare som använder %1 IP-adress %2",
    'ip_addr__cl_list_for_ip_add' => "Lägg till en IP-adress till återförsäljarens pool",
    'ip_addr__domains_list_for_ip' => "Webbplatser som använder %1 IP-adress %2",
    'ip_addr__ip_used_by_hst_or_frw' => "IP-adressen %1 används för värdtjänster eller vidarebefordran.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Kan inte ta bort denna IP-adress eftersom det finns domäner som hostas på denna IP-adress.",
    'ip_addr__remove_ip_addr' => "Följande IP-adresser kommer att tas bort från systemet:",
    'ip_addr__select_clients' => "Markera kunder",
    'ip_addr__select_ip_addr_to_remove' => "Välj IP-adresser att ta bort.",
    'ip_addr__unallowed_by_license' => "Detta exemplar av Plesk är inte licensierat för att användas på IP-adress %1.\nTillåtna IP-intervall är: %2.",
    'ip_alias__interface' => "Gränssnitt",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-adress för en namnbaserad virtuell värdtjänst är ogiltig.",
    'ip_alias__invalid_ip_or_netmask' => "Ogiltig IP-adress/nätmaskpar.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-adressen %1 är originalserverns IP, så du kan inte ta bort den.",
    'ip_alias__ip_is_invalid' => "%1 IP-adressen är ogiltig.",
    'ip_alias__ip_mask_is_invalid' => "IP-mask %1 är ogiltig.",
    'ip_alias__ip_not_exist' => "IP-adressen %1 finns inte.",
    'ip_alias__ip_address_and_mask' => 'IP-adress och nätmask',
    'ip_alias__mask' => "Subnätmask",
    'ip_alias__remove_selected_ip_aliases?' => "Är du säker på att du vill ta bort angivna IP-adresser?",
    'ip_alias__select_ip' => "Markera minst en IP-adress i listan för att ta bort den.",
    'ip_alias__this_ip_used_for_domain' => "(%1) denna IP-adress används för domän %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) denna IP-adress används till en namnbaserad virtuell värdtjänst.",
    'ip_alias__unable_add_ip' => "Det gick inte att lägga till IP: %1",
    'ip_alias__unable_remove_ip' => "Kan inte ta bort IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Du kan inte ändra IP-adresstypen till delad, då det kommer att göra anonym FTP för domänen '%1' otillgänglig.",
    'ip_ctrl__ip_addr' => "IP-adress %2 på gränssnitt %1",
    'ip_ctrl__ip_exists_many_pools' => "Du kan inte ändra IP-typen. Denna IP-adress tillhör poolerna för flera användare samtidigt.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-certifikat",
    'ip_pool__ip_address_is_absend_in_pool' => "IP-adress saknas.",
    'ip_pool__ip_pool_for_client' => "IP-pool för kunden %1",
    'ip_pool__no_cliens_avail' => "Det finns inga kunder tillgängliga.",
    'ip_pool__no_vacant_ips' => "Det finns inga lediga IP.",
    'ip_pool__pool_is_empty' => "IP-poolen är tom.",
    'ip_pool__remove_ip_addr' => "Dessa IP-adresser kommer att tas bort ur pool %1:",
    'ip_pool__select_free_ips' => "Lediga IP",
    'limit__date_in_past' => "Giltighetsperioden är ogiltig. %1 har passerats.",
    'limit__enter_date' => "Ange datum",
    'limit__max_db' => "DatabaVisar",
    'limit__name_disk_space' => "diskutrymme",
    'limit__name_max_box' => "E-postkonton",
    'limit__name_max_db' => "MySQL-databaVisar",
    'limit__name_max_dom' => "domäner",
    'limit__name_max_maillists' => "E-postlistor",
    'limit__name_max_subdom' => "subdomäner",
    'limit__name_max_traffic' => "trafik",
    'limit__name_max_wu' => "webbanvändare",
    'limit__name_mbox_quota' => "e-postkvot",
    'limit__name_max_mn' => "E-postkonton",
    'limit__name_max_cl' => 'klienter',
    'limit__name_total_mboxes_quota' => "total kvot för e-postlådan",
    'limit__name_mysql_dbase_space' => "MySQL-databasutrymme",
    'limit__name_mssql_dbase_space' => "MSSQL-databasutrymme",
    'limit__name_expiration' => 'utgångsdatum',

    'locale_upload__title' => 'Lägg till språkversion',
    'locale_upload__file_name' => 'Sökväg till språkpaketfilens läge',
    'locale_upload__unable_to_install' => 'Kan inte installera språkpaketfilen',
    'locale_upload__wrong_package' => 'Filen du laddade upp innehåller inte ett giltigt språkpaket för denna Plesk-version.',
    'locale_upload__wrong_locale' => 'Filen du laddade upp innehåller inte ett giltigt språkpaket.',

    'locales_remove__title' => 'Borttagande av språkversioner',
    'locales_remove__select_locales_for_remove' => 'Markera de locales som ska tas bort.',
    'locales__can_not_remove' => 'Kan inte ta bort språkpaket för språkversion %1: %2',

    'ma__create_title' => 'Skapa e-postalias för %1',
    'ma__edit_title' => "Redigera e-postalias %1",
    'ma__enter_new_alias' => "Ange ny alias",
    'ma__invalid_alias' => "Ogiltig e-postalias",
    'ma__mail_aliases_mailname' => "E-postaliaser för e-postkonto %1",
    'ma__mailname_does_not_exist' => "E-postkontot finns inte.",
    'ma__select_ma_for_remove' => "Markera e-postalias som ska tas bort.",
    'ma__unable_to_add_new_ma' => "Kan inte lägga till e-postalias: %1",

    'mail__white_list' => "White List",
    'mail__white_list_add' => 'Lägg till nätverk',
    'mail__white_list_remove' => 'Följande nätverk kommer att tas bort:',
    'mail__white_list_remove_warning_webmail' => 'Att ta bort följande nätverk kan göra det omöjligt att skicka e-post från webbmail: %1',
    'mail__white_list_member' => 'Tillåtna nätverk',
    'mail__white_list_empty_selection_for_remove' => 'Markera entiteterna som ska tas bort.',
    'mail_queue__not_allowed_by_license_key' => 'E-postköhantering tillåts inte av licensnyckeln.',
    'maillist__' => "E-postlista %1",
    'maillist__already_exists' => "E-postlista finns redan.",
    'maillist__mail_alias_already_exists_in_this_domain' => "E-postalias %1 finns redan i denna domän.",
    'maillists__' => "E-postlistor %1",
    'maillists__limit_cl_max_maillists' => "Gränsen för antalet e-postlistor har nåtts för kunden (gräns: %1, använt: %2)",
    'maillists__limit_dom_max_maillists' => "Gränsen för antal e-postlistor har nåtts för domänen.",
    'maillists__list' => "E-postlistor",
    'maillists__mailman_not_installed_or_conf' => "Mailman-servertillägg är för närvarande inte installerade eller konfigurerade\npå servern. Kontakta serveradministratören för att få Mailman-servertillägg installerade eller ordentligt konfigurerade.",
    'maillists__status' => "E-postlistans tjänst är påsatt",
    'maillists__unable_to_delete__' => "Det går inte att ta bort e-postlistan: %1",
    'maillists__disabled_text' => 'Du kan inte hantera e-postlistor eftersom Mailmans serverkomponent e-postlistor inte är installerad eller konfigurerat.',
    'maillist_member__already_exists' => 'E-postlisteabonnent finns redan.',
    'maillist_member__not_exists' => 'En sådan användare finns inte på e-postlistan.',
    'mailserver_switching_warning' => "Varning!\n\nÄndring av e-postservern är avedd endast för den inledande inställningen och, om servern redan används, leder den till följande problem: förlust av inställningar och e-postlådornas innehåll och, i fall när servern du byter till redan har konfigurerats, olika konflikter.\nOm denna server används nu och du är säker på att byta till en annan, kan du meddela dina kunder om åtgärden så att de kan ladda ner och spara e-posten.",
    'manager__access_denied' => "Åtkomst nekad: %1",
    'manager__admin' => "Administratör",
    'manager__client' => 'Kund',
    'manager__domain' => "Domän",
    'manager__domain_cl_limit_exceeding' => "Gränsen för antalet domäner nås för detta kundkonto.",
    'manager__domain_is_not_yours' => "Domänen %1 tillhör inte dig.",
    'manager__domain_key_limit_exceeding' => "Gränsen för domänskapande som definieras av din licensnyckel är nådd.",
    'manager__no_perm_to_call' => "Du saknar behörighet att ringa %1.",
    'manager__no_perm_to_create_domains' => "Du saknar behörighet att skapa domäner.",
    'manager__no_perm_to_modify_domain' => "Du saknar behörighet att modifiera domänen %1.",
    'manager__no_perm_to_modify_domains' => "Du saknar behörighet att modifiera domäner.",
    'manager__no_perm_to_remove_domain' => "Du saknar behörighet att ta bort domänen %1.",
    'manager__no_perm_to_remove_domains' => "Du saknar behörighet att ta bort domäner.",
    'manager__node_doesnt_exist' => "%1 finns inte.",
    'manager__user_disabled' => "Ditt kontot upphävs tillfälligt. Du kan inte använda systemet.",
    'mail_quota_unsupported' => "stöds inte av e-postservern",
    'mbox_quota_unsupported' => "stöds inte av e-postservern",
    'mn__create_title' => "Skapa e-postkonto",
    'mn__edit_title' => "Inställningar",
    'mn__files_list_title' => "Bifogade filer",
    'mn__files_remove' => "Ta bort filer från bilagskatalogen. Dessa filer används eventuellt av autosvar. De kommer att tas bort både från katalogen och autosvaren som använder dem.",
    'mn__files_select_for_remove' => "Välj filer att ta bort.",
    'mn__mail_alias_form' => "E-postens aliasform",
    'mn__mail_aliases_list' => "E-postaliaser",
    'mn__mailbox' => "E-postkontohantering",
    'mn__unable_define_mn' => "Kan inte ställa in e-postkonton: %1",
    'mn__unable_remove_mbox_quota' => "Kan inte ta bort e-postkvot: %1",
    'mn__upload_file' => "Ladda upp fil",
    'mn_edit__attach_filename_changed' => 'Den överförda filen %1 har döpts om till %2 eftersom dess namn innehöll icke-ASCII-tecken.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Du ska lägga till en e-postgruppmedlem innan du aktiverar e-postgruppen.",
    'mn_edit__add_resp_or_turn_off_box' => "Du måste lägga till autosvar eller rensa autosvar-kryssrutan.",
    'mn_edit__attachments' => "Bilagor",
    'mn_edit__dom_quota_less_then_quota' => "Storlek på detta e-postkonto får inte överstiga gränsen för mängden tilldelat diskutrymme för e-postkonton på denna domän.",
    'mn_edit__enter_external_rcpnt_email' => "Ange den externa e-postgruppmedlemmens e-post",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Skriv en adress för vidarebefordran av e-post eller avmarkera kryssrutan.",
    'mn_edit__ext_rcpnt_email_invalid' => "Externa mottagarens e-postadressen är ogiltig.",
    'mn_edit__file_exists' => "Filen finns. Skriva över?",
    'mn_edit__files_deld_from_repository' => "Dessa filer kommer att raderas från katalogen och autosvaren som de innehåller. Vill du fortsätta?",
    'mn_edit__mail_name' => "E-postkonto",
    'mn_edit__mail_name_invalid' => "E-postkontonamnet är ogiltigt.",
    'mn_edit__mail_redir' => "E-postsändare",
    'mn_edit__mail_redir_add' => "Lägg till e-postgruppmedlem",
    'mn_edit__mail_resps' => "Automatsvar för e-post",
    'mn_edit__mailbox' => "E-postkonto",
    'mn_edit__enable_mailbox' => "E-postkonto",
    'mn_edit__mailgroup' => "E-postgrupp",
    'mn_edit__mailgroup_addresses' => "E-postgruppmedlemmar",
    'mn_edit__mailgroup_disabled' => "Tillgänglig endast om e-postkontot redan har tillagts.",
    'mn_edit__max_dom_quota' => "Standard för domänen (%1)",
    'mn_edit__mbox_quota_invalid' => "Inkorrekt storlek på postlådan angiven.",
    'mn_edit__new_resp_name' => "Nytt autosvarnamn",
    'mn_edit__no_autoresponders' => "Du bör välja minst ett autosvar innan du sätter på/stänger av autosvartjänsten.",
    'mn_edit__no_file_sel' => "Inga filer har valts.",
    'mn_edit__no_mail_addresses' => "Inga e-postadresser har specificerats eller valts.",
    'mn_edit__none' => "Ingen",
    'mn_edit__not_create_pass' => "Det skapar inte ett lösenord för detta konto.\nUtan lösenord, kommer användaren inte att kunna visa och skicka e-post.",
    'mn_edit__redir_email_invalid' => "Adressen för vidarebefordran är ogiltig.",
    'mn_edit__redirect_addr' => "Adress för vidarebefordran",
    'mn_edit__remove_autoresp?' => "Vill du verkligen ta bort autosvar?",
    'mn_edit__remove_rcpnts?' => "Vill du verkligen ta bort dessa mottagare?",
    'mn_edit__repository' => "Repository",
    'mn_edit__resps_attach' => "Bifogade filer till autosvar",
    'mn_edit__select_rcpnt_from_list' => "Markera minst en mottagare i listan för att ta bort den.",
    'mn_edit__select_registered_users' => "Välj registrerade användare",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Du har valt att ha ett e-postkonto, men har inte konfigurerat lösenordet för det.",
    'mn_edit__unable_act_deact_mail_group' => "Kan inte aktivera eller inaktivera e-postgruppen: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Kan inte aktivera eller inaktivera vidarebefordran av e-post: %1",
    'mn_edit__unable_act_deact_postbox' => "Kan inte aktivera eller inaktivera e-postkonto: %1",
    'mn_edit__unable_act_deact_resp' => "Kan inte aktivera eller inaktivera autosvar: %1",
    'mn_edit__unable_add_attach' => "Det gick inte att lägga till filen: %1",
    'mn_edit__unable_add_mail_group_member' => "Kan inte lägga till e-postgruppmedlem: %1",
    'mn_edit__unable_add_resp' => "Kan inte lägga till autosvar: %1",
    'mn_edit__unable_change_mail_name' => "Kan inte ändra e-postkontonamn: %1",
    'mn_edit__unable_deactivate_mail_group' => "Kan inte inaktivera e-postgruppen: %1",
    'mn_edit__unable_deactivate_resp' => "Kan inte inaktivera e-postens autosvar: %1",
    'mn_edit__unable_define_resp_id' => "Kan inte definiera autosvar-ID: %1",
    'mn_edit__unable_remove_attach' => "Kan inte ta bort den temporära filbilagan(-orna): %1",
    'mn_edit__unable_remove_autoresp' => "Kan inte ta bort autosvar: %1",
    'mn_edit__unable_remove_mail_group_member' => "Kan inte ta bort e-postgruppmedlem: %1",
    'mn_edit__wrong_way' => 'Meddelanden som är adresserade till %1 kommer inte att levereras eftersom detta e-postkonto inte har en postlåda eller postsändningen är aktiverad.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Brevlådan på adressen %1 har kopplats från. Meddelandena i brevlådan har inte tagits bort, men du kommer inte att kunna hämta dem genom IMAP- eller POP3-protokollet.',
    'mn_list__mail_names_for_domain' => "E-postkonton under domänen %1",
    'mn_list__sa_cannot_unable' => "Kan inte slå på skräppostfiltrering",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Kund',
    'mn_list__tab_title_domain' => 'Domän',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Namn",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Kan inte ta bort e-postkonton %1",
    'no_psa_mails_matched' => "Inga e-postkonton matchar mönstersträngen som angivits.",
    'module_upload__module_was_installed' => 'Den här modulen är redan installerad. Om du vill installera en nyare version av denna modul, avinstallera modulen genom Plesk och försök sedan installera den.',
    'module_upload__unable_to_install' => 'Kan inte installera modulpaketfilen',
    'module_upload__wrong_package' => 'Den överförda filen är inte ett modulpaket som stöds.',
    'module_upload__wrong_module' => 'Den uppladdade filen innehåller inte ett modulpaket.',

    'news_articles_title' => 'Plesk News',
    'notification_text__invalid_subject_length' => "Ogiltig längd på meddelandets ämne. Ska vara från 1 till 255 tecken.",
    'notification_text__invalid_text_length' => "Ogiltig meddelandetextlängd. Ska vara från 1 till 65533 tecken.",
    'notification_text__subject' => "Meddelandets ämne",
    'notification_text__text' => "Notistext",
    'notification_text__title' => "Redigera meddelande",
    'notification_text__unable_set_text' => "Kan inte modifiera meddelandetext:",

    'odbc__cant_add_dsn' => "Det gick inte att lägga till DSN %1: %2",
    'odbc__cant_build_connection_string' => "Det gick inte att ansluta med de parametrar som specificerats, försök igen med annorlunda parametrar. Verktyget har returnerat: %1",
    'odbc__cant_connect' => "Det gick inte att ansluta till datakällan med hjälp av de definierade inställningarna. Servern har returnerat: %1",
    'odbc__cant_delete_dsn' => "Det gick inte att radera DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Kan inte få information om drivers.",
    'odbc__cant_get_drivers' => "Det gick inte att hämta en lista över ODBC-driver: %1",
    'odbc__cant_get_list' => "Kan inte hämta en lista över befintliga DSN: %1",
    'odbc__cant_get_servers_list' => "Kan inte hämta en lista över servrar.",
    'odbc__cant_open_info_file' => "Det går inte att öppna filen med ODBC-drivrutinsinformation.",
    'odbc__cant_parse_string' => "Kan inte parsa anslutningssträngen.",
    'odbc__connect_success' => "Lyckad anslutning",
    'odbc__driver_not_set' => "Drivrutinen är inte inställd",
    'odbc__driver_or_name_not_set' => "Drivrutin eller namn på ODBC-anslutning har inte angetts",
    'odbc__dsn_already_exists' => "Det finns redan en DSN med namnet %1 i systemet.",
    'odbc__dsn_not_exists' => "Denna DSN finns inte",
    'odbc__enter_connection_params' => "Ställ in en ODBC-anslutning",
    'odbc__enter_dsn_name' => "Ange DSN-namnet",
    'odbc__invalid_dsn_name' => "Fel syntax för ODBC-anslutningsnamn (%1): använd endast alfanumeriska tecken.",
    'odbc__no_such_driver' => "En ODBC-drivrutin med sådant namn (%1) stöds inte.",
    'odbc__remove_page_title' => "Följande ODBC DSN-anslutningar kommer att tas bort",
    'odbc__select_dsn_to_remove' => "Markera DSN som ska tas bort.",
    'odbc__unknown_driver' => "Okänd drivernamn (%1).",
    'odbc_add_new' => "Lägg till DSN-anslutning",
    'odbc_driver' => "Drivrutin",
    'odbc_dsn_description' => "Anslutningsbeskrivning",
    'odbc_dsn_list' => "ODBC DSN-anslutningar",
    'odbc_dsn_name' => "Anslutningsnamn",
    'odbc_dsn_system' => "System-DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Lägg till en OBDC DSN',
    'odbc_req_field_not_set' => "Obligatoriska parametrar är ej angivna.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Databasfilens sökväg',
    'odbc__access_pagetimeout' => 'Tidsperioden, i tiondelar av en sekund, som en oanvänd sida förblir i bufferten. Detta alternativ gäller alla datakällor som använder Microsoft Access driver.',
    'odbc__access_maxbuffersize' => 'Storlek av intern buffert, i KB, inrymd inom gränsen 256 KB.',
    'odbc__access_readonly' => 'Klassar databasen som enbart läsbar, för att förhindra eventuella uppdateringar.',
    'odbc__access_exclusive' => 'Betecknar databasen som exklusiv för att förbjuda delade uppdateringar.',
    'odbc__access_safetransactions' => 'Om satt till 0 (standardinställningen), verkställs alla transaktioner omedelbart. Om satt till 1, sparas alla transaktioner till hårddisken endast vid en verkställande operation, men prestandan blir något försämrad.',
    'odbc__access_threads' => 'Antalet bakgrundstrådar som motorn ska använda.',
    'odbc__access_maxscanrows' => "Antalet rader att scanna när man ställer in en kolumns datatyp, baserat på befintliga data.",
    'odbc__access_implicitcommitsync' => 'Anger hur ändringar gjorda utanför en transaktion skrivs till databasen.',
    'odbc__access_usercommitsync' => 'Specificerar om MS Access-driver ska utföra uttalade användardefinierade transaktioner asynkront.',
    'odbc__mssql_server' => 'Server',
    'odbc__mssql_uid' => 'Inloggnings-ID',
    'odbc__mssql_pwd' => 'Lösenord',
    'odbc__mssql_database' => 'Standarddatabas för ODBC-datakällan',
    'odbc__mssql_app' => 'Programnamn',
    'odbc__mssql_wid' => 'Arbetsstations-ID',
    'odbc__mssql_language' => 'Förvalt nationellt språk att använda',
    'odbc__mssql_oemtoansi' => 'Omvandling av utökade tecken till OEM-värden',
    'odbc__mysql_server' => 'Värddatornamnet för MySQL-server',
    'odbc__mysql_database' => 'Standarddatabasen',
    'odbc__mysql_user' => 'Användarnamnet som används för att ansluta till MySQL',
    'odbc__mysql_password' => 'Lösenordet för användarkontot i servern',
    'odbc__mysql_port' => 'TCP/IP-porten som används om servern inte är den lokala värddatorn',
    'odbc__mysql_socket' => 'Windows namngivna rör för anslutning om servern är den lokala värddatorn',
    'odbc__mysql_option' => 'Alternativ som anger hur MyODBC ska fungera. Se <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'DB filsökväg',
    'odbc__excel_defaultdir' => 'Standard datumkatalog',
    'odbc__excel_fil' => 'Databasversion',
    'odbc__excel_maxbuffersize' => 'Maximal buffertstorlek',
    'odbc__excel_pagetimeout' => 'Timeout för sida',

    'pb__aliases' => "Alias",
    'pb__anonftp' => "Anonym FTP",
    'pb__autoinstaller_releases' => 'Uppdaterare',
    'pb__cert' => "Certifikat",
    'pb__cl_pool' => "IP-adresser",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Inställningar",
    'pb__cl_rpt' => "Rapport",
    'pb__cl_rpt_list' => "Anpassa",
    'pb__cl_templates' => "Kundmallar",
    'pb__cl_traffic' => "Trafik",
    'pb__cl_traffic_history' => "Trafikhistorik",
    'pb__cl_traffic_of' => "Trafik för %1",
    'pb__client' => "%1",
    'pb__clients' => "Kunder",
    'pb__comp_info' => "Serverkomponenter",
    'pb__common_acl' => 'Tillåt överföring ACL',
    'pb__cp_access' => "Åtkomst",
    'pb__crontab' => "Scheduler",
    'pb__scheduler' => "Scheduler",
    'pb__custom_buttons' => "Anpassade knappar",
    'pb__databases_db' => 'DatabaVisar',
    'pb__sqlservers_db' => 'SQL-servrar',//to check
    'pb__db' => "DatabaVisar",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Databasservrar',
    'pb__dl_usr_ed' => "Domänadministratör",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domängränser",
    'pb__dom_pref' => "Inställningar",
    'pb__dom_sum_report' => "Domänsammanfattningsrapport",
    'pb__dom_templates' => "Domänmallar",
    'pb__dom_traffic' => "Trafik för %1",
    'pb__dom_traffic_history' => "Trafikhistorik",
    'pb__domains' => "Domäner",
    'pb__domain_aliases' => 'Domänalias',
    'pb__dumps_list' => "Lagringen för säkerhetskopierade",
    'pb__forwarding_setup' => "Vidarebefordranskonfiguration",
    'pb__filemanager' => "Filhanteraren",
    'pb__ip_aliasing' => "IP-adresser",
    'pb__ip_clients' => "IP-adressborttagning",
    'pb__license_management' => 'Licenshantering',
    'pb__locales' => 'Språk',
    'pb__log_files' => "Loggfiler",
    'pb__mail' => 'E-post',
    'pb__mail_blocked_domains' => 'Svarta listan',
    'pb__mail_name_files' => "Bifogade filer",
    'pb__mail_name_redirects' => "E-postsändare",
    'pb__mail_name_resp_attach_add' => "Ny bilaga",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Automatsvar för e-post",
    'pb__mail_names' => "E-post",
    'pb__mail_white_list' => 'Vita listan',
    'pb__maillists' => "E-postlistor",
    'pb__mimetypes' => 'MIME-typer',
    'pb__modules' => 'Moduler',
    'pb__modules_management' => 'Hantera moduler',
    'pb__notifications' => "Meddelanden",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Fysisk värdtjänst inställning",
    'pb__prtd_dirs' => "Skyddade kataloger",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Rapport",
    'pb__report_auto' => "Leveransschema för %1",
    'pb__report_list' => "Anpassa",
    'pb__server' => "Server",
    'pb__sessions' => "Sessioner",
    'pb__sapp_pool' => "Webbprogramspool",
    'pb__siteapp_install' => 'Webbprogramsinstallation',
    'pb__site_app_pkgs' => 'Webbapplikationer',
    'pb__site_apps' => "Webbapplikationer",
    'pb__additional_key_info' => 'Nyckelegenskaper',
    'pb__additional_key_properties' => 'Nyckelegenskaper',
    'pb__skeleton' => 'Virtuell värdsservers innehåll',
    'pb__skins' => 'Skalutseenden',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Skräppostfilter",
    'pb__statistics' => "Statistik",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomäner",
    'pb__templates' => "Mallar",
    'pb__virtualdirs' => 'Virtuella kataloger',
    'pb__web_users' => "Webbanvändare",
    'pb__webalizer_preferences' => 'Webbstatistikinställningar',
    'pdir__enter_dir_name' => "Ange kataglognamnet.",
    'pdir__invalid_hst' => "Värdtjänsttypen är ogiltig. Måste vara fysisk.",
    'pdir__pd_id_is_undefined' => "Skyddad katalog-ID är odefinierad.",
    'pdir__pdir_exist' => "Katalog med detta namn är redan skyddat.",
    'pdir__pdir_not_exist' => "Den skyddade katalogen finns inte.",
    'pdir__pdir_usr_not_exist' => "Skyddad katalog-användare finns inte.",
    'pdir__prdirs_for_domain' => "Skyddade kataloger under webbplatsen %1",
    'pdir__prdirs_for_subdomain' => "Skyddade kataloger för subdomän %1",
    'pdir__remove_pdir_usrs' => "Följande användare av skyddad katalog %2 under webbplatsen %1 kommer att tas bort:",
    'pdir__remove_pdir_usrs_on_subdom' => "Följande användare av skyddad katalog %2 under subdomän %1 kommer att tas bort:",
    'pdir__remove_pdirs_on_dom' => "Denna åtgärd leder till att skyddet tas bort från katalogerna under webbplats %2 som ägs av kunden %1. Katalogerna raderas inte.",
    'pdir__remove_pdirs_on_subdom' => "Denna åtgärd kommer att resultera i borttagande av skyddet från katalogerna under subdomänen %1. Kataloger kommer inte att raderas.",
    'pdir__select_pdir_usrs_for_remove' => "Välj de skyddad katalog-användare som ska tas bort.",
    'pdir__select_pdirs_to_remove' => "Välj kataloger att ta bort skydd från.",
    'pdir__unable_define_pdir_users' => "Kan inte definiera användarna av den skyddade katalogen.",
    'pdir__unable_define_pdirs_properties' => "Kan inte ställa in egenskaperna för skyddade kataloger: %1",
    'pdir__unable_select_dom_param' => "Kan inte välja domänparametrar: %1",
    'pdir_ed__create_pdir_for_domain' => "Skapa en skyddad katalog under webbplatsen %1",
    'pdir_ed__create_pdir_for_subdomain' => "Skapa en skyddad katalog under subdomänen %1",
    'pdir_ed__dir_already_protect' => "Denna katalog är redan skyddad.",
    'pdir_ed__head_txt' => "Titeln på det skyddade området.",
    'pdir_ed__invalid_login' => "Du angav felaktigt användarnamn.",
    'pdir_ed__login_exists' => "Denna användare finns redan. Försök specificera annat användarnamn.",
    'pdir_ed__new_usr' => "Användarnamn",
    'pdir_ed__non_ssl' => "icke-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Katalognamn",
    'pdir_ed__pdir_for_domain' => "Skyddad katalog %1 på domän %2",
    'pdir_ed__pdir_for_subdomain' => "Skyddad katalog %1 under subdomänen %2",
    'pdir_ed__pdir_location' => "Katalogplats",
    'pdir_ed__pdir_users' => "Skyddad katalog-användare",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "SSL/TLS stöds inte av denna webbplats eller tillhandahålls inte med ditt abonnemang. För att sätta på SSL/TLS-stöd, gå till fliken Webbplatser och domäner och klicka på ditt domännamn i listan. Om SSL/TLS-stöd inte tillhandahålls med ditt abonnemang, kontakta din värdtjänstleverantör för uppgradering av din värdtjänstplan.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "SSL/TLS stöds inte av denna site. För att sätta på SSL/TLS-stöd, gå till fliken Webbplatser och domäner och klicka på ditt domännamn i listan.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Minst en kryssruta ska väljas av kryssrutorna SSL/TLS och icke-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Kan inte skapa skyddad katalog-användaren: %1",
    'pdir_ed__unable_create_pdir' => "Kan inte ta bort den skyddade katalogen: %1.",
    'pdir_ed__unable_define_hst_type' => "Kan inte definiera värdtjänsttyp.",
    'pdir_ed__unable_update_pdir' => "Det gick inte att spara inställningarna för den skyddade katalogen: %1",
    'pdir_ed__wrong_symbol_in_header' => "Använd inte tecknet %1 i katalogtiteln.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Skapa användare för den skyddade katalogen %1",
    'pdir_usr_ed__not_create_pass' => "Detta kommer inte att skapa ett lösenord för den nya skyddad katalog-användaren.\nUtan lösenord kommer användaren inte kunna logga in.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Lösenord för skyddad katalog-användaren %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Kan inte välja skyddad katalog-användaren: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Kan inte definiera användarna av den skyddade katalogen: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Kan inte ta bort användarna av den skyddade katalogen: %1",
    'pdirs_list__name' => "Namn",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Kan inte ta bort skyddade kataloger: %1.",
    'phosting__anonftp_disabled' => "Den anonyma FTP-tjänsten är inte tillgänglig för denna domän eftersom denna IP-adress redan används för anonyma FTP-tjänst på andra domäner.",
    'phosting__anonftp_encrypt' => 'Lösenordet för FTP-användaren är krypterat och kan därför inte användas för att skydda katalogen /plesk-stat/webstat/. Ange ditt FTP-lösenord, eller avmarkera alternativet " \'/Plesk-stat/webstat/\'" som nås via lösenordsskyddad katalog',
    'phosting__hosting_and_dns_ip_difference_warning' => "Domännamnet %%domain_name%% kopplar till IP-adressen %%dns_ip_address%%. Din webbplats tilldelas IP-adress %%värdtjänst_ip_address%%. Om din webbplats inte öppnas i en webbläsare när du hänvisar till den med dess domännamn, gå till DNS-hanteringsskärmen (Domäner > Domännamn > DNS) och ändra egenskaperna för resursposten: tilldela IP-adressen %%värdtjänst_ip_address%% till domännamnet %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-adressen har ändrats. De motsvarande ändringarna har också gjorts i domänens DNS-zon.",
    'phosting__other_hosting_exists_on_ip' => "Kan inte ändra certifikatet eftersom denna IP-adress används på ett eller flera värdtjänstkonton.",
    'phosting__unable_to_change_certificate' => "Det gick inte att installera certifikatet %1",
    'phosting__unable_to_change_ip_address' => "Kan inte ändra IP-adressen: %1",
    'phosting__unable_to_set_cert' => "Kan inte ställa in SSL/TLS-certifikatet: %1",
    'phosting__unable_update' => "Kan inte uppdatera värdtjänstinställningarna: %1",
    'phosting__unable_manage' => "Kan inte hantera värdtjänster: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Kunde inte konfigurera fail2ban för att spåra domänens loggar. Loggar kommer spåras automatiskt nästa gång fail2ban-tjänsten startar om.\n%1",

    'picker_acl_record__tittle' => 'Välj en ACL-post',
    'picker_autoresponder__title' => 'Välj ett autosvar',
    'picker_black_list__domain_name' => 'Välj ett domännamn',
    'picker_certificate' => 'Välj ett SSL/TLS-certifikat',

    'picker_dns_zone_template__title' => 'Välj en resurspost',
    'picker_domain__title' => 'Markera en webbplats',
    'picker_domain_alias__title' => 'Markera en domänalias',
    'picker_resource_record__title' => 'Välj en resurspost',
    'picker_disabled_resource_record__title' => 'Markera en namnserver',
    'picker_ip_address__title' => 'Markera en IP-adress',
    'picker_ip_address_clients__title' => 'Markera kunder som använder denna IP-adress',
    'picker_mail_queue' => 'Markera e-postmeddelanden',
    'picker_site_application__title' => 'Välj ett webbprogram',
    'picker_subdomain__title' => 'Välj en subdomän',
    'picker_web_user__title' => 'Markera en webbanvändare',
    'picker_custom_button__title' => 'Markera en anpassad knapp',
    'picker_license_key__title' => "Licensnyckelns val",
    'picker_spamfilter_address__title' => 'Välj en skräppostfilteradress',
    'picker_white_list__networks' => 'Val av nätverk',

    'plesk_key__action_logs' => "Loggning av åtgärder utförda av Plesk-användare.",
    'plesk_key__app_vault' => "Applikationsvalv",
    'plesk_key__backup' => "Säkerhetskopierings- och återställningsfunktioner",
    'plesk_key__client_templs' => "Hantering av tjänsteplaner",
    'plesk_key__clients' => "Användarkonton (återförsäljare och kunder)",
    'plesk_key__resellers_only' => "Användarkonton (återförsäljare)",
    'plesk_key__customers_only' => "Användarkonton (kunder)",
    'plesk_key__domains' => "Domäner",
    'plesk_key__domain_aliases' => "Domänalias",
    'plesk_key__manage_dashboard' => 'Anapssning av startsidan',
    'plesk_key__drweb' => "Antivirushantering",
    'plesk_key__event_manager' => "Händelsehanterare",
    'plesk_key__expirations' => "Hantering av kontots förfallodatum",
    'plesk_key__group_ops' => "Modifiering av flera objekt på en gång",
    'plesk_key__expiration' => "Nyckelns förfallodatum",
    'plesk_key__edition_name' => "Plesk-utgåva",
    'plesk_key__key_number' => "Nyckelnummer",
    'plesk_key__languages' => "Språkpaket",
    'plesk_key__mailnames' => "E-postkonton",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Server-support",
    'plesk_key__myplesk_func' => "Länkar för att köpa SSL/TLS-certifikat och domänregistreringstjänster",
    'plesk_key__myplesk_server_id' => "MPC slavserveridentifierare",
    'plesk_key__notifications' => "Meddelandehantering",
    'plesk_key__postgresql' => "PostgreSQL databasserverstöd",
    'plesk_key__qmail_queue' => 'Hantering av e-postkö',
    'plesk_key__remote_db' => 'Fjärrdatabasvärdtjänst',
    'plesk_key__slave_servers' => "Slavservrar",
    'plesk_key__spamassassin' => "Skräppostfilterhantering",
    'plesk_key__subdomains' => "Subdomänhantering",
    'plesk_key__sys_access' => "Hantering av åtkomst till servern",
    'plesk_key__traffic_reports' => "Trafikanvändningsrapporter",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Gäller enbart för Virtuozzo containers",
    'plesk_key__webusers' => "Webbanvändare",
    'plesk_key__license_update_date' => 'Nästa licensnyckeluppdatering',
    'plesk_key__autoinstaller_config' => 'Hantering av uppdaterarinställningar',
    'plesk_key_update__title' => 'Nyckelns uppdateringsstatus',
    'plesk_key_update__legend' => 'Nyckelns uppdateringsstatus',
    'plesk_key_update__new_additional_key' => 'Ny ytterligare nyckel mottagen',
    'plesk_key__check_wrong' => "Licensnyckeln är ogiltig. För att använda Plesk, hämta och installera en ny giltig licensnyckel.",
    'plesk_key__upload_check_wrong' => 'Den uppladdade licensnyckeln är ogiltig.',
    'plesk_key__revert_check_wrong' => 'Den tidigare installerade licensnyckeln är ogiltig.',
    'plesk_key__update_check_wrong' => 'Den uppdaterade licensnyckeln är ogiltig.',
    'plesk_key__viruozzo_only_key' => 'Licensnyckeln är enbart avsedd för användning med Plesk som körs inuti Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Du kan använda denna licensierade Plesk-kopia enbart med följande IP-adresser: %2. Följande IP-adresser täcks inte av din licens: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Antalet resurser som används för närvarande överstiger gränserna som definieras av din licens.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Antalet webbplatser som är värdbaserade på servern överskrider gränserna som definieras av din licens. Du har %2 värdbaserade webbplatser: din licens tillåter värdtjänst endast för %1 webbplatser.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Antalet domänalias på servern överstiger de gränser som definieras av din licens. Du har %2 domänaliaser: din licens tillåter värdtjänst endast för %1 domänaliaser.',
    'plesk_key__limits_exceeded_lim_cl' => 'Antalet betjänade kundkonton överstiger de gränser som fastställts för din licens. Du har %2 kundkonton som betjänas för närvarande; din licens tillåter betjäning av endast %1 kundkonton.',
    'plesk_key__limits_exceeded_lim_mn' => 'Antalet betjänade e-postkonton överstiger de gränser som fastställts för din licens. Du har %2 e-postkonton som betjänas för närvarande; din licens tillåter betjäning av endast %1 e-postkonton.',
    'plesk_key__limits_exceeded_lim_wu' => 'Antalet betjänade webbanvändarkonton överstiger de gränser som fastställts för din licens. Du har %2 webbanvändarkonton som betjänas för närvarande; din licens tillåter betjäning av endast %1 webbanvändarkonton.',
    'plesk_key__limits_exceeded_MLS' => 'Antalet för närvarande installerade språkpaket överstiger gränserna som definieras av din licens. Det finns %2 språkpaket installerade; din licens tillåter installation av endast %1 språkpaket.',
    'plesk_key__wrong_version' => 'Du försöker använda en licensnyckel skapad för en annan version av Plesk. Kontakta Plesk säljare för att erhålla rätt licensnyckel.',
    'plesk_key__other_product' => 'Du försöker använda en licensnyckel skapad för en annan produkt. Kontakta Plesk säljare för att erhålla rätt licensnyckel.',
    'plesk_key__limits_exceeded_error' => 'Kan inte installera licensnyckeln: den för närvarande använda mängden resurser överstiger gränserna som definieras i den uppladdade licensnyckeln.',
    'plesk_key__limits_exceeded_note' => 'Den för närvarande använda mängden resurser överstiger gränserna som definieras i den uppladdade licensnyckeln.',
    'plesk_key__key_file_invalid' => 'Den uppladdade nyckelfilen är ogiltig eller innehåller inte en licensnyckel.',
    'plesk_key__server_request_error' => 'Kunde inte uppdatera licensen. Kontrollera att anslutningar till licensservern ka.plesk.com på TCP-porten %1 inte har blockerats. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Se hur man gör</a>.',
    'key__title' => 'Licenshantering',
    'key__upload_title' => 'Installera en licensnyckel',
    'key__no_key_file_in_zip' => 'Den uppladdade .zip-filen innehåller inte nyckelfilen',
    'key__key_upload' => 'Licensnyckel-installation',
    'key__tabs_plesk' => 'Plesk-licensnyckel',
    'key__tabs_additional' => 'Extra licensnycklar',
    'key_revert__title' => 'Licensnyckel-rollback',
    'key_revert__legend' => 'Bekräftelse nyckel-rollback',
    'key_revert__text' => 'Licensnyckeln med följande egenskaper kommer att återställas:',
    'key__license_update_date_hint' => 'Utgångsdatumet kommer automatiskt att förlängas den %%license_update_date%%. För den automatiska uppdateringen måste du tillåta anslutningar till %%keyserver_host%%. För mer information, se %%help begin:lim_date%%följande hjälpavsnitt%%help end:lim_date%%.',
    'additional_key__info' => 'Extra nyckelegenskaper',
    'additional_key__prop_name' => 'Egenskap',
    'additional_key__prop_value' => 'Värde',
    'additional_key__descr_name' => 'Nyckelnamn',
    'additional_key__descr_key_number' => 'Nyckelnummer',
    'additional_key__descr_key_vz' => "Denna licensnyckel är avsedd att användas enbart i Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Utgångsdatum',
    'additional_key__descr_license_update_date' => 'Nästa licensnyckeluppdatering',
    'additional_key__remove_title' => "Webbprogrammets nyckel med följande egenskaper kommer att tas bort:",
    'additional_keys__remove_title' => "Följande extra nycklar kommer att tas bort:",
    'additional_keys__select_to_remove' => 'Välj de ytterligare knapparna att ta bort.',
    'additional_key__file_invalid' => 'Den uppladdade nyckelfilen är ogiltig eller innehåller inte en licensnyckel.',
    'additional_key__file_incompatible' => 'Den uppladdade nyckelfilen gäller inte för detta program.',
    'additional_key__expired' => 'Denna extra nyckel har gått ut.',
    'additional_key__not_exists' => 'Ingen licensnyckel installerad.',
    'additional_key__viruozzo_only_key' => 'Denna licensnyckel är enbart avsedd för användning med Plesk installerat i Virtuozzo containers.',
    'additional_keys__legend' => 'Ytterligare knappar',
    'additional_keys__list_header' => 'Ytterligare knappar',
    'additional_key_update__result_response' => 'Licensierande serversvar: %1',
    'additional_key_update__result_network' => 'Kan inte ansluta till licensieringsservern. Se till att ditt nätverk tillåter kommunikation till %1: %2.',
    'additional_key_update__result_lock' => 'Nyckeluppdatering pågår redan',
    'additional_key_update__result_internal_error' => 'Fel uppstod medan licensnyckeln uppdaterades: %1',

    'additional_key_revert__title' => 'Bekräfta åtgärden',
    'additional_key_revert__legend' => 'Egenskaper för den tidigare använda extra nyckeln',
    'additional_key_revert__confirm_text' => 'Återskapa nyckel',
    'additional_key_revert__confirm_required' => 'Bekräfta åtgärden.',

    'proceed_to_cl_pool' => "Sätt igång med konfigurationen av kundens IP-pool",
    'proceed_to_hosting_setup' => "Gå vidare till värdtjänstens inställning",
    'removeCerts__remove_certificates_cp' => "Följande certifikat kommer att tas bort:",
    'removeCerts__remove_certificates_domain' => "Följande certifikat som ägs av %1 kommer att tas bort:",
    'removeClientsIP_remove_clients_ip' => "Denna IP-adress kommer att tas bort från poolerna för följande kunder:",
    'removeMailAliases__remove_mail_aliases' => "Följande e-postaliaser för e-postkonto %1 kommer att tas bort:",
    'removeMailNames__remove_mailnames' => "Följande e-postkonton och aliaser kommer att tas bort från domänen %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Följande e-postkonton och aliaser kommer att tas bort från domänen %2 som ägs av kunden %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Dessa e-postkonton kommer inte att raderas.",
    'removeFtpSessions__remove_title' => "Följande FPT-sessioner kommer att avslutas:",
    'removeTemplates__remove_templates' => "Följande mallar kommer att tas bort:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Frekvens',
    'report_auto__list_last' => 'Senaste leveransdatum',
    'report_auto__list_recipient' => 'Skicka till',
    'report_auto__list_select' => 'Rapport om',
    'report_auto__title' => 'Leveransscheman för %1',
    'report_auto__recipient_email' => 'e-postadressen jag specificerar.',
    'report_auto__recipient_admin' => 'serveradministratören',
    'report_auto__recipient_client' => 'kunden',
    'report_auto__recipient_domain' => 'domänadministratören',
    'report_auto_edit__select' => 'Rapport om',
    'report_auto__select_client_report_all' => 'alla kunder',
    'report_auto__select_client_report_current' => 'denna kund',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'alla domäner',
    'report_auto__select_domain_report_other_client' => 'alla domäner för %1',
    'report_auto__select_domain_report_client' => 'alla kundens domäner',
    'report_auto__select_domain_report_reseller' => 'alla domäner för denna återförsäljare',
    'report_auto__select_domain_report_current' => 'Den här domänen',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Leveransscheman',
    'report_auto__select_for_remove' => "Välj leveransscheman att ta bort.",
    'report_auto_remove__title' => "Följande rapportleveransscheman kommer att tas bort:",
    'report_auto_edit__title' => 'Leveransschemaegenskaper',
    'report_auto_edit__recipient' => 'Skicka till',
    'report_auto_edit__target' => 'Rapport om',
    'report_auto_edit__auto' => 'Leveransfrekvens',
    'resp_edit__always_respond' => "alltid svara",
    'resp_edit__reply_subject' => "Svarsämne",
    'resp_edit__answer_subject' => "Svara med ämne",
    'resp_edit__answer_txt' => "Svara med text",
    'resp_edit__attach' => "Bifoga filer",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "för",
    'resp_edit__frw_rqst_email' => "Vid automatsvar, vidarebefordra originalmeddelandet till den specifika e-posten",
    'resp_edit__fwd_email_invalid' => "Destinationens e-postadress är ogiltig.",
    'resp_edit__in_body' => "när angivna ord finns i meddelandetexten",
    'resp_edit__in_subject' => "när angivna ord finns i meddelandets ämnesrad",
    'resp_edit__invalid_resp_freq' => "Svarsfrekvensen är ogiltig.",
    'resp_edit__invalid_rqst_txt' => "Ogiltig textbegäran.",
    'resp_edit__invalid_store_lim_num' => "Gränsvärdet är ogiltigt.",
    'resp_edit__limits_title' => "Gränser",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Maximalt antal svar per dag överstiger definierad siffra. Tillåtet: %1, begärt: %2",
    'resp_edit__no_files_sel' => "Inga filer har valts.",
    'resp_edit__no_txt_supplied' => "Ingen text tillhandahållen.",
    'resp_edit__reply_title' => "Svara",
    'resp_edit__reply_to_address' => "Avsändaradress",
    'resp_edit__reply_to_invalid' => "Returadressen är ogiltig.",
    'resp_edit__reply_uniq_email' => "Svar på den unika e-postadressen under",
    'resp_edit__conditions_title' => "Villkor",
    'resp_edit__request_title' => "Begära",
    'resp_edit__resp' => "Autosvar",
    'resp_edit__resp_name' => "Autosvar-namn",
    'resp_edit__resp_not_exist' => "Autosvar finns inte.",
    'resp_edit__resp_status' => "Autosvar-status",
    'resp_edit__rqst_txt' => 'Ange villkor för detta autosvar',
    'resp_edit__select_files_on_server_for_attach' => "Markera vilka filer som ska bifogas",
    'resp_edit__store_up_to' => "Lagra upp till",
    'resp_edit__subj_line_invalid' => "Ämnesraden är felaktig.",
    'resp_edit__text_too_big' => "Svarsmeddelandetexten är för stor.",
    'resp_edit__times_in_a_day' => "gånger per dag.",
    'resp_edit__unable_define_resp_cond' => "Kan inte definiera autosvar-villkor: %1",
    'resp_edit__unable_define_resp_status' => "Kan inte definiera autosvar-status: %1",
    'resp_edit__unable_turn_on_resp' => "Kan inte slå på autosvaret: %1",
    'resp_edit__uniq_email' => "unika e-postadresser",
    'resp_edit__content_type' => 'Format på e-postmeddelande',
    'resp_edit__content_type_text' => 'Oformaterad text',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kodning',
    'restart__dns' => 'DNS-server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3-server (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "MySQL-server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Tjänster",
    'restart__smtp' => "SMTP-server (%1)",
    'restart__spamd' => "Skräppostfilter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webbserver (%1)",
    'restart__ftp' => "FTP-server (%1)",
    'restart__service_start' => 'Lämna lite tid för att tjänsten ska starta.',
    'restart__service_stop' => 'Lämna lite tid för att tjänsten ska stoppa.',
    'restart__service_restart' => 'Lämna lite tid för att tjänsten ska starta om.',
    'rm_domains__some_domains_are_not_exist' => "Några av de angivna domänerna finns inte. Eventuellt har de tagits bort av en annan användare.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Vidarebefordrare",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Rapport till administratören %1",
    'rpt_cl_report_for_reseller__' => "Rapport till återförsäljaren %1",
    'rpt_cl_report_for_cl__' => "Rapport om kunden %1",
    'rpt_cl_section_domains' => "Domäner",
    'rpt_cl_section_full_domains' => "Domäner",
    'rpt_cl_section_general' => "Allmänt",
    'rpt_create' => "Skapa rapport",
    'rpt_empty' => "Rapporten måste innehålla minst ett avsnitt",
    'rpt_default_report' => "Använd som standardrapport",
    'rpt_dom_report_for_dom__' => "Domänrapport för %1",
    'rpt_dom_section_databases' => "DatabaVisar",
    'rpt_dom_section_full_databases' => "DatabaVisar",
    'rpt_dom_section_full_maillists' => "E-postlistor",
    'rpt_dom_section_full_mailnames' => "E-postkonton",
    'rpt_dom_section_full_webusers' => "Webbanvändare",
    'rpt_dom_section_full_siteapps' => 'Webbapplikationer',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET webbprogram',
    'rpt_dom_section_general' => "Allmänt",
    'rpt_dom_section_hosting' => "Värding",
    'rpt_dom_section_maillists' => "E-postlistor",
    'rpt_dom_section_mailnames' => "E-postkonton",
    'rpt_dom_section_siteapps' => 'Webbapplikationer',
    'rpt_dom_section_aspnetapps' => 'ASP.NET webbprogram',
    'rpt_dom_section_webusers' => "Webbanvändare",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Redigera rapport %1.",
    'rpt_enter_email_address' => "Ange e-postadressen som rapporten ska levereras till.",
    'rpt_list' => "Layouter för anpassade rapporter",
    'rpt_name' => "Rapportnamn",
    'rpt_remove_reports' => "Följande rapportlayouter kommer att tas bort:",
    'rpt_reports' => "Rapporter",
    'rpt_section_full' => "Full",
    'rpt_section_none' => "Ingen",
    'rpt_section_summary' => "Sammanfattning",
    'rpt_select_reports_for_remove' => "Markera de rapportlayouter som ska tas bort.",
    'rpt_default_full' => 'Fullständig rapport',
    'rpt_default_summary' => 'Sammanfattningsrapport',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Fel när rapporten skulle skickas: %1",
    'rpt_send_report_by_email_ok__' => "Rapporten skickades till %1",
    'sa_action' => "Action",
    'sa_action_del' => "Ta bort",
    'sa_action_desc' => "Vad man gör med skräppost",
    'sa_action_save' => "Markera som skräppost och lagra i mailboxen",
    'sa_admin_blacklist' => "Administratörs svarta lista",
    'sa_admin_whitelist' => "Administratörs vita lista",
    'sa_blacklist' => "Svarta listan",
    'sa_blacklist_desc' => "Markera alltid som skräppost från följande adresser",
    'sa_by_tag' => "efter tag",
    'sa_conf_list_black' => "Är du säker på att du vill ta bort markerade mönster från den svarta listan?",
    'sa_conf_list_ignore' => "Är du säker på att du vill ta bort markerade mönster från ignoreringslistan?",
    'sa_conf_list_white' => "Är du säker på att du vill ta bort markerade mönster från den vita listan?",
    'sa_db_del_confirm' => "Är du säker på att du vill radera spamfiltrets databas?",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "Skräppostfiltret är avstängt: e-postservern stödjer inte skräppostfilterinställningarna på e-postlådenivå.",
    'sa_eml_in_ignorelist' => "E-posten finns i ignogeringslistan",
    'sa_eml_pattern' => "E-post-mönster",
    'sa_empty_email' => "Kan inte lägga till tomma e-postmönster",
    'sa_exists_email' => "Sådana e-postmönsteer finns redan.",
    'sa_disabled__mailname_not_filtering' => "De aktuella serverinställningarna tillåter inte användning av e-postfiltrering för detta e-postkonto",
    'sa_disabled__filtering_is_disabled' => 'Skräppostfiltreringen har stängts av av serveradministratören',
    'sa_disabled__hasnt_mailbox' => "Omöjligt att slå på skräppostfiltrering utan en mailbox",
    'sa_enable_filter' => "Slå på skräppostfiltrering",
    'bt_sa_clear_db' => 'Rensa skräppostfilterdatabas',
    'bt_sa_forget' => 'Glöm det',
    'bt_sa_learn_as_spam' => "Det är skräppost!",
    'bt_sa_learn_as_nonspam' => "Det är inte skräppost",
    'sa_forget' => "Glöm",
    'sa_from' => "Från",
    'sa_ham' => "ham",
    'sa_ignorelist' => "Serveromfattande ignorera-lista",
    'sa_ignorelist_desc' => "Filtrera inte e-post för dessa konton",
    'sa_pattern_in_blacklist' => "Mönstret finns redan i svarta listan.",
    'sa_pattern_in_ignorelist' => "Mönstret finns redan i ignoreringslistan.",
    'sa_pattern_in_whitelist' => "Mönstret finns redan i vita listan.",
    'sa_pattern_is_invalid' => "Mönstret är ogiltigt.",
    'sa_select_email' => "Markera minst ett e-postmönster i listan för att ta bort det.",
    'sa_spam' => "skräppost",
    'sa_trainer__page_title' => 'Skräppostfilter-upplärning',
    'sa_trainer__tools_legend' => 'Verktyg',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Meddelanden i din e-postlåda',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Ämne',
    'sa_trainer__from' => 'Från',
    'sa_trainer__date' => 'Datum',
    'sa_trainer__info_text' => 'Inlärda meddelanden: %1 som skräpppost, %2 som icke-skräppost, %3 totalt.',
    'sa_trainer__messages' => 'meddelande (n)',
    'sa_trainer__select__all' => 'Alla',
    'sa_trainer__select__spam_only' => 'Skräppost',
    'sa_trainer__select__ham_only' => 'Ej skräppost',
    'sa_trainer__select__unknown_only' => 'Okänt',
    'sa_trainer__cannot_remove_messages' => 'Kan inte ta bort markerade meddelanden från e-postlådan.',
    'sa_trainer__remove_messages_confirm' => 'Är du säker på att du vill ta bort markerade mönster från e-postlådan?',
    'sa_srv_blacklist' => "Serveromfattande svart lista",
    'sa_srv_whitelist' => "Serveromfattande vit lista",
    'sa_subj' => "Ämne",
    'sa_training' => "Skräppostfilter-upplärning",
    'sa_training_legend' => "Bayesiskt filter-upplärning",
    'sa_use_srv_settings' => "Använd serveromfattande inställningar",
    'sa_user_blacklist' => "Användares svarta lista",
    'sa_user_whitelist' => "Användares vita lista",
    'sa_usr_disabled_by_srv' => "Individuella skräppostfiltreringsinställningar tillåts inte av serveradministratören",
    'sa_usr_no_postbox' => "Kan inte aktivera spamfiltrering eftersom brevlådan är avstängd för detta e-postkonto.",
    'sa_whitelist' => "Vita listan",
    'sa_whitelist_desc' => "Markera aldrig som skräppost från följande adresser",
    'sa_filters' => 'Skräppostfilter',
    'sa_max_mail' => 'Filtreta inte om poststorleken överskrider den specificerade storleken',
    'sa_size_limit_text' => 'Storleksgräns',
    'sa_invalid__max_spam_threads' => 'Ogiltigt värde. Ange ett värde mellan 1 och 32.',
    'sa_max_threads' => 'Antal trådar som skräppostfilter kan skapa',
    'sa_max_threads_maximum' => '(maximalt32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(otillgängligt: det aktuella skräppostfiltret stödjer inte detta alternativ)',
    'spamfilter__tools_legend' => 'Verktyg',
    'spamfilter__prefs_legend' => 'Inställningar',
    'spamfilter__max_children' => 'Maximalt antal worker spamd-processer att köra',
    'spamfilter__rewrite_header_subject_hint' => 'Lämna detta fält tomt om du inte vill lägga till valfri text. Skriv _SCORE_ om du vill inkludera poängen i meddelandets ämnesrad.',
    'spamfilter__reject_spam' => 'Radera skräppost när den kommer till brevlådan',
    'spamfilter__enabled' => 'Påkopplad',
    'spamfilter_addresses_list__tools_legend' => 'Verktyg',
    'spamfilter_addresses_list__list_legend' => 'Adresser',
    'spamfilter_addresses_list__items' => 'adresser',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Adress',
    'spamfilter_addresses__file_legend' => 'Från fil',
    'spamfilter_addresses__file_label' => 'Filnamn',
    'spamfilter_addresses__file_hint' => 'Överför en fil i UTF-8-filkodning.',
    'spamfilter_addresses__text_legend' => 'Från lista',
    'spamfilter_addresses__text_label' => 'E-postadresser',
    'spamfilter_addresses__remove_title' => 'Följande adresser kommer att tas bort ur listan:',
    'spamfilter_addresses__empty_selection' => 'Inga adresser valda.',
    'server__admin_info' => "Administratörsinformation",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Ange beskrivning av buggen nedan",
    'server__power_management' => "Energisparfunktioner",
    'server__services' => "Tjänster",
    'server__system' => "System",
    'server__title' => "Serveradministration",
    'server_preferences__admin_skin' => "Administratörs gränssnittsskal",
    'server_preferences__count_disk_space' => "Inkludera i beräkningen av använt diskutrymme",
    'server_preferences__count_traffic' => "Inkludera i trafikberäkningen",
    'server_preferences__count_type' => 'Vid beräkning av använt diskutrymme, räkna',
    'server_preferences__count_type__byte' => 'filstorlek',
    'server_preferences__count_type__block' => 'diskutrymme som används',
    'server_preferences__default_language' => "Grundspråk",
    'server_preferences__default_skin' => "Standardskal",
    'server_preferences__include_databases' => "databaser",
    'server_preferences__include_domaindumps' => "domänens säkerhetskopierade filer",
    'server_preferences__include_incoming' => "endast ingående trafik",
    'server_preferences__include_incoming_and_outgoing' => "in- och utgående trafik",
    'server_preferences__include_logs' => "loggfiler och statistikrapporter",
    'server_preferences__include_mailboxes' => "E-postkonton",
    'server_preferences__include_maillists' => "E-postlistor",
    'server_preferences__include_outgoing' => "endast utgående trafik",
    'server_preferences__include_remote_databases' => 'Fjärrdatabaser',
    'server_preferences__keep_stats' => "Behåll webb- och trafikstatistik för",
    'server_preferences__restart_apache_interval' => "Apache omstartintervall",
    'server_preferences__stat_warning' => "Ändringar som görs av beräkningsschemat för användning av diskutrymmet, kommer att träda i kraft först under nästa statistikberäkning.",
    'server_preferences__title' => "Serverinställningar",
    'server_preferences__system' => 'Systeminställningar',
    'server_mail__title' => "Serveromfattande e-postinställningar",
    'mail__tabs_preferences' => "Inställningar",
    'mail__tabs_white_list' => "White List",
    'mail__tabs_blocked_domains' => "Svarta listan",
    'mail__tabs_mail_queue' => "E-postko",
    'server_preferences__use_vocabulary' => "Kontrollera lösenorden för e-postkonton i ordlistan",
    'sessions__agreement' => "Ja, jag vill avsluta dessa sessioner.",
    'sessions__select_sessions_for_remove' => "Markera sessioner som ska avslutas.",
    'sessions__tabs_cp_sessions' => 'Plesk-sessioner',
    'sessions__tabs_ftp_sessions' => 'FPT-sessioner',
    'sessions__ftp_sessions_login' => 'FTP-kontots användarnamn',
    'sessions__ftp_sessions_domain' => 'Domännamn',
    'sessions__ftp_sessions_path' => 'Aktuell plats',
    'sessions__ftp_sessions_file' => 'Filnamn',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Hastighet, KB/S',
    'sessions__ftp_sessions_comp' => 'Förlopp, %',

    'site_apps__access_level' => 'Åtkomstnivå',
    'site_apps__access_level_commercial' => 'Kommersiell',
    'site_apps__access_level_free' => 'GRATIS',
    'site_apps__action_installer' => "Webbprogramsinstallation",
    'site_apps__action_reconfigure' => "Webbprogram håller på att återkonfigureras",
    'site_apps__custom_button_level' => 'Vill du skapa en anpassad knapp för åtkomst till detta program?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nej',
    'site_apps__custom_button_level_domain_user_only' => 'Ja',
    'site_apps__custom_button_level_false' => 'Nej',
    'site_apps__custom_button_level_domain' => 'Ja, och gör den tillgänglig endast för den aktuella domänen',
    'site_apps__custom_button_level_client' => 'Ja, och gör den tillgänglig för alla kundens domäner',
    'site_apps__custom_button_level_admin' => 'Ja, och gör den tillgänglig för alla domäner',
    'site_apps__description' => "Beskrivning",
    'site_apps__dir_used_by_sapp__' => "Katalogen \"%1\" används av ett annat webbprogram",
    'site_apps__dir_used_by_unknown__' => "Katalogen %1 finns redan. Dess innehåll kommer att skrivas över om du fortsätter",
    'site_apps__dir_invalid_name__' => "Katalognamnet %1 är felaktigt",
    'site_apps__file_name' => 'Webbprogrammets filnamn',
    'site_apps__invalid_install_prefix' => "Ogiltigt installationsprefix",
    'site_apps__invalid_package' => "Webbprogrammet är ogiltigt",
    'site_apps__key_status' => 'Licensiering',
    'site_apps__key_status_free' => 'Fritt distribuerade. Ingen licensnyckel krävs',
    'site_apps__key_status_ok' => 'Den nödvändiga licensnyckeln är installerad',
    'site_apps__key_status_problem' => 'Den nödvändiga licensnyckeln är inte installerad',
    'site_apps__name' => "Namn",
    'site_apps__no_domains' => 'Webbprogrammet kan inte installeras. Det finns redan ett annat webbprogram installerat i rotkatalogen på denna domän. Överväg att skapa en underdomän för webbprogrammet.',
    'site_apps__package_info_' => "Information för webbprogram",
    'site_apps__package_integrated' => "inbyggt program, kan inte tas bort",
    'site_apps__pool_select_packages_to_add' => 'Markera webbprogrammen du vill lägga till i poolen',
    'site_apps__release' => "Släppa",
    'site_apps__resource_used_by_sapp' => "Denna resurs används av ett installerat webbprogram",
    'site_apps__root_used_by_sapp' => "Denna resurs används av ett instalelrat webbprogram",
    'site_apps__these_domains_will_not_delete' => 'Dessa (sub)domäner kommer inte att raderas',
    'site_apps__upload_site_app_pkg_title' => 'Ladda upp ett nytt webbprogram',
    'site_apps__version' => "Version",
    'site_apps__access_to' => "Åtkomst toill %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Virtuell värdsservers innehåll",
    'skeleton__client_label' => "%1 virtuell värddatormall",
    'skeleton__admin_page' => "Hantera den virtuella värddatormallen",
    'skeleton__files_list' => "Filer och kataloger",
    'skeleton__archiver_not_installed' => "Kan inte packa upp arkivet. Arkiveraren är eventuellt inte installerad på servern. Kontakta {$PROD_NAME}-administratör för att låta installera arkiverar-mjukvaran.",
    'skeleton__client_page' => "Hantera den virtuella värddatormallen",
    'skeleton__archive_corrupted' => "Arkivkontrollen upptäckte att arkivfilen är antingen korrupt eller att denna arkivtyp inte stöds.",
    'skeleton__archive_too_large' => "Arkivkontrollen upptäckte att arkivfilen är för stor.",
    'skeleton__not_supported_archive_type' => "Denna filtyp (fil %1) tillåts inte.",
    'skeleton__upload_archive_file' => "Överför arkivfil",
    'skin_download__title' => 'Ladda ner skal',
    'skin_download_now__title' => 'Skalnedladdning pågår',
    'skin_download_now__text' => 'Skalpaketskapande pågår.<br>Denna procedur kan ta lite tid.<br> När dialogfönstret visas, kan du fortsätta arbeta med Plesk.',
    'skin_file__help_for_using_types' => "Använd skalarkiven i något av följande format:",
    'skin_info__title' => 'Skalegenskaper',
    'skin_mng_err__rpm_not_skin' => 'Detta RPM är inte ett Plesk-skalpaket',
    'skin_mng_err__psa_install_noreloc' => 'Kunde inte installera det rpm-baserade skalet på angiven position.',
    'skin_mng_err__already_exists' => 'Skalinstallationskatalogen finns redan, och det finns ett skalpaket publicerat.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Den uppladdade filen är inte ett giltigt RPM-skalpaket.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Den uppladdade filen är inte ett giltigt skalpaket.',
    'skin_mng_err__rpm_upgrade_base' => "Den uppladdade filen är inte ett giltigt {$PROD_NAME}-skalpaket.",
    'skin_mng_err__rpm_upgrade_other' => 'Kan inte installera skalet: ogiltigt skalformat.',
    'skin_mng_err__no_a_skin' => "Den uppladdade filen är inte ett giltigt {$PROD_NAME}-skalpaket.",
    'skin_upload__title' => 'Ladda upp nytt skal',
    'skin_upload__already_exists' => "Skalet %1 finns redan.",
    'skin_upload__unable_to_apply' => "Den uppladdade filen innehåller inte ett Plesk-skal, eller så stöds inte arkiveringsformatet.",
    'skin_upload__unable_to_rename__' => "Kan inte ändra namn på skal %2 till %1: %3.",
    'skin_upload__file_name' => 'Sökväg till skalpaketfilen',
    'skins_list__title' => 'Skalkatalog',
    'skins_remove__title' => 'Skalborttagande',
    'skins_remove__select_skins_for_remove' => 'Välj de skal som ska tas bort.',

    'spamassassin__title' => "Skräppostfilterkonfiguration",
    'spf_parameters' => 'SPF-spamskydd',
    'spf_enable_label' => 'Aktivera SPF spamskydd för att kontrollera inkommande post',
    'spf_behavior' => 'SPF-kontrolläge',
    'spf_rules' => 'lokala SPF-regler',
    'spf_guess' => 'SPF-gissningsregler',
    'spf_exp' => 'SPF-förklaringstext',
    'spf__unable_update' => 'Det gick inte att uppdatera SPF-parametrar',
    'spf_bhv__create_headers_no_block' => 'Skapa bara Mottaget-SPF-rubriker, spärra aldrig',
    'spf_bhv__use_tmp_errors' => 'Använd tillfälliga felmeddelanden när du har DNS-sökningsproblem',
    'spf_bhv__reject_if_fail' => 'Avvisa post när SPF anger "fail" (neka)',
    'spf_bhv__reject_if_softfail' => 'Avvisa post när SPF anger "softfail"',
    'spf_bhv__reject_if_neutral' => 'Avvisa post när SPF anger "neutral"',
    'spf_bhv__reject_if_no_pass' => 'Avvisa post när SPF anger "pass"',
    'sshterm__title' => 'Secure Shell-terminal.',
    'sshterm__password_authentication_warning' => 'Notera: Lösenordsautentisering slås av i den lokala SSH-serverkonfigurationen. Om du inte kan ansluta med hjälp av SSH-terminalen, be administratören ställa in "PasswordAuthentication yes" i filen /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Notera: Lösenordsautentisering slås av i den lokala SSH-serverkonfigurationen. Om du inte kan ansluta med hjälp av SSH-terminalen, ställ in "PasswordAuthentication yes" i filen /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Aktiva domäner",
    'statistics__clients' => "Kunder",
    'statistics__subdomains' => "Subdomäner",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "DatabaVisar",
    'statistics__db_users' => "Databasanvändare",
    'statistics__dirs' => "Skyddade kataloger",
    'statistics__dom_active' => "Aktiva",
    'statistics__dom_passive' => "Passiv",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domäner",
    'statistics__domains_with_host' => "Domäner med värdtjänst",
    'statistics__doms' => "Domäner",
    'statistics__filesystem' => "Filsystem",
    'statistics__general' => "Allmänt",
    'statistics__hdd_available' => "Tillgänglig",
    'statistics__hdd_capacity' => "Kapacitet",
    'statistics__hdd_total' => "Totalt",
    'statistics__hdd_usage' => "Hårddiskanvändning",
    'statistics__hdd_used' => "Används",
    'statistics__ip' => "IP-adress",
    'statistics__key_number' => "Nyckelnummer",
    'statistics__l1' => "Den senaste minuten",
    'statistics__l15' => "De senaste 15 minuterna",
    'statistics__l5' => "De senaste 5 minuterna",
    'statistics__la' => "CPU-användning",
    'statistics__mail_autoresponders' => "Autosvar",
    'statistics__mail_boxes' => "E-postlådor",
    'statistics__mail_groups' => "E-postgrupper",
    'statistics__mail_lists' => "E-postlistor",
    'statistics__mail_redirects' => "E-postsändare",
    'statistics__mem' => "Minnesanvändning",
    'statistics__mem_usage' => "Användning",
    'statistics__memory_available' => "Tillgänglig",
    'statistics__memory_buffer' => "Buffert",
    'statistics__memory_cached' => "Cachelagrad",
    'statistics__memory_free' => "GRATIS",
    'statistics__memory_shared' => "Delad",
    'statistics__memory_total' => "Totalt",
    'statistics__memory_used' => "Används",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problemkunder",
    'statistics__problem_domains' => "Problemdomäner",
    'statistics__swap' => "Växlingsanvändning",
    'statistics__swap_free' => "GRATIS",
    'statistics__swap_total' => "Totalt",
    'statistics__swap_usage' => "Användning",
    'statistics__swap_used' => "Används",
    'statistics__system_stat' => "Serverinformation",
    'statistics__unable_define_active_doms' => "Kan inte fastställa antalet aktiva domäner: %1",
    'statistics__unable_define_inactive_doms' => "Kan inte fastställa antalet inaktiva domäner: %1",
    'statistics__up_time' => "Systemtillänglighet:",
    'statistics__ver' => "Version",
    'statistics__web_users' => "Webbanvändare",
    'statistics__mem_win' => "Användning av fysiskt minne",
    'statistics__memory_total_win' => "Totalt",
    'statistics__memory_used_win' => "Används",
    'statistics__memory_free_win' => "Tillgänglig",
    'statistics__swap_win' => "Användning av virtuellt minne",
    'statistics__swap_total_win' => "Totalt",
    'statistics__swap_used_win' => "Används",
    'statistics__swap_free_win' => "Tillgänglig",
    'status__domain_has_reasons_to_be_off' => "Domänen är fortfarande inaktiverad av följande orsak: %1",
    'subdomain__create__' => "Skapa en subdomän i domänen %1",
    'subdomain__edit__' => "Hantera subdomän %1",
    'subdomain__invalid_name' => "Ogiltigt subdomännamn: använd endast alfanumeriska tecken och bindestreck.",
    'subdomain__incorrect_name' => "Ogiltigt underdomännamn.",
    'subdomains__maillists_enabled_in_domain' => "Felaktiga subdomännamnlistor.%1: detta domännamn används redan av e-postlistor under domänen %1.",
    'subdomains__dalias_exists' => 'En domänalias med ett sådant namn finns redan.',
    'subdomains__name_exists' => "En underdomän med ett sådant namn finns redan",
    'subdomains__regular_domain_exists' => "Domän med ett sådant namn finns redan",
    'subdomains__domain_alias_exists' => 'En domänalias med ett sådant namn finns redan.',
    'subdomains__remove_subdomains_on_domain' => "Följande subdomäner för domän %1 kommer att tas bort:",
    'subdomains__select_subdomains_for_remove' => "Markera de underdomäner som ska tas bort.",
    'subdomains__webmail_enabled_in_domain' => "Felaktigt subdomännamn webbmail.%1: Detta domännamn används för åtkomst till webbmail under domänen %1.",
    'subdomains__dns_record_already_exists' => 'Kan inte skapa underdomänen %1 eftersom det redan finns en DNS-post som pekar mot värddator %1.',
    'subdomains__www_prefix_in_domain' => "Felaktigt subdomännamn www.%1: domänen %1 har redan WWW-prefixet.",
    'subdomains__user_type_quota_exceeds' => 'Kan inte ändra användarkontot eftersom det skulle leda till att det tilldelade diskutrymmet överskrids.',
    'subdomains__creation_in_dns_slave' => "Plesk-namnserver fungerar som sekundär namnserver (slav) för denna domän. För att din subdomän ska adresseras ordentligt, se till att zonfilen på den primära servern (mastern) innehåller posten %1.",
    'sys_user__attributes_not_changed' => "Följande systemanvändaregenskaper ändrades inte: %1",
    'sys_user__no_access_without_password' => "Du angav inget lösenord. Systemanvändaren kommer att skapas, men kommer inte att kunna logga in på systemet förrän hon får ett lösenord. Vill du fortsätta?",
    'sys_user__no_hard_quota' => "stöds inte",
    'sysuser__zero_quota_is_unlimited' => "0 för obegränsat",
    'template__num_excl_ips' => "Allokera dedikerade IP-adresser till kunden",
    'template__sel_sh_ips' => "Valda delade IP-adresser",
    'template__av_sh_ips' => "Tillgängliga delade IP-adresser",
    'template__up_to_excl_ip' => "Upp till %1 IP-adresser",
    'templates__all_clients' => "alla kunder",
    'templates__cl_domain_templates' => "Mallar för %1",
    'templates__cl_templates' => "Kundmallar",
    'time__day' => "Dag",
    'time__dom_name_ip' => "Domännamn eller IP",
    'time__hours' => "Timmar",
    'time__invalid_ip' => "Ogiltig IP-adress eller domännamn.",
    'time__invalid_year' => "Årtalet är ogiltigt. Ska vara mellan 1971 och 2036.",
    'time__invalid_month' => "Månaden är ogiltig. Ska vara mellan 1 och 12.",
    'time__invalid_day' => "Dag är ogiltig. Ska vara mellan 1 och 31.",
    'time__invalid_hours' => "Timmar är ogiltigt. Ska vara mellan 0 och 24.",
    'time__invalid_minutes' => "Minuter är ogiltigt. Ska vara mellan 0 och 59.",
    'time__invalid_seconds' => "Sekunder är ogiltigt. Ska vara mellan 0 och 59.",
    'time__minutes' => "Min",
    'time__month' => "Månad",
    'time__sec' => "Visaconds",
    'time__syn_sys_time' => "Synkronisera systemtiden",
    'time__system_datetime' => 'Datum och tid',
    'time__system_date_update' => 'Uppdatera systemtid',
    'time__system_date' => "Datum (år-månad-dag)",
    'time__system_time' => "Tid (timmar:minuter:sekunder)",
    'time__system_date_title' => "Systemets datum och tid",
    'time__timezone_title' => 'Tidszon',
    'time__network_time' => 'Nätverkstid',
    'time__timezone' => 'Din tidszon',
    'time__daylight' => 'Justera klockan automatiskt för ändringar av sommartid',
    'time__please_select_timezone' => 'Markera en tidszon',
    '__please_select_country' => 'Välj land',
    'time__unable_set_time' => "Det gick inte att ange systemtiden: %1",
    'time__year' => "År",
    'tmpl__create' => "Skapa mall",
    'tmpl__edit__' => 'Mall %1',
    'tmpl__logrotation_warn' => "Loggrotation på domänen som skapats med denna mall kommer att utföra endast vid efterföljande fysiskt värdbaserat konto som skapats för detta.",
    'tmpl__name' => "Mallnamn",
    'tmpl__dom_exist' => "En domänmall med ett sådant namn finns redan i administratörens eller kundens mallpool.",
    'tmpl__name_invalid' => "Mallnamnet är tomt eller ogiltigt.",
    'tmpl__use_next_ip_addr' => "Nästa lediga IP-adress kommer att användas",
    'tmpl_name_already_exists' => "En mall med namnet  '%1'  finns redan.",
    'traffic__no_periods_found' => "Kan inte visa webb- och trafikstatistik. Denna funktion kommer att vara tillgänglig endast efter nästa statistikberäkning.",

    'vh_based__no_free_ip_for_vh' => "Det finns inga lediga IP-adresser för den IP-baserade virtuella webbtjänsten. Ange en IP-adress.",

    'wu__at_domains_text' => "Tillåt webuser@%1 åtkomstformat",
    'wu__unable_create' => "Kan inte skapa en webbplatsanvändare: %1",
    'wu_edit__disk_quota' => "Diskkvot",
    'wu_edit__invalid_pass' => "Lösenordet är ogiltigt.",
    'wu_edit__invalid_quota' => "Det angivna utrymmeskvotvärdet är ogiltigt. Ange ett positivt heltal.",
    'wu_edit__invalid_quota_value' => "Den angivna utrymmeskvoten är mindre än vad som för närvarande används (%1 MB). Viss funktionalitet kan bli otillgänglig. Är du säker på att du vill fortsätta?",
    'wu_edit__not_create_pass' => "Denna åtgärd kommer inte skapa ett lösenord för den nya webbanvändaren.\nUtan lösenord kommer användaren inte kunna logga in.",
    'wu_edit__unable_update' => "Det gick inte att uppdatera webbanvändaregenskapen: %1",

    'bt_webdirs' => 'Virtuella kataloger',

    'dns__tabs_general' => 'Zon Inställningar',
    'dns__tabs_zone_settings' => 'SOA-poster',
    'soa__seconds' => 'sekunder',
    'soa__minutes' => 'minuter',
    'soa__hours' => 'timmar',
    'soa__days' => 'dagar',

    'DomainSubdirectory' => 'Målunderkatalog',

    'filemanager__select_codepage' => 'Välj kodsida:',

    'bt_server_app_add' => 'Lägg till serverprogram',
    'packages_list' => 'Serverprogram',

    'bt_packages_management' => 'Pakethantering',
    'pb__packages_management' => 'Applikationshantering',
    'bt_package_new' => 'Lägg till program',
    '__packages' => 'Serverprogram',

    'dom_ctrl__mysql_dbase_space' => 'Totalt MySQL-databasvärde',
    'dom_ctrl__mssql_dbase_space' => 'Totalt MS SQL databasvärde',
    'server_preferences__include_mysql_databases' => 'MySQL-databaVisar',
    'server_preferences__include_mssql_databases' => 'Microsoft SQL-databaser',

    'check_permissions__domains_selection' => 'Filens och mappens åtkomstbehörigheter för följande domäner kommer att kontrolleras',

    'dns_add__enter_ixfr_path' => 'Ange IXFR-sökväg',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT-post finns redan. Det kan bara finnas en SPF-post. För att lägga till en post, ta bort den befintliga först.',

    'component_name__network' => 'Nätverk',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Ange skal',
    'bt_set_skin' => 'Ange skal',
    'firewall__rule_already_exists' => 'En regel med namnet "%1" finns redan',
    'pb__firewall' => 'Brandvägg',
    'ruleeditform__incorect_port_value' => 'Portnumret ska vara mellan 1 och 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Filplatsen är ogiltigt.',

    'error_doc__erorr_invalid_url_location' =>  'Fel URL-format. Ange en absolut URL inom den virtuella värddatorn (webbplatsen).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirus-skydd',
    'antivirus__antivirus_direction_off' => 'Avstängd',
    'antivirus__antivirus_direction_any' => 'Inkommande och utgåend e-post.',
    'antivirus__antivirus_direction_from' => 'Endast utgående e-post',
    'antivirus__antivirus_direction_to' => 'Endast inkommande e-post',
    'antivirus__unable_to_update_settings' => 'Kan inte ändra antivirusinställningarna: %1',




    '__normal' => 'Normal',
    '__low' => 'Låg',
    '__high' => 'Hög',

    'mail__antivirus' => "Intern mailservers antivirus",
    'mail__use_internal_antivirus' => 'Använd interna antivirus',

    'sa__tabs_general' => 'Allmänt',
    'sa__tabs_whitelist' => 'White List',
    'sa__tabs_blacklist' => 'Svarta listan',
    'sa__tabs_trustednetworks' => 'Betrodda nätverk',
    'sa__alarm_message_text' => 'Varningstext skräppostdetektering',
    'sa__ok_languages' => 'Betrodda språk',
    'sa__language_groups_available' => 'Tillgängliga språk',
    'sa__language_groups_belonged' => 'Valda betrodda språk',
    'sa__ok_locales' => 'Betrodda språkversioner',
    'sa__locale_groups_available' => 'Tillgängliga språkversionsgrupper',
    'sa__locale_groups_belonged' => 'Markerade betrodda språkversionsgrupper',

    'sa_trustednetworks' => 'Lista över betrodda nätverk',
    'sa_tn_address' => 'Nätverk/Mask',
    'sa_trustednetworks_desc' => 'Valda betrodda nätverk',

    '__mysql_databases' => 'MySQL-databaser',

    'check_permissions__read_only' => 'Endast kontrolläge',
    'check_permissions__notification_email' => 'Skicka meddelande med e-post',

    'cl_perm__mysql_dbase_space' => 'Totalt MySQL-databasvärde',
    'cl_perm__mssql_dbase_space' => 'Totalt MS SQL databasvärde',
    'cl_perm__max_mssql_db' => 'Maximalt antal Microsoft SQL Server-databaser',
    'cl_perm__total_mboxes_quota' => 'Total e-postkontokvot',



    'time__date' => 'Datum',
    'time__time' => 'Tid',

    'check_permissions_warning' => 'Denna procedur kan ta lång tid. Ha tålamod och avbryt inte laddningen av sidan.',

    'i_i_cl_on' => 'Kundens konto är aktivt.',
    'i_i_cl_off_by_admin' => 'Kundkontot har tillfälligt upphävts av administratören.',

    'check_permissions__email_is_invalid' => 'Den bifogade e-postadressen är ogiltig',

    'sa_invalid_tn_ip' => 'IP-värdet är ogiltigt.',
    'sa_invalid_tn_mask' => 'Maskvärdet är ogiltigt.',
    'sa_exists_tn' => 'Nätverket finns redan i listan.',
    'sa_select_tn' => 'Inga nätverk har valts för borttagning.',
    'sa_conf_list_tn' => 'Bekräfta borttagande av de valda nätverken.',

    'firewall__tabs_general' => 'Allmänt',
    'firewall_tabs_icmp' => 'ICMP-protokoll',

    'firewallicmpform__title' => 'Brandväggsregler för ICMP-protokollet',
    'firewallicmpform__icmpsettings_list_legend' => 'Brandväggsregler för ICMP-protokollet',
    'firewallicmpform__icmpsettingslist' => 'Regler',
    'icmpsettingslist__enabled' => 'S',
    'icmpsettingslist__type' => 'Regelnamn',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Tillåt inkommande begäran om router',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Tillåt inkommande begäran om tidstämpling',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Tillåt inkommande maskbegäran',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Tillåt utgående källavstängning',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Tillåt utgående parameterproblem',
    'firewall__icmp_type_allowredirect' => 'Tillåt omdirigering',
    'firewall__icmp_type_allowinboundechorequest' => 'Tillåt inkommande ekobegäran',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Tillåt överskridning av utgående tid',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Tillåt utgående där mål inte kan nås',


    'webdir__select_vdirs_to_remove' => 'Välj de kataloger du önskar ta bort',
    'webdir__select_mime_types_to_remove' => 'Välj de MIME-typer du önskar ta bort',

    'defaultcomponents__not_activated' => 'inte aktiverad',

    'bt_traffic_at_domains' => 'Trafik',

    'firewall__icmpsettingslist' => 'Regler',
    'icmpsettingslist__name' => 'Regelnamn',

    '__awstats_perl_warning' => 'Utan Perl installerat, kommer AWStats inte låta användare att kontrollera statistiken för föregående år.',

    'class_client__mysql_dbase_space' => 'Värdet överskrider kundens gräns',
    'class_client__mssql_dbase_space' => 'Värdet överskrider kundens gräns',
    'class_client__max_mssql_db' => 'Värdet överskrider kundens gräns',

    'firewall__icmp_reset_configuration' => 'Är du säker att du vill återställa brandväggsinställningarna till standardläget?',
    'firewall__icmp_panic_configuration' => 'Är du säker att du vill slå på panikläge? Vissa nätverkstjänster kan upphöra att fungera.',


    'dns__remove_transfer_restrictions_list_items' => 'Följande nätverk kommer att tas bort ur åtkomstkontrollistan:',

    'firewall__select_rule_to_remove' => 'Välj regler att ta bort',

    'bt_up' => "Upp",
    'bt_down' => "Ner",
    'virtualdir__type_default_doc_name_to_add' => 'Ange ett filnamn att lägga till i listan',
    'virtualdir__select_default_doc_to_remove' => 'Markera filer som ska tas bort ur listan',

    'bt_install_selected' => 'Installera valda licensnycklar', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Domänen kopplar till en annan IP-adress: (%1). Korrigera DNS-inställningarna.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'E-postservern som används för närvarande stödjer inte både e-postlådan och e-postgrupperna som sätts på samtidigt. Tryck på OK för att sätta på brevlådan på bekostnad av avstängningen av e-postgrupperna. Tryck på Avbryt för att lämna allting som det är.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'E-postservern som används för närvarande stödjer inte både e-postlådan och e-postgrupperna som sätts på samtidigt. Tryck på OK för att sätta på e-postgrupper på bekostnad av avstängningen av brevlådan. Tryck på Avbryt för att lämna allting som det är.',

    'mysql_dbase_space_limit' => 'MySQL-databasutrymmesgräns',
    'mysql_dbase_usage' => 'MySQL-databasutrymmesanvändning',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server-databasutrymmesgräns',
    'mssql_dbase_usage' => 'Microsoft SQL Server-databasutrymmesanvändning',

    '__statistics' => "statistik", //indirect

    'dns__soa_minimum_value_is_big' => 'Om du ställer in minimi-TTL-värdet till mer än 3 timmar kan detta göra dina domäner otillgängliga för några av domänadministratörerna. Det rekommenderas att ställa in ett sådant värde endast om din domännamnsregistrator insisterar på det.',

    'maillists__server_legend' => 'Mailman-inställningar',
    'maillists__secure_links_text' => 'Använd säkra länkar i e-postlistor',
    'maillists__secure_links_hint' => 'Aktivera eller inaktivera säker (HTTPS) länkgenerering i e-postlistor.',

    'virusfilter__interface_not_available' => 'Inga virusfilter är tillgängliga.',
    'virusfilter__none_virus_filter' => 'Ingen',
    'virusfilter__server_legend' => 'Antivirus-inställningar',
    'virusfilter__server_text' => 'Använt antivirus',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'avstängd',
    'virusfilter__status_any' => 'inkommande och utgåend e-post.',
    'virusfilter__status_outgoing' => 'endast utgående e-post',
    'virusfilter__status_incoming' => 'endast inkommande e-post',

    'visibility__adminonly' => 'Endast admin',
    'visibility__button_sets' => 'Kontroller',
    'visibility__control' => 'Klicka för att anpassa denna kontroll.',
    'visibility__customization_footnote' => 'Klicka på OK till slutföra anpassningen av denna skärm.',
    'visibility__default' => 'Standard',
    'visibility__export_note' => "De anpassade inställningar du gjort är på väg att exporteras. Ett kommandoskript kommer nu att laddas ner till din dator. För att tillämpa dessa inställningar på en annan Plesk-server, och skriva över ev. befintliga gränssnittshanteringsinställningar, ladda upp och kör skripten där.\n\nNotera att om du har gjort ändringar av denna skärm, men ännu inte har klickat på OK, kommer datan som exporteras inte att inkludera dina senaste ändringar.",
    'visibility__hide' => 'Dölj',
    'visibility__reset_all' => 'Återställ alla till standard',
    'visibility__reset_screen' => 'Återställ originallayouten för denna skärm',
    'visibility__root_override_parse_error' => 'Det finns ett syntaxfel i fil %1 på rad %2.',
    'visibility__screen_title' => 'Gränssnittshantering',
    'visibility__set_billing_enabled' => 'Koppla ifrån Customer & Business Manager',
    'visibility__set_cert_puchasing' => 'Dölj knappar för certifikatköp',
    'visibility__set_domain_registration' => 'Dölj knappar för domänregistrering',
    'visibility__set_extras' => 'Dölj knappar för extra tjänster',
    'visibility__set_mail_bounce' => 'Dölj kontroller för meddelanden om avvisande för obefintliga e-postadresser',
    'visibility__show' => 'Visa',
    'visibility__show_toolbar' => 'Visa verktygsfältet för gränssnittshantering',
    'visibility__standby_footnote' => 'Klicka för att anpassa kontroller på denna skärm.',
    'visibility__standby_footnote_nocontrols' => 'Det finns inga anpassningsbara kontroller på denna skärm.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Publiceringsautomation stöds inte av komponenten",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Inställning av e-postlådans kvot stöds inte av den aktuella e-postservern.',
    '__unable_get_total_mboxes_quota' => 'Inställning av e-postlådans kvot stöds inte av den aktuella e-postservern.',

    'install_prefix__parent_not_exists' => "Huvudkatalogen finns inte.",

    'bt_change_version' => 'Ändra version',
    'aspdotnet__changeversion_title' => 'Markera ASP.NET-version',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Markera alla",
    '__uncheck_all' => "Radera alla",

    'dns__editing_domain_controller_zone' => "Redigering av DNS-zonposter för domäncontrollern kan orsaka problem för domänens funktion",

    'pb__interface_management' => "Gränssnittshantering",
    'interface_management__tabs_skins' => "Skalutseenden",
    'interface_management__tabs_interface_templates' => "Gränssnittsmallar",
    'interface_management__tabs_locales' => "Språk",
    'locales_list__title' => "Språkpaketskatalog",
    'locales_list__legend' => "Tillgängliga språk",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Språkpaket",
    'locales_list__lang_title' => "Språk",
    'locales_list__country_title' => "Land",
    'locales_list__used_title' => "Används",

    'backup__suspend_warning_during_backup' => "Domänen kommer att vara otillgänglig under säkerhetskopieringsprocessen",
    'backup__suspend_warning_during_restore' => "Domänen kommer att vara otillgänglig under återställningssprocessen",
    'backup__suspend_domain' => "Stäng av domän",

    'locales_list__mls_limit' => "Din aktuella Plesk-licens möjliggör användning av %2 språk. För ögonblicket, har du %1 språk angivna som tillgängliga för användare, vilket överstiger antalet som medges av licensen. Välj %2 språk som du vill använda, och gör resten otillgängliga för användare genom att klicka på deras ikoner i kolumnen 'S'.",

    'bt_change_owner' => 'Tilldela ny ägare',
    'chown__new_owner' => 'Ny ägare',
    'chown__selected_domains' => 'Markera abonnemang',
    'chown__limits_legend' => 'Resurser',
    'chown__limit_name' => 'Resursnamn',
    'chown__limit_value' => 'Belagda resurser',
    'chown__limit_assigned_before' => 'Före överföring',
    'chown__limit_assigned_after' => 'Efter överföring',
    'chown__error_limits' => "Kan inte fortsätta med abonnemangsöverföringen: detta abonnemang kräver mer resurser än vad den nya ägarens leverantör kan tillhandahålla.",
    'chown__error_no_domains' => 'Kan inte fortsätta med abonnemangsöverföringen: antingen har inga abonnemang valts eller så tillhör de valda abonnemangen redan målanvändaren.',
    'chown__error_empty_ip_pool' => "Kan inte fortsätta med abonnemangsöverföringen: IP-poolen för den nya ägarens leverantör är tom. Se till att leverantören har minst en IP-adress i poolen.",
    'chown__please_select_new_domain_owner' => 'Markera den nya ägaren för detta abonnemang',
    'chown__old_ip_address' => 'Aktuell IP-adress',
    'chown__new_ip_address' => 'Ny IP-adress',

    'chown__error_ssl_already_used' => "SSL/TLS-stöd används redan på följande mål-IP: %1 Därför kunde inte följande domäner med SSL/TLS-stöd överföras: %2. Åtgärda problemet och försök igen",
    'chown__sitebuilder_not_installed' => 'Presence Builder är inte installerat.',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domän %1 kan inte överföras till en annan ägare eftersom Presence Builder inte är installerat.',

    'backup__backup_time' => 'Säkerhetskopieringstid',
    'backup__backup_time_hour' => 'timmar',
    'backup__backup_time_minute' => 'minuter',
    'backup__every' => 'var',
    'backup__day_of_month' => 'Dag i månad',

    'subdomain__select_hst_type' => 'Markera typ av värdtjänst för underdomänen',
    'hst_sel__subdom_subfolder_hst' => 'Subdomän på undermapp',
    'subdomain__www_root_folder_not_exists' => 'Webbplatsens katalogen %1 finns inte',
    '__site_home_dir' => 'Webbplatsens startkatalog',
    'subdomain__aspnet_disabled_domain' => 'avstängt av domän',

    'domains__remove_description' => 'Alla domändata, inklusive domän och respelktive underdomänsinnehåll och inställningar, webbprogramdata, e-postlådans innehåll, e-post, antivirus- och spam-filterinställningar, loggfiler, domänens säkerhetskopieringskatalogs data och SSL/TLS-certifikaten raderas. Om du inte har en säkerhetskopia på dina lokala dator, kommer all data att gå förlorad permanent.',
    'subdomains__remove_description' => 'Alla underdomänuppgifter, inklusive sekundärdomänens innehåll och inställningar, webbprogramuppgifter och loggfiler kommer att raderas. Om du inte har en säkerhetskopia på dina lokala dator, kommer all data att gå förlorad permanent.',

    'mail__no_relay_networks' => 'Använd inga vidaresändningsbegränsningar för följande nätverk:',
    'mail__tabs_spam_filtering' => 'Skräppostfiltrering',
    'mail__tabs_antivirus' => 'Antivirus',
    'server_mail__usage_policy_legend' => 'Användningspolicy',
    'server_mail__for_incoming_mail' => 'för inkommande e-post',
    'server_mail__for_outgoing_mail' => 'för utgående e-post',
    'server_mail__antivirus_direction_off' => 'Scanning avstängd',
    'server_mail__antivirus_direction_any' => 'Skanna både inkommande och utgående e-post',
    'server_mail__antivirus_direction_from' => 'Skanna endast utgående e-post',
    'server_mail__antivirus_direction_to' => 'Skanna endast inkommande e-post',
    'antivirus__use_server_settings_scan' => 'Använd serveromfattande standardinställningar (scanna)',
    'antivirus__use_server_settings_no_scan' => 'Använd serveromfattande standardinställningar (scanna inte)',
    'antivirus__check_for_viruses' => 'Scanna efter virus',
    'antivirus__dont_check_for_viruses' => 'Scanna inte efter virus',
    'antivirus__incoming_mail' => 'Inkommande',
    'antivirus__outgoing_mail' => 'Utgående post',

    'domain_alias__CNAME_dns_record_exists' => 'DNS CNAME-post med sådant namn finns redan',
    'domain_alias__A_dns_record_exists' => 'DNS A-post med ett sådant namn finns redan.',
    'domain_alias__bad_prefix' => 'Felaktigt prefix för domänalias',
    'domain_alias__domain_doesnt_exist' => "Domänen finns inte",

    'dns__zone_ttl_message_info' => 'Om TTL-värdet inte anges så kommer TLL-värdet i SOA-postmallen (%1) att användas för denna DNS-post.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "En fil med namnet index.html kommer att skapas för omdirigering till valt webbprogram. Om en fil kallad index.html redan finns, kommer den att säkerhetskopieras som index.html.old och ersättas av den nya. Tryck på OK för att bekräfta",

    'bt_ftp_ctrl' => "Extra FTP-konton",
    'ftp_users_no_permission' => "Du har inte behörighet att hantera FTP-konton för denna domän.",
    'ftp_users_limit_reached' => "FTP-kontogränsen har nåtts för denna domän",
    'pb__ftp_ctrl' => "FTP-hantering",
    'class_client__max_subftp_users' => "Extra FTP-konton",

    '__client_form_settings' => "Kundinställningar",
    '__sbnet_client_keep_sbnet' => "Behåll motsvarande användarkonto i Presence Builder",
    '__sbnet_cant_add_more_sites' => "Gränsen för antalet webbplatser som kan använda Presence Builder har nåtts för denna kund",
    '__sbnet_legend_text' => "Presence Builder-integration",
    '__sbnet_synchronize_user_with_sbnet' => "Skapa ett motsvarande användarkonto i Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Du försöker ta bort ett Presence Builder-användarkonto som är associerat med denna kund. Detta raderar alla användarens webbplatser och alla andra relevanta inställningar från Presence Builder-systemet för att ta bort förmågan att redigera befintliga webbplatser genom Presence Builder, även om du sätter på detta tillval igen senare. Om du skapar ett Presence Builder-användarkonto igen senare, måste du skapa och publicera alla webbplatser från början. Vill du stänga av webbplatsskapandet och publicera via Presence Builder?",
    'sb__build_site_with_subdomains' => "Skapa blogg- och fotogallerisubdomäner",
    '__sbnet_client_dont_have_sbuser' => "Kan inte skapa och publicera webbplatsen med hjälp av Presence Builder: Presence Builder-användaren finns inte",

    '__component_disabled' => "Komponent avstängd",

    'subdomains__physical_path_not_exist' => "Det finns subdomäner länkade till ej existerande fysiska kataloger",

    'dnsserver_bind_to_msdns_switching_warning' => "Varning: endast de första 254 IP-adresserna av subnätet med /8 och /16 masker i Åtkomstkontrollistan kommer att överföras. De överförs som separata IP-adresser. Vill du fortsätta?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder-siter kan behöva ASP.NET 2.0 stöd på din domän. Vi rekommenderar att aktivera ASP.NET 2.0-stöd om du använder Presence Builder.",

    'subdomain_auto_create_dir' => "Skapa fysisk katalog för subdomän",

    'sa_trainer__unable_to_get_messages_list' => "Kan inte få listan med meddelanden i e-postlådan: %1",
    'sa_trainer__pass_doesnt_exist' => "Lösenordet för detta e-postkonto saknas",

    '__sitebuilder_error' => "Ett fel inträffade under anslutningsförsöket till Presence Builder. Kontakta din serverleverantör för assistans.",
    'wsb_error_user_not_exist' => "Detta Presence Builder-användarkonto finns inte.",
    'wsb_error_site_already_exist' => "Denna site finns redan i Presence Builder.",
    'wsb_error_site_limit_reached' => "Gränsen för antal Presence Builder-siter har nåtts.",
    'wsb_error_internal_error' => "Internt Presence Builder-fel uppstod: Kontakta din serverleverantör för assistans.",
    'wsb_error_user_already_exist' => "Presence Builder-användare med sådant namn finns redan i Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder-användaren finns inte.",
    'wsb_error_object_not_found' => "Presence Builder kunde inte hitta korrekt värddatoringång.",

    'mg_no_mail_groups' => "Inga e-postgrupper",

    'drweb__drweb_incoming' => 'Antiviruskontroll för inkommande e-post',
    'drweb__drweb_outgoing' => 'Antiviruskontroll för utgående e-post',
    'drweb__disable_reason_serv' => 'E-postservern stödjer inte antivirusfilterinställningarna på e-postlådenivå',

    'vz_sitebuilder3_client_cant_be_created' => "Kan inte skapa kundkonto: SiteBuilder version 3.1 eller senare har inte installerats",

    'chown__client_without_sitebuilder_support' => "Det går inte att fortsätta abonnemangsöverföringen: Presence Builder-tjänsten är inte inkluderad i den nya ägarens eller leverantörens tjänsteplan.",

    // new limits

    'class_client__max_odbc' => "ODBC-anslutningar",
    'cl_perm__max_odbc' => "maximalt antal ODBC-anslutningar",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Domänens aliasnamn',
    'domain_alias__list_ascii_name' => 'I ASCII-format',


    // Interface Customization Templates
    'interface_preferences' => 'Gränssnittshantering',
    'pb__interface_templates' => 'Gränssnittshantering',
    'pb__interface_clients' => 'Kunder som använder %1',

    // service management
    'bt_service_showall' => "Visa alla",
    'bt_service_hideall' => "Dölj alla",
    'bt_service_start' => "Start",
    'bt_service_stop' => "Stopp",
    'bt_service_restart' => "Omstart",
    'bt_service_disable' => "Stänga av",
    'bt_service_manual' => "Manuell",
    'bt_service_auto' => "Auto",
    'comp_info__statup_type' => 'Startmetod',
    'service_startup_auto' => 'Automatisk',
    'service_startup_manual' => 'Manuell',
    'service_startup_disabled' => 'Avstängd',
    'service_action_ok' => "Åtgärden med %1 tjänsten slutfördes korrekt",
    'service_action_failed_disabled_service' => "Kunde inte slutföra åtgärden med %1 tjänsten eftersom den är avstängd",
    'service_action_failed_error' => "Det gick inte att slutföra åtgärden: %1",
    'service_group_action_ok' => "Åtgärden med följande tjänster slutfördes korrekt: \n %1",
    'service_group_action_disabled' => "Kunde inte slutföra åtgärden med följande tjänster eftersom de är avstängda: \n %1",
    'service_group_action_failed' => "Kan inte slutföra åtgärden med följande tjänster: \n %1. \nFör att ta emot detaljerad felinformation, utför åtgärden med varje tjänst separat",

    // php 4vs5
    'bt_php' => "PHP-inställningar",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Tillgängliga återförsäljare',
    'massmail__resellers_list_selected' => 'Markerade återförsäljare',
    'massmail__clients_list_available_for_select' => 'Tillgängliga kunder',
    'massmail__clients_list_selected' => 'Markerade kunder',
    'massmail__advanced' => 'Avancerat',
    'bt_massmail_send' => 'Skicka',
    'massmail__save_template_name' => 'Spara texten på den nya mallen som namngivits',
    'massmail__template' => 'Mall',
    'massmail__compose_mail' => 'Meddelande',
    'massmail__from' => 'Från',
    'massmail__to' => 'Till',
    'massmail__subject' => 'Ämne',
    'massmail__body' => 'Meddelandetext',
    'massmail__body_hint' => 'Använd <name>-variabeln för att automatiskt infoga användarens namn i ditt meddelande.',
    'massmail__send_to_clients' => "Kunder",
    'massmail__send_to_domainusers' => "DomänAdministreraistratörer",
    'massmail__send_to_admins' => "Plesk Administratörer",
    'massmail_select' => 'Markera adresser',
    'massmail_showhide_selected' => "Visa/dölj markerade",
    'massmail_send_all' => "Alla",
    'massmail_send_selected' => "Endast markerade",
    'massmail_send_except' => "Alla utom markerade",
    'bt_new_mass_mail_template' => "Lägg till e-postmall för massutskick",
    '__mass_mail_templates_list' => "Lista över e-postmeddelandemallar för massutskick",
    'massmail__template_name' => 'Mallnamn',
    'massmail__receivers' => 'Mottagare',
    'massmail__created' => 'Avsändare',
    'massmail__date_created' => 'Skapandedatum',
    'massmail__compose' => 'Skicka',
    'mass_mail__resellers_all' => 'Alla återförsäljare',
    'mass_mail__clients_all' => 'Alla kunder',
    'mass_mail__domainusers_all' => 'Alla domänadministratörer',
    'mass_mail__resellers_selected' => 'Markerade återförsäljare',
    'mass_mail__clients_selected' => 'Markerade kunder',
    'mass_mail__domainusers_selected' => 'Markerade domänadministratörer',
    'mass_mail__resellers_except' => 'Alla återförsäljare utom markerade',
    'mass_mail__clients_except' => 'Alla kunder utom markerade',
    'mass_mail__domainusers_except' => 'Alla domänadministratörer förutom markerade',
    'mass_mail__admins_all' => 'Alla administratörer',
    'massmailtemplateslist__title' => 'E-postmeddelandemall för massutskick',
    'massmail__insert_from_template' => "Mata in data från mall",
    'massmail__select_template' => "Välj mall",
    'massmail__body_short_hint' => "(endast oformaterad text)",
    'massmail__from_short_hint' => "(e-post eller namn)",
    'bt_insert' => "Infoga",
    'massmail__mail_send_successfully' => "Meddelandet har skickats korrekt.",
    'massmail__mail_send_successfully_with_some_errors' => "Meddelandet skickades ut, men flera fel hittades.  Några av mottagarna kan inte få meddelandet. För ytterligare information, se följande loggfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Meddelandet har inte skickats. Försäkra dig om att minst en mottagare har valts och att Plesks e-postserver fungerar korrekt. För ytterligare information, se följande loggfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Uppgifterna från mallen %1 har matats in korrekt.",
    'massmail__template_added_successfully' => "Meddelandemallen sparades med namnet %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder-fel uppstod. Kontakta din serverleverantör för assistans.",
    'wsb_error_sitebuilder_access_denied_error' => "Kan inte få tillgång til filen: Presence Builder har inga åtkomsträttigheter till den begärda filen eller mappen. Kontakta din serverleverantör för assistans.",
    'wsb_error_sitebuilder_connection_failed' => "Det gick inte att ansluta till Presence Builder eftersom anslutningen bröts. Kontakta din serverleverantör för assistans.",
    'wsb_error_critical_during_operation' => "Kritiskt Presence Builder-fel uppstod:\n%1",
    'wsb_error_license_during_operation' => "Presence Builder-fel uppstod:\n%1",
    'wsb_error_during_operation' => "Presence Builder-fel uppstod:\n%1",
    'wsb_error_license_error' => "Presence Builder-licensbegränsning hittades.",

    // Other
    '__confrim_service_stop' => "Varning! Om du avbryter tjänsten %1, kan Plesk upphöra att fungerar. Är du säker på att du vill stoppa tjänsten %1?",
    'virtualdir__name_is_reserved' => "Detta namn är reserverat",
    'index_redirect_help_text' => 'Nu kommer du automatiskt att omdirigeras till begärd webbplats. Om webbläsaren inte stödjer omdirigering, klicka på %1 här %2',
    'bt_default_settings' => "Återställ standardvärden",
    'logfiles__remove_failed' => "Kan inte radera fil %1: filen är låst av ett annat program. Försök igen senare",
    'subdomain__invalid_homedirectory' => "Den specificerade underdomänens startkatalog är ogiltig",
    'scheduler_item__empty_filename' => "Specificera den utförbara filen att köra",
    'subdomains__overlapped_domain_exists' => 'Subdomän överlappas av DNS-zon av domän %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomän överlappas av DNS-zon av domänalias %1',
    'services_action_none_selected' => 'Kunde inte slutföra åtgärdemn: välj begärda tjänster',
    'cl_perm__max_subftp_users' => "maximalt antal extra FTP-konton",
    'login_up__access_denied_no_cp_access' => 'Åtkomst nekad. Du saknar behörighet att söka åtkomst till Plesk.',
    'drweb__disable_reason_admin' => "Antivirusfilterinställningar på e-postkontonivå tillåts inte av serverpolicyn.",

    'webdirs__name_is_invalid' => 'Använd endast alfanumeriska tecken, understrykningstecken och bindestreck i katalognamn.',
    'webdirs__physical_path_is_invalid' => 'Den fysiska sökvägen är ogiltig eller existerar inte',
    '__use_default' => 'Använd standard',
    'branding_pagetitle' => 'Branding-inställningar',
    'fieldset_titlebar_setup' => "Titel på Plesk-sidor",
    'use_custom_titlebar' => "Rubriktext",
    'odbc__dsn_list_legend' => 'ODBC DSN-anslutningar',

    'webalizer_preferences__title' => 'Webbstatistikinställningar',
    'webalizer_preferences__tab_hidden_referrers' => 'Dolda referenter',
    'webalizer_preferences__tab_group_referrers' => 'Grupperade referenter',

    'webalizer_hidden_referrer__edit_title' => 'Egenskaper dold post',
    'webalizer_hidden_referrer__edit_legend' => 'Dolda poster',
    'webalizer_hidden_referrer__referrer_type' => 'Transaktionstyp',
    'webalizer_hidden_referrer__referrer' => 'Referent',
    'webalizer_hidden_referrer__list_header' => 'Dolda referenter',
    'webalizer_hidden_referrer__list_legend' => 'Dolda referenter',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Direkt förfrågan',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Referent',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Inga poster valda',
    'webalizer_hidden_referrer__remove_title' => 'Följande referenter kommer inte längre vara dolda:',
    'webalizer_hidden_referrer__already_exist' => 'En sådan post finns redan.',

    'webalizer_group_referrer__list_header' => 'Gruppreferenter',
    'webalizer_group_referrer__list_legend' => 'Gruppreferenter',
    'webalizer_group_referrer__edit_title' => 'Hänvisarens gruppegenskaper',
    'webalizer_group_referrer__edit_legend' => 'Hänvisarens gruppegenskaper',
    'webalizer_group_referrer__group' => 'Grupp',
    'webalizer_group_referrer__referrer' => 'Referent',
    'webalizer_group_referrer__already_exist' => 'En grupphänvisning med samma namn finns redan.',
    'webalizer_group_referrer__remove_empty_selection' => 'Inga referenter valda',
    'webalizer_group_referrer__remove_title' => 'Följande referentsiter kommer att avgrupperas:',

    'pb__dashboard' => 'Hem',

    'server_interface__page_title' => 'Servergränssnittsinställningar',
    'server_interface__tabs_locales' => 'Språk',
    'server_interface__tabs_skins' => 'Skalutseenden',
    'server_interface__tabs_interface_templates' => 'Gränssnittsmallar',
    'bt_server_interface' => 'Gränssnittsinställningar',
    'pb__server_interface' => 'Gränssnittsinställningar',

    'bt_wizard_next' => 'Nästa>>',
    'bt_wizard_prev' => '<< Tillbaka',

    '__limit_exceeded_max_dom_server' => 'Du kan inte värdbasera fler domäner i denna server eftersom gränsen för antalet domäner som tillåts i servern av licensnyckeln har nåtts. Kontakta din serviceleverantör för att lösa detta problem.',
    '__limit_exceeded_max_subdom_server' => 'Du kan inte vara värd för fler underdomäner på denna server. Kontakta din internetleverantör.',
    '__limit_exceeded_max_dom_aliases_server' => 'Du kan inte konfigurera fler domänalias på den här servern. Kontakta din internetleverantör.',
    '__limit_exceeded_max_wu_server' => 'Du kan inte skapa fler webbanvändare eftersom gränsen för antal webbanvändare som tillåts på servern av licensnyckeln har uppnåtts. Kontakta din serviceleverantör för att lösa detta problem.',
    '__limit_exceeded_max_mn_server' => 'Du kan inte skapa fler e-postkonton eftersom gränsen för antalet e-postkonton som tillåts av licensnyckeln har nåtts. Kontakta din serviceleverantör för att lösa detta problem.',

    '__limit_exceeded_max_cl_useradmin' => 'Du har nått gränsen för antalet kundkonton som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Du har nått den gräns för antalet domäner som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Du har nått den gräns för antal subdomäner som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Du har nått gränsen för antalet dmänalias som definieras av din licensnyckel (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Du har inget ledigt diskutrymme kvar',
    '__limit_exceeded_max_wu_useradmin' => 'Du har nått gränsen för antalet webbanvändarkonton som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Du har nått den gräns för antalet databaser som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Du har nått gränsen för antalet e-postlådor som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Du har nått gränsen för antalet e-postkonton som definieras av din licensnyckel (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Du har nått den gräns för antalet e-postlistor som definieras av din licensnyckel (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Du har nått gränsen för antalet domäner (%2).',
    '__limit_exceeded_max_subdom_userclient' => 'Du har nått gränsen för antalet underdomäner (%2) som tillåts av din tjänsteleverantör',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Du har nått gränsen för antal dmänalias (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Du har nått diskutrymmets användningsgräns (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Du har nått gränsen för bandbreddsanvändning per månad (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Du har nått gränsen för antalet webbanvändare (%2) som tillåts av din tjänsteleverantör.',
    '__limit_exceeded_max_db_userclient' => 'Du har nått gränsen för antalet databaser (%2).',
    '__limit_exceeded_max_box_userclient' => 'Du har nått gränsen för antalet brevlådor %2.',
    '__limit_exceeded_max_maillists_userclient' => 'Du har nått gränsen för antal e-postlistor (%2)',
    '__limit_exceeded_expiration_userclient' => 'Ditt konto gick ut den %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Du har nått gränsen för antalet underdomäner (%2) som tillåts av din tjänsteleverantör',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Du har nått gränsen för antal dmänalias (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Du har nått diskutrymmets användningsgräns (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Du har nått gränsen för använd bandbredd per månad (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Du har nått gränsen för antalet webbanvändarkonton /(%2)',
    '__limit_exceeded_max_db_userdomain' => 'Du har nått gränsen för antalet databaser (%2).',
    '__limit_exceeded_max_box_userdomain' => 'Du har nått gränsen för antalet brevlådor %2.',
    '__limit_exceeded_max_maillists_userdomain' => 'Du har nått gränsen för antal e-postlistor (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Ditt konto gick ut den %2',

    'mmt__to_none' => 'Ingen',
    'mmt__to_admin' => 'Administratör',
    'mmt__to_resellers_all' => 'Alla återförsäljare',
    'mmt__to_resellers_select' => 'Markerade återförsäljare',
    'mmt__to_resellers_select__available' => 'Tillgängliga återförsäljare',
    'mmt__to_resellers_except' => 'Alla återförsäljare utom markerade',
    'mmt__to_clients_all' => 'Alla kunder',
    'mmt__to_clients_select' => 'Markerade kunder',
    'mmt__to_clients_select__available' => 'Tillgängliga kunder',
    'mmt__to_clients_except' => 'Alla kunder utom markerade',

    'mmt__unable_send_empty_selection' => 'Kan inte skicka e-postmeddelanden med massutskick: ingen e-postadress har valts.',
    'mmt__unable_send_to__' => 'Kan inte skicka e-postmeddelanden med massutskick till:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Kan inte validera webbprogrammet eftersom en av de begärda filerna (%1) inte hittades. Kontakt din tekniska supportrepresentant för hjälp.',
    'sapp_error_validation_spec_failed' => 'Det uppladdade webbprogrammet uppfyller inte specifikationerna för AppPacks: %1.',
    'sapp_error_validation_register' => 'Kan inte registrera webbprogrammet i katalogen "%1": %2 Du ska ta bort webbprogrammet från servern eftersom det inte kommer att fungera riktigt.',

    'sapp__install_failed' => 'Webbprogrammets installation misslyckades: %1',
    'sapp__install_res_failed' => 'Det gick inte att skapa begärd resurs.',

    'server_preferences__subdomains_blog_and_photo' => 'Skapa blogg- och fotogallerisubdomäner som standard',
    'firewall__info' => 'Av säkerhetsskäl, blockerar den brandväggen alla anslutningar förutom de som uttryckligen tillåts. Du kan tillåta en anslutning genom att skapa en regel. Se dokumentationen för ytterligare information',
    'plesk_key__blog_and_photo' => 'Förmåga att hantera standardtillståndet för Skapa blogg- och Fotogalleri-subdomänkryssrutan',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Kan inte ändra IP-adresstypen till dedikerad, eftersom den är tilldelad fler än en användare.',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "Kan inte fastställa TCP portnummeret användt av  Microsoft SQL server '%1': TCP/IP protokollet är inte aktiverad i server nätverk konfigurationen eller servern är konfigurerad till att använda dynamiska TCP protokoller. \nFör att tillåta dina kunder att automatisk konfigurera brandvägg för fjärråtkomst till databasen, konfigurera SQL Servern manuellt till att lyssna på en specifik fast TCP port.",
    '__local_server_mssql' => 'Lokal MS SQL-server',
    'pb__db_server_databases' => 'Databasserverhantering',

    '__write_modify_warning' => 'När du väljer ytterligare skriv-/ändringstillstånd kommer vissa webbapplikationer att fungera riktigt, men ökar också säkerhetsriskerna betydligt',
    '__write_modify_subdomain_warning' => 'När du väljer ytterligare skriv-/ändringstillstånd kommer vissa webbapplikationer att fungera riktigt, men ökar också säkerhetsriskerna betydligt',

    'phosting__php_incorrect_version_used' => "PHP-versionsproblem detekterade. För att lösa dessa problem, markera kryssrutan med nödvändig PHP-version nedan och klicka på OK. För att stänga av PHP på denna domän, klicka på OK utan att välja PHP-version",
    'fp__mail_preferences' => 'Inställningar för e-post',

    'mail__specify_patterns' => 'E-postadresser',
    'mail__specify_patterns_with_ip' => 'E-post eller IP-adresser',
    'mail__blocker_action_text' => 'Vad man gör med e-postmeddelanden som uppfyller kriterierna:',
    'mail__action_delete' => 'Ta bort från servern',
    'mail__action_spam' => 'Mark som skräppost',
    'mail__action_with_mails' => 'Action',
    'mail__white_list_action_text' => 'Email addresses specified here will not be recognized as spam by SpamAssassin.',
    'mail__smtp_white_list_action_text' => 'IP-inmatningar som anges här kommer att läggas till i mail-serverns undantag.',
    'mail__invalid_white_pattern' => 'Den angivna värdet är ogiltigt. Använd följande format: mail@example.com för e-postadresser, example.com för domäner.',
    'mail__white_list__text_wildcard_pattern' => 'IP-adresser kan innehålla jokertecken (till exempel: 123.123.*.123).',
    'mail__white_list__text_cidr_pattern' => 'IP-adresser kan innehålla CIDR-masker (till exempel: 10.0.0.0/8).',
    'mail__invalid_black_pattern' => 'Den angivna värdet är ogiltigt. Använd följande format: mail@example.com för e-postadresser, example.com för domäner.',
    'mail__black_list_no_sa_warning' => 'Poster kommer inte att markeras som skräppost eftersom SpamAssassin inte är installerat eller avstängt',
    'mail__smtp_white_list__text_hint' => 'Separera flera adresser med ny med ett kommatecken eller en semikolon. Det får inte finnas några icke-ASCII-tecken till vänster om @-tecknet. Adresser kan innehålla jokertecknen "*" och "?" (exempelvis *@domain.com, användare?@*.com). Icke-ASCII-delar av domännamn får inte innehålla jokertecken.',

    'resp_edit__reply_as_html' => 'Skicka som HTML',
    'exception__path_very_long' => "Sökvägen är för lång. Se till att det finns färre än %1 tecken i sökvägen.",

    // 8.2


    //SAPP
    'sapp_on' => 'På',
    'sapp_off' => 'Av',
    'sapp_directive_aspect' => 'Obligatoriskt',
    'sapp_databases_num' => 'DatabaVisar',
    'sapp_db_required' => 'Obligatoriskt',
    'sapp_Required' => 'Obligatoriskt',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Databas-ID',
    'sapp_db_id_type' => 'DB (id: %1) typ',
    'sapp_db_id_min_version' => 'DB (id: %1) min.-version',
    'sapp_db_id_table_prefix' => 'DB (id: %1) tabellprefix',
    'sapp_Default' => 'Standardvärde',
    'sapp_apache_mod_req' => 'Apache-modul',
    'sapp_dbtype_not_installed' => 'inte installerat',
    'sapp_apache_mod_not_installed' => 'inte installerat',
    'sapp__value_error_empty' => 'Tomma värden är inte tillåtna.',
    'sapp_error_invalid_type' => 'Programmet "%1" stödjer inte begärd åtgärd.',
    'sapp_error_unknown_app_type' => 'Inget stöd för applikationstypen: %1.',
    'sapp__ssl_text' => 'Installera programmet i "http://" eller "https://" virtuell värddator?',
    'sapp__app_to_upgrade' => 'Program att uppgradera',
    'sapp__upgrade_apps_title' => 'Uppgradera program',
    'sapp__upgrade_to_ver' => 'Uppgradera till version',
    'sapp__choose_pkg_ver' => 'Markera ett paket...',
    'sapp__pkg_cant_upgrade_pkg' => 'Paketet "%1" kan inte användas för uppgradering av webbprogrammet "%2".',
    'sapp__app_ugrade_error' => 'Kan inte uppgradera programmet: %1. Kontakta din systemadministratör.',
    'sapp__no_suitable_db_found' => 'Ingen lämplig databas hittades.',
    'sapp__upgrade_success' =>  'Programmet har uppgraderats korrekt.',
    'sapp__pkg_info_changelog' => 'Ändringshistorik',
    'sapp_requirement_legend' => 'Värdtjänstfunktioner som krävs av programmet',

    // other
    'odbc__mssql_wsid' => 'Arbetsstations-ID',
    'odbc__mssql_driver' => 'Drivrutin',
    'bt_apply' => 'Använd',
    'tsclient_disabled' => 'Du har inte behörighet att komma åt systemet via fjärrskrivbordet',
    'mn_edit__add_alias_if_mailbox_disabled' => 'För att skapa en e-postalias, måste e-postlådan sättas på i detta e-postkonto. Slå på e-postkontot?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Avstängningen av e-postlådan kommer att ta bort e-postaliaserna eftersom de kommer att sluta fungera. Stänga av e-postkontot?',
    'odbc__mysql_driver' => 'MySQL ODBC-drivrutin',
    'antivirus__disable_reason_install' => 'Du kan inte hantera antivirus eftersom det inte är installerat.',
    'antivirus__disable_reason_key' => 'Du kan inte hantera antivirus eftersom det inte är aktiverat med en korrekt licensnyckel.',
    'antivirus__disable_reason_deny_personal_settings' => 'Du kan inte hantera antivirus eftersom serverpolicyn förbjuder individuella antivirus-inställningar.',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => 'Ändra lösenord',
    'change_foreign_user_password_hint' => "Användaren tillhör inte programmet. Klicka på länken för att gå till ett annat program och ändra användarlösenordet där. För att göra det, måste du ha rätt behörigheter i programmet.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Strängformat',
    'lang_unknown' => 'Okänt språk',
    'odbc__access_driver' => 'Drivrutin',
    'odbc__access_pwd' => 'Lösenord',
    'odbc__access_uid' => 'Inloggnings-ID',
    'odbc__excel_driver' => 'Drivrutin',
    'pb__cl_ed' => 'Kundinformation',
    'pb__actionlog' => 'Åtgärdslogg',
    'pb__cl_limits' => 'Kundgränser',
    'pb__edit' => 'Redigera',
    'pb__subdom_edit' => 'Värdtjänst-inställningar',
    'cf__select_dsn_to_remove' => 'Markera minst en DNS som du vill ta bort',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => 'Att processa reglerna för detta portintervall kan ta lång tid.\\nVill du fortsätta?',
    'firewall__port_range_exceeds_limit' => 'Angivet portintervall överstiger det tillgängliga portintervallvärdet på %1',

    'backup_mail_content' => 'Säkerhetskopiera innehållet på e-postkonton',

    'maillist_import_result' => "Totalt antal e-postadresser i filen: %1\nmängd importerade e-postadresser: %2\nmängd redan befintliga e-postadresser: %3\nmängd duplicerade e-postadresser i den specificerade filen: %4\nmängd ogiltiga e-postadresser i filen: %5",
    'maillist_import_error' => 'Kan inte importera e-postadresslistan',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Filen du valt är antingen tom eller inte ett giltigt HTML-dokument i den valda kodningen. Välj rätt kodning eller lägg bara till innehåll till filen.",

    'dom_pref__external_mail_srv' => "Omdirigera till extern e-postserver med IP-adress:",
    'mn_edit__store_messages' => 'E-postkonto',

    // aps

    'sapp__before_upgrade_notice' => 'Det rekommenderas att backa upp programmet och användaruppgifterna innan du startar uppgraderingsprocessen.',
    'sapp__application_properties' => 'Programegenskaper',
    'sapp__application_root_descr' => 'Programmets huvudsida',

    'sapp__aps_license_invalid_id' => 'Licensnyckeln har ogiltigt ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Licens med nyckelnumret %1 finns redan i databasen.',
    'sapp__aps_lic_del_used' => 'Kan inte radera licensnyckeln. Den används av ett installerat program.',
    'sapp__aps_lic_del_unknown' => 'Det går inte att ta bort licensnyckeln: %1',
    'sapp__aps_cappi_duplicate' => "Detta program finns redan i kundens programpool",
    'sapp__appi_not_shared_no_install' => "Det finns inget sådant program i kundens programpool. Om du vill installera detta program på din webbpats, ska du först lägga till programmet till kundens programpool.",
    'sapp__appi_shared_not_client' => "Det finns inget sådant program i kundens programpool. Om du vill uppgradera programmet till den specificerade versionen, ska du först lägga till programmet till kundens programpool.",
    'sapp__apply_license_script_not_found' => 'Kan inte hitta skriptet "tillämpa licens" för detta webbprogram.',
    'sapp__unable_to_activate_key' => 'Ett fel uppstod under ett försök att aktivera en licensnyckel: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Det finns installerade webbprogram som kräver att detta webbprogram finns i systemet.',
    'sapp__unable_to_delete_ai_in_pool' => 'Detta program finns redan i kundens pool Om du vill ta bort detta program, måste du först ta bort det från alla kunders programpooler eller göra den gratis.',
    'sapp__unable_to_delete_app_template' => 'Kan inte ta bort Java-programmet #%1: %2',
    'sapp__limit_exceeded_client' => 'Du har nått gränsen för antalet gånger du kan installera detta webbprogram (%2).',


    // atis module

    '_week_on' => 'vecka på',
    '__week_first' => 'första',
    '__week_second' => 'sekund',
    '__week_third' => 'tredje',
    '__week_fourth' => 'fjärde',
    '__week_last' => 'sist',
    '__not_started' => 'Väntar',
    '__started' => 'Körs',
    '__cancel_pending' => 'Raderar',
    '__canceled' => 'Avbruten',
    '__error' => 'Fel',
    '__done' => 'Klart',

    '__php_cgi_handler' => 'CGI-program',
    '__php_isapi_handler' => 'ISAPI-tillägg',
    '__php_fastcgi_handler' => 'FastCGI-program',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'Kör som',

    'firewall_tabs_rules' => 'Brandväggsregler',

    'cf_dbfolder_text' =>'Databasmapp',
    'cf_isnewdb_text' => 'Skapa databas',
    'cf_isnewdb_title' => 'Markera kryssrutan om databasen måste skapas.',

    'pb__site_apps_upgrade' => 'Webbprogram uppgradering',

    'detach' => 'Koppla från',
    'preferences' => "Ändra lösenord",

    'toolsbar__switch_user?' => "Är du säker på att du vill logga in till en annan användares kontot?",
    '__aps_left' => 'Installationer kvar',
    'aps__license_key' => 'Licensnyckel',
    'aps__download_code' => 'Licensnyckelnedladdning och aktiveringskod',
    'aps__license_key_hint' => 'Hämta från licensieringsservern med aktiveringskoden',
    'aps__database_not_available' => 'inte tillgänglig, vänligen kontrollera domänen eller kundgränserna',
    'aps__yes' => 'ja',
    'aps__no' => 'nej',
    '__click_to_enlarge' => 'Klicka om du vill förstora',
    'site_apps__back_to_list' => 'Tillbaka till listan',
    'sapp__pkg_info_installation_requirements' => 'Installationskrav',
    '__close_window' => 'Stäng',

    //SAPP END

    'skin_info__already_default' => 'Skalet är redan satt som standard.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus-inställningar för %1',
    'drweb:properties_legend' => 'Inställningar',
    'drweb:status' => 'Kontrollera om det finns virus i e-posten',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder-installationsguide',
    'dom_site_builder' => 'Klicka för att öppna Presence Builder-guiden.',
    'sb_plesk_admin_url' => 'Presence Builders server-URL. Säkerställ att denna adress kopplar ordentligt i DNS',
    'sb_plesk_admin_login' => 'Användarnamn för serveradministratörinloggning i Presence Builder',
    'sb_plesk_admin_password' => 'Administratörslösenord',
    'sb_sitebuilder_preferences' => 'Presence Builder-administratörens inloggningsuppgifter',
    'sb__server' => 'Presence Builder systemadministratörsinställningar',
    'sb__sitebuilder_support' => 'Presence Builder-stöd',
    'sb_keep_sb_user' => 'Behåll motsvarande användarkonto i Presence Builder',
    'sb_create_sb_user' => 'Skapa ett motsvarande användarkonto i Presence Builder',
    'sb__build_site_using_sitebuilder' => "Skapa en webbplats med Presence Builder",
    'sb_no_current_sb_server_set' => 'Anslutningen till Presence Builder har inte konfigurerats ännu: du behöver lägga till en A-post i DNS zonmallen som pekar mot Presence Builder-servern.',
    'sb_unable_update_sb_server_sb_return_message' => "Det gick inte att hämta informationen från Presence Builder-systemet:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Det gick inte att ansluta till Presence Builder: Fel användarnamn eller lösenord.",
    'sb_init_sb_manager' => "Initierar Presence Builder manager: %1",
    'sb_err_couldnt_connect_sb' => "Lyckades inte ansluta till Presence Builder-systemet.",
    'sb_err_client_dont_have_sbuser' => "Denna kund har inget användarkonto i Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder är inte konfigurerat.",
    'sb_err_you_dont_have_sbaccount' => "Lyckades inte ge dig behörighet i Presence Builder.",
    'sb_error_critical_during_operation' => "Följande fel uppstod i Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Stöd för enkel inloggning är inte påslaget i Plesk.",

    'forbid_create_dns_subzone' => "Förbjud användare att skapa DNS-subzoner i andra användares DNS-superzoner",
    'warning__super_zone_exist' => "Zonen %1 skapades, men detta zonnamn är en undderzon för en redan existerande zon %2, sm tillhör en annan användare %3. Det är möjligt, men se till att du har valt korrekt användarkonto.",
    'error__super_zone_exist' => "Kan inte skapa DNS-zonen eftersom dess superzone tillhör en annan användare.",

    'locales__files_not_exits' => 'Kan inte ändra språkversion: det angivna gränssnittsspråkets paketfiler finns inte i systemet.',
    'locales__unavailable' => 'Kan inte ändra språkversion: det angivna gränssnittsspråkets paketfiler är inte tillgängliga.',

    // DB BU

    'pb__dbbackup_list' => 'Databasens säkerhetskopierade filer',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Temporär nätverkskatalog',
    'dbbackup__network_user' => 'Användarnamn',
    'dbbackup__network_pass' => 'Lösenord',
    // domain
    'dbbackup__add_database_legend' => 'Återställ säkerhetskopierad databas',
    'dbbackup__add_database_restore' => 'Återställ databas från säkerhetskopiefil.',
    'dbbackup__add_database_file' => 'Databassäkerhetskopia',
    'dbbackup__add_database_user' => 'Standardanvändarnamn',
    'dbbackup__add_database_pass' => 'Standardlösenord för användaren',
    'dbbackup__add_database_pass2' => 'Lösenordsbekräftelse standardanvändare',

    'bt_dbbackup_now' => 'Säkerhetskopiera',

    'bt_repair' => 'Reparera',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Uppladdning av SQL Server-databasdumpar är förbjuden av värddatorleverantören.',

    // APS categories

    'cf_invalid_password' => 'Lösenordet får inte vara längre än 16 tecken.',
    'cf_invalid_description_length' => 'Beskrivningen får inte vara längre än 256 symboler',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-adress %1 används redan av en extern e-postserver',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP-kontots användarnamn eller lösenord är ogiltigt. Ange rätt inloggningsuppgifter för FTP-användare.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Gränsen för serienumemrändringar har nåtts. Inga fler DNS-zonsändringar kan utföras i dag.',
    'dns__zone_apply_changes' => 'Förändringar gjorda på DNS-poster är inte sparade än. De gjorda ändringarna är markerade nedan. Klicka på Ändra för att tillämpa ändringarna på DNS-zonen eller klicka på Återställ för att annullera ändringarna.',
    'dns__update_dns_zone' => 'Klicka för att spara ändringar gjorda på DNS-poster',
    'dns__revert_dns_zone' => 'Klicka för att avbryta ändringar gjorda på DNS-poster',
    'bt_revert' => 'Återställ',
    'dns__dns_zone_has_beed_updated' => 'Förändringar gjorda av DNS-poster har sparats',
    'dns__dns_zone_has_beed_reverted' => 'Förändringar gjorda av DNS-poster har annullerats',
    'db__nondefault_server_not_allowed' => 'Användning av icke-standard-databasserver är inte tillåtet',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Kundens %1 konto och domäner.',
    'ui__client__disabled-warning' => 'Kontot för kunden %1 har upphävts.',
    'ui__client__none-available' => 'Inga kundkonton har konfigurerats.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Kund %1',
    'ui__client_self__description' => 'Lista över mina domäner.',
    'ui__client_self__short-title' => 'Mina domäner',
    'ui__client_self__title' => 'Mina domäner',


    'site_apps__non_removable' => 'Poster som det inte går att ta bort',
    'site_apps__non_removable_items' => 'Följande webbprogram kunde inte tas bort:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Det finns inga anpassade knappar.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Det finns inga anpassade knappar i kundens %1 Kundpanel.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Ta bort knapp %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Ta bort',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Ta bort knapp %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Ta bort anpassade knappar från kundens Kundpanel',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Ta bort',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Ta bort anpassade knappar',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ta bort knappar',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Markera en kund vars anpassade knappar du vill ta bort och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Markera de knappar du vill ändra och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekräfta borttagning av knapparna genom att markera kryssrutan på denna skärm och klicka på Slutför.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Ta bort en anpassad knapp från kundens Kundpanel.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Ta bort',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Ta bort en anpassad knapp.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ta bort anpassad knapp',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Markera en kund vars anpassade knappar du vill ta bort och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Markera en anpassad knapp du vill ta bort och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekräfta borttagningen av den anpassade knappen genom att markera kryssrutan på denna skärm och klicka sedan på Slutför.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Redigera egenskaperna för kundnivåknapp %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Inställningar',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modifiera kundens anpassade knapp %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Lägg till anpassad knapp',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Markera en kund i vars Kundpanel du vill skapa en anpassad knapp och klicka på Nästa>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klicka på Slutför för att skapa knappen.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Ändra egenskaperna för en knapp i kundens Kundpanel.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Ändra egenskaperna för en knapp i kundens Kundpanel',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ändra egenskaperna för anpassade knapåar',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Markera en kund vars anpassade knapp du vill ändra och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Markera en anpassad knapp du vill klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'När du är färdig med att redigera egenskaperna för knappen, klicka på Slutför för att verkställa ändringarna och avsluta guiden.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Gör knappen %1 otillgänglig för dina kunder.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Gör den tillgänglig för dina kunder',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Gör knappen %1 otillgänglig för dina kunder.',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Gör knappen %1 synbar för kundens användare.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Gör den tillgänglig för dina kunder',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Gör knappen %1 synbar för kundens användare',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Göra en anpassad knapp tillgänglig/otillgänglig för din akunder.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'tillgänglig/otillgänglig för dina kunder',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'gör en anpassad knapp tillgänglig eller otillgänglig för dina kunder',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Göra en anpassad knapp tillgänglig/otillgänglig för din akunder.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Markera en kund vars anpassade knapp du vill gör tillgänglig för kundens användare och klicka på Nästa >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Väj en anpassad knapp du behöver göra tillgänglig eller otillgänglig för dina kunder och klicka på Nästa >>.',

    'ui__client/domain__description' => 'Hantera domän %1',
    'ui__client/domain__disabled-warning' => 'Domän %1 är avstängd.',
    'ui__client/domain__none-available' => 'Du har inga domäner.',
    'ui__client/domain__none-available__1' => 'Kontot %1 har inga domäner.',
    'ui__client/domain__none-available__2' => 'Kontot %1 har inga domäner.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domän: %1',
    'ui__client/domain_self__description' => 'Hantera din domän.',
    'ui__client/domain_self__disabled-warning' => 'Din domän är avstängd.',
    'ui__client/domain_self__quick-search' => 'Mina domäner',
    'ui__client/domain_self__short-title' => 'Min domän',
    'ui__client/domain_self__title' => 'Min domän',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Det finns inga anpassade knappar på kundens Kundpanelen.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Kunden %1 har inga anpassade knappar på Kundpanelen.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Det finns inga anpassade knappar för domän %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Ta bort den anpassade knappen %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Ta bort',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Ta bort den anpassade knappen %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Ta anpassade knappar.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Ta bort',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Ta bort anpassade knappar',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ta bort anpassade knappar',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Markera kunden vars domänadministratörspanel du vill ta bort knappar från och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Välj den domän från vars administrationspanel du vill ta bort knappar och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Markera de knappar du vill ändra och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Bekräfta borttagande av knapparna genom att markera respektive kryssrutor och klicka på Slutför för att ta bort knapparna och avsluta guiden.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Ta bort en anpassad knapp.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Ta bort',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Ta bort en anpassad knapp.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ta bort en anpassad knapp.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Markera kunden vars domänadministrationspanel du vill ta bort den anpassade knappen från och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Välj den domän från vars administrationspanelen du vill ta bort knappen och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Markera anpassad knapp att ändra och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Bekräfta borttagningen av den anpassade knappen genom att välja kryssrutan och klicka på Slutför för att ta bort knappen och avsluta installationsguiden.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Ändra egenskaperna för den anpassade knappen %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Egenskaper",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Ändra egenskaperna för den anpassade knappen %1 på Kundpanelen.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Lägg till en knapp',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Markera en kund i vars Kundpanel du vill placera knappen på och klicka på Nästa>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Markera abonnemang att ändra och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klicka på Slutför för att skapa knappen och avsluta guiden.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Ändra egenskaper för en knapp i Kundpanelen.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Ändra egenskaper för en knapp i Kundpanelen',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ändra knappens egenskaper',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Markera anpassad knapp, vars inställningar du vill ändra och klicka på Nästa >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'När du är färdig med att ändra egenskaperna för knappen, klicka på Slutför för att verkställa ändringarna och avsluta guiden.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Gör knappen %1 otillgänglig för e-postanvändare på denna domän.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Otillgänglig för e-postanvändare',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Gör knappen %1 otillgänglig för e-postanvändare på denna domän',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Gör knappen %1 synbar för e-postanvändare på domänen.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Tillgänglig för e-postanvändare på denna domän',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Gör den anpassade knappen %1 synbar för e-postanvändare på denna domän',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tillgängligt/otillgängligt för andra användare',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Välj en domän där knappen är placerad och klicka på Nästa >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Välj en knapp som du vill göra tillgänglig eller otillgänglig för andra användare och klick på Nästa >>.',

    'ui__client/domain/delete__description' => 'Ta bort domänen %1.',
    'ui__client/domain/delete__short-title' => 'Ta bort',
    'ui__client/domain/delete__title' => 'Ta bort domänen %1',
    'ui__client/domain/delete_multi__description' => 'Ta bort domäner.',

    'ui__client/domain/delete_multi__short-title' => 'Ta bort',
    'ui__client/domain/delete_multi__title' => 'Ta bort domäner',
    'ui__client/domain/delete_multi__wizard-title' => 'Ta bort domäner',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Välj domäner du vill ta bort och klicka på Nästa >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Bekräfta borttagning av domäner genom att markera kryssrutan, klicka sedan på Slutför för att ta bort dem och avsluta guiden.',
    'ui__client/domain/delete_unknown__description' => 'Ta bort en domän.',
    'ui__client/domain/delete_unknown__short-title' => 'Ta bort',
    'ui__client/domain/delete_unknown__title' => 'Ta bort domän',
    'ui__client/domain/delete_unknown__wizard-title' => 'Ta bort en domän',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Välj en domän du vill ta bort och klicka på Nästa >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Bekräfta borttagning av domänen genom att markera kryssrutan, klicka sedan på Slutför för att ta bort den och avsluta guiden.',

    'ui__client/domain/hosting__none-available' => 'Det finns inga domäner med konfigurerad webbvärdtjäntser. Skapa en domän och konfigurera webbvärdtjänster på den för att få tillgång till denna funktion.',
    'ui__client/domain/hosting__none-available__1' => 'Detta användarkonto har inga domäner med konfigurerade webbvärdtjänster. Konfigurera webbvärdtjänsten på begärd domän för tillgång till denna funktion.',
    'ui__client/domain/hosting__none-available__2' => 'Webbvärdtjänsten har inte konfigurerats för domän %1. Konfigurera webbvärdtjänsten på domän %1 för tillgång till funktionen.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Hantera dina filer och kataloger',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Markera domänen vars filer du vill arbeta med.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Värdtjänsten har ännu inte konfigurerats på domänen. Ställ in en fysisk värdtjänst och klicka på Nästa >> för att gå till filhanteraren.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Värdtjänsten har ännu inte konfigurerats på din domän. Ställ in den fysiska värdtjänsten och klicka på Nästa >> för att gå till filhanteraren.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'När du arbetat klart med filer och kataloger, klicka på Slutför för att avsluta guiden.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'När du arbetat klart med filer och kataloger, klicka på Slutför för att avsluta guiden.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Visa värdtjänstens prestandainställningar',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Justera webbvärdtjänstens prestandainställningar',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Markera domän för vilken du vill visa värdtjänstens prestandainställningar och klicka på Nästa >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Markera domän för vilken du vill konfigurera värdtjänstens prestandainställningar och klicka på Nästa >>.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Justera värdtjänstens prestandainställningar i domänen och klicka på Slutför.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'När du är klar med att visa värdtjänstens prestandainställningar i domänen, klicka på Slutför.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'När du är klar med att visa värdtjänstens prestandainställningar i din domän, klicka på Slutför.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'När du är klar med att visa värdtjänstens prestandainställningar i domänen, klicka på Slutför.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'När du är klar med att konfigurera värdtjänstens prestandainställningar i din domän, klicka på Slutför.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'När du är klar med att konfigurera värdtjänstens prestandainställningar i domänen, klicka på Slutför.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Kunder",
    'ui__client/domain/hosting/application#list_header__description__title' => "Beskrivning",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Föremål",
    'ui__client/domain/hosting/application#list_header__name__title' => "Namn",
    'ui__client/domain/hosting/application#list_header__release__title' => "Släppa",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sortera efter kunder",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sortera efter beskrivning",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sortera efter objekt",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sortera efter namn",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sortera efter släpp",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sortera efter version",
    'ui__client/domain/hosting/application#list_header__title' => "Webbapplikationer",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versioner",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'IP-adressen %%ip_address%% har tilldelats %%client_name%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'Användarens IP-pool är tom. Den valda IP-adressen tilldelas motsvarande användarkonto.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'Den nya domänen skapas omedelbart när du klickar på Nästa >>.',

    'ui__client/domain/properties_new__wizard-title' => 'Skapa domän',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Markera kunden som du vill skapa domänen för.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Markera önskad typ av värdbaserad tjänst och klicka på Nästa >>.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'När du konfigurerat klart vidarebefordring på domänen, klicka på Slutför för att tillämpa konfigurationen och avsluta guiden.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'När du är klar med konfigurationen av den värdbaserade tjänsten på domänen, klicka på Slutför för att tillämpa alla ändringar och stänga installationsguiden.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Ställ in domänens administratörskonto',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Markera domän för vilken du vill ställa in domänens administratörskonto.',
    'ui__client/domain/properties_unknown__wizard__3' => 'För att slutföra skapandet av domänens administratörskonto, klicka på Slutför.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'För att applicera ändringarna och avsluta guiden, klick på Slutför.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Anonym FTP-statistik för en domän',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Anonym FTP-statistik',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Anonym FTP-statistik för en domän',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'FTP-statistik för en domän',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'FTP-statistik',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'FTP-statistik för en domän',

    'ui__client/domain/report/traffic__description' => 'Visa bandbreddsanvändning av siten %1',
    'ui__client/domain/report/traffic__short-title' => 'Bandbreddsanvändning',
    'ui__client/domain/report/traffic__title' => 'Bandbredd som används av siten %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Statistik om säkra besök på siten',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Statistik på besök över SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Statistik om säkra besök på siten',

    'rpt_reseller_section_general' => 'Allmänt',
    'rpt_reseller_section_domains' => 'Domäner',
    'rpt_reseller_section_clients' => 'Kunder',
    'statistics__cl_active_domains' => "Aktiva domäner",
    'rpt_reseller_cl_domains' => "Domäner",
    'rpt_reseller_cl_subdomains' => "Subdomäner",
    'by__cl_domains' => "klients domäner",
    'dom_ctrl__cl_mboxes' => "E-postlådor",
    'rpt_reseller_cl_redirects' => "Vidarebefordrare",
    'rpt_reseller_cl_mail_groups' => "E-postgrupper",
    'rpt_reseller_cl_mail_resps' => "Autosvar",
    'rpt_reseller_cl_mail_lists' => "E-postlistor",
    'rpt_reseller_cl_web_users' => "Webbanvändare",
    'rpt_reseller_cl_data_bases' => "DatabaVisar",

    'statistics__active_clients' => 'Kunder med aktiva abonnemang',
    'statistics__clients_active_domains' => 'Aktiva domäner',
    'statistics__clients_doms' => 'Domäner',
    'statistics__cl_doms' => 'Domäner',
    '__clients_subdomains' => 'Subdomäner',
    '__clients_domains' => 'Domäner',
    'dom_ctrl__clients_mboxes' => 'E-postlådor',
    'dom_ctrl__clients_redir' => 'Vidarebefordrare',
    'dom_ctrl__clients_mg' => 'E-postgrupper',
    'dom_ctrl__clients_resp' => 'Autosvar',
    'dom_ctrl__clients_maillists' => 'E-postlistor',
    'dom_ctrl__clients_wu' => 'Webbanvändare',
    'dom_ctrl__clients_db' => 'DatabaVisar',

    'dom_ctrl__cl_redir' => 'Vidarebefordrare', // to resolve!
    'dom_ctrl__cl_mg' => 'E-postgrupper', // to resolve!
    'dom_ctrl__cl_resp' => 'Autosvar', // to resolve!
    'dom_ctrl__cl_maillists' => 'E-postlistor', // to resolve!
    'dom_ctrl__cl_wu' => 'Webbanvändare', // to resolve!
    'dom_ctrl__cl_db' => 'DatabaVisar', // to resolve!

    'rpt_cl_section_clients' => 'Kunder',

    'rpt_admin_section_general' => 'Allmänt',
    'rpt_admin_section_resellers' => 'Återförsäljare',
    'rpt_admin_section_clients' => 'Kunder',
    'rpt_admin_section_personal_clients' => 'Egna kunder',
    'rpt_admin_section_domains' => 'Domäner',
    'rpt_admin_section_personal_domains' => 'Personal domains',

    'rpt_reseller_section_personal_domains' => 'Personal domains',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Markera vilka domäner du vill upphäva eller aktivera.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Stäng av eller aktivera en domän',

    'ui__client/ip-pool__description' => 'Tilldela och avtilldela IP-adresser och SSL/TLS-certifikat för kund %1.',
    'ui__client/ip-pool__short-title' => 'IP pool',
    'ui__client/ip-pool__title' => 'Kundens %1 IP-pool',
    'ui__client/ip-pool_self__description' => 'Visa din IP-pool',
    'ui__client/ip-pool_self__short-title' => 'IP pool',
    'ui__client/ip-pool_self__title' => 'Min IP-pool',
    'ui__client/ip-pool/properties__description' => 'Ställ in IP-pool för kunden %1.',

    'ui__client/ip-pool/properties__short-title' => 'IP pool',
    'ui__client/ip-pool/properties__title' => 'Ställ in IP-pool för kunden %1',
    'ui__client/ip-pool/properties_self__description' => 'Visa din IP-pool',

    'ui__client/ip-pool/properties_self__short-title' => 'Min IP-pool',
    'ui__client/ip-pool/properties_self__title' => 'Min IP-pool',
    'ui__client/ip-pool/properties_unknown__description' => 'Tilldela eller avtilldela IP-adresser och SSL/TLS-certifikat från kunden.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP pool',
    'ui__client/ip-pool/properties_unknown__title' => 'Ställ in kundens IP-pool',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Ställ in kundens IP-pool',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Markera kunden vars IP-pool du vill konfigurera.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'När du är klar med konfigurationen av IP-poolen, klicka på Slutför för att tillämpa ändringarna och stänga installationsguiden.',


    'ui__client/limits_readonly-unknown__description' => 'Visa resursgränser för en kund.',
    'ui__client/limits_readonly-unknown__short-title' => 'Resursbegränsningar',
    'ui__client/limits_readonly-unknown__title' => 'Visa resursgränser för ett kundkonto',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Visa eller ändra resursgränser för en kund',

    'ui__client/limits_unknown__wizard-title' => 'Visa eller ändra resursgränser för en kund',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Markera kunden du behöver.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Markera kunden du behöver.',
    'ui__client/limits_unknown__wizard__2' => 'Klicka på Slutför för att tillämpa ändringarna.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Klicka på Slutför när du vill avsluta guiden.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Klicka på Slutför när du vill avsluta guiden.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Klicka på Slutför när du vill avsluta guiden.',

    'ui__client/permissions_unknown__wizard-title' => 'Visa eller ändra behörigheter för en kund',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'När du tittat klart på dina behörigheter, klicka på Slutför för att verkställa ändringarna och avsluta guiden.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Markera kunden vars berhörigheter du vill visa eller ändra.',
    'ui__client/permissions_unknown__wizard__2' => 'När du är klar med redigeringen av kundens behörigheter, klicka på Slutför för att tillämpa ändringarna och stänga installationsguiden.',

    'ui__client/preferences_unknown__wizard-title' => 'Redigera kundens preferenser',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Markera kunden vars session och gränssnittspreferenser du vill hantera.',
    'ui__client/preferences_unknown__wizard__2' => 'När du är klar med ändringen av kundens preferenser, klicka på Slutför.',
    'ui__client/preferences_unknown__wizard__2_self' => 'När du är klar med ändra dina preferenser, klicka på Slutför.',

    'ui__custom-buttons/custom-button__none-available' => 'Du har inga anpassade knappar.',
    'ui__custom-buttons/custom-button/delete__description' => 'Ta bort den anpassade knappen %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Ta bort',
    'ui__custom-buttons/custom-button/delete__title' => 'Ta bort den anpassade knappen %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Ta bort de anpassade knapparna.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Ta bort',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Ta bort anpassade knappar',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Ta bort anpassade knappar',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Markera vilka knappar du vill ta bort.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Bekräfta borttagning av knapparna genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Ta anpassade knappar.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Ta bort',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Ta bort anpassade knappar',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ta bort anpassade knappar',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Markera vilka anpasdae knappar du vill ta bort.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Bekräfta borttagning av knappen genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',
    'ui__custom-buttons/custom-button/properties__description' => 'Ändra egenskaperna för knappen %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Egenskaper',
    'ui__custom-buttons/custom-button/properties__title' => 'Ändra egenskaperna för knappen %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Skapa en knapp',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klicka på Slutför för att skapa knappen.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Ändra egenskaperna för den anpassade knappen.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Ändra egenskaperna för den anpassade knappen',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ändra egenskaperna för den anpassade knappen',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Markera den anpassade knappen vars egenskaper du vill ändra.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Klicka på Slutför för att tillämpa ändringarna.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Gör den anpassade knappen %1 otillgänglig för andra användare.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Otillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Gör den anpassade knappen %1 otillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Gör den anpassade knappen %1 tillgänglig för andra användare.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Tillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Gör den anpassade knappen %1 tillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Tillgänglig eller otillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gör den anpassade knappen tillgänglig eller otillgänglig för andra användare',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Markera den anpassade knappen du vill göra tillgänglig eller otillgänglig för andra och klicka på Nästa >>.',

    'ui__longtasks#list_header__name__title' => "Namn",
    'ui__longtasks#list_header__owner__title' => "Ägare",
    'ui__longtasks#list_header__start_time__title' => "Skapande tid",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Aktiviteter",
    'ui__longtasks#list_header__finish_time__title' => "Tid för slutförande",
    'ui__longtasks#task_list_legend__title' => "Aktiviteter",
    'ui__longtasks#tools_legend__title' => "Verktyg",
    'ui__longtasks__description' => "Hantera bakgrundsaktiviteter",
    'ui__longtasks__short-title' => "Bakgrundsaktiviteter",
    'ui__longtasks__title' => "Bakgrundsaktiviteter",
    'ui__longtasks/longtask/properties#current_operation__title' => "Aktuell åtgärd:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Uppskattad tid för slutförande:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Allmänt",
    'ui__longtasks/longtask/properties#owner__title' => "Aktiviteten har startats av:",
    'ui__longtasks/longtask/properties#progress__title' => "Förlopp:",
    'ui__longtasks/longtask/properties#start_time__title' => "Uppgiften har startat:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Task Status",
    'ui__longtasks/longtask/properties__description' => "Bakgrundsåtgärdsstatus och -information",

    'ui__longtasks/properties__description' => "Inställningar av bakgrundsaktiviteter",
    'ui__longtasks/properties__short-title' => "Inställningar",
    'ui__longtasks/properties__title' => "Bakgrundsaktiviteter",

    // updated
    'ui__mass-mail/template#list_header__title' => 'E-postmeddelandemall för massutskick',
    'ui__mass-mail/template#list_header__name__title' => 'Mallnamn',
    'ui__mass-mail/template#list_header__from_email__title' => 'Avsändare',
    'ui__mass-mail/template#list_header__to__title' => 'Mottagare',
    'ui__mass-mail/template#list_header__subject__title' => 'Ämne',
    'ui__mass-mail/template#list_header__cdate__title' => 'Skapandedatum',
    'ui__mass-mail/template#list_header__send__title' => 'Skicka',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Redigera meddelandemall för massutskick av e-post',
    'ui__mass-mail/template/properties__description' => 'Redigera denna meddelandemall för massutskick av e-post.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Lägg till e-postmall för massutskick',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Lägg till e-postmall för massutskick',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Lägg till en meddelandemall för massutskick av e-post.',
    'ui__mass-mail/send__short-title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send__title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send__description' => 'Sortera massutskick av e-postmeddelanden till valda mottagare',
    'ui__mass-mail/template/delete_multi__short-title' => 'Ta bort e-postmall för massutskick',
    'ui__mass-mail/template/delete_multi__title' => 'Ta bort dessa meddelandemallar för massutskick av e-post:',
    'ui__mass-mail/template/delete_multi__description' => 'Ta bort valda meddelandemallar för massutskick av e-post.',
    'ui__mass-mail/template/delete_multi__done' => 'Den valda meddelandemallen har tagits bort.',
    'ui__mass-mail/template/properties__invalid_values' => 'Ogiltiga värden har angetts',


    // old
    'ui__mass-mail#body_text__description' => 'Du kan använda <name>variabeln i meddelandets text (men inte i rubriken). Den ersätts med kundens eller återförsäljarens kontaktnamn.',
    'ui__mass-mail#body_text__title' => 'Meddelandetext',
    'ui__mass-mail#compose_legend__title' => 'Meddelande',
    'ui__mass-mail#from_email_text__title' => 'Från (e-post)',
    'ui__mass-mail#list_header__cdate__title' => 'Skapad',
    'ui__mass-mail#list_header__from_email__title' => 'Från',
    'ui__mass-mail#list_header__name__title' => 'Namn',
    'ui__mass-mail#list_header__send__title' => 'Skapa ett meddelande',
    'ui__mass-mail#list_header__subject__title' => 'Ämne',
    'ui__mass-mail#list_header__title' => 'E-postmeddelandemall för massutskick',
    'ui__mass-mail#list_header__to__title' => 'Till',
    'ui__mass-mail#list_legend__title' => 'E-postmeddelandemall för massutskick',
    'ui__mass-mail#load_template_text__title' => 'Läs in',
    'ui__mass-mail#name_text__title' => 'Mallnamn',
    'ui__mass-mail#option_mode_all__title' => 'Alla',
    'ui__mass-mail#option_mode_except__title' => 'Alla utom markerade',
    'ui__mass-mail#option_mode_select__title' => 'Endast markerade',
    'ui__mass-mail#option_select_template__title' => '---Välj en mall---',
    'ui__mass-mail#picker_legend__title' => 'E-postmeddelandemall',
    'ui__mass-mail#picker_title__title' => 'Välj en mall',
    'ui__mass-mail#save_as_legend__title' => 'Spara som mall',
    'ui__mass-mail#save_as_text__title' => 'Spara skapat meddelande i en ny mall med namnet',
    'ui__mass-mail#subject_text__title' => 'Ämne',
    'ui__mass-mail#template_legend__title' => 'Mall',
    'ui__mass-mail#to_admin_text__title' => 'Plesk administrator',
    'ui__mass-mail#to_clients_text__title' => 'Kunder',
    'ui__mass-mail#to_domains_text__title' => 'DomänAdministreraistratörer',
    'ui__mass-mail#to_select_text__title' => 'Markera adresser',
    'ui__mass-mail#to_show_hide_text__title' => 'Visa/dölj markerade',
    'ui__mass-mail#to_text__title' => 'Till',
    'ui__mass-mail#tools_legend__title' => 'Verktyg',
    'ui__mass-mail__already_exists' => 'En mall med namnet %1 finns redan',
    'ui__mass-mail__none-available' => 'Du har inga meddelandemallar.',

    'ui__mass-mail/delete__description' => 'Ta bort meddelandemallar för massutskick av e-post %1',

    'ui__mass-mail/delete__empty_selection' => 'Markera vilka mallar du vill ta bort',
    'ui__mass-mail/delete__short-title' => 'Ta bort %1',
    'ui__mass-mail/delete__title' => 'Ta bort meddelandemallar för massutskick av e-post %1',
    'ui__mass-mail/delete_multi__description' => 'Ta bort dessa meddelandemallar för e-post.',

    'ui__mass-mail/delete_multi__short-title' => 'Ta bort',
    'ui__mass-mail/delete_multi__title' => 'Ta bort meddelandemallar för massutskick av e-post',
    'ui__mass-mail/delete_multi__wizard-title' => 'Borttagning av meddelandemallar för massutskick av e-post',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Markera de massutskicksmallar för e-post som du vill ta bort.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Bekräfta borttagning av mallar genom att välja kryssrutan och klicka på Slutför för att stänga installationsguiden.',
    'ui__mass-mail/delete_unknown__description' => 'Ta bort dessa meddelandemallar för e-post.',
    'ui__mass-mail/delete_unknown__short-title' => 'Ta bort',
    'ui__mass-mail/delete_unknown__title' => 'Ta bort meddelandemallar för massutskick av e-post',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Borttagning av meddelandemallar för massutskick av e-post.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Markera mallen för massutskick av e-postmeddelanden som du vill ta bort.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Bekräfta borttagning av mallar genom att välja kryssrutan och klicka på Slutför för att stänga installationsguiden.',

    'ui__mass-mail/properties__description' => 'Redigera e-postmeddelandemallen %1.',

    'ui__mass-mail/properties__invalid_values' => 'Angivna värden är felaktiga',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Redigera e-postmeddelandemallen %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Skapa en mall för massutskick av e-postmeddelanden.',
    'ui__mass-mail/properties_unknown-new__description' => 'Skapa en e-postmeddelandemall.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Lägg till en e-postmeddelandemall',
    'ui__mass-mail/properties_unknown-new__title' => 'Skapa e-postmeddelandemall',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Redigera meddelandemall för massutskick av e-post',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Markera mall att ändra och klicka på Nästa >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'När du är klar med redigeringen av mallen, klicka på Slutför för att tillämpa ändringarna och stänga installationsguiden.',

    'ui__mass-mail/send__invalid_values' => 'Du angav felaktiga värden',

    'ui__mass-mail/send_new__wizard-title' => 'Skapa en e-postmeddelandemall och skicka e-post',
    'ui__mass-mail/send_unknown-new__description' => 'Skicka e-post till valda mottagare',

    'ui__mass-mail/send_unknown-new__short-title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send_unknown-new__title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send_unknown__description' => 'Skicka e-post till valda mottagare',

    'ui__mass-mail/send_unknown__short-title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send_unknown__title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send_unknown__wizard-title' => 'Skicka massutskick med e-post',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Markera mallen som du behöver och klicka på Nästa >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'När du är klar med redigeringen av egenskaperna, klicka på Slutför för att skicka meddelandet och stänga installationsguiden.',

    'ui__mass-email/delete__description' => 'Ta bort valda meddelandemallar för massutskick av e-post.',

    'ui__mass-email/delete__empty_selection' => "Markera vilka mallar du vill ta bort.",
    'ui__mass-email/delete__short-title' => "Ta bort %1",
    'ui__mass-email/delete__title' => "Ta bort meddelandemallar för massutskick av e-post %1",
    'ui__mass-email/delete_multi__description' => "Ta bort dessa meddelandemallar för e-post.",

    'ui__mass-email/delete_multi__short-title' => "Ta bort",
    'ui__mass-email/delete_multi__title' => "Ta bort meddelandemallar för massutskick av e-post",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Bekräfta borttagning av mallar genom att välja kryssrutan och klicka på Slutför för att stänga installationsguiden.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Markera de massutskicksmallar för e-post som du vill ta bort.",
    'ui__mass-email/delete_multi__wizard-title' => "Borttagning av meddelandemallar för massutskick av e-post",
    'ui__mass-email/delete_unknown__description' => "Ta bort dessa meddelandemallar för e-post.",
    'ui__mass-email/delete_unknown__short-title' => "Ta bort",
    'ui__mass-email/delete_unknown__title' => "Ta bort meddelandemallar för massutskick av e-post",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Bekräfta borttagning av mallar genom att välja kryssrutan och klicka på Slutför för att stänga installationsguiden.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Markera mallen för massutskick av e-postmeddelanden som du vill ta bort.",
    'ui__mass-email/delete_unknown__wizard-title' => "Borttagning av meddelandemallar för massutskick av e-post.",
    'ui__mass-email/send__description' => "Skicka e-post till valda mottagare",
    'ui__mass-email/send__short-title' => "Skicka massutskick med e-post",
    'ui__mass-email/send__title' => "Skicka massutskick med e-post",
    'ui__mass-email/send_main__description' => "Skicka e-post till valda mottagare",

    'ui__mass-email/send_main__short-title' => "Skicka massutskick med e-post",
    'ui__mass-email/send_main__title' => "Skicka massutskick med e-post",
    'ui__mass-email/send_selectresellers__title' => 'Markera återförsäljare',
    'ui__mass-email/send_selectresellers__short-title' => 'Återförsäljare',
    'ui__mass-email/send_selectresellers__description' => 'Markera återförsäljarkonton',

    'ui__mass-email/send_selectclients__description' => "Markera kundkonton",

    'ui__mass-email/send_selectclients__short-title' => "Kunder",
    'ui__mass-email/send_selectclients__title' => "Markera kunder",
    'ui__mass-email/send_selectdomainusers__description' => "Markera domänens administratörskonton",

    'ui__mass-email/send_selectdomainusers__short-title' => "DomänAdministreraistratörer",
    'ui__mass-email/send_selectdomainusers__title' => "Markera domänadministratörer",
    'ui__mass-email/template/properties_main__description' => "Skapa en mall för massutskick av e-postmeddelanden.",
    'ui__mass-email/template/properties_main__short-title' => "Redigera mall",
    'ui__mass-email/template/properties_main__title' => "Redigera meddelandemall för massutskick av e-post",
    'ui__mass-email/template/properties_new-main__description' => "Skapa en mall för massutskick av e-postmeddelanden.",
    'ui__mass-email/template/properties_new-main__short-title' => "Skapa en mall för massutskick av e-postmeddelanden.",
    'ui__mass-email/template/properties_new-main__title' => "Skapa en mall för massutskick av e-postmeddelanden.",
    'ui__mass-email/template/properties_new-selectclients__description' => "Markera kunderna som ska ta emot e-postmeddelande ned massutskick enligt denna mall",
    'ui__mass-email/template/properties_new-selectclients__title' => "Markera kunderna som ska ta emot e-postmeddelande ned massutskick enligt denna mall",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Markera domänadministratörer som ska ta emot e-postmeddelanden baserade på denna mall.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Markera domänadministratörer som ska ta emot e-postmeddelanden baserade på denna mall.",
    'ui__mass-email/template/properties_selectclients__title' => "Markera kunderna som ska ta emot e-postmeddelande ned massutskick enligt denna mall",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Markera domänadministratörer som ska ta emot e-postmeddelanden baserade på denna mall.",

    'ui__mass-email/template/properties_unknown-new__description' => "Skapa en mall för massutskick av e-postmeddelanden",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Skapa mall",
    'ui__mass-email/template/properties_unknown-new__title' => "Skapande av e-postmeddelandemall för massutskick",
    'ui__news/dismiss__description' => 'Klicka för att stänga nyhetsramen. Plesk kommer inte att visa denna ram förrän nyhetsartiklar uppdateras.',

    'ui__news/dismiss__title' => 'Stäng nyheterna',

    'ui__server__description' => 'Serverhantering.',
    'ui__server__short-title' => 'Hantera servern',
    'ui__server__title' => 'Serverhantering',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-adressen %1 är otillgänglig.',
    'ui__server/ip-address__none-available' => 'Det finns inga IP-adresser.',
    'ui__server/ip-addresses/ip-address__title' => "IP-adresser",
    'ui__server/ip-address/client/properties_new__description' => "Tilldela IP-adress %1 till återförsäljare.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Tilldela',
    'ui__server/ip-address/client/properties_new__title' => "Tilldela IP-adress %1 till återförsäljare",
    'ui__server/ip-address/client__none-available' => 'Det finns inga användarkonton',
    'ui__server/ip-address/client_unknown__quick_search' => 'Användare',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lista över användare som använder denna IP-adress.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Välj IP-adress.',
    'ui__server/ip-address/client/delete__description' => 'Avtilldela IP-adresser från återförsäljaren.',
    'ui__server/ip-address/client/delete__short-title' => 'Avtilldela',
    'ui__server/ip-address/client/delete__title' => 'Avtilldela IP-adresser från återförsäljaren',
    'ui__server/ip-address/client/delete_multi__description' => "Avtilldela IP-adressen från återförsäljarpooler.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Avtilldela',
    'ui__server/ip-address/client/delete_multi__title' => 'Avtilldela en IP-adress från en återförsäljare',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Ta bort IP-adressen från användarnas pooler.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Välj den IP-adress du vill bortkoppla från användare och klicka på Nästa >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Välj de användare som du vill avtilldela IP-adressen och klicka på Nästa >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Bekräfta avtilldelningen av IP-adressen från användaren genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Avtillldela en IP-adress från återförsäljare.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Avtilldela',
    'ui__server/ip-address/client/delete_unknown__title' => 'Avtilldela IP-adressen från återförsäljare',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Avtilldela en IP-adress från användare',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Välj den IP-adress du vill bortkoppla från användare och klicka på Nästa >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Välj den användare som du vill avtilldela IP-adressen och klicka på Nästa >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Bekräfta avtilldelningen av IP-adressen från användaren genom att markera kryssrutan och klicka på Slutför för att avsluta guiden.',

    'ui__server/ip-address/domain__description' => "Alla domäner på IP-adressen %1.",
    'ui__server/ip-address/domain__short-title' => "Domäner",
    'ui__server/ip-address/domain__title' => "Domäner på IP-adressen %1.",
    'ui__server/ip-address/domain_unknown__description' => "Alla domäner på IP-adress.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domäner",
    'ui__server/ip-address/domain_unknown__title' => "Domäner på IP-adressen",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Välj den IP-adress du behöver och klicka på Nästa >>.",

    'ui__server/ip-address/properties__description' => 'Ändra egenskaperna för IP-adressen %1.',
    'ui__server/ip-address/properties__short-title' => 'Egenskaper',
    'ui__server/ip-address/properties__title' => 'Ändra egenskaperna för IP-adressen %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Lägg till IP-adress',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'När du är klar med att ändra IP-adressegenskaper, klicka på Slutför för att applicera ändringarna.',
    'ui__server/ip-address/properties_unknown__description' => 'Ändra egenskaperna för IP-adressen.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/ip-address/properties_unknown__title' => 'Ändra egenskaperna för IP-adressen',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Ändra egenskaperna för IP-adressen',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Markera IP-adressen vars egenskaper du vill ändra.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'När du är klar med att ändra IP-adressegenskaper, klicka på Slutför för att applicera ändringarna.',

    'ui__server/spam-filter/black-list__description' => 'Konfigurera svart lista för serveromfattande skräppostfilter.',
    'ui__server/spam-filter/black-list__short-title' => 'Svarta listan',
    'ui__server/spam-filter/black-list__title' => 'Svart lista för serveromfattande skräppostfilter.',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Endast %1 första unika e-postadresser kommer att läggas till.',
    'ui__server/spam-filter/black-list/address__description' => 'Skräppostfiltrets svarta lista-adress.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Det finns inga e-postadresser i listan.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Den överförda filen är tom.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Följande e-postadresser är ogiltiga: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Det finns inga adresser i skräppostfiltrets svarta lista.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adress',
    'ui__server/spam-filter/black-list/address__title' => 'Svarta listan-adress %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Lägg till adresser i svarta listan.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Lägg till adresser',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Lägg till adresser i svarta listan',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Ta bort %1-adressen från den serveromfattande svarta listan.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Ta bort',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Ta bort %1-adressen från den serveromfattande svarta listan',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Ta bort adresser från den serveromfattande svarta listan.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Ta bort',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Ta bort adresser från den serveromfattande svarta listan',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Borttagande av adresser från det serveromfattande skräppostfiltrets svarta lista',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Välj de skräppostfilteradresser du vill ta bort och klicka på Nästa >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Bekräfta borttagande av skräppostfilteradresser genom att markera kryssrutan och klicka på Slutför för att fullständigt ta bort dem och avsluta guiden.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Ta bort adress från den serveromfattande svarta listan.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Ta bort',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Ta bort adress från den serveromfattande svarta listan',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Borttagande av adresser från det serveromfattande skräppostfiltrets svarta lista',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Välj den skräppostfilteradress du vill ta bort och klicka på Nästa >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Bekräfta borttagande av skräppostfilteradressen genom att markera kryssrutan och klicka på Slutför för att fullständigt ta bort den och avsluta guiden.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Endast %1 första unika e-postadresser kommer att läggas till.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Det finns inga e-postadresser i listan.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Kan inte ladda filen. Den maximala storleken för en fil som kan laddas upp är %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Följande e-postadresser är ogiltiga: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Lägg till adresser i svarta listan.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Lägg till adresser',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Lägg till adresser i svarta listan',

    'ui__server/spam-filter/properties__description' => 'Konfigurera serveromfattande skräppostfilter.',

    'ui__server/spam-filter/properties__short-title' => 'Inställningar',
    'ui__server/spam-filter/properties__title' => 'Skräppostfilterinställningar',

    'ui__server/spam-filter/toggle_disable__description' => 'Inaktivera skräppostfiltrering för hela systemet.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Inaktivera',
    'ui__server/spam-filter/toggle_disable__title' => 'Inaktivera skräppostfiltrering',
    'ui__server/spam-filter/toggle_enable__description' => 'Aktivera skräppostfiltrering för hela servern.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Aktivera',
    'ui__server/spam-filter/toggle_enable__title' => 'Aktivera spamfiltrering',
    'ui__server/spam-filter/toggle_unknown__description' => 'Aktivera eller inaktivera skräppostfiltrering för hela servern.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktivera eller inaktivera',
    'ui__server/spam-filter/toggle_unknown__title' => 'Aktivera eller inaktivera skräppostfiltrering',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Aktivera eller inaktivera skräppostfilter',

    'ui__server/spam-filter/white-list__description' => 'Konfigurera systemomfattande vit lista för skräppostfilter.',
    'ui__server/spam-filter/white-list__short-title' => 'Vita listan',
    'ui__server/spam-filter/white-list__title' => 'Konfigurera vit lista för skräppostfilter.',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Endast %1 första unika e-postadresser kommer att läggas till.',
    'ui__server/spam-filter/white-list/address__description' => 'Skräppostfiltrets vita lista-adress.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Det finns inga e-postadresser i listan.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Den överförda filen är tom.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Följande e-postadresser är ogiltiga: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Det finns inga adresser i skräppostfiltrets serveromfattande vita lista.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adress',
    'ui__server/spam-filter/white-list/address__title' => 'Vita lista-adress %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Lägg till adresser till vita listan.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Lägg till adresser',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Lägg till adresser till vita listan',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Ta bort %1-adress från den serveromfattande vita listan.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Ta bort',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Ta bort %1-adress från den serveromfattande vita listan',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Ta bort adresser från den serveromfattande vita listan.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Ta bort',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Ta bort adresser från den serveromfattande vita listan',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Borttagande av adresser från det serveromfattande skräppostfiltrets vita lista',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Välj de skräppostfilteradresser du vill ta bort och klicka på Nästa >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Bekräfta borttagande av skräppostfilteradresser genom att markera kryssrutan och klicka på Slutför för att fullständigt ta bort dem och avsluta guiden.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Ta bort adress från den serveromfattande vita listan.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Ta bort',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Ta bort adress från den serveromfattande vita listan',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Borttagande av adresser från det serveromfattande skräppostfiltrets vita lista',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Välj den skräppostfilteradress du vill ta bort och klicka på Nästa >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Bekräfta borttagande av skräppostfilteradressen genom att markera kryssrutan och klicka på Slutför för att fullständigt ta bort den och avsluta guiden.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Endast %1 första unika e-postadresser kommer att läggas till.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Det finns inga e-postadresser i listan.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Kan inte ladda filen. Den maximala storleken för en fil som kan laddas upp är %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Följande e-postadresser är ogiltiga: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Lägg till adresser till vita listan.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Lägg till adresser',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Lägg till adresser till vita listan',

    'ui__server/mail/statistics#apply__description' => "Använd filter",
    'ui__server/mail/statistics#apply__title' => "Använd",
    'ui__server/mail/statistics#custom_from__title' => "från",
    'ui__server/mail/statistics#custom_to__title' => "till",
    'ui__server/mail/statistics#period_all__title' => "Alla",
    'ui__server/mail/statistics#period_custom__title' => "Anpassad",
    'ui__server/mail/statistics#period_month__title' => "Aktuell månad",
    'ui__server/mail/statistics#period_prev_month__title' => "Föregående månad",
    'ui__server/mail/statistics#period_prev_week__title' => "Föregående vecka",
    'ui__server/mail/statistics#period_today__title' => "Idag",
    'ui__server/mail/statistics#period_week__title' => "Nuvarande vecka",
    'ui__server/mail/statistics#period_yesterday__title' => "I går",
    'ui__server/mail/statistics#show_for_period__title' => "Visa för period",
    'ui__server/mail/statistics#tools_legend__title' => "Verktyg",
    'ui__server/mail/statistics__description' => "Visa skräppost- och virusstatistik",

    'ui__server/mail/statistics__short-title' => "Statistik",
    'ui__server/mail/statistics__title' => "Inställningar för e-post",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Skräppoststatistik",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Verktyg",
    'ui__server/mail/statistics/spam__description' => "Visa skräpppoststatistik",

    'ui__server/mail/statistics/spam__short-title' => "Skräppoststatistik",
    'ui__server/mail/statistics/spam__title' => "Skräppoststatistik",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "E-postnamn",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% av alla",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sortera efter e-postkonto",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sortera efter % av alla",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sortera efter mottagen skräppost",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "E-postkonton",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Skräppost mottagen",
    'ui__server/mail/statistics/spam/recipients__description' => "Mottagare",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Mottagare",
    'ui__server/mail/statistics/spam/recipients__title' => "Mottagare",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Rengör",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infekterade",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% av alla",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Count",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Skyddad",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Inte markerad",
    'ui__server/mail/statistics/spam/summary__description' => "Sammanfattning",

    'ui__server/mail/statistics/spam/summary__short-title' => "Sammanfattning",
    'ui__server/mail/statistics/spam/summary__title' => "Sammanfattning",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virusstatistik",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Verktyg",
    'ui__server/mail/statistics/virus__description' => "Visa virusstatistik",

    'ui__server/mail/statistics/virus__short-title' => "Virusstatistik",
    'ui__server/mail/statistics/virus__title' => "Virusstatistik",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "E-postkonto",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% av alla",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sortera efter e-postnamn",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sortera efter % av alla",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sortera efter virus mottagna",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "E-postkonton",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Virus mottaget",
    'ui__server/mail/statistics/virus/recipients__description' => "Mottagare",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Mottagare",
    'ui__server/mail/statistics/virus/recipients__title' => "Mottagare",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Rengör",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infekterade",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% av alla",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Count",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Skyddad",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Inte markerad",
    'ui__server/mail/statistics/virus/summary__description' => "Sammanfattning",

    'ui__server/mail/statistics/virus/summary__short-title' => "Sammanfattning",
    'ui__server/mail/statistics/virus/summary__title' => "Sammanfattning",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Namn",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% av alla",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sortera efter namn",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sortera efter % av alla",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sortera efter infekterade objekt",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virus",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Infekterade objekt",
    'ui__server/mail/statistics/virus/viruses__description' => "Virus",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virus",
    'ui__server/mail/statistics/virus/viruses__title' => "Virus",

    'ui__support#param_company__title' => "Företag",
    'ui__support#param_email__title' => "E-post",
    'ui__support#param_firstname__title' => "Förnamn",
    'ui__support#param_keynumber__title' => "Produktnyckelnummer",
    'ui__support#param_operatingsystem__title' => "Operativsystem",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Plesk-uppbyggnad",
    'ui__support#param_psainsttype__title' => "Plesk-installationstyp",
    'ui__support#param_psaversion__title' => "Plesk version",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Verktyg",

    'ui__reseller/traffic-history_unknown__short-title' => "Visa trafik för återförsäljare",
    'ui__reseller/traffic-history_unknown__title' => "Visa trafik för återförsäljare",
    'ui__reseller/traffic-history_unknown__description' => "Visa trafik för återförsäljarkonton.",
    'ui__reseller#list__title' => "Återförsäljare",
    'accounts_list__name__filter_title' => "Namn",
    'accounts_list__resource__filter_title' => "Resurs-användning",
    'resellers_list__filter_resource_usage_any' => "Valfri",
    'resellers_list__filter_resource_usage_overuse' => "Överanvändning",
    'resellers_list__filter_resource_usage_normal' => "Inom gränserna",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Valfri",
    'resellers_list__filter_status_blocked' => "Avstängd",
    'resellers_list__filter_status_active' => "Aktiva",
    'resellers_list__filter_clients__filter_title' => "Visa",
    'resellers_list__filter_clients_on' => "Återförsäljare med deras kunder",
    'resellers_list__filter_clients_off' => "Endast återförsäljare",
    '__disk_usage' => "Använt diskutrymme",
    'ui__reseller/traffic_unknown__short-title' => "Visa trafik för återförsäljare",
    'ui__reseller/traffic_unknown__title' => "Visa trafik för återförsäljare",
    'ui__reseller/traffic#list__title' => "Trafik hos återförsäljaren",
    'ui__reseller/traffic_unknown__description' => "Visa trafikanvändningsrapporter.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafik hos återförsäljaren",

    '__reseller_name' => "Återförsäljarens namn",
    '__reseller' => "Återförsäljare",
    'resellertrafficlist_header' => "Visa trafik för återförsäljare",
    '__reseller_personal' => "Trafik som används av återförsäljarens domäner",
    'ui__reseller/traffic-history__short-title' => "Trafik per återförsäljare",
    'ui__reseller/traffic-history__title' => "Trafik per återförsäljare",
    'ui__reseller/traffic-history__description' => "Visa trafikanvändningsrapporter.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Tillåt överförsäljning",
    'limits__reseller_oversell_description' => "Översäljning gör att återförsäljaren kan sälja mer resurser än vad som faktiskt allokerats honom eller henne. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.",
    'limits__overuse_block_text' => "Överanvändningspolicy",
    'limits__overuse_block_true_text' => "Överanvändning är inte tillåtet",
    'limits__reseller_overuse_block_true_description' => "Blockera överanvändning av resurser. Faktisk resursanvändning kan inte överstiga den ursprungliga resursallokeringen",
    'limits__overuse_block_false_text' => "Överanvändning är tillåtet",
    'limits__reseller_overuse_block_false_description' => "Blockera inte överanvändningen av resurser för att låta kunden använda mer resurser än vad som gavs till en början. Faktisk resursanvändning kan överstiga den ursprungliga resursallokeringen",
    'limits__reseller_overuse_notify_text' => "Meddela kunden om hur man når resursgränserna",
    'reseller_perm__manage_sh_access_disabled' => "Återförsäljaren kan inte tillåta eller förbjuda skalåtkomst",
    'reseller_perm__manage_sh_access_chrooted' => "Återförsäljare kan tillåta åtkomst endast till en chrootad miljö",
    'reseller_perm__manage_sh_access_any' => "Återförsäljare kan tillåta åtkomst till vilken typ av skal som helst",
    'template__reseller_num_excl_ips' => "Allokera dedikerade IP-adresser till återförsäljaren",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Markera de kundkonton du vill tilldela till en annan ägare.',
    'ui__reseller#tools2__title' => "Konto",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Kunder",
    'ui__reseller#domainsTab__title' => "Domäner",
    'ui__reseller__title' => "Hantera %1 återförsäljarkontot",
    'domains__reseller_info' => "%1 kunder, %2 domäner, %3 diskutrymme som används, %4 data som överförts.",
    'domains__reseller_info_hiding_traffic' => "%1 kunder, %2 domäner, %3 diskutrymme som används.",
    'ui__reseller__description' => "Hantera återförsäljarkontot.",

    'ui__reseller/limits_unknown__wizard-title' => 'Visa eller ändra resursgränser för en återförsäljare',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Markera återförsäljaren du behöver.',
    'ui__reseller/limits_unknown__wizard__2' => 'Klicka på Slutför för att tillämpa ändringarna.',

    'ui__client/report_reseller__short-title' => "Rapport",
    'ui__client/report_reseller__title' => "Visa kontorapport",
    'ui__client/report_reseller__description' => "Visa återförsäljarens kontorapport.",
    'ui__client/ip-pool_reseller__short-title' => "IP pool",
    'ui__client/ip-pool_reseller__description' => "Tilldela IP-adresser och SSL/TLS-certifikat till återförsäljarkontot.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Specificera kontoinställningar och klicka på Slutför.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Visa eller ändra behörighet för en återförsäljare.',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Markera kunden vars rapport du vill visa.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'När du är klar med redigeringen av mallen, klicka på Slutför för att tillämpa ändringarna och stänga installationsguiden.',

    // Customers > create customer account

    '__resellers_list' => 'Återförsäljare',
    'picker_reseller__title' => 'Markera återförsäljare',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Verktyg",
    'ui__client#tools2__title' => "Konto",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Kunder",
    'ui__client#domainslist__title' => "Domäner",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Alla webbprogram sorteras nu efter kategori, vilket gör det lättar att välja rätt proram att installera.",
    'feature__domainkeys__reseller' => "Du kan använda DKIM autentiseringsmekanism för e-postavsändare för att minska antalet spam och phising-mail.",

    '__reseller_form' => "Återförsäljarformulär",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Markera kundkontot vars inställningar du vill ändra.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "För att förändra resursanvändningsgränserna, klicka på Resursbegränsningar.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "För att ändra behörigheter för åtgärderna som kunden kan utföra på Plesk, klicka på Behörigheter.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "För att skapa en domän som kommer att tillhöra ditt konto, klicka på Skapa domän. För att skapa en domän för en av dina kunder, klicka på önskat kundnamn och sedan på Skapa domän.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Gör denna mall tillgänglig för andra användare",
    'template__shared_description' => "Markera detta alternativ om du vill att dina kunder ska kunna använda denna mall.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Verktyg',

    'ui__client/traffic-history_unknown__short-title' => 'Visa trafik enligt kunder',
    'ui__client/traffic-history_unknown__title' => 'Trafik enligt kunder',
    'ui__client/traffic-history_unknown__description' => 'Visa trafikanvändningsrapporter för alla kunder',
    'ui__client/traffic-history__short-title' => 'Trafik enligt kunder',
    'ui__client/traffic-history__title' => 'Visa trafik enligt kunder',
    'ui__client/traffic-history__description' => 'Visa trafikanvändningsrapporter för alla kunder',

    'ui__client/traffic#list__title' => 'Trafik enligt kunder',
    'ui__reseller/client/traffic#list__title' => 'Trafik enligt kunder',

    'clients_list__filter_type__filter_title' => 'Visa',
    'clients_list__filter_type_any' => 'Kunder och återförsäljare',
    'clients_list__filter_type_clients' => 'Enbart kunder',
    'clients_list__filter_type_resellers' => 'Endast återförsäljare',
    'ui__client/domain_unknown-new__short-title' => "Skapa domän",

    // Customers > View traffic by customers
    '__personal' => "Trafik använd av användarens domäner",
    'PersonalTrafficList_header_of_client__' => "Visa trafikanvändningsrapporter för ditt konto",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domänadministratören kan inte tillåta eller förbjuda skalåtkomst",
    'domain_perm__manage_sh_access_chrooted' => "Domänadministratören kan tillåta åtkomst endast till en chrootad miljö",
    'domain_perm__manage_sh_access_any' => "Domänadministratören kan tillåta åtkomst till vilken typ av skal som helst",

    // APS Catalog
    'bt_add_to_vault' => "Lägg till i valvet",
    'bt_hide_updates' => "Dölj tillgängliga uppdateringar",
    'bt_show_updates' => "Visa tillgängliga uppdateringar",

    '__site_apps__applications' => "Program",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Program som har markerats för tillägg till valvet",
    'site_apps__application_selected' => "Markerad",
    'site_apps__currently_in_vault' => "Andra versioner finns redan i valvet:",
    'site_apps__new_versions' => "Nya versioner:",
    'site_apps__patches' => "Patchar:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Antalet program som har schemalagts för tillägg till valvet: %1",
    'site_apps__applications_downloading_now' => "Följande program håller på att laddas ner: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Redan i valvet",

    // Server > Action Log
    'bt_skin_edit' => "Redigera skalets beskrivning",
    'domains__you_want_change_the_status_of_the_reseller??' => "Är du säker på att du vill ändra status för återförsäljarkontot?",
    'limits__oversell_legend' => "Överförsäljning",
    'limitsManager__limit_available_error' => "Kan inte allokera begärd mängd resurser (%%quantity%% %%limitName%%). Bara %%available%% %%limitName%% är tillgängligt.",
    'limitsManager__limit_reserved_error' => "Kan inte ställa in begärd resursanvändningsgräns (%%quantity%% %%limitName%%) eftersom det nya värdet är mindre än antalet resurser som reserverats för dina kunder eller används av dig (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Kan inte ställa in begärd resursanvändningsgräns (%%quantity%% %%limitName%%) eftersom det nya värdet är mindre än den faktiska resursmängd som redan används av ditt konto och dina webbpaltser (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Bandbreddsanvändning för tjänster",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Visa trafikanvändningsrapport",
    'ui__client/domain/traffic_unknown-reseller__title' => "Visa trafikanvändningsrapport",

    'ui__client/domain_new__short-title' => "Skapa domän",

    'ui__client_reseller__description' => "Hantera återförsäljarkonto %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Hantera återförsäljarkonto",

    '__owner_name' => "Ägarens namn",
    'domains_list__resource__filter_title' => "Resurs-användning",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-programmens katalog",
    'site_apps__applications_have_updates' => "Det finns uppdaterade versioner av följande program tillgängliga:\n%1\nFör att visa uppdateringarna, se till att Sökområdet är synbart, välj <b>Visa kryssrutan endast uppdateringar</b> och sök efter programmen du behöver.",
    'site_apps__progress_adding_to_vault' => "Lägga till i valvet:",
    'site_apps__progress_done_message' => "Förlopp:",
    'site_apps__progress_applications_left' => "%1 av %2 program kvar",
    'site_apps__download_item_long_task_title' => "Ladda ner APS-programmet (%1)",
    'site_apps__download_transaction_long_task_title' => "Ladda ner APS-program från APS-katalogen",
    'site_apps__last_check_for_updates' => "senaste kontrollen efter uppdateringar: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Alla schemalagda program har lagts till korrekt till programvalvet",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 schemalagda program har lagts till korrekt till programvalvet.",
    'site_apps__no_search_results' => 'Inga ansökningar funna. Försök med en annan sökbegäran eller bläddra i programmen efter kategori .',
    'site_apps__search_results_title' => 'Sökresultat',
    '__site_apps__search_by_application' => 'Programnamn',
    '__site_apps__search_by_vendor' => 'Leverantör',
    '__site_apps__search_by_vendor__all' => 'Alla leverantörer',
    '__site_apps__search_by_packager' => 'Paketeraren',
    '__site_apps__search_by_certification_level' => 'Certifieringsnivå',
    '__site_apps__search_by_cert__any' => 'Valfri',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver och högre',
    '__site_apps__search_by_cert__gold_and_higher' => 'Guld och högre',
    '__retry' => 'Försök igen',
    'site_apps__application_packager_site' => 'Paketeraren',
    'site_apps__add_to_pool_message' => "Programm som är markerade som \"tillgängliga för alla\" distribueras automatiskt till alla återförsäljare och kunder med ett obegränsat antal installationer. Begränsade program distribueras till alla återförsäljare och kunder manuellt på en individuell basis med uttryckligt specificerat antal tillgängliga installationer.",
    'site_apps__make_available_for_all' => "Gör valda program tillgängliga för alla användare",

    'site_apps__broadcast_app_text' => "Programm som är markerade som \"tillgängliga för alla\" distribueras automatiskt till alla återförsäljare och kunder med ett obegränsat antal installationer. Begränsade program distribueras till alla återförsäljare och kunder manuellt på en individuell basis med uttryckligt specificerat antal tillgängliga installationer.",
    'site_apps__broadcast_app_name' => 'Gör programmet tillgängligt för alla användare',

    // User Application Pool per application
    'site_apps__available_clients' => 'Tillgängliga användare',
    'site_apps__no_more_clients_to_add_to_pool' => 'Det finns inga fler användarkonton som du kan tillhandahålla detta program till',

    // Installed application instances
    'site_apps__installations' => 'Anläggningar',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domännamn och IP-adress",
    '__assign_ip_address' => "Tilldela IP-adress",
    '__switch_on_service' => "Sätt på tjänsten",
    '__hosting_configuration' => "Hosting konfiguration",
    '__vrt_hst' => "Webbplatshosting",
    '__vrt_hst_hint' => "Värdbasera en webbplats på denna server.",
    '__fwd' => "Vidarebefordran",
    '__web_hosting_settings' => "Värdtjänst-inställningar",
    '__fwd_hint' => "Omdirigera besökare till en annan webbplats.",
    '__none_hint' => "Webbasera ingen webbplats just nu.",
    '__login_hint' => "Detta användarnamn används för tillgång till webbplatsen via FTP",
    '__password_hint' => "Detta lösenord används för tillgång till webbplatsen via FTP",
    '__advanced_hosting_setup' => "Konfigurera den avancerade webbplatsens värdtjänstinställningar.",
    '__domain_creation_successful' => "Domänen har skapats.",
    'bt_hosting_settings' => "Värdtjänst-inställningar",
    '__change_hosting_type' => "Ändra värdtjänsttypen för domän %1",
    '__hosting_type_change_warning' => "När du ändrar värdtjänsttyp till vidarebefordran eller ingen värdtjänst, kommer alla filer och kataloger som gäller din webbplats att tas bort ur servern. Se till att spara en lokal kopia av din site.",
    '__current_hosting_type' => "Aktuell värdtjänsttyp",
    '__new_hosting_type' => "Ny värdtjänsttyp",
    '__fwd_settings' => "Vidarekopplingsinställningar",
    '__fwd_settings_legend' => "Vidarekopplingsinställningar",
    '__fwd_destination_url' => "Destinationsadress",
    '__fwd_type' => "Vidarebefordringstyp",
    '__fwd_type_standart' => "Standard vidarebefordran",
    '__fwd_type_standart_hint' => "Omdirigera webbplatsbesökare till en annan webbplats, och visa dem destinationsadressen så att de får reda på omdirigeringen.",
    '__fwd_type_frame' => "Frame vidarebefordran",
    '__fwd_type_frame_hint' => "Omdirigera webbplatsbesökare till en annan webbplats, men visa dem inte destinationsadressen så att de inte får reda på omdirigeringen.",
    '__hosting_type_template_warning' => "Den typ av värdtjänst du väljer skiljer sig från den typ som specificeras i mallen. Om du fortsätter, kommer webbvärdtjänstens inställningar i den valda mallen att ignoreras. Vill du verkligen ställa in markerad värdtjänsttyp?",

    'ui__client/domain/properties#vrt_hst__title' => "Webbplatshosting",
    'ui__client/domain/properties#vrt_hst__description' => "Värdbasera en webbplats på denna server",
    'ui__client/domain/properties#fwd__title' => "Vidarebefordran",
    'ui__client/domain/properties#fwd__description' => "Omdirigera besökare till annan webbplats",
    'ui__client/domain/properties#none__title' => "Inga värdtjänster",
    'ui__client/domain/properties#none__description' => "Erbjuder inte värdtjänster på en webbplats just nu",

    '__no_resellers_selected' => "Du måste välja minst ett återförsäljarkonto.",

    'ui__client/logo_unknown__wizard-title' => 'Konfigurera en logotyp',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Markera kunden vars logotypegenskaper du vill ändra.',
    'ui__client/logo_unknown__wizard__2' => 'Klicka på Slutför för att tillämpa ändringarna.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klicka på Slutför för att tillämpa ändringarna.',

    'ui__client/ipaddress/properties_new__short-title' => "Lägg till IP-adress",
    'ui__client/ipaddress/properties_new__title' => 'Lägg till IP-adress',
    'ui__client/ipaddress/properties_new__description' => "Lägg till IP-adress.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Lägg till IP-adress",
    'ui__client/ipaddress/properties_unknown-new__title' => "Lägg till IP-adress",
    'ui__client/ipaddress/properties_unknown-new__description' => "Lägg till IP-adress",
    'ui__client/ipaddress/delete_multi__short-title' => "Ta bort IP-adress",
    'ui__client/ipaddress/delete_multi__description' => "Ta bort IP-adresser.",
    'ippool_Manager__no_available_ips' => "Det finns inga lediga IP-adresser i IP-poolen.",
    'ippool_Manager__ip_shared' => "delad",
    'ippool_Manager__ip_exclusive' => "dedikerad",
    'ui__client/ipaddress/properties__title' => "Hantera IP-adresser",
    'ui__client/ipaddress/properties__description' => "Visa eller ändra IP-adressegenskaper.",
    'ui__client/ipaddress_unknown-new__title' => "Lägg till IP-adress",
    'ui__client/ipaddress_unknown-new__short-title' => "Lägg till IP-adress",
    'ui__client/ipaddress_unknown-new__description' => "Lägg till IP-adresser.",

    'ui__mass-mail#to_resellers_text__title' => "Återförsäljare",
    'ui__mass-mail#to_domainusers_text__title' => "DomänAdministreraistratörer",
    'ui__mass-email#tools_legend__title' => "Verktyg",
    'ui__mass-email#list_legend__title' => 'E-postmeddelandemall för massutskick',
    'ui__mass-email#template_legend__title' => "Mall",
    'ui__mass-email#from_email_text__title' => "Från",
    'ui__mass-email#to_text__title' => 'Till',
    'ui__mass-email#to_resellers_text__title' => "Återförsäljare",
    'ui__mass-email#to_clients_text__title' => "Kunder",
    'ui__mass-email#to_domainusers_text__title' => "DomänAdministreraistratörer",
    'ui__mass-email#to_admin_text__title' => "Plesk administrator",
    'ui__mass-email#option_mode_all__title' => "Alla",
    'ui__mass-email#option_mode_select__title' => "Endast markerade",
    'ui__mass-email#option_mode_except__title' => "Alla utom markerade",
    'ui__mass-email#option_select_template__title' => '---Välj en mall---',
    'ui__mass-email#subject_text__title' => "Ämne",
    'ui__mass-email#body_text__title' => "Meddelandetext",
    'ui__mass-email#save_as_legend__title' => "Spara som mall",
    'ui__mass-email#save_as_text__title' => "Spara skapat meddelande i en ny mall med namnet",
    'ui__reseller/preferences_unknown__wizard-title' => "Ändra kontoinställningar",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Markera återförsäljaren vars kontoinställningar du vill ändra och klicka på Nästa.",
    'ui__reseller/preferences_unknown__wizard__2' => "Specifica kontoinställningar och klicka på OK.",
    'ippoolManager__ip_shared' => "delad",
    'ippoolManager__ip_exclusive' => "dedikerad",

    '__users_list' => "Användare",
    '__users' => "Användare",
    '__user_name' => "Användarens namn",

    'clientOwnerChanger__wrong_owner_type' => "Du kan överföra valda kundkonton endast till ett återförsäljarkonto.",
    'clientOwnerChanger__wrong_client_type' => 'Valt användarkonto är ett återförsäljarkonto. Återförsäjarkonton kan inte tilldelas en ny ägare eftersom de ägs av serveradministratören.',
    'ui__client/chowner_multi__description' => "Överför användarkonton till en annan användare. Transfer user accounts to another owner.",
    'client_chown__clients_list_legend' => "Användarkonton",
    'client_chown__client_name' => "Användarens namn",
    'client_chown__old_owner' => "Tidigare ägare",
    'client_chown__limits_legend' => "Resurser",
    'client_chown__limit_name' => "Resursnamn",
    'client_chown__limit_value' => "Belagda resurser",
    'client_chown__usage_before' => "Före överföring",
    'client_chown_usage_after' => "Efter överföring",
    'limit__name_max_dom_aliases' => "domänalias",
    'limit__name_max_subftp_users' => "Extra FTP-konton",
    'limit__name_max_mssql_db' => "Microsoft SQL Server-databas",
    'limit__name_max_iis_app_pools' => "IIS-programpooler",
    'limit__name_max_odbc' => "ODBC-anslutningar",
    'total_mboxes_quota_unsupported' => 'stöds inte av e-postservern',
    'limit_soft__disk_space' => 'Meddela när diskutrymme nås',
    'limit_soft__max_traffic' => 'Meddela när trafik nås',
    'dsr__of_reseller_title' => "Resursanvändning efter domän",
    'client_chown__new_owner' => 'Ny ägare',
    'ui__reseller/to-client__has_clients_warning' => 'Vissa av de valda återförsäljarkontona kan inte omvandlas till kundkonton eftersom de har kunder som abonnerar på tjänsterna. Ta bort kundkontona som denna återförsäljare abonnerar på eller flytta dem till en annan återförsäljare.',
    'limitsManager__commit_failed' => "Kan inte ändra resursgränserna.",
    'limitsManager__date_in_past' => "Felaktigt utgångsdatum %1",
    'limitsManager__limit_not_supported' => "Gränser för resurstypen %1 kan inte anges.",
    'limitsManager__limit_oversell_inconsistency' => "Kan inte allokera angiven mängd resurser med överförsäljning avstängt.",
    'limitsManager__limit_overuse_inconsistency' => "Resursanvändningen överstiger de definierade gränserna.",
    'limitsManager__no_resource_available' => "Det finns inga tillgängliga resurser av denna typ (%%limitName%%) kvar. Begärt: %%quantity%%; tillgängligt: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Det finns inga resurser av denna typ (%%limitName%%) som är tillgängliga från din tjänsteleverantör. Begärt: %%quantity%%; tillgängligt: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Utgångsdatumet måste vara mindre än eller lika med %1.",
    'limitsManager__invalid_disk_space_limit' => "Mängden diskutrymme måste vara mindre än eller lika med %1.",
    'limitsManager__invalid_max_traffic_limit' => "Mängden trafik måste vara mindre än eller lika med %1.",
    'ippoolManager__ip_has_suballocations' => "Kan inte ändra typen av IP-adress som redan tilldelats en användare. IP-adress %%ip%% är redan tilldelad användare som %%reserved%% IP-adress.",
    'ippoolManager__ip_is_already_in_pool' => "Denna IP-adress är redan tilldelad användaren.",
    'ippoolManager__ip_is_not_in_pool' => "Det finns ingen IP-adress %%ip%% konfigurerad i poolen.",
    'ippoolManager__can_not_allocate_ip' => "IP-adressen %%ip%% är tillgänglig bara som %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP-adressen %%ip%% kan inte allokeras eller dedikeras.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP-adressen %%ip%% används redan för värdtjänster.",
    'ippoolManager__active_anon_ftp_on_ip' => "En anonym FTP-åtkomst är redan påsatt för IP-adress %%ip%%",
    'ippoolManager__no_vacant_ips' => "Det finns inga lediga IP-adresser.",
    'ippoolManager__no_available_ips' => "Det finns inga tillgängliga IP-adresser.",
    'templates__dublicate_name' => "En mall med ett sådant namn finns redan. Markera ett annat namn för denna mall.",
    'cl_perm__client_limits_exceeded' => "De specificerade resursgränsvärdena överskrider värdena som tillåts av din värdtjänstplan och dessa värden ger mindre resurser än vad som normalt används av dina webbplatser.",
    'cl_perm__reseller_limits_exceeded' => "De specificerade resursgränsvärdena överskrider värdena som tillåts av din värdtjänstplan eller dessa värden ger mindre resurser än vad som normalt används av användarens konton och webbplatser.",

    'site_apps__preferences_show_all_versions_title' => "Visa en fullständig lista över versioner för varje program som du hämtat ur katalogen",
    'site_apps__preferences_show_all_versions_hint' => "Om du väljer detta alternativ, kan det ta lång tid att hämta alla versioner av varje program varje gånd du öppnar katalogen. Om detta alternativ inte är markerat, visas bara de senaste versionerna.",
    '__select_user_template' => "Skapa användarkonto baserat på en mall",
    'ip_already_added_to_all_clients' => "Denna IP-adress är redan tilldelad alla användare.",
    'ui__server/ip-address/client/delete#legend__description' => "Följande IP-adresser kommer att tas bort ur systemet och användarens IP-pooler:",

    'site_apps__cancelled_apps' => "Du har avbrutit tillägget av följande program: %2",

    'sb_url_is_not_resolved' => 'URL kan inte kopplas: kontrollera dina DNS-inställningar. URL %1 måste kopplas i serverns IP-adress med den installerade Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Kan inte ta bort IP-adressen %%ip%% eftersom det är den sista IP-adress som finns på ett nätverksgränssnitt.',
    'ip_addr__used_for_current_session' => 'Kan inte ta bort IP-adressen %%ip%% eftersom den används av en aktiv session.',
    'ip_addr__used_for_hosting' => 'Kan inte ta bort IP-adressen %%ip%% eftersom den används för värdbasering för en webbplats.',
    'ip_addr__is_main' => 'Kan inte ta bort IP-adressen %%ip%% eftersom det är den primära IP-adressen till ett nätverksgränssnitt.',
    'ip_addr__ip_used_by_message_submission' => 'Kan inte ta bort IP-adressen %%ip%% eftersom den används för att skicka e-postmeddelanden',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domäner av kunder',
    'excl_ip_num' => 'Dedikerad IP-adress',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder är inte installerat.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Behörighet att tillåta överförsäljning kan inte återkallas från användaren eftersom användaren redan har allokerat mer resurser än tillgängligt, och övergått till överförsäljningsläge.',
    'limitsManager__invalid_limit_value' => 'Ogiltigt värde %%value%% angivet för gränsen %%limit_name%%',
    'ip_alias__type' => "IP-adress distribuerad som",
    'ip_alias__in_type' => 'IP-adress allokerad som',
    'ui__client/ipaddress/delete_multi__title' => 'Ta bort IP-adresser',
    'ui__client/ipaddress/delete#legend__short-title' => 'Element som kommer att tas bort',
    'ui__client/ipaddress/delete#legend__description' => "Följande IP-adresser kommer att tas bort ur användarens IP-pool:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Poster som det inte går att ta bort',
    'ui__client/ipaddress/delete#nlegend__description' => 'Följande IP-adresser kan inte tas bort:',
    'ui__server/ip-address/delete#legend__description' => 'Följande IP-adresser kommer att tas bort ur serverns IP-pool:',
    'confirmationForm_default_agreement_text' => 'Bekräfta åtgärden',
    'confirmationForm_default_confirm_message' => 'Bekräfta åtgärden.',
    'limit__max_mn' => 'Maximalt antal e-postkonton',

    'limits__client_overuse_description' => 'Överanvändningspolicyn anger vad Plesk ska göra när resursanvändningen överstiger den ursprungliga resursallokeringen.',
    'limits__client_overuse_block_true_description' => 'Blockera överanvändning av resurser. Faktisk resursanvändning kan inte överstiga den ursprungliga resursallokeringen',
    'limits__client_overuse_block_false_description' => 'blockera inte överanvändningen av resurser för att låta kunden använda mer resurser än vad som gavs till en början. Faktisk resursanvändning kan överstiga den ursprungliga resursallokeringen',
    'limits__client_overuse_notify_text' => 'Meddela kunden om hur man når resursgränserna',

    'limits__domain_overuse_description' => 'Överanvändningspolicyn anger vad Plesk ska göra när resursanvändningen överstiger den ursprungliga resursallokeringen.',
    'limits__domain_overuse_block_true_description' => 'Överanvändningspolicyn säger åt Plesk vad det ska göra när resurser överanvänds.',
    'limits__domain_overuse_block_false_description' => 'Blockera inte överanvändning av resurser, vilket tillåter domänen att använda mer resurser än som initialt tillhandahållits. Faktisk resursanvändning kan överstiga den ursprungliga resursallokeringen',
    'limits__domain_overuse_notify_text' => 'Meddela domänägaren om att resursbegränsningarna nåtts',


    'cancel_remove' => 'Kassera ändringarna och återgå till föregående sida.',
    'php_not_installed' => 'PHP är inte installerat',

    'dns__dns_rr_delete' => 'Element som kommer att tas bort',
    'dns__delete_rr' => 'Följande DNS-poster kommer att avlägsnas från DNS-zonen:',
    'dns__dns_rr_delete_non_removable' => 'Poster som det inte går att ta bort',
    'dns__non_delete_rr' => 'Följande DNS-poster kunde inte tas bort:',
    'dns__dns_rr_delete_confirm_message' => 'Bekräfta borttagande av DNS-poster',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Okänt webbprogramformat: webbprogrammet kanske inte är tillgängligt för installation och användning.',

    '__php_handler_type_desc' => 'Kör PHP som',
    'sfdk_domain_sign__failed' => 'Ett oidentifierat fel inträffade när du försökte sätta på signering av e-post med DKIM på domänen. Se serverns fellogg för mer information.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Meddelande om lyckad Plesk-nyckeluppdatering',
    'pkey_notify__subj_update_deferral_notification' => 'Meddelande om uppskjutande av Plesk-nyckeluppdatering',
    'pkey_notify__subj_update_error_notification' => 'Meddelande om fel på Plesk-nyckeluppdatering',
    'pkey_notify__update_successful' => '%1 uppdateringen har slutförts riktigt.',
    'pkey_notify__update_failed_no_more_try' => 'Det gick inte att uppdatera %1. Nyckeln du försöker sända är ogiltig. Försök inte uppdatera denna nyckel längre.',
    'pkey_notify__update_failed_try_later' => 'Det gick inte att uppdatera %1: ett fel uppstod under bearbetning av din nyckel. Du kan försöka hämta nyckeln manuellt i Plesk (Verktyg och inställningar>Licenshantering) eller låta Plesk försöka uppdatera den under de kommande 24 timmarna. Om du inte längre vill få detta meddelande, ta bort denna nyckel från Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Kan inte stänga av serveromfattande skräppostfiltrering.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Kan inte slå på serveromfattande skräppostfiltrering.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Denna återförsäljare',
    'report_auto__select_reseller_report_all' => 'Alla återförsäljare',
    'report_auto__select_reseller_report_client' => 'Alla återförsäljare för denna kund',
    'report_auto__select_reseller_report_current' => 'Denna återförsäljare',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Alla kunder för denna återförsäljare',
    'report_auto__select_client_report_client' => 'Denna kund',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Återförsäljare, kunder och domäner',

    'rpt_reseller_section_full_domains' => 'Domäner',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Vidarebefordrare',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Kunder',
    '__cl_name' => 'Kundens namn',
    '__cl_creation_date' => 'Skapandedatum',
    '__clients_traffic' => 'Kundtrafik',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder är inte installerat.',
    'sitebuilder_disabled' => 'Presence Builder är avstängt.',
    'b_sitebuilder_disabled' => 'Presence Builder är avstängt.',
    'webmail_not_installed' => 'Webbmailmjukvaran är inte installerad.',
    'webmail_disabled' => 'Webbposttjänsten är avstängd.',
    'spamassassin_not_installed' => 'SpamAssassin är inte installerat.',
    // pfu:
    'anonymous_ftp_shared' => 'Kan inte konfigurera anonym FTP: delad IP-adresstyp.',
    'anonymous_ftp_used' => 'Kan inte ställa in anonym FTP: IP-adressen används av en annan domän för anonym FTP-tjänst.',
    'sshterm__not_installed' => 'SSH-terminal är inte installerad.',
    'sshterm__empty_shell' => 'För att kunna använda terminalkunden, måste du tillta fysisk skalåtkomst för denna domän.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET är inte installerat.',
    'tsclient__not_installed' => 'Fjärrskrivbordet har inte installerats.',
    'site_builder_no_package' => 'Presence Builder är inte tillgängligt. Kontrollera att Presence Builder är installerat och valt som en aktiv komponent.',
    'site_builder_not_configured' => 'Presence Builder är inte konfigurerat.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Verktyg',
    'ui__reseller/client#clientslist__title' => 'Kunder',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Ställ in ODBC-datakällor för webbplatsen",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Markera webbplatsen för vars program du vill ställa in ODBC-datakällor.",

    'ui__client/domain/hosting/tsclient_unknown__wizard-title' => "Sök åtkomst till den virtuella värddatorn för domänen via fjärrskrivbordet",
    'ui__client/domain/hosting/tsclient_unknown__wizard__2_unknown' => "Markera domänen vars virtuella värddator du vill få tillgång till via fjärrskrivbordet.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Hantera virtuella kataloger på domänen.",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Markera domän vars virtuella kataloger du vill hantera.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Hantera virtuella kataloger på en webbplats',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Markera webbplatsen vars kataloger du vill hantera.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Konfigurera Hotlink-skydd för domän",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Välj den domän vars filer du vill skydda från hotlinking.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Konfigurera PHP-inställningarna för domänen",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Välj den domän vars PHP-inställningar du vill konfigurera.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Ställ in anonym FTP på domän',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Välj domänen för vilken du vill upprätta anonym FTP.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Hantera lösenordsskyddade kataloger på domän',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Välj den domän vars lösenordsskyddade kataloger du vill hantera.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Visa webbstatistik för domän',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Välj den domän för vilken du vill visa webbstatistik.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Konfigurera logghanterare för domän och visa domänloggfiler',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Välj den domän vars logghanterare du vill konfigurera och vars loggfiler du vill visa.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Hantera SSL/TLS-certifikat för domän',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Välj den domän vars SSL/TLS-certifikat du vill hantera.',

    'ui__client/to-reseller_multi__wizard-title' => 'Omvandla kundkonton till återförsäljarkonton',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Du måste välja de kundkonton du vill omvandla till återförsäljarkonton.',

    'ui__reseller/to-client_multi__wizard-title' => 'Omvandla återförsäljarkonton till kundkonton',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Markera de återförsäljarkonton du vill omvandla till kundkonton.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Specificera värdtjänstinställningarna för domänen.',







    'ui__client/domain/disable_multi__wizard-title' => 'Stäng av domäner',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Markera vilka domäner du vill upphäva.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktivera domäner',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Markera vilka domäner du vill aktivera.',

    'ui__client/domain_unknown__wizard-title' => 'Visa domäner',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Markera kunden vars domäner du vill visa.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Omvandla valda domänadministratörkonton till kundkonton',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Markera domäner vars administratörskonton du vill omvandla till kundkonton',

    'ui__client/domain/register_unknown__wizard-title' => 'Registrera domäner',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Markera domänen du vill registrera.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Använd verktyg från MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Välj den domän du vill hantera med verktyg från MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Sök åtkomst till servern via SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Markera domänen vars virtuella värddator du vill ansluta till via SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP-adress användare',
    'ui__server/ip-address/client_unknown__title' => 'IP-adress användare',
    'ui__server/ip-address/client_unknown__description' => 'Användare av IP-adress %1',

    'disabled_by_admin' => 'Inaktiverad av serveradministratör',






    'ui__client/domain/chowner_multi__short-title' => 'Ändra ägarskap',
    'ui__client/domain/chowner_multi__title' => 'Ändra abonnemangsägare',
    'ui__client/domain/chowner_multi__description' => 'Ändra abonnemangsperiod.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Välj de domäner för vilka du vill ändra på ägarskapet och klicka på Nästa >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Ändra ägarskap',
    'ui__client/domain/chowner_unknown__title' => 'Ändra abonnemangsägare',
    'ui__client/domain/chowner_unknown__description' => 'Ändra abonnemangsperiod.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Ändra abonnemangsägare',


    'ui__client/chowner__short-title' => 'Ändra kundägare',
    'ui__client/chowner__title' => 'Ändra kundägarkonto',
    'ui__client/chowner__description' => 'Tilldela en ny ägare för detta kundkonto',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Det finns inga anpassade knappar.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Det finns inga anpassade knappar i återförsäljarens %1 gränssnitt.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Ta bort knapp %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Ta bort',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Ta bort knapp %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Ta bort kundknappar från återförsäljar gränssnittet',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Ta bort',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Ta bort anpassade knappar',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Ta bort knappar',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Markera en återförsäljare vars anpassade knappar du vill ta bort och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Markera de knappar du vill ändra och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekräfta borttagning av knapparna genom att markera kryssrutan på denna skärm och klicka på Slutför.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Ta bort en kundknapp från återförsäljarens gränssnitt.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Ta bort',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Ta bort en anpassad knapp.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Ta bort anpassad knapp',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Markera en återförsäljare vars anpassade knappar du vill ta bort och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Markera en anpassad knapp du vill ta bort och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekräfta borttagningen av den anpassade knappen genom att markera kryssrutan på denna skärm och klicka sedan på Slutför.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Redigera egenskaperna för en anpassad knapp %1 på återförsäljarnivå.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Inställningar',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modifiera återförsäljarens anpassade knapp %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Lägg till anpassad knapp',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Markera en återförsäljare i vars gränssnitt du vill skapa en anpassad knapp och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klicka på Slutför för att skapa knappen.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Ändra egenskaper för en knapp i återförsäljarens gränssnitt.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Ändra egenskaper för en knapp i återförsäljarens gränssnitt',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ändra egenskaperna för anpassade knapåar',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Markera en återförsäljare vars anpassade knappar du vill ändra och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Markera en anpassad knapp du vill klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'När du är färdig med att redigera egenskaperna för knappen, klicka på Slutför för att verkställa ändringarna och avsluta guiden.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Gör knappen %1 otillgänglig för dina kunder.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Gör den tillgänglig för dina kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Gör knappen %1 otillgänglig för dina kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Gör knappen %1 synbar för återförsäljarens kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Gör den tillgänglig för dina kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Gör knappen %1 synbar för återförsäljarens kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Göra en anpassad knapp tillgänglig/otillgänglig för din akunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'tillgänglig/otillgänglig för dina kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'gör en anpassad knapp tillgänglig eller otillgänglig för dina kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Göra en anpassad knapp tillgänglig/otillgänglig för din akunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Markera en återförsäljare vars anpassade knapp du vill göra tillgänglig för återförsäljarens kunder och klicka på Nästa >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Väj en anpassad knapp du behöver göra tillgänglig eller otillgänglig för dina kunder och klicka på Nästa >>.',




    'ui__server/ip-addresses__short-title' => 'IP-adresser',
    'ui__server/ip-addresses__title' => 'IP-adresshantering',
    'ui__server/ip-addresses__description' => 'Lägg till, ta bort och tilldela IP-adresser.',

    'ip_ctrl__allow_ftps' => 'Tillåt FTP över SSL/TLS',
    '__ftps' => 'FTP över SSL/TLS',
    '__not_allowed' => 'Tillåts inte',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Domäner som använder %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Domäner som använder %1 IP-adress %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Visa listan över domäner som använder %1 IP-adress %2',

    'ui__client/ipaddress__none-available' => 'Inga IP-adresser som finns',
    'ui__client/ipaddress__none-available__1' => 'Inga IP-adresser som finns',



    'ui__client/domain/report_unknown__wizard-title' => 'Visa domänrapport',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Markera domän vars rapport du vill visa.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Välj en ny ägare av domänen.',

    'ui__client/chowner__wizard__2_select' => 'Markera ny ägare för kundkontot.',

    '__ip_addr_state_unknown' => "IP-adressen är inte operativ nu, eftersom systemet fortfarande bearbetar din begäran. Vänta en minut.",


    'resellers_list__accounts' => 'Användare',

    'ip_addr__repair_is_not_allowed' => 'IP-adressen kan inte repareras under Virtuozzo-miljön.',

    'ui__reseller/client__none-available__1' => 'Återförsäljaren %1 har inga kunder.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP-adressen %%ip%% kan inte tas bort eftersom den används av en eller flera domäner utan hosting.",
    'ippoolManager__ip_used_for_mail_service' => "IP-adressen %%ip%% kan inte tas bort eftersom den används av en eller flera domäner som deras e-posttjänsts IP-adress.",
    'ippoolManager__ip_used_for_send_emails' => "IP-adressen %%ip%% kan inte tas bort eftersom den används för att skicka e-post från specifik IP (se inställningar för e-postserver).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-adress %%ip%% kan inte tas bort eftersom den används av DNS-zonen för en eller flera domän.',
    'ip_ctrl__cannot_manage_on_vz' => 'Denna installation av Plesk fungerar under Virtuozzo containers. Nya IP-adresser kan läggas till bara av Virtuozzo containers-nodadministratör.',

    'client_template__limits_auto_adjusted' => 'Gränser från kundmallen har justerats automatiskt.',

    '__entries' => 'Poster',

    '__path_is_not_set' => 'Sökvägen har inte specificerats. Specificera en giltig sökväg.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'Den nya, Plesk-nyckeln har laddats upp',
    'key_new_additional_key_is_uploaded' => 'Den nya, extra nyckeln har laddats upp',

    'defaultcomponents__imap_required' => '(Den aktuella e-postservern stöder inte IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Hotlink-skydd är påslaget för denna domän.',
    'i_hotlinkprotection_off' => 'Hotlink-skydd är avstängt för denna domän.',

    '__commercial_web_stats_not_installed' => 'Plesk stödjer bara kommersiell webbstatistikmjukvara för subdomänstatistikberäkning. Ingen sådan programvara har för närvarande installerats i systemet.',

    'mail__spamassassin_personal_settings_disallowed' => 'Möjligheten att tillämpa personliga skräppostfiltreringsinställningar är avstängd av serveradministratören. Skräppostfilterinställningarna som anges nedan kommer inte att tillämpas',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Kan inte skapa %1 objektet, %2',
    'cu_dom_pref__invalid_expiration_date' => 'Ogiltigt förfallodatum: %1',
    'cu_cl_pref__illegal_date_val' => 'Du har angett ett ogiltigt datumvärde ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Ange årtal från "%1" till "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'Kan inte ställa in IP-aliastyp: %1',
    'cu_mlist__unable_change_status' => "Kan inte ändra e-postlistans status: %1",
    'cu_initconf__unable_change_passwd' => "Kan inte ändra administratörslösenord: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Inkluderar MySQL-fjärrdatabaser i beräkningen av använt diskutrymme.',
    'cu_siteapp_item__add_to_pool_success' => 'Webbprogrammet har lagts till webbprogrampoolen.',
    'cu_siteapp_item__remove_from_pool_success' => 'Webbprogrammet har tagits bort från webbprogrampoolen.',
    'cu_traffic_command_description_add_user' => 'Registrerar en specifik mängd trafik som om det redan användes av kunden/återförsäljaren',
    'cu_traffic_command_description_sub_user' => 'Drar ifrån en specifik mängd trafik från mängden som registrerats för kunden/återförsäljaren',
    'cu_traffic_command_description_add_batch_user' => 'Registrerar en specifik mängd trafik som om det redan användes av kunden/återförsäljaren (partiläge)',
    'cu_traffic_command_description_del_user' => 'Nollställer mängden trafik som registrerats för denna kund/återförsäljare till noll',
    'cu_resellerpref__option_lock_screen' => 'Förhindrar användare att arbeta med Plesk innan gränssnittskärmarna är fullständigt laddade',
];