<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'Installierte Anwendungen',
    'app.instances.buttonCheckForUpdates' => 'Auf Updates überprüfen',
    'app.instances.buttonScan' => 'Durchsuchen',
    'app.instances.hintButtonScan' => 'Durchsuchen Sie die Dateien Ihres Abonnements nach Anwendungen.',
    'app.instances.taskScan' => 'Suche nach Anwendungen...',
    'app.instances.undefinedApp' => 'Nicht definiert',
    'app.instances.name' => 'Name',
    'app.instances.installedTo' => 'Installationspfad',
    'app.instances.uninstall' => 'Entfernen',
    'app.instances.update' => 'Update verfügbar',
    'app.instances.noUpdates' => 'Es wurden keine Updates gefunden. Alle Anwendungen sind auf dem neuesten Stand.',
    'app.instances.foundUpdates' => 'Verfügbare Updates:',
    'app.instances.noInstallationUrlAvailable' => 'Keiner',

    'app.packages.title' => 'Verfügbare Anwendungen',
    'app.packages.name' => 'Name',
    'app.packages.version' => 'Version',
    'app.packages.summary' => 'Zusammenfassender Bericht',
    'app.packages.install' => 'Installieren',

    'app.services.title' => 'Verfügbare Services',
    'app.services.serviceID' => 'Service-ID',
    'app.services.name' => 'Name',
    'app.services.summary' => 'Zusammenfassender Bericht',
    'app.services.instantiate' => 'Instanz erstellen',

    'app.subserviceinstances.remove' => 'Entfernen',
    'app.subserviceinstances.hintRemove' => 'Entfernen Sie die ausgewählten Service-Instanzen.',
    'app.subserviceinstances.confirmOnDelete' => 'Möchten Sie wirklich die ausgewählten Service-Instanzen entfernen?',
    'app.subserviceinstances.serviceName' => 'Service-Name',
    'app.subserviceinstances.userName' => 'Benutzer',

    'contentfiles.name' => 'Name',
    'contentfiles.changeDate' => 'Geändert',
    'contentfiles.size' => 'Größe',
    'contentfiles.permissions' => 'Berechtigungen',
    'contentfiles.user' => 'Benutzer',
    'contentfiles.group' => 'Gruppe',
    'contentfiles.buttonUploadFiles' => 'Datei hochladen',
    'contentfiles.buttonUploadDirectory' => 'Verzeichnis hochladen',
    'contentfiles.buttonImportFileViaUrl' => 'Datei über URL importieren',
    'contentfiles.hintUploadFiles' => 'Laden Sie Dateien auf das aktuelle Verzeichnis hoch.',
    'contentfiles.buttonDeleteFile' => 'Entfernen',
    'contentfiles.hintDeleteFile' => 'Die ausgewählten Dateien entfernen.',
    'contentfiles.buttonPurgeFile' => 'Entfernen',
    'contentfiles.hintPurgeFile' => 'Die ausgewählten Dateien endgültig entfernen.',
    'contentfiles.buttonPurgeAll' => 'Papierkorb leeren',
    'contentfiles.buttonRotationSettings' => 'Rotationseinstellungen',
    'contentfiles.hintRotationSettings' => 'Einstellungen für Rotation anpassen',
    'contentfiles.hintPurgeAll' => 'Alle Dateien und Verzeichnisse endgültig aus dem Papierkorb entfernen.',
    'contentfiles.buttonCopyFiles' => 'Kopieren',
    'contentfiles.hintCopyFiles' => 'Kopieren Sie ausgewählte Dateien in ein anderes Verzeichnis.',
    'contentfiles.buttonMoveFiles' => 'Verschieben',
    'contentfiles.hintMoveFiles' => 'Verschieben Sie ausgewählte Dateien in ein anderes Verzeichnis.',
    'contentfiles.buttonMoreActions' => 'Mehr',
    'contentfiles.buttonCalculateSize' => 'Größe berechnen',
    'contentfiles.hintCalculateSize' => 'Berechnen Sie die Gesamtgröße von ausgewählten Dateien.',
    'contentfiles.buttonChangeTimestamp' => 'Zeitstempel ändern',
    'contentfiles.hintChangeTimestamp' => 'Ändern Sie den Zeitstempel von ausgewählten Dateien.',
    'contentfiles.buttonArchiveActions' => 'Archivieren',
    'contentfiles.buttonExtractArchive' => 'Dateien extrahieren',
    'contentfiles.hintExtractArchive' => 'Extrahieren Sie Dateien aus ausgewählten Archiven in das aktuelle Verzeichnis.',
    'contentfiles.buttonCreateArchive' => 'In Archiv packen',
    'contentfiles.hintCreateArchive' => 'Packen Sie die ausgewählten Dateien zu einem Archiv.',
    'contentfiles.buttonNewActions' => 'Neu',
    'contentfiles.buttonNewFile' => 'Datei erstellen',
    'contentfiles.hintNewFile' => 'Erstellen Sie eine Datei.',
    'contentfiles.buttonNewDirectory' => 'Verzeichnis erstellen',
    'contentfiles.hintNewDirectory' => 'Erstellen Sie ein Verzeichnis.',
    'contentfiles.rootDirectory' => 'Basisverzeichnis',
    'contentfiles.buttonView' => 'Ansichtsoptionen',
    'contentfiles.hintView' => 'Ändern Sie die Einstellungen des File Managers.',
    'contentfiles.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {{name}} one {die ausgewählte Datei bzw. das ausgewählte Verzeichnis} other {die # ausgewählten Dateien und Verzeichnisse}} wirklich dauerhaft entfernen?',
    'contentfiles.confirmOnDeleteToTrash' => '{count, plural, =1 {{name}} one {Die ausgewählte Datei bzw. das ausgewählte Verzeichnis} other {Die # ausgewählten Dateien und Verzeichnisse}} in den Papierkorb verschieben?',
    'contentfiles.deleteWithForce' => 'Papierkorb überspringen und {count, plural, =1 {{name}} one {die ausgewählte Datei bzw. das ausgewählte Verzeichnis} other {die # ausgewählten Dateien und Verzeichnisse}} dauerhaft entfernen.',
    'contentfiles.confirmOnPurge' => '{count, plural, =1 {{name}} one {Die ausgewählte Datei bzw. das ausgewählte Verzeichnis} other {Die # ausgewählten Dateien und Verzeichnisse}} dauerhaft entfernen?',
    'contentfiles.confirmOnPurgeAll' => 'Alle Dateien und Verzeichnisse endgültig aus dem Papierkorb entfernen?',
    'contentfiles.waitMessage' => 'Bitte warten ...',
    'contentfiles.readonlyHint' => 'Dieses Verzeichnis ist schreibgeschützt: Sie können keine Dateien oder Verzeichnisse darin erstellen.',
    'contentfiles.directoryNotFound' => 'Das Verzeichnis %%directory%% kann nicht gefunden werden: %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'Symbolische Verknüpfungen außerhalb des Webspace sind nicht zulässig %%symlink%%: %%error%%',
    'contentfiles.dragAndDropArea' => 'Verzeichnisse oder Dateien zum Upload hier herziehen',
    'contentfiles.nonUTF8' => 'Im File Manager können Dateien und Verzeichnisse nicht geöffnet werden, deren Namen Zeichen enthalten, die nicht UTF-8 entsprechen.',
    'contentfiles.non4ByteChar' => 'Im File Manager können Dateien und Verzeichnisse nicht geöffnet werden, deren Namen 4-Byte-Zeichen enthalten.',
    'contentfiles.searchInFilename' => 'In Dateiname suchen',
    'contentfiles.searchInFilenameAndContent' => 'Im Dateinamen und Inhalt suchen',
    'contentfiles.searchInContent' => 'Im Inhalt suchen',
    'contentfiles.menuItemFilename' => 'Nur Dateiname',
    'contentfiles.menuItemFilenameAndContent' => 'Dateiname und Inhalt',
    'contentfiles.menuItemContent' => 'Nur Inhalt',
    'contentfiles.noEntriesFound' => 'Keine Elemente gefunden.',
    'contentfiles.loadingTitle' => 'Wird gesucht...',
    'contentfiles.searchError' => 'Im aktuellen Verzeichnis kann nicht nach Dateien gesucht werden.',
    'contentfiles.searchErrorTimeout' => 'Die Suche dauerte zu lange und wurde abgebrochen.',
    'contentfiles.item-action-view' => 'Anzeigen',
    'contentfiles.item-action-textCodeEditor' => 'Im Code-Editor bearbeiten',
    'contentfiles.item-action-visualEdit' => 'Im HTML-Editor bearbeiten',
    'contentfiles.item-action-textEdit' => 'Im Texteditor bearbeiten',
    'contentfiles.item-action-browse' => 'Im Browser öffnen',
    'contentfiles.item-action-logBrowser' => 'Im Protokollbrowser öffnen',
    'contentfiles.item-action-download' => 'Herunterladen',
    'contentfiles.item-action-permissions' => 'Berechtigungen ändern',
    'contentfiles.item-action-rename' => 'Umbenennen',
    'contentfiles.item-action-extractArchive' => 'Dateien extrahieren',
    'contentfiles.item-action-imageView' => 'Anzeigen',
    'contentfiles.imageViewer' => 'Bildanzeige',
    'contentfiles.tooltipReadOnly' => 'Dieses Verzeichnis ist schreibgeschützt: Sie können keine Dateien oder Verzeichnisse darin erstellen.',

    'database.issues.type' => 'Typ',
    'database.issues.table' => 'Tabelle',
    'database.issues.code' => 'Code',
    'database.issues.problem' => 'Problem',
    'database.issues.icon-title-att' => 'Warnung',
    'database.issues.icon-title-warning' => 'Fehler',

    'database.users.login' => 'Name',
    'database.users.server' => 'Datenbankserver',
    'database.users.database' => 'Datenbank',
    'database.users.remove' => 'Entfernen',
    'database.users.hintRemove' => 'Ausgewählte Datenbankbenutzer entfernen.',
    'database.users.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {den Datenbankbenutzer {login}} one {die # ausgewählten Datenbankbenutzer} other {die # ausgewählten Datenbankbenutzer}} wirklich entfernen?',
    'database.users.disabledSelectHint' => 'Von einer installierten Webapp verwendet',
    'database.users.orphanedHint' => 'Nach Wiederherstellungsvorgang verwaist, bitte %%orphanedRepairLink%% Sie das Benutzerkonto.',
    'database.users.orphanedRepairLink' => 'reparieren',
    'database.users.anyDatabase' => 'Beliebige Datenbank',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => 'Zu Abonnement verschieben',
    'databases.assignToSubscription_powerUser' => 'Zu Webspace verschieben',
    'databases.assignToSubscriptionPopupTitle' => 'Datenbanken zu anderem Abonnement verschieben',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'Datenbanken zu anderem Webspace verschieben',
    'databases.assignToSubscriptionPopupDesc' => 'Die ausgewählten Datenbanken werden zum ausgewählten Abonnement verschoben. Datenbankbenutzer werden ebenfalls verschoben, es sei denn, sie haben Zugriff auf andere Datenbanken.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => 'Die ausgewählten Datenbanken werden zum ausgewählten Webspace verschoben. Datenbankbenutzer werden ebenfalls verschoben, es sei denn, sie haben Zugriff auf andere Datenbanken. Beachten Sie, dass nach diesem Verschieben bisherige Benutzer die Datenbanken nicht für die Verwaltung ihrer Inhalte über den Link in Plesk öffnen können.',
    'databases.loading' => 'Wird geladen',
    'databases.name' => 'Name',
    'databases.type' => 'T',
    'databases.server' => 'Datenbankserver',
    'databases.users' => 'Benutzer',
    'databases.remove' => 'Entfernen',
    'databases.hintRemove' => 'Ausgewählte Datenbanken entfernen.',
    'databases.confirmOnDelete' => 'Are you sure to remove {count, plural, =1 {the {name} database} one {the # selected database} other {the # selected databases}}?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'MS SQL Server',
    'databases.serverMysql' => 'Lokaler MySQL Server',
    'databases.serverPostgresql' => 'Lokaler PostgreSQL Server',
    'databases.serverMssql' => 'Lokaler MS SQL-Server',
    'databases.disabledSelectHint' => 'Von einer installierten Webapp verwendet',
    'databases.buttonMakeCopy' => 'Kopieren',
    'databases.buttonMakeCopyHint' => 'Erstellen Sie eine exakte Kopie der Datenbank oder kopieren Sie ihren Inhalt in eine bestehende Datenbank.',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => 'Verwalten Sie die Datenbanken über eine Weboberfläche.',
    'databases.buttonConnectionInfo' => 'Verbindungsdaten',
    'databases.buttonConnectionInfoHint' => 'Informationen, wie z. B. der Hostname und die Datenbankbenutzer-Zugangsdaten, die für die Verbindung zu dieser Datenbank erforderlich sind.',
    'databases.buttonPhpMyAdmin' => 'phpMyAdmin',
    'databases.buttonMyLittleAdmin' => 'myLittleAdmin',
    'databases.buttonDownloadDump' => 'Abbild exportieren',
    'databases.buttonDownloadDumpHint' => 'Exportieren Sie eine Kopie dieser Datenbank.',
    'databases.buttonUploadDump' => 'Abbild importieren',
    'databases.buttonUploadDumpHint' => 'Importieren Sie Ihre Kopie dieser Datenbank.',
    'databases.buttonDelete' => 'Datenbank entfernen',
    'databases.buttonDeleteHint' => 'Entfernen Sie diese Datenbank.',
    'databases.buttonDeleteDisabledHint' => 'Die Datenbank kann nicht entfernt werden. Sie wird von einer installierten Webapp verwendet.',
    'databases.buttonDeleteConfirmationText' => 'Möchten Sie die Datenbank %%name%% wirklich entfernen?',
    'databases.buttonActiveList' => 'Aktive Liste',
    'databases.buttonActiveListHint' => 'Zwischen Darstellungsmodi hin- und herschalten',
    'databases.buttonCheckAndFix' => 'Überprüfen und reparieren',
    'databases.buttonCheckAndFixHint' => 'Suchen Sie nach Problemen wie fehlerhafter Tabellenstruktur und lösen Sie diese.',
    'databases.buttonAssignToSubscription' => 'Zu Abonnement verschieben',
    'databases.buttonAssignToSubscriptionHint' => 'Verschieben Sie die Datenbanken zu einem anderen Abonnement.',
    'databases.buttonAssignToSubscription_powerUser' => 'Zu Webspace verschieben',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'Verschieben Sie die Datenbanken zu einem anderen Webspace.',
    'databases.promptPassword' => 'Geben Sie das Passwort ein, um sich als Datenbankbenutzer %%login%% anzumelden.',
    'databases.promptPasswordPopupTitle' => 'Geben Sie das Passwort an',
    'databases.taskCheckDatabase' => 'Datenbank überprüfen',
    'databases.taskRepairDatabase' => 'Datenbank reparieren',
    'databases.downloadTask' => 'Bereite ein Abbild von %%database%% zum Exportieren vor...',
    'databases.downloadPopupTitle' => 'Abbild exportieren',
    'databases.downloadHint' => 'Sie sind dabei, ein Abbild von %%database%% zu erstellen und es herunterzuladen.',
    'databases.downloadRelativePath' => 'Abbild in folgendem Verzeichnis speichern',
    'databases.downloadDumpName' => 'Name der Abbilddatei',
    'databases.downloadDumpAutomatically' => 'Abbild automatisch nach der Erstellung herunterladen',
    'databases.errorDumpNameEmpty' => 'Bitte geben Sie einen Abbildnamen an.',
    'databases.errorDumpNameInvalid' => 'Ein Abbildname darf keine der folgenden Zeichen enthalten: %%chars%%.',
    'databases.errorDumpNameTooLong' => 'Der Name der Abbilddatei ist zu lang. Ein vollständiger Abbildpfad darf nicht mehr als %%maxLength%% Zeichen umfassen.',
    'databases.uploadTask' => 'Importiere ein Abbild von %%database%%...',
    'databases.uploadPopupTitle' => 'Datenbankabbild importieren',
    'databases.uploadHint' => 'Laden Sie ein Abbild aus Ihrem lokalen Computer hoch oder importieren Sie ein Abbild, das auf Ihrem Hosting-Server gespeichert ist.',
    'databases.uploadFromFile' => 'Hochladen',
    'databases.uploadFromWebspace' => 'Importieren',
    'databases.recreateDatabase' => 'Datenbank neu erstellen',
    'databases.uploading' => 'Importiere...',
    'databases.waitMessage' => 'Bitte warten...',
    'databases.rootDirectory' => 'Stammverzeichnis',
    'databases.connectionInfoTitle' => 'Verbindungsdaten für %%database%%',
    'databases.connectionInfoDesc' => 'Sie können diese Details zur Datenbankverbindung z.B. nutzen, wenn Sie während der Installation einer Webanwendung aufgefordert werden, solche Informationen anzugeben.',
    'databases.connectionInfoServerAddress' => 'Host',
    'databases.connectionInfoDatabaseName' => 'Datenbankname',
    'databases.connectionInfoUserLogin' => 'Benutzername',
    'databases.connectionInfoUserPassword' => 'Passwort',
    'databases.connectionInfoNoUserLogin' => 'Kein Standardbenutzer',
    'databases.buttonClose' => 'Schließen',
    'databases.nothingFound' => "Keine Übereinstimmungen gefunden",
    'databases.moreObjectsAvailable' => 'Es sind %%count%% weitere Objekte verfügbar.',

    'dnsaclrecords.value' => 'IP-Adresse',
    'dnsaclrecords.add' => 'IP-Adresse hinzufügen',
    'dnsaclrecords.remove' => 'Entfernen',
    'dnsaclrecords.hintRemove' => 'Löschen Sie die ausgewählten IP-Adressen.',
    'dnsaclrecords.confirmOnDelete' => 'Ausgewählte IP-Adressen entfernen?',
    'dnsaclrecords.emptyViewTitle' => 'Zonenübertragung ist nicht zulässig',
    'dnsaclrecords.emptyViewDescription1' => 'Aus Sicherheitsgründen können Sie eine Übertragung der DNS-Zone nur an Server zulassen, die in den NS-Einträgen der Zone angegeben sind.',
    'dnsaclrecords.emptyViewDescription2' => 'Um einen oder mehrere Server anzugeben, auf die die Übertragung möglich sein soll, klicken Sie auf "IP-Adresse hinzufügen".',

    'dnsrecords.host' => 'Host',
    'dnsrecords.type' => 'Eintragstyp',
    'dnsrecords.value' => 'Wert',
    'dnsrecords.nameServer' => 'Nameserver',
    'dnsrecords.ipAddress' => 'IP-Adresse',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'Testen Sie die DNS-Zone auf dem Nameserver.',
    'dnsrecords.remove' => 'Entfernen',
    'dnsrecords.hintRemove' => 'Löschen Sie die ausgewählten DNS-Einträge.',
    'dnsrecords.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {den DNS-Eintrag {host}} one {den ausgewählten DNS-Eintrag} other {die # ausgewählten DNS-Einträge}} wirklich entfernen?',
    'dnsrecords.turnOff' => 'Deaktivieren',
    'dnsrecords.hintTurnOff' => 'Deaktivieren Sie den lokalen DNS-Service für die DNS-Zone %%name%%',
    'dnsrecords.turnOn' => 'Aktivieren',
    'dnsrecords.hintTurnOn' => 'Aktivieren Sie den lokalen DNS-Service für die Zone %%name%%',
    'dnsrecords.toggleTypeToSlave' => 'Zum Slave wechseln',
    'dnsrecords.toggleTypeToMaster' => 'Zum Master wechseln',
    'dnsrecords.hintToggleTypeToMaster' => 'Legen Sie diesen Server als Master-Nameserver für die Zone %%name%% fest.',
    'dnsrecords.hintToggleTypeToSlave' => 'Schalten Sie den Servicemodus für die DNS-Zone %%name%% auf Slave um.',
    'dnsrecords.hintToggleTypeDisabled' => 'Das Umschalten des DNS-Zonen-Servicemodus ist nicht möglich, da die DNS-Zone %%name%% von einem anderen Server bedient wird.',
    'dnsrecords.addRecord' => 'Eintrag hinzufügen',
    'dnsrecords.hintSpecifyNameServer' => 'Neuen Nameserver für %%name%% angeben',
    'dnsrecords.hintAddPrimaryDns' => 'Primären DNS-Server für %%name%% hinzufügen',
    'dnsrecords.hintAddRecord' => 'Erstellen Sie einen Ressourceneintrag in DNS-Zone %%name%%',
    'dnsrecords.restoreDefault' => 'Auf Standard zurücksetzen',
    'dnsrecords.hintRestoreDefault' => 'Erstellen Sie die DNS-Zone in Übereinstimmung mit dem serverweiten DNS-Template neu. Alle benutzerdefinierten Ressourceneinträge werden entfernt und alle vom Benutzer an der Zone vorgenommenen Änderungen werden verloren gehen.',
    'dnsrecords.syncZone' => 'DNS-Template anwenden',
    'dnsrecords.hintSyncZone' => 'Wenden Sie die Änderungen, die am serverweiten DNS-Template gemacht wurden, auf die Zone an. Sie können neue Ressourceneinträge hinzufügen und bestehende entfernen. Ressourceneinträge, die vom Benutzer hinzugefügt oder bearbeitet wurden, werden nicht beeinträchtigt.',
    'dnsrecords.applyChanges' => 'Die von Ihnen an den DNS-Einträgen vorgenommenen Änderungen wurden noch nicht gespeichert. Die Änderungen werden in der Liste der Einträge markiert. Klicken Sie auf Aktualisieren, um die Änderungen an der DNS-Zone zu übernehmen. Klicken Sie auf Zurücksetzen, um die Änderungen zu verwerfen.',
    'dnsrecords.updateButtonTitle' => 'Aktualisieren',
    'dnsrecords.updateButtonDescription' => 'Speichern Sie die Änderungen an den DNS-Einträgen.',
    'dnsrecords.revertButtonTitle' => 'Zurücksetzen',
    'dnsrecords.revertButtonDescription' => 'Verwerfen Sie die Änderungen an den DNS-Einträgen.',

    'emails.name' => 'E-Mail-Adresse',
    'emails.owner' => 'Benutzer',
    'emails.remove' => 'Entfernen',
    'emails.addNewEmail' => 'E-Mail-Adresse erstellen',
    'emails.hintAddNewEmail' => 'Erstellen Sie eine E-Mail-Adresse und weisen Sie sie einem Nutzer zu.',
    'emails.recalculateUsage' => 'Verbrauchsstatistiken aktualisieren',
    'emails.hintRecalculateUsage' => 'Berechnen Sie den tatsächlichen durch die Postfächer verwendeten Speicherplatz neu.',
    'emails.outgoingSpamSettings' => 'Ausgehende Nachrichten begrenzen',
    'emails.hintOutgoingSpamSettings' => 'Begrenzen Sie die Zahl der ausgehenden Nachrichten für die ausgewählten Postfächer. Für jedes Postfach bestimmt die angegebene Grenze die maximale Anzahl versendbarer Nachrichten.',
    'emails.searchByEmail' => 'E-Mail-Adresse',
    'emails.hintRemove' => 'Entfernen Sie ausgewählte E-Mail-Adressen.',
    'emails.webMailDisabledHint' => 'WebMail-Software ist nicht installiert.',
    'emails.webMailHint' => 'Öffnen Sie WebMail für diese E-Mail-Adresse in einem neuen Browser-Fenster.',
    'emails.editHint' => 'Erfahren Sie, wie Sie ein E-Mail-Konto in einem Mail-Client-Programm verwenden (z. B. Microsoft Outlook, Outlook Express, Thunderbird und Apple Mail).',
    'emails.confirmOnDelete' => 'Möchten Sie {count, plural, =1 {die E-Mail-Adresse {name}} one {die ausgewählte E-Mail-Adresse} other {die # ausgewählten E-Mail-Adressen}} wirklich entfernen?',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% (und %%countLeft%% mehr)',
    'emails.autoresponderEnabled' => 'Die automatische Antwort ist eingeschaltet.',
    'emails.autoresponderEnabledTill' => 'Die automatische Antwort ist bis %%endDate%% eingeschaltet.',
    'emails.spaceUsage' => 'Belegung',
    'emails.noMailbox' => 'Kein Postfach',
    'emails.statusNotOperable' => 'Der E-Mail-Service ist deaktiviert.',

    'failedrequestfiles.downloadZip' => 'ZIP herunterladen',
    'failedrequestfiles.downloadZipHint' => 'Laden Sie die ausgewählten Dateien als ZIP-Archiv herunter.',
    'failedrequestfiles.name' => 'Name',
    'failedrequestfiles.modificationDate' => 'Änderungsdatum',
    'failedrequestfiles.remove' => 'Entfernen',
    'failedrequestfiles.hintRemove' => 'Löschen Sie die fehlgeschlagenen Abfragedateien.',
    'failedrequestfiles.confirmOnDelete' => 'Möchten Sie die fehlgeschlagenen Abfragedateien entfernen?',
    'failedrequestfiles.viewHint' => 'Klicken Sie hier, um die fehlgeschlagene Abfragedatei anzusehen.',
    'failedrequestfiles.buttonChangeTracing' => 'Ablaufverfolgungsoptionen ändern',
    'failedrequestfiles.buttonChangeTracingHint' => 'Ändern Sie die aktuell definierten Einstellungen zur Ablaufverfolgung für Anforderungsfehler.',
    'failedrequestfiles.buttonDisableTracing' => 'Ablaufverfolgung beenden',
    'failedrequestfiles.buttonDisableTracingHint' => 'Beenden Sie die Ablaufverfolgung.',
    'failedrequestfiles.buttonEnableTracing' => 'Ablaufverfolgung starten',
    'failedrequestfiles.buttonEnableTracingHint' => 'Starten Sie die Ablaufverfolgung.',
    'failedrequestfiles.buttonRefresh' => 'Aktualisieren',
    'failedrequestfiles.buttonRefreshHint' => 'Klicken Sie hier, um alle fehlgeschlagenen Abfragen anzuzeigen, die den angegebenen Kriterien entsprechen. Beachten Sie allerdings, dass neu protokollierte fehlgeschlagene Abfragen nicht automatisch angezeigt werden.',

    'files.name' => 'Name',
    'files.modificationDate' => 'Geändert',
    'files.size' => 'Größe',
    'files.share' => 'Release',
    'files.shareHint' => 'Verschieben Sie die ausgewählten Dateien in den Ordner Freigegebene Dateien, damit alle in Plesk berechtigten Mitarbeiter darauf zugreifen können.',
    'files.publish' => 'Veröffentlichen',
    'files.publishHint' => 'Kopieren Sie die ausgewählten Dateien in den Ordner Öffentliche Dateien, damit Ihre Kunden und Besucher Ihrer Website darauf zugreifen können. Sie können den Zugriff auf diese Dateien mit einem Passwort schützen.',
    'files.email' => 'Link senden',
    'files.emailHint' => 'Senden Sie den Link für den Zugriff auf die ausgewählten Dateien per E-Mail an Mitarbeiter und Kunden.',
    'files.delete' => 'Löschen',
    'files.deleteHint' => 'Gewählte Dateien löschen',
    'files.moreActions' => 'Mehr',
    'files.createFolder' => 'Neuer Ordner',
    'files.createFolderHint' => 'Erstellen Sie im aktuellen Ordner einen Unterordner',
    'files.copy' => 'Kopieren',
    'files.copyHint' => 'Kopieren Sie die ausgewählten Dateien bzw. Ordner in ein Verzeichnis Ihrer Wahl.',
    'files.move' => 'Verschieben',
    'files.moveHint' => 'Verschieben Sie die ausgewählten Dateien bzw. Ordner in ein Verzeichnis Ihrer Wahl.',
    'files.protectedDescription' => 'Der Zugang zu den Dateien in diesem Ordner ist mit einem Passwort geschützt. Anwender werden aufgefordert, dieses Passwort einzugeben, wenn sie versuchen auf diese Dateien zuzugreifen.',
    'files.nothingSelected' => 'Es wurden keine Dateien oder Ordner ausgewählt.',

    'gitrepositories.lastCommitInfo' => 'Letzte Commit-Informationen:',
    'gitrepositories.deploymentActions' => 'Zusätzliche Bereitstellungsaktionen:',

    'logfiles.name' => 'Name',
    'logfiles.path' => 'Pfad',
    'logfiles.modificationDate' => 'Änderungsdatum',
    'logfiles.fileSize' => 'Größe',
    'logfiles.logRotation' => 'Protokoll-Rotation',
    'logfiles.logRotationHint' => 'Konfigurieren Sie die Einstellungen zur Protokoll-Rotation für die Website.',
    'logfiles.logRotationTitle' => 'Protokoll-Rotation konfigurieren',
    'logfiles.remove' => 'Entfernen',
    'logfiles.hintRemove' => 'Löschen Sie die ausgewählten Protokolldateien. Sie können nur verarbeitete Protokolldateien löschen.',
    'logfiles.confirmOnDelete' => 'Möchten Sie die ausgewählten Protokolldateien entfernen?',
    'logfiles.viewHint' => 'Klicken Sie hier, um die Protokolldatei anzuzeigen.',
    'logfiles.buttonDownloadHint' => 'Klicken Sie hier, um die Protokolldatei herunterzuladen.',
    'logfiles.buttonViewHint' => 'Klicken Sie hier, um die Protokolldatei in einem neuen Fenster anzuzeigen.',
    'logfiles.addCustomLog' => 'Benutzerdefiniertes Protokoll hinzufügen',
    'logfiles.addCustomLogHint' => 'Öffnen Sie eine Datei im Protokollbrowser.',
    'logfiles.customLogPopupTitle' => 'Benutzerdefiniertes Protokoll hinzufügen',
    'logfiles.invalidLogFormat' => 'Das Format der Protokolldatei wird nicht unterstützt.',
    'logfiles.buttonUnlinkHint' => 'Klicken Sie, um Updates in dieser Datei nicht mehr im Protokollbrowser zu verfolgen',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Möchten Sie wirklich Updates in dieser Datei nicht mehr im Protokollbrowser verfolgen?',
    'logfiles.buttonUnlinkConfirmationYes' => 'Ja',
    'logfiles.buttonUnlinkConfirmationNo' => 'Nein',
    'logfiles.accessLog' => 'Apache-Zugriff',
    'logfiles.accessLogProcessed' => 'Apache-Zugriff (rotiert)',
    'logfiles.accessSslLog' => 'SSL/TLS-Zugriff für Apache',
    'logfiles.accessSslLogProcessed' => 'SSL/TLS-Zugriff für Apache (rotiert)',
    'logfiles.errorLog' => 'Apache-Fehler',
    'logfiles.proxyAccessLog' => 'nginx-Zugriff',
    'logfiles.proxyAccessSslLog' => 'SSL/TLS-Zugriff für nginx',
    'logfiles.proxyErrorLog' => 'nginx-Fehler',
    'logfiles.phpErrorLog' => 'PHP-Fehler',
    'logfiles.iisAccessLog' => 'IIS-Zugriff',
    'logfiles.iisLog' => 'IIS (%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',

    'maillists.title' => 'Mailinglisten',
    'maillists.remove' => 'Entfernen',
    'maillists.name' => 'Adresse',
    'maillists.subscribers' => 'Mitglieder',
    'maillists.hintRemove' => 'Ausgewählte Mailinglisten entfernen.',
    'maillists.confirmOnDelete' => 'Ausgewählte Mailinglisten entfernen?',
    'maillists.openWebPanel' => 'Liste verwalten',
    'maillists.statusNotEnabled' => 'Ausgeschaltet.',
    'maillists.statusNotOperable' => 'Mailinglisten-Service ist ausgeschaltet.',

    'mailsettings.name' => 'Domainname',
    'mailsettings.mailService' => 'E-Mail-Service',
    'mailsettings.webmail' => 'WebMail',
    'mailsettings.nonexist' => 'An nicht vorhandene Benutzer gesendete E-Mails',
    'mailsettings.webmailNone' => 'Ohne',
    'mailsettings.nonExistBounce' => 'Bounce (Zurücksenden) mit Nachricht',
    'mailsettings.nonExistCatch' => 'Weiterleiten an %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => 'Die Adresse muss zur ausgewählten Domain gehören. Nur der Administrator kann eine externe Adresse oder eine gemeinsame Adresse für mehrere Domains angeben',
    'mailsettings.nonExistExternal' => 'Weiterleiten an %%catchIp%%',
    'mailsettings.nonExistReject' => 'Abweisen',
    'mailsettings.nonExistDiscard' => 'Abweisen',
    'mailsettings.statusEnabled' => 'Ein',
    'mailsettings.statusDisabled' => 'Aus',
    'mailsettings.searchByName' => 'Domainname',
    'mailsettings.editOutgoingSpamSettings' => 'Grenze bearbeiten',
    'mailsettings.numberOutgoingMessages' => 'Anzahl an ausgehenden Nachrichten',

    'roles.title' => 'Benutzerrollen',
    'roles.name' => 'Rollenname',
    'roles.description' => 'Beschreibung',
    'roles.remove' => 'Entfernen',
    'roles.numberOfUsers' => 'Benutzer',
    'roles.hintRemove' => 'Ausgewählte Benutzerrollen entfernen. Rollen können nur entfernt werden, wenn sie keinen Benutzerkonten zugewiesen sind.',
    'roles.disabledSelectHint' => 'Diese Rolle ist mindestens einem Benutzerkonto zugewiesen. Rollen können nur entfernt werden, wenn sie keinen Benutzerkonten zugewiesen sind.',
    'roles.builtInItemHint' => 'Diese Rolle kann nicht bearbeitet oder entfernt werden.',
    'roles.confirmOnDelete' => 'Ausgewählte Benutzerrollen entfernen?',

    'sites.selectdns.domain' => 'Domain',
    'sites.selectdns.dnsStatus' => 'Status',
    'sites.selectdns.statusOff' => 'DNS-Zonenverwaltung ist ausgeschaltet.',
    'sites.selectdns.statusMaster' => 'DNS-Zone ist im Master-Modus.',
    'sites.selectdns.statusSlave' => 'DNS-Zone ist im Slave-Modus.',
    'sites.selectdns.linkManage' => 'Verwalten',

    'sites.selectfrontpage.domain' => 'Domain',
    'sites.selectfrontpage.linkManage' => 'Verwalten',

    'sites.selectsimple.domain' => 'Domain',
    'sites.selectsimple.linkManage' => 'Verwalten',
    'sites.selectsimple.linkView' => 'Anzeigen',

    'sites.selectstatistics.domain' => 'Domain',
    'sites.selectstatistics.linkView' => 'Anzeigen',

    'sites.selecttrafficstatistics.domain' => 'Domain',
    'sites.selecttrafficstatistics.linkView' => 'Anzeigen',

    'sites.selectwebdeploy.domain' => 'Domain',
    'sites.selectwebdeploy.linkDownload' => 'Herunterladen',

    'sites.unitymobile.website' => 'Webseite',
    'sites.unitymobile.mobileSite' => 'Mobile Site-Name',
    'sites.unitymobile.createSite' => 'Mobile Website erstellen',
    'sites.unitymobile.launchEditor' => 'Website-Content bearbeiten',
    'sites.unitymobile.changeSiteName' => 'Site-Name ändern',
    'sites.unitymobile.delete' => 'Entfernen',
    'sites.unitymobile.confirmDeleteTitle' => 'Möchten Sie diese Mobile Site wirklich entfernen?',
    'sites.unitymobile.confirmDeleteDescription' => 'Der gesamte Content der Website wird verloren gehen.',

    'sites.domainHeader' => 'Domain',
    'sites.hostingHeader' => 'Hosting',
    'sites.diskUsage' => 'Belegter Speicherplatz',
    'sites.traffic' => 'Verkehr',
    'sites.buttonAddDomain' => 'Domain hinzufügen',
    'sites.buttonAddDomainHint' => 'Sie können eine neue Website auf diesem Server hosten, die Weiterleitung auf eine andere Website einrichten oder eine Domain-DNS-Zone einrichten, wenn Sie nur E-Mail-Adressen unter einem Domainnamen verwenden wollen.',
    'sites.buttonAddSubdomain' => 'Subdomain hinzufügen',
    'sites.buttonAddSubdomainHint' => 'Erstellen Sie eine Site, die von der Third-Level-Domain addressiert wird, z.B. shop.example.com.',
    'sites.buttonAddDomainAlias' => 'Domain-Alias hinzufügen',
    'sites.buttonAddDomainAliasHint' => 'Richten Sie einen zusätzlichen Domainnamen für Ihre Site ein.',
    'sites.buttonRemove' => 'Entfernen',
    'sites.buttonRemoveHint' => 'Entfernen Sie die ausgewählten Sites und deren Webcontent (inklusive Anwendungen und E-Mail-Daten).',
    'sites.buttonActivate' => 'Aktivieren',
    'sites.buttonSuspend' => 'Sperren',
    'sites.buttonClassicList' => 'Klassische Liste',
    'sites.buttonClassicListHint' => 'Zwischen Darstellungsmodi wechseln',
    'sites.buttonActiveList' => 'Aktive Liste',
    'sites.buttonActiveListHint' => 'Zwischen Darstellungsmodi hin- und herschalten',
    'sites.buttonDynamicList' => 'Dynamische Liste',
    'sites.buttonDynamicListHint' => 'Zwischen Darstellungsmodi wechseln',
    'sites.buttonFileManager' => 'Dateimanager',
    'sites.buttonMail' => 'E-Mail',
    'sites.buttonDatabases' => 'Datenbanken',
    'sites.buttonDatabasesCreate' => 'Datenbank hinzufügen',
    'sites.buttonDatabasesTogglerText' => 'oder',
    'sites.buttonDatabasesToggle' => 'Vorhandene Datenbank auswählen',
    'sites.buttonDatabasesEdit' => 'Öffnen',
    'sites.buttonDatabasesPromptPassword' => 'Geben Sie das Passwort ein, um sich als Datenbankbenutzer %%login%% anzumelden.',
    'sites.removeConfirmation' => 'Möchten Sie {count, plural, =1 {die Website {name}} one {die ausgewählte Website} other {die # ausgewählten Websites}} wirklich entfernen?',
    'sites.removeConfirmationSubscription' => "Die folgenden Websites werden auch entfernt:\n%%domains%%",
    'sites.manageFilesHint' => 'Gehen Sie zum Website-Ordner, um die Dateien der Website zu verwalten.',
    'sites.sitebuilderHint' => 'Bearbeiten Sie die Website in Presence Builder.',
    'sites.sitebuilderOldHint' => 'Site in SiteBuilder 4 oder Site Editor bearbeiten',
    'sites.webstatisticsHint' => 'Website-Besucherstatistiken anzeigen.',
    'sites.webstatisticsSslHint' => 'Berichte über Besuche Ihrer Websites via SSL/TLS aufrufen.',
    'sites.certificatesHint' => 'SSL/TLS-Zertifikate verwalten.',
    'sites.logsHint' => 'Protokolle anzeigen.',
    'sites.previewHint' => 'Vorschau dieser Website im Browser anzeigen.',
    'sites.dnsHint' => 'DNS-Zoneneinstellungen ändern.',
    'sites.disabledSelectHint' => 'Die Domain kann nicht entfernt werden.',
    'sites.websiteAt' => 'Website unter',
    'sites.noHosting' => 'Kein Webhosting',
    'sites.forwardingTo' => 'Weiterleiten an',
    'sites.add' => 'hinzufügen',
    'sites.name' => 'Domainname',
    'sites.inactive' => 'Inaktiv',
    'sites.disabled' => 'Deaktiviert',
    'sites.suspended' => 'Gesperrt',
    'sites.moreActions' => 'Mehr',
    'sites.domainAliasDescription' => 'Alias für %%siteDisplayName%% %%servicesDescription%%',
    'sites.domainAliasServiceDescription' => '(Aktivierte Services: %%service%%)',
    'sites.domainAliasServicesDescription' => '(Aktivierte Services: %%services%%)',
    'sites.web' => 'Web',
    'sites.mail' => 'E-Mail',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Java Apps',
    'sites.seoRedirect' => 'Weiterleitung',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLegacy' => 'SiteBuilder 4 oder Site Editor',
    'sites.sitebuilderLink' => 'Website bearbeiten',
    'sites.error503PageLink' => 'Fehlerseite bearbeiten',
    'sites.modeTitle' => 'Darstellungsmodus',
    'sites.quickStart' => 'Ihnen stehen die folgenden Optionen zur Verfügung, um mit der Gestaltung Ihrer Website zu beginnen:',
    'sites.quickStartSitebuilderName' => 'Presence Builder verwenden',
    'sites.quickStartSitebuilderDescription' => 'Bauen Sie Ihre Website mithilfe unseres professionellen Tools zur Erstellung von Websites auf.',
    'sites.quickStartSitebuilderLink' => 'Website erstellen',
    'sites.quickStartApplicationsName' => 'Anwendung installieren',
    'sites.quickStartApplicationsDescription' => 'Erstellen Sie Ihre Website durch Installation einer Webapp wie Joomla oder Drupal.',
    'sites.quickStartApplicationsLink' => 'Apps installieren',
    'sites.quickStartCustomName' => 'Benutzerdefinierte Website erstellen',
    'sites.quickStartCustomDescription' => 'Laden Sie Ihren Webinhalt hoch und fügen Sie Datenbanken hinzu.',
    'sites.quickStartCustomFilesLink' => 'Dateien',
    'sites.quickStartCustomDatabasesLink' => 'Datenbanken',
    'sites.resellerDescription' => 'Reseller',
    'sites.ownerDescription' => 'Kunde',

    'sslcertificates.name' => 'Name',
    'sslcertificates.used' => 'Verwendet',
    'sslcertificates.csrHint' => 'CSR-Teil bereitgestellt.',
    'sslcertificates.noCsrHint' => 'CSR-Teil nicht bereitgestellt.',
    'sslcertificates.privateKeyHint' => 'Privater Schlüssel bereitgestellt.',
    'sslcertificates.noPrivateKeyHint' => 'Privater Schlüsselteil nicht bereitgestellt.',
    'sslcertificates.certificateHint' => 'Zertifikatsteil bereitgestellt.',
    'sslcertificates.noCertificateHint' => 'Zertifikatsteil nicht bereitgestellt.',
    'sslcertificates.caCertificateHint' => 'CA-Zertifikatsteil bereitgestellt.',
    'sslcertificates.noCaCertificateHint' => 'CA-Zertifikatsteil nicht bereitgestellt.',
    'sslcertificates.buttonDownloadHint' => 'Laden Sie alle Zertifikatskomponenten herunter.',
    'sslcertificates.webmail' => 'Webmail schützen',
    'sslcertificates.hintWebmail' => 'Verwenden Sie das ausgewählte SSL/TLS-Zertifikat zum Schutz von Webmail in der Domain.',
    'sslcertificates.remove' => 'Entfernen',
    'sslcertificates.hintRemove' => 'Entfernen Sie die ausgewählten SSL/TLS-Zertifikate aus dem Domain-Repository.',
    'sslcertificates.confirmOnDelete' => 'Möchten Sie die ausgewählten SSL/TLS-Zertifikate entfernen?',
    'sslcertificates.addCertificate' => 'SSL/TLS-Zertifikat hinzufügen',
    'sslcertificates.hintAddCertificate' => 'Fügen Sie ein SSL/TLS-Zertifikat hinzu.',
    'sslcertificates.viewCertificates' => 'Zertifikate anzeigen',
    'sslcertificates.hintViewCertificates' => 'Rufen Sie die Liste der SSL/TLS-Zertifikate auf, die Sie bei Ihrem Provider erworben haben.',
    'sslcertificates.webmailCertificate' => 'Schützt Webmail',
    'sslcertificates.mailCertificate' => 'Schützt E-Mails',
    'sslcertificates.mailAndWebmailCertificate' => 'Schützt sowohl E-Mails als auch Webmail',
    'sslcertificates.mail' => 'E-Mails schützen',
    'sslcertificates.hintMail' => 'Verwenden Sie das ausgewählte SSL/TLS-Zertifikat zum Schutz von E-Mails in der Domain.',

    'subscriptions.subscription' => 'Abonnement',
    'subscriptions.price' => 'Gebühr',
    'subscriptions.renewalDate' => 'Ablaufdatum',
    'subscriptions.setupDate' => 'Einrichtungsdatum',
    'subscriptions.domains' => 'Websites',
    'subscriptions.systemUser' => 'Systembenutzer',
    'subscriptions.ipAddress' => 'IP-Adresse',
    'subscriptions.addonDomains' => 'Add-on-Domains',
    'subscriptions.diskSpace' => 'Speicherplatz',
    'subscriptions.moreDomains' => '... und %%count%% weitere Domains',
    'subscriptions.buy' => 'Neues Abonnement kaufen',
    'subscriptions.create' => 'Abonnement erstellen',
    'subscriptions.create_powerUser' => 'Webspace erstellen.',
    'subscriptions.renew' => 'Erneuern',
    'subscriptions.confirmOnCancel' => 'Sind Sie sicher, dass Sie das Abonnement abbrechen möchten?',
    'subscriptions.subscriptionSuspended' => 'Gesperrt',
    'subscriptions.myResources' => 'Meine Ressourcen',
    'subscriptions.planName' => 'Service-Paket',
    'subscriptions.switchToLink' => 'Wechseln auf Abonnement',
    'subscriptions.switchToLinkHint' => 'Auf dieses Abonnement wechseln.',
    'subscriptions.switchToLinkPowerUser' => 'Auf Webspace wechseln.',
    'subscriptions.switchToLinkHintPowerUser' => 'Auf dieses Webspace wechseln.',
    'subscriptions.buttonRemove' => 'Entfernen',
    'subscriptions.buttonRemoveDescription' => 'Ausgewählte Webspaces entfernen',
    'subscriptions.confirmOnDelete' => 'Wollen sie die ausgewählten Webspaces wirklich entfernen?',
    'subscriptions.buttonAddNew' => 'Webspace hinzufügen',
    'subscriptions.buttonAddNewDescription' => 'Webspace erstellen.',
    'subscriptions.subscription_powerUser' => 'Webspace',
    'subscriptions.subscriptionPowerUser' => 'Webspace',
    'subscriptions.confirmOnCancel_powerUser' => 'Sind Sie sicher, dass Sie den Webspace abbrechen möchten?',
    'subscriptions.subscriptionSuspended_powerUser' => 'Gesperrt',
    'subscriptions.switchToLink_powerUser' => 'Auf Webspace wechseln.',
    'subscriptions.switchToLinkHint_powerUser' => 'Auf dieses Webspace wechseln.',
    'subscriptions.primaryDomain' => 'Primäre Domain',
    'subscriptions.ftpAccess' => 'FTP-Zugang',

    'users.contactName' => 'Name des Kontakts',
    'users.email' => 'E-Mail-Adresse',
    'users.role' => 'Rolle',
    'users.contacts' => 'Kontakte',
    'users.phone' => 'Telefonnummer',
    'users.roleFilter' => 'Benutzerrolle',
    'users.filterAnyRole' => 'Beliebig',
    'users.activate' => 'Aktivieren',
    'users.deactivate' => 'Sperren',
    'users.remove' => 'Entfernen',
    'users.status' => 'Status',
    'users.statusBlocked' => 'Inaktiv',
    'users.buttonAddNewUser' => 'Benutzerkonto erstellen',
    'users.hintAddNewUser' => 'Erstellen Sie ein Benutzerkonto.',
    'users.hintRemove' => 'Ausgewählte Benutzerkonten entfernen.',
    'users.disabledSelectHint' => 'Dieses Benutzerkonto kann nicht entfernt werden, da es sich um ein integriertes Benutzerkonto oder Ihr eigenes Benutzerkonto handelt.',
    'users.confirmOnDelete' => 'Ausgewählte Benutzerkonten entfernen?',

    'webusers.name' => 'Name',
    'webusers.add' => 'Webbenutzer hinzufügen',
    'webusers.hintAdd' => 'Fügen Sie ein Webbenutzerkonto hinzu. %%resourceUsage%%',
    'webusers.settings' => 'Einstellungen',
    'webusers.hintSettings' => "Webnutzer-Einstellungen.",
    'webusers.remove' => 'Entfernen',
    'webusers.hintRemove' => 'Entfernen Sie die ausgewählten Webnutzer.',
    'webusers.confirmOnDelete' => 'Ausgewählte(n) Webnutzer entfernen?',
    'webusers.buttonOpenHomepageHint' => "Anklicken, um die Startseite des Webnutzers im Browser zu öffnen.",
];