<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: ฝั่งต้นทางส่งส่วนหัวขนาดใหญ่เกินไปในขณะที่กำลังอ่านส่วนหัวของการตอบกลับ',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: ไม่อนุญาตตัวเลือก FollowSymLinks ที่นี่"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "ถึงจำนวน max_children สูงสุดจำนวนที่ตั้งไว้บนเซิร์ฟเวอร์แล้ว"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptoms</h4><ul><li><p>เว็บไซต์ที่ตั้งตัวจัดการ PHP เป็น<strong>แอปพลิเคชัน FPM ซึ่งให้บริการโดย Apache</strong> หรือ <strong>แอปพลิเคชัน FPM ที่ให้บริการโดย nginx</strong> ที่<strong>โดเมน</strong> &gt; <strong>example.com</strong> &gt; <strong>การตั้งค่า PHP</strong> ประสบปัญหาใดปัญหาหนึ่งต่อไปนี้:</p><ul><li><p>โหลดช้า</p></li><li><p>ไม่สามารถเข้าถึงได้ (ถาวรหรือเป็นระยะ) โดยมีข้อผิดพลาด 50x ในเว็บบราวเซอร์:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>มีข้อความต่อไปนี้ปรากฏขึ้นในไฟล์บันทึกของ PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (ซึ่ง <em>XX</em> เป็นเวอร์ชัน PHP ที่เว็บไซต์ใช้งาน):</p><pre>คำเตือน: [pool example.com] ถึงจำนวน max_children สูงสุดจำนวนที่ตั้งไว้บนเซิร์ฟเวอร์แล้ว (*) โปรดพิจารณาเพิ่มจำนวนดังกล่าว</pre><ul><li><p>ปกติแล้ว ข้อความข้างต้นจะปรากฏขึ้นพร้อมข้อผิดพลาดนี้:</p><pre>ไม่สามารถอ่านสิ่งที่เครื่องรองพูดได้: ตัวอธิบายไฟล์ไม่ถูกต้อง (9)</pre></li></ul></li><li><p>หากเปิดใช้งาน nginx ไว้บนเซิร์ฟเวอร์ ข้อความข้อผิดพลาดต่อไปนี้ก็อาจปรากฏขึ้นในไฟล์บันทึกข้อผิดพลาดของโดเมนได้ <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: ทรัพยากรไม่พร้อมใช้งานชั่วคราว) ในขณะกำลังเชื่อมต่อกับฝั่งต้นทาง ไคลเอนท์: 203.0.113.2 เซิร์ฟเวอร์: example.com ขอ: "GET / HTTP/1.1" ฝั่งต้นทาง: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:" โฮสต์: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 ฝั่งต้นทางได้ปิดการเชื่อมต่อก่อนกำหนดในขณะที่กำลังอ่านส่วนหัวการตอบกลับจากฝั่งต้นทาง ไคลเอนท์: 203.0.113.2 เซิร์ฟเวอร์: example.com ขอ: "POST /path/to/some/file HTTP/2.0" ฝั่งต้นทาง:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>เว็บไซต์ถึงจำนวน <code>pm.max_children</code> สูงสุดของ PHP-FPM แล้ว</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>เพิ่มจำนวนจำกัด <code>pm.max_children</code> ให้กับโดเมนที่ได้รับผลแล้ว:</p><ol><li><p>เชื่อมกับเซิร์ฟเวอร์ Plesk ผ่าน <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>ค้นหาโดเมนที่ได้รับผลโดยใช้คำสั่งด้านล่าง:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>หมายเหตุ:</strong> จำนวนทางด้านซ้ายจะระบุจำนวนครั้งที่เว็บไซต์ถึงจำนวน <code>pm.max_children</code> ที่จำกัดไว้</div><pre style="white-space: pre-wrap;"># grep -r "ถึงจำนวน max_children สูงสุดจำนวนที่ตั้งไว้บนเซิร์ฟเวอร์แล้ว" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">เข้าสู่ระบบบน Plesk</a>.</p></li><li><p>ไปที่ <strong>โดเมน</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP Settings</strong> &gt; <strong>การตั้งค่า PHP-FPM</strong>.</p></li><li><p>เพิ่มค่าจำนวน <code>pm.max_children</code> ให้กับโดเมนแล้วปรับใช้การเปลี่ยนแปลง เพิ่มค่านี้ให้กับโดเมนทั้งหมดที่ระบุไว้ในขั้นตอนที่ 2 </p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "มีไฟล์ที่เปิดไว้มากไป"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx เริ่ม/โหลดเซิร์ฟเวอร์ Plesk ใหม่ไม่สำเร็จ: Too many open files</p><h4>Symptoms</h4><ul><li><p>The nginx service fails to start/reload with the following error in the <code>/var/log/nginx/error.log</code> file:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>ไม่สามารถเข้าถึงบางเว็บไซต์หรือเว็บไซต์ทั้งหมดได้</p></li><li><p>คำเตือนจะแสดงอยู่ใน <strong>เครื่องมือ &amp; การตั้งค่า &gt; การวินิจฉัย &amp; ซ่อมแซม</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>เว็บแอปพลิเคชันของ NodeJS และ Ruby แสดงข้อผิดพลาด 502 Bad Gateway เมื่อดำเนินงาน Plesk บางรายการ เช่น การสร้างโดเมน การสมัครสมาชิก การเปลี่ยนแปลงบน Apache หรือ Nginx เป็นต้น:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>เว็บเซิร์ฟเวอร์ได้รับการตอบกลับที่ไม่ถูกต้องในขณะที่ทำหน้าที่เป็นเกตเวย์หรือเซิร์ฟเวอร์พร็อกซี่</pre></li><li><p>หลังจากที่ <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">ติดตั้งใบรับรองใหม่ให้กับโดเมน</a> ใบรับรองเก่าจะยังคงแสดงในเว็บบราวเซอร์ อย่างไรก็ตาม จะมีการเลือกโดเมนที่ถูกต้องไว้ที่หน้า<strong>โดเมน &gt; example.com &gt; การตั้งค่าการโฮสต์</strong></p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>โฮสต์จำลองของ Nginx ได้เปิดไฟล์บันทึก 4 ไฟล์ให้กับโฮสต์จำลองแต่ละโฮสต์ด้วยการโฮสต์แบบกายภาพ:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>ด้วยเหตุนี้ เซิร์ฟเวอร์ nginx จึงเกินจำนวนไฟล์ที่เปิดได้สูงสุดเนื่องจากมีโดเมนจำนวนมาก (ปกิแล้วมากกว่า 100 โดเมน)</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>คำเตือน:</strong> การใช้ยูทิลิตี <code>websrv_ulimits</code> โดยไม่มีตัวเลือก <strong>--no-restart</strong> จะเริ่มการสร้างไฟล์กำหนดค่าของเว็บไซต์ขึ้นใหม่ให้กับโดเมนทั้งหมดและจะทำให้ระบบไม่ทำงานในกรณีที่ได้โฮสต์เว็บไซต์ไว้เป็นจำนวนมาก<br><br>การรันคำสั่งในระหว่างกรอบเวลาการซ่อมบำรุง</div><p>เป็นแนวปฏิบัติที่ดีในการตั้งค่าจำกัดการเปิดไฟล์ไว้มากกว่า <strong>ของจำนวนโดเมนใน Plesk * 16</strong> เป็นอย่างน้อย ที่ด้านล่างคือตัวอย่างวิธีการตั้งจำนวนจำกัดไว้ที่ 4096:</p><ol><li><p>เชื่อมต่อกับเซิร์ฟเวอร์ผ่าน <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>ตั้งจำนวนจำกัดสำหรับการเปิดไฟล์ไว้ที่ 4096 ให้กับทั้ง Apache และ Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>รีสตาร์ทบริการ Apache แบะ nginx services ที่ <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>เครื่องมือ &amp; การตั้งค่า &gt; การจัดการบริการ</strong> เพื่อปรับใช้การเปลี่ยนแปลง</p></li><li><p>ตรวจสอบว่า \'Max open files limit\' ได้ปรับใช้การเปลี่ยนแปลงอย่างถูกต้องหรือไม่ หลังจากที่รีสตาร์ทบริการของเว็บไซต์แล้ว:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>หากวิธีข้างต้นไม่ได้ผล ให้กำหนดขีดจำกัดโดยใช้คำสั่ง the <code>ulimit</code> utility:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP sessions "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];