<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomen</h4><ul><li><p>Websites waarvoor de PHP-handler is ingesteld als <strong>FPM application served by Apache</strong> of <strong>FPM application served by nginx</strong> onder <strong>Domeinen</strong> &gt; <strong>voorbeeld.nl</strong> &gt; <strong>PHP-instellingen</strong> lopen tegen een van de volgende problemen aan:</p><ul><li><p>lange laadtijd</p></li><li><p>niet beschikbaar (permanent of af en toe) met een 50x-foutmelding in de browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>De volgende boodschap verschijnt in het logbestand met PHP-FPM-foutmeldingen <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (waarbij <em>XX</em> de versie van PHP is die door de websites wordt gebruikt):</p><pre>WARNING: [pool voorbeeld.nl] server reached max_children setting (*), consider raising it</pre><ul><li><p>Dit bericht gaat doorgaans vergezeld met deze foutmelding:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>Als nginx op de server is ingeschakeld, dan zal een van de volgende foutmeldingen verschijnen in het logbestand met foutmeldingen van het domein <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/voorbeeld.nl/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: voorbeeld.nl, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/voorbeeld.nl/php-fpm.sock:", host: "voorbeeld.nl"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: voorbeeld.nl, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>The PHP-FPM <code>pm.max_children</code> has been reached by the website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>De beperking <code>pm.max_children</code> voor de getroffen domeinen verhogen:</p><ol><li><p>Maak verbinding met de Plesk-server via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Zoek naar getroffen domeinen met behulp van de opdracht hieronder:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Opmerking:</strong> Het getal aan de linkerkant geeft aan hoeveel keer de beperking <code>pm.max_children</code> door de website is bereikt.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 voorbeeld.nl<br>50 voorbeeld.com<br>25 voorbeeld.net<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Meld u aan bij Plesk</a>.</p></li><li><p>Ga naar <strong>Domeinen</strong> &gt; <strong>voorbeeld.nl</strong> &gt; <strong>PHP-instellingen</strong> &gt; <strong>PHP-FPM-instellingen</strong>.</p></li><li><p>Verhoog de waarde van <code>pm.max_children</code> voor het domein en pas de wijzigen toe. Verhoog deze waarde voor alle domeinen die in stap 2 zijn aangegeven.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server:: Too many open files</p><h4>Symptomen</h4><ul><li><p>De dienst nginx weigert op te starten of opnieuw te starten en geeft de volgende foutmelding in het bestand <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/voorbeeld.nl/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Een aantal of zelfs alle websites zijn onberehikbaar</p></li><li><p>Waarschuwing wordt getoond onder <strong>Hulpprogramma\'s &amp; instellingen&gt; Diagnose &amp; herstel</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>Webapplicaties gebouwd in NodeJS en Ruby tonen de foutmelding 502 Bad Gateway bij het uitvoeren van sommige Plesk-taken zoals het aanmaken van domeinen, abonnementen, bij het doorvoeren van wijzigingen in Apache of Nginx, enz:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>Na het <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">installeren van een nieuwe certificaat voor het domein</a> wordt de oude nog steeds geladen in de browser, terwijl het juiste certificaat is geselecteerd op de pagina <strong>Domeinen &gt; voorbeeld.nl &gt; Hosting-instellingen</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>De virtuele host van nginx opent 4 logbestanden voor elke virtuele host met fysieke hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Als gevolg hiervan kan het maximale aantal geopende bestanden door de nginx-server worden overschreden als er een groot aantal domeinen zijn (meestal meer dan 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Waarschuwing:</strong> het uitvoeren van het hulpprogramma <code>websrv_ulimits</code> zonder de optie <strong>--no-restart</strong> start het opnieuw opbouwen van webconfiguratiebestanden voor alle domeinen en dit kan een aanzienlijke downtime veroorzaken wanneer er een groot aantal websites wordt gehost.<br><br>Voer de opdracht daarom uit tijdens de onderhoudsperiode.</div><p>Het is een goed gebruikt de beperking van het aantal open bestanden in te stellen op meer dan <strong>het aantal domeinen in Plesk * 16</strong>. In het onderstaande voorbeeld worden de stappen aangegeven om de beperking in te stellen op 4096:</p><ol><li><p>Maak verbinding met de server via <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Stel de beperking van het aantal open bestanden in op 4096 voor zowel Apache als Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Start de services Apache en nginx opnieuw op vanuit <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Hulpprogramma\'s &amp; instellingen &gt; Beheer diensten</strong> om de wijzigingen toe te passen.</p></li><li><p>Controleer of \'Max open files limit\' na het opnieuw opstarten van de web services correct is toegepast:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 files</pre></li><li><p>Als de bovenstaande oplossing niet heeft geholpen, stel dan de beperking in met behulp van het hulpprogramma <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP-sessies "503 Internal Server Error" of "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];