<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Netzwerkadresse oder IP-Adresse',
    'access-network.subnetOrIpAddressHint' => 'Zum Beispiel 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletter',
    'admin.announcement-settings.getConsentLoading' => 'Informationen zu Newsletter werden abgerufen...',
    'admin.announcement-settings.getConsentWarning' => 'Der Status Ihres Abonnements konnte nicht abgerufen werden.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Ich würde gerne Newsletter von Plesk erhalten. Sie können auf die Sicherheit bezogene, technische und allgemeine Produktinformationen enthalten. Ich stimme zu und autorisiere Plesk dazu, meine persönliche Daten (E-Mail) im Einklang mit den derzeit gültigen Datenschutzgesetzen und einschließlich grenzüberschreitender Verarbeitung zu erfassen, zu verarbeiten und zu benutzen, um mir entweder direkt oder durch einen Drittanbieterdienst Newsletter zuzusenden. Wenn ich dieses Kontrollkästchen deaktiviere, wird dadurch meine Zustimmung rückgängig gemacht und Plesk dazu aufgefordert, mir keine weiteren E-Mails zu senden und meine persönliche Daten dauerhaft von seinen Systemen zu löschen.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Ja. Ich bestätige, dass ich den personalisierten Plesk Newsletter erhalten möchte. Plesk International GmbH und seine verbundenen Unternehmen können die von mir angegebenen Daten zum Zweck der Zusendung des Newsletters gemäß der %%privacyPolicy%% speichern und verarbeiten. Um die Nachrichten und Angebote zu personalisieren, kann Plesk auch zusätzliche Informationen zur Profilerstellung verwenden, wie Nutzungs- und Verhaltensdaten. Ich kann mich jederzeit von der Mailingliste abmelden.',
    'admin.announcement-settings.privacyPolicy' => 'Datenschutzrichtlinie von Plesk',
    'admin.announcement-settings.noConsent' => 'Plesk Newsletter abbestellen.',
    'admin.announcement-settings.reportConsentError' => 'Ihre Einstellungen zum Informationserhalt von Plesk konnten nicht gespeichert werden. %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Ihr Profil kann derzeit leider nicht aktualisiert werden. Bitte versuchen Sie es später erneut.',
    'admin.announcement-settings.invalidConsentType' => "Unbekannter Einwilligungstyp: '%%type%%'",
    'admin.announcement-settings.retry' => 'Erneut versuchen',
    'admin.announcement-settings.consentGivenInfo' => 'Wir hoffen, Sie finden unseren allgemeinen Newsletter von Plesk hilfreich. Wir bieten nun eine personalisierte Version mit hilfreichen Informationen und Tipps an, die genau auf Ihre Interessen abgestimmt sind. Wenn Sie diesen individuellen Newsletter von Plesk erhalten möchten, wählen Sie die erste Option unten aus und klicken Sie auf "OK".',
    'admin.announcement-settings.consentNotGivenInfo' => 'Sie haben unseren allgemeinen Newsletter nicht abonniert. Wir bieten nun eine personalisierte Alternative mit hilfreichen Informationen und Tipps an, die genau auf Ihre Interessen abgestimmt sind.',

    'admin.personal-info.title' => 'Administrator-Profile bearbeiten',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk Einstellungen',
    'admin.personal-info.settingsSectionLegend' => 'Einstellungen',

    'admin-alias.login' => 'Nutzername',
    'admin-alias.password' => 'Passwort',
    'admin-alias.passwordConfirmation' => 'Passwort bestätigen',
    'admin-alias.email' => 'E-Mail',
    'admin-alias.contact' => 'Name des Kontakts',
    'admin-alias.comments' => 'Anmerkungen',
    'admin-alias.emptyLogin' => 'Bitte geben Sie einen Nutzernamen an.',
    'admin-alias.loginTooLong' => 'Die Länge des Nutzernamens überschreitet 20 Zeichen.',
    'admin-alias.emptyEmail' => 'Bitte geben Sie eine E-Mail-Adresse an.',
    'admin-alias.emptyContactName' => 'Bitte geben Sie einen Ansprechpartner an.',
    'admin-alias.contactNameTooLong' => 'Die Länge des Namens des Ansprechpartners überschreitet 255 Zeichen.',
    'admin-alias.emptyPassword' => 'Bitte geben Sie ein Passwort an.',
    'admin-alias.commentsTooLong' => 'Die Länge des Kommentars überschreitet 255 Zeichen.',
    'admin-alias.emailActivation' => 'Account per E-Mail aktivieren',
    'admin-alias.simplePanel' => 'Eingeschränkten Modus aktivieren',
    'admin-alias.simplePanelHint' => 'Wählen Sie diese Option aus, um die Anzahl der Aktionen einzuschränken, die der zusätzliche Administrator in Plesk ausführen kann. Wenn Sie die verfügbaren Aktionen ändern möchten, rufen Sie %%link%% auf.',
    'admin-alias.simplePanelLink' => 'Tools & Einstellungen> Einstellungen für eingeschränkten Modus',
    'admin-alias.lockPowerUser' => 'Power-User-Ansicht für zusätzliche Administratoren erzwingen',
    'admin-alias.lockPowerUserHint' => 'Die Ansicht für zusätzliche Plesk Administratoren kann eingeschränkt werden, damit sie keinen Zugriff auf Kunden, Reseller und Service-Pakete haben.',

    'admin-info.plesk-settings.multiplyLogin' => 'Mehrere Sitzungen unter diesem Konto zulassen',
    'admin-info.plesk-settings.adminLanguage' => 'Sprache der Administratoroberfläche',
    'admin-info.plesk-settings.password' => 'Passwort',
    'admin-info.plesk-settings.passwordConfirmation' => 'Passwort bestätigen',

    'admin-panel.form.contact-info.contactName' => 'Name des Kontakts',
    'admin-panel.form.contact-info.emptyContactName' => 'Bitte geben Sie den Namen des Kontaktsn an.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Name des Kontakts ist zu lang (maximal %max% Zeichen sind zulässig).',
    'admin-panel.form.contact-info.email' => 'E-Mail-Adresse',
    'admin-panel.form.contact-info.emptyEmail' => 'Bitte geben Sie eine E-Mail-Adresse an.',
    'admin-panel.form.contact-info.companyName' => 'Firmenname',
    'admin-panel.form.contact-info.longCompanyName' => 'Dieser Firmenname ist zu lang (maximal %max% Zeichen sind zulässig).',
    'admin-panel.form.contact-info.phone' => 'Telefonnummer',
    'admin-panel.form.contact-info.longPhone' => 'Diese Faxnummer ist zu lang (maximal %max% Zeichen sind zulässig).',
    'admin-panel.form.contact-info.fax' => 'Faxnummer',
    'admin-panel.form.contact-info.imNumber' => 'Instant Messenger',
    'admin-panel.form.contact-info.longFax' => 'Diese Adresse ist zu lang (maximal %max% Zeichen sind zulässig).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Die angegebene Telefonnummer ist nicht gültig.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Die Faxnummer ist nicht korrekt.',
    'admin-panel.form.contact-info.address' => 'Adresse',
    'admin-panel.form.contact-info.longAddress' => 'Diese Adresse ist zu lang (maximal %max% Zeichen sind zulässig).',
    'admin-panel.form.contact-info.city' => 'Stadt',
    'admin-panel.form.contact-info.longCity' => 'Der Name der Stadt ist zu lang.',
    'admin-panel.form.contact-info.shortCity' => 'Der Name der Stadt ist zu kurz.',
    'admin-panel.form.contact-info.state' => 'US-Staat/Provinz/Region',
    'admin-panel.form.contact-info.postalCode' => 'Postleitzahl',
    'admin-panel.form.contact-info.country' => 'Land',
    'admin-panel.form.contact-info.additionalInfo' => 'Zusätzliche Informationen',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Nur Klartext: Alle HTML-Tags werden ignoriert.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Ein Benutzer mit dieser E-Mail-Adresse ist bereits im System vorhanden.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonnement',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Eigenschaften der Website, die zusammen mit dem Abonnement bereitgestellt wird.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Eigenschaften der Website, die zusammen mit dem Abonnement bereitgestellt wird.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Eigenschaften der Website, die zusammen mit dem Abonnement bereitgestellt wird.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Abonnement für den Kunden erstellen',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Deaktivieren Sie dieses Kontrollkästchen, wenn Sie für den Kunden im Moment kein Hosting-Service-Abonnement erstellen und keine Website einrichten wollen. Ohne Abonnement kann sich der Kunde nicht am Kunden-Panel anmelden.',
    'admin-panel.form.domain-info-section.domainName' => 'Domainname',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Bitte geben Sie einen Domainnamen an.',
    'admin-panel.form.domain-info-section.shared' => 'gemeinsam genutzt',
    'admin-panel.form.domain-info-section.exclusive' => 'dediziert',
    'admin-panel.form.domain-info-section.userName' => 'Benutzername',
    'admin-panel.form.domain-info-section.userNameHint' => 'Systembenutzerkonto, das verwendet wird, um Dateien und Ordner der im Abonnement erstellten Websites zu verwalten.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Bitte geben Sie einen Benutzernamen an.',
    'admin-panel.form.domain-info-section.password' => 'Passwort',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Bitte geben Sie ein Passwort an.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Passwort bestätigen',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4-Adresse',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "Die IP-Adresse, auf der die Website gehostet wird, ist eine Netzwerkadresse des virtuellen Hosts der Website.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6-Adresse',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Keine Angabe',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Zusätzliche Abonnementeinstellungen',
    'admin-panel.form.domain-info-section.credentials' => 'Anmeldedaten für Systembenutzer',
    'admin-panel.form.domain-info-section.credentialsHint' => 'für den Zugriff auf gehostete Dateien via FTP und SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'für den Zugriff auf gehostete Dateien via FTP und RDP',

    'admin-panel.form.login-info.userName' => 'Benutzername',
    'admin-panel.form.login-info.emptyUserName' => 'Bitte geben Sie einen Benutzernamen an',
    'admin-panel.form.login-info.password' => 'Passwort',
    'admin-panel.form.login-info.emptyPassword' => 'Bitte geben Sie ein Passwort an',
    'admin-panel.form.login-info.passwordConfirmation' => 'Passwort wiederholen',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Wenn Sie das Passwort ändern, wird auch das interne Passwort der E-Mail-Adresse geändert',
    'admin-panel.form.login-info.emailActivation' => 'Account per E-Mail aktivieren',
    'admin-panel.form.login-info.emailActivationHint' => 'Ein erstellter Account ist so lange inaktiv, bis der Benutzer ihn über den per E-Mail versendeten Link aktiviert, oder der Administrator ihn manuell aktiviert.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonnement',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Service-Paket',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Aktuelles Service-Paket',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Neues Service-Paket',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Einfacher Plan',
    'admin-panel.form.subscription-info-section.none' => 'Keines',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Add-ons',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Mit dem Anpassen der Abonnement-Parameter fortfahren, nachdem die Paket-Zuordnung geändert wurde. Bitte beachten, dass dadurch das Abonnement für die Synchronisierung gesperrt wird.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Passen Sie die Abonnement-Parameter nach der Erstellung an.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Passen Sie die Abonnement-Parameter nach der Erstellung des Kunden an.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Mit dem Anpassen der Abonnement-Parameter nach der Erstellung fortfahren. Bitte beachten, dass dadurch das Abonnement für die Synchronisierung gesperrt wird.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Bitte beachten Sie, dass dadurch das Abonnement für die Synchronisierung gesperrt wird.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Abonnement hinzufügen',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Das Abonnement konnte nicht mit dem Service-Paket synchronisiert werden. Die folgenden Einstellungen stehen in Konflikt mit dem Service-Paket: %%problems%%.',

    'app.configure.otherSettings' => 'Sonstiges',
    'app.configure.passwordConfirmation' => 'Passwort bestätigen',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Updates für alle installierten Apps erzwingen',
    'app.update-settings.forceUpdatesHint' => 'Alle Apps von Kunden werden automatisch aktualisiert, sobald Updates verfügbar sind. Die Kunden können dann die automatischen Updates für ihre Apps nicht ausschalten. Achtung: Verwenden Sie diese Option mit Vorsicht, denn Updates können die Funktionalität der Apps signifikant beeinträchtigen. Beispielsweise kann es vorkommen, dass App-Erweiterungen mit der Folgeversion einer App nicht mehr funktionieren.',
    'app.update-settings.suggestUpdates' => 'Option "App automatisch aktualisieren" standardmäßig aktivieren',
    'app.update-settings.suggestUpdatesHint' => 'Für neu installierte Apps wird die Option "App automatisch aktualisieren" in den Einstellungen der App aktiviert.',

    'backup.server-settings.rotation' => 'Maximale Anzahl der Dateien, die für vollständige Backups gespeichert werden können (gilt sowohl für geplante als auch manuelle Backups)',
    'backup.server-settings.rotationDescription' => 'Die Anzahl der vollständigen Backups, die Benutzer im Server speichern können. Wenn die Anzahl der gespeicherten vollständigen Backups über dem Grenzwert liegt, werden nur die neuesten Backups beibehalten. Dies betrifft nicht inkrementelle Backups.',
    'backup.server-settings.maxProcesses' => 'Maximale Anzahl gleichzeitig laufender geplanter Backupprozesse',
    'backup.server-settings.niceScheduled' => 'Geplante Backupvorgänge mit niedriger Priorität ausführen',
    'backup.server-settings.niceScheduledPriority' => 'Priorität',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Geben Sie einen Wert zwischen 1 und 19 ein. Je höher der Wert, desto niedriger die Priorität.',
    'backup.server-settings.niceScheduledIoPriority' => 'E/A-Priorität',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Geben Sie einen Wert zwischen 0 und 7 ein. Je höher der Wert, desto niedriger die Priorität.',
    'backup.server-settings.niceAlways' => 'Alle Backupprozesse mit niedriger Priorität ausführen',
    'backup.server-settings.niceAlwaysPriority' => 'Priorität',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Geben Sie einen Wert zwischen 1 und 19 ein. Je höher der Wert, desto niedriger die Priorität.',
    'backup.server-settings.niceAlwaysIoPriority' => 'E/A-Priorität',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Geben Sie einen Wert zwischen 0 und 7 ein. Je höher der Wert, desto niedriger die Priorität.',
    'backup.server-settings.compressionLevel' => 'Komprimierungsstufe',
    'backup.server-settings.compressionLevelNoCompression' => 'Keine Komprimierung',
    'backup.server-settings.compressionLevelFastest' => 'Am schnellsten',
    'backup.server-settings.compressionLevelFast' => 'Schnell',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Maximal',
    'backup.server-settings.freeSpaceRequired' => 'Backup nur starten, wenn mein Server über den festgelegten freien Speicherplatz verfügt (in Megabyte)',
    'backup.server-settings.checkBackupDiskSpace' => 'Backup nur starten, wenn genug Speicherplatz auf dem Server frei ist',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Native MS-SQL-Backup-Funktionalität verwenden (bei Remote-Datenbanken müssen Sie sichergehen, dass Sie die Backup-Einstellungen des Remote-MSSQL-Servers unter Tools & Einstellungen >  Datenbankserver konfiguriert haben)',
    'backup.server-settings.localFtpRestriction' => 'Auf dem lokalen Server darf ein FTP-Backupspeicher eingerichtet werden',
    'backup.server-settings.backupSecuritySettings' => 'Einstellungen zur Backupsicherheit',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Backups im Serverspeicher speichern, wenn der Upload in den Remote-Speicher fehlschlägt',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Manuelle und geplante Backups, die nicht wie vorhergesehen in den Remote-Speicher hochgeladen werden können, werden im lokalen Serverspeicher gespeichert. Benutzer müssen die Berechtigung haben, Backups im Serverspeicher aufzubewahren.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Kunden im Besitz des Admins',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Alle Kundenkonten, die in der Vorgängerversion von Plesk zu einem Administrator gehörten, wurden in Kundenkonten im Besitz des Administrators konvertiert: (1) Legacy-Ressourcen von jedem Kunden wurden beibehalten (zu finden unter der Bezeichnung \'Meine Ressourcen\' oben in der Abonnementliste des Kunden). Sie werden entfernt sobald die Übernahme abgeschlossen ist. (2) Alle ihre Domains wurden in Abonnements konvertiert (ein neues Abonnement von jeder Domain). (3) Domain-Administratoren wurden in Kunden-Benutzer umgewandelt, die nur Zugriff auf das Abonnement haben, das ihre Domain enthält.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Voriger Kundenstatus',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Anzahl an Kunden',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Übernahmeschema',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'Eine Domain; eine Anpassung der Grenze ist unzulässig.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Die Ressourcen des neuen Abonnements entsprechen dem Minimum der vorigen Kunden- oder Domaingrenzen.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'Eine Domain; eine Anpassung der Grenze ist zulässig.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Neue Abonnement-Ressourcen sind identisch zu vorigen Kundengrenzen.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Mehrere Domains; Domain-Erstellung und eine Anpassung der Grenzen ist unzulässig.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Die Ressourcen des neuen Abonnements werden von den vorigen Domaingrenzen übernommen.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Mehrere Domains; Domain-Erstellung und eine Anpassung der Grenzen ist zulässig.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Übernahme als:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Reseller. Ein voriger Kunde wird jetzt zu einem Reseller aufgestuft. Die Ressourcen von Reseller-Abonnements werden von den vorigen Kundengrenzen vererbt. Falls ein Domainadministratorkonto für eine vorige Domain aktiviert wurde, wird er auf ein Kundenkonto aufgestuft und das entsprechende Abonnement zugewiesen. Andernfalls gehören Abonnements direkt zum Reseller.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Kunde. Ein voriger Kunde bleibt ein Kunde. An der Aufteilung der Kunden-Ressourcen auf die verschiedenen Abonnements ändert sich nichts.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Reseller',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Kunden',
    'business-model-upgrade.bunch.t1s6-apply' => 'Übernahme dieser Kunden als',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Kunden im Besitz des Resellers',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Alle Kundenkonten, die in Plesk 9 zu einem Reseller gehörten, wurden in Kundenkonten des neueren Modells, deren Verantwortlicher der entsprechende Reseller ist, umgewandelt: (1) Die Legacy-Ressourcen von jedem Kunden wurden beibehalten (zu finden unter der Bezeichnung \'Meine Ressourcen\' oben in der Abonnementliste des Kunden). Sie werden, entfernt sobald die Übernahme abgeschlossen ist. (2) Alle ihre Domains wurden in Abonnements umgewandelt (1 neues Abonnement für jede Domain). (3) Domain-Administratoren wurden in Benutzer eines Kunden umgewandelt, die nur Zugriff auf das Abonnement mit ihrer Domain haben.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Voriger Kundenstatus',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Anzahl an Kunden',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Übernahmeschema',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'Eine Domain; eine Anpassung der Grenze ist unzulässig.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Die Ressourcen des neuen Abonnements entsprechen dem Minimum der vorigen Kunden- oder Domaingrenzen.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'Eine Domain; eine Anpassung der Grenze ist zulässig.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Neue Abonnement-Ressourcen sind identisch zu vorigen Kundengrenzen.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Mehrere Domains; Domain-Erstellung und eine Anpassung der Grenzen ist unzulässig.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Die Ressourcen des neuen Abonnements werden von den vorigen Domaingrenzen übernommen.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Mehrere Domains; Domain-Erstellung und eine Anpassung der Grenzen ist zulässig.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'An der Aufteilung der Kunden-Ressourcen auf die verschiedenen Abonnements ändert sich nichts.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Übernahme dieser Kunden',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Abonnements im Besitz des Admins',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Alle Domains, die in einer Vorgängerversion von Plesk zum Administrator gehörten, wurden in Abonnements des Administrators konvertiert. Domain-Administratoren wurden in Kunden-Panel-Benutzer umgewandelt und haben nur Zugriff auf das Abonnement, das ihre Domain enthält. Gehen Sie wie empfohlen vor, um diese Abonnements zu übernehmen oder wählen Sie ein benutzerdefiniertes Übernahmeschema für jedes Abonnement aus. Gehen Sie hierzu zur Registerkarte \'Benutzerdefinierte Übernahme von Abonnements\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Voriger Domainstatus',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Anzahl an Abonnements',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Übernahmeschema',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'Domain gehörte zum Admin. Das Domainadministratorkonto wurde aktiviert.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'Der vorige Domain-Administrator ist in der neuen Version ein Kunde und wird zu einem Abonnenten, was bedeutet, das ihm das Abonnement zugewiesen wird.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Übernahme dieser Abonnements',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Abonnements im Besitz des Resellers',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Alle Domains, die in einer Vorgängerversion von Plesk zu einem Reseller gehörten, wurden in Abonnements im Besitz des Resellers konvertiert. Domain-Administratoren wurden in Kunden-Panel-Benutzer umgewandelt und haben nur Zugriff auf das Abonnement, das ihre Domain enthält. Gehen Sie wie empfohlen vor, um diese Abonnements zu übernehmen oder wählen Sie ein benutzerdefiniertes Übernahmeschema für jedes Abonnement aus. Gehen Sie hierzu zur Registerkarte \'Benutzerdefinierte Übernahme von Abonnements\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Voriger Domainstatus',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Anzahl an Abonnements',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Übernahmeschema',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'Domain gehörte zu einem Reseller. Das Domainadministratorkonto wurde aktiviert.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'Der vorige Domain-Administrator ist in der neuen Version ein Kunde und wird zu einem Abonnenten, was bedeutet, das ihm das Abonnement zugewiesen wird.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Übernahme dieser Abonnements',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'Einige der ausgewählten Kunden und Abonnements wurden nicht übernommen.',

    'change-current-subscription.hint' => 'Hier ändern Sie für das Abonnement die Zuweisung von Service-Paketen. Bitte beachten Sie, dass wenn Sie \'Keines\' als neues Service-Paket ausgewählt haben, das Abonnement aus dem Service-Paket entfernt wird und als \'Benutzerdefiniert\' festgelegt wird.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Das Abonnement konnte nicht mit dem Service-Paket synchronisiert werden. Die folgenden Einstellungen stehen in Konflikt mit dem Service-Paket: %%problems%%.',

    'change-password.oldPassword' => 'Altes Passwort',
    'change-password.password' => 'Neues Passwort',
    'change-password.passwordConfirmation' => 'Passwort bestätigen',
    'change-password.oldPasswordIsIncorrect' => 'Das alte Passwort ist falsch. Bitte versuchen Sie es erneut.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Das zusätzliche Administratorkonto konnte nicht gefunden werden.',
    'change-password.warningAboutAdminPasswordSyntax' => "Das Passwort muss aus %%min%% bis %%max%% Zeichen bestehen und darf den Benutzernamen nicht enthalten.\nVerwenden Sie im Passwort keine Anführungszeichen, Leerzeichen und sprachspezifischen Zeichen.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Verwenden Sie im Passwort keine Anführungszeichen, Leerzeichen, Strichpunkte und sprachspezifischen Zeichen.\nDas Passwort muss aus %%min%% bis %%max%% Zeichen bestehen und darf den Benutzernamen nicht enthalten.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Überbuchungsrichtlinien',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Überbuchung ist zulässig',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Die Überbuchung (Overselling) erlaubt es einem Reseller, mehr Ressourcen als ihm im Paket zugewiesen zu verkaufen. Wenn die Überbuchung zulässig ist, dann gilt für einen Reseller der tatsächliche Ressourcenverbrauch und nicht die anfängliche Ressourcenzuweisung.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Überbuchung ist nicht zulässig',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Wenn die Überbuchung nicht zulässig ist, kann ein Reseller nur so viele Ressourcen verkaufen wie anfangs im Paket zugewiesen wurden, unabhängig davon, wie viele dieser Ressourcen tatsächlich verwendet werden.',

    'change-reseller-subscription.hint' => 'Hier ändern Sie für das Reseller-Abonnement die Zuweisung von Service-Paketen. Bitte beachten Sie, dass wenn Sie \'Keines\' als neues Service-Paket ausgewählt haben, das Abonnement aus den Service-Paketen entfernt wird und als \'Benutzerdefiniert\' festgelegt wird.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Das Abonnement konnte nicht mit dem Service-Paket synchronisiert werden. Die folgenden Einstellungen stehen in Konflikt mit dem Service-Paket: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Neues Paket',
    'change-reseller-subscription.oldSubscription' => 'Aktuelles Paket',
    'change-reseller-subscription.none' => 'Keines',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Die Abonnement-Zuweisung mit dem Service-Paket wurde aktualisiert.',
    'change-reseller-subscription.customizeSubscription' => 'Mit dem Anpassen der Abonnement-Parameter fortfahren, nachdem die Paket-Zuordnung aktualisiert wurde. Bitte beachten, dass dadurch das Abonnement für die Synchronisierung gesperrt wird.',

    'change-subscription.hint' => 'Hier ändern Sie für die ausgewählten Abonnements die Zuweisung von Service-Paketen.',
    'change-subscription.selectPlanLegend' => 'Service-Paket',
    'change-subscription.selectPlanDescription' => 'Um auf ein anderes Service-Paket umzustellen, wählen Sie ein neues Paket aus der Liste. Bitte beachten Sie, dass wenn Sie \'Keines\' ausgewählt haben, die Abonnements aus dem Service-Paket entfernt und als \'Benutzerdefiniert\' festgelegt werden.',
    'change-subscription.servicePlan' => 'Neues Service-Paket',
    'change-subscription.selectAddonPlansLegend' => 'Add-on-Pakete',
    'change-subscription.selectAddonPlansDescription' => 'Add-on-Pakete hinzufügen oder entfernen',
    'change-subscription.noChange' => 'keine Änderungen',
    'change-subscription.none' => 'Keines',
    'change-subscription.add' => 'hinzufügen',
    'change-subscription.del' => 'entfernen',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Netzwerkadresse oder IP-Adresse',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Zum Beispiel 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Zugang zu Plesk mit Administratorrechten',
    'control-panel-access.settings.policyAllow' => 'Erlaubt mit Ausnahme der Netzwerke in der Liste.',
    'control-panel-access.settings.policyDeny' => 'Verweigert von den Netzwerken, die nicht aufgelistet sind.',

    'create-subscription.title' => 'Hinzufügen eines Abonnements',
    'create-subscription.titleOwn' => 'Eigenes Abonnement hinzufügen',
    'create-subscription.poolIsEmpty' => 'Es kann kein Abonnement erstellt werden, da keine gemeinsam genutzten oder dedizierten IP-Adressen in Plesk verfügbar sind.',
    'create-subscription.infoNewSubscriptionCreated' => 'Das Abonnement %%name%% wurde erstellt.',
    'create-subscription.createBeforeAppInstall' => 'Sie benötigen ein Abonnement, um die Anwendung zu installieren.',

    'customer.hint' => 'Hier können Sie einen neuen Kunden für Ihre Hosting-Services anmelden. Mit der Anmeldung erstellen Sie ein Kundenkonto in Plesk und ein Abonnement für eines Ihrer Hosting-Pakete und - optional - Add-ons. Es kann aber auch ein Abonnement für eine vollständig benutzerdefinierte, nicht an ein Paket gebundene Zusammenstellung aus Ressourcen und Services erstellt werden -- wählen Sie hierzu \'Keines\' neben dem Service-Paket aus.',
    'customer.contactInfoSection' => 'Kontaktdaten',
    'customer.additionalInfoSection' => 'Zusätzliche Kundeninformationen',
    'customer.accessToPanelSection' => 'Zugang zu Plesk',
    'customer.contactInfoSectionHint' => 'Geben Sie die Kontaktdaten des Kunden ein.',
    'customer.accessToPanelSectionHint' => 'Zugangsdaten, die der Kunde für den Zugriff auf sein Kunden-Panel verwenden wird.',
    'customer.unableCreateSubscription' => 'Das Abonnement kann nicht erstellt werden: %%reason%%',
    'customer.poolIsEmpty' => 'Der IP-Pool ist leer',
    'customer.buttonOk' => 'Kunden hinzufügen',

    'database-settings.dbPrefixRadio' => 'Präfix und Unterstrich an den Anfang von Datenbanknamen anfügen',
    'database-settings.dbPrefixNone' => 'Ohne',
    'database-settings.dbPrefixUsername' => 'Benutzername',
    'database-settings.dbPrefixExternalId' => 'Externe ID eines Abonnements',
    'database-settings.dbUserPrefix' => 'Benutzernamen und Unterstrich an den Anfang von Datenbankbenutzernamen anfügen',
    'database-settings.dbUserPrefixHint' => 'Datenbankbenutzernamen haben das Format <plesk_benutzername>_<datenbankbenutzername>. Aufgrund der Beschränkung der Länge von Benutzernamen in Datenbanken kann <plesk_benutzername> abgekürzt werden.',
    'database-settings.grantAlterDatabase' => 'Alle Microsoft SQL Server Datenbankbenutzer erhalten die Berechtigung ALTER DATABASE',
    'database-settings.grantAlterDatabaseHint' => 'Diese Berechtigung erhalten neue und bestehende Benutzer.',
    'database-settings.enableBackupOperator' => 'Die Mitgliedschaft in der Rolle db_backupoperator für alle Microsoft-SQL-Server-Datenbankbenutzer aktivieren',
    'database-settings.enableBackupOperatorHint' => 'Dieser Rolle werden neue wie auch bestehende Benutzer angehören.',
    'database-settings.aclRadio' => 'Standardeinstellungen für Remotezugriff von Datenbankbenutzern',
    'database-settings.aclLocalhost' => 'Nur lokale Verbindungen zulassen',
    'database-settings.aclAny' => 'Remoteverbindungen von beliebigem Host zulassen',
    'database-settings.aclCustom' => 'Remoteverbindungen zulassen von',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDie angegebenen Hosts dürfen im Namen dieses Benutzers auf die Datenbank zugreifen.",
    'database-settings.aclDescription' => 'Mit dieser Einstellung werden nur die Berechtigungen der Benutzer geändert. Um den Remotezugriff auf einen lokalen MySQL-Server zu aktivieren, wählen Sie die entsprechende Option in den <a href="/server/db_server_edit.php?db_server_id=%d">Einstellungen für den lokalen MySQL-Server</a> aus.',
    'database-settings.example' => "Zum Beispiel:\n%%example%%",

    'dns.template.synchronize-done' => 'Das DNS-Zonen-Template wurde erfolgreich übernommen.',
    'dns.template.synchronize-error' => 'Das DNS-Zonen-Template wurde auf einige DNS-Zonen nicht angewendet.',
    'dns.template.synchronize-progress' => 'DNS-Zonen-Template wird übernommen.',

    'domain-restriction.name' => 'Domainname',
    'domain-restriction.nameDescription' => 'Sie können ein Platzhalterschema angeben, indem Sie ein Sternchen (*) verwenden. Beispielsweise *.beispiel.com',
    'domain-restriction.domainAlreadyExists' => 'Der angegebene Domainname befindet sich bereits in der Liste.',

    'event-handler.eventLabel' => 'Ereignis',
    'event-handler.priorityLabel' => 'Priorität',
    'event-handler.userLabel' => 'Benutzer',
    'event-handler.commandLabel' => 'Befehl',
    'event-handler.commandHint' => 'Geben Sie für ein optimales Ergebnis den vollständigen Pfad zu einer Skriptdatei in das Feld "Befehl" ein. Wir empfehlen, keine Systembefehle einzugeben, da diese möglicherweise nicht funktionieren. Ein Beispiel für nicht funktionierende Systembefehle sind Befehle, die Operatoren für die Ausgabeumleitung < oder > enthalten.',
    'event-handler.priorityHighestText' => 'höchste',
    'event-handler.priorityHighText' => 'hoch',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'gering',
    'event-handler.priorityLowestText' => 'geringste',
    'event-handler.priorityCustomText' => 'benutzerdefiniert',
    'event-handler.priorityHighestOption' => 'am höchsten (%%value%%)',
    'event-handler.priorityHighOption' => 'hoch (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'niedrig (%%value%%)',
    'event-handler.priorityLowestOption' => 'am niedrigsten (%%value%%)',

    'extension.upload.fileUpload' => 'Pfad zur Paketdatei für die Erweiterung',

    'external-webmail.hint' => 'Sobald Sie einen zusätzlichen Webmail-Service in Plesk registrieren, wird er für Ihre Kunden verfügbar sein: Er wird als Option in den Einstellungen \'E-Mail\' der Hosting-Pakete und Abonnements angezeigt. Der Webmail-Name wird in der Liste der Webmail-Optionen angezeigt und die URL öffnet sich nach einem Klick auf das Webmail-Symbol neben einem Postfach im Kunden-Panel.',
    'external-webmail.name' => 'Name des Webmail-Services',
    'external-webmail.url' => 'URL des Webmail-Services',
    'external-webmail.enabled' => 'Verfügbar',

    'ftp-settings.generalSection' => 'Allgemein',
    'ftp-settings.portRange' => 'Port oder Portbereich für passive FTP-Modus-Verbindungen',
    'ftp-settings.hintPortRange' => '(Standardwert: %%defaultPortRange%%)',

    'health.upload.hint' => 'Laden Sie die Konfiguration zur Systemüberwachung hoch. Die Konfiguration wird übernommen, sobald die Datei hochgeladen wurde.',
    'health.upload.selectFile' => 'Konfigurationsdatei',

    'install-local-package.selectUploadType' => 'Führen Sie eine der folgenden Aktionen aus:',
    'install-local-package.uploadAsFile' => 'APS-Paket hochladen',
    'install-local-package.downloadFromCatalog' => 'Anwendung vom Anwendungskatalog auswählen',
    'install-local-package.formInfo' => "Erweitern Sie die Liste der verfügbaren Anwendungen durch den Upload einer neuen Anwendung, oder fügen Sie eine Anwendung vom Anwendungskatalog hinzu, um sie weiter zu konfigurieren.",
    'install-local-package.invalidFileExtension' => 'Die hochgeladene Anwendung muss sich in einem ZIP-Archiv befinden (mit der Erweiterung .zip).',
    'install-local-package.packagesNotSelected' => 'Keines der Pakete wurde ausgewählt.',
    'install-local-package.visible' => 'Für Kunden verfügbar machen',
    'install-local-package.isCommercial' => 'Dies ist eine kommerzielle App, für die der Kauf eines Lizenzschlüssels erforderlich ist.',
    'install-local-package.visibleDescription' => 'Stellen Sie Kunden die Anwendung für die Installation zur Verfügung.',

    'ip-address.generalSection' => 'Allgemein',
    'ip-address.interface' => 'Schnittstelle',
    'ip-address.addressAndSubnetPrefixLength' => 'IP-Adresse und Subnetzmaske',
    'ip-address.publicIp' => 'Öffentliche IP-Adresse',
    'ip-address.hintPublicIp' => 'Sie können eine öffentliche IP-Adresse verwenden, wenn NAT für Ihren Plesk-Server eingesetzt wird.',
    'ip-address.distributionType' => 'IP-Adresse wird bereitgestellt als',
    'ip-address.distributionTypeShared' => 'Gemeinsam genutzt',
    'ip-address.distributionTypeExclusive' => 'Dediziert',
    'ip-address.certificate' => 'SSL/TLS-Zertifikat',
    'ip-address.defaultSite' => 'Standard-Site',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Auf dem installierten FTP-Server wird FTPS nicht unterstützt.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Der installierte FTP-Server unterstützt keine IPv6-Adressen.',
    'ip-address.interfaceDHCPEnabled' => 'Die IP-Adresse kann nicht hinzugefügt werden. In dieser Netzwerkschnittstelle werden IP-Adressen automatisch abgerufen.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Hinweis: Die benutzerdefinierte Plesk URL ist für alle unbekannten Domains aktiviert. Die Plesk Benutzeroberfläche wird statt der Standardwebsite unter &quot;https://%%ip%%/&quot; angezeigt.',

    'ip-ban.filter.name' => 'Name',
    'ip-ban.filter.content' => 'Inhalt',
    'ip-ban.filter.filterExistsError' => 'Ein Filter mit diesem Namen ist bereits vorhanden.',

    'ip-ban.jail.name' => 'Name',
    'ip-ban.jail.filter' => 'Filtern',
    'ip-ban.jail.filterDescription' => 'Wählen Sie den Filter aus.',
    'ip-ban.jail.action' => 'Aktion',
    'ip-ban.jail.actionDescription' => 'Wählen Sie eine Aktion aus und klicken Sie auf die Schaltfläche, um sie hinzuzufügen.',
    'ip-ban.jail.logPath' => 'Protokollpfad',
    'ip-ban.jail.banTime' => 'Zeitraum für IP-Adress-Sperre',
    'ip-ban.jail.maxRetry' => 'Maximale Anzahl an fehlgeschlagenen Anmeldeversuchen',
    'ip-ban.jail.timeUnit' => 'Sekunden',
    'ip-ban.jail.addAction' => 'Hinzufügen',
    'ip-ban.jail.chooseAction' => 'Wählen Sie aus:',
    'ip-ban.jail.apache-auth-filter-description' => 'Fehlgeschlagene Apache-Autorisierung (bei Protokollierung in Datei)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Fehlgeschlagene Apache-Autorisierung (bei Protokollierung)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Fehlgeschlagene Apache-Autorisierung (bei Protokollierung in syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spambots und bösartige Webcrawler',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Fehlgeschlagene IMAP- und POP3-Authentifizierung mit Courier',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Fehlgeschlagene IMAP-, POP3- und Sieve-Authentifizierung mit Dovecot',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Fehlgeschlagene IMAP-, POP3- und Sieve-Authentifizierung mit Dovecot (aggressiver Modus)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Fehlgeschlagene Horde-Webmail-Authentifizierungen',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Verstöße gegen Sicherheits- und Zugriffskontrollen in Web Application Firewall (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Fehlgeschlagene Plesk Authentifizierungen',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Fehlgeschlagene QMail-SMTP-Authentifizierungen',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Fehlgeschlagene Roundcube-Webmail-Authentifizierungen',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Fehlgeschlagene WordPress-Authentifizierung',
    'ip-ban.jail.postfix-filter-description' => 'Fehler im Postfix-SMTP-Client (inklusive RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Fehler, fehlgeschlagene Authentifizierung und DDoS-Angriffe im Postfix-SMTP-Client',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Fehlgeschlagene SMTP- und SASL-Authentifizierung mit Postfix',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'DDoS-Angriffe auf SMTP-Dienst Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Fehler und fehlgeschlagene Authentifizierung im Postfix-SMTP-Client',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Fehler im Postfix-SMTP-Client (inklusive RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Fehler im Postfix-SMTP-Client (nur RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Fehlgeschlagene ProFTPD-Anmeldeversuche',
    'ip-ban.jail.recidive-filter-description' => 'Hosts wiederholt von Fail2Ban gesperrt',
    'ip-ban.jail.sshd-filter-description' => 'Fehlgeschlagene SSH-Anmeldeversuche',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Fehlgeschlagene SSH-Anmeldung, Aushandlungsfehler und DDoS-Angriffe',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Fehlgeschlagene SSH-Anmeldung und DDoS-Angriffe',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Fehlgeschlagene SSH-Anmeldung und Aushandlungsfehler',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Sperren via firewalld-Firewall, auf allen Ports',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Sperren via firewalld-Firewall, auf mehreren Ports',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Sperren via firewalld-Firewall, auf einem einzigen Port',
    'ip-ban.jail.iptables-action-description' => 'Sperren via iptables-Firewall, auf einem einzigen Port',
    'ip-ban.jail.iptables-allports-action-description' => 'Sperren via iptables-Firewall, auf allen Ports',
    'ip-ban.jail.iptables-multiport-action-description' => 'Sperren via iptables-Firewall, auf mehreren Ports',
    'ip-ban.jail.sendmail-action-description' => 'E-Mail-Benachrichtigung via Sendmail senden',
    'ip-ban.jail.jailExistsError' => 'Eine Jail mit diesem Namen ist bereits vorhanden.',
    'ip-ban.jail.invalidInteger' => 'Der angegebene Wert ist ungültig. Geben Sie eine Ganzzahl an.',

    'ip-ban.settings.pageHint' => 'Hier können Sie die Sperre von IP-Adressen einrichten, um Ihre Server und gehosteten Websites vor schadhaftem Traffic zu schützen.',
    'ip-ban.settings.detectionEnabled' => 'Angriffserkennung aktivieren',
    'ip-ban.settings.banPeriod' => 'Zeitraum für IP-Adress-Sperre',
    'ip-ban.settings.banTimeWindow' => 'Zeitintervall für Erkennung nachfolgender Angriffe',
    'ip-ban.settings.maxRetries' => 'Anzahl an fehlgeschlagenen Versuchen, bevor die IP-Adresse gesperrt wird',
    'ip-ban.settings.timeUnit' => 'Sekunden',
    'ip-ban.settings.invalidInteger' => 'Sie haben einen ungültigen Wert angegeben. Bitte geben Sie eine positive ganze Zahl an.',

    'ip-ban.trusted-ip.ipAddress' => 'IP-Adresse',
    'ip-ban.trusted-ip.hintIpAddress' => 'Geben Sie eine IP-Adresse, CIDR-Maske oder einen DNS-Hostnamen ein.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Die angegebene IP-Adresse, die Netzwerkadresse oder der Hostname ist ungültig.',

    'login-info.hint' => 'Hier können Sie den Benutzernamen und das Passwort ändern, die der Kunde für den Zugriff auf sein Kunden-Panel verwendet.',
    'login-info.resellerHint' => 'Hier können Sie den Benutzernamen und/oder das Passwort ändern, die der Reseller für den Zugang zu seinem Plesk verwendet.',
    'login-info.myProfileHint' => 'Hier können Sie das Passwort ändern, das Sie für den Zugang zu Ihrem Plesk verwenden.',

    'mail.lists-server-settings.email' => "E-Mail-Adresse des Mailinglisten-Administrators",
    'mail.lists-server-settings.emptyEmail' => 'Bitte geben Sie eine E-Mail-Adresse an.',
    'mail.lists-server-settings.newPassword' => 'Neues Passwort',
    'mail.lists-server-settings.emptyPassword' => 'Bitte geben Sie ein Passwort an.',
    'mail.lists-server-settings.passwordConfirmation' => 'Passwort bestätigen',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Die Mailinglistensoftware wurde konfiguriert.',

    'mail.outgoing-messages.hint' => 'Hier können Sie eine Grenze für von einem Postfach abgehende Nachrichten angeben.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Die maximale Anzahl an abgehenden E-Mails',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% Nachrichten pro Stunde)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Benutzerdefinierter Wert für dieses Postfach',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'Nachrichten pro Stunde',

    'mail-gate-settings.host' => 'Hostname oder IP-Adresse',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Nutzername',
    'mail-gate-settings.password' => 'Passwort',
    'mail-gate-settings.encryption' => 'SMTP-Server erfordert verschlüsselte Verbindung',
    'mail-gate-settings.allowUsers' => 'Skripte von Nutzern dürfen E-Mails über diesen SMTP-Server senden (unter Verwendung des angegebenen Benutzernamens und Passworts)',
    'mail-gate-settings.useDefaultSettings' => 'Den mit Plesk installierten Mailserver und das von Plesk erstellte Standard-E-Mail-Konto nutzen',

    'mail-gate.hint' => 'Hier können Sie den SMTP-Server angeben, der verwendet werden soll, wenn der Plesk Mailserver nicht installiert ist oder wenn nicht zugelassen ist, dass er abgehende E-Mails sendet. Dieser Server wird von Plesk Skripten sowie Nutzer-Skripten als SMTP-Relais verwendet werden, um abgehende E-Mails (wie etwa E-Mail-Benachrichtigungen) zu senden.',
    'mail-gate.enableMailGate' => 'Plesk darf E-Mail-Benachrichtigungen über diesen SMTP-Server senden',
    'mail-gate.notifications' => 'E-Mail-Benachrichtigungen von externem SMTP-Server',
    'mail-gate.smtpSettings' => 'Einstellungen für externen SMTP-Server',

    'optimization-settings.apacheModulesSection' => 'Apache-Module',
    'optimization-settings.apacheSettingsSection' => 'Allgemeine Einstellungen',
    'optimization-settings.additionalPageHint' => 'Schalten Sie Module nur um, wenn Sie genau wissen, was dies zur Folge hat. Beachten Sie, dass einige Modifikationen die Leistung von Apache senken oder gar zu dessen Funktionsverlust führen können.',
    'optimization-settings.pageHint' => 'Hier können Sie Plesk optimieren, indem Sie nicht genutzte Apache-Module ausschalten. Diese Optimierung verbessert die Speichernutzung und ermöglicht Ihnen, mehr Hosting-Kunden zu bedienen. Beachten Sie, dass einige Module von einander abhängig sind und nur aus-/eingeschaltet werden können, wenn die Module, von denen sie abhängen, aus-/eingeschaltet sind.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Dieses Feature ist nur für fortgeschrittene Nutzer bestimmt.',
    'optimization-settings.apacheRestartInterval' => 'Apache Neustartintervall (Sekunden)',
    'optimization-settings.apacheRestartIntervalHint' => 'Plesk sucht einmal in einem vorgegebenen Intervall nach Änderungen, die an Domains und Subdomains gemacht wurden. Im Falle, dass es Änderungen gibt, für die ein Neustart des Webservers erforderlich ist, startet das Plesk Apache neu.',
    'optimization-settings.gracefulRestart' => 'Unterbrechungsfreier Neustart von Apache',
    'optimization-settings.gracefulRestartHint' => 'Wählen Sie diese Option aus, wenn Sie vermeiden möchten, dass auf dem Server gehostete Websites nicht verfügbar sind, wenn Sie Hosting-Einstellungen ändern.',
    'optimization-settings.pipedLog' => 'Piped Logs',
    'optimization-settings.mpmMode' => 'MPM-Modus',
    'optimization-settings.moduleDeprecated' => '(Veraltet)',

    'personal-info.contactInfoSection' => 'Kontaktdaten',
    'personal-info.hint' => 'Hier können Sie die Kontaktdaten des Benutzers bearbeiten.',
    'personal-info.hintMyProfile' => 'Hier können Sie Ihre Kontaktdaten bearbeiten.',

    'php-handler.ini.formHint' => 'Diese php.ini-Datei wird nur von diesem Handler verwendet.',
    'php-handler.ini.formHintSharedIni' => 'Diese php.ini-Datei wird ebenfalls von folgenden PHP-Handlern verwendet: %%handlers%%. Die Einstellungen gelten für alle Websites, die diese Handler nutzen.',
    'php-handler.ini.incorrectTextForIniFile' => "Die angegebenen Einstellungen sind nicht korrekt und können nicht in der Datei php.ini gespeichert werden. Fehler: %%message%%.",

    'php-handler.modules.formHint' => 'Diese Einstellungen für PHP-Erweiterungen sind nur für diesen Handler vorgesehen.',
    'php-handler.modules.formHintSharedModules' => 'Diese Einstellungen sind für folgende PHP-Handler gleich: %%handlers%%. Die Einstellungen gelten für alle Websites, die diese Handler nutzen.',

    'plan-item-custom.planItemName' => 'Service-Name',
    'plan-item-custom.buttonLabel' => 'Dieser Name wird auch als Beschriftung für die benutzerdefinierte Schaltfläche verwendet.',
    'plan-item-custom.planItemDescription' => 'Beschreibung des Services',
    'plan-item-custom.buttonTooltip' => 'Dieser Text wird auch als Tooltip für die benutzerdefinierte Schaltfläche verwendet.',
    'plan-item-custom.url' => 'URL verlinkt mit der benutzerdefinierten Schaltfläche',
    'plan-item-custom.backgroundImage' => 'Hintergrundbild für die benutzerdefinierte Schaltfläche',
    'plan-item-custom.emptyItemName' => 'Bitte geben Sie ein Bezeichnung für den Service an.',
    'plan-item-custom.emptyItemDescription' => 'Bitte geben Sie einen Text für den Service-Tooltip an.',
    'plan-item-custom.emptyUrl' => 'Bitte geben Sie eine URL an.',
    'plan-item-custom.longItemName' => 'Dieses Service-Label ist zu lang.Die maximal zulässige Länge sind %max% Zeichen.',
    'plan-item-custom.longItemDescription' => 'Dieser Service ist zu lang.Die maximal zulässige Länge sind %max% Zeichen.',
    'plan-item-custom.longUrl' => 'Diese URL ist zu lang.Die maximal zulässige Länge sind %max% Zeichen.',
    'plan-item-custom.useCustomButton' => 'Benutzerdefinierte Schaltfläche für den Service verwenden',
    'plan-item-custom.useCustomButtonHint' => 'Platzieren Sie eine benutzerdefinierte Schaltfläche auf der Startseite des Benutzers und den Seiten zur Website.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'URL in Plesk öffnen',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Geben Sie an, ob die URL auf einer Plesk Seite geöffnet werden soll oder in einem neuen Browserfenster.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Keine Frames verwenden',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Wenn Sie eine benutzerdefinierte Schaltfläche hinzufügen, die zu einer Plesk Erweiterung oder einer App im Kunden-Panel führt, können Sie angeben, wie diese Erweiterung/App angezeigt werden soll: In einem Frame oder als Teil der grafischen Benutzeroberfläche (GUI) von Plesk.',
    'plan-item-custom.includeDomId' => 'Abonnement-ID einfügen',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Hauptdomainnamen einfügen',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'FTP-Benutzernamen einfügen',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'FTP-Passwort einfügen',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Kunden-ID einfügen',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Firmennamen des Kunden einfügen",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Name des Kundenkontakts einfügen",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "E-Mail-Adresse des Kunden einfügen",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Wählen Sie aus, wie die Vorschau von Websites aussehen soll',
    'preview-domain-settings.previewQuick' => 'Standardschnellvorschau',
    'preview-domain-settings.previewDisabled' => 'Schnellvorschau deaktivieren',
    'preview-domain-settings.previewQuickDescription' => 'Eine empfohlene Option die sofort einsatzbereit ist.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Schnellvorschau auf einem Domainnamen in Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Wählen Sie eine Ihrer über Plesk bediente Websites aus, die für die Vorschau verwendet werden soll.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Um dieses Feature zu erstellen, %%link%% Sie mindestens eine Domain.',
    'preview-domain-settings.subscriptionCreateLink' => 'erstellen',
    'preview-domain-settings.previewZoneTypeExternal' => 'Schnellvorschau auf einem externen Domainnamen',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Verwenden Sie einen externen Domainnamen (DNS-Zone). Fügen Sie, wenn Sie diese Option nutzen, den folgenden DNS-Eintrag (Typ A) zur externen Domainzone hinzu: *.<Plesk_IP>.externe.dom. Hierbei ist <Plesk_IP> die Plesk Server-IP, wobei Punkte (.) in IPv4-Adressen oder Doppelpunkte (:) in IPv6-Adressen durch Bindestriche (-) ersetzt werden. Zum Beispiel *.192-0-2-12.externe.dom. Falls Plesk mehr als eine registrierte IP-Adresse besitzt, müssen Sie für jede Adresse einen Eintrag hinzufügen.',
    'preview-domain-settings.sitePreviewProtection' => 'Authentifizierung erforderlich',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Sorgen Sie dafür, dass der FTP-Benutzername und das Passwort angegeben werden müssen, um auf die Vorschau zugreifen zu können.',
    'preview-domain-settings.nginxNotInstalled' => 'Die Standardschnellvorschau ist nicht verfügbar, da der nginx Webserver nicht installiert ist.',
    'preview-domain-settings.nginxDisabled' => 'Die Standardschnellvorschau ist nicht verfügbar, da der nginx Webserver deaktiviert ist.',

    'reseller-preferences.settingsSection' => 'Einstellungen',
    'reseller-preferences.multiLogin' => 'Mehrere Sitzungen zulassen',
    'reseller-preferences.language' => 'Sprache der Benutzeroberfläche',
    'reseller-preferences.interfaceView' => 'Wählen Sie Ihre Benutzeroberfläche',
    'reseller-preferences.serviceProviderView' => 'Service-Provider-Ansicht',
    'reseller-preferences.serviceProviderViewHint' => 'Diese Ansicht ist für Reseller mit Kunden gedacht. Hiermit können Kunden sowie die eigenen Websites und Hosting-Services verwaltet werden.',
    'reseller-preferences.powerUserView' => 'Power-User-Ansicht',
    'reseller-preferences.powerUserViewHint' => 'Die Ansicht stellt Resellern eine einfache Benutzeroberfläche zur Verfügung, über die sie ihre eigenen Websites, E-Mail-Konten und sonstigen Hosting-Services verwalten können. In dieser Ansicht, können keine Kunden verwaltet werden.',

    'reseller.hint' => 'Hier können Sie einen neuen Reseller für Ihre Hosting-Services anmelden.',
    'reseller.contactInfoSection' => 'Kontaktdaten',
    'reseller.contactInfoSectionHint' => 'Geben Sie die Kontaktdaten des Resellers ein.',
    'reseller.accessToPanelSection' => 'Zugang zu Plesk',
    'reseller.accessToPanelSectionHint' => 'Zugangsdaten, die der Reseller für den Zugriff auf sein Plesk verwenden wird, um abonnierte Services zu verwalten.',
    'reseller.subscription' => 'Abonnement',
    'reseller.subscriptionSectionHint' => 'Wählen Sie ein Service-Paket aus, das der Reseller abonnieren soll.',
    'reseller.servicePlan' => 'Service-Paket',
    'reseller.none' => 'Keines',
    'reseller.customizeSubscription' => 'Mit dem Anpassen der Abonnement-Parameter fortfahren, nachdem der Reseller erstellt wurde. Bitte beachten, dass dadurch das Abonnement für die Synchronisierung gesperrt wird.',
    'reseller.subscriptionNotSynchronized' => 'Das Abonnement konnte nicht mit dem Service-Paket synchronisiert werden. Die folgenden Einstellungen stehen in Konflikt mit dem Service-Paket: %%problems%%.',

    'security-policy.encryptionSection' => 'Erweiterter Sicherheitsmodus',
    'security-policy.encryptionSectionHint' => 'Der erweiterte Sicherheitsmodus bietet einen erweiterten Schutz sensibler Daten in Plesk. In diesem Modus kommen in Plesk mehrere Sicherheitsmechanismen zum Einsatz, die vollständig transparent für Plesk Benutzer sind. Zur Verbesserung der Sicherheit in Plesk empfehlen wir, den Modus zu aktivieren.',
    'security-policy.encryptionEnable' => 'Erweiterter Sicherheitsmodus',
    'security-policy.securePassword' => 'Erweiterter Sicherheitsmodus',
    'security-policy.strengthSection' => 'Passwortqualität',
    'security-policy.strengthSectionHint' => 'Wenn Nutzer ein neues Passwort im System festlegen (ein neues erstellen oder ein bestehendes ändern), müssen Sie das Passwort gemäß den Mindestanforderungen an die Passwortsicherheit, die auf dieser Seite angegeben sind, anpassen. Die Sicherheit eines Passworts wird anhand der Gesamtlänge und Komplexität berechnet (Nutzung von Ziffern, Groß- und Kleinbuchstaben sowie Sonderzeichen). Wir empfehlen, von Benutzern zu verlangen, dass sie sicherere Passwörter verwenden.',
    'security-policy.passwordStrength' => 'Mindestqualität für Passwörter',
    'security-policy.passwordStrengthVeryWeakHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten nur eine Art von Zeichen (Klein- oder Großbuchstaben oder Ziffern). Beispiel: passwort. Dieses Sicherheitsniveau verhindert die einfachsten Angriffe, bei denen das Passwort geraten wird.',
    'security-policy.passwordStrengthWeakHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten überwiegend eine Art von Zeichen (Klein- oder Großbuchstaben oder Ziffern) mit einigen Zeichen einer anderen Art. Beispiel: passwort12. Diese Passwörter bieten einen Basisschutz vor dem Erraten eines Passworts.',
    'security-policy.passwordStrengthMediocreHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten mindestens zwei Zeichentypen (Klein- oder Großbuchstaben, Ziffern oder Sonderzeichen). Beispiel: Passwort12. Solche Passwörter bieten einen zuverlässigen Schutz gegen Angriffe, die darauf abzielen, Passwörter herauszufinden.',
    'security-policy.passwordStrengthStrongHint' => 'Diese Passwörter bestehen aus mindestens 8 Zeichen, wobei mindestens ein Klein- und Großbuchstabe, eine Ziffer und ein Sonderzeichen vorkommen. Beispiel: P@ssw0rt12. Solche Passwörter bieten einen starken Schutz vor Brute-Force-Angriffen (Angriffe mit systematischem Durchprobieren aller möglichen Kombinationen).',
    'security-policy.passwordStrengthStrongerHint' => 'Diese Passwörter bestehen aus mindestens 16 Zeichen, wobei Klein- und Großbuchstaben, Ziffern und Sonderzeichen in unterschiedlicher Kombination vorkommen. Beispiel: ~!my_P@$$w0rD123. Solche Passwörter bieten den bestmöglichen Schutz, auch wenn sie schwer zu merken sind.',
    'security-policy.secureFtpSection' => 'Sicheres FTP',
    'security-policy.ftpOverSsl' => 'Richtlinie zur FTPS-Nutzung',
    'security-policy.ftpOverSslHint' => 'FTPS wird eingesetzt, um die Kommunikation zwischen dem FTP-Server und externen FTP-Clients mithilfe von SSL/TLS-Protokollen zu schützen. Hier können Sie auswählen, welche Arten von Verbindungen zugelassen werden sollen.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS wird eingesetzt, um die Kommunikation zwischen dem FTP-Server und externen FTP-Clients mithilfe von SSL/TLS-Protokollen zu schützen. Hier können Sie auswählen, welche Arten von Verbindungen zugelassen werden sollen. Die ausgewählte Option wird für alle IP-Adressen auf dem Server angewendet. Wenn Sie benutzerdefinierte Einstellungen für einzelne IP-Adressen verwenden möchten, wählen Sie die entsprechende Option aus und ändern Sie dann die FTPS-Richtlinie unter "Tools & Einstellungen" > "IP-Adressen".',
    'security-policy.ftpOverSslCustomHint' => 'FTPS wird eingesetzt, um die Kommunikation zwischen dem FTP-Server und externen FTP-Clients mithilfe von SSL/TLS-Protokollen zu schützen.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS wird eingesetzt, um die Kommunikation zwischen dem FTP-Server und externen FTP-Clients mithilfe von SSL/TLS-Protokollen zu schützen. Wenn Sie die FTPS-Einstelllungen für IP-Adressen individuell anpassen möchten, wählen Sie zuerst unter "Tools & Einstellungen" > "Sicherheitsrichtlinien" > "Sicheres FTP" die Option "Benutzerdefinierte FTPS-Richtlinien pro IP-Adresse verwenden" aus.',
    'security-policy.ftpOverSslOptionRequired' => 'Nur sichere FTPS-Verbindungen zulassen',
    'security-policy.ftpOverSslOptionEnabled' => 'Sowohl sichere FTPS- als auch nicht sichere FTP-Verbindungen zulassen',
    'security-policy.ftpOverSslOptionDisabled' => 'Nur nicht sichere FTP-Verbindungen zulassen. FTPS nicht verwenden',
    'security-policy.ftpOverSslOptionCustom' => 'Benutzerdefinierte FTPS-Richtlinien pro IP-Adresse verwenden',
    'security-policy.prohibitWebConfigHandlersSection' => 'Richtlinie zu benutzerdefinierten Handlern',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Aktivieren Sie diese Option, um zu verhindern, dass Kunden auf Server-Ebene definierte IIS-Handler über die Datei web.config außer Kraft setzen können.',
    'security-policy.prohibitWebConfigHandlers' => 'Handler können nicht via web.config überschrieben werden',

    'service-instance.setup-instance.resourcesSection' => 'Service-Ressourcen',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Bereits installiert',
    'service-instance.setup-instance.requirementsSection' => 'Erforderliche Services',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Nicht ausgewählt',

    'service-node.ipAddress' => 'IP-Adresse des Service Node',
    'service-node.ipAddressLocal' => 'Lokaler Service Node',
    'service-node.description' => 'Beschreibung des Service Node',
    'service-node.accessKey' => 'Passwort',
    'service-node.useAccessKey' => 'Authentifizierung verwenden',
    'service-node.useAccessKeyDescription' => 'Hinweis zu Verwendung der Authentifizierung.',
    'service-node.oldAccessKey' => 'Altes Passwort',
    'service-node.newAccessKey' => 'Neues Passwort',
    'service-node.noAccessKeySpecified' => 'Kein Passwort angegeben',

    'service-plan.admin-plan.subscription_section' => 'Üblich',
    'service-plan.admin-plan.tools_section' => 'Tools & Ressourcen',
    'service-plan.admin-plan.apps_section' => 'Anwendungen & Datenbanken',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk Erscheinungsbild',
    'service-plan.admin-plan.statistics_section' => 'Statistiken',
    'service-plan.admin-plan.general_section' => 'Allgemein',
    'service-plan.admin-plan.mail_section' => 'E-Mail',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Erweiterungen',
    'service-plan.admin-plan.simplePanel' => 'Eingeschränkter Modus',
    'service-plan.admin-plan.enabled' => 'Eingeschränkten Modus aktivieren',
    'service-plan.admin-plan.enabledDescription' => 'Wählen Sie diese Option aus, um die Anzahl der Aktionen einzuschränken, die der Administrator in Plesk ausführen kann.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Wählen Sie diese Option aus, um die Anzahl der Aktionen einzuschränken, die der zusätzliche Administrator in Plesk ausführen kann.',

    'service-plan.applications-subscription.useFilterLabel' => 'Nur Anwendungen bereitstellen, die ich auswähle',
    'service-plan.applications-subscription.useFilterDescription' => 'Verwenden Sie diese Option, um die Anwendungen auszuwählen, die für den Abonnenten zur Verfügung stehen sollten.',
    'service-plan.applications-subscription.applications' => 'Anwendungen',
    'service-plan.applications-subscription.isCommercial' => 'Dies ist eine kommerzielle App, für die der Kauf eines Lizenzschlüssels erforderlich ist.',

    'service-plan.applications.useFilterLabel' => 'Nur Anwendungen bereitstellen, die ich auswähle',
    'service-plan.applications.useFilterDescription' => 'Verwenden Sie diese Option, um die Anwendungen auszuwählen, die für Abonnenten zur Verfügung stehen sollten.',
    'service-plan.applications.applications' => 'Anwendungen',
    'service-plan.applications.isCommercial' => 'Dies ist eine kommerzielle App, für die der Kauf eines Lizenzschlüssels erforderlich ist.',

    'service-plan.dns.dnsZoneType' => 'Domain-DNS-Zone',
    'service-plan.dns.dnsZoneTypeMaster' => 'Master',
    'service-plan.dns.dnsZoneTypeSlave' => 'Slave',

    'service-plan.extras.groupOtherServices' => 'Andere Dienste',
    'service-plan.extras.none' => 'Keine',

    'service-plan.hosting.enablePhysicalHosting' => 'Hosting aktivieren',
    'service-plan.hosting.sectionCoreHosting' => 'Allgemeine Einstellungen',
    'service-plan.hosting.sectionScripting' => 'Skripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Standard-Datenbankserver',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Erweitert',
    'service-plan.hosting.phpSettingsHelpLink' => 'Erfahren Sie, wie Sie geeignete PHP-Einstellungen auswählen',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Status von Websites, wenn das Abonnement gesperrt ist',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status von Websites in gesperrten Abonnements',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Der ausgewählte Status wird auf alle zu den Abonnements des Pakets gehörenden Websites angewendet, wenn das Abonnement gesperrt wird (zum Beispiel wenn es abläuft oder der bezahlte Zeitraum ausläuft).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Der ausgewählte Status wird auf Websites angewendet, wenn das Abonnement gesperrt wird (zum Beispiel wenn es abläuft oder der bezahlte Zeitraum ausläuft).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Deaktiviert',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Besucher der Websites werden auf die Standardseite des Webservers weitergeleitet.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Gesperrt',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Besucher der Websites werden mit dem suchmaschinenfreundlichen HTTP-Code 503 auf die benutzerdefinierte Fehlerdokumentseite weitergeleitet.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Aktiv',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Websites bleiben über das Internet zugänglich.',

    'service-plan.ip.sharedIpAddresses' => 'Shared-IP-Adressen zuweisen',
    'service-plan.ip.allocateExclusiveIp' => 'Dedizierte IP-Adressen zuweisen',
    'service-plan.ip.allocateExclusiveIpV4' => 'Dedizierte IPv4-Adressen zuweisen',
    'service-plan.ip.allocateExclusiveIpV6' => 'Dedizierte IPv6-Adressen zuweisen',

    'service-plan.mail.mailService' => 'E-Mail-Service einschalten',
    'service-plan.mail.webMail' => 'WebMail',
    'service-plan.mail.mailingLists' => 'Mailinglisten einschalten',
    'service-plan.mail.mailToNonExistentUser' => 'E-Mail-Regeln für nichtvorhandene Benutzer',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Bounce (Zurücksenden) mit Nachricht',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Weiterleitung an Adresse',
    'service-plan.mail.mailToNonExistentUserReject' => 'Abweisen',
    'service-plan.mail.mailAutodiscovery' => 'Automatische E-Mail-Erkennung aktivieren',
    'service-plan.mail.mailAutodiscoveryDescription' => '<a href="%%link%%" target="_blank">Weitere Informationen dazu in der Knowledge Base</a>',
    'service-plan.mail.bounceMessage' => 'Diese akzeptiert keine E-Mails mehr.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Umleitung an externen Mailserver mit der IP-Adresse',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - deaktiviert',

    'service-plan.misc.retainEnabled' => 'Web- und Traffic-Statistiken behalten für',
    'service-plan.misc.logRotation' => 'Protokoll-Rotation',
    'service-plan.misc.logRotationCondition' => 'Bedingung für Protokoll-Rotation',
    'service-plan.misc.logRotationBySize' => 'Nach Größe',
    'service-plan.misc.logRotationByTime' => 'Nach Zeit',
    'service-plan.misc.logRotationDaily' => 'Täglich',
    'service-plan.misc.logRotationWeekly' => 'Wöchentlich',
    'service-plan.misc.logRotationMonthly' => 'Monatlich',
    'service-plan.misc.logRotationSizeDescription' => 'Der Wert für die Größe muss zwischen %%min%% und %%max%% KB liegen.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maximale Anzahl an Protokolldateien',
    'service-plan.misc.compress' => 'Protokolldateien komprimieren',
    'service-plan.misc.sendLogToEmail' => 'Nachdem Plesk die Daten aus den Protokolldateien von Web- oder FTP-Servern abgerufen hat, die Protokolle an diese E-Mail-Adresse senden',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'Monate',
    'service-plan.misc.logRotationPeriodGreater' => 'Die Häufigkeit der Protokollrotation kann nicht über dem serverweiten Grenzwert von %%max%% liegen.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Wenn ausgeschaltet, verwenden alle Websites eines Abonnements denselben, nur für das Abonnement bestimmten IIS-Anwendungspool.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Services und Berechtigungen des Abonnements auswählen',
    'service-plan.permissions-subscription.showMorePermissions' => 'Weitere verfügbare Berechtigungen anzeigen',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Weniger Berechtigungen anzeigen',
    'service-plan.permissions-subscription.noShellManagement' => 'Nicht zulässig',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Verwaltung des Zugriffs auf den Server via SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Ermöglicht Kunden, SSH für ihren Systembenutzer zu aktivieren. Damit wird der Hosting-Parameter "SSH-Zugriff auf Server-Shell unter dem Systembenutzer des Abonnements" als Voreinstellung festgelegt.',

    'service-plan.permissions.permissionsTabDescription' => 'Wählen Sie die im Paket enthaltenen Dienste und Berechtigungen aus.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Wählen Sie die Services und Berechtigungen aus, die zu den Abonnements mit diesem Add-on-Paket hinzugefügt werden soll. Bitte beachten Sie, dass Berechtigungen, die nicht in dem Add-on ausgewählt wurden, die Abonnement-Parameter in keiner Weise verändern.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Über Berechtigungen wird festgelegt, welche Einstellungen der Abonnements Kunden ändern können. Wenn ein Abonnement erstellt wird, wendet Plesk die voreingestellten Werte aus dem Paket auf die Einstellungen an, die der Kunde ändern kann. Wenn das Paket anschließend geändert oder ein Zusatzpaket angewendet wird, werden die vom Kunden vorgenommenen Änderungen nicht überschrieben.',
    'service-plan.permissions.showMorePermissions' => 'Weitere verfügbare Berechtigungen anzeigen',
    'service-plan.permissions.hideMorePermissions' => 'Weniger Berechtigungen anzeigen',
    'service-plan.permissions.noShellManagement' => 'Nicht zulässig',
    'service-plan.permissions.systemAccessLabel' => 'Verwaltung des Zugriffs auf den Server via SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Der Hosting-Parameter "SSH-Zugang zur Server Shell unter dem Abonnement des Systembenutzers" agiert als Voreinstellung.',

    'service-plan.resources-subscription.overusePolicy' => 'Überbeanspruchungsrichtlinien',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Überbeanspruchung ist nicht zulässig',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Lassen Sie die Überbeanspruchung von Ressourcen nicht zu. Ein Abonnement wird automatisch gesperrt, wenn der Ressourcenverbrauch die Grenzwerte übersteigt.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Überbeanspruchung von Speicherplatz und Traffic ist zulässig',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Erlauben Sie die Überbeanspruchung von Speicherplatz und Traffic. Lassen Sie die Überbeanspruchung anderer Ressourcen nicht zu.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Überbeanspruchung ist zulässig (nicht empfohlen)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Erlauben Sie dem Abonnenten, mehr Ressourcen zu verbrauchen, als anfangs im Abonnement vereinbart.',
    'service-plan.resources-subscription.overuseNotify' => 'Im Falle einer Überbeanspruchung möchte ich per E-Mail benachrichtigt werden.',
    'service-plan.resources-subscription.oversellPolicy' => 'Überbuchungsrichtlinien',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Überbuchung ist zulässig',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Die Überbuchung (Overselling) erlaubt es einem Reseller, mehr Ressourcen als ihm im Abonnement zugewiesen zu verkaufen. Wenn die Überbuchung zulässig ist, dann gilt für einen Reseller der tatsächliche Ressourcenverbrauch und nicht die anfängliche Ressourcenzuweisung.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Überbuchung ist nicht zulässig',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Wenn die Überbuchung nicht zulässig ist, kann ein Reseller nur so viele Ressourcen verkaufen wie anfangs im Abonnement zugewiesen wurden, unabhängig davon, wie viele dieser Ressourcen tatsächlich verwendet werden.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Geben Sie die Grenzen für die Nutzung der mit dem Abonnement bereitgestellten Ressourcen an.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Weitere verfügbare Ressourcen anzeigen',
    'service-plan.resources-subscription.hideMoreResources' => 'Weniger Ressourcen anzeigen',

    'service-plan.resources.overusePolicy' => 'Überbeanspruchungsrichtlinien',
    'service-plan.resources.overusePolicyNotAllowed' => 'Überbeanspruchung ist nicht zulässig',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Lassen Sie die Überbeanspruchung von Ressourcen nicht zu. Ein Abonnement wird automatisch gesperrt, wenn der Ressourcenverbrauch die Grenzwerte übersteigt.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Überbeanspruchung von Speicherplatz und Traffic ist zulässig',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Erlauben Sie die Überbeanspruchung von Speicherplatz und Traffic. Lassen Sie die Überbeanspruchung anderer Ressourcen nicht zu.',
    'service-plan.resources.overusePolicyAllowed' => 'Überbeanspruchung ist zulässig (nicht empfohlen)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Erlauben Sie Kunden, mehr Ressourcen zu verbrauchen, als anfangs durch den Plan vereinbart.',
    'service-plan.resources.overuseNotify' => 'Im Falle einer Überbeanspruchung möchte ich per E-Mail benachrichtigt werden.',
    'service-plan.resources.oversellPolicy' => 'Überbuchungsrichtlinien',
    'service-plan.resources.oversellPolicyAllowed' => 'Überbuchung ist zulässig',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Die Überbuchung (Overselling) erlaubt es einem Reseller, mehr Ressourcen als ihm im Paket zugewiesen zu verkaufen. Wenn die Überbuchung zulässig ist, dann gilt für einen Reseller der tatsächliche Ressourcenverbrauch und nicht die anfängliche Ressourcenzuweisung.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Überbuchung ist nicht zulässig',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Wenn die Überbuchung nicht zulässig ist, kann ein Reseller nur so viele Ressourcen verkaufen wie anfangs im Paket zugewiesen wurden, unabhängig davon, wie viele dieser Ressourcen tatsächlich verwendet werden.',
    'service-plan.resources.mainGroupTitle' => 'Geben Sie die Ressourcen an, die mit diesem Paket bereitgestellt werden.',
    'service-plan.resources.additionalGroupTitle' => 'Weitere verfügbare Ressourcen anzeigen',
    'service-plan.resources.hideMoreResources' => 'Weniger Ressourcen anzeigen',
    'service-plan.resources.allowSitebuilderUpsell' => 'Kunden dürfen Testwebsites mit Presence Builder erstellen.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Mit dieser Einstellung können Kunden mehr Websites mit Presence Builder erstellen als im Service-Paket vorgesehen ist. Der Kunde muss diese Websites kaufen, damit er sie veröffentlichen kann.',

    'service-plan.servicePlanName' => 'Name des Service-Pakets',
    'service-plan.resellerPlanName' => 'Reseller Paket-Name',
    'service-plan.addonPlanName' => 'Paketname des Add-ons',
    'service-plan.adminPlanPermissionsTab' => 'Verwaltung',
    'service-plan.adminPlanPermissionsTabDescription' => 'Wählen Sie die Funktionen aus, die Administratoren zur Verfügung stehen, wenn der eingeschränkte Modus aktiviert ist.',
    'service-plan.hostingPermissionsTab' => 'Hosting-Tools',
    'service-plan.hostingPermissionsTabDescription' => 'Wählen Sie die Tools &amp; Einstellungen für das Webhosting aus, die für den Administrator in der Power-User-Ansicht verfügbar sind, wenn der eingeschränkte Modus aktiviert ist.',
    'service-plan.resourcesTab' => 'Ressourcen',
    'service-plan.resourcesTabDescription' => 'Geben Sie die Ressourcen an, die mit dem Paket zur Verfügung gestellt werden sowie die Regeln zum Ressourcenverbrauch.',
    'service-plan.subscriptionResourcesTabDescription' => 'Geben Sie die Ressourcen an, die mit dem Abonnement zur Verfügung gestellt werden sowie die Regeln zum Ressourcenverbrauch.',
    'service-plan.hostingTab' => 'Hosting-Parameter',
    'service-plan.hostingTabDescription' => 'Geben Sie die Parameter des Hosting-Services ein, der mit dem Paket zur Verfügung gestellt werden soll. Beachten Sie, dass die im Add-on-Paket angegebenen Hosting-Einstellungen nicht für Abonnements übernommen werden, denen entweder durch das Service-Paket oder das Add-on-Paket die Berechtigung "Verwaltung der Hosting-Einstellungen" erteilt wurde.',
    'service-plan.secureSettingsDescription' => 'Falls Sie das bereitgestellte Hosting maximal sichern möchten, gehen Sie folgendermaßen vor: %%link%%. Bitte beachten Sie, dass einige der Berechtigungen, sofern gewährt, dazu führen können, dass Abonnenten diese Einstellungen ändern. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'übernehmen Sie die voreingestellten Sicherheitseinstellungen',
    'service-plan.secureSettingsHelpLink' => 'Erfahren Sie mehr über die Einstellungen für sicheres Hosting',
    'service-plan.mailTab' => 'E-Mail',
    'service-plan.mailTabDescription' => 'Geben Sie die Parameter des E-Mail-Services ein, der mit dem Paket zur Verfügung gestellt werden soll.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Geben Sie die Parameter des DNS-Service ein, der mit dem Paket zur Verfügung gestellt werden soll.',
    'service-plan.performanceTab' => 'Leistung',
    'service-plan.performanceTabDescription' => 'Geben Sie die Systemparameter an, die die Leistung aller Services betreffen, die mit dem Paket zur Verfügung gestellt werden.',
    'service-plan.permissionsTab' => 'Berechtigungen',
    'service-plan.miscTab' => 'Protokolle & Statistiken',
    'service-plan.miscTabDescription' => 'Geben Sie an, wie Statistiken und Protokolle für die Abonnements des Pakets gespeichert werden sollen. Beachten Sie aber, dass diese Einstellungen nicht in den Abonnements synchronisiert werden.',
    'service-plan.miscTabAdminPlanDescription' => 'Geben Sie an, wie Statistiken und Protokolle für die Abonnements gespeichert werden sollen.',
    'service-plan.extrasTab' => 'Zusätzliche Services',
    'service-plan.extrasTabDescription' => 'Wählen Sie die Services aus, die in dem Paket zusätzlich zu den Webhosting-, DNS- und E-Mail-Services aufgenommen werden sollen.',
    'service-plan.ipTab' => 'IP-Adressen',
    'service-plan.ipTabDescription' => 'Geben Sie die Parameter der IP-Ressourcen an, die mit dem Paket zur Verfügung gestellt werden sollen.',
    'service-plan.applicationsTab' => 'Anwendungen',
    'service-plan.applicationsTabDescription' => 'Wählen Sie die Anwendungen aus, die mit dem Paket zur Verfügung gestellt werden sollen. Sie können festlegen, dass alle Anwendungen aus dem Anwendungskatalog bereitgestellt werden sollen, sowie diejenigen, die Sie auf den Server hochgeladen oder manuell ausgewählt haben. Wenn Sie alle verfügbaren Anwendungen zur Verfügung stellen wollen, dann müssen Sie auf dieser Registerkarte keinerlei Einstellungen vornehmen. Gehen Sie zur Registerkarte "Berechtigungen" und aktivieren Sie die Option "Zugang zum Anwendungskatalog". Wenn Sie Anwendungen manuell auswählen wollen, dann können Sie das auf dieser Registerkarte tun.',
    'service-plan.applicationsTabDescription-addon' => 'Wählen Sie die Anwendungen aus, die in dem Add-on verfügbar sein sollen.',
    'service-plan.applicationsTabDescription-subscription' => 'Wählen Sie die Anwendungen aus, die mit dem Abonnement zur Verfügung gestellt werden sollen. Sie können festlegen, dass alle Anwendungen aus dem Anwendungskatalog bereitgestellt werden sollen, sowie diejenigen, die Sie auf den Server hochgeladen oder manuell ausgewählt haben. Wenn Sie alle verfügbaren Anwendungen zur Verfügung stellen wollen, müssen Sie auf dieser Registerkarte keinerlei Einstellungen vornehmen. Gehen Sie zur Registerkarte "Berechtigungen" und aktivieren Sie die Option "Zugang zum Anwendungskatalog". Wenn Sie Anwendungen manuell auswählen wollen, dann können Sie das auf dieser Registerkarte tun.',
    'service-plan.planSyncSubsriptionWarning' => 'Einige Abonnements wurden nicht mit dem Paket synchronisiert. Sie wurden in der Abonnement-Liste als \'Nicht synchronisiert\' gekennzeichnet. Um die Synchronisierung ein weiteres Mal zu versuchen, gehen Sie zur Übersichtseite eines Abonnements und klicken Sie auf die Schaltfläche Synchronisierung.',
    'service-plan.planSyncResellerWarning' => 'Einige Reseller wurden nicht mit dem Paket synchronisiert. Sie wurden in der Reseller-Liste als \'Nicht synchronisiert\' gekennzeichnet. Um die Synchronisierung ein weiteres Mal zu versuchen, gehen Sie zur Übersichtseite eines Resellers und klicken Sie auf die Schaltfläche Synchronisierung.',
    'service-plan.planSyncAdminWarning' => 'Die Änderungen können nicht auf die Abonnements angewendet werden, da Plesk einige der Dienste oder Ressourcen, die von den Änderungen betroffen sind, nicht zur Verfügung stellt. Grund: %%reason%%',
    'service-plan.duplicateName' => 'Ein Paket mit diesem Namen ist bereits vorhanden.',
    'service-plan.phpSettingsTab' => 'PHP-Einstellungen',
    'service-plan.phpSettingsTabDescription' => 'Hier können Sie die PHP-Einstellungen für einzelne Abonnements angeben. Diese Einstellungen überschreiben die Einstellungen, die in der serverweiten Datei "php.ini" festgelegt wurden. Dies kann hilfreich sein, wenn Sie z. B. den Verbrauch der Systemressourcen durch die PHP-Skripts des Kunden einschränken möchten. Kunden können, falls berechtigt, diese PHP-Konfiguration mit ihrer eigenen domainspezifischen Konfiguration überschreiben. Wenn Sie für einen Parameter den Standardwert festlegen, verwendet PHP den Parameterwert aus der serverweiten PHP-Konfiguration. Die folgenden Platzhalter werden unterstützt: {DOCROOT} und {WEBSPACEROOT} stehen für das Dokumentstammverzeichnis einer Domain sowie für das Stammverzeichnis eines Abonnements, das eine benutzerdefinierte PHP-Konfiguration enthält. {TMP} steht für das Verzeichnis, in dem temporäre Dateien gespeichert werden.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Hier können Sie die PHP-Einstellungen für einzelne Abonnements angeben. Diese Einstellungen überschreiben die Einstellungen, die im Haupt-Service-Paket festgelegt wurden. Dies kann nützlich sein, wenn Sie z. B. PHP-Beschränkungen, die im Haupt-Service-Paket festgelegt wurden, entfernen möchten. Wenn Sie für einen Parameter den Standardwert festlegen, verwendet PHP den Parameterwert aus der PHP-Konfiguration des Service-Pakets. Die folgenden Platzhalter werden unterstützt: {DOCROOT} und {WEBSPACEROOT} stehen für das Dokumentstammverzeichnis einer Domain sowie für das Stammverzeichnis eines Abonnements, das eine benutzerdefinierte PHP-Konfiguration enthält. {TMP} steht für das Verzeichnis, in dem temporäre Dateien gespeichert werden.',
    'service-plan.phpSettingsPhpVersion' => 'Ihre aktuelle PHP-Version ist %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Hier können Sie die PHP-Einstellungen für einzelne Abonnements angeben. Diese Einstellungen überschreiben die Einstellungen, die in der serverweiten Datei "php.ini" festgelegt wurden. Wenn Sie für einen Parameter den Standardwert festlegen, verwendet PHP den Parameterwert aus der serverweiten PHP-Konfiguration.',
    'service-plan.webServerSettingsTab' => 'Webserver',
    'service-plan.webServerSettingsTabDescription' => 'Hier können Sie die Apache-Webserver-Einstellungen für dieses Service-Paket angeben. Wenn Apache mit nginx als Front-End-Server ausgeführt wird, können Sie die nginx-Einstellungen ebenfalls auf dieser Seite angeben. Alle neu erstellten Domains erhalten die angegebenen Einstellungen. Wenn Sie diese Einstellungen jedoch ändern, werden diese Änderungen nicht für bestehende Domains übernommen.',
    'service-plan.servicesTab' => 'Dienstleistungen',
    'service-plan.servicesTabDescription' => 'Hier können Sie Services angeben, die dem Service-Paket zugewiesen sind.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% Eigenschaften',
    'service-plan.servicePropertiesTabDescription' => 'Hier können Sie die Eigenschaften des Services %%serviceName%%, der dem Service-Paket zugewiesen ist, angeben.',
    'service-plan.longTaskWarning' => 'Sie haben %%subscriptionsCount%% Abonnements für dieses Paket. Beachten Sie bitte, dass die Synchronisierung u.U. viel Zeit in Anspruch nehmen kann und daher im Hintergrund durchgeführt wird.',
    'service-plan.hostingParametersTab' => 'Hosting-Parameter',
    'service-plan.adminInfoSection' => 'Informationen für den Administrator',
    'service-plan.descriptionInPanel' => 'Beschreibung',
    'service-plan.longDescription' => 'Die angegebene Beschreibung ist zu lang.',
    'service-plan.conflictPermissions' => 'Folgende Berechtigungen konnten nicht erteilt werden, da sie in Konflikt mit dem Reseller-Paket stehen: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Starttyp',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatisch',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuell',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Deaktivieren',
    'services.change-startup-type.autoActionError' => 'Der Starttyp konnte nicht auf "automatisch" festgelegt werden: %%error%%',
    'services.change-startup-type.manualActionError' => 'Der Starttyp konnte nicht auf "manuell" festgelegt werden: %%error%%',
    'services.change-startup-type.disableActionError' => 'Der Starttyp konnte nicht auf "deaktiviert" festgelegt werden: %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Auf Standard zurücksetzen',
    'sessions.settings.restoreDefaultButtonDescription' => 'Setzen Sie Sitzungsparameter auf die Standardwerte zurück.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Die Sitzungsparameter haben Standardwerte.',
    'sessions.settings.idleTime' => 'Sitzungs-Leerlaufzeit',
    'sessions.settings.disableCheckSessionIp' => 'Änderungen der IP-Adresse während einer einzelnen Sitzung zulassen',
    'sessions.settings.minuteShortTitle' => 'Min.',

    'settings-ui.controls.title' => 'Bedienelemente',

    'settings-ui.interface-views.description' => "Es stehen mehrere Produkt-Benutzeroberflächen-Ansichten für Sie zur Verfügung. Abhängig davon, welche Ansicht Sie verwenden, können Features und Einstellungen an unterschiedlichen Positionen angezeigt oder sogar aktiviert bzw. deaktiviert werden. Unterschiedliche Ansichten sind für unterschiedliche Benutzertypen geeignet.",
    'settings-ui.interface-views.panelSimpleLink' => 'Tools & Einstellungen> Einstellungen für eingeschränkten Modus',
    'settings-ui.interface-views.useCustomView' => 'Eingeschränkten Modus aktivieren',
    'settings-ui.interface-views.useCustomViewHint' => 'Wählen Sie diese Option aus, um die Anzahl der Aktionen einzuschränken, die der Administrator in Plesk Panel ausführen kann. Wenn Sie die verfügbaren Aktionen ändern möchten, rufen Sie %%customViewSettingsLink%% auf.',
    'settings-ui.interface-views.powerUserViewHint' => "Diese Ansicht dient zur Aktivierung einzelner, vereinfachter Benutzeroberflächen für Serveradministratoren, mit denen diese ihre eigenen Websites, E-Mail-Konten und sonstigen Services verwalten können.",
    'settings-ui.interface-views.selectUiModeTitle' => "Benutzeroberfläche auswählen",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Power-User-Ansicht",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Service-Provider-Ansicht",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Diese Ansicht bietet Benutzeroberflächen für Serveradministratoren, Reseller und Hosting-Endbenutzer.",

    'sitebuilder.trial.description' => 'Auf dieser Seite können Sie den Try&Buy-Modus konfigurieren (früher: Kundengewinnszenario). In diesem Modus kann der Kunde eine Website mit allen verfügbaren Funktionalitäten in der integrierten Anwendung Presence Builder erstellen. Jedoch ist das Veröffentlichen von Testwebsites für Kunden nicht verfügbar, bis sie ein Hosting-Service-Paket oder ein Paket-Add-on kaufen. Der Try&Buy-Modus kann auch Ihren bestehenden Kunden über ein Hosting-Paket oder ein Add-on zum Paket zur Verfügung gestellt werden. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Weitere Informationen finden Sie in der Dokumentation.',
    'sitebuilder.trial.lifetimeLabel' => 'Gültigkeitsdauer für die Test-Website',
    'sitebuilder.trial.lifetimeUnits' => 'Tage',
    'sitebuilder.trial.lifetimeDescription' => 'Die Dauer gibt an, wie lange Test-Websites, die noch nicht von Kunden gekauft wurden, auf dem Server bleiben sollen.',
    'sitebuilder.trial.signupLabel' => 'Öffentlichen Zugriff auf den Testmodus aktivieren',
    'sitebuilder.trial.signupDescription' => 'Wenn Sie Kunden mithilfe von Presence Builder für Ihr Hosting gewinnen und ihnen Zugang zur Presence Builder Demo verschaffen wollen, so aktivieren Sie den öffentlichen Zugang zum Testmodus und veröffentlichen Sie die URL für den Zugang zum Testmodus auf Ihrer Website.',
    'sitebuilder.trial.signupLinkLabel' => 'URL für Testmodus',
    'sitebuilder.trial.signupLinkDescription' => 'Diese URL wird Presence Builder im Testmodus öffnen. Stellen Sie diese URL auf Ihre Website, um mit Presence Builder für Ihr Hosting zu werben und Kunden zu gewinnen.',
    'sitebuilder.trial.promotionLabel' => 'Meldung zum Testmodus im Presence Builder Editor anzeigen',
    'sitebuilder.trial.promotionDescription' => 'Verwenden Sie diese Option, wenn Sie eine zusätzliche Meldung anzeigen wollen, in der steht, dass Presence Builder als Testversion verwendet wird.',

    'update-settings.policyHintForPum' => 'Hier können Sie die automatische Installation von Updates einrichten. Benachrichtigungs-E-Mail können gesendet werden, wenn Updates für manuelle Installationen verfügbar sind oder Updates automatisch installiert wurden.',
    'update-settings.policyHint' => 'Benachrichtigungs-E-Mail können gesendet werden, wenn Updates für manuelle Installationen verfügbar sind oder Updates automatisch installiert wurden.',
    'update-settings.branchDisabledDescription' => 'Mich nicht über verfügbare Upgrades benachrichtigen',
    'update-settings.automaticPatchesInstallation' => 'Plesk Updates automatisch installieren (empfohlen)',
    'update-settings.automaticPatchesInstallationHint' => 'Kritische Sicherheitsupdates werden immer automatisch installiert.',
    'update-settings.automaticPatchesThirdParty' => 'Updates für Drittanbieterkomponenten, die von Plesk geliefert werden, automatisch installieren',
    'update-settings.automaticSystemPackageUpdates' => 'Systempaket-Updates automatisch installieren',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Beachten Sie, dass damit auch Updates für Drittanbieterkomponenten, die von Plesk geliefert werden, automatisch installiert werden.',
    'update-settings.automaticPatchesNotification' => 'Über verfügbare und installierte Aktualisierungen des Systempakets benachrichtigen',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'E-Mail-Adresse',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Häufigkeit der E-Mail-Benachrichtigungen',
    'update-settings.daily' => 'Täglich',
    'update-settings.weekly' => 'Wöchentlich',
    'update-settings.generalSection' => 'Allgemein',
    'update-settings.notificationsSection' => 'Benachrichtigungen',
    'update-settings.safeUpdatesSection' => 'Sichere Updates',
    'update-settings.safeUpdatesSectionHint' => 'In Plesk werden Updates für Systempakete standardmäßig von dem Repository installiert, von dem die Pakete ursprünglich installiert wurden. Diese Updates werden als sicher eingestuft. Wenn Sie die sicheren Updates deaktivieren, werden Updates über Ihren Systempaketmanager möglicherweise von beliebigen Repositorys im System installiert.',
    'update-settings.safeUpdatesSectionWarn' => 'Wir empfehlen, sichere Updates zu verwenden, wenn Sie kein fortgeschrittener Benutzer sind. Willkürliche Updates von Systempaketen von verschiedenen Repositorys können sich negativ auf die Funktionen Ihres Servers auswirken.',
    'update-settings.allowSafeUpdates' => 'Sichere Updates für Systempakete aktivieren',

    'requiredFields' => 'Erforderliche Felder',
];