<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Jeśli twój serwis jest hostowany na dedykowanym adresie IP (niewspółdzielonym z innymi użytkownikami lub serwisami), możesz skonfigurować katalog wewnątrz serwisu, w którym uzytkownicy będą mogli anonimowo wgrywać i pobierać pliki poprzez FTP. Kiedy anonimowe FTP jest włączone, użytkownicy będą mogli zalogować się do katalogu pod adresem takim jak ftp://ftp.your-domain.com używając anonimowej nazwy użytkownika i jakiegokolwiek hasła.',
    'anonymous-ftp.displayLogin' => 'Wyświetl wiadomość logowania',
    'anonymous-ftp.loginText' => 'Tekst wiadomości',
    'anonymous-ftp.incomingDir' => 'Pozwól na wgrywanie do katalogu przychodzącego',
    'anonymous-ftp.incomingSubDir' => 'Pozwól na tworzenie podkatalogów w katalogu przychodzącym',
    'anonymous-ftp.incomingReadable' => 'Pozwól na pobieranie z katalogu przychodzącego',
    'anonymous-ftp.quota' => 'Ogranicz przestrzeń dysku w katalogu przychodzącym',
    'anonymous-ftp.maxConnections' => 'Ogranicz liczbę równoczesnych połączeń',
    'anonymous-ftp.bandwidth' => 'Ogranicz limit pobierania dla tej wirtualnej domeny FTP',
    'anonymous-ftp.unlimited' => 'Nieograniczone',

    'aps.catalog.loading' => 'Ładowanie',
    'aps.catalog.searchName' => 'Aplikacja',
    'aps.catalog.searchVendor' => 'Dostawca',
    'aps.catalog.searchPackager' => 'Pakowacz',
    'aps.catalog.searchLicenseType' => 'Typ licencji',
    'aps.catalog.searchLicenseTypeAny' => 'Jakikolwiek',
    'aps.catalog.searchLicenseTypeFreeware' => 'Darmowy',
    'aps.catalog.searchLicenseTypeCommercial' => 'Komercyjny',
    'aps.catalog.showSearch' => 'Pokaż wyszukiwanie',
    'aps.catalog.hideSearch' => 'Ukryj szukanie',
    'aps.catalog.buttonSearch' => 'Szukaj',
    'aps.catalog.buttonResetSearch' => 'Wyczyść szukanie',
    'aps.catalog.showCategories' => 'Wybierz kategorię poniżej lub wyszukaj aplikacje używając pola wyszukiwania',
    'aps.catalog.searchResults' => 'Wyniki wyszukiwania',
    'aps.catalog.buttonInstall' => 'Instaluj',
    'aps.catalog.buttonInstallTooltip' => 'Szybko zainstaluj najnowszą wersje aplikacji z optymalnymi domyślnymi parametrami.',
    'aps.catalog.buttonAdvancedInstall' => 'Instaluj (spersonalizowane)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Zaisntaluj najnowszą wersję aplikacji, personalizując wszystkie parametry.',
    'aps.catalog.buttonInstallOldVersion' => 'Zainstaluj wersję',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Zainstaluj wybraną wersję aplikacji, personalizując wszystkie parametry.',
    'aps.catalog.buttonInstallDescription' => 'Zainstaluj aplikację na stronie WWW, jeśli już masz kod aktywacyjny, lub jeśli chcesz ją wypróbować.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Zainstaluj tę darmową aplikację na stronie WWW.',
    'aps.catalog.version' => 'Wersja',
    'aps.catalog.moreVersions' => 'Więcej wersji',
    'aps.catalog.release' => 'Wersja',
    'aps.catalog.overview' => 'Opis',
    'aps.catalog.noApplicationsInCategory' => 'Nie ma żadnych dostępnych aplikacji w tej kategorii. Wybierz inną kategorię.',
    'aps.catalog.noCategoriesSelected' => 'Wybierz kategorię, aby przejrzeć wszystkie aplikacje dostępne w tej kategorii.',
    'aps.catalog.noSearchResults' => 'Twoje wyszukiwanie nie pasuje do żadnej aplikacji.',
    'aps.catalog.connectionFailed' => 'Nieudane łączenie z Katalogiem aplikacji. %%retryLink%%.',
    'aps.catalog.retry' => 'Potwórz',
    'aps.catalog.categoriesError' => 'Lista kategorii nie mogła być załadowana w tej chwili.',
    'aps.catalog.applicationsError' => 'Lista aplikacji nie mogła być załadowana w tej chwili.',
    'aps.catalog.detailsError' => 'Szczegóły aplikacji nie mogły być załadowane w tej chwili.',
    'aps.catalog.searchError' => 'Rezultaty wyszukiwania nie mogły być załadowane w tej chwili.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Publikacja %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Historia zmian',
    'aps.catalog.officialApplicationSite' => 'Informacja o dostawcy',
    'aps.catalog.returnToCategories' => '<< Powrót do listy aplikacji',
    'aps.catalog.buttonUninstall' => 'Usuń',
    'aps.catalog.gotoHome' => 'Start',
    'aps.catalog.all' => 'Wszystkie',
    'aps.catalog.buttonDetails' => 'Czytaj więcej',
    'aps.catalog.buttonBuy' => 'Kup teraz',
    'aps.catalog.buttonBuyTooltip' => 'Kup aplikację',
    'aps.catalog.buttonBuyDescription' => 'Odwiedź nasz sklep, aby kupić kod aktywacyjny do aplikacji.',
    'aps.catalog.buttonDownload' => 'Pobierz',
    'aps.catalog.buttonDownloadDescription' => 'Pobierz aplikację, jeśli już masz kod aktywacyjny, lub jeśli chcesz ją wypróbować.',
    'aps.catalog.marketplaceMoreInfo' => 'Aby uzyskać więcej informacji, kliknij %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'strona WWW dostawcy aplikacji',

    'aps.configure.installedAt' => "Zainstalowane na",
    'aps.configure.otherSettings' => "Inne",
    'aps.configure.globalSettings' => 'Ustawienia pakietu',
    'aps.configure.passwordConfirmation' => 'Potwierdź hasło',
    'aps.configure.databaseParams' => 'Parametry bazy danych',
    'aps.configure.noInstallationUrlAvailable' => 'Żaden (aplikacja zewnętrzna)',
    'aps.configure.updateSettingsSection' => 'Ustawienia aktualizacji',
    'aps.configure.forceUpdates' => 'Automatycznie aktualizuj aplikację, kiedy dostępne będą aktualizacje',
    'aps.configure.forceUpdatesHint' => 'Aplikacja zostanie automatycznie zaktualizowana do nowszych wersji. Ostrzeżenie: Korzystaj z tej opcji ostrożnie, ponieważ aktualizacja mogą znacząco wpłynąć na funkcjonalność aplikacji. Na przykład, rozszerzenia aplikacji mogą przestać działać z inną wersją aplikacji.',

    'aps.install.showAllSettings' => 'Pokaż wszystkie ustawienia',
    'aps.install.showLessSettings' => 'Pokaż minimalne ustawienia',
    'aps.install.install' => 'Instaluj',
    'aps.install.otherSettings' => 'Inne ustawienia',
    'aps.install.globalSettings' => 'Ustawienia pakietu',
    'aps.install.passwordConfirmation' => 'Potwierdź hasło',
    'aps.install.provisionsSectionLabel' => 'Ścieżka instalacji',
    'aps.install.context' => 'Określ lokalizację instalacji tej aplikacji webowej',
    'aps.install.registerAsWebmailSection' => 'Rejestracja poczty online',
    'aps.install.registerAsWebmailDescription' => "Zaznacz tę opcję, jeśli aplikacja jest klientem poczty online. W ten sposób aplikacja pojawi się na liście dostępnych usług poczty online w Ustawieniach poczty w subskrypcjach i planach usług. Administrator może skonfigurować ogólnodostępne URL poczty online w Zarządzanie serwerem>Ustawienia>Poczta online.",
    'aps.install.registerAsWebmailLabel' => 'Zarejestruj jako pocztę online',
    'aps.install.addItem' => 'Dodaj',
    'aps.install.removeItem' => 'Usuń',
    'aps.install.updateSettingsSection' => 'Ustawienia aktualizacji',
    'aps.install.forceUpdates' => 'Automatycznie aktualizuj aplikację, kiedy dostępne będą aktualizacje',
    'aps.install.forceUpdatesHint' => 'Aplikacja zostanie automatycznie zaktualizowana do nowszych wersji. Ostrzeżenie: Korzystaj z tej opcji ostrożnie, ponieważ aktualizacja mogą znacząco wpłynąć na funkcjonalność aplikacji. Na przykład, rozszerzenia aplikacji mogą przestać działać z inną wersją aplikacji.',

    'aps.invalid-requirements.requirementsLegend' => 'Wymagania',
    'aps.invalid-requirements.domainLegend' => 'Strona WWW',
    'aps.invalid-requirements.context' => 'Wybierz inną stronę WWW',
    'aps.invalid-requirements.backToApplicationList' => 'Powrót do listy aplikacji',

    'aps.license.title' => 'Instalacja %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Aby zainstalować aplikację, musisz przeczytać końcową umowę licencyjną użytkownika i zgodzić się na jej warunki.',
    'aps.license.licenseAgree' => 'Zgadzam się na warunki umowy licencyjnej',

    'aps.services-list-customization.settings' => 'Ustawienia',

    'asp-dot-net.change-version.frameworkVersion' => 'Wersja ASP.NET',

    'asp-dot-net.settings.casSettingsSection' => "Bezpieczeństwo Kodu Dostępu",
    'asp-dot-net.settings.clientScriptsSection' => "Ustawienia Biblioteki Skryptów",
    'asp-dot-net.settings.connStringsSection' => "Manager Ciągów Połączeń",
    'asp-dot-net.settings.customErrorsSection' => "Własne Ustawienia Błędów",
    'asp-dot-net.settings.frameworkVersionSection' => "Wersja Frameworku",
    'asp-dot-net.settings.globalizationSection' => "Ustawienia Globalne",
    'asp-dot-net.settings.otherSection' => "Ustawienia sesji",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Kompilacja i Testy",
    'asp-dot-net.settings.authMode' => "Tryb autentykacji",
    'asp-dot-net.settings.connStrings' => "Ciągi połączenia",
    'asp-dot-net.settings.connStringName' => "Nazwa",
    'asp-dot-net.settings.connStringValue' => "Parametry Połączenia",
    'asp-dot-net.settings.culture' => "Kultura",
    'asp-dot-net.settings.customErrMode' => "Tryb własnych błędów",
    'asp-dot-net.settings.customErrorRedirect' => "URL przekierowania",
    'asp-dot-net.settings.customErrorStatus' => "Kod Statusu",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Kod statusu musi być liczbą całkowitą.",
    'asp-dot-net.settings.customErrors' => "Własne błędy",
    'asp-dot-net.settings.debugMode' => "Przełącz na debugowanie",
    'asp-dot-net.settings.defLanguage' => "Domyślny język strony",
    'asp-dot-net.settings.tempDirectory' => "Katalog tymczasowy",
    'asp-dot-net.settings.fileEnc' => "Kodowanie pliku",
    'asp-dot-net.settings.fileEncInvalid' => "Podana wartość dla parametru kodowania pliku jest niepoprawna.",
    'asp-dot-net.settings.pathToLib' => "Ścieżka do biblioteki skryptów Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instaluj",
    'asp-dot-net.settings.reqEnc' => "kodowanie zapytania",
    'asp-dot-net.settings.reqEncInvalid' => "Podana wartość dla parametru kodowania żądań jest niepoprawna.",
    'asp-dot-net.settings.resEnc' => "Kodowanie odpowiedzi",
    'asp-dot-net.settings.resEncInvalid' => "Podana wartość dla parametru kodowania odpowiedzi jest niepoprawna.",
    'asp-dot-net.settings.sessTimeout' => "Przekroczony czas sesji (minuty)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Podana wartość dla parametru wygaśnięcia sesji jest niepoprawna. Podaj dodatnią liczbę mniejszą lub równą niż %%max%%.",
    'asp-dot-net.settings.trustLevel' => "Poziom zaufania CAS",
    'asp-dot-net.settings.uiCulture' => "Kultura UI",
    'asp-dot-net.settings.version' => "Wersja",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Zezwalaj na nadpisanie poziomu zaufania CAS dla tego serwisu WWW',
    'asp-dot-net.settings.addConnStrings' => 'Dodaj łańcuch połączenia',
    'asp-dot-net.settings.addCustomErrors' => 'Dodaj spersonalizowany błąd',
    'asp-dot-net.settings.buttonRemove' => 'Usuń',

    'database.clone.formDescription' => 'Kopiuj zawartość bazy danych do nowej lub istniejącej bazy danych. Po skopiowaniu do istniejącej bazy danych tabele źródłowej bazy danych są dodawane do listy tabel w docelowej bazie danych. Uwaga: Jeśli nazwa tabeli jest taka sama w źródłowej i w docelowej bazie, wtedy tabela ze źródłowej bazy zastąpi tę w docelowej.',
    'database.clone.copyData' => 'Utwórz pełną kopię',
    'database.clone.copyDataHint' => 'Odznaczenie spowoduje, że skopiowana zostanie cała baza danych (w tym struktury i dane). Jeśli zostaną wyczyszczone, tylko struktury tabel zostaną skopiowane.',
    'database.clone.server' => 'Docelowy serwer bazy danych',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Inne...',
    'database.clone.database' => 'Docelowa baza danych',
    'database.clone.newDatabase' => 'Utwórz bazę danych z nazwą',
    'database.clone.existingDatabase' => 'Kopiuj do istniejącej bazy danych',
    'database.clone.externalDbHost' => 'Nazwa hosta lub adres IP',
    'database.clone.externalDbLogin' => 'Nazwa użytkownika',
    'database.clone.externalDbPassword' => 'Hasło',
    'database.clone.subscription' => 'Docelowa subskrypcja',
    'database.clone.subscription_powerUser' => 'Docelowa Przestrzeń WWW',
    'database.clone.cloneInProgress' => 'Klonowanie bazy danych %%source%% do bazy danych %%destination%%. Zostaniesz poinformowany o jej postępie e-mailem (%%email%%).',
    'database.clone.unableToClone' => 'Nie udało się skopiować bazy danych.',
    'database.clone.unableToCreateExternalDatabase' => 'Nie udało się utworzyć bazy danych na podanym serwerze.',
    'database.clone.databaseCloned' => 'Baza danych została skopiowana.',
    'database.clone.emailSubjSuccess' => 'Baza danych "%%sourceDatabase%%" została skopiowana.',
    'database.clone.emailSubjFailure' => 'Nie udało się skopiować bazy danych %%sourceDatabase%%" .',
    'database.clone.emailBodySuccess' => 'Baza danych "%%sourceDatabase%%" (%%sourceHost%%) została skopiowana do bazy danych "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Nie udało się skopiować bazy danych %%sourceDatabase%%" (%%sourceHost%%) do bazy danych "%%destDatabase%%" (%%destHost%%). Nieudana procedura kopiowania.',
    'database.clone.localServer' => 'serwer lokalny',

    'database.repair-orphaned.formDescription' => 'Ten użytkownik został „osierocony” po procesie odtwarzania. Proszę wprowadzić hasło dla tego użytkownika, żeby usunąć problem. Jeśli ten użytkownik ma być użytkownikiem systemu bez hasła, uruchom funkcję naprawy z pustym polem hasła.',
    'database.repair-orphaned.login' => 'Hasło',
    'database.repair-orphaned.pass' => 'Hasło',
    'database.repair-orphaned.pass2' => 'Potwierdź hasło',
    'database.repair-orphaned.users' => 'Niektórzy użytkownicy wymagają twojej uwagi. Pojawiło się kilku „osieroconych” użytkowników, których konta powinny być naprawione.',
    'database.repair-orphaned.orphaned' => 'Użytkownik jest „osierocony”. %%gui begin:link%%Napraw teraz%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Naprawa',

    'database.repair.fixSelected' => 'Napraw wybrane',
    'database.repair.fix' => 'Naprawa',

    'database.user.password' => 'Hasło',
    'database.user.passwordConfirmation' => 'Potwierdź hasło',
    'database.user.server' => 'Serwer bazy danych',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Baza danych',
    'database.user.anyDatabase' => 'Jakikolwiek',
    'database.user.dataAccess' => 'Dostęp do danych',
    'database.user.structureAccess' => 'Dostęp struktury',
    'database.user.globalAccess' => 'Globalne przywileje',
    'database.user.globalAccessHint' => 'Globalne przywileje działa dla wszystkich baz danych na tym koncie hostingowym.',
    'database.user.aclRadio' => 'Kontrola dostępu',
    'database.user.aclLocalhost' => 'Zezwalaj tylko na lokalne połaczenia',
    'database.user.aclAny' => 'Zezwalaj na zdalne połączenia od każdego hosta',
    'database.user.aclCustom' => 'Zezwalaj na zdalne połaczenia od',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOkreślone hosty mają pozwolenie na dostęp do bazy danych w imieniu tego użytkownika.",
    'database.user.remoteAccess' => 'Zdalny dostęp',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nPodane adresy IP mają pozwolenie na dostęp do bazy danych w imieniu użytkownika. Zmiany na tej liście zostaną wstępnie zmoderowane przez dostawcę usług hostingowych.",
    'database.user.example' => "Na przykład:\n%%example%%",
    'database.user.denied' => 'Użyj reguł zapory ogniowej systemu',
    'database.user.allowed' => 'Zezwalaj na zdalne połaczenia od',
    'database.user.default' => 'Użyj danych tego użytkownika domyślnie poprzez dostęp do %%webadmin%%',
    'database.user.remoteAccessHint' => 'Skontaktuj się z dostawcą hostingu i upewnij się, że opcja, którą określiłeś powyżej będzie zgodna z obecnymi regułami zapory ogniowej dla przychodzącego dostępu do MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.myLittleAdmin' => 'myLittleAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Rola',
    'database.user.roleReadWrite' => 'Czytaj i pisz',
    'database.user.roleWriteOnly' => 'Tylko zapis',
    'database.user.roleReadOnly' => 'Tylko do odczytu',
    'database.user.roleCustom' => 'Personalizuj',

    'database.generalSection' => 'Ogólny',
    'database.name' => 'Nazwa bazy danych',
    'database.server' => 'Serwer bazy danych',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Powiązany serwis',
    'database.noDomainRelations' => 'Brak powiązanych serwisów',
    'database.userSection' => 'Użytkownicy',
    'database.userSectionDescription' => 'Utwórz domyślnego użytkownika bazy danych. Plesk uzyska dostęp do bazy danych w imieniu tego użytkownika. Jeżeli żaden użytkownik bazy danych nie jest przypisany do bazy danych, nie jest ona dostępna.',
    'database.createUser' => 'Utwórz użytkownika bazy danych',
    'database.username' => 'Nazwa użytkownika bazy danych',
    'database.password' => 'Hasło',
    'database.passwordConfirmation' => 'Potwierdź hasło',
    'database.allDbAccess' => 'Użytkownik ma dostęp do wszystkich baz danych w obrębie wybranej subskrypcji',
    'database.aclRadio' => 'Kontrola dostępu',
    'database.aclLocalhost' => 'Zezwalaj tylko na lokalne połaczenia',
    'database.aclAny' => 'Zezwalaj na zdalne połączenia od każdego hosta',
    'database.aclCustom' => 'Zezwalaj na zdalne połaczenia od',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOkreślone hosty mają pozwolenie na dostęp do bazy danych w imieniu tego użytkownika.",
    'database.remoteAccess' => 'Zdalny dostęp',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nPodane adresy IP mają pozwolenie na dostęp do bazy danych w imieniu użytkownika. Zmiany na tej liście zostaną wstępnie zmoderowane przez dostawcę usług hostingowych.",
    'database.example' => "Na przykład:\n%%example%%",
    'database.denied' => 'Użyj reguł zapory ogniowej systemu',
    'database.allowed' => 'Zezwalaj na zdalne połaczenia od',

    'deployment-section.deploymentDisabledHint' => 'Wgraj pliki z repozytorium Git',
    'deployment-section.deploymentEnabledHint' => 'Odblokuj obsługę Git',
    'deployment-section.deploymentSectionLegend' => 'Twoje pliki do skopiowania do hostingu',
    'deployment-section.deploymentSectionDescriptionHint' => 'Jeśli pozostawisz obsługę Git zablokowaną, katalogi root (serwis WWW/aplikacja root i dokument root) zostana utworzone jako puste, a serwis wyświetli domyślną stronę w przeglądarce. Musisz wgrac pliki swojego serwisu do dokumentu root używając FTP lub Menadżera plików. Możesz również odblokować Git teraz lub później (w Serwisy WWW i domeny) i wgrać pliki z repozytorium Git.',

    'dns-zone.acl-record.addIpHint' => 'Dodaj adres IP serwera DNS, który może otrzymac kopię strefy DNS.',
    'dns-zone.acl-record.ipAddress' => 'Adres IP',
    'dns-zone.acl-record.ipAddressWithMask' => 'Adres IP/maska',
    'dns-zone.acl-record.ipAddressDescription' => "Np. 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.acl-record.ipAddressWithMaskDescription' => "Np. 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.acl-record.addIpButton' => 'Dodaj adres IP',

    'dns-zone.record.type' => "Typ rekordu",
    'dns-zone.record.domainName' => "Nazwa domeny",
    'dns-zone.record.nameServer' => "Serwer nazw",
    'dns-zone.record.protocol' => "Protokół",
    'dns-zone.record.priority' => "Priorytet",
    'dns-zone.record.priorityLow' => "niski (%%priority%%)",
    'dns-zone.record.priorityHigh' => "bardzo wysokie (%%priority%%)",
    'dns-zone.record.weightLow' => "niski (%%weight%%)",
    'dns-zone.record.weightHigh' => "bardzo wysokie (%%weight%%)",
    'dns-zone.record.ipAddress' => "Adres IP",
    'dns-zone.record.ipAddressDescription' => "Np. 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Adres IPv6",
    'dns-zone.record.ipAddressV6Description' => "Np. 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Np. 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Np. 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nazwa kanoniczna",
    'dns-zone.record.mailDomain' => "Domena poczty",
    'dns-zone.record.mxServer' => "Podaj zamiennik poczty",
    'dns-zone.record.mxServerPriority' => "Sprecyzuj priorytet serwera wymiany",
    'dns-zone.record.txtRecord' => "rekord TXT",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Określono niepoprawne wartości dla rekordu TXT.",
    'dns-zone.record.dsRecord' => "Rekord DS",
    'dns-zone.record.dsRecordDescription' => "Na przykład 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Podano niepoprawną wartość dla rekordu DS.",
    'dns-zone.record.serviceName' => "Nazwa usługi",
    'dns-zone.record.serviceNameDescription' => "Przykład: SIP",
    'dns-zone.record.srvWeight' => "Względna waga dla zapisów z tym samy priorytetem",
    'dns-zone.record.targetHost' => "Host docelowy",
    'dns-zone.record.targetHostDescription' => "Przykład: przykład.com",
    'dns-zone.record.targetPort' => "Port docelowy",
    'dns-zone.record.retrieveDataError' => "Dane rekordu nie zostały znalezione.",
    'dns-zone.record.unknownTypeError' => "Nieznany typ rekordu DNS.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Nie można skonfigurować rekordu NULL MX, gdy obecne są inne rekordy MX.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Nie można skonfigurować rekordu non-NULL MX, gdy rekord NULL MX jest obecny.',
    'dns-zone.record.masterShouldBeRemote' => "Musisz mieć dwa różne autorytatywne serwery nazw na osobnych hostach.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Wartość",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.invalidValue' => 'Wartość jest błędna. Powinna być z zakresu od 1 sekundy do 2147483647 sekund.',
    'dns-zone.record.ttlDefaultValue' => 'Domyślna wartość: %%value%% sekund',

    'dns-zone.restore-default.formHint' => "Tutaj możesz przywrócić oryginalną konfigurację strefy w zgodzie z domyślnymi ustawieniami szablonu DNS używanego na tym serwerze. Wybierz adresy IP, które mają być używane do przywrócenia strefy i określ, czy dla domeny wymagany jest alias www.",
    'dns-zone.restore-default.ipv4' => "Adres Ipv4",
    'dns-zone.restore-default.ipv4Hint' => "Np. 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Adres IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Np. 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Podany adres IP jest niepoprawny.',
    'dns-zone.restore-default.customIpHint' => "Rekordy z adresem IP będą uważane za zmodyfikowane przez użytkownika i nie będą synchronizowane z ogólnym dla serwera szablonem DNS.",
    'dns-zone.restore-default.wwwPrefix' => "Prefiks WWW",
    'dns-zone.restore-default.previewRecords' => "Przywróć rekordy używane do podglądu serwisu",

    'dns-zone.soa-record.soaMnameSection' => 'Główny serwer nazw',
    'dns-zone.soa-record.soaMname' => 'Serwer nazw',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatyczny wybór)',
    'dns-zone.soa-record.soaRecordSection' => 'rekord SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Odśwież',
    'dns-zone.soa-record.retry' => 'Potwórz',
    'dns-zone.soa-record.expire' => 'Wygasa',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.invalidValue' => 'Wartość jest błędna. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns-zone.soa-record.serialNumberFormatSection' => 'format numeru seryjnego strefy DNS',
    'dns-zone.soa-record.serialNumberFormatText' => 'Użycie numeru seryjnego w formacie zalecanym przez IETF i RIPE może rozwiązać problem związane z odrzuceniem przez registratora i jest obowiązkowa dla wielu domen zarejestrowanych w niektórych strefach DNS wysokiego poziomu.',
    'dns-zone.soa-record.serialNumberFormat' => 'Użyj formatu numeru seryjnego zalecanego przez IETF i RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Przełączanie pomiędzy różnymi formatami numerów seryjnych może spowodować opóźnienie w aktualizowaniu strefy DNS',
    'dns-zone.soa-record.restoreDefaultButton' => 'Użyj ustawień domyślnych',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Domyślne ustawienia strefy',

    'domain-info-section.domainName' => 'Nazwa domeny',
    'domain-info-section.emptyDomainName' => 'Proszę podać nazwę domeny.',
    'domain-info-section.ipAddress' => 'Adres IP',
    'domain-info-section.shared' => 'współdzielony',
    'domain-info-section.exclusive' => 'dedykowany',
    'domain-info-section.ipAddressHint' => "Adres IP, na którym hostowana jest strona jest adresem sieciowym wirtualnego hosta strony. Ten adres IP będzie używany dla wszystkich stron stworzonych w obrębie tej subskrypcji.",
    'domain-info-section.ipAddressHint_powerUser' => "Adres IP, na którym hostowana jest strona jest adresem sieciowym wirtualnego hosta strony.Ten adres IP będzie używany dla wszystkich stron stworzonych w obrębie tej Przestrzeni WWW.",
    'domain-info-section.userName' => 'Nazwa użytkownika',
    'domain-info-section.userNameHint' => 'Konto użytkownika systemu powiązane z przestrzenią WWW używane do dostępu do hostowanych plików poprzez SSH i FTP.',
    'domain-info-section.emptyLogin' => 'Podaj nazwę użytkownika.',
    'domain-info-section.password' => 'Hasło',
    'domain-info-section.emptyPassword' => 'Proszę podać hasło.',
    'domain-info-section.passwordConfirmation' => 'Powtórz hasło',

    'email-address.generalTab' => 'Ogólny',
    'email-address.generalHint' => 'Jeśli to konto e-mail jest powiązane z dodatkowym użytkownikiem (odblokowany jest dostęp do panelu klienta) zmiany, których dokonasz na tej stronie będą miały wpływ na ustawienia tego użytkownika. Przede wszystkim jeśli zmienisz adres e-mail i hasło, login i hasło dodatkowego użytkownika zostaną również zmienione na nowe.',
    'email-address.redirectTab' => 'Przekierowanie',
    'email-address.redirectHint' => 'Skonfiguruj przekazywanie wiadomości e-mail na jeden lub więcej adresów e-mail.',
    'email-address.aliasesTab' => 'Aliasy e-mail',
    'email-address.autoResponderTab' => 'Auto odpowiedź',
    'email-address.antispamTab' => 'Filtr spamu',
    'email-address.autoResponderHint' => 'Ustaw automatyczną odpowiedź na wszystkie wiadomości przychodzące na twój adres e-mail. Auto odpowiedź jest standardowym sposobem powiadamiania o tym, że jesteś poza biurem lub na wakacjach.',
    'email-address.antivirusTab' => 'Antywirus',
    'email-address.name' => 'Adres e-mail',
    'email-address.externalEmail' => 'Zewnętrzny adres e-mail',
    'email-address.externalEmailHint' => 'Służy do resetowania hasła, jeśli utracisz dostęp do podstawowego adresu e-mail.',
    'email-address.user' => 'Przypisane do',
    'email-address.password' => 'Hasło',
    'email-address.passwordConfirmation' => 'Potwierdź hasło',
    'email-address.responderEnable' => 'Włącz auto odpowiedź',
    'email-address.responderSubject' => 'Temat auto odpowiedzi',
    'email-address.responderContentType' => 'Format wiadomości',
    'email-address.responderContentTypeHint' => 'Format tekstowy jest obsługiwany przez wszystkie programy klientów poczty i dlatego wszyscy odbiorcy zobaczą wiadomość dokładnie tak, jak ty ją widzisz. Wiadomości w HTML-u wyglądają lepiej, ponieważ pozwalają na wprowadzenie sformatowanego tekstu w różnych czcionkach. Jednak niektóre klienty poczty nie obsługują HTML-a i niektórzy odbiorcy mogą nie zobaczyć sformatowanego tekstu.',
    'email-address.responderContentTypeTextPlain' => 'Zwykły tekst',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kodowanie',
    'email-address.responderCodepageHint' => 'Kodowanie określa, w jaki sposób znaki są wyświetlane. Zalecane kodowanie to UTF-8.',
    'email-address.responderReplyTo' => 'Prześlij do',
    'email-address.responderReplyToHint' => 'Kiedy wysyłana jest automatyczna odpowiedź, oryginalna wiadomość będzie przekazana na podany adres e-mail.',
    'email-address.responderForwardAddress' => 'Prześlij do',
    'email-address.responderForwardAddressHint' => 'Kiedy wysyłana jest automatyczna odpowiedź, oryginalna wiadomość będzie przekazana na podany adres e-mail.',
    'email-address.responderMessage' => 'Tekst auto odpowiedzi',
    'email-address.responderReplyToEqualsEmail' => 'Adres podany do przekazania wiadomości jest taki sam jak adres e-mail.',
    'email-address.responderForwardAddressEqualsEmail' => 'Adres podany do przekazania wiadomości jest taki sam jak adres e-mail.',
    'email-address.responderReplyLimit' => 'Wyślij automatyczną odpowiedź na unikalny adres e-mail nie więcej niż (razy dziennie)',
    'email-address.buttonAddResponderAttachment' => 'Dodaj załącznik',
    'email-address.buttonRemoveResponderAttachment' => 'Usuń',
    'email-address.responderAttachment' => 'Załącz plik',
    'email-address.redirectEnable' => 'Włącz przekazywanie wiadomości',
    'email-address.redirectRemoveEnable' => 'Nie dostarczaj kopii przekazanych e-maili do skrzynki Plesk',
    'email-address.redirectAddress' => 'Przekaż przychodzące wiadomości na poniższy adres e-mail',
    'email-address.redirectAddressHint' => 'Podaj adresy e-mail. Możesz wpisać każdy adres w nowym wierszu albo oddziel adresy spacją, przecinkami lub średnikami.',
    'email-address.role' => 'Rola użytkownika',
    'email-address.roleHint' => 'Role użytkownika zapewniają użytkownikom uprawnienia administracyjne i dostęp do aplikacji, które zostały przypisane do roli.',
    'email-address.errorRedirectAddress' => 'Podałeś nieprawidłowy adres e-mail: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Podałeś nieprawidłowe adresy e-mail: %value%.',
    'email-address.mailAlias' => "Aliasy e-mail",
    'email-address.mailAliasNone' => 'Żaden',
    'email-address.mailAliasHint' => "Aliasy e-mail są alternatywnymi adresami e-mail powiązanymi z podstawowym adresem e-mail. Wszystkie wiadomości wysłane na aliasy e-mail będą otrzymywane przez podstawowy adres e-mail.",
    'email-address.buttonAddMailAlias' => 'Dodaj alias e-mail',
    'email-address.buttonRemoveMailAlias' => 'Usuń',
    'email-address.emptyEmail' => 'Podaj adres e-mail, na który powinny być przekazywane wszystkie przychodzące wiadomości.',
    'email-address.emailsIsEqual' => 'Zewnętrzny adres e-mail odpowiada pierwotnemu adresowi e-mail. Podaj inny zewnętrzny adres e-mail.',
    'email-address.emptyPassword' => 'Musisz podać hasło.',
    'email-address.emptyPasswordConfirmation' => 'Musisz potwierdzić hasło.',
    'email-address.emptyAlias' => "Podaj alias e-mail dla tego adresu e-mail.",
    'email-address.aliasEqualsEmail' => 'Podany alias e-mail jest taki sam jak adres e-mail.',
    'email-address.passwordHint' => 'Zostanie wykorzystany do uzyskania dostępu do skrzynki pocztowej i zalogowania się do Plesk (jeśli odpowiednia opcja jest włączona).',
    'email-address.cyclicRedirect' => 'Adres e-mail nie może być skonfigurowany tak, aby przekazywał wiadomości do samego siebie.',
    'email-address.errorMailnameReserved' => 'Podany adres e-mail jest już używany.',
    'email-address.antivirusEnable' => 'Włącz ochronę antywirusową dla tego adresu e-mail',
    'email-address.antivirusHint' => 'Usługa antywirusowa blokuje wiadomości e-mail, które zawierają wirusy i powiadamia o tym fakcie nadawcę i odbiorcę.',
    'email-address.antivirusSettings' => 'Sprawdź w poszukiwaniu wirusów',
    'email-address.antivirusSettingOnlyIncomingMail' => 'tylko przychodząca poczta',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'tylko wychodząca poczta',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'przychodząca i wychodząca poczta',
    'email-address.antispamHint' => 'Usługa filtrowania spamu wykrywa spam wysyłany na adresy e-mailowe. Możesz ustawić filtr spamu tak, aby kasował wiadomości spam, oznaczał je jako spam poprzez zmianę ich tematu lub przenosił je do specjalnego katalogu dostępnego dla klientów poczty poprzez IMAP. Filtr spam wykorzystuje szeroki zakres lokalnych i sieciowych testów, aby zidentyfikować spam.',
    'email-address.antispamEnable' => 'Włącz filtrowanie spamu dla tego adresu e-mail',
    'email-address.antispamSettings' => 'Co zrobić z wiadomościami zaklasyfikowanymi jako spam',
    'email-address.antispamSettingsMark' => 'Oznacz wiadomości spam, dodając poniższy tekst do tematu wiadomości',
    'email-address.antispamSettingsMarkHint' => 'Pozostaw puste pole jeśli nie chcesz dodać żadnego tekstu. Wpisz _SCORE_ jeśli do tytułu wiadomości chcesz dodać także punktację.',
    'email-address.antispamReportTextHint' => 'Wpisz tekst, który chcesz dodać do tekstu wiadomości spam.',
    'email-address.antispamSettingsDelete' => 'Usuń wszystkie wiadomości spam',
    'email-address.antispamSettingsDeleteHint' => 'Wiadomości spam będą usunięte z twojej skrzynki pocztowej.',
    'email-address.antispamSettingsMove' => 'Przenieś spam do katalogu Spam',
    'email-address.antispamSettingsMoveHint' => 'Przenieś wszystkie wiadomości spam do katalogu o nazwie Spam. Ten katalog jest dostępny z twojego klienta poczty lub z poczty online. Jeżeli korzystasz z konta pocztowego IMAP, możesz użyć katalogu Spam do trenowania filtra spamu.',
    'email-address.antispamSettingsMoveWarning' => '"Przenieś spam do folderu Spam" nie działa, chyba że wyłączysz opcję "Nie dostarczaj kopii przekazanych wiadomości e-mail" na karcie "Przekazywanie dalej".',
    'email-address.antispamSettingsMoveJunk' => 'Przenieś spam do folderu "Wiadomości śmieci"',
    'email-address.antispamSettingsMoveJunkHint' => 'Przenieś wszystkie wiadomości spamowe do folderu o nazwie "Wiadomości śmieci". Ten katalog jest dostępny z twojego klienta poczty lub z poczty online. Jeśli korzystasz z konta pocztowego IMAP, możesz użyć folderu "Wiadomości śmieci" do uczenia filtra antyspamowego.',
    'email-address.antispamShowAdvancedSection' => 'Pokaż Zaawansowane ustawienia',
    'email-address.antispamHideAdvancedSection' => 'Ukryj Zaawansowane ustawienia',
    'email-address.antispamLearnMore' => 'Dowiedz się, jak konfigurować filtr antyspamowy.',
    'email-address.antispamFilterScoreTitle' => 'Wrażliwość filtra',
    'email-address.antispamFilterScoreHint' => 'Filtr spamu wykonuje wiele różnych testów na zawartości i temacie każdej wiadomości. W rezultacie każda wiadomość otrzymuje punkty. Im wyższa ich liczba, tym większe prawdopodobieństwo, że wiadomość to spam. Wrażliwość filtra domyślnie skonfigurowana jest w taki sposób, że wiadomości, którym przyznano 7 punktów lub więcej są klasyfikowane jako spam. Jeśli dostajesz dużo spamu przy obecnych ustawieniach, powinieneś zmienić wrażliwość filtra. Aby to zrobić, spróbuj ustawić go na wartość, np. 6. Jeżeli część wiadomości nie dociera na twoją skrzynkę, ponieważ filtr uważa je za spam, spróbuj zredukować wrażliwość filtra, ustawiając wyższą wartość, np. 8.',
    'email-address.antispamFilterScore' => 'Wrażliwość filtra spamu',
    'email-address.antispamWhiteListTitle' => 'Biała lista',
    'email-address.antispamWhiteListHint' => 'Wiadomości e-mail od nadawców na białej liście nie są sprawdzane przez filtr spamu.',
    'email-address.antispamWhiteListField' => 'Biała lista',
    'email-address.antispamWhiteListFieldHint' => 'Wpisz nazwy domen, jedna domena w wierszu. Adresy mogą zawierać "*" i wieloznacznik "?", np. *@domena.com, użytkownik?@*.com.',
    'email-address.antispamBlackListTitle' => 'Czarna lista',
    'email-address.antispamBlackListHint' => 'Wiadomości e-mail od nadawców z czarnej listy są klasyfikowane jako spam.',
    'email-address.antispamBlackListField' => 'Czarna lista',
    'email-address.antispamBlackListFieldHint' => 'Wpisz nazwy domen, jedna domena w wierszu. Adresy mogą zawierać "*" i wieloznacznik "?", np. *@domena.com, użytkownik?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Wiadomości e-mail',
    'email-address.antispamTrustedLanguagesHint' => 'Wiadomości e-mail napisane w tych językach zawsze będą przepuszczone przez filtr.Zaufane języki.',
    'email-address.antispamTrustedLocalesTitle' => 'Zaufane grupy',
    'email-address.antispamTrustedLocalesHint' => 'Które wykorzystują określone grupy znaków zawsze będą przepuszczane przez filtr. Grupy obejmują najczęściej używane zestawy znaków. Na przykład zestaw znaków zachodnich obejmuje kodowanie dla liter używanych w języku angielskim i językach zachodnioeuropejskich.',
    'email-address.antispamTrustedNetworksTitle' => 'Zaufane sieci',
    'email-address.antispamTrustedNetworksHint' => 'Hosty typu relay w zaufanych sieciach nie powinny być z góry uważane za będące pod wpływem spamerów. Nie są też otwartymi serwerami typu relay ani otwartymi serwerami typu proxy.',
    'email-address.antispamIpAddressesField' => 'Adresy IP',
    'email-address.antispamIpAddressesFieldHint' => 'Określ sieciowy adres IP i maskę.',
    'email-address.mailBoxQuotaDomainDefault' => 'Domyślny rozmiar (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Domyślny rozmiar',
    'email-address.mailBoxOutgoingMessages' => 'Maksymalna liczba wychodzących wiadomości e-mail',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Domyślnie (%%domainOutgoingMessages%% wiadomości na godzinę)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Spersonalizowana wartość dla skrzynki pocztowej',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'wiadomości',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Domyślny',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Domyślny rozmiar',
    'email-address.mailBoxQuotaDomainSpecific' => 'Inny rozmiar',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Rozmiar skrzynki pocztowej',
    'email-address.mailBoxQuotaUnlimited' => 'Nieograniczone',
    'email-address.mailBoxLimitReached' => 'Limit liczby skrzynek pocztowych został osiągnięty.',
    'email-address.postboxEnabled' => 'Skrzynka pocztowa',
    'email-address.postboxEnabledYes' => 'Wł',
    'email-address.postboxEnabledNo' => 'Wył',
    'email-address.description' => 'Opis w Plesku',
    'email-address.descriptionHint' => 'Opis jest widoczny dla każdego, kto ma dostęp do konta e-mail.',
    'email-address.longDescription' => 'Podany opis jest za długi. Nie może być dłuższa niż %%max%% znaki.',
    'email-address.loginAsUser' => 'Może być używany do logowania się do Plesk',
    'email-address.loginAsUserDescription' => '(Nazwa użytkownika: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Rozmiar skrzynki pocztowej nie może przekroczyć rozmiaru domyślnego.',
    'email-address.endDateEnable' => 'Wyłącz autoodpowiedź',

    'failed-request.enable-tracing.description' => 'Śledzenie nieudanych żądań jest działaniem pochłaniającym zasoby. Śledzenie zostanie sutomatycznie zatrzymane za %%days%% dni. Możesz wyłączyć je ręcznie w każdej chwili.',
    'failed-request.enable-tracing.statusCodes' => 'Kody statusu',
    'failed-request.enable-tracing.statusCodesDescription' => 'Na przykład: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Dostawca',

    'file-manager.show.buttonReload' => 'Przeładuj',
    'file-manager.show.buttonSave' => 'Zapisz',
    'file-manager.show.buttonSaveAs' => 'Zapisz jako',
    'file-manager.show.buttonReset' => 'Resetuj',
    'file-manager.show.buttonTextCodeEditor' => 'Edytuj w edytorze kodu',
    'file-manager.show.buttonTextEdit' => 'Edytuj w edytorze tekstu',
    'file-manager.show.buttonWysiwygEdit' => 'Edytuj w edytorze HTML',
    'file-manager.show.eolLabel' => 'Znak końca linii:',
    'file-manager.show.saveAs' => 'Zapisz jako',
    'file-manager.show.saveCodepage' => 'Zapisz z następującym zestawem znaków:',
    'file-manager.show.loadCodepage' => 'Podgląd pliku z zestawem znaków:',
    'file-manager.show.loadCodepageHint' => 'Ostrzeżenie: Wszystkie niezapisane zmiany zostaną utracone podczas ponownego ładowania pliku.',
    'file-manager.show.fileExists' => "Plik lub folder %%fileName%% już istnieje. Nie możesz posiadać folderu i pliku o tej samej nazwie.",
    'file-manager.show.popupTitle' => 'Zapisz jako',
    'file-manager.show.popupFilename' => 'Nazwa pliku:',

    'file-manager.permissions.filePermissions' => 'Uprawnienia pliku',
    'file-manager.permissions.directoryPermissions' => 'Uprawnienia dostępu do katalogu',
    'file-manager.permissions.buttonSubmit' => 'Zapisz',
    'file-manager.permissions.buttonApply' => 'Zapisz i kontynuuj',
    'file-manager.permissions.buttonCancel' => 'Anuluj',
    'file-manager.permissions.buttonAdvanced' => 'Zaawansowane',

    'file-manager.unix-file-permissions.group' => 'Grupa',
    'file-manager.unix-file-permissions.owner' => 'Właściciel',
    'file-manager.unix-file-permissions.others' => 'Inne',
    'file-manager.unix-file-permissions.readMode' => 'Odczyt',
    'file-manager.unix-file-permissions.writeMode' => 'Zapisz',
    'file-manager.unix-file-permissions.execMode' => 'Wykonaj/szukaj',
    'file-manager.unix-file-permissions.changeRecursive' => 'Zmień uprawnienia rekurencyjnie',

    'file-manager.windows-permissions.allow' => 'Pozwól',
    'file-manager.windows-permissions.deny' => 'Zabroń',
    'file-manager.windows-permissions.inheritFromParent' => 'Pozwól na propagację uprawnień z obiektu nadrzędnego do tego obiektu i wszystkich obiektów podrzędnych. Zawrzyj to wraz z wpisami zdefiniowanymi tutaj',
    'file-manager.windows-permissions.replaceOnChildren' => 'Zastąp wpisy dotyczące uprawnień wszystkich obiektów podrzędnych wpisami poniżej',
    'file-manager.windows-permissions.buttonAdvanced' => 'Zaawansowane',
    'file-manager.windows-permissions.applyTo' => 'Zastosuj do:',
    'file-manager.windows-permissions.folderOnly' => 'Jedynie ten katalog',
    'file-manager.windows-permissions.subfolderOnly' => 'Jedynie podkatalogi',
    'file-manager.windows-permissions.filesOnly' => 'Jedynie pliki',
    'file-manager.windows-permissions.permissionsFor' => 'Uprawnienia dla',
    'file-manager.windows-permissions.applyOnto1' => 'Jedynie ten katalog',
    'file-manager.windows-permissions.applyOnto2' => 'Jedynie podkatalogi',
    'file-manager.windows-permissions.applyOnto3' => 'Ten katalog i podkatalogi',
    'file-manager.windows-permissions.applyOnto4' => 'Jedynie pliki',
    'file-manager.windows-permissions.applyOnto5' => 'Ten katalog i pliki',
    'file-manager.windows-permissions.applyOnto6' => 'Jedynie podkatalog i pliki',
    'file-manager.windows-permissions.applyOnto7' => 'Ten katalog, podkatalogi i pliki',
    'file-manager.windows-permissions.notInherited' => '<nie dziedziczone>',

    'file-manager.editor.titleTextEditor' => 'Edytor tekstu',
    'file-manager.editor.titleCodeEditor' => 'Edytor kodu',
    'file-manager.editor.titleCodeViewer' => 'Widok',
    'file-manager.editor.buttonSubmit' => 'Zapisz',
    'file-manager.editor.buttonApply' => 'Zapisz i kontynuuj',
    'file-manager.editor.buttonSaveAs' => 'Zapisz jako...',
    'file-manager.editor.buttonCancel' => 'Anuluj',
    'file-manager.editor.exitConfirmationYes' => 'Tak',
    'file-manager.editor.exitConfirmationNo' => 'Nie',
    'file-manager.editor.fileOverwrite' => 'Plik już istnieje.',
    'file-manager.editor.fileOverwriteDescription' => 'Plik o tej samej nazwie już istnieje. Czy chcesz go nadpisać?',
    'file-manager.editor.exitConfirmation' => 'Czy na pewno chcesz zamknąć plik i odrzucić niezapisane zmiany?',
    'file-manager.editor.buttonCodeEditor' => 'Edytuj w edytorze kodu',
    'file-manager.editor.buttonTextEditor' => 'Edytuj w edytorze tekstu',
    'file-manager.editor.buttonHtmlEditor' => 'Edytuj w edytorze HTML',

    'file-manager.import-file.buttonSubmit' => 'Importuj',
    'file-manager.import-file.fieldUrl' => 'URL pliku',
    'file-manager.import-file.fieldUrlDescription' => 'Podaj źródłowy adres URL, np. \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Pełny wzorzec adresu URL jest następujący: \'https://user:password@example.com/example.tgz\'. Nazwa użytkownika i hasło są opcjonalne. Obsługiwane protokoły to http, https, ftp, ftps. Użyj kodowania adresów URL dla części adresu URL, które zawierają znaki specjalne lub spacje.',
    'file-manager.import-file.failure' => 'Nie można zaimportować pliku.',

    'ftp-user.description' => 'Jeśli pracujesz w swoim serwisie WWW razem z kimś innym lub jeśli hostujesz poddomeny dla innych użytkowników, możesz chcieć utworzyć dla nich oddzielne konto FTP.',
    'ftp-user.generalSection' => 'Ogólny',
    'ftp-user.login' => 'Nazwa konta FTP',
    'ftp-user.home' => 'Katalog domowy',
    'ftp-user.systemArea' => 'Utwórz konto FTP z dostępem do plików poza katalogiem domowym',
    'ftp-user.password' => 'Hasło',
    'ftp-user.passwordConfirmation' => 'Potwierdź hasło',
    'ftp-user.hardQuotaSection' => 'Limit przestrzeni dysku',
    'ftp-user.hardQuota' => 'Limit przestrzeni dysku',
    'ftp-user.hardQuotaUnlimited' => 'Nieograniczone',
    'ftp-user.permissionsSection' => 'Uprawnienia',
    'ftp-user.permissionRead' => 'Prawa odczytu',
    'ftp-user.permissionWrite' => 'Prawa zapisu',
    'ftp-user.popupTitle' => 'Wybierz katalog',

    'mail-list.listName' => 'Adres listy mailingowej',
    'mail-list.enabled' => 'Włączony',
    'mail-list.administratorEmail' => 'E-mail administratora listy mailingowej',
    'mail-list.password' => 'Hasło',
    'mail-list.passwordConfirmation' => 'Potwierdź hasło',
    'mail-list.subscribers' => 'Subskrybenci',
    'mail-list.subscribersHint' => 'Podaj adresy e-mail. Możesz wpisać każdy adres w nowym wierszu lub oddzielić adresy spacją, przecinkiem lub średnikiem.',
    'mail-list.notify' => 'Powiadom administratora o utworzeniu listy mailingowej',
    'mail-list.emptyPassword' => 'Proszę podać hasło.',
    'mail-list.emptyPasswordConfirmation' => 'Proszę potwierdzić hasło.',
    'mail-list.errorSubscribers' => 'Niepoprawne adresy e-mail: %value%.',
    'mail-list.errorMaillistReserved' => 'Podany adres listy mailingowej jest już używany.',

    'mail-settings.hint' => 'Tutaj możesz zmienić ustawienia usługi pocztowej dla tej domeny.',
    'mail-settings.service' => 'Aktywuj usługę pocztową dla tej domeny',
    'mail-settings.nonExist' => 'Co zrobić z pocztą nieistniejących użytkowników',
    'mail-settings.nonExistBounceWithMessage' => 'Odbij z wiadomością',
    'mail-settings.nonExistBounce' => 'Odbij',
    'mail-settings.nonExistCatch' => 'Przechwyć do adresu',
    'mail-settings.nonExistCatchDescription' => 'Adres musi należeć do wybranej domeny. Tylko administrator może podać zewnętrzny adres lub adresy dla wielu domen.',
    'mail-settings.nonExistExternal' => 'Przekieruj na zewnętrzny serwer pocztowy z adresem IP',
    'mail-settings.nonExistReject' => 'Odrzuć',
    'mail-settings.nonExistDiscard' => 'Odrzuć',
    'mail-settings.webmail' => 'Poczta webowa',
    'mail-settings.webmailNone' => 'Żaden',
    'mail-settings.webmailComponentNotInstalled' => 'Komponent poczty WWW nie został zainstalowany.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Istnieje subdomena o nazwie %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certyfikat SSL/ TLS dla poczty WWW',
    'mail-settings.webmailCertificateNone' => 'Nie zaznaczone',
    'mail-settings.mailCertificate' => 'Certyfikat SSL / TLS dla poczty',
    'mail-settings.mailCertificateNone' => 'Nie zaznaczone',
    'mail-settings.serverCertificateNotSelected' => 'Certyfikat został przypisany, ale poczta dla domeny nie została zabezpieczona. Aby zakończyć zabezpieczanie poczty dla domeny, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'zabezpiecz serwer pocztowy',
    'mail-settings.mailLists' => 'Uruchom listy mailingowe',
    'mail-settings.mailAutodiscovery' => 'Włącz automatyczne wykrywanie poczty',
    'mail-settings.mailAutodiscoveryDescription' => 'Zobacz, jak to działa w %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'baza wiedzy',
    'mail-settings.domainKeys' => 'Użyj systemu ochrony przed systemem DKIM by podpisać wychodzące wiadomości email',
    'mail-settings.greyListing' => 'Włącz ochronę przed spamem typu szara lista dla wszystkich kont pocztowych w tej domenie.',
    'mail-settings.howToConfigureExternalDns' => 'Jak skonfigurować zewnętrzny DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Aby włączyć podpisywanie DKIM (jeśli korzystasz z zewnętrznego serwera DNS), musisz samodzielnie skonfigurować rekordy DKIM DNS na serwerze DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Aby to zrobić, użyj poniższych rekordów DKIM DNS:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Jeśli masz aliasy domeny, których używasz do wysyłania poczty, dodaj również rekordy DKIM DNS dla nich. Użyj tych samych rekordów, co w przypadku domeny głównej, ale z nazwą aliasu domeny.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Aby zobaczyć rekordy DKIM DNS, które musisz skonfigurować, zaznacz pole wyboru "%%option%%", zastosuj je i ponownie otwórz to wyskakujące okienko.',

    'role.roleSection' => 'Ogólny',
    'role.name' => 'Nazwa roli użytkownika',
    'role.description' => 'Opis',
    'role.generalPermissionsSection' => 'Dostęp do usług Plesku',
    'role.applicationsAccessSection' => 'Dostęp do aplikacji',
    'role.permissionAllow' => 'Nadano uprawnienia',
    'role.permissionDeny' => 'Zabroniony',
    'role.emptyRoleName' => 'Proszę podać nazwę roli.',
    'role.installedAt' => 'Zainstalowane na',
    'role.noInstallationUrlAvailable' => 'Aplikacja zewnętrzna',
    'role.invalidRoleName' => 'Podana nazwa roli użytkownika jest niepoprawna. Znaki zapytania i cudzysłów nie mogą być używane w nazwie roli.',
    'role.longRoleName' => 'Podana nazwa roli użytkownika jest zbyt długa.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Niektóre operacje mogą być niedostępne z następujących powodów: brak pozwolenia na operację w obecnie wybranej subskrypcji lub też ilość przyznanych środków nie jest wystarczająca do przeprowadzenia operacji.',
    'role.servicesPermissionsDescription' => 'Zdefiniuj dostęp do zainstalowanych aplikacji lub usług Plesku dla wszystkich użytkowników o tej roli. Jeśli zapewnisz dostęp użytkownikowi, aplikacja stanie się dla niego dostępna w Panelu klienta.',
    'role.emailActivation' => 'Aktywuj konta tej roli przez e-mail',

    'service.admin-access.adminAccess' => 'Dostęp administracyjny',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Te dane będą używane do dostępu administracyjnego do tej aplikacji.',
    'service.admin-access.login' => 'Administracyjna nazwa użytkownika',
    'service.admin-access.password' => 'Administracyjne hasło',
    'service.admin-access.passwordConfirmation' => 'Potwierdź hasło',

    'service.info.service-entry-point.availableAt' => 'Dostępne na',
    'service.info.service-entry-point.customize' => 'Spersonalizuj skrót',
    'service.info.service-entry-point.displayNameLabel' => 'Nazwa skrótu',
    'service.info.service-entry-point.displayNameDescription' => 'Podaj nazwę tego skrótu. Nazwa jest pokazana pod ikoną skrótu. Skróty są umieszczane na stronach Moje usługi należących do użytkowników, którzy otrzymali dostęp do tej aplikacji.',
    'service.info.service-entry-point.descriptionLabel' => 'Opis skrótu',
    'service.info.service-entry-point.descriptionDescription' => 'Podaj opis tego skrótu. Opis jest pokazywany jako wskazówka, kiedy najedziesz na niego kursorem myszy.',
    'service.info.service-entry-point.iconLabel' => 'Kliknij, aby wybrać ikonę skrótu',
    'service.info.service-entry-point.iconCurrent' => 'Obecna ikona',
    'service.info.service-entry-point.errorEmptyName' => 'Musisz podać nazwę skrótu',
    'service.info.service-entry-point.errorLongName' => 'Nazwa skrótu powinien zawierać od 1 do 255 znaków.',
    'service.info.service-entry-point.errorLongDescription' => 'Opis skrótu powinien zawierać od 0 do 255 znaków.',
    'service.info.service-entry-point.hiddenLabel' => 'Ukryj skrót',
    'service.info.service-entry-point.hiddenDescription' => 'Nie pokazuj tego skrótu użytkownikom.',

    'service.info.service-permission.assignedUser' => "Zapewnij dostęp administracyjny temu użytkownikowi",
    'service.info.service-permission.assignedUserNone' => 'Nie przypisano użytkownika',

    'shared-ssl.master-ssl.switchedOn' => 'Włącz współdzielone SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Nazwa domeny dla serwisu, którego certyfikat SSL/TLS będzie współdzielony pomiędzy inne serwisy',
    'shared-ssl.master-ssl.none' => 'Żaden',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Współdzielone SSL/TLS nie mogą być włączone, ponieważ nie ma domen z odblokowaną obsługą SSL/TLS.',

    'user.email.email' => 'Adres e-mail',
    'user.email.emptyEmail' => 'Musisz podać adres e-mail.',
    'user.email.internalEmailHint' => 'Utwórz nowy adres e-mail w Plesku lub użyj zewnętrznego adresu e-mail.',
    'user.email.longInternalEmail' => 'Adres e-mail jest zbyt długi.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Część nazwy użytkownika adresu e-mail jest za długa dla tego serwera poczty. Proszę określić nazwę użytkownika nie dłuższą niż %%max%% znaki.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Adres e-mail jest za długi dla tego serwera poczty. Proszę określić adres nie dłuższy niż %%max%% znaki.',
    'user.email.externalEmail' => 'Zewnętrzny adres e-mail',
    'user.email.externalEmailHint' => 'Służy do resetowania hasła, jeśli utracisz dostęp do podstawowego adresu e-mail.',
    'user.email.emailsIsEqual' => 'Zewnętrzny adres e-mail odpowiada pierwotnemu adresowi e-mail. Podaj inny zewnętrzny adres e-mail.',

    'user.profileSection' => 'Informacje ogólne',
    'user.contactName' => 'Kontakt',
    'user.email' => 'Adres e-mail',
    'user.role' => 'Rola użytkownika',
    'user.accountSection' => 'Preferencje Pleska',
    'user.login' => 'Nazwa użytkownika',
    'user.password' => 'Hasło',
    'user.buttonBack' => 'Wstecz',
    'user.generalTab' => 'Ogólny',
    'user.applicationsAccessSection' => 'Usługi',
    'user.generalPermissionsSection' => 'Uprawnienia',
    'user.contactsTab' => 'Dane do kontaktu',
    'user.passwordConfirmation' => 'Potwierdź hasło',
    'user.emailName' => 'Adres e-mail',
    'user.emailType' => 'Typ e-maila',
    'user.companyName' => 'Nazwa firmy',
    'user.phone' => 'Numer telefonu',
    'user.imNumber' => 'Komunikator',
    'user.fax' => 'Numer faksu',
    'user.address' => 'Adres',
    'user.city' => 'Miasto',
    'user.state' => 'Województwo lub powiat',
    'user.zip' => 'Kod pocztowy',
    'user.country' => 'Kraj',
    'user.additionalInfo' => 'Informacje dodatkowe',
    'user.additionalInfoHint' => 'Tylko zwykły tekst: wszystkie tagi HTML będą ignorowane.',
    'user.language' => 'Język Pleska',
    'user.buttonChangePassword' => 'Zmień hasło',
    'user.permissionAllow' => 'Nadano uprawnienia',
    'user.permissionDeny' => 'Zabroniony',
    'user.permissionInherited' => 'Zdefiniowany przez rolę',
    'user.emptyContactName' => 'Musisz podać osobę do kontaktu.',
    'user.emptyLogin' => 'Musisz podać nazwę użytkownika.',
    'user.emptyPassword' => 'Musisz podać hasło.',
    'user.emptyPasswordConfirmation' => 'Musisz potwierdzić hasło.',
    'user.chooseDomainBoxTitle' => 'Wybierz inną domenę:',
    'user.userIsActive' => 'Użytkownik jest aktywny',
    'user.userIsActiveHint' => 'Aktywni użytkownicy mogą uzyskać dostęp do Pleska.',
    'user.emailActivation' => 'Aktywuj konto przez e-mail',
    'user.emailHint' => 'Aby zapewnić użytkownikowi adres e-mail hostowany na tym serwerze, otwórz zakładkę Poczta, utwórz określony adres e-mail i połącz go z użytkownikiem.',
    'user.emailContactHint' => 'Skontaktuj się z dostawcą usług, jeśli chcesz używać adresu e-mail hostowanego na tym serwerze.',
    'user.personalEmailHint' => "Ten adres e-mail użytkownika może być zmieniony w zakładce Poczta.",
    'user.externalMailRedirectHint' => 'Przekazywanie wiadomości może być aktywowane tylko dla adresów e-mail hostowanych na tym serwerze. Aby utworzyć adres e-mail, otwórz zakładkę Poczta.',
    'user.externalMailRedirectHint2' => 'Przekazywanie wiadomości może być aktywowane tylko dla adresów e-mail hostowanych na tym serwerze.',
    'user.externalMailAutoResponderHint' => 'Auto odpowiedź może być aktywowana tylko dla adresów e-mail hostowanych na tym serwerze.Aby utworzyć adres e-mail, otwórz zakładkę Poczta.',
    'user.externalMailAutoResponderHint2' => 'Auto odpowiedź może być aktywowana tylko dla adresów e-mail hostowanych na tym serwerze.',
    'user.roleHint' => 'Role użytkownika zapewniają użytkownikom uprawnienia administracyjne i dostęp do aplikacji, które zostały przypisane do roli.',
    'user.cannotManageMail' => "Nie masz uprawnień do zarządzania ustawieniami poczty oraz usługami pocztowymi.",
    'user.longCompanyName' => 'Podana nazwa firmy jest zbyt długa.',
    'user.longPhone' => 'Podany numer telefonu jest zbyt długi.',
    'user.longFax' => 'Podany numer faksu jest zbyt długi.',
    'user.longAddress' => 'Podany adres jest zbyt długi.',
    'user.longCity' => 'Podana nazwa miasta jest zbyt długa.',
    'user.phoneRegexNotMatch' => 'Podany numer telefonu jest niepoprawny.',
    'user.faxRegexNotMatch' => 'Podany numer faksu jest niepoprawny.',
    'user.shortCity' => 'Podana nazwa miasta jest zbyt krótka.',
    'user.limitSubscription' => 'Dostęp do subskrypcji',
    'user.limitSubscriptionHint' => 'Zezwalaj użytkownikom na dostęp tylko do określonej subskrypcji. Wartość "Wszystkie" zapewnia dostęp do wszystkich subskrypcji w obrębie twojego konta hostingowego.',
    'user.limitSubscriptionAll' => 'Wszystkie',
    'user.deletedSubscription' => 'Usunięta subskrypcja',

    'web.add-domain-alias.title' => 'Dodaj Alias Domeny',
    'web.add-domain-alias.createdSuccessfully' => "Alias domeny %%name%% został utworzony.",
    'web.add-domain-alias.domainAliasName' => 'Nazwa aliasu Domeny',
    'web.add-domain-alias.domainAliasNameHint' => 'Na przykład example.net',
    'web.add-domain-alias.forDomain' => 'dla domeny',
    'web.add-domain-alias.settingsSectionLegend' => 'Ustawienia',
    'web.add-domain-alias.settingsDns' => 'Synchronizuj strefę DNS z domeną główną',
    'web.add-domain-alias.settingsMail' => 'Usługa pocztowa',
    'web.add-domain-alias.settingsWeb' => 'Usługa webowa',
    'web.add-domain-alias.settingsSeoRedirect' => 'Przekierownie z kodem HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Kiedy odwiedzający otworzą URL aliasu, zostaną przekierowani na URL podstawowej domeny. Plesk używa przyjaznego wyszukiwarkom przekierowania HTTP 301, co oznacza, że ranking w wyszukiwarce nie będzie podzielony pomiędzy URL.',
    'web.add-domain-alias.settingsTomcat' => 'Aplikacje Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Niepoprawna domena',

    'web.add-domain.formTitle' => 'Dodawanie nowej domeny',
    'web.add-domain.formRegistrationHint' => 'Możesz zarejestrować nową nazwę domeny tutaj %%link%%.',
    'web.add-domain.portalLink' => 'Portal usług',
    'web.add-domain.domainName' => 'Nazwa domeny',
    'web.add-domain.domainNameHint' => "Na przykład example.com",
    'web.add-domain.assignToCustomer' => 'Przypisz domenę do klienta',
    'web.add-domain.customer' => 'Wybierz klienta',
    'web.add-domain.createNewCustomer' => 'Utwórz nowego klienta',
    'web.add-domain.selectExistingCustomer' => 'Wybierz istniejącego klienta:',
    'web.add-domain.customerContactInfoHint' => 'Wpisz informacje o kontakcie do klienta. Możesz podać wszystkie inne informacje takie jak numer telefonu czy adres później.',
    'web.add-domain.customerLoginInfoHint' => 'Dane do logowania do panelu klienta',
    'web.add-domain.target' => 'Przestrzeń WWW',
    'web.add-domain.createNewTarget' => 'Utwórz nową subskrypcję',
    'web.add-domain.createNewTarget_powerUser' => 'Utwórz nową przestrzeń WWW',
    'web.add-domain.selectExistingTarget' => 'Wybierz istniejącą subskrypcję:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Wybierz istniejącą przestrzeń WWW:',
    'web.add-domain.dns' => 'Włącz usługę DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktywuj usługę poczty',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Działa, jeśli ustawienia subskrypcji pozwalają na zarządzanie uprawnieniami poczty dla poszczególnych domen. Jeśli nie, faktyczny status usługi pocztowej zostanie pobrany z subskrypcji.',
    'web.add-domain.hostingManagementOptions' => 'Typ hostingu',
    'web.add-domain.websiteHosting' => 'Hosting strony WWW',
    'web.add-domain.websiteForwarding' => 'Przekierowanie',
    'web.add-domain.websiteNoHosting' => 'Brak hostingu',
    'web.add-domain.hostingSettingsSectionLegend' => 'Ustawienia hostingu',
    'web.add-domain.domainCreatedSuccessfully' => 'Utworzono domenę %%domainName%%.',
    'web.add-domain.webspaceLegend' => 'Ustawienia przestrzeni WWW',
    'web.add-domain.addWhmWebsiteTitle' => 'Dodawanie nowego serwisu WWW',
    'web.add-domain.addWhmWebsiteHint' => "Możesz hostować stronę WWW na tym serwerze.",
    'web.add-domain.selectWhmDomain' => 'Wybierz domenę',
    'web.add-domain.customerLegend' => 'Informacje o kliencie',
    'web.add-domain.credentials' => 'Dane dostępowe użytkownika',
    'web.add-domain.credentialsHint' => 'aby uzyskać dostęp do hostowanych plików przez FTP i SSH',
    'web.add-domain.buttonAddDomain' => 'Dodaj domenę',

    'web.add-subdomain.formTitle' => 'Dodaj poddomenę',
    'web.add-subdomain.formGeneralHint' => 'Poddomeny są adresami internetowymi dla różnych sekcji twojego serwisu. Wykorzystują nazwę głównej domeny oraz prefiks. Na przykład, jeśli twoja domena ma adres domena.com, poddomena może mieć adres sklep.domena.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Możesz również stworzyć poddomenę jako dziką kartę wpisując symbol * zamiast nazwy. Odwiedzający serwis będą przekierowania do tej poddomeny bez względu na wpisaną w przeglądarce nazwę poddomeny.',
    'web.add-subdomain.subdomainName' => 'Nazwa subdomeny',
    'web.add-subdomain.subdomainNameHint' => 'Wpisz *, aby utworzyć poddomenę jako dziką kartę.',
    'web.add-subdomain.forDomain' => 'Nadrzędna doemna',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Utworzono poddomenę.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Ustawienia hostingu',

    'web.change-hosting.formGeneralHint' => 'Możesz hostować serwis na serwerze (Hostowanie serwisu), ustawić przekazywanie na inny serwis (Przekazywanie) lub użyć strefy DNS domeny, aby mieć skrzynki pocztowe pod nazwą tej domeny (Brak hostingu).',
    'web.change-hosting.changed' => 'Zmieniono typ hostingu dla %%domainName%%.',
    'web.change-hosting.hostingManagementOptions' => 'Typ hostingu',
    'web.change-hosting.websiteHosting' => 'Hosting strony WWW',
    'web.change-hosting.websiteForwarding' => 'Przekierowanie',
    'web.change-hosting.websiteNoHosting' => 'Brak hostingu',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Ustawienia hostingu',
    'web.change-hosting.userName' => 'Nazwa użytkownika',
    'web.change-hosting.userNameHint' => 'Użytkownika systemu używane do zarządzania plikami i katalogami w subskrypcji.',
    'web.change-hosting.userNameHint_powerUser' => 'Użytkownika systemu używane do zarządzania plikami i katalogami w ramach Przestrzeni WWW.',
    'web.change-hosting.emptyLogin' => 'Musisz podać nazwę użytkownika.',
    'web.change-hosting.password' => 'Hasło',
    'web.change-hosting.emptyPassword' => 'Musisz podać hasło.',
    'web.change-hosting.passwordConfirmation' => 'Potwierdź hasło',
    'web.change-hosting.warningInstalledApplications' => 'Na tej stronie zainstalowane są aplikacje sieciowe. Jeśli zmienisz typ hostingu, nie będą one dostępne.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Ostrzeżenie: Zawartość serwisu WWW zostanie usunięta.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Czy chcesz zmienić typ hostingu dla swojego serwisu WWW?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Następujące foldery i cała ich zawartość zostaną usunięte:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Cała zawartość folderu głównego zostanie usunięta.',

    'web.change-status.changed' => 'Zmieniono status strony dla %%domainName%%.',
    'web.change-status.statusManagementOptions' => 'Status strony WWW',
    'web.change-status.statusDisabled' => 'Zablokowany (poprzednia nazwa to Zawieszony)',
    'web.change-status.statusSuspended' => 'Zawieszone',
    'web.change-status.statusActive' => 'Aktywne',
    'web.change-status.statusDisabledHint' => 'Serwis przestanie być hostowany na serwerze i będzie niedostępny dla wszystkich oprócz klientów FTP i File Managera. Odwiedzający zobaczą domyślną stronę serwera.Usługa pocztowa pozostanie dostępna.',
    'web.change-status.statusSuspendedHint' => 'Serwis będzie hostowany na serwerze, ale odwiedzający będą przekierowani z kodem 503 HTTP na spersonalizowaną stronę dokumentu błędu. Usługa pocztowa pozostanie dostępna. Tutaj możesz %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Odwiedzający zostaną przekierowani przy pomocy przyjaznego przeglądarkom kodu 503 HTTP na spersonalizowaną stronę dokumentu błędu, chociaż serwis będzie wciąż hostowany na serwerze. Usługa pocztowa pozostanie dostępna.',
    'web.change-status.error503PageLink' => 'edytuj spersonalizowany dokument błędu',
    'web.change-status.statusActiveHint' => 'Serwis będzie działał jak zwykle.',
    'web.change-status.notActivatedSuspended' => 'Nie można aktywować domeny lub strony %%domainName%%, ponieważ została ona zawieszona przez dostawcę usług.',
    'web.change-status.notActivatedDisabled' => 'Nie można aktywować domeny lub strony %%domainName%%, ponieważ został wyłączony przez dostawcę usługi.',

    'web.edit.formTitle' => 'Dostęp hostingu WWW dla %%name%%',
    'web.edit.formGeneralHint' => 'Tutaj możesz zobactć adresy IP powiązane z twoją subskrypcją i zmienić nazwę użytkownika i hasło na użytkownika systemu.',
    'web.edit.formGeneralHint_powerUser' => 'Tutaj możesz zobactć adresy IP powiązane z tą pzrestrzenią WWW i zmienić nazwę użytkownika i hasło na użytkownika systemu.',
    'web.edit.ipAddressesLegend' => 'Adresy IP',
    'web.edit.ipAddresses' => 'Adresy IP',
    'web.edit.certificateLegend' => 'Certyfikat',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (należy do innego użytkownika)',
    'web.edit.userAccountLegend' => 'Użytkownik systemu',
    'web.edit.systemUserHint' => 'Tutaj możesz określić użytkownika systemu operacyjnego do zarządzania plikami i folderami w subskrypcji poprzez FTP i File Managera. Użytkownik systemu jest również wykorzystywany do dostępu do Plesku poprzez SSH (w Linuksie) lub RDP (w Windowsie), jeśli nadano odpowiednie uprawnienia.',
    'web.edit.systemUserHint_powerUser' => 'Tutaj możesz określić użytkownika systemu operacyjnego do zarządzania plikami i folderami w ramach przestrzeni WWW poprzez FTP i File Managera. Użytkownik systemu jest również wykorzystywany do dostępu do Plesku poprzez SSH (w Linuksie) lub RDP (w Windowsie), jeśli nadano odpowiednie uprawnienia.',
    'web.edit.login' => 'Nazwa użytkownika',
    'web.edit.emptyLogin' => 'Proszę podać nazwę użytkownika.',
    'web.edit.password' => 'Hasło',
    'web.edit.passwordConfirmation' => 'Potwierdź hasło',
    'web.edit.emptyPassword' => 'Proszę podać hasło.',
    'web.edit.emptyPasswordConfirmation' => 'Proszę potwierdzić hasło.',
    'web.edit.shellUnix' => "Dostęp do serwera przy pomocy SSH",
    'web.edit.shellHintUnix' => "Dostęp do serwera przy pomocy SSH z wykorzystaniem danych użytkownika systemu.",
    'web.edit.shellWin' => 'Dostęp do serwera poprzez Zdalny pulpit',
    'web.edit.shellHintWin' => "Dostęp do serwera poprzez Zdalny pulpit z wykorzystaniem danych użytkownika systemu.",
    'web.edit.diskQuotaLegend' => 'Limity dyskowe',
    'web.edit.diskQuotaHint' => 'Limit dyskowy to limit w ilości przestrzeni dyskowej, która może być wykorzystana. Jeśli limit dyskowy jest określony i cała wyznaczona przestrzeń dyskowa jest używana, nie można wykonać żadnych działań na plikach.',
    'web.edit.diskQuota' => 'Limity dyskowe',
    'web.edit.diskQuotaUnlimited' => 'Nieograniczone',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Nieograniczone. Limity dyskowe nie są obsługiwane z powodu konfiguracji plików systemowych serwera.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Zaktualizowano ustawienia hostingu.',
    'web.edit.affectedDomainsLegend' => 'Serwisy WWW, do których zastosowane są te ustawienia',
    'web.edit.affectedDomainsHint' => 'Następujące serwisy WWW są powiązane z obecnym użytkownikiem systemu. Zmiany w ustawieniach dostępu do hostingu wykonane na tej stronie zostaną zastosowane do wszystkich serwisów WWW.',

    'web.mobile.create.formTitle' => 'Utwórz mobilną stronę',
    'web.mobile.create.formGeneralHint' => 'Określ nazwę mobilnej strony WWW - podaj URL dostępu do strony.Zazwyczaj używa się prefiksów takich jak "m", "mob", "mobile", itp. (np. mobile.przykład.com. Może użyć tego URL potem w linku zatytułowanym "Wersja mobilna" umieszczonym na twojej stronie WWW tak aby odwiedzający stronę mogli swobodnie przełączać się pomiędzy wersjami strony.',
    'web.mobile.create.prefix' => 'Nazwa strony',
    'web.mobile.create.emptySiteName' => 'PodglądNazwa mobilnej strony WWW nie może być pusta, ponieważ spowoduje to konflikt z właściwą stroną WWW.',

    'web.security-section.securitySectionLegend' => 'Bezpieczeństwo',
    'web.security-section.securitySectionHint' => 'Aby zabezpieczyć transakcje w twoim serwisie, użyj protokołu SSL/TLS, który szyfruje wszystkie dane i przenosi je poprzez bezpieczne połączenie. Aby uruchomić SSL/TLS, przenieś ten serwis na dedykowany adres IP, zainstaluj certyfikat SSL/TLS w serwisie, a następnie zaznacz go poniżej.',
    'web.security-section.securitySectionSniHint' => 'Aby zabezpieczyć transakcje w twoim serwisie, użyj protokołu SSL/TLS, który szyfruje wszystkie dane i przenosi je poprzez bezpieczne połączenie. Aby uruchomić SSL/TLS, przenieś ten serwis na dedykowany adres IP, zainstaluj certyfikat SSL/TLS w serwisie, a następnie zaznacz go poniżej.',
    'web.security-section.enableSslSupport' => 'Obsługa SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Stałe bezpieczne w kontekście SEO 301 przekierowanie z HTTP na HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Preferowana domena',
    'web.seo-settings.seoRedirectDirectionHint' => 'Wybierz URL (albo z albo bez prefiksu www.), na który zostaną przekierowani odwiedzający serwis poprzez przekierowanie HTTP 301 z zabezpieczonym SEO.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Żaden',

    'web.settings.formGeneralHint' => 'Tutaj możesz skonfigurować ustawienia hostingu strony i wybrać funkcjonalności dostępne na stronie.',
    'web.settings.hostingType' => 'Typ hostingu',
    'web.settings.websiteHosting' => 'Strona WWW',
    'web.settings.forwardingHosting' => 'Przekierowanie',
    'web.settings.noHosting' => 'Brak hostingu',
    'web.settings.changeHosting' => 'Zmień',
    'web.settings.websiteStatus' => 'Status strony WWW',
    'web.settings.changeStatus' => 'Zmień',
    'web.settings.active' => 'Aktywne',
    'web.settings.suspended' => 'Zawieszone',
    'web.settings.disabled' => 'Wyłączony',
    'web.settings.webScriptingSectionLegend' => 'Skrypty i statystyki',
    'web.settings.webScriptingSectionHint' => 'Określ, które z następujących języków programowania i języków skryptowych powinny być tłumaczone, wykonane lub w jakiś sposób przetworzone przez serwer.',
    'web.settings.__asp_win_support' => 'Obsługa Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Obsługa Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Wersja',
    'web.settings.__asp_dot_net_version_readonly' => 'wersja %%value%%',
    'web.settings.__ssi_support' => 'Obsługa SSI',
    'web.settings.__ssi_with_html' => 'użyj SSI dla plików *.htm, *.html',
    'web.settings.__php_support' => 'Obsługa PHP',
    'web.settings.__php_run_as' => 'uruchom PHP jako',
    'web.settings.__php_served_by_apache' => 'obsługiwany przez Apache',
    'web.settings.__php_served_by_nginx' => 'obsługiwany przez nginx',
    'web.settings.__cgi_support' => 'Obsługa CGI',
    'web.settings.__cgi_bin_mode' => 'Katalog cgi-bin jest umieszczony w',
    'web.settings.__cgi_bin_mode_webspace' => 'Katalog root Przestrzeni WWW',
    'web.settings.__cgi_bin_mode_www_root' => 'dokument root tej domeny',
    'web.settings.__cgi_bin_mode_old_style' => '"old-style root\' tej domeny',
    'web.settings.__cgi_bin_mode_readonly' => 'Katalog cgi-bin jest umieszczony w %%value%%',
    'web.settings.__perl_unix_support' => 'Obsługa Perl',
    'web.settings.__perl_win_support' => 'Obsługa Perl',
    'web.settings.__python_unix_support' => 'Obsługa Python',
    'web.settings.__python_win_support' => 'Obsługa Python',
    'web.settings.__fastcgi_unix_support' => 'Obsługa FastCGI',
    'web.settings.__webstat_support' => 'Statystyki WWW',
    'web.settings.__plesk_stat_protect' => 'Chroń dostęp do statystyk sieci nazwą użytkownika i hasłem FTP',
    'web.settings.__plesk_stat_protected' => 'Dostęp do statystyk sieciowych jest chroniony przy użyciu nazwy użytkownika i hasła FTP',
    'web.settings.__apache_errdocs' => 'Spersonalizowane dokumenty błędów',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Aplikacja FastCGI',
    'web.settings.__php_cgi_handler' => 'Aplikacja CGI',
    'web.settings.__php_isapi_handler' => 'Rozszerzenie ISAPI',
    'web.settings.__php_version' => 'Wersja PHP',
    'web.settings.__hosting_write_modify' => 'Dodatkowe uprawnienia zapisu/modyfikacji',
    'web.settings.__hosting_webdeploy' => 'Publikacja Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Żaden',
    'web.settings.activate' => 'Aktywuj',
    'web.settings.deactivate' => 'Zawieś',
    'web.settings.__php_support_readonly' => 'wersji%%version%%; procedura obsługi: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'Nie zarejestrowany',
    'web.settings.domainName' => 'Nazwa domeny',
    'web.settings.domainNameHint' => "Na przykład example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Tryb kompatybilności dla archiwalnej opcji "Rozdziel treści SSL/TLS od nie-SSL/TLS"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Uruchom serwis WWW w trybie kompatybilności, aby skorzystać z archiwalnej opcji "Rozdziel treści SSL/TLS od nie-SSL/TLS"',
    'web.settings.sameSslCompatibilityHint' => 'Widzisz tę sekcję, ponieważ użyłeś opcji "Rozdziel treści SSL/TLS od nie-SSL/TLS" przed podniesieniem parametrów. W Plesku 11 ta opcja została usunięta. Wszystkie strony stworzone w Plesku 11 wykorzystują ten sam katalog do przechowywania treści dostępnych poprzez połączenia HTTP i HTTPS. Oznacza to, że strona wciąż działa w trybie kompatybilnym, ale nie może być zarządzana z poziomu Plesku. Zaleca się przeniesienie wszystkich danych z katalogu httpsdocs/ do katalogu httpdocs/, a następnie wyłączeniu trybu kompatybilności. Po wyłączeniu trybu kompatybilności, nie będzie można go włączyć ponownie ta sekcja więcej się nie pojawi. Zauważ jednak, że jeśli zainstalujesz aplikacje w katalogu httpsdocs/, kiedy włączony jest tryb kompatybilności, aplikacje nie będą dostępne przez Internet. Jeśli chcesz zainstalować aplikacje w httpsdocs/, wyłącz tryb kompatybilności.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'Ustawienia strony będą zastosowane za %%restartInterval%% minut.',
    'web.settings.phpSettingsDescription' => 'Ta strona wyświetla konfigurację PHP dla tego serwisu WWW. Te ustawienia są określone dla tego serwisu WWW i nie mają wpływu na inne serwisy w tej subskrypcji. Możesz zmienić konfigurację PHP, jeśli dostawca hostingu zapewnia odpowiednie uprawnienia. Spersonalizowana konfiguracja PHP mogą być użyteczne, na przykład, kiedy chcesz ograniczyć zużycie zasobów systemu przez skrypty PHP lub jeśli chcesz sprostać wymaganiom jakiejś aplikacji sieciowej. Jesli ustawisz parametry na wartości domyślne, PHP wykorzysta wartości parametrów z konfiguracji PHP na serwerze.',
    'web.settings.phpSettingsAvailableVariables' => 'Możesz użyć poniższych zmiennych w wartościach parametru:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} dla katalogu root dokumentu tego serwisu WWW. Obecna wartość to %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Katalog root dokumentu jest taki sam dla http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'Katalog root dokumentu jest %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} dla katalogu root dokumentu podstawowego serwisu WWW subskrypcji.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} dla katalogu, w którym przechowywane są pliki tymczasowe..',
    'web.settings.phpSettingsPhpVersion' => 'Twoja wersja PHP to %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP jest wyłączona.',
    'web.settings.phpHandlerTypeHint' => 'Zauważ, że zmiana typu uchwytu PHP może przeszkodzić w działaniu istniejących skryptów PHP na tej stronie WWW.',
    'web.settings.phpHandlerChangeHint' => 'Zmieniłeś ustawienia obsługi PHP. Jeśli zapiszesz te zmiany, skrypty PHP w Twojej witrynie mogą zostać zatrzymane na %%interval%% sekund z powodu konfiguracji serwera.',
    'web.settings.phpHandlerTypeHelpLink' => 'Dowiedz się, jak wybrać najodpowiedniejsze ustawienia PHP',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Obsługa PHP nie może być włączona, ponieważ obecna konfiguracja hostingu nie obejmuje żadnych wersji PHP dostępnych dla tej domeny.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Dowiedz się, jak włączyć inne wersje PHP.',
    'web.settings.phpHandlerBroken' => 'Obecnie wybrany uchwyt PHP jest uszkodzony. Wybierz inny uchwyt.',
    'web.settings.phpHandlerOutdated' => '(Nieaktualne)',
    'web.settings.phpHandlerDeprecated' => '(Przestarzałe)',

    'web.setupService.formTitle' => 'Ustaw usługę: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Usługa \'%%serviceReference%%\' została zaktualizowana.',

    'web.site-copy.subdomainsGroup' => 'Poddomeny %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Cel kopiowania',
    'web.site-copy.destinationType' => 'Wybierz pliki na stronie, które powinny być skopiowane',
    'web.site-copy.destinationTypeSite' => 'Serwis WWW w Plesku',
    'web.site-copy.destinationTypeSiteDescription' => 'Kopiuj pliki strony na inną twoją stronę hostowaną na tym koncie. Jeśli masz dostęp do FTP na innym koncie na tym serwerze, użyj opcji Przechowywanie FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Kopiuj pliki strony na inną twoją stronę hostowaną na tym koncie.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nazwa strony',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Pliki na stronie %%source%% nie mogą być skopiowane do %%destination%%, ponieważ %%destination%% jest również częścią tych plików -- root jego dokumentu jest podkatalogiem roota dokumentu %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Pliki na stronie %%destination%% nie mogą być usunięte, ponieważ pliki %%source%% są częścią nich -- root dokumentu %%source%% jest podkatalogiem roota dokumentu %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Przechowywanie FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Kopiuj pliki strony na konto FTP na tym lub na zewnętrznym serwerze.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Kopiuj pliki strony na konto FTP na tym lub na zewnętrznym serwerze.',
    'web.site-copy.destinationTypeFtpHost' => "Nazwa hosta serwera",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Katalog',
    'web.site-copy.destinationTypeFtpUser' => 'Nazwa użytkownika',
    'web.site-copy.destinationTypeFtpPassword' => 'Hasło',
    'web.site-copy.destinationTypeFtpMode' => 'Metoda połączenia z FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Tryb aktywny',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'W trybie aktywnym Plesk wysyła swój adres IP i numer portu, pod którym będzie słuchał serwera zewnętrznego i serwer inicjuje połączenie TCP. Ten tryb jest zalecany, kiedy serwer zarządzany przez Plesk nie jest chroniony przez firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Tryb pasywny',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Tryb pasywny może być używany, kiedy serwer zarządzany przez Plesk jest chroniony przez firewall i nie może zaakceptować przychodzących połączeń TCP.',
    'web.site-copy.existingFiles' => 'Co zrobić z istniejącymi plikami',
    'web.site-copy.existingFilesKeep' => 'Zachowaj istniejące pliki na stronie docelowej',
    'web.site-copy.existingFilesKeepDescription' => 'Nadpisz istniejące pliki plikami o tych samych nazwach na stronie docelowej.',
    'web.site-copy.existingFilesDelete' => 'Usuń wszystkie istniejące pliki',
    'web.site-copy.existingFilesDeleteDescription' => 'Usuń wszystkie pliki na stronie docelowej przed rozpoczęciem kopiowania.',
    'web.site-copy.emptyLogin' => 'Podaj nazwę użytkownika konta FTP.',
    'web.site-copy.emptyHost' => 'Podaj nazwę hosta serwera.',
    'web.site-copy.emptyPort' => 'Podaj posrt hosta serwera.',
    'web.site-copy.copyInProgress' => 'Kopiowanie strony WWW %%sourceName%% do %%destinationName%%. Zostaniesz poinformowany o jej postępie e-mailem (%%email%%).',
    'web.site-copy.unableToCopy' => 'Nie udało się kopiowanie plików strony WWW.',
    'web.site-copy.siteCopied' => 'Skopiowano pliki strony.',
    'web.site-copy.emailSubjSuccess' => 'Skopiowano pliki strony WWW "%%source%%".',
    'web.site-copy.emailSubjFailure' => 'Nie udało się kopiowanie plików strony WWW "%%source%%".',
    'web.site-copy.emailBodySuccess' => 'Pliki strony "%%source%%" zostały skopiowane do "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Nie udało się kopiowanie plików strony WWW "%%source%%" do "%%destination%%: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Ustawienia przekazywania',
    'web._shared.forwardDestination' => 'Adres docelowy',
    'web._shared.forwardDestinationHint' => 'URL docelowego serwisu WWW.',
    'web._shared.forwardingTypeOptions' => 'Typ przekierowania',
    'web._shared.forwardingFrame' => 'Przekierowanie przez ramkę',
    'web._shared.forwardingFrameHint' => 'Przekieruj odwiedzających stronę na inną stronę, ale nie pokazuj im adresu docelowego tak, żeby nie wiedzieli o przekierowaniu.',
    'web._shared.forwardingHttpCode301' => 'Przeniesiony na stałe (kod 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Przekieruj odwiedzających serwis do innego serwisu i pokaż im adres docelowy. Takie przekierowanie zachowa rankingi serwisu w wyszukiwarkach.',
    'web._shared.forwardingHttpCode302' => 'Przeniesiony tymczasowo (kod 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Przekieruj odwiedzających serwis WWW na tymczasową kopię serwisu, jeśli nie chcesz, żeby wyszukiwarki indeksowały ten tymczasowy serwis.',
    'web._shared.documentRoot' => 'Root dokumentu',
    'web._shared.documentRootHint' => 'Ścieżka do katalogu domowego serwisu.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Nie można zmienić roota dokumentu, ponieważ na tej stronie zainstalowane są aplikacje.',
    'web._shared.ipAddress' => 'Adres IP',
    'web._shared.shared' => 'współdzielony',
    'web._shared.exclusive' => 'dedykowany',
    'web._shared.ipAddressHint' => "Adres IP, pod którym hostowana jest strona WWW jest adresem sieciowym wirtualnego hosta strony WWW.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (inne repozytorium)',
    'web._shared.certificate' => 'Certyfikat',
    'web._shared.sameCertificatesHint' => 'Wybrany certyfikat będzie używany dla wszystkich stron hostowanych na tym samym dedykowanym adresie IP.',
    'web._shared.differentCertificatesHint' => 'Ta subskrypcja jest powiązana z dwoma adresami IP z dwoma różnymi certyfikatami. Wybrany certyfikat zastąpi każdy certyfikat zainstalowany na stronach hostowanych na tych dwóch adresach IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Ta subskrypcja jest powiązana z jednym współdzielonym i jednym dedykowanym adresem IP. Wybrany certyfikat będzie również używany dla wszystkich innych stron hostowanych na tym dedykowanym adresie IP.',
    'web._shared.certificateNotSelected' => 'Nie zaznaczone',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'W twoim repozytorium nie ma certyfikatów SSL/TLS. Jeśli chcesz dodać certyfikat, idź %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'ta strona',

    'web-user.settings.allowScripts' => 'Zezwalaj użytkownikom sieci na używanie skryptów',

    'web-user.name' => 'Nazwa użytkownika web',
    'web-user.longName' => 'Podana nazwa użytkownika jest zbyt długa (maksymalnie %max% znaków).',
    'web-user.password' => 'Hasło',
    'web-user.passwordConfirmation' => 'Potwierdź hasło',
    'web-user.hardDiskQuota' => 'Limit przestrzeni dysku',
    'web-user.hardDiskQuotaUnlimited' => 'Nieograniczone',
    'web-user.hardDiskQuotaIsNotSupported' => '(wielkość dysku twardego nie jest obsługiwana z powodu konfiguracji systemu plików na serwerze)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Wymagane pola',
];